(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    455799,       8872]
NotebookOptionsPosition[    445758,       8538]
NotebookOutlinePosition[    446168,       8556]
CellTagsIndexPosition[    446125,       8553]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Mit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " durchs Abitur"
}], "Title",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, 
   3.382549020869715*^9}],

Cell[CellGroupData[{

Cell["Fl\[ADoubleDot]chenst\[UDoubleDot]ck unter einer Kurve", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
   3.36386547274861*^9, 3.36386547931836*^9}, 3.3892697548078*^9}],

Cell[TextData[{
 StyleBox["Aufgabe:",
  FontWeight->"Bold",
  Background->None],
 StyleBox["\nGegeben ist f\[UDoubleDot]r ",
  Background->None],
 StyleBox["x>0", "InlineFormula",
  Background->None],
 StyleBox[" die Funktion ",
  Background->None],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "=", 
    RowBox[{
     FractionBox["x", "8"], "+", 
     FractionBox["2", "x"]}]}], TraditionalForm]],
  Background->None],
 StyleBox[".  Zeichnen Sie den Graphen der Kurve.\n\nIn die \
Fl\[ADoubleDot]che zwischen Kurve und ",
  Background->None],
 StyleBox["x",
  FontSlant->"Italic",
  Background->None],
 StyleBox["-Achse ist ein Streifen mit der Breite 3 parallel zur ",
  Background->None],
 StyleBox["y",
  FontSlant->"Italic",
  Background->None],
 StyleBox["-Achse so einzuf\[UDoubleDot]gen, dass seine Fl\[ADoubleDot]che m\
\[ODoubleDot]glichst klein wird.  Berechnen Sie den Ort der beiden Parallelen \
und die resultierende minimale Fl\[ADoubleDot]che.",
  Background->None]
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
  3363862474.58663}},
 Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   FractionBox["x", "8"], "+", 
   FractionBox["2", "x"]}]}]}], "Input",
 CellChangeTimes->{{3.36386275289306*^9, 3.36386278855872*^9}, 
   3.3638634205039*^9}],

Cell[TextData[{
 "Um ein Bild der Situation mit ",
 StyleBox["Plot",
  FontWeight->"Bold"],
 ", ",
 StyleBox["FillingStyle",
  FontWeight->"Bold"],
 " und verschiedenen Streifen erstellen, definieren wir die folgende \
Funktion. Sie erzeugt den Plot zweier Funktionen, die in der Komposition \
genau das gew\[UDoubleDot]nschte Bild ergeben. Mit den ",
 StyleBox["Filling",
  FontWeight->"Bold"],
 "-Optionen wird genau die Fl\[ADoubleDot]che zwischen den beiden Kurven gef\
\[ADoubleDot]rbt. ",
 StyleBox["PlotRange",
  FontWeight->"Bold"],
 " fixiert den Wertebereich auf einen f\[UDoubleDot]r unsere Zwecke \
sinnvollen Bereich."
}], "SmallText",
 CellChangeTimes->{{3.3638627985965*^9, 3.36386282164846*^9}, {
  3.36386285412745*^9, 3.36386294089008*^9}, {3.36386446004901*^9, 
  3.36386452998521*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fplot", "[", "u_", "]"}], ":=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"u", "<", "x", "<", 
           RowBox[{"u", "+", "3"}]}]}], "}"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "11"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Filling", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", "->", "Axis"}], "}"}]}], ",", 
    RowBox[{"FillingStyle", "\[Rule]", "Blue"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fplot", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.36386335920881*^9, 3.36386336549634*^9}, {
  3.36386410227139*^9, 3.3638641044319*^9}, {3.36386423091527*^9, 
  3.36386423179518*^9}, {3.3638745350115*^9, 3.3638745362204*^9}, {
  3.36387458244652*^9, 3.3638745825871*^9}, {3.389267313923936*^9, 
  3.389267315894378*^9}, {3.389267756451784*^9, 3.38926777334513*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzdmnlYjVvY8HfTbm7v3aBRRJNEylRK9y1TCQ2oRBkaT0JSimRsomNKIqVB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   "], {{{}, {}, {}, 
     {RGBColor[0, 0, 1], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{652, 2, 52, 686, 565, 693, 615, 673, 481, 696, 629, 687, 
        570, 694, 620, 678, 515, 626, 684, 557, 692, 607, 665, 446, 631, 689, 
        572, 622, 680, 520, 627, 685, 562, 612, 670, 464, 567, 617, 675, 498, 
        540, 590, 648, 397, 522, 564, 614, 672, 480, 569, 619, 677, 514, 556, 
        606, 664, 445, 519, 561, 611, 669, 463, 497, 539, 589, 647, 396, 479, 
        513, 555, 605, 663, 444, 518, 560, 610, 668, 462, 496, 538, 588, 646, 
        395, 478, 512, 554, 604, 662, 443, 461, 495, 537, 587, 645, 394, 477, 
        511, 553, 603, 661, 442, 460, 494, 536, 586, 644, 393, 476, 510, 552, 
        602, 660, 441, 459, 493, 535, 585, 643, 392, 475, 509, 551, 601, 659, 
        440, 458, 492, 534, 584, 642, 391, 474, 508, 550, 600, 658, 439, 457, 
        491, 533, 583, 641, 390, 473, 507, 549, 599, 657, 438, 456, 490, 532, 
        582, 640, 389, 472, 506, 548, 598, 656, 437, 455, 489, 531, 581, 639, 
        388, 471, 505, 547, 597, 655, 436, 454, 488, 530, 580, 638, 387, 470, 
        504, 546, 596, 654, 435, 453, 487, 529, 579, 637, 386, 469, 503, 545, 
        595, 653, 434, 452, 486, 528, 578, 636, 385, 521, 563, 613, 671, 468, 
        568, 618, 676, 502, 625, 683, 544, 691, 594}},
        VertexColors->None]]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1He4DmQYB+Dv2Htlr+PYe6+0ZCuVpFLICEnZW1tlz3Yo0iCi0DAz2nYI
ZW+yo2EU93P1x31+v/c517fe9/2+lM69W/VKSiQST/nzTapEYqc+k9RUMjsm
Z9OPO7jfLDub9SnUooH1VbmCkXSgvVk+ftXfJw2VrY/Lj+nPnTxgloOf9anU
pqH1v/JrRtGRtFQxPyHnMIAWPGiWky36NOqwzOdoZPafvpLRdCIdVc1/l3MZ
yF3UpbH5NbmKMXQmPdXMT8pPGMTd3EiT2DRWi7E8Sgaqm52S8xjMPdSjqXkS
a/RxdCEjNcxOy/kMoSU30cw8VZyJPp6uZKKm2Rn5KUO5l5tpbp6ab/UJdCNz
nI/ZWfkZw2jFLXGW5mn4Tp/IY2SJ/Tc7JxfEneA+bo2zMk/L9/okupM19tvs
vFzI07Tmtjgb83T8oE/mcbLFXpv9IRfxTNwn6sc5mKfnR/0VepA99trsgvyc
Z+O+cHucg3kGftJf5QlyxF6bXZRf8FzcD9qY5WKr/g4N4lysM7JWf40nyRl7
b/an/JLn47E8ZHYD2/R3aRjnZJ2JdfrrcZ56UfbrPXlEz89v+gfkinOy/kt+
xQtxx6wLszdeg4f13PwSzyHLMD3ORqZwSO8jy9Mozl5mZgDr4zPI0rwR90Um
M4gD1r1lOYbSy7qDLMBAdlnHj8By35uycggfxpnJEgzmiHVfWYFhsR9xj+Tf
sr9cHGcgSzE8vg+yCPvic9FWz8N2fUbcH704h/XGcS/1LGzQ34z7qxfjYLx3
OuoF2a1/RO64l9b/yCW8GK9BO7O87NDfo0ncYeusbNTfij0kT9xTs0tyKS/F
Y2lK3riT/ndZLuNl2tOMfOSnAAUpRGGKUJRkipFCcUpQklKUpgxlKUd5KlCR
SlSmClWpRvW4697HFbmcEXGvaE5r82xs0t+Os6GTdSH26LPooZfkqN5PVkz6
/3e+hvV1SRqh/w==
       "]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{380, 633, 575, 525, 483, 449, 431, 381, 382, 383, 634, 576, 
       526, 484, 450, 432, 651, 593, 543, 501, 467, 384, 635, 577, 527, 485, 
       451, 667, 609, 559, 517, 679, 621, 571, 688, 630, 697, 433}], 
      LineBox[{652, 594, 691, 544, 683, 625, 502, 676, 618, 568, 468, 671, 
       613, 563, 521, 385, 636, 578, 528, 486, 452, 434, 653, 595, 545, 503, 
       469, 386, 637, 579, 529, 487, 453, 435, 654, 596, 546, 504, 470, 387, 
       638, 580, 530, 488, 454, 436, 655, 597, 547, 505, 471, 388, 639, 581, 
       531, 489, 455, 437, 656, 598, 548, 506, 472, 389, 640, 582, 532, 490, 
       456, 438, 657, 599, 549, 507, 473, 390, 641, 583, 533, 491, 457, 439, 
       658, 600, 550, 508, 474, 391, 642, 584, 534, 492, 458, 440, 659, 601, 
       551, 509, 475, 392, 643, 585, 535, 493, 459, 441, 660, 602, 552, 510, 
       476, 393, 644, 586, 536, 494, 460, 442, 661, 603, 553, 511, 477, 394, 
       645, 587, 537, 495, 461, 443, 662, 604, 554, 512, 478, 395, 646, 588, 
       538, 496, 462, 668, 610, 560, 518, 444, 663, 605, 555, 513, 479, 396, 
       647, 589, 539, 497, 463, 669, 611, 561, 519, 445, 664, 606, 556, 514, 
       677, 619, 569, 480, 672, 614, 564, 522, 397, 648, 590, 540, 498, 675, 
       617, 567, 464, 670, 612, 562, 685, 627, 520, 680, 622, 572, 689, 631, 
       446, 665, 607, 692, 557, 684, 626, 515, 678, 620, 694, 570, 687, 629, 
       696, 481, 673, 615, 693, 565, 686}], 
      LineBox[{628, 695, 523, 681, 623, 573, 398, 649, 591, 541, 499, 465, 
       447, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 
       412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 
       426, 427, 428, 429, 650, 592, 542, 500, 466, 448, 666, 608, 558, 516, 
       482, 674, 616, 566, 524, 682, 624, 574, 690, 632, 698, 430}]}, 
     {RGBColor[0, 0, 1], LineBox[{703, 705, 702}], 
      LineBox[{704, 706, 701}]}}, {{}, {}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"AxesInFront" -> True},
  PlotRange->{{0, 11}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Und so l\[ADoubleDot]sst sich daraus in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 eine Animation erstellen."
}], "SmallText",
 CellChangeTimes->{{3.3638645513526*^9, 3.36386457326146*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Animate", "[", 
   RowBox[{
    RowBox[{"fplot", "[", "u", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", ".4", ",", "7", ",", ".2"}], "}"}], ",", 
    RowBox[{"AnimationDirection", "->", "ForwardBackward"}], ",", 
    RowBox[{"DefaultDuration", "->", "10"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{
  3.36386295058063*^9, {3.36386367728297*^9, 3.36386368064519*^9}, {
   3.389267969648497*^9, 3.38926800365616*^9}, {3.389268079351522*^9, 
   3.389268148880269*^9}, {3.389268286836191*^9, 3.389268301541723*^9}, {
   3.389268352145183*^9, 3.389268353136092*^9}, 3.389268745582872*^9, {
   3.389268805596921*^9, 3.389268818397526*^9}, {3.389268864230448*^9, 
   3.389268871836586*^9}, {3.389268904576973*^9, 3.389268905992477*^9}}],

Cell[TextData[{
 "Die eigentliche Aufgabenstellung l\[ADoubleDot]sst sich mit folgendem \
\"Gewalt\"-Ansatz l\[ODoubleDot]sen: Berechne den Fl\[ADoubleDot]cheninhalt \
",
 StyleBox["A[u]=", "InlineFormula"],
 StyleBox[Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "u", 
    RowBox[{"u", "+", "3"}]], 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]], "InlineFormula",
  PageWidth->Infinity,
  CellChangeTimes->{{3.36386464148139*^9, 3.36386471991508*^9}}], 
  "InlineFormula"],
 " der zu untersuchenden Figur in Abh\[ADoubleDot]ngigkeit von der Abszisse \
",
 StyleBox["u",
  FontSlant->"Italic"],
 " der linken unteren Ecke",
 StyleBox[",", "InlineFormula"],
 " bestimme die Nullstellen der Ableitung von A[u] und \[UDoubleDot]berpr\
\[UDoubleDot]fe die \[UDoubleDot]blichen Extremwert-Konditionen."
}], "SmallText",
 CellChangeTimes->{{3.36386459301252*^9, 3.36386460237623*^9}, {
  3.36386473671622*^9, 3.36386489025762*^9}, {3.36386515570267*^9, 
  3.36386516280051*^9}, {3.36386520263879*^9, 3.3638652201742*^9}, {
  3.36387499163744*^9, 3.36387499271618*^9}, {3.36387504092772*^9, 
  3.36387504897587*^9}, {3.36387513691539*^9, 3.36387513757526*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", "u_", "]"}], "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{"u", ">", "0"}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "u", 
      RowBox[{"u", "+", "3"}]], 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "]"}], " "}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386464148139*^9, 3.36386471991508*^9}, {
   3.36386494634054*^9, 3.36386498750683*^9}, 3.36386504057542*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["9", "16"], "+", 
  FractionBox[
   RowBox[{"3", " ", "u"}], "8"], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    FractionBox[
     RowBox[{"3", "+", "u"}], "u"], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Eingabe kann nat\[UDoubleDot]rlich auch in der eindinemsionalen \
Input-Notation als ",
 StyleBox["Integrate[f[x],{x,u,u+3}] ",
  FontWeight->"Bold"],
 "erfolgen. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 muss die zus\[ADoubleDot]tzliche ",
 StyleBox["Assuming",
  FontWeight->"Bold"],
 "-Konstruktion verwendet werden, weil das CAS \"zu schlau\" ist und uns erz\
\[ADoubleDot]hlt, dass f\[UDoubleDot]r irgendwelche komplexe Werte von ",
 StyleBox["u",
  FontSlant->"Italic"],
 " B\[ODoubleDot]ses passieren kann."
}], "SmallText",
 CellChangeTimes->{{3.36386499531742*^9, 3.36386512926002*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "u", ",", 
     RowBox[{"u", "+", "3"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "u", "]"}], ">", "0"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "u", "]"}], "\[NotEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{"Re", "[", "u", "]"}], "\[Equal]", "0"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"(", 
     RowBox[{"9", "+", 
      RowBox[{"6", " ", "u"}], "-", 
      RowBox[{"32", " ", 
       RowBox[{"Log", "[", "u", "]"}]}], "+", 
      RowBox[{"32", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"3", "+", "u"}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      FractionBox["2", "x"], "+", 
      FractionBox["x", "8"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "u", ",", 
       RowBox[{"3", "+", "u"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"!", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "[", "u", "]"}], ">", "0"}], "||", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Im", "[", "u", "]"}], "\[NotEqual]", "0"}], "&&", 
           RowBox[{
            RowBox[{"Re", "[", "u", "]"}], "\[Equal]", "0"}]}], ")"}]}], 
        ")"}]}]}]}], "]"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dflaeche", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"A", "[", "u", "]"}], ",", "u"}], "]"}], "//", 
   "Together"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386492509093*^9, 3.36386493258472*^9}, {
  3.36386523374757*^9, 3.36386525682038*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "u"}], "+", 
     SuperscriptBox["u", "2"]}], ")"}]}], 
  RowBox[{"8", " ", "u", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "u"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"dflaeche", "\[Equal]", "0"}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386526798291*^9, 3.36386526855388*^9}, 
   3.389275061817372*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        SqrtBox["73"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["73"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.3638652768406*^9, 3.36386528037186*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"-", "5.772001872658765`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", "2.772001872658765`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Nur die positive L\[ODoubleDot]sung ist f\[UDoubleDot]r die Aufgabenstellung \
relevant. Fassen wir zum Schluss noch alle zu berechnenden St\[UDoubleDot]cke \
in einer Liste zusammen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"A", "[", "u", "]"}]}], "}"}], "/.", 
   RowBox[{"sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "N"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386529661573*^9, 3.36386530083447*^9}, {
  3.36387578743021*^9, 3.36387579518097*^9}, {3.389273355387271*^9, 
  3.389273364217235*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.772001872658765`", ",", "3.068899119167584`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Eine einfachere mathematische L\[ODoubleDot]sung (warum?) geht so:\
\>", "SmallText",
 CellChangeTimes->{{3.36386533670555*^9, 3.36386535801878*^9}, {
  3.36386541635483*^9, 3.36386541942881*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"u", "+", "3"}], "]"}], "-", 
      RowBox[{"f", "[", "u", "]"}]}], "\[Equal]", "0"}], ",", "u"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36386536159901*^9, 3.36386540500043*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        SqrtBox["73"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["73"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eine Eliminationsaufgabe", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36387990206389*^9, 3.36387990670122*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:",
  FontWeight->"Bold",
  Background->None],
 StyleBox["\n",
  Background->None],
 "Bringen Sie die in Parameterform gegebene Funktion (",
 StyleBox["x,y) = (2Cos[t],Cos[3t])", "InlineFormula"],
 " in explizite Form und zeichnen Sie den Graphen.  \nBestimmen Sie den \
Inhalt der Fl\[ADoubleDot]chenst\[UDoubleDot]cke, die zwischen der Kurve und \
der ",
 StyleBox["x",
  FontSlant->"Italic"],
 "-Achse eingeschlossen werden."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
  3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369, 
  3363865693.92767}, {3363879913.55481, 3363879926.325}},
 Background->RGBColor[1, 1, 0]],

Cell["Auch hier erzeugen wir uns erst einmal ein Bild.", "SmallText",
 CellChangeTimes->{{3363865715.8457, 3363865727.70661}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", " ", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386571111207*^9, 3.3638657448007*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Xk8lN37B/BE+0JZy1IirahEFF2kaEEoS4snQrtIopC0KAkl2UqJnihr
UYnUpSQlLcoe2Zkxy7lnsS/zu/2+z/wzr/frnjlz3+dc55zPeY3qQU9b94kT
Jkx4JjZhwvj7fy/j/71RYDXl62SRSASvE9WM+kUEDq5cqThCWwyihY20F/77
/ARFe+q7hF+naY8WVOe+p60irbPzxyiBUxe2VdANgFpm+HWjfgIjDjuN6Qbg
TVIHb6iRwO6UrwIPSgRRP5576PsQaFuq9N2rSATXv01XT0nlwArz++sWHBfB
2gU++/7p6AGgFOyGR8agtn8xSpt1g29c4G7KdQx0mjfsmHC2DV6uD6la+WoU
fJ+9Dnz4bwNUyqaokboRuFZcd7eKXQGSf4ql9jQPg9nalIfhPQ9AZCupEN0w
BOxhUGtNL8Gj/wz5nUsZhCUZH6ezdGpw3VW35rz7g1Clx95b6FyDL0J2PmPH
D4JMjqz2+Yga7D9Ze3PPzUHwP3pb1NhVg1aLJlgtDByEcyZvrk1MqEWbJVHT
DtoNwsyO38E/hupwr21uwuvJg7C94IREad4fdLTT3lniNgAVo08Osf1bsHyP
ZcCLAwNQFzu/YDSyBaO5eTr/7h2APEH58smPWjCh5Ob2C9YDcHNNn/FIeQsW
lw8qqBsOgNaJ7pmB81uxS/V+4FLpAQhcV1hTnN+K6+1+XFYp7oc5ny9Xy7La
0FN968/Wwn7QW73sYd9oG5qt+JP76GU/HKamG36Tasey0psb1DL64afpItyn
147dK/td58T2w0XFlfUjwe24SWOxQ/rxftDYZfPITKYDBy5Gjf2U7Yd9thpU
3ppOlNNn1/Ik+6HAZMuL11s6Ma/SQHrO9H6Qf7JkxjPHTrzE3vV8+1gfzO/b
b+Ib1IkTS2Tj0rv64MlG70sHvnSiYeU7d+X8PlAM+DP93v4u/HZ6wmilfR9o
bYpKcj/bjQfnO7WjdR845FjopF7vxqGtsgaZ2/vgfOB7Vu3dbgx4b7E2eGMf
xAb6Jc1+242/6r6dkdXog3nzrnWUTWBgkMKikF5hL9y/PxrnHMLAowWSfyKj
euHXpTC9tktMVPtmUvfqRi+IeSWt04xi4ord6VeaQnphflPHimNJTJQKCWdr
+PeCX2XR94I3TGzwuDsx/WAv+NzzUc8RMHHI1jz+lE4vQImRM8u5B31SD/Om
VgkhsWL1et9VLGz2kgud8l0Iml1ZUjxDFr5+fqte4rMQOCPmZP82FmacPZA9
/EYID2/eejrlIAvfPni+rOGRENIj99o9uc3Cu8tLC/aeFgK3fmuRFI+F3zbE
1J2YIwSxhBRpmxQ27gpeKobThdCd4hv/IYuNLv4pBZISQoj/9jFetYCNd97r
Nmb2CcB0xnlu2g82FhVb9lb/EcChM2/UqofZqPZqfXv7YwGMZnCuZVhz0DJB
ZLogSQC/rR578PZycFKjq+GeeAF8d5E4oO7OwcMGI72fwwSwK9lju805DopP
m303zlMAzI0RkZ8ecnBFq7w0X18AMkG+2+axOch/sm+p/BoBvLhuw13Zy8HB
3XOa1q8QgOI3ow2aYxzU8i3XCFIWQNME+VcCSS6eXbppm1BMAL526rfi1nCx
ZPpMg6RyPli/TBXT8+Ei3+dlcHYJH8A04fqcQC4qRBd5FhXx4fftywfrL3Mx
0axtS1U2H+TydASa0Vy8fDKkRXCbD0tKzk7uecbFTYe2g2AvHz5e0/v1lMFF
n5S3SrN382FPnoTTMsJFxYiSl0ss+XDRozQtppeLByW9lByAD3/vanqsnUgw
TT7rS6oaH7wWpWwPm09wmr9cVL4SH24YFx72XEgweW6XfJksH1zMFDVMNAi2
Wj9yb5vCB71G87PpqwkaF0+XnM7mgaSgSfKOOcGI/nnNUp08SMSAqiYLgjf8
jnjL/eXBZt0iFRlbgvaBzzuUf/IgRLBundl+glNuBExSecED+a1mC4s9Ca6M
8/23PYAHO8LEDKdGE6xwu9VW48ODB4uXUQpxBCeNZLA+e/DArvX9sOw9giyF
RuenB3hQdMhdsjqFvv78W8c+Ux5cURnsPPSc4IyGlNAthrQT6uY2vCCICq7D
mro88J//+IrBa4LHJe/tHNbgAazJ1Hr7jiBX4mnxtek8WD2c51ZbTjDmWCzz
sDgP+CNdwZnfCM4869RpNkJB8rM7vzx+EgxyPuUgxqXArfqW5Mtqgj4Nhd8b
uyhYciS2f30dQdX1tfPzmykw4V+ZndVAcH/FJZ0jlRR4/phbYtdM8KCppBiU
U5DN+uoU3kpwdOnRxzIlFLhGJ6vmtBPUzAj2KXpBQWqz04KCboJJqwwfRmZR
8HLOe/uHTIK7+or/PZBKwXeWQe5pFsEx4aL1Y3EUXHrA+fmXSzBn5XKReRQF
vtNM8/dRBNldC0tvhVHgX7hidxmP4PXL/nYLzlPQODcr+5iQ7o/9mQvdfSn4
s7ruWEovwe//Huc+9aRAePVNw+c+ggKF1dGrDtLXi/R+tw4QXPJy8nHvfRQE
DWfsrRok+Cx5qnnebgpCV96JfjlE8HnRgyUCSwqcjp45HzJM8IRg1aw15vTz
LmuW3zxCUH/TkgFPYwoyTY8d5NG+8ILJyDSgYCv79f6IUYL5bi3NjDX09/N9
JyuMEXQOPN2ktpKCzjjHA1G0BToz2pwWU6DSonR4kHbHL0lurAoFz0xuKFuL
CN7PYYr9kKeg7JvPpRjaPtpiKpPnUKDTmxfzhXbKp3ebDKdT4BO60oFN22Qg
zOuUOAW/879+GqV9MzNx545BAq7SoR3jHpvYXvmcRWDWDZdn458fsC08IveX
QPhJl+XltHXmCWXO/SRwxOOubSxtFnGprf9AgMQuXWZDuyqy+pn+SwLqe1dn
D9H3O1a+MCUmjcDTkPbW27SbY2UzqQQCT8z9Ps6jvWHi1R/bwgm81NSyv0n3
h+T6zbOSg+jr6rviBHR/xYUuOtTnReDM2fWhZrQN7AQN21wJiFeZLAsd72/1
6yfu2RHgGf/0f02PR3HcK0WWOYFDS+zP19LjVe5hxdRfT+CnpeXqTno8p11S
q7mykkBynX5caz/BX66VUvJzCBReXBqQStdD2VlrZydxAl5FLkMn6XrJ3Lvn
V3IvF95HD2pqCAg6WdurLm7ggp2F3Etnut62R/FErhVcOK6pOL2DrkfLQTeJ
5Hdc4D0NkrPn0PX4S+2S7CMuMP/57Di5h+AnO/lRixguxHqcu7WZQVBpkU7y
pWtc0C5RuXyqi2ACb+0RxnEufPq46X5cG0EZqeSpD9Zywb2l7YMMPb9SimQ7
Pmlw4aF3N/lcS9ezqSPhKHDh7JKKluP0/IwsuhevN8qBmRudpIPo+Xst0Mcy
t5QDF2XftP4uJfglbnFW0isOqHPHNIo/EJxr9JIflsaBQ28O6MQjwdnfX+js
u86BwLLIpzMKCB4gyhltFhxQ0JhjPiGDYJRuhgMacSBywHrCjjT6+1r/8hO0
OEAZLbt98RFB+ZhFA1ulOHCFtXtbLr1+GY3tPRD5mw3pm0wtFt2g50O01f29
H9kgvjFOquIqvX46b/6l/pINlPPaDy6X6PU69crivFg29NyOGbA+R1Bt8OLN
/D1sMPnyXRwO0euRir6rczMLqg6UWuw3JDhfGW/P/MmC7IUM20969HrQdKv8
VTELZh82P6dEr9/2eccdJqWwoD59rW7EYoJ+9YclbrixoPBVU2XwLLoe+vSS
DJg9sKTVdeqLei4W7NE/v4LHBPezMRZHXLl0vjTZ928bEzDMU4yxj4tTbVse
KlYxYb7V1mb73VyMXOxzaFI+Exaaf9GYuIWLxl8khaWBTEjNbth/czEX8+ea
tA1PYYK2v9mm0HYOtt/ocDRRZkDiBzOU2cXBhKpv3aGzGTBXdevRS9s4aOKv
Mfxd1A3vPgVWNQMHz+wpy7Vv6waNdKb4sZX0ft6jd2F3WjeMnM76p0iCg86G
MY7TV3eDQEahxSmXzgtH9b3cTbtgLHLNpyIxNh4NooKMdbqgI67znm4vC1NT
3Pjz1LogNNTYMJHBwtgxzZmfJ3aBo3fF6JofLFzzbtLKOR86IfKfrhPX7rGw
20VbzdG4E+SXiQ79pvNRwILLS99v6IDDpbtu6Fr1YFAWyTXRagMZ5ZoPuvYM
rHX9pTlTpQ3c0Cc5fwsDR1etcq+e1QaZnhtMl+sysGZL+yw3TiuQGX8GW6UZ
GPum9pB3Ziu8uJztmPizGx8mlK7dvbwVDo8KFpuZd6Pjoys6axe3wELlKasK
l3XhklOVmju0GyEHTtSnlLbjg4/ZGiOnqsCcGczuTmrCciV7ie2kDC7uXCHG
eFuJHq8LK8TEn8Et1g3toJF8DJvhqrXkVjZWz7o8Z3HnK1jZUByWf+cz+oyl
2Ibo/oK0wLmdkYursDA7K+KrfhNo9X1e8eV2I2aXh5nHiHXAFO8t5o/zGjGt
rENth2wH7NMUc79Q1Yg51XK+wqUdkJeh8EBTrglZM6jtqtYdMDlG9OlUQhMq
i9Kd2+53wFTztt7YpL9o+1HuSb9eJ6g3JHstsmvBHZVyuYoHuiBNJ0zJcX8b
XhYLnPD9CgNWn3Q6e/h4G9bf2zSXRDOAqxSXf8a/DbVytpRPfMSA5iP3GiPj
23DnMrOZE98zoO6Cf1peVRuWVqcL/xlhQODCg2c+WbSjsi3H9oYXE0Seg/em
G3Zg4z+3M/yseuCH1IZHwu20pcd0/+7rAf/7PK+mPR3o/3zkpN7RHtBQUN+f
4deBohdvfry53AOqs0456ud1oOsV3cvzXvfA9m/nF8gt78SF80Iuz1dhwQn7
4eQGuS4ckt0iJ07P096usrQGjS48LQxZc4PFgi91kor1el3Irft0VmyABdbn
r22ptO/CCslA19dSbHjttCssO7YLu8buVVuZsGHI4Gm1olw3Cp48OSWfxIZ2
t/wbBXTdXJC1n9tBr0tiz6WkQtQYWG9U2rrIgQPXvcubrHQYuFyL8K1cOCDs
brdusmWgaNPF4pNnOLDptJ1vZxQDl8Yl2VUkciDLvLIkWZKJvBkH+ge7OZBU
mpP4YVoP9gc/kO7z5MI8btA0C4Ue3PB8ACz8uBD+Xbn+t0YPqk5+7RsVxAVy
cc39v6Y9aL8ZBIxwLqQ1RCe1nO/B3V9OFXx9woVM5xMfY3g9eP3EHVWnJi4o
6cTyJSawcFR7l1pKOxcUU9af8Z7NQl70UkE1kwvwyMVn6woWXt9hQ6b1cWFU
eY1JixsLs/O3DafMIjB15hXLd7UsHHlZFxlrQCCjP8BxbhcL37s8Z3zaSKC8
Ou+pm5CFjcodTZ2mBISnHBUl5tDnhsNDkcSSQJN79iKt7WwUXQx4t9qFgM7B
v2Y+jmw01fd+XONO76MrN6S/PsTGaQESc48dI5DzRLDc8DIb28WrT+0/TWDJ
s+fDmkVsdFhuMMXzCr3PVsVPOFTOxiaDP9XXQglERj80Sqxjo+/QZ7mb9L4e
+jdiv3gvG1VlErqO3CHgU7hNtkiTg5kz0i9ue0Q7QZhV84CDoVdS24reEtim
tD43PZODe+OWksxiAtMeCfmBhRycGKglulFCwDbugoZSDQf1ep6qyX+hc8II
f+OWWVzU/Jtg5/KbgOBjp+QMRS4yT+jafakmMH3SO7kfS7mYlzPNcmEdge5l
9R9sNnMx9p3rwnuNBD5n1Z43CeBigJ+U7scOAtHK0t0DoVy03utW/aiLwGvz
jAvZsVyMb2a7eTMIyPrlbJDJ5WKqRpllI52TQuP8nT4iF28f3vLYj0Og/Ylz
hvc3Lhpst2GIEQJ7Jxt9/kKfW3xP/dBs5xHQtoiO8e7jYrJlvtZ6AZ1rfD/e
mCdB58JheYVgIQF+2YT0d3MINqmaMl/0EghIOktcFhBMDI9OrusjMOq3f5+4
JsHpmh7GrH4CEYxGdsp6guvmG5WyB+j2A3zPN9oRvNubHFQ0RCDOkefv60pw
T+XG3LBhAr82V9ydfYqgZ3XrF/MRAifc9Bv/DSLYWb+4lM5b4DJwaKNBOL2v
/81+FDlKYPk/14u/JtA5eepydzqfQplkpct+et9PfGI5jc6n8OORpyqLPndU
6dTfHKB97lvsmB+dK95vjRmwEtG5b//ZgYl0DinN2mV6h7bIyGx2eBOd22yI
52fazf5rQJrO9Ze3WwSxaF8w8AyLp3OaRp3DSTqPQsA/cf2zxCksd5lqPEY7
Odfm1fdpFJr6OQk4tDNrRcGRUhS+/3kgtIJ24vwNDpbyFFZaqYoSaPNrEvVn
qFBoNVTkYE+7xPed+md1Cu0lHG6L0X7hbaB4ZQWFup+Ucu7R9z/JNk0R1lBo
+X5ztjrtuPTkxYP6FA4+mH0rke4P3sIP+rlA4fFVJbvFaZseSdl9zIzCkJMv
Rhzp/juzqfGsqiWF2eeMQu/T/b0oeNrj2l0UJiV86P9Jj0fqhI914Xsp1DZ6
vkNA5+5FuY+lTVwonDd04YoE7YtRW+2EhyksCs9OkaDHMyjd7H7qSQqra0tT
BfT4Z8ivZzmcoXBdh0NUJV0fqx8djcu/RGHxwoNKe+l6Yp3v8u2/TqEwa3V3
F11vBsNSWnpRFOZM6b59gKJze8Fh1WdJFOqXMG/J0PWqnXhrPyuVwii17Z3W
dD0fdHf2WJxNoYHFK5VzTAKOVdxZsUUU9m9x3RLRSWBmSXpiRQmFau5Kuufa
CagunyoS+0qhYXflbJtWAvsbUgyP1lPo25oV8pGeX3uyDSOW9VFofcQ6vfAX
gfjXjHT7UQob3xfOnUyfIzxtteMvSfBQ/L3LKaNvBNp2hTXXzOWh9NczCl5l
BCylPaVPafMwW4lp0llI139YV9IdPR46W0nfupVPj+9IX/8rIx5+1GhrX/KC
Hq/77VMHdvAwXX7O4/lZ9Hqxqi/p+BEemqqzKqQe0ONtAgEhnjyUiZl3Teku
AQflxSoPfHm4QHRuj0wsgWMF5a+/XqF/r3mSzecIAl+H7uooJPOwQD2g2iSQ
bn9Dt9HSJzyMaJl7L9uPADOifsa6HB5mWIZHTqHXx76sV5T1Wx4OxjCnBx2l
6zft8s8z9TxsfOqRfZ4+p/g9XtUT0MJDra1/1llYE1gZcrskuJuHm3cMTpmy
g8DRofN5V3t5+Eb/7nUTY/rcpajvf3kOH/0ivLzLl9H15ZCqa7yNj5rdMuLa
g1zI67ku/mYnH4325NisEXCheGlV3lp7PjL/Vqapc7gQXzS1UN2VjxutRH41
LVxgv+qx6Q/ko+cy3SmeZVw4IXvT4dAzPm4oNx70jeJCpGWm0o9XfPSnBAdP
hHFBLpjxVu8tH+2MUmbZXOZClq1W9MRyPkp8vanL8OGC+tQpQeHtfDwdOBOs
HLjQat42ekROgLM3+FaO0OcS0dAme1QSYMSegDUMKS4cKA6/IqMmwEV8JfmS
qVyIu2Dt8kZbgJJ1iufNBzhQWPhDanirAHtCLTfcqOHA7nMPeSYBApyZsyR+
4i0OvDHgzGL9FeBi4xD3331ssA7RvPKwU4AdMeFuf1lssKopitjNFuChjGfF
NS1s+KDZ5Ph6UIBd075k3ixnw29e4fuTMkL88UZLRe0+G2qnC7xjtwnxpcq1
xpqNbCjMmiz2PVeItdXXGWk+LNA5Pr93d4EQHa0X6nkcZkF63W6PBhTi2DrV
Pwv3smB58QFGS4UQN3i8sNwFLGhOej/8p0uIVyUbyjqnsqDYLVs7bH4vDnR1
ln+O74HCioSokuBe7I1ZtbwsgwmfLaSKsq/2oke3J9PjPhNUJC9Gxof3YneM
0+bJN5nw7ljtsiPxvfirLIMzw5sJoY8mr+rP6UWHq5n84+uYoKOhvbTqby/O
SzGZdBUZkDNZZf21DX044uXV5lTaDU4vDhS/pfowWll14+2nnSDeylFa29eH
dfO0PYziO4EUlCg8He5DR/f3/MarneCm38+OnNyP055MXDLo2glw0WFsm1I/
el3bbJim3AknaqUDz5v3o6xFkFdbZAdUSUc/rE3sx3mnVwgVjrbDRK7TWzPT
AUzmsJQKxlrAgzNPrnLrAO5JZH6UY7ZAdw0nf4/VAIa1r80++rsFMs9aVrvv
GcBzkb8CSFoLiOmJnzjqOYBJiueuBlq3gM3zI7nK9wYw1chH2gaagaRe46/j
DWCAobi+vUcjbOUZq6nED2KJs9BnWkwNKE3kPtAqGkLxqoLjI4afIE/4K6a3
YRg377JfveD2PTxnfvLiuuoRlD464/zF0AqMaQiejcmjePhWdMKTc/WYJ6gU
m31gDHWswm1/27RhXMQm9RhqDLV0Zvr2NXfhDcvqTZ4uIvR33rboYlQPjhzs
GBkrEOH9bgWnBVEc3L/3d2owW4TGYXwrGRuCDQv8vg6LRGhZrLekQUQwXrmO
PW77zUm7/tDeGpY7a4R2Xp5FQCPtwGe/LcddvMu36C/tpavKysYdckdicjtt
5RHvlFHaK/pmvuqhfaOkiT9Ge3hbxfU+2lkPToiLaF/nVar0037J8JEet02w
Us64vb/wVo9bf1fw+wHayW8Tj4zbqOJS1hDtRK/8onH/73cI9hs0fRx3+ewy
1rh1vAMrxv1sivMqej9GW236sWgPZThnjFutUZOM+3/tEgxTWiAY93wxhfBx
//5K3ybtiOV16eOe+v/dI/qvHYIf/v9xRP99juB//3cV//d/F/4fvV9UFQ==

     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-2., 2.}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Zur L\[ODoubleDot]sung einer Eliminationsaufgabe bietet sich das Kommando \
",
 StyleBox["Eliminate",
  FontWeight->"Bold"],
 " an. \nWichtig: bei Eliminate muss ",
 "\[Equal]",
 " und nicht = verwendet werden; trotzdem ist das Ergebnis nicht das, was wir \
wollten."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3.36386576363678*^9, 3.36386582056789*^9}, {
   3.36386592018833*^9, 3.3638659363723*^9}, 3.389275062148157*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "t"}], "]"}]}]}], "}"}], ",", "t"}], "]"}]], "Input",\

 PageWidth->Infinity,
 CellChangeTimes->{{3.36388044464927*^9, 3.36388044517216*^9}, {
  3.389275062346017*^9, 3.38927506235256*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eliminate", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Eliminate\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCos", "[", "y", "]"}], "\[Equal]", 
  RowBox[{"3", " ", 
   RowBox[{"ArcCos", "[", 
    FractionBox["x", "2"], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dabei hat ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " genau das gemacht, was wir gefordert haben: beide Gleichungen nach ",
 StyleBox["t",
  FontSlant->"Italic"],
 " aufgel\[ODoubleDot]st und gleichgesetzt. Wir wollten aber eigentlich \
Cos[t] eliminiert haben."
}], "SmallText",
 CellChangeTimes->{{3.36386583244242*^9, 3.36386586964976*^9}, {
  3.36386594180275*^9, 3.36386598903175*^9}, {3.36386604721006*^9, 
  3.36386608119989*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "t"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"Cos", "[", "t", "]"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.3638660142993*^9, 3.3638660219792*^9}, {
  3.3638804493683*^9, 3.36388044967379*^9}, {3.389275062360644*^9, 
  3.389275062366828*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"3", " ", "t"}], "]"}], "\[Equal]", "y"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das ging leider auch daneben: ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " wei\[SZ] von sich aus nicht, dass Cos[3t] auch was mit Cos[t] zu tun hat."
}], "SmallText",
 CellChangeTimes->{{3.36386608474984*^9, 3.3638661626113*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"3", " ", "t"}], "]"}], "//", "TrigExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "t", "]"}], "3"], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Cos", "[", "t", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x_", "]"}], "2"], "->", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "t", "]"}], "3"], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Cos", "[", "t", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "t", "]"}], "2"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y0", "=", 
  RowBox[{"%", "//", "Expand"}]}]], "Input",
 CellChangeTimes->{{3.36388177719429*^9, 3.36388177818664*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "3"}], " ", 
   RowBox[{"Cos", "[", "t", "]"}]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "t", "]"}], "3"]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Mit der so umgeformten rechten Seite der Bestimmungsgleichung f\[UDoubleDot]r \
y und Elimination nach Cos[t] statt t gelingt nun die Elimination.\
\>", "SmallText",
 CellChangeTimes->{{3.36386619150412*^9, 3.36386619422038*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gl", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
      RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", 
    RowBox[{"Cos", "[", "t", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389275062375588*^9, 3.389275062381796*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y"}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Auch bei Elimination nach t erhalten wir dasselbe Ergebnis, weil die \
Gleichungen polynomial im einzigen Kern Cos[t] sind. Einzig eine zus\
\[ADoubleDot]tzliche Warnung wird ausgegeben.\
\>", "SmallText",
 CellChangeTimes->{{3.382505638611945*^9, 3.3825057323002*^9}, {
  3.38250589900014*^9, 3.382505947142995*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.38927506238969*^9, 3.389275062395759*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eliminate", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Eliminate\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y"}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Reduce ",
  FontWeight->"Bold"],
 "liefert die L\[ODoubleDot]sung der Aufgabe, in einige \
zus\[ADoubleDot]tzliche Terme eingebettet, \[UDoubleDot]brigens ohne \
vorbereitende Umformungen."
}], "SmallText",
 CellChangeTimes->{{3.382505964631394*^9, 3.382506041886047*^9}, {
   3.382506091824419*^9, 3.382506094348392*^9}, {3.389276313618008*^9, 
   3.389276322077959*^9}, {3.3892763531882*^9, 3.389276424469975*^9}, 
   3.389276534225356*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Cos", "[", 
        RowBox[{"3", "t"}], "]"}]}]}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.382505773779188*^9, 3.382505775508621*^9}, {3.382505808959411*^9, 
  3.382505840183094*^9}, {3.389275062403639*^9, 3.389275062409658*^9}, {
  3.389276180794036*^9, 3.38927619886934*^9}, {3.38927790133823*^9, 
  3.389277904665092*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"t", "\[Equal]", 
     RowBox[{"\[Pi]", "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "+", "x"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "x"}], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            RowBox[{"2", "-", "x"}]], 
           SqrtBox[
            RowBox[{"2", "+", "x"}]]], "]"}]}], "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
      RowBox[{"t", "\[Equal]", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            RowBox[{"2", "-", "x"}]], 
           SqrtBox[
            RowBox[{"2", "+", "x"}]]], "]"}]}], "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.382505773779188*^9, 3.382505775508621*^9}, {3.382505808959411*^9, 
  3.382505840183094*^9}, {3.389275062403639*^9, 3.389275062409658*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}], "+", 
      SuperscriptBox["x", "3"]}], ")"}]}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"t", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ArcCos", "[", 
        FractionBox["x", "2"], "]"}]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"t", "\[Equal]", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       FractionBox["x", "2"], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " mit Cos[t] als Eliminationsziel stellt x in Abh\[ADoubleDot]ngigkeit von y \
als ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdruck dar. y muss mit in die Liste der Variablen aufgenommen werden, \
nach denen aufgel\[ODoubleDot]st wird, um y durch x auszudr\[UDoubleDot]cken \
und zu obigem Ergebnis zu gelangen. "
}], "SmallText",
 CellChangeTimes->{{3.382506099884212*^9, 3.382506209312404*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"Cos", "[", "t", "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.382505773779188*^9, 3.382505775508621*^9}, {3.382505808959411*^9, 
  3.382505811365045*^9}, {3.382505857057821*^9, 3.382505861720855*^9}, {
  3.38927506241803*^9, 3.389275062424254*^9}, {3.38927878525541*^9, 
  3.389278804054683*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}], "+", 
      SuperscriptBox["x", "3"]}], ")"}]}]}], "&&", 
  RowBox[{
   RowBox[{"Cos", "[", "t", "]"}], "\[Equal]", 
   FractionBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Nun verwandeln wir die Gleichung in einen expliziten Funktionszusammenhang \
y=y(x)\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"gl", ",", "y"}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.382506231056918*^9, 3.382506232752561*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", "x"}], "+", 
       SuperscriptBox["x", "3"]}], ")"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "x_", "]"}], "=", 
   RowBox[{"y", "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}],
   ";"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.36386624626444*^9, 3.36386627810723*^9, 3.3638663669547*^9, {
   3.3638825095702*^9, 3.36388251415049*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.36386625600973*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmXk0lV8Xx1WaJKkQUlSUUFFKVLYGJUWSJJUiaVZkCpUkqYQUSZPMRSWE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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-2, 2}, {-0.9999998288044623, 0.9999998519380949}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Als Wertebereich f\[UDoubleDot]r ",
 StyleBox["x",
  FontSlant->"Italic"],
 " wurde der gleiche Bereich wie oben im ersten Plot verwendet. Die \
Schnittpunkte mit den Achsen ergeben sich als "
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3.36386656527568*^9, 3.36386661178261*^9}, {
  3.36386664800726*^9, 3.36386666174014*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.389275062448979*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["3"]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
und die gesuchte Fl\[ADoubleDot]che (beachten Sie die Vorzeichenregeln) zu\
\>", "SmallText",
 CellChangeTimes->{{3.36386668289751*^9, 3.36386671496544*^9}, {
  3.36386674597703*^9, 3.36386674938859*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", 
     SqrtBox["3"]}], "0"], 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 FractionBox["9", "4"]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Komplexe Wurzeln", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36386676316605*^9, 3.36386676782471*^9}, {3.36386875230835*^9, 
  3.36386875783081*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:",
  FontWeight->"Bold",
  Background->None],
 StyleBox["\n",
  Background->None],
 "L\[ODoubleDot]sen Sie die Gleichung ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "3"], "=", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"4", " ", "\[ImaginaryI]"}]}], ")"}], "5"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "-", 
        RowBox[{"3", "\[ImaginaryI]"}]}], ")"}], "2"]]}], TraditionalForm]]],
 " im Bereich der komplexen Zahlen und stellen Sie die L\[ODoubleDot]sungen \
in der Gau\[SZ]schen Zahlenebene grafisch dar."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
  3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369, 
  3363865693.92767}, {3363868776.11101, 3363868889.87804}, {3363868987.67785, 
  3363868988.94409}},
 Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["z", "3"], "\[Equal]", " ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"4", "I"}]}], ")"}], "5"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"3", "I"}]}], ")"}], "2"]]}], ",", "z"}], "]"}]}]}], "Input",\

 CellChangeTimes->{3.36386911163634*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"117", "-", 
        RowBox[{"44", " ", "\[ImaginaryI]"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"117", "-", 
         RowBox[{"44", " ", "\[ImaginaryI]"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"117", "-", 
         RowBox[{"44", " ", "\[ImaginaryI]"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Ergebnis sollte in der Form",
 StyleBox[" ", "InlineFormula"],
 Cell[BoxData[
  RowBox[{"a", " ", "+", " ", 
   RowBox[{
    SuperscriptBox["b", "2"], "\[ImaginaryI]"}]}]]],
 " ausgegeben werden."
}], "SmallText",
 CellChangeTimes->{3.36386912950609*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"117", "-", 
        RowBox[{"44", " ", "\[ImaginaryI]"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"117", "-", 
         RowBox[{"44", " ", "\[ImaginaryI]"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Auch ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " f\[UDoubleDot]hrt zu keinem besseren Ergebnis."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"625", "-", 
         RowBox[{"150", " ", "#1"}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"625", "-", 
         RowBox[{"150", " ", "#1"}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die beiden anderen Wurzeln sind algebraische Zahlen vom Grad 4. Mit der \
Root-Notation kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " besser rechnen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{"z", "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "//",
    "RootReduce"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"625", "-", 
     RowBox[{"150", " ", "#1"}], "+", 
     RowBox[{"11", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"6", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Wir extrahieren das Minimalpolynom und bestimmen dessen Nullstellen. Zwei \
davon sind die nicht identifizierten Elemente aus ",
 StyleBox["lsg",
  FontSlant->"Italic"],
 "."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "[", 
   "z", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"625", "-", 
  RowBox[{"150", " ", "z"}], "+", 
  RowBox[{"11", " ", 
   SuperscriptBox["z", "2"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  SuperscriptBox["z", "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", "z"}], "]"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["3", "2"], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        SqrtBox["3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["3", "2"], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["z", "3"], "/.", "lsg1"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"117", "-", 
    RowBox[{"44", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"117", "+", 
    RowBox[{"44", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"117", "+", 
    RowBox[{"44", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"117", "-", 
    RowBox[{"44", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Wir transformieren ",
 StyleBox["lsg",
  FontSlant->"Italic"],
 " in numerische N\[ADoubleDot]herungswerte, um ein Bild zu erstellen. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nlsg", "=", 
  RowBox[{"N", "[", "lsg", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"4.964101615137755`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.598076211353316`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "3.000000000000001`"}], "-", 
      RowBox[{"4.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.964101615137754`"}], "+", 
      RowBox[{"4.598076211353318`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lst", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], ",", 
     RowBox[{"Im", "[", "z", "]"}]}], "}"}], " ", "/.", "nlsg"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.964101615137755`", ",", 
     RowBox[{"-", "0.598076211353316`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.000000000000001`"}], ",", 
     RowBox[{"-", "4.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.964101615137754`"}], ",", "4.598076211353318`"}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"lst", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.04", "]"}]}], ",", " ", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6"}], ",", "6"}], "}"}]}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.36386926480238*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.04], 
    PointBox[{{
     4.964101615137755, -0.598076211353316}, {-3.000000000000001, -4.}, \
{-1.964101615137754, 4.598076211353318}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3.000000000000001, 4.964101615137755}, {-6, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eine Extremwertaufgabe", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36386676316605*^9, 3.36386676782471*^9}, {3.36388357638755*^9, 
  3.36388358883075*^9}, {3.36388389001981*^9, 3.36388389423147*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:\n",
  FontWeight->"Bold",
  Background->None],
 StyleBox["Der Ellipse",
  Background->None],
 StyleBox[" ",
  FontWeight->"Bold",
  Background->None],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"9", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"16", 
     SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]]],
 " soll ein Rechteck maximaler Fl\[ADoubleDot]che einbeschrieben werden, \
dessen Seiten parallel zu den Koordinatenachsen sind.\n\nBestimmen Sie\na) \
die Abmessungen dieses Rechtecks und\nb) das Volumen des Ellipsoids und des \
Zylinders, die bei Drehung dieser Figueren um die ",
 StyleBox["x",
  FontSlant->"Italic"],
 "-Achse entstehen. "
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
   3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369,
    3363865693.92767}, {3363869342.87972, 3363869472.10979}, 
   3363884017.64136, {3363884104.60001, 3363884264.8706}},
 Background->RGBColor[1, 1, 0]],

Cell["Ein Bild der Situation erstellen. Die Ellipse:", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{"ellipse", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"9", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"16", 
     SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386221101731*^9, 3.36386221393524*^9}, {
  3.36386949443442*^9, 3.36386949724216*^9}, {3.381908517689234*^9, 
  3.381908531351125*^9}, {3.381908565193753*^9, 3.381908782525855*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"9", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"16", " ", 
    SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]], "Output"]
}, Open  ]],

Cell["\<\
Die Ellipse kann nun mit ContourPlot gezeichnet werden. Die \
Standardeinstellungen (mit Frame, ohne Achsen, nicht \
ma\[SZ]st\[ADoubleDot]blich) sind ge\[ADoubleDot]ndert.\
\>", "SmallText",
 CellChangeTimes->{{3.381908789864228*^9, 3.381908878878545*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e1", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", "ellipse", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "False"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386221101731*^9, 3.36386221393524*^9}, {
  3.36386949443442*^9, 3.36386949724216*^9}, {3.381908517689234*^9, 
  3.381908531351125*^9}, {3.381908565193753*^9, 3.381908782525855*^9}, {
  3.381908836747103*^9, 3.381908842116796*^9}, {3.381909332230506*^9, 
  3.381909340706379*^9}, {3.389284627895886*^9, 3.389284663712778*^9}, {
  3.389285150583336*^9, 3.389285167785092*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdl3tQVEcWxmGcmYsKMxIWSWABCRaRBbO6YIwhpBs1iIm4ZBEfBFjBJBoN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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 
        215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227}],
       RowBox[{
         RowBox[{
           RowBox[{"9", " ", 
             SuperscriptBox["x", "2"]}], "+", 
           RowBox[{"16", " ", 
             SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]],
      Annotation[#, 9 $CellContext`x^2 + 16 $CellContext`y^2 == 144, 
       "Tooltip"]& ]}}],
  Axes->True,
  PlotRange->{{-6, 6}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Berechnung der Eckpunkte ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[PlusMinus]", 
     SubscriptBox["x", "0"]}], ",", 
    RowBox[{"\[PlusMinus]", 
     SubscriptBox["y", "0"]}]}], ")"}]]],
 " des einbeschriebenen Rechtecks bei vogegebenem ",
 Cell[BoxData[
  SubscriptBox["x", "0"]]],
 ":"
}], "SmallText",
 CellChangeTimes->{3.36386950773648*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"ellipse", ",", "y"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["3", "4"]}], " ", 
      SqrtBox[
       RowBox[{"16", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox[
        RowBox[{"16", "-", 
         SuperscriptBox["x", "2"]}]]}], "4"]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["y", "0"], "=", 
  RowBox[{
   RowBox[{"y", "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    
   RowBox[{"x", "\[Rule]", 
    SubscriptBox["x", "0"]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "4"], " ", 
  SqrtBox[
   RowBox[{"16", "-", 
    SubsuperscriptBox["x", "0", "2"]}]]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beachten Sie, dass ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "0"], TraditionalForm]]],
 " keine Funktion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "0"], "[", 
    SubscriptBox["x", "0"], "]"}], TraditionalForm]]],
 ", sondern ein Ausdruck ist, welcher die Variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "0"], " "}], TraditionalForm]]],
 "enth\[ADoubleDot]lt. Diese kann durch ein Subsitutionskommando belegt \
werden. \nAlles in einer gemeinsamen Grafik darstellen ..."
}], "SmallText",
 CellChangeTimes->{{3.3638695356302*^9, 3.36386959467424*^9}, {
  3.36418594053497*^9, 3.36418595599481*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rechteck", " ", "=", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        SubscriptBox["y", "0"]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "0"]}], ",", 
        SubscriptBox["y", "0"]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "0"]}], ",", 
        RowBox[{"-", 
         SubscriptBox["y", "0"]}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        RowBox[{"-", 
         SubscriptBox["y", "0"]}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        SubscriptBox["y", "0"]}], "}"}]}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"e1", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"rechteck", "/.", 
     RowBox[{
      SubscriptBox["x", "0"], "\[Rule]", "1.6"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"rechteck", "/.", 
     RowBox[{
      SubscriptBox["x", "0"], "\[Rule]", "3.2"}]}], "]"}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.36386952894811*^9, 3.36386953158946*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdl3tQVEcWxmGcmYsKMxIWSWABCRaRBbO6YIwhpBs1iIm4ZBEfBFjBJBoN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    "], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      TagBox[
       TooltipBox[
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227}],
        RowBox[{
          RowBox[{
            RowBox[{"9", " ", 
              SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"16", " ", 
              SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]],
       Annotation[#, 9 $CellContext`x^2 + 16 $CellContext`y^2 == 144, 
        "Tooltip"]& ]}}], 
   LineBox[{{1.6, 2.749545416973504}, {-1.6, 
    2.749545416973504}, {-1.6, -2.749545416973504}, {
    1.6, -2.749545416973504}, {1.6, 2.749545416973504}}], 
   LineBox[{{3.2, 1.7999999999999996`}, {-3.2, 
    1.7999999999999996`}, {-3.2, -1.7999999999999996`}, {
    3.2, -1.7999999999999996`}, {3.2, 1.7999999999999996`}}]},
  Axes->True,
  PlotRange->{{-6, 6}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell["... oder eine Animation erstellen:", "SmallText",
 CellChangeTimes->{{3.36386960005296*^9, 3.36386961122463*^9}}],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"e1", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"rechteck", "/.", 
       RowBox[{
        SubscriptBox["x", "0"], "\[Rule]", "u"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.3", ",", "3.8", ",", "0.2"}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.36386963136962*^9, 3.3638696782911*^9}}],

Cell["\<\
Und nun die analytische L\[ODoubleDot]sung der Aufgabe a). \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"flaeche", "=", 
  RowBox[{
   RowBox[{"4", "x", " ", "y"}], "/.", 
   RowBox[{
   "lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"3", " ", "x", " ", 
  SqrtBox[
   RowBox[{"16", "-", 
    SuperscriptBox["x", "2"]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"extrema", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"flaeche", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36418709582577*^9, 3.36418709855537*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"flaeche", "/.", 
  RowBox[{
  "extrema", "\[LeftDoubleBracket]", "2", 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.36418710250986*^9, 3.36418710481768*^9}}],

Cell[BoxData["24"], "Output"]
}, Open  ]],

Cell["\<\
Jetzt beginnt der zweite Rechenabschnitt - die Berechnung der Volumens des \
Rotationsellipsoids und des Zylinders.
Die Begrenzungskurve\
\>", "SmallText",
 Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["f", "1"], "[", "x_", "]"}], "=", 
  RowBox[{"y", "/.", 
   RowBox[{
   "lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SqrtBox[
    RowBox[{"16", "-", 
     SuperscriptBox["x", "2"]}]]}], "4"]], "Output"]
}, Open  ]],

Cell["Die Grenzen ", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"ellipse", "/.", 
    RowBox[{"y", "\[Rule]", "0"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ellipsoidVolumen", "=", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{
    UnderoverscriptBox["\[Integral]", 
     RowBox[{"-", "4"}], "4"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SubscriptBox["f", "1"], "[", "x", "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"48", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zylinderVolumen", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "\[Pi]", " ", "x", " ", 
     SuperscriptBox["y", "2"]}], "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    
   RowBox[{
   "extrema", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.36418711911802*^9, 3.36418712163934*^9}, {
  3.36418719291803*^9, 3.36418723047086*^9}}],

Cell[BoxData[
 RowBox[{"18", " ", 
  SqrtBox["2"], " ", "\[Pi]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analytische Geometrie", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36386676316605*^9, 3.36386676782471*^9}, {3.36388357638755*^9, 
  3.36388358883075*^9}, {3.36388389001981*^9, 3.36388389423147*^9}, {
  3.36418487488781*^9, 3.36418487847423*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:\n",
  FontWeight->"Bold",
  Background->None],
 "Der Kreis ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"6", "y"}], "-", "91"}], "\[Equal]", "0"}], TraditionalForm]]],
 " und die Kurve ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", "b"}]}], TraditionalForm]]],
 " schneiden einander in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", "(", 
     RowBox[{"6", ";", "y"}], ")"}], ",", " ", 
    RowBox[{"y", ">", "0"}], ","}], TraditionalForm]]],
 " unter einem Winkel von 90 Grad.\n\na) Berechnen Sie ",
 StyleBox["a",
  FontSlant->"Italic"],
 " und ",
 StyleBox["b",
  FontSlant->"Italic"],
 ".\nb) Die Schnittfl\[ADoubleDot]che der beiden Kurven rotiert um die ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-Achse.  \nBerechnen Sie das Volumen des entstehenden Rotationsk\
\[ODoubleDot]rpers."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
   3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369,
    3363865693.92767}, {3363869342.87972, 3363869472.10979}, 
   3363884017.64136, {3363884104.60001, 3363884264.8706}, {3364184972.02352, 
   3364185124.88087}},
 Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"kreis", "=", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       RowBox[{"6", "y"}], "-", "91"}], "\[Equal]", "0"}]}], ",", "y"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.36418817394384*^9, 3.36418817498613*^9}, 
   3.389275062793047*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      SqrtBox[
       RowBox[{"100", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox[
       RowBox[{"100", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], "=", 
  RowBox[{"y", "/.", 
   RowBox[{
   "lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  SqrtBox[
   RowBox[{"100", "-", 
    SuperscriptBox["x", "2"]}]]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Koordinaten des Punktes ",
 StyleBox["P",
  FontSlant->"Italic"],
 " ergeben sich nun durch Einsetzen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"f1", "[", "6", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "5"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}], "+", "b"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"b", "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die beiden Parameter ",
 StyleBox["a",
  FontSlant->"Italic"],
 " und ",
 StyleBox["b",
  FontSlant->"Italic"],
 " ergeben sich aus den Bedingungen ",
 StyleBox["f1[6]\[Equal]f[6] ", "InlineFormula"],
 "(beide Kurven gehen durch ",
 StyleBox["P",
  FontSlant->"Italic"],
 ") und f1'[6]\[CenterDot]f'[6]\[Equal]",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]]],
 " (beide Kurven stehen in ",
 StyleBox["P",
  FontSlant->"Italic"],
 " aufeinander senkrecht)."
}], "SmallText",
 CellChangeTimes->{{3.36418514789761*^9, 3.36418520407457*^9}, {
  3.3641852343762*^9, 3.3641852834606*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "6", "]"}], "\[Equal]", 
     RowBox[{"f", "[", "6", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f1", "'"}], "[", "6", "]"}], "*", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "6", "]"}]}], "\[Equal]", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.389275062888217*^9, 3.389275062894715*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"5", "\[Equal]", 
    RowBox[{
     RowBox[{"36", " ", "a"}], "+", "b"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "9"}], " ", "a"}], "\[Equal]", 
    RowBox[{"-", "1"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox["1", "9"]}], ",", 
    RowBox[{"b", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "/.", 
   RowBox[{
   "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "9"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "[", "x", "]"}], ",", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36418532509027*^9, {3.36418849027501*^9, 3.36418850997932*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Xk0ldv7APBjOrkoQzKct4HzSpJKGZLU3qWByJWkJBJyS93mJFNCElKZ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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk0VV/YB/BrTOZ5KsIlF9GgKNSzI5UIqVQ0olIRIbMmQiklMw2Gkil+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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-10, 10}, {-2.9971428571726526`, 12.111110204081651`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Berechnung des Volumens des K\[ODoubleDot]rpers, der sich aus der Rotation \
der gemeinsamen Fl\[ADoubleDot]chenanteile um die ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-Achse ergibt (nach der Formel ",
 Cell[BoxData[
  FormBox[
   RowBox[{"V", "=", 
    RowBox[{"\[Pi]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", "[", "y", "]"}], "2"], 
       RowBox[{"\[DifferentialD]", "y"}]}]}]}]}], TraditionalForm]]],
 "). Die Integrationsgrenzen sind jeweils 5 und f1[0] bzw. f2[0] und 5.\n",
 "\n",
 "Aus der Kreisgleichung wird dazu zun\[ADoubleDot]chst die Umkehrfunktion \
g1[y] extrahiert"
}], "SmallText",
 CellChangeTimes->{{3.36418856724299*^9, 3.36418857596674*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"kreis", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36418857902082*^9, 3.36418857965674*^9}, 
   3.36418893906933*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"91", "-", 
        RowBox[{"6", " ", "y"}], "-", 
        SuperscriptBox["y", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"91", "-", 
       RowBox[{"6", " ", "y"}], "-", 
       SuperscriptBox["y", "2"]}]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "[", "y_", "]"}], "=", 
  RowBox[{"x", "/.", " ", 
   RowBox[{
   "sol1", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.36418858328468*^9, 3.3641885845029*^9}, 
   3.36418894048644*^9}],

Cell[BoxData[
 SqrtBox[
  RowBox[{"91", "-", 
   RowBox[{"6", " ", "y"}], "-", 
   SuperscriptBox["y", "2"]}]]], "Output"]
}, Open  ]],

Cell["\<\
Der erste Teil des Volumenintegrals ergibt sich dann als Integral \
\[UDoubleDot]ber g1 von y=5 bis y=f1[0], dem y-Wert des Schnittpunkts des \
Kreises mit der Ordinatenachse.\
\>", "SmallText",
 CellChangeTimes->{{3.36418862517853*^9, 3.36418877560342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vol1", "=", 
  RowBox[{"\[Pi]", 
   RowBox[{
    UnderoverscriptBox["\[Integral]", "5", 
     RowBox[{"f1", "[", "0", "]"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"g1", "[", "y", "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"112", " ", "\[Pi]"}], "3"]], "Output"]
}, Open  ]],

Cell["\<\
Analog ergibt sich das zweite Teilvolumen und das Gesamtvolumen als Summe \
beider.\
\>", "SmallText",
 CellChangeTimes->{{3.36418897179539*^9, 3.36418900084568*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"f2", "[", "x", "]"}]}], " ", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36418894958666*^9, 3.36418895044425*^9}, 
   3.389275062908545*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "y"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"3", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "y"}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", "[", "y_", "]"}], "=", 
  RowBox[{"x", "/.", " ", 
   RowBox[{
   "sol2", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.36418895328616*^9, 3.36418895408685*^9}}],

Cell[BoxData[
 RowBox[{"3", " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vol2", "=", 
  RowBox[{"\[Pi]", 
   RowBox[{
    UnderoverscriptBox["\[Integral]", 
     RowBox[{"f2", "[", "0", "]"}], "5"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"g2", "[", "y", "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"72", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vol", "=", 
  RowBox[{"vol1", "+", "vol2"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"328", " ", "\[Pi]"}], "3"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "10"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{"f1", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{"f2", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"l", ",", "r1", ",", "r2", ",", 
   RowBox[{"Boxed", "->", "False"}], ",", 
   RowBox[{"ViewAngle", "->", 
    RowBox[{"20", "\[Degree]"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389293991428398*^9, 3.389294002401612*^9}, {
  3.389294164752849*^9, 3.389294205141758*^9}, {3.389294240555805*^9, 
  3.389294285456476*^9}, {3.389294315569954*^9, 3.389294400260601*^9}, {
  3.389294590242403*^9, 3.389294598961666*^9}, {3.389294717806356*^9, 
  3.389294725146193*^9}, {3.389294800831515*^9, 3.38929481088832*^9}, {
  3.389294844121712*^9, 3.389294890408359*^9}, {3.389294921482363*^9, 
  3.389294933002795*^9}, {3.389294975338399*^9, 3.389295146112736*^9}, {
  3.389295183220936*^9, 3.389295196510823*^9}, {3.389295257875568*^9, 
  3.389295345365911*^9}, {3.389295377823614*^9, 3.389295384144224*^9}, {
  3.389295415420813*^9, 3.389295433118382*^9}, {3.389295548590586*^9, 
  3.389295596318355*^9}, {3.389295631414908*^9, 3.389295662432914*^9}, {
  3.389295698631657*^9, 3.389295703645731*^9}, {3.389295740092256*^9, 
  3.389295808789632*^9}, {3.389296029416273*^9, 3.389296106073516*^9}, {
  3.3892967634229*^9, 3.389296778137387*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Thickness[Large], Line3DBox[{{0, 0, -2}, {0, 0, 10}}]}, 
   GraphicsComplex3DBox[CompressedData["
1:eJyFnHc8V+/7x+0VkmztSENakgrntNNCAyHtQQMNNLR3KaOlJEoaRqhUqvc5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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmnf8V9Mfx++551wyK1EZIRoq7aUopCSV0kBGy8pIwyqrIkISRZGyysze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          "]], Polygon3DBox[CompressedData["
1:eJw1mgPYJNfWRqtOn47tTDSTZGLbtm3b5sT2xLZvnBvbtm3bzk3yr5W3/udJ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          "]], Polygon3DBox[CompressedData["
1:eJw113m8TfUWAPBzz71H0aCSVEISJZqJIryIkqGIUCJlqrjInHmeZciUoSQp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          "]], 
         Polygon3DBox[{{859, 1019, 605, 737, 1229, 858}, {1228, 884, 883, 
          1227, 735, 736}}]}]}, {}, {}, {}}, {
      Line3DBox[{307, 1, 303, 227, 775, 16, 274, 789, 31, 276, 803, 46, 1117, 
       278, 61, 1119, 280, 76, 1121, 282, 91, 1123, 284, 860, 106, 286, 887, 
       121, 288, 901, 136, 290, 915, 151, 292, 166, 1129, 294, 181, 1131, 296,
        196, 1112, 268, 309, 211, 306, 298, 507, 212, 508, 213, 509, 214, 510,
        215, 511, 216, 512, 217, 513, 514, 218, 515, 219, 516, 220, 517, 221, 
       518, 222, 519, 223, 520, 224, 759, 270, 310, 225, 304, 269, 982, 210, 
       265, 968, 195, 262, 954, 180, 259, 165, 1100, 256, 150, 1097, 253, 135,
        1094, 250, 120, 1092, 247, 885, 105, 244, 857, 90, 241, 843, 75, 238, 
       829, 60, 1076, 235, 45, 1073, 232, 30, 1070, 229, 308, 15, 305, 272, 
       338, 14, 336, 13, 334, 12, 332, 11, 330, 10, 328, 9, 326, 8, 323, 322, 
       7, 320, 6, 318, 5, 316, 4, 314, 3, 312, 2, 760, 271, 307}], {}, {}, {
       Line3DBox[{312, 522, 1230, 313, 536, 340, 1328, 550, 354, 1332, 564, 
        368, 1339, 578, 382, 1347, 592, 396, 1359, 606, 1271, 410, 620, 1284, 
        424, 1372, 634, 438, 1375, 648, 452, 1379, 662, 466, 1385, 676, 480, 
        1393, 690, 494, 1403, 704, 508}], 
       Line3DBox[{314, 523, 1231, 315, 537, 1243, 341, 551, 355, 1333, 565, 
        369, 1340, 579, 383, 1348, 593, 397, 1360, 607, 1272, 411, 621, 1285, 
        425, 635, 1296, 439, 649, 453, 1380, 663, 467, 1386, 677, 481, 1394, 
        691, 495, 1404, 705, 509}], 
       Line3DBox[{316, 524, 1232, 317, 538, 1244, 342, 552, 1253, 356, 566, 
        370, 1341, 580, 384, 1349, 594, 398, 1361, 608, 1273, 412, 622, 1286, 
        426, 636, 1297, 440, 650, 1306, 454, 664, 468, 1387, 678, 482, 1395, 
        692, 496, 1405, 706, 510}], 
       Line3DBox[{318, 525, 1233, 319, 539, 1245, 343, 553, 1254, 357, 567, 
        1261, 371, 581, 385, 1350, 595, 399, 1362, 609, 1274, 413, 623, 1287, 
        427, 637, 1298, 441, 651, 1307, 455, 665, 1314, 469, 679, 483, 1396, 
        693, 497, 1406, 707, 511}], 
       Line3DBox[{320, 526, 1234, 321, 540, 1246, 344, 554, 1255, 358, 568, 
        1262, 372, 582, 1266, 386, 596, 400, 1363, 610, 1275, 414, 624, 1288, 
        428, 638, 1299, 442, 652, 1308, 456, 666, 1315, 470, 680, 1319, 484, 
        694, 1322, 498, 1407, 708, 512}], 
       Line3DBox[{322, 527, 1235, 324, 541, 1247, 345, 555, 1256, 359, 569, 
        1263, 373, 583, 1267, 387, 597, 1269, 401, 611, 1276, 415, 625, 1289, 
        429, 639, 1300, 443, 653, 1309, 457, 667, 1316, 471, 681, 1320, 485, 
        695, 1323, 499, 709, 1324, 513}], 
       Line3DBox[{326, 529, 1236, 327, 1327, 543, 347, 1330, 557, 361, 1335, 
        571, 375, 1343, 585, 389, 1352, 599, 403, 1365, 613, 1277, 417, 627, 
        1290, 431, 1374, 641, 445, 1377, 655, 459, 1382, 669, 473, 1389, 683, 
        487, 1398, 697, 501, 1409, 711, 515}], 
       Line3DBox[{328, 530, 1237, 329, 544, 1248, 348, 1331, 558, 362, 1336, 
        572, 376, 1344, 586, 390, 1353, 600, 404, 1366, 614, 1278, 418, 628, 
        1291, 432, 642, 1301, 446, 1378, 656, 460, 1383, 670, 474, 1390, 684, 
        488, 1399, 698, 502, 1410, 712, 516}], 
       Line3DBox[{330, 531, 1238, 331, 545, 1249, 349, 559, 1257, 363, 1337, 
        573, 377, 1345, 587, 391, 1354, 601, 405, 1367, 615, 1279, 419, 629, 
        1292, 433, 643, 1302, 447, 657, 1310, 461, 1384, 671, 475, 1391, 685, 
        489, 1400, 699, 503, 1411, 713, 517}], 
       Line3DBox[{332, 532, 1239, 333, 546, 1250, 350, 560, 1258, 364, 1338, 
        574, 378, 1346, 588, 392, 1355, 602, 406, 1368, 616, 1280, 420, 630, 
        1293, 434, 644, 1303, 448, 658, 1311, 462, 672, 476, 1392, 686, 490, 
        1401, 700, 504, 1412, 714, 518}], 
       Line3DBox[{334, 533, 1240, 335, 547, 1251, 351, 561, 1259, 365, 575, 
        1264, 379, 589, 393, 1356, 603, 407, 1369, 617, 1281, 421, 631, 1294, 
        435, 645, 1304, 449, 659, 1312, 463, 673, 1317, 477, 687, 491, 1402, 
        701, 505, 1413, 715, 519}], 
       Line3DBox[{336, 534, 1241, 337, 548, 1252, 352, 562, 1260, 366, 576, 
        1265, 380, 590, 1268, 394, 1357, 604, 408, 1370, 618, 1282, 422, 632, 
        1295, 436, 646, 1305, 450, 660, 1313, 464, 674, 1318, 478, 688, 1321, 
        492, 702, 506, 1414, 716, 520}], 
       Line3DBox[{338, 718, 719, 1242, 761, 720, 1415, 721, 762, 723, 1417, 
        724, 763, 726, 1419, 727, 764, 729, 1421, 730, 765, 732, 1423, 733, 
        766, 1437, 735, 736, 1283, 767, 738, 739, 768, 741, 1426, 742, 769, 
        744, 1428, 745, 770, 747, 1430, 748, 771, 750, 1432, 751, 772, 753, 
        1434, 754, 773, 756, 757, 759}], 
       Line3DBox[{507, 703, 1436, 758, 493, 689, 1435, 755, 479, 675, 1433, 
        752, 465, 661, 1431, 749, 451, 647, 1429, 746, 437, 633, 1427, 743, 
        423, 619, 1425, 740, 409, 1270, 605, 737, 1358, 395, 591, 1424, 734, 
        381, 577, 1422, 731, 367, 563, 1420, 728, 353, 549, 1418, 725, 339, 
        535, 1416, 722, 311, 521, 717, 760}], 
       Line3DBox[{514, 710, 1408, 500, 696, 1397, 486, 682, 1388, 472, 668, 
        1381, 458, 654, 1376, 444, 640, 1373, 430, 626, 1371, 416, 612, 1364, 
        402, 598, 1351, 388, 584, 1342, 374, 570, 1334, 360, 556, 1329, 346, 
        542, 1326, 325, 528, 1325, 323}]}, {
       Line3DBox[{775, 1069, 521, 774, 1230, 983, 776, 1231, 984, 777, 1232, 
        985, 778, 1233, 986, 779, 1234, 987, 780, 1235, 1133, 1325, 781, 1236,
         988, 782, 1237, 989, 783, 1238, 990, 784, 1239, 991, 785, 1240, 992, 
        786, 1241, 993, 787, 1226, 1242, 1113, 994, 1070}], 
       Line3DBox[{789, 1072, 1134, 1416, 788, 536, 790, 1243, 995, 791, 1244, 
        996, 792, 1245, 997, 793, 1246, 998, 794, 1247, 1135, 1326, 795, 1136,
         1327, 796, 1248, 999, 797, 1249, 1000, 798, 1250, 1001, 799, 1251, 
        1002, 800, 1252, 1003, 801, 1415, 1071, 1114, 1004, 1073}], 
       Line3DBox[{803, 1075, 1137, 1418, 802, 1138, 1328, 804, 551, 805, 1253,
         1005, 806, 1254, 1006, 807, 1255, 1007, 808, 1256, 1139, 1329, 809, 
        1140, 1330, 810, 1141, 1331, 811, 1257, 1008, 812, 1258, 1009, 813, 
        1259, 1010, 814, 1260, 1011, 815, 1417, 1074, 1115, 1012, 1076}], 
       Line3DBox[{829, 1078, 1116, 1077, 1419, 828, 1016, 1265, 827, 1015, 
        1264, 826, 1338, 1148, 825, 1337, 1147, 824, 1336, 1146, 823, 1335, 
        1145, 822, 1334, 1144, 1263, 821, 1014, 1262, 820, 1013, 1261, 819, 
        566, 818, 1333, 1143, 817, 1332, 1142, 816, 1420, 1080, 1079, 1117}], 
       Line3DBox[{843, 1082, 1118, 1081, 1421, 842, 1018, 1268, 841, 589, 840,
         1346, 1156, 839, 1345, 1155, 838, 1344, 1154, 837, 1343, 1153, 836, 
        1342, 1152, 1267, 835, 1017, 1266, 834, 581, 833, 1341, 1151, 832, 
        1340, 1150, 831, 1339, 1149, 830, 1422, 1084, 1083, 1119}], 
       Line3DBox[{857, 1086, 1120, 1085, 1423, 856, 1357, 1167, 855, 1356, 
        1166, 854, 1355, 1165, 853, 1354, 1164, 852, 1353, 1163, 851, 1352, 
        1162, 850, 1351, 1161, 1269, 849, 596, 848, 1350, 1160, 847, 1349, 
        1159, 846, 1348, 1158, 845, 1347, 1157, 844, 1424, 1088, 1087, 1121}],
        Line3DBox[{860, 1091, 1270, 1019, 859, 1271, 1020, 862, 1272, 1021, 
        864, 1273, 1022, 866, 1274, 1023, 868, 1275, 1024, 870, 1276, 612, 
        872, 1277, 1025, 874, 1278, 1026, 876, 1279, 1027, 878, 1280, 1028, 
        880, 1281, 1029, 882, 1282, 1030, 884, 1228, 1283, 1124, 1031, 1092}],
        Line3DBox[{885, 1089, 1122, 1437, 1227, 883, 1370, 1178, 881, 1369, 
        1177, 879, 1368, 1176, 877, 1367, 1175, 875, 1366, 1174, 873, 1365, 
        1173, 871, 1364, 611, 869, 1363, 1172, 867, 1362, 1171, 865, 1361, 
        1170, 863, 1360, 1169, 861, 1359, 1168, 858, 1229, 1358, 1090, 1123}],
        Line3DBox[{887, 1093, 1179, 1425, 886, 1284, 1032, 888, 1285, 1033, 
        889, 1286, 1034, 890, 1287, 1035, 891, 1288, 1036, 892, 1289, 1180, 
        1371, 893, 1290, 1037, 894, 1291, 1038, 895, 1292, 1039, 896, 1293, 
        1040, 897, 1294, 1041, 898, 1295, 1042, 899, 739, 1125, 1043, 1094}], 
       Line3DBox[{901, 1096, 1181, 1427, 900, 1182, 1372, 902, 1296, 1044, 
        903, 1297, 1045, 904, 1298, 1046, 905, 1299, 1047, 906, 1300, 1183, 
        1373, 907, 1184, 1374, 908, 1301, 1048, 909, 1302, 1049, 910, 1303, 
        1050, 911, 1304, 1051, 912, 1305, 1052, 913, 1426, 1095, 1126, 1053, 
        1097}], Line3DBox[{915, 1099, 1185, 1429, 914, 1186, 1375, 916, 649, 
        917, 1306, 1054, 918, 1307, 1055, 919, 1308, 1056, 920, 1309, 1187, 
        1376, 921, 1188, 1377, 922, 1189, 1378, 923, 1310, 1057, 924, 1311, 
        1058, 925, 1312, 1059, 926, 1313, 1060, 927, 1428, 1098, 1127, 1061, 
        1100}], Line3DBox[{292, 258, 1431, 928, 1190, 1379, 929, 1191, 1380, 
        930, 664, 931, 1314, 1062, 932, 1315, 1063, 933, 1316, 1192, 1381, 
        934, 1193, 1382, 935, 1194, 1383, 936, 1195, 1384, 937, 672, 938, 
        1317, 1064, 939, 1318, 1065, 940, 1430, 257, 259}], 
       Line3DBox[{954, 1102, 1128, 1101, 1432, 953, 1067, 1321, 952, 687, 951,
         1392, 1203, 950, 1391, 1202, 949, 1390, 1201, 948, 1389, 1200, 947, 
        1388, 1199, 1320, 946, 1066, 1319, 945, 679, 944, 1387, 1198, 943, 
        1386, 1197, 942, 1385, 1196, 941, 1433, 1104, 1103, 1129}], 
       Line3DBox[{968, 1106, 1130, 1105, 1434, 967, 702, 966, 1402, 1213, 965,
         1401, 1212, 964, 1400, 1211, 963, 1399, 1210, 962, 1398, 1209, 961, 
        1397, 1208, 1323, 960, 1068, 1322, 959, 1396, 1207, 958, 1395, 1206, 
        957, 1394, 1205, 956, 1393, 1204, 955, 1435, 1108, 1107, 1131}], 
       Line3DBox[{982, 1109, 1132, 756, 981, 1414, 1225, 980, 1413, 1224, 979,
         1412, 1223, 978, 1411, 1222, 977, 1410, 1221, 976, 1409, 1220, 975, 
        1408, 1219, 1324, 974, 1407, 1218, 973, 1406, 1217, 972, 1405, 1216, 
        971, 1404, 1215, 970, 1403, 1214, 969, 1436, 1111, 1110, 1112}]}}},
    VertexNormals->CompressedData["
1:eJx0nHk0Vt//9k0pU5EiTaIMRVIqGtgyFlIplEIqU5MxaUQZImUeknkoFJln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     "]], GraphicsComplex3DBox[CompressedData["
1:eJx0fXc8V+/7v713JO2UNGkahXPaaaBJpV2KEpWM3lHR1hDtSUNDCoUGr3NS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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtnHfgV9Mbx+86996vhFCyRSGbslcRsiN7VvZo2VuRKPuXpKIlZJPsPbJl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          "]], Polygon3DBox[CompressedData["
1:eJwtnAf8T9Ubx+++95eGqNASiRSFlGgplLTQUFJE0aZhq9CiUFpKS2mrKJVo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          "]], Polygon3DBox[CompressedData["
1:eJwt13m8zXUex/HDPZdzKcpO3BtC1uw1xqSFRlxL9uxTjWbG2oLI3oxSlkkM
ipppwcyEEclQUbZUhMky0UOpUU0TbaiInp/5nT/e93zfr+/78/39zu98f9/v
91a/bWS3EUVTqdQKyqWhxVOps8VSqVHpVOpp2lAklfoXn0cZ2keVsHI+p9Cx
nFSqIw1X+44BhmPr+YpUC6vIP0D/4TvTKKwT3yRjHOMvxPZjOdhoeo9fo6+o
dj+f89zPade729h30XV4Q/wStbNld6jdjDWTmyQ3QObn+rb6HII/L1OEysqV
5SfTh3wHGoZtl/sNtpLPpfLYq9gA7Dk+TZqp8v5MpY/4QhoRz8x9VKB3+Z9R
K2rLP+leUh7q++6jL1VQN40+1t+JRure5BoDsaUxPkVJf7WPa5zzPcbrH0fb
6E65FTI5VE5uB/ZbbFXUUQXsRrWL4rdTe8g1e9LH8czk3pRpSDdGTuZW2eH6
bpapLF8o0xiryC+Qe1dut/5h+EsxPl2BFeHvpX/zL8jHg+lKzbUvU/sEfgh+
RW1//Fm+aE4yr5bI5NIyPkN59LKOfnLP5MQE8Kx9VOUfoc/5XjQB2yjXF3ua
P1/0/9HUemNVo+NMF+oa80umKVbZQIv4A3LX8FN9572+50q8LrXEpmB7sBV8
LcpVO4YOq1urP61dnMbSEexFrJj21T6nqz2gdo26OnQtNhf7FtvLF1KXmJN4
Fe3H1R90L8v4S+ktvhFdFfOGf1DtQbVrZevTn7ES9E/9lagy7fIMhhpzXcxR
qmm8bjLT1O5Te5P+dnSB7pE7JLNa/3l+sc8W8byMvQRfTNfxj6k9pXYf3pm6
Yn/BnjL2DzL11faJezHeV3LD4h7oK746/rXM72iB/EXqStKL2lOwccarLldD
7ht+KC3Ut0/9RdirfD1qg+3FSmKv8HXpWmy5sX6lvop2qZhHMmWxMrQVewSb
4hrf83nU0/2diWcXk42/EO+W5mi5u/FefHvXmKB9lvLNo97Yzdgk/hwVYBvV
To81S+3AWMOMV4pvI9cpnTyreGafYfnYZzKD6CH5ylgB9l9+MM3AFvH1qKS6
B7Hp8bz42rHGYRP4++m02jtde52x58e7F/MKqy9XSnumzDbjtcEaYKWxWdh2
rClWFyuOPYCtxxpjdeKdw6Zi67A5/OX0JT+Efh1rgtwCKiP3B36j3E6Zq6hs
OrnfuO8mMlfGO4BN41+Sm8fXpO/5u2Jtp4vlfoF1TCfvQrwTm32vTVRP+z2s
tu/3HbWWu4l/m07qG5JdI5YbpySViGfLtzbmGtdboGYhzTfW77FP9Vfnz6id
g92HHcWq5ibztRZWqD6PL0FjYo7E/oC1dc236ATWIdZx2eOucSGdbIQdsRlY
y1h/Ys3CumDdsBpqavA1aTB/C95AuyGt1DcRG+Re/hrrlfF2YaX5vnIjZUbl
Jntap3hOxZM1uBqWH/tn/I60Ovvex/vfmS+UqyJXIHM59cTej+/i/nrHe0p7
XWMPFWLN1LV37b/Hvi27hq8W646+9tgvsdExl6mSeb9TfR62ViY/1ia5E3J3
uO4LrvuU3O3UW+Zz2Q76B8X3p2UxT+XGyc2QaRxnB6yY7N+MVYYK5F/GNhZL
7iHupZXcPdm1bkPsMbGu0fLY44033ngPyzSlN7GdMbfUXilzPXaDuoVyP8gd
5LvH+i5zBX5OZgwti+tm5+l32Tkfc/+Yuo9ohPtvHzy2bP4bWox9HWtirKvq
TmEVPaNvsXtpN7+LGskdi71DXyu5I9gnarZirel1/jWqI3eYPx99/Baqix3B
LmAN+LXuu2U6eX7xHNsZ7yR+qbFPYMNjjeJ/pKXxDrjn3e75an5brE+xHsS7
qXZD9j0/KdOX+tGnMl/ITlN7VK6J3BPZ97wcP1fmUVolszLWcrn1+GG52Xz3
mPvYLdk5d8hnD6yHz+65yXuy3+dI19kc7yU1w1bHuqF+rHF66W9hzFVY7eLJ
+9gTa441irUPvyad/Obx2x/X18s1+sc5IfY34z3DX0yvZ+dKzJnrY07F3qpu
Dv+G3IF4z/DX+BrUHCvgZ9MJ/laaHPOQn0n/43vTRCyfnxXPi+9Dk7B6fC3X
+JEfG3M0nj02MM6orvVYvPvY5Exylojzw2WZ5OzQSHt+HCLd30h+ieb9MUfV
nKWKmWS/PqldTntvfCcaKDchk+zpsY9XyiRnr4mZ5CwW56/KmeTM3FB7Hl3Q
HhF7vO5x2fPpfr4dtaU6MnPpjPYdNDve89hb5fbEuYAGYLVlHqXT/O00C/tS
rrzcPv6GWJuxWjJ/pFP8bTQT+0KujNw7sb9Tf2xM9nfbkj33xPmnhbo/xf8W
8Xvzz8tNyiT/C8T5v0omOY89lD3rfZKdyzGnj+mvin2g3SPOG2rHmkODsedc
f7wx+5hDS7EB2MPYDHpWbk/2PFQ1ncz5mPtbsvt0iXSyH8e+fF/2vPZ2TnK2
jzP+puzeXSSd7Hex7x2NMwK2PeYZdXKND7FLsDf4ltQFezK7tv8ju7fFHveB
XGlsRzyPWOvlfgIpAJUG
          "]], 
         Polygon3DBox[{{1532, 1650, 983, 1103, 2113, 
          1531}}]}]}, {}, {}, {}}, {
      Line3DBox[{749, 1, 739, 227, 1466, 16, 364, 1474, 31, 372, 1482, 46, 
       1841, 380, 61, 1849, 388, 76, 1857, 396, 91, 1865, 404, 1533, 106, 412,
        1554, 121, 420, 1562, 136, 428, 1570, 151, 436, 166, 1901, 444, 181, 
       1909, 452, 196, 1812, 352, 751, 211, 748, 460, 918, 212, 919, 213, 920,
        214, 921, 215, 922, 216, 923, 217, 924, 925, 218, 733, 926, 219, 734, 
       927, 220, 735, 928, 221, 736, 222, 1451, 737, 223, 1452, 738, 224, 
       1153, 354, 752, 225, 746, 353, 1625, 210, 349, 1611, 195, 340, 1597, 
       180, 331, 165, 1778, 322, 150, 1775, 313, 135, 1767, 304, 120, 1761, 
       295, 1552, 105, 286, 1530, 90, 277, 1516, 75, 268, 1502, 60, 1720, 259,
        45, 1705, 250, 30, 1697, 241, 750, 15, 747, 362, 785, 14, 745, 784, 
       13, 744, 783, 12, 743, 11, 1455, 742, 10, 1454, 741, 9, 1453, 740, 8, 
       777, 776, 7, 774, 6, 772, 5, 770, 4, 768, 3, 766, 2, 1154, 355, 
       749}], {}, {}, {
       Line3DBox[{766, 930, 2145, 767, 939, 787, 2207, 948, 798, 2209, 957, 
        809, 2212, 966, 820, 2217, 975, 831, 2225, 984, 2171, 842, 993, 2179, 
        853, 2233, 1002, 864, 2235, 1011, 875, 2237, 1020, 886, 2240, 1029, 
        897, 2245, 1038, 908, 2251, 1047, 919}], 
       Line3DBox[{768, 931, 2146, 769, 940, 2153, 788, 949, 799, 2210, 958, 
        810, 2213, 967, 821, 2218, 976, 832, 2226, 985, 2172, 843, 994, 2180, 
        854, 1003, 2187, 865, 1012, 876, 2238, 1021, 887, 2241, 1030, 898, 
        2246, 1039, 909, 2252, 1048, 920}], 
       Line3DBox[{770, 932, 2147, 771, 941, 2154, 789, 950, 2160, 800, 959, 
        811, 2214, 968, 822, 2219, 977, 833, 2227, 986, 2173, 844, 995, 2181, 
        855, 1004, 2188, 866, 1013, 2193, 877, 1022, 888, 2242, 1031, 899, 
        2247, 1040, 910, 2253, 1049, 921}], 
       Line3DBox[{772, 933, 2148, 773, 942, 2155, 790, 951, 2161, 801, 960, 
        2164, 812, 969, 823, 2220, 978, 834, 2228, 987, 2174, 845, 996, 2182, 
        856, 1005, 2189, 867, 1014, 2194, 878, 1023, 2197, 889, 1032, 900, 
        2248, 1041, 911, 2254, 1050, 922}], 
       Line3DBox[{774, 934, 2149, 775, 943, 2156, 791, 952, 2162, 802, 961, 
        2165, 813, 970, 2167, 824, 979, 835, 2229, 988, 2175, 846, 997, 2183, 
        857, 1006, 2190, 868, 1015, 2195, 879, 1024, 2198, 890, 1033, 2200, 
        901, 1042, 2202, 912, 2255, 1051, 923}], 
       Line3DBox[{776, 935, 2150, 778, 944, 2157, 792, 953, 2163, 803, 962, 
        2166, 814, 971, 2168, 825, 980, 2169, 836, 989, 2176, 847, 998, 2184, 
        858, 1007, 2191, 869, 1016, 2196, 880, 1025, 2199, 891, 1034, 2201, 
        902, 1043, 2203, 913, 1052, 2204, 924}], 
       Line3DBox[{743, 234, 1816, 359, 235, 1823, 368, 247, 1833, 376, 1834, 
        256, 384, 1845, 265, 392, 1853, 274, 400, 1861, 283, 1869, 408, 292, 
        1876, 416, 301, 1883, 424, 310, 1890, 432, 319, 440, 1897, 328, 448, 
        1905, 337, 456, 1913, 346, 736}], 
       Line3DBox[{783, 1060, 1197, 1061, 2151, 1155, 1062, 1203, 1063, 2158, 
        1158, 1071, 1209, 2297, 1072, 1161, 1078, 2262, 1215, 1079, 1164, 
        1085, 1221, 1086, 1167, 2283, 1092, 1227, 1093, 1170, 2285, 1099, 
        1233, 1100, 2177, 1173, 1106, 1239, 1107, 2185, 1176, 1113, 1245, 
        1114, 2192, 1179, 1120, 1251, 1121, 1182, 1127, 1257, 1128, 1185, 
        1134, 1263, 1135, 1188, 2293, 1141, 1269, 1142, 1191, 2294, 1148, 
        1275, 1149, 1451}], 
       Line3DBox[{784, 1064, 1198, 1065, 2152, 1156, 1066, 1204, 1067, 2159, 
        1159, 1073, 1210, 2298, 1074, 1162, 1080, 2263, 1216, 1081, 1165, 
        1087, 2266, 1222, 1088, 1168, 2284, 1094, 1228, 1095, 1171, 2286, 
        1101, 1234, 1102, 2178, 1174, 1108, 1240, 1109, 2186, 1177, 1115, 
        1246, 1116, 1180, 1122, 1252, 2301, 1123, 1183, 1129, 1258, 1130, 
        1186, 1136, 2276, 1264, 1137, 1189, 1143, 1270, 1144, 1192, 2295, 
        1150, 1276, 1151, 1452}], 
       Line3DBox[{785, 1347, 1348, 1199, 1350, 1349, 2313, 1157, 1351, 1352, 
        1205, 1354, 2296, 1353, 1160, 1359, 1360, 1211, 2314, 1362, 1361, 
        1163, 1367, 1368, 2264, 1217, 1370, 1369, 1166, 1375, 1376, 2267, 
        1223, 1378, 1377, 1169, 1383, 2320, 1384, 1229, 1386, 1385, 1172, 
        2287, 1391, 1392, 1235, 1394, 1393, 2323, 1175, 1399, 1400, 1241, 
        1402, 1401, 2324, 1178, 1407, 1408, 1247, 1410, 2300, 1409, 1181, 
        1415, 1416, 1253, 2325, 1418, 1417, 1184, 1423, 1424, 1259, 1426, 
        1425, 1187, 1431, 1432, 2277, 1265, 1434, 1433, 1190, 1439, 2328, 
        1440, 1271, 1442, 1441, 1193, 1447, 1448, 1277, 1450, 1449, 1153}], 
       Line3DBox[{918, 1046, 2280, 1152, 907, 1037, 2279, 1145, 896, 1028, 
        2278, 1138, 885, 1019, 2275, 1131, 874, 1010, 2274, 1124, 863, 1001, 
        2271, 1117, 852, 992, 2270, 1110, 841, 2170, 983, 1103, 2224, 830, 
        974, 2269, 1096, 819, 965, 2268, 1089, 808, 956, 2265, 1082, 797, 947,
         2261, 1075, 786, 938, 2258, 1068, 765, 929, 1055, 1154}], 
       Line3DBox[{925, 1053, 2256, 914, 1044, 2249, 903, 1035, 2243, 892, 
        1026, 2239, 881, 1017, 2236, 870, 1008, 2234, 859, 999, 2232, 848, 
        990, 2230, 837, 981, 2221, 826, 972, 2215, 815, 963, 2211, 804, 954, 
        2208, 793, 945, 2206, 779, 936, 2205, 777}], 
       Line3DBox[{926, 1054, 1456, 1272, 1444, 1443, 915, 1045, 1338, 1266, 
        1436, 2302, 1435, 904, 1036, 1333, 1260, 2326, 1428, 1427, 893, 1027, 
        1328, 1254, 1420, 1419, 882, 1018, 1323, 2272, 1248, 1412, 1411, 871, 
        1009, 2309, 1318, 1242, 1404, 1403, 860, 2291, 1000, 1313, 1236, 1396,
         1395, 849, 2288, 991, 1308, 1230, 1388, 1387, 2321, 838, 982, 1303, 
        1224, 1380, 2299, 1379, 827, 973, 1298, 1218, 2318, 1372, 1371, 816, 
        964, 1293, 1212, 2315, 1364, 1363, 805, 955, 1288, 2259, 1206, 1356, 
        1355, 794, 946, 2304, 1283, 1200, 1344, 1343, 780, 2281, 937, 1278, 
        1194, 1462, 1461, 1453}], 
       Line3DBox[{927, 1458, 1457, 1273, 1146, 1445, 2329, 916, 1340, 1339, 
        1267, 1139, 1437, 905, 1335, 1334, 1261, 2327, 1132, 1429, 894, 1330, 
        1329, 1255, 1125, 1421, 883, 1325, 1324, 2273, 1249, 1118, 1413, 872, 
        1320, 2310, 1319, 1243, 1111, 1405, 861, 2292, 1315, 1314, 1237, 1104,
         1397, 850, 2289, 1310, 1309, 1231, 1097, 1389, 2322, 839, 1305, 1304,
         1225, 1090, 2222, 1381, 828, 1300, 1299, 1219, 2319, 1083, 1373, 817,
         1295, 1294, 1213, 2316, 1076, 1365, 806, 1290, 1289, 2260, 1207, 
        1069, 1357, 795, 1285, 2305, 1284, 1201, 1057, 1345, 781, 2282, 1280, 
        1279, 1195, 1056, 1463, 1454}], 
       Line3DBox[{928, 1460, 1459, 1274, 1147, 2257, 1446, 917, 1342, 1341, 
        1268, 1140, 2250, 1438, 906, 1337, 1336, 1262, 1133, 2244, 1430, 895, 
        1332, 1331, 1256, 1126, 1422, 884, 1327, 2312, 1326, 1250, 1119, 1414,
         873, 1322, 2311, 1321, 1244, 1112, 1406, 862, 1317, 2308, 1316, 1238,
         1105, 1398, 851, 2290, 1312, 1311, 1232, 1098, 2231, 1390, 840, 1307,
         1306, 1226, 1091, 2223, 1382, 829, 1302, 1301, 1220, 1084, 2216, 
        1374, 818, 1297, 1296, 1214, 2317, 1077, 1366, 807, 1292, 2307, 1291, 
        1208, 1070, 1358, 796, 1287, 2306, 1286, 1202, 1059, 1346, 782, 1282, 
        2303, 1281, 1196, 1058, 1464, 1455}]}, {
       Line3DBox[{1466, 1688, 929, 1465, 2145, 1626, 1467, 2146, 1627, 1468, 
        2147, 1628, 1469, 2148, 1629, 1470, 2149, 1630, 1471, 2150, 2053, 
        2205, 1472, 1689, 1813, 1959, 2281, 1631, 1917, 1691, 1814, 2122, 
        2282, 1632, 1918, 1693, 1815, 2303, 1960, 1633, 1919, 1695, 1816, 
        1961, 1634, 1920, 2102, 2151, 1817, 1962, 1635, 1921, 2104, 2152, 
        1818, 1963, 1636, 1922, 2130, 2313, 2005, 1819, 1637, 1697}], 
       Line3DBox[{1474, 1698, 2054, 2258, 1473, 939, 1475, 2153, 1638, 1476, 
        2154, 1639, 1477, 2155, 1640, 1478, 2156, 1641, 1479, 2157, 2055, 
        2206, 1480, 1690, 1820, 551, 2304, 1923, 1692, 1821, 2305, 552, 1924, 
        1694, 1822, 2306, 553, 1925, 1696, 1823, 554, 1926, 2103, 2158, 1824, 
        555, 1927, 2105, 2159, 1825, 556, 1928, 2296, 632, 1826, 1642, 1705}],
        Line3DBox[{1482, 1707, 2056, 2261, 1481, 2057, 2207, 1483, 949, 1484, 
        2160, 1643, 1485, 2161, 1644, 1486, 2162, 1645, 1487, 2163, 2058, 
        2208, 1488, 1699, 1827, 1964, 2259, 2123, 1929, 1700, 1829, 2124, 
        2260, 1965, 1930, 1701, 1831, 2307, 1966, 1967, 1931, 1702, 1833, 
        1968, 1969, 1932, 2297, 1703, 1835, 1970, 1971, 1933, 2298, 1704, 
        1837, 1972, 1973, 1934, 2131, 2314, 1706, 1839, 1646, 1720}], 
       Line3DBox[{1502, 1722, 1840, 1721, 2264, 2133, 1501, 2010, 1719, 1838, 
        1718, 2263, 1500, 2009, 1717, 1836, 1716, 2262, 1499, 2008, 1715, 
        1834, 1714, 1498, 2007, 2317, 1713, 1832, 1712, 1497, 2006, 2316, 
        1711, 1830, 1710, 1496, 2132, 2315, 1709, 1828, 1708, 1495, 2211, 
        2061, 2166, 1494, 1648, 2165, 1493, 1647, 2164, 1492, 959, 1491, 2210,
         2060, 1490, 2209, 2059, 1489, 2265, 1724, 1723, 1841}], 
       Line3DBox[{1516, 1736, 1848, 1735, 2267, 2135, 1515, 2015, 1734, 1847, 
        1733, 2266, 1514, 2014, 1732, 1846, 1085, 1513, 2013, 1731, 1845, 
        1730, 1512, 2012, 2106, 2216, 1844, 1729, 1511, 2011, 2319, 1728, 
        1843, 1727, 1510, 2134, 2318, 1726, 1842, 1725, 1509, 2215, 2065, 
        2168, 1508, 1649, 2167, 1507, 969, 1506, 2214, 2064, 1505, 2213, 2063,
         1504, 2212, 2062, 1503, 2268, 1738, 1737, 1849}], 
       Line3DBox[{1530, 1743, 1856, 663, 2320, 1529, 662, 1855, 2284, 2108, 
        1528, 661, 1854, 2283, 2107, 1527, 660, 1853, 1742, 1526, 659, 2223, 
        1852, 1741, 1525, 658, 2222, 1851, 1740, 1524, 2299, 657, 1850, 1739, 
        1523, 2221, 2070, 2169, 1522, 979, 1521, 2220, 2069, 1520, 2219, 2068,
         1519, 2218, 2067, 1518, 2217, 2066, 1517, 2269, 1745, 1744, 1857}], 
       Line3DBox[{1533, 1756, 2170, 1650, 1532, 2171, 1651, 1535, 2172, 1652, 
        1537, 2173, 1653, 1539, 2174, 1654, 1541, 2175, 1655, 1543, 2176, 990,
         1545, 1747, 1866, 1974, 2288, 1656, 1935, 1749, 1867, 2125, 2289, 
        1657, 1936, 1751, 1868, 2126, 2290, 1658, 1937, 1753, 1869, 1975, 
        1659, 1938, 2110, 2177, 1870, 1976, 1660, 1939, 2112, 2178, 1871, 
        1977, 1661, 1940, 2139, 2323, 2027, 1872, 1662, 1761}], 
       Line3DBox[{1552, 1754, 1864, 2026, 2287, 2138, 1551, 2024, 2025, 1863, 
        2286, 2111, 1550, 2022, 2023, 1862, 2285, 2109, 1549, 2020, 2021, 
        1861, 1752, 1548, 2018, 2019, 2231, 1860, 1750, 1547, 2017, 2322, 
        2137, 1859, 1748, 1546, 2136, 2321, 2016, 1858, 1746, 1544, 2230, 989,
         1542, 2229, 2075, 1540, 2228, 2074, 1538, 2227, 2073, 1536, 2226, 
        2072, 1534, 2225, 2071, 1531, 2113, 2224, 1755, 1865}], 
       Line3DBox[{1554, 1762, 2076, 2270, 1553, 2179, 1663, 1555, 2180, 1664, 
        1556, 2181, 1665, 1557, 2182, 1666, 1558, 2183, 1667, 1559, 2184, 
        2077, 2232, 1560, 1757, 1873, 1978, 2291, 1668, 1941, 1758, 1874, 
        2127, 2292, 1669, 1942, 1759, 1875, 2308, 1979, 1670, 1943, 1760, 
        1876, 1980, 1671, 1944, 2114, 2185, 1877, 1981, 1672, 1945, 2115, 
        2186, 1878, 1982, 1673, 1946, 2140, 2324, 2028, 1879, 1674, 1767}], 
       Line3DBox[{1562, 1769, 2078, 2271, 1561, 2079, 2233, 1563, 2187, 1675, 
        1564, 2188, 1676, 1565, 2189, 1677, 1566, 2190, 1678, 1567, 2191, 
        2080, 2234, 1568, 1763, 1880, 1983, 1984, 2309, 1947, 1764, 1881, 
        2310, 1985, 1986, 1948, 1765, 1882, 2311, 1987, 1988, 1949, 1766, 
        1883, 1989, 1990, 1950, 2116, 2192, 1884, 1991, 1992, 1951, 1116, 
        1885, 1993, 1994, 1952, 2300, 2029, 1768, 1886, 1679, 1775}], 
       Line3DBox[{1570, 1777, 2081, 2274, 1569, 2082, 2235, 1571, 1012, 1572, 
        2193, 1680, 1573, 2194, 1681, 1574, 2195, 1682, 1575, 2196, 2083, 
        2236, 1576, 1770, 1887, 1995, 2272, 2128, 1953, 1771, 1888, 2129, 
        2273, 1996, 1954, 1772, 1889, 2312, 1997, 1998, 1955, 1773, 1890, 
        1999, 2000, 1956, 1121, 1891, 2001, 2002, 1957, 2301, 1774, 1892, 
        2003, 2004, 1958, 2141, 2325, 1776, 1893, 1683, 1778}], 
       Line3DBox[{436, 324, 2275, 1577, 2084, 2237, 1578, 2085, 2238, 1579, 
        1022, 1580, 2197, 1684, 1581, 2198, 1685, 1582, 2199, 2086, 2239, 
        1583, 316, 1254, 521, 317, 1255, 522, 318, 1256, 523, 319, 524, 1257, 
        320, 525, 1258, 321, 526, 1259, 323, 331}], 
       Line3DBox[{1597, 1790, 1900, 1789, 2277, 2143, 1596, 2034, 1788, 1899, 
        1787, 2276, 1595, 2033, 1786, 1898, 1134, 1594, 2032, 1785, 1897, 
        1784, 1593, 2031, 2117, 2244, 1896, 1783, 1592, 2030, 2327, 1782, 
        1895, 1781, 1591, 2142, 2326, 1780, 1894, 1779, 1590, 2243, 2090, 
        2201, 1589, 1686, 2200, 1588, 1032, 1587, 2242, 2089, 1586, 2241, 
        2088, 1585, 2240, 2087, 1584, 2278, 1792, 1791, 1901}], 
       Line3DBox[{1611, 1802, 1908, 1801, 2041, 2328, 1610, 2040, 1800, 1907, 
        1143, 1609, 2039, 1799, 1906, 2293, 2119, 1608, 2038, 1798, 1905, 
        1797, 1607, 2037, 2118, 2250, 1904, 1796, 1606, 2036, 1139, 1903, 
        1795, 1605, 2302, 2035, 1794, 1902, 1793, 1604, 2249, 2095, 2203, 
        1603, 1687, 2202, 1602, 2248, 2094, 1601, 2247, 2093, 1600, 2246, 
        2092, 1599, 2245, 2091, 1598, 2279, 1804, 1803, 1909}], 
       Line3DBox[{1625, 1809, 1916, 2052, 1447, 1624, 2050, 2051, 1915, 2295, 
        2121, 1623, 2048, 2049, 1914, 2294, 2120, 1622, 2046, 2047, 1913, 
        1808, 1621, 2044, 2045, 2257, 1912, 1807, 1620, 2043, 2329, 2144, 
        1911, 1806, 1619, 1443, 2042, 1910, 1805, 1618, 2256, 2101, 2204, 
        1617, 2255, 2100, 1616, 2254, 2099, 1615, 2253, 2098, 1614, 2252, 
        2097, 1613, 2251, 2096, 1612, 2280, 1811, 1810, 1812}]}}},
    VertexNormals->CompressedData["
1:eJx0vHk0ll37Pk40UZEojSLRoCiKqHuLigYVSUokUxIpCg0yZKhEhEilVCok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     "]]},
  Boxed->False,
  ViewAngle->NCache[20 Degree, 0.3490658503988659]]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{632, 680},
WindowMargins->{{Automatic, 21}, {Automatic, 68}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 194, 7, 90, "Title"],
Cell[CellGroupData[{
Cell[809, 34, 204, 2, 55, "Section"],
Cell[1016, 38, 1177, 37, 138, "SmallText",
 Evaluatable->False],
Cell[2196, 77, 296, 8, 78, "Input"],
Cell[2495, 87, 805, 21, 93, "SmallText"],
Cell[3303, 110, 803, 23, 65, "Input"],
Cell[CellGroupData[{
Cell[4131, 137, 397, 6, 44, "Input"],
Cell[4531, 145, 13715, 223, 276, "Output"]
}, Open  ]],
Cell[18261, 371, 223, 6, 42, "SmallText"],
Cell[18487, 379, 778, 15, 49, "Input"],
Cell[19268, 396, 1212, 28, 98, "SmallText"],
Cell[CellGroupData[{
Cell[20505, 428, 504, 14, 60, "Input"],
Cell[21012, 444, 230, 8, 58, "Output"]
}, Open  ]],
Cell[21257, 455, 637, 17, 76, "SmallText"],
Cell[CellGroupData[{
Cell[21919, 476, 199, 6, 44, "Input"],
Cell[22121, 484, 1321, 42, 110, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23479, 531, 309, 9, 44, "Input"],
Cell[23791, 542, 287, 10, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24115, 557, 233, 6, 44, "Input"],
Cell[24351, 565, 481, 18, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24869, 588, 137, 3, 44, "Input"],
Cell[25009, 593, 238, 7, 44, "Output"]
}, Open  ]],
Cell[25262, 603, 212, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[25499, 611, 409, 11, 44, "Input"],
Cell[25911, 624, 107, 2, 44, "Output"]
}, Open  ]],
Cell[26033, 629, 206, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[26264, 637, 325, 10, 44, "Input"],
Cell[26592, 649, 481, 18, 58, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27122, 673, 153, 2, 55, "Section"],
Cell[27278, 677, 746, 19, 110, "SmallText",
 Evaluatable->False],
Cell[28027, 698, 126, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[28178, 703, 486, 13, 65, "Input"],
Cell[28667, 718, 9057, 155, 217, "Output"]
}, Open  ]],
Cell[37739, 876, 456, 12, 76, "SmallText",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[38220, 892, 460, 14, 44, "Input"],
Cell[38683, 908, 270, 6, 65, "Message"],
Cell[38956, 916, 170, 5, 56, "Output"]
}, Open  ]],
Cell[39141, 924, 466, 12, 59, "SmallText"],
Cell[CellGroupData[{
Cell[39632, 940, 534, 15, 44, "Input"],
Cell[40169, 957, 111, 3, 44, "Output"]
}, Open  ]],
Cell[40295, 963, 257, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[40577, 973, 113, 3, 44, "Input"],
Cell[40693, 978, 226, 7, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40956, 990, 244, 8, 46, "Input"],
Cell[41203, 1000, 279, 9, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41519, 1014, 143, 3, 44, "Input"],
Cell[41665, 1019, 203, 7, 46, "Output"]
}, Open  ]],
Cell[41883, 1029, 239, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[42147, 1037, 392, 11, 44, "Input"],
Cell[42542, 1050, 172, 6, 46, "Output"]
}, Open  ]],
Cell[42729, 1059, 327, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[43081, 1069, 375, 10, 44, "Input"],
Cell[43459, 1081, 270, 6, 65, "Message"],
Cell[43732, 1089, 172, 6, 46, "Output"]
}, Open  ]],
Cell[43919, 1098, 469, 10, 59, "SmallText"],
Cell[CellGroupData[{
Cell[44413, 1112, 654, 16, 44, "Input"],
Cell[45070, 1130, 1629, 52, 135, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46736, 1187, 468, 11, 44, "Input"],
Cell[47207, 1200, 798, 26, 92, "Output"]
}, Open  ]],
Cell[48020, 1229, 463, 11, 76, "SmallText"],
Cell[CellGroupData[{
Cell[48508, 1244, 646, 16, 44, "Input"],
Cell[49157, 1262, 340, 12, 58, "Output"]
}, Open  ]],
Cell[49512, 1277, 112, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[49649, 1284, 196, 5, 44, "Input"],
Cell[49848, 1291, 286, 10, 58, "Output"]
}, Open  ]],
Cell[50149, 1304, 350, 10, 44, "Input"],
Cell[CellGroupData[{
Cell[50524, 1318, 252, 8, 44, "Input"],
Cell[50779, 1328, 9583, 163, 258, "Output"]
}, Open  ]],
Cell[60377, 1494, 359, 9, 59, "SmallText",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[60761, 1507, 209, 7, 44, "Input"],
Cell[60973, 1516, 300, 11, 47, "Output"]
}, Open  ]],
Cell[61288, 1530, 214, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[61527, 1538, 251, 9, 61, "Input"],
Cell[61781, 1549, 48, 1, 58, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61878, 1556, 192, 3, 55, "Section"],
Cell[62073, 1561, 975, 28, 94, "SmallText",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[63073, 1593, 520, 17, 86, "Input"],
Cell[63596, 1612, 1011, 34, 68, "Output"]
}, Open  ]],
Cell[64622, 1649, 276, 9, 44, "SmallText"],
Cell[CellGroupData[{
Cell[64923, 1662, 59, 1, 44, "Input"],
Cell[64985, 1665, 780, 26, 46, "Output"]
}, Open  ]],
Cell[65780, 1694, 142, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[65947, 1703, 61, 1, 44, "Input"],
Cell[66011, 1706, 1016, 33, 68, "Output"]
}, Open  ]],
Cell[67042, 1742, 199, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[67266, 1752, 182, 5, 44, "Input"],
Cell[67451, 1759, 325, 10, 46, "Output"]
}, Open  ]],
Cell[67791, 1772, 209, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[68025, 1782, 149, 4, 44, "Input"],
Cell[68177, 1788, 228, 7, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68442, 1800, 182, 6, 44, "Input"],
Cell[68627, 1808, 1359, 46, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70023, 1859, 107, 3, 46, "Input"],
Cell[70133, 1864, 349, 10, 44, "Output"]
}, Open  ]],
Cell[70497, 1877, 170, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[70692, 1886, 82, 2, 44, "Input"],
Cell[70777, 1890, 598, 17, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71412, 1912, 196, 6, 44, "Input"],
Cell[71611, 1920, 406, 13, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72054, 1938, 349, 10, 44, "Input"],
Cell[72406, 1950, 467, 12, 267, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72922, 1968, 242, 3, 55, "Section"],
Cell[73167, 1973, 1049, 29, 163, "SmallText",
 Evaluatable->False],
Cell[74219, 2004, 67, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[74311, 2008, 496, 12, 66, "Input"],
Cell[74810, 2022, 183, 6, 46, "Output"]
}, Open  ]],
Cell[75008, 2031, 267, 5, 59, "SmallText"],
Cell[CellGroupData[{
Cell[75300, 2040, 930, 20, 65, "Input"],
Cell[76233, 2062, 4621, 81, 274, "Output"]
}, Open  ]],
Cell[80869, 2146, 384, 14, 42, "SmallText"],
Cell[CellGroupData[{
Cell[81278, 2164, 113, 3, 44, "Input"],
Cell[81394, 2169, 461, 17, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81892, 2191, 249, 8, 44, "Input"],
Cell[82144, 2201, 142, 5, 58, "Output"]
}, Open  ]],
Cell[82301, 2209, 668, 20, 76, "SmallText"],
Cell[CellGroupData[{
Cell[82994, 2233, 1268, 41, 65, "Input"],
Cell[84265, 2276, 4988, 88, 274, "Output"]
}, Open  ]],
Cell[89268, 2367, 119, 1, 42, "SmallText"],
Cell[89390, 2370, 520, 14, 65, "Input"],
Cell[89913, 2386, 88, 2, 42, "SmallText"],
Cell[CellGroupData[{
Cell[90026, 2392, 182, 5, 44, "Input"],
Cell[90211, 2399, 123, 4, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90371, 2408, 275, 8, 44, "Input"],
Cell[90649, 2418, 289, 11, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90975, 2434, 200, 5, 44, "Input"],
Cell[91178, 2441, 29, 0, 44, "Output"]
}, Open  ]],
Cell[91222, 2444, 186, 5, 76, "SmallText",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[91433, 2453, 199, 6, 44, "Input"],
Cell[91635, 2461, 137, 5, 69, "Output"]
}, Open  ]],
Cell[91787, 2469, 33, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[91845, 2473, 143, 4, 44, "Input"],
Cell[91991, 2479, 204, 7, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92232, 2491, 318, 10, 79, "Input"],
Cell[92553, 2503, 55, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92645, 2509, 452, 12, 46, "Input"],
Cell[93100, 2523, 77, 2, 47, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93226, 2531, 288, 4, 55, "Section"],
Cell[93517, 2537, 1402, 44, 146, "SmallText",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[94944, 2585, 471, 13, 66, "Input"],
Cell[95418, 2600, 431, 16, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95886, 2621, 177, 5, 44, "Input"],
Cell[96066, 2628, 132, 5, 52, "Output"]
}, Open  ]],
Cell[96213, 2636, 142, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[96380, 2645, 102, 3, 44, "Input"],
Cell[96485, 2650, 73, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96595, 2657, 151, 5, 46, "Input"],
Cell[96749, 2664, 98, 3, 46, "Output"]
}, Open  ]],
Cell[96862, 2670, 622, 22, 59, "SmallText"],
Cell[CellGroupData[{
Cell[97509, 2696, 449, 14, 44, "Input"],
Cell[97961, 2712, 253, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98251, 2726, 160, 5, 44, "Input"],
Cell[98414, 2733, 183, 6, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98634, 2744, 206, 6, 44, "Input"],
Cell[98843, 2752, 96, 3, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98976, 2760, 421, 12, 44, "Input"],
Cell[99400, 2774, 24990, 418, 298, 14037, 237, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[124405, 3195, 733, 20, 112, "SmallText"],
Cell[CellGroupData[{
Cell[125163, 3219, 201, 5, 44, "Input"],
Cell[125367, 3226, 428, 15, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125832, 3246, 276, 8, 44, "Input"],
Cell[126111, 3256, 122, 4, 52, "Output"]
}, Open  ]],
Cell[126248, 3263, 268, 5, 59, "SmallText"],
Cell[CellGroupData[{
Cell[126541, 3272, 286, 9, 80, "Input"],
Cell[126830, 3283, 77, 2, 58, "Output"]
}, Open  ]],
Cell[126922, 3288, 176, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[127123, 3296, 267, 7, 44, "Input"],
Cell[127393, 3305, 393, 15, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127823, 3325, 252, 7, 44, "Input"],
Cell[128078, 3334, 106, 4, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128221, 3343, 286, 9, 81, "Input"],
Cell[128510, 3354, 55, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128602, 3360, 80, 2, 44, "Input"],
Cell[128685, 3364, 77, 2, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128799, 3371, 2085, 49, 105, "Input"],
Cell[130887, 3422, 314831, 5111, 388, 230841, 3733, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
