(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1007140,      21171]
NotebookOptionsPosition[    974878,      20106]
NotebookOutlinePosition[    975304,      20125]
CellTagsIndexPosition[    975261,      20122]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["... Doing Mathematics by Computer", "Title"],

Cell[CellGroupData[{

Cell["Grenzwerte und Reihen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Grenzwertberechnung", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"4", "x"}], 
      RowBox[{
       RowBox[{"2", "x"}], "+", "3"}]], ")"}], "3"], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData["8"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["1", "x"]}], ")"}], "x"], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData["\[ExponentialE]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Tan", "[", "x", "]"}], "-", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{"x", "-", 
     RowBox[{"Sin", "[", "x", "]"}]}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 PageWidth->Infinity],

Cell[BoxData["3"], "Output"]
}, Open  ]],

Cell["Links- und rechtsseitiger Grenzwert", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "2"]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData["\[Infinity]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdi3k41OsCgH8zg6GyhGlQkmWyVspVx/p9JY02EUeKFCJEci5S0jLppBG5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     "]], LineBox[CompressedData["
1:eJwtV2k0lQ3bPY4hY+ZZMjyVlAhRqa67KIpSNFA8ISVJSYYihQpRFE9kKFPG
JqKk5LrfSkrlKRRKCAeHDme8j6H4+t717rX22n/2j/1n77W2vs9xl4N0Go02
8Yf/r01R9da3LwmR9l/8RX6kn3LPOCNEveFK1pL9huSM1pyH50KEuPjdcLa8
iCG5xCJd+vBRIXangnlAsQEZd6D62UoPIUaW5Cq+n9InqyNtVfR3CrFXqbI8
okyf7EtrOSrlJETtoqWreHv1ybWv2PO+2ghxSbB1RlWDHsn/yyQ6UluI6pnT
DvLH5pMGa+s6DigLUYl4o6TE0SW373Jc7iQjxPdb/7OwI1yXvHPRv09nmsKh
DF8PsavzSJ/BIrv6rxRGnyxdXTeoTV6dsbxZ3ELhRkKt8vZ5bfK52itBchOF
dJlc3xWG2qSGfV/x/qcUVszRsxzw1yL/LdGVEsmiUEHkuVurkibpxSJFQlIp
rDSvlCto1CC55gemBhMpLCkXhhqe1SBV6ktG30dSOBm9wlGMrU66tZk13/Ck
sFRl+fwmhhrJ1Gx9LbObwjbxiOhHxWpkxP5QPLuNwiRnZvLYYTXy5khthS9Q
WGb17oUeR5Xso9mmmelT6Lnoe3iUvCp5chMjqVCTQvtc9mRTpwopdjn+gpoS
hR/39C7WLVIhF6m/D/1Fp3CB8SFGzToV8qjJLrc3AwJUdZ5YMnFGmaTc/eZ5
lQpQXa5kWYCeEhmfK6XWmifAkBL+rOaEIqnBuDN3U6YAbabvewR/VCRtgtiz
SxIFGGfTJip/XpGMjjvdJwwQ4O1k04TEcQVSuiqpJMVUgC774xeLNMiT2RMm
eXQjAQZJpegvjJMnl677eCNUT4Cda2C5hYM86fxWJXGfogDFt6734jTPJf/p
uXl0EY+Pddc6Qk4NypG6shXL8TEfdT+wjdmrZMljA0ZdKff5OHz2BsNBVJas
r8uP8yrm4552GwXfDzKkZ2DaN5F0PpbvGtny6YAMmdMcdtEulI+vfE890sqU
JjWvre18a8HH0VPNPW4GUuRh/8fns5bw0X/DNlFDSpJ8st50WYAhHy2dJg+f
bpIk3bh652WV+bi8VWIXGSJJpruKmThzeVjCs2s7/u8cUkXtXXRbBQ/3uY7F
bs+WIH3HbJcUlfKw0dP+IYZJkNWv6z6H5vFQs2C+W4aLBOkaft9Y/SoPHR63
tZySkSBTO661uR/noX+Ar1tbjDgpn+1m1GPCw9c1pFPSOTFSWm/wX2Y5F7Ne
D8UkPqKTXTmS73oLuLh78rP5nWw6eU9zyev2LC66HlstLxlLJ7crB9U1JHIx
8NDb9mBnOpkuMVWaf4SLUovjjgp+ipAGLLlYd2MuOj9w2CViLkLy/c2ithtw
cfmhdO+L2iJkw6DLKXstLprusrq4SlyEPNybcWyFNBfl7jrHmnbSyPut+vsU
RzgYM6eavv48jbR5usLybRkHPdsXZLDrZ1HW2s2UzOegq3/qnMCMWeyuijCu
yeRggENQvHXQLMbeQ72iSxzsrqz99NBgFt/kbZaL8eeg5WjoSqOkGdwZ7zm4
cjEHvTbWT9v7/8ajOy/eKC1lI9fnc0PHzmnMn3lqYZzPxmGvstE062n8Uspu
vpPJxuKq6pQorWkkfu8Tf5DIxh817/y+9k6hSrF58KOjbHzjm7r53vEpfC7s
cXxhxsYT7FtRO69Poo5V6EzNiXEU8Wtgtv8WYlxir+Uzn3Gkv0i0vMYQIrvb
MaDedRxvSpv+ffSDEF/FG3S8WjGOHXr20vE3hRjY+W/lp8kxXOsxoL8RhFh/
xvjgaMwYPmxbAwUJFHq97Hmnm8pC1RWO7r/MBGi/duLg9xgWnpMLrSnVEuCy
GgVazgkWzppP/gwWE+Cv8vWWmjtYmBr1/MX+Dj7eSC3MUVZgIYOlfyktho8f
vf0CJZN/4hVZr8LFnTxcTxufy700iuequ3P9srloFDGnrOL0KCr8eGW6M4GL
Cvz5tsf9R3GriPWCPaFc7B7aHv7TYRTrHrPP5DpzMeLfhz2Dc0bxQ0lNgaU4
Fx/eCqv4dnEER/x4CQ4hHDRYO7OjIYaJ8XXHbFlebPyouHZpZjATbzuOFQTs
YOPZwUiJwANM3OKwa2piPRu/pkw+VdnIxDw/gS5hyMa0Pr6hryQTe2Z43lPv
x1EsYVRATxnGzoPGlSt6xnCwpSOTyBnC8htCMz91FpYdrvrx7DEDH+kkHBb7
wMQ2n9z5jsUMHDhS3TJWyUSaZ5Ln1+sMTFfzvzyezsTdOw50ToQwUM+HZ2/h
zUT6auVPKywY+Ctb5RBSw7hX5iT54MEAGnrlX2tcMIzS981zC0v7UY/M+pWa
OohHeJUeSVk/0ETr+5lvuf247Ky4u4ThN/RdrhV3u78LlU+3yaRnt2Lj+S7/
V+vasN33qPGD/tfYLy2vyzdoxPAI4+S31+8jp8DbfF7ufSxPWUncNrsHilYV
abjyHiT7x3zxim0ELd5ei6nXjSDHd7K5u6MVDAYVqlNZrdAb8toy7MI32Nwt
Jk24f4ex2q0vwt/8gLyG8n0be/phgVRjSGT7D2jPKQrS5PeDhxux6NzgD4h4
blk7KTkATZT55TixPugKlVjRYz4ARRYau68TfVAa/m4uET8AHvf6mA+f9EHg
xrqIAHMGNOWFK46V9oPq6tQIetogFMfne/leYsDVbqep+FgmeFUGPribyYA3
7qaqljeZoPVt1Qy/jAG0TUyuoIYJyctasi82MSAv91bmMxYTwj7T24tlBkGJ
5Gu57h2BTYa+W5lXBqHsuKlbh/UoDNYvXH0sdQgq8oIwUpwFecPchMcFQ7Cm
9tpqK0MW7FXC9pmHQ/Bo36VtsutZ0HxwT2hK6xCA5i1N2SgWPJZNqKhQGYZz
ZxM2elEsiNvLXMhLHwbLeSozl8fGYAF1R/lUNhMInXhb10g2aDTsMLhTzoSY
eWt+iiWxQfofoVl3LRMCA6olXmexgb3cdptdBxNkRM2kwp+yoS7wa4KC6ghs
dd1/K2OKDTsZkjOlySOQOvOlfSyKA7FtB4c7Y0bBr32JHuMaF0ILZYSy10ah
IlDVqqGQC4eDK8WJvFHoSnecX/uIC9sUfhsU14+Cr2ivwvdOLmg6/eMZPD0K
i372yGkZ8qDi5YsW6dCfYLpo8EtyLQ+6H85/bnOYBe2apt0VQj58WBlsbBDO
ArQ7+W5aRgB19a8yJONYUD3ysnC/ngCym/yDPxeyYKarmRO8WQBufVWLjvew
oCbca2lzjgA+KTqkFuweA+vvi+MTHSh4FRTkJ7VxHCJsgxu+PRJCFfWibdx1
HCYu8chnH4RQcEZ1wxefcWBWuw7VMYQQk/BUpzB6HBgR3/mGahOwLk+sZU3d
OExK+Momn5qALj8n3SeabFhLsz46z24SdmX0JoxeZcM8OwtRcmIKku2r5EQy
2YDnv9KY6tPwRngxVS2fDUUbqCh762lY7bYkZ30lG+7Pj/UpCZsGXc2wBxmf
2FDetdxJbGIahrNkvtgqceDVr8eXX4v/Bn3H7r3uWhzQKD25/rrRb9g7XdFz
zIADh3xEHW87/ob3+3YzM805UCqpHhKX+hsqdfJ/jbtwQD5ye+gJwxmIuGVl
mJPGge3rxnXyXGahaptUaWU2BzzfZ7W2n56FnzPfljYWcmCvv1WzZ/4s/L0/
xopbxQHqrUKqG2cWbPXeb3Zo48A/fiZmaVtohGyBdxBfhQvbxyzir1A04lbR
5edO6Vw4d35lWuFJOhFi5FTQfpMLp1tExNKS6MTmOzLxPkVceG60Z+ZxIZ3g
VyRuP1XNhX23D4TmttEJx7qE/sIWLmxYTg+fs0qUmGi5IDU9lwedZ2Z3DsuK
Ec277MYuqvEg04fZd9ZIjCjsEG1V0OWB7PXozXvsxIht3bE5C014oHJhVdKn
M2LEbWa0qYsjD9ozkg9KcsSIHbSoXWXxPLhgZXojdEicWHh+zWrLFB6oD+xz
KZ8jQfwS/6WL6TwQ1mxWtzCSIEplIofbinhw9+CiZZuOSBAzaqcjaa94MOHZ
b5HFlSDKTULz99D4UHs5V9ZFVZKIrrCM65vDhxPSQeqRNpLELgv+kUB5Pmx7
nlGr6CNJ0FadtDyvy4ezNKfolApJYo/dicb7a/hwK0e/U9xVihDbF8gSP82H
jrtn25ofSBPajrv1LGL4oPt7FefJD2nC3AZcvS7xQf2xZaGzigzhpa1Y+zST
Dza5ad7XImWI59+qLxx/yoeHTflBLS6yRNu7mzU5L/gQ/l6u5nKiLPHzWdzI
2yY+ZN5UKFF+KUto5bht/+sbH95/rv2eaSVHhHn80u6c5sNpn0pRBaO5xBUn
xjYJMQHMfwOqNYfmErfXNMdYyApgSGXZPtfiuUSrTt7QFR0BZJ0sYMQayRNm
322rNqz908tQp2WPdRQIpmfSlrtnBeDoRzDeblYkaNtCojrjBFCz7InJ38GK
hMY6zwqJFAEERQXzSrMViU26pmreuQJYReMOhLIViYLulh+qpABM5XsDzxcq
EbXNz1Rs3wig3nDJFa8WJeJj/W37oI8CeKuxe7k+XZmYvRV2r6lXAJYRyW1+
vsqEx36t0+dEKFgf4x702VKFOOkseveuFAVvTftEbgSoEInws7tTkQLKt3Nt
ZKEK8WR+vZ2lAQUhpcZZb9RUCdVebwXmBurPTm02vCGrRiz9uMVWzZGCUpGB
/rCtaoQdaRFm60qBgjVGvEtRI4LzxLtuHqBA8u/Gg9Ka6kSzV1mJywUKLF9o
xgSBBhFreG61IIkCl5oEh+0JGsSKwZ0fMtIo8BsJu9LTokHkBNB4XQUUzCN4
AVsCNYmAsD3r/P5DQZe4BGVSq0XorjL5JPWWggFHz3pvRW2iZZrue/cjBTLJ
m4K+BGgTq2PuX+L0UODfP0HvXqRDSF4W/xw588cfgEdNcB5Rt+2bn66EEN6N
atIXL9UljitWTpFyQlhfWOlO5OgSX9I99CTmCeHp9RE357j5RKK7eVXpX0IY
/2uh32aaHrFOR3KT41IhJHkwJu1AjyjKrwq4aiOEmYa8YYOXeoSb76UZc1sh
CJ0VQ1ZI6hOyi/Zf+7xFCIc7LpyIddYnQu5K12jtFULKyz2H1zH0iQ013vSi
U0I4MmMzt83MkKBOW1+3j/6TbzIlamOSIVG2Rs5oJF4Iko01ikpMQ0IqSqX9
3iUh/O9vE/8HBtvvGw==
     "]], LineBox[CompressedData["
1:eJwd0Xs41PkeB/DfzNAwchshl5V7LluyJEV9v+GI1uYosnLJdaUb1Sa3XNJG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     "]], 
    LineBox[{{1.5719517126117426`, 10.}, {1.571961678869746, -10.}}], 
    LineBox[{{-1.571027974796521, 10.}, {-1.5710116461898662`, -10.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Grenzwert einer komplexen Funktion mit wesentlicher Singularit\[ADoubleDot]t \
aus verschiedenen komplexen Richtungen\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"directions", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], "n"], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "8"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"2", " ", "\[ImaginaryI]"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "8"}], " ", "\[ImaginaryI]"}], ",", 
   RowBox[{"8", "-", 
    RowBox[{"8", " ", "\[ImaginaryI]"}]}], ",", "16"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      FractionBox["1", "z"], "]"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}], ",", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  "directions"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     RowBox[{"Interval", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}], "]"}]}]], ",", "ComplexInfinity", 
   ",", "\[Infinity]", ",", "ComplexInfinity", ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     RowBox[{"Interval", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}], "]"}]}]], ",", "0", ",", "0"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Grenzwert einer reellen Funktion, der nicht eindeutig bestimmt ist.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["1", "x"], "]"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["1", "x"], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUm3c8198XxxUligaRkbIpaWggulJUslfIJpmJUFb2iOwte5O9+eKY2WSv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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.1, 0.1}, {-0.9999999946029886, 0.9999999177372805}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Grenzwerte f\[UDoubleDot]r Funktionen mit Parametern\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", 
       RowBox[{"-", "a"}]]}], "+", 
     SuperscriptBox["x", "a"]}], 
    RowBox[{"x", "-", 
     FractionBox["1", "x"]}]], ",", 
   RowBox[{"x", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData["a"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["a", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s F\[ADoubleDot]higkeiten zur Grenzwertberechnung werden von Version zu \
Version besser. Diese Grenzwerte konnte es zum Beispiel in Version 4 noch \
nicht symbolisch bestimmen.   "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "n"], 
    SuperscriptBox["E", "x"]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "!"}], 
    SuperscriptBox["x", "x"]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], 
    RowBox[{"Cot", "[", 
     RowBox[{"2", "x"}], "]"}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["\[ExponentialE]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], "-", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}]}]}], ",", 
   RowBox[{"s", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData["EulerGamma"], "Output"]
}, Open  ]],

Cell["Differentialquotient als Grenzwertberechnung bestimmen", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", " ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "dx"}], "]"}], "-", 
     RowBox[{"Sin", "[", "x", "]"}]}], "dx"], ",", 
   RowBox[{"dx", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output"]
}, Open  ]],

Cell["\<\
Grenzwerte mehrstelliger Funktionen sind nicht vorgesehen - sie sind auch \
mathematisch komplizierter. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", "y", "-", "1"}], "x"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"y", " ", 
        FractionBox["\[Pi]", "2"]}], "]"}], "+", "x"}], "y"]}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ivar\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\({x, y}\\) is not a valid variable.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"x", "+", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "y"}], "2"], "]"}]}], "y"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "y", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], "x"]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", " ", 
   RowBox[{"y", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"optx\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Unknown option \\!\\(y\\) in \\!\\(Limit[\\(\\(\\(\\(\\(x \
+ \\(\\(Cos[\\(\\(\\(\[Pi]\\\\ y\\)\\/2\\)\\)]\\)\\)\\)\\/y + \
\\(\\(\\(-1\\)\\) + y + \\(\\(Sin[x]\\)\\)\\)\\/x\\)\\), \\(\\(x \[Rule] 0\\)\
\\), \\(\\(y \[Rule] 1\\)\\)\\)\\)]\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"x", "+", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "y"}], "2"], "]"}]}], "y"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "y", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], "x"]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"y", "\[Rule]", "1"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", " ", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DirectedInfinity", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "y"}], "]"}], ",", 
   RowBox[{"x", "+", 
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], "x"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Der Grenzwert kann als doppelter Grenzwert (erst nach x, dann nach y) \
berechnet werden. In diesem Beispiel kommt es allerdings auf die Reihenfolge \
an.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"f", ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "]"}], ",", " ", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"f", ",", 
     RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", " ", 
   RowBox[{"y", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData["\[Infinity]"], "Output"]
}, Open  ]],

Cell["\<\
Ein Bild schafft Aufkl\[ADoubleDot]rung: Die zweistellige Funktion ist in der \
N\[ADoubleDot]he des Punktes (0,1) sehr unregelm\[ADoubleDot]\[SZ]ig.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", ".01"}], ",", ".01"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0.99", ",", "1.01"}], "}"}], ",", " ", 
   RowBox[{"Axes", "->", "None"}]}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJycnXVYVkv39+luMMDExO6OjaKiqCgSohio2N2N3YoKFip2YSsmKDcqWKik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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNnHncVVP7xs85z/OcPZ0jMpaiQaIkDZo0kUakQaYKGcqURJQQkrGMmeeh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         "]], Polygon3DBox[CompressedData["
1:eJw1nAnYVdPbxvc55z1nn7P3flFJk6F5LppUohKKNEmTlMiQoTlSUajMQ4Mp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         "]], 
        Polygon3DBox[CompressedData["
1:eJwt2HecVcUZxvGzsHfvLruKIhoURRcLYKEJFpQiCChRiQWIFAsSNHQQRVAx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         "]]}]}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1lluIVWUUx/fsvTvn7DlnTMPRHroYmRhWXlCDzEs60kVQMzMN0rJA88Fr
VqipQzWOkwSaQykz5UxhjZZ2c7KECa2HyAJBCXqoHvJBKgijTNEuv3//1cM6
39prrW99a61vrf93rlu8Ys7yNEmSb6AMmlxLkr+qSXJFniTbUQxG2IT8b2ST
0A1EvgN+O3QX+ozvhdAw+JFFkiyHvsX+FPrx2Peg2wzfDI3CZjv+voe+xOZP
1kegi3Wci93PCgCb3ayv8X0c/hhrG9/n4SfW7OdyZMvgm6D16F7nuwv6AZtZ
pSS5AA3D1ZjMPu6D34O+I3MMrxDjJGwGJ/bzQkOSnC3ZVnumEs9S+easW5CX
2PswNBz9zXzfBF0P347+0/okmZ/a9vGa7duwfQ86gHw++uHorky871LmvZvQ
H4HehD+BbAj8Qc69mFrWH/4tZMfQbYLvD98Lvxg/dawp1FPnM8TvhV9bIT9y
+wn+1jrfn+5O9yL5//vqwl7n6Dz5fwl9c8n+21PXaSbyVuQz8NsH34hsGbV6
prAfna0Y1iA7X7Xt08T5MdSdumcuq7dP9cC5wnfxOXu7Mue4lr2X1E/oTiO7
N3f8r8LfULKfM+Uk2Yl+AfIRfG+DxuEnp953QCvYc6ri/LW3ie/p0FLsFuG7
H7RTcWbuP/VeKbVe8ieR7czct3ezrwVaJT37roY6sbmKtQtaibwGrU4t/4oz
v674u5fvmaxDWJdju69q219Drn77A/4B+BtZP2Lf5JJ7IyGP56lFF3lOq7me
vxPTRGLZxjqUPVPgn4OWpO7FWsQwm3VG1b41m9OrPnML/m+vuK9Gc87I6Fvl
sjTyamC9k/O+4IyBUAv6AyFfFHXbQ0wPllxznTM7cryWWM5kjn9zarnmbivr
vNQ9ozhmhX0Pe1eT48mKZ35E3KP2KXbt7Sg8w+KPwD+L7S+c0UEfbax6j+p2
uGK/n2CzHlqYuR9a8P8O33v5fihiEzaV4q6FN0Xu8+fG/OoumlPPseKZUnNP
1ueOa17k1Zr6HnXPspUP2feFjfw0xXxpLnSnU6FxueO/H5+nE+OmajxId5S6
5qSTLCHvctkz24dsbJ3tZ0YPqYbrcs9Gd9x5Y9SuHfljmef+Q/I/Wvb+hdj0
1nvWhEWPUp/fOKcDfSeE6X93uDdqNY1AdhXOcUPuedZZslcvKWbN6hMlz/L+
qnu9FnkMjryEr2cDY39Ef7hqXNW8tFQ8g/vw80Hh3Cfws79wXYT9HYH/IzLX
QjX5LDWvmpzD3xhquytzv6+Jntdb9GLmOxc+DY27ELY1lo1Fwqd1kddTDX7v
hH/qw81xv/tyvz16dw7jY1tu/NEbdU3ud+qfmE/N5oaqa606C9ebA9u34ve7
srG0JzBhXer4VRNhtPQ7CtsczYz7wuQJ5NfJnb2c+a0ZX3WvqX4no4bCyA2R
i+ZddzsAfg6yVmh96l4QrqgfRiEbnRuDTpQ9K7oX9eSm6Ev1qc5VnQeh74O6
w9/c8Kl3QL3XxpmHqp7NsYFFvdGrB4WrefR8zX3Yjeztwr2uO91SuOe0pzF3
rVXnQ6wDctekpXB/KLa+6AmdtbLBmHwc3T01/+fQ/w3ZqFc0C8LyGYHns3O/
AarbBWxvY8+5zNiWlD3L6mHhoHpSb3h7vHONMW/KS3HITn0uPJ4amKw5bQ2c
1/+FHZlxWm/+6MBe7dsScyLM2BrYonnqV/ZMvR//r+TnUOF70h1tzN0f6g29
yZ2F+6EvclU92wq/l6qh8GBVbt28wAlhlGTvBlYsYH0jMw6oJsJE2fwLpnQ3
wQ==
         "],
         VertexColors->None], Polygon3DBox[CompressedData["
1:eJwtlmuIVVUUx8/ccxy9njuhlGNBkpWYNYlmpZFl+cKpoSwznFQ0rHQSNPNB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         "],
         VertexColors->None], 
        Polygon3DBox[{{3069, 3135, 870, 1665, 2451}, {2427, 2490, 1072, 599, 
         501}, {2986, 2985, 2259, 2182, 524}, {3000, 3062, 921, 946, 322}, {
         2945, 2944, 83, 947, 1039}, {3462, 3076, 1135, 1205, 2372}, {3068, 
         3136, 869, 1652, 2449}, {3068, 3445, 2280, 1138, 1034}, {2717, 2901, 
         507, 1033, 919}, {2565, 3070, 1044, 1141, 665}, {3064, 3139, 982, 
         2123, 2440}, {2179, 2491, 1092, 616, 518}, {2911, 2829, 968, 1087, 
         512}, {3138, 3072, 2465, 1985, 939}, {2742, 2910, 512, 1054, 930}, {
         2253, 2252, 202, 990, 1101}, {2977, 2844, 413, 2434, 2251}, {3137, 
         3076, 2477, 2000, 945}, {2900, 3065, 1014, 1015, 507}, {3064, 3443, 
         2265, 1116, 1012}, {2856, 2648, 1778, 2183, 431}, {2232, 2231, 24, 
         861, 1064}, {3467, 3178, 891, 1112, 2263}, {3461, 3072, 1077, 1130, 
         2273}, {3140, 3178, 1777, 1598, 855}, {3069, 3447, 2286, 1140, 
         1042}},
         VertexColors->None]}]}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1lluIVmUUhve///0f9vz/jINOamQOBXmgKAi6SOhClLLSDo5ZepOaJmEo
aBqClnnATM25sSKzwgEd0VE7eCA1ki46E10ojoeCDnbwQFY2qZE977zLi8X+
9trvt751eNf69g3T5oyfnSZJ0o0UkUO1JNmE/FBIkgIfnkK60Leh+6whSW5H
34muCfALrOenxr6JLGU9CzkAvg/4jTXv/x7s58iX6L8rJcm3SH/Wg/W95r3S
nQx9e2OSlOpJsidPkiHlJHk9Yz92KmF/PfhxPO9j71+s14Evgu8E35dzisgx
7AwH05ja/uCIax7v2wrGdPI8WU2SEUgX63mc04jcCmZZ6ti+wM6NRce8GszQ
8EM+NAZG9hXv1Jr1HTxfwqevq46vNWJ8Gd0l1mvxcxDf3slt8ytifKDivC1C
vxf9j+SiHexO3u+RH/hwBN1xxQV+WNk52YK/b/Gtg3Utcwzyvwfs37LBei26
D8DMUE3J08PIKHSrOaenYv0O3p8G8w3rLvYsQk7LZ/mLjEydM+mUt8PoeuDD
c6wnYu8K7wMy+7uw6jrORP88+ib0bXXXdBvr8XXnIclsc0zUq0JMZWRC6nPL
4K7PzJ2zwZ+PeX4S3FOtNhQd7wb23UQsS8A8zr4P8e0X4l+PL5Mr5oLqNi/4
ORXMBc64AKYluNSKzX95v4wcFA5ZjlyDfjTf5yLnWO9HtyL0O9HNqZkLI/Hl
oviA/fPY+B25A8wCvo9HhrG+P7UNnXVL0ecI82mDe0z91Zaa18LLr5Z4XxE+
6dzdxHtnxWe1Rv1Vi39Krr3qfheYE8QPrHef9reAuRb9gLLfX8mdO+VNOZ6Y
Oc/zowfU25fxYUrNOVf/qc+Ps/6Tc/6IGHfl9kn+iCPij3jSFL0jXj2LLzMq
1i+PWOTP6pgpsv8G51wkF9NT1+FS1GIp9ZqArBKPU3/XXJKdfkXnRFzqGxxV
PqeAP8P+yTybNb+Ktl+s+cwEf6/oe8wVxaT+raOvlZ33x9jbA/7t6I3OqO85
9p0tuV7qjSeQuQXza3twbHHm/uyIObotfF6CzUeQlUXPtpujl6dE7MpDd9E9
qTO3ox/b4Fkkzk6rm7c/sW96xb2jWTE6+KnZMDRsam9XzfWYic192BzE80lq
0ZE75h08O8Gvw84cvt2defa/VnNfixvq610xi1LOfwgZC+43/PhVdQqeTEJf
yJwnzU3lSrN6JbNvT9V+DQnf3uXcBVXXS36PTd0XB9Dfi+zNPEs1P59J3eut
Zff7++x7r+p+EgfPBw91js7bXfXsqdQ9f5rZ16fsMxbGXs2oERGX5v8p5bTk
/lO/aoZc7cFx4Vu17DnVO6Ny51E5/CjuO62n4cMO1of5loEtIgNTn98UPjyK
Tz8Tz5mCe7F/9KNyu4r9W7Ddgq4f0pyap/8FV9v5Nrvq3tyPjesy10iz/cVG
17Ub7NGSe1/3UnPcTYewN6piHqqvNIPEYc0XxaR4N+e+k8ThTbn3CK/7YVlw
clbMU2Gu3mfqqYvR66r7hrg7enkVPNSclO+KT/6rNzS/hNFdtD73fZRm5qJ4
eLpknolj4svW3JwZBOZg0X2nOaycL079H3Ei/iX0D9Fc9WzcCHZz5n7tvb9q
9vc42GMlc6DE9/ai7/lTZc8r3blHWU+quAcXYXMfMle4uKN1ls7Zmfss9fia
Rt9J3WXfQZqrqmffqKlmWCFmwpj4b9G/ie7qgZnzoDnUELNIfJIt2dE8XIv9
2yqeq0eq5pK4lgbfHqz7v6gt83+O7gLNy4znq7nzpr6XDeVfc2h49Ob8+HdS
vGty7+nF586F9P8DK95T3g==
         "],
         VertexColors->None], Polygon3DBox[CompressedData["
1:eJw1lm1olmUUx+/nvq/n3vN477FlJlrSKAgLoiDog1KRFEQ1E7Ss7EU3t2wI
SlaapGUuMZtzQkwDa4GCLnzZrLQXp20JvWAv9MFIp5BZ84NlQZY5s/r997/7
cLivl3Od61z/8z/n3Fc2LJg2P46iaBcSkNeyKFpTiaK+UhTNYuMI33uroqg9
YY5COzIujaKV7O1F6spRtBNp52wtOmPZnxR8tqkQRbOro+izEVF0I+Nfirb1
JeefTGzzYfZf4b6vdA/nBvg+hM6r7NUHj79D/5nEa/uxNYszJ7F1DTZXcfYx
5j8w36OzjM/zhhfZ+xT9u/CtAxmDrfeQRvYXZT5bxO7HnLmdO9rQvZX9Maxd
iowu+I3d7E9AfwfzHsZTsdWDdPLeqzhThz/t+NDF2kHWzqGzifEOxts4/z42
24KxGI/+u+wvZ/84/n5f9HvXMT/Bfgv6zdx1BfIU4ypkE+N+ZHvstTn4/zl3
zmT8D+d/5/x6zi/nvk7W3mK8iLVB7ro/GOstrN0djLnw6EXmJvanAXt/YH8d
Z//E3tqyY65Yh2DsdEa6esPG1PeNY+8J1vpTv3cy8/nM38BWX+a3NyMTwXae
9hNjthi98cjCgv3dlL+3s2AMbkP3beQU41GcCfiyhvkFxr1IN+Ma1j5i/Fww
dsJQXKkKjsd27C3F9g4J4wVIV8FrG8q2KVuXBWOl+1qDMXu8ZAz09qOJY/8o
GA0UzQFxTZzbjd4J1jr4tih+6JaCuSAfdPd59n5D51fkOvZvKnhNMVJsViPn
2PuraPy1Ly4KU2EpTjZWGRNhcQT85ud80VuPJ8Z3N/rzGLcij+DfFO7/At0Z
egP6x0r2HdXheJ5l8EHinBgqmR+9kTkmPgmjYWyCuSA8Bji/IjYWwmQM+keL
zn/FRLH4MDiXldNTGX/N2SbGC9Gv4ewo/Oxh/UDi/ByZOLb96N0cHONd4hrz
TxivCObTRUhHwT4od5TnynflUBNvGcTutoJjPIJxGTnDeHTsOC1Ffiw6Xqo/
epPeojcLb9WAptg5q9goRorfqfw+5ew9zGuZt5ZdGycKO3zciG9tFb9hDjon
WTuIDGDrZ/S/ZX1xyb4tYz/GtwIyxHxsbO4IJ+ElDqkOLmVtYeJ6KGyFsWrr
85yp4b6ZYHosMSZ6v+zrLt2pWrG64rgqnpPy+L8Uu6aJD7dw/yWJ15TLirli
rZzepxxGJsfOUcVOMbyYM6eZV/hWp8ZWeMh/5cC1sXNY9Vr5qFqmevgmtvpy
3zfHeW1NzQf505/nt+4SfkeI0eGiuSrOqtap5l0ouocolorplNgxTlPXcdXz
+2JjG6Wuj8JYtV41P6TG+x3OLin5LYqpcqUBvA6VnDN6Zw1SF1tHXCqltq37
horOWeXqvth8VU9QL2gt2M+/i96TvzN5yGHOV2JjtCev/8JOb1BPUYyExZ3M
X664forrm8vmljim/noDts6o5uf3q2aMTB0T2ZPPCbprOdNWtj93qLZntq07
tCcd8V28F1fEGdXerTm3xXHVevVw9dlBZHpsjMVNcfTpvD8p3zdnnmtd/w76
h1A/uhp/X2A8F/wzuHU9OuvYPzvC/UB9QWOt7SmbI6pNul+5pRql2qZ+uzy4
xtXn9UC9pRC796jnrgzuQW2Z8RKXxGHV9uGeElzjz7L3IP50q/bG5tf0zFwR
Z4S9YiCb6mHTMnNobM6nc+i/nhlb1bDLg3uaepnevB8flwVzXTHT+w5lvktv
rs3c44WdMOtK/f+0hDPNeb3/ibVnGa9P/HbxqzcYgw15vnbm+bkzrw+qvbKh
XnM6zxX1HP2/KP7isnjfElyDVXu/Ye1f9maAx97E/utfoL7aPBO/dLc4rlos
H9RP1V+V25Wcb8KjMTanVJeK6E2IXZ+E1+zMsWrM80096oHgmqU4HM59EUbi
hHqaetkB9fRqc0jcqU1dj8RpcVk1ZGfm/FWdVX3VWHf8X3vV21QLVwX/A4kL
wljYihMp9tdm5sqW4H+F7sy2VLP/A0nlgIs=
         "],
         VertexColors->None], 
        Polygon3DBox[{{3066, 3154, 966, 2076, 2445}, {1882, 2197, 1032, 994, 
         204}, {3063, 3029, 382, 960, 928}, {3464, 3073, 1091, 1157, 2297}, {
         3156, 3202, 1839, 1704, 873}, {3157, 3200, 1829, 1691, 872}, {3077, 
         3155, 959, 2064, 2486}, {2899, 2760, 1516, 1515, 506}, {2957, 2958, 
         1053, 958, 143}, {2750, 2898, 506, 1513, 1512}, {3066, 3470, 2242, 
         1086, 1024}, {3075, 3471, 2299, 1161, 1107}, {2487, 2172, 500, 595, 
         1509}, {2912, 3067, 1025, 1026, 513}, {3468, 3200, 903, 1081, 
         2240}, {3469, 3202, 905, 1084, 2241}, {2832, 2913, 513, 1094, 969}, {
         2847, 2979, 2255, 2435, 414}, {3075, 3151, 885, 1752, 2472}, {3465, 
         3074, 1100, 1159, 2298}, {3077, 3472, 2411, 1219, 1195}, {2488, 2428,
          519, 551, 912}, {2990, 2991, 525, 1753, 2261}, {3071, 2968, 607, 
         1082, 1047}, {3153, 3073, 2467, 2150, 988}, {3152, 3074, 2471, 2158, 
         993}, {2227, 2228, 1504, 1503, 22}},
         VertexColors->None]}]}, {}}, {{Line3DBox[CompressedData["
1:eJwl1Ql8j2UAwPHXtYZtplw1RzN3zlkzmkquRBclhhJJwwedjqSkojsqui/N
InShVCgWubcxVrmGcqZFuqXvU5/Pvvs97/s87/9993//73/JQ8b0Hl0miqKT
fqXGRFEY51WMokTdoPW0UFtqsXbUA9pLS3WAntERmlApiiZoDZ2udXS2puhc
baZLNEPztJtu1b3Ou01LtEj36XbdrzvC+bQ4HBcbRbkusEUF10MrWtM1Lora
aCptSeNC0mlHN/MZ2p6VrrWDXkQm1c111Iu5hEvpRIr9l2lnuoRzhNehO5fT
I7DmCo3VntqLK7mKq7mGa+lNJWv66HVcT19uoB/9w7Hms3QAAxnEjdzEYG4O
r23NEB3KLQzj1nA++4frbWQzgpGMYjTjykXRGB3L7dzBndzF3dwT3k+vMU7H
M4GJ3Etz+yfpfUzmfh5gCg8ylSbWPKQP8wjTmM6jPEZl84/rEzzJUzzNM8xg
JhWteVaf43lmMZtz7H9BX+QlXuYVXuU1XqeqNW/om7zFHN4mhy/c77mayzvM
Yz7vsoD6jl2oi3iP9/mAD/ko3CPzi3UJS/mYT1jGp7Qz/5l+znJWsDKcly9Z
RTVrVmseX7GGtTS1/2tdx/qw3rVu0I3UMrdJN7OFfAooZCutzG/TInaEe+Ye
H/Sc7PScHNJdelh36xHdo0d1rx7TEu3j+SvULrpa03WxNtEcra+zNEmnaTUd
r3Garaddb5Ye157hudVM3a4tNF/r6jqtoj2cN0G7a7x2VX9G1Fkrayf10tFE
6/PKe69Yw1oywnul61jPBjayic20N79F81nu+AItZCsJ4b3SIrazg2Lq2v+N
fst37GQXu9nDXjKtKdF97OcA3/MDB0kzf0gPc4SjHONHjpNo/ict5WdOcJJf
OMUy1/qr/sbv/MGf/EWyY//W0/zDGSL3ugxlKUc9a8prBWI4i1ha219RK4Xn
jzjiSaAKiTS0pqqeHZ6z8DmlOjWoGY4xX0vP5TySqE0d6oZzcz7J4TkihQZh
reMaaiMah++H8FmnGReE59/fUcu9HqqLGcYWn99S+htP0iSv0U9TbA+nYbiX
tk8wwHiyDqS5cTYtw321He+4UzrI9hQdTJrxSNJpZH6BfTOMVzDVeCijjZcy
ljbhO8e+tuE7yfYi41G6UGfqSuYbF1PFmnmaGu6/ttJcbWB/kTaz3ZRV7vNh
242Ma5prrAW2kzVLc+jLRGqbP66bmMNGFvi/l+k98xN1iPnvYxBlaPhIpKsl
UZqWjf7/P/4vbID8Dw==
       "]], 
      Line3DBox[{1597, 7, 1496, 1497, 1498, 1499, 3165, 1500, 1501, 1502, 
       1503, 1504, 1505, 1506, 3166, 1507, 1508, 2487, 1509, 1510, 1511, 3167,
        1512, 1513, 1514, 1515, 1516, 3168, 1517, 1518, 1519, 1520, 1521, 
       1522, 1523, 1524, 3169, 1525, 3170, 1526, 1527, 1528, 1529, 1530, 1531,
        1532, 1533, 3171, 1534, 1535, 1536, 1537, 1538, 1539, 1540, 3172, 
       1541, 1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551, 1552,
        1553, 3173, 1554, 1555, 1556, 1557, 1558, 1559, 1561, 1167, 699, 277, 
       787, 1597}], 
      Line3DBox[{647, 8, 2483, 1324, 1122, 1203, 1124, 974, 1007, 1112, 891, 
       3140, 855, 1058, 1126, 1060, 978, 1009, 1114, 893, 859, 1067, 1128, 
       1069, 982, 3139, 1012, 1116, 896, 863, 1075, 1130, 1077, 3138, 939, 
       1168, 1213, 898, 866, 1133, 1205, 1135, 3137, 945, 1177, 1216, 900, 
       869, 3136, 1034, 1138, 1036, 948, 1016, 1079, 902, 870, 3135, 1042, 
       1140, 1043, 951, 1017, 1186, 2494, 1185, 1187, 1164, 952, 1045, 1141, 
       1044, 3134, 950, 1040, 1080, 1041, 949, 924, 1184, 3133, 1039, 947, 
       1180, 1183, 922, 946, 921, 3122, 1175, 944, 1137, 868, 1173, 1174, 
       1172, 943, 3131, 919, 1033, 865, 1015, 1014, 3130, 936, 1073, 1072, 
       2490, 862, 895, 3101, 1011, 980, 1064, 861, 934, 1000, 1055, 3094, 
       1056, 976, 932, 857, 9, 1949, 279, 647}], 
      Line3DBox[{886, 217, 2414, 836, 425, 804, 1389, 917, 1201, 1162, 997, 
       1108, 1160, 1106, 3117, 884, 914, 1120, 1030, 992, 3115, 1099, 1158, 
       1097, 880, 910, 1118, 1027, 987, 3111, 1090, 1156, 1088, 877, 908, 
       1085, 1023, 3147, 965, 1153, 1211, 1151, 874, 906, 1218, 1194, 3146, 
       1193, 3126, 1196, 962, 1192, 961, 1150, 1197, 929, 964, 3144, 930, 
       1054, 1003, 1087, 968, 3143, 986, 1093, 1092, 2491, 1004, 1095, 3114, 
       1096, 991, 1101, 990, 913, 883, 1104, 3097, 1105, 996, 916, 886}], 
      Line3DBox[{1765, 218, 840, 427, 1766, 219, 1494, 971, 999, 1111, 3164, 
       1110, 1005, 970, 994, 1032, 995, 1103, 3163, 1102, 882, 2488, 912, 
       1029, 989, 3162, 969, 1094, 879, 1026, 1025, 3161, 967, 963, 1200, 
       1155, 876, 1198, 985, 1199, 3160, 928, 960, 927, 1191, 1149, 958, 1053,
        3078, 1190, 925, 957, 1052, 1143, 1051, 955, 3158, 1047, 1082, 1048, 
       954, 1165, 1208, 871, 2492, 1207, 1046, 953, 1018, 1081, 903, 3157, 
       872, 1049, 1142, 1050, 956, 1021, 1084, 905, 3156, 873, 1145, 1210, 
       1147, 959, 3155, 1195, 1219, 907, 875, 1152, 1212, 1154, 966, 3154, 
       1024, 1086, 909, 878, 1089, 1157, 1091, 3153, 988, 1028, 1119, 911, 
       881, 1098, 1159, 1100, 3152, 993, 1031, 1121, 915, 885, 3151, 1107, 
       1161, 1109, 998, 1163, 1202, 918, 888, 1765}], 
      Line3DBox[{3079, 1567, 923, 1037, 1139, 1035, 3175, 1038, 3079}], 
      Line3DBox[{1573, 1148, 1144, 1209, 1146, 926, 1573}], 
      Line3DBox[{1578, 1176, 1181, 1179, 901, 1217, 1578}], 
      Line3DBox[{1584, 1019, 1188, 3125, 1022, 3090, 904, 1083, 1584}], 
      Line3DBox[{1565, 1564, 1563, 3104, 1562, 3174, 1182, 1566, 1565}], 
      Line3DBox[{1571, 1570, 1569, 1568, 1189, 1572, 1571}], 
      Line3DBox[{1581, 1580, 1020, 1585, 1583, 3177, 1582, 3176, 1581}], 
      Line3DBox[{1575, 1574, 1178, 1579, 1577, 1576, 1575}]}, {
      Line3DBox[{2500, 1773, 2499, 3282, 2644, 2501, 3283, 2645, 2502, 3284, 
       2646, 2503, 3275, 3285, 2647, 3045, 3276, 3456, 3046, 2883, 2929, 3060,
        3100}], 
      Line3DBox[{2505, 2654, 3289, 2504, 2653, 3288, 3236, 2860, 2652, 3287, 
       3235, 2859, 2651, 3286, 3234, 2858, 2650, 3429, 2887, 2747, 2857, 2649,
        3428, 3252, 2886, 2964, 2963, 3128}], 
      Line3DBox[{2507, 3179, 3336, 2506, 1782, 2508, 3290, 2655, 2509, 3291, 
       2656, 2510, 3237, 3292, 2888, 2657, 2861}], 
      Line3DBox[{2512, 2662, 3295, 2511, 2661, 1968, 2867, 2660, 3294, 3239, 
       2866, 2659, 3293, 3238, 2865, 2658, 3430, 2893, 2748, 2864, 534}], 
      Line3DBox[{2514, 3180, 3337, 2513, 3181, 3338, 2515, 3182, 3339, 2516, 
       3296, 2663, 2517, 1970, 2894, 2664, 2868, 3258, 3437, 2749, 2896, 2932,
        2933, 2869, 2236, 3108}], 
      Line3DBox[{2518, 2668, 2755, 3418, 2874, 2667, 2754, 3417, 2873, 2666, 
       1977, 2872, 2665, 3297, 3240, 2871, 1794, 2904, 2715, 2753, 2935, 3386,
        3253, 2902, 2714, 2941, 2752, 2189, 3086}], 
      Line3DBox[{2520, 3183, 3340, 2519, 3184, 3341, 2521, 3185, 3342, 2522, 
       1798, 2523, 3389, 2756, 2895, 2757, 2524, 3390, 2758, 2897, 2759, 2995,
        2996, 3259, 3391, 3087}], 
      Line3DBox[{2530, 2769, 2768, 3397, 2529, 2767, 2766, 3396, 2528, 2765, 
       2764, 3395, 2527, 2722, 3343, 3219, 2526, 3394, 2721, 2905, 2720, 2525,
        3393, 2719, 2903, 2718, 2998, 3041, 3255, 3435, 3102}], 
      Line3DBox[{2532, 3186, 3344, 2531, 3187, 3345, 2533, 3188, 3346, 2534, 
       3189, 3347, 2535, 1996, 2770, 2536, 3272, 3392, 2762, 3037, 2763, 2999,
        3042, 2275, 2723, 3010, 3123}], 
      Line3DBox[{2542, 2777, 2776, 3399, 2541, 2775, 2774, 3398, 2540, 2729, 
       1910, 2539, 2728, 3348, 3220, 2538, 1907, 2727, 2537, 3012, 3449, 2726,
        3047, 2725, 3001, 3044, 2277, 2724, 3011, 3132}], 
      Line3DBox[{2544, 3190, 3349, 2543, 3191, 3350, 2545, 3192, 3351, 2546, 
       3193, 3352, 2547, 3277, 3353, 3048, 2548, 3280, 3419, 3055, 2875, 2967,
        2966, 2549, 3444, 3002, 3003, 2771, 3174}], 
      Line3DBox[{2557, 2669, 3298, 2556, 2782, 3357, 3241, 2555, 2732, 3356, 
       3223, 2554, 2731, 3355, 3222, 2553, 3221, 3354, 2730, 2552, 3013, 3450,
        3266, 2773, 2947, 2946, 2551, 3446, 3004, 3005, 2772, 3124}], 
      Line3DBox[{106, 1673, 107, 1674, 108, 1675, 109, 1676, 110, 1677, 111, 
       2300, 687, 805, 112, 2025, 346}], 
      Line3DBox[{2559, 3194, 3358, 2558, 3195, 3359, 2560, 3196, 3360, 2561, 
       3197, 3361, 2562, 3224, 3362, 2733, 2563, 3267, 3400, 3014, 2778, 2949,
        2948, 2564, 3264, 3401, 3006, 2779, 2950, 3105}], 
      Line3DBox[{2572, 3367, 3199, 2571, 3366, 3198, 2570, 2783, 3365, 3242, 
       2569, 2735, 3364, 3226, 2568, 3225, 3363, 2734, 2567, 3015, 3451, 3268,
        2781, 2953, 2952, 2566, 3265, 3448, 3007, 2780, 2951, 3088}], 
      Line3DBox[{2574, 3299, 2670, 2573, 3300, 2671, 2575, 2784, 3301, 2672, 
       2785, 3227, 3302, 2673, 2786, 3228, 3303, 2674, 2787, 3269, 3452, 3017,
        2788, 2936, 2675, 3049, 2329, 3016, 2789, 2937, 3089}], 
      Line3DBox[{120, 1685, 119, 1684, 118, 1683, 117, 1682, 116, 1681, 115, 
       1680, 689, 114, 1679, 806, 688, 113}], 
      Line3DBox[{2580, 2682, 3307, 2579, 2681, 3306, 2578, 2680, 3305, 2577, 
       2679, 3304, 2576, 2678, 3460, 3056, 2736, 2791, 2677, 3420, 3273, 2876,
        2956, 2955, 3019, 2676, 3402, 3018, 2790, 2954, 3106}], 
      Line3DBox[{2582, 3201, 3368, 2581, 2792, 3308, 2683, 2793, 2737, 3309, 
       2684, 2794, 3229, 3310, 2685, 2795, 3230, 3311, 2686, 2796, 3270, 3453,
        3022, 2797, 2938, 2687, 3052, 3457, 3020, 3021, 2798, 3125}], 
      Line3DBox[{2587, 2693, 3316, 2586, 2692, 3315, 2585, 2691, 3314, 2584, 
       2690, 3313, 2583, 2689, 3312, 3050, 3051, 2688, 3421, 3281, 2877, 2970,
        2969, 3024, 3454, 3203, 3023, 2799, 3159}], 
      Line3DBox[{2589, 3204, 3369, 2588, 2801, 3205, 3404, 2878, 2802, 3317, 
       2694, 2803, 3231, 3318, 2695, 2804, 3232, 3319, 2696, 2805, 3271, 3455,
        2738, 3053, 3025, 3026, 2806, 3405, 3027, 2739, 3030, 3145}], 
      Line3DBox[{2594, 2701, 3324, 2593, 2700, 3323, 2592, 2699, 3322, 2591, 
       2698, 3321, 2590, 2697, 3320, 2810, 2879, 3039, 3403, 3274, 3040, 2800,
        3033, 2808, 3458, 3032, 3031, 3038, 3127}], 
      Line3DBox[{2595, 2812, 3206, 3408, 2880, 2813, 3207, 3409, 2881, 2814, 
       3208, 3410, 2815, 3233, 3325, 2702, 2816, 3411, 2740, 2906, 2703, 2817,
        3412, 2741, 2908, 3034, 3035, 2818, 3256, 3436, 3107}], 
      Line3DBox[{2600, 2707, 3329, 2599, 2706, 3328, 2598, 2705, 3327, 2597, 
       2704, 3326, 2596, 3413, 3210, 2916, 2821, 2882, 3407, 3209, 2914, 2811,
        3036, 2820, 3254, 3406, 3092}], 
      Line3DBox[{2602, 2822, 2823, 3422, 2601, 2824, 2825, 3423, 2603, 2826, 
       2827, 3424, 2604, 3243, 3370, 2828, 2605, 3387, 2743, 2907, 2744, 2606,
        3257, 3388, 2745, 2909, 2746, 2959, 2607, 3260, 3414, 3093}], 
      Line3DBox[{2614, 2710, 3332, 2613, 2709, 3331, 2612, 2708, 3330, 2611, 
       3371, 3211, 2610, 3415, 2836, 2917, 2835, 2609, 2975, 3439, 2834, 2915,
        2833, 2974, 2608, 3261, 3438, 3113}], 
      Line3DBox[{2616, 3212, 3372, 2615, 2837, 2838, 3425, 2617, 2839, 3373, 
       3244, 2618, 3245, 3374, 2840, 2619, 3246, 3431, 2918, 2841, 2620, 3262,
        3416, 2842, 2919, 2843, 2976, 2621, 3142}], 
      Line3DBox[{2628, 2712, 3334, 2627, 2711, 3333, 2626, 3377, 3214, 2625, 
       3376, 3213, 2624, 3247, 3375, 2923, 2850, 2623, 2981, 3441, 2849, 2922,
        2848, 2980, 2622, 3096}], 
      Line3DBox[{2630, 3215, 3378, 2629, 2851, 3379, 3248, 2631, 2852, 3380, 
       3249, 2632, 3250, 3381, 2853, 2633, 3251, 3432, 2924, 2854, 2634, 3263,
        3433, 2982, 2925, 2984, 2983, 3141}], 
      Line3DBox[{2643, 2713, 3335, 2642, 3385, 3218, 2641, 3384, 3217, 2640, 
       3383, 3216, 2639, 3278, 3382, 3057, 3059, 3058, 2638, 3054, 3459, 3279,
        2928, 2993, 2992, 3119}], Line3DBox[{3080, 3081}], 
      Line3DBox[{3082, 3083}], Line3DBox[{1010, 1311}], 
      Line3DBox[{3084, 3085}], Line3DBox[{3090, 3091}], 
      Line3DBox[{3095, 2862, 531, 2889, 586}], Line3DBox[{3098, 3099}], 
      Line3DBox[{1309, 894}], Line3DBox[{3103, 3104}], 
      Line3DBox[{3109, 3110}], Line3DBox[{3148, 3112}], 
      Line3DBox[{3149, 3116}], Line3DBox[{3150, 3118}], 
      Line3DBox[{3120, 3121}], Line3DBox[{3129, 2863, 593, 2892}]}, {
      Line3DBox[{1586, 1773, 1587, 3336, 1781, 1611, 3337, 1788, 1622, 3340, 
       1795, 1634, 3344, 1802, 1647, 3349, 1809, 1660, 3358, 1817, 1673, 1826,
        3299, 1686, 3368, 1836, 1699, 3369, 1846, 1712, 2068, 2142, 3408, 
       1856, 1725, 2079, 3422, 2145, 1867, 1737, 3372, 1878, 1748, 3378, 1889,
        1760}], 
      Line3DBox[{1588, 1774, 3282, 1589, 1782, 1612, 3338, 1789, 1623, 3341, 
       1796, 1635, 3345, 1803, 1648, 3350, 1810, 1661, 3359, 1818, 1674, 1827,
        3300, 1687, 2044, 2045, 1837, 3308, 1700, 2056, 2140, 3404, 1847, 
       1713, 2069, 2143, 3409, 1857, 1726, 2080, 3423, 2146, 1868, 1738, 2088,
        3425, 2153, 1879, 1749, 3379, 2097, 2160, 1890, 1761}], 
      Line3DBox[{1590, 1775, 3283, 1591, 1783, 3290, 1613, 3339, 1790, 1624, 
       3342, 1797, 1636, 3346, 1804, 1649, 3351, 1811, 1662, 3360, 1819, 1675,
        2032, 2033, 1828, 3301, 1688, 1930, 2046, 1838, 3309, 1701, 2057, 
       2058, 1848, 3317, 1714, 2070, 2071, 3410, 1858, 1727, 2081, 3424, 2147,
        1869, 1739, 3373, 2089, 2154, 1880, 1750, 3380, 2098, 2161, 1891, 
       1762}], Line3DBox[{1592, 1776, 3284, 1593, 1784, 3291, 1614, 1791, 
       3296, 1625, 1798, 1637, 3347, 1805, 1650, 3352, 1812, 1663, 3361, 1820,
        1676, 1924, 2034, 1925, 3302, 1689, 1931, 2047, 1932, 3310, 1702, 
       1935, 2059, 1936, 3318, 1715, 1939, 2072, 1940, 3325, 1728, 3370, 2082,
        2148, 2083, 1740, 3374, 2090, 2155, 2091, 1751, 3381, 2099, 2162, 
       2100, 1763}], 
      Line3DBox[{1594, 2387, 2388, 3285, 1595, 1958, 1959, 3292, 2170, 1969, 
       1970, 2173, 1982, 3389, 1983, 1638, 1996, 1997, 1651, 3353, 2395, 2396,
        1664, 3362, 1918, 1919, 1677, 1926, 2035, 1927, 3303, 1690, 1933, 
       2048, 1934, 3311, 1703, 1937, 2060, 1938, 3319, 1716, 1941, 2073, 3411,
        1942, 2175, 1944, 3387, 2084, 1945, 2177, 3431, 2092, 2156, 2093, 
       2180, 3432, 2101, 2163, 2102, 1764}], 
      Line3DBox[{1596, 1947, 2389, 2391, 2390, 3456, 2168, 1960, 2114, 2226, 
       2225, 2171, 1971, 2121, 3437, 2234, 2233, 2174, 1984, 3390, 2129, 2355,
        2354, 2131, 2356, 2357, 3392, 1998, 2359, 2358, 2135, 3419, 2418, 
       2419, 2397, 2399, 2398, 2012, 3400, 2321, 2322, 2022, 2302, 2301, 2300,
        2303, 2304, 2036, 2332, 2331, 3452, 2038, 2209, 2210, 2049, 2338, 
       2337, 3453, 2051, 2339, 2340, 2061, 3455, 2346, 2345, 2063, 2347, 2348,
        2074, 3412, 1943, 2176, 2221, 2222, 3388, 2085, 1946, 2178, 2248, 
       2249, 3416, 2157, 2094, 2181, 3433, 2257, 2258, 2164, 2103, 2104}], 
      Line3DBox[{1601, 1951, 2110, 1779, 3429, 1602, 1962, 2117, 1786, 3430, 
       1617, 1901, 2124, 1794, 1629, 1903, 3394, 1988, 1801, 1642, 1907, 2004,
        1808, 1655, 3354, 1913, 2017, 1815, 1668, 3363, 1921, 2028, 1823, 
       1681, 1929, 1831, 3460, 1694, 2406, 1841, 3312, 1707, 2066, 1851, 3320,
        1720, 2078, 3413, 1862, 1732, 2087, 3415, 1873, 1743, 3375, 2096, 
       1884, 1755, 3382, 2415, 1895, 1768}], 
      Line3DBox[{1603, 1952, 2111, 1953, 3286, 1604, 1963, 2118, 1964, 3293, 
       1618, 1974, 2125, 1975, 3297, 1630, 3343, 1904, 1989, 1905, 1643, 3348,
        1908, 2005, 1909, 1656, 3355, 1914, 2018, 1915, 1669, 3364, 1922, 
       2029, 1923, 1682, 1832, 3304, 1695, 1842, 3313, 1708, 1852, 3321, 1721,
        1863, 3326, 1733, 3371, 1874, 1744, 3376, 1885, 1756, 3383, 1896, 
       1769}], Line3DBox[{1605, 1954, 2112, 1955, 3287, 1606, 1965, 2119, 
       1966, 3294, 1619, 1976, 2126, 1977, 1631, 1990, 3395, 2132, 1991, 1644,
        1910, 2006, 1911, 1657, 3356, 1916, 2019, 1917, 1670, 3365, 2030, 
       2139, 2031, 1683, 1833, 3305, 1696, 1843, 3314, 1709, 1853, 3322, 1722,
        1864, 3327, 1734, 1875, 3330, 1745, 3377, 1886, 1757, 3384, 1897, 
       1770}], Line3DBox[{1607, 1956, 2113, 1957, 3288, 1608, 1967, 2120, 
       1968, 1620, 1978, 2127, 3417, 1979, 1632, 1992, 3396, 2133, 1993, 1645,
        2007, 3398, 2136, 2008, 1658, 3357, 2020, 2138, 2021, 1671, 3366, 
       1824, 1684, 1834, 3306, 1697, 1844, 3315, 1710, 1854, 3323, 1723, 1865,
        3328, 1735, 1876, 3331, 1746, 1887, 3333, 1758, 3385, 1898, 1771}], 
      Line3DBox[{1609, 1780, 3289, 1610, 1787, 3295, 1621, 1980, 2128, 3418, 
       1981, 1633, 1994, 3397, 2134, 1995, 1646, 2009, 3399, 2137, 2010, 1659,
        1816, 3298, 1672, 3367, 1825, 1685, 1835, 3307, 1698, 1845, 3316, 
       1711, 1855, 3324, 1724, 1866, 3329, 1736, 1877, 3332, 1747, 1888, 3334,
        1759, 1899, 3335, 1772}], 
      Line3DBox[{1767, 1894, 2416, 2105, 2417, 3459, 1754, 1883, 2159, 3441, 
       2095, 2256, 1742, 1872, 2152, 3439, 2086, 2247, 1731, 1861, 3407, 2144,
        2067, 2425, 2367, 1719, 2365, 2366, 2364, 3403, 2141, 2055, 2424, 
       2363, 1706, 3421, 2422, 2423, 2421, 2407, 2043, 2420, 2408, 1693, 3420,
        2361, 2362, 2360, 2042, 1928, 2307, 1680, 2386, 2385, 2027, 1920, 
       2404, 2324, 3451, 1667, 2195, 2323, 2194, 2016, 1912, 2402, 2319, 3450,
        1654, 2317, 2318, 2316, 2003, 3449, 1906, 2394, 2314, 1641, 2312, 
       2313, 2311, 1987, 3393, 1902, 1628, 2191, 2190, 3386, 1973, 1900, 1616,
        2188, 2187, 2116, 1961, 1600, 3428, 2185, 2184, 2109, 1950, 2426}], 
      Line3DBox[{2489, 1821, 1678, 2208, 2496}], 
      Line3DBox[{2493, 2462, 2463, 1972, 2189, 1793, 1627, 2198, 2370, 2199, 
       3435, 1986, 2310, 2393, 1800, 1640, 2276, 2373, 2277, 2002, 2192, 2401,
        1807, 1653, 2281, 3446, 2283, 2282, 2015, 2193, 2403, 1814, 1666, 
       3448, 2287, 2289, 2288, 2026, 2327, 2328, 1822, 1679, 2305, 2378, 2306,
        2041, 2333, 2334, 1830, 3402, 1692, 2213, 2379, 2214, 2054, 2341, 
       2342, 3454, 1840, 1705, 2217, 2381, 2218, 2065, 2349, 3458, 2412, 1850,
        1718, 2295, 2384, 2296, 2077, 3406, 2196, 2413, 1860, 1730, 2245, 
       2246, 3438, 2151, 2447, 1871, 2497}], 
      Line3DBox[{2495, 2468, 2469, 2149, 3414, 2244, 2243, 2437, 2219, 2350, 
       2220, 3436, 2075, 2294, 2382, 2293, 2431, 2343, 2410, 3405, 2344, 2062,
        2216, 2292, 2215, 2053, 2335, 3457, 2409, 2336, 2050, 2212, 2290, 
       2211, 2040, 2329, 2405, 2330, 2037, 2207, 2376, 2206, 2025, 2204, 2325,
        2205, 2023, 2285, 2375, 2284, 3401, 2014, 2202, 2320, 2203, 2011, 
       2279, 2374, 3444, 2278, 2001, 2200, 2315, 2201, 1999, 2275, 2371, 2274,
        2430, 2308, 2353, 2309, 2130, 3391, 2238, 2272, 2237, 2436, 2235, 
       2236, 2122, 2459, 2458, 2498}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJzsvHk01VH7PixpMCYplChJpISShG5kzJiZyJh5JmTIHCoRUmSKZkOSoQxt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    "]],
  Axes->None,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-0.01, 0.01}, {0.99, 1.01}, {-4.937109618568054, 
   6.948290222869736}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Die Grenzwerte, die sich ergeben, wenn man sich dem Punkt aus \
unterschiedlichen Richtungen n\[ADoubleDot]hert, sind verschieden!\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"a", " ", "\[CurlyEpsilon]"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"1", "+", "\[CurlyEpsilon]"}]}]}], "}"}]}], ",", 
   RowBox[{"\[CurlyEpsilon]", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["1", "a"]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Potenzreihen", "Subsection"],

Cell["Potenzreihen entwickeln", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "-", 
   FractionBox[
    SuperscriptBox["x", "11"], "39916800"], "+", 
   FractionBox[
    SuperscriptBox["x", "13"], "6227020800"], "-", 
   FractionBox[
    SuperscriptBox["x", "15"], "1307674368000"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "16"],
    SeriesData[$CellContext`x, 0, {}, 1, 16, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880], 0, 
    Rational[-1, 39916800], 0, 
    Rational[1, 6227020800], 0, 
    Rational[-1, 1307674368000]}, 1, 16, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "5"],
    SeriesData[$CellContext`x, 1, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {1, 
    Rational[-1, 2], 
    Rational[1, 3], 
    Rational[-1, 4]}, 1, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["z", "2"], "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "I", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["\[ImaginaryI]", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]]}], "+", 
   FractionBox["1", "4"], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "32"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "64"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], "]"}], "5"],
    SeriesData[$CellContext`z, 
     Complex[0, 1], {}, -1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   Complex[0, 1], {
    Complex[0, 
     Rational[-1, 2]], 
    Rational[1, 4], 
    Complex[0, 
     Rational[1, 8]], 
    Rational[-1, 16], 
    Complex[0, 
     Rational[-1, 32]], 
    Rational[1, 64]}, -1, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    SqrtBox["x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"x", "-", "1"}], "2"], "-", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "-", 
   RowBox[{
    FractionBox["5", "128"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "5"],
    SeriesData[$CellContext`x, 1, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {1, 
    Rational[1, 2], 
    Rational[-1, 8], 
    Rational[1, 16], 
    Rational[-5, 128]}, 0, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "//", "InputForm"}]], "Input"],

Cell["SeriesData[x, 1, {1, 1/2, -1/8, 1/16, -5/128}, 0, 5, 1]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "\[LeftDoubleBracket]", 
    RowBox[{"3", ",", "5"}], "\[RightDoubleBracket]"}], ",", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"f", ",", "4"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["5", "128"]}], ",", 
   RowBox[{"-", 
    FractionBox["5", "128"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{"y", "-", 
      FractionBox[
       SuperscriptBox["y", "3"], "6"], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "y", "]"}], "4"],
       SeriesData[$CellContext`y, 0, {}, 1, 4, 1],
       Editable->False]}],
     SeriesData[$CellContext`y, 0, {1, 0, 
       Rational[-1, 6]}, 1, 4, 1],
     Editable->False], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"1", "-", 
       FractionBox[
        SuperscriptBox["y", "2"], "2"], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "y", "]"}], "4"],
        SeriesData[$CellContext`y, 0, {}, 0, 4, 1],
        Editable->False]}],
      SeriesData[$CellContext`y, 0, {1, 0, 
        Rational[-1, 2]}, 0, 4, 1],
      Editable->False], ")"}], " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["y", "2"]}], "+", 
       FractionBox[
        SuperscriptBox["y", "3"], "12"], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "y", "]"}], "4"],
        SeriesData[$CellContext`y, 0, {}, 1, 4, 1],
        Editable->False]}],
      SeriesData[$CellContext`y, 0, {
        Rational[-1, 2], 0, 
        Rational[1, 12]}, 1, 4, 1],
      Editable->False], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], "+", 
       FractionBox[
        SuperscriptBox["y", "2"], "12"], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "y", "]"}], "4"],
        SeriesData[$CellContext`y, 0, {}, 0, 4, 1],
        Editable->False]}],
      SeriesData[$CellContext`y, 0, {
        Rational[-1, 6], 0, 
        Rational[1, 12]}, 0, 4, 1],
      Editable->False], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    SeriesData[$CellContext`y, 0, {1, 0, 
      Rational[-1, 6]}, 1, 4, 1], 
    SeriesData[$CellContext`y, 0, {1, 0, 
      Rational[-1, 2]}, 0, 4, 1], 
    SeriesData[$CellContext`y, 0, {
      Rational[-1, 2], 0, 
      Rational[1, 12]}, 1, 4, 1], 
    SeriesData[$CellContext`y, 0, {
      Rational[-1, 6], 0, 
      Rational[1, 12]}, 0, 4, 1]}, 0, 4, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Grenzwertbestimmung f\[UDoubleDot]r einen komplizierten Ausdruck.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"Tan", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox["f", 
    SuperscriptBox["x", "7"]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", "30"]], "Output"]
}, Open  ]],

Cell["\<\
Der Grenzwert kann aus der zugeh\[ODoubleDot]rigen Potenzreihe leicht \
abgelesen werden. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "7"], "30"], "+", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["x", "9"]}], "756"], "+", 
   FractionBox[
    RowBox[{"1913", " ", 
     SuperscriptBox["x", "11"]}], "75600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "13"],
    SeriesData[$CellContext`x, 0, {}, 7, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 30], 0, 
    Rational[29, 756], 0, 
    Rational[1913, 75600]}, 7, 13, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["Selbst bei so komplizierten Ausdr\[UDoubleDot]cken \
wie dem Folgenden wird die Reihenentwicklung ohne Verz\[ODoubleDot]gerung \
berechnet. ", "SmallText"]], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"x", "-", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      RowBox[{
       SuperscriptBox["E", "x"], "-", 
       SuperscriptBox["E", 
        RowBox[{"Sin", "[", "x", "]"}]]}]], ")"}], "3"]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{"3", " ", "x"}], "+", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox["x", "2"]}], "2"], "-", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "3"]}], "4"], "+", 
   FractionBox[
    RowBox[{"21", " ", 
     SuperscriptBox["x", "4"]}], "8"], "-", 
   FractionBox[
    RowBox[{"73", " ", 
     SuperscriptBox["x", "5"]}], "80"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, -3, 
    Rational[9, 2], 
    Rational[-17, 4], 
    Rational[21, 8], 
    Rational[-73, 80]}, 0, 6, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
In Reihenentwicklungen kann man keine Werte einsetzen. Das macht mathematisch \
ja auch wenig Sinn, denn eine Reihenentwicklung beschreibt ja das Aussehen \
einer Funktion in der N\[ADoubleDot]he eines Punkts. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"f", "/.", 
  RowBox[{"x", "\[Rule]", "1"}]}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 1, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120]}, 1, 7, 1],
  Editable->False]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"ssdn\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Attempt to evaluate a series at the number \\!\\(1\\). \
Returning Indeterminate.\"\>"}]], "Message", "MSG"],

Cell[BoxData["Indeterminate"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit ",
 StyleBox["Norma",
  FontSlant->"Italic"],
 StyleBox["l ",
  FontSlant->"Italic"],
 "kann man aber den polynomialen Teil der Reihe extrahieren und weiter \
verarbeiten. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "=", 
  RowBox[{"Normal", "[", "f", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "-", 
  FractionBox[
   SuperscriptBox["x", "3"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "120"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "/.", 
  RowBox[{"x", "\[Rule]", "1"}]}]], "Input"],

Cell[BoxData[
 FractionBox["101", "120"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "f1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "\[Pi]"}], ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dashed"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmnk8VN//x61F1pmxU6JI0p4+JTmXUNmVUJFShESLpJSyZEtlKdkiIlmy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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwVl3k8VN8bx+2z2CUklSR7kTZJzk30lSWSipIkZcmWJKlslWwVEkIlIcpO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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{(-2) Pi, 2 Pi}, {-3.834094800846218, 
     3.833996379901964}}, {{-6.283185307179586, 
    6.283185307179586}, {-3.834094800846218, 3.833996379901964}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "=", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "-", 
  FractionBox[
   SuperscriptBox["x", "3"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "120"], "-", 
  FractionBox[
   SuperscriptBox["x", "7"], "5040"], "+", 
  FractionBox[
   SuperscriptBox["x", "9"], "362880"], "-", 
  FractionBox[
   SuperscriptBox["x", "11"], "39916800"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "f1", ",", "f2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "\[Pi]"}], ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dotted", ",", "Dashed"}], "}"}]}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmnk8VN//x61F1pmxU6JI0p4+JTmXUNmVUJFShESLpJSyZEtlKdkiIlmy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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwVl3k8VN8bx+2z2JeQVJLsRdokOTfRV5ZIKkqSlCVbkqSyVbJVSAiVhCg7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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwtmnk0Vd/7x80RGa47kU8hidIgkiT7GJJkqigNhhQhSZJkyJCE0KCkksxJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{(-2) Pi, 2 Pi}, {-3.8754327942879576`, 
     3.875314400562414}}, {{-6.283185307179586, 
    6.283185307179586}, {-3.8754327942879576`, 3.875314400562414}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mit Potenzreihen rechnen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "4"]}], "24"], "-", 
   FractionBox[
    RowBox[{"97", " ", 
     SuperscriptBox["x", "6"]}], "720"], "-", 
   FractionBox[
    RowBox[{"2063", " ", 
     SuperscriptBox["x", "8"]}], "40320"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[-7, 24], 0, 
    Rational[-97, 720], 0, 
    Rational[-2063, 40320]}, 0, 10, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"Tan", "[", "x", "]"}], "]"}], "+", 
  SuperscriptBox[
   RowBox[{"O", "[", 
    RowBox[{"x", ",", "\[Pi]"}], "]"}], "8"]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[Pi]"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["7", "24"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[Pi]"}], ")"}], "4"]}], "-", 
   RowBox[{
    FractionBox["97", "720"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[Pi]"}], ")"}], "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "\[Pi]"}], "]"}], "8"],
    SeriesData[$CellContext`x, Pi, {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, Pi, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[-7, 24], 0, 
    Rational[-97, 720]}, 0, 8, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"3", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"5", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"], "+", 
  SuperscriptBox[
   RowBox[{"O", "[", 
    RowBox[{"x", ",", "1"}], "]"}], "9"]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"9", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}]}], "-", 
   RowBox[{"26", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "-", 
   RowBox[{"27", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "5"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "9"],
    SeriesData[$CellContext`x, 1, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {-9, -26, -27, -10, 1, 1}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Normal"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "9"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "-", 
  RowBox[{"26", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "-", 
  RowBox[{"27", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "-", 
  RowBox[{"10", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "5"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "6"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"4", "x"}]}]]}], ";"}], "\n", 
 RowBox[{"s1", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"28", " ", 
    SuperscriptBox["x", "5"]}], "-", 
   RowBox[{"84", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"264", " ", 
    SuperscriptBox["x", "7"]}], "-", 
   RowBox[{"858", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 2, -2, 4, -10, 28, -84, 264, -858}, 0, 9, 
   1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6]}, 1, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "+", "s2"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"3", " ", "x"}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   FractionBox[
    RowBox[{"25", " ", 
     SuperscriptBox["x", "3"]}], "6"], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 3, -2, 
    Rational[25, 6], -10}, 0, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", " ", "s2"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "4"]}], "3"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 2, 
    Rational[-11, 6], 
    Rational[13, 3]}, 1, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", 
      RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "7"], "30"], "+", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["x", "9"]}], "756"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 7, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 30], 0, 
    Rational[29, 756]}, 7, 10, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["s", "2"]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "14"], "900"], "+", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["x", "16"]}], "11340"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "17"],
    SeriesData[$CellContext`x, 0, {}, 14, 17, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 900], 0, 
    Rational[29, 11340]}, 14, 17, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], "s1"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "-", 
   RowBox[{"4", " ", "x"}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"40", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"140", " ", 
    SuperscriptBox["x", "4"]}], "-", 
   RowBox[{"504", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"1848", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   RowBox[{"6864", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "8"],
    SeriesData[$CellContext`x, 0, {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, -4, 12, -40, 140, -504, 1848, -6864}, 0, 
   8, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], "f"}]], "Input"],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox[
   RowBox[{"1", "+", 
    RowBox[{"4", " ", "x"}]}]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "-", 
   RowBox[{"4", " ", "x"}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"40", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"140", " ", 
    SuperscriptBox["x", "4"]}], "-", 
   RowBox[{"504", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"1848", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   RowBox[{"6864", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"25740", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, -4, 12, -40, 140, -504, 1848, -6864, 
   25740}, 0, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"s1", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "3"], "+", 
   SuperscriptBox["x", "4"], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   FractionBox[
    RowBox[{"14", " ", 
     SuperscriptBox["x", "6"]}], "3"], "-", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"33", " ", 
    SuperscriptBox["x", "8"]}], "-", 
   FractionBox[
    RowBox[{"286", " ", 
     SuperscriptBox["x", "9"]}], "3"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[-2, 3], 1, -2, 
    Rational[14, 3], -12, 33, 
    Rational[-286, 3]}, 1, 10, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"f", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"4", " ", "x"}]}], ")"}], 
   RowBox[{"3", "/", "2"}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "6"], "+", "x", "+", 
   SuperscriptBox["x", "2"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "3"], "+", 
   SuperscriptBox["x", "4"], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   FractionBox[
    RowBox[{"14", " ", 
     SuperscriptBox["x", "6"]}], "3"], "-", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"33", " ", 
    SuperscriptBox["x", "8"]}], "-", 
   FractionBox[
    RowBox[{"286", " ", 
     SuperscriptBox["x", "9"]}], "3"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 6], 1, 1, 
    Rational[-2, 3], 1, -2, 
    Rational[14, 3], -12, 33, 
    Rational[-286, 3]}, 0, 10, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "+", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"3", " ", "x"}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   FractionBox[
    RowBox[{"23", " ", 
     SuperscriptBox["x", "3"]}], "6"], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   FractionBox[
    RowBox[{"3361", " ", 
     SuperscriptBox["x", "5"]}], "120"], "-", 
   RowBox[{"84", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   FractionBox[
    RowBox[{"1330559", " ", 
     SuperscriptBox["x", "7"]}], "5040"], "-", 
   RowBox[{"858", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 3, -2, 
    Rational[23, 6], -10, 
    Rational[3361, 120], -84, 
    Rational[1330559, 5040], -858}, 0, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "-", "f"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "x", "]"}], "9"],
  SeriesData[$CellContext`x, 0, {}, 9, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  FractionBox["1", "s1"]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"70", " ", 
    SuperscriptBox["x", "4"]}], "-", 
   RowBox[{"252", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"924", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   RowBox[{"3432", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"12870", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, -2, 6, -20, 70, -252, 924, -3432, 12870}, 
   0, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", " ", "s2"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1}, 0, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["1", "f"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"70", " ", 
    SuperscriptBox["x", "4"]}], "-", 
   RowBox[{"252", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"924", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   RowBox[{"3432", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"12870", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, -2, 6, -20, 70, -252, 924, -3432, 12870}, 
   0, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["s1", 
    RowBox[{"Cos", "[", "x", "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   FractionBox[
    RowBox[{"259", " ", 
     SuperscriptBox["x", "4"]}], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 2, 
    Rational[-3, 2], 5, 
    Rational[-259, 24]}, 0, 5, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"InverseSeries", "[", 
   RowBox[{"s1", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ComposeSeries",
  FontWeight->"Bold"],
 "[f,g] funktioniert nur, wenn die beiden Reihen \"verkettet\" sind, d.h. \
wenn der konstante Term in g mit dem Expansionspunkt von f \
\[UDoubleDot]bereinstimmt. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";", 
  RowBox[{"sf", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Tan", "[", "x", "]"}]}], ";", 
  RowBox[{"sg", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[17, 315]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{"sf", ",", "sg"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "40"], "-", 
   FractionBox[
    RowBox[{"55", " ", 
     SuperscriptBox["x", "7"]}], "1008"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[-1, 40], 0, 
    Rational[-55, 1008]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "40"], "-", 
   FractionBox[
    RowBox[{"55", " ", 
     SuperscriptBox["x", "7"]}], "1008"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[-1, 40], 0, 
    Rational[-55, 1008]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invsf", "=", 
  RowBox[{"InverseSeries", "[", 
   RowBox[{"sf", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112]}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{"sf", ",", "invsf"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1}, 1, 9, 1],
  Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Differentiation", "Section"],

Cell[CellGroupData[{

Cell["Ableitungen einstelliger Funktionen ", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "2"], "+", "x"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "2"], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"6", " ", "x"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", "A", ")"}], " "}], TraditionalForm]]],
 "wird intern sofort in die Notation ",
 StyleBox["D[A,x] ",
  FontWeight->"Bold"],
 "umgesetzt."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "2"], "+", "x"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", "x"], 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", "1"}], 
    RowBox[{
     SuperscriptBox["x", "3"], "-", "1"}]]}], " ", "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "x"}], "+", 
      SuperscriptBox["x", "3"]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "3"]}], ")"}], "2"]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"Sin", "[", 
   RowBox[{"Cos", "[", "x", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Cos", "[", 
    RowBox[{"Cos", "[", "x", "]"}], "]"}]}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Ist im Ausdruck ",
 StyleBox["A",
  FontWeight->"Bold"],
 " eine Funktion ",
 StyleBox["f",
  FontWeight->"Bold"],
 " enthalten, deren Ableitung nicht bekannt ist, so wird ",
 StyleBox["D[A,x]",
  FontWeight->"Bold"],
 " in einen Ausdruck umgeformt, der ",
 StyleBox["f",
  FontWeight->"Bold"],
 " und ",
 StyleBox["f'",
  FontWeight->"Bold"],
 " (FullForm: ",
 StyleBox["Derivative[1][f]",
  FontWeight->"Bold"],
 ") etc. enth\[ADoubleDot]lt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"g", "[", "x", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["g", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", "x"], 
   FractionBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"g", "[", "x", "]"}]]}], " ", "//", "Together"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", "x", "]"}], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}], "-", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], " ", 
    RowBox[{
     SuperscriptBox["g", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], 
  SuperscriptBox[
   RowBox[{"g", "[", "x", "]"}], "2"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{"g", "[", "x", "]"}], "]"}], " ", 
  RowBox[{
   SuperscriptBox["g", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", "x"}], "]"}]}], ";"}]], "Input",
 PageWidth->Infinity,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontColor->GrayLevel[0],
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"f", "[", "x", "]"}]}], ")"}]}], ")"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "4"], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"a", " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "x", ",", "x", ",", "x"}]], " ", 
  RowBox[{"f", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "4"], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"a", " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}]], 
  RowBox[{"f", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "4"], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"a", " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "''''"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "4"], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"a", " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "'"}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{"Derivative", "[", "1", "]"}], "[", "g", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "'"}], ",", 
   RowBox[{"Sqrt", "'"}], ",", 
   RowBox[{"Log", "'"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "#1", "]"}], "&"}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["#1"]}]], "&"}], ",", 
   RowBox[{
    FractionBox["1", "#1"], "&"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Achtung, die folgende Definition werden Sie nicht so schnell \
wieder los.",
  FontColor->RGBColor[1, 0, 0]],
 " Unklar bleibt, wo sie von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gespeichert wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "2"]}], "+", "5"}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"y", ",", "y"}]], 
  RowBox[{"f", "[", "y", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"6", " ", "y", " ", 
  RowBox[{
   SuperscriptBox["g", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{"5", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"]}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "y", "]"}], ",", "y", ",", "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"6", " ", "y", " ", 
  RowBox[{
   SuperscriptBox["g", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{"5", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"]}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"6", " ", "y", " ", 
  RowBox[{
   SuperscriptBox["g", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{"5", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"]}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "\[CapitalUDoubleDot]brigens hat die Definition von f' keinen Einfluss auf \
f'', denn f' ist als ",
 StyleBox["Derivative[1][f] ",
  FontWeight->"Bold"],
 "codiert, f'' dagegen als ",
 StyleBox["Derivative[2][f]",
  FontWeight->"Bold"],
 ". Das Muster der Definition passt also nicht. ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[PartialD]", 
    RowBox[{"y", ",", "y"}]], 
   RowBox[{"f", "[", "y", "]"}]}]],
  CellChangeTimes:>{3.35115476742904*^9}],
 "dagegen ist als ",
 StyleBox["D[f[y],y,y]",
  FontWeight->"Bold"],
 " codiert."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "''"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", "\[Prime]\[Prime]",
   MultilineFunction->None], "[", "x", "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ableitungen mehrstelliger Funktionen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "x"}], "]"}], ",", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "3"]}], ")"}], "4"]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "3"]}], ")"}], "3"]}], ",", 
   RowBox[{"8", " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "3"]}], ")"}], "3"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "y"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{"12", " ", 
  SuperscriptBox["y", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "y"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{"72", " ", "x", " ", 
  SuperscriptBox["y", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"y", ",", "x"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{"72", " ", "x", " ", 
  SuperscriptBox["y", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "3"]}], ")"}], "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], " ", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", 
    RowBox[{"x", ",", "x"}]], 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"1", ",", "0", ",", "0"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "y", ",", "y", ",", "z"}]], " ", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"1", ",", "2", ",", "1"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"1", ",", "2", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Totales Differential", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"Dt", "[", "x", "]"}]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"], " ", 
     RowBox[{"Dt", "[", "y", "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"], " ", 
     RowBox[{"Dt", "[", 
      RowBox[{"y", ",", "x"}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"Dt", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "x", ",", " ", 
   RowBox[{"Constants", "\[Rule]", "y"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"8", " ", "x", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", "y", " ", 
    RowBox[{"Dt", "[", 
     RowBox[{"y", ",", "x"}], "]"}]}]}], "\[Equal]", 
  RowBox[{"2", " ", "a", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x", ",", " ", 
   RowBox[{"Constants", "\[Rule]", "a"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", "y", " ", 
    RowBox[{"Dt", "[", 
     RowBox[{"y", ",", "x", ",", 
      RowBox[{"Constants", "\[Rule]", 
       RowBox[{"{", "a", "}"}]}]}], "]"}]}]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "/:", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}], "=", "0"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", "y", " ", 
    RowBox[{"Dt", "[", 
     RowBox[{"y", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"a", ",", "Constant"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", "y", " ", 
    RowBox[{"Dt", "[", 
     RowBox[{"y", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ein Beispiel", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", " ", "/:", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"y", ",", "x"}], "]"}], "=", "k"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gl", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "16"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gldt", "=", 
  RowBox[{"Dt", "[", 
   RowBox[{"gl", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", "k", " ", "y"}]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"{", 
   RowBox[{"gl", ",", "gldt"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "16"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", 
     RowBox[{"2", " ", "k", " ", "y"}]}], "\[Equal]", "0"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqns", ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"k", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["x", "y"]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqns", ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"16", "-", 
        SuperscriptBox["y", "2"]}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{"16", "-", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "&&", 
  RowBox[{"y", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"k", "\[Equal]", 
   RowBox[{"-", 
    FractionBox["x", "y"]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"eqns", ",", "k", ",", "y"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["x", 
       SqrtBox[
        RowBox[{"16", "-", 
         SuperscriptBox["x", "2"]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{"16", "-", 
        SuperscriptBox["x", "2"]}]]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"k", "/.", 
       RowBox[{
       "lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "]"}],
      ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "6"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", "gl", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtWGk4lW243dh72+P77owNikwlCmXoU7xPvlLGojIm9KUSmRIiZWySiEKG
KJIiEmUonkdKknlMpMylZBu22KbTOddZf+7rvta1fty/7rXW+mMeFs6CJBKJ
KkAi/e88rZDeHBiDI9L/YSUwfOHw6sQVHE1ot/5JZ0uC6x5nbBxDcYSLnXLI
j5MAdUqBf2yCcDS19Pp3rYwEMLsXv830LI72VJ6pTjEVB9HWmc0G7jiCBbf8
9X6JgSaR5x7ABUfSWsJrK6LFgMWV+pxtDjhitzk01Q+Igrhd3YabbXGUm/z9
QmGcKGib/z6ieBhHJ5hSV6T3igJLT7L8amMc2RHbO6KKRUDCJpE3ogY4WnOj
s0LGRwR8GpR2ZO/CUWmAfI/NNhFgZ7MjhaSNow9Po/pFS1eAFFFDHb46joxk
HsTsu7QC9NZbfppSwZEuCtl6fe8K4KjvLTYii6PauVvg9RcOOK78+EY9hqOU
VkklfB0HPBx6uek9HUddGkpX4wdwMJz2tgaRcYQ0KO35UThwEftGLuJjaMhX
NPffHxhwX5QIShrG0E0jK7y9jA3yi+XX3O7DkIwXGN/owwZcr62lUT0YGt/f
fNFIlQ28h015wS0Yuh2zKujxExbwaww/c7ICQ0oTr/RnCpngxk/fzukSDEWL
3+DO+jDBA2GXXaGFGMIfL0SFaDNBHWEqnpqNIYe+4TvDiAFkn4mXt8RiqO5b
yoXAATrYXie8wTEKQxHeqp6y+XRg+n0uZuwKhmb0lyeGA+nAX6b3OC0IQ9Ym
BY7pK+mgISaLpXcSQ6vUIx6029PAYG6i70cnDB34RHx2VqeBuZrr36yPYKhr
AyuxgUID8gIeRWfNMWSs1quHFQiDAC/tI493YKj8QmhOPEcYKFrU5IhxMJS8
vvi81DgF7HQvE3/AwJAZL7nqcj0FmF/PvaRKwVC11b/P/XIp4MKbmINGfDaa
FZC1/upKAS1bbeYvDbLR4cMS71y4ZBAkOmr0s4SNDMWENYfZZBCr2lPkX8hG
+7b/VjebEgLZxg3rqHls1NlseYfTJQRawp5PymSwkQNx0CvloRDYOB2QZBnF
Ru81pdcn6wuBtjbmaKUTG509q2hTfF0QhBx/UZFzhI0+RCjGO/gKgi3TR+Pu
WLHRk1tJbcQxQXBV9PlOF1M2ElI10snUEQS6FtbRnH/YyFWrxbpvTABkNWZq
OHDY6OXuqkFnewFw0MGMbshko0NWvhnSJgKANP7ny1YqGyXwAlKEdggAW8z4
CnWBhXaq9vjvXSUAcNOJrqcjLNS545lNbicJ+NfqXlqoYKF9snZJx+xIQMF2
5OBwKQv9k1WZ5WNCAi0/YjY2FbFQnYt6wCNdElChDzZnPGEhWZJwxBkZEujb
e13eOJ6FeNWXQU/DMmH0ruPD3TMsZN+39UIlb4lYizzEtKVYyLHOJ+yLyyJR
J6LpoyPJQl5WTkjy4CIR4Mxv1RVhoYF42/iAnYtEByMibjeNhVb6kUVL8EUi
5nCSiMU0E11q9BgjlywQQj/fcs7UMVFrd0xqCL5A/BBfzc64wETvSkhmep18
IvHUV7csPyZqmf03u/QtnzB4lVn32JuJ9q05uNH8OZ944Kh649kpJpoafXG6
NYpPHMnZzaw4xERuMgG/pAz4RCPwoHepMJG/IuvX5VdzxAvXtxT8CwMtk051
LRfPEttl3NWzOhkoxqPbRO3RLFHWJmmv28JAIdXKTf7xswTSdS1yfc9A8yQn
3PzcLFGLi/xXU8BA92M4XyU1ZolvhQ4o5DIDbSjfPFD34g/BWOAHTKsy0ELH
jmzXmhki6llmVuQmBqr9emFGo2yG4DibtcgqMNBiymohTu4MId5wX8l8NQOl
1+i+5EfPEDLp+z49JTPQkOs97XvWM4Tm7njNk110VO5+uGHhF49wvKHO7Qql
o4DmKYGN63lEQFHs5fogOiqyy84vEucRd3qmpCr96cjrcNUGUwaPqFV5aZjt
TkdTxzzX3p+aJrbV62T42tJRDsevuKV6mqBiuy1Ft9LR1zKBDUYe00RutOVr
kz4a0t+wp4RUM0XMxgZehQQNme2u4XTcniRGpCpHDXRoaFTtQK1A5CTRkUU1
bdCgIc/vbl5aIZNEYdmtFV+UaGjl7hSjsjOThHv/oyS+KA3F1XgEb9o7SQyo
t+VqfhdGTmkZyunzE0RDk0pzToww6isf7gg+PUFkYL2rEvuoqMMkK8jfnkvE
2hHC//RQUalNFyXtMJcIzU6f7uqgovxW3QMfTbnEMf3/GtfUUdENshpDU49L
yPp+D097SUX1y2dVTKS5xIMvk+NZkVQ0kdRgS343TqTnCle/0KSie10g71nX
byLFSN279RoFRT0uTzghPUaEujn5KxmSUb/6Ro8GnVEiUOiJn/eYIHKwUnxv
f36EcApulO/IFkB1uz9Pim4eIu6UDyWmnCahuoLSSr70AFH2dSMrV3YJXvPO
HHES6yPkOED/0L15uPOkRkheai/xfNPV0/0Ds/BSdqHAUXI38fVdgYyW1gx8
q1i+XyS/kxhSubMVvpyCj7xaZJ6WtBErLj7W2iIwASPXfQkOzGgmVLTGVR5O
/YJcvxif9pJ6Imz3WFOp/wjcF9YUffTbe0L8UF6MjWQ/DLtL0Txg8IZ4PvMO
r5H/DN0Wt2K8vWXEw+6hqB/hDTBQpe1gW2weYW8uVdT9XxGkygQ8Hzx+myhl
BLa/OVdIPNuzTe2xbxzU7BdYF2LdSJS/Xm67czIfynFfzem86SJoza1CvQOl
0DCjq97Mup8QUJTsMb72Bu4xFRHivRghAttHq7tlamC0Q2ewWvEv4ue6aFs/
v3r43mwt+4DIBCG28WZqystmOLZe/GJL0hRRmhd3xyCxDZ7zUXaKlpghYPfc
rYqrnbCzh2NxomaWuNucTNbv+wwdz+8cETaZJzYnV78gb+mFVcra16soS4S8
o725/fI3qEh//T1zHwk80ZFlhYz2w7WvXfdQrgqAzV5pe6qmByGJL/jYu18Q
bL2Xo+52fAT+MS8/+k6BDDz1viw0//4BuzUc1iiEU8DT8+JkxxVj8MScJh5x
jQIeic61Za4bg9xyltDQTQrg0S37J5THIHlv2WjmXQo4UvGnJ9NgDG6xES+T
z6cAL0/nSx4XxmBw0Edr+c8U8ND1ssL9H2NQsVo7Xk6NCvT0c1Le1/6Gnlac
FbI9VJB2bW940GEuPJatmqTQRwW76J6TTUe48PCcmZzSMBXkJXxwVTrOhTrJ
UZpqXCpQjqxM/uHNhZSvDFs9sjBQqL7+4lEMFyadoGTYqgiDip5GufX1XPj2
HF8j7oIwyPi1I0LPaAKuuj1oTV5LA+1P1AqoVpNwe5i0hI8sDYw2SeimOE5C
S2/b1oENNHAkQdla5/QkjD3QZFq1lQb22HzzjQmahCz2a/3QfTQQpmI6/zBz
Ei5FxKmQfGjAazqwMmx6Eg766ZMWamkg+xgz/lLyFBQ8GVTu2kQDoJB+wSBr
CspYlgR0t9OA3Pw/EisLpqC9xhZe2Tca0MwcK+6unoId3FWj52f++oihpInh
ySn4wWWi9c96Okhsy1+SNp2GeXbpj6b86aBQIXgNZPCgRqccn3qRDgz+SyvX
kuDBVxaPTFaH0cEQijAuW8+DNYZ5EyCKDrY9O3xlaDsPDmi/3nHzPh3YSiHx
xpM8uFLsU+PGWjrQGeVIk2t4MLQOn7VfwwCPtq84XRA7A2n74oy8ZBggvbs0
4VPaDIyukkgNV2AAtI8iiz+dgSlla/VzVP/uO3hNT97PwOJs5Ruz/zLATs5l
0/TFGfgrfK9MnBsDtI8vfHjg9gda6V7aV1POAOUrW3UlrGdhD28Yf/OGAZh5
pxblTs7CY3lmna/eM4D+U3GLPb6z0E163Yn8Zgaw/OrrU3V7FoYKlIfFDzGA
u9xM6/OWWZj3jl9xnM0E9+ex1msWc5Bs5qspYM8E/R8LT6f+x4fXqb0LfCcm
uPcT1YSf40Mc7nk7fYIJpKj+Py9f4cPVauIHv3syQZZ/VFpPDh+qihR5NoYz
QV7++4F2Hh/adkzkpOYyQXbq5+e7o+dhwdEzsjoLTPB1q1Lfxc8L8NgL7tp0
ARY4zu9sJCYXoBjLZxVVmAW0b7j1bmYsQt/SAE7LChYYvzEI43QWoY7Y1SWX
DSwQ9jbyT0LqInzz4cHnuxYscO7XlaeSZ5bgWRnFjmUrFqAVcRpnryxBeb/H
zc72LFBQ7y4pkrEEL8s/q1E/9Vfv0n2U27UEjS+Vv/wQxAK9TMfIs0bLsE3j
U+xcNgt0W2WRCtaQUESk3U2HPBb4dWDx/EplEtLq7732rpAF1LI6MzJ0SCgx
eij4VgULPMk/a7HBloTsRyfdldpYoDmX1zWdRELDaWxjm2UWkDnoWqIjL4Bm
Gf8KlR5mg09rAzS4toJI5Dd2+40tG4Q9ia794C6IlJs/y9c5sEHgjuSfXaGC
6GiCt8FXFzY472w8ej9HEFXJPbhGucgGIuvENo8vC6KbOwU4FllscD9nOjey
SAhlS9en2+WwwfxirLNNnRCqFLyr7vyMDS5K+bZ5DQqh6Rq1g/5/c0K5zCfd
a+JkZHvYMf5eAxuYZIyMhASSkYI7lPo585cv9r2x15qC9Mwjn07Ps4GsuKnO
vXMUZK1hpbdEwoCviiXHMY6CrvN/O6xgYqCvOr1PtYmCuJfXZWhLY0Dd8z5x
YD8VMU6PbtsljwHe0EW035OK5ExfvjVSwkBc6AG3lltUZClqNmy/DQOvE5ID
PP7+5ddpQUrhezFAKo6uP3tCGHWEGpZFmWBARS9S5U+kMBp3FjdOMMeAx59B
8rrnwkhW5anbEzsMeK/TuO5CoqErJT35TR4YKH9TlxL5kIYsmndorU3EwEic
WqK7JAMlWMjNx6ZioNJp6aOOGQP1tDIQLQMDovaG6Xv/+rATHV2G008xQDFv
d7fkM1Bgt5/9xyoMnDMZsv08xUToiIPsrg8YmPg+qPaPFgtRew1GXjZgQLw2
ffJQAAvFfBP3etCFgUz9iAExGhtlDhWGnx/HQCwRqrFrJ4Z+nEg2HJ/GwHGp
yElGNIa2fA/FnPl/73V+mWc/iKGSUfPEAxQcJOwx/qGUgKNF13/sqxk4CNvY
zORO40h/TEZ2JwcHX3iPg39t4qD68fGcDWtw4GPnZvc9hoNEvDo9U2Vw0MXr
EM2s5iDryQpNUUUc0Lv9bGyXOKh/OgouqeFA875WuI7PCjQzp9zaboCDC6I2
OjIXRdCOQNFEYxMcXByk7Z97L4KCF/hHKs1xcI+spawjLooYyx+Gc4/g4BBn
NljklSjaH1yQI3sMB6kN5FX7xcTQbYG7noknceDWsuos8BZD0uRT/DBvHISY
cpYYeuLoeMR+OOeHg50up1K4ueLoCVU73CMIB9ztXa8fy0qg8SvrDIdCceBU
Nls8mSaBNOhUzO4qDqoukx88VJBE56+PtTT9zcHFRcGpqEgSHQpU0A2KwcH/
9wnofwD7vMlE
      "]]}}, GraphicsComplexBox[CompressedData["
1:eJxdmQlwVtUVx0NAFuHLY6yFSVQoyyCtIsUQGobCvRako9KyGGztaEuhkaUE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    "], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1fN/EAgYBvCtZdu1lm3b5rJrmcvmlrds27ZtHOquzld38VB3dahjfffp
h+/z/gXP84aEhYcODAwICLglYm4sgohNHOISj/gkICGJSEwSkpKM5KQgJalI
TRrSko70ZCAjmchMFrISTDZCyE4OcpKL3OQhL/nITwEKUojCFKEoxShOCUpS
itKUoSzlKE8FKlKJylShKtWoTg1qUova1KEu9ahPAxrSiMY0oSnNCKU5LWhJ
K1rThra0oz0d6EgnOtOFroTRje70oCe96E0f+tKP/gxgIOEMYjBDGMowhjOC
kYxiNGMYyzjGM4GJTGIyEUQyhalMYzozmMksoohmNnOYyzzms4CFLGIxS1jK
MpazgpWsYjVrWMs61rOBjWxiM1vYyja2s4Od7GI3e9jLPvZzgIMc4jBHOMox
jnOCk5ziNGc4yznOc4GLXOIyV7jKNa5zg5vc4gM+5CM+5jZ3+IRPucs9PuNz
vuBLvuJrvuFb7vOA7/iehzziMU94yjN+4Ed+4mee84Jf+JWXvOI3fucP/uQ1
b/iLv/mHf/mP/3lLTPkDiUUQsYlDXOIRnwQkJBGJSUJSkpGcFKQkFalJQ1rS
kZ4MZCQTmclCVoLJRgjZyUFOcpGbPOQlH/kpQEEKUZgiFKUYxSlBSUpRmjKU
pRzlqUBFKlGZKlSlGtWpQU1qUZs61KUe9WlAQxrRmCY0pRmhNKcFLWlFa9rQ
lna0pwMd6URnutCVMLrRnR70pBe96UNf+tGfAcSMdziDGMwQhjKM4YxgJKMY
zRjGMo7xTGAik5hMBJFMYSrTmM4MZjKLKKKZzRzmMo/5LGAhi1jMEpayjOWs
YCWrWM0a1rKO9WxgI5vYzBa2so3t7GAnu9jNHvayj/0c4CCHOMwRjnKM45zg
JKc4zRnOco7zXOAil7jMFa5yjevc4Gbg+3/5DjiV1Hw=
         "]],
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], "\[Equal]", "16"}]],
       Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 16, 
        "Tooltip"]& ]}}]},
  AspectRatio->Automatic,
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-4, 4}, {-6, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integration", "Section"],

Cell[CellGroupData[{

Cell["Einf\[UDoubleDot]hrung", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "2", "3"], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 FractionBox["271", "12"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "a", "b"], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["a", "3"], "3"]}], "-", 
  FractionBox[
   SuperscriptBox["a", "4"], "4"], "+", 
  FractionBox[
   SuperscriptBox["b", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["b", "4"], "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["a", "3"], "3"]}], "-", 
  FractionBox[
   SuperscriptBox["a", "4"], "4"], "+", 
  FractionBox[
   SuperscriptBox["b", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["b", "4"], "4"]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrale rationaler Funktionen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "5"], "-", 
     RowBox[{"2", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"2", 
      SuperscriptBox["x", "3"]}], "-", "x", "+", "1"}], 
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "x"]}], "-", 
  RowBox[{"2", " ", "x"}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  RowBox[{"ArcTan", "[", "x", "]"}], "-", 
  RowBox[{"Log", "[", "x", "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["x", "n"], "-", 
        RowBox[{"2", "x"}], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}]]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "10"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "-", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"], "-", 
       RowBox[{"2", " ", "x"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
    RowBox[{
     FractionBox["1", "10"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SqrtBox["5"], "+", 
       RowBox[{"2", " ", "x"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"RootSum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "#1", "+", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", "#1"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", "#1"}], "]"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", "#1"}], "]"}], " ", 
           SuperscriptBox["#1", "2"]}]}], 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "#1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "//", "Normal"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}]]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "10"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "-", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"], "-", 
       RowBox[{"2", " ", "x"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
    RowBox[{
     FractionBox["1", "10"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SqrtBox["5"], "+", 
       RowBox[{"2", " ", "x"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"x", "-", 
              RowBox[{"Root", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "#1", "+", 
                  SuperscriptBox["#1", "2"], "+", 
                  SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], 
             "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"x", "-", 
              RowBox[{"Root", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "#1", "+", 
                  SuperscriptBox["#1", "2"], "+", 
                  SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], 
             "]"}], " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", "#1", "+", 
                SuperscriptBox["#1", "2"], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "+", 
           
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"x", "-", 
              RowBox[{"Root", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "#1", "+", 
                  SuperscriptBox["#1", "2"], "+", 
                  SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], 
             "]"}], " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
             "2"]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", "#1", "+", 
                SuperscriptBox["#1", "2"], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "+", 
           
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
             "2"]}]}], ")"}]}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], 
            "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], 
            "]"}], " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", "#1", "+", 
               SuperscriptBox["#1", "2"], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], 
            "]"}], " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", "#1", "+", 
                SuperscriptBox["#1", "2"], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], 
            "2"]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", "#1", "+", 
               SuperscriptBox["#1", "2"], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", "#1", "+", 
                SuperscriptBox["#1", "2"], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], 
            "2"]}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], 
            "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], 
            "]"}], " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", "#1", "+", 
               SuperscriptBox["#1", "2"], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"x", "-", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", "#1", "+", 
                 SuperscriptBox["#1", "2"], "+", 
                 SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], 
            "]"}], " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", "#1", "+", 
                SuperscriptBox["#1", "2"], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], 
            "2"]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", "#1", "+", 
               SuperscriptBox["#1", "2"], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", "#1", "+", 
                SuperscriptBox["#1", "2"], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], 
            "2"]}]}], ")"}]}]}], ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]}], 
     RowBox[{"x", "+", 
      SqrtBox["x"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox["x", 
    RowBox[{"1", "/", "3"}]]}], "-", 
  RowBox[{"2", " ", 
   SqrtBox["3"], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", 
        RowBox[{"1", "/", "6"}]]}]}], 
     SqrtBox["3"]], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", 
      RowBox[{"1", "/", "6"}]]}], "]"}]}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "6"}]], "+", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "3"}]]}], "]"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox["x"]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i3", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "n"], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "n"], ",", "1", ",", 
    RowBox[{"1", "+", 
     FractionBox["1", "n"]}], ",", 
    RowBox[{"-", 
     SuperscriptBox["x", "n"]}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"i3", "/.", 
     RowBox[{"n", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"i3", "/.", 
     RowBox[{"n", "\[Rule]", "3"}]}], "]"}], ",", 
   RowBox[{"i4", "=", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["x", "3"], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcTan", "[", "x", "]"}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      FractionBox["1", "3"], ",", "1", ",", 
      FractionBox["4", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox["x", "3"]}]}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}], 
     SqrtBox["3"]], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x", "+", 
       SuperscriptBox["x", "2"]}], "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FunctionExpand", "[", 
   RowBox[{"i3", "/.", 
    RowBox[{"n", "\[Rule]", "3"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"i5", "=", 
  RowBox[{"PowerExpand", "[", "%", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["x", "3"], ")"}], 
    RowBox[{"2", "/", "3"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["x", "3"], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "]"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"1", "/", "3"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["x", "3"], ")"}], 
          RowBox[{"1", "/", "3"}]]}]}], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"2", "/", "3"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["x", "3"], ")"}], 
          RowBox[{"1", "/", "3"}]]}]}], "]"}]}]}], ")"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]], " ", "x"}]}], "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", "/", "3"}]], " ", "x"}]}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i4", ",", "i5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdzn8w1Hkcx/H1M+0Ky3X00wqJUO76nXp/Lv1yqz2XNrVbapfjKiVqtaVY
cVOrZHN7JdG2TSpNdKa6ZgtbahHLsjtjapCf68d+v+6wNjm/7uPeM695z+O/
pxs/bvcv5hQK5Se8mZ+fzLcOiEraXONkt6Fjn075XscICWfsh0MuYaFvQaec
rixPYzCOwNy4/Gj5Up0y/02mqxXjLHxHpP7OG9EqYzcJjo+6iuGyasdwR5ZW
qRv/VTroegsYy+TTnZWNylnNnV4DroXAkM91NqxqUMprZPGEqwLyqr6dI1lS
oyx+Km6O9a+B2Sytao27QhkDjbfIBB2ImOdvDhUh5Qm9d9fz4k8Qa77zn1Nl
L4Hy/7VDwUhZmvpIFVDd0r3a1rVDX3Pxo7vrq+GaQ62P/HAXnPprfuiG5Ebg
N+9RWqh74MLrs/z6+iaIV6Xz47wMIOSmWfslNEPJSdswl+ABaNKo8+dtbgN5
0jHDyvBB8O2eP0yJ6YCLsomfR8ghOC5Kd7mq6wSKrh2VnjPCJjrH3dO6G5ae
jhbu8THBuxttZdlueug23dxLK/sCQcmJGrl5D/yoP3ohO/4rUMZpJ0XaHmB1
S5YvXvwv2J7xdJ8j6gXDO76oumgcWC9a2H60PvCnNy0KOjQJn9u3xkdk9gEV
TLwW4xS8uqqWX//SBzsGOKNL2BS0yiuk4vH+fvhYEWXG8TVDLYrVYzuL++HF
5fcRDJMZqt5wdGGhsR+irQTt9fXmSDTUz7VaY4DIhKQXtrkWKMLm+nBLrAFW
xCyvD+FZoivGxiB9ngE0jr40wXortPvGHpWg1gCviy/e9rWwRtrX8H30sAGS
zHxC1a3WKHBXFpPtQgC15dzOE89nITv/RIlmPQH6B25S2XkbVMWdFrjsJUC6
bJ6lgj0b5apLDhjjCZDkRlfxGFS0XZXrni8mgCM9WG/bS0UnU3o0rXcI+Lq1
YExWTkNSqb3n5DMCuvRbhBWXbJHhimS1YyUB9zYFLKjjzUHCgUVRzh8JKPpN
QI/xs0PZo2s1f/QScIkdybQw2aFAo77ggYmA1S3ywkt19miJy+lSlQUJOd63
i+qYDsiUkFk5YU9CypvMHKbCAa0beuO4fSEJuxawC2o86IhQPW5I9CLhhxNV
XLqYjljp4WMBASTIFvI91CY6Gnwp9KRtJMHj3cMbLK4j+jv3APdeEAkSvwof
bbkj6rzyOU/MJCHaaNn4wccJrck5FiwNI4FfMswQZzkhm9utQhmHhOoam7TS
CSdEbdqor+WREBvUIfmAzRM0KNTYDqWKO03YqWcir9Vh7ys6+moQO/B++loN
dm+Weshj0glZ3X0m1mJbsyWHM7HPebz3+4Qd1Oa8OWLKCfkmPz3dg90TPsg8
hu2X4hDci53RUL1fiJ3SFbeoD1v79qwgG9u7ybuyH5t/v/lJJbZ9VIbzALbo
iGzBimknpPCcUhixPTrPeAdiqw9uuzaCXc0JXRuMLRjL4Jtm+kPMwiKxs7l0
2ii2zD8y4yb2+VrqgX+xtzzcmHMfu5CxbeX4TJ/rNw9KsDM+XbCcwPanq97W
YqcmGp5MzvSJ8zUfsfM4i1OnsBPNE1v12Cn3QtnT2POTWMQwti8r1ZvCJ6Hc
uHRsGvvRwT8nZ/wfed5tBw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwdz3801Xccx/HLzY+uS67rLHbLvTpGxC12lGW8P5XEroyEJbXcW7cVS7Rr
Ij9CR5wjJqHM7khUw02j7W4o+oX8vltHqMzP6N6693t3UffKPt/98TnP8zjv
f14fW37sniP6FAolED+y5al8Q9fDyd5B4Pp/H8g4AeGcfXAp6y6P7PKj1kwO
5xh0ChvTyZbfy2MbcE6DgbOnEdkYL9G3C+wccOeN35zHlWm/KVKyL8N63XDa
HK7RyLiDgn0DzO/4ZzXjVnSJ416zpbCnf3eW0EYK9ZKckRhuF7Se3yt34HTB
URi4LI+XQbO1rD43SAYnphwnGuufQcrQyavefs+AZpvl8NJjDP7eOa9tEL2E
C+ZPnCoOTYDT41FtXvQ48Ef23qV2T4PEn24wxJyCuIdZ/FiHOaizZoRnH5mB
hpP0ECt/BQzLmipTeLNQkRw9tylcCWuD5h7GMV9DhlgX/K9cBQfkIXJdmhwo
sjHUnKQGlxTHhUu3FWD/nTBxr5MGGvUlP1B738CkpiTMpGUe3OZ2XrWQvIUv
po6nFMYtQsKviopEUELgZMEGG5v3kBqXpPUuVsLcfX56R50WxOZPLftGlMBl
PF274+slENrnVs6sUQENNFGj6g8QquvZejZYBbsUEQvrQimosNP0iWmmCoba
D+tFOOuh6cKM6cg6FTSdf3CQo9FDkbI1i/R+FQgNRGO9vfro9/rR1Z4qFQji
k5voV6ho/dZNE9V0AjYe3dAbELUCtUj6TX6xI6DPwtlE9JkB4ugVBqg9Cfiz
PqPMmWqIxi5mZ0Z/SUCynlNQ93NDVBwpWSXgE0AbTfI70WiEPnSvc+OcImCq
2rZIfMYYjQpmqnzOElC03nqFNHQl8vkRWbnlE1BwRfg4ikNDZVZNWsMyAiKK
DvTSZ2jolmY4uOYaAYs+196JW03QtvRY3eZbBExMbU9sz6YjuVaStU1KQKWX
K6snyhQ11s6zfNoJqDsnYhx1MUNtDZnB1C4CskMFPKrGDBVLhptNBghwH624
kd2zCq1st/VjDRFQ6lhW18MzR/Gx3J7NLwhIu5dXypOaoyKu36n9kwTsZoVe
67JjIIWV16B6loBtJx7vZ+QwkE3iReHAGwLEa/h23RoGUjKqdC1qAuzu1xQH
7rdAsdTikpWL+H8u7U6DrRZoVhvmsaQlQKheMdDpxESWGeUX9Clq4DcQnJx8
JjqTGWZ/nqqGji7jzGYdEy39fC7SxkgNMTv+KejEvq7se0TavFn601NsaZy1
Kxv7q7rjfyixPzK+acDBnsnvVtktMdH7c231ttiGoQWH8rDdOzopn2DveLna
++AHJjITQdUG7OlwJS8a+4Im1swZO7e/Y18i9m814kTSg22nRYXY9ApdgAs2
v2qk9hE25VWthoudfkzM2rjMRH91TPu6YduNf+/4OfaLw7QG0h0RQVv8sW+7
ubA+JfcH6IUIsNsEJ9+SFnMFuSXYd1iKEnfs7TWepVXYAb40/c3kPrZldQN2
S6V9DGku42HbE2wPVSTaQu7LKe8bwvadSLhJOkE/4fkUeTcqsPTA/jg58DWB
bXbgeirpVrX9u2Xs7sm7r0j/ByXgUBQ=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 5}, {-0.3022997919982201, 1.1892632571964894`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"i4", "-", "i5"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]], " ", "x"}]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", "/", "3"}]], " ", "x"}]}], "]"}]}], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}]}], "]"}]}], 
   ")"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptische Integrale", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"n", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Alpha]", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "\[Alpha]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"\[Alpha]", ",", "n"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i6", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "\[Alpha]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], ",", 
      FractionBox[
       RowBox[{"2", " ", "b"}], 
       RowBox[{"a", "+", "b"}]]}], "]"}], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], 
     RowBox[{"a", "+", "b"}]]]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"i6", ",", "\[Alpha]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], ",", 
      FractionBox[
       RowBox[{"2", " ", "b"}], 
       RowBox[{"a", "+", "b"}]]}], "]"}], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], 
       RowBox[{"a", "+", "b"}]], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], ",", 
      FractionBox[
       RowBox[{"2", " ", "b"}], 
       RowBox[{"a", "+", "b"}]]}], "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], 
      RowBox[{"a", "+", "b"}]]]}]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", " ", "b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{
           FractionBox["1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"\[Pi]", "-", 
             RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "]"}], "2"]}], 
       RowBox[{"a", "+", "b"}]]}]], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], 
     RowBox[{"a", "+", "b"}]]]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 SqrtBox[
  RowBox[{"a", "+", 
   RowBox[{"b", " ", 
    RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i7", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox["x", 
      RowBox[{
       SuperscriptBox["x", "3"], "+", 
       SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]], 
    RowBox[{"\[DifferentialD]", "x"}], " "}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x", " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    SuperscriptBox["x", "2"]]], " ", 
  SqrtBox[
   FractionBox["x", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}]]], " ", 
  RowBox[{"EllipticPi", "[", 
   RowBox[{
    RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
    RowBox[{"ArcSin", "[", 
     FractionBox[
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
      SqrtBox["2"]], "]"}], ",", 
    RowBox[{"-", "\[ImaginaryI]"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"i7", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", "x", " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      SuperscriptBox["x", "2"]]], " ", 
    SqrtBox[
     FractionBox["x", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "3"]}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "\[ImaginaryI]"}], "x"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       SuperscriptBox["x", "2"]]}], ")"}]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], "x"]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"1", "+", "x"}], "x"]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "+", 
          FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], "x"]}]], " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "-", 
          FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], "x"]}]]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], 
     SuperscriptBox["x", "2"]]], " ", 
   SqrtBox[
    FractionBox["x", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"]}]]], " ", 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
     RowBox[{"ArcSin", "[", 
      FractionBox[
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
       SqrtBox["2"]], "]"}], ",", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", "x", " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      SuperscriptBox["x", "2"]]], " ", 
    SqrtBox[
     FractionBox["x", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "3"]}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "\[ImaginaryI]"}], "x"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], 
       SuperscriptBox["x", "2"]]}], ")"}], " ", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
      RowBox[{"ArcSin", "[", 
       FractionBox[
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
        SqrtBox["2"]], "]"}], ",", 
      RowBox[{"-", "\[ImaginaryI]"}]}], "]"}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      SuperscriptBox["x", "2"]]]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", "x", " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
    SqrtBox[
     FractionBox["x", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "3"]}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], 
       SuperscriptBox["x", "2"]], "+", 
      FractionBox[
       RowBox[{"1", "+", "x"}], 
       SuperscriptBox["x", "2"]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       SuperscriptBox["x", "3"]]}], ")"}], " ", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
      RowBox[{"ArcSin", "[", 
       FractionBox[
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
        SqrtBox["2"]], "]"}], ",", 
      RowBox[{"-", "\[ImaginaryI]"}]}], "]"}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     FractionBox["x", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "3"]}]]]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", "x", " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      SuperscriptBox["x", "2"]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "x"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "x", "+", 
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["x", "3"]}], ")"}], "2"]]}], "+", 
      FractionBox["1", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["x", "3"]}]]}], ")"}], " ", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
      RowBox[{"ArcSin", "[", 
       FractionBox[
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
        SqrtBox["2"]], "]"}], ",", 
      RowBox[{"-", "\[ImaginaryI]"}]}], "]"}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 SqrtBox[
  FractionBox["x", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"]}]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Ergebnis i7 stellt Sie sicher nicht zufrieden, da die verschiedenen \
Wurzeln zusammengefasst werden k\[ODoubleDot]nnen. Aus Gr\[UDoubleDot]nden \
der mathematischen Exaktheit l\[ADoubleDot]sst sich das mit den \
\[UDoubleDot]blichen Simplifikationskommandos nicht bewerkstelligen.\n\nDas n\
\[ADoubleDot]chste Kommando extrahiert alle Terme des Produkts bis auf den \
letzten. Dazu wird das Produkt in eine Liste verwandelt, ",
 StyleBox["DeleteCases",
  FontWeight->"Bold"],
 " angewendet und danach das Ergebnis wieder in eine Liste verwandelt. Nat\
\[UDoubleDot]rlich k\[ODoubleDot]nnen Sie alternativ auch die zu \
untersuchenden Teilausdr\[UDoubleDot]cke mit der Maus markieren und in eine \
neue Zelle kopieren."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{"Times", "@@", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"List", "@@", "i7"}], ",", "_EllipticPi"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SuperscriptBox["u", "2"], "//", "Together"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x", " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    SuperscriptBox["x", "2"]]], " ", 
  SqrtBox[
   FractionBox["x", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}]]]}]], "Output"],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Auch h\[ADoubleDot]tte es nicht des Umwegs \[UDoubleDot]ber eine Liste \
bedurft, da ",
 StyleBox["DeleteCases",
  FontWeight->"Bold"],
 " auch auf allgemeinere Ausdr\[UDoubleDot]cke angewendet werden kann. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{"i7", ",", "_EllipticPi"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x", " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    SuperscriptBox["x", "2"]]], " ", 
  SqrtBox[
   FractionBox["x", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}]]]}]], "Output"]
}, Open  ]],

Cell["\<\
Das Integral i7 sollte also zum folgenden Ausdruck \[ADoubleDot]quivalent \
sein.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i8", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{"2", "-", 
     RowBox[{"2", "I"}]}]], 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"1", "-", "I"}], ",", 
     RowBox[{"ArcSin", "[", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "I"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}]}], 
        RowBox[{"2", "x"}]]], "]"}], ",", 
     RowBox[{"-", "I"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", "-", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}]], " ", 
  RowBox[{"EllipticPi", "[", 
   RowBox[{
    RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
    RowBox[{"ArcSin", "[", 
     FractionBox[
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
      SqrtBox["2"]], "]"}], ",", 
    RowBox[{"-", "\[ImaginaryI]"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Alternativ h\[ADoubleDot]tten Sie nat\[UDoubleDot]rlich auch einfach ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["i7", "2"], " "}]],
  CellChangeTimes:>{3.35117232134555*^9}],
 "berechnen k\[ODoubleDot]nnen:"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["i7", "2"], "//", "Together"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "-", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
     RowBox[{"ArcSin", "[", 
      FractionBox[
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}]}], "x"]], 
       SqrtBox["2"]], "]"}], ",", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "]"}], "2"]}]], "Output"]
}, Open  ]],

Cell["\<\
Versuchen wir die Probe, indem wieder die Ableitung der Stammfunktion i6 \
berechnet wird.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a8", "=", 
  RowBox[{"D", "[", 
   RowBox[{"i8", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", "\[ImaginaryI]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "\[ImaginaryI]"}], "x"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      SuperscriptBox["x", "2"]]}], ")"}]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], "x"]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"1", "+", "x"}], "x"]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], "x"]}]], " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "-", 
         FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], "x"]}]]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a8", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox[
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox["\[ImaginaryI]", "2"]}]], " ", "x", " ", 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}], "x"]], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], 
     SuperscriptBox["x", "2"]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
Leider dasselbe Problem wie oben mit den Wurzeln. Wir quadrieren einfach \
wieder. i6 ist also bis auf das Vorzeichen die richtige Stammfunktion und \
mehr k\[ODoubleDot]nnen wir auch nicht erwarten, da f\[UDoubleDot]r komplexe \
x der Radikand selbst nur bis aufs Vorzeichen eindeutig bestimmt ist. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SuperscriptBox["a8", "2"], "//", "Together"}], "\[IndentingNewLine]", 
 RowBox[{
  SuperscriptBox["a8", "2"], "//", "Simplify"}]}], "Input"],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output"],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{"1", "+", "x", "+", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "3"]}]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mehrfachintegrale", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", "2"], 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", "3"], 
   RowBox[{"1", 
    RowBox[{"\[DifferentialD]", "y"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData["6"], "Output"]
}, Open  ]],

Cell["\<\
Bei vielen bestimmten Mehrfachintegralen ist die Reihenfolge des \
Abintegrierens  relevant, da die Grenzen des inneren Integrals von der \
\[ADoubleDot]u\[SZ]eren Integrationsvariablen abh\[ADoubleDot]ngen k\
\[ODoubleDot]nnen! Die beiden folgenden Integrale sind gleichwertig, einmal \
in der Formelschreibweise, einmal als konventionelles Kommando; beachten Sie \
beim zweiten Beispiel, dass das innere Integral durch den \
\[ADoubleDot]u\[SZ]eren Parameter angegeben wird (w\[ADoubleDot]hrend bei der \
Formelschreibweise das innere Integral nat\[UDoubleDot]rlich innen steht)\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]], 
   RowBox[{"1", 
    RowBox[{"\[DifferentialD]", "y"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"1", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", "1"], 
   RowBox[{
    UnderoverscriptBox["\[Integral]", "0", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]], " ", 
    RowBox[{
     SuperscriptBox["E", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "y"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "1"], 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}]], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Erf", "[", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], "]"}]}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData["1.9858653037988707`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", 
    RowBox[{"\[Pi]", "/", "2"}]], 
   RowBox[{
    UnderoverscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     SuperscriptBox["E", 
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}]], "r", 
     RowBox[{"\[DifferentialD]", "r"}], 
     RowBox[{"\[DifferentialD]", "\[Phi]"}]}]}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], " ", "\[Pi]"}], 
  "\[ExponentialE]"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "//", "N"}]], "Input"],

Cell[BoxData["1.9858653037988714`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     SuperscriptBox["E", 
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}]], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Phi]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}], ",", "z"}], "}"}], ",", "\n", 
     "\t\t", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"1", "/", "E"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx0fXlcTs/7fryTrFkjS5YWyVoqWxqRqJBdkWSXCKFspQhlTVJUWiwhyRKF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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFnAccV+P3x+8eoUJlpy0rMiorREZIQkXSMEPKblBKIiszFVGJjOy9Z/aW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          "]], Polygon3DBox[CompressedData["
1:eJwtnAXYFNUbxWd26q4tJqIijRIiBmIQEgImYCsKBoL6V0QlTEAQRVDCFiTF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          "]], Polygon3DBox[CompressedData["
1:eJwl1wm81lMex/Hnus/tPteYGZEo3fbsSd3UMDPKOhMiLZg2qYhqQslUQsuQ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          "]], 
         Polygon3DBox[{{1626, 1740, 991, 1152, 2251, 
          1625}}]}]}, {}, {}, {}}, {
      Line3DBox[{775, 1, 765, 227, 1563, 16, 379, 1570, 31, 388, 1577, 46, 
       1955, 397, 61, 1964, 406, 76, 1973, 415, 91, 1982, 424, 1627, 106, 433,
        1647, 121, 442, 1654, 136, 451, 1661, 151, 460, 166, 2023, 469, 181, 
       2032, 478, 196, 1922, 366, 777, 211, 774, 487, 932, 212, 933, 213, 934,
        214, 935, 215, 936, 216, 937, 217, 938, 939, 218, 759, 940, 219, 760, 
       941, 220, 761, 942, 221, 1547, 762, 222, 1548, 763, 223, 1549, 764, 
       224, 1251, 368, 778, 225, 772, 367, 1714, 210, 363, 1700, 195, 353, 
       1686, 180, 343, 165, 1882, 333, 150, 1879, 323, 135, 1870, 313, 120, 
       1862, 303, 1645, 105, 293, 1624, 90, 283, 1610, 75, 273, 1596, 60, 
       1816, 263, 45, 1799, 253, 30, 1790, 243, 776, 15, 773, 377, 811, 14, 
       771, 810, 13, 770, 809, 12, 769, 808, 11, 1552, 768, 10, 1551, 767, 9, 
       1550, 766, 8, 803, 802, 7, 800, 6, 798, 5, 796, 4, 794, 3, 792, 2, 
       1252, 369, 775}], {}, {}, {
       Line3DBox[{792, 944, 2281, 793, 952, 813, 2335, 960, 823, 2336, 968, 
        833, 2339, 976, 843, 2343, 984, 853, 2350, 992, 2303, 863, 1000, 2313,
         873, 2355, 1008, 883, 2356, 1016, 893, 2357, 1024, 903, 2359, 1032, 
        913, 2363, 1040, 923, 2368, 1048, 933}], 
       Line3DBox[{794, 945, 2282, 795, 953, 2289, 814, 961, 824, 2337, 969, 
        834, 2340, 977, 844, 2344, 985, 854, 2351, 993, 2304, 864, 1001, 2314,
         874, 1009, 2321, 884, 1017, 894, 2358, 1025, 904, 2360, 1033, 914, 
        2364, 1041, 924, 2369, 1049, 934}], 
       Line3DBox[{796, 946, 2283, 797, 954, 2290, 815, 962, 2295, 825, 2338, 
        970, 835, 2341, 978, 845, 2345, 986, 855, 2352, 994, 2305, 865, 1002, 
        2315, 875, 1010, 2322, 885, 1018, 2327, 895, 1026, 905, 2361, 1034, 
        915, 2365, 1042, 925, 2370, 1050, 935}], 
       Line3DBox[{798, 947, 2284, 799, 955, 2291, 816, 963, 2296, 826, 971, 
        2299, 836, 979, 846, 2346, 987, 856, 2353, 995, 2306, 866, 1003, 2316,
         876, 1011, 2323, 886, 1019, 2328, 896, 1027, 2331, 906, 1035, 916, 
        2366, 1043, 926, 2371, 1051, 936}], 
       Line3DBox[{800, 948, 2285, 801, 956, 2292, 817, 964, 2297, 827, 972, 
        2300, 837, 980, 2301, 847, 988, 2302, 857, 2354, 996, 2307, 867, 1004,
         2317, 877, 1012, 2324, 887, 1020, 2329, 897, 1028, 2332, 907, 1036, 
        2333, 917, 1044, 2334, 927, 2372, 1052, 937}], 
       Line3DBox[{802, 1056, 2375, 1058, 1253, 1059, 2377, 1061, 1258, 1083, 
        2380, 1085, 1263, 1097, 2384, 1099, 1268, 1111, 2390, 1113, 1273, 
        1125, 2395, 1127, 1278, 1139, 1141, 2308, 1283, 1153, 2401, 1155, 
        1288, 1167, 2404, 1169, 1293, 1181, 2407, 1183, 1298, 1195, 2411, 
        1197, 1303, 1209, 2413, 1211, 1308, 1223, 2418, 1225, 1313, 1237, 
        2422, 1239, 938}], 
       Line3DBox[{808, 1066, 1322, 1067, 2286, 1254, 1068, 1330, 1069, 2293, 
        1259, 1088, 1338, 1089, 2298, 1264, 1102, 2385, 1346, 1103, 1269, 
        2427, 1116, 1354, 1117, 1274, 2428, 1130, 1362, 1131, 1279, 2430, 
        1144, 1370, 1145, 2309, 1284, 1158, 1378, 1159, 2318, 1289, 1172, 
        1386, 1173, 2325, 1294, 1186, 1394, 1187, 2330, 1299, 1200, 1402, 
        1201, 1304, 2439, 1214, 1410, 1215, 1309, 2440, 1228, 1418, 1229, 
        1314, 2442, 1242, 1426, 1243, 1547}], 
       Line3DBox[{809, 1070, 1323, 1071, 2287, 1255, 1072, 1331, 1073, 2294, 
        1260, 1090, 1339, 2448, 1091, 1265, 1104, 2386, 1347, 1105, 1270, 
        1118, 2391, 1355, 1119, 1275, 2429, 1132, 1363, 1133, 1280, 2431, 
        1146, 1371, 1147, 2310, 1285, 1160, 1379, 1161, 2319, 1290, 1174, 
        1387, 1175, 2326, 1295, 1188, 1395, 2460, 1189, 1300, 1202, 1403, 
        1203, 1305, 1216, 2414, 1411, 1217, 1310, 2441, 1230, 1419, 1231, 
        1315, 2443, 1244, 1427, 1245, 1548}], 
       Line3DBox[{810, 1074, 1324, 1075, 2288, 1256, 1076, 1332, 2446, 1077, 
        1261, 1092, 1340, 2449, 1093, 1266, 1106, 2387, 1348, 1107, 1271, 
        1120, 2392, 1356, 1121, 1276, 1134, 2396, 1364, 1135, 1281, 2432, 
        1148, 1372, 1149, 2311, 1286, 1162, 1380, 1163, 2320, 1291, 1176, 
        1388, 2458, 1177, 1296, 1190, 1396, 2461, 1191, 1301, 1204, 1404, 
        1205, 1306, 1218, 2415, 1412, 1219, 1311, 1232, 2419, 1420, 1233, 
        1316, 2444, 1246, 1428, 1247, 1549}], 
       Line3DBox[{811, 1078, 1325, 2445, 1079, 1257, 1080, 1333, 2447, 1081, 
        1262, 1094, 1341, 2450, 1095, 1267, 1108, 2388, 1349, 1109, 1272, 
        1122, 2393, 1357, 1123, 1277, 1136, 2397, 1365, 1137, 1282, 1150, 
        2399, 1373, 1151, 2312, 1287, 1164, 1381, 2457, 1165, 1292, 1178, 
        1389, 2459, 1179, 1297, 1192, 1397, 2462, 1193, 1302, 1206, 1405, 
        1207, 1307, 1220, 2416, 1413, 1221, 1312, 1234, 2420, 1421, 1235, 
        1317, 1248, 2423, 1429, 1249, 1251}], 
       Line3DBox[{932, 1047, 2424, 1250, 922, 1039, 2421, 1236, 912, 1031, 
        2417, 1222, 902, 1023, 2412, 1208, 892, 1015, 2410, 1194, 882, 1007, 
        2405, 1180, 872, 999, 2402, 1166, 862, 2455, 991, 1152, 2349, 852, 
        983, 2398, 1138, 842, 975, 2394, 1124, 832, 967, 2389, 1110, 822, 959,
         2383, 1096, 812, 951, 2378, 1082, 791, 943, 1055, 1252}], 
       Line3DBox[{939, 1053, 1422, 2466, 1238, 928, 1045, 1414, 2464, 1224, 
        918, 1037, 1406, 2463, 1210, 908, 1029, 1398, 1196, 898, 1021, 2406, 
        1390, 1182, 888, 1013, 2403, 1382, 1168, 878, 1005, 2400, 1374, 1154, 
        868, 2433, 997, 1366, 2456, 1140, 858, 989, 1358, 2453, 1126, 848, 
        981, 1350, 2452, 1112, 838, 973, 1342, 2451, 1098, 828, 965, 2379, 
        1334, 1084, 818, 957, 2376, 1326, 1060, 804, 949, 2374, 1318, 1057, 
        803}], Line3DBox[{940, 1054, 1553, 1423, 1544, 1543, 2486, 929, 1046, 
        1490, 1415, 1540, 2465, 1539, 919, 1038, 1485, 1407, 2484, 1536, 1535,
         909, 1030, 1480, 1399, 1532, 1531, 899, 1022, 1475, 2408, 1391, 1528,
         1527, 889, 1014, 2473, 1470, 1383, 1524, 1523, 879, 2437, 1006, 1465,
         1375, 1520, 1519, 869, 2434, 998, 1460, 1367, 1516, 1515, 2482, 859, 
        990, 1455, 1359, 1512, 2454, 1511, 849, 982, 1450, 1351, 2480, 1508, 
        1507, 839, 974, 1445, 1343, 2477, 1504, 1503, 829, 966, 1440, 2381, 
        1335, 1500, 1499, 819, 958, 2468, 1435, 1327, 1496, 1495, 805, 2425, 
        950, 1430, 1319, 1559, 1558, 1550}], 
       Line3DBox[{941, 1555, 1554, 1424, 1240, 1545, 2487, 930, 1492, 1491, 
        1416, 1226, 1541, 920, 1487, 1486, 1408, 2485, 1212, 1537, 910, 1482, 
        1481, 1400, 1198, 1533, 900, 1477, 1476, 2409, 1392, 1184, 1529, 890, 
        1472, 2474, 1471, 1384, 1170, 1525, 880, 2438, 1467, 1466, 1376, 1156,
         1521, 870, 2435, 1462, 1461, 1368, 1142, 1517, 2483, 860, 1457, 1456,
         1360, 1128, 2347, 1513, 850, 1452, 1451, 1352, 2481, 1114, 1509, 840,
         1447, 1446, 1344, 2478, 1100, 1505, 830, 1442, 1441, 2382, 1336, 
        1086, 1501, 820, 1437, 2469, 1436, 1328, 1063, 1497, 806, 2426, 1432, 
        1431, 1320, 1062, 1560, 1551}], 
       Line3DBox[{942, 1557, 1556, 1425, 1241, 2373, 1546, 931, 1494, 1493, 
        1417, 1227, 2367, 1542, 921, 1489, 1488, 1409, 1213, 2362, 1538, 911, 
        1484, 1483, 1401, 1199, 1534, 901, 1479, 2476, 1478, 1393, 1185, 1530,
         891, 1474, 2475, 1473, 1385, 1171, 1526, 881, 1469, 2472, 1468, 1377,
         1157, 1522, 871, 2436, 1464, 1463, 1369, 1143, 1518, 861, 1459, 1458,
         1361, 1129, 2348, 1514, 851, 1454, 1453, 1353, 1115, 2342, 1510, 841,
         1449, 1448, 1345, 2479, 1101, 1506, 831, 1444, 2471, 1443, 1337, 
        1087, 1502, 821, 1439, 2470, 1438, 1329, 1065, 1498, 807, 1434, 2467, 
        1433, 1321, 1064, 1561, 1552}]}, {
       Line3DBox[{1563, 1779, 2041, 943, 1562, 2281, 1715, 1564, 2282, 1716, 
        1565, 2283, 1717, 1566, 2284, 1718, 1567, 2285, 1719, 1568, 2375, 
        1780, 1923, 2190, 2374, 2042, 1782, 1924, 2104, 2425, 1720, 2043, 
        1784, 1925, 2266, 2426, 1721, 2044, 1786, 1926, 2467, 2105, 1722, 
        2045, 2233, 2286, 1927, 2106, 1723, 2046, 2235, 2287, 1928, 2107, 
        1724, 2047, 2237, 2288, 1929, 2108, 1725, 2048, 2445, 1789, 1930, 
        1726, 1790}], 
       Line3DBox[{1570, 1792, 2049, 2191, 2378, 1569, 952, 1571, 2289, 1727, 
        1572, 2290, 1728, 1573, 2291, 1729, 1574, 2292, 1730, 1575, 2377, 
        1781, 1931, 2192, 2376, 2050, 1783, 1932, 605, 2468, 2051, 1785, 1933,
         2469, 606, 2052, 1787, 1934, 2470, 607, 2053, 2234, 2293, 1935, 608, 
        2054, 2236, 2294, 1936, 609, 2055, 2446, 1788, 1937, 610, 2056, 2447, 
        1791, 1938, 1731, 1799}], 
       Line3DBox[{1577, 1801, 2057, 2193, 2383, 1576, 2194, 2335, 1578, 961, 
        1579, 2295, 1732, 1580, 2296, 1733, 1581, 2297, 1734, 1582, 2380, 
        1793, 1939, 2195, 2379, 2059, 1794, 1941, 2109, 2381, 2267, 2060, 
        1795, 1943, 2268, 2382, 2110, 2061, 1796, 1945, 2471, 2111, 2112, 
        2062, 2238, 2298, 1947, 2113, 2114, 2063, 2448, 1797, 1949, 2115, 
        2116, 2064, 2449, 1798, 1951, 2117, 2118, 2065, 2450, 1800, 1953, 
        1735, 1816}], 
       Line3DBox[{1596, 1818, 1954, 1817, 2388, 1595, 2154, 1815, 1952, 1814, 
        2387, 1594, 2153, 1813, 1950, 1812, 2386, 1593, 2152, 1811, 1948, 
        1810, 2385, 1592, 2151, 2479, 1809, 1946, 1808, 1591, 2150, 2478, 
        1807, 1944, 1806, 1590, 2274, 2477, 1805, 1942, 1804, 1589, 2451, 
        1803, 1940, 1802, 2384, 1588, 1737, 2300, 1587, 1736, 2299, 1586, 
        2338, 2198, 1585, 2337, 2197, 1584, 2336, 2196, 1583, 2389, 1820, 
        2058, 1819, 1955}], 
       Line3DBox[{1610, 1834, 1963, 1833, 2393, 1609, 2159, 1832, 1962, 1831, 
        2392, 1608, 2158, 1830, 1961, 1829, 2391, 1607, 2157, 1828, 1960, 
        2427, 2240, 1606, 2156, 2239, 2342, 1959, 1827, 1605, 2155, 2481, 
        1826, 1958, 1825, 1604, 2275, 2480, 1824, 1957, 1823, 1603, 2452, 
        1822, 1956, 1821, 2390, 1602, 1738, 2301, 1601, 979, 1600, 2341, 2201,
         1599, 2340, 2200, 1598, 2339, 2199, 1597, 2394, 1836, 2066, 1835, 
        1964}], Line3DBox[{1624, 1844, 1972, 1843, 2397, 1623, 706, 1971, 
        1842, 2396, 1622, 705, 1970, 2429, 2242, 1621, 704, 1969, 2428, 2241, 
        1620, 703, 2348, 1968, 1841, 1619, 702, 2347, 1967, 1840, 1618, 2454, 
        701, 1966, 1839, 1617, 2453, 1838, 1965, 1837, 2395, 1616, 1739, 2302,
         1615, 2346, 2205, 1614, 2345, 2204, 1613, 2344, 2203, 1612, 2343, 
        2202, 1611, 2398, 1846, 2067, 1845, 1973}], 
       Line3DBox[{1627, 1857, 2069, 2455, 1740, 1626, 2303, 1741, 1629, 2304, 
        1742, 1631, 2305, 1743, 1633, 2306, 1744, 1635, 2307, 1745, 1637, 
        2243, 2308, 1983, 2433, 1746, 2070, 1849, 1984, 2119, 2434, 1747, 
        2071, 1851, 1985, 2269, 2435, 1748, 2072, 1853, 1986, 2270, 2436, 
        1749, 2073, 2245, 2309, 1987, 2120, 1750, 2074, 2247, 2310, 1988, 
        2121, 1751, 2075, 2249, 2311, 1989, 2122, 1752, 2076, 2250, 2312, 
        1990, 1753, 1862}], 
       Line3DBox[{1645, 1855, 1981, 1854, 2399, 1644, 2167, 2168, 1980, 2432, 
        2248, 1643, 2165, 2166, 1979, 2431, 2246, 1642, 2163, 2164, 1978, 
        2430, 2244, 1641, 2162, 1518, 1977, 1852, 1640, 2161, 2483, 2277, 
        1976, 1850, 1639, 2276, 2482, 2160, 1975, 1848, 1638, 2456, 1847, 
        1974, 1139, 1636, 2354, 2210, 1634, 2353, 2209, 1632, 2352, 2208, 
        1630, 2351, 2207, 1628, 2350, 2206, 1625, 2251, 2349, 2068, 1856, 
        1982}], Line3DBox[{1647, 1864, 2077, 2211, 2402, 1646, 2313, 1754, 
        1648, 2314, 1755, 1649, 2315, 1756, 1650, 2316, 1757, 1651, 2317, 
        1758, 1652, 2401, 1858, 1991, 2212, 2400, 2078, 1859, 1992, 2123, 
        2437, 1759, 2079, 1860, 1993, 2271, 2438, 1760, 2080, 1861, 1994, 
        2472, 2124, 1761, 2081, 2252, 2318, 1995, 2125, 1762, 2082, 2253, 
        2319, 1996, 2126, 1763, 2083, 2254, 2320, 1997, 2127, 1764, 2084, 
        2457, 1863, 1998, 1765, 1870}], 
       Line3DBox[{1654, 1872, 2085, 2213, 2405, 1653, 2214, 2355, 1655, 2321, 
        1766, 1656, 2322, 1767, 1657, 2323, 1768, 1658, 2324, 1769, 1659, 
        2404, 1865, 1999, 2215, 2403, 2086, 1866, 2000, 2128, 2129, 2473, 
        2087, 1867, 2001, 2474, 2130, 2131, 2088, 1868, 2002, 2475, 2132, 
        2133, 2089, 2255, 2325, 2003, 2134, 2135, 2090, 2256, 2326, 2004, 
        2136, 2137, 2091, 2458, 1869, 2005, 2138, 2139, 2092, 2459, 1871, 
        2006, 1770, 1879}], 
       Line3DBox[{1661, 1881, 2093, 2216, 2410, 1660, 2217, 2356, 1662, 1017, 
        1663, 2327, 1771, 1664, 2328, 1772, 1665, 2329, 1773, 1666, 2407, 
        1873, 2007, 2218, 2406, 2094, 1874, 2008, 2140, 2408, 2272, 2095, 
        1875, 2009, 2273, 2409, 2141, 2096, 1876, 2010, 2476, 2142, 2143, 
        2097, 2257, 2330, 2011, 2144, 2145, 2098, 2460, 1877, 2012, 2146, 
        2147, 2099, 2461, 1878, 2013, 2148, 2149, 2100, 2462, 1880, 2014, 
        1774, 1882}], 
       Line3DBox[{460, 335, 2412, 1667, 2219, 2357, 1668, 2220, 2358, 1669, 
        1026, 1670, 2331, 1775, 1671, 2332, 1776, 1672, 2411, 326, 1398, 569, 
        327, 1399, 570, 328, 1400, 571, 329, 1401, 572, 1402, 330, 573, 1403, 
        331, 574, 1404, 332, 575, 1405, 334, 343}], 
       Line3DBox[{1686, 1896, 2022, 1895, 2416, 1685, 2173, 1894, 2021, 1893, 
        2415, 1684, 2172, 1892, 2020, 1891, 2414, 1683, 2171, 1890, 2019, 
        2439, 2259, 1682, 2170, 2258, 2362, 2018, 1889, 1681, 2169, 2485, 
        1888, 2017, 1887, 1680, 2278, 2484, 1886, 2016, 1885, 1679, 2463, 
        1884, 2015, 1883, 2413, 1678, 1777, 2333, 1677, 1035, 1676, 2361, 
        2223, 1675, 2360, 2222, 1674, 2359, 2221, 1673, 2417, 1898, 2101, 
        1897, 2023}], 
       Line3DBox[{1700, 1910, 2031, 1909, 2420, 1699, 2179, 1908, 2030, 1907, 
        2419, 1698, 2178, 1906, 2029, 2441, 2262, 1697, 2177, 1905, 2028, 
        2440, 2261, 1696, 2176, 2260, 2367, 2027, 1904, 1695, 2175, 1226, 
        2026, 1903, 1694, 2465, 2174, 1902, 2025, 1901, 1693, 2464, 1900, 
        2024, 1899, 2418, 1692, 1778, 2334, 1691, 2366, 2227, 1690, 2365, 
        2226, 1689, 2364, 2225, 1688, 2363, 2224, 1687, 2421, 1912, 2102, 
        1911, 2032}], 
       Line3DBox[{1714, 1919, 2040, 1918, 2423, 1713, 2188, 2189, 2039, 2444, 
        2265, 1712, 2186, 2187, 2038, 2443, 2264, 1711, 2184, 2185, 2037, 
        2442, 2263, 1710, 2182, 2183, 2373, 2036, 1917, 1709, 2181, 2487, 
        2280, 2035, 1916, 1708, 2279, 2486, 2180, 2034, 1915, 1707, 2466, 
        1914, 2033, 1913, 2422, 1706, 2372, 2232, 1705, 2371, 2231, 1704, 
        2370, 2230, 1703, 2369, 2229, 1702, 2368, 2228, 1701, 2424, 1921, 
        2103, 1920, 1922}]}}},
    VertexNormals->CompressedData["
1:eJx0fHtUjt32dlQURYlEIiqHQhKJ1KKQzkVKVJQiEVEh0ZkoOucURYgQlVKp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     "]], GraphicsComplex3DBox[CompressedData["
1:eJzNnXe4VcX5cLErVtQkQkwsRGNEUWMvcNWIBTQaRIkJGkNAxYom9h6NPRak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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNnXX8FcX79vdzNs7unt1jgaiogIqJomJhYaKI3ZiYqKDYXRjYjd1iJ3Yh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          "]], Polygon3DBox[CompressedData["
1:eJwtnXn8FeMXx+fOXebO3JlvypY9JUKWijalVbLvskXJvlZIdhHJFiUthIho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          "]], 
         Polygon3DBox[CompressedData["
1:eJwl1WtMlnUcxvFbjQeUR6eioQNNo4xDTlcTamhWaFOxPKzNJg2ntQ4TRZf5
praaZeIkSRsKSIKKZh4gTTxEBuQLe5Fbc6tWWI6yVU5Ws7ZOhn3+u19ce/6/
731dv9//Pj4TV1QuXj0wiqJySqEV6VF0cmgU/T44iq5TC9aunoNPZuzGuuhk
Ek/GufK0KHobK1Xv4D2aiKLn6Qp//5Ao+hsf5ncE35YBUdSj17t819R9NHBQ
FLWGHD7X8czUKKrV7xO5c/SpPmX61WOX1N/SUesK2ZfN3y37H7aELwMrle/E
0rCz+q1Wzze/DnsV+xLbjPXq2av+PhnvtVL2hL7v8P2GzcD+4iuiemxTmC37
lvpH2Yt61mD3ydRjGY5tcw6X8QHqp/BDeuySrQ5zHN+BX5Xdw9OBz/I7m9bx
1cv2WafyrJU9jp1Xb5C9Tb0FT9GjQa4K+y7Mw37S7zO+zVgB33Ys6dhRvmX4
PNfoBXwdXVHv4Xsu3EO+KXwf8g3A2qyfxkp41qjX0gZ7eMB1GRqeBb5CeyzU
r8nMI/gm9f5w76xbqZk/G2vTo56nAbug70iekXid9Xgsx/FbsAS2LdxzbDS2
D1uJXTdjF9YYZtvHYccysKl61mFl2FJ6UfZGuKbYeNlxdJqvSp0nc7t6Ip3B
NmMF2Az1dOrCqrEi7CU6ju13ngdogvPYqX7FjC/MqDLjstkr1RWUzlOcFu+p
z36H0+M8E/QZ5Xk+JtuOLZIdh+/jL1F3ON6qz9eyuWYc4OvEy/i+wXpoIbaA
zutdo344PBM8KVim9Zi0+Jq1qders/TZHZ5bara3H4bE97Xd3GewMr4nKd++
qs1+xPF8vjw6oFcN3yX+Y2a8z9ckMxZ7FPsTO4VNkynD9mDp2C/hnPXLxhfi
h8J1xi6Gey0/gnL1v4tazNjK0xOeXXUj7037OI7dwIrlDod3IVyjcF2ddzZf
FjWHZyw1vgc3+c7wPWTmcuwwlhLecWweVoGdwvLVeTQZ2yKfbZ+z1CVUjG0N
zx/WLdtFO81cnhZ/Z4bx7KXFemVjy7ClMkewCr6VNNv+RsjVYnXOY1oifk9O
qxt5K60f9DuTEnwf46XWq/Q8Y38fqfep1/PN9TuHCrGi8H5ZV+nXaUakbqbH
5EbbyxP851yDE9hZ+8jDl+k3yYw7KWH9ZnjWeLN4silXv9cT8TtRoL57aHw9
NmJTwjulHkW3YhuwSeH7oE6ncvOy9Fqk53T9i5PxN64hXHt8Cs/U8M7JviF7
r+xg+0vFsqzH8mznv0MuJxl/u6pl9+Jj1Jl00742Yk1Yl9xgrJNvTXj+9Pgq
3EM9W8I1Df9J5nSoP+BtU+fwLeH/nO81vJHvHvwaX79eTXzzeUalxf8PP/PV
8rVar+Ib5Ni/2GUs4Tx+xWZif4TZWD9fL3Y/9qz6oH5J9QX9r9p7JfYeNhzr
wf7BDsp2h/vmd0H4tujxP7jj7k4=
          "]]}]}, {}, {}, {}}, {{}, {}, {}, {
       Line3DBox[{1585, 1738, 1914, 1739, 3522, 2315, 2107, 2326, 1758, 1928, 
        1759, 3523, 2327, 2114, 2351, 1769, 1942, 1770, 3527, 2352, 2121, 
        2376, 1780, 1956, 1781, 2377, 2128, 2401, 3616, 1791, 1970, 1792, 
        2402, 2135, 2426, 3620, 1802, 1984, 1803, 2427, 2142, 2451, 3627, 
        1813, 1998, 1814, 2452, 2149, 2476, 1824, 2012, 1825, 3528, 2477, 
        2156, 2501, 1835, 2026, 1836, 3529, 2502, 2163, 2526, 1846, 2040, 
        1847, 3533, 2527, 2170, 2551, 1857, 2054, 1858, 2552, 2177, 2576, 
        3640, 1868, 2068, 1869, 2577, 2184, 2601, 3647, 1879, 2082, 1880, 
        2602, 2191, 2626, 3656, 1890, 2096, 1891, 1894}], 
       Line3DBox[{1586, 1740, 1915, 1741, 2316, 3606, 2108, 2328, 1760, 1929, 
        1761, 3524, 2329, 2115, 2353, 1771, 1943, 3611, 1772, 2354, 2122, 
        2378, 1782, 1957, 1783, 2379, 2129, 2403, 1793, 3545, 1971, 1794, 
        2404, 2136, 2428, 3621, 1804, 1985, 1805, 2429, 2143, 3575, 2453, 
        1815, 1999, 1816, 2454, 2150, 2478, 1826, 2013, 1827, 2479, 3631, 
        2157, 2503, 1837, 2027, 1838, 3530, 2504, 2164, 2528, 1848, 2041, 
        3635, 1849, 2529, 2171, 2553, 1859, 2055, 1860, 2554, 2178, 2578, 
        3641, 1870, 2069, 1871, 2579, 2185, 2603, 3648, 1881, 2083, 1882, 
        2604, 2192, 3583, 2627, 1892, 2097, 1893, 1896}], 
       Line3DBox[{1587, 1742, 1916, 993, 3607, 2109, 1015, 1930, 3610, 1017, 
        2116, 1054, 1944, 3612, 1056, 2123, 1093, 1958, 1095, 2130, 1132, 
        3546, 1972, 1134, 2137, 1171, 1986, 1173, 2144, 3576, 1210, 2000, 
        1212, 2151, 1249, 2014, 1251, 3632, 2158, 1288, 2028, 1290, 2165, 
        1327, 2042, 3636, 1329, 2172, 1366, 2056, 1368, 2179, 1405, 3551, 
        2070, 1407, 2186, 3582, 1444, 2084, 1446, 2193, 3584, 1480, 2098, 
        1895, 1898}], 
       Line3DBox[{1588, 1743, 1917, 2318, 3553, 2317, 2110, 2330, 2331, 1931, 
        2335, 3554, 2334, 2117, 2355, 2356, 1945, 2360, 3556, 2359, 2124, 
        2380, 2381, 1959, 2385, 2384, 2131, 2405, 3617, 2406, 1973, 2410, 
        2409, 2138, 2430, 3622, 2431, 1987, 2435, 2434, 2145, 2455, 3628, 
        2456, 2001, 2460, 2459, 2152, 2480, 2481, 2015, 2485, 3562, 2484, 
        2159, 2505, 2506, 2029, 2510, 3563, 2509, 2166, 2530, 2531, 2043, 
        2535, 2534, 2173, 2555, 2556, 2057, 2560, 2559, 2180, 2580, 3642, 
        2581, 2071, 2585, 2584, 2187, 2605, 3649, 2606, 2085, 2610, 2609, 
        2194, 3585, 2628, 2629, 2099, 1897, 1899}], 
       Line3DBox[{247, 246, 2925, 646, 265, 2939, 660, 279, 2953, 674, 293, 
        688, 2967, 307, 702, 2981, 321, 716, 2995, 335, 730, 349, 3009, 744, 
        363, 3023, 758, 377, 3037, 772, 391, 786, 3051, 405, 800, 3065, 419, 
        814, 3079, 443, 446}], 
       Line3DBox[{1593, 1752, 1922, 1753, 2319, 2111, 2340, 1764, 1936, 1765, 
        3525, 2341, 2118, 2365, 1775, 1950, 1776, 2366, 2125, 2390, 1786, 
        1964, 1787, 2391, 2132, 2415, 1797, 1978, 1798, 2416, 2139, 2440, 
        3623, 1808, 1992, 1809, 2441, 2146, 2465, 1819, 2006, 1820, 2466, 
        2153, 2490, 1830, 2020, 1831, 2491, 2160, 2515, 1841, 2034, 1842, 
        3531, 2516, 2167, 2540, 1852, 2048, 1853, 2541, 2174, 2565, 1863, 
        2062, 1864, 2566, 2181, 2590, 3644, 1874, 2076, 1875, 2591, 2188, 
        2615, 3651, 1885, 2090, 1886, 2616, 2195, 3586, 2636, 1902, 2104, 
        1903, 1906}], 
       Line3DBox[{1594, 1754, 1923, 1755, 2320, 3608, 2112, 2342, 1766, 1937, 
        1767, 3526, 2343, 2119, 2367, 1777, 1951, 3613, 1778, 2368, 2126, 
        2392, 1788, 1965, 1789, 2393, 2133, 2417, 1799, 3547, 1979, 1800, 
        2418, 2140, 2442, 3624, 1810, 1993, 1811, 2443, 2147, 3577, 2467, 
        1821, 2007, 1822, 2468, 2154, 2492, 1832, 2021, 1833, 2493, 3633, 
        2161, 2517, 1843, 2035, 1844, 3532, 2518, 2168, 2542, 1854, 2049, 
        3637, 1855, 2543, 2175, 2567, 1865, 2063, 1866, 2568, 2182, 2592, 
        1876, 3552, 2077, 1877, 2593, 2189, 2617, 1887, 2091, 1888, 2618, 
        2196, 3587, 2637, 1904, 2105, 1905, 1908}], 
       Line3DBox[{1595, 1756, 1924, 2322, 2321, 3609, 2113, 2344, 2345, 1938, 
        2347, 3555, 2346, 2120, 2369, 2370, 1952, 3614, 2372, 2371, 2127, 
        2394, 2395, 1966, 2397, 2396, 2134, 2419, 2420, 3548, 1980, 2422, 
        2421, 2141, 2444, 3625, 2445, 1994, 2447, 2446, 2148, 3578, 2469, 
        2470, 2008, 2472, 2471, 2155, 2494, 2495, 2022, 2497, 2496, 3634, 
        2162, 2519, 2520, 2036, 2522, 3564, 2521, 2169, 2544, 2545, 2050, 
        3638, 2547, 2546, 2176, 2569, 2570, 2064, 2572, 2571, 2183, 2594, 
        3645, 2595, 2078, 2597, 2596, 2190, 2619, 3652, 2620, 2092, 2622, 
        2621, 2197, 3588, 2638, 2639, 2106, 1907, 1909}], 
       Line3DBox[{1680, 1726, 2093, 2624, 2623, 3653, 1673, 1723, 2306, 2079, 
        2599, 3568, 2598, 1666, 1720, 2297, 2065, 2574, 3565, 2573, 1659, 
        1717, 2288, 2051, 2549, 2548, 1652, 1714, 2279, 2037, 2524, 2523, 
        1645, 1711, 3599, 2270, 2023, 2499, 2498, 1638, 1708, 2261, 2009, 
        2474, 2473, 1631, 1705, 2252, 1995, 2449, 2448, 1624, 1702, 2243, 
        1981, 2424, 3558, 2423, 1617, 1699, 2234, 1967, 2399, 2398, 1610, 
        1696, 2225, 1953, 2374, 2373, 1603, 1693, 2216, 1939, 2349, 2348, 
        1596, 1690, 3591, 2207, 1925, 2324, 2323, 1582, 1687, 2198, 1911, 
        1733, 1910}], 
       Line3DBox[{1681, 1727, 2094, 1473, 3654, 1674, 976, 2080, 1433, 3646, 
        1667, 963, 2066, 3639, 1394, 1660, 950, 2052, 1355, 1653, 937, 3549, 
        2038, 1316, 1646, 924, 2024, 1277, 1639, 3579, 911, 2010, 1238, 1632, 
        898, 1996, 1199, 3626, 1625, 885, 1982, 1160, 1618, 872, 1968, 3615, 
        1121, 1611, 859, 1954, 1082, 1604, 846, 3542, 1940, 1043, 1597, 833, 
        3541, 1926, 1004, 1583, 3572, 819, 1912, 1734, 1735}], 
       Line3DBox[{1682, 1728, 2095, 1889, 2625, 3655, 1675, 2308, 2307, 2081, 
        1878, 3539, 2600, 1668, 2299, 2298, 2067, 1867, 3537, 2575, 1661, 
        2290, 2289, 2053, 1856, 2550, 1654, 2281, 2280, 2039, 1845, 2525, 
        1647, 2272, 3600, 2271, 2025, 1834, 2500, 1640, 2263, 2262, 2011, 
        1823, 2475, 1633, 2254, 2253, 1997, 1812, 2450, 1626, 2245, 2244, 
        1983, 1801, 3534, 2425, 1619, 2236, 2235, 1969, 1790, 2400, 1612, 
        2227, 2226, 1955, 1779, 2375, 1605, 2218, 2217, 1941, 1768, 2350, 
        1598, 2209, 3592, 2208, 1927, 1757, 2325, 1584, 2200, 3589, 2199, 
        1913, 1736, 1737}], 
       Line3DBox[{1683, 1729, 2100, 2631, 3571, 2630, 1676, 1724, 2309, 2086, 
        2608, 3569, 2607, 1669, 1721, 2300, 2072, 2583, 3566, 2582, 1662, 
        1718, 2291, 2058, 2558, 2557, 1655, 1715, 3605, 2282, 2044, 2533, 
        2532, 1648, 1712, 3601, 2273, 2030, 2508, 2507, 1641, 1709, 3598, 
        2264, 2016, 2483, 2482, 1634, 1706, 2255, 2002, 2458, 3561, 2457, 
        1627, 1703, 2246, 1988, 2433, 3559, 2432, 1620, 1700, 2237, 1974, 
        2408, 3557, 2407, 1613, 1697, 2228, 1960, 2383, 2382, 1606, 1694, 
        3597, 2219, 1946, 2358, 2357, 1599, 1691, 3593, 2210, 1932, 2333, 
        2332, 1589, 1688, 3590, 2201, 1918, 1744, 1745}], 
       Line3DBox[{1684, 1730, 2101, 2633, 2632, 3657, 1677, 1725, 2310, 2087, 
        2612, 3570, 2611, 1670, 1722, 2301, 2073, 2587, 3567, 2586, 1663, 
        1719, 2292, 2059, 2562, 2561, 1656, 1716, 2283, 2045, 2537, 2536, 
        1649, 1713, 3602, 2274, 2031, 2512, 2511, 1642, 3580, 1710, 2265, 
        2017, 2487, 2486, 1635, 1707, 2256, 2003, 2462, 2461, 3629, 1628, 
        1704, 2247, 1989, 2437, 3560, 2436, 1621, 1701, 2238, 1975, 3618, 
        2412, 2411, 1614, 1698, 2229, 1961, 2387, 2386, 1607, 1695, 2220, 
        3543, 1947, 2362, 2361, 1600, 1692, 3594, 2211, 1933, 2337, 2336, 
        1590, 3573, 1689, 2202, 1919, 1746, 1747}], 
       Line3DBox[{1685, 1731, 2102, 1900, 2634, 3658, 1678, 2312, 2311, 2088, 
        1883, 2613, 3650, 1671, 2303, 2302, 2074, 3643, 1872, 2588, 1664, 
        2294, 2293, 2060, 1861, 2563, 1657, 2285, 2284, 3550, 2046, 1850, 
        2538, 1650, 2276, 3603, 2275, 2032, 1839, 2513, 1643, 3581, 2267, 
        2266, 2018, 1828, 2488, 1636, 2258, 2257, 2004, 1817, 2463, 3630, 
        1629, 2249, 2248, 1990, 1806, 3535, 2438, 1622, 2240, 2239, 1976, 
        3619, 1795, 2413, 1615, 2231, 2230, 1962, 1784, 2388, 1608, 2222, 
        2221, 3544, 1948, 1773, 2363, 1601, 2213, 3595, 2212, 1934, 1762, 
        2338, 1591, 3574, 2204, 2203, 1920, 1748, 1749}], 
       Line3DBox[{1686, 1732, 2103, 1901, 2635, 3659, 1679, 2314, 2313, 2089, 
        1884, 3540, 2614, 1672, 2305, 2304, 2075, 1873, 3538, 2589, 1665, 
        2296, 2295, 2061, 1862, 2564, 1658, 2287, 2286, 2047, 1851, 2539, 
        1651, 2278, 3604, 2277, 2033, 1840, 2514, 1644, 2269, 2268, 2019, 
        1829, 2489, 1637, 2260, 2259, 2005, 1818, 2464, 1630, 2251, 2250, 
        1991, 1807, 3536, 2439, 1623, 2242, 2241, 1977, 1796, 2414, 1616, 
        2233, 2232, 1963, 1785, 2389, 1609, 2224, 2223, 1949, 1774, 2364, 
        1602, 2215, 3596, 2214, 1935, 1763, 2339, 1592, 2206, 2205, 1921, 
        1750, 1751}]}, {
       Line3DBox[{2640, 3173, 3174, 2915, 3083, 1687, 2837, 3175, 3176, 2916, 
        3084, 3572, 2730, 2838, 3177, 3178, 2917, 3589, 3085, 2731, 2839, 
        3179, 3180, 3522, 2918, 3086, 2732, 2840, 3181, 3606, 3496, 2919, 
        3087, 2733, 2841, 3182, 3607, 3183, 2920, 3088, 2734, 2842, 3553, 
        3184, 3185, 2921, 3089, 3477, 3590, 2843, 3186, 3187, 2922, 3090, 
        3573, 2735, 2844, 3188, 3189, 2923, 3491, 3574, 2736, 2845, 3190, 
        3191, 2924, 2206, 2737, 2846, 3192, 3193, 2925, 3091, 2738, 2847, 
        3194, 2319, 2926, 3092, 2739, 2848, 3195, 3608, 3497, 2927, 3093, 
        2740, 2849, 3498, 3609, 3196, 2928, 3094, 2741, 2754}], 
       Line3DBox[{2641, 3455, 2755, 2929, 3095, 3096, 3591, 2850, 3197, 2756, 
        2930, 3097, 3541, 3098, 2851, 3198, 2757, 2931, 3592, 3099, 3100, 
        2852, 3199, 3479, 3523, 2932, 3101, 3102, 2853, 3200, 3480, 3524, 
        2933, 3103, 3104, 2854, 3201, 3610, 2758, 2934, 3105, 3106, 2855, 
        3554, 3202, 2759, 2935, 3107, 3108, 3593, 2856, 3203, 2760, 2936, 
        3109, 3110, 3594, 2857, 3204, 2761, 2937, 3595, 3111, 3112, 2858, 
        3205, 2762, 2938, 3596, 3113, 3114, 2859, 3206, 2763, 2939, 3115, 
        3116, 2860, 3207, 3481, 3525, 2940, 3117, 3118, 2861, 3208, 3482, 
        3526, 2941, 3119, 3120, 2862, 3555, 3209, 2764, 2942, 3444, 3445, 
        3443}], Line3DBox[{2642, 3456, 2765, 2943, 3121, 2216, 2863, 3210, 
        2766, 2944, 3122, 3542, 3123, 2864, 3211, 2767, 2945, 2217, 3124, 
        2865, 3212, 3483, 3527, 2946, 3125, 3126, 2866, 3213, 3611, 2768, 
        2947, 3127, 3128, 2867, 3214, 3612, 2769, 2948, 3129, 3130, 2868, 
        3556, 3215, 2770, 2949, 3131, 3132, 3597, 2869, 3216, 2771, 2950, 
        3133, 3543, 3492, 2870, 3217, 2772, 2951, 3493, 3544, 3134, 2871, 
        3218, 2773, 2952, 2223, 3135, 2872, 3219, 2774, 2953, 3136, 3137, 
        2873, 3220, 1776, 2954, 3138, 3139, 2874, 3221, 3613, 2775, 2955, 
        3140, 3141, 2875, 3499, 3614, 2776, 2956, 3447, 3448, 3446}], 
       Line3DBox[{1534, 283, 1953, 493, 284, 1954, 494, 285, 1955, 495, 1956, 
        286, 496, 1957, 287, 497, 1958, 288, 498, 1959, 289, 1960, 499, 290, 
        1961, 500, 291, 1962, 501, 292, 1963, 502, 293, 503, 1964, 294, 504, 
        1965, 295, 505, 1966, 296, 1506}], 
       Line3DBox[{2656, 3458, 2800, 2970, 2799, 3548, 3501, 2655, 3244, 2798, 
        2969, 2797, 3547, 3243, 2654, 3242, 2796, 2968, 1797, 3241, 2653, 
        3240, 2795, 2967, 2794, 3239, 2652, 3238, 1796, 2966, 2793, 3237, 
        2651, 3236, 3619, 2792, 2965, 2791, 3235, 2650, 3500, 3618, 2790, 
        2964, 2789, 3234, 2649, 3557, 3233, 2788, 2963, 2787, 3232, 3617, 
        2648, 3231, 2786, 2962, 2785, 3546, 3230, 2647, 3229, 2784, 2961, 
        2783, 3545, 3228, 2646, 3227, 2782, 2960, 3616, 3484, 3226, 2645, 
        3225, 1790, 2959, 2781, 3224, 2644, 3223, 3615, 2780, 2958, 2779, 
        3222, 2643, 2399, 2778, 2957, 2777, 3471, 3457}], 
       Line3DBox[{2670, 1542, 2984, 1195, 3625, 2669, 1193, 2983, 3624, 1192, 
        2668, 1190, 2982, 3623, 1189, 2667, 1187, 2981, 1186, 2666, 1184, 
        3536, 2980, 1183, 2665, 1181, 3535, 2979, 1180, 2664, 3560, 1178, 
        2978, 1177, 2663, 3559, 1175, 2977, 1174, 3622, 2662, 1172, 2976, 
        1171, 2661, 1169, 2975, 3621, 1168, 2660, 1166, 2974, 3620, 1165, 
        2659, 1163, 3534, 2973, 1162, 2658, 1160, 2972, 1159, 2657, 3558, 
        1158, 2971, 1574, 3459}], 
       Line3DBox[{106, 720, 1631, 107, 721, 1632, 108, 722, 1633, 109, 2149}],
        Line3DBox[{2684, 3461, 3462, 2998, 3287, 3578, 3506, 2683, 3285, 3286,
         2997, 3505, 3577, 3284, 2682, 3282, 3283, 2996, 2465, 3281, 2681, 
        3279, 3280, 2995, 3278, 3277, 2680, 3276, 2464, 2994, 3275, 3274, 
        2679, 3273, 3630, 3504, 2993, 3272, 3271, 2678, 3503, 3629, 3270, 
        2992, 3269, 3268, 2677, 3561, 3266, 3267, 2991, 3265, 3264, 3628, 
        2676, 3262, 3263, 2990, 3261, 3576, 3260, 2675, 3258, 3259, 2989, 
        3502, 3575, 3257, 2674, 3255, 3256, 2988, 3627, 3254, 3253, 2673, 
        3252, 2450, 2987, 3251, 3250, 2672, 3248, 3626, 3249, 2986, 3247, 
        3246, 2671, 2448, 3245, 2985, 3473, 3472, 3460}], 
       Line3DBox[{2685, 3463, 3464, 2999, 3142, 1708, 2876, 3288, 3289, 3000, 
        3143, 3579, 2742, 2877, 3290, 3291, 3001, 2263, 2743, 2878, 3292, 
        3293, 3528, 3002, 3144, 2744, 2879, 3294, 3631, 3507, 3003, 3145, 
        2745, 2880, 3295, 3632, 3296, 3004, 3146, 2746, 2881, 3562, 3297, 
        3298, 3005, 3147, 3478, 3598, 2882, 3299, 3300, 3006, 3148, 3580, 
        2747, 2883, 3301, 3302, 3007, 3494, 3581, 2748, 2884, 3303, 3304, 
        3008, 2269, 2749, 2885, 3305, 3306, 3009, 3149, 2750, 2886, 3307, 
        2491, 3010, 3150, 2751, 2887, 3308, 3633, 3508, 3011, 3151, 2752, 
        2888, 3509, 3634, 3309, 3012, 3450, 2753, 3449}], 
       Line3DBox[{120, 733, 2155, 119, 732, 2154, 118, 731, 2153, 117, 730, 
        116, 1637, 729, 115, 1636, 728, 114, 1635, 727, 113, 1634, 726, 2152, 
        112, 725, 2151, 111, 724, 2150, 110, 723}], 
       Line3DBox[{2686, 1550, 3013, 923, 3599, 2889, 1278, 3014, 924, 2890, 
        1281, 3015, 3600, 925, 2891, 1284, 3529, 3016, 926, 2892, 1287, 3530, 
        3017, 927, 2893, 1290, 3018, 928, 2894, 3563, 1293, 3019, 929, 3601, 
        2895, 1296, 3020, 930, 3602, 2896, 1299, 3021, 3603, 931, 2897, 1302, 
        3022, 3604, 932, 2898, 1305, 3023, 933, 2899, 1308, 3531, 3024, 934, 
        2900, 1311, 3532, 3025, 935, 2901, 3564, 1313, 3026, 1517, 3451}], 
       Line3DBox[{2687, 3465, 2801, 3027, 3152, 2279, 2902, 3310, 2802, 3028, 
        3153, 3549, 3154, 2903, 3311, 2803, 3029, 2280, 3155, 2904, 3312, 
        3485, 3533, 3030, 3156, 3157, 2905, 3313, 3635, 2804, 3031, 3158, 
        3159, 2906, 3314, 3636, 2805, 3032, 3160, 3161, 2907, 2535, 2806, 
        3033, 3162, 3163, 3605, 2908, 3315, 2807, 3034, 3164, 2283, 2909, 
        3316, 2808, 3035, 3495, 3550, 3165, 2910, 3317, 2809, 3036, 2286, 
        3166, 2911, 3318, 2810, 3037, 3167, 3168, 2912, 3319, 1853, 3038, 
        3169, 3170, 2913, 3320, 3637, 2811, 3039, 3171, 3172, 2914, 3510, 
        3638, 2812, 3040, 3453, 3454, 3452}], 
       Line3DBox[{1555, 381, 2051, 584, 382, 2052, 585, 383, 2053, 586, 
        2054}], Line3DBox[{1520, 394, 2064, 596, 393, 2063, 595, 392, 2062, 
        594, 391, 593, 2061, 390, 592, 2060, 389, 591, 2059, 388, 590}], 
       Line3DBox[{2701, 3467, 2835, 3054, 2834, 3346, 3645, 2700, 3345, 2833, 
        3053, 2832, 3552, 3344, 2699, 3343, 2831, 3052, 3644, 3490, 3342, 
        2698, 3341, 2830, 3051, 2829, 3340, 2697, 3339, 3489, 3538, 3050, 
        2828, 3338, 2696, 3337, 3643, 2827, 3049, 2826, 3336, 2695, 3567, 
        3335, 2825, 3048, 2824, 3334, 2694, 3566, 3333, 2823, 3047, 2822, 
        3332, 3642, 2693, 3331, 2821, 3046, 2820, 3551, 3330, 2692, 3329, 
        2819, 3045, 3641, 3488, 3328, 2691, 3327, 2818, 3044, 3640, 3487, 
        3326, 2690, 3325, 3486, 3537, 3043, 2817, 3324, 2689, 3323, 3639, 
        2816, 3042, 2815, 3322, 2688, 3565, 3321, 2814, 3041, 2813, 3474, 
        3466}], Line3DBox[{2715, 3469, 3470, 3068, 3396, 3395, 3652, 2714, 
        3393, 3394, 3067, 2617, 3392, 2713, 3390, 3391, 3066, 3651, 3389, 
        3388, 2712, 3386, 3387, 3065, 3385, 3384, 2711, 3382, 3383, 3540, 
        3064, 3381, 3380, 2710, 3379, 3650, 3511, 3063, 3378, 3377, 2709, 
        3570, 3375, 3376, 3062, 3374, 3373, 2708, 3569, 3371, 3372, 3061, 
        3370, 3369, 3649, 2707, 3367, 3368, 3060, 3366, 3582, 3365, 2706, 
        3363, 3364, 3059, 3648, 3362, 3361, 2705, 3359, 3360, 3058, 3647, 
        3358, 3357, 2704, 3355, 3356, 3539, 3057, 3354, 3353, 2703, 3351, 
        3646, 3352, 3056, 3350, 3349, 2702, 3568, 3347, 3348, 3055, 3476, 
        3475, 3468}], 
       Line3DBox[{2729, 3441, 3442, 3082, 3440, 3588, 3521, 2728, 3438, 3439, 
        3081, 3520, 3587, 3437, 2727, 3435, 3436, 3080, 3519, 3586, 3434, 
        2726, 3432, 3433, 3079, 3431, 3430, 2725, 3429, 3659, 3518, 3078, 
        3428, 3427, 2724, 3426, 3658, 3517, 3077, 3425, 3424, 2723, 3516, 
        3657, 3423, 3076, 3422, 3421, 2722, 3571, 3419, 3420, 3075, 3418, 
        3585, 3515, 2721, 3416, 3417, 3074, 3415, 3584, 3414, 2720, 3412, 
        3413, 3073, 3514, 3583, 3411, 2719, 3409, 3410, 3072, 3656, 3408, 
        3407, 2718, 3406, 3655, 3513, 3071, 3405, 3404, 2717, 3402, 3654, 
        3403, 3070, 3401, 3400, 2716, 3512, 3653, 3399, 3069, 3398, 3397, 
        2836}], Line3DBox[{384, 587, 2055, 385, 588, 2056, 386, 589, 2057, 
        387, 2058}]}}},
    VertexNormals->CompressedData["
1:eJztnXtcFdUWx09KqaQmaipm+eCj1xREMykfcLTyBT6INKOUT9fygVl6LUvz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     "]]},
  Axes->None,
  BoxRatios->NCache[{2, 2, GoldenRatio^(-1)}, {2, 2, 0.6180339887498948}],
  Boxed->False,
  Method->{},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerische Integration", "Subsection"],

Cell["\<\
F\[UDoubleDot]r eine Reihe von Integralen, f\[UDoubleDot]r die keine \
geschlossenen symbolischen Ausdr\[UDoubleDot]cke existieren, kann numerische \
Integration versucht werden.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "1", "3"], 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "1", "3"], 
  RowBox[{
   SuperscriptBox["x", 
    FractionBox["1", "x"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData["2.715081514645178`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["2.715081514645178`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]}], "Input"],

Cell[BoxData["0"], "Output"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1nk0Vvv3B/DHMxkyKyXzkBQZM1S0d4rbpNziUigkIqWBypAxQyWhm5Ki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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1},
  PlotRange->{{0, 20}, {1, 1.444667818851056}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "x"}], ")"}]}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(\\(\\(-1\\)\\) + x\\^\\(1\\/x\\)\\) does \
not converge on \\!\\({1, \[Infinity]}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "1", "\[Infinity]"], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", 
      FractionBox["1", "x"]]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "x"}], ")"}]}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({6.132236402772647`*^28}\\). NIntegrate obtained \
\\!\\(1.7541166899586654`*^8\\) and \\!\\(1.7070432577814826`*^8\\) for the \
integral and error estimates.\"\>"}]], "Message", "MSG"],

Cell[BoxData["1.7541166899586654`*^8"], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "u_", "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"1", "/", "x"}]], "-", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "u"}], "}"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"PaddedForm", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          SuperscriptBox["10", "n"], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "2", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"2", 
     TagBox[
      InterpretationBox["\<\"  11.51\"\>",
       11.507427996777631`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"3", 
     TagBox[
      InterpretationBox["\<\"  24.89\"\>",
       24.893613590952043`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"4", 
     TagBox[
      InterpretationBox["\<\"  43.48\"\>",
       43.476794349994265`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"5", 
     TagBox[
      InterpretationBox["\<\"  67.34\"\>",
       67.33981128801788,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"6", 
     TagBox[
      InterpretationBox["\<\"  96.50\"\>",
       96.50092852787604,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"7", 
     TagBox[
      InterpretationBox["\<\" 130.96\"\>",
       130.96336186594954`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"8", 
     TagBox[
      InterpretationBox["\<\" 170.73\"\>",
       170.72761043281983`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"9", 
     TagBox[
      InterpretationBox["\<\" 215.79\"\>",
       215.79374604028732`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]},
    {"10", 
     TagBox[
      InterpretationBox["\<\" 266.16\"\>",
       266.16177810242766`,
       AutoDelete->True],
      PaddedForm[#, {5, 2}]& ]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Right}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "10", ",", "1000"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Hk81AkDBvBJU0ZWrrBuwxhncoyZYRmPiKxraR2bN2eSsuRI5BrkWDlC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 5.},
  PlotRange->{{10, 1000}, {3.1013964269530048`, 24.893613450904013`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "u", "]"}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Log", "[", "u", "]"}], "2"], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "3", ",", 
     SuperscriptBox["10", "3"]}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Dotted"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV0Wk41AsDBXDZkitr2cvYEskymJkMzZFdhURqSnXL/pQ1skyWLEkYJJGr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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwV0Hk81IsCBXBUV4SEbE0x6JE0DLPY55CxJy3S8khTGAkRhaZBQ2SbmUhG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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{3, 1000}, {0., 24.893613449913783`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uneigentliche Integrale", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "x"]}], ",", "1"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"1", "/", "2"}]]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   FractionBox["\[Pi]", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   SuperscriptBox["E", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erf", "[", "x", "]"}]}], ",", 
   FractionBox[
    SqrtBox["\[Pi]"], "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"s", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      FractionBox["1", "2"], ",", 
      FractionBox["1", "3"], ",", 
      FractionBox["3", "2"], ",", 
      SuperscriptBox["x", "2"]}], "]"}]}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}], 
    RowBox[{"Gamma", "[", 
     FractionBox["1", "6"], "]"}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"s", ",", "30"}], "]"}]], "Input"],

Cell[BoxData["1.293554779614895267476757512565605818832886376263`30."], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", "x"]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(1\\/x\\) does not converge on \\!\\({\\(\
\\(-1\\)\\), 1}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], "1"], 
    RowBox[{
     FractionBox["1", "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdlXs8FPgCxcdryCsxvUORR5I804NWqZa1GwohSkQ3UXIlKUpbFN1sKiV2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     "]], LineBox[CompressedData["
1:eJwd1Hk01PsbB/CxjLE3tnsz2hAu7qnIla37fEJSRjcRYrK2l5RfkSulwti3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     "]], 
    LineBox[{{-0.0009037596386804051, -5.}, {-0.000897468214066935, 5.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(1\\/x\\^2\\) does not converge on \
\\!\\({\\(\\(-1\\)\\), 1}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "x"]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], "1"], 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["x", "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdxQk0lIsbgPEZ2ZMrtKibZAsRWSpJ7yctSrkiboSEFiRLSFGWFpJSKiE3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     "]], LineBox[CompressedData["
1:eJwd1Hk0FHwXB/AZ2bdQZCmF0qKeVpLU95elyPI8laUshZKHEsmSVEpKUZJW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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "a"}]}], "}"}]}], "]"}], "+", 
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "b", ",", "1"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Re", "[", "a", "]"}], "\[GreaterEqual]", "0"}], "||", 
     RowBox[{
      RowBox[{"Im", "[", "a", "]"}], "\[NotEqual]", "0"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["1", "a"]}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["x", "2"]], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "a"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"!", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Re", "[", "a", "]"}], "\[GreaterEqual]", "0"}], "||", 
          RowBox[{
           RowBox[{"Im", "[", "a", "]"}], "\[NotEqual]", "0"}]}], ")"}]}]}]}],
      "]"}]}], "]"}], "+", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", 
         FractionBox["b", 
          RowBox[{"1", "-", "b"}]], "]"}], "\[GreaterEqual]", "0"}], "&&", 
       RowBox[{
        FractionBox["b", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "b"}]], "\[NotEqual]", "0"}]}], ")"}], "||",
      
     RowBox[{
      RowBox[{"Re", "[", 
       FractionBox["b", 
        RowBox[{"1", "-", "b"}]], "]"}], "\[LessEqual]", 
      RowBox[{"-", "1"}]}], "||", 
     RowBox[{
      RowBox[{"Im", "[", 
       FractionBox["b", 
        RowBox[{"1", "-", "b"}]], "]"}], "\[NotEqual]", "0"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["1", "b"]}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["x", "2"]], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "b", ",", "1"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"!", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Re", "[", 
              FractionBox["b", 
               RowBox[{"1", "-", "b"}]], "]"}], "\[GreaterEqual]", "0"}], "&&",
             
            RowBox[{
             FractionBox["b", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "b"}]], "\[NotEqual]", "0"}]}], ")"}],
           "||", 
          RowBox[{
           RowBox[{"Re", "[", 
            FractionBox["b", 
             RowBox[{"1", "-", "b"}]], "]"}], "\[LessEqual]", 
           RowBox[{"-", "1"}]}], "||", 
          RowBox[{
           RowBox[{"Im", "[", 
            FractionBox["b", 
             RowBox[{"1", "-", "b"}]], "]"}], "\[NotEqual]", "0"}]}], 
         ")"}]}]}]}], "]"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "a"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"Re", "[", "a", "]"}], ">", "0"}]}]}], "]"}], "+", 
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "b", ",", "1"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"Re", "[", "b", "]"}], ">", "0"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  FractionBox["1", "a"], "+", 
  FractionBox["1", "b"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "2"]}], ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdhws0FPgegOfRzNCYMUjIzWuXJa1IWYv8/z28KsrkbM567FUrj1psQlFJ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     "]], LineBox[CompressedData["
1:eJwdygs01HkfBvCZv2HMMBo7s+xS2zTOCm1rQyXh+8ObzaXInVdCbbJuke0l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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{Rational[-1, 2] Pi, Rational[1, 2] Pi}, {0, 
     5}}, {{-1.5707963267948966`, 1.5707963267948966`}, {0, 5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", 
   FractionBox["\[Pi]", "2"]], 
  RowBox[{"f", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(1\\/\\@\\(1 - \\(\\(Cos[x]\\)\\)\\)\\) \
does not converge on \\!\\({0, \[Pi]\\/2}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", 
   FractionBox["\[Pi]", "2"]], 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "2"]}], ",", 
     FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(1\\/\\@\\(1 - \\(\\(Cos[x]\\)\\)\\)\\) \
does not converge on \\!\\({\\(\\(-\\(\\(\[Pi]\\/2\\)\\)\\)\\), \
\[Pi]\\/2}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", 
    FractionBox["\[Pi]", "2"]}], 
   FractionBox["\[Pi]", "2"]], 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f0", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Tan", "[", 
     FractionBox["x", "4"], "]"}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "x", "]"}]}]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"f0", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], "<", "x", "<", 
      FractionBox["\[Pi]", "2"]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "x", "]"}]}]], " ", 
  RowBox[{"Csc", "[", 
   FractionBox["x", "2"], "]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"Tan", "[", 
    FractionBox["x", "4"], "]"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"f0", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", "<", "x", "<", 
      FractionBox["\[Pi]", "2"]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"Tan", "[", 
    FractionBox["x", "4"], "]"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SqrtBox["2"], "x"], "+", 
   FractionBox["x", 
    RowBox[{"12", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"2880", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, -1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2^Rational[1, 2], 0, Rational[1, 12] 2^Rational[-1, 2], 0, 
    Rational[7, 2880] 2^Rational[-1, 2]}, -1, 4, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Normal", "[", "s", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "100"}], ",", "100"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Dotted"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwdxQk4FAgbwPGRo8Um0opBh6O2dlgN0UWvGdMwDMZ9lcUWIoSvg08hIoUZ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     "]], 
    LineBox[CompressedData["
1:eJwdyQk41AkfB3CVXKXe5KhIKVpqxJIppvH7OXIMGYYZRlg6dmmlTTmjt2RK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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwdiXk8FIgewKfSgV0lZZlIuUpNVkNsRGPGhGEwjuRKZSt2hOiV4zkm5IwZ
t8kxF6YhXezmJb+fTahNS4U86c7rQEPDI9Hue9/P5/v5/vHdfCTS8+hSAoEQ
8bf/q9F99czy8hZYzMqqvedCQv+i9+FFxS3QXj//ysaDhHmB7ax8Xgu8f0pK
b/Qm4cxY1Ib0rBZwsYhaKA0iYef3vY1RcS1wKOG73oRIEh5zz+t39GsBzlh2
YUYhCaUPVQxmtFrgT5Nqv6anJCQNLWvzLLsBxnqizOyYHXhmJHLiOOc3cEud
64BeU3QxNx6Z/eevQKzWWbxMNENeq2VVTWIzmFzviHs7ZIZE23a/xtAmmEoL
2hjTthNNV5c8Ih+7DkOKgB/bZWRMe/LGUcPtGqS7CQnO3ebo2n8+b7XNVcjb
Pm39dtkurDLgFGZYX4EgQf3d/7pb4tGHT41+c2oEVpLy+ZvvrVBEcBXut2+A
8Jvze7YLd+Pt4sj2HQ4ySBpoII7wbDBMO2OgdYMUuj8y0hOV7VDpXo+8UUMK
OXcyArM07LAqfp2qUFUKgtinExd07fDxsHBv+nwdhFWPB/fvtENKVauUOVwH
lN08c76/HWoZTMU/49eB32VB28lLdthJCtIjEOsg5Qqycg7sRQOKeShNqxao
3RY+6iEUjEXmkczVtdCx6OB0PoyC9ymhgT0raiEjwStYLYqCp+0rPXyna+CP
9VPqmxIpeI+6cjf7YQ3oTqpYnS2lYDR9WLkwtwY2Nfuuceyh4O+M1PpXhBr4
KMutW2Jrj0d8Hk1w3oshqIe8fMCUip51KV2fXojha58cGyypSJvbIQh6IoaV
chNqth0VDSszWbu7xCCW0274uVFx9I1tk1wiBtuL8nCXCCqyT0njgg+J4RG9
+wvnMhVPFSYq2Q6KgKM0sCXZioY/v902InsgAiti4GMKhYY+Vk+atTpFEHv0
QbKKMw0th8nHFU0i8JWd+NbsT8NZ/Xd36wtEUH2wfSgiiYaJ1zzziW4isJAW
EaK7aHiubwtxtkMIb3pGe9YecsBlp7t651qFcIKfu9Y+zAFTiMcz5puEYLXD
Wngm2gHjQ2oVixIhmCa33l1Ic8AT04Z/Lk8XQqiOa0akzAG9tfXTNOhCMP4W
PTc144D6h3UmTO8I4PnlyDO9JXSsXt4qMbslgMlWabiekI46soAAcrMACpRU
98bW01HzM797V40A3gv1mxyRjsrp2uI96QKYuJseE/yBjnKp5gEGXQC1VwNp
yZR9mPByc9of2dUgkY9YTCj24bu7q66eiqsGfqh6ZuESR9x/7dOIbmg1jH2e
6dun5ojk1FtWUfRqmHZorx3c4ogfDP0+riNUA3V69QdJgCP6h3I9D/6jCqIH
NSyXdTriT58WN00GV0Kq1bgsvdYJawffMvlulfDlwYCC2OyE6/B+PM22EtiZ
Ndntt51QzuU/LiZWQmIIfz3tpRPWkS0zrfsrQEpsI27QdUbN0yc+pTIq4MXS
bRE2Zc6o+Dp8S3PXBVhUf3WRXMnA+Oy62v8YXgDJZxF/zSUGLtGKyb+x7gJM
rI8/u+QWA9XMVQ77K/igqboGdUYYuDXsJ6Wq63wQ7kxo37PRBQP7ixhGZD4M
3OGFUyUu2HGJOWj+Yzmwi+1exqArMmy0UUmvHDYMl3PmHrpiX/cbab9aOVSZ
zamVvnXFZ68T4s9MlMHDRoN6oioTZ7VlujcvlQF3iKPj7MtE0rkVP1NJZfBl
udKmCAUTiw+C3MOkFFTpky/daO7IzSGXd/1QChzqCsp3Ae6YfaPG3m5FKVQJ
5V3j0e6Ysja3YPvrEoit6BRuFLvjL50HLFZUlkA+5/oxwVIPpJhOnbm5pgRy
Vikn/RLqgR8XDL8ZzRZBuIR1T0Fj4ei2srqK0SJYShswPunJwhe+qh4a/X//
oZ7R5YdZOHB1UkC4VgTJVzWy4pJYiEfbqMPsIojVTmFy/8XCkh7fc9znhVCs
H8D+1coT7Suzv5/vLICLE1unxhy9MPqEQczt5gIYJOiMyfy8UGLb+iRHUgDh
Wzn1WWwvXPVsXKxztgD08k+9k+V7Ye9GlrWdbQF09TDrzg154UHBD8c513ng
zNzF/BLjjdyoK/edRTzocggOm8rwxt8pzuS1PB4oK2Jl6hXeaPQyfkEUwQPj
Dja7q8MbxzY/K+ww4cFX3uUFHS0fTBBLcKWAC/b7RaHPO32wIcbWuDePC9N9
iUZpIz74jDaQU5bIhSfnOrcdUPgg9c1KX5MALgS/eB3C1d+PKkbscYYmF+h3
CCc9OfvRjBlioaOdD//2+dzW4OSLeUwV0uRMLhD+jx/+BTYUmTQ=
     "]], 
    LineBox[CompressedData["
1:eJwdygk01IseB3DVFKPUu6JVStGlxnItUwx+P2NnLA0z4uIivSLpRbJENzJS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     "]], 
    LineBox[{{-0.00003006989431168561, -100.}, {-0.000029971034111521677`, 
     100.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.1, 0.1}, {-100, 100}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "-", 
     FractionBox[
      SqrtBox["2"], "x"]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], " ", 
  RowBox[{"Log", "[", 
   FractionBox[
    RowBox[{"8", " ", 
     RowBox[{"Tan", "[", 
      FractionBox["\[Pi]", "8"], "]"}]}], "\[Pi]"], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "-", 
     FractionBox[
      SqrtBox["2"], "x"]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], ",", 
      FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  SqrtBox["2"], " ", 
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["1", "2"], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "4"], ",", 
        FractionBox["3", "4"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        FractionBox["1", "2"]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"-", "1"}], ",", "2"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.9739178375728095`"}], "-", 
  RowBox[{"3.1014760968576036`", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i3", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "-", 
     FractionBox[
      SqrtBox["2"], 
      RowBox[{"Abs", "[", "x", "]"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], ",", 
      FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["2"], " ", 
  RowBox[{"Log", "[", 
   FractionBox[
    RowBox[{"8", " ", 
     RowBox[{"Tan", "[", 
      FractionBox["\[Pi]", "8"], "]"}]}], "\[Pi]"], "]"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrale mit Parametern", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["E", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", "0"}], ",", 
   FractionBox[
    SqrtBox["\[Pi]"], 
    RowBox[{"2", " ", 
     SqrtBox["a"]}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["x", "2"]}]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "a", "]"}], "\[LessEqual]", "0"}]}]}], "]"}]}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox["E", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "a", "]"}], ">", "0"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], 
  RowBox[{"2", " ", 
   SqrtBox["a"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox["E", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "a", "]"}], "<", "0"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(\[ExponentialE]\\^\\(\\(\\(-a\\)\\)\\\\ \
x\\^2\\)\\) does not converge on \\!\\({0, \[Infinity]}\\).\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "a", "]"}], "<", "0"}]}]}], "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pfadintegrale im Komplexen", "Subsection"],

Cell["\<\
F\[UDoubleDot]r gen\[UDoubleDot]gend glatte Funktionen gilt der Hauptsatz der \
Integralrechnung auch im Komplexen. Deshalb k\[ODoubleDot]nnen die folgenden \
bestimmten Integrale \[UDoubleDot]ber Einsetzen der Integrationsgrenzen in \
die Stammfunktion ermittelt werden.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"1", "+", "I"}]], 
  RowBox[{
   SuperscriptBox["z", "2"], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["2", "3"]}], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"\[Pi]", " ", "I"}]], 
  RowBox[{"z", " ", 
   RowBox[{"Cos", "[", 
    SuperscriptBox["z", "2"], "]"}], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"Sin", "[", 
   SuperscriptBox["\[Pi]", "2"], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Hat die Funktion dagegen Singularit\[ADoubleDot]ten wie hier ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "z"], TraditionalForm]]],
 " eine Polstelle bei z=0, so ist der Wert des Integrals vom Integrationsweg \
abh\[ADoubleDot]ngig. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Integral of \\!\\(1\\/z\\) does not converge on \\!\\({\\(\
\\(-1\\)\\), 1}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "1"}], "1"], 
  RowBox[{
   FractionBox["1", "z"], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
W\[UDoubleDot]rde der Hauptsatz der Integralrechnung zur Anwendung kommen, so \
w\[ADoubleDot]re das Ergebnis gleich -\[ImaginaryI] \[Pi]. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "[", "z_", "]"}], "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", "z"], 
    RowBox[{"\[DifferentialD]", "z"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F", "[", "1", "]"}], "-", 
  RowBox[{"F", "[", 
   RowBox[{"-", "1"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Log", "[", "z", "]"}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Diese Rechnung zeigt, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (nun) wei\[SZ], dass der Wert des Integrals vom Integrationspfad abh\
\[ADoubleDot]ngt.\n\n",
 StyleBox["Integrate",
  FontWeight->"Bold"],
 " verwendet als Pfad immer die direkte geradlinige Verbindung zwischen den \
Integrationsgrenzen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", ">", "0"}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], 
     RowBox[{"1", "+", 
      RowBox[{"I", " ", "a"}]}]], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", 
    RowBox[{"\[ImaginaryI]", " ", "a"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", "<", "0"}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], 
     RowBox[{"1", "+", 
      RowBox[{"I", " ", "a"}]}]], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"\[ImaginaryI]", " ", "a"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"1", "+", "a"}], "]"}], "-", 
  RowBox[{"F", "[", 
   RowBox[{"-", "1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "a"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Im zweiten Parameter des ",
 StyleBox["Integrate",
  FontWeight->"Bold"],
 "-Kommandos k\[ODoubleDot]nnen mehrere St\[UDoubleDot]tzstellen angegeben \
werden. Das zugeh\[ODoubleDot]rige Integral wird als Summe der Teilintegrale \
berechnet."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", "z", "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "\[ExponentialE]"}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    FractionBox[
     RowBox[{"Cot", "[", 
      FractionBox["1", "2"], "]"}], 
     RowBox[{"1", "+", "\[ExponentialE]"}]], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Tan", "[", 
     FractionBox["1", "2"], "]"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " die Stammfunktion nicht berechnen, so wird das Integral unausgewertet zur\
\[UDoubleDot]ckgegeben. In diesen F\[ADoubleDot]llen kann eine numerische \
Auswertung mit ",
 StyleBox["% // N",
  FontWeight->"Bold"],
 " oder ",
 StyleBox["NIntegrate",
  FontWeight->"Bold"],
 " noch zu brauchbaren numerischen Werten f\[UDoubleDot]hren. Die symbolische \
Ausertung dauert hier ziemlich lange."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"Sin", "[", "z", "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1", ",", "\[ImaginaryI]", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"6.2831853071795765`", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Viele Warnungen ergeben sich, wenn der Wert des Integrals gleich Null ist. \
Hier hilft oft eine Zerlegung des Integrationspfades in mehrere Teile.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["z", "2"], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(z\\) near \\!\\({z}\\) = \
\\!\\({2.76990133638922052432986798580204914618864284497153983530204398084`65.\
954589770191*^-15 - \\(\\(\\(\\(\[LeftSkeleton] 83 \[RightSkeleton]\\)\\)\\\\ \
\[ImaginaryI]\\)\\)}\\). NIntegrate obtained \\!\\(3.0704605524789486`*^-16 - \
\\(\\(3.0531133177191805`*^-16\\\\ \[ImaginaryI]\\)\\)\\) and \
\\!\\(3.309051717675891`*^-13\\) for the integral and error \
estimates.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"0``12.63081144296415", "+", 
  RowBox[{"0``12.63081144296415", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Sin", "[", 
      SuperscriptBox["z", "2"], "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1", ",", "I", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "+", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Sin", "[", 
      SuperscriptBox["z", "2"], "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"6.2831853071795765`", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Eine (etwas komplexere) Analyse der Residuen zeigt, dass das richtige \
Ergebnis 2 \[ImaginaryI] \[Pi] lautet. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], "\[Equal]", "0"}], ",", "z"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Solve\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"z", "\[Rule]", "0"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], "\[Equal]", "0"}], ",", "z"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{"(", 
   RowBox[{
    RowBox[{"z", "\[Equal]", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"2", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}], "||", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"2", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}], "||", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"\[Pi]", "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}], "||", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"\[Pi]", "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Die L\[ODoubleDot]sung kann auch k\[UDoubleDot]rzer als 
   z \[Equal] ArcSin[\[Pi] C[1]]+ \[Pi] C[2], C[1],C[2] \[Element] Integers
geschrieben werden. Von diesen liegt genau z=0 im Gebiet, welches vom \
Integrationspfad umschlossen wird. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Nach dem Resiudensatz ist also das Integral gleich 2 \[ImaginaryI] \[Pi].\n\
Die folgende Aufstellung zeigt, dass alle anderen ",
 StyleBox["z",
  FontSlant->"Italic"],
 " bereits einen zu gro\[SZ]en Realteil haben."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{"k", " ", "\[Pi]"}], "]"}], "//", "N"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"4.140208760146491`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"4.034788777250522`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"3.9169225870390156`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"3.783269869341139`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"3.628932172522998`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"3.446300223633231`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"3.2225845112382845`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"2.933662920962394`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"2.524630659933467`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5707963267948966`"}], "+", 
    RowBox[{"1.8115262724608532`", " ", "\[ImaginaryI]"}]}], ",", "0.`", ",", 
   
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.8115262724608532`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.524630659933467`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.933662920962394`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"3.2225845112382845`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"3.446300223633231`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"3.628932172522998`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"3.783269869341139`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"3.9169225870390156`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"4.034788777250522`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
    RowBox[{"4.140208760146491`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Pfadintegrale lassen sich auch direkt berechnen.", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pfadIntegral", "[", 
   RowBox[{"f_", ",", "z_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", "[", "t", "]"}], "]"}], 
     RowBox[{
      RowBox[{"z", "'"}], "[", "t", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input"],

Cell["\<\
F\[UDoubleDot]r obiges Beispiel und geradlinigen Pfad ergibt sich eine \
geschlossene Formel, die f\[UDoubleDot]r a\[Rule]+0 und a\[Rule]-0 \
verschiedene Werte ergibt.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "z_", "]"}], ":=", 
  RowBox[{"1", "/", "z"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"t", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"I", " ", "a"}]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "\[Element]", "Reals"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"pfadIntegral", "[", 
    RowBox[{"f", ",", "\[Gamma]"}], "]"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Log", "[", 
  FractionBox["\[ImaginaryI]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "a"}]], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"%", ",", 
     RowBox[{"a", "\[Rule]", "0"}], ",", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Auch hier darf nicht einfach der Hauptsatz der Integralrechnung zur Anwendung \
kommen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"\[Gamma]", "[", "t", "]"}], "]"}], 
     RowBox[{
      RowBox[{"\[Gamma]", "'"}], "[", "t", "]"}]}], ",", "t"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"\[ImaginaryI]", "+", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "t"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "1"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "0"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"\[ImaginaryI]", "-", "a"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"%", ",", 
     RowBox[{"a", "\[Rule]", "0"}], ",", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Pfadintegrale lassen sich mit ",
 StyleBox["pfadIntegral",
  FontWeight->"Bold"],
 " auch \[UDoubleDot]ber kompliziertere Pfade berechnen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "\[Pi]", " ", "t"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Pi]", " ", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pfadIntegral", "[", 
  RowBox[{"f", ",", "\[Gamma]"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell["\<\
Das dauert manchmal l\[ADoubleDot]nger, denn auch hier gilt, dass nicht \
einfach der Haupsatz der Integralrechnung angewendet werden kann. Die \
Stammfunktion selbst ist schnell berechnet.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", "z", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "\[Pi]", " ", "t"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Pi]", " ", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pfadIntegral", "[", 
   RowBox[{"f", ",", "\[Gamma]"}], "]"}], "//", "Timing"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"94.66`", ",", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"\[Gamma]", "[", "t", "]"}], "]"}], 
  RowBox[{
   RowBox[{"\[Gamma]", "'"}], "[", "t", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}]}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"%", ",", "t"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}]}], ")"}]}], "]"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "1"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "0"}]}], ")"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["Residuen", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", "z", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["z", "2"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["z", "2"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["z", "2"]], "+", 
   FractionBox[
    SuperscriptBox["z", "2"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"],
    SeriesData[$CellContext`z, 0, {}, -2, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 0, 0, 
    Rational[1, 6]}, -2, 4, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Als Beispiel berechnen wir das komplexe\nWegintegral auf dem Kreis um den \
Mittelpunkt z=0 und mit dem Radius ",
 Cell[BoxData[
  FormBox[
   FractionBox["3", "2"], TraditionalForm]]],
 " f\[UDoubleDot]r die Funktion \[LineSeparator]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"22", "z"}], "+", "8"}], 
    RowBox[{
     SuperscriptBox["z", "3"], "-", 
     RowBox[{"5", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"4", "z"}]}]]}]], "Input",
  CellChangeTimes->{3.36422119653342*^9}],
 "."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "z"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"22", "z"}], "+", "8"}], 
    RowBox[{
     SuperscriptBox["z", "3"], "-", 
     RowBox[{"5", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"4", "z"}]}]]}], ";"}]}], "Input"],

Cell["Bestimmen der Singularit\[ADoubleDot]ten.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Denominator", "[", 
     RowBox[{"f", "[", "z", "]"}], "]"}], "\[Equal]", "0"}], ",", "z"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Summe \[UDoubleDot]ber die Residuen innerhalb des Integrationsbereichs.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", "I", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0"}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1"}], "}"}]}], "]"}]}], ")"}], " "}]], "Input"],

Cell[BoxData[
 RowBox[{"14", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["pfadIntegral",
  FontWeight->"Bold"],
 " liefert dasselbe Ergebnis."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"3", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", "\[Pi]", " ", "t"}], "]"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "\[Pi]", " ", "t"}], "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pfadIntegral", "[", 
  RowBox[{"f", ",", "\[Gamma]"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"14", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{659, 629},
WindowMargins->{{Automatic, 261}, {Automatic, 14}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 50, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[665, 27, 40, 0, 55, "Section"],
Cell[708, 29, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[809, 34, 41, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[875, 38, 165, 5, 59, "Input"],
Cell[1043, 45, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1108, 50, 267, 9, 44, "Input"],
Cell[1378, 61, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1443, 66, 222, 7, 58, "Input"],
Cell[1668, 75, 42, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1747, 80, 304, 10, 61, "Input"],
Cell[2054, 92, 28, 0, 44, "Output"]
}, Open  ]],
Cell[2097, 95, 56, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[2178, 99, 169, 5, 57, "Input"],
Cell[2350, 106, 55, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2442, 112, 217, 6, 41, "Input"],
Cell[2662, 120, 38, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2737, 125, 319, 10, 44, "Input"],
Cell[3059, 137, 18356, 309, 267, 11567, 196, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[21430, 449, 146, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[21601, 456, 244, 8, 44, "Input"],
Cell[21848, 466, 504, 15, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22389, 486, 278, 9, 58, "Input"],
Cell[22670, 497, 544, 14, 68, "Output"]
}, Open  ]],
Cell[23229, 514, 96, 2, 42, "SmallText"],
Cell[CellGroupData[{
Cell[23350, 520, 165, 5, 58, "Input"],
Cell[23518, 527, 129, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23684, 536, 223, 7, 58, "Input"],
Cell[23910, 545, 82622, 1362, 247, 42661, 705, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[106547, 1910, 81, 2, 42, "SmallText"],
Cell[CellGroupData[{
Cell[106653, 1916, 306, 11, 71, "Input"],
Cell[106962, 1929, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107027, 1934, 171, 5, 46, "Input"],
Cell[107201, 1941, 28, 0, 44, "Output"]
}, Open  ]],
Cell[107244, 1944, 266, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[107535, 1954, 195, 6, 59, "Input"],
Cell[107733, 1962, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107798, 1967, 189, 6, 59, "Input"],
Cell[107990, 1975, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108055, 1980, 276, 9, 59, "Input"],
Cell[108334, 1991, 42, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108413, 1996, 246, 8, 44, "Input"],
Cell[108662, 2006, 37, 0, 44, "Output"]
}, Open  ]],
Cell[108714, 2009, 75, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[108814, 2013, 259, 8, 59, "Input"],
Cell[109076, 2023, 57, 1, 44, "Output"]
}, Open  ]],
Cell[109148, 2027, 133, 3, 42, "SmallText"],
Cell[109284, 2032, 329, 12, 71, "Input"],
Cell[CellGroupData[{
Cell[109638, 2048, 213, 7, 44, "Input"],
Cell[109854, 2057, 169, 5, 24, "Message"],
Cell[110026, 2064, 495, 17, 71, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110558, 2086, 156, 4, 44, "Input"],
Cell[110717, 2092, 367, 7, 53, "Message"],
Cell[111087, 2101, 433, 14, 71, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111557, 2120, 199, 6, 44, "Input"],
Cell[111759, 2128, 243, 8, 59, "Output"]
}, Open  ]],
Cell[112017, 2139, 183, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[112225, 2147, 206, 6, 44, "Input"],
Cell[112434, 2155, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112499, 2160, 206, 6, 44, "Input"],
Cell[112708, 2168, 38, 0, 44, "Output"]
}, Open  ]],
Cell[112761, 2171, 178, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[112964, 2178, 287, 8, 44, "Input"],
Cell[113254, 2188, 233922, 3812, 320, 176589, 2871, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[347191, 6003, 159, 3, 59, "SmallText"],
Cell[CellGroupData[{
Cell[347375, 6010, 351, 10, 44, "Input"],
Cell[347729, 6022, 71, 2, 58, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[347849, 6030, 34, 0, 45, "Subsection"],
Cell[347886, 6032, 44, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[347955, 6036, 173, 5, 44, "Input"],
Cell[348131, 6043, 947, 30, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[349115, 6078, 172, 5, 44, "Input"],
Cell[349290, 6085, 836, 30, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[350163, 6120, 215, 7, 59, "Input"],
Cell[350381, 6129, 1335, 46, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[351753, 6180, 181, 6, 52, "Input"],
Cell[351937, 6188, 871, 31, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352845, 6224, 58, 1, 44, "Input"],
Cell[352906, 6227, 73, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353016, 6232, 235, 6, 44, "Input"],
Cell[353254, 6240, 161, 6, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353452, 6251, 266, 8, 44, "Input"],
Cell[353721, 6261, 2583, 82, 113, "Output"]
}, Open  ]],
Cell[356319, 6346, 94, 2, 42, "SmallText"],
Cell[CellGroupData[{
Cell[356438, 6352, 198, 6, 44, "Input"],
Cell[356639, 6360, 192, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356868, 6371, 159, 5, 59, "Input"],
Cell[357030, 6378, 49, 1, 58, "Output"]
}, Open  ]],
Cell[357094, 6382, 119, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[357238, 6389, 142, 4, 44, "Input"],
Cell[357383, 6395, 595, 20, 62, "Output"]
}, Open  ]],
Cell[357993, 6418, 189, 2, 45, "Text"],
Cell[358185, 6422, 324, 11, 62, "Input"],
Cell[CellGroupData[{
Cell[358534, 6437, 116, 3, 44, "Input"],
Cell[358653, 6442, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358718, 6447, 141, 4, 44, "Input"],
Cell[358862, 6453, 755, 26, 62, "Output"]
}, Open  ]],
Cell[359632, 6482, 239, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[359896, 6490, 264, 8, 65, "Input"],
Cell[360163, 6500, 456, 15, 62, "Output"],
Cell[360622, 6517, 211, 5, 45, "Message"],
Cell[360836, 6524, 40, 0, 44, "Output"]
}, Open  ]],
Cell[360891, 6527, 212, 8, 42, "SmallText"],
Cell[CellGroupData[{
Cell[361128, 6539, 83, 2, 44, "Input"],
Cell[361214, 6543, 154, 5, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[361405, 6553, 80, 2, 44, "Input"],
Cell[361488, 6557, 52, 1, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[361577, 6563, 406, 13, 44, "Input"],
Cell[361986, 6578, 36946, 615, 259, 28661, 478, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[398969, 7198, 239, 7, 44, "Input"],
Cell[399211, 7207, 338, 11, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[399586, 7223, 435, 14, 44, "Input"],
Cell[400024, 7239, 52816, 878, 265, 42713, 711, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[452889, 8123, 46, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[452960, 8127, 204, 6, 44, "Input"],
Cell[453167, 8135, 722, 24, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[453926, 8164, 192, 6, 46, "Input"],
Cell[454121, 8172, 823, 28, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[454981, 8205, 267, 9, 46, "Input"],
Cell[455251, 8216, 947, 32, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[456235, 8253, 55, 1, 44, "Input"],
Cell[456293, 8256, 756, 29, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457086, 8290, 55, 1, 44, "Input"],
Cell[457144, 8293, 190, 6, 46, "Output"]
}, Open  ]],
Cell[457349, 8302, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[457450, 8307, 280, 10, 70, "Input"],
Cell[457733, 8319, 787, 25, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[458557, 8349, 233, 7, 44, "Input"],
Cell[458793, 8358, 369, 12, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[459199, 8375, 51, 1, 44, "Input"],
Cell[459253, 8378, 561, 18, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[459851, 8401, 51, 1, 44, "Input"],
Cell[459905, 8404, 565, 19, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[460507, 8428, 326, 10, 44, "Input"],
Cell[460836, 8440, 472, 16, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[461345, 8461, 50, 1, 46, "Input"],
Cell[461398, 8464, 482, 16, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[461917, 8485, 77, 2, 44, "Input"],
Cell[461997, 8489, 734, 23, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[462768, 8517, 76, 2, 44, "Input"],
Cell[462847, 8521, 109, 4, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[462993, 8530, 141, 4, 44, "Input"],
Cell[463137, 8536, 805, 25, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[463979, 8566, 107, 3, 57, "Input"],
Cell[464089, 8571, 884, 29, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[465010, 8605, 106, 3, 57, "Input"],
Cell[465119, 8610, 194, 7, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[465350, 8622, 141, 4, 44, "Input"],
Cell[465494, 8628, 937, 31, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[466468, 8664, 80, 2, 44, "Input"],
Cell[466551, 8668, 933, 30, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467521, 8703, 50, 1, 44, "Input"],
Cell[467574, 8706, 167, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467778, 8716, 72, 2, 58, "Input"],
Cell[467853, 8720, 799, 25, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[468689, 8750, 51, 1, 44, "Input"],
Cell[468743, 8753, 287, 9, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[469067, 8767, 163, 5, 58, "Input"],
Cell[469233, 8774, 799, 25, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[470069, 8804, 196, 6, 60, "Input"],
Cell[470268, 8812, 605, 20, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[470910, 8837, 200, 6, 44, "Input"],
Cell[471113, 8845, 545, 18, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[471695, 8868, 115, 3, 44, "Input"],
Cell[471813, 8873, 591, 20, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[472441, 8898, 175, 5, 44, "Input"],
Cell[472619, 8905, 591, 20, 62, "Output"]
}, Open  ]],
Cell[473225, 8928, 248, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[473498, 8938, 249, 8, 44, "Input"],
Cell[473750, 8948, 545, 18, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[474332, 8971, 249, 8, 44, "Input"],
Cell[474584, 8981, 593, 20, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[475214, 9006, 91, 2, 44, "Input"],
Cell[475308, 9010, 571, 19, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[475916, 9034, 204, 6, 44, "Input"],
Cell[476123, 9042, 571, 19, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[476731, 9066, 118, 3, 44, "Input"],
Cell[476852, 9071, 591, 20, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[477480, 9096, 94, 2, 44, "Input"],
Cell[477577, 9100, 287, 9, 46, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[477925, 9116, 34, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[477984, 9120, 58, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[478067, 9124, 163, 5, 46, "Input"],
Cell[478233, 9131, 131, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[478401, 9140, 212, 7, 46, "Input"],
Cell[478616, 9149, 73, 2, 44, "Output"]
}, Open  ]],
Cell[478704, 9154, 281, 11, 42, "SmallText"],
Cell[CellGroupData[{
Cell[479010, 9169, 190, 6, 46, "Input"],
Cell[479203, 9177, 131, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[479371, 9186, 242, 9, 63, "Input"],
Cell[479616, 9197, 332, 12, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[479985, 9214, 137, 4, 44, "Input"],
Cell[480125, 9220, 161, 5, 44, "Output"]
}, Open  ]],
Cell[480301, 9228, 479, 20, 59, "SmallText"],
Cell[480783, 9250, 81, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[480889, 9256, 178, 6, 44, "Input"],
Cell[481070, 9264, 338, 11, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[481445, 9280, 195, 6, 61, "Input"],
Cell[481643, 9288, 422, 14, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[482102, 9307, 133, 4, 44, "Input"],
Cell[482238, 9313, 257, 8, 44, "Output"]
}, Open  ]],
Cell[482510, 9324, 58, 1, 44, "Input"],
Cell[482571, 9327, 274, 10, 44, "Input"],
Cell[CellGroupData[{
Cell[482870, 9341, 356, 12, 44, "Input"],
Cell[483229, 9355, 128, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[483394, 9364, 153, 4, 44, "Input"],
Cell[483550, 9370, 128, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[483715, 9379, 153, 5, 44, "Input"],
Cell[483871, 9386, 128, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484036, 9395, 75, 2, 44, "Input"],
Cell[484114, 9399, 128, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484279, 9408, 80, 2, 44, "Input"],
Cell[484362, 9412, 217, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484616, 9425, 146, 5, 44, "Input"],
Cell[484765, 9432, 263, 10, 62, "Output"]
}, Open  ]],
Cell[485043, 9445, 58, 1, 44, "Input"],
Cell[485104, 9448, 256, 8, 59, "SmallText"],
Cell[485363, 9458, 197, 7, 46, "Input"],
Cell[CellGroupData[{
Cell[485585, 9469, 128, 4, 44, "Input"],
Cell[485716, 9475, 225, 7, 46, "Output"]
}, Open  ]],
Cell[485956, 9485, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[486057, 9490, 116, 3, 44, "Input"],
Cell[486176, 9495, 225, 7, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[486438, 9507, 155, 5, 44, "Input"],
Cell[486596, 9514, 225, 7, 46, "Output"]
}, Open  ]],
Cell[486836, 9524, 572, 19, 78, "SmallText"],
Cell[CellGroupData[{
Cell[487433, 9547, 73, 2, 44, "Input"],
Cell[487509, 9551, 122, 3, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[487680, 9560, 58, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[487763, 9564, 463, 16, 52, "Input"],
Cell[488229, 9582, 415, 14, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[488681, 9601, 208, 7, 48, "Input"],
Cell[488892, 9610, 212, 7, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[489141, 9622, 232, 8, 48, "Input"],
Cell[489376, 9632, 222, 7, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[489635, 9644, 232, 8, 48, "Input"],
Cell[489870, 9654, 222, 7, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[490129, 9666, 235, 8, 48, "Input"],
Cell[490367, 9676, 483, 16, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[490887, 9697, 187, 6, 44, "Input"],
Cell[491077, 9705, 300, 11, 44, "Output"]
}, Open  ]],
Cell[491392, 9719, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[491493, 9724, 138, 4, 44, "Input"],
Cell[491634, 9730, 229, 8, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[491900, 9743, 62, 1, 44, "Input"],
Cell[491965, 9746, 320, 11, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[492322, 9762, 187, 5, 44, "Input"],
Cell[492512, 9769, 229, 8, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[492778, 9782, 57, 1, 44, "Input"],
Cell[492838, 9785, 320, 11, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[493207, 9802, 42, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[493274, 9806, 182, 6, 52, "Input"],
Cell[493459, 9814, 395, 13, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[493891, 9832, 210, 7, 52, "Input"],
Cell[494104, 9841, 380, 13, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[494521, 9859, 210, 7, 52, "Input"],
Cell[494734, 9868, 380, 13, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[495151, 9886, 263, 8, 52, "Input"],
Cell[495417, 9896, 187, 6, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[495641, 9907, 214, 7, 46, "Input"],
Cell[495858, 9916, 283, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[496178, 9930, 267, 8, 46, "Input"],
Cell[496448, 9940, 274, 8, 44, "Output"]
}, Open  ]],
Cell[496737, 9951, 143, 4, 44, "Input"],
Cell[CellGroupData[{
Cell[496905, 9959, 214, 7, 46, "Input"],
Cell[497122, 9968, 195, 6, 44, "Output"]
}, Open  ]],
Cell[497332, 9977, 61, 1, 44, "Input"],
Cell[497396, 9980, 96, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[497517, 9986, 214, 7, 46, "Input"],
Cell[497734, 9995, 195, 6, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[497978, 10007, 34, 0, 45, "Subsection"],
Cell[498015, 10009, 143, 4, 44, "Input"],
Cell[498161, 10015, 179, 6, 46, "Input"],
Cell[CellGroupData[{
Cell[498365, 10025, 106, 3, 44, "Input"],
Cell[498474, 10030, 138, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[498649, 10039, 103, 3, 44, "Input"],
Cell[498755, 10044, 305, 11, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499097, 10060, 84, 2, 44, "Input"],
Cell[499184, 10064, 147, 5, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499368, 10074, 85, 2, 44, "Input"],
Cell[499456, 10078, 447, 16, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499940, 10099, 120, 3, 44, "Input"],
Cell[500063, 10104, 406, 15, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[500506, 10124, 1006, 32, 85, "Input"],
Cell[501515, 10158, 22297, 379, 460, 11067, 193, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[523873, 10544, 30, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[523928, 10548, 44, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[523997, 10552, 231, 8, 57, "Input"],
Cell[524231, 10562, 142, 5, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524410, 10572, 263, 9, 60, "Input"],
Cell[524676, 10583, 51, 1, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524764, 10589, 263, 9, 60, "Input"],
Cell[525030, 10600, 274, 10, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[525341, 10615, 220, 7, 46, "Input"],
Cell[525564, 10624, 274, 10, 62, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[525887, 10640, 53, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[525965, 10644, 387, 13, 63, "Input"],
Cell[526355, 10659, 342, 11, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[526734, 10675, 372, 12, 58, "Input"],
Cell[527109, 10689, 1922, 66, 134, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[529068, 10760, 56, 1, 44, "Input"],
Cell[529127, 10763, 9058, 262, 402, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[538222, 11030, 279, 10, 68, "Input"],
Cell[538504, 11042, 799, 29, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[539340, 11076, 209, 7, 58, "Input"],
Cell[539552, 11085, 257, 8, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[539846, 11098, 476, 15, 59, "Input"],
Cell[540325, 11115, 822, 28, 113, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[541184, 11148, 249, 7, 65, "Input"],
Cell[541436, 11157, 1420, 49, 86, "Output"],
Cell[542859, 11208, 852, 30, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[543748, 11243, 190, 6, 44, "Input"],
Cell[543941, 11251, 3732, 68, 241, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[547710, 11324, 138, 4, 44, "Input"],
Cell[547851, 11330, 1204, 43, 109, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[549104, 11379, 43, 0, 45, "Subsection"],
Cell[549150, 11381, 98, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[549273, 11387, 274, 9, 65, "Input"],
Cell[549550, 11398, 93, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[549680, 11405, 248, 8, 57, "Input"],
Cell[549931, 11415, 662, 23, 96, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[550630, 11443, 85, 2, 44, "Input"],
Cell[550718, 11447, 2242, 77, 193, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[552997, 11529, 57, 1, 44, "Input"],
Cell[553057, 11532, 125, 4, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[553219, 11541, 280, 9, 67, "Input"],
Cell[553502, 11552, 1117, 38, 136, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[554656, 11595, 78, 2, 44, "Input"],
Cell[554737, 11599, 8459, 283, 694, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[563233, 11887, 57, 1, 44, "Input"],
Cell[563293, 11890, 156, 5, 67, "Output"]
}, Open  ]],
Cell[563464, 11898, 758, 13, 161, "SmallText"],
Cell[CellGroupData[{
Cell[564247, 11915, 271, 8, 66, "Input"],
Cell[564521, 11925, 687, 24, 69, "Output"],
Cell[565211, 11951, 85, 2, 44, "Output"]
}, Open  ]],
Cell[565311, 11956, 243, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[565579, 11966, 98, 2, 44, "Input"],
Cell[565680, 11970, 687, 24, 69, "Output"]
}, Open  ]],
Cell[566382, 11997, 110, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[566517, 12004, 500, 18, 67, "Input"],
Cell[567020, 12024, 543, 18, 87, "Output"]
}, Open  ]],
Cell[567578, 12045, 246, 7, 44, "SmallText"],
Cell[CellGroupData[{
Cell[567849, 12056, 82, 2, 46, "Input"],
Cell[567934, 12060, 592, 19, 90, "Output"]
}, Open  ]],
Cell[568541, 12082, 119, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[568685, 12089, 103, 3, 44, "Input"],
Cell[568791, 12094, 1317, 47, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[570145, 12146, 58, 1, 44, "Input"],
Cell[570206, 12149, 620, 22, 85, "Output"]
}, Open  ]],
Cell[570841, 12174, 329, 5, 76, "SmallText"],
Cell[CellGroupData[{
Cell[571195, 12183, 167, 4, 68, "Input"],
Cell[571365, 12189, 273, 9, 58, "Output"],
Cell[571641, 12200, 141, 4, 57, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[571831, 12210, 39, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[571895, 12214, 243, 7, 79, "Input"],
Cell[572141, 12223, 28, 0, 44, "Output"]
}, Open  ]],
Cell[572184, 12226, 609, 9, 110, "SmallText"],
Cell[CellGroupData[{
Cell[572818, 12239, 311, 10, 89, "Input"],
Cell[573132, 12251, 52, 1, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[573221, 12257, 294, 9, 56, "Input"],
Cell[573518, 12268, 52, 1, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[573607, 12274, 516, 17, 89, "Input"],
Cell[574126, 12293, 452, 15, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[574615, 12313, 50, 1, 44, "Input"],
Cell[574668, 12316, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[574751, 12321, 389, 12, 79, "Input"],
Cell[575143, 12335, 176, 6, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[575356, 12346, 55, 1, 44, "Input"],
Cell[575414, 12349, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[575497, 12354, 1114, 34, 114, "Input"],
Cell[576614, 12390, 300523, 4864, 304, 243861, 3934, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[877186, 17260, 44, 0, 45, "Subsection"],
Cell[877233, 17262, 207, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[877465, 17270, 188, 6, 60, "Input"],
Cell[877656, 17278, 187, 6, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[877880, 17289, 50, 1, 44, "Input"],
Cell[877933, 17292, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[878015, 17297, 195, 6, 46, "Input"],
Cell[878213, 17305, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[878295, 17310, 335, 10, 68, "Input"],
Cell[878633, 17322, 28, 0, 44, "Output"],
Cell[878664, 17324, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[878729, 17329, 290, 9, 46, "Input"],
Cell[879022, 17340, 5143, 90, 255, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[884202, 17435, 256, 8, 44, "Input"],
Cell[884461, 17445, 232, 5, 34, "Message"],
Cell[884696, 17452, 271, 9, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[885004, 17466, 257, 8, 44, "Input"],
Cell[885264, 17476, 317, 7, 85, "Message"],
Cell[885584, 17485, 423, 8, 91, "Message"],
Cell[886010, 17495, 49, 0, 46, "Output"]
}, Open  ]],
Cell[886074, 17498, 359, 11, 66, "Input"],
Cell[CellGroupData[{
Cell[886458, 17513, 497, 15, 44, "Input"],
Cell[886958, 17530, 1609, 61, 151, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[888604, 17596, 172, 5, 44, "Input"],
Cell[888779, 17603, 2780, 51, 243, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[891596, 17659, 440, 14, 46, "Input"],
Cell[892039, 17675, 5590, 98, 259, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[897678, 17779, 45, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[897748, 17783, 374, 13, 59, "Input"],
Cell[898125, 17798, 115, 4, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[898277, 17807, 468, 16, 67, "Input"],
Cell[898748, 17825, 133, 4, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[898918, 17834, 398, 14, 49, "Input"],
Cell[899319, 17850, 220, 8, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[899576, 17863, 501, 18, 67, "Input"],
Cell[900080, 17883, 486, 16, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[900603, 17904, 78, 2, 44, "Input"],
Cell[900684, 17908, 83, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[900804, 17914, 358, 12, 58, "Input"],
Cell[901165, 17928, 208, 5, 43, "Message"],
Cell[901376, 17935, 268, 9, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[901681, 17949, 281, 9, 44, "Input"],
Cell[901965, 17960, 7015, 121, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[909017, 18086, 221, 6, 44, "Input"],
Cell[909241, 18094, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[909306, 18099, 384, 13, 59, "Input"],
Cell[909693, 18114, 212, 5, 44, "Message"],
Cell[909908, 18121, 307, 11, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[910252, 18137, 259, 8, 44, "Input"],
Cell[910514, 18147, 8044, 138, 278, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[918595, 18290, 335, 11, 44, "Input"],
Cell[918933, 18303, 2685, 86, 200, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[921655, 18394, 555, 17, 65, "Input"],
Cell[922213, 18413, 120, 4, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[922370, 18422, 542, 18, 79, "Input"],
Cell[922915, 18442, 4990, 89, 278, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[927942, 