(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2214964,      39884]
NotebookOptionsPosition[   2203633,      39542]
NotebookOutlinePosition[   2204043,      39560]
CellTagsIndexPosition[   2204000,      39557]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Differentialgleichungen analysieren", "Title",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, 
   3.382549297319674*^9}],

Cell[CellGroupData[{

Cell["Analyse mit NDSolve", "Section",
 CellChangeTimes->{{3.36643149908654*^9, 3.36643150090416*^9}}],

Cell[TextData[{
 "Die folgende Gleichung hat wirklich nur die L\[ODoubleDot]sung y[x]=Sin[x], \
wenn man eine auf ganz ",
 StyleBox["R",
  FontWeight->"Bold"],
 " definierte sucht. Das wird deutlich, wenn man die numerischen L\
\[ODoubleDot]sungen mit ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " und verschiedenen Anfangswerten berechnet. Die n\[ADoubleDot]hern sich \
alle der Standardl\[ODoubleDot]sung an.\n\nDas sah in der Version 4.1 noch \
deutlich komplizierter aus."
}], "SmallText",
 CellChangeTimes->{{3.36595174484853*^9, 3.36595188988288*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{"eqn", ",", "y", ",", "x"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "//", "Simplify"}]}], "Input",\

 CellChangeTimes->{{3.36594981180802*^9, 3.36594985407313*^9}, {
  3.36629384311863*^9, 3.36629384379527*^9}, {3.36629388058093*^9, 
  3.36629389120363*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Sin", "[", "x", "]"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Wir wollen das mit ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " \[UDoubleDot]berpr\[UDoubleDot]fen."
}], "SmallText",
 CellChangeTimes->{{3.36629441939901*^9, 3.36629443048162*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36629439870486*^9, 3.36629440300401*^9}, 
   3.36629444879039*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnco\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The number of constraints (\\!\\(0\\)) (initial \
conditions) is not equal to the total differential order of the system \
(\\!\\(1\\)).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}]}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsol", "=", 
  RowBox[{"Join", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"eqn", "&&", 
        RowBox[{
         RowBox[{"y", "[", "0", "]"}], "\[Equal]", "i"}]}], ",", "y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2", ",", ".3"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.36595080485575*^9, 3.36595086821951*^9}, {
   3.3659509024931*^9, 3.36595096846599*^9}, 3.3662939122523*^9, {
   3.36629733716745*^9, 3.36629736735275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "/.", "nsol"}]], "Input",
 CellChangeTimes->{{3.36629982321367*^9, 3.36629985884435*^9}, 
   3.36630003528038*^9, {3.36630044239959*^9, 3.36630044591372*^9}, 
   3.389327236137587*^9, {3.389327266581481*^9, 3.389327287127642*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
         "]"}],
        False,
        Editable->False], "[", "x", "]"}], "2"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "nsol"}], "/.", 
  RowBox[{"x", "\[Rule]", "0.1"}]}]], "Input",
 CellChangeTimes->{{3.36629982321367*^9, 3.36629985884435*^9}, 
   3.36630003528038*^9, {3.36630044239959*^9, 3.36630044591372*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
   "False", ",", "False"}], "}"}]], "Output"]
}, Open  ]],

Cell["Probe mit den N\[ADoubleDot]herungswerten", "SmallText",
 CellChangeTimes->{{3.36629847144352*^9, 3.36629847692351*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "-", 
    RowBox[{"eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    "nsol"}], "/.", 
  RowBox[{"x", "\[Rule]", "0.1"}]}]], "Input",
 CellChangeTimes->{{3.36629822332273*^9, 3.36629826970728*^9}, {
  3.36629850008482*^9, 3.36629850477446*^9}, {3.389324619950702*^9, 
  3.389324628920945*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.107808508318044`*^-7", ",", 
   RowBox[{"-", "1.20047199514417`*^-7"}], ",", "5.399786640047921`*^-8", ",",
    "2.0851389903597806`*^-7", ",", 
   RowBox[{"-", "2.5621912578266404`*^-6"}], ",", "3.992167334487817`*^-6", 
   ",", 
   RowBox[{"-", "2.435057411931396`*^-6"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Chop", "[", 
      RowBox[{"#", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "-", 
        RowBox[{
        "eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
        "nsol"}], "/.", 
      RowBox[{"x", "\[Rule]", "i"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36629805402524*^9, 3.36629817781134*^9}, {
  3.36629830465572*^9, 3.36629846145399*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "nsol"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36595087026301*^9, 3.36595088556989*^9}, {
   3.36595094636353*^9, 3.36595097636045*^9}, 3.36629391567157*^9, {
   3.389324652967844*^9, 3.389324683377347*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdmnc8lf/7x41SZlbInkc4xkF7vC+VSqSys4qGSKSiQqlkK1LJKJKM8omS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     "]], LineBox[CompressedData["
1:eJwVmnk4lO8XxpWyE0OS7MzYxjJo0eI5JEVKCJEUWsjShhRFUdm3kBYUKi20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     "]], LineBox[CompressedData["
1:eJwVmnk41N8Xx23Jni1K9uwzlqGkzT0hSoqSrVBoF5WQUFqUPfIVUiiphCQp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     "]], LineBox[CompressedData["
1:eJwVl3c81f8Xx2WVkaxkb9e6xqVEpfdJ0kCkSJKMFkJmilJUZPNFUkiRslLR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     "]], LineBox[CompressedData["
1:eJwVl3c81f8Xx4WWvcmWzTUuQqXeJ4pEJZnlK2lYGSUS2iqzJCGVlVJC0SR5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     "]], LineBox[CompressedData["
1:eJwVl3k8lN8Xx5VSKPuSneyMZVCR6h5LSiQpQrK2WCJtKEWhyFLytVekjShJ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     "]], LineBox[CompressedData["
1:eJwVmHc81d8fx5WSUTJLtrjmNS6VlJx3KClpIUmJfJVkVSQjpbJFEqJSUpJU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {-0.9999974913374489, 1.7999990857175607`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
L\[ODoubleDot]sungen mit einem Fourierreihenansatz suchen:\
\>", "SmallText",
 CellChangeTimes->{{3.36629938305972*^9, 3.36629939500775*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ansatz", "=", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["a", "i"], 
         RowBox[{"Cos", "[", 
          RowBox[{"i", " ", "x"}], "]"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "i"], 
         RowBox[{"Sin", "[", 
          RowBox[{"i", " ", "x"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "0"], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["a", "i"], ",", 
          SubscriptBox["b", "i"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "}"}], "//", 
    "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqn1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "-", 
    RowBox[{"eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "\[Rule]", "ansatz"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{"ansatz", ",", "x"}], "]"}]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.36629871395035*^9, 3.36629882527604*^9}, {
  3.36629887260605*^9, 3.36629902265956*^9}, {3.36629908808674*^9, 
  3.36629908866346*^9}, {3.36629942742296*^9, 3.36629946348636*^9}, {
  3.36629950068845*^9, 3.36629950096134*^9}, {3.36629954781461*^9, 
  3.36629968674602*^9}, {3.36630222268173*^9, 3.36630222411183*^9}, {
  3.36630236138301*^9, 3.36630236329866*^9}, {3.389328619217005*^9, 
  3.389328619821755*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Cos", "[", "x", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   SubscriptBox["a", "1"]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}], " ", 
   SubscriptBox["a", "2"]}], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"3", " ", "x"}], "]"}], " ", 
   SubscriptBox["a", "3"]}], "-", 
  RowBox[{"4", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"4", " ", "x"}], "]"}], " ", 
   SubscriptBox["a", "4"]}], "-", 
  RowBox[{"5", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"5", " ", "x"}], "]"}], " ", 
   SubscriptBox["a", "5"]}], "-", 
  RowBox[{"6", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"6", " ", "x"}], "]"}], " ", 
   SubscriptBox["a", "6"]}], "-", 
  RowBox[{"7", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"7", " ", "x"}], "]"}], " ", 
   SubscriptBox["a", "7"]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SubscriptBox["b", "1"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}], " ", 
   SubscriptBox["b", "2"]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"3", " ", "x"}], "]"}], " ", 
   SubscriptBox["b", "3"]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"4", " ", "x"}], "]"}], " ", 
   SubscriptBox["b", "4"]}], "+", 
  RowBox[{"5", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"5", " ", "x"}], "]"}], " ", 
   SubscriptBox["b", "5"]}], "+", 
  RowBox[{"6", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"6", " ", "x"}], "]"}], " ", 
   SubscriptBox["b", "6"]}], "+", 
  RowBox[{"7", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"7", " ", "x"}], "]"}], " ", 
   SubscriptBox["b", "7"]}], "-", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SubscriptBox["a", "1"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "2"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "3"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"4", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "4"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"5", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "5"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"6", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "6"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"7", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "7"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      SubscriptBox["b", "1"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "2"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"3", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "3"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "4"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"5", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "5"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"6", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "6"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"7", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "7"]}]}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SubscriptBox["a", "1"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "2"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "3"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"4", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "4"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"5", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "5"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"6", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "6"]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"7", " ", "x"}], "]"}], " ", 
      SubscriptBox["a", "7"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      SubscriptBox["b", "1"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "2"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"3", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "3"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "4"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"5", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "5"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"6", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "6"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"7", " ", "x"}], "]"}], " ", 
      SubscriptBox["b", "7"]}]}], ")"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"CoefficientList", "[", 
     RowBox[{"eqn1", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"i", " ", "x"}], "]"}], ",", 
           RowBox[{"Cos", "[", 
            RowBox[{"i", " ", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}], "]"}], "//",
     "Flatten"}], "//", "Union"}]}]], "Input",
 CellChangeTimes->{{3.36629903194139*^9, 3.36629921509261*^9}, {
  3.36630236838015*^9, 3.36630237834486*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   SubsuperscriptBox["a", "0", "2"], ",", 
   SubsuperscriptBox["a", "1", "2"], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["a", "2"]}], ",", 
   SubsuperscriptBox["a", "2", "2"], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["a", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["a", "3"]}], ",", 
   SubsuperscriptBox["a", "3", "2"], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["a", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["a", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["a", "4"]}], ",", 
   SubsuperscriptBox["a", "4", "2"], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["a", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["a", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["a", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["a", "5"]}], ",", 
   SubsuperscriptBox["a", "5", "2"], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["a", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["a", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["a", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["a", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["a", "6"]}], ",", 
   SubsuperscriptBox["a", "6", "2"], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["a", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["a", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["a", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["a", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["a", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["a", "7"]}], ",", 
   SubsuperscriptBox["a", "7", "2"], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "1"]}], "+", 
    SubscriptBox["b", "1"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "0"]}], "-", 
    SubscriptBox["a", "1"], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "1"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "1"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "2"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "3"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "3"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "4"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "5"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "5"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "6"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "6"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["a", "7"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "7"], " ", 
     SubscriptBox["b", "1"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "1"]}], "+", 
    SubsuperscriptBox["b", "1", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "7"], " ", 
    SubscriptBox["b", "2"]}], ",", 
   SubsuperscriptBox["b", "2", "2"], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SubscriptBox["a", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "1"], " ", 
     SubscriptBox["b", "2"]}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "7"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "2"], " ", 
    SubscriptBox["b", "3"]}], ",", 
   SubsuperscriptBox["b", "3", "2"], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "3"]}], "+", 
    RowBox[{"3", " ", 
     SubscriptBox["b", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     SubscriptBox["a", "3"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "3"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "1"], " ", 
     SubscriptBox["b", "3"]}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "7"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "2"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "3"], " ", 
    SubscriptBox["b", "4"]}], ",", 
   SubsuperscriptBox["b", "4", "2"], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "4"]}], "+", 
    RowBox[{"4", " ", 
     SubscriptBox["b", "4"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     SubscriptBox["a", "4"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "4"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "1"], " ", 
     SubscriptBox["b", "4"]}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "7"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "2"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "3"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "4"], " ", 
    SubscriptBox["b", "5"]}], ",", 
   SubsuperscriptBox["b", "5", "2"], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "5"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["b", "5"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], " ", 
     SubscriptBox["a", "5"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "5"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "5"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "1"], " ", 
     SubscriptBox["b", "5"]}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "7"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "2"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "3"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "4"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "5"], " ", 
    SubscriptBox["b", "6"]}], ",", 
   SubsuperscriptBox["b", "6", "2"], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "6"]}], "+", 
    RowBox[{"6", " ", 
     SubscriptBox["b", "6"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], " ", 
     SubscriptBox["a", "6"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "6"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "6"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "1"], " ", 
     SubscriptBox["b", "6"]}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "1"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "2"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "3"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "4"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "5"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "6"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["a", "7"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "2"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "3"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "4"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "5"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["b", "6"], " ", 
    SubscriptBox["b", "7"]}], ",", 
   SubsuperscriptBox["b", "7", "2"], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["a", "7"]}], "+", 
    RowBox[{"7", " ", 
     SubscriptBox["b", "7"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "7"}], " ", 
     SubscriptBox["a", "7"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "0"], " ", 
     SubscriptBox["b", "7"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["b", "7"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["b", "1"], " ", 
     SubscriptBox["b", "7"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"sys", "\[Equal]", "0"}], ",", "vars"}], "]"}], "//", 
   "Solve"}]}]], "Input",
 CellChangeTimes->{{3.36629948188407*^9, 3.36629949200914*^9}, {
  3.36629952720641*^9, 3.36629953827225*^9}, {3.36629965010696*^9, 
  3.36629965069156*^9}, {3.36630238922305*^9, 3.36630238993919*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "0"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "1"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "2"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "3"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "4"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "5"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "6"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "7"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["b", "1"], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["b", "2"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["b", "3"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["b", "4"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["b", "5"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["b", "6"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["b", "7"], "\[Rule]", "0"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ansatz", "/.", "sol"}]], "Input",
 CellChangeTimes->{{3.36629964412651*^9, 3.36629964781536*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Sin", "[", "x", "]"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ein komplexes Beispiel", "Section",
 CellChangeTimes->{{3.36643150400791*^9, 3.3664315075098*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", "x"}], ")"}]}], "+", 
     SuperscriptBox["x", "2"], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"y", "[", "x", "]"}], "2"], " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "==", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", 
     RowBox[{"DSolve", "[", 
      RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}], "]"}], "//", 
   "Simplify"}]}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36643991585594*^9, 3.36643993242137*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The equations appear to involve the variables to be solved \
for in an essentially non-algebraic way.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "#1"}], "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "#1"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "#1"}], ")"}], "2"]}]}], "&"}], "]"}], "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "-", 
     RowBox[{"2", " ", "x"}], "-", 
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", "1", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}]}]}], ")"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Eine symbolische L\[ODoubleDot]sung mit der Randbedingung y[0]=4 kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nicht finden."
}], "SmallText",
 CellChangeTimes->{{3.36638279238511*^9, 3.36638279748694*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "4"}]}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.36630491360188*^9, 3.36630491425002*^9}, {
  3.36638277014915*^9, 3.36638278850442*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The equations appear to involve the variables to be solved \
for in an essentially non-algebraic way.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvnul\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"For some branches of the general solution, the given \
boundary conditions lead to an empty solution.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Das Vektorfeld, welches zu dieser Gleichung geh\[ODoubleDot]rt\
\>", "Subsection",
 CellChangeTimes->{{3.36630512970047*^9, 3.36630514189153*^9}, 
   3.36643158198261*^9}],

Cell[TextData[{
 StyleBox["eqn",
  FontWeight->"Bold"],
 " l\[ADoubleDot]sst sich einfach nach y'[x] aufl\[ODoubleDot]sen, womit sich \
das Vektorfeld der Dgl. berechnen l\[ADoubleDot]sst."
}], "SmallText",
 CellChangeTimes->{{3.36644006125267*^9, 3.36644010890815*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"eqn", ",", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vfy", "=", 
  RowBox[{"First", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "sol"}], "/.", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", "y"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36630592396304*^9, 3.36630595530882*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", "y"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   SuperscriptBox["y", "2"]}]]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"frameTicks", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1."}], ",", 
       RowBox[{"-", ".5"}], ",", "0", ",", ".5", ",", "1."}], "}"}], ",", 
     "Automatic", ",", "None", ",", "None"}], "}"}]}], ";", 
  RowBox[{"myPlotOptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"Axes", "->", "None"}], ",", 
     RowBox[{"FrameTicks", "->", "frameTicks"}]}], "}"}]}], ";", 
  RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.36630488789896*^9, 3.36630488925114*^9}, {
   3.36630530654364*^9, 3.36630534985935*^9}, {3.36630568023563*^9, 
   3.36630568046078*^9}, 3.36630596524441*^9, {3.36630621153932*^9, 
   3.36630625356182*^9}, 3.36630656210991*^9, {3.36630659268803*^9, 
   3.36630659855717*^9}, {3.36630675282627*^9, 3.36630675366514*^9}, {
   3.36630678399999*^9, 3.36630678480751*^9}, {3.36638281866656*^9, 
   3.36638288697941*^9}, 3.36638292392006*^9, {3.36696896869596*^9, 
   3.36696901615257*^9}, {3.36696913404838*^9, 3.3669691352378*^9}, {
   3.36696919002407*^9, 3.36696919323749*^9}, 3.3669693269784*^9, {
   3.382701651581977*^9, 3.382701677974315*^9}, {3.382701717699255*^9, 
   3.382701730724514*^9}, {3.382701853946124*^9, 3.382701874897175*^9}, {
   3.382701910567696*^9, 3.382701913950138*^9}, {3.382701961508196*^9, 
   3.382701963665226*^9}, {3.382701996173395*^9, 3.382701997065822*^9}, 
   3.389325629052963*^9, {3.389333152536863*^9, 3.389333152923737*^9}, {
   3.389333519204241*^9, 3.389333522593824*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vf", "[", 
    RowBox[{"a_", ",", "b_", ",", 
     RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"VectorFieldPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "vfy"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", ".9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "a", ",", "b"}], "}"}], ",", "opts"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.389324942792985*^9, 3.389324970603005*^9}, {
   3.389325024210361*^9, 3.389325080311456*^9}, 3.389325152755589*^9, {
   3.389325464499753*^9, 3.389325532070323*^9}, 3.389325728653178*^9, {
   3.389325801942387*^9, 3.38932583554473*^9}}],

Cell[TextData[{
 StyleBox["Graphics",
  FontWeight->"Bold"],
 "-Optionen haben leider \[UDoubleDot]berhaupt keine Auswirkungen, obwohl \
angeblich doch."
}], "SmallText",
 CellChangeTimes->{{3.38932914813597*^9, 3.389329189222239*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3", ",", 
     RowBox[{"PlotPoints", "->", "20"}]}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], " ", "]"}]], "Input",
 CellChangeTimes->{{3.36630488789896*^9, 3.36630488925114*^9}, {
   3.36630530654364*^9, 3.36630534985935*^9}, {3.36630568023563*^9, 
   3.36630568046078*^9}, 3.36630596524441*^9, {3.36630621153932*^9, 
   3.36630625356182*^9}, 3.36630656210991*^9, {3.36630659268803*^9, 
   3.36630659855717*^9}, {3.36630675282627*^9, 3.36630675366514*^9}, {
   3.36630678399999*^9, 3.36630678480751*^9}, {3.36638281866656*^9, 
   3.36638288697941*^9}, 3.36638292392006*^9, {3.382701966179742*^9, 
   3.382701988279349*^9}, {3.38932536646865*^9, 3.389325386995119*^9}, {
   3.389325437704699*^9, 3.389325459053683*^9}, {3.389325559838078*^9, 
   3.389325571824228*^9}, {3.389325747674595*^9, 3.389325781484728*^9}, {
   3.389325822067949*^9, 3.389325850007121*^9}, {3.389329000327616*^9, 
   3.389329003739593*^9}, {3.38932920099959*^9, 3.389329203276474*^9}, {
   3.389330435180914*^9, 3.389330576599995*^9}, {3.389330697906102*^9, 
   3.389330698222876*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], 
   ArrowBox[{{-1., -3.}, {-0.9997341848838092, -3.00002953501291}}], 
   ArrowBox[{{-1., -2.6842105263157894`}, {-0.9997341848838092, \
-2.684241594287847}}], 
   ArrowBox[{{-1., -2.3684210526315788`}, {-0.9997341848838092, \
-2.368453475512418}}], 
   ArrowBox[{{-1., -2.0526315789473686`}, {-0.9997341848838092, \
-2.0526647839914687`}}], 
   ArrowBox[{{-1., -1.736842105263158}, {-0.9997341848838092, \
-1.7368745693682575`}}], 
   ArrowBox[{{-1., -1.4210526315789473`}, {-0.9997341848838092, \
-1.4210803434429125`}}], 
   ArrowBox[{{-1., -1.105263157894737}, {-0.9997341848838092, \
-1.1052746102466817`}}], 
   ArrowBox[{{-1., -0.7894736842105263}, {-0.9997341848838092, \
-0.789428790990903}}], 
   ArrowBox[{{-1., -0.47368421052631576`}, {-0.9997341848838092, \
-0.4733724520567092}}], 
   ArrowBox[{{-1., -0.15789473684210525`}, {-0.9997341848838092, \
-0.15340541487977097`}}], 
   ArrowBox[{{-1., 0.15789473684210525`}, {-0.9997341848838092, 
    0.1640675545403149}}], 
   ArrowBox[{{-1., 0.47368421052631576`}, {-0.9997341848838092, 
    0.4745571342412141}}], 
   ArrowBox[{{-1., 0.7894736842105263}, {-0.9997341848838092, 
    0.7898552765773248}}], 
   ArrowBox[{{-1., 1.105263157894737}, {-0.9997341848838092, 
    1.1054922049336315`}}], 
   ArrowBox[{{-1., 1.4210526315789473`}, {-0.9997341848838092, 
    1.4212119747967462`}}], 
   ArrowBox[{{-1., 1.736842105263158}, {-0.9997341848838092, 
    1.7369626862249563`}}], 
   ArrowBox[{{-1., 2.0526315789473686`}, {-0.9997341848838092, 
    2.0527278735752588`}}], 
   ArrowBox[{{-1., 2.3684210526315788`}, {-0.9997341848838092, 
    2.368500862799798}}], 
   ArrowBox[{{-1., 2.6842105263157894`}, {-0.9997341848838092, 
    2.6842784875046655`}}], 
   ArrowBox[{{-1., 3.}, {-0.9997341848838092, 3.00005907002582}}], 
   ArrowBox[{{-0.9, -3.}, {-0.8997341848838092, -3.0000251824846917`}}], 
   ArrowBox[{{-0.9, -2.6842105263157894`}, {-0.8997341848838092, \
-2.6842370158498596`}}], 
   ArrowBox[{{-0.9, -2.3684210526315788`}, {-0.8997341848838092, \
-2.3684486974036627`}}], 
   ArrowBox[{{-0.9, -2.0526315789473686`}, {-0.8997341848838092, \
-2.0526598906165487`}}], 
   ArrowBox[{{-0.9, -1.736842105263158}, {-0.8997341848838092, \
-1.736869785184348}}], 
   ArrowBox[{{-0.9, -1.4210526315789473`}, {-0.8997341848838092, \
-1.4210762595892754`}}], 
   ArrowBox[{{-0.9, -1.105263157894737}, {-0.8997341848838092, \
-1.1052729225316582`}}], 
   ArrowBox[{{-0.9, -0.7894736842105263}, {-0.8997341848838092, \
-0.7894354068337949}}], 
   ArrowBox[{{-0.9, -0.47368421052631576`}, {-0.8997341848838092, \
-0.4734183954101249}}], 
   ArrowBox[{{-0.9, -0.15789473684210525`}, {-0.8997341848838092, \
-0.15406699916895708`}}], 
   ArrowBox[{{-0.9, 0.15789473684210525`}, {-0.8997341848838092, 
    0.163157876142684}}], 
   ArrowBox[{{-0.9, 0.47368421052631576`}, {-0.8997341848838092, 
    0.4744284928516501}}], 
   ArrowBox[{{-0.9, 0.7894736842105263}, {-0.8997341848838092, 
    0.789799041912744}}], 
   ArrowBox[{{-0.9, 1.105263157894737}, {-0.8997341848838092, 
    1.1054584506331628`}}], 
   ArrowBox[{{-0.9, 1.4210526315789473`}, {-0.8997341848838092, 
    1.4211884926383338`}}], 
   ArrowBox[{{-0.9, 1.736842105263158}, {-0.8997341848838092, 
    1.736944916399007}}], 
   ArrowBox[{{-0.9, 2.0526315789473686`}, {-0.8997341848838092, 
    2.052713682787991}}], 
   ArrowBox[{{-0.9, 2.3684210526315788`}, {-0.8997341848838092, 
    2.3684891013013236`}}], 
   ArrowBox[{{-0.9, 2.6842105263157894`}, {-0.8997341848838092, 
    2.684268472171568}}], 
   ArrowBox[{{-0.9, 3.}, {-0.8997341848838092, 3.0000503649693835`}}], 
   ArrowBox[{{-0.8, -3.}, {-0.7997341848838092, -3.0000210026758474`}}], 
   ArrowBox[{{-0.8, -2.6842105263157894`}, {-0.7997341848838092, \
-2.684232619095919}}], 
   ArrowBox[{{-0.8, -2.3684210526315788`}, {-0.7997341848838092, \
-2.3684441089023975`}}], 
   ArrowBox[{{-0.8, -2.0526315789473686`}, {-0.7997341848838092, \
-2.052655191423173}}], 
   ArrowBox[{{-0.8, -1.736842105263158}, {-0.7997341848838092, \
-1.7368651908490065`}}], 
   ArrowBox[{{-0.8, -1.4210526315789473`}, {-0.7997341848838092, \
-1.4210723377933225`}}], 
   ArrowBox[{{-0.8, -1.105263157894737}, {-0.7997341848838092, \
-1.105271301789453}}], 
   ArrowBox[{{-0.8, -0.7894736842105263}, {-0.7997341848838092, \
-0.7894417601432386}}], 
   ArrowBox[{{-0.8, -0.47368421052631576`}, {-0.7997341848838092, \
-0.47346251561459557`}}], 
   ArrowBox[{{-0.8, -0.15789473684210525`}, {-0.7997341848838092, \
-0.1547023301133342}}], 
   ArrowBox[{{-0.8, 0.15789473684210525`}, {-0.7997341848838092, 
    0.16228429609416545`}}], 
   ArrowBox[{{-0.8, 0.47368421052631576`}, {-0.7997341848838092, 
    0.47430495627913233`}}], 
   ArrowBox[{{-0.8, 0.7894736842105263}, {-0.7997341848838092, 
    0.7897450387824718}}], 
   ArrowBox[{{-0.8, 1.105263157894737}, {-0.7997341848838092, 
    1.105426035789062}}], 
   ArrowBox[{{-0.8, 1.4210526315789473`}, {-0.7997341848838092, 
    1.4211659423116043`}}], 
   ArrowBox[{{-0.8, 1.736842105263158}, {-0.7997341848838092, 
    1.7369278517248812`}}], 
   ArrowBox[{{-0.8, 2.0526315789473686`}, {-0.7997341848838092, 
    2.0527000551272017`}}], 
   ArrowBox[{{-0.8, 2.3684210526315788`}, {-0.7997341848838092, 
    2.368477806528979}}], 
   ArrowBox[{{-0.8, 2.6842105263157894`}, {-0.7997341848838092, 
    2.6842588542723234`}}], 
   ArrowBox[{{-0.8, 3.}, {-0.7997341848838092, 3.0000420053516943`}}], 
   ArrowBox[{{-0.7000000000000001, -3.}, {-0.6997341848838092, \
-3.0000170260662657`}}], 
   ArrowBox[{{-0.7000000000000001, -2.6842105263157894`}, \
{-0.6997341848838092, -2.684228436087917}}], 
   ArrowBox[{{-0.7000000000000001, -2.3684210526315788`}, \
{-0.6997341848838092, -2.3684397434687683`}}], 
   ArrowBox[{{-0.7000000000000001, -2.0526315789473686`}, \
{-0.6997341848838092, -2.0526507206786735`}}], 
   ArrowBox[{{-0.7000000000000001, -1.736842105263158}, {-0.6997341848838092, \
-1.7368608198649211`}}], 
   ArrowBox[{{-0.7000000000000001, -1.4210526315789473`}, \
{-0.6997341848838092, -1.4210686066534683`}}], 
   ArrowBox[{{-0.7000000000000001, -1.105263157894737}, {-0.6997341848838092, \
-1.1052697598387993`}}], 
   ArrowBox[{{-0.7000000000000001, -0.7894736842105263}, \
{-0.6997341848838092, -0.7894478045898022}}], 
   ArrowBox[{{-0.7000000000000001, -0.47368421052631576`}, \
{-0.6997341848838092, -0.4735044909379543}}], 
   ArrowBox[{{-0.7000000000000001, -0.15789473684210525`}, \
{-0.6997341848838092, -0.15530677476970078`}}], 
   ArrowBox[{{-0.7000000000000001, 
    0.15789473684210525`}, {-0.6997341848838092, 0.1614531846916614}}], 
   ArrowBox[{{-0.7000000000000001, 
    0.47368421052631576`}, {-0.6997341848838092, 0.47418742537372777`}}], 
   ArrowBox[{{-0.7000000000000001, 0.7894736842105263}, {-0.6997341848838092, 
    0.7896936609866807}}], 
   ArrowBox[{{-0.7000000000000001, 1.105263157894737}, {-0.6997341848838092, 
    1.105395196775982}}], 
   ArrowBox[{{-0.7000000000000001, 1.4210526315789473`}, {-0.6997341848838092,
     1.421144488257443}}], 
   ArrowBox[{{-0.7000000000000001, 1.736842105263158}, {-0.6997341848838092, 
    1.7369116166411358`}}], 
   ArrowBox[{{-0.7000000000000001, 2.0526315789473686`}, {-0.6997341848838092,
     2.052687089968152}}], 
   ArrowBox[{{-0.7000000000000001, 2.3684210526315788`}, {-0.6997341848838092,
     2.368467060846199}}], 
   ArrowBox[{{-0.7000000000000001, 2.6842105263157894`}, {-0.6997341848838092,
     2.684249703942318}}], 
   ArrowBox[{{-0.7000000000000001, 3.}, {-0.6997341848838092, 
    3.0000340521325315`}}], 
   ArrowBox[{{-0.6000000000000001, -3.}, {-0.5997341848838093, \
-3.0000132907558097`}}], 
   ArrowBox[{{-0.6000000000000001, -2.6842105263157894`}, \
{-0.5997341848838093, -2.6842245069032153`}}], 
   ArrowBox[{{-0.6000000000000001, -2.3684210526315788`}, \
{-0.5997341848838093, -2.3684356429279565`}}], 
   ArrowBox[{{-0.6000000000000001, -2.0526315789473686`}, \
{-0.5997341848838093, -2.0526465212172136`}}], 
   ArrowBox[{{-0.6000000000000001, -1.736842105263158}, {-0.5997341848838093, \
-1.7368567141104527`}}], 
   ArrowBox[{{-0.6000000000000001, -1.4210526315789473`}, \
{-0.5997341848838093, -1.4210651019177316`}}], 
   ArrowBox[{{-0.6000000000000001, -1.105263157894737}, {-0.5997341848838093, \
-1.105268311453112}}], 
   ArrowBox[{{-0.6000000000000001, -0.7894736842105263}, \
{-0.5997341848838093, -0.7894534822616959}}], 
   ArrowBox[{{-0.6000000000000001, -0.47368421052631576`}, \
{-0.5997341848838093, -0.47354391921499284`}}], 
   ArrowBox[{{-0.6000000000000001, -0.15789473684210525`}, \
{-0.5997341848838093, -0.1558745419590548}}], 
   ArrowBox[{{-0.6000000000000001, 
    0.15789473684210525`}, {-0.5997341848838093, 0.1606725048062996}}], 
   ArrowBox[{{-0.6000000000000001, 
    0.47368421052631576`}, {-0.5997341848838093, 0.47407702619802}}], 
   ArrowBox[{{-0.6000000000000001, 0.7894736842105263}, {-0.5997341848838093, 
    0.7896454007755856}}], 
   ArrowBox[{{-0.6000000000000001, 1.105263157894737}, {-0.5997341848838093, 
    1.1053662290622395`}}], 
   ArrowBox[{{-0.6000000000000001, 1.4210526315789473`}, {-0.5997341848838093,
     1.4211243360269568`}}], 
   ArrowBox[{{-0.6000000000000001, 1.736842105263158}, {-0.5997341848838093, 
    1.7368963666959671`}}], 
   ArrowBox[{{-0.6000000000000001, 2.0526315789473686`}, {-0.5997341848838093,
     2.052674911529919}}], 
   ArrowBox[{{-0.6000000000000001, 2.3684210526315788`}, {-0.5997341848838093,
     2.3684569672072775`}}], 
   ArrowBox[{{-0.6000000000000001, 2.6842105263157894`}, {-0.5997341848838093,
     2.6842411088507836`}}], 
   ArrowBox[{{-0.6000000000000001, 3.}, {-0.5997341848838093, 
    3.000026581511619}}], 
   ArrowBox[{{-0.5, -3.}, {-0.49973418488380916`, -3.0000098450043033`}}], 
   ArrowBox[{{-0.5, -2.6842105263157894`}, {-0.49973418488380916`, \
-2.6842208823064753`}}], 
   ArrowBox[{{-0.5, -2.3684210526315788`}, {-0.49973418488380916`, \
-2.368431860258525}}], 
   ArrowBox[{{-0.5, -2.0526315789473686`}, {-0.49973418488380916`, \
-2.052642647295402}}], 
   ArrowBox[{{-0.5, -1.736842105263158}, {-0.49973418488380916`, \
-1.7368529266315245`}}], 
   ArrowBox[{{-0.5, -1.4210526315789473`}, {-0.49973418488380916`, \
-1.4210618688669356`}}], 
   ArrowBox[{{-0.5, -1.105263157894737}, {-0.49973418488380916`, \
-1.1052669753453852`}}], 
   ArrowBox[{{-0.5, -0.7894736842105263}, {-0.49973418488380916`, \
-0.7894587198039852}}], 
   ArrowBox[{{-0.5, -0.47368421052631576`}, {-0.49973418488380916`, \
-0.4735802910364469}}], 
   ArrowBox[{{-0.5, -0.15789473684210525`}, {-0.49973418488380916`, \
-0.15639829618799383`}}], 
   ArrowBox[{{-0.5, 0.15789473684210525`}, {-0.49973418488380916`, 
    0.15995234274150846`}}], 
   ArrowBox[{{-0.5, 0.47368421052631576`}, {-0.49973418488380916`, 
    0.47397518509794856`}}], 
   ArrowBox[{{-0.5, 0.7894736842105263}, {-0.49973418488380916`, 
    0.7896008816661259}}], 
   ArrowBox[{{-0.5, 1.105263157894737}, {-0.49973418488380916`, 
    1.1053395069077019`}}], 
   ArrowBox[{{-0.5, 1.4210526315789473`}, {-0.49973418488380916`, 
    1.4211057459848804`}}], 
   ArrowBox[{{-0.5, 1.736842105263158}, {-0.49973418488380916`, 
    1.7368822989170907`}}], 
   ArrowBox[{{-0.5, 2.0526315789473686`}, {-0.49973418488380916`, 
    2.0526636771566653`}}], 
   ArrowBox[{{-0.5, 2.3684210526315788`}, {-0.49973418488380916`, 
    2.3684476560209853`}}], 
   ArrowBox[{{-0.5, 2.6842105263157894`}, {-0.49973418488380916`, 
    2.684233180045415}}], 
   ArrowBox[{{-0.5, 3.}, {-0.49973418488380916`, 3.0000196900086067`}}], 
   ArrowBox[{{-0.4, -3.}, {-0.3997341848838092, -3.0000067508600936`}}], 
   ArrowBox[{{-0.4, -2.6842105263157894`}, {-0.3997341848838092, \
-2.6842176275665453`}}], 
   ArrowBox[{{-0.4, -2.3684210526315788`}, {-0.3997341848838092, \
-2.3684284635757704`}}], 
   ArrowBox[{{-0.4, -2.0526315789473686`}, {-0.3997341848838092, \
-2.0526391686717345`}}], 
   ArrowBox[{{-0.4, -1.736842105263158}, {-0.3997341848838092, \
-1.7368495256300378`}}], 
   ArrowBox[{{-0.4, -1.4210526315789473`}, {-0.3997341848838092, \
-1.4210589657192823`}}], 
   ArrowBox[{{-0.4, -1.105263157894737}, {-0.3997341848838092, \
-1.1052657755751814`}}], 
   ArrowBox[{{-0.4, -0.7894736842105263}, {-0.3997341848838092, \
-0.7894634229031838}}], 
   ArrowBox[{{-0.4, -0.47368421052631576`}, {-0.3997341848838092, \
-0.47361295144754856`}}], 
   ArrowBox[{{-0.4, -0.15789473684210525`}, {-0.3997341848838092, \
-0.1568686061078574}}], 
   ArrowBox[{{-0.4, 0.15789473684210525`}, {-0.3997341848838092, 
    0.15930566660169604`}}], 
   ArrowBox[{{-0.4, 0.47368421052631576`}, {-0.3997341848838092, 
    0.47388373594686395`}}], 
   ArrowBox[{{-0.4, 0.7894736842105263}, {-0.3997341848838092, 
    0.7895609053229374}}], 
   ArrowBox[{{-0.4, 1.105263157894737}, {-0.3997341848838092, 
    1.105315511503627}}], 
   ArrowBox[{{-0.4, 1.4210526315789473`}, {-0.3997341848838092, 
    1.4210890528858728`}}], 
   ArrowBox[{{-0.4, 1.736842105263158}, {-0.3997341848838092, 
    1.7368696666258547`}}], 
   ArrowBox[{{-0.4, 2.0526315789473686`}, {-0.3997341848838092, 
    2.0526535891480293`}}], 
   ArrowBox[{{-0.4, 2.3684210526315788`}, {-0.3997341848838092, 
    2.3684392949557433`}}], 
   ArrowBox[{{-0.4, 2.6842105263157894`}, {-0.3997341848838092, 
    2.6842260603018184`}}], 
   ArrowBox[{{-0.4, 3.}, {-0.3997341848838092, 3.0000135017201877`}}], 
   ArrowBox[{{-0.30000000000000004`, -3.}, {-0.2997341848838092, \
-3.000004089463326}}], 
   ArrowBox[{{-0.30000000000000004`, -2.6842105263157894`}, \
{-0.2997341848838092, -2.6842148280349973`}}], 
   ArrowBox[{{-0.30000000000000004`, -2.3684210526315788`}, \
{-0.2997341848838092, -2.368425541953541}}], 
   ArrowBox[{{-0.30000000000000004`, -2.0526315789473686`}, \
{-0.2997341848838092, -2.052636176568859}}], 
   ArrowBox[{{-0.30000000000000004`, -1.736842105263158}, \
{-0.2997341848838092, -1.736846600293095}}], 
   ArrowBox[{{-0.30000000000000004`, -1.4210526315789473`}, \
{-0.2997341848838092, -1.4210564686062657`}}], 
   ArrowBox[{{-0.30000000000000004`, -1.105263157894737}, \
{-0.2997341848838092, -1.1052647436050063`}}], 
   ArrowBox[{{-0.30000000000000004`, -0.7894736842105263}, \
{-0.2997341848838092, -0.7894674682262708}}], 
   ArrowBox[{{-0.30000000000000004`, -0.47368421052631576`}, \
{-0.2997341848838092, -0.47364104396898565`}}], 
   ArrowBox[{{-0.30000000000000004`, -0.15789473684210525`}, \
{-0.2997341848838092, -0.15727313841655127`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    0.15789473684210525`}, {-0.2997341848838092, 0.15874943467724198`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    0.47368421052631576`}, {-0.2997341848838092, 0.47380507688684015`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    0.7894736842105263}, {-0.2997341848838092, 0.7895265200766984}}], 
   ArrowBox[{{-0.30000000000000004`, 1.105263157894737}, {-0.2997341848838092,
     1.1052948721001223`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    1.4210526315789473`}, {-0.2997341848838092, 1.4210746944860273`}}], 
   ArrowBox[{{-0.30000000000000004`, 1.736842105263158}, {-0.2997341848838092,
     1.7368588010886377`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    2.0526315789473686`}, {-0.2997341848838092, 2.0526449120496917`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    2.3684210526315788`}, {-0.2997341848838092, 2.3684321032702553`}}], 
   ArrowBox[{{-0.30000000000000004`, 
    2.6842105263157894`}, {-0.2997341848838092, 2.684219936326557}}], 
   ArrowBox[{{-0.30000000000000004`, 3.}, {-0.2997341848838092, 
    3.000008178926652}}], 
   ArrowBox[{{-0.20000000000000007`, -3.}, {-0.19973418488380923`, \
-3.0000019690008606`}}], 
   ArrowBox[{{-0.20000000000000007`, -2.6842105263157894`}, \
{-0.19973418488380923`, -2.6842125975139264`}}], 
   ArrowBox[{{-0.20000000000000007`, -2.3684210526315788`}, \
{-0.19973418488380923`, -2.368423214156968}}], 
   ArrowBox[{{-0.20000000000000007`, -2.0526315789473686`}, \
{-0.19973418488380923`, -2.0526337926169753`}}], 
   ArrowBox[{{-0.20000000000000007`, -1.736842105263158}, \
{-0.19973418488380923`, -1.7368442695368314`}}], 
   ArrowBox[{{-0.20000000000000007`, -1.4210526315789473`}, \
{-0.19973418488380923`, -1.421054479036545}}], 
   ArrowBox[{{-0.20000000000000007`, -1.105263157894737}, \
{-0.19973418488380923`, -1.1052639213848665`}}], 
   ArrowBox[{{-0.20000000000000007`, -0.7894736842105263}, \
{-0.19973418488380923`, -0.7894706913292181}}], 
   ArrowBox[{{-0.20000000000000007`, -0.47368421052631576`}, \
{-0.19973418488380923`, -0.473663426628342}}], 
   ArrowBox[{{-0.20000000000000007`, -0.15789473684210525`}, \
{-0.19973418488380923`, -0.15759544871128298`}}], 
   ArrowBox[{{-0.20000000000000007`, 
    0.15789473684210525`}, {-0.19973418488380923`, 0.1583062580219859}}], 
   ArrowBox[{{-0.20000000000000007`, 
    0.47368421052631576`}, {-0.19973418488380923`, 0.47374240544064233`}}], 
   ArrowBox[{{-0.20000000000000007`, 
    0.7894736842105263}, {-0.19973418488380923`, 0.7894991237016462}}], 
   ArrowBox[{{-0.20000000000000007`, 
    1.105263157894737}, {-0.19973418488380923`, 1.10527842769733}}], 
   ArrowBox[{{-0.20000000000000007`, 
    1.4210526315789473`}, {-0.19973418488380923`, 1.421063254460134}}], 
   ArrowBox[{{-0.20000000000000007`, 
    1.736842105263158}, {-0.19973418488380923`, 1.7368501439939446`}}], 
   ArrowBox[{{-0.20000000000000007`, 
    2.0526315789473686`}, {-0.19973418488380923`, 2.052637998589228}}], 
   ArrowBox[{{-0.20000000000000007`, 
    2.3684210526315788`}, {-0.19973418488380923`, 2.36842637330946}}], 
   ArrowBox[{{-0.20000000000000007`, 
    2.6842105263157894`}, {-0.19973418488380923`, 2.6842150570617145`}}], 
   ArrowBox[{{-0.20000000000000007`, 3.}, {-0.19973418488380923`, 
    3.000003938001721}}], 
   ArrowBox[{{-0.10000000000000007`, -3.}, {-0.09973418488380922, \
-3.000000537000235}}], 
   ArrowBox[{{-0.10000000000000007`, -2.6842105263157894`}, \
{-0.09973418488380922, -2.6842110911880086`}}], 
   ArrowBox[{{-0.10000000000000007`, -2.3684210526315788`}, \
{-0.09973418488380922, -2.368421642138503}}], 
   ArrowBox[{{-0.10000000000000007`, -2.0526315789473686`}, \
{-0.09973418488380922, -2.0526321826754432`}}], 
   ArrowBox[{{-0.10000000000000007`, -1.736842105263158}, \
{-0.09973418488380922, -1.7368426955196143`}}], 
   ArrowBox[{{-0.10000000000000007`, -1.4210526315789473`}, \
{-0.09973418488380922, -1.4210531354310194`}}], 
   ArrowBox[{{-0.10000000000000007`, -1.105263157894737}, \
{-0.09973418488380922, -1.1052633661193179`}}], 
   ArrowBox[{{-0.10000000000000007`, -0.7894736842105263}, \
{-0.09973418488380922, -0.7894728679701696}}], 
   ArrowBox[{{-0.10000000000000007`, -0.47368421052631576`}, \
{-0.09973418488380922, -0.47367854219050476`}}], 
   ArrowBox[{{-0.10000000000000007`, -0.15789473684210525`}, \
{-0.09973418488380922, -0.15781311280642646`}}], 
   ArrowBox[{{-0.10000000000000007`, 
    0.15789473684210525`}, {-0.09973418488380922, 0.1580069698911636}}], 
   ArrowBox[{{-0.10000000000000007`, 
    0.47368421052631576`}, {-0.09973418488380922, 0.47370008186658663`}}], 
   ArrowBox[{{-0.10000000000000007`, 
    0.7894736842105263}, {-0.09973418488380922, 0.789480622253559}}], 
   ArrowBox[{{-0.10000000000000007`, 
    1.105263157894737}, {-0.09973418488380922, 1.1052673223863532`}}], 
   ArrowBox[{{-0.10000000000000007`, 
    1.4210526315789473`}, {-0.09973418488380922, 1.421055528728362}}], 
   ArrowBox[{{-0.10000000000000007`, 
    1.736842105263158}, {-0.09973418488380922, 1.7368442976442815`}}], 
   ArrowBox[{{-0.10000000000000007`, 
    2.0526315789473686`}, {-0.09973418488380922, 2.052633329758785}}], 
   ArrowBox[{{-0.10000000000000007`, 
    2.3684210526315788`}, {-0.09973418488380922, 2.3684225037255464`}}], 
   ArrowBox[{{-0.10000000000000007`, 
    2.6842105263157894`}, {-0.09973418488380922, 2.684211761973769}}], 
   ArrowBox[{{-0.10000000000000007`, 3.}, {-0.09973418488380922, 
    3.0000010740004694`}}], 
   ArrowBox[{{-8.326672684688674*^-17, -3.}, {0.00026581511619076255`, -3.}}],
    ArrowBox[{{-8.326672684688674*^-17, -2.6842105263157894`}, {
    0.00026581511619076255`, -2.6842105263157894`}}], 
   ArrowBox[{{-8.326672684688674*^-17, -2.3684210526315788`}, {
    0.00026581511619076255`, -2.3684210526315788`}}], 
   ArrowBox[{{-8.326672684688674*^-17, -2.0526315789473686`}, {
    0.00026581511619076255`, -2.0526315789473686`}}], 
   ArrowBox[{{-8.326672684688674*^-17, -1.736842105263158}, {
    0.00026581511619076255`, -1.736842105263158}}], 
   ArrowBox[{{-8.326672684688674*^-17, -1.4210526315789473`}, {
    0.00026581511619076255`, -1.4210526315789473`}}], 
   ArrowBox[{{-8.326672684688674*^-17, -1.105263157894737}, {
    0.00026581511619076255`, -1.105263157894737}}], 
   ArrowBox[{{-8.326672684688674*^-17, -0.7894736842105263}, {
    0.00026581511619076255`, -0.7894736842105263}}], 
   ArrowBox[{{-8.326672684688674*^-17, -0.47368421052631576`}, {
    0.00026581511619076255`, -0.47368421052631576`}}], 
   ArrowBox[{{-8.326672684688674*^-17, -0.15789473684210525`}, {
    0.00026581511619076255`, -0.15789473684210525`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 0.15789473684210525`}, {
    0.00026581511619076255`, 0.15789473684210525`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 0.47368421052631576`}, {
    0.00026581511619076255`, 0.47368421052631576`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 0.7894736842105263}, {
    0.00026581511619076255`, 0.7894736842105263}}], 
   ArrowBox[{{-8.326672684688674*^-17, 1.105263157894737}, {
    0.00026581511619076255`, 1.105263157894737}}], 
   ArrowBox[{{-8.326672684688674*^-17, 1.4210526315789473`}, {
    0.00026581511619076255`, 1.4210526315789473`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 1.736842105263158}, {
    0.00026581511619076255`, 1.736842105263158}}], 
   ArrowBox[{{-8.326672684688674*^-17, 2.0526315789473686`}, {
    0.00026581511619076255`, 2.0526315789473686`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 2.3684210526315788`}, {
    0.00026581511619076255`, 2.3684210526315788`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 2.6842105263157894`}, {
    0.00026581511619076255`, 2.6842105263157894`}}], 
   ArrowBox[{{-8.326672684688674*^-17, 3.}, {0.00026581511619076255`, 3.}}], 
   ArrowBox[{{0.09999999999999991, -3.}, {
    0.10026581511619076`, -3.0000006563336203`}}], 
   ArrowBox[{{0.09999999999999991, -2.6842105263157894`}, {
    0.10026581511619076`, -2.6842112167151684`}}], 
   ArrowBox[{{0.09999999999999991, -2.3684210526315788`}, {
    0.10026581511619076`, -2.368421773140042}}], 
   ArrowBox[{{0.09999999999999991, -2.0526315789473686`}, {
    0.10026581511619076`, -2.0526323168372373`}}], 
   ArrowBox[{{0.09999999999999991, -1.736842105263158}, {
    0.10026581511619076`, -1.7368428266877158`}}], 
   ArrowBox[{{0.09999999999999991, -1.4210526315789473`}, {
    0.10026581511619076`, -1.4210532473981465`}}], 
   ArrowBox[{{0.09999999999999991, -1.105263157894737}, {
    0.10026581511619076`, -1.1052634123914469`}}], 
   ArrowBox[{{0.09999999999999991, -0.7894736842105263}, {
    0.10026581511619076`, -0.7894726865834236}}], 
   ArrowBox[{{0.09999999999999991, -0.47368421052631576`}, {
    0.10026581511619076`, -0.4736772825603245}}], 
   ArrowBox[{{0.09999999999999991, -0.15789473684210525`}, {
    0.10026581511619076`, -0.15779497413183116`}}], 
   ArrowBox[{{0.09999999999999991, 0.15789473684210525`}, {
    0.10026581511619076`, 0.15803191056873214`}}], 
   ArrowBox[{{0.09999999999999991, 0.47368421052631576`}, {
    0.10026581511619076`, 0.4737036088310913}}], 
   ArrowBox[{{0.09999999999999991, 0.7894736842105263}, {0.10026581511619076`,
     0.7894821640408997}}], 
   ArrowBox[{{0.09999999999999991, 1.105263157894737}, {0.10026581511619076`, 
    1.1052682478289346`}}], 
   ArrowBox[{{0.09999999999999991, 1.4210526315789473`}, {
    0.10026581511619076`, 1.421056172539343}}], 
   ArrowBox[{{0.09999999999999991, 1.736842105263158}, {0.10026581511619076`, 
    1.7368447848400868`}}], 
   ArrowBox[{{0.09999999999999991, 2.0526315789473686`}, {
    0.10026581511619076`, 2.0526337188279884`}}], 
   ArrowBox[{{0.09999999999999991, 2.3684210526315788`}, {
    0.10026581511619076`, 2.3684228261908724`}}], 
   ArrowBox[{{0.09999999999999991, 2.6842105263157894`}, {
    0.10026581511619076`, 2.684212036564431}}], 
   ArrowBox[{{0.09999999999999991, 3.}, {0.10026581511619076`, 
    3.0000013126672402`}}], 
   ArrowBox[{{0.1999999999999999, -3.}, {
    0.20026581511619074`, -3.000002953501291}}], 
   ArrowBox[{{0.1999999999999999, -2.6842105263157894`}, {
    0.20026581511619074`, -2.684213633112995}}], 
   ArrowBox[{{0.1999999999999999, -2.3684210526315788`}, {
    0.20026581511619074`, -2.3684242949196626`}}], 
   ArrowBox[{{0.1999999999999999, -2.0526315789473686`}, {
    0.20026581511619074`, -2.0526348994517787`}}], 
   ArrowBox[{{0.1999999999999999, -1.736842105263158}, {
    0.20026581511619074`, -1.736845351673668}}], 
   ArrowBox[{{0.1999999999999999, -1.4210526315789473`}, {
    0.20026581511619074`, -1.421055402765344}}], 
   ArrowBox[{{0.1999999999999999, -1.105263157894737}, {
    0.20026581511619074`, -1.1052643031299314`}}], 
   ArrowBox[{{0.1999999999999999, -0.7894736842105263}, {
    0.20026581511619074`, -0.789469194888564}}], 
   ArrowBox[{{0.1999999999999999, -0.47368421052631576`}, {
    0.20026581511619074`, -0.4736530346793551}}], 
   ArrowBox[{{0.1999999999999999, -0.15789473684210525`}, {
    0.20026581511619074`, -0.15744580464587182`}}], 
   ArrowBox[{{0.1999999999999999, 0.15789473684210525`}, {
    0.20026581511619074`, 0.1585120186119262}}], 
   ArrowBox[{{0.1999999999999999, 0.47368421052631576`}, {
    0.20026581511619074`, 0.4737715028978056}}], 
   ArrowBox[{{0.1999999999999999, 0.7894736842105263}, {0.20026581511619074`, 
    0.7895118434472062}}], 
   ArrowBox[{{0.1999999999999999, 1.105263157894737}, {0.20026581511619074`, 
    1.1052860625986265`}}], 
   ArrowBox[{{0.1999999999999999, 1.4210526315789473`}, {0.20026581511619074`,
     1.4210685659007272`}}], 
   ArrowBox[{{0.1999999999999999, 1.736842105263158}, {0.20026581511619074`, 
    1.7368541633593377`}}], 
   ArrowBox[{{0.1999999999999999, 2.0526315789473686`}, {0.20026581511619074`,
     2.0526412084101575`}}], 
   ArrowBox[{{0.1999999999999999, 2.3684210526315788`}, {0.20026581511619074`,
     2.368429033648401}}], 
   ArrowBox[{{0.1999999999999999, 2.6842105263157894`}, {0.20026581511619074`,
     2.684217322434677}}], 
   ArrowBox[{{0.1999999999999999, 3.}, {0.20026581511619074`, 
    3.000005907002582}}], 
   ArrowBox[{{0.2999999999999999, -3.}, {
    0.3002658151161907, -3.0000075947176055`}}], 
   ArrowBox[{{0.2999999999999999, -2.6842105263157894`}, {
    0.3002658151161907, -2.68421851522289}}], 
   ArrowBox[{{0.2999999999999999, -2.3684210526315788`}, {
    0.3002658151161907, -2.3684293899437945`}}], 
   ArrowBox[{{0.2999999999999999, -2.0526315789473686`}, {
    0.3002658151161907, -2.05264011738728}}], 
   ArrowBox[{{0.2999999999999999, -1.736842105263158}, {
    0.3002658151161907, -1.736850453175898}}], 
   ArrowBox[{{0.2999999999999999, -1.4210526315789473`}, {
    0.3002658151161907, -1.421059757486824}}], 
   ArrowBox[{{0.2999999999999999, -1.105263157894737}, {
    0.3002658151161907, -1.105266102785237}}], 
   ArrowBox[{{0.2999999999999999, -0.7894736842105263}, {
    0.3002658151161907, -0.789462140239766}}], 
   ArrowBox[{{0.2999999999999999, -0.47368421052631576`}, {
    0.3002658151161907, -0.4736040440627027}}], 
   ArrowBox[{{0.2999999999999999, -0.15789473684210525`}, {
    0.3002658151161907, -0.15674033976607643`}}], 
   ArrowBox[{{0.2999999999999999, 0.15789473684210525`}, {0.3002658151161907, 
    0.1594820328216449}}], 
   ArrowBox[{{0.2999999999999999, 0.47368421052631576`}, {0.3002658151161907, 
    0.4739086766244325}}], 
   ArrowBox[{{0.2999999999999999, 0.7894736842105263}, {0.3002658151161907, 
    0.7895718079619888}}], 
   ArrowBox[{{0.2999999999999999, 1.105263157894737}, {0.3002658151161907, 
    1.1053220557047385`}}], 
   ArrowBox[{{0.2999999999999999, 1.4210526315789473`}, {0.3002658151161907, 
    1.4210936055492385`}}], 
   ArrowBox[{{0.2999999999999999, 1.736842105263158}, {0.3002658151161907, 
    1.7368731117961917`}}], 
   ArrowBox[{{0.2999999999999999, 2.0526315789473686`}, {0.3002658151161907, 
    2.0526563404231117`}}], 
   ArrowBox[{{0.2999999999999999, 2.3684210526315788`}, {0.3002658151161907, 
    2.3684415752462638`}}], 
   ArrowBox[{{0.2999999999999999, 2.6842105263157894`}, {0.3002658151161907, 
    2.6842280020500717`}}], 
   ArrowBox[{{0.2999999999999999, 3.}, {0.3002658151161907, 
    3.000015189435211}}], 
   ArrowBox[{{0.3999999999999999, -3.}, {
    0.40026581511619075`, -3.0000157520068855`}}], 
   ArrowBox[{{0.3999999999999999, -2.6842105263157894`}, {
    0.40026581511619075`, -2.6842270959008867`}}], 
   ArrowBox[{{0.3999999999999999, -2.3684210526315788`}, {
    0.40026581511619075`, -2.368438344834693}}], 
   ArrowBox[{{0.3999999999999999, -2.0526315789473686`}, {
    0.40026581511619075`, -2.052649288304222}}], 
   ArrowBox[{{0.3999999999999999, -1.736842105263158}, {
    0.40026581511619075`, -1.7368594194525444`}}], 
   ArrowBox[{{0.3999999999999999, -1.4210526315789473`}, {
    0.40026581511619075`, -1.4210674112397288`}}], 
   ArrowBox[{{0.3999999999999999, -1.105263157894737}, {
    0.40026581511619075`, -1.1052692658157741`}}], 
   ArrowBox[{{0.3999999999999999, -0.7894736842105263}, {
    0.40026581511619075`, -0.7894497411600605}}], 
   ArrowBox[{{0.3999999999999999, -0.47368421052631576`}, {
    0.40026581511619075`, -0.4735179393425256}}], 
   ArrowBox[{{0.3999999999999999, -0.15789473684210525`}, {
    0.40026581511619075`, -0.15550043179552697`}}], 
   ArrowBox[{{0.3999999999999999, 0.15789473684210525`}, {
    0.40026581511619075`, 0.1611869062811504}}], 
   ArrowBox[{{0.3999999999999999, 0.47368421052631576`}, {
    0.40026581511619075`, 0.4741497698409282}}], 
   ArrowBox[{{0.3999999999999999, 0.7894736842105263}, {0.40026581511619075`, 
    0.7896772001394855}}], 
   ArrowBox[{{0.3999999999999999, 1.105263157894737}, {0.40026581511619075`, 
    1.1053853163154808`}}], 
   ArrowBox[{{0.3999999999999999, 1.4210526315789473`}, {0.40026581511619075`,
     1.42113761462844}}], 
   ArrowBox[{{0.3999999999999999, 1.736842105263158}, {0.40026581511619075`, 
    1.7369064151094504`}}], 
   ArrowBox[{{0.3999999999999999, 2.0526315789473686`}, {0.40026581511619075`,
     2.0526829360822436`}}], 
   ArrowBox[{{0.3999999999999999, 2.3684210526315788`}, {0.40026581511619075`,
     2.368463618054629}}], 
   ArrowBox[{{0.3999999999999999, 2.6842105263157894`}, {0.40026581511619075`,
     2.68424677228319}}], 
   ArrowBox[{{0.3999999999999999, 3.}, {0.40026581511619075`, 
    3.0000315040137706`}}], 
   ArrowBox[{{0.4999999999999999, -3.}, {
    0.5002658151161907, -3.00002953501291}}], 
   ArrowBox[{{0.4999999999999999, -2.6842105263157894`}, {
    0.5002658151161907, -2.684241594287847}}], 
   ArrowBox[{{0.4999999999999999, -2.3684210526315788`}, {
    0.5002658151161907, -2.368453475512418}}], 
   ArrowBox[{{0.4999999999999999, -2.0526315789473686`}, {
    0.5002658151161907, -2.0526647839914687`}}], 
   ArrowBox[{{0.4999999999999999, -1.736842105263158}, {
    0.5002658151161907, -1.7368745693682575`}}], 
   ArrowBox[{{0.4999999999999999, -1.4210526315789473`}, {
    0.5002658151161907, -1.4210803434429125`}}], 
   ArrowBox[{{0.4999999999999999, -1.105263157894737}, {
    0.5002658151161907, -1.1052746102466817`}}], 
   ArrowBox[{{0.4999999999999999, -0.7894736842105263}, {
    0.5002658151161907, -0.789428790990903}}], 
   ArrowBox[{{0.4999999999999999, -0.47368421052631576`}, {
    0.5002658151161907, -0.4733724520567092}}], 
   ArrowBox[{{0.4999999999999999, -0.15789473684210525`}, {
    0.5002658151161907, -0.15340541487977097`}}], 
   ArrowBox[{{0.4999999999999999, 0.15789473684210525`}, {0.5002658151161907, 
    0.16406755454031488`}}], 
   ArrowBox[{{0.4999999999999999, 0.47368421052631576`}, {0.5002658151161907, 
    0.4745571342412141}}], 
   ArrowBox[{{0.4999999999999999, 0.7894736842105263}, {0.5002658151161907, 
    0.7898552765773248}}], 
   ArrowBox[{{0.4999999999999999, 1.105263157894737}, {0.5002658151161907, 
    1.1054922049336315`}}], 
   ArrowBox[{{0.4999999999999999, 1.4210526315789473`}, {0.5002658151161907, 
    1.4212119747967462`}}], 
   ArrowBox[{{0.4999999999999999, 1.736842105263158}, {0.5002658151161907, 
    1.7369626862249563`}}], 
   ArrowBox[{{0.4999999999999999, 2.0526315789473686`}, {0.5002658151161907, 
    2.0527278735752588`}}], 
   ArrowBox[{{0.4999999999999999, 2.3684210526315788`}, {0.5002658151161907, 
    2.368500862799798}}], 
   ArrowBox[{{0.4999999999999999, 2.6842105263157894`}, {0.5002658151161907, 
    2.6842784875046655`}}], 
   ArrowBox[{{0.4999999999999999, 3.}, {0.5002658151161907, 
    3.00005907002582}}], 
   ArrowBox[{{0.5999999999999999, -3.}, {
    0.6002658151161907, -3.0000531630232383`}}], 
   ArrowBox[{{0.5999999999999999, -2.6842105263157894`}, {
    0.6002658151161907, -2.6842664486654932`}}], 
   ArrowBox[{{0.5999999999999999, -2.3684210526315788`}, {
    0.6002658151161907, -2.3684794138170893`}}], 
   ArrowBox[{{0.5999999999999999, -2.0526315789473686`}, {
    0.6002658151161907, -2.0526913480267486`}}], 
   ArrowBox[{{0.5999999999999999, -1.736842105263158}, {
    0.6002658151161907, -1.736900540652337}}], 
   ArrowBox[{{0.5999999999999999, -1.4210526315789473`}, {
    0.6002658151161907, -1.4211025129340844`}}], 
   ArrowBox[{{0.5999999999999999, -1.105263157894737}, {
    0.6002658151161907, -1.1052837721282374`}}], 
   ArrowBox[{{0.5999999999999999, -0.7894736842105263}, {
    0.6002658151161907, -0.7893928764152043}}], 
   ArrowBox[{{0.5999999999999999, -0.47368421052631576`}, {
    0.6002658151161907, -0.473123045281024}}], 
   ArrowBox[{{0.5999999999999999, -0.15789473684210525`}, {
    0.6002658151161907, -0.14981395730990354`}}], 
   ArrowBox[{{0.5999999999999999, 0.15789473684210525`}, {0.6002658151161907, 
    0.1690058086988826}}], 
   ArrowBox[{{0.5999999999999999, 0.47368421052631576`}, {0.6002658151161907, 
    0.4752554732131328}}], 
   ArrowBox[{{0.5999999999999999, 0.7894736842105263}, {0.6002658151161907, 
    0.7901605504707635}}], 
   ArrowBox[{{0.5999999999999999, 1.105263157894737}, {0.6002658151161907, 
    1.1056754425647473`}}], 
   ArrowBox[{{0.5999999999999999, 1.4210526315789473`}, {0.6002658151161907, 
    1.4213394493709854`}}], 
   ArrowBox[{{0.5999999999999999, 1.736842105263158}, {0.6002658151161907, 
    1.737059150994395}}], 
   ArrowBox[{{0.5999999999999999, 2.0526315789473686`}, {0.6002658151161907, 
    2.052804909277571}}], 
   ArrowBox[{{0.5999999999999999, 2.3684210526315788`}, {0.6002658151161907, 
    2.3685647109343733`}}], 
   ArrowBox[{{0.5999999999999999, 2.6842105263157894`}, {0.6002658151161907, 
    2.6843328564557667`}}], 
   ArrowBox[{{0.5999999999999999, 3.}, {0.6002658151161907, 
    3.000106326046476}}], 
   ArrowBox[{{0.6999999999999998, -3.}, {
    0.7002658151161907, -3.000096481042173}}], 
   ArrowBox[{{0.6999999999999998, -2.6842105263157894`}, {
    0.7002658151161907, -2.6843120150245112`}}], 
   ArrowBox[{{0.6999999999999998, -2.3684210526315788`}, {
    0.7002658151161907, -2.368526967375653}}], 
   ArrowBox[{{0.6999999999999998, -2.0526315789473686`}, {
    0.7002658151161907, -2.052740048758096}}], 
   ArrowBox[{{0.6999999999999998, -1.736842105263158}, {
    0.7002658151161907, -1.7369481546731498`}}], 
   ArrowBox[{{0.6999999999999998, -1.4210526315789473`}, {
    0.7002658151161907, -1.4211431570012332`}}], 
   ArrowBox[{{0.6999999999999998, -1.105263157894737}, {
    0.7002658151161907, -1.1053005689110897`}}], 
   ArrowBox[{{0.6999999999999998, -0.7894736842105263}, {
    0.7002658151161907, -0.7893270330264234}}], 
   ArrowBox[{{0.6999999999999998, -0.47368421052631576`}, {
    0.7002658151161907, -0.47266579952560106`}}], 
   ArrowBox[{{0.6999999999999998, -0.15789473684210525`}, {
    0.7002658151161907, -0.14322961843181328`}}], 
   ArrowBox[{{0.6999999999999998, 0.15789473684210525`}, {0.7002658151161907, 
    0.17805927465625673`}}], 
   ArrowBox[{{0.6999999999999998, 0.47368421052631576`}, {0.7002658151161907, 
    0.476535761328317}}], 
   ArrowBox[{{0.6999999999999998, 0.7894736842105263}, {0.7002658151161907, 
    0.7907202192754011}}], 
   ArrowBox[{{0.6999999999999998, 1.105263157894737}, {0.7002658151161907, 
    1.1060113782217926`}}], 
   ArrowBox[{{0.6999999999999998, 1.4210526315789473`}, {0.7002658151161907, 
    1.4215731527570905`}}], 
   ArrowBox[{{0.6999999999999998, 1.736842105263158}, {0.7002658151161907, 
    1.737236003071699}}], 
   ArrowBox[{{0.6999999999999998, 2.0526315789473686`}, {0.7002658151161907, 
    2.052946141398477}}], 
   ArrowBox[{{0.6999999999999998, 2.3684210526315788`}, {0.7002658151161907, 
    2.3686817658477617`}}], 
   ArrowBox[{{0.6999999999999998, 2.6842105263157894`}, {0.7002658151161907, 
    2.684432532866118}}], 
   ArrowBox[{{0.6999999999999998, 3.}, {0.7002658151161907, 
    3.000192962084346}}], 
   ArrowBox[{{0.7999999999999998, -3.}, {
    0.8002658151161907, -3.0001890240826246`}}], 
   ArrowBox[{{0.7999999999999998, -2.6842105263157894`}, {
    0.8002658151161907, -2.6844093613369586`}}], 
   ArrowBox[{{0.7999999999999998, -2.3684210526315788`}, {
    0.8002658151161907, -2.368628559068949}}], 
   ArrowBox[{{0.7999999999999998, -2.0526315789473686`}, {
    0.8002658151161907, -2.052844091229609}}], 
   ArrowBox[{{0.7999999999999998, -1.736842105263158}, {
    0.8002658151161907, -1.7370498755357948`}}], 
   ArrowBox[{{0.7999999999999998, -1.4210526315789473`}, {
    0.8002658151161907, -1.4212299875083234`}}], 
   ArrowBox[{{0.7999999999999998, -1.105263157894737}, {
    0.8002658151161907, -1.1053364529471832`}}], 
   ArrowBox[{{0.7999999999999998, -0.7894736842105263}, {
    0.8002658151161907, -0.789186367604937}}], 
   ArrowBox[{{0.7999999999999998, -0.47368421052631576`}, {
    0.8002658151161907, -0.47168895632083385`}}], 
   ArrowBox[{{0.7999999999999998, -0.15789473684210525`}, {
    0.8002658151161907, -0.12916307628316587`}}], 
   ArrowBox[{{0.7999999999999998, 0.15789473684210525`}, {0.8002658151161907, 
    0.1974007701106469}}], 
   ArrowBox[{{0.7999999999999998, 0.47368421052631576`}, {0.8002658151161907, 
    0.47927092230166507`}}], 
   ArrowBox[{{0.7999999999999998, 0.7894736842105263}, {0.8002658151161907, 
    0.7919158753580362}}], 
   ArrowBox[{{0.7999999999999998, 1.105263157894737}, {0.8002658151161907, 
    1.1067290589436625`}}], 
   ArrowBox[{{0.7999999999999998, 1.4210526315789473`}, {0.8002658151161907, 
    1.4220724281728603`}}], 
   ArrowBox[{{0.7999999999999998, 1.736842105263158}, {0.8002658151161907, 
    1.7376138234186667`}}], 
   ArrowBox[{{0.7999999999999998, 2.0526315789473686`}, {0.8002658151161907, 
    2.0532478645658667`}}], 
   ArrowBox[{{0.7999999999999998, 2.3684210526315788`}, {0.8002658151161907, 
    2.3689318377081823`}}], 
   ArrowBox[{{0.7999999999999998, 2.6842105263157894`}, {0.8002658151161907, 
    2.684645477924597}}], 
   ArrowBox[{{0.7999999999999998, 3.}, {0.8002658151161907, 
    3.000378048165249}}], 
   ArrowBox[{{0.8999999999999998, -3.}, {
    0.9002658151161906, -3.0004784672091436`}}], 
   ArrowBox[{{0.8999999999999998, -2.6842105263157894`}, {
    0.9002658151161906, -2.6847138274631237`}}], 
   ArrowBox[{{0.8999999999999998, -2.3684210526315788`}, {
    0.9002658151161906, -2.368946303301172}}], 
   ArrowBox[{{0.8999999999999998, -2.0526315789473686`}, {
    0.9002658151161906, -2.0531695006617903`}}], 
   ArrowBox[{{0.8999999999999998, -1.736842105263158}, {
    0.9002658151161906, -1.7373680237657703`}}], 
   ArrowBox[{{0.8999999999999998, -1.4210526315789473`}, {
    0.9002658151161906, -1.4215015637751807`}}], 
   ArrowBox[{{0.8999999999999998, -1.105263157894737}, {
    0.9002658151161906, -1.1054486859962416`}}], 
   ArrowBox[{{0.8999999999999998, -0.7894736842105263}, {
    0.9002658151161906, -0.7887464140526281}}], 
   ArrowBox[{{0.8999999999999998, -0.47368421052631576`}, {
    0.9002658151161906, -0.4686337233186897}}], 
   ArrowBox[{{0.8999999999999998, -0.15789473684210525`}, {
    0.9002658151161906, -0.08516772105229001}}], 
   ArrowBox[{{0.8999999999999998, 0.15789473684210525`}, {0.9002658151161906, 
    0.25789438355310124`}}], 
   ArrowBox[{{0.8999999999999998, 0.47368421052631576`}, {0.9002658151161906, 
    0.48782557470766874`}}], 
   ArrowBox[{{0.8999999999999998, 0.7894736842105263}, {0.9002658151161906, 
    0.7956554805526607}}], 
   ArrowBox[{{0.8999999999999998, 1.105263157894737}, {0.9002658151161906, 
    1.1089737199248295`}}], 
   ArrowBox[{{0.8999999999999998, 1.4210526315789473`}, {0.9002658151161906, 
    1.4236339917072895`}}], 
   ArrowBox[{{0.8999999999999998, 1.736842105263158}, {0.9002658151161906, 
    1.7387955168442895`}}], 
   ArrowBox[{{0.8999999999999998, 2.0526315789473686`}, {0.9002658151161906, 
    2.0541915519191916`}}], 
   ArrowBox[{{0.8999999999999998, 2.3684210526315788`}, {0.9002658151161906, 
    2.369713977356731}}], 
   ArrowBox[{{0.8999999999999998, 2.6842105263157894`}, {0.9002658151161906, 
    2.6853114975755834`}}], 
   ArrowBox[{{0.8999999999999998, 3.}, {0.9002658151161906, 
    3.000956934418287}}]},
  AspectRatio->1,
  Axes->None,
  Frame->True,
  FrameTicks->{{{-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, Automatic, None, None}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sung mit NDSolve", "Subsection"],

Cell["\<\
Die bisherige Analyse hat gezeigt, dass in der N\[ADoubleDot]he von x=1 \
Instabilit\[ADoubleDot]ten zu erwarten sind, wahrscheinlich eine Polstelle. \
Deshalb wollen wir L\[ODoubleDot]sungen im Bereich -1<x<0.9 f\[UDoubleDot]r \
verschiedene Anfangswerte y[0]=c studieren.\
\>", "SmallText",
 CellChangeTimes->{{3.36644068241181*^9, 3.36644078187982*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "4"}]}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36638300616063*^9, 3.36638301724437*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "F\[UDoubleDot]r Anfangswerte c\[GreaterEqual]2 hat ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " keine Probleme, eine L\[ODoubleDot]sung \[UDoubleDot]ber den ganzen uns \
interessierenden Bereich zu generieren. Diese passt auch gut in das \
Vektorfeld der Dgl."
}], "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
  3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
  3.36644048070057*^9}, {3.3664405920042*^9, 3.36644063780813*^9}, {
  3.3664407928681*^9, 3.36644081343934*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsol1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "2", ",", "4", ",", ".5"}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
   3.36644045227148*^9, 3.36644045299187*^9}, {3.36644058552207*^9, 
   3.36644058669555*^9}, 3.3664408585507*^9, {3.36696808047478*^9, 
   3.36696808308461*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Eine Art Probe.", "SmallText",
 CellChangeTimes->{{3.36638310916353*^9, 3.36638311213621*^9}, {
  3.382702857935231*^9, 3.382702896428649*^9}, {3.389325197433865*^9, 
  3.389325198025614*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", "eqn", "]"}], "/.", 
    RowBox[{"nsol1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36591897620293*^9, 3.36630638308132*^9, 3.36630668488073*^9, {
   3.36644037244102*^9, 3.36644037260496*^9}, 3.36644086426545*^9, {
   3.36696903009287*^9, 3.36696906132145*^9}, {3.3669691705387*^9, 
   3.36696917315582*^9}, 3.36696921290739*^9, {3.36696986140894*^9, 
   3.36696986412891*^9}, {3.38270270509602*^9, 3.382702709453922*^9}, {
   3.382702758178848*^9, 3.382702815413026*^9}, {3.382702871489782*^9, 
   3.382702892420672*^9}, 3.382702941423127*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwk3Hc81d8fB3DJt1AkSUPDCglJVsZJkqxkZWVWSsqWBolCi5KdhOy99ziu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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1, 0.9}, {-0.000037865821320037796`, 
    0.000029921860093540253`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Und hier die L\[ODoubleDot]sungen selbst.", "SmallText",
 CellChangeTimes->{{3.36638312592233*^9, 3.36638313262727*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", 
   RowBox[{"vf", "[", 
    RowBox[{"2", ",", "4.5"}], "]"}], ",", "myPlotOptions"}], "]"}]}], "Input",\

 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638331099061*^9}, {3.3664408694685*^9, 3.36644088810172*^9}, {
   3.36696865274727*^9, 3.3669686529012*^9}, {3.3669690468311*^9, 
   3.36696905710896*^9}, 3.36696987454002*^9, {3.382702661167972*^9, 
   3.382702668994074*^9}, {3.389325266614429*^9, 3.389325270273916*^9}, {
   3.389325309837923*^9, 3.38932531748862*^9}, {3.389325701517202*^9, 
   3.38932570687171*^9}, {3.389325898744127*^9, 3.389325920065236*^9}, 
   3.389338550776048*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13k8VU8UAPBny1IoRYXKTqUfUZHk3EQlURQRSalEklCksmQNhRYkSXZK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      "]], LineBox[CompressedData["
1:eJwd13c8Vl8YAHC8r5cUZSYa9ooIWZVzk1LJiMxE0jYSKj/JSNlFUWaSPbNl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      "]], LineBox[CompressedData["
1:eJwd13c8Vl8YAHBR3mHvflr2iqySJOcmDRmVykoqkpJNErI3hSgzCSGizOyD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      "]], LineBox[CompressedData["
1:eJwd13c8l08cAHBR1ncoK0n2jsyQX9yTpEERyqhUSkNIRmWEkF0oIiubiLK3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      "]], LineBox[CompressedData["
1:eJwd2Hc81d8bAHD0JSPuJUkayB5lZv3kuVkNkZSMolJSskepJHtWVEQISWb2
yMqxZZQ9svcORSrC73z6h9f79XHPfT7nec5zzsFrZqtnTkNFRXUA/yB+05Ye
ntvaWkQLgp5k8CJRKv8s9CquL6KmorFUW2x3+cwGx9VFJKXIqBSH/TdHInVq
fhGFi6fIUXuTKCspkreavy6ib4c1Uiqxx8Olp2JyF9H72SQnNV88nqPc2FGL
RVTlk5qiHECiuImp9D34soDyvOWKmINJlJd2Zf9peH1D5msMmjujSBTPVTke
ap15dFF/QDjsHYni++q+xpcDc4jrHtttxUwSRYRNImG6cwZ9SG3O+VlIosQ1
9q38jJ9GuWM0AVcrSJQC4z9uuhemEKvC/bKmehJljG6UrZQ0iT6ryyyYtOL4
lisjuIbG0dbLF96t3SSKdwG7YW3oGPIcHasRGyRRfheZMphfGUXeFpbU3mP4
ea9jNbv0CFoLYrqiOE2imLxZtufrGEKnPj+yr5wnUYxJSyrb7AYQ+n7Y494S
iRIm/MXtYU8vmh2kzVpdJlG2Hqi27dHuQSeTytWHVkmU8ySevii1HrSsuikx
g50cvzG2X6kHpVwIYF/G1q0v/Mkr1IP+eDytp/tFosRzSOwRpe5BXqJeY4ew
1bP3XlHK70aVnX4997H9J1e+Ge/vRiYiwW2k3yQK69kkhuhvnYi9neOa4B8S
he22rqvuWCdqf8thJoHN7vNn4b+vnUhuLcdIAZujSKvDuroTjUY3SJ/C3su7
FANRnSjN9cNja2yB7wqyYyc6UXVp2EgOtuKzBlPRhA7E8bODW2GNRLna+i23
0LgdnVodsz+0TqLcTBcs23e2HX0/FSIhi20XcPmT+/F29OzVmSklbPdjrf0n
ZNvRhU8sGiew47LzaL8ytyPxieoiM+yhZw8M/pS3odyJkoCX2CZ6DOuKQm2I
07+u9Q/29cOqtDH725A1T2LnFrYV4wMSDXsbmvvY0077l0RxrZzna6BqQ633
VRErdrR0y2nj3lbksP+angh2H1t4zP0nregEKee2AbZRO79qyXILUljUuZeJ
zSInUnB2pgV5OF4/mo9dGXFIdHqwBV3M41kvxhY3lWPb1dCCVkQjrtViU80c
H7WJa0Esgl+m+7ETNy09D2q3oEzBrFr6DRJl+pyZz07tZpR2p2HsIrbentvW
FIVmxF/JMnoFu3TQUd+arxnJrJ/rNccOvuUjUPfnC2KanS+0xZZ7lFxzP/EL
MkxMPeyF7ZW6QDu69Rnt/jW+mYx9gPqBb1ZOE0qbbNZcwjZy4XmkEtOEFtq2
313BDl2sudsU0IRMVNve/MZmHCTfmr7ShLaXiUxRbZIov4oTtXhITcgpU1KK
FbvFqY0ccrsRzVLYaySxvaZFomz5G9ClFjlqK+yyy80vNkgNaF/9lQBb7LUu
p8dB6/WI/seDHY7YdjXoYVJbPVJbeLbtPvaleP0rQ+71SFXjWb4fttwlD4Ez
A5+Qxy4vsXjs6eaezMMv61DJoytO7diSja+793rVIabbjw53Yd+rNduit6tD
475B4z3YjB/ndcZO1qGrfM7qg9hiqVQL4Ru1yLu0vX0a28ZbWJzavBbZPJeX
2cD+qeCS3C5Tg8bibm7n2yJRVGSPtpTz1CD2BWN1AWxfCZrf6cw1SHgp+KEQ
Nofg4+P+U9WIrqhpXAxbYWfcpHJUNdqY6vOVxXb9VsefSFONmFje7dXAponf
/caltRIJsvtEXsNOSHWMbiitRDd1bwWZYx/PbQ7fl1yJuBNPu1hgP672e1ru
VolUJQ9o3sbeNfXrAb14JeLZdS7HAVtYvOdChG8Foh3ybnHHbpCV1Zu1r0AJ
ldxenthWR0O0lU0q0ObdVSlv7GydE+rDMhXI0vKGtx+2kn2hlPBIOcpbLPr7
BFu7IGJH4f/KUaH/A5VI7KWyle2MQuXIMTe8IAr7eZ3utkts5ejnHzGx19jp
2awrW60Idc03MsRhl69+/xIsjlDMnN7rd9gT7jnemSMf0aJRPU8WtmSYzNKC
Vgn6YVqYW4kdnCGqcVagBN2g0c6qwl6o443M3SxGkVTyqdXE+GskdZfsYlRX
x/myFlv0ynw49e5i9DnSUacBm0/sHbCPFiINHj/1VmxP9ejQOyWFSFCLmbMN
e9TkxUxPaCHqKuaeIRwX4vHi9fFCxMf3y6sDe9+qyZRg+ge0Q6olupvIZwVH
sKJLAepmETcdwHbuZR6POluAqM3Ydgxidyz/p7gpWoDoxks+EH4uuDxaOZCP
Un2u0w9jkx43y51Wy0fcGWeCR7HpDfwHTVnyEOnpe7kpbAu7RzIVU7loJEut
knBtwB1/vopcpHqoQ2sa26f0uvS0Yy5yKls0nCHq5eAxX/uvOYh9192Lc9jr
838OeSdkoy7Bn/8tYm/eEk1IdstGP4w+2BKmmjLm+myYjSzmy3oI/zdSQsfB
nI1I42nvlrB3dD4cSnLOQmF3DcV+YLPoZeg3nclCnIox/oTJzYONSyJZ6OzT
Y+OERZ4/snMszURLDzNfLhP1cn/bwfAnGYii8HR6hVgfTtdZho9loCYTQcWf
2Ko2NWvCq+lIWEzRn7CWmV97sWk6unx8gHcV+9IpJp9BifdI4LSP2i/sK+pW
9kLjaej5HUN/wtdVPpvYRaShuUtVjYStpYPlaKjTkNWUjc5vbDeundMCbSmI
pdhT7Q+Rb3anDhvfFHQk8N5Dwr4sneUflFLQdVGBAsLBNOGvTr5NRmPXU/jW
iPzPcmlZOyWhGv/GRcIJ4w/kC4STkEfsF+517OTBfr6t/kRkGvlWh3B2W8zf
EI1ElLO9PJlwZfHBjDyOdyh3Y1jnL5G/PK/IjYYE9HvguTPhhoxxX81HCegu
lVgU4fb4xMs9U2/RehL3GOGe6O2neaPfork1b9oN7P6XNxUsdd+iBbFRQcLj
gaKsfwvjEVV12A3C095BG+rW8ejv7xVvwvNu8zNPeOPRSJJJPOEVh4xK7sA3
SIVk0kuY9qK0k9rFOCR+PBg2se0DFzO4GeIQb1y8IeFiR6P2X9axqKDoox1h
SymdspsCMUgmlTeGsGrIJxlej9eoq8w5lzDXomrK1/5oFEyariPc8F4+9FRo
FCocPrpAOJ4ph2HbUiQaixGn2sK+byn+qEQrEkWy67ISFhXmtRTf9godjNeS
IkzjFzU0bhqBMn4dphDundil/7o4HG2IX9EhHPiWkcLi8BLFPaq5SdiMxie/
9nMYiu3540RY6eqW6CORMFSa6O1OmK38Xpy8Tyj6NWMeRHj2wMqupeEXSDf+
dRjhyoc2QcnKL9CnZrFYwpH901RXI54jEwdyMuFTkQNzrWeeoYJtzIWED/4x
uBqYFoJ6A88gwmsGbV2q20OQjsPuWsIJ1q8iVmueIrbi602Ez4k99bJ4+AQJ
mcm3/Xu/GU+bHtnH6IllcDfhnMS7RifnA5Fau1X/v/e5bqVe/DYAnYpuHv4X
/8GrEmIX/RFl7MP4v3iH9Lmi2fyQbQxlmrDD61O0zA0+SPqu29y/+C7C0kMP
b+Rvbb9AuI1Ttm9BwQvZe+z5TtizS7j28pIH+pZzZ5mwdOj+7JYkd7RBHfCT
cNVbfgWvMjcUa6P769943Cws5odcUdfvpt//Ph/5a0wz+h6Kjdv8Q3h010iR
MNNd5FJBv05Y9VlDMON9J5StI/eXcPyOPPP5aXuUYH9p49/4dCx8V57cQvJt
TZuEvactfn55ZopUCuy3CG9WUhkKUWnA11A6fJsgUyr08wTXP90CKfXgf+aV
9ZsqonOAGxEG1ISvHs3736rwXdh21YyGME1lgzl78T24VTX0z/GaI8HSWq4Q
2um+jbBq468i3X43YD2v+R/h70LbHT4UuMOAiiQtYRsRrrBzMx5Af12MjvCs
6KHCxb1ecO6Y5nbCN8QpfUE63oC63OkJjx46tynk4QNa/H0MhE0lbvBW5/rC
LxF9JsK9kvfUr0z6QTF5eQfhC9KPLf5yBoCAYTUL4TaZ2MAIrUA4fLeBTFjn
SE66rFsQdFrT7iTcIFfT0pL1GPYqO+8irKnQs2w19gQ2R/ZwEq5SnONg4AgG
98vLXITj9m9F6/GHQFwe9YF/8cT4Z8R9DIHLI+q8/+KJjWpVXnoGS5p3hQlH
8AiMBQY8hzdtD8T/xfcmY6Xn4At4n90g+S+++Irdzvqh0HrruBLhED4tkaqF
UJhXdYZ/8SZ0KLH6h8EV22/q/+J9N2WSXvwSjCpLdQn7C9rbrp8Lh2cSuwz+
xZ+05n7yWzj80kYmhCuTmRMmuF/BZTN2K8LuIuH5MkWvgDas2pGwSipPnYde
JNy40vqAcEmazOx+nyiIU2J6Qvi++Mf12weigdv36EvCCumazMUfoiF+rCuW
cF6GkeSF2dewpX0yj7CDxNixBK8YcAsXQoQls6zO/dgXC1pWdxsId/XA/+qE
4mCP1J1Rwkde/adu4xQHyER0kXCoUf3pXRVxsPnU+C9hvV4902vGb+CJiyIn
NfaXPnOPrcfxsFaodIHwoWjRwMSv8XDjIqcF4ceXFp9rC76FrRVfF8KnBlwS
otBb2PDlfU045fXRdNUdCcBQqpdFmN6UpmDGMAECr3JXE64dDKqT/5EA8nfD
vhEWiNVtGVR5B/T86ttosL0v7/rqE/QOXhVH7CGsOhwz286fCJqayicIo5Fs
ZjuDJJD4GZFOuMCK65NXahLsM1trIJzxy9MzfCMJaIalZwhHM5//VfY2Gcx8
jwhvI+ZbcXWYeSkFmKt6sgjbV5tG8aqlwuWNk52Eb56p0z/yMhXW5dPWCBuY
RzRcUk6DIoFTJ/7Dln2mlJfm/x4Whc8uEhbb99YG9b2HQ2mv9tJiH0xiEmk/
nA7b98+dIMz6sf/1Wkc6HDmen0h4YdrN7yRvJuxcP2pLh30+7mr6cn8WZE7T
ytNjt0yEBT6kywaavxbOhLXEGiy2S2ZDvCFDPmHVAumDe72y4af8bgUGbKmm
beGqIjmg+LJUmxH7PauCU5NeDiitO78kLGxgdfaCaw5MHg0YJswz2sFk2ZwD
1okNLkzYLL/fuT9zzgUvJo7iHdiBR3tN9sbmgoD5OjMzNp0Xy//efcqFFkn9
a4Q3mO/+LNybB3Y3HdlYsOf5TlgOV+SB4JUPniTs+jOz5yRYCuBV/N0MNqJ/
SU2QfskVwKWnJ/fsJOZ/53Bj2eUCELtU7ENYvLtTTSe7AA4w+l5jx35qWiFj
ff4DNCfwyXAQ82MdsTMtshCG3S0EuIh6PPOi2aGqELz/V5xGmE7qaZDSfCHQ
BozI7MX+sOK1reFoEfScKDm5D5vL1XZ5ergIRM7+CTqAPRyo2S4oVAJ/V2Os
+bCLrI4FL5wpAT7tbjZ+7Oc6yloFLiXQvWd/MWE1NukqjYYSCFQcZhHETny1
P/e6dSkEeWe0CmPfTl55Hp/7Ee71F6PD2OqBizqW/R/BNTXETwJ7n9UsozRt
GYTfyzorSawviWHPigtlkHN0YF6KWL8fGh2G/5TBzzP6cAR73eysCImnHA5L
kgyViX53RqJnp0w5nMmXkDuKXazM7MepWQ5nH3hyqGC7cNSP81qVAzVb4wBg
r9RT4mQLy0HNTMVPjciPpORuY90K2KVrckILu3E/S63ptQqI0WbTOo2dyjjv
dO1OBdwOFNXVJup/PKnNKroChM8+v3oGeyKc++mj6Qqgjop9cw57cJOF9p17
JcyY5r+6hP1xbj435UUlrAwoVZsQ662nwSwjsRLSso2/m2Ib5/iWf2iqBHPe
u+euYnebbz5o4KyCnhQv+RtEvTd9+7GYVQVurxc97Ih+Gtk0rDRSDSm0RxT8
sI/f31na+7MalCreDfhjNxkZh99nrAF/mWTfQGI8zmntYpkayGtzHHtCvO/L
bSWKvjUwufvNp1DsXS+UwhTEaqFz7KLGW+xIBw+7HqgFxv+YBN8R60Hvk5bL
+VoYHXrJmIQtynqBpvBhLYSYGw6lEv072N5WvqUWoieZCnOI+QlKPinnXAf7
0t1Eq7C/WS7ydwXUgWOehlYN0Z9PyVHdiamD9jF5uzpsV4bqgvy6OqjTz65t
xH7mN8R3hOsTyFZ7JHYQ+fTi2JRBn6CicPTIFDazq3eOFEMDMN9gKCBR437Y
nWbqsK8BbuYPyLNh/5VuZ8yVaIBzqsMf2bHnZ3ivyV5ogFVWz6492E0GaKf8
2wYQdypQ4sd+LLPmpHy0EZzjW9sUsRnnbOWP2zcBe/jpqzexPTXDx/y8m2BC
Ktb+Nvbam7LgT+FNwL+c6WuDPWvIPH2yrAkYJvcjJ+yG2tSI00yfQepeyi0P
7ID4iT9n330G+lyblChseuOLpZe+foFMlucr7dgZ2yYNlOe/gEU79YtubP10
u+W9W1/Aa2+oXB92PJWvaB9/M7y3lHkyiq2clBVhZNcMYnfGXL5jK6x5KqVt
awHpz8o6ZBoyxep4D0dyZAuMddqx6WFD9Ovx3Qkt8Oelm+kFbLbvZjl+6S0Q
73Eiyxi7KPKbtkV5C9yh5ze/hk23QOMjONkCj7Xd2Z2x40IPLSdItYK9GvPT
V9jtI57Nbz61QoMoN9sU9lqmq8xQWytcs2F8Oo/N43YnfN9AK+yQf8T6g4iH
y/Jy+PdWOFfOK7FBjH/u7OJjrjbgCWGt3bkNx1/NTXKxagNOcvtNVezoxFId
HXI7OMyH5r7DrnQqyAniage6546H32NPq2Zx1PO3Qx8Nys7BPjL0dlBNsR1Y
MwtbEfaX3UE2imbtwEHavNuLTRVg9JQ/rx24XeWus/5Hply/vfp5zaADLoSV
rfhge9+9Eul/tQMCWaoZnmC/9Wq4wXG7A4yoNwVDsUejYrak3Dpgxk/0fjz2
1SZNqVsJHZDqw++NsE0PhYd2L3WAXWqw+Dq24aL8xbyATrjQPLDpQov7z/ob
IdUXnbBVHCvkgR2+fcdKc3QnKFfYGgVgd3EPP57L7ITgs/o9r7D1df3LDnZ1
gtPCiloJtl52D++zg11QSpPSs4Wt7Xhv2rqkC569IUuE0JEp5b93a9XXdEFB
8+uzkdjSbgXp/C1doJDy/VECNmfAskPfeBcUGXNQFWGPxlhvnGDpBu8Yh+BR
bJeGq2z8V7thbMh6WX47rjfeU8q9dD0wsCnMOY+9K2k65ghrD+T3mtf9wvYX
96N+trcHBDWyvbbRkynW8tW1xyV7QLEymm8vtoK2ytl8ox7IPTZBrYX92UX6
Rsj7HohpYVJNx/7dzBWiqfcVQruEBV0ZcD5eiFz8cfEryHMNpPhjt1xQEIwx
/wouUipKYdjJA/qlP12+gt3nwx4Z2IZzIdMJsV9B12QkeQS7iG77sW3fvkLX
txM3TzHi/fPo8nfk1wvMxozfBJjIlEkqmo+3n/VC6vOcPbLYetVk/91RvfBa
5vh5VWxRrcMHbDN6Yf8bk2VT7F7DW6cOdPZC2gfD3ghsJaeheNeDfWD80Euf
tAPvP6mN5xQ/9sHOnCP625nJFLddj1/m1eLnFDHa3dg07qe/SrT0wdOd81WC
2PT6n00Fx/pAYv+GtSY2x9aXWzsZ+uFGU5SzL7bkubZH3873g8rO6ksMLGSK
+XpP2pv5fji63buXi4Tr3fzVwr7Vfojbs3pPHNuqxUgqYqsfHNnjRFSwHd71
FjxlG4A+g/qiq9juZ/orHigMgP2erJgU7Mi3Q9363gOQUNLoo0wmU5q1Jrcx
7huEvkuuoraseL+W6OvXExwEs0WxcG9s150t+VGSg5B5cp4zElu4r8jikMYg
DKdPXqzB9rR80qhrMwhOMfkj+9jweS9A9kV4+SAcsDX424wdWet5UMB8CFTV
fWY12cmUnLhgHh6DYVjb0137YDd+LqVaMX9xGPrMV+TDsD0rV64WXRmGSMhA
Gdh640Zv9SyHgc5CZefobuL+xi/o83AYfjKXN53kxPOVWSg2+3YYOLaqI/bv
wf3z44hc3tIwiJj5s3Zz4fN1r4z2icAR+KHINB92AOcvmaroQfAIDJm/Ui3E
bnL+zJ8ZOgLProcW9WIvkC3+7oodgeuORxl4uPH7HI9MG8sdgRd056XfY6Nc
KsZHAyMg/dqrqoGHTOl8/Lk2X3IUpAStSnn5yBRqsKDwdY+CB1XSSRVhMuXA
8I6bKv2j4PehbvImtrJHTrDRyCjE2O9Ie4F9p2pjMHhuFCrZo1JmsGePhz78
uzUKCtwbnuEi+D6mW1HcKTwG3n7nP62J4vVotveI//0xWC3WSxk+hM+3vs0i
3/aPQ5/UZW9pWTLlkma6T9bBcbDXK/W7jn2HLmjEUWgcCuTkC15ip/hqvlqT
HId05X1h69hkv4/09OrjsDJYalp3hEwZ8EubOmg5Dqf7BFUt5HE/CPB7Z1gw
DpP2K5b1SmRK5mPgrdaZgMOp9RReVVxvAfInFs5NgHFCe+R1bDlfCVtOownQ
3zMqm4xd+oj7o9W1CfAsERGVVCNTPjlsGe5ymQDtbkleNXXcfwxRyI03EyDH
6/vIWROvBwGgYliZAOce5e/MWmTKV155IZk/E8CylNhlhB19QELHZHMCulVP
0yZi83FyR2fTTwL77ziA07gemLbkjfdPQq/MgJSzNr5vfS+zTdOchC6fnwaL
Z8iUhx9VhrRfTULu4xpabn2cj682Sjwxk1BUa0dni/13JSbsR/wkBO4L00XY
ruJbWuHvJyHydlzllQvYxL+60CS01fELJRlg36M8d5ychJT1DWVVY9xvjqhq
vJKZAirJipXcy7jezjrE3VaYApOWnw3MV/D+aBW/fvToFMy8D/xpgX0/gSZn
VHMKDOVcTu6/Sqbc21l1QNx4CkS0e34FmeH5/672u8x9CgRijRvumZMpd9M1
0sY/T0GCoCN/5G28H0brVMa0TQHzUaXzG9gsjw2+GnZPgc52ptErVng9W97a
/nl4CtjGEveIWJMpHUJPruUvT0HqTDttmQ2er/iOvb57puFm1XWlNXvcX15e
eyxkPg00JgkXkQuuf1+rtyO3pkFhjl9O4h6Z8sjZuTjKZhoagy+6xWJznPeb
JrlMw+A9WWOP+/g8z5qm/jtwGvLNXp455YrPC0E//n7KmoZ6FqHs74/IFCN3
D2vLv9Nw1kfTLNKPTNF5n3AmiHoGounLBvn88ed76qTe083AtY8By+nYhyVZ
Vr+RZ0DpaeZMVQDup8ORbvYCM/ArRIr3VxA+j0NesIvODMQ2C/k8CMHzuzmZ
7Rs3A+fee5O3RZIpi6KMoUnvZqBNt9D+Dfb4hUN3PqXOwMJ2gyBKFD4fZDgq
MebPAL+G0Lx7NF5fplRVT+pnoFfjljdjLL5Plu3pCP0xA+KBKbKqCbj+Hp5e
jVefhc+0pOnTmfj+9Slph9XJWVBy/O75G9t95za+IzqzoE5/czwhi0y5llJ0
ps5gFiJtDKmocvD+0imYMmc5C3zPj1SgPDKlUJz6kuyzWVBOoQu+UYzz05df
UTMwC7RhavkXa/H9X5C15+noLKyFLYwerMN/b2+1YDA1C3GjQ3Rz2FHb+fbO
LmG7nFB0qydTzGRCnFj+m4N7L/73KKuJTFkKtBQyEJ2Dmet/jmu2kylMStxP
pu/MAfM+ezaNEVwfFaE2nK5zUDvOnKw6ivvJSUbdEx5zMDA4m3lsDNef4U+2
5KA5eABpB9Un8P3mTmOERdwcTBUf+m48Q/TDuwmT9XMQsnvRqv07meJ4qKVk
fN88CLyuUmf6j5XCkq/xmv3gPGwyd9mp0LJSUpVL3NSF5iEyaCLEkY6VMqyV
eCxBah40vHSqxuhZKdqWrnXXNOehLH7oaT8zK0UoSbh91HYeuFYv5shyslL6
eDxmhyvnYfuQ6GLaYVbKfcYPr+ir5sEgwvL0B2yulfkTkthhf7VSK7GN6wyT
HmGbbi5bfMXutZa8fqB6HuocemfpJFgpPcVDAxdr8HiuzCQz7K7zKq1ddfj7
f9u0ckqyUu6oOLlvYu+x21Llx+YQTpUQ/DQP/hdk8iWwL6zveuqMLZziE6WJ
3fnm2yn2+nlg/d5p64TdsRBdfbYBv+9NKfkWbKeeNsd72E12Wzl92OyV9Hxv
sAUb7CWmsM+HOXksYXcmq4luYrf/77RKcCOO981rIXEpVoqDgOe3AuyvZcHJ
8thspMLoQez9MYKiath6o3zrh5pw/H2qEsbYPxqNUvWxTS58yjHHfp4fbPQQ
O7fxh5w9tnRsDf077JGTlSWu2G3+6x+amoj5lTvmj/1/O3qrfQ==
      "]]}}, 
   {Thickness[Small], Arrowheads[0.02], 
    ArrowBox[{{-1., 2.}, {-0.9779568460206436, 2.0082661827422585`}}], 
    ArrowBox[{{-1., 2.1785714285714284`}, {-0.9779568460206436, 
     2.1859527158217045`}}], 
    ArrowBox[{{-1., 2.357142857142857}, {-0.9779568460206436, 
     2.3638023591256014`}}], 
    ArrowBox[{{-1., 2.5357142857142856`}, {-0.9779568460206436, 
     2.5417749505457454`}}], 
    ArrowBox[{{-1., 2.7142857142857144`}, {-0.9779568460206436, 
     2.7198422988068263`}}], 
    ArrowBox[{{-1., 2.892857142857143}, {-0.9779568460206436, 
     2.8979840828011296`}}], 
    ArrowBox[{{-1., 3.071428571428571}, {-0.9779568460206436, 
     3.0761853147697087`}}], 
    ArrowBox[{{-1., 3.25}, {-0.9779568460206436, 3.254434717368628}}], 
    ArrowBox[{{-1., 3.4285714285714284`}, {-0.9779568460206436, 
     3.4327236546248314`}}], 
    ArrowBox[{{-1., 3.6071428571428568`}, {-0.9779568460206436, 
     3.611045409450152}}], 
    ArrowBox[{{-1., 3.7857142857142856`}, {-0.9779568460206436, 
     3.789394684153701}}], 
    ArrowBox[{{-1., 3.964285714285714}, {-0.9779568460206436, 
     3.9677672480608805`}}], 
    ArrowBox[{{-1., 4.142857142857142}, {-0.9779568460206436, 
     4.1461596843570225`}}], 
    ArrowBox[{{-1., 4.321428571428571}, {-0.9779568460206436, 
     4.324569205210481}}], 
    ArrowBox[{{-1., 4.5}, {-0.9779568460206436, 4.502993514737938}}], 
    ArrowBox[{{-0.8642857142857143, 2.}, {-0.8422425603063579, 
     2.0066242573360378`}}], 
    ArrowBox[{{-0.8642857142857143, 
     2.1785714285714284`}, {-0.8422425603063579, 2.184486558655243}}], 
    ArrowBox[{{-0.8642857142857143, 2.357142857142857}, {-0.8422425603063579, 
     2.3624795713480764`}}], 
    ArrowBox[{{-0.8642857142857143, 
     2.5357142857142856`}, {-0.8422425603063579, 2.5405711107716145`}}], 
    ArrowBox[{{-0.8642857142857143, 
     2.7142857142857144`}, {-0.8422425603063579, 2.718738585329699}}], 
    ArrowBox[{{-0.8642857142857143, 2.892857142857143}, {-0.8422425603063579, 
     2.8969657103294972`}}], 
    ArrowBox[{{-0.8642857142857143, 3.071428571428571}, {-0.8422425603063579, 
     3.07524047505515}}], 
    ArrowBox[{{-0.8642857142857143, 3.25}, {-0.8422425603063579, 
     3.2535538422000045`}}], 
    ArrowBox[{{-0.8642857142857143, 
     3.4285714285714284`}, {-0.8422425603063579, 3.431898891168466}}], 
    ArrowBox[{{-0.8642857142857143, 
     3.6071428571428568`}, {-0.8422425603063579, 3.6102702390985826`}}], 
    ArrowBox[{{-0.8642857142857143, 
     3.7857142857142856`}, {-0.8422425603063579, 3.7886636405884775`}}], 
    ArrowBox[{{-0.8642857142857143, 3.964285714285714}, {-0.8422425603063579, 
     3.967075705309371}}], 
    ArrowBox[{{-0.8642857142857143, 4.142857142857142}, {-0.8422425603063579, 
     4.145503695134085}}], 
    ArrowBox[{{-0.8642857142857143, 4.321428571428571}, {-0.8422425603063579, 
     4.323945375982536}}], 
    ArrowBox[{{-0.8642857142857143, 4.5}, {-0.8422425603063579, 
     4.502398908006466}}], 
    ArrowBox[{{-0.7285714285714286, 2.}, {-0.7065282745920722, 
     2.005076822033675}}], 
    ArrowBox[{{-0.7285714285714286, 
     2.1785714285714284`}, {-0.7065282745920722, 2.1831047764198273`}}], 
    ArrowBox[{{-0.7285714285714286, 2.357142857142857}, {-0.7065282745920722, 
     2.3612329078293075`}}], 
    ArrowBox[{{-0.7285714285714286, 
     2.5357142857142856`}, {-0.7065282745920722, 2.539436549994481}}], 
    ArrowBox[{{-0.7285714285714286, 
     2.7142857142857144`}, {-0.7065282745920722, 2.717698388746024}}], 
    ArrowBox[{{-0.7285714285714286, 2.892857142857143}, {-0.7065282745920722, 
     2.8960059435169563`}}], 
    ArrowBox[{{-0.7285714285714286, 3.071428571428571}, {-0.7065282745920722, 
     3.074350009310578}}], 
    ArrowBox[{{-0.7285714285714286, 3.25}, {-0.7065282745920722, 
     3.2527236599470606`}}], 
    ArrowBox[{{-0.7285714285714286, 
     3.4285714285714284`}, {-0.7065282745920722, 3.431121591491122}}], 
    ArrowBox[{{-0.7285714285714286, 
     3.6071428571428568`}, {-0.7065282745920722, 3.6095396785245035`}}], 
    ArrowBox[{{-0.7285714285714286, 
     3.7857142857142856`}, {-0.7065282745920722, 3.7879746673768406`}}], 
    ArrowBox[{{-0.7285714285714286, 3.964285714285714}, {-0.7065282745920722, 
     3.9664239597046533`}}], 
    ArrowBox[{{-0.7285714285714286, 4.142857142857142}, {-0.7065282745920722, 
     4.144885457010906}}], 
    ArrowBox[{{-0.7285714285714286, 4.321428571428571}, {-0.7065282745920722, 
     4.3233574470995855`}}], 
    ArrowBox[{{-0.7285714285714286, 4.5}, {-0.7065282745920722, 
     4.50183851991343}}], 
    ArrowBox[{{-0.5928571428571429, 2.}, {-0.5708139888777864, 
     2.0036480290141845`}}], 
    ArrowBox[{{-0.5928571428571429, 
     2.1785714285714284`}, {-0.5708139888777864, 2.1818289358018674`}}], 
    ArrowBox[{{-0.5928571428571429, 2.357142857142857}, {-0.5708139888777864, 
     2.36008182633947}}], 
    ArrowBox[{{-0.5928571428571429, 
     2.5357142857142856`}, {-0.5708139888777864, 2.538388976298778}}], 
    ArrowBox[{{-0.5928571428571429, 
     2.7142857142857144`}, {-0.5708139888777864, 2.7167379443155633`}}], 
    ArrowBox[{{-0.5928571428571429, 2.892857142857143}, {-0.5708139888777864, 
     2.8951197622853377`}}], 
    ArrowBox[{{-0.5928571428571429, 3.071428571428571}, {-0.5708139888777864, 
     3.0735278158153165`}}], 
    ArrowBox[{{-0.5928571428571429, 3.25}, {-0.5708139888777864, 
     3.251957127991831}}], 
    ArrowBox[{{-0.5928571428571429, 
     3.4285714285714284`}, {-0.5708139888777864, 3.4304038875901277`}}], 
    ArrowBox[{{-0.5928571428571429, 
     3.6071428571428568`}, {-0.5708139888777864, 3.6088651302270947`}}], 
    ArrowBox[{{-0.5928571428571429, 
     3.7857142857142856`}, {-0.5708139888777864, 3.7873385179275547`}}], 
    ArrowBox[{{-0.5928571428571429, 3.964285714285714}, {-0.5708139888777864, 
     3.9658221836116025`}}], 
    ArrowBox[{{-0.5928571428571429, 4.142857142857142}, {-0.5708139888777864, 
     4.144314619371728}}], 
    ArrowBox[{{-0.5928571428571429, 4.321428571428571}, {-0.5708139888777864, 
     4.322814594882996}}], 
    ArrowBox[{{-0.5928571428571429, 4.5}, {-0.5708139888777864, 
     4.501321096926947}}], 
    ArrowBox[{{-0.4571428571428572, 2.}, {-0.4350997031635008, 
     2.0023710283271914`}}], 
    ArrowBox[{{-0.4571428571428572, 
     2.1785714285714284`}, {-0.4350997031635008, 2.180688638135653}}], 
    ArrowBox[{{-0.4571428571428572, 2.357142857142857}, {-0.4350997031635008, 
     2.359053033621941}}], 
    ArrowBox[{{-0.4571428571428572, 
     2.5357142857142856`}, {-0.4350997031635008, 2.5374526948984353`}}], 
    ArrowBox[{{-0.4571428571428572, 
     2.7142857142857144`}, {-0.4350997031635008, 2.7158795357281846`}}], 
    ArrowBox[{{-0.4571428571428572, 2.892857142857143}, {-0.4350997031635008, 
     2.8943277273116643`}}], 
    ArrowBox[{{-0.4571428571428572, 3.071428571428571}, {-0.4350997031635008, 
     3.0727929706390262`}}], 
    ArrowBox[{{-0.4571428571428572, 3.25}, {-0.4350997031635008, 
     3.2512720309763234`}}], 
    ArrowBox[{{-0.4571428571428572, 
     3.4285714285714284`}, {-0.4350997031635008, 3.4297624312265222`}}], 
    ArrowBox[{{-0.4571428571428572, 
     3.6071428571428568`}, {-0.4350997031635008, 3.6082622446954256`}}], 
    ArrowBox[{{-0.4571428571428572, 
     3.7857142857142856`}, {-0.4350997031635008, 3.7867699518212774`}}], 
    ArrowBox[{{-0.4571428571428572, 3.964285714285714}, {-0.4350997031635008, 
     3.9652843390996555`}}], 
    ArrowBox[{{-0.4571428571428572, 4.142857142857142}, {-0.4350997031635008, 
     4.1438044264694325`}}], 
    ArrowBox[{{-0.4571428571428572, 4.321428571428571}, {-0.4350997031635008, 
     4.322329414283662}}], 
    ArrowBox[{{-0.4571428571428572, 4.5}, {-0.4350997031635008, 
     4.500858644003262}}], 
    ArrowBox[{{-0.3214285714285715, 2.}, {-0.2993854174492151, 
     2.001292588421087}}], 
    ArrowBox[{{-0.3214285714285715, 
     2.1785714285714284`}, {-0.2993854174492151, 2.1797256453036145`}}], 
    ArrowBox[{{-0.3214285714285715, 2.357142857142857}, {-0.2993854174492151, 
     2.3581842078390007`}}], 
    ArrowBox[{{-0.3214285714285715, 
     2.5357142857142856`}, {-0.2993854174492151, 2.5366619958520236`}}], 
    ArrowBox[{{-0.3214285714285715, 
     2.7142857142857144`}, {-0.2993854174492151, 2.7151546010544596`}}], 
    ArrowBox[{{-0.3214285714285715, 2.892857142857143}, {-0.2993854174492151, 
     2.893658845821357}}], 
    ArrowBox[{{-0.3214285714285715, 3.071428571428571}, {-0.2993854174492151, 
     3.0721723865070114`}}], 
    ArrowBox[{{-0.3214285714285715, 3.25}, {-0.2993854174492151, 
     3.250693459665751}}], 
    ArrowBox[{{-0.3214285714285715, 
     3.4285714285714284`}, {-0.2993854174492151, 3.4292207148847984`}}], 
    ArrowBox[{{-0.3214285714285715, 
     3.6071428571428568`}, {-0.2993854174492151, 3.6077531018086693`}}], 
    ArrowBox[{{-0.3214285714285715, 
     3.7857142857142856`}, {-0.2993854174492151, 3.7862897920339624`}}], 
    ArrowBox[{{-0.3214285714285715, 3.964285714285714}, {-0.2993854174492151, 
     3.9648301240073134`}}], 
    ArrowBox[{{-0.3214285714285715, 4.142857142857142}, {-0.2993854174492151, 
     4.1433735634391695`}}], 
    ArrowBox[{{-0.3214285714285715, 4.321428571428571}, {-0.2993854174492151, 
     4.321919674394469}}], 
    ArrowBox[{{-0.3214285714285715, 4.5}, {-0.2993854174492151, 
     4.5004680978644265`}}], 
    ArrowBox[{{-0.18571428571428578`, 2.}, {-0.16367113173492936`, 
     2.0004808898049715`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     2.1785714285714284`}, {-0.16367113173492936`, 2.1790008390861604`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     2.357142857142857}, {-0.16367113173492936`, 2.357530277395898}}], 
    ArrowBox[{{-0.18571428571428578`, 
     2.5357142857142856`}, {-0.16367113173492936`, 2.5360668682810728`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     2.7142857142857144`}, {-0.16367113173492936`, 2.7146089716984743`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     2.892857142857143}, {-0.16367113173492936`, 2.893155405456294}}], 
    ArrowBox[{{-0.18571428571428578`, 
     3.071428571428571}, {-0.16367113173492936`, 3.0717052976332706`}}], 
    ArrowBox[{{-0.18571428571428578`, 3.25}, {-0.16367113173492936`, 
     3.250257992163614}}], 
    ArrowBox[{{-0.18571428571428578`, 
     3.4285714285714284`}, {-0.16367113173492936`, 3.428812986644759}}], 
    ArrowBox[{{-0.18571428571428578`, 
     3.6071428571428568`}, {-0.16367113173492936`, 3.607369890306345}}], 
    ArrowBox[{{-0.18571428571428578`, 
     3.7857142857142856`}, {-0.16367113173492936`, 3.7859283949522413`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     3.964285714285714}, {-0.16367113173492936`, 3.964488254460586}}], 
    ArrowBox[{{-0.18571428571428578`, 
     4.142857142857142}, {-0.16367113173492936`, 4.143049270056275}}], 
    ArrowBox[{{-0.18571428571428578`, 
     4.321428571428571}, {-0.16367113173492936`, 4.3216112795556425`}}], 
    ArrowBox[{{-0.18571428571428578`, 4.5}, {-0.16367113173492936`, 
     4.500174149394393}}], 
    ArrowBox[{{-0.05000000000000007, 2.}, {-0.027956846020643654`, 
     2.000039362774963}}], 
    ArrowBox[{{-0.05000000000000007, 
     2.1785714285714284`}, {-0.027956846020643654`, 2.1786065775583343`}}], 
    ArrowBox[{{-0.05000000000000007, 
     2.357142857142857}, {-0.027956846020643654`, 2.3571745690570607`}}], 
    ArrowBox[{{-0.05000000000000007, 
     2.5357142857142856`}, {-0.027956846020643654`, 2.5357431460230067`}}], 
    ArrowBox[{{-0.05000000000000007, 
     2.7142857142857144`}, {-0.027956846020643654`, 2.7143121742120053`}}], 
    ArrowBox[{{-0.05000000000000007, 
     2.892857142857143}, {-0.027956846020643654`, 2.892881556856876}}], 
    ArrowBox[{{-0.05000000000000007, 
     3.071428571428571}, {-0.027956846020643654`, 3.0714512225873385`}}], 
    ArrowBox[{{-0.05000000000000007, 3.25}, {-0.027956846020643654`, 
     3.2500211177017553`}}], 
    ArrowBox[{{-0.05000000000000007, 
     3.4285714285714284`}, {-0.027956846020643654`, 3.4285912010764448`}}], 
    ArrowBox[{{-0.05000000000000007, 
     3.6071428571428568`}, {-0.027956846020643654`, 3.6071614407252723`}}], 
    ArrowBox[{{-0.05000000000000007, 
     3.7857142857142856`}, {-0.027956846020643654`, 3.78573181142114}}], 
    ArrowBox[{{-0.05000000000000007, 
     3.964285714285714}, {-0.027956846020643654`, 3.9643022930179765`}}], 
    ArrowBox[{{-0.05000000000000007, 
     4.142857142857142}, {-0.027956846020643654`, 4.142872869245237}}], 
    ArrowBox[{{-0.05000000000000007, 
     4.321428571428571}, {-0.027956846020643654`, 4.321443526827533}}], 
    ArrowBox[{{-0.05000000000000007, 4.5}, {-0.027956846020643654`, 
     4.500014254832085}}], 
    ArrowBox[{{0.08571428571428563, 2.}, {0.10775743969364204`, 
     2.0001328493655004`}}], 
    ArrowBox[{{0.08571428571428563, 2.1785714285714284`}, {
     0.10775743969364204`, 2.1786900564022362`}}], 
    ArrowBox[{{0.08571428571428563, 2.357142857142857}, {0.10775743969364204`,
      2.357249884853294}}], 
    ArrowBox[{{0.08571428571428563, 2.5357142857142856`}, {
     0.10775743969364204`, 2.53581168925622}}], 
    ArrowBox[{{0.08571428571428563, 2.7142857142857144`}, {
     0.10775743969364204`, 2.7143750165369465`}}], 
    ArrowBox[{{0.08571428571428563, 2.892857142857143}, {0.10775743969364204`,
      2.8929395401062425`}}], 
    ArrowBox[{{0.08571428571428563, 3.071428571428571}, {0.10775743969364204`,
      3.071505019089411}}], 
    ArrowBox[{{0.08571428571428563, 3.25}, {0.10775743969364204`, 
     3.2500712722434244`}}], 
    ArrowBox[{{0.08571428571428563, 3.4285714285714284`}, {
     0.10775743969364204`, 3.4286381607758583`}}], 
    ArrowBox[{{0.08571428571428563, 3.6071428571428568`}, {
     0.10775743969364204`, 3.60720557673351}}], 
    ArrowBox[{{0.08571428571428563, 3.7857142857142856`}, {
     0.10775743969364204`, 3.785773434974919}}], 
    ArrowBox[{{0.08571428571428563, 3.964285714285714}, {0.10775743969364204`,
      3.9643416675071004`}}], 
    ArrowBox[{{0.08571428571428563, 4.142857142857142}, {0.10775743969364204`,
      4.142910219416962}}], 
    ArrowBox[{{0.08571428571428563, 4.321428571428571}, {0.10775743969364204`,
      4.321479045900066}}], 
    ArrowBox[{{0.08571428571428563, 4.5}, {0.10775743969364204`, 
     4.500048110058288}}], 
    ArrowBox[{{0.22142857142857134`, 2.}, {0.24347172540792775`, 
     2.0010411273414563`}}], 
    ArrowBox[{{0.22142857142857134`, 2.1785714285714284`}, {
     0.24347172540792775`, 2.1795011031517055`}}], 
    ArrowBox[{{0.22142857142857134`, 2.357142857142857}, {
     0.24347172540792775`, 2.357981622726791}}], 
    ArrowBox[{{0.22142857142857134`, 2.5357142857142856`}, {
     0.24347172540792775`, 2.5364776276412884`}}], 
    ArrowBox[{{0.22142857142857134`, 2.7142857142857144`}, {
     0.24347172540792775`, 2.714985567198531}}], 
    ArrowBox[{{0.22142857142857134`, 2.892857142857143}, {
     0.24347172540792775`, 2.8935028819510054`}}], 
    ArrowBox[{{0.22142857142857134`, 3.071428571428571}, {
     0.24347172540792775`, 3.072027684187527}}], 
    ArrowBox[{{0.22142857142857134`, 3.25}, {0.24347172540792775`, 
     3.2505585535244106`}}], 
    ArrowBox[{{0.22142857142857134`, 3.4285714285714284`}, {
     0.24347172540792775`, 3.4290944022591505`}}], 
    ArrowBox[{{0.22142857142857134`, 3.6071428571428568`}, {
     0.24347172540792775`, 3.607634384373173}}], 
    ArrowBox[{{0.22142857142857134`, 3.7857142857142856`}, {
     0.24347172540792775`, 3.7861778326212683`}}], 
    ArrowBox[{{0.22142857142857134`, 3.964285714285714}, {
     0.24347172540792775`, 3.9647242141491392`}}], 
    ArrowBox[{{0.22142857142857134`, 4.142857142857142}, {
     0.24347172540792775`, 4.143273098608307}}], 
    ArrowBox[{{0.22142857142857134`, 4.321428571428571}, {
     0.24347172540792775`, 4.321824134870828}}], 
    ArrowBox[{{0.22142857142857134`, 4.5}, {0.24347172540792775`, 
     4.5003770337697455`}}], 
    ArrowBox[{{0.35714285714285704`, 2.}, {0.37918601112221345`, 
     2.003280231246928}}], 
    ArrowBox[{{0.35714285714285704`, 2.1785714285714284`}, {
     0.37918601112221345`, 2.1815005108136014`}}], 
    ArrowBox[{{0.35714285714285704`, 2.357142857142857}, {
     0.37918601112221345`, 2.359785516659819}}], 
    ArrowBox[{{0.35714285714285704`, 2.5357142857142856`}, {
     0.37918601112221345`, 2.538119311441055}}], 
    ArrowBox[{{0.35714285714285704`, 2.7142857142857144`}, {
     0.37918601112221345`, 2.7164907081432985`}}], 
    ArrowBox[{{0.35714285714285704`, 2.892857142857143}, {
     0.37918601112221345`, 2.8948916428349154`}}], 
    ArrowBox[{{0.35714285714285704`, 3.071428571428571}, {
     0.37918601112221345`, 3.0733161679925147`}}], 
    ArrowBox[{{0.35714285714285704`, 3.25}, {0.37918601112221345`, 
     3.251759808479614}}], 
    ArrowBox[{{0.35714285714285704`, 3.4285714285714284`}, {
     0.37918601112221345`, 3.4302191373227786`}}], 
    ArrowBox[{{0.35714285714285704`, 3.6071428571428568`}, {
     0.37918601112221345`, 3.608691489010831}}], 
    ArrowBox[{{0.35714285714285704`, 3.7857142857142856`}, {
     0.37918601112221345`, 3.787174761285482}}], 
    ArrowBox[{{0.35714285714285704`, 3.964285714285714}, {
     0.37918601112221345`, 3.9656672753076054`}}], 
    ArrowBox[{{0.35714285714285704`, 4.142857142857142}, {
     0.37918601112221345`, 4.144167675198364}}], 
    ArrowBox[{{0.35714285714285704`, 4.321428571428571}, {
     0.37918601112221345`, 4.322674854675361}}], 
    ArrowBox[{{0.35714285714285704`, 4.5}, {0.37918601112221345`, 
     4.501187902673784}}], 
    ArrowBox[{{0.49285714285714277`, 2.}, {0.5149002968364992, 
     2.0079185706309643`}}], 
    ArrowBox[{{0.49285714285714277`, 2.1785714285714284`}, {
     0.5149002968364992, 2.1856423156133933`}}], 
    ArrowBox[{{0.49285714285714277`, 2.357142857142857}, {0.5149002968364992, 
     2.3635223116579165`}}], 
    ArrowBox[{{0.49285714285714277`, 2.5357142857142856`}, {
     0.5149002968364992, 2.541520085565911}}], 
    ArrowBox[{{0.49285714285714277`, 2.7142857142857144`}, {
     0.5149002968364992, 2.7196086315704253`}}], 
    ArrowBox[{{0.49285714285714277`, 2.892857142857143}, {0.5149002968364992, 
     2.897768483113344}}], 
    ArrowBox[{{0.49285714285714277`, 3.071428571428571}, {0.5149002968364992, 
     3.075985282705665}}], 
    ArrowBox[{{0.49285714285714277`, 3.25}, {0.5149002968364992, 
     3.2542482272418587`}}], 
    ArrowBox[{{0.49285714285714277`, 3.4285714285714284`}, {
     0.5149002968364992, 3.432549043911519}}], 
    ArrowBox[{{0.49285714285714277`, 3.6071428571428568`}, {
     0.5149002968364992, 3.6108812980955793`}}], 
    ArrowBox[{{0.49285714285714277`, 3.7857142857142856`}, {
     0.5149002968364992, 3.789239914883311}}], 
    ArrowBox[{{0.49285714285714277`, 3.964285714285714}, {0.5149002968364992, 
     3.967620841509772}}], 
    ArrowBox[{{0.49285714285714277`, 4.142857142857142}, {0.5149002968364992, 
     4.146020804845256}}], 
    ArrowBox[{{0.49285714285714277`, 4.321428571428571}, {0.5149002968364992, 
     4.324437134292891}}], 
    ArrowBox[{{0.49285714285714277`, 4.5}, {0.5149002968364992, 
     4.502867630516564}}], 
    ArrowBox[{{0.6285714285714284, 2.}, {0.6506145825507849, 
     2.017586076691223}}], 
    ArrowBox[{{0.6285714285714284, 2.1785714285714284`}, {0.6506145825507849, 
     2.1942749144137745`}}], 
    ArrowBox[{{0.6285714285714284, 2.357142857142857}, {0.6506145825507849, 
     2.371310764657794}}], 
    ArrowBox[{{0.6285714285714284, 2.5357142857142856`}, {0.6506145825507849, 
     2.5486081836414347`}}], 
    ArrowBox[{{0.6285714285714284, 2.7142857142857144`}, {0.6506145825507849, 
     2.7261071952009592`}}], 
    ArrowBox[{{0.6285714285714284, 2.892857142857143}, {0.6506145825507849, 
     2.9037645667379763`}}], 
    ArrowBox[{{0.6285714285714284, 3.071428571428571}, {0.6506145825507849, 
     3.081548412207079}}], 
    ArrowBox[{{0.6285714285714284, 3.25}, {0.6506145825507849, 
     3.259434739368861}}], 
    ArrowBox[{{0.6285714285714284, 3.4285714285714284`}, {0.6506145825507849, 
     3.437405175427899}}], 
    ArrowBox[{{0.6285714285714284, 3.6071428571428568`}, {0.6506145825507849, 
     3.6154454299636516`}}], 
    ArrowBox[{{0.6285714285714284, 3.7857142857142856`}, {0.6506145825507849, 
     3.7935442322842947`}}], 
    ArrowBox[{{0.6285714285714284, 3.964285714285714}, {0.6506145825507849, 
     3.971692581745849}}], 
    ArrowBox[{{0.6285714285714284, 4.142857142857142}, {0.6506145825507849, 
     4.149883209168975}}], 
    ArrowBox[{{0.6285714285714284, 4.321428571428571}, {0.6506145825507849, 
     4.328110183518436}}], 
    ArrowBox[{{0.6285714285714284, 4.5}, {0.6506145825507849, 
     4.506368620365546}}], 
    ArrowBox[{{0.7642857142857141, 2.}, {0.7863288682650705, 
     2.04096949186845}}], 
    ArrowBox[{{0.7642857142857141, 2.1785714285714284`}, {0.7863288682650705, 
     2.215155133215763}}], 
    ArrowBox[{{0.7642857142857141, 2.357142857142857}, {0.7863288682650705, 
     2.390149194026163}}], 
    ArrowBox[{{0.7642857142857141, 2.5357142857142856`}, {0.7863288682650705, 
     2.565752619764234}}], 
    ArrowBox[{{0.7642857142857141, 2.7142857142857144`}, {0.7863288682650705, 
     2.741825686658966}}], 
    ArrowBox[{{0.7642857142857141, 2.892857142857143}, {0.7863288682650705, 
     2.9182676776704355`}}], 
    ArrowBox[{{0.7642857142857141, 3.071428571428571}, {0.7863288682650705, 
     3.0950043093128494`}}], 
    ArrowBox[{{0.7642857142857141, 3.25}, {0.7863288682650705, 
     3.271979687945204}}], 
    ArrowBox[{{0.7642857142857141, 3.4285714285714284`}, {0.7863288682650705, 
     3.4491510112923858`}}], 
    ArrowBox[{{0.7642857142857141, 3.6071428571428568`}, {0.7863288682650705, 
     3.6264849876044245`}}], 
    ArrowBox[{{0.7642857142857141, 3.7857142857142856`}, {0.7863288682650705, 
     3.8039553600575187`}}], 
    ArrowBox[{{0.7642857142857141, 3.964285714285714}, {0.7863288682650705, 
     3.9815411602562256`}}], 
    ArrowBox[{{0.7642857142857141, 4.142857142857142}, {0.7863288682650705, 
     4.159225453520399}}], 
    ArrowBox[{{0.7642857142857141, 4.321428571428571}, {0.7863288682650705, 
     4.336994422584018}}], 
    ArrowBox[{{0.7642857142857141, 4.5}, {0.7863288682650705, 
     4.514836688413266}}], 
    ArrowBox[{{0.8999999999999999, 2.}, {0.9220431539793563, 
     2.13391216042459}}], 
    ArrowBox[{{0.8999999999999999, 2.1785714285714284`}, {0.9220431539793563, 
     2.2981482820259043`}}], 
    ArrowBox[{{0.8999999999999999, 2.357142857142857}, {0.9220431539793563, 
     2.4650267892633106`}}], 
    ArrowBox[{{0.8999999999999999, 2.5357142857142856`}, {0.9220431539793563, 
     2.6338970559839314`}}], 
    ArrowBox[{{0.8999999999999999, 2.7142857142857144`}, {0.9220431539793563, 
     2.804302383527729}}], 
    ArrowBox[{{0.8999999999999999, 2.892857142857143}, {0.9220431539793563, 
     2.97591356994973}}], 
    ArrowBox[{{0.8999999999999999, 3.071428571428571}, {0.9220431539793563, 
     3.1484878135549983`}}], 
    ArrowBox[{{0.8999999999999999, 3.25}, {0.9220431539793563, 
     3.3218424213717723`}}], 
    ArrowBox[{{0.8999999999999999, 3.4285714285714284`}, {0.9220431539793563, 
     3.495837490636558}}], 
    ArrowBox[{{0.8999999999999999, 3.6071428571428568`}, {0.9220431539793563, 
     3.670364204521038}}], 
    ArrowBox[{{0.8999999999999999, 3.7857142857142856`}, {0.9220431539793563, 
     3.845336740432817}}], 
    ArrowBox[{{0.8999999999999999, 3.964285714285714}, {0.9220431539793563, 
     4.020686561443413}}], 
    ArrowBox[{{0.8999999999999999, 4.142857142857142}, {0.9220431539793563, 
     4.196358315155195}}], 
    ArrowBox[{{0.8999999999999999, 4.321428571428571}, {0.9220431539793563, 
     4.372306838695506}}], 
    ArrowBox[{{0.8999999999999999, 4.5}, {0.9220431539793563, 
     4.548494938754584}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{0, 2.},
  Frame->True,
  FrameTicks->{{{-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, Automatic, None, None},
  PlotRange->{{-1, 0.9}, {1.847412899817926, 4.298371333097527}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "F\[UDoubleDot]r Anfangswerte in der N\[ADoubleDot]he von c=0 hat ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " Probleme, weil die L\[ODoubleDot]sung nicht \[UDoubleDot]ber das ganze \
Gebiet ausgedehnt werden kann. Das ist mit Blick auf das Vektorfeld auch \
nicht weiter verwunderlich. \[CapitalUDoubleDot]ber die Stelle ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]]],
 " mit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "[", 
     SubscriptBox["x", "0"], "]"}], "=", "0"}], TraditionalForm]]],
 " l\[ADoubleDot]sst sich die L\[ODoubleDot]sung nicht sinnvoll fortsetzen. "
}], "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
  3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
  3.36644048070057*^9}, {3.36644051650422*^9, 3.36644053374247*^9}, {
  3.36644056386189*^9, 3.36644057173263*^9}, {3.36644083307155*^9, 
  3.36644083454827*^9}, {3.36644110242705*^9, 3.3664411326857*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsol2", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", ".3"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "0.06", ",", "0.2", ",", ".02"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
   3.36638316883576*^9, 3.36638318466153*^9}, {3.36638321570362*^9, 
   3.36638324157278*^9}, {3.36638370424821*^9, 3.36638371299074*^9}, {
   3.36644089788181*^9, 3.36644090262552*^9}, {3.36644096721381*^9, 
   3.36644096769171*^9}, {3.36697011352743*^9, 3.36697011749794*^9}, {
   3.382703223978722*^9, 3.382703224410737*^9}, 3.38270325914223*^9, {
   3.382703290698958*^9, 3.382703291391382*^9}, {3.382703332099888*^9, 
   3.382703369387557*^9}, {3.382703796592814*^9, 3.382703833993711*^9}, {
   3.382703938769323*^9, 3.382703973555786*^9}, {3.38270400545492*^9, 
   3.382704128534603*^9}, {3.382704194065054*^9, 3.382704194802331*^9}, {
   3.382704229308504*^9, 3.382704229517201*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"At \\!\\(x\\) == \\!\\(-0.05999971170460646`\\), step size \
is effectively zero; singularity or stiff system suspected.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"At \\!\\(x\\) == \\!\\(-0.07999971404210329`\\), step size \
is effectively zero; singularity or stiff system suspected.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"At \\!\\(x\\) == \\!\\(-0.0999996950381377`\\), step size \
is effectively zero; singularity or stiff system suspected.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Further output of \\!\\(NDSolve :: \\\"ndsz\\\"\\) will be \
suppressed during this calculation.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.05999971170460646`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.07999971404210329`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.0999996950381377`"}], ",", "0.9`"}], "}"}], "}"}],
          ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.1199997038030147`"}], ",", "0.9`"}], "}"}], "}"}],
          ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.13999970428353864`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.15999968989872934`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.17999979957212459`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.19999979427091827`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", ".3"}], ",", ".9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2.2"}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638335890342*^9}, {3.36638375346106*^9, 3.36638379395125*^9}, {
   3.36638385324782*^9, 3.36638385347759*^9}, {3.36644090810339*^9, 
   3.36644091826707*^9}, {3.36644097910378*^9, 3.36644105544716*^9}, 
   3.36697005863252*^9, {3.36697036330738*^9, 3.36697036388311*^9}, {
   3.3669704074967*^9, 3.36697042459722*^9}, {3.36697046480268*^9, 
   3.3669704749194*^9}, {3.382703099582849*^9, 3.382703106892808*^9}, {
   3.382703275711332*^9, 3.382703278065186*^9}, {3.38270337362608*^9, 
   3.382703374062924*^9}, {3.382704059572828*^9, 3.382704059963282*^9}, {
   3.382704238765118*^9, 3.38270423910463*^9}, {3.389325299167943*^9, 
   3.389325303804643*^9}, {3.389325977445431*^9, 3.389325999544453*^9}, 
   3.389332000448498*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Input value \\!\\({\\(-0.29997548571428573`\\)}\\) lies \
outside the range of data in the interpolating function. Extrapolation will \
be used.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Input value \\!\\({\\(-0.29997548571428573`\\)}\\) lies \
outside the range of data in the interpolating function. Extrapolation will \
be used.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Input value \\!\\({\\(-0.29997548571428573`\\)}\\) lies \
outside the range of data in the interpolating function. Extrapolation will \
be used.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Further output of \\!\\(InterpolatingFunction :: \\\"dmval\
\\\"\\) will be suppressed during this calculation.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw11mk41N37AHBbWYsQkVCpJKUiy4PuQmRJWSpkK0lkl6UFUWTJToTs6yzf
mRGRcEgyhiR7HoSQMj2NZC/+39+L/6tzfa77nBfnXs51dl/zMnfmYGNj28TO
xva/VS1oxCj1CYaaZTQ+RWosov/3PSF9xuBgPOgsNPG5W2Foq7aYYwdXKpj6
ljB05TCEjijr/ZZMB5ufMTE7WWQUyGNXWxH+DG64exnNvyYjJysDekd4Fvh+
s+Brf0xGV/Vf76drPYeQG+qMAgsySujqqgxrzoGYL1Ixd2XIKC2cu8FpWx48
dWQ3Mp8loQ2Zuz/1aHlQMDLFq1BNQivyrf0qevmA2TDa2B+SUHb7FTGDjnxo
sUwxpEmSEMWEbv6hqQAkm/Zps30nooAPMr36CoXgfbjm6PlXRKT2NsbxVFwh
SG0eEf9xmYje3h1v7dcrAl9fL36tA0R0j8AWdz6zCFpH2TdiFglo9YhEBx8T
j1fvn5ZPI6DPotKSXhHFQN/76lPgdQJqWZs4kPa+GKQTjd+/Uyagqks+uqvC
JdB207vyenc5utGk76P6tARkJWvD8wTL0UnRiHj/8FIIiDQJ+Dlahvhe3uir
rymFjl+jriexMqQh/yjB9EcpBLZzmg2blCFGtEV1tlkZdN4/J7MjphRZ/m64
MsZTDnLfPgu7WJeir4QzVR7K5XD3ou/ml/KlaO5YYFurbTnsO5L+w6K1BC3Y
3AgVJJXD/c9jrxO4SpAB+U/blpME6Db2o4z2FKMtPBcV5RwJIF+zqfBwYTE6
VG7RaBFGgJ5EhZj208WIX1FER6qJAAo6t624Q4sQZvJ2mluNCA+wzSaXTItQ
NU/79wJzIvRJPoPiXUWI9XR3Q5QHHp+v369bV4gcGkfLz+YTYaCIeyFkpQBR
Lmj1iLGTQHFb5sx7egGKIAeIRImTIDxYcVgqowAtWp66deMwCY5cMmuuVS1A
m6ty54Muk+ARd1bSol8+upB5mXS+mARDfocjzujmo1xJ8nJkNQmOjqGgVOF8
1LLrZaReGwn+rZl0OE7LQ5uMLxnZzZLgeq+t7fBwLup0EP9orEAGmwdOFdeD
cxHHlHb2C3UyXFB04/mxKxdN/20WeKVPBu1HgZV/7XNQw4IzKrpKBjGVZAGZ
8WxEeO/eqpJCBoGxjGulYdnILlCAF+WQgeNJbo3Snmz0dp5Vs1BOhp9fSNdP
OWWh4yd86Z6IDPSU1rqrU89Q3OnAodppMjRAp/D3iGfop2GccO9PMlTO9t70
3f8M9Z8nDBcvkyFfd0L0oUsGujHE+SWIF4OMnzNu/DwZiM9Rqun+Ngzis342
ppSlo0Oe1sUnJTC4O//HvejbUxSj8HiYXR4D71zOZsWYp6g3kUrYpITBDWM+
iSqFp2he2y2n4wQG5oXiLS230lDbpYQt5ToYHLI4vuvrjxQ0eY9ZWmeNwZ4N
dT+v+BQkIMFzYc0egx1EaFs6koL8yISHm69jwMV5zp/HOxkt3siYj/TAYBWz
aE8USkaV54L91n0wYNnY7JagJSEugcsz+gEYjFS4vD/4KxHZMiQnTEMw6LX3
3FuRnIjsGgwihcIxYPD53/lHORHJFexyLo3AwL2Fy/jpTDwijoYPWD3BwGqX
8FLJwXhUaql+yz8BgzP+MoXVbnGI5WGveSsZA+l9/6wNMmOR80e+3Ol0DPiC
DUq/HY5F26NO6XhmYrDUa2mx6hmD1kozFXqyMZhUvLbBR41GbprdF8RyMeh6
5EXcOReFqCZ5ZPV8DOqG719WPB6FZKfrNTQLMShXieHU9nuM8pa7WdLFGIRP
Fl2xX4hAfVyro3FlGHhqVXB7qUagB9b9fyUJGFxJRS9CAx+hpaPMfXFEDM4y
OxwSax4iAX0doykSBip6Q/z5K+EoweKznRyGgWz212raP+HITJRhYUzBQOD3
b6c398KQnC6vzBUqBsvGHEI9dQ/QiCmtwpKG58tAJqh1LRQZKu7cpFGBwePv
rFZfuxCUWWX0UeIFBnpxb8Sl0X2kNyDA/IKb7WiqS5vsPSTipxqTUYlBfbdz
9e3wO6jHLXtMvQrvH381btnJQGSaJyL3DrfqDt7L7WcCkNmCd/TplxjM1w6V
BJTeRqXG0WdIuKl2pMXdvH6oIkwhjrsaAw+2EP33bj5oZtdwqiVuC/1cxbkM
L9T61CUpFXdHrE6Hga074k15W03Hrf9x6laOjCvS3y6u/Qs3EovmX5hwRlxK
lReFazBQt1UkGpdcQ92sPScUcDvp5qbp9dijiJqOI5q4L3VO9c5ZWyGZ/EMe
+rgNrRVFc8fMkIRIucg53EH0qZKMTn20MT9gewH367opo+lqZTSraFphhnvG
jm0suWoH0M8l/PifBxd8Ry7zngLlfBdPc9y/Pk/Z/10zgRzBRR9L3JudFb3N
liyBElNz1Bq3yNDU0SLvK5BQJ+LrhDux9EPQ2m9HYHkvL/vgFr+m+Kno2HU4
XiYkF4k7Rypaw9TTBVovi8/l45YbmHq2RHAD3ajAzHe4CUk6q3lfPaB5T6/N
Au4dJecP70v2BqKbhIfSKwxsOUNG7hz1hWlPN4EA3LmOpLjOTj+AZPHbDNwT
9UPaez38wWIb4fPhWgz27+T9L5A/EMJrsJh83K5Bajkd5UHwsSaBuv81BqQ+
Z9PdZ++Cnm71kwbcrOOp6/7T92AsKsHGrQ4D5cQ3GONRMBBqwy8eqscg4AfL
XmZvKBTxrtVwNGBgV5zAXev4APpLrjXO4V7vKXGYVAqDBJPtpSsIgzyOhuqt
G2Ggq2VduLMJA51jfYIaneEQMcjBtHqDz58D08Xp+UNYCKytrWjGIDKeszHO
/REc9ZE3VGjB4EC95I4azQjolVzoanyHgZukIV1gKBI6Pxm/OM/A58PQUVat
/DFczd4fZtSBATkwMOhqUBRslDsfce3EwLQkvivWIBoGf+ZNkLrw+/UWy78U
iwEDYas2sR4MkjnrH4xNxcBfhrtoWR8+j8d7B/mqYoHQ07hwdRCDwASOaAeL
OKj3+H7achSvR4PEePSeeIAm49X4cQxqmUc1KufiwTim7NviJAYbRZTbXGcT
gQspCFkwMbig9TrvGSURKo1fZxiy8Hz0vOs4Ip4Et09Krfr8xvPBMSpnPZ0E
Sk0iD2z/4udr475t6CfDRqzy3ffsFKjz08ZKSpPh16mhOI/NFFCdylb7fTMF
IuWeBp4UosD8c5M/mW0pcDBenOW9nQLUS38aTyukguKpzRN9khRQoF8xSphN
hedZ+579s58CXx/wC6qapMGbm7FzmooUKNJ43TNMSoNUE/KS73EKSBMl7RQ8
n0LG5xmIAAqIxH/yamGlw2Ts10/nbSnQpR+t4m6WAcJB51gi1ykQv6G+IlyR
ASsqe4ki7hTg8ckId/R7BrOt/bn0+xT4Y3E5bW0hE7Q7GBUS+RR4JcBtU3Ap
CyrfbLXvIFAgoOWltGF1FoSap0ShSgqwVMXKngZlw/fd4V6ubRSYlOirPbb2
HBwTnYc/LVAgv/tR6OCVHLBz5bf8wEYF+1gVvdC6HEgfi//Ss5kKg39S3ncE
5wJjbvKSnggVpr0OspQf5EEPZ9bz1sNU0DMJM39MzQM7RadHjSpUKJT/VDk0
lge3k/QWhzWp4DgedSfsdD7cKj299MCICkPmMxwfOAogpyZJJ8iVCupKp5z3
KBfAGe3PkYk+VEjnz2j1dyoAt8KWne/vUMHyrcETqbcFsHxyy6UXMVToPFG6
3S2iEEJHrb6oYFRo3nFDfhNPMcQGHhUS/EOFd2Ktxi5axVA+/dHDlJsGdFF5
rzbvYjj/ZM6oRpgGHULfq+I+FYP1rJUavwINenk8dcWIJUBivThFsKHB5LK/
/QHTMlBbSssnNtNgerE/LDq8DIJ3v88J/0iDmd9qxbMvy+BPh1Ja2GcaMFkr
sxSZcrC5qRG6uEaD3zPBd9TnyoGzOS+5SrUCuD5FpBqmEqFloIjD7EUFbB6Y
ribSiaBF+8wR01wBPH0G/275S4TtaWUT0z0VIPCRd0+3MwkSr2pI8C9UgGhb
HMVGjQy98pfNFtRfwL5XaYxbQ/g7r6iaLNj6Ago7zNkMhGiQYHrhtdFqJXT3
GwX8PUiDvwkfDIS2VgHbuA7zhS4NMLK698/dVWC7cHxQNpAGrlmyiSuGVSAm
LUJdHaHBVts/zBNZVRDl1eOAESuAqpq6TVznJXgKW6LtBpUw2nng4WBuNahb
XQyZDK6GpItx9/Yl1kLS6rPIrPv1sHLCxeX+2UYg32S3SltvAoXXKqP9jGbw
+9xPc+VuATk3p+gQrVbw9T4ppWBGh4Atx8rdpNtB0iVdMD22HQaN9XcNbfsA
cq7b6InxndCpcOudrPdHvK/jz2p+6wJvkvOIVlIPPL5UnHDbqxuufnC3cM/p
A6XnKju5/uuB9LI77MK0AZhnCVB44/pg7Oe5f5Q5h+Amw7/4otAA0Hdfk/sE
w7BCPVAkXjkIWnSHJ8FNo+BgZP5V6cIQmB7Jzl8vGYMA1y1x8V3/AvvhBWO+
iXEoT9um6eQzAvamsmzael8gzqDEOGRxFILevEt4lDUJe/utu5Y0xoA+7jvR
vjwFWwQ3hc7yjEOCs/vaqYdf4UPMsj0HYxzcr/jJ83N+A5k4IV3LrAngFIwQ
n676Dme7va3a7L+A/cyHDjsHJvzrvSXRVXoSypx17bJF/4M/aZ3tev9NwrzS
8YhVThYs/h1Q16VOQdC9Ly3HV1kQwtxEuB8+DSrETVl223+Bt4q39viFrzDF
NxrgeHIeNNEeDtdtMyDrOj13xOU3pHatMA5NzIALhrp83izAOzmJlm3F36Ap
/zGf0d4luNZ9e3zP9e8gSRali+Ysw5PNC+xeyrPQNqFGCXBZhfjgeovR37PQ
KdY2ddD4D8jcI5RHvWPCAU5W3HPyOqy7c9Tm406o32T3A/ewvQ2jFrfe4tph
bWwdMnT4Zpm4PfRj+oZxC/O5KZq1MsFR6pimFHUduJ4dpEjQmfDQr94xq2Id
vr8sqyS0MaHBP3R7VvU60MvYWppxJ5n1yc7iLs206hvGvYexFf+/rMP1EJ7F
rQwmaCwomv6Le+TMTTU/3NM/dhTvrF2Hrt4DtZrt+P6TLeTsunXA3oUyLHGn
pTsOMHE/qRkY8sC9KDXOoV2/DobZj9dycZsLJjuM4H7j9FWLq4MJKyYvlaTR
OuRdhHO7cAc0Bt/0xB1qkG6nijvkwKHCBtxahwxCbuL+T1ld2qFxHSR35caH
4T7Jn2FPwb28dSknE/cXjdG8Ddz9bOcpL3B3DfJNnW9ah6pfJagD9xqb9KE8
3P8Hgy1MIA==
      "]], LineBox[CompressedData["
1:eJw112k41N/7B3BJFFqoKGUJUaIkhVR3URRaRJJC9iUx2SVkX8qSpYjsM7Yy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      "]], LineBox[CompressedData["
1:eJw113c8ld8fAHBZURKljIRQJCGVkfRJKYWS0bKzSVF2ZUYoZI/sTdd2r3uf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      "]], LineBox[CompressedData["
1:eJw113c0V+8fAHCREkpDksiorCQhJHmHQkYRRXaSWYisMjIq2XtWZO/Nhw+f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      "]], LineBox[CompressedData["
1:eJw112c4lt8fAHAhhOyIjJYISVIU9f2VSkXDjAoVMsrIlsxkFcmWmcxkzx7j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      "]], LineBox[CompressedData["
1:eJw113dYjt8bAPC+FdJQSIgGkSQko6jctMmopEWDNlG8TWmqtLWHpKHe9t7z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      "]], LineBox[CompressedData["
1:eJw113k0VV8bB3BRRCrhl3moVJIiylR6MhRFZao0oEKhgcyUDJkzSyiZx2Se
r2Fz3XvuNSYkRKmEcs1SGd/dH+9fZ33WOmuds5999vd5zo6btgaWzExMTMHr
mJj+XTuNS1ii2WioUUy5z195Af3fI8NuztXXo6G3x+Nu7CKB+oIOJig/TYHP
RtrvX04QKLL08FOmRxkw0sl9PHmIQCJoSsXuSjYw9AYz07sIpKjtYPsz9zVQ
z0QP+NMIFHONo/Km3xtI1DzNbV1NoD+VjUHbJPPB5fialk4BgaYKAj4YpRSA
nlKZx4E0AkkYssksPiqEfXJ3SrbGEohsrDKyUbgImKV3/JgJJlDG1FrYtsIi
KBELNSq3J5BqpsZNm9piCBHQCI67RaAsUgY/l3IJWPD8Re5XCCQqkdUelF8C
29ks94M6gd4GhHjEBpWC++QxZvo2Al0SF2E+tbkcDMdmFV9vIFBowsLBEsty
kP6afS/kLxUlRjpehupy+PSet0/vCxUNs94N8zKtAPVaRkFfIRXRFArVdwdX
glBF6vfqdCpKWRKaU+yohPlCY6HEOCqCbLGISN4qyEyn+N/0oiJbUecEx7gq
YA9JMBk/T0VhPInneMNJ8NXPILpNg4pa93/cFdREApLnxqYCRSoai9Gu6WSu
hrsOjocdxahIP+1iI499NXRc0d20MklBki63O9w1ayDHiFnt81cK6mt61kN1
rgGfc5XODT0UlPfVhO1Idg0cVpf46ldHQd+G1fe/2lgLcfuWK7eEUZB9yaMD
evW18GBX8eS0NwXJKm5PdGPUwhkRK4kuJwry4plQ+stXB8tc3eGxJhS006Ug
fPO9OjD7k3tL/AAFiRW57WXnQrCHdpVXrrURZb0weKItWg/PXd/Gc6FG9Jft
7G7XQ/XAKqUhNlXUiM6LvaJbatbDSIiU1JvYRjSzOs7vbV0PmQZ/YY95I0pz
C1b7UlgPez49vyO4SEbaXOUfzY40wPNwjpk/DDKqP6Tcs+VkA7CqPXb+8JmM
/v4XsyPcqAFG0iy9n1HJ6Koh4zibQwNkWh+O3RJJRqa7293G8xpgz693ZGZJ
MmqbnRGUEibD88yT2l8EySj+9d+O0/vIwGpc1YY2k9Fon7jiKQUyjJCSex/N
NaCCZ5Z7PpwnQ6aX7eRCXQPy5ZMg3fYmwx7OzYLjFxrQW9+jqgWfyLB3l/aD
rif16I4Mv0mibyMwbY3TnHKuR1ttGNvXQhuhf3GUb5NNPVopzis8HdsIIZ0B
dep69SjILCLwVU4jzHrTNhUL16MaS7mBU22N4N4QqrvjDkIDK2vJ77gocCD+
wJyxPkJODmpaDH4KDNm1xUcoIpQe3nF5XpwCJ8U3j66xIBS+TjG4TZYCXJ4h
3p8S6pBR6viH7PMUyDz2tPxley0SHCSVSQZT4DLvfpOu0lok90iacjCSApyM
ZpZNL2vRAwGeYYk4Cjx4yaHvfrsW9TQnjHzJoMCxxaBxY6ZadMFO9mNqPQU6
KwLFt8vVoDJZh/1mcxRYkfMPjoghoR2hLuGx56hgxLzS/MSDhLhT+o/7GlLh
zTuHTS6WJHROWe3SLWMqXLO7EWJyhIR4Sh9u23STCqS8Y2FS76tQBtPljl5H
KrhKzkVSeKtQxBRN+nkcFTp+W3dWLFei5/6qV74mUGEvbYg7d7gS1T7O4t2d
QoUey/boyNJKpNzraB+WQ4UjaTkxpkaVyJ2/Onm2igqzItfj/0RXIGGKO8fW
PiqcmejpG39YgdJDWpNaBqiQWnNW8LN5BcoaWyF5DlFB/+rRl1T5CpSpWk5q
H6VCYdz2V1Fd5Ugh1MOSfYEK93jakqV5ylGSSWvsChcBYxtVsq9HlaJDR/i2
HVMj4L6WdKCuayn6q6hNOa5JwLyfqJWSaSmalcm4rqxFABMLiySXVCnaZjYe
sf0sAXwrLVmooQTZ+R08b29MwKkZkyzRmWKkvbSrk3SPgFYZvQCOD8VIlzPx
kbodAQb31W8v1BSjsNqdo2R7AkzH9+xtDyxGridED+W7EOD8fSrTQ7wYCVeF
s8l6E5DR5505cL4IhelcvD4eRYAUv6M//UgRGt8LP9fHEFB48datUqEi9KO7
9jdfLAE1XWf2hIwWomQStVXqJQHdbTyZRz0LUab1Ws76NAI2+uroHDEpQGqI
DNFFBPCuk920eV8B2lH+4e6ZEgLEH/O2DM/nozUZ0c6lUgIUXQfPPAvJR5av
YuzOVhJw667tmbnqPGQzFyCdV0cA1Sj6dJHgG/RORoXTqpkAwYbdqkw/c5Hh
utTwwhYC7A5Uyp6vykWOXscS5lsJEGYd5Ju4lIsqFETtbd8SYF+xZ0Qy5jVS
P7v7j2w3AfRdVX0uFq9R9YWSNxffEyAaodNGyL9GIjavpF17CGiysiu16MxB
tZYvCvJ78fsKknySt+Ygqf1vcn4O4Pr56zpPfcpGD2O3JE8N4vrPfrI+np+N
2pe3pU1/IsClhUV/QDcbGQl7T44MEdD+6KwYf3AWokdnumQME/Do81B1+PpM
FPRUVenBOAGdOg4Fn7oykMGU/msVBgGSlRvSDqRlII854SymCQK6IqSCW9Qy
0D55o+s+k3h/1B2N2TzTkW+U+GuTGQK88ll1L55LR4+FsnU4Zwl4LxgPGSLp
yMewrawC22uudo9GTRr6eK+MecM8AR/S2X49/puKOOKuXXRfIEB624uxNnoq
uhQtz8v1mwAfD+kB4bhUVLdOuzcV++BF/UaSQirqMa6ORH8I8GV7GbngkIIu
Gg8n9iwS0O9wwO+kRgry2cdpcWGJANkh5PqMOwX5tpvefYf9sXLYTK4oGXnR
flk0LBNg0X3t2sBAEkpYd6jFe5WAK17mxRYeSUi+ccDuB7aetM3GCZEkNEK2
Lji3RoCqr0vpimkiShsr5+FmosH2w1GcYl8SUFIDu5rHOhpwDsXdzPJOQEpW
uU6d2MwhSZUyOxPQgsTZR7uZaTD17Y3FCfOXaNZYXJiKTY+m1dz4Ho/03VVs
x1loUAft3D/94tG0gc+yzHoalI53W9nviUeWDTwx9tgpGl95n9yOQw8eZ6yf
xY6bGrPZtDEOXRmY/HFwAw3CXk7VR2fHoupJnt/W2O5zy3fTfzxHIeefZPRj
2yWxNEoHP0e6edsvcLHS4JYOh0CZ1HN0X1jgtCa2QRoflXonBtVWmwtlYe83
lBMZnYhGg7wkuctsNNi5puRgGxaNXgQ2vvXG5s+Fpt8HoxGf1aef2djrWc46
bbSLQiURWypnsRfzDVsiuKLQKsPf9b+NNJi+cmWHQFEksvjY06WAPVh8u23f
bARyKKC4OGF3m97fVRwVgXJLu9ujsJs5nNxU5CNQNHPGYD72Xep6nedjYYhV
Kx6+YRuLcP/O3BeGetJPpSxhn3QSS6uwCUXfBGgfuNlpILpbZamX8RQF394/
pIrN4aGV9ePAU3SC/Wm9PvbvbiPDxfvBqN+KFmWBPSx9c42jMAh5CsmaOmN3
+NrmCs0EIsNyXqkA7JqBR5ek5QLR43bKynPsnMPBLKoOAch6t/9QBrbPcPpV
019+KO36yel67PvHitlsFfzQZO2f/W3YV5+hEk8XX+SLNj7rxdZmtJpFVD5B
dKZ3Mt+wD2v2b0r564OERPJYJ7DFE0YrilR80Eg6p/gCNuf8vDn5oTfiq7v1
ZBX7jw4zV1eNFxLx2qDEyoHrpSXmSlvyRK9Z5E5uxg74OU2zN3mMmOSHFXix
NUPJfKLoEbr9ythJEJtJ9tntJvGHaM69iV0cu7bTssLRxw1xmScuSmC7Oymy
iQ+7oIbvg3r7sBX42S+1nHRGf1pc+A5gz5H6M52zHFH2p6uXZbELTd4s7GB3
QJQRtx3y2PeYHp9qs3mAjuc1uB/BNjyVJD0TZ4s4lnbaKWK3PlVv1bp2F6Ur
DXMqY5969/1Oopg12mfPflUFG20P2vTrqyXyv8d/7Si20jXpXJ3Mm0jq6TeR
Y9jmGkkxml2mKGRqJOufL7Z/7565bIwGtwqxqGKfvizNmzSkjzKXhI79syv9
e2Zc+ylk8cfR5J+ra76fGamQRxSR7rv/PGbCNBRVxg+VyyV2/9z7y37wEvsJ
nHv8D/959vN305UlXSjVuv7sn1ktpe30fxtBvixPyz/z9H+XTbe7Ch6MBzzH
sSOy3rouzV+H3kxHv3/muyndl37IAvJNNkgCdqJwkPK5+7chvmsdxwlsiQ/f
43+/toE657SDativI9UXk0fvwU16bqY6Nn/m+QO7o+yAO0nDUxP7GsvjQTdZ
e3B88cRMCzvp+pvQ9nYHUL6wtOEM9tfaftVd95zgQzcT91nsPULsky6bXCDd
iz9TD9vaVTGxNccVUo0bKEbYb95bntuh7Q56X1pdLmNPyz1bdRp5CI82bG0y
xZaPIOc3+3qASLsZ2QLbeWLaVGyXJ7jGx927g22SEc5Guu4FMdbPu+2xV7sy
zYZlvEHaX3ndQ+xk5rqKLWveENhvvvIEW/3Q+63K7T4gLL/UGYo9bMa4bf7q
CUTXjTyNw/YPY6kPvesLLiPb5NKx99YK8lce9YPxF9ZvC7FtBE/TOfv9YdXR
jK8Nm/P0dXHFnACIMkl5P4Cd5+LiesM1EKx6o4onsM9lhnU81QoCc6OTlWv/
1tedIVm+PRgsTzRPc2+iQRRLrdfQ92DQ2yR/ay/2YbnuXo6yp7BBInKnKrZL
OHOQmWEoXF60j7uLzV8n8CVoZxhUxwjc8scmMWSVS2fC4IHKUmoK9lp6geN6
7QgwuVoWNYCtd6w6Ob4gAozLCi8vYyd3Ea0H+SJBplu6UoQT14P5k8TlkUhY
EJowt8ReI4X+WDsVBRPTK7uDsGscVPMzs6JgztDwXj62wvcExXmraCjQePJm
BXvule7yi6ZokIyoKt27GZ/Hi8v1alLPwPTn6E1DbCn61TPh488gjqXsXQH2
qNemrQq6MWCrOpo6hJ2uXN018CYGlLg5jvJswfmZK2gidf85ngOvffHA5gnr
s6VOxwLr8eZJ6604H08FHb6rHwecIYJDOdhha0p/uYvjgHKjo38ce+ODOJ/r
DvGQK5i12ZmLBsuGl2KWfr2AqdV4/fRtNKjiZLuSevEl/i8rcP6F7UwtFz1d
8RLaWZJHtbnx/ihsz37umgA9emfaF7CHBd6TDi29gvOW9c9seXE/7PT17L2a
CFbasWtd2KZPD2t61iTCVg2zPyr/4fO7HN3W6pEEx2V4y7i202DEdt+0vFcy
vC49qznAh/NQ19sgoDAZqnb/YLvIT4M0yb7S/qFkoG0RSOjEvv4l0M1bLQV4
/gZc6hagQb/BGPNb5lRYWRtkWRLCeSRzwnKnfCr4MV8+EiJMg9hNcTQn81Rw
H9zkLi5CAyOKVogwJRX2jF4zNRClQfuRrP9s/NLAvDzRaUCcBo38tyQ3bMyA
qUt1GyP30IDYTtO5fSwDruuq81jtxfMBr6Rtk10GZAi/uqAhifOS62dZaF8G
FEJGLqsU7pcb72tsz80Ehv/juoYDNOhhfXvL9XMmGKVczak+iNe/Xja4nycL
BGi6oiQZGgwwzXYkPsqCo95abymHcD3/OJnuPZcNarT0O9wKuD4LPd5BPtmw
zkiSekgR5+G8YsZ4eTbw+7kuXlCiAWP673iBWA40iV/dkadCg/kxDzelmRyQ
PBbrHgu4//f5PTv9LBcuHfedsjiD8/HDSEUuPRcoF98U9Ojg7+G91sfNK7lQ
JE/8OHsWn9d37Ds7Ld+AUxHXnK4eDXibQguuKObBtZ4u67CLNNhdFdN8pz8f
KmoWOfZa0ECyYmGibUsBiHDaD8xb4u+57NI2WY0C+OH3q5Z+mwYHiwSM53ML
ICVTqsfnDg1edrfb1x0vhPPtV66pOeD9bTVg0uIqgoermoZTT2jQ2XPGeWVf
ESxvlZrn88f98Is6o0SjCMxyjedOBeJ8/SXXK+5SBHrXGNKVIXjeE+UpXBws
AtdUFtuxGBoE2naZ5ecWQ7RkLM0/hwblbi3vLajFIMk99JP/DQ2+P2nUEfpc
DBKlBsNF+fh8x5UoBnKX4PXfcP5TQoOl+uitN91KYCzlw+feOjwvcBuh/7RK
oStz5wjjPQ0ShHWPtF4vBc66mMKpXtzf92jm+riXQkw9Z83fjzgPjx6Oncor
BT835fxdX2kwZM5r28RbBvrGs9lvJ3G/LesW9fhaBjmbPY6HstNByfjC42GP
CpjKviFL0aQD2cb5yueYCjASXjB30qaDjkesQn9eBZzZsNftgC4dTFP7Jt8O
VoCA1iajYkM6PGGYmFWrVkLifJzIVnM6tHvdOhG1UglsZ9JD+Z7QwSLHhfmE
BwkE+E7KutDpMFkd90klhgQVpnlT7G10cGmvIh3JI4FiWM5Q2js6BM8t2e8f
JIFdQK/pRD8dClS9vm1XrYY63ntMHybosPgukDKxXA1joVePsP7XBJGL8f4v
H9UCpTnqY79VEzBeQeOr57Ug8XrcuO1+E2irfV9LKqwFuDH/gO7YBKsBsm7p
w7WgMlLm1OvVBDb/0e7k6daBlZIJySy+CTRl5/WQMILkW9fGOVqbYEkuK/SB
aT08TFdq6FBshjyrdcYxqw3gtVal2CTZAoF1VjmVHGTgenS5Sk+2BSx4OxY/
bidDUnCuxWfFFhCsT3y1U4YMLqJmMtxaLeDPd+xbgRkZrNT/u9Bm2QKmhPP9
5noy/DVYi4hNbwEuCYbvmk8jwCtLBau9reDwuafImo0K/pHRSfpqbVDu4VUS
wUuFO+vKPhvotMGikFRZxQ4q0N/mpV+90AY+xh6VG45R4awUJfeJdRtEvduF
UuyoYKDVf/hAVBsUN9q19vVRIdCm8erX4TaYzeIYPf2GgPAHN+rKwtvB3u64
sJQ+HWw1crawLb4FwduxW2OftoBnUfLpw37vQMJ6Gz0irB2YKjIEdQS6oJQc
pn30RweonGgNMJ/rhoCLGeGOtp3Qq/uuaKWlB2ReHRZaP9kFtzrWsiZKe2Fu
mrOAPfQ9CFD1dul+7QerZqeMC1wf4EbZ2Hw38yD8Ldybzofv85+LWlC78xnM
zhiMyuj1g8fzDHrszBA4W28ODev4CBU3WxcDJL5CTsy2o+YPBkHpoGm8quc3
CNXK1Hm88Ano5w07/DuGYVfP5Y7fykPALmwQWSw5Apu3bvAc3/gFoiQu3DTM
H4W3wX9MmZu/gIqLlsR+qR8gFsqlYfTyK3gVSxip9f0E7U474ybTb8BgvRH/
0pMBH+02R1iLDsOFYb4GUblJWI5pb9GcHAa1pSsfb2+bhoWVD0oahd9hi7wC
1Yd1Bh4zNrx+5DMCIsXvNj8XnwW7w3aqX/RG4f4PXqZk7Tk4inYyW28bg8Hs
rul4u3l41vG3ef/XMahN7zjM3vILCAkB6raMH3Bsz7mLUvt/w81Oxy87LX5C
ydGZkLMZfyCE9dc6W/lxyJpWe7H+/iKEedQafpofx3NtSLG4/jKIPXydE0gw
4NdttwMLxauwepeZlIJddfzTj5MlqzBgeqWZhB1Xtis7BjtOnWOcgf16TE/q
SOkqcHPYSOvTGEDbo3jSsWwV1sfvKxCgM4CX//T72YpV+FmeXfq6iQEubvJm
MzWrQM9mojZiH1QZvKRWuwpZL4zfD2BnkG0MIrEtHm9c2NKMnx9+6OyhulUY
PGml6IAtM2h3+QFahY7uvaSjLQzIu9LaOtOwCvmEZ7MRdu2dum9q5FUIqfzQ
fw/buDdmORL7dELAUhK25L5f8nKNq0A2Hz22vpUB5DuuVfaUVUi+AGdFsHuE
4j6TsT21Yk0UsK/PvGLjoa7Csf1aj62wqx9cMynBFhRJCvPGZjv/31MWYhX+
bPmd+AK7qryUZIjdw3S+oAR7C1mFkYZdNpuJWrFPBWeJzWP/D/8pddU=
      "]], LineBox[CompressedData["
1:eJw113c8Vf8bAHDRMCopX0IRlRVNMsJTiIwKLS0aCiWEjLKTFZItZF9kz2t/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      "]]}}, 
   {Thickness[Small], Arrowheads[0.02], 
    ArrowBox[{{-1., -1.}, {-0.9998653628780456, -1.}}], 
    ArrowBox[{{-1., -0.7714285714285715}, {-0.9998653628780456, \
-0.7714027151911591}}], 
    ArrowBox[{{-1., -0.5428571428571429}, {-0.9998653628780456, \
-0.5427527151725245}}], 
    ArrowBox[{{-1., -0.3142857142857143}, {-0.9998653628780456, \
-0.3138183788210792}}], 
    ArrowBox[{{-1., -0.08571428571428574}, {-0.9998653628780456, \
-0.07733686479267984}}], 
    ArrowBox[{{-1., 0.14285714285714282`}, {-0.9998653628780456, 
     0.1466269822718655}}], 
    ArrowBox[{{-1., 0.3714285714285714}, {-0.9998653628780456, 
     0.3720977736915399}}], 
    ArrowBox[{{-1., 0.6}, {-0.9998653628780456, 0.600299193604343}}], 
    ArrowBox[{{-1., 0.8285714285714285}, {-0.9998653628780456, 
     0.8287507312784308}}], 
    ArrowBox[{{-1., 1.0571428571428572`}, {-0.9998653628780456, 
     1.057266774435525}}], 
    ArrowBox[{{-1., 1.2857142857142856`}, {-0.9998653628780456, 
     1.2858073681689701`}}], 
    ArrowBox[{{-1., 1.5142857142857142`}, {-0.9998653628780456, 
     1.5143595274462018`}}], 
    ArrowBox[{{-1., 1.7428571428571429`}, {-0.9998653628780456, 
     1.7429179303779392`}}], 
    ArrowBox[{{-1., 1.9714285714285713`}, {-0.9998653628780456, 
     1.9714800395155188`}}], 
    ArrowBox[{{-1., 2.1999999999999997`}, {-0.9998653628780456, 
     2.200044508139489}}], 
    ArrowBox[{{-0.8642857142857143, -1.}, {-0.8641510771637599, -1.}}], 
    ArrowBox[{{-0.8642857142857143, -0.7714285714285715}, \
{-0.8641510771637599, -0.7714078510579117}}], 
    ArrowBox[{{-0.8642857142857143, -0.5428571428571429}, \
{-0.8641510771637599, -0.5427734578144228}}], 
    ArrowBox[{{-0.8642857142857143, -0.3142857142857143}, \
{-0.8641510771637599, -0.3139112064292435}}], 
    ArrowBox[{{-0.8642857142857143, -0.08571428571428574}, \
{-0.8641510771637599, -0.07900088562051279}}], 
    ArrowBox[{{-0.8642857142857143, 
     0.14285714285714282`}, {-0.8641510771637599, 0.14587817289934066`}}], 
    ArrowBox[{{-0.8642857142857143, 0.3714285714285714}, {-0.8641510771637599,
      0.371964848950855}}], 
    ArrowBox[{{-0.8642857142857143, 0.6}, {-0.8641510771637599, 
     0.6002397642890633}}], 
    ArrowBox[{{-0.8642857142857143, 0.8285714285714285}, {-0.8641510771637599,
      0.8287151160882988}}], 
    ArrowBox[{{-0.8642857142857143, 
     1.0571428571428572`}, {-0.8641510771637599, 1.0572421605408842`}}], 
    ArrowBox[{{-0.8642857142857143, 
     1.2857142857142856`}, {-0.8641510771637599, 1.285788879048661}}], 
    ArrowBox[{{-0.8642857142857143, 
     1.5142857142857142`}, {-0.8641510771637599, 1.5143448658173344`}}], 
    ArrowBox[{{-0.8642857142857143, 
     1.7428571428571429`}, {-0.8641510771637599, 1.742905856053201}}], 
    ArrowBox[{{-0.8642857142857143, 
     1.9714285714285713`}, {-0.8641510771637599, 1.9714698163251776`}}], 
    ArrowBox[{{-0.8642857142857143, 
     2.1999999999999997`}, {-0.8641510771637599, 2.2000356674149018`}}], 
    ArrowBox[{{-0.7285714285714286, -1.}, {-0.7284367914494743, -1.}}], 
    ArrowBox[{{-0.7285714285714286, -0.7714285714285715}, \
{-0.7284367914494743, -0.7714126913639884}}], 
    ArrowBox[{{-0.7285714285714286, -0.5428571428571429}, \
{-0.7284367914494743, -0.5427930067514305}}], 
    ArrowBox[{{-0.7285714285714286, -0.3142857142857143}, \
{-0.7284367914494743, -0.3139986919613894}}], 
    ArrowBox[{{-0.7285714285714286, -0.08571428571428574}, \
{-0.7284367914494743, -0.0805691447893514}}], 
    ArrowBox[{{-0.7285714285714286, 
     0.14285714285714282`}, {-0.7284367914494743, 0.14517245627336328`}}], 
    ArrowBox[{{-0.7285714285714286, 0.3714285714285714}, {-0.7284367914494743,
      0.371839573810149}}], 
    ArrowBox[{{-0.7285714285714286, 0.6}, {-0.7284367914494743, 
     0.6001837550330333}}], 
    ArrowBox[{{-0.7285714285714286, 0.8285714285714285}, {-0.7284367914494743,
      0.8286815504937219}}], 
    ArrowBox[{{-0.7285714285714286, 
     1.0571428571428572`}, {-0.7284367914494743, 1.0572189631353552`}}], 
    ArrowBox[{{-0.7285714285714286, 
     1.2857142857142856`}, {-0.7284367914494743, 1.2857714539467848`}}], 
    ArrowBox[{{-0.7285714285714286, 
     1.5142857142857142`}, {-0.7284367914494743, 1.5143310479410692`}}], 
    ArrowBox[{{-0.7285714285714286, 
     1.7428571428571429`}, {-0.7284367914494743, 1.742894476585972}}], 
    ArrowBox[{{-0.7285714285714286, 
     1.9714285714285713`}, {-0.7284367914494743, 1.9714601814626092`}}], 
    ArrowBox[{{-0.7285714285714286, 
     2.1999999999999997`}, {-0.7284367914494743, 2.2000273354594593`}}], 
    ArrowBox[{{-0.5928571428571429, -1.}, {-0.5927225057351885, -1.}}], 
    ArrowBox[{{-0.5928571428571429, -0.7714285714285715}, \
{-0.5927225057351885, -0.7714171605624899}}], 
    ArrowBox[{{-0.5928571428571429, -0.5428571428571429}, \
{-0.5927225057351885, -0.542811056866154}}], 
    ArrowBox[{{-0.5928571428571429, -0.3142857142857143}, \
{-0.5927225057351885, -0.3140794699541402}}], 
    ArrowBox[{{-0.5928571428571429, -0.08571428571428574}, \
{-0.5927225057351885, -0.08201716510384736}}], 
    ArrowBox[{{-0.5928571428571429, 
     0.14285714285714282`}, {-0.5927225057351885, 0.1445208471318401}}], 
    ArrowBox[{{-0.5928571428571429, 0.3714285714285714}, {-0.5927225057351885,
      0.3717239035483401}}], 
    ArrowBox[{{-0.5928571428571429, 0.6}, {-0.5927225057351885, 
     0.6001320400218013}}], 
    ArrowBox[{{-0.5928571428571429, 0.8285714285714285}, {-0.5927225057351885,
      0.8286505583823535}}], 
    ArrowBox[{{-0.5928571428571429, 
     1.0571428571428572`}, {-0.5927225057351885, 1.057197544281178}}], 
    ArrowBox[{{-0.5928571428571429, 
     1.2857142857142856`}, {-0.5927225057351885, 1.2857553648321793`}}], 
    ArrowBox[{{-0.5928571428571429, 
     1.5142857142857142`}, {-0.5927225057351885, 1.514318289485112}}], 
    ArrowBox[{{-0.5928571428571429, 
     1.7428571428571429`}, {-0.5927225057351885, 1.7428839695855711`}}], 
    ArrowBox[{{-0.5928571428571429, 
     1.9714285714285713`}, {-0.5927225057351885, 1.9714512853075579`}}], 
    ArrowBox[{{-0.5928571428571429, 
     2.1999999999999997`}, {-0.5927225057351885, 2.2000196423172924`}}], 
    ArrowBox[{{-0.4571428571428572, -1.}, {-0.4570082200209028, -1.}}], 
    ArrowBox[{{-0.4571428571428572, -0.7714285714285715}, \
{-0.4570082200209028, -0.7714211549615938}}], 
    ArrowBox[{{-0.4571428571428572, -0.5428571428571429}, \
{-0.4570082200209028, -0.5428271893700143}}], 
    ArrowBox[{{-0.4571428571428572, -0.3142857142857143}, \
{-0.4570082200209028, -0.3141516662420767}}], 
    ArrowBox[{{-0.4571428571428572, -0.08571428571428574}, \
{-0.4570082200209028, -0.0833113504135226}}], 
    ArrowBox[{{-0.4571428571428572, 
     0.14285714285714282`}, {-0.4570082200209028, 0.14393846374248623`}}], 
    ArrowBox[{{-0.4571428571428572, 0.3714285714285714}, {-0.4570082200209028,
      0.37162052188159095`}}], 
    ArrowBox[{{-0.4571428571428572, 0.6}, {-0.4570082200209028, 
     0.6000858191178844}}], 
    ArrowBox[{{-0.4571428571428572, 0.8285714285714285}, {-0.4570082200209028,
      0.8286228588156779}}], 
    ArrowBox[{{-0.4571428571428572, 
     1.0571428571428572`}, {-0.4570082200209028, 1.0571784009265244`}}], 
    ArrowBox[{{-0.4571428571428572, 
     1.2857142857142856`}, {-0.4570082200209028, 1.2857409849954051`}}], 
    ArrowBox[{{-0.4571428571428572, 
     1.5142857142857142`}, {-0.4570082200209028, 1.5143068864639606`}}], 
    ArrowBox[{{-0.4571428571428572, 
     1.7428571428571429`}, {-0.4570082200209028, 1.7428745788294946`}}], 
    ArrowBox[{{-0.4571428571428572, 
     1.9714285714285713`}, {-0.4570082200209028, 1.9714433342635949`}}], 
    ArrowBox[{{-0.4571428571428572, 
     2.1999999999999997`}, {-0.4570082200209028, 2.2000127664803464`}}], 
    ArrowBox[{{-0.3214285714285715, -1.}, {-0.3212939343066171, -1.}}], 
    ArrowBox[{{-0.3214285714285715, -0.7714285714285715}, \
{-0.3212939343066171, -0.771424528271756}}], 
    ArrowBox[{{-0.3214285714285715, -0.5428571428571429}, \
{-0.3212939343066171, -0.5428408134315559}}], 
    ArrowBox[{{-0.3214285714285715, -0.3142857142857143}, \
{-0.3212939343066171, -0.314212636732364}}], 
    ArrowBox[{{-0.3214285714285715, -0.08571428571428574}, \
{-0.3212939343066171, -0.08440430290608096}}], 
    ArrowBox[{{-0.3214285714285715, 
     0.14285714285714282`}, {-0.3212939343066171, 0.14344663512083497`}}], 
    ArrowBox[{{-0.3214285714285715, 0.3714285714285714}, {-0.3212939343066171,
      0.3715332150256765}}], 
    ArrowBox[{{-0.3214285714285715, 0.6}, {-0.3212939343066171, 
     0.600046785100293}}], 
    ArrowBox[{{-0.3214285714285715, 0.8285714285714285}, {-0.3212939343066171,
      0.8285994662534115}}], 
    ArrowBox[{{-0.3214285714285715, 
     1.0571428571428572`}, {-0.3212939343066171, 1.0571622341712474`}}], 
    ArrowBox[{{-0.3214285714285715, 
     1.2857142857142856`}, {-0.3212939343066171, 1.2857288410788212`}}], 
    ArrowBox[{{-0.3214285714285715, 
     1.5142857142857142`}, {-0.3212939343066171, 1.5142972564980686`}}], 
    ArrowBox[{{-0.3214285714285715, 
     1.7428571428571429`}, {-0.3212939343066171, 1.742866648241669}}], 
    ArrowBox[{{-0.3214285714285715, 
     1.9714285714285713`}, {-0.3212939343066171, 1.9714366195271094`}}], 
    ArrowBox[{{-0.3214285714285715, 
     2.1999999999999997`}, {-0.3212939343066171, 2.2000069597669856`}}], 
    ArrowBox[{{-0.18571428571428578`, -1.}, {-0.1855796485923314, -1.}}], 
    ArrowBox[{{-0.18571428571428578`, -0.7714285714285715}, \
{-0.1855796485923314, -0.7714270672274965}}], 
    ArrowBox[{{-0.18571428571428578`, -0.5428571428571429}, \
{-0.1855796485923314, -0.5428510677181755}}], 
    ArrowBox[{{-0.18571428571428578`, -0.3142857142857143}, \
{-0.1855796485923314, -0.31425852678364086`}}], 
    ArrowBox[{{-0.18571428571428578`, -0.08571428571428574}, \
{-0.1855796485923314, -0.08522692456600643}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.14285714285714282`}, {-0.1855796485923314, 0.1430764553738685}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.3714285714285714}, {-0.1855796485923314, 0.3714675026445582}}], 
    ArrowBox[{{-0.18571428571428578`, 0.6}, {-0.1855796485923314, 
     0.6000174057552957}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.8285714285714285}, {-0.1855796485923314, 0.8285818596067068}}], 
    ArrowBox[{{-0.18571428571428578`, 
     1.0571428571428572`}, {-0.1855796485923314, 1.057150066100675}}], 
    ArrowBox[{{-0.18571428571428578`, 
     1.2857142857142856`}, {-0.1855796485923314, 1.2857197008381553`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     1.5142857142857142`}, {-0.1855796485923314, 1.5142900084076152`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     1.7428571428571429`}, {-0.1855796485923314, 1.7428606792051686`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     1.9714285714285713`}, {-0.1855796485923314, 1.9714315656133197`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     2.1999999999999997`}, {-0.1855796485923314, 2.2000025892859116`}}], 
    ArrowBox[{{-0.05000000000000007, -1.}, {-0.04986536287804569, -1.}}], 
    ArrowBox[{{-0.05000000000000007, -0.7714285714285715}, \
{-0.04986536287804569, -0.7714284483036314}}], 
    ArrowBox[{{-0.05000000000000007, -0.5428571428571429}, \
{-0.04986536287804569, -0.5428566455824543}}], 
    ArrowBox[{{-0.05000000000000007, -0.3142857142857143}, \
{-0.04986536287804569, -0.3142834888787398}}], 
    ArrowBox[{{-0.05000000000000007, -0.08571428571428574}, \
{-0.04986536287804569, -0.08567439323370667}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.14285714285714282`}, {-0.04986536287804569, 0.1428750944734034}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.3714285714285714}, {-0.04986536287804569, 0.3714317581060141}}], 
    ArrowBox[{{-0.05000000000000007, 0.6}, {-0.04986536287804569, 
     0.6000014247314492}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.8285714285714285}, {-0.04986536287804569, 0.8285722823938428}}], 
    ArrowBox[{{-0.05000000000000007, 
     1.0571428571428572`}, {-0.04986536287804569, 1.0571434472252033`}}], 
    ArrowBox[{{-0.05000000000000007, 
     1.2857142857142856`}, {-0.04986536287804569, 1.2857147289640698`}}], 
    ArrowBox[{{-0.05000000000000007, 
     1.5142857142857142`}, {-0.04986536287804569, 1.5142860657769546`}}], 
    ArrowBox[{{-0.05000000000000007, 
     1.7428571428571429`}, {-0.04986536287804569, 1.7428574323215276`}}], 
    ArrowBox[{{-0.05000000000000007, 
     1.9714285714285713`}, {-0.04986536287804569, 1.9714288165146996`}}], 
    ArrowBox[{{-0.05000000000000007, 
     2.1999999999999997`}, {-0.04986536287804569, 2.200000211943521}}], 
    ArrowBox[{{0.08571428571428563, -1.}, {0.08584892283624002, -1.}}], 
    ArrowBox[{{0.08571428571428563, -0.7714285714285715}, {
     0.08584892283624002, -0.7714281558818987}}], 
    ArrowBox[{{0.08571428571428563, -0.5428571428571429}, {
     0.08584892283624002, -0.5428554645550687}}], 
    ArrowBox[{{0.08571428571428563, -0.3142857142857143}, {
     0.08584892283624002, -0.3142782035371755}}], 
    ArrowBox[{{0.08571428571428563, -0.08571428571428574}, {
     0.08584892283624002, -0.08557964859233136}}], 
    ArrowBox[{{0.08571428571428563, 0.14285714285714282`}, {
     0.08584892283624002, 0.14291772956202228`}}], 
    ArrowBox[{{0.08571428571428563, 0.3714285714285714}, {0.08584892283624002,
      0.37143932646494054`}}], 
    ArrowBox[{{0.08571428571428563, 0.6}, {0.08584892283624002, 
     0.6000048084686412}}], 
    ArrowBox[{{0.08571428571428563, 0.8285714285714285}, {0.08584892283624002,
      0.8285743102220767}}], 
    ArrowBox[{{0.08571428571428563, 1.0571428571428572`}, {
     0.08584892283624002, 1.057144848670775}}], 
    ArrowBox[{{0.08571428571428563, 1.2857142857142856`}, {
     0.08584892283624002, 1.2857157816823073`}}], 
    ArrowBox[{{0.08571428571428563, 1.5142857142857142`}, {
     0.08584892283624002, 1.5142869005686506`}}], 
    ArrowBox[{{0.08571428571428563, 1.7428571428571429`}, {
     0.08584892283624002, 1.7428581197994415`}}], 
    ArrowBox[{{0.08571428571428563, 1.9714285714285713`}, {
     0.08584892283624002, 1.9714293985942544`}}], 
    ArrowBox[{{0.08571428571428563, 2.1999999999999997`}, {
     0.08584892283624002, 2.2000007153093843`}}], 
    ArrowBox[{{0.22142857142857134`, -1.}, {0.22156320855052572`, -1.}}], 
    ArrowBox[{{0.22142857142857134`, -0.7714285714285715}, {
     0.22156320855052572`, -0.7714253148303862}}], 
    ArrowBox[{{0.22142857142857134`, -0.5428571428571429}, {
     0.22156320855052572`, -0.5428439901697355}}], 
    ArrowBox[{{0.22142857142857134`, -0.3142857142857143}, {
     0.22156320855052572`, -0.3142268532920689}}], 
    ArrowBox[{{0.22142857142857134`, -0.08571428571428574}, {
     0.22156320855052572`, -0.0846591479022722}}], 
    ArrowBox[{{0.22142857142857134`, 0.14285714285714282`}, {
     0.22156320855052572`, 0.1433319548725489}}], 
    ArrowBox[{{0.22142857142857134`, 0.3714285714285714}, {
     0.22156320855052572`, 0.37151285758515235`}}], 
    ArrowBox[{{0.22142857142857134`, 0.6}, {0.22156320855052572`, 
     0.6000376834932861}}], 
    ArrowBox[{{0.22142857142857134`, 0.8285714285714285}, {
     0.22156320855052572`, 0.828594011782625}}], 
    ArrowBox[{{0.22142857142857134`, 1.0571428571428572`}, {
     0.22156320855052572`, 1.0571584645502299`}}], 
    ArrowBox[{{0.22142857142857134`, 1.2857142857142856`}, {
     0.22156320855052572`, 1.2857260094677525`}}], 
    ArrowBox[{{0.22142857142857134`, 1.5142857142857142`}, {
     0.22156320855052572`, 1.5142950110677889`}}], 
    ArrowBox[{{0.22142857142857134`, 1.7428571428571429`}, {
     0.22156320855052572`, 1.7428647990573376`}}], 
    ArrowBox[{{0.22142857142857134`, 1.9714285714285713`}, {
     0.22156320855052572`, 1.9714350538442407`}}], 
    ArrowBox[{{0.22142857142857134`, 2.1999999999999997`}, {
     0.22156320855052572`, 2.200005605808918}}], 
    ArrowBox[{{0.35714285714285704`, -1.}, {0.3572774942648114, -1.}}], 
    ArrowBox[{{0.35714285714285704`, -0.7714285714285715}, {
     0.3572774942648114, -0.7714183110168998}}], 
    ArrowBox[{{0.35714285714285704`, -0.5428571428571429}, {
     0.3572774942648114, -0.5428157032997547}}], 
    ArrowBox[{{0.35714285714285704`, -0.3142857142857143}, {
     0.3572774942648114, -0.3141002637045099}}], 
    ArrowBox[{{0.35714285714285704`, -0.08571428571428574}, {
     0.3572774942648114, -0.0823899123326961}}], 
    ArrowBox[{{0.35714285714285704`, 0.14285714285714282`}, {
     0.3572774942648114, 0.14435311087885816`}}], 
    ArrowBox[{{0.35714285714285704`, 0.3714285714285714}, {0.3572774942648114,
      0.3716941278821303}}], 
    ArrowBox[{{0.35714285714285704`, 0.6}, {0.3572774942648114, 
     0.600118727620771}}], 
    ArrowBox[{{0.35714285714285704`, 0.8285714285714285}, {0.3572774942648114,
      0.8286425804392865}}], 
    ArrowBox[{{0.35714285714285704`, 1.0571428571428572`}, {
     0.3572774942648114, 1.0571920306716938`}}], 
    ArrowBox[{{0.35714285714285704`, 1.2857142857142856`}, {
     0.3572774942648114, 1.2857512231963033`}}], 
    ArrowBox[{{0.35714285714285704`, 1.5142857142857142`}, {
     0.3572774942648114, 1.5143150052224157`}}], 
    ArrowBox[{{0.35714285714285704`, 1.7428571428571429`}, {
     0.3572774942648114, 1.742881264889205}}], 
    ArrowBox[{{0.35714285714285704`, 1.9714285714285713`}, {
     0.3572774942648114, 1.971448995272598}}], 
    ArrowBox[{{0.35714285714285704`, 2.1999999999999997`}, {
     0.3572774942648114, 2.2000176619601146`}}], 
    ArrowBox[{{0.49285714285714277`, -1.}, {0.49299177997909716`, -1.}}], 
    ArrowBox[{{0.49285714285714277`, -0.7714285714285715}, {
     0.49299177997909716`, -0.7714038025057706}}], 
    ArrowBox[{{0.49285714285714277`, -0.5428571428571429}, {
     0.49299177997909716`, -0.5427571065982962}}], 
    ArrowBox[{{0.49285714285714277`, -0.3142857142857143}, {
     0.49299177997909716`, -0.31383803135872684`}}], 
    ArrowBox[{{0.49285714285714277`, -0.08571428571428574}, {
     0.49299177997909716`, -0.07768915472680774}}], 
    ArrowBox[{{0.49285714285714277`, 0.14285714285714282`}, {
     0.49299177997909716`, 0.14646845180150792`}}], 
    ArrowBox[{{0.49285714285714277`, 0.3714285714285714}, {
     0.49299177997909716`, 0.37206963218792616`}}], 
    ArrowBox[{{0.49285714285714277`, 0.6}, {0.49299177997909716`, 
     0.6002866118209813}}], 
    ArrowBox[{{0.49285714285714277`, 0.8285714285714285}, {
     0.49299177997909716`, 0.8287431911847158}}], 
    ArrowBox[{{0.49285714285714277`, 1.0571428571428572`}, {
     0.49299177997909716`, 1.0572615634266382`}}], 
    ArrowBox[{{0.49285714285714277`, 1.2857142857142856`}, {
     0.49299177997909716`, 1.2858034538363687`}}], 
    ArrowBox[{{0.49285714285714277`, 1.5142857142857142`}, {
     0.49299177997909716`, 1.5143564234320084`}}], 
    ArrowBox[{{0.49285714285714277`, 1.7428571428571429`}, {
     0.49299177997909716`, 1.7429153741220345`}}], 
    ArrowBox[{{0.49285714285714277`, 1.9714285714285713`}, {
     0.49299177997909716`, 1.9714778751633715`}}], 
    ArrowBox[{{0.49285714285714277`, 2.1999999999999997`}, {
     0.49299177997909716`, 2.2000426364692367`}}], 
    ArrowBox[{{0.6285714285714284, -1.}, {0.6287060656933828, -1.}}], 
    ArrowBox[{{0.6285714285714284, -0.7714285714285715}, {0.6287060656933828, 
     -0.7713735629938129}}], 
    ArrowBox[{{0.6285714285714284, -0.5428571428571429}, {
     0.6287060656933828, -0.5426349758270098}}], 
    ArrowBox[{{0.6285714285714284, -0.3142857142857143}, {
     0.6287060656933828, -0.3132914709235896}}], 
    ArrowBox[{{0.6285714285714284, -0.08571428571428574}, {
     0.6287060656933828, -0.06789155285249562}}], 
    ArrowBox[{{0.6285714285714284, 0.14285714285714282`}, {0.6287060656933828,
      0.15087737264494838`}}], 
    ArrowBox[{{0.6285714285714284, 0.3714285714285714}, {0.6287060656933828, 
     0.37285228085835936`}}], 
    ArrowBox[{{0.6285714285714284, 0.6}, {0.6287060656933828, 
     0.6006365261736354}}], 
    ArrowBox[{{0.6285714285714284, 0.8285714285714285}, {0.6287060656933828, 
     0.8289528901546773}}], 
    ArrowBox[{{0.6285714285714284, 1.0571428571428572`}, {0.6287060656933828, 
     1.057406487778687}}], 
    ArrowBox[{{0.6285714285714284, 1.2857142857142856`}, {0.6287060656933828, 
     1.2859123160794166`}}], 
    ArrowBox[{{0.6285714285714284, 1.5142857142857142`}, {0.6287060656933828, 
     1.5144427497568176`}}], 
    ArrowBox[{{0.6285714285714284, 1.7428571428571429`}, {0.6287060656933828, 
     1.7429864666376504`}}], 
    ArrowBox[{{0.6285714285714284, 1.9714285714285713`}, {0.6287060656933828, 
     1.9715380683695936`}}], 
    ArrowBox[{{0.6285714285714284, 2.1999999999999997`}, {0.6287060656933828, 
     2.2000946898440117`}}], 
    ArrowBox[{{0.7642857142857141, -1.}, {0.7644203514076685, -1.}}], 
    ArrowBox[{{0.7642857142857141, -0.7714285714285715}, {
     0.7644203514076685, -0.7713004207523229}}], 
    ArrowBox[{{0.7642857142857141, -0.5428571428571429}, {
     0.7644203514076685, -0.5423395703198288}}], 
    ArrowBox[{{0.7642857142857141, -0.3142857142857143}, {
     0.7644203514076685, -0.3119694702447591}}], 
    ArrowBox[{{0.7642857142857141, -0.08571428571428574}, {
     0.7644203514076685, -0.044193466609755074`}}], 
    ArrowBox[{{0.7642857142857141, 0.14285714285714282`}, {0.7644203514076685,
      0.16154151145418164`}}], 
    ArrowBox[{{0.7642857142857141, 0.3714285714285714}, {0.7644203514076685, 
     0.37474532325053095`}}], 
    ArrowBox[{{0.7642857142857141, 0.6}, {0.7644203514076685, 
     0.6014828863965903}}], 
    ArrowBox[{{0.7642857142857141, 0.8285714285714285}, {0.7644203514076685, 
     0.8294601024642723}}], 
    ArrowBox[{{0.7642857142857141, 1.0571428571428572`}, {0.7644203514076685, 
     1.0577570255773836`}}], 
    ArrowBox[{{0.7642857142857141, 1.2857142857142856`}, {0.7644203514076685, 
     1.2861756281487804`}}], 
    ArrowBox[{{0.7642857142857141, 1.5142857142857142`}, {0.7644203514076685, 
     1.5146515527594904`}}], 
    ArrowBox[{{0.7642857142857141, 1.7428571428571429`}, {0.7644203514076685, 
     1.743158422651774}}], 
    ArrowBox[{{0.7642857142857141, 1.9714285714285713`}, {0.7644203514076685, 
     1.9716836615270397`}}], 
    ArrowBox[{{0.7642857142857141, 2.1999999999999997`}, {0.7644203514076685, 
     2.200220594670567}}], 
    ArrowBox[{{0.8999999999999999, -1.}, {0.9001346371219543, -1.}}], 
    ArrowBox[{{0.8999999999999999, -0.7714285714285715}, {
     0.9001346371219543, -0.7710097003824912}}], 
    ArrowBox[{{0.8999999999999999, -0.5428571428571429}, {
     0.9001346371219543, -0.5411654143663256}}], 
    ArrowBox[{{0.8999999999999999, -0.3142857142857143}, {
     0.9001346371219543, -0.30671487975862666`}}], 
    ArrowBox[{{0.8999999999999999, -0.08571428571428574}, {0.9001346371219543,
      0.04999993321572971}}], 
    ArrowBox[{{0.8999999999999999, 0.14285714285714282`}, {0.9001346371219543,
      0.20392854137564984`}}], 
    ArrowBox[{{0.8999999999999999, 0.3714285714285714}, {0.9001346371219543, 
     0.3822696480886614}}], 
    ArrowBox[{{0.8999999999999999, 0.6}, {0.9001346371219543, 
     0.6048469363903577}}], 
    ArrowBox[{{0.8999999999999999, 0.8285714285714285}, {0.9001346371219543, 
     0.8314761324248652}}], 
    ArrowBox[{{0.8999999999999999, 1.0571428571428572`}, {0.9001346371219543, 
     1.059150317284079}}], 
    ArrowBox[{{0.8999999999999999, 1.2857142857142856`}, {0.9001346371219543, 
     1.2872222214801747`}}], 
    ArrowBox[{{0.8999999999999999, 1.5142857142857142`}, {0.9001346371219543, 
     1.5154814874856137`}}], 
    ArrowBox[{{0.8999999999999999, 1.7428571428571429`}, {0.9001346371219543, 
     1.7438419006940444`}}], 
    ArrowBox[{{0.8999999999999999, 1.9714285714285713`}, {0.9001346371219543, 
     1.9722623544371205`}}], 
    ArrowBox[{{0.8999999999999999, 2.1999999999999997`}, {0.9001346371219543, 
     2.2007210318597226`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, Automatic, None, None},
  PlotRange->{-1, 2},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
F\[UDoubleDot]r Anfangswerte c<-2 werden ebenfalls plausible \
L\[ODoubleDot]sungen im ganzen uns interessierenden Bereich gefunden.\
\>", "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
   3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
   3.36644048070057*^9}, {3.36644051650422*^9, 3.36644053374247*^9}, {
   3.36644056386189*^9, 3.36644057173263*^9}, {3.36644083307155*^9, 
   3.36644083454827*^9}, {3.36644110242705*^9, 3.3664411326857*^9}, {
   3.36644135000811*^9, 3.36644141937365*^9}, 3.36697082949473*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsol3", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "4"}], ",", 
      RowBox[{"-", "2"}], ",", ".3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
  3.36638316883576*^9, 3.36638318466153*^9}, {3.36638321570362*^9, 
  3.36638324157278*^9}, {3.36638343115048*^9, 3.36638345735994*^9}, {
  3.36644114893442*^9, 3.36644115421382*^9}, {3.36644118668446*^9, 
  3.36644120657309*^9}, {3.36644126641416*^9, 3.36644133051094*^9}, {
  3.36644138065606*^9, 3.36644138895105*^9}, {3.3669708223428*^9, 
  3.36697082590289*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol3"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p3", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "2"}]}], "]"}], ",", "myPlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638335890342*^9}, {3.36638348799274*^9, 3.36638351512981*^9}, {
   3.36644121023608*^9, 3.36644127744919*^9}, {3.36644131108589*^9, 
   3.36644132590008*^9}, 3.36697078858893*^9, {3.36697093600771*^9, 
   3.36697093718865*^9}, {3.38270338875001*^9, 3.382703394278992*^9}, {
   3.389325948014017*^9, 3.389325951683944*^9}, 3.389326010040156*^9, {
   3.38933211926872*^9, 3.389332119720041*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2nk0ld/XAHDKkCH3Xg1SlCGFZMoQyq5URAlFpiRFpZJ8RZEhJEMkSuY5
Q4QyC+fJlAwZQ6bMyXSJZErveX7vP/euz1pn3efs85yzz95rXUGLO3qW6xgY
GM7iD/JbEraO//tHR9dExrUi8yjEnSVhn6VlOhrb7hddhJ2dI7Nn7jcdZc3P
/ujAlhU9YzE6QUca23dc25xPIRRpXl31HXS0Lvg7VwD2kaHZ2vAsOho0eMHk
UkAh9J40pB+4REc2OtX+F4oohGOj1+1rZdPoVetmoT8lFKKtjWP84+UpVOtm
+8e2kkLwE3c2K/JNoqiVIb3ftRQi72YlM6V3HIVJ38uYaKIQ5k9lZr55/ETp
Mv1XJtopxGKwsw+CMWR0X+vg1h4KkcjVxxs2MIpcgx1klAcoRJSmjF2r7wh6
XsjI3TJCITxuXb4vdmoYfWcqWcv7SSGc179xtJsaRN6BKRTPKQpx2b1xd3vq
ADI5c0czc4ZCvCwdCYuy7kfCUmGpd+coRPF3Uc4MoT5UVWnow71AIYSpR46d
j+lGccYHbWUWKUSg9ICTdUg3+jmjMaeEvajjkePu041EOeNtj2HXP6/c/dau
G9EO7Tc+h22/6RQri3o3crjZPWaPXb1Vr76A3oVSLpT9zse25r9qsONoF9Lp
29ahsEQh3ov7WA8OdSJr6/n1e5YpxK5m86J93zpR5mO1dfuxnzoqbbj3pROt
nLNYOYBtWTn+mrWoE6U1bu47ir3N7MyARGAnWsy5Z3kR2+U5t6HjwU7kkWft
EoKtsRh1gjOgAxlXHe5Zwf5e9U5AQaEdOZjfSC5doRAPzy0dPyjRjio+CjJW
YG8bOHJDWagdHRZJuVCDrbPa+E6Vqx2ZJPAvtmATstPH1Ee/oo/HuljGsONi
xS0NQ78iHp8wU9oqhbB4kJjmtNCGtL1MZ82x11gmGh5OtiGR08ufLLEjXsj+
ch1sQ+JX/COssVuyPip7fmlDJ64EHLDHVhv9Xuef3IbSz8vLP8HefY5vOsqg
DZmrKd/PwB6ReCmL8lvRgO8xlnlscdfX02Pprcj2aeGHRWybxrw33PGt6EdO
1K2/2It324Ws/FvRboF8guUvhWAv4Nm00bwVrR4wleXFlj4aMWfM1orknCYO
HcZ21o/NXTBpQRfYapYfYRPJWbYCui2IXxkEvbGZFpGE5skWdFDYWM0POzCi
PylaugUJiXg6BWPHfRd8eZy5BVlYf81NwK6+kXQvOLMZsShuNSnHprmmKUgy
NqNrJYNOa9je+aI11D9N6NvRhm7GNQqxPJ1iNDfZhNie71Rixh68lPywsLMJ
nXu8MsaB/f5oYvmx7CYkG1zDz4utxxytfeFSE7qc8LdHFnsvr2ADg3Mjqqo+
WXIFm+q3a6bKqhFlLkxnWGEvLvNv8tdrREEl+yNuYNf0bDfaIt6ICvUcrO9g
X4/bPCL27QvqtbDAE6QQb/Zu+Kun+AVxd22VeY4toUCXeD1Xj0bNHfU/YFtJ
urkV9daj3QHc3GXYsXsoLQ2f6hFnyHgtgc3NI+W4EFmPsp8ayVRj//lj81H9
eD3a0Xu7uQm7vGhaf/xFHZIXPGE+gm14eNpVSqEWbci48InjH4UIlndtVhOo
RVPzURQu7Lr9XLsN2WuRvpnFeSq26k7Jz+59n5HQwoPWzdjC/25vavH+jHgu
86fyY08TUyn2HTXoSLr8W0lsz+NTTUX3P6GJk9kK2tjlGpNn5a58QqunRth1
sBnOTHzJPPMJVVmv69HFfqj/sz5R6BNqy/xrr4/tYDVSE1BfjbYOynmYYl/3
6SUuC1SjH2t+HNbYyU97oIe9Gq3PO5F1E3s4qLvM4HcV4pPk0LmNfTn8W4lW
bRUK5UY+ttjGb74WyttXof4TrB0O2KfrG7LZaioRU8ramAe2X1O9lNf7SiR6
46aZF3ZNW13mWlQlsiJYmx9jn+j9nDF3txJF/uh860Oux3RVau+OSjQjLngy
EFuaWhb37k4FUtxiPReGveV8ZpARTzniXRzQzcB+v8e/+MT6ciTNXGD2Fltn
6dqwDP0j4k42vZFJPj9G8CD7p4/Ixkfwfjb22tiL78UOH9Hsps/OudijLs6S
fO0E8rpxir+EXF8dQ8MN5QSye7Z5Qym2gLC8x/xbAq32Ns6QNq6Z/lr/mEA8
XTtLEPYXbgsXF3kC9QbrK1dg25x9HlYqhhCTeH/7Z+zUec3Jl4wIyRVGxNdi
D4YzHbH5VoZMpC2t67ANhh1/7PQtQ/9aZRfqseGBmYL7WCkySqIvNGJTE/e1
HUspQRzqIzFfsTU1RvbucCtBTKfTtdqxvaZinOcMStCbTa8XSC8qcgsnsZSg
wwOH1DuxB+oX7zJbfUCHZA61dpHrtVBFqdldjM563An7jh34JqFcdakIicgn
yPdj3zRzu5fXUITijww2kd5dfbA7waEI+TW8ZBzEDn2ZnuxSU4giM7acHsZ2
knt++MCtAlSpEfpkjIxn7PZM2pECZLavh+Un9oEozUSBLQXoSrGJF+nJ9Uxs
XGX56A/XZqdxbLNWh7YxSj5SnSjTmcQ+Zmd6MyYnF607mPqWjr1zj9LOLT65
qCxlgTaDvfJtS7O/aS5i9s2yJ517tFHhAXMueth8S34Wew/t2LrzF3IQc6t1
0i/sdVU782r35SCqqMUq6e/3V64dZchBFI0evTnssP7cBsm09+gPz8UV0uzZ
e8PZVt4h99F+5d/k/rjCdNq98R2yXJF6QrqCZ2BtIfEdurZhWwvph24RV4dP
v0Mhm4grC+R51d4ojWKykZpEncMf7NfdIwE/vTJR0/kUsyXsrodbY6MPZKKI
0hvBpLl2qmfrDr5Fu+8IVJF2ME9tKYK3SEfj3t5l7JMj1jx+y+lodAtrP2kn
70hR1bR0FMKaz7GCnbm3XunXhXSU+cBGgTSP9X5T47w3iNWZxZf02DQ9Ttw2
DT2JpwivYvMFCbzv25mGjPpU1UnryOhWBDekovcintakC/97P7IsnoroNRcy
Sfsu2ovXjSQjw81P9/3FLgt/reL2IhkJGZZpkP6l3H76gFoysgjaZUna2EXx
TmTca6Tc6hxJWnzdcs5NkyS0UX9hjbRZonjVLvYkpE5f3rJG5sfjJu2thYlo
9JqGBOll75JFla2JSONnrQFpSdEptpnKBPTkFstN0haf+Xck/ZeAhCpeuZKu
43A7zNkcj658r0kkzfA2S5twi0deu+7kkZbT7r9kLxmPlvberyYdFXTUo8c/
DrV5o1HSneIbAo0CYtBmKVeBf9hHbt/I/jgejV5cfbmfdGpWbYuYRjQyOC2m
TPqBXADP8rooFL63TZf0oMO0koV5JOqU+WVKWrPorGltaQTSGI++Rnq7Knd8
xP1wRGTEO5P2cP+vYl17GKrJX/IiPVHeNmJ9IAxlevcHkC5RfyWuMh2KuO8b
x5De7bd4OlErFAWFT70m/bTe6A5H2ks04U55S/qiLl9u95UX6MtWlmLSk3O/
le5VhqDquS5E+mFoI+ISCUHnN16uIs2plHYi9XEwcrwSVks6qtuj7ujocyS5
4N5IWsLVVLf75HPkXLW9jfQHAYUO+5QgdLHZspN0bl1L1dnmQNQfQ+kn3Ub1
bvYIDkCPzG2GSM/pK/XmnXuKCsxcR0lzR06OjW32R83lJ36Slu2Pnd/R7os+
r3VNkNYVOcdw9pUPuidwZJq0rTULp4fhE9S2994M6aCsIp48Xm80ttnpF+ms
+VvCY11eKOuH9jzpL0oCUjuiPJF43Nxv0tOurcraFz2Qoer1P6Q3VnqffLTz
EVIpz1gkbchtn3QduaHmfR+XSLfvOdoqV+mEEn5Zr5A+p8K1jvHzPcSZIfmX
dGSNDpJ9fQ31LEj+I+3eJtq2o+IwSmf6+z87h5ysvSlnDsZP5HD3QiUqBHyf
RFPtIJjt6/98krPEsJnDEXZ4hzGSrvkzLcbM+hCO6J1bR9rvtg93rJcrUCPR
/5w8G+TC98gd7kmqrSftndF79yd6BLacff/ztWviVvlrHsAgH8REWkPI0djz
sBfsTTViJi3aW6Gt8/AxDFkqs5BmC6Oq8X/wBnkbWVbS43oXFceXngD/x6Mb
SNdufLOv4KAvRJpdZyOdXrOwy8vRD07nJrOTfuqptlk33x+MjFk5Sd9SDdqw
8/dTqB0M3Ej6zFLP6viBQIg+c5hCWjJXbLbA7hm0RnDTSPsofrArNwyC27Vc
m0gvvhiYFF0MAusemS2kr/9ivfbs1XOobXLmId15VnLgt0IwBKRM8pIuYnf+
Wn4vBA6vHttFOm7/ltYsoRew4mMr9L/10clqimp8Aep3+kRI3/7v1Bffhy9h
ueGpGOnzoUN1DmKhsOm1837SKkUun6+0h0Lw/BsZ0kI9PJ90PF+BY8l2BdIz
gqfLxXvDwC7vA5DuOD6KePzCwXd08jjpsmvupUyKERA0bKZJ2v9tbmFfUCQo
iPIYkLZr0s6vOxwFbrQrpqQN58ZyCsejwMVn1YL0HiX+rODjMVCvJHiXNKdp
QYbbbAwoMr67T3rOVffNrZhY8Ld95U7afLBcT/hhHAhcvvucdNvcs+bwljh4
eOdGBGl15os6VLF4mIePif9bf9E/Z/5+jQebo+EFpBOUKuv/k0gA33/85aS3
aD3XGvdIgPlwjgbSq7f3neqQSgS6i/gw6c85l46/802C70X5PIzYh6okKvb2
J8EIrVyEdHb70tEYhdeQ6KQhRzp0KQT8h17D/bBGPdLsHJfLGJWTIa2rzYK0
C5/k4ftByVCtbvYf6atQo2x5OAV+l7CEku7UeVnUHZICAnriqaS1LCwO6o2n
wE2J7mLSso9X5eFVKgTVTg2Q/lcrLcM7mwZZ9iyK68j17vmb9Uz9DYw8+nyG
9OhUrSRLzBsQlhGzJF1PtZSY00yHcI5PL0lHGITvbUjKgNjPhWukua5bJaut
ZMAJhujt67EfPTggUqz7FgqZpBRJX49qEEpZewsjnJZ2pOUHGXc+MsyCZwf0
Z0lLFl+YlU7LguGdcVQm8v0Gv63sX8qCFaXn0qQ54jPk485kQ9TSLTvSqzqG
Pf+ms2Hgnsoa6cVD66sv8LwD1/wxIWbsedHMrCx4Bwo7NDVITzIweV4Kege7
taRfku7NzhJDMu9BnO+DIgt2V5TxJh7j97CqoWJBut2H+a+Nx3vI3+EeQPqL
uUnTztb3cEjt0ijpMiqro6t9DvzdnRrPih1ra1Z5uCAXErw3HGHDjjJly3z5
PRcmfHIdSYdp5L6aYs0DpkNq2aSDBNhvRhvmgbACdTc7tntTHu3vUh64M0Vv
5cC+LL3xUsmhAuC8uEdsI7YZX6HGZssCWA7ru0PaeMMV2VsBBZDh/6qAtF5/
ITNfXwF0bt2kyYV9LOhqhrNbIWxMuuNMwRae+bCkXF4EQldbadzYDxvUvOan
imAJbbhLuv1NHVcmbzG8P/uimbSfZbew4N1iELhQGLqJPM9dy2dYBT6AJN9D
nHBw/FVKCa0uJWAmcyB9G/a2xI8SAWklIFLKIMhL7if3UwUnv5YAX+aZMNIi
Kkb1RRKlQOew9d9O5sPs+wux3aVg27DTi4+MJ7JA85YSgu3xoR8FsHPvw1cR
SwT1DAk6guT+Mvh06XsQArVFowHSH6kd9npjCE487GYVxt6s5nw2SouAjvuO
N0SwnQsjHngsE2B5MvWROPapxG8N2oblYHr8JU5QOJ7HmVZVt8vh1IrcAOmw
657/VDzLIaWsPk0Re2z/fhmxzHJgCKUfUSLzb6H7i/VMFTCfp/PkEHn/NOw1
KcyqgO3UXw5q2LbZq3OSVRVwmsXC7Di5HiHNT193VYCNzx/1E+T+N3QuC2au
BOmRWEF17A1DXwRvm1TC1VlVuiaZfxbvjQmyVsGpLpcFPezpLs1HYXxV8OFD
BeN5Mj+U7tpOka2CppXLFH3yfHp81lo1rYKg07kyF8j8vZE/q/19FfAJsoWY
YFcLVd7zN6uGfXwqdVexT5zhXv877xOc9Fnd+wA78DLb7NLnT3B3fOqWE5k/
7jF8X+v9BB6dR3Odsa1jpos3sNTA+5Qdmq7keHqtHZ9BDUQIDgZ7kuOfew6q
LdSAfcmxyEByfPv8x2CFWvDrKoxMxs4Zn8h6pVkLbG/cZVPJ87o2GB1lVgtl
Uqz1aeTv7W1+kOxdC8PMpqxvyfH338oUt9dCzT2H2Bxy/Har+AGHOhAVW7nw
EfvZpQ536YJ6cEh5s9ZHxjt5CEbr62EHoz7/ALbrg4S/kYP1wDSSBkPYNiG3
nVi5GuCIwdVnP7C1P62377vaAJ9FQ0xmyP0kJX3tKfcXODMQ/GYdI57Pms+Z
sduNEKw0dUQc29t/miPGsxF8GMV7JbBdt52vPRfeCDWp4S5S2Dayu9RRZSNU
xwrVyWHvzTEWqNvYBMJOeuGAzfpjhjfhahP4HRhmNsD+pM2/UYe7GSx/vFD1
xt4sObDVjq8ZKOYhB3yxzTe+Fnixpxk4pIoknmIv10nIdSo3w2KD375gbIlT
h0zMrzRDKmO+SQx2kJpJmm1uM8g3pfsWYBsfDD/x3KAF2HxpB6ewk3kuns0x
b4F3rUVFM9hzCwJGX61bIPkq25F57Kd5qbd43VrgwYVM4xVsJFsYEp/SAh/s
3GrY1lGJ3fs7Bt4ttsCKNPLdiz0luMW1JaIVkkQefrTCPugcf/djUiuIejnW
WWN7tO23zM5sBc2B/7pssLc+OXk6sLwVHl1+xOqIrTrpuF1zvBWcGG7FPMF+
lt+V/1GpDQymr1SkYctoxdGzO9tgTpGB7Rf2wySJodjBNljTLvqwgF39t7A9
cLINnPIY7VewjbObS28xfIXvynq/mdbj529Z/1RU9CvsyLRR2Ybd+t1SNM7x
K9hrPPgG2Pfs911+trUdngZquIZgb2WnlxgItsPO04EW4diFse+37ZRoB7sq
Xu1Y7NVapaaMo+3AqMCvkk7+vqAG1N5qh628L29XYAd+ucrPXNEODMpHlX9j
J4vGfHO60wHfXM4kmDHherLssvwxpw743enx0BL75zmR52yPO6DxeKfZLWwJ
twyNsIgOMA1fU3HCfv+1uCCvqgMOHlk0DMUu8+h4ObOjE9rZw4SbsDt6qHpW
NZ3g+FVfWpOZSmj6W3bat3QC5D55oYtdolRs5tnTCd974hiMsONCr9yMm+mE
s18SZ65hX9fJ9+ra9g0svFKkvbGXK0wKtG98g23N7gqV2HzpyXyK7F3Q73fW
5yQLjs9oJeHE5i5YmTBf0MZm2KAjdn5nF7BnSN2+gD18dUn+rmwXpHMI3LuO
/Xbn6bPpxl1wJ5KV7oetGjz7aFd6F5g6fglqxjZ/cOgH6+luOE+vJCxZqYT4
1Zqv0wbdIK61TtgWe077fOXXy91QKZYY5ITtvftWfKJjN3xQVgp8hp3RGGkC
id3Afqh7UzH2kshKo8NyNyDVHXq0DVQiuKWocCS1B2SNsoZqsE1LT6TU5/SA
TlRkdRu2SGrzy5yyHlgtVcrvxy50+Wn3qK0HXK/nfVjE7hPl3c/P0Av241/M
xdjw/Nzux5+/0AvTHC18AdgV+xT9Kpj7QNBQ570ZO76Ppc4nzlL6wP26r8lN
7EXZuyW7tvfBCbc9tPvYEsrp086SffB0W0H8c+wXGrvOyV3og3ZLY6MqbCtL
Vr7XqX2Q+XlynxQHvg9iO956a30HeqpJKicnrn/YSsaSNPqh+NqOK7MbqcSv
T5LWCWf64c0Db3FGLrw/vOMnYvX6wd40joGGbcD0ZDrCtB8U93B/k8Z+/E93
Psi2Hz5VaRy6iz38+8e/h2H9EE/pap/HThjcxKM/1g9zCVo5rFScz+K9w/Sm
+oF6OuQ6L7ay+RKvzq9+8CK2Su7Dbunt49Na7YcXchvHtbEZv6UJHaUOQJL+
lb2vsM0bQXL/wQHI7eWsEqdRCf6SmyeYfQaAn2fbHzNunO94l5dtAgZAhjPN
3R6b08EnuzN4APYwhezyw16Ver0jI3oAHnWi6DzsrsS+Wb2cAfDYEhO9cRO+
//x1Y+L6BoDvt33JR2wuE8U/KvKDcG7gv3UqW6gES2FVxmvlQfgvYp3ZOey/
m89bUI4MgpPz8+ab2JNfbBsGNQeBT5HGGI1de+xNoq/5IHwSVPNi2Eolnojz
63T4D0LA/irpemyG5XVpdoODoGM5Uu+wDcc39G3O7ccg7K6LdQ/CJuqzVQMm
B8FBdkzrDbZ7rFlbysIg1GraifVh/zte/K+HfQhKvUPXqfNSibVndw3UDwxB
SUPlEf7tOF6R/vV8XkPAW/wuvGcH3q+UAm0x3yHQdum+uYRdshgQrhA4BCs5
AYZb+XA+rFOR0g0bAhXz6Uc62Cu2r4y9M4Ygfu48TzX28gftdzNtQ5DPYGSR
z08l/uiWmlWJDEOEUp1Exi6cv75l9aruG4ZbKZ6KjdhclxNMC6WHYfaaueUv
7D22T4zTVYahtF9wn5IA7vcCdQ2e6w6DUhbjlRrs7NqRMxddhkExky95SpBK
3FDjOvy7bRgsJaV9z+/G9XYtQ4lN1zCcGq1We4jtrjenPPZ9GALPeOxJwg67
3Hmwe3wYUp+KWc5jV7slyH1kGAFlV7/6UBHcP5YoSARIjEBIwQ6boT1Uolvu
0g4RrxGYqUnRiRbD52VJnvLYdwS6HDZFfsaeKeVcPxI4Aj3v2LkXsJnUi8eT
wkeAofyc91lx3E8YbSnenTUCxgkVAUz78Hxc6gx3d42AjbuipqMEjrdaMVRY
ehR0mV5yPJLC8flx+XnKj8KMQqVeDrby2RGXIeVRqFDybxjBPtsZbJl4YhTm
rKvNtKSpxP3xKTlhk1EYHj+1sE2GStRxJbUKeY/CdNzkgTJZXA9eoNKEekYh
wNShU1aBSlikSkWIDIzCNw1J5evY+kvawmKjo7DdD5qisZUjA+SlZ0aB8+u5
CDZFKsH8nd1YlekH7q+fZgxhR1gxJxpL/ADD1l7GBCUqUXlvWS7k4Q+Yk2Cx
OnWYSuRX85aFPvoB1tvt2h5jp/EoqUd4/4BDVX1u5diBRY5G8UF4fG5X4CFV
KmH0d94lK+kHVLyBlwcA15te9Oq6+h9wRnPp8f6jVIL3xbAhE/8YrLh+u3Tu
BL7vPXdttRcag5Y/W7uisQ3sjFuH9o7BFpP41DHsYJ2mMxWyY+B/7vpxt5P4
fG8sOeahMQZZZlae2ep4/z8OkWCwH4P3GrtDhDVxPnI8xrBaOwbS+y93nD1L
JdZdcym92TQGM/r1va+xBQwKnbq/joF+wadTq9gX5SR/F/eP4XpJQf+NDu5X
ZnjHHyyMwb8aqzMcerjfvjHb+kfwJ1QtZJkNnKcSmSZxKXP3fwKi3fo5aEwl
5DqEl1lcf4LZwZv6R0yoxAe9lNPbPX/CypilZAx2zanM2SMBP8GqVlDcxJRK
DCmWqATG/4RHpa6mXRdxPb+5s1G09idU9u/RmjbH56mesnhxxzgIVJ98e/ca
zt8aIZp3BcbhyOCaRB/2s4qt0V4i42Czb9MBreu4HyzmP5YuNQ7Rhxu+7rlB
JQpS9z1dVBuHsLfsgcPWOD95qQuE3BqHM6co6U42VOLCYTeNmtJxYJMqB14H
KtHze5RSXj4OBzhfsoRiW2Rqd3z4NA4/D6jYbnKkErd27bTKah4HO3cJGep9
PD/GUs/QkXE41NMUQHPC61G1XHZ14wRIbQpplXPF50XbQZ7x4gR80LrzhPUJ
7vdY+laXL09Am/RFg0hsCjpROW81AS6TbQtSPlRiu/SWc2O2E1B3qSTHxJdK
SHHn2jZ6TYAuo6t+qT+ux9pn06MzJsBOgrb8JohKvDO7LaS8OgGWwxtcVCPx
fPNm+OMYJ+E5Un73D3szpz0vC+skoA5CqjyKSjgUOVFbaJPQrbCfVysGn4fN
Pms39k7CHzqN/XY8lSj/nNAVrjcJzw7e6Z5PoRL/Cexp/3dhEnb3f3pUn4rr
Vce0ZsuLk0C/pPT+dRpZP2TXyFyfBMlqpirTdCqh5Vaa/9llEp5AoEpfJpVo
k+sMXkrFz7OKq5XNx/elv0ngpcxJ0D5kbiNSQCUUBvt8q3ImobKUf5a3EOev
ZyPuz8smwf1SZvqGYrwfx3/ZiLVNQqHRdPTfUtyPxW7UMvo3CcC8r1SzGtcD
7Grri/SnQJs3eVtUJ5XgnuZ6UW48BVIvTsp+/EYl9jV37a6/NAVvLr54MdaF
64lXdie/35iCU9saT6r24npDOMGX2XUKJBuHxpkH8fk9xEjVS56C5yaxTuyT
VCJ1V0OcSfoU1FY0WBtM4X54XbiMZfYUsFuz/Eqaxvm4Rvrc/eIpcM/Y/+3U
LH4/+uahMV+mQDHDISRnAddDNohvYmEK+jNZGTnW0QhVXf+38ytToLMS/NZj
PY0wlLugusYwDYr3HsNfJhrhtzx9icYxDUf3K+5dYaURM947ExV3TYOW7kzg
di4aURLrIualPg1Kj75smNxOI/SaVRT4w6Yh8sjQ9IoCjXilJ7wSHD0NHQo3
WdYp0YieVnZiQ+I0yHhGHOZUoRFW7d9Ozb+dhpuZA8L7gUY4dzterKuYhuNH
cl3j1WlE0kiO1wP6NDR3Pxg0MqIRP60iT9Hnp8GSd7g/yYRGSI55cFkuT0PL
FLKYv0gjCsd1w3SY6XBtoowt3oJGNNDp6Xt30KFO/GGIzC0asbC0r/XrSTqU
Hl/PIe9OI1ScN4VpnabDra9zEnUeNMJ9ddn0oy4d3h8WULB6TCPY/30ezTCl
g6TILp50Pxqxi+n6sqcdHWSOXii3fUkjNLiSBGVj6PBOkZCdTacR4UJ8toG/
6cBwd1b4Vw+N4ORgUijEvhIWNMLeSyNc5yZWBrBtGZxThbEtKj88kV+gg1SZ
jKw+toSVSWwPdpGgqH4hdllaxBfxRTp0bz72zbWPRgxL8+7/tEyHs+yOXZz9
NMKAl3FuBtveOqRKBLuG8Wfh9hU6XL2++k4V+21L4XEb7FM3cgNtsR3sDU23
rNIhIrv0Qhs2W+Er/yt/6XBsQFU0aoBGPIxz0w3AVlcRF83Dnva5xlOAnTxg
IfYFu8VIMZF9jQ48UCLFMEgjolbai99hH7ehnr6KzTVc5t6N/cr0moELtnt9
8knmf3QImOawCMW2jHZoMcRmFlN1qcHufGwW5oFt+KPu6QC2ps1JswzsX/Yp
0cvYJQaSu9uxi3uasjYN4ff9//9vgkgxjQoJ7P8DsE5DiA==
      "]], LineBox[CompressedData["
1:eJwt2nk0Vd/bAHAVCd3rpkHKLLMkhVCeqJBkqhBNFM1SiWQeEhmjTMlMlDEZ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      "]], LineBox[CompressedData["
1:eJwt2nc01f//AHAlI/caaUgoNIwklVHEs5RICEnKTJGIpKKyRyKFJCShbLKy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      "]], LineBox[CompressedData["
1:eJwt2nk01N/7AHAtmBlrPpUUQskuqYjKk0pEFEnWolBpJaHFElKSJZWQ7EJk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      "]], LineBox[CompressedData["
1:eJwt2nk0Vd/bAHCUexFCSso8JFJRhlAelSiiqCSVUIaEylckY0hKhErIPEum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      "]], LineBox[CompressedData["
1:eJwt2nk4Vd/XAHByL1JJEynJWJFQmVJZlTKVMpTMUkqjryRDxpAyJCEhmcfM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      "]], LineBox[CompressedData["
1:eJwt2nc81f/3AHD3GhkZKU2rJSQto6hOiJQRKlkJRbvURyREVvbO3rtkkxFe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      "]]}}, 
   {Thickness[Small], Arrowheads[0.02], 
    ArrowBox[{{-1., -5.}, {-0.9399083861668724, -5.00480732910665}}], 
    ArrowBox[{{-1., -4.785714285714286}, {-0.9399083861668724, \
-4.790680645422927}}], 
    ArrowBox[{{-1., -4.571428571428571}, {-0.9399083861668724, \
-4.576563352884039}}], 
    ArrowBox[{{-1., -4.357142857142857}, {-0.9399083861668724, \
-4.362455982902357}}], 
    ArrowBox[{{-1., -4.142857142857143}, {-0.9399083861668724, \
-4.148358990972661}}], 
    ArrowBox[{{-1., -3.9285714285714284`}, {-0.9399083861668724, \
-3.93427268251196}}], 
    ArrowBox[{{-1., -3.7142857142857144`}, {-0.9399083861668724, \
-3.7201970934571684`}}], 
    ArrowBox[{{-1., -3.5}, {-0.9399083861668724, -3.506131797329911}}], 
    ArrowBox[{{-1., -3.2857142857142856`}, {-0.9399083861668724, \
-3.2920755907703443`}}], 
    ArrowBox[{{-1., -3.0714285714285716`}, {-0.9399083861668724, \
-3.0780259741371303`}}], 
    ArrowBox[{{-1., -2.857142857142857}, {-0.9399083861668724, \
-2.8639782782163756`}}], 
    ArrowBox[{{-1., -2.642857142857143}, {-0.9399083861668724, \
-2.6499241624532957`}}], 
    ArrowBox[{{-1., -2.4285714285714284`}, {-0.9399083861668724, \
-2.435848959658485}}], 
    ArrowBox[{{-1., -2.2142857142857144`}, {-0.9399083861668724, \
-2.2217268194325843`}}], 
    ArrowBox[{{-1., -2.}, {-0.9399083861668724, -2.007511451729141}}], 
    ArrowBox[{{-0.8642857142857143, -5.}, {-0.8041941004525868, \
-5.003852441458701}}], 
    ArrowBox[{{-0.8642857142857143, -4.785714285714286}, \
{-0.8041941004525868, -4.789694169266241}}], 
    ArrowBox[{{-0.8642857142857143, -4.571428571428571}, \
{-0.8041941004525868, -4.5755434228401475`}}], 
    ArrowBox[{{-0.8642857142857143, -4.357142857142857}, \
{-0.8041941004525868, -4.361400628037484}}], 
    ArrowBox[{{-0.8642857142857143, -4.142857142857143}, \
{-0.8041941004525868, -4.147266149877357}}], 
    ArrowBox[{{-0.8642857142857143, -3.9285714285714284`}, \
{-0.8041941004525868, -3.933140233111293}}], 
    ArrowBox[{{-0.8642857142857143, -3.7142857142857144`}, \
{-0.8041941004525868, -3.719022906538}}], 
    ArrowBox[{{-0.8642857142857143, -3.5}, {-0.8041941004525868, \
-3.5049138283912002`}}], 
    ArrowBox[{{-0.8642857142857143, -3.2857142857142856`}, \
{-0.8041941004525868, -3.290812034336385}}], 
    ArrowBox[{{-0.8642857142857143, -3.0714285714285716`}, \
{-0.8041941004525868, -3.0767155212400663`}}], 
    ArrowBox[{{-0.8642857142857143, -2.857142857142857}, \
{-0.8041941004525868, -2.8626205473419475`}}], 
    ArrowBox[{{-0.8642857142857143, -2.642857142857143}, \
{-0.8041941004525868, -2.6485204287852917`}}], 
    ArrowBox[{{-0.8642857142857143, -2.4285714285714284`}, \
{-0.8041941004525868, -2.4344034117485274`}}], 
    ArrowBox[{{-0.8642857142857143, -2.2142857142857144`}, \
{-0.8041941004525868, -2.2202487805394266`}}], 
    ArrowBox[{{-0.8642857142857143, -2.}, {-0.8041941004525868, \
-2.0060194397792204`}}], 
    ArrowBox[{{-0.7285714285714286, -5.}, {-0.6684798147383011, \
-5.002952506022762}}], 
    ArrowBox[{{-0.7285714285714286, -4.785714285714286}, \
{-0.6684798147383011, -4.788764463188235}}], 
    ArrowBox[{{-0.7285714285714286, -4.571428571428571}, \
{-0.6684798147383011, -4.5745821880910675`}}], 
    ArrowBox[{{-0.7285714285714286, -4.357142857142857}, \
{-0.6684798147383011, -4.360406007107546}}], 
    ArrowBox[{{-0.7285714285714286, -4.142857142857143}, \
{-0.6684798147383011, -4.146236199987831}}], 
    ArrowBox[{{-0.7285714285714286, -3.9285714285714284`}, \
{-0.6684798147383011, -3.932072954309167}}], 
    ArrowBox[{{-0.7285714285714286, -3.7142857142857144`}, \
{-0.6684798147383011, -3.717916292142846}}], 
    ArrowBox[{{-0.7285714285714286, -3.5}, {-0.6684798147383011, \
-3.5037659515596453`}}], 
    ArrowBox[{{-0.7285714285714286, -3.2857142857142856`}, \
{-0.6684798147383011, -3.2896211934948782`}}], 
    ArrowBox[{{-0.7285714285714286, -3.0714285714285716`}, \
{-0.6684798147383011, -3.075480482749696}}], 
    ArrowBox[{{-0.7285714285714286, -2.857142857142857}, \
{-0.6684798147383011, -2.861340951643972}}], 
    ArrowBox[{{-0.7285714285714286, -2.642857142857143}, \
{-0.6684798147383011, -2.6471974776787706`}}], 
    ArrowBox[{{-0.7285714285714286, -2.4285714285714284`}, \
{-0.6684798147383011, -2.4330410527408346`}}], 
    ArrowBox[{{-0.7285714285714286, -2.2142857142857144`}, \
{-0.6684798147383011, -2.218855800351124}}], 
    ArrowBox[{{-0.7285714285714286, -2.}, {-0.6684798147383011, \
-2.004613290660566}}], 
    ArrowBox[{{-0.5928571428571429, -5.}, {-0.5327655290240153, \
-5.0021215688799305`}}], 
    ArrowBox[{{-0.5928571428571429, -4.785714285714286}, \
{-0.5327655290240153, -4.78790603792651}}], 
    ArrowBox[{{-0.5928571428571429, -4.571428571428571}, \
{-0.5327655290240153, -4.57369465147}}], 
    ArrowBox[{{-0.5928571428571429, -4.357142857142857}, \
{-0.5327655290240153, -4.359487644033132}}], 
    ArrowBox[{{-0.5928571428571429, -4.142857142857143}, \
{-0.5327655290240153, -4.14528521663471}}], 
    ArrowBox[{{-0.5928571428571429, -3.9285714285714284`}, \
{-0.5327655290240153, -3.931087504061263}}], 
    ArrowBox[{{-0.5928571428571429, -3.7142857142857144`}, \
{-0.5327655290240153, -3.716894522172463}}], 
    ArrowBox[{{-0.5928571428571429, -3.5}, {-0.5327655290240153, \
-3.5027060827550134`}}], 
    ArrowBox[{{-0.5928571428571429, -3.2857142857142856`}, \
{-0.5327655290240153, -3.288521654742549}}], 
    ArrowBox[{{-0.5928571428571429, -3.0714285714285716`}, \
{-0.5327655290240153, -3.0743401349941872`}}], 
    ArrowBox[{{-0.5928571428571429, -2.857142857142857}, \
{-0.5327655290240153, -2.8601594628940084`}}], 
    ArrowBox[{{-0.5928571428571429, -2.642857142857143}, \
{-0.5327655290240153, -2.645975957591153}}], 
    ArrowBox[{{-0.5928571428571429, -2.4285714285714284`}, \
{-0.5327655290240153, -2.4317831461664787`}}], 
    ArrowBox[{{-0.5928571428571429, -2.2142857142857144`}, \
{-0.5327655290240153, -2.2175696203303517`}}], 
    ArrowBox[{{-0.5928571428571429, -2.}, {-0.5327655290240153, \
-2.0033149513748914`}}], 
    ArrowBox[{{-0.4571428571428572, -5.}, {-0.3970512433097296, \
-5.0013789089650444`}}], 
    ArrowBox[{{-0.4571428571428572, -4.785714285714286}, \
{-0.3970512433097296, -4.787138810179734}}], 
    ArrowBox[{{-0.4571428571428572, -4.571428571428571}, \
{-0.3970512433097296, -4.572901405100952}}], 
    ArrowBox[{{-0.4571428571428572, -4.357142857142857}, \
{-0.3970512433097296, -4.358666846156226}}], 
    ArrowBox[{{-0.4571428571428572, -4.142857142857143}, \
{-0.3970512433097296, -4.144435263997281}}], 
    ArrowBox[{{-0.4571428571428572, -3.9285714285714284`}, \
{-0.3970512433097296, -3.93020674622832}}], 
    ArrowBox[{{-0.4571428571428572, -3.7142857142857144`}, \
{-0.3970512433097296, -3.7159813031573026`}}], 
    ArrowBox[{{-0.4571428571428572, -3.5}, {-0.3970512433097296, \
-3.501758812455414}}], 
    ArrowBox[{{-0.4571428571428572, -3.2857142857142856`}, \
{-0.3970512433097296, -3.287538928957256}}], 
    ArrowBox[{{-0.4571428571428572, -3.0714285714285716`}, \
{-0.3970512433097296, -3.0733209356788698`}}], 
    ArrowBox[{{-0.4571428571428572, -2.857142857142857}, \
{-0.3970512433097296, -2.85910349332753}}], 
    ArrowBox[{{-0.4571428571428572, -2.642857142857143}, \
{-0.3970512433097296, -2.644884209542426}}], 
    ArrowBox[{{-0.4571428571428572, -2.4285714285714284`}, \
{-0.3970512433097296, -2.4306588772641864`}}], 
    ArrowBox[{{-0.4571428571428572, -2.2142857142857144`}, \
{-0.3970512433097296, -2.2164200817003907`}}], 
    ArrowBox[{{-0.4571428571428572, -2.}, {-0.3970512433097296, \
-2.0021545452578824`}}], 
    ArrowBox[{{-0.3214285714285715, -5.}, {-0.2613369575954439, \
-5.000751725207797}}], 
    ArrowBox[{{-0.3214285714285715, -4.785714285714286}, \
{-0.2613369575954439, -4.786490878641699}}], 
    ArrowBox[{{-0.3214285714285715, -4.571428571428571}, \
{-0.2613369575954439, -4.572231500575082}}], 
    ArrowBox[{{-0.3214285714285715, -4.357142857142857}, \
{-0.2613369575954439, -4.357973674105249}}], 
    ArrowBox[{{-0.3214285714285715, -4.142857142857143}, \
{-0.2613369575954439, -4.143717470458219}}], 
    ArrowBox[{{-0.3214285714285715, -3.9285714285714284`}, \
{-0.2613369575954439, -3.929462937392245}}], 
    ArrowBox[{{-0.3214285714285715, -3.7142857142857144`}, \
{-0.2613369575954439, -3.7152100805268105`}}], 
    ArrowBox[{{-0.3214285714285715, -3.5}, {-0.2613369575954439, \
-3.50095883317321}}], 
    ArrowBox[{{-0.3214285714285715, -3.2857142857142856`}, \
{-0.2613369575954439, -3.2867090071612757`}}], 
    ArrowBox[{{-0.3214285714285715, -3.0714285714285716`}, \
{-0.2613369575954439, -3.0724602116204505`}}], 
    ArrowBox[{{-0.3214285714285715, -2.857142857142857}, \
{-0.2613369575954439, -2.858211716422693}}], 
    ArrowBox[{{-0.3214285714285715, -2.642857142857143}, \
{-0.2613369575954439, -2.6439622173499777`}}], 
    ArrowBox[{{-0.3214285714285715, -2.4285714285714284`}, \
{-0.2613369575954439, -2.4297094208842696`}}], 
    ArrowBox[{{-0.3214285714285715, -2.2142857142857144`}, \
{-0.2613369575954439, -2.2154492847816534`}}], 
    ArrowBox[{{-0.3214285714285715, -2.}, {-0.2613369575954439, \
-2.001174570637182}}], 
    ArrowBox[{{-0.18571428571428578`, -5.}, {-0.12562267188115817`, \
-5.000279669059905}}], 
    ArrowBox[{{-0.18571428571428578`, -4.785714285714286}, \
{-0.12562267188115817`, -4.78600320646842}}], 
    ArrowBox[{{-0.18571428571428578`, -4.571428571428571}, \
{-0.12562267188115817`, -4.571727290212039}}], 
    ArrowBox[{{-0.18571428571428578`, -4.357142857142857}, \
{-0.12562267188115817`, -4.357451951205974}}], 
    ArrowBox[{{-0.18571428571428578`, -4.142857142857143}, \
{-0.12562267188115817`, -4.1431772159488895`}}], 
    ArrowBox[{{-0.18571428571428578`, -3.9285714285714284`}, \
{-0.12562267188115817`, -3.9289031022085883`}}], 
    ArrowBox[{{-0.18571428571428578`, -3.7142857142857144`}, \
{-0.12562267188115817`, -3.7146296120757234`}}], 
    ArrowBox[{{-0.18571428571428578`, -3.5}, {-0.12562267188115817`, \
-3.5003567207396746`}}], 
    ArrowBox[{{-0.18571428571428578`, -3.2857142857142856`}, \
{-0.12562267188115817`, -3.286084358194311}}], 
    ArrowBox[{{-0.18571428571428578`, -3.0714285714285716`}, \
{-0.12562267188115817`, -3.0718123790215994`}}], 
    ArrowBox[{{-0.18571428571428578`, -2.857142857142857}, \
{-0.12562267188115817`, -2.8575405115874095`}}], 
    ArrowBox[{{-0.18571428571428578`, -2.642857142857143}, \
{-0.12562267188115817`, -2.6432682706753012`}}], 
    ArrowBox[{{-0.18571428571428578`, -2.4285714285714284`}, \
{-0.12562267188115817`, -2.428994803013326}}], 
    ArrowBox[{{-0.18571428571428578`, -2.2142857142857144`}, \
{-0.12562267188115817`, -2.214718604740042}}], 
    ArrowBox[{{-0.18571428571428578`, -2.}, {-0.12562267188115817`, \
-2.0004369829061015`}}], 
    ArrowBox[{{-0.05000000000000007, -5.}, {
     0.010091613833127532`, -5.000022892043365}}], 
    ArrowBox[{{-0.05000000000000007, -4.785714285714286}, {
     0.010091613833127532`, -4.785737935046232}}], 
    ArrowBox[{{-0.05000000000000007, -4.571428571428571}, {
     0.010091613833127532`, -4.571453022768836}}], 
    ArrowBox[{{-0.05000000000000007, -4.357142857142857}, {
     0.010091613833127532`, -4.357168157741712}}], 
    ArrowBox[{{-0.05000000000000007, -4.142857142857143}, {
     0.010091613833127532`, -4.142883342133884}}], 
    ArrowBox[{{-0.05000000000000007, -3.9285714285714284`}, {
     0.010091613833127532`, -3.9285985773997165`}}], 
    ArrowBox[{{-0.05000000000000007, -3.7142857142857144`}, {
     0.010091613833127532`, -3.7143138637103403`}}], 
    ArrowBox[{{-0.05000000000000007, -3.5}, {
     0.010091613833127532`, -3.500029199034904}}], 
    ArrowBox[{{-0.05000000000000007, -3.2857142857142856`}, {
     0.010091613833127532`, -3.2857445776431238`}}], 
    ArrowBox[{{-0.05000000000000007, -3.0714285714285716`}, {
     0.010091613833127532`, -3.0714599876319455`}}], 
    ArrowBox[{{-0.05000000000000007, -2.857142857142857}, {
     0.010091613833127532`, -2.8571754067670168`}}], 
    ArrowBox[{{-0.05000000000000007, -2.642857142857143}, {
     0.010091613833127532`, -2.64289079533141}}], 
    ArrowBox[{{-0.05000000000000007, -2.4285714285714284`}, {
     0.010091613833127532`, -2.4286060834813665`}}], 
    ArrowBox[{{-0.05000000000000007, -2.2142857142857144`}, {
     0.010091613833127532`, -2.214321148119747}}], 
    ArrowBox[{{-0.05000000000000007, -2.}, {
     0.010091613833127532`, -2.000035768817758}}], 
    ArrowBox[{{0.08571428571428563, -5.}, {
     0.14580589954741324`, -5.000077260646357}}], 
    ArrowBox[{{0.08571428571428563, -4.785714285714286}, {
     0.14580589954741324`, -4.785794102209603}}], 
    ArrowBox[{{0.08571428571428563, -4.571428571428571}, {
     0.14580589954741324`, -4.571511094701963}}], 
    ArrowBox[{{0.08571428571428563, -4.357142857142857}, {
     0.14580589954741324`, -4.3572282466639916`}}], 
    ArrowBox[{{0.08571428571428563, -4.142857142857143}, {
     0.14580589954741324`, -4.1429455654161425`}}], 
    ArrowBox[{{0.08571428571428563, -3.9285714285714284`}, {
     0.14580589954741324`, -3.928663055866901}}], 
    ArrowBox[{{0.08571428571428563, -3.7142857142857144`}, {
     0.14580589954741324`, -3.714380718593827}}], 
    ArrowBox[{{0.08571428571428563, -3.5}, {
     0.14580589954741324`, -3.500098546742802}}], 
    ArrowBox[{{0.08571428571428563, -3.2857142857142856`}, {
     0.14580589954741324`, -3.285816520974115}}], 
    ArrowBox[{{0.08571428571428563, -3.0714285714285716`}, {
     0.14580589954741324`, -3.0715346011149594`}}], 
    ArrowBox[{{0.08571428571428563, -2.857142857142857}, {
     0.14580589954741324`, -2.857252712124396}}], 
    ArrowBox[{{0.08571428571428563, -2.642857142857143}, {
     0.14580589954741324`, -2.642970719957795}}], 
    ArrowBox[{{0.08571428571428563, -2.4285714285714284`}, {
     0.14580589954741324`, -2.4286883888924704`}}], 
    ArrowBox[{{0.08571428571428563, -2.2142857142857144`}, {
     0.14580589954741324`, -2.2144053034755746`}}], 
    ArrowBox[{{0.08571428571428563, -2.}, {
     0.14580589954741324`, -2.0001207197599324`}}], 
    ArrowBox[{{0.22142857142857134`, -5.}, {
     0.2815201852616989, -5.0006054840460665`}}], 
    ArrowBox[{{0.22142857142857134`, -4.785714285714286}, {
     0.2815201852616989, -4.786339799695938}}], 
    ArrowBox[{{0.22142857142857134`, -4.571428571428571}, {
     0.2815201852616989, -4.572075298162346}}], 
    ArrowBox[{{0.22142857142857134`, -4.357142857142857}, {
     0.2815201852616989, -4.357812046376786}}], 
    ArrowBox[{{0.22142857142857134`, -4.142857142857143}, {
     0.2815201852616989, -4.1435501017089145`}}], 
    ArrowBox[{{0.22142857142857134`, -3.9285714285714284`}, {
     0.2815201852616989, -3.9292895026260615`}}], 
    ArrowBox[{{0.22142857142857134`, -3.7142857142857144`}, {
     0.2815201852616989, -3.7150302536544912`}}], 
    ArrowBox[{{0.22142857142857134`, -3.5}, {
     0.2815201852616989, -3.500772301079167}}], 
    ArrowBox[{{0.22142857142857134`, -3.2857142857142856`}, {
     0.2815201852616989, -3.2865154933366805`}}], 
    ArrowBox[{{0.22142857142857134`, -3.0714285714285716`}, {
     0.2815201852616989, -3.0722595155967136`}}], 
    ArrowBox[{{0.22142857142857134`, -2.857142857142857}, {
     0.2815201852616989, -2.8580037797708586`}}], 
    ArrowBox[{{0.22142857142857134`, -2.642857142857143}, {
     0.2815201852616989, -2.6437472353646005`}}], 
    ArrowBox[{{0.22142857142857134`, -2.4285714285714284`}, {
     0.2815201852616989, -2.4294880350425503`}}], 
    ArrowBox[{{0.22142857142857134`, -2.2142857142857144`}, {
     0.2815201852616989, -2.215222922941827}}], 
    ArrowBox[{{0.22142857142857134`, -2.}, {
     0.2815201852616989, -2.0009460688219796`}}], 
    ArrowBox[{{0.35714285714285704`, -5.}, {
     0.41723447097598465`, -5.001907670280417}}], 
    ArrowBox[{{0.35714285714285704`, -4.785714285714286}, {
     0.41723447097598465`, -4.787685063376445}}], 
    ArrowBox[{{0.35714285714285704`, -4.571428571428571}, {
     0.41723447097598465`, -4.573466183117249}}], 
    ArrowBox[{{0.35714285714285704`, -4.357142857142857}, {
     0.41723447097598465`, -4.359251240380754}}], 
    ArrowBox[{{0.35714285714285704`, -4.142857142857143}, {
     0.41723447097598465`, -4.1450404159188565`}}], 
    ArrowBox[{{0.35714285714285704`, -3.9285714285714284`}, {
     0.41723447097598465`, -3.930833830928782}}], 
    ArrowBox[{{0.35714285714285704`, -3.7142857142857144`}, {
     0.41723447097598465`, -3.716631499671212}}], 
    ArrowBox[{{0.35714285714285704`, -3.5}, {
     0.41723447097598465`, -3.502433252908695}}], 
    ArrowBox[{{0.35714285714285704`, -3.2857142857142856`}, {
     0.41723447097598465`, -3.2882386131174837`}}], 
    ArrowBox[{{0.35714285714285704`, -3.0714285714285716`}, {
     0.41723447097598465`, -3.0740465883764125`}}], 
    ArrowBox[{{0.35714285714285704`, -2.857142857142857}, {
     0.41723447097598465`, -2.8598553258228248`}}], 
    ArrowBox[{{0.35714285714285704`, -2.642857142857143}, {
     0.41723447097598465`, -2.645661515712759}}], 
    ArrowBox[{{0.35714285714285704`, -2.4285714285714284`}, {
     0.41723447097598465`, -2.4314593377329587`}}], 
    ArrowBox[{{0.35714285714285704`, -2.2142857142857144`}, {
     0.41723447097598465`, -2.2172385337884406`}}], 
    ArrowBox[{{0.35714285714285704`, -2.}, {
     0.41723447097598465`, -2.002980734813151}}], 
    ArrowBox[{{0.49285714285714277`, -5.}, {
     0.5529487566902703, -5.004605169794117}}], 
    ArrowBox[{{0.49285714285714277`, -4.785714285714286}, {
     0.5529487566902703, -4.790471798505601}}], 
    ArrowBox[{{0.49285714285714277`, -4.571428571428571}, {
     0.5529487566902703, -4.576347423442551}}], 
    ArrowBox[{{0.49285714285714277`, -4.357142857142857}, {
     0.5529487566902703, -4.362232553670217}}], 
    ArrowBox[{{0.49285714285714277`, -4.142857142857143}, {
     0.5529487566902703, -4.14812762552877}}], 
    ArrowBox[{{0.49285714285714277`, -3.9285714285714284`}, {
     0.5529487566902703, -3.9340329315917244`}}], 
    ArrowBox[{{0.49285714285714277`, -3.7142857142857144`}, {
     0.5529487566902703, -3.7199485062847675`}}], 
    ArrowBox[{{0.49285714285714277`, -3.5}, {
     0.5529487566902703, -3.505873941063925}}], 
    ArrowBox[{{0.49285714285714277`, -3.2857142857142856`}, {
     0.5529487566902703, -3.2918080831734198`}}], 
    ArrowBox[{{0.49285714285714277`, -3.0714285714285716`}, {
     0.5529487566902703, -3.0777485380876155`}}], 
    ArrowBox[{{0.49285714285714277`, -2.857142857142857}, {
     0.5529487566902703, -2.8636908329438673`}}], 
    ArrowBox[{{0.49285714285714277`, -2.642857142857143}, {
     0.5529487566902703, -2.649626977927019}}], 
    ArrowBox[{{0.49285714285714277`, -2.4285714285714284`}, {
     0.5529487566902703, -2.435542922636917}}], 
    ArrowBox[{{0.49285714285714277`, -2.2142857142857144`}, {
     0.5529487566902703, -2.2214139037433096`}}], 
    ArrowBox[{{0.49285714285714277`, -2.}, {
     0.5529487566902703, -2.0071955778033077`}}], 
    ArrowBox[{{0.6285714285714284, -5.}, {
     0.688663042404556, -5.010227460604917}}], 
    ArrowBox[{{0.6285714285714284, -4.785714285714286}, {
     0.688663042404556, -4.796280079555967}}], 
    ArrowBox[{{0.6285714285714284, -4.571428571428571}, {
     0.688663042404556, -4.582352677909654}}], 
    ArrowBox[{{0.6285714285714284, -4.357142857142857}, {
     0.688663042404556, -4.3684463862311995`}}], 
    ArrowBox[{{0.6285714285714284, -4.142857142857143}, {
     0.688663042404556, -4.154562173573234}}], 
    ArrowBox[{{0.6285714285714284, -3.9285714285714284`}, {
     0.688663042404556, -3.9407006897020533`}}], 
    ArrowBox[{{0.6285714285714284, -3.7142857142857144`}, {
     0.688663042404556, -3.7268620110724564`}}], 
    ArrowBox[{{0.6285714285714284, -3.5}, {
     0.688663042404556, -3.513045230363415}}], 
    ArrowBox[{{0.6285714285714284, -3.2857142857142856`}, {
     0.688663042404556, -3.299247787459923}}], 
    ArrowBox[{{0.6285714285714284, -3.0714285714285716`}, {
     0.688663042404556, -3.0854643644437028`}}], 
    ArrowBox[{{0.6285714285714284, -2.857142857142857}, {
     0.688663042404556, -2.871685027690474}}], 
    ArrowBox[{{0.6285714285714284, -2.642857142857143}, {
     0.688663042404556, -2.6578920328990683`}}], 
    ArrowBox[{{0.6285714285714284, -2.4285714285714284`}, {
     0.688663042404556, -2.4440541760269694`}}], 
    ArrowBox[{{0.6285714285714284, -2.2142857142857144`}, {
     0.688663042404556, -2.230116461059715}}], 
    ArrowBox[{{0.6285714285714284, -2.}, {
     0.688663042404556, -2.0159804071951832`}}], 
    ArrowBox[{{0.7642857142857141, -5.}, {
     0.8243773281188417, -5.023826454953263}}], 
    ArrowBox[{{0.7642857142857141, -4.785714285714286}, {
     0.8243773281188417, -4.810328940391443}}], 
    ArrowBox[{{0.7642857142857141, -4.571428571428571}, {
     0.8243773281188417, -4.596877970945301}}], 
    ArrowBox[{{0.7642857142857141, -4.357142857142857}, {
     0.8243773281188417, -4.383476180441781}}], 
    ArrowBox[{{0.7642857142857141, -4.142857142857143}, {
     0.8243773281188417, -4.170125826439207}}], 
    ArrowBox[{{0.7642857142857141, -3.9285714285714284`}, {
     0.8243773281188417, -3.9568284226688935`}}], 
    ArrowBox[{{0.7642857142857141, -3.7142857142857144`}, {
     0.8243773281188417, -3.7435841472441465`}}], 
    ArrowBox[{{0.7642857142857141, -3.5}, {
     0.8243773281188417, -3.530390886419979}}], 
    ArrowBox[{{0.7642857142857141, -3.2857142857142856`}, {
     0.8243773281188417, -3.3172426760116096`}}], 
    ArrowBox[{{0.7642857142857141, -3.0714285714285716`}, {
     0.8243773281188417, -3.1041271271040207`}}], 
    ArrowBox[{{0.7642857142857141, -2.857142857142857}, {
     0.8243773281188417, -2.8910210977795283`}}], 
    ArrowBox[{{0.7642857142857141, -2.642857142857143}, {
     0.8243773281188417, -2.6778832499378167`}}], 
    ArrowBox[{{0.7642857142857141, -2.4285714285714284`}, {
     0.8243773281188417, -2.464640888924552}}], 
    ArrowBox[{{0.7642857142857141, -2.2142857142857144`}, {
     0.8243773281188417, -2.251165892998492}}], 
    ArrowBox[{{0.7642857142857141, -2.}, {
     0.8243773281188417, -2.037228835864474}}], 
    ArrowBox[{{0.8999999999999999, -5.}, {
     0.9600916138331275, -5.077878731527734}}], 
    ArrowBox[{{0.8999999999999999, -4.785714285714286}, {
     0.9600916138331275, -4.866169312994273}}], 
    ArrowBox[{{0.8999999999999999, -4.571428571428571}, {
     0.9600916138331275, -4.654612031007144}}], 
    ArrowBox[{{0.8999999999999999, -4.357142857142857}, {
     0.9600916138331275, -4.443215494446754}}], 
    ArrowBox[{{0.8999999999999999, -4.142857142857143}, {
     0.9600916138331275, -4.231987082328538}}], 
    ArrowBox[{{0.8999999999999999, -3.9285714285714284`}, {
     0.9600916138331275, -4.020931742408037}}], 
    ArrowBox[{{0.8999999999999999, -3.7142857142857144`}, {
     0.9600916138331275, -3.810050056863271}}], 
    ArrowBox[{{0.8999999999999999, -3.5}, {
     0.9600916138331275, -3.599335116744558}}], 
    ArrowBox[{{0.8999999999999999, -3.2857142857142856`}, {
     0.9600916138331275, -3.3887674276224393`}}], 
    ArrowBox[{{0.8999999999999999, -3.0714285714285716`}, {
     0.9600916138331275, -3.178306495307221}}], 
    ArrowBox[{{0.8999999999999999, -2.857142857142857}, {
     0.9600916138331275, -2.967876678533853}}], 
    ArrowBox[{{0.8999999999999999, -2.642857142857143}, {
     0.9600916138331275, -2.7573428603148225`}}], 
    ArrowBox[{{0.8999999999999999, -2.4285714285714284`}, {
     0.9600916138331275, -2.546467432181751}}], 
    ArrowBox[{{0.8999999999999999, -2.2142857142857144`}, {
     0.9600916138331275, -2.33483161766501}}], 
    ArrowBox[{{0.8999999999999999, -2.}, {
     0.9600916138331275, -2.1216855180120833`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{0, -4.5},
  Frame->True,
  FrameTicks->{{{-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, Automatic, None, None},
  PlotRange->{{-1, 1}, {-4.471850444106532, -2.1520305679722127`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Im Bereich -2.2<c<0.5 sehen wir noch einmal deutlich, dass ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " eine L\[ODoubleDot]sung generell nicht \[UDoubleDot]ber die Stelle y=0 \
hinweg verl\[ADoubleDot]ngern kann, ansonsten aber plausible \
L\[ODoubleDot]sungen liefert."
}], "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
  3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
  3.36644048070057*^9}, {3.36644051650422*^9, 3.36644053374247*^9}, {
  3.36644056386189*^9, 3.36644057173263*^9}, {3.36644083307155*^9, 
  3.36644083454827*^9}, {3.36644110242705*^9, 3.3664411326857*^9}, {
  3.36644135000811*^9, 3.36644141937365*^9}, {3.36644166666137*^9, 
  3.36644178486316*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsol4", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "2.2"}], ",", "0.5", ",", ".3"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
  3.36638316883576*^9, 3.36638318466153*^9}, {3.36638321570362*^9, 
  3.36638324157278*^9}, {3.36638343115048*^9, 3.36638345735994*^9}, {
  3.36644114893442*^9, 3.36644115421382*^9}, {3.36644118668446*^9, 
  3.36644120657309*^9}, {3.36644126641416*^9, 3.36644133051094*^9}, {
  3.36644138065606*^9, 3.36644138895105*^9}, {3.366441469127*^9, 
  3.36644147634493*^9}, {3.36644155240451*^9, 3.36644155828784*^9}, {
  3.36644159812517*^9, 3.36644160076444*^9}, {3.36697135116537*^9, 
  3.36697135388669*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"At \\!\\(x\\) == \\!\\(0.6999996454469152`\\), step size \
is effectively zero; singularity or stiff system suspected.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"At \\!\\(x\\) == \\!\\(0.39999972754492774`\\), step size \
is effectively zero; singularity or stiff system suspected.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"At \\!\\(x\\) == \\!\\(0.09999968741677946`\\), step size \
is effectively zero; singularity or stiff system suspected.\"\>"}]], "Message",\
 "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Further output of \\!\\(NDSolve :: \\\"ndsz\\\"\\) will be \
suppressed during this calculation.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.6999996454469152`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.39999972754492774`"}], "}"}], "}"}],
          ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.`"}], ",", "0.09999968741677946`"}], "}"}], "}"}],
          ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.19999978450774003`"}], ",", "0.9`"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.499999716571207`"}], ",", "0.9`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol4"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p4", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ",", "myPlotOptions"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638335890342*^9}, {3.36638348799274*^9, 3.36638351512981*^9}, {
   3.36644121023608*^9, 3.36644127744919*^9}, {3.36644131108589*^9, 
   3.36644132590008*^9}, {3.3664414930643*^9, 3.36644153150844*^9}, 
   3.36697116610569*^9, {3.38270341110172*^9, 3.382703418587591*^9}, {
   3.389326023280105*^9, 3.389326029733221*^9}, {3.389332364469024*^9, 
   3.389332396983606*^9}, 3.389338601498908*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Input value \\!\\({\\(-0.9999591428571428`\\)}\\) lies \
outside the range of data in the interpolating function. Extrapolation will \
be used.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Input value \\!\\({\\(-0.9999591428571428`\\)}\\) lies \
outside the range of data in the interpolating function. Extrapolation will \
be used.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81f/3AHD3GhkZKU2rJSQto6hOiJQRKlkJRbvURyREVvbO3rtkkxFe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      "]], LineBox[CompressedData["
1:eJwt2nc41e/7APBjlUpSaSgrMhMNI/roTouQVWRmFEnSRpkhRIQKlWxSypYR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      "]], LineBox[CompressedData["
1:eJwt2nk01N/7AHA+KFGSJCpLWggJWaL0lEpKhEqWkgpJJUmlZAnJTpKQfU2y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      "]], LineBox[CompressedData["
1:eJwt2nk0ld/XAHAVKZUkQzIkEZUQIVS7aBDKVBKaFE3qqxIJKSQaZApJ5iHJ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      "]], 
     LineBox[{{-0.9999999591836735, -1.0000000000000002`}, \
{-0.9803713183903062, -1.0000000000000002`}, {-0.9607426775969391, \
-1.0000000000000002`}, {-0.9181832858290826, -1.0000000000000002`}, \
{-0.8784442328596956, -1.0000000000000002`}, {-0.8394847023622477, \
-1.0000000000000002`}, {-0.7972230616836775, -1.0000000000000002`}, \
{-0.757781759803577, -1.0000000000000002`}, {-0.7150383477423542, \
-1.0000000000000002`}, {-0.6730744581530703, -1.0000000000000002`}, \
{-0.6339309073622561, -1.0000000000000002`}, {-0.5914852463903196, \
-1.0000000000000002`}, {-0.5518599242168528, -1.0000000000000002`}, \
{-0.5130141245153249, -1.0000000000000002`}, {-0.47086621463267486`, \
-1.0000000000000002`}, {-0.4315386435484944, -1.0000000000000002`}, \
{-0.3889089622831917, -1.0000000000000002`}, {-0.34705880348982804`, \
-1.0000000000000002`}, {-0.30802898349493396`, -1.0000000000000002`}, \
{-0.26569705331891763`, -1.0000000000000002`}, {-0.2261854619413709, \
-1.0000000000000002`}, {-0.18337176038270195`, -1.0000000000000002`}, \
{-0.141337581295972, -1.0000000000000002`}, {-0.10212374100771163`, \
-1.0000000000000002`}, {-0.05960779053832902, -1.0000000000000002`}, \
{-0.01991217886741602, -1.0000000000000002`}, {
      0.01900391033155799, -1.0000000000000002`}, {
      0.06122210971165424, -1.0000000000000002`}, {
      0.10061997029328089`, -1.0000000000000002`}, {
      0.14331994105602977`, -1.0000000000000002`}, {
      0.18524038934683965`, -1.0000000000000002`}, {
      0.22434049883917992`, -1.0000000000000002`}, {
      0.2667427185126425, -1.0000000000000002`}, {
      0.3063245993876354, -1.0000000000000002`}, {
      0.3451269577906893, -1.0000000000000002`}, {
      0.38723142637486546`, -1.0000000000000002`}, {
      0.426515556160572, -1.0000000000000002`}, {
      0.4691017961274008, -1.0000000000000002`}, {
      0.50886769729576, -1.0000000000000002`}, {
      0.5478540759921803, -1.0000000000000002`}, {
      0.5901425648697227, -1.0000000000000002`}, {
      0.6296107149487956, -1.0000000000000002`}, {
      0.6723809752089908, -1.0000000000000002`}, {
      0.7143717129972469, -1.0000000000000002`}, {
      0.7535421119870335, -1.0000000000000002`}, {
      0.7960146211579422, -1.0000000000000002`}, {
      0.8356667915303814, -1.0000000000000002`}, {
      0.8745394394308815, -1.0000000000000004`}, {
      0.9167141975125039, -1.0000000000000004`}, {
      0.9560686167956567, -1.0000000000000004`}, {
      0.9987251462599317, -1.0000000000000002`}, {
      0.9993625527218026, -1.0000000000000002`}, {
      0.9999999591836735, -1.0000000000000002`}}], LineBox[CompressedData["
1:eJw913c81d//AHANqYwQaUgiMxkZhepUGgoZkZlsWSUp2TMZhRQJJTtky+aV
lRHZe99FPsgqO79zv3/8/rn38Xzcc8/79T7n9X69X+e4yUMN8+00NDTb8Qf1
WxQdmNra+g1L+Vo2WdK/4OEqb8Dq2m+Q2LPg3yH1C3LyJfgX//yGzEtRGX8l
f8FpQRUTyn+/4cmKHDM6/QvOsPgNNPf+hrIqc8U20V9wkTjf9D77N/xHyfNa
EvgFGi9aMiTv/Qam6HOOVw7/AqdWPzvLylmoKVjypN2ahK4u+qkq4xngtLWw
/1w7CUe/PWQ7wzkNQxm+Ly6FTsJXm1rafcNT0Hj4+MZJg0kweikx1+/zC56k
2Tx9wj8JK+GuAYAmwcQ+01b87wQkMo0cihqnwJdtPeMStRMQe1PCoTOQDI3/
1V2uiJgAH1vjZ0I3SNDDsn5x03YCXHekOznMEICrQyR+QGECjL1aT/R8Hgc6
n+Ef3twTEFFBjoq1HoNgf0PeYZoJKB0VZPjCMwK5um4ctAQK8DJfvKz5cRAO
raVYRjRQIE84wJpA7IP5tUjfzBwKHGs3KjnZ3wfWzQJntLFfOsnufvKzDwYk
/57Yhm1eO5VMV9IHe7OksrWyKXDQUGVcJKQPQnMj3bdlUcD9NauO09k+kNhJ
2DDNoIDiSuxVhle9oKgmelczhQKjdbncMjI9ELcUoT8eSwG326tXzor0wOel
D9c+Yh8cv2glx9MDGrd6TfSx1TZacy8w9UC5U7loTwwFvp2evXyd0g03fc33
/4ymwKc4YXOdyG6w9urfXR9FARPnxDSXv13gfdLbavgtBcgiEaehsBPmpq6d
jH5FAWGP5NnJjE6YWlVyMcR+0Po1nTW+E97MxdDwYq886uGxCO6EOveRvC8v
KbC3iGM/o1EnGD2R/1IdTAHxS9GLens64WQ9kFYCKeCqFVfwV78DJkxu0IT4
4/hSsu251TuA/VTUYV3snSsgcvNaB7jwXbI+gR0SPZb0QbwDKgJN08qe4/hH
j0dcoe2AEfczydN+FPhulfQkPKsd0PYXz3V8KcDikSYjuq0d1iU43LS9KOBf
KNjAvNwG/922PiuCvTabqrs43Qa0O92Pb8Mm3EtxK+5rg4WFj84Znnh/LyVW
X85pg9s3dl3cjq1B++GW9r02kKubPlDsTgGBQ8dbaFxbocz4vvMVVwowBx2b
q7Noharu1Ewu7JW1o/uDNVqhZTWCYdWFAg1Dh3XZhVtBSubczSzs+5/YyEL9
P2GwYrz6MHa6wO5NjTM/IfLP4Zj1ZxQQkfktkrzYDIQHEY+HnlLAQtTTs2S4
GRqJGvwl2HH8+zpa6pvhJjfsjsRm5RBz+hvTDAVdqgZq2MvLD6quX2kG+Xcz
8vVPKFBdMqs19fYHNBrT1Fc4UkDn/KyHmEwTeLsO3WlxoEC4tEe7AncTmKeY
tWZj/zjFdEJnbxOcfmTvGI59gUu00WukEfIOZCjoYPNu2e3v8G8E/YXuRfIj
Csx+m0l17G2ALUdlvz3Yvldm2kqe1QPtDHOO/UN8fcVpVSnTelih3bmsg02j
8t/PLJV6SHAF80vYblq/mhN56iH6wqlSVuynFuSGV83fgYtG+FzRA7xeAcPf
jLm/Q+90TBAddsrLITS09zssu0ldWrCjAClssPLOnzoQfNJ9dBjb+H1/uVJT
HbC4fVPMx9ZL7y6WdqwD9RUhE2Ns5eaWnD0NtSCrUhNUa0uBoLZmMb+8WjCy
rXybi93Q9SPrX2wtzNhuq/mIfXW48cvio1oImZsNdsa+MFv3efhILcSxaDeL
Y4szV37KfVgDib1LM8k2FGDXzArT5agGb+WWsTRrnE/8waVXd1TDeJaydCy2
2qolSeJ3FcSI8aSEYAd9PH52b30VcHLZDT3G/jf5drT0aRWoZ7ZHIWyKu6so
Z8836K4elBuywuurpqOzu/obnHfYVGzD5uaV9lnK/AZ8mkOParH1Gma7m59/
g8YWy/2Z2D9ZTdzdpb9BhG1buCf2A9XXURVCAMurlTZC2J+Xbk5HbAOYNFQ6
dAyb8H7nxQf9lfDx4cwoG/YdktMEV2AlpOftLqbBRs6GMl6TFeD4pjCs/z7O
/8STXZdTy6E4831zKPZNRbLAEc9yGMtd/ueP7Tfz0XXxTjnc7ihS9MBeOcPK
m7SrHEZTZo7bYY83rzyitSiDaa3Dk0rYeX/r9jWcKIUq/5Z0RuyQ9ITqC6sl
4HU8L5UW28bQ88nXlhJgdf1XsWlJgRPfzw4mPC0B3sILMrPYkREZKe4NxSBo
8FC9DdtF6vV5SdsisNxk2/8e+86k3VzaxSJIsgyKCMeWjL2ZyM1eBLv5OMVe
Yk/v2LmHqbIQSBxrKZ7Yhp1Puyb3FYKcpkWyJfZlBwObj/kFQO6XLJPH5uKX
5WIPKAA2ldsfZLDX+9nbgw0KYJyR760EdsGlVhln2gJY/HsFBLD5WS5v19TO
B5Xhc3Ts2NvruL42ncwHkPwaxIw9+mzd8hJNPtB3px9nwI4aK2gRTcuD1qeP
A3dg780ReL9nPRcs2C6cW7TA+WG6U9mrNRecDxpp/8au4Rj/9zcxF37T1fj9
h+3mGW1GUs4FqeIUdhL27C1GcfiYA9YNJvQ92MmD5Fe//LLAcjyJpwJ7wO1A
3AfJLDgTfcyjFJuJ63qOOiETlj6oTBRhPzX63FGCMoFz7iwhD/sa2ZojaC0D
7ib5PE3DdvGPEbyQlgF971vkU7GzBJplF7QzYE9WIWMyNof1KQO9r+ngGNvX
8wl7cvb3J2H7NDiy/notCpszjDtvhCsNGu7RH3+HrSahXhPe8hl0iOy3I7CL
H+eR14Q/w6ycav9r7MAVR+Ef5BTw6bGyDsaufJ8s7/k2BQaHfH4FYi/I9ShL
KqRA9i+mxwHYeu5nHsZ8SoY3e+eTnmMLb1/Lt9FPguH9S55e2IaJwnXH9iZB
4UrZLU/s8Cv6PZ3FiRCXMsDvgb3mX74ifyARnK+8XnDFFhWc2TNXmwBCbWNk
F2yTxqNHkh4ngN+llXFn7B/0nucZ2uOhkGF20QmbJjP71jfPeFDa7reHaqlb
Y/ccReOBjl1d4Cl2bNgln6HgT/CgccvFEbtPeHeI7quPYLhQ4vEI+6KdVU7V
1AcI0trfYY/9ObupQ0jxA3Rf8RGh2lnqFcfa9lg4OmP59wE24emsrIlRDHSf
KjOn+maJqkFTRTTY7P82aId9+AJrfPSz92BOEhu0xfbxelyzvScKjPQVzKj+
r7qLbC0ZBVYhuos22OXX3wnLz0ZCDxrlofpE0IpyolIkdNxYrrbGftms+5A+
LQIYBEzvU31XnbNg0PQtWDm8qLbCnl78I/uk9g3YbOk8o9otshWY+N5ABmPC
aaoZZNOufn4eDm+sZOfvU9dj0OfHJcprCBr9k0+1iIeB+uC117Aqn+VCdRm3
TK9jahjcVJK9SnXBj4461fYQOJHCQ7bE7mL2b/cJfwUbFYdLqV7Ukh3+evsl
vOGTDaeaNWZ6cpItGH4NudtRfXosbulITyBsESeVqFbnu02j+i4AOuVcTlFt
b72LwUfnBViMS7BSHZZdwvH1kD9Mv8xatcDOXrLlnRzwAy0rByLVP2W5xY7E
+oLVH7dWqmc9OuVu3fUBfomfFVQz1vpf8+byhhBOiyyqdVgdk+6DJ8QXXYmn
+l3sQNnPS+7gJ8MVSXUP/6VOqVoXeP7v3kuq2XJTp6KvPYM7urv8qL4tz7R9
W+MT+HuNxZ3q8DrHQ5ZKj8Gy3suJ6jbVQfGWFntIHdB8TDVXgW+YxSdbmNg/
+5DqmAY1OJ1sCXPSMrZUnyR2y0be1YeHefr3qfbqEuw6UnMe1qvw9NR45n3i
mFcU0bTtP3OqXd9ca7KRMkJXZA+YUf3PwzkmTswciWjymvzv/9ZfbDuFrdHC
zE9DqnfcGT1Px/8QVWc/16e6hjvwxQdmB5Q8MqVNtV8kj/2ZEEe0/euCBtXX
GMp12umd0MDpD8pU0/loXbIJdEaiOlNXqG5YnhWipXND6ycG5KkOsgtgjfPz
QJ/prCWoTpkPc+f09kJCDXv5qPb/MvzoF3ijsj9WB6i2tBS2KPzng+6FvaCl
WpHHSc/3vB9ijzJdMMcWHK65peb2HA0z/Buiek8Us8LRMn80kKdaR/WUxt0z
U6svUOxISTrVTYzpJ4vOBqIrlesvqc5o+HvMzykItauz21L90leBTb0wGCm8
36VIte2FsN1cf16imLet3FSrrA5tTEmGoHMMtn/NqPWmQGi+yCEUTT2MbaA6
4EyZQ7VOGAp3FnxH9crb8WnBlTC0TYRoTPX9BTrL0Hev0fagOEGq+1RFx//I
hCPjSPH/TLFL9rp2Vz95g+zqOE2p/nSKvTOb5y3y4QhgodpfLbsttvUt4t06
XWqCbff4xs9AtwgUSE8yoFozkvjjqVAkmvphvGqMLV/i3mjaE4k8Wx1CqeYZ
4qhX832HvJOHuaieO65cLTwchTJoBwWNsHuv4HdC0HukkLWWcI9avy29Knae
iUYCFiHsVAdnFhSPhMWg4osixLvYDm23Cn+cj0Vd3jXnqdZZnMwvnopFdsv/
Qg2w+WWPZodf+YiMTEcO61PriUHRF8/5j2jw1qHbetTn30M93fZjHMq+dtFH
F9uIUK3B6/YJPWD3qtWm1ovF0Pb3HZ/Q3Uax3jvY12nvqjELxaNshdVRrf/V
+2WVze54FHCVrvM2doJsbfNjkQS0P51QroHNrvRaaconAdGH0saqY2/YnbzR
K5aIVN6qyqpiN+bfu5IbmIS0E6SmbmCfqxOpERhLQl07Xz5TxM7pWb30USYZ
aXQ8W7uGHbn6BgUTk1FNwtE+Bey99MaV2+RSkBH7fcnL2O6couefhaWgfFEz
74vYZqhBzvx8KuqUilw6R91vtYiSwTep6OZrw0Py2EomJmc1plJR2+NNMVlq
vXu+IY3efUa66UQJaeytJnGJQ/Np6MfKbR8R6noPbWaHXk9HLPEdYsLYlJkm
0V0f0xFryKMWAexmZnORxZsZKJ5duo8HO/rOe4GWpC9o3uIm30FspvsWKQrr
X9A1HjMVdmxvZ0m+UvVMdEDluykrNT9jW3hS/2WiPG1PPQZsacI2Lm+dbBTH
5Ge1ZY7Xu1R7XjwtGz1WhrMb2PzhmbVjq9lIibRteQWbPv6L9CeVHDSmR0QL
2BtqOkNbszkoY377PyL2yrkd37U5clH8K7OLY9hLglnZ2SgXdZvq2A9hT9Ps
9L0XlotunRaK6sIezskWAok8FCA0s60WeyBWbz+HXh6K/auZAdg9AbSbD3zy
0Pnm0otl2D+N9Nu4OvNQkliRaB52JTOdk4djPnooMs8Shx1nb1h7vqgAqaQZ
NDpixxrsyYoYLUD9r+mPPMSOUix4N0P3FZE3wrWssMO499p80PmK/q0Y+93F
9mr7yrK5+hW9H/GouYJtLM54r/xcEVLanRjDhG3IWazIZl6EClMlTemw9Xab
nrZ9VYQ8JayZabA1xoppOUeK0Enh2cPzZrh/DTP74upZjNpKtKbasXnnylbl
qktQdnzN5RBstxYFv6WZEuRFczPQD7sn/QdT1qFSZH6v44sLdpD5IO/xR6VI
zaMj0AJ7bmBNhY67DO2dmH9zDruyTjah070cDUWWZoybUuBgYpXIq7RytP9v
SXw3toPXjaJr3eUo8IuBfSM2n7xuc4lIBRINMIzMwX6Z8+xv3GAF2m/DtumG
rRdTdNNWFhCDufIiI3bBM9TNZw7o8oaA2pYJzq879fdGwwAtaM55zWFXMfc6
akwC+pd46G4HNpuCq2qs0jfkLhS6/AbbtTja2WftGxrX3vOYCftGYn/LLZ1q
pP0t3nTECN/P8yyLOrtqRFHo2tOEHXXfd0vetxrZC+5y+4o9eeqUhFBWNTLz
FasJxg4o9nq7Y2cNUgxk6JLGbmgR0C/OrkFDB8PKPO/hfiFnY1G0rgbNZnBs
WmIffNP+MnmgBuXql9OqYd/Xca0Mp61Fy5d5bY5h7yb+PG6nX4tCyxncywxx
/Vl5Mnmcrg6dKC19NHkX9w8DN72jOOvQ5kGtzWbsyIpjh/edrkOdhIKbudgU
n0alDYM65MRlK+SM7c94NLsnrw593aUyQ4v9naf2SbDhd/SJ10lhvwE+36qw
7vjztR6Vih6tX9PF5y3jPfOrjfXo8HzirX7svic0o/+G69EM5XpkEbb1x9nS
3bsa0JJdptlj6vjfTQ6cdxpQ5ZzOnwkdPP61L0HhL/59u098rTYe37NUFS7T
hBgqorZuaFEgf+q/7Hc3m1ALfeTCMeyNf4QPsYZN6J1vTcwfTTyfQLtzin8T
Wtl2Y98n7PxnmRKlPU2oukbq0fxtPP6wRfz40x+43ip0PNegQOi9Xi/xomYU
/3Q80kEV3+/0OURpbkaXp43l5bA9nBM2YwjNqLOT6LoN+8EbOxc6phY0487b
GnKLArfqdziOmLUgjz9seUkqOJ/ExC1fsv5EUqxum+VKOJ5/ASqTdq2IfPII
R+x1PH/wLP1H31YknTKleAfb46Bm0+33rYjevmIXM/aD08euQ20rspgyOuFz
jQIC+XrcPxjbUNBlpX6jq7hfmZg7lGDWhmK9zQrpFChQf+sooxprOzoC3xWW
z+N8FR0/4MDZjtbSR6JSsY0Yk7nf8rejqWp+Z23stR8iUn1y7WjJRLv/6znc
D984p29k2o4cetP22snj+qGgn2Zf0I64xENra8/i5+fs+6uv73Sgv72bbAck
cf/DcVc136gDPbdy6ys8jd+Hf7l1u607EEuHxwFt7JdfP9se8uxATarftyIk
KACni9/Ep3Ygu/0mToziuN8/1Tueu9KB4P6wC0GEAjPH2T06ojuRdMyFDm5+
Cpx1jX9UldSJCO38tHl8+DzRdco8J6sTCRJzky9jH3hxTTmkuhMZ7eY6ZXKC
AhemnQ7fnOpEDd7KCtE8eD8LBwqrZLuQpcbixgwXBSSUPv3O6etC9S7zJ45x
4PqUJEKMI3QhkYyzLbEHcD5vFveETHchFZWQn4ew9XLaK2xpulGabkc/Czu+
PvuOl4KC3Wh8T/nWKisFOkfNBT85daNaJ9mRNCYKPHE8aRx6oAfN1G9/7kOL
49v7u/zO8R5klvymd2gnPm/G5R3kEulBKGjXDRnsjSbZti+XelCrVbIfZTue
/7giarLtQf2Priuco8H58tPsKG0NHl9TO122RoYUwY/9Lg97UXk0Y/uO32RQ
rDSWvuzSi1p054fRLBl+3eZ7ved5L9JbCSO7zJBBxPOLYlR0LzrqoT828x8Z
8rpLi77W9SKOew9M6yfJUOnTGzF3pA85xje7XieQoXeIWcOioQ/92XNdzKGL
DDeDzfscO/pQ2aZlYHQnGcplSw19h/pQqqr+QFUHGT5Fmtp8mutD8VMiBozt
ZLivVug3cLAfVYdGwbsWMqzV6BfdsupHRg/6J559JwNnRgrnmb0DqDRvlc20
iAwhuusJV9kGkEuDSK1lIRlodqsJaXINoIDzusjmKxlIZqvSj04PoEVge/sg
nwyZXMqqGXoDqMvjdphFNhkuhM97H8sYQD6Dp3wPp5LByPncBJ3yICpRXErz
jyCDsFlD9+ydQdQn+IHnxlsyLN7SrO02HkRM8Q5Le96Qwf+EbXyi0yBqesse
4x9Ghi+tMfoocRBFldvl2gSTYZVvvfXp2iDK0QxtIniRIbyjpJj8eQhFsFmO
O1iTwaDiampz/hC69nI6bf0+Gfg+t0fkVw6hIcmgZz6WZCh2/+Xg3TWEyodb
jgSZkWFE8NCpozTDyEHo6wlvQxyf57N4Te1h1Lhn5TW9BhlqTp4JqqEdQWlt
llmuZ8hgKKaZOL9vBEWlyn8YkibDyulH5ccOj6B/wZFP5aXw/splzLqKjqCz
LpShBXEyvFU8dltKewSV9LKcUBQmg4U5HWfy5xHU/qGGGMhJht1xvZn+SqPI
lP5apvoWCRISlr4XaI2ifcrHA6w2SXAuhWWMcG8UJVYcGvVYJ4F9phIrchxF
t8ck5+KXSdBfBk+XY0dR/nADf+NvEqT3paL7s6NI/MVt3qhREvDvKZ9MUhxD
so/PBR+qIMFCvah1gsoY6mDqKyCWkqDSP/6/OI0xFB9LS04vJsGdnS9mow3G
kMwL/aviBSR4vqW+FGY/hvxMul0PZJCA9Gdiyy1qDNlHHNFWjsLxEvZzaE2O
oasm9Y7S9iR4EO8fpTEzhoS6jSci7EggZ7R6SG1hDB1Ivpa6YE2CjuERTqWN
MWSj/XrhkzkJtvWn8VxiHkcx5Ki5Vj0SGLUi0VNnx9HOsm1aj66Q4Gi5zVXa
gHHkyc1PH8xGArZDa2sPXo0jHtTHzcNCAoanATl94eOoam1/Vj4jCTbEko98
+TCOijPH1+p2kWAgcWReI38c9dVM/E5eIUJksPrHTyPjKJm7p+36IBGY9M8s
y0sT0O9xWp/MGCLsKq77kixHQCdYIi4+e0eETTZNk30XCUij+XmY/BsiTP+0
byHcJKDRl73vM4KI0HQ5PTHQiIAGqlWuizkT4YXwUbXeYAJayJowzdckAs3a
9jQHAgFdaK1/ykhLBCNi/6LnBAHtS+/lP0JDhG/NORdeTRNQW01U/bF1AnjF
GXal/iUgfhbNx4zzBNi6Uro1tJeI7D4WxDoNEeBf6KM71yWJyC9MsephLgEM
nRXjNc8SEdfqUcJoBgEqTY5NG5/HvfLBFbGrKQTwkG7xdrtORDq+ej2z0QTY
HBDMzNUnItaJhpxSXwJs8I3t4PQjoromrTdstwlgsK/ollAgEbGkvj5Wr0yA
8pVX72VC8PwMmf621wjg9kNeTD2KiDJ05iVDZQmwbv9Oz/8LEQVXFImJHSPA
Wtmt3LkuPP6ifGz2xDgsq1cY1vGRUEZxtDav7Tj49GcPXzhJQse6+08eMB0H
JuMEg2JxElp8UJU9pzsO/PYv9DLkSYhwQ25Z7/o4aIao33mtTkIy1sUdy9zj
kNNEVrnrTkKSCoJ2hJ9jcE6jr7nHh4Tm2uLN2WvHoL6/SUktgIReL1QFCJSM
wchk9g2FNySUoLm9kJIwBgx0LleF0kho5dFbs3LHMbBSYDr/p4uELK5GPmdk
GYOlJpryBwM4vkV15u4dY+ClsSg3OUpCT54LpA5Oj0KUcd/ZwSkS0spupTta
OArfPROkqmjI6L5iXl67wiho0EXky+0io41N9ixR/lEYDnlxuoCejE5KQuXB
3aOw9MFWPPUAGXnSntB/0TQCPOUyIq9EyGghzsvK9sYIZCkIZew6TUZsz3kI
bQIjIPvjiLDXGTJyPCT2Iol2BNQGaAQfXyajuKD2Bn8YBo+VJl5dHTKa697G
+fnkMAxK3TvC50dG4mF+ZwdGB8FiVXrf80Ay4kuoMDufPwhzFQw7yCFkpKVZ
uO/z80HYeb10Kuk9GbHONlVaCgyCqC576YlsMpJhFVkWvzsAxUenM/0KyGhF
5hz7Y4EBuEyojieVkFFa+1qu8lw/aNvYBybVklHM0kdLJ/d+8HL/oXNiAMf/
yP0lq28f7L2coOw3SkaDKXny3qgPInY5XySRyKh7Smkgc7UX0kP5BZN+k9Fk
f1R/hEUvSGluHtn5h4yu7tv7c/ZgL160rn1ma2T0TVDu04WGHuiM917mpaWg
/TFW65mcPWBoofOf714Kyly9sy5Y1Q2TwmKjxH0UJMTAvEvFuBscftN2KrBT
0P1/o68SNrpgI3/oe+JhCnLtqCfGhHeB/7P80h3cFEROY8sN5ekClvNBWaZ8
FKRKP8Gcm9EJ/N/PRPKKU9ArutJY5eQOyAliCvKVpqBnRwxsV1k7QE6V7E6U
oyCJO94J64/boXZ/+SOFixRUlKDQ9aquDVT7ws0Tr1JQE1M5uWVHGz5vWunu
UKKgw9Y1jvQaP8HM+KKKqRoFv48FmB11mmGWj+NSjRYF/ekNda5cb4RnUzNS
vPoUNHpoWV138ztsz64V9DWioHlLvmvihdXw6nEMJz4Ho6GNjpqauZz/N0sy
48McVZaL/wecf6/t
      "]], LineBox[CompressedData["
1:eJw913c8le/7AHCVUUZJSUOyQsgsUukODVFIklDIR4QoI7JXKGXvvUX2yAiX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      "]], LineBox[CompressedData["
1:eJw91mk41U8bB/ASKXtJWpCQOOmUlK0YJEmyJclSoZAl/lSW7GSJdLJvkX13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      "]], LineBox[CompressedData["
1:eJw113c41e/7AHD7ZBRpqIyMIpJslXQfKqnsSpKRiqQUMjNDZiRkb7L3yDo8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      "]], LineBox[CompressedData["
1:eJw113c4Vu8bAHAyXiMzJcosySxZmfcrIg2hMkulokXIaEhCEZJ8SykZWdk7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      "]]}}, 
   {Thickness[Small], Arrowheads[0.02], 
    ArrowBox[{{-1., -2.}, {-0.9999079404053108, -2.000011507449336}}], 
    ArrowBox[{{-1., -1.7857142857142858`}, {-0.9999079404053108, \
-1.7857256274563515`}}], 
    ArrowBox[{{-1., -1.5714285714285714`}, {-0.9999079404053108, \
-1.5714392229519238`}}], 
    ArrowBox[{{-1., -1.3571428571428572`}, {-0.9999079404053108, \
-1.3571517825883257`}}], 
    ArrowBox[{{-1., -1.1428571428571428`}, {-0.9999079404053108, \
-1.1428621773662273`}}], 
    ArrowBox[{{-1., -0.9285714285714286}, {-0.9999079404053108, \
-0.928567615452122}}], 
    ArrowBox[{{-1., -0.7142857142857143}, {-0.9999079404053108, \
-0.7142599375992014}}], 
    ArrowBox[{{-1., -0.5}, {-0.9999079404053108, -0.4999079404053109}}], 
    ArrowBox[{{-1., -0.2857142857142857}, {-0.9999079404053108, \
-0.28531152498752077`}}], 
    ArrowBox[{{-1., -0.07142857142857142}, {-0.9999079404053108, \
-0.06305114831186079}}], 
    ArrowBox[{{-1., 0.14285714285714285`}, {-0.9999079404053108, 
     0.14543481150843843`}}], 
    ArrowBox[{{-1., 0.35714285714285715`}, {-0.9999079404053108, 
     0.3576326141866033}}], 
    ArrowBox[{{-1., 0.5714285714285714}, {-0.9999079404053108, 
     0.5716500898282921}}], 
    ArrowBox[{{-1., 0.7857142857142857}, {-0.9999079404053108, 
     0.7858474297561915}}], 
    ArrowBox[{{-1., 1.}, {-0.9999079404053108, 1.0000920595946892`}}], 
    ArrowBox[{{-0.8642857142857143, -2.}, {-0.8641936546910252, \
-2.000009221705842}}], 
    ArrowBox[{{-0.8642857142857143, -1.7857142857142858`}, \
{-0.8641936546910252, -1.7857233746275636`}}], 
    ArrowBox[{{-0.8642857142857143, -1.5714285714285714`}, \
{-0.8641936546910252, -1.5714371072224085`}}], 
    ArrowBox[{{-0.8642857142857143, -1.3571428571428572`}, \
{-0.8641936546910252, -1.3571500097124851`}}], 
    ArrowBox[{{-0.8642857142857143, -1.1428571428571428`}, \
{-0.8641936546910252, -1.1428611773534485`}}], 
    ArrowBox[{{-0.8642857142857143, -0.9285714285714286}, \
{-0.8641936546910252, -0.9285683728582502}}], 
    ArrowBox[{{-0.8642857142857143, -0.7142857142857143}, \
{-0.8641936546910252, -0.7142650576646286}}], 
    ArrowBox[{{-0.8642857142857143, -0.5}, {-0.8641936546910252, \
-0.4999262263532653}}], 
    ArrowBox[{{-0.8642857142857143, -0.2857142857142857}, \
{-0.8641936546910252, -0.28539152600982126`}}], 
    ArrowBox[{{-0.8642857142857143, -0.07142857142857142}, \
{-0.8641936546910252, -0.06471516957571097}}], 
    ArrowBox[{{-0.8642857142857143, 
     0.14285714285714285`}, {-0.8641936546910252, 0.1449228049657153}}], 
    ArrowBox[{{-0.8642857142857143, 
     0.35714285714285715`}, {-0.8641936546910252, 0.35753533294348594`}}], 
    ArrowBox[{{-0.8642857142857143, 0.5714285714285714}, {-0.8641936546910252,
      0.5716060892660269}}], 
    ArrowBox[{{-0.8642857142857143, 0.7857142857142857}, {-0.8641936546910252,
      0.7858209831372491}}], 
    ArrowBox[{{-0.8642857142857143, 1.}, {-0.8641936546910252, 
     1.0000737736467347`}}], 
    ArrowBox[{{-0.7285714285714286, -2.}, {-0.7284793689767395, \
-2.0000070675031223`}}], 
    ArrowBox[{{-0.7285714285714286, -1.7857142857142858`}, \
{-0.7284793689767395, -1.7857212514453633`}}], 
    ArrowBox[{{-0.7285714285714286, -1.5714285714285714`}, \
{-0.7284793689767395, -1.5714351132496434`}}], 
    ArrowBox[{{-0.7285714285714286, -1.3571428571428572`}, \
{-0.7284793689767395, -1.3571483388627306`}}], 
    ArrowBox[{{-0.7285714285714286, -1.1428571428571428`}, \
{-0.7284793689767395, -1.1428602348897587`}}], 
    ArrowBox[{{-0.7285714285714286, -0.9285714285714286}, \
{-0.7284793689767395, -0.9285690866769029}}], 
    ArrowBox[{{-0.7285714285714286, -0.7142857142857143}, \
{-0.7284793689767395, -0.7142698830787202}}], 
    ArrowBox[{{-0.7285714285714286, -0.5}, {-0.7284793689767395, \
-0.49994345997502093`}}], 
    ArrowBox[{{-0.7285714285714286, -0.2857142857142857}, \
{-0.7284793689767395, -0.2854669231050022}}], 
    ArrowBox[{{-0.7285714285714286, -0.07142857142857142}, \
{-0.7284793689767395, -0.06628342915547476}}], 
    ArrowBox[{{-0.7285714285714286, 
     0.14285714285714285`}, {-0.7284793689767395, 0.1444402635565572}}], 
    ArrowBox[{{-0.7285714285714286, 
     0.35714285714285715`}, {-0.7284793689767395, 0.35744365007574586`}}], 
    ArrowBox[{{-0.7285714285714286, 0.5714285714285714}, {-0.7284793689767395,
      0.5715646208636773}}], 
    ArrowBox[{{-0.7285714285714286, 0.7857142857142857}, {-0.7284793689767395,
      0.7857960584776852}}], 
    ArrowBox[{{-0.7285714285714286, 1.}, {-0.7284793689767395, 
     1.000056540024979}}], 
    ArrowBox[{{-0.5928571428571429, -2.}, {-0.5927650832624537, \
-2.000005078463708}}], 
    ArrowBox[{{-0.5928571428571429, -1.7857142857142858`}, \
{-0.5927650832624537, -1.785719291048116}}], 
    ArrowBox[{{-0.5928571428571429, -1.5714285714285714`}, \
{-0.5927650832624537, -1.571433272155309}}], 
    ArrowBox[{{-0.5928571428571429, -1.3571428571428572`}, \
{-0.5927650832624537, -1.3571467961174781`}}], 
    ArrowBox[{{-0.5928571428571429, -1.1428571428571428`}, \
{-0.5927650832624537, -1.142859364685015}}], 
    ArrowBox[{{-0.5928571428571429, -0.9285714285714286}, \
{-0.5927650832624537, -0.9285697457668864}}], 
    ArrowBox[{{-0.5928571428571429, -0.7142857142857143}, \
{-0.5927650832624537, -0.7142743385270092}}], 
    ArrowBox[{{-0.5928571428571429, -0.5}, {-0.5927650832624537, \
-0.49995937229033866`}}], 
    ArrowBox[{{-0.5928571428571429, -0.2857142857142857}, \
{-0.5927650832624537, -0.28553653948451735`}}], 
    ArrowBox[{{-0.5928571428571429, -0.07142857142857142}, \
{-0.5927650832624537, -0.06773144984939015}}], 
    ArrowBox[{{-0.5928571428571429, 
     0.14285714285714285`}, {-0.5927650832624537, 0.14399471872766018`}}], 
    ArrowBox[{{-0.5928571428571429, 
     0.35714285714285715`}, {-0.5927650832624537, 0.3573589965582554}}], 
    ArrowBox[{{-0.5928571428571429, 0.5714285714285714}, {-0.5927650832624537,
      0.571526331854944}}], 
    ArrowBox[{{-0.5928571428571429, 0.7857142857142857}, {-0.5927650832624537,
      0.7857730447985066}}], 
    ArrowBox[{{-0.5928571428571429, 1.}, {-0.5927650832624537, 
     1.0000406277096614`}}], 
    ArrowBox[{{-0.4571428571428572, -2.}, {-0.4570507975481681, \
-2.000003300736168}}], 
    ArrowBox[{{-0.4571428571428572, -1.7857142857142858`}, \
{-0.4570507975481681, -1.7857175389198532`}}], 
    ArrowBox[{{-0.4571428571428572, -1.5714285714285714`}, \
{-0.4570507975481681, -1.5714316266554378`}}], 
    ArrowBox[{{-0.4571428571428572, -1.3571428571428572`}, \
{-0.4570507975481681, -1.357145417270633}}], 
    ArrowBox[{{-0.4571428571428572, -1.1428571428571428`}, \
{-0.4570507975481681, -1.1428585869292163`}}], 
    ArrowBox[{{-0.4571428571428572, -0.9285714285714286}, \
{-0.4570507975481681, -0.928570334836367}}], 
    ArrowBox[{{-0.4571428571428572, -0.7142857142857143}, \
{-0.4570507975481681, -0.7142783206366977}}], 
    ArrowBox[{{-0.4571428571428572, -0.5}, {-0.4570507975481681, \
-0.499973594110655}}], 
    ArrowBox[{{-0.4571428571428572, -0.2857142857142857}, \
{-0.4570507975481681, -0.2855987599484013}}], 
    ArrowBox[{{-0.4571428571428572, -0.07142857142857142}, \
{-0.4570507975481681, -0.06902563549817599}}], 
    ArrowBox[{{-0.4571428571428572, 
     0.14285714285714285`}, {-0.4570507975481681, 0.14359650775880298`}}], 
    ArrowBox[{{-0.4571428571428572, 
     0.35714285714285715`}, {-0.4570507975481681, 0.3572833364741726}}], 
    ArrowBox[{{-0.4571428571428572, 0.5714285714285714}, {-0.4570507975481681,
      0.5714921105998079}}], 
    ArrowBox[{{-0.4571428571428572, 0.7857142857142857}, {-0.4570507975481681,
      0.7857524760501152}}], 
    ArrowBox[{{-0.4571428571428572, 1.}, {-0.4570507975481681, 
     1.000026405889345}}], 
    ArrowBox[{{-0.3214285714285715, -2.}, {-0.3213365118338824, \
-2.0000017994274057`}}], 
    ArrowBox[{{-0.3214285714285715, -1.7857142857142858`}, \
{-0.3213365118338824, -1.785716059229937}}], 
    ArrowBox[{{-0.3214285714285715, -1.5714285714285714`}, \
{-0.3213365118338824, -1.5714302370142694`}}], 
    ArrowBox[{{-0.3214285714285715, -1.3571428571428572`}, \
{-0.3213365118338824, -1.3571442528206235`}}], 
    ArrowBox[{{-0.3214285714285715, -1.1428571428571428`}, \
{-0.3213365118338824, -1.1428579301066328`}}], 
    ArrowBox[{{-0.3214285714285715, -0.9285714285714286}, \
{-0.3213365118338824, -0.9285708323114598}}], 
    ArrowBox[{{-0.3214285714285715, -0.7142857142857143}, \
{-0.3213365118338824, -0.7142816835683252}}], 
    ArrowBox[{{-0.3214285714285715, -0.5}, {-0.3213365118338824, \
-0.49998560458075325`}}], 
    ArrowBox[{{-0.3214285714285715, -0.2857142857142857}, \
{-0.3213365118338824, -0.28565130575508113`}}], 
    ArrowBox[{{-0.3214285714285715, -0.07142857142857142}, \
{-0.3213365118338824, -0.07011858827711667}}], 
    ArrowBox[{{-0.3214285714285715, 
     0.14285714285714285`}, {-0.3213365118338824, 0.143260214596052}}], 
    ArrowBox[{{-0.3214285714285715, 
     0.35714285714285715`}, {-0.3213365118338824, 0.3572194407732499}}], 
    ArrowBox[{{-0.3214285714285715, 0.5714285714285714}, {-0.3213365118338824,
      0.5714632104061339}}], 
    ArrowBox[{{-0.3214285714285715, 0.7857142857142857}, {-0.3213365118338824,
      0.7857351055355103}}], 
    ArrowBox[{{-0.3214285714285715, 1.}, {-0.3213365118338824, 
     1.0000143954192469`}}], 
    ArrowBox[{{-0.18571428571428578`, -2.}, {-0.18562222611959664`, \
-2.000000669452302}}], 
    ArrowBox[{{-0.18571428571428578`, -1.7857142857142858`}, \
{-0.18562222611959664`, -1.785714945526475}}], 
    ArrowBox[{{-0.18571428571428578`, -1.5714285714285714`}, \
{-0.18562222611959664`, -1.5714291910869007`}}], 
    ArrowBox[{{-0.18571428571428578`, -1.3571428571428572`}, \
{-0.18562222611959664`, -1.35714337638564}}], 
    ArrowBox[{{-0.18571428571428578`, -1.1428571428571428`}, \
{-0.18562222611959664`, -1.142857435742525}}], 
    ArrowBox[{{-0.18571428571428578`, -0.9285714285714286}, \
{-0.18562222611959664`, -0.92857120674108}}], 
    ArrowBox[{{-0.18571428571428578`, -0.7142857142857143}, \
{-0.18562222611959664`, -0.7142842147125574}}], 
    ArrowBox[{{-0.18571428571428578`, -0.5}, {-0.18562222611959664`, \
-0.49999464438158264`}}], 
    ArrowBox[{{-0.18571428571428578`, -0.2857142857142857}, \
{-0.18562222611959664`, -0.2856908548837097}}], 
    ArrowBox[{{-0.18571428571428578`, -0.07142857142857142}, \
{-0.18562222611959664`, -0.07094121015259067}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.14285714285714285`}, {-0.18562222611959664`, 0.14300710017282925`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.35714285714285715`}, {-0.18562222611959664`, 0.35717134903283754`}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.5714285714285714}, {-0.18562222611959664`, 0.5714414583853882}}], 
    ArrowBox[{{-0.18571428571428578`, 
     0.7857142857142857}, {-0.18562222611959664`, 0.7857220314434017}}], 
    ArrowBox[{{-0.18571428571428578`, 1.}, {-0.18562222611959664`, 
     1.0000053556184174`}}], 
    ArrowBox[{{-0.05000000000000007, -2.}, {-0.04990794040531094, \
-2.0000000547973777`}}], 
    ArrowBox[{{-0.05000000000000007, -1.7857142857142858`}, \
{-0.04990794040531094, -1.7857143397225814`}}], 
    ArrowBox[{{-0.05000000000000007, -1.5714285714285714`}, \
{-0.04990794040531094, -1.5714286221501113`}}], 
    ArrowBox[{{-0.05000000000000007, -1.3571428571428572`}, \
{-0.04990794040531094, -1.3571428996449786`}}], 
    ArrowBox[{{-0.05000000000000007, -1.1428571428571428`}, \
{-0.04990794040531094, -1.1428571668309955`}}], 
    ArrowBox[{{-0.05000000000000007, -0.9285714285714286}, \
{-0.04990794040531094, -0.9285714104137176}}], 
    ArrowBox[{{-0.05000000000000007, -0.7142857142857143}, \
{-0.04990794040531094, -0.714285591539588}}], 
    ArrowBox[{{-0.05000000000000007, -0.5}, {-0.04990794040531094, \
-0.4999995616209777}}], 
    ArrowBox[{{-0.05000000000000007, -0.2857142857142857}, \
{-0.04990794040531094, -0.285712367806063}}], 
    ArrowBox[{{-0.05000000000000007, -0.07142857142857142}, \
{-0.04990794040531094, -0.07138867893753947}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.14285714285714285`}, {-0.04990794040531094, 0.14286941746976806`}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.35714285714285715`}, {-0.04990794040531094, 0.35714518931925593`}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.5714285714285714}, {-0.04990794040531094, 0.5714296262780939}}], 
    ArrowBox[{{-0.05000000000000007, 
     0.7857142857142857}, {-0.04990794040531094, 0.7857149197335329}}], 
    ArrowBox[{{-0.05000000000000007, 1.}, {-0.04990794040531094, 
     1.0000004383790224`}}], 
    ArrowBox[{{0.08571428571428563, -2.}, {
     0.08580634530897475, -2.00000018494115}}], 
    ArrowBox[{{0.08571428571428563, -1.7857142857142858`}, {
     0.08580634530897475, -1.7857144679922834`}}], 
    ArrowBox[{{0.08571428571428563, -1.5714285714285714`}, {
     0.08580634530897475, -1.571428742613768}}], 
    ArrowBox[{{0.08571428571428563, -1.3571428571428572`}, {
     0.08580634530897475, -1.3571430005875165`}}], 
    ArrowBox[{{0.08571428571428563, -1.1428571428571428`}, {
     0.08580634530897475, -1.1428572237688959`}}], 
    ArrowBox[{{0.08571428571428563, -0.9285714285714286}, {
     0.08580634530897475, -0.928571367289154}}], 
    ArrowBox[{{0.08571428571428563, -0.7142857142857143}, {
     0.08580634530897475, -0.7142853000175382}}], 
    ArrowBox[{{0.08571428571428563, -0.5}, {
     0.08580634530897475, -0.4999985204707996}}], 
    ArrowBox[{{0.08571428571428563, -0.2857142857142857}, {
     0.08580634530897475, -0.2857078127740341}}], 
    ArrowBox[{{0.08571428571428563, -0.07142857142857142}, {
     0.08580634530897475, -0.07129393427133858}}], 
    ArrowBox[{{0.08571428571428563, 0.14285714285714285`}, {
     0.08580634530897475, 0.14289856967475295`}}], 
    ArrowBox[{{0.08571428571428563, 0.35714285714285715`}, {
     0.08580634530897475, 0.3571507282382031}}], 
    ArrowBox[{{0.08571428571428563, 0.5714285714285714}, {0.08580634530897475,
      0.5714321315457098}}], 
    ArrowBox[{{0.08571428571428563, 0.7857142857142857}, {0.08580634530897475,
      0.7857164255292449}}], 
    ArrowBox[{{0.08571428571428563, 1.}, {0.08580634530897475, 
     1.0000014795292003`}}], 
    ArrowBox[{{0.22142857142857134`, -2.}, {
     0.22152063102326047`, -2.0000014493655063`}}], 
    ArrowBox[{{0.22142857142857134`, -1.7857142857142858`}, {
     0.22152063102326047`, -1.7857157142089286`}}], 
    ArrowBox[{{0.22142857142857134`, -1.5714285714285714`}, {
     0.22152063102326047`, -1.5714299129900315`}}], 
    ArrowBox[{{0.22142857142857134`, -1.3571428571428572`}, {
     0.22152063102326047`, -1.3571439813044686`}}], 
    ArrowBox[{{0.22142857142857134`, -1.1428571428571428`}, {
     0.22152063102326047`, -1.1428577769545518`}}], 
    ArrowBox[{{0.22142857142857134`, -0.9285714285714286}, {
     0.22152063102326047`, -0.9285709483083023}}], 
    ArrowBox[{{0.22142857142857134`, -0.7142857142857143}, {
     0.22152063102326047`, -0.7142824677069805}}], 
    ArrowBox[{{0.22142857142857134`, -0.5}, {
     0.22152063102326047`, -0.4999884050759507}}], 
    ArrowBox[{{0.22142857142857134`, -0.2857142857142857}, {
     0.22152063102326047`, -0.28566355792156994`}}], 
    ArrowBox[{{0.22142857142857134`, -0.07142857142857142}, {
     0.22152063102326047`, -0.07037343334008402}}], 
    ArrowBox[{{0.22142857142857134`, 0.14285714285714285`}, {
     0.22152063102326047`, 0.14318180073052358`}}], 
    ArrowBox[{{0.22142857142857134`, 0.35714285714285715`}, {
     0.22152063102326047`, 0.3572045421387995}}], 
    ArrowBox[{{0.22142857142857134`, 0.5714285714285714}, {
     0.22152063102326047`, 0.571456471714565}}], 
    ArrowBox[{{0.22142857142857134`, 0.7857142857142857}, {
     0.22152063102326047`, 0.7857310552325388}}], 
    ArrowBox[{{0.22142857142857134`, 1.}, {0.22152063102326047`, 
     1.0000115949240493`}}], 
    ArrowBox[{{0.35714285714285704`, -2.}, {
     0.35723491673754615`, -2.0000045664481494`}}], 
    ArrowBox[{{0.35714285714285704`, -1.7857142857142858`}, {
     0.35723491673754615`, -1.7857187864055817`}}], 
    ArrowBox[{{0.35714285714285704`, -1.5714285714285714`}, {
     0.35723491673754615`, -1.5714327982235525`}}], 
    ArrowBox[{{0.35714285714285704`, -1.3571428571428572`}, {
     0.35723491673754615`, -1.357146398986297}}], 
    ArrowBox[{{0.35714285714285704`, -1.1428571428571428`}, {
     0.35723491673754615`, -1.142859140678208}}], 
    ArrowBox[{{0.35714285714285704`, -0.9285714285714286}, {
     0.35723491673754615`, -0.9285699154288466}}], 
    ArrowBox[{{0.35714285714285704`, -0.7142857142857143}, {
     0.35723491673754615`, -0.7142754854418599}}], 
    ArrowBox[{{0.35714285714285704`, -0.5}, {
     0.35723491673754615`, -0.4999634684148059}}], 
    ArrowBox[{{0.35714285714285704`, -0.2857142857142857}, {
     0.35723491673754615`, -0.28555446002906154`}}], 
    ArrowBox[{{0.35714285714285704`, -0.07142857142857142}, {
     0.35723491673754615`, -0.06810419717590847}}], 
    ArrowBox[{{0.35714285714285704`, 0.14285714285714285`}, {
     0.35723491673754615`, 0.1438800272425776}}], 
    ArrowBox[{{0.35714285714285704`, 0.35714285714285715`}, {
     0.35723491673754615`, 0.35733720517608974`}}], 
    ArrowBox[{{0.35714285714285704`, 0.5714285714285714}, {
     0.35723491673754615`, 0.5715164755554447}}], 
    ArrowBox[{{0.35714285714285704`, 0.7857142857142857}, {
     0.35723491673754615`, 0.7857671206515499}}], 
    ArrowBox[{{0.35714285714285704`, 1.}, {0.35723491673754615`, 
     1.000036531585194}}], 
    ArrowBox[{{0.49285714285714277`, -2.}, {
     0.4929492024518319, -2.000011023534465}}], 
    ArrowBox[{{0.49285714285714277`, -1.7857142857142858`}, {
     0.4929492024518319, -1.7857251505098541`}}], 
    ArrowBox[{{0.49285714285714277`, -1.5714285714285714`}, {
     0.4929492024518319, -1.5714387750307206`}}], 
    ArrowBox[{{0.49285714285714277`, -1.3571428571428572`}, {
     0.4929492024518319, -1.3571514072526913`}}], 
    ArrowBox[{{0.49285714285714277`, -1.1428571428571428`}, {
     0.4929492024518319, -1.142861965653471}}], 
    ArrowBox[{{0.49285714285714277`, -0.9285714285714286}, {
     0.4929492024518319, -0.928567775802612}}], 
    ArrowBox[{{0.49285714285714277`, -0.7142857142857143}, {
     0.4929492024518319, -0.7142610215685135}}], 
    ArrowBox[{{0.49285714285714277`, -0.5}, {
     0.4929492024518319, -0.49991181172428273`}}], 
    ArrowBox[{{0.49285714285714277`, -0.2857142857142857}, {
     0.4929492024518319, -0.28532846200802253`}}], 
    ArrowBox[{{0.49285714285714277`, -0.07142857142857142}, {
     0.4929492024518319, -0.06340343833829792}}], 
    ArrowBox[{{0.49285714285714277`, 0.14285714285714285`}, {
     0.4929492024518319, 0.145326414577227}}], 
    ArrowBox[{{0.49285714285714277`, 0.35714285714285715`}, {
     0.4929492024518319, 0.35761201876967313`}}], 
    ArrowBox[{{0.49285714285714277`, 0.5714285714285714}, {0.4929492024518319,
      0.5716407744670161}}], 
    ArrowBox[{{0.49285714285714277`, 0.7857142857142857}, {0.4929492024518319,
      0.7858418307411495}}], 
    ArrowBox[{{0.49285714285714277`, 1.}, {0.4929492024518319, 
     1.0000881882757173`}}], 
    ArrowBox[{{0.6285714285714284, -2.}, {
     0.6286634881661176, -2.000024481782324}}], 
    ArrowBox[{{0.6285714285714284, -1.7857142857142858`}, {
     0.6286634881661176, -1.7857384149589444`}}], 
    ArrowBox[{{0.6285714285714284, -1.5714285714285714`}, {
     0.6286634881661176, -1.5714512322518794`}}], 
    ArrowBox[{{0.6285714285714284, -1.3571428571428572`}, {
     0.6286634881661176, -1.357161845782887}}], 
    ArrowBox[{{0.6285714285714284, -1.1428571428571428`}, {
     0.6286634881661176, -1.1428678536369095`}}], 
    ArrowBox[{{0.6285714285714284, -0.9285714285714286}, {
     0.6286634881661176, -0.9285633162648598}}], 
    ArrowBox[{{0.6285714285714284, -0.7142857142857143}, {
     0.6286634881661176, -0.7142308750933087}}], 
    ArrowBox[{{0.6285714285714284, -0.5}, {
     0.6286634881661176, -0.49980414574140863`}}], 
    ArrowBox[{{0.6285714285714284, -0.2857142857142857}, {
     0.6286634881661176, -0.28485742333294845`}}], 
    ArrowBox[{{0.6285714285714284, -0.07142857142857142}, {
     0.6286634881661176, -0.05360583389675627}}], 
    ArrowBox[{{0.6285714285714284, 0.14285714285714285`}, {0.6286634881661176,
      0.14834106209770137`}}], 
    ArrowBox[{{0.6285714285714284, 0.35714285714285715`}, {0.6286634881661176,
      0.35818480179856327`}}], 
    ArrowBox[{{0.6285714285714284, 0.5714285714285714}, {0.6286634881661176, 
     0.5718998457383069}}], 
    ArrowBox[{{0.6285714285714284, 0.7857142857142857}, {0.6286634881661176, 
     0.7859975460056369}}], 
    ArrowBox[{{0.6285714285714284, 1.}, {0.6286634881661176, 
     1.0001958542585914`}}], 
    ArrowBox[{{0.7642857142857141, -2.}, {
     0.7643777738804033, -2.000057034107121}}], 
    ArrowBox[{{0.7642857142857141, -1.7857142857142858`}, {
     0.7643777738804033, -1.7857704985302643`}}], 
    ArrowBox[{{0.7642857142857141, -1.5714285714285714`}, {
     0.7643777738804033, -1.5714813633293776`}}], 
    ArrowBox[{{0.7642857142857141, -1.3571428571428572`}, {
     0.7643777738804033, -1.3571870941234496`}}], 
    ArrowBox[{{0.7642857142857141, -1.1428571428571428`}, {
     0.7643777738804033, -1.1428820952790082`}}], 
    ArrowBox[{{0.7642857142857141, -0.9285714285714286}, {
     0.7643777738804033, -0.9285525296956962}}], 
    ArrowBox[{{0.7642857142857141, -0.7142857142857143}, {
     0.7643777738804033, -0.7141579578857633}}], 
    ArrowBox[{{0.7642857142857141, -0.5}, {
     0.7643777738804033, -0.49954372714303213`}}], 
    ArrowBox[{{0.7642857142857141, -0.2857142857142857}, {
     0.7643777738804033, -0.28371809196505116`}}], 
    ArrowBox[{{0.7642857142857141, -0.07142857142857142}, {
     0.7643777738804033, -0.0299077414444935}}], 
    ArrowBox[{{0.7642857142857141, 0.14285714285714285`}, {0.7643777738804033,
      0.15563278285224375`}}], 
    ArrowBox[{{0.7642857142857141, 0.35714285714285715`}, {0.7643777738804033,
      0.35957022874192635`}}], 
    ArrowBox[{{0.7642857142857141, 0.5714285714285714}, {0.7643777738804033, 
     0.5725264779906504}}], 
    ArrowBox[{{0.7642857142857141, 0.7857142857142857}, {0.7643777738804033, 
     0.7863741844743632}}], 
    ArrowBox[{{0.7642857142857141, 1.}, {0.7643777738804033, 
     1.000456272856968}}], 
    ArrowBox[{{0.8999999999999999, -2.}, {
     0.9000920595946891, -2.0001864206792455`}}], 
    ArrowBox[{{0.8999999999999999, -1.7857142857142858`}, {
     0.9000920595946891, -1.78589802193575}}], 
    ArrowBox[{{0.8999999999999999, -1.5714285714285714`}, {
     0.9000920595946891, -1.5716011261068812`}}], 
    ArrowBox[{{0.8999999999999999, -1.3571428571428572`}, {
     0.9000920595946891, -1.3572874493594465`}}], 
    ArrowBox[{{0.8999999999999999, -1.1428571428571428`}, {
     0.9000920595946891, -1.1429387019043127`}}], 
    ArrowBox[{{0.8999999999999999, -0.9285714285714286}, {
     0.9000920595946891, -0.9285096560386609}}], 
    ArrowBox[{{0.8999999999999999, -0.7142857142857143}, {
     0.9000920595946891, -0.7138681319642044}}], 
    ArrowBox[{{0.8999999999999999, -0.5}, {
     0.9000920595946891, -0.4985086345660361}}], 
    ArrowBox[{{0.8999999999999999, -0.2857142857142857}, {
     0.9000920595946891, -0.2791895619406938}}], 
    ArrowBox[{{0.8999999999999999, -0.07142857142857142}, {0.9000920595946891,
      0.0642856830621408}}], 
    ArrowBox[{{0.8999999999999999, 0.14285714285714285`}, {0.9000920595946891,
      0.18461537500813124`}}], 
    ArrowBox[{{0.8999999999999999, 0.35714285714285715`}, {0.9000920595946891,
      0.36507692125154495`}}], 
    ArrowBox[{{0.8999999999999999, 0.5714285714285714}, {0.9000920595946891, 
     0.5750171695040469}}], 
    ArrowBox[{{0.8999999999999999, 0.7857142857142857}, {0.9000920595946891, 
     0.7878712191931591}}], 
    ArrowBox[{{0.8999999999999999, 1.}, {0.9000920595946891, 
     1.0014913654339639`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, Automatic, None, None},
  PlotRange->{-2, 1},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Noch einmal die symbolische L\[ODoubleDot]sung \
\>", "Subsection",
 CellChangeTimes->{{3.36630694896728*^9, 3.36630695098131*^9}, {
  3.36643159002579*^9, 3.36643159923483*^9}}],

Cell["\<\
Auch in der symbolischen L\[ODoubleDot]sungsschar gibt es \
L\[ODoubleDot]sungen, welche durch y[0]=c gehen. Wir bestimmen zun\
\[ADoubleDot]chst den Zusammenhang zwischen c und C[1], siehe auch Notebook \
solve.nb\
\>", "SmallText",
 CellChangeTimes->{{3366435438.89025, 3366435441.5208}, {3366435508.92756, 
  3366435546.42025}, {3366441865.12739, 3366441878.06063}, {3366442181.20435, 
  3366442218.17683}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "c", "]"}], "\[IndentingNewLine]", 
 RowBox[{"u", "=", 
  RowBox[{"y0", "[", "0", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"csol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"u", "\[LeftDoubleBracket]", 
       RowBox[{"0", ",", "1"}], "\[RightDoubleBracket]"}], "[", "c", "]"}], 
     "\[Equal]", 
     RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
    ",", 
    RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36697255017744*^9, 3.36697260531788*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "#1"}], "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "#1"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "#1"}], ")"}], "2"]}]}], "&"}], "]"}], "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "-", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}], "]"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "-", 
       RowBox[{"2", " ", "c"}], "+", 
       SuperscriptBox["c", "2"], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "c"}], "]"}]}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die numerische Auswertung wird von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " verweigert, da jeder solche Funktionswert einen Aufruf von ",
 StyleBox["FindRoot ",
  FontWeight->"Bold"],
 "bedeutet. Das kann selbst \"nachger\[UDoubleDot]stet\" werden. \nDa ",
 StyleBox["InverseFunction",
  FontWeight->"Bold"],
 " schreibgesch\[UDoubleDot]tzt ist, ersetzen wir diesen Funktionsnamen durch \
einen anderen und definieren zugleich eine Funktionenschar ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["y", "1"], "[", "c", "]"}], "[", "x", "]"}], 
   TraditionalForm]]],
 ", wobei jede Funktion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "1"], "[", "c", "]"}], TraditionalForm]]],
 " eine L\[ODoubleDot]sung von ",
 StyleBox["eqn",
  FontWeight->"Bold"],
 " mit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["y", "1"], "[", "c", "]"}], "[", "0", "]"}], "=", "c"}], 
   TraditionalForm]]],
 " ist."
}], "SmallText",
 CellChangeTimes->{{3.36643561590133*^9, 3.36643563996943*^9}, {
  3.36644189850327*^9, 3.3664419020832*^9}, {3.36697463234333*^9, 
  3.36697473317273*^9}, {3.36697626853329*^9, 3.36697627662893*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "y1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y1", "[", "c_", "]"}], "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"y0", "[", "x", "]"}], "/.", 
    RowBox[{"csol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
   "/.", 
   RowBox[{"InverseFunction", "\[Rule]", "InvFct"}]}]}]}], "Input",
 CellChangeTimes->{{3.36643566180759*^9, 3.36643566962611*^9}, {
  3.36697274046417*^9, 3.36697274120001*^9}, {3.36697278430989*^9, 
  3.36697278900756*^9}, {3.36697284663466*^9, 3.36697287693588*^9}, {
  3.36697623026584*^9, 3.36697628134008*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InvFct", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "#1"}], "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "#1"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "#1"}], ")"}], "2"]}]}], "&"}], "]"}], "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "-", 
     RowBox[{"2", " ", "c"}], "+", 
     SuperscriptBox["c", "2"], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
     RowBox[{"2", " ", "x"}], "-", 
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "c"}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}]}]}], ")"}]}], "]"}]], "Output"]
}, Open  ]],

Cell["\<\
Und nun definieren wir eine Regel, die InvFct[f] mit numerischen Argumenten \
wirklich numerisch auswertet.\
\>", "SmallText",
 CellChangeTimes->{{3.36697439565545*^9, 3.3669744061837*^9}, 
   3.36697444631928*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InvFct", "[", "f_Function", "]"}], "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "y", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"y", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "y", "]"}], "\[Equal]", 
        RowBox[{"N", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1."}], "}"}]}], "]"}]}]}], "]"}]}]], "Input"],

Cell["Die Wertetabelle sieht plausibel aus.", "SmallText",
 CellChangeTimes->{{3.36643619858145*^9, 3.36643620855486*^9}, {
  3.389337171130719*^9, 3.389337175800293*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"y1", "[", "4", "]"}], "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2.4"}], ",", "0.9", ",", "0.2"}], "}"}]}], "]"}], "//", 
    "Chop"}], ",", 
   RowBox[{"Alignment", "->", "\"\<.\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36638509033346*^9, 3.36638513821215*^9}, {
   3.36643568300303*^9, 3.36643571621085*^9}, 3.36643619554597*^9, {
   3.36697270095742*^9, 3.36697271197736*^9}, {3.36697274849343*^9, 
   3.36697275698147*^9}, {3.36697280383678*^9, 3.36697281332848*^9}, {
   3.36697629143973*^9, 3.36697629379867*^9}, {3.36697731916924*^9, 
   3.3669773676771*^9}, {3.36697748118969*^9, 3.36697749709204*^9}, {
   3.389336951189647*^9, 3.389337164124855*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"-", "2.4`"}], "3.4167190021114955`"},
    {
     RowBox[{"-", "2.1999999999999997`"}], "3.5354897120206275`"},
    {
     RowBox[{"-", "2.`"}], "3.6369556614780545`"},
    {
     RowBox[{"-", "1.7999999999999998`"}], "3.723003340795981`"},
    {
     RowBox[{"-", "1.5999999999999999`"}], "3.7951132835707018`"},
    {
     RowBox[{"-", "1.4`"}], "3.8544927920886045`"},
    {
     RowBox[{"-", "1.1999999999999997`"}], "3.902172328723268`"},
    {
     RowBox[{"-", "0.9999999999999998`"}], "3.9390851024620184`"},
    {
     RowBox[{"-", "0.7999999999999998`"}], "3.966144773263306`"},
    {
     RowBox[{"-", "0.5999999999999999`"}], "3.984337069963773`"},
    {
     RowBox[{"-", "0.3999999999999998`"}], "3.9948484453926576`"},
    {
     RowBox[{"-", "0.1999999999999998`"}], "3.9992744345354208`"},
    {"0", "3.9999999999999996`"},
    {"0.20000000000000023`", "4.000982215072933`"},
    {"0.40000000000000024`", "4.009619127544038`"},
    {"0.6000000000000003`", "4.042322116703216`"},
    {"0.8000000000000003`", "4.149590042156544`"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{"."}}, "Rows" -> {{"."}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output"]
}, Open  ]],

Cell["\<\
Achtung: F\[UDoubleDot]r x=1 wertet das Argument B von InvFct[A][B] zu \
\[Infinity]  aus und die InvFct-Regel wird nicht angewendet.\
\>", "SmallText",
 CellChangeTimes->{{3.36697841812012*^9, 3.36697848411455*^9}, {
   3.36697851975098*^9, 3.36697852134928*^9}, 3.382704582077171*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y1", "[", "4", "]"}], "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.3669774531672*^9, 3.36697746790745*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InvFct", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "#1"}], "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "#1"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "#1"}], ")"}], "2"]}]}], "&"}], "]"}], "[", 
  "\[Infinity]", "]"}]], "Output"]
}, Open  ]],

Cell["\<\
Selbst eine grafische Darstellung kann man aus diesem Weg generieren. \
\>", "SmallText",
 CellChangeTimes->{{3.36643621842285*^9, 3.36643623524728*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y1", "[", "4", "]"}], "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1.2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36638514384482*^9, 3.3663851529523*^9}, {
  3.3664356910506*^9, 3.3664356933449*^9}, {3.36644193841468*^9, 
  3.36644194987147*^9}, {3.3669728879187*^9, 3.36697288913765*^9}, {
  3.36697629977739*^9, 3.36697630001124*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13c8ld8fAHCrsu+1ItnJqmSGknO/qBRFKiVbU0lGSWSVZO+9ycre2QfZ
ZOfae4vIlvE7z++v+3q/znPP6zzn+ZzP+Xx4jV9rPiEjISFZICUhwX6drkzP
Hh7+gbvP2+nAJxyhcdt7wmb3D3Q2qbrzDhmfcWF4df0PtD3z1SMbOZbRrWty
/g9826PYwu2CI1SOilQ0dP+BVpO0YYfI/96bB/im/IFVDsOG5a44gnXWP3lu
9T9Q9RxpsYgHjvCSlTFAIWYZSspzVQ/44Qi3o5MLyriWYHaX4Z5fDI5w7874
XkLxIqQykv5pkoYjHMc/cPXTXoAyGgHzAoU4QrfTBbfyoTk4/16dsw/iCJm8
Zdma72ehrsDHpL+NOMIn6xR1we1puHIjCD/Zif7f1S5G5jAFQwKrmar7cYQG
vRiZa5yTMCs7efjWGI5gFd1T1BwzDo80v+YOncERLtPl6hTLjcGI1coLRYs4
gtuxwE8Pvg/D1iOP6RlWcIQhyi/HbdOHYZGYoRcfshi13bfI2GFoHeF9IInc
R/uofeTLMBzfdYVayEKMkiefPBiGzL9AQSRyE0d3nsXOELTgOPvy1CqOQC3B
NOFxaQj6M4rzifzFEbx1AwkVcADqWXJrsqzjCMa+BfxpBQPw1Sv2bT5kmZpf
lKHfBuCLsBdBYsjjgmyd5oEDsIiBOUcVWXotyoj/2QBsrG+zckYedk/+6Ek/
AKXdDkUXkc99L6nV1uuHpiE6n79v4Ag/GcZUNneJ8IqNwGWpLRxB8WMtz8Yy
Ef5cMXMgIBf9Td1emyBCKifWQjXkuG6L1NVmIpQ8G0L2BPlNMDnlUgQRblKk
cAUjs58QbJi8SIQSMkf015Cf85hd6bTthTSZLxlSt9F6/DQ5O8x64eySwpF8
ZE1SmY024154g3p0uQJZfuIwsfVGL3zWEPi1GxmX6E/RyN4LHS6JBx4gFwkW
/qgs/QUVetV9NHdwBIrze/9l7PZAozxyujXkbMcF1cnlHuj1fTNwD/lhR989
9skeWHrpE8PRXTRuUWji1tIDJWOsV9iQHxaY+T+O6oFDp4QUFJBz5MbHOBR6
oJlD3ckvyLrK9Y7ezt1Q2DNzm+EfjnAsuMC99m03rBqI12ZHzptOCPxn0g0L
FeJz+bDxL44pJprdsLW3/aokNt4k237lVDd0j9M8eheZUj2d66C2C/ZdFRgO
RC7U9qswo+yCm92MFHR7OMLYYDqbxX4nHArh7WBCptVvsLL62wknan4GsSM/
Nj4QthnqhJ4N1JRCyIwvTUOcczoh1ZhZiCKy+QeV10EPOmGXRMw9a+SzsSS8
pakdUPd5p1Uf8gNejg/l0R2wVi9dewTZ5asMsTKgA16Pd5OdQh5MMfP+8aED
UvA/HP+D7JEztNOq0QFXBwpGj+7jCG2fLJLgajtce30mQBJZuWmckiagDXqT
Wk9/QR5UiU2WtG2DNoyyBt7Ilo26yrrGbXDuKqEzADmugeiYKdEGHb9KxUQj
79f93FTv/gkL7gsN5SEX1ZRMBTH/hC+sT/4eRBYq96/iCm2BYCfETugAR4CX
1PWvObbAKObqo+eQtcpo914/a4FJj6o9xJFdSr/IVMu0wNOC9+0vIo8X22c9
6muGch+16dSQIwpNolJPNMNA066hV8i02f/ZSEQ1wnqSnw8zkJP8tYtXPzfC
MwRCSzaywhuL7ZzXjbDLZFc6H9lcLt7mvFIjfGFxZ7cEuecHyfuzCw2Q8JwS
NCBH9cH3ArIN0EOfonwMWbqMWDLN2wAvRzd2TSK3Rf/ZSaRpgFtPmKdmkEke
cdueGq2HMv80N38jP15ysOVxrYenjEb7t5HPkinYsffUQfMXPXG4Qxyhbupe
WX9FHby7QmLMiKzf8OpfWEodXHm+xcmC7OcVbcdqVwdTaO+4siOvH9+3Y+ar
g00Ol06cRi4/U/6B3rwWBsp7qMohq9676EBG+wPypKqR6CPz5/clTa/VwINa
Rw1D5D38u5+NgzWQ100m0hg5qzWfwze9BkplqfI8Q8Yrnys7qVoDp9qT5l8j
90rwbEt5VMOom6cdnJCz/Sq52SyrYdewxvuPyG7Lutf+aVfDPDq91y7Icmnh
IdXC1dA6S1TNDTmKl0n6VlMVPKas0+SLbIQ/avmMsgqSE48Qo5HfDKlIBo9B
SDV78DEW+XTY5486ORBetpQRicfmxx3yzKmj8ROOLxKRbx6s6pH6VsLrwoz5
ach9g0SiJF0FTDaMNilC9ghlFtwdKofM9M9bvyNfunPbuiqjHLoy94iUIMc0
NzPfVCuHz/DfBsqQH5VU3H7qWQabczaOViMvh3xtCaMqhcdfRYY2I7/rPjYJ
Bkogn7tsXgsyCd50dyatBGZEkjS1IjO6SwlLq5XAkXXhxTbkC3Z1rp0+xbDt
vhdZNzL8LhxjY1AMw/6eOcSssu5dyC1WDBnfCm73ID98pTX1qvM7dJ66MdqL
7GAw+x8183foQrH6cQD5WJSqdu5UEVTT53w0iMVDX7b5g8IiSHhABEPICbdt
YpO1iuA/Zbo/w8j1SlT7iuGF8I6B+OlxZHqhM8V2XAUw/MTcxgxy6GPfdr4/
+bBsdzp+Fpknfm2mCeZDtbvEG3PIEuzlLGxG+TBEOytwHlmL9qZVwdc8WF83
SfobeVQl10PnTR48ayoZgvn5Z5YEsit5sDM/TXAJ2fZguENjJhc+thNRXMb2
e8VMdEkoF4bvCmqtIAue674StJMDZRNe9WDOMZHRu9ScAy8s4TRWkWsmDj3d
X+bA5fOfwV/k1m+83aq62fCow/LhGvII3wJpxH4W5FP4ZbKOvBKZJzYXkwUH
nW91Ymb2UfJxGc+EGg1M4RvIepZPrlc8zYBkNqm0W8jW70JJn9JnQJftE/qY
/T40ldAXpUOLvuhMzDWu50QMj6RDUqG1q9vIQpEb1OSJ3+BKqcWjHWTFOMEf
6arfoGsfUzJmnSRtu7trqdDOaWMGs092xWKSYipckfN5tIud1x+fW1XGkyGv
baHKP+x7NH13WXVLhpwHa/aYBdvm5SPEkuH0Qmwu5od9NzMXHZMgG/995j3s
fAw7PgkSTIIG1GZKmL0ncjkvtydCLm8qC8xVv1l8fLgSoWXZdAPmgdVrV2Xq
v0JSNolVzGub7w9GX32FZFbsJ/aRBUhHzMQrEuCL5N7HmD1ZktV7dOJhgXTC
b8yJ7H3H7Mnj4cNEK5oD5Epu6qrT6XFQzBgvjHnizpDh8nosvJTxwxAziz6h
EyjHQjWxGVvMKs8T//MPjIG31xYDMWd9MOWTkoiGPNdKajCPu3YEfHaOgkuz
Xn2Ymf2lyIkdkbB4VmcJs23S3uT71xGw+QoF8yFyZrbh3ZbKcGjTOn8a81hJ
bS0HfThcJ5u8gPlKm1cSzAiF+6tCWpht+lZYGPZCYOCi82PMaRN3XY1VQ+Bx
1mOWmId/F2/mRwTDtqhKB8z4LY5nRxaC4KnULA/MSqTORC25IJj0bDgYszXN
9LVUt0C4S3s7DvMQd6aQqmAAzBjlzseME2EIj7L2h6edvpRhVpR6S7Vc5wcr
fqv9wPxWof89YPGDm0+tmzFr+Nv28Db5QDtJ6k7MRUmKhbXPvKFkBD0RM0cp
dcizo15QasZ9CPPHti5r6iQP2Prk4zjm2YmI+5lK7tDlxcE0ZpX05hyf2i9w
u+Pewv/f12qXyvyKK1x8IbKMmUZe5NHtehfYrumyitmU4mG5xLVPMDTl5Trm
n63uLMyNzrDIa24Ts2hwidmGihM8L0K+g5m7rMs3M9AeumX82MU8oSqhaB5s
C3uVJfYw93MasW7KvoItW3qHmIt9rb+JclyBvDSH//f+r6SakTRjIHuBBXUn
eMJ6Sk/o41tvAX547/+WYH07Ha9mA5TV35Fifu3KIjl6ww7YMjGTYc7YKHTi
uO4A2syI//dbiTOzGV+dQHNqHTlm5hf/vFv4PgJDmkkKzHnxLVIL8Z/A6oTk
Ucy3+yMHKXk/A3WH8mOYV/CmHwXjXEG5qDMVZl8VeeGr3G5g+ZorDWZRJ9qO
xzHuAM/TQYe59fuQ9SdOT1CLe4TH/PJPBmdClBcQslRiwkwtaF9bddIHdCS+
PY45Vf/my9EIX9B+7OAEZv4WeqpDLz9QvD/GiXltxlrXR80fRC3y8WGuIRvN
5qQNAAxyjQKYA7iukWe2BAAxjV9nMBtdzNaS9wwEIdG3xDGLabGmtdwIAmZ+
sjKYSSwd9x9SB4OnEaGXMbd7z2osNAUDeN5cGbNZ3fctyuuhQG0g9g5mhXFu
1TDKMNA8daiDmW7/S4xgYxhQeLL4+P/7LfXgytVrEWC3zdoGs51GVdivo5Hg
Yg33J8w3TIV+P66PBI/AUx/M81+3Az5diQZslCPJmIuh4QzjkRjgaclWgNlt
sFEuoTYGFCWS1WAOdFczH+ONAyxl26OYbUNJ2FOd44BBN90KZuOkgh+vx+OA
z8lpElIsPqo5WA/j4oFM9W9+zIxKz2RMd+MB5aP+C5j/1ube77+TAM7IOl7H
nN94NSz/6FdQnXvEAnPQDf9iHsOvgHpz6TPmN62Dfd4lX4F2ZkwkZqkO8xPP
TRNBaMvzJszMmmVyv+oSAc2k+zjm9e4jDxW5k4Bf28ddzIXEiAiOriSwGU5z
ngz5wmjtyU6ZFCBSM52A+bgRTl7BPwVon5Gowbw5oa2bvpACFPzeTmD+PrMc
9Tk6FeRQrZ4mR5ZdZuO6SJ4GzHSFSzCzmT9SSNFNA6bSUWOYt1cz9ZmL0kB9
2WkqCuSSDcXY5efpYKfLSw/zxX1Tnq9tGeCw+CTzEWR2x+8EvFAmWLItUMa8
S0JmZO+cCSiEXawxl1GExt+XygIlgX3DmOVpq/loI7KBk1Bj2VFkDh8apfdr
2eBGtccm5oNj6eJWAjnAmSVJ4hjyiPvG7THHHGD9aTULc6y3R0CpRC5QPNAr
pkT2a8vmszDIBTyLmgeYnXC/8gS9coHDZtUVKmRDf+7uoOlcsHT1RD9mnuAC
ptdheaDzqTgjDXJ81EjQqYN8UKhc3kmHXKo7pLsjXABqI/TO0yN3cQzwt98r
AOVS6T6YyaN/FdhmFgBcuo4mDvlJdGtPp24hsDH8vIxHdtBrjkpxKwSnPu9p
MyCHcDY+ti8oBKSs/zVgboj+sS5EWwT4lZRSGJGFY0qZncqKQINrvD0zsqJ+
8dC92SLwsG1nC/NDrqLEM0zfgbTif29YkD1jcqWIL74Dj7Isy+PISzGpd0XZ
iwHLL7svbMi5sSFBQzYlIDU+iZkTudkgSDcvsQQoSG5kY57gDuB36ygBYwrv
b3IhM8V5F0gKlQIdMzFfbizfxbn0eBBLwaER8Rwfsly8JbPchXLwO3R1UBBZ
08h8iN64HHDsxUYJIb/gNUuc8i4HxLRmA2HkyHgTKb/pctB9IWVJBHk/3vDu
bFAFCK/bFxRFrk64FRS8Vgng8/MnpbH3MwXep05BwKXQe+ICFv/SYq65mhBs
UdSclEEWaGKw+ZkLwUGSk7Acct27hUwy2SpgUqf86vL/9y/T/+JmFSgpvx55
FYt/MgEfUvpqEMnA3XkNy3fPYjwaT1eDetYo6uvIOuK+n7TuVYMyy2Q3VWTv
WvO3lgXVoHo8M1cDeXVBUjvNsgZ8ouWt0EGuVM+4Z+FRA1w6zMT0kD0K+DVl
E2rAO7qWFH0s3zqwqNZ3Il9oSjBC1mLYkp8Q+wFuMgY3P8PiSaaUh/3PD5Dr
BWbfIH90Icy5v6wD7edNXQKQ1Vz1FUud60BJKPPjIGRWtw9RC6F1IFOJXCUE
y4+exRqqtXXgaUAzRwQyMUCshJazHtwlSdyNRz4bz+Ph21YPlKuTvPKQtxIU
puBUPXixbp5fgL1/oq7Cym49iK8cGylCvp8a9ldDsAEQztcrlWHrycbrMDo1
AKqt21drsfkrSM4GizeC/17WSRKREyCXa921RuCUU5DSj2xaLT+2odcIzFLS
eIaQyepsgrQ8GgFX6Q/ecWw9rSt7rJONoLn6odEiNv/A2M+IoCbAejJjkIQU
jW9VvY7bagbFGxIL55G/2z+YyMC1gCuWPbckkRUpVu6WCLaA3gbN0gvIDxi4
L3bdbwFCoZTJl5FdzthTUBS3AGp1tU5V5EEDufBnNq3g6a8pBxNkj8bcGtGd
n+DeOdG3acgs6telLzG0AU2SxPos5LhfYynXhNvAVCgrTz5y0QTO21C7DYwv
cS6WIU/svbofUNIG+lNzJ34iy4mL/N543w44tw0M15DX1To99O07AHVW0oAy
GZ5AIcYUcNa9A3SEPT99A5mJ6V74blAHcGDDv1dHlujvSwnJ6ADqnFKXHiKb
PxmrbRvsAKU1U2fMkZfs/xwoXOwE222JDdHIM1l0VtxbnaB2lU6MhBzFs7+6
7RJZFzhmsZl2FPnIW3/nMvoukMpMK0aHzH+Jxe++QBf4ODf/gB3ZuIEj0/de
Fzj/MlZAGnl09MzsYX4XOGrhUWaK3Ie/oTNm3g3096ZOTCE/rdFnmLTrBgkl
cc8XkTesrBqmXbvB4Cvz6r/IjMQoycWobkAHLP1JKfCEm9F/aDYbu8FoGn0G
N3KNcHA5DW8P+HTzUo8ecobiGKdMZw/g3n9+YQL54vp6t9xQDxAQ6BlYQG5K
ovKQn+0BZ+8Fe6whz1BKbv633wOMjyjTHjmCJ/C2f25TE/4Frot+CBdCDtE5
42js/AuU81VOWSA7v7Ee8xbvBZ9FX3vSHUX7OdeQ4HC5F0jyuniyIevrnnjy
+nov6D/jG3EKWV65fF7DqBeIE2um5ZC3mcjWmPx7wcZTRYlnyGb53kciVnrB
Af9gTi3yw7+JIsnZRGAdN5PjeQxPuP5083dIGRH4kptmhiHLDlzL/tJABPmd
A6VJyCw1C5Imo0RwN6uIsgq5w1/s8llcHzDwkrXcQL4qXq6eZ9YHvlJxeT6i
xBMkzbvfVJ7rB4FNGjdvUqF4zNuanpTtB7UyIi46yPQbJ+9TKfeDstuJLSbI
C+8fy9192A9c7Iq8XJETPm3sz7v2gxH6nb4qZHwo6xeWsX6wnHs3RZYaT1iu
0Ak3DRgAzNco3aVp8ARdEifqgOgBoH1/a/UKcrNiot331AHQNeD4Sgs5ueG3
HhkcAOwbsVHvkPU67fnCFgfA5cq/Q6XIrVOx6T+UB8FoYN26Mi2e8I1mqoJ9
axB8+6n97xkdnjD26mDvGNkQkPgR/N4Wma2DTX6DdgjsMbbReCO7Bd0sbecb
AiN7703zkJ9zfi9yuTUEdo9l8RwgC533yF5OGgJGgZKPw+nxhBRNsfiau8Pg
osqbvlEcuv8LboxlGwyDCXWLnXXk46xPuKNfDAOH0jIxajye4DoYHv3OaRgk
an+ZkEJ++pg84mzGMCDy8d/zRBaw7g0IIR8Bb76Su8kz4AlJ4R9cXuSNAL/2
qoIcRlSfVna3X6kcASkC5j3NyL0TIid5m0eAY6AVwzTy0bP9ucTxEbBbODt5
ggnNXyk9qswwCiibE5ZckAUml+W4zUdB3uWCTENmPOFuSM7W/PEx0FoqkHv+
OPq+QrrRRI4xYIDXKbiJ/Lv0mFId3xi4RpbS9xLZZVTfJ050DPS0Hf2cilwg
RHf6/tUx8OvmW/NTrCi+ykw0a9+OgfXl/SxuNrS+Ub7MmJ4x0HF5okSCHZ33
fpk0gYExsKHI36WJvNSllpI1Ogb0P69RWyFT1FvHVy6MAT7hvJF8ZImM5uAR
knGQ2UjKKHMS9SM2lg5c58bBo8apGiUOPEGFoUY95vM4mOX7ePYdF57QQ01U
E/AcBz4PpQIjkQ0ofl/P8hsHihnvuKqQrbdYlCsjx4H5l0tfqbjR/g6byI7k
jgPxv59NYpDJ0hh4uUbQ81oslO08qB5UNPobfWECdPza9bp5Cv0/OmgjSn4C
qHzYUbZFlthu2I5UnAB5O4bnUpDTMkUPw29NABJRaT9SfjwhjG2PJuTpBNj3
8/xajGy9HHLaJwQ9H+IvKiaA+pWI1gcOmxNgz+jc7avCaL/XD3Xs9ybAvxeW
9u+RU9QlDT6QTYI8oZ2xDGSuIxFPbOknQaJC6S1mEdSfmD+ztBaYBGzd8S3T
yAtXyLzMtCYBn2erU+BZPCFxVQbqF02CGJLHYSfFUD2a33Niu2wSTDHPKmki
R7y1eONfPQnKkxIE3JH9d9KEa1sngVj5t4AtZAdSriDhyUnwhVaLhiiO7mMG
CpN13BS4zsSRHyeJ+jvxDkYPkymwbT/lZSiD8v2a6atTr6dAzjdccAwySSFV
Y/mbKZCEUx4aQt6SVbL/4zgFjEb6hR7K4glThKLZuyFTwJVcpea+HJ5QoRFV
zv1jCmQ0zUoaXEL50vz500KOaUDJqckSD/AEDUWSVAm+abA9rSw0gyzGHDaf
LTgN/jtW7XSGgOqh7w2maRLTAG64k6NKn2B5KGAVqzINLFZmH3T+h/obn2lH
9zfToGYm1o1JGU+wyTAO12udBmFbAUodKuj+dtgdGOicBrUq9Mlc11H+1Ajg
eECcBhmqCQ9eIe+sVcdqTqD13HfPprmB+rNLvMnXttF67iaLqqniCR+aR/PE
+WdA2/mv9UM38QTHOd3WIx9mgHxLBB+4g+r/k0zMu84zQFHJqz8WOe5Wk87y
lxmQe29in+QunlBVIL3YGzgDKNLI/WuRyZzpqVPTZ0CD8/VVDS10/k5UXbsx
OANMnSe5HLVRvrpx6ofPxVmgf6M/QNoQxZt9P/UnwizwaTkhkIScmuOr+e7q
LHCkOnuJxQjdZ8f3xg00Z4EL4dvSJjL1ZA+J+ItZUHDVz63qEaov7VwVusNn
weira+DVM9RvZ8yXsO7Mghh31lsSr1G9cZVKO/lgFngIGu+mIUuMC21LUcwB
7jv2ovzmeEIny/MLmrg5kM56XpzNAuV7x5k8r9NzIKn4ZNFRK3R+b0+mk2rO
AX6nS+YH1niC1+ZQ9GLaHDgfzOiv74gnDPntydvmIMsVtM8jnz3DMURZNAfG
+Cty3zqh/G6gwy5QPQdqU3ce+TrjCTRN/SGGxDkQGaIa3fwJ1VORvb6/yOfB
iLKWmpEbnvCF0OEMdefBQ++8p6wBKD/K0wvWGc+Dirx/ZfXIrjJqrc3P5wFN
5dE960Bk0cbjvW/mwWE/j9JAEDJHVfpvr3kwahXGmRGKvJ3960TFPBgz7g5y
iEbfI8dX+A3nAqCl/CT0+xvKXxk/296fWgDGyos25WloPIXmjaPwAnhMOFzz
TkeO+VLpIb0APNRqrKQyUX2gItKAu7kADncjg+1y8IT/Ad6LU5g=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 3.95},
  PlotRange->{{-1, 1.2}, {3.9390851096078423`, 4.172346437115947}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell["\<\
Statt einzelner Graphen kann auch eine ganze Funktionenschar untersucht \
werden.\
\>", "SmallText",
 CellChangeTimes->{{3.3664362469311*^9, 3.36643629827637*^9}}],

Cell["\<\
Im Bereich 1.3 \[LessEqual] c \[LessEqual] 4 zeigen die so gewonnenen L\
\[ODoubleDot]sungskurven ein regul\[ADoubleDot]res Verhalten ...\
\>", "SmallText",
 CellChangeTimes->{{3.36643630866307*^9, 3.36643638174525*^9}, {
  3.36697323664356*^9, 3.36697324022199*^9}, {3.36697327461668*^9, 
  3.36697327580435*^9}, {3.38270463536164*^9, 3.382704637141459*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y1", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "1.3", ",", "4", ",", ".3"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p5", ",", 
   RowBox[{"vf", "[", 
    RowBox[{"1", ",", "5"}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.36638514384482*^9, 3.3663851529523*^9}, {
   3.3664356910506*^9, 3.3664356933449*^9}, {3.36643597236892*^9, 
   3.36643606885238*^9}, {3.36644199676428*^9, 3.36644210749922*^9}, {
   3.36697290762136*^9, 3.36697291358155*^9}, {3.36697297674361*^9, 
   3.36697325762006*^9}, {3.36697630778497*^9, 3.36697630820461*^9}, {
   3.382704606489332*^9, 3.382704613853804*^9}, 3.38932620610199*^9, 
   3.389338652208022*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//AHB771IpJEqSUBlpeL1REslIEkoD9VEJiUQIoWTLSmbDyChk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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc4le//AHB7RkaatgYlqZRI3g+VFkIloaiMPtKgrIRCkpWQvffIKMoI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      "]]}, 
    {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//AHB7ExoiK1SSoiLJJ683lVR2slPKKAmVUsoISRmhsrK1ZIfM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      "]]}, 
    {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//AHDX3hlFREbJ/CApaZ2TColEkpAWKqmQjMyMkpWVlWwysrfk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      "]]}, 
    {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//APDqula2JEJGShLKCuUcDStZFUJW4aOJqCQUEsnI3iOSUmRl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      "]]}, 
    {Hue[0.8503398874989481, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//AHAN9yIro1J2ZCaVWZ+c00JJobIJhUhCQpkhaRhJdnZJdrLH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      "]]}, 
    {Hue[0.08640786499873876, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//AHClce+1d8qOoiRk1qfOkZISIUUoGigtKaWEQhKRlexNREa2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      "]]}, 
    {Hue[0.3224758424985268, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nk0Vd/bAHAVKfderjlF5giZMoSyt1RUZiVTGtW3kjSZooRQIiLzrETG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      "]]}, 
    {Hue[0.5585438199983166, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc81d//AHAVFbnDLiFp2SsjrXMaRqFQyYpUtCUfI8kIiUT2yl6RnS05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