(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    455177,      10505]
NotebookOptionsPosition[    428741,       9658]
NotebookOutlinePosition[    432264,       9757]
CellTagsIndexPosition[    431661,       9740]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Funktionen und Auswertung", "Title"],

Cell[CellGroupData[{

Cell["Einf\[UDoubleDot]hrung", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Set", "//", "Attributes"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected", ",", "SequenceHold"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDelayed", "//", "Attributes"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected", ",", "SequenceHold"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Ein und dieselbe Notation auf der rechten Seite kann f\[UDoubleDot]r \
unterschiedliche Objekte stehen.

f1 ist ein Ausdruck mit zwei Symbolvariablen
f2 ist eine Funktion mit formalem Parameter x, in der eine weitere \
Symbolvariable vorkommt.
f3 ist eine zweistelllige Funktion.
f4 ist eine Schar einstelliger Funktionen mit Scharparameter t und \
Funktionsparameter x.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"f1", ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f3", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f4", "[", "t_", "]"}], "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}]}], "Input"],

Cell["\<\
Das erste Listenelement ist der Ausdruck f1.
Das zweite Listenelement ist der Funktionswert von f2 an der (symbolischen) \
Stelle x f\[UDoubleDot]r den speziellen Wert t\[Equal]3.
Das dritte Listenelement ist der Funktionswert von f3 an der Stelle \
(x,t)=(2,x). Das erste Argument (f\[UDoubleDot]r x) ist eine Zahl, das zweite \
(f\[UDoubleDot]r t) das Symbol x.
Das vierte Listenelement ist der Funktionswert der \"allgemeinen\" Funktion \
f4[t] der Schar (der Unterschied ist wie der zwischen f2 und f2[x] im zweiten \
Fall) an der Stelle x\[Equal]3.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f1", ",", 
   RowBox[{
    RowBox[{"f2", "[", "x", "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "3"}]}], ",", 
   RowBox[{"f3", "[", 
    RowBox[{"2", ",", "x"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "t", "]"}], "[", "3", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"t", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"5", "+", 
    RowBox[{"2", " ", "x"}]}], ",", 
   RowBox[{"10", "+", 
    RowBox[{"3", " ", "t"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Und hier werden schlie\[SZ]lich f\[UDoubleDot]nf der Funktionen aus der Schar \
f4 grafisch dargestellt. Ganz genau: Dargestellt werden nicht die Funktionen \
f4[t], sondern die Ausdr\[UDoubleDot]cke f4[t][x].\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f4", "[", "t", "]"}], "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"u", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], " ", ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1", ",", ".5"}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", "\"\<\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"-", "1"}], ",", "1", ",", ".1"}], "}"}]}], "]"}]}], 
       "]"}], "}"}]}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Hk8VO/3AHD7HqJEliSVbNlF6Zlky9pGSklEpWSJD8WHSYoWFSFJUiLi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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nk0lPsfB/CR7RLGEl3iVyFJ0qJGifk8MmUpJTX2rOXOTQ0hXLKWkhRK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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Hs01HkYx/FBaqM0TDMtNVZGbYtcMzple35J7RBzlm0zbSLZON0m6YJ0
kHRMK+WQbZI27XRZG2ps1m3yrYllSyyjwY7EmHEZzfyIyrjNfvec/njO+7z+
/5xn5b6jIfuNKRQKF9//dQGGxmAgEfNTj+pZAv0UiSa9mLWTuA//cF89/p5E
1w84zJG4HmuC9g2MkIid4SntwvW2TP+3qYNE1dd3/JCPS/SPPb/2gES2jr8+
byklUUjGy/ueESTy6T543zyMRPEt6UdianWoIa/sSINYh9rbzTVPI7WItURy
a8RRi5hPji71XvEWcWz/nnQSjaDyQ3WmS15r0K09MdmzCzVo70X30a60YZQZ
XrPe2GMITeYkCRAMId4lOtcuYgCJLHqshX0DiPNFQN1ejgoVBLjHyS6oUaiP
xG2LrRKlHY5M+MpfhQLnp+RL596gJJPf4+O0SlSae4xf5KxAkaktDvLf+hD5
7rAHJ16O8h6rhQUHe5FlzEPj4nutqPrNmkXF9j0o8OmYXS+/EbGohO+OXxRo
fWS2Ph7VoDJHwUFlfyei2pcHEWWX0Zt6sR2bLUeF0fcMvtsfgdo5zwP9KUMT
3YMp17vrwTK5iO1i1Ipktwt19LOt4Mwmne+MN6GSqEObJZ0dcM5P+09VQgO6
kdgnlI31AH1HafauZVKUuHarm71VP5R9qF/S6FCNtkcJK25nDMAdhTprOL0U
WR0Ly3X9UQN7glc8UkRdQaMTxcNKax1UmSW9kp7MBVc7a5lBMwpeSiPbs7wH
YLbTP+Su4R2wRmv0G6RVUFf0wad/dgL8RV0vuTwpDJYbSPD6CFuDrEzelzcA
a7+yojFWD5cjOlLdKprARTVR0JEzDQ1c5uJvrVqhB+mmnMZmQbuSntyWL4PU
3msRG20oxMkTTpGXGXLwE/jRY3yMiI5uakh0Yycciz8TvSnZmNib6DO4IFAB
qbI4Bk1sQjxz8v7pmWkPZApEXPk8U2L1QsnQbU4vVIUwWM2c+QRTcmirqaAP
sr8sV5dfXEBQpoyL4pRKgPyfFYzxz4iPwY/D61epgO870eXMMSMU6yKWr0pX
g4eCzqc8NSdiQ6mW9t0DoBS+7IANiwnrKyrePOYQzOTq4+8XWhCluwvvjScM
wzdpOpt1DCoR+nUKp/GxBsoCNyf5tVEJcfgR+w0zI3CYWpIjzbIkJs22mFR9
r4VX63iU0jArIqR1I5sp1MFb1yeui1bSiGv2K2IvvSeh3pN1PFFPIxaZz2NX
YhOxcZm52MnjI9N92I+4LaIS7H11NRleH0i4NCZu78N2jt59sxub0mLjHTBF
I2qL8psdJ0l4PXR6zmaaRqjcrNc2TJFwXnjiqmSGRuy0NhofxQ5emiCWYzca
DVfaTJPwuceFF6PYJW2VfnzsvO/aDQ6zNOLUCV4YfYYErovFgSzshZVXM6Nm
SajxpW4Kn6MRZwpTgrOw3Xq0vARsnSBmWQV24fKu4znYbbu8RWZzJPDPdBb9
hV0wLa8WY794dZrhaqARFqraVAX20rP17v7YqU13t5niafGamUFR2PtvnGrj
YbdyP567it15PlyYhm2alnBTjB3A3xZejO0ZuqDmBbZkp4uDHHt3s0iuxv70
zyB5MOidAfs/5PGWug==
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx3FiujC5ZWYi9gg5iSwS6fb5dKF0sc1saUqIVjbFtDaTUpKm
2IuS5JbtsrqgMkk2xLylRK02t2aU3Abl/iVLZgzf/eye/eF1nufxD7zmBwh4
gdPU1NQ8yf6tHWL30jQFVv+VBoHCIk6hpOBRipmFQknDg3wHq5FRCm7r2CQO
j9LguHBrwMc+CvJ3YoO2Phpc9EXvq2UUHPM6lJ4vowF3DL9KE1Mgnv7qlZOY
Bl7s67tL/Ch44ZBx95oPDUffiEKCJINw/eGVEE7hFDQ0aPc+9R8A1XBHhZf7
JJiWCQxdTPrBUZBxLq91AgoOPmfoNvdCTidr87kflbD3V4ehdzE9IAwXGoa+
H4fxxMg4QN2QlbCxT/DNF8jUaTFKbf8IY2xDgSppFDI2OYTV/9QFx58JudoN
IxBzyD/C2qMTGo7WBLhZfoZIjZyjYQNyyNn/Q0rHmiHwj35jKc1qh0YFY/Xx
zn64XNqVmhHcBibDq9LDVvdAcetC5j3zFvi6bZuOzuIusNDDa7dfbQJXQ56Z
0YZ2eLgoLlje0Qhl9aOHjrS/g9aKPDNnZyks66/cG2hRC122lx3hj3poOLG2
S57wFPSjsp3t1Guh5sHLyQHFKWTrTNneGqkGu4ufdtSXlqMz6wdqiiIqwVsW
/EC4tB6xtucm7OKUwyf7Jakpc5vRw7EK3SrLYgi/ea1Ae10HutXUFd8jygX+
nChlW2Q38uGaPGralwSBBkzmc+EAKtKKfFsefgntZgpapMuG0VK5+len+WJk
EujqHawcQRZDTxTLy4vQi+8T+6enjyGPzHevPfnlaFtv8UuPaAVy22qgMVpQ
iapz1/Njg1Togp8s2v5xNTKr0b1fak2jSk/T2dsMalHVrHl0q7E6HpjPiqpL
r0cS0R7x5fhpOPyIjf8FthTVjR1Qd6U1sOyDHm9/VSNiXpLYb05h4L3HVn6a
saUJ3QvYPSfJeAZ+ZuPy8zNGC9IM7YXzFTOx1ayS7psb25DGDjefL7u1sGnJ
QTdGXDtKZuu5PB7UxmrKadlhcjkCvuxs/t3Z+Au31LdiQSfqT850uMrVxU1O
fvMWiLqQU4PwveZFPXx4p56++YePyE820+5mhD42Surka5p2o9N7jDaMfWuA
c72v3xmJ6EGl8fILPLc5eOeqUxurSnuRjxNXNGltiPN8Q8yXq/rQ2hKl1GM2
C49rrdMo2jGAnJLLzAJnsDGvdoWzaeogYufESnX/ZuM0c5PD50cpNLfQao3N
OAcztTWdC4lvDDsmbiKOGumbaCe2fL2l4wBxwPMnsUvHKGQcnH02i9h2v/e1
D8QVK6b/uUDBwZLs9L8WjVOItdqTb6bk4E57o8WVSgr9LuGcZKk42MtIfWSI
+IRL4xsn4ir1nkLjCQpxebfNtxPfrytcH0rcF3KwKpFYeIS/h6WiUPPKNEO9
SQ6eVZjyy75JCpW4nhFrTXHwieunuPHEuM5UYxHxYFwQ5zGxhPnCy4O4bpdL
ptYUhbKC0FQsccaEtDiPGBW83cqgOVinUxLdRJzs03zDkji6+rY7g6ZQ953P
o+uIA38T1vGJT5q7X40hbjzrmxpDXMYTfb5BvCnU3fcescqyxv0pcYmXnaWU
eEma9ZU24v//DH0nTqBo4n8AWu2Q9Q==
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Gs01GkABvAZY0wN5VKUZiRMNYkJrdHa6n1VJO3YqI22lkaJQ9LaUVol
rJhuq4Y2WpWOdduKIrmE95/LssW6LmpQpmGjxp8mjGZq9u2c/fCc5/y+PZ8e
q6BI32AdCoXijfO5ecBsTKslUWDxJVKrZRCRszbi2Q8kcvbKVLpqGMS9UscV
yikSgfe3JNEqBuHEFQSNvCHRSHTprdEJBuFinPS8pZdE59b00lqHGAR8Nfkk
s5hE3JNWffH1DMI3pfX22kASlf/0mMhKZhDH25IiQmrHkf28NZJcfQbR3a0/
9lioQE7jooHf1HTCgohc6MJ+i7JXholHpnWJsvAGuuHAGNo0TzOiN0kj9l9w
nHiWOIq6rm9NVrTqECpJrBiB18jEvr43v5xK5MwfNM8YGkGcVOpGeSKFyPJy
jOo6O4yaQ1OZUxmfUOJhYcyqbXK0kEe1fO6pQbG0P45HKWQoNNSjK6tiFgnj
2zg9BUOIXRPmWOAxg67UDGdkhb1E/r2XM1O636OqF1yDO9aDSK/Aielk+Q7Z
GMFNu25I0XZ2lNtmMxKV2IrDZK/60DptbfjtoFH0ovH+Mj6/Bxk8qyZa77xC
w3ZXnNDDLuQdzs91ON2PjOMK+TxqBxL4lcR5JLQjOz5pl6tsQXQvw6Kc8Afo
5y2K9sqYJhTc3W4ZIq8BpruKLu1ZVIcG9Prbxgy6Qcl0o2EzpwptfCoIGda8
ALnS4YujSUXoRtlNoSRtBHzvw34gPZCOnq8J5+V2vQWVzNh/6qLTwBlVw+jd
5EngLKMuTfAvBjzRqoO8qffAZuLRrGtdJfhrJS/Llq8C23KetXr714HKpcdy
dj5VA3eBCW2qrAmIVHkq9wAtSA3sjXcobwFzA64M+uynwiZvi3k7TDrArdJa
iu0GGlRYmcZ1XusCaq6llqTQYbRotTDVrAcIg1MVzDo92Ntv5HuouQ/kF1HU
fvfmwP0n1v/L+FoK+ibdjEyTmLB+tcu5evogOLnT0XFrsgFcMbf69e+eL4HA
T3R1WcR8aFEd7k4XD4G2ROct+7hGkPJBpzBKJgPZ+gaLuU7GcManJqBxuRyU
RRc2pNibQOkXgazlScOgvUp26qzbAnjUz8jYun8ECGS2R7m7FkLzdLm/rsVr
oEs6d/7qZwqL9mbnK2NGwdrMHt0fRGbQb8Npz+aaMTCHLbz4MGERvB8QYe2q
eQPMQz1ZHRcWQxVzM63yWwVIm+G6sUvMoW/HV3yLjHEAOd+cWtC0BGZas4/+
MkWCw+ttDQemWdBAX5dfgU37UZlBnWHBOOUb9RB2+vYn1iuwgxoepThPkyBP
ls2PxLY7tPdmP/b5gskAqooFawuv/W2rIoEgzapk+SwLyh3M7Zs+kKBWXhV0
RM2Cu82pygns/O/WjUuwm6mjFUvUJDgXVX+iHPtuZ8WWI9hQrHOZomHBYyL/
faYavG87h5Bgz624ev7ARxLUOEwvK//IgiezT/tcxN7xp+CuFHtcHLKoHLv/
Y8mXlE8s2LnHJYf5iQQy3zzfbdhZ6p6q+9il6Q5npNjz5bXxUuzFrlPGFC0L
xrfkedC1JIhJaLrBwQ6+fqzTH9t2Or0iArvvTEBGInaszSV3CbbXEY+AO9iN
7zI6H2JX7+ZxerD1DxYHSrH//zPgdbzrrRb7P1sZgmM=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1, 1}, {-2.999999877551019, 6.999999714285716}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
      FormBox["0.`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {-1., 
      FormBox["\"\"", TraditionalForm]}, {-0.9, 
      FormBox["\"\"", TraditionalForm]}, {-0.8, 
      FormBox["\"\"", TraditionalForm]}, {-0.7, 
      FormBox["\"\"", TraditionalForm]}, {-0.6, 
      FormBox["\"\"", TraditionalForm]}, {-0.5, 
      FormBox["\"\"", TraditionalForm]}, {-0.39999999999999997`, 
      FormBox["\"\"", TraditionalForm]}, {-0.29999999999999993`, 
      FormBox["\"\"", TraditionalForm]}, {-0.19999999999999996`, 
      FormBox["\"\"", TraditionalForm]}, {-0.09999999999999995, 
      FormBox["\"\"", TraditionalForm]}, {5.551115123125783*^-17, 
      FormBox["\"\"", TraditionalForm]}, {0.10000000000000006`, 
      FormBox["\"\"", TraditionalForm]}, {0.20000000000000007`, 
      FormBox["\"\"", TraditionalForm]}, {0.30000000000000004`, 
      FormBox["\"\"", TraditionalForm]}, {0.4000000000000001, 
      FormBox["\"\"", TraditionalForm]}, {0.5000000000000001, 
      FormBox["\"\"", TraditionalForm]}, {0.6000000000000001, 
      FormBox["\"\"", TraditionalForm]}, {0.7000000000000001, 
      FormBox["\"\"", TraditionalForm]}, {0.8, 
      FormBox["\"\"", TraditionalForm]}, {0.9000000000000001, 
      FormBox["\"\"", TraditionalForm]}, {1., 
      FormBox["\"\"", TraditionalForm]}}}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auswertung von Ausdr\[UDoubleDot]cken", "Section"],

Cell[CellGroupData[{

Cell["Attribute mit Transformationswirkung", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "[", 
   RowBox[{
    RowBox[{"Plus", "[", 
     RowBox[{"x1", ",", "x3"}], "]"}], ",", "x2"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "2", ",", 
    FractionBox["\[Pi]", "4"], ",", "3.5"}], "}"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "2", "]"}], ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{"-", "0.35078322768961984`"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"Plus", "[", "a", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],

Cell[BoxData["a"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auswertung von Plot-Ausdr\[UDoubleDot]cken", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plot", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ivar\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(-2.9998774285714287`\\) is not a valid \
variable.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ivar\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(-2.877428448979592`\\) is not a valid \
variable.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ivar\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(-2.754979469387755`\\) is not a valid \
variable.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Further output of \\!\\(General :: \\\"ivar\\\"\\) will be \
suppressed during this calculation.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{-2.9999998775510206`, 0.}, {-2.8822280327908176`, 
   0.}, {-2.754549857487248, 0.}, {-2.635332698579087, 
   0.}, {-2.518454107086743, 0.}, {-2.3916691850510325`, 
   0.}, {-2.273345279410731, 0.}, {-2.1451150432270625`, 
   0.}, {-2.019223374459211, 0.}, {-1.9017927220867685`, 
   0.}, {-1.7744557391709594`, 0.}, {-1.655579772650559, 
   0.}, {-1.5390423735459755`, 0.}, {-1.4125986438980254`, 
   0.}, {-1.294615930645484, 0.}, {-1.1667268868495762`, 
   0.}, {-1.0411764104694852`, 0.}, {-0.9240869504848028, 
   0.}, {-0.7970911599567538, 0.}, {-0.6785563858241136, 
   0.}, {-0.5501152811481067, 0.}, {-0.42401274388791677`, 
   0.}, {-0.30637122302313563`, 0.}, {-0.17882337161498782`, 
   0.}, {-0.059736536602248806`, 0.}, {0.05701173099467323, 0.}, {
   0.183666329134962, 0.}, {0.30185991087984193`, 0.}, {0.42995982316808856`, 
   0.}, {0.5557211680405183, 0.}, {0.6730214965175392, 0.}, {
   0.8002281555379268, 0.}, {0.9189737981629056, 0.}, {1.0353808733720673`, 
   0.}, {1.1616942791245957`, 0.}, {1.2795466684817152`, 0.}, {
   1.4073053883822015`, 0.}, {1.526603091887279, 0.}, {1.6435622279765396`, 
   0.}, {1.7704276946091668`, 0.}, {1.8888321448463852`, 0.}, {
   2.0171429256269704`, 0.}, {2.143115138991739, 0.}, {2.2606263359610983`, 
   0.}, {2.3880438634738246`, 0.}, {2.5070003745911422`, 0.}, {
   2.623618318292643, 0.}, {2.75014259253751, 0.}, {2.8682058503869685`, 
   0.}, {2.9961754387797934`, 0.}, {2.9999998775510206`, 0.}}, {}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {0., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"Sin", "[", 
      SuperscriptBox["x", "2"], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtm3k4lN/7x4eZMZaxzvBBUhFZWlTK7pz2UiktUpakBVEpQkiRIhWSImQt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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-5.466779531487192, 5.466779531487192}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Hiermit gab es gelegentlich Schwierigkeiten, wenn beide Kommandos auf einer \
Zeile stehen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}]}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{"u", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtm3k4lN/7x4eZMZaxzvBBUhFZWlTK7pz2UiktUpakBVEpQkiRIhWSImQt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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-5.466779531487192, 5.466779531487192}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtm3k4lN/7x4eZMZaxzvBBUhFZWlTK7pz2UiktUpakBVEpQkiRIhWSImQt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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-5.466779531487192, 5.466779531487192}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Auswertung boolescher Ausdr\[UDoubleDot]cke\
\>", "Subsection"],

Cell[TextData[{
 "Die oft zu beobachtende \"Faulheit\" von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " bei der Auswertung boolescher Ausdr\[UDoubleDot]cke hat verschiedene \
Ursachen.\n\nDie erste liegt in der Natur der Ausdr\[UDoubleDot]cke selbst: \
Sie k\[ODoubleDot]nnen ",
 StyleBox["Aussagen",
  FontSlant->"Italic"],
 " (boolesche Ausdr\[UDoubleDot]cke ohne freie Variablen, denen sich ein \
Wahrheitswert zuordnen l\[ADoubleDot]sst) oder ",
 StyleBox["Aussageformen",
  FontSlant->"Italic"],
 " (boolesche Ausdr\[UDoubleDot]cke mit freien Variablen) sein. \n\nBeim \
Anschreiben eines Gleichungssystems etwa werden Aussageformen mit \[Equal] \
(",
 StyleBox["Equal",
  FontWeight->"Bold"],
 ") verwendet. Hier soll nicht untersucht werden, ob dies f\[UDoubleDot]r \
alle (x,y) gilt, sondern es wird das ",
 StyleBox["Problem",
  FontSlant->"Italic"],
 " formuliert, die L\[ODoubleDot]sungspaare (x,y) zu finden. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y", "-", "2"}], "\[Equal]", "0"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       SuperscriptBox["y", "2"], "-", "2"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sys", "//", "FullForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"Equal", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"Power", "[", 
          RowBox[{"x", ",", "2"}], "]"}], ",", "y"}], "]"}], ",", "0"}], 
      "]"}], ",", 
     RowBox[{"Equal", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"Times", "[", 
          RowBox[{"3", ",", "x"}], "]"}], ",", 
         RowBox[{"Times", "[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"Power", "[", 
            RowBox[{"y", ",", "2"}], "]"}]}], "]"}]}], "]"}], ",", "0"}], 
      "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "An der Stelle ist die Probe einfach - wenigstens mit Vorversionen von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6. Alle Vereinfachungen wurden automatisch vorgenommen und die \
entsprechenden booleschen Ausdr\[UDoubleDot]cke zu ",
 StyleBox["True",
  FontWeight->"Bold"],
 " vereinfacht. Nun nicht mehr (und von einem systematischen Standpunkt aus \
sollte auch ein ",
 StyleBox["Expand",
  FontWeight->"Bold"],
 " ben\[ODoubleDot]tigt werden ..."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "\[Equal]", "0"}], ",", "True"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "\[Equal]", "0"}], ",", "True"}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "... wie es der Fall ist, wenn die rechten Seiten durch einen Parameter ",
 StyleBox["a",
  FontSlant->"Italic"],
 " ersetzt werden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", "a"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "2"], "+", 
       RowBox[{"2", "x"}]}], "\[Equal]", "a"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sys", "/.", "sol"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "3"}], "+", "a"}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "3"}], "+", "a"}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "3"}], "+", "a"}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "3"}], "+", "a"}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox[
        RowBox[{"1", "+", "a"}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox[
        RowBox[{"1", "+", "a"}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox[
        RowBox[{"1", "+", "a"}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox[
        RowBox[{"1", "+", "a"}]]}]}]}], "}"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}], "2"], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}]}]}], "\[Equal]", "a"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}], "2"]}], "\[Equal]", 
      "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}], "2"]}], "\[Equal]", 
      "a"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}], "2"], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "a"}]]}], ")"}]}]}], "\[Equal]", "a"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}], "2"]}], "\[Equal]", "a"}], ",", 
     
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}], "2"]}], "\[Equal]", "a"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}], "2"]}], "\[Equal]", "a"}], ",", 
     
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", "a"}]]}], ")"}], "2"]}], "\[Equal]", "a"}]}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " braucht wenigstens den Hinweis, dass die linken Seiten zu expandieren \
sind."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "3"}], "+", "a"}]]}], ")"}], "2"], "+", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "3"}], "+", "a"}]]}], ")"}]}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData["a"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sys", "/.", "sol"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dann kann es sein, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zwar Aussagen vorgelegt bekommt, aber mit den eingesetzten Mitteln deren \
Wahrheitswert nicht entscheiden kann.\n\nDie folgende Identit\[ADoubleDot]t \
erkennt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 6 inzwischen automatisch."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}], "\[Equal]", "6"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Aber schon beim n\[ADoubleDot]chsten Beispiel muss ein so \
m\[ADoubleDot]chtiges Werkzeug wie ",
 StyleBox["RootReduce",
  FontWeight->"Bold"],
 " oder ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " herangezogen werden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1", "=", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"3", "-", 
      SqrtBox["5"]}]], "+", 
    SqrtBox[
     RowBox[{"3", "+", 
      SqrtBox["5"]}]]}], "\[Equal]", 
   SqrtBox["10"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"3", "-", 
     SqrtBox["5"]}]], "+", 
   SqrtBox[
    RowBox[{"3", "+", 
     SqrtBox["5"]}]]}], "\[Equal]", 
  SqrtBox["10"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beide Beispiele geh\[ODoubleDot]ren zu einer Familie von Identit\
\[ADoubleDot]ten der folgenden Bauart, die f\[UDoubleDot]r a>b>0 gelten, was \
aber nicht einmal ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " in der Lage ist nachzupr\[UDoubleDot]fen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SqrtBox[
      RowBox[{"a", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]], "+", 
     SqrtBox[
      RowBox[{"a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]]}], "\[Equal]", 
    SqrtBox[
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}]]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}]], "+", 
   SqrtBox[
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}]]}], "\[Equal]", 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    RowBox[{"a", "+", "b"}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"expr2", ",", 
   RowBox[{"a", ">", "b", ">", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    RowBox[{"a", "+", "b"}]]}], "\[Equal]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}]], "+", 
   SqrtBox[
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}]]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Dabei m\[UDoubleDot]ssen nur beide Seiten quadriert und vereinfacht werden.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"expr2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
       ",", 
      RowBox[{
      "expr2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
     "}"}], "2"], ",", 
   RowBox[{"a", ">", "b", ">", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beispiele dieser Art k\[ODoubleDot]nnen beliebig kompliziert sein. In den \
1960er Jahren ist im Zusammenhang mit dem 10. Hilbertschen Problem bewiesen \
worden, dass die Frage der algorithmischen Bestimmung des Wahrheitswerts \
eines Booleschen Ausdrucks bereits in nicht sehr umfangreichen Klassen nicht \
entscheidbar ist.\nMit folgendem Beispiel kommt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 nun jedoch in beiden Varianten nach einiger Arbeit zurecht."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr3", "=", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "7"], "]"}], "-", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"2", "\[Pi]"}], "7"], "]"}], "+", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"3", "\[Pi]"}], "7"], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox["\[Pi]", "7"], "]"}], "+", 
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", "14"], "]"}], "-", 
  RowBox[{"Sin", "[", 
   FractionBox[
    RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr3", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 FractionBox["1", "2"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr4", "=", 
  RowBox[{"expr3", "//", "TrigToExp"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "14"]}]]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "14"]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "7"]}]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "7"]]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "14"]}]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "14"]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr4", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"0.5`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr4", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 FractionBox["1", "2"]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Zur Untersuchung der allgemeing\[UDoubleDot]ltigen syntaktischen \
Gleichwertigkeit Boolescher Ausdr\[UDoubleDot]cke mit Symbolvariablen dient \
der Operator === (",
 StyleBox["SameQ",
  FontWeight->"Bold"],
 "). Beachten Sie aber, dass nat\[UDoubleDot]rlich auch hier vor dem \
Vergleich die Argumente von ",
 StyleBox["SameQ",
  FontWeight->"Bold"],
 " ausgewertet werden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "===", 
  RowBox[{"y", "+", "x"}]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "x"}], "===", 
  RowBox[{"2", "x"}]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "+", "x"}], "===", 
  RowBox[{"x", 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}]}]}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[TextData[{
 "=== (",
 StyleBox["SameQ",
  FontWeight->"Bold"],
 ") und \[Equal] (",
 StyleBox["Equal",
  FontWeight->"Bold"],
 ") reagieren in diesem Beispiel unterschiedlich. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x"}], "===", 
   RowBox[{"x", 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}]}]}], "//", "Expand"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x"}], "==", 
   RowBox[{"x", 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}]}]}], "//", "Expand"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell["\<\
Auch in Steuerstrukturen kann es geschehen, dass Boolesche \
Ausdr\[UDoubleDot]cke nicht vollst\[ADoubleDot]ndig ausgewertet werden k\
\[ODoubleDot]nnen. 

Verzweigungen werden dann in symbolischer Form als Funktionsausdruck zur\
\[UDoubleDot]ckgegeben.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "y"}], ",", "1", ",", "2"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "y"}], ",", "1", ",", "2"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "/.", 
  RowBox[{"x", "\[Rule]", "y"}]}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"y", "+", "1"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", "y"}], "\[Equal]", "y"}], ",", "1", ",", "2"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData["2"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Schleifenk\[ODoubleDot]rper werden dagegen nur dann betreten, wenn die \
Testbedingung explizit zu ",
 StyleBox["True",
  FontWeight->"Bold"],
 " auswertet."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "0"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"i", "\[LessEqual]", "n"}], ",", 
    RowBox[{
     RowBox[{"i", "++"}], ";", 
     RowBox[{"Print", "[", "i", "]"}]}]}], "]"}], ";", " ", "i"}]}], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dies kann zu falschen Ergebnissen f\[UDoubleDot]hren, wenn eine Aussage als \
Testbedingung zwar den Wahrheitswert ",
 StyleBox["True",
  FontWeight->"Bold"],
 " hat, dies aber von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nicht erkannt wird."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["3"]}]], "+", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["3"]}]]}], "\[Equal]", 
  SqrtBox["6"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["3"]}]], "+", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["3"]}]]}], "\[Equal]", 
  SqrtBox["6"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["i"], "\[LessEqual]", 
     RowBox[{
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox["3"]}]], "+", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["3"]}]]}]}], ",", 
    RowBox[{"i", "++"}]}], "]"}], ";", " ", "i"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Internal precision limit $MaxExtraPrecision = \
\\!\\(50.`\\) reached while evaluating \\!\\(\\@6 - \\@\\(2 - \\@3\\) - \
\\@\\(2 + \\@3\\)\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData["6"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox["3"]}]], "+", 
    SqrtBox[
     RowBox[{"2", "-", 
      SqrtBox["3"]}]]}], "\[LessEqual]", 
   SqrtBox["6"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Internal precision limit $MaxExtraPrecision = \
\\!\\(50.`\\) reached while evaluating \\!\\(\\(\\(-\\@6\\)\\) + \\@\\(2 - \
\\@3\\) + \\@\\(2 + \\@3\\)\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["3"]}]], "+", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["3"]}]]}], "\[LessEqual]", 
  SqrtBox["6"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Interessanterweise wird als Ergebnis der numerischen N\[ADoubleDot]herung \
",
 StyleBox["True",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ckgegeben, obwohl dies auf Grund von \
Rundungsungenauigkeiten numerisch niemals genau festgestellt werden kann. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "//", "N"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
   RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "N"}]], "Input"],

Cell[BoxData["4.440892098500626`*^-16"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mehr noch, wir bekommen damit zwei Ausdr\[UDoubleDot]cke, von denen ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " behauptet, dass sie numerisch gleich seien, ihre Differenz aber nicht \
numerisch gleich Null. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   "\[Equal]", 
   RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "N"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
    
    RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "\[Equal]", "0"}], "//", "N"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "-", 
      RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
      "N"}], "//", "Chop"}], ")"}], "\[Equal]", "0"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit zus\[ADoubleDot]tzlichem Aufwand kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " den Ausdruck zu ",
 StyleBox["True",
  FontWeight->"Bold"],
 " vereinfachen und liefert dann auch das korrekte Ergebnis."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "//", "RootReduce"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["i"], "\[LessEqual]", 
     RowBox[{"RootReduce", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["3"]}]], "+", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["3"]}]]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"i", "++"}], ";", 
     RowBox[{"Print", "[", "i", "]"}]}]}], "]"}], ";", " ", "i"}]], "Input"],

Cell[BoxData["6"], "Print"],

Cell[BoxData["7"], "Print"],

Cell[BoxData["7"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funktionen definieren", "Section"],

Cell[CellGroupData[{

Cell["Transformationen, Regeln, Muster", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"i1", "[", 
   RowBox[{"f", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "1"}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"i1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"g", "[", "y", "]"}], ",", 
     RowBox[{"f", "[", 
      FractionBox["1", "x"], "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "x"}], "]"}], ",", 
   RowBox[{"i1", "[", 
    RowBox[{"f", "[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"i1", "[", 
    RowBox[{"g", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", 
     FractionBox["1", "x"]}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "i1"}]], "Input"],

Cell["Global`i1", "Print", "PrintUsage",
 CellTags->"Info3392922012-7672565"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"i1", "[", 
          RowBox[{"f", "[", "x_", "]"}], "]"}], ":=", 
         RowBox[{"f", "[", 
          RowBox[{"x", "+", "1"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["i1"],
  Editable->False]], "Print",
 CellTags->"Info3392922012-7672565"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"i2", "[", 
   RowBox[{"_", "[", "y_", "]"}], "]"}], ":=", 
  RowBox[{"y", "/", "x"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"i2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"g", "[", "y", "]"}], ",", 
     RowBox[{"g", "[", 
      FractionBox["1", "x"], "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"i2", "[", 
    RowBox[{"f", "[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
   FractionBox["y", "x"], ",", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "i2"}]], "Input"],

Cell["Global`i2", "Print", "PrintUsage",
 CellTags->"Info3392922034-8418612"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"i2", "[", 
          RowBox[{"_", "[", "y_", "]"}], "]"}], ":=", 
         FractionBox["y", "x"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["i2"],
  Editable->False]], "Print",
 CellTags->"Info3392922034-8418612"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partiell definierte Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "3"}], ",", " ", 
     SqrtBox["12"], ",", "1.7", ",", "x"}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"n", "!"}], 
   RowBox[{
    RowBox[{"k", "!"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "-", "k"}], ")"}], "!"}]}]]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "Indeterminate", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}], ")"}], "!"}], 
    RowBox[{"2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"]}]}], ")"}], "!"}]}]], ",", "0.595`", ",", 
   FractionBox[
    RowBox[{"x", "!"}], 
    RowBox[{"2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "x"}], ")"}], "!"}]}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "6", ",", 
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", "0.5950000000000001`", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bedingte Funktionsvorschriften", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "!"}], 
    RowBox[{
     RowBox[{"k", "!"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "k"}], ")"}], "!"}]}]], "/;", " ", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "n", "]"}], "\[And]", 
    RowBox[{"IntegerQ", "[", "k", "]"}], "\[And]", 
    RowBox[{"n", "\[GreaterEqual]", "0"}], "\[And]", 
    RowBox[{"k", "\[GreaterEqual]", "0"}]}]}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", 
   RowBox[{"ourBinomial", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "2"}], "]"}], ",", 
   RowBox[{"ourBinomial", "[", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox["3"]}], ",", "2"}], "]"}], ",", 
   RowBox[{"ourBinomial", "[", 
    RowBox[{"1.7`", ",", "2"}], "]"}], ",", 
   RowBox[{"ourBinomial", "[", 
    RowBox[{"x", ",", "2"}], "]"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bedingte Muster", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{
    RowBox[{"n_", "?", "NonNegative"}], ",", 
    RowBox[{"k_", "?", "NonNegative"}]}], "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "i", "+", "1"}], "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"NonNegative", ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "True", ",", 
   RowBox[{"NonNegative", "[", "x", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", 
   RowBox[{"ourBinomial", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "2"}], "]"}], ",", 
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", "0.595`", ",", 
   RowBox[{"ourBinomial", "[", 
    RowBox[{"x", ",", "2"}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"{", 
    RowBox[{"1.5", ",", "\[Infinity]", ",", 
     SqrtBox["12"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NonNegative", "/@", "l1"}], "\[IndentingNewLine]", 
 RowBox[{"NumberQ", "/@", "l1"}], "\[IndentingNewLine]", 
 RowBox[{"NumericQ", "/@", "l1"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ourBinomial", "[", 
    RowBox[{"15", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"3.3", ",", "3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"455", ",", "455"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"15", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"3.3", ",", "3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"655.3747162298547`", ",", "455"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"k_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"IntegerQ", "[", "#", "]"}], "\[And]", 
        RowBox[{"NonNegative", "[", "#", "]"}]}], "&"}], ")"}]}]}], "]"}], ":=",
   
  RowBox[{"Product", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "i", "+", "1"}], "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "6", ",", 
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", "0.595`", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Typmuster", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"k_Integer", "?", "NonNegative"}]}], "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "i", "+", "1"}], "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "6", ",", 
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", "0.595`", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_Integer", "]"}], ":=", "x"}], "\n", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}], "]"}], ",", 
   RowBox[{"f", "[", "1.7`", "]"}], ",", 
   RowBox[{"f", "[", "x", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_Real", "]"}], ":=", "x"}], "\[IndentingNewLine]", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "7", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"-", "3"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}], "]"}], ",", "1.7`", ",", 
   RowBox[{"f", "[", "x", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_Integer", "]"}], ":=", "x"}], "\n", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}], "]"}], ",", "1.7`", ",", 
   RowBox[{"f", "[", "x", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392922312-7412908"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_Real", "]"}], ":=", "x"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "x_Integer", "]"}], ":=", "x"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392922312-7412908"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], "//", "InputForm"}]], "Input"],

Cell["Sqrt[2]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Head"}]], "Input"],

Cell[BoxData["Power"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"2", ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"N", "[", "x", "]"}], "]"}]}], "\n", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"-", "3"}], ",", "3.4641016151377544`", ",", "1.7`", ",", 
   RowBox[{"f", "[", "x", "]"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funktionen mit variabler Parameterzahl", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"relSum", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"a", "+", "b"}], 
   RowBox[{"1", "+", 
    RowBox[{"a", " ", "b"}]}]]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"relSum", "[", 
   RowBox[{"a_", ",", "b_", ",", "c__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"relSum", "[", 
    RowBox[{"a", ",", 
     RowBox[{"relSum", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}], "//", "Together"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"relSum", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y", "+", "z", "+", 
   RowBox[{"x", " ", "y", " ", "z"}]}], 
  RowBox[{"1", "+", 
   RowBox[{"x", " ", "y"}], "+", 
   RowBox[{"x", " ", "z"}], "+", 
   RowBox[{"y", " ", "z"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"relSum", "[", 
  RowBox[{"0.4", ",", "0.4", ",", "0.4", ",", "0.4"}], "]"}]], "Input"],

Cell[BoxData["0.9347300564061242`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"relSum", "[", 
  RowBox[{"a", ",", "1", ",", "b"}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Muster, Regeln, Substitutionen und lokale Zuweisungen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   RowBox[{"2", "a", " ", 
    SuperscriptBox["b", "2"]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", "1"}]}], ",", 
    RowBox[{"b", "\[Rule]", "2"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"8", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["b", "2"]}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["b", "2"]}], ")"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   RowBox[{"2", "a", " ", 
    SuperscriptBox["b", "2"]}]}], "//.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", "1"}]}], ",", 
    RowBox[{"b", "\[Rule]", "2"}]}], "}"}]}]], "Input"],

Cell[BoxData["65"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
St\[UDoubleDot]ckweise zusammengesetzte Funktionen\
\>", "Section"],

Cell[CellGroupData[{

Cell["Realisierung als bedingte Funktionsdefinitions", "Subsection"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", " ", "/;", " ", 
   RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"1", " ", "/;", " ", 
   RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"3", "-", "x"}], " ", "/;", " ", 
   RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", "0", " "}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392922589-4789835"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{"x", "/;", 
          RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{"1", "/;", 
          RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{
          RowBox[{"3", "-", "x"}], "/;", 
          RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", "0"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392922589-4789835"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", " ", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN1Xs0lOsewPHXDKbatMneMmwMyiaVyLXoeVUSFbqwleRepDP7nGSHVC65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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-1, -0.2},
  PlotRange->{{-1, 4}, {-0.2, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1"}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1"}]}], "//", "Hold"}], "//", 
  "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Hold", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"Rule", "[", 
       RowBox[{"x", ",", "1"}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", " ", "/;", " ", 
   RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"1", " ", "/;", " ", 
   RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"3", "-", "x"}], " ", "/;", " ", 
   RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_Real", "]"}], ":=", "0", " "}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1"}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN1Xs0lOsewPHXDKbatMneMmwMyiaVyLXoeVUSFbqwleRepDP7nGSHVC65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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-1, -0.2},
  PlotRange->{{-1, 4}, {-0.2, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.1", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.5", "]"}]}], "}"}], " "}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], ",", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "0", "]"}], ",", "0.9594565157065158`", 
   ",", "0.9999999999999962`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.1", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.5", "]"}]}], "}"}], " ", "//", 
  "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], ",", "0.5`", ",", 
   "0.9594565157065158`", ",", "0.9999999999999962`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "x", "]"}], ",", "  ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxE23k0Vd/bAPB7LxfJWCIyU1RCkqHkOVREypCiUUklJUJSSUIqSmQMIXNk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-1, -0.2},
  PlotRange->{{-1, 4}, {-1.162467288473347, 1.1580398584734113`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funktionsdefinition mit If oder Which", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"0", "\[LessEqual]", "x", "<", "1"}], ",", "x", ",", 
    RowBox[{"1", "\[LessEqual]", "x", "<", "2"}], ",", "1", ",", 
    RowBox[{"2", "\[LessEqual]", "x", "<", "3"}], ",", 
    RowBox[{"3", "-", "x"}], ",", "True", ",", "0"}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "+", "0.1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dashed"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN1Xs0lOsewPHXDKbatMneMmwMyiaVyLXoeVUSFbqwleRepDP7nGSHVC65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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJxF0XlM0wcUB/DS0gpaUNiEFVax4IGJ1dRpCQijMCqKB3jQoY3hEOwQh4mI
YwSmkAEFTTNouYWiglpE4xBFxgqs00ChICMlDlJxs+X62XIKFgd2I4vvfZOX
l89/37zHijl3JI5MIpHi/5vlPVvhpbZYJlvLSpfT5B/Wl8G2SpwA19E0+WSd
EbxWxlTHXhgHH4xyfpi7ZwQcYpcgqfHUg03Kdw8CJK/Aw0PxtcovB8C++wQZ
ZlEf2IcwJgfGtIN/kb6UTa37DZyUek3k1/gIXDNo33Fs4B44ts3Qti2oCpxz
Wp7qNVsAduL0d/NTksFE8GVZnPBb8BFhnculq5HYrzyKoxFzwA12i1aMDoH/
/572v89UBG8NTgKby+M3b0m8DPZ+LN0WSpGA/caGynw0heBPBnj6Lax6sLNZ
7cZ/3gJeKqateN3fBS7uLf37sEILzn8ReYL9dhBc1Nn/foP+L3BlB+trX18D
+EXOM1K+cBQc5V63O7uFwH5hXZfcjhrBLj8Qvz8ZNYF1XSF5JtUEWM64G+Ze
OQmO8PhuXNyEXsP+KnNSizZyFD03XqM7uKtdBVPo6t3JItsPaF6V6fgQdcr/
4/3NiqaZIBb654dZV+76ot3bmcqUJHTB4KMJfi3a40GrOS1jGtyQpSY3RMyA
Ex1ylTxiFty7kmirqJgDdxnmzzB2vgPH9giularM4OqNEU7E+ffg9JNUr+O0
RbCFfKyqpHkJLHlZXeJT8AG87sncT7pvLGDtmVf6sTL0FaaaO6dBj8z7Rf0z
jA7src+1sqAPUGzyrpNJvG7NcoytKZXcUBUVfdM77lO9DbpHKx2g0NEbV02f
4jui0wIOTWR/hv7irVeANARN3GLJ5GlolYh5YOs4utSTYd0UbgUuLDvdHr2e
DI6Uneyhj6KXgmoW5C0U8NhwYIoqxxp824/j2h1NBddnJTuI2DTw1fBT+ylz
aH1JZio/egXYR3ddkdONrvVoNngOohkJWrfOEXSvfbTSxYQW15tOJMyiY60b
FNJ5NE+Qam5eQH9+hxdsWESbF2hFdJIN7+O//hR700MZ6Ebns5n5O9AXd/2R
6BSH3nmUKywvRrsSnnsYVFswOcOVU3weLefWhhTuWwkW6ySN7o6rwHzvp3tL
3qAPZYeyKx7TwZuEP4ZXp9uB+0Zsb0jD7cGdMcMBjm6rwUWFDrTvF9B5LdvT
fl1Ep48enLFY0P8CM8Gqew==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-1, -0.2},
  PlotRange->{{-1, 4}, {-0.9, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", 
     RowBox[{"-", "0.1"}], "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.1", "]"}]}], "}"}], " "}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{"0", "\[LessEqual]", "x", "<", "1"}], ",", "1", ",", 
     RowBox[{"1", "\[LessEqual]", "x", "<", "2"}], ",", "0", ",", 
     RowBox[{"2", "\[LessEqual]", "x", "<", "3"}], ",", 
     RowBox[{"-", "1"}], ",", "True", ",", "0"}], "]"}], ",", "1", ",", "0", 
   ",", "1"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Realisierung mit Piecewise", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", " ", 
        RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "-", "x"}], ",", 
        RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}], "}"}]}], "}"}], ",", 
    "0"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"1", 
      RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]},
     {
      RowBox[{"3", "-", "x"}], 
      RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]},
     {"x", 
      RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.84]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392922924-7502732"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{"\[Piecewise]", GridBox[{
            {"1", 
             RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]},
            {
             RowBox[{"3", "-", "x"}], 
             RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]},
            {"x", 
             RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392922924-7502732"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "+", "0.1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dashed"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{-0.9999998979591836, 0.}, {-0.9984664103972019, 
      0.}, {-0.99693292283522, 0.}, {-0.9938659477112564, 
      0.}, {-0.9877319974633292, 0.}, {-0.9754640969674748, 
      0.}, {-0.9509282959757659, 0.}, {-0.901856693992348, 
      0.}, {-0.7954582145727068, 0.}, {-0.6961105821492396, 
      0.}, {-0.5987117559056199, 0.}, {-0.4930576542091945, 
      0.}, {-0.3944543995089432, 0.}, {-0.2875958693558862, 
      0.}, {-0.18268614538267675`, 0.}, {-0.0848272684056413, 
      0.}, {-0.08316923477392503, 0.}, {-0.08151120114220876, 
      0.}, {-0.07819513387877623, 0.}, {-0.07156299935191117, 
      0.}, {-0.058298730298181035`, 0.}, {-0.031770192190720775`, 
      0.}, {-0.03011215855900451, 0.}, {-0.028454124927288243`, 
      0.}, {-0.025138057663855712`, 0.}, {-0.018505923136990645`, 
      0.}, {-0.005241654083260513, 0.}, {-0.0035836204515442465`, 
      0.}, {-0.0019255868198279802`, 0.}, {-0.0015943877551020409`, 0.}}], 
     LineBox[{{0.0015943877551020409`, 0.0015943877551020409`}, {
      0.003048514075320819, 0.003048514075320819}, {0.004706547707037085, 
      0.004706547707037085}, {0.008022614970469619, 0.008022614970469619}, {
      0.009680648602185885, 0.009680648602185885}, {0.01133868223390215, 
      0.01133868223390215}, {0.014654749497334684`, 0.014654749497334684`}, {
      0.02128688402419975, 0.02128688402419975}, {0.022834748171600798`, 
      0.022834748171600798`}, {0.024382612319001844`, 
      0.024382612319001844`}, {0.027478340613803935`, 
      0.027478340613803935`}, {0.033669797203408125`, 
      0.033669797203408125`}, {0.046052710382616505`, 
      0.046052710382616505`}, {0.07081853674103326, 0.07081853674103326}, {
      0.12035018945786678`, 0.12035018945786678`}, {0.21746468871168637`, 
      0.21746468871168637`}, {0.3228344634183115, 0.3228344634183115}, {
      0.42115339112876266`, 0.42115339112876266`}, {0.5277275942920194, 
      0.5277275942920194}, {0.6323529912754287, 0.6323529912754287}, {
      0.7299275412626639, 0.7299275412626639}, {0.8357573667027047, 
      0.8357573667027047}, {0.8373007882408902, 0.8373007882408902}, {
      0.8388442097790756, 0.8388442097790756}, {0.8419310528554464, 
      0.8419310528554464}, {0.8481047390081881, 0.8481047390081881}, {
      0.8604521113136714, 0.8604521113136714}, {0.8851468559246382, 
      0.8851468559246382}, {0.8866902774628236, 0.8866902774628236}, {
      0.8882336990010089, 0.8882336990010089}, {0.8913205420773798, 
      0.8913205420773798}, {0.8974942282301215, 0.8974942282301215}, {
      0.9098416005356049, 0.9098416005356049}, {0.9345363451465716, 
      0.9345363451465716}, {0.9362087553637071, 0.9362087553637071}, {
      0.9378811655808426, 0.9378811655808426}, {0.9412259860151135, 
      0.9412259860151135}, {0.9479156268836556, 0.9479156268836556}, {
      0.9612949086207396, 0.9612949086207396}, {0.9629673188378751, 
      0.9629673188378751}, {0.9646397290550106, 0.9646397290550106}, {
      0.9679845494892817, 0.9679845494892817}, {0.9746741903578238, 
      0.9746741903578238}, {0.9880534720949078, 0.9880534720949078}, {
      0.9897258823120434, 0.9897258823120434}, {0.9913982925291789, 
      0.9913982925291789}, {0.9930707027463144, 0.9930707027463144}, {
      0.9947431129634499, 0.9947431129634499}, {0.9964155231805853, 
      0.9964155231805853}, {0.9980879333977208, 0.9980879333977208}, {
      0.998405612244898, 0.998405612244898}}], 
     LineBox[{{1.0015943877551021`, 1.}, {1.0081223947005338`, 1.}, {
      1.014812035569076, 1.}, {1.02819131730616, 1.}, {1.041570599043244, 
      1.}, {1.0941133229016564`, 1.}, {1.1466560467600688`, 1.}, {
      1.2446906474807196`, 1.}, {1.3509805236541759`, 1.}, {
      1.4502195528314583`, 1.}, {1.5475097758288934`, 1.}, {
      1.6530552742791338`, 1.}, {1.7515499257332003`, 1.}, {
      1.8582998526400727`, 1.}, {1.9631009733670974`, 1.}, {
      1.9753197575834536`, 1.}, {1.98753854179981, 1.}, {1.993647933907988, 
      1.}, {1.9984056122448979`, 1.}}], 
     LineBox[{{2.001594387755102, 0.9984056122448979}, {2.0028120220702554`, 
      0.9971879779297446}, {2.005866718124344, 0.9941332818756559}, {
      2.0119761102325224`, 0.9880238897674776}, {2.0135034582595672`, 
      0.9864965417404328}, {2.0150308062866116`, 0.9849691937133884}, {
      2.0180855023407007`, 0.9819144976592993}, {2.024194894448879, 
      0.975805105551121}, {2.036413678665235, 0.9635863213347649}, {
      2.060851247097948, 0.9391487529020521}, {2.0625075838039426`, 
      0.9374924161960574}, {2.0641639205099374`, 0.9358360794900626}, {
      2.0674765939219264`, 0.9325234060780736}, {2.074101940745905, 
      0.9258980592540951}, {2.087352634393862, 0.912647365606138}, {
      2.113854021689776, 0.8861459783102239}, {2.166856796281604, 
      0.8331432037183961}, {2.2658114984690862`, 0.7341885015309138}, {
      2.362817394476721, 0.6371826055232792}, {2.468078565937161, 
      0.5319214340628391}, {2.5662888904014274`, 0.4337111095985726}, {
      2.6727544903184994`, 0.32724550968150057`}, {2.7721692432393974`, 
      0.2278307567606026}, {2.869635189980448, 0.13036481001955202`}, {
      2.871287084077227, 0.1287129159227729}, {2.8729389781740062`, 
      0.12706102182599377`}, {2.876242766367564, 0.12375723363243596`}, {
      2.88285034275468, 0.1171496572453199}, {2.8960654955289122`, 
      0.10393450447108776`}, {2.922495801077376, 0.07750419892262395}, {
      2.924147695174155, 0.07585230482584482}, {2.925799589270934, 
      0.07420041072906614}, {2.929103377464492, 0.07089662253550788}, {
      2.9357109538516077`, 0.06428904614839226}, {2.94892610662584, 
      0.05107389337416013}, {2.975356412174304, 0.024643587825695867`}, {
      2.976898136786768, 0.023101863213232043`}, {2.978439861399232, 
      0.02156013860076822}, {2.9815233106241594`, 0.01847668937584057}, {
      2.9876902090740143`, 0.01230979092598572}, {2.9892319336864777`, 
      0.01076806631352234}, {2.9907736582989415`, 0.009226341701058516}, {
      2.993857107523869, 0.006142892476130868}, {2.995398832136333, 
      0.004601167863667044}, {2.996940556748797, 0.00305944325120322}, {
      2.998405612244898, 0.0015943877551021224`}}], 
     LineBox[{{3.001594387755102, 0.}, {3.003107455198652, 0.}, {
      3.0061909044235797`, 0.}, {3.012357802873435, 0.}, {3.024691599773145, 
      0.}, {3.0262333243856085`, 0.}, {3.0277750489980724`, 0.}, {
      3.030858498223, 0.}, {3.0370253966728553`, 0.}, {3.049359193572566, 
      0.}, {3.074026787371986, 0.}, {3.0756975006634, 0.}, {
      3.0773682139548137`, 0.}, {3.0807096405376417`, 0.}, {
      3.0873924937032973`, 0.}, {3.1007582000346083`, 0.}, {3.12748961269723, 
      0.}, {3.180952438022474, 0.}, {3.285929282493114, 0.}, {
      3.3838552799675803`, 0.}, {3.490036552894852, 0.}, {3.5891669788259497`,
       0.}, {3.6863485985772, 0.}, {3.791785493781256, 0.}, {
      3.8901715419891376`, 0.}, {3.996812865649825, 0.}, {3.996862663029659, 
      0.}, {3.9969124604094923`, 0.}, {3.9970120551691597`, 0.}, {
      3.997211244688495, 0.}, {3.9976096237271648`, 0.}, {3.9984063818045046`,
       0.}, {3.9984561791843385`, 0.}, {3.998505976564172, 0.}, {
      3.9986055713238393`, 0.}, {3.9988047608431745`, 0.}, {
      3.9992031398818444`, 0.}, {3.9992529372616783`, 0.}, {
      3.9993027346415118`, 0.}, {3.999402329401179, 0.}, {3.999601518920514, 
      0.}, {3.9996513163003478`, 0.}, {3.999701113680181, 0.}, {
      3.9998007084398486`, 0.}, {3.9998505058196825`, 0.}, {
      3.9999003031995164`, 0.}, {3.9999501005793503`, 0.}, {
      3.9999998979591838`, 0.}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
     LineBox[{{-0.9999998979591836, 0.1}, {-0.9509282959757659, 
      0.1}, {-0.901856693992348, 0.1}, {-0.7954582145727068, 
      0.1}, {-0.6961105821492396, 0.1}, {-0.5987117559056199, 
      0.1}, {-0.4930576542091945, 0.1}, {-0.3944543995089432, 
      0.1}, {-0.2875958693558862, 0.1}, {-0.18268614538267675`, 
      0.1}, {-0.13375670689415903`, 0.1}, {-0.0848272684056413, 
      0.1}, {-0.058298730298181035`, 0.1}, {-0.031770192190720775`, 
      0.1}, {-0.018505923136990645`, 0.1}, {-0.005241654083260513, 
      0.1}, {-0.0035836204515442465`, 0.1}, {-0.0019255868198279802`, 
      0.1}, {-0.0015943877551020409`, 0.1}}], 
     LineBox[{{0.0015943877551020409`, 1.1}, {0.004706547707037085, 1.1}, {
      0.008022614970469619, 1.1}, {0.014654749497334684`, 1.1}, {
      0.02128688402419975, 1.1}, {0.07081853674103326, 1.1}, {
      0.12035018945786678`, 1.1}, {0.21746468871168637`, 1.1}, {
      0.3228344634183115, 1.1}, {0.42115339112876266`, 1.1}, {
      0.5277275942920194, 1.1}, {0.6323529912754287, 1.1}, {
      0.7299275412626639, 1.1}, {0.8357573667027047, 1.1}, {
      0.8851468559246382, 1.1}, {0.9345363451465716, 1.1}, {
      0.9612949086207396, 1.1}, {0.9880534720949078, 1.1}, {
      0.9913982925291789, 1.1}, {0.9947431129634499, 1.1}, {
      0.9964155231805853, 1.1}, {0.9980879333977208, 1.1}, {0.998405612244898,
       1.1}}], LineBox[{{1.0015943877551021`, 0.1}, {1.0081223947005338`, 
      0.1}, {1.014812035569076, 0.1}, {1.02819131730616, 0.1}, {
      1.041570599043244, 0.1}, {1.0941133229016564`, 0.1}, {
      1.1466560467600688`, 0.1}, {1.2446906474807196`, 0.1}, {
      1.3509805236541759`, 0.1}, {1.4502195528314583`, 0.1}, {
      1.5475097758288934`, 0.1}, {1.6530552742791338`, 0.1}, {
      1.7515499257332003`, 0.1}, {1.8582998526400727`, 0.1}, {
      1.910700413003585, 0.1}, {1.9631009733670974`, 0.1}, {
      1.9753197575834536`, 0.1}, {1.98753854179981, 0.1}, {1.993647933907988, 
      0.1}, {1.9984056122448979`, 0.1}}], 
     LineBox[{{2.001594387755102, -0.9}, {2.0028120220702554`, -0.9}, {
      2.0043393700973, -0.9}, {2.005866718124344, -0.9}, {
      2.0089214141784333`, -0.9}, {2.0119761102325224`, -0.9}, {
      2.036413678665235, -0.9}, {2.060851247097948, -0.9}, {
      2.113854021689776, -0.9}, {2.166856796281604, -0.9}, {
      2.2658114984690862`, -0.9}, {2.362817394476721, -0.9}, {
      2.468078565937161, -0.9}, {2.5662888904014274`, -0.9}, {
      2.6727544903184994`, -0.9}, {2.7721692432393974`, -0.9}, {
      2.869635189980448, -0.9}, {2.922495801077376, -0.9}, {
      2.975356412174304, -0.9}, {2.9815233106241594`, -0.9}, {
      2.9876902090740143`, -0.9}, {2.9907736582989415`, -0.9}, {
      2.993857107523869, -0.9}, {2.995398832136333, -0.9}, {
      2.996940556748797, -0.9}, {2.998405612244898, -0.9}}], 
     LineBox[{{3.001594387755102, 0.1}, {3.012357802873435, 0.1}, {
      3.024691599773145, 0.1}, {3.049359193572566, 0.1}, {3.074026787371986, 
      0.1}, {3.12748961269723, 0.1}, {3.180952438022474, 0.1}, {
      3.285929282493114, 0.1}, {3.3838552799675803`, 0.1}, {3.490036552894852,
       0.1}, {3.5891669788259497`, 0.1}, {3.6863485985772, 0.1}, {
      3.791785493781256, 0.1}, {3.8901715419891376`, 0.1}, {3.996812865649825,
       0.1}, {3.9984063818045046`, 0.1}, {3.9999998979591838`, 
      0.1}}]}, {}}, {{}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-1, -0.2},
  PlotRange->{{-1, 4}, {-0.9, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   AdjustmentBox["f",
    BoxMargins->{{-0.238806, 0.238806}, {0, 0}}], 
   AdjustmentBox["'",
    BoxMargins->{{-0.079602, 0.079602}, {0, 0}}]}], 
  AdjustmentBox["[",
   BoxMargins->{{-0.079602, 0.079602}, {0, 0}}], 
  AdjustmentBox["x",
   BoxMargins->{{-0.079602, 0.079602}, {0, 0}}], 
  AdjustmentBox["]",
   BoxMargins->{{-0.079602, 0.079602}, {0, 0}}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"0", 
     RowBox[{"x", "<", "0"}]},
    {"1", 
     RowBox[{"0", "<", "x", "<", "1"}]},
    {"0", 
     RowBox[{"1", "<", "x", "<", "2"}]},
    {
     RowBox[{"-", "1"}], 
     RowBox[{"2", "<", "x", "<", "3"}]},
    {"0", 
     RowBox[{"x", ">", "3"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", " ", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"x", 
      RowBox[{"1", "<", "x"}]},
     {
      RowBox[{
       RowBox[{"2", 
        SqrtBox["x"]}], "-", "1"}], 
      RowBox[{"x", "\[LessEqual]", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.84]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAASmXo0cDpZT5mkmSfsPzvvwRDGnDf
GUQ/zYFNADVq7r8zn5icsxlUPyQkr7Ihwu2/5BwkgXcmXj9Iw9ZbKUHtv0vN
17KdGWQ/XzG+L2/U7L8kjB2l/x9pPx7UQbykdOy//Epjl2Embj9PTfS2Ch7s
v1dk972SGXQ/ZlDOD0eE67/EQxq3w5x2P63mRDioPuu/MCM9sPQfeT8UZCXz
zvzqvwjigqJWJn4/s17ptVWC6r/dL4dDjRmEP9SfEPfgqOm/lJ8YwCVbhT8E
fLXV7Hbpv0oPqjy+nIY/fk5jnGtG6b+27sw17x+JP/m9CcpL6ei/jq0SKFEm
jj9cNriLFzzov6AVT4aKGZQ/pJTV9I8I5797zZfEVrqUPwJnh9v45Oa/VoXg
AiNblT+saHTK6sHmvwz1cX+7nJY/evTsKlJ95r941JR47B+ZP6xI+omf+eW/
UZPaak4mnj/+K/HqrATlv4EIsyeJGaQ/+rLrOcNR478qR5GIsnCkP+bBRjRi
NuO/0oVv6dvHpD+mn3BROxvjvyQDLKsudqU/WFmaUZbl4r/G/aQu1NKmPwx3
Xf7KfOK/DPOWNR+MqT/wYg0GMrThv5jdekO1/q4/oMjsDNZA4L9BHFmk3lWv
Pz6gVHfBKuC/6lo3BQitrz9KEiOCyxTgvx7seWOtLbA/FF75B3PS379vaTYl
ANywPzxjwXTgJt+/EmSvqKU4sj8I9ffd09ndv1hZoa/w8bQ/pB2DWSpj27/v
21QKohq1P1zPDqKqP9u/hl4IZVNDtT/M5LETTRzbv7Njbxq2lLU/UnOG7PbV
2r8Obj2Feze2P+RiUC/UStq/xYLZWgZ9tz+0+IUpaDrZvzKsEQYcCLo/YBKf
L9ku178L/4FcRx6/P/QjVoR8X9O/JVHu6MOLxD/8gFW2a2/Jv3fOOT+Y9Mk/
CHNxHkhxub8XtBHeAQHPPwDsmsoiEJC/tuJDzM880j9g9+Cgl1CxP8JqnRtZ
7NQ/8PFLachfwj/1Jj0PrW3XPyCr0Qar48o/AvmrEBsl2j8ciMghuM/RPzb/
YLZTrtw/WIz1Gfiv1T/MhDTOxirfP1A2KoXxUtk/H5Dr+anu4D/kWcY59hvd
P+v3397VMOI/bnl+OvFA4D+k6rvKDo7jP6jzrGnAB+I/Dh2n7+Tk5D/Akwz9
DbfjP4xptWagJOY/1lYVMv885T/2QKvkaH/nP/gU9hqx1+Y/dDLEtBbD6D9g
wJ8GeEzoP9+uxIvRIeo/zMrEDM/V6T/7atSbKXrrP6ALN4ITTus/K0EH/ma7
7D8UoUSn4KTsP0eiIWexF+4/PKvl4TAQ7j93HV8i4VzvP4TuNikPXO8/PzTW
h8b67z88jjpRxvrvP/WoFlE=
      "]], 
     LineBox[{{1.0190039103315582`, 1.0190039103315582`}, {
      1.0612221097116545`, 1.0612221097116545`}, {1.1006199702932813`, 
      1.1006199702932813`}, {1.1433199410560302`, 1.1433199410560302`}, {
      1.1852403893468402`, 1.1852403893468402`}, {1.2243404988391806`, 
      1.2243404988391806`}, {1.2667427185126432`, 1.2667427185126432`}, {
      1.3063245993876362`, 1.3063245993876362`}, {1.3451269577906901`, 
      1.3451269577906901`}, {1.3872314263748664`, 1.3872314263748664`}, {
      1.426515556160573, 1.426515556160573}, {1.4691017961274018`, 
      1.4691017961274018`}, {1.508867697295761, 1.508867697295761}, {
      1.5478540759921813`, 1.5478540759921813`}, {1.5901425648697238`, 
      1.5901425648697238`}, {1.6296107149487966`, 1.6296107149487966`}, {
      1.6723809752089918`, 1.6723809752089918`}, {1.714371712997248, 
      1.714371712997248}, {1.7535421119870345`, 1.7535421119870345`}, {
      1.7960146211579433`, 1.7960146211579433`}, {1.8356667915303824`, 
      1.8356667915303824`}, {1.8745394394308825`, 1.8745394394308825`}, {
      1.9167141975125048`, 1.9167141975125048`}, {1.9560686167956576`, 
      1.9560686167956576`}, {1.9987251462599327`, 1.9987251462599327`}, {
      1.9987450652118661`, 1.9987450652118661`}, {1.9987649841637998`, 
      1.9987649841637998`}, {1.9988048220676666`, 1.9988048220676666`}, {
      1.9988844978754003`, 1.9988844978754003`}, {1.9990438494908678`, 
      1.9990438494908678`}, {1.999362552721803, 1.999362552721803}, {
      1.9993824716737365`, 1.9993824716737365`}, {1.99940239062567, 
      1.99940239062567}, {1.9994422285295368`, 1.9994422285295368`}, {
      1.9995219043372707`, 1.9995219043372707`}, {1.9996812559527384`, 
      1.9996812559527384`}, {1.9997011749046718`, 1.9997011749046718`}, {
      1.9997210938566052`, 1.9997210938566052`}, {1.999760931760472, 
      1.999760931760472}, {1.9998406075682058`, 1.9998406075682058`}, {
      1.9998605265201392`, 1.9998605265201392`}, {1.9998804454720727`, 
      1.9998804454720727`}, {1.9999202833759395`, 1.9999202833759395`}, {
      1.999940202327873, 1.999940202327873}, {1.9999601212798064`, 
      1.9999601212798064`}, {1.99998004023174, 1.99998004023174}, {
      1.9999999591836735`, 1.9999999591836735`}}]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2}, {-0.9995959389821791, 1.9999999591836735`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox["1", 
      SqrtBox["x"]], 
     RowBox[{"x", "<", "1"}]},
    {"1", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "''"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", 
         RowBox[{"3", "/", "2"}]]}]]}], 
     RowBox[{"x", "<", "1"}]},
    {"0", 
     RowBox[{"x", ">", "1"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "*", 
   RowBox[{"UnitStep", "[", 
    RowBox[{"x", "*", "y"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"x", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y"}], "\[GreaterEqual]", "0"}]}]},
    {"y", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y"}], "<", "0"}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "*", 
     RowBox[{"Floor", "[", "y", "]"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"1", "<", "x", "<", "2"}], "&&", 
    RowBox[{"2", "<", "y", "<", "4"}]}]}], "]"}]], "Input",
 CellID->897672834],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"2", 
     RowBox[{
      RowBox[{"y", "<", "3"}], "&&", 
      RowBox[{"x", "\[LessEqual]", 
       FractionBox[
        SqrtBox["5"], "2"]}]}]},
    {"3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox[
          SqrtBox["5"], "2"], "<", "x", "<", 
         FractionBox[
          SqrtBox["7"], "2"]}], "&&", 
        RowBox[{"y", "<", "3"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "<", 
         SqrtBox[
          FractionBox["7", "6"]]}], "&&", 
        RowBox[{"y", "\[GreaterEqual]", "3"}]}], ")"}]}]},
    {"4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "<", "3"}], "&&", 
        RowBox[{
         FractionBox[
          SqrtBox["7"], "2"], "\[LessEqual]", "x", "\[LessEqual]", 
         FractionBox["3", "2"]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[GreaterEqual]", "3"}], "&&", 
        RowBox[{
         SqrtBox[
          FractionBox["7", "6"]], "\[LessEqual]", "x", "\[LessEqual]", 
         SqrtBox[
          FractionBox["3", "2"]]}]}], ")"}]}]},
    {"5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["3", "2"], "<", "x", "<", 
         FractionBox[
          SqrtBox["11"], "2"]}], "&&", 
        RowBox[{"y", "<", "3"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox[
          FractionBox["3", "2"]], "<", "x", "<", 
         SqrtBox[
          FractionBox["11", "6"]]}], "&&", 
        RowBox[{"y", "\[GreaterEqual]", "3"}]}], ")"}]}]},
    {"6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "<", "3"}], "&&", 
        RowBox[{
         FractionBox[
          SqrtBox["11"], "2"], "\[LessEqual]", "x", "\[LessEqual]", 
         FractionBox[
          SqrtBox["13"], "2"]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[GreaterEqual]", "3"}], "&&", 
        RowBox[{
         SqrtBox[
          FractionBox["11", "6"]], "\[LessEqual]", "x", "\[LessEqual]", 
         SqrtBox[
          FractionBox["13", "6"]]}]}], ")"}]}]},
    {"7", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox[
          SqrtBox["13"], "2"], "<", "x", "<", 
         FractionBox[
          SqrtBox["15"], "2"]}], "&&", 
        RowBox[{"y", "<", "3"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox[
          FractionBox["13", "6"]], "<", "x", "<", 
         SqrtBox[
          FractionBox["5", "2"]]}], "&&", 
        RowBox[{"y", "\[GreaterEqual]", "3"}]}], ")"}]}]},
    {"8", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "<", "3"}], "&&", 
        RowBox[{"x", "\[GreaterEqual]", 
         FractionBox[
          SqrtBox["15"], "2"]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[GreaterEqual]", "3"}], "&&", 
        RowBox[{
         SqrtBox[
          FractionBox["5", "2"]], "\[LessEqual]", "x", "\[LessEqual]", 
         SqrtBox[
          FractionBox["17", "6"]]}]}], ")"}]}]},
    {"9", 
     RowBox[{
      RowBox[{
       SqrtBox[
        FractionBox["17", "6"]], "<", "x", "<", 
       SqrtBox[
        FractionBox["19", "6"]]}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "3"}]}]},
    {"10", 
     RowBox[{
      RowBox[{"y", "\[GreaterEqual]", "3"}], "&&", 
      RowBox[{
       SqrtBox[
        FractionBox["19", "6"]], "\[LessEqual]", "x", "\[LessEqual]", 
       SqrtBox[
        FractionBox["7", "2"]]}]}]},
    {"11", 
     RowBox[{
      RowBox[{
       SqrtBox[
        FractionBox["7", "2"]], "<", "x", "<", 
       SqrtBox[
        FractionBox["23", "6"]]}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "3"}]}]},
    {"12", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{"0", "\[LessEqual]", "x", "<", "1"}], ",", "x", ",", 
     RowBox[{"1", "\[LessEqual]", "x", "<", "2"}], ",", "1", ",", 
     RowBox[{"2", "\[LessEqual]", "x", "<", "3"}], ",", 
     RowBox[{"3", "-", "x"}]}], "]"}], "//", "PiecewiseExpand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]},
    {
     RowBox[{"3", "-", "x"}], 
     RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]},
    {"x", 
     RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"0", 
     RowBox[{"x", "<", "0"}]},
    {"1", 
     RowBox[{"0", "<", "x", "<", "1"}]},
    {"0", 
     RowBox[{"1", "<", "x", "<", "2"}]},
    {
     RowBox[{"-", "1"}], 
     RowBox[{"2", "<", "x", "<", "3"}]},
    {"0", 
     RowBox[{"x", ">", "3"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funktionen von Funktionen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"Sin", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", 
  RowBox[{"Cos", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"f", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"2", ",", "x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", 
      RowBox[{"Power", "[", 
       RowBox[{"x", ",", "2"}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "'"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "#1", "]"}], "&"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Namenlose Funktionen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "'"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "#1"], "&"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "'"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", 
    SuperscriptBox["#1", "2"]}]], "&"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Function", "[", 
    RowBox[{"Power", "[", 
     RowBox[{
      RowBox[{"Plus", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Power", "[", 
         RowBox[{
          RowBox[{"Slot", "[", "1", "]"}], ",", "2"}], "]"}]}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dlog", "=", 
  RowBox[{"Log", "'"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "#1"], "&"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dlog", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", "a"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"elog", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"1", "/", "x"}]}], "]"}]}], ";", 
  RowBox[{"elog", "[", "b", "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox["1", "b"]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Solche namenlosen Funktionen treten \[UDoubleDot]berall dort auf, wo ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " selbst Funktionen erzeugt; etwa in der Ausgabe der L\[ODoubleDot]sung von \
Differenzialgleichungen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]]}], "]"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "}"}], "/.", 
  RowBox[{
  "lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], ",", 
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpolationsfunktionen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Interpolation", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
   RowBox[{"PeriodicInterpolation", "\[Rule]", "False"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
    "0.53", ",", "0.66", ",", "0.24", ",", "0.58", ",", "0.92", ",", "0.65", 
     ",", "0.19", ",", "0.67", ",", "0.52", ",", "0.30"}], "}"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", "data", "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", ".02", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "[", "x", "]"}], "-", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "''"}], "[", "x", "]"}], "-", "2.5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
     PointBox[{{1., 0.53}, {2., 0.66}, {3., 0.24}, {4., 0.58}, {5., 0.92}, {
      6., 0.65}, {7., 0.19}, {8., 0.67}, {9., 0.52}, {10., 
      0.3}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmXc81d8fx43szTWvL5drVGRUZKT3m4SkSJJESZEUkigqIyohUiGFSppm
pRIZqcyyZ0nGHdYtsme/z++fex/Px7nnnPd4vc8578dVcvez9+BgY2MLIz7+
/901sVOXjW0cbsgcGKic7oMq4fzruwTGoVmuZOMH3n54rSE6kiY1DvG9ST9T
yP0Q79GSabhuHGLf0X1msB+2djuSApzHYYlfUt0+ph/yKg7N0gvHQVqCPnZD
egAuJ/iX1h+fgM5L/ba35AfhdE6LrFzgBCzyzMlOaQyCW+2GIK/wCZB+1y1h
aDwIRpwzWlwpE2DyYHWL3/5BGA8KebDl8wSUzstJ37w9CC4HIyNfKvyFtqyo
12+5aLB+XdL2lNa/IPmWo4LZSgMO343k7l9/4Ut4ds5YHw1a8lrH5Mb+wtHD
2VKtLBr464jfyFg1CS+nxPPMeehQsCGh47HeJLjt3bDwwYAOWkbXjhSmTELP
davL4sl0WAlZrTfzaBIO3f8jb/CQDg0l1dwGBZPwi+fcIcyhg48J94uSmkmQ
8U3Qmf9IhxyMHK+cnwTriBhx4TE6rLW8eLH5wBT47Dbd027EgIWr8rYSXlPw
uDjGV8ucAXU1JZS9Z6ZgqATcT+xkwHHrhU9dcVPQJGWrkHiIAc92nuXvK50C
PsqbueuXGKDm4J/yW3Ea+oS1Cl0/MWDmtuhxHc1pyOsr1ViuY0BVe77RaYNp
uB279XlECwM89v3+OW03DX+WbrIb9TMgy/mEynLENLyBKX3vZQYoHfZ4KUCb
hh1ttuu7dZjQ85N58+KfaeCl/XD10WdCsrP3mT8L0+AwosY/aswEfge/Ta1i
M+Dr6aT8yIIJUxbBpXdhBuL+lK3wHGBC3qfFDMEdM5B2pevn8CEmHMfQ8FDH
GRjW8C16c5QJvYaRW919ZkBg3cl0AV8m1Gher11zbwZ291i1vQxjwqXnItn3
nswAuahrMz2SCSZqN+OEXs1A4/uHZM5oJrxSTLGdqJmBL8UmwSsJTLgn/rC9
aGYGvl3e4D6dwQTHBOq7tRyz8P6I8trQTCaICj65kyY0C4ZhPIMTj5kQxZV9
IFxlFpoWxD3u5jDBd66w39J+FvQ7P++bKGLC6sBNn967zsKzM4sOrSVMGJx4
n6VxfBZcj9FLH5QxwWm07JhI+Cwc6dIVXfnEBHEv0+0RsbPwIG2rTHwVE77S
Pq2dTJ6FadNjtXy1TDDtrWF15M5CeYnZ0c/fmLDkvKPR6v0sUDqen+RsYsLb
zm8FxZ9nwc814oBWCxPWNrcEZPyYhYItfWusOphA27l3ryhzlqg/qdWbuphw
v65T/9LfWdA9K28t/p0JpM898x58c5ChMKl//ScTGvDQj07SHNgHBFDW/WLC
tdL+D9spc/DIRunE+z4mrLxlhK3bNAcsmaOHUwaZULTh+OH7ZnPQuvuZxjCN
CQEFo2Ziu+Zg7b1zt9UZTBh6Ps41fXQOuEfJYd5DTMhUC2B6npqDoE0Zin7D
THB9NF3TdX4OtCgCaW4jTJChnHthfXUOVKyKOWGUCS1pC7Efbs7BLntOT/4x
JsTJXvTRypiDzH6TlkqCLZL/7XrwfA5IqR/3ebGYwCZxSUf8zRzcIzO4Fgku
SVglHlUxB5qCnGMhv4n8J0WHfKgnWESDyiD4xT3BwakOwv+/Ft7wh7Dv4Y0d
6wbmwLKovvEKwXefkgo9WIS/h7XcPxB8M/eOfMbcHOybGNTuI/jaa/nLHZzz
sMPrsOVfgsPfP2AJi8xDQg353f/5XLmKo6XcPAxJRF/vJ/jUl2dlYarzoGBD
7i4j2KteU71IZx5mTls/iyHYrbkgYdx4HjbFxPBtI3hf58a51Zbz8OSWncBv
wt5dP4vcDtvPA3+i2IfLBFsMbq5NdZ2HNVFmawUJ3jJcodviNQ81vk5HIwj/
9f+Y3+U/Mw/59jXn6ES8tKZrOLaGzUOmLk+QAcGqizYnzsfMw3GhGO8QIt7y
7M2tr5PmoZb55Wg2kQ8Sz97NYw/m4VqldkA9kS9Boe4slZx58L2/Oes7kc9V
Eq5Cru/mAcMPc3czmTCp4NH77ds8lDlUpzyiM2FEZdiCu3seZnf8HfQj9DGw
1id/C20eNu7iu6dB6KdFPzA8f2Ee2kIaI/0JfdVtnh9ici3Ap2deLYu9TPho
dnE3RWwBGoc+fgkk9Fmw67JyovoC7H0S3WZA6PeZA19s7foFOKDeJ3jp//p2
vj7JvmUBUj7WU0sI/cd7Jn0+7bAA1VYb1JeJ+vAJfezpELEAr1pFZCvrmHA0
ak1jXNwCCNu1fY+tYYJLTO6mLykL0DTZ9nsbUY82yW949fMW4H7RQcvYj0R9
5X15If1jASSPu9m6vGOCcuF2CTvGAqHPlk0vCpkgW/ztfPTEAij4r2YMvWQC
b1W7zTzPIqQ77m0wIM4L5k/67+8bF6H078XDKg+YkCXEvSEjfhGYSycMN11m
QuimGtG6u4twY7+n0PYI4rw4HPN7+ski6FDIvNYXifi/EX6xs5xYb2tUiWwg
E864SCst/1kEqZ08in+PMME8e7WIy+4l+Pf+yEryFiYotI+MXXVdgiPCfrRH
hkyYW8mpe318CbrXBck83MiEHHvdKwKXlsBUzarw5Foi3wuGy8WvlmDcM7fc
WpI4v6x2jMqSlsHwrOiO9UMM+HBaqHYbZRnY283e2QwwIDmt8Ym/5jJMH3x1
x6mHAdbje9xrzZfhma0s17YmBrxKcek+F7gMa4TfR59+x4BLDJ/qzo5lELFt
ddOJZIBy1I1HSakrMH9AKKJIlAHMYb3EiawVyGt7T3nKx4Ac2x+hOwtWYClO
RzqWgwF6ZDVnruoVqKq+YL5hig5Wr0pEA6dW4P6bG+bcncR92se46GD7Dxi/
ny18uksHlwyFnGscbDhWkreFh0yHJwtnrlgVsSGrL09tmp0GIeWMTafK2JDE
dv7G0Owg7IxyGk75zIa6GYyfraxBmBLabMNsYkNR+wW/m92DYKbEKX5lmA2b
Ax5ffVkwCL2Wiemf5NixMiTVMNp1EKSScgu3XGTHy/5+Nv+9It4v2oyBjWYc
eOfHtd0SO/pBMC5a8e9nThy7dtQ4taMHhj1uOr1cx4XPP5O1/O52gtl9SdGG
DVyYnXrs3uuoTrjbdad6xJALTadotpx+nWCz476+igUXvqhYpfJlayfk6eSQ
Ug5y4aOjXxM6WB1wevFL04UELnyyXXbdbvMOWLoxb2U1wYUHBJOMsxfbwKHu
ApvHLBee+CTO/pDZBrmcbEURy1yYv9Gi+ElrGxwM4lYv4eNG/68H0wey2+Dj
AQkuLWVu7A+1NqG4tsEVtXUfJfZwo6jb83utla0g+sHN8FchNwrcOZVASWuB
g7fa524Vc+OX6q6KmNgWyPG2LrKq4MbsatYw9/kWsJLduOlVPTde3NWQpufc
AuFBPHqXB7jxu6RRt59sC/zRydPREOXBk+dMd5y+1wybeanjvyR58PAuWSP+
uGaI+ZWSf5vMg4m7DvK8vdAMavERWitqPKhJ+/V2+8FmODjqoNlswoMj7DdL
jyo3Q8PjRfWzJ3gwbEqfNyqvCeQvnmJq+PPgR7EoiteDJvB2oD/pC+JB+9cr
y4dvNgE3Z6Oq9SUeHEjVvJQS1ARb3DKp/6XyoMtNY04hbIK4TdKDzRk8mO/3
5U7m+ib4LhyXeSWLB51Wehi7VJsgqDRQaTyfBzdaeKiN8TdBntx2xU9VPOhq
7CgUnNcISxOlvWe/8mCeBcNLKqkRrGvXZ2i28GCZsL384PlGYJyV/y/5Jw+q
cPwXKmDdCBttE3usB3nw31bNJ8d0G+GSGnfavyEezPQ7Kzsl00jU9x+541M8
aPVSqT1jqAFO5hz9/t8CDzb91EkpbWqA4sju1JZ/PLhGqSdF6H0D8B7Ytf8q
Fy8+UF1XLlHRAI7rP8lsFuDFP2+YP7bVNEAWn0HXuCgv+h0O0XlOzP/bl5Py
WIoX9+XcSTXpboDrCclSIsq8CLoW8vMjDRCiESf7VJ0XZVanuE1MNoBndYQ8
rOPFtJvjVjLLDYD/Tir7GfDidpe34RMijfDXd6tW4y5eNJt2G/62qREcd41v
SzjPi3Ud9ZfFbjSC2QjdSj2CF3V4aQG0e42gfeXHjvIrvPhIYnRi8Gkj8JZV
7f6TyIvG9uUyXhWNULIu3dX2GS96PNzjGzHZCBQh60CRdl7cdWMggaXTBILP
4dzT77yoEcxVssGgCebN9c5DHy+acEioJEATtFygRPiN8uKXj94+l3c1QdTY
TFwjOx8uJAQJ+Po0wXD9o6wELT4M1bMZouQ3wauY5VaRaD5U4HMsv2PaDDcM
biYqxfOh4Sud55ttmsGXoWa74TYfHk8soMw6NsMaM7s6xwd8+HTyxZH8k83w
YD6zIr2ID7n2dDLWpjZDvJdVrsYwH67uCrIxnmkGb4tbVyyt+fFgq8SQZgVR
L1Pq5vvt+PEC78ih4G8toJb5gf2EIz/mhpeWdn9vgf5l+oV4d36kGx/raJ9u
Aac3BgHtIfwoOiy+5r1mK1io9B46ks2Pm4M3lMlmtIISxxrDMEEBBKuehdz4
Npjamb+yWlwA41kWnabpbVCTqve5RVoAe1mmRTSi/n11zWzVqALIdoRmtq+2
DYrdDnh8MyTmdxWnsFa1g3359UTyMQG89iZbrSm0HaIu/B1+91EAnU/Hik1d
6ADGTMnd8SBB/C+38Pt4RhdMH5PIavonhHIaehbc1T8hhy3tekSECH5sso06
/6gfXASqDO+eEcXnW/pWU9bSINrhAVv2JjGc385eKPeFAYdc8r58YIlhgmuP
egzHMAT9Jz7SPC6GJ0+YcOQIDBPv3EBh5qQYpl0t3lxDGoYyN5N9YgtiuBxh
k/dHbRgUPL4OeXCLo8qDZ9fmrYeh12dEQERRHOfj+O0mEofBNUzN/rCdOGaE
lyauJ4/AGYwJCtojjgaRrpQE6gjEsf++G+sojrds9CdoGiPwIfLN4BsXcUys
a9e7sHkE5KPNA/mPi6Nw0mM7J9cR6Lnhfud1hDiy++1eLEsfgQOZGb1cr8Xx
abzyPR7ZUaj8Upkl+FYczZ77nXOijMLaYYa3xHtxTCtqqnyoPgpz2tqzlHJx
LJleuvCf/igklZaLbK4XR5ds07tF9qPQ2NWHpwfFkUvsrnhQzChsFaE+6pWQ
QPF1Z+tbJkfhxXrL43QpCWxcfD5MWRgFcccT2mOyEqj00d3Tk20M+tJel8wr
SmCx3+39nYJjcHGteRtJUwK9FDYb2amOwbttHlw7zCXwZkNxaLLDGGhceHrs
3RkJtOz3oBvmjEGc72fdmLMSuM3iBEng5Rj8dutfdAmRwFGFmPbWN2Pwahv5
Bke4BMY3ZfzdUT4GRiIJRTtjJZBW/LuzvXkMrDOD+GgPJfBs94Wd1tNjkHP7
VuvbLAkM+e7kmTg/BsJXC9KvPZXAl7RzjxqXx6DlxIiudq4EyhaL+Olys2C/
3kHnkCIJjP3tHntNigVeNduyRRslMD97suOyHgvqit0DB5sl8MJD2yVjQxZo
5obB2zYJ5NOX6xrazILxxPetB75L4Ke+yylq5iw4e2Dd0hO6BPpVRgTq2rOg
a6d1VfAQ4c+G/+LT9rLACI/dsBmVQFb8ZrUVJxasqDxU+TsugYwnie+zDrHA
Tbrs9+dJCbz+VvDpsDsLKvl+FKXMSOB/e5PnVDxZoLI0e8l7XgJ/a+x+6nic
BVd+k3aaLEmgM+1QTuhJFgz16UqL/pPAInU6W7ofC6xbd/UPsJOwVaolSO4U
C3K+nMh+s4qEb87EfTAnxoWLogOjeUi4IHTezsOXBadePIYD/CRc/WPfpgs+
LKJ/quTTEiJhRVtP4DVi/eSIpfRWcRJu064WvOrNgrkAWa8nkiQ0iHjge5aw
x9lTf32wDAmf9PMZH/RigcKOU1UKCiTkKjijJkLY/5hE+318DQn1X7J/XXFj
AdsNu+RgTRK6XvC0vUz47yxQanJNm4RT93NL2A6yQIQjOe6ZHgnPOC56djiz
IPiP5VqmKQlfW8PL5T0saPMubJ4xJ+H+R4dVNIl4azEowdxWJPSjpBTY2rFg
sGe+WnUXCYdZezSDbFiwsy7b46gzCcUelO83JfL1bJuM0BlXEmozVLfImrGA
42NUYaQbCT/IN51gAAvevXPlfORJIvTOW+JmzAKlxyIP+0+TUPzlm+Z2XRZM
hwX0HIwlYfBFB9VqeRbYLf6K9I0n9i9rPzUjy4IXQTYaoYlE/K8ueZClWXDI
RzUkPYWEv2T3eFiIsaDWuVO65xEJebka3ZS4WJCuZ7xn/wcSXrJ0ujE+MgZz
BU8XvMpJuJ5TePtF5hjYa5Iyz1WScOevOgE22hjwUFnjKTUk/HTwdDWzZwz8
Re/Hd7SR8Jk5tQIbxmDbKEfdHhYJtyy5L/2XPwZ39bwCtcdJeKW8zXdP9hiM
h32jCEyS8ARD5Er4U2KcdOds5RwJ5ztC3368T9SjyTpV3VWS6B9z5Vlfwhjc
ubEvXJgsiacCz5KTfMdgRC9Hv9ZKEuk6L+MXiHqHcLGBrB2SKHFBVk5LaQxu
1wVdD98lifIjWsz98sT4IVPaJgdJzHyyvP+uODEe3ZH45JAk9gz5a5SvjILJ
DzZWZJAk5n79U53WPgo3wvc+2pIliT8Z4oZ1F0dh47rz4wJPJVHsO2W/5rlR
6O5+YNL9XBJv+zzOuHp6FJQ3jHUG5EviKCsuZ82xUSikXxJ8XiyJgRlae+Xt
RqHLuiBQolkSqySu0sqJ81JRUsBqaFkSf0/37qaUjkDe84qxxH1S+PRruez2
wWHY8UtPOs1ZCn9mtyde+DEMQ6Rs0yeuUlhW7b33eeswKIcnJRcfkcIg7xcd
vz8NQ7KjNw76SaH/rseea7OGIYyTdHtjtBSS1N7TvY4Mg53rMePOIil0qmh/
rvlzCP6KCsfIy0ljFkdNkmw5E2IkLxT9lZfGf5l9IT5vif5QboRRoyiNluHX
mj/kMmE3tWproKo0FlsVMXamEf2sXujyNx1prDpdoW8UzARf59+nwiylscNA
6z6sJ/rnRw37Bs5IY/istKLiQ6J/erb5StFZabTxeBU2ksIAudwXhfEh0lhT
A6Mv4xmw/e0VMeNwaRyrPjSz8QIDntVsqb8VK40XeUfdBfcxwJOVt2VbpjRq
POivWiXIgH79BNVnjdJ4+DbT0iSADqc/2+iWtEijUn1iwycvOnDY85s0tEvj
uQL6EYuDdFD2ueww9UMaNQ9OtsB2Ohx9dD4Sh6Tx7eoon1WKdJjSMUzYMyqN
au/2k06S6BBVNnPX87c0VmS+WGjko8Pjbv9XcVPS+N5LPSNuigb6x7TL7s9K
Y1ne1WP0YRpUTY3VvlqQxs1rvkYb/aKB46UX7V+WpZFDWIQ3ro0GDBGv/i42
GexZ1r4nWEuDoHRV1iinDKaV7v3uU0IDbo3BuRVuGbyiMpFcn0sDdYuDoqpC
Mnh6q17dhZs08LrgAP6yMqho+Zz27gANRocwnW+9DKafmrK4T/R703f/kk7c
lkFz0lCkms4A/LzpeyZ5ryyW7a+oLY//CX7bFVoq+eSwUtBf+OBNol9LpLk1
Ccqhd2rEzW/BnUDqfvHnp4gcnkt4cGfH4U4o9tokNC8ph62jT7MDdDqBO9rO
SltZDu1atf3PNnZAetWlsntGclhaW552XLQD6rcyX5w5IYeFb0tiujPaICM2
1/CSrxyaFBul74tug1OtATUJ/nLIqnmvP+TfBlJH2BgvzhLrGzuGmW5rA/dL
skr9kXIYRj8w2jnWCvMVO1J2pslhdqHe7gJoBfUtBZFq3+TwedaK1/hUM0w5
+EmxNcmhw5XBB3YDzVB5Qut5d4sc8n1KvPC5keinUnMa4rrkMDF7+CrzRTPc
nnomOzlI+F83UPefezOwZT/ML1+Qwy0NHbTDbU3QJX3rh9NqMl697/BvJbER
nmjZ+67XIOO+1V0lQqcbIWCbGLugFhmPWtC2W9s3gnBAglr5BjL+Xm7L3inR
COYNsf6qQEbZ0EaITGmAl1FRPH/3ktGhp9+n89k3iJkI3BAbSUZmj7nozfF6
eOo9fczxChmvCfdzmHXWw+fBM2lK18gYVW+6TaWsHlbaA7iK4sm4v/RUaHhc
PfgX+3fSUsm4bv8RtXSNenCK9Dm/pYCM1fo3T9wMqIPApbF8vtdkPKi5/kyo
ax3cDDxJa3tDxuurpPrvW9ZB/bETO0+UELy+NidSvg622BxXvFNFxnuuH/za
ampBVdLj00QPGYPefK38olELZvG02Q+/yDg+4LFGUbYWDvIc1YweIKOVdSXv
S+5auDPvnqQwREbTNNpM6EANvDk9UDs8QsZmfyOvkqYaaBk9vFLIIiPfvgBp
3fIaEOx1O7Zjkoxb1PKmatJqYM2+vntSM2SkLsLl0dgasGg61NQ/R8bwN20y
VudrwH37r1W5i2T8Zl3Y1+tdA2GVBw3PrZAxoEBNuMC5BtKMe322ssvjDZ1x
XZZLDRQVumYKr5LHXBA+5xtYA+3rfnZ0c8ujfWey4Nr4Gvj7xEXgMZ88uqWK
ZSs+rQERSg+cEpTHcnVuEduKGtBMPXDGWEQe96ssTb7rrgHPWOefzSR5HPzD
r60nVAvdfk75K4ryWHH52lh7UC1UGDjscdKXx29ORffOONRBhxHVw81QHr9+
4cyJJ/IxuvlvkNdmeUyuzXdj3qwDKdMbd8+ZyeOTQJP9e1rq4OT2r/13dsnj
5rDiaQGHepB2Nj/V7SmP1/fetnvt/hV8z2+87pwij4z5eJ2gFw0gX0aqdpmT
x60f/nQ6DDWDZkJPj86iPKopYdDgUjNsdsv6u2pFHiN1tTsixVrAhWOjQi7n
f9gZ1WAzb9QC6RZ7ApeF/0N9S8f1r+NbQKExkZqh+h/Ofc6p2WrYCpQ+4fBf
9v9hz8y1gF+pbUDl4DN0zyX4y1Nr44hOsI36tZLhr4AGSroOyzq9oPZluLJn
tSK6iH9Jstw4AOfsig9kayii64bXJQI4APU/YqaCtRTxZeBRyfodA3Dqr4aa
9EZi3DddwfjIAJQo+l7bDYp4/YF5Zm/iANiF/LWt2quIVde3mqj8HoDz2os9
+ZcU0bjol4FO5iA0FNcHhl5WxCuNlzcY5g4CxSJNeGe0Ig5F79M3LhqEKhcT
HLmuiJS//CJrGwZBNCbskUqqItKFr6u9nB+EJzRO79R8RYyY7f6w15YGc35t
HF6vFPGsRKUUcz8Ndixm3dN/o4gTYvxHTh2lwbiYxbfWYkUMq7K47h1MA2OI
1hGuUsSPobvMFjNp0JQqOHupRxHdXp5eDiXuA3Kepk/8L8KezL3n3P7RwLPS
ZjB1QBGndFd0NvHTYXkkrrFgSBETNq5wfCbuG6t/Ods+jCqiZN6q8eC1dLgt
8a2k+rciSjVrVaro0WHtZqFnvVOK6KNoU+pkTYcgu3UKI7OK+MXu9/t+Bzp8
PLrz9vSCIl7eJL710CE6CAb78LOvKGKeY4JZ83E65FRZ4BU2CkpoZkqZ+NOh
pclxUYCDgpkb8ih/T9Nh9rvn20ROCr7+tOrqvTN0MPtzRTOdm4Jvi7Si68/S
wWs+manMS0H7kqb19sF0uM75NPMZHwWrIpz3fwuhE+dltUyhIAWvJVUaPrxI
hxWlzlZDYQpGhftxLoTSQUWTGV8uQsFs74deluF08EMernpxCjad1VWtuET4
ay1dYUeiYLDBwbjRSDoUO6if75D8v325eQKX6cB93HKiX4aC9SRb87VX6aAZ
sC/nmBwFz9w5Vb06mg67Lx47xiJTcCJxt6r8NTqkJV79OadAwVKlPzf6Y+hQ
eS/lTiiF8GdvSN7rWDowHz/ds0qZgl1G7lUhcUS8Ct4Jx1ApOKsY36d/nQ7r
i6trRVQpOLyHvmqIYKfPnVFJahSMVLU1jo+nQ2gDE8irKZg6+Cp2TQIdagd4
3qppUDDRjesu3KDD7zFp/xxNCpJLK48VE0yaVddcr0XBc6bSfmsT6WDEbsB8
p03BkM0j7xIIdhOwyjTRJfZfUrYeIfiKpJPrp/UU/Nz8bJ3RTTpkK3rJbN9I
2M93xDuM4KY151ob9Ij4TBrwFhM8syE63mETBV17xURGCJbfcmf7dwMKfpBp
vyJyiw6mVs9WuRlRMGni+Nm1BHvaF5XTjYnxd++GjAiOc6kJOWFCQe7ixwNI
8CvPLr2JLRTcbkn22Uxw16mh8SCk4P68fwnrbv3//+C57CVTCgpsMdpDIph6
mffYpa0U1Nv2qmyc2N8qQUaZdxuRb3Hb75UE+6au/nndgoJbp2dzYwi+/cjg
joQVBZuNb5taEVyca7UndTsFNfQE0hcJ//veOQkr7qCgqo55TRbBXJVetVk2
hP3n1eq3Erz267motbsoaOeZmttFxNeuIxoKbIn5EHX2CMGTlklL5N0UbJT+
tTxG5Cf5/cP3V+0pyBMLVT4E96QVbzi0l4IBXz/r7yXyGSZcPV7nSMFtbp9G
S4h8K4e35uo7EfmXPb8kS7DXkTF14QMUZFyrtf5A6EegfY4W7ELBX1xGSWwE
51lwZdJdKchcL713M6G3qTUK8qVuFDyuUb/rLqHP8HFb0ZOeFPx5lKN3PIqI
l7vLt85jFBQy+Hh1gtB7VatXzNbjFKxt2fN9mKgHwXcRq8gnKag+8vTWR6Je
7lx8PVfrT8HVflP8whfoYPyn/I1eAAVP7zTK/0rUX6/b19MPz1DwC1+JdiRR
nyrm9LFzZwl+SvnVGUSHfH7pfvWLFByw9MimEPVvf4GacSuUgmvo3vQMP8Je
lvaBf2GE/oLEtSV9CX02W7V3XKLgIc5F/hFvwr6UkNrL0RRUipdL1TtK7KfS
+3LwFgWX+7pz9++lQ0TyiK9tEhEvaT76gT3E/ryzGiXJxHlx6tlNx9108B4V
eXIzlYiX6Ki33k5Cry9N75reJ+rll9enVHM6CMPjS/dfUHBq9fXXHOvpsC5w
f96aHAru2lYQ5axNB5tsoe+vc4n6bjKZfq5Jh1jpIN2aAgoe1d/Zrq1OB95x
i77xtxQ03awT1EUm3vsPh0zMPlHw27b77lmcdFDqTDv+9TMFD7jd/xfMRgcU
2p3kWEXB86M/yyyXaRAW/H7Mu5aCFXvqP9fP0GBpd8y9W40UfO7r3BpEvOdn
ODTnaT+I/P/qV3b7RgNJwz4Vv58U1BX6V1RCvN83+t22m++loGOO1pRIFQ0C
fiw9FRqgYBiGhGSWEffH62+O+kMUTK58k30qnwYjR/0Kr04R+QbHmqIEGvRW
vfJbK6SEK7nLaro7aKCqZXkyV1gJySoO5lUWNDiZ9MNLR1QJ94Q2Wuw1o8HC
kVXu+hJKKOe8Wu6wIWEPu6ODmawS8gsKtOqo08DGeN7AWVUJv5t22r9jp0FJ
PnDEmCjhB4PMwuRXg3Dnztfbwz5KeNDvw247rkFwOeZ6y95PCbkvnKMt/xsA
iv7vxJJTSjit96796cIAPG8VSbgeoIQtp3vGxv8MQLHwnmu6wUr4ySkr3en7
APREdV8MjlLCbin56Mg8Yr4/w5PvnhKOepqcC3AYgGfb2QzX1CjhsfzOCPKd
fqiTVb26aq0yLjS4zJxs+AVmtUcc3C4rY0pNt15PSg9kVebtH+9VRtP0xbz4
lG7gfn2CN7BPGYUjJA1UY7vB69Hqd/P9yij3wNKoMrQbNKIySZx0ZfxdnTMk
4tkNr7YlN0qOKqOmRVTW4sZu+FhzcZvxrDIGGxfaKbd1QW+Dje4VESpGLAWb
yMl0AZbz9fGLUTH2aId1hmAXZOZXxSeIUzGlWrB6LXsXeNzAsTuSVCx+W27t
OtIJY7s3Ps0mU/FbhaX+2tJOWGwj/9esTsX7lZqO/kc7QebHCK88UlHuVM55
5eIOmF2f9f6KKRXZaTNzlwo6oCPG1XvCjIocG9kvjT3pgNtGTfVV26jYIrpj
5PutDhC7+ybefwcVrfefOKfm2wH8+8NJ1Y5UTOC4VxCp0gHLxOV42oeKDunp
Zfl32qFHq7Gpx5eKjhv73a1vtMOHK9ERlqcIf0YTX/y52g4h+osD8gFU1D2i
s8/5bDvMJPU9rj5Hxe/isjEvHdth3CFb478oKvraOV44Ld0OAy24qeYuFfs0
jlWkPGyDLX8eOu5Oo+Je/YT9/HfbIFWAM+h7OhUNviXYx95sAzvzL4VjD6go
4fEvqyiyDcrebF8v9pSKh+93J1Z6Er+/Y7/O+TUVX9peLn2o3QZTha9tBgup
qLSB6w/7GmJ+M+nkybdUDHk7Humv3Abc/J0vQt9TcfDwH5kwyTY4c/7A6kfl
VIzL/fpm71Ir2B08Sh2rp2L2GnHWytdWyAn5Yhb4jYonFcjjLtWtwJOi5r7S
QMXHVcrO9R9boaxx6IFoCxXtZ8Szut+2gqapj4JeFxHvjUXtpQ9bIdq1waSs
m4ru6nMdD9JaYTBY29XyBxU197F9vJ3SCndfTdzb30vFbRt23ci/TqyvEiQb
SqPiZ1AaeBXSCu7YacDDoKJJKO2PQhCxn4uB0w0mFXMjDb3S/FvhTNJCcuYI
FY8+u9hd79UKA9xhpOpxKhqV5Eet7CN+P3xVRHSZipPSVdofife3AlW3kUyw
mm1gwBOCQ12+x6sTzCjcVxJL8JZGTWEgOO7i232OBJcXNgv6Eiyh8Kty1KAV
KsLI/F8JlvWfdpcmuFIyf1X0CjHOs1znr98KyrZOn28RPCWwPWkfwZei2aPu
E3y5vv6ICcFmi3s43xFsMhYoxEfwp745dgbBjxoO3Xqg1wqfs83+bf1H6G8s
83jTxlZQoY+W2RJcNXzs7FuCoxSSQg8QvHjM41oaweaJzOXTBK934i/2Ivhz
UNzSQ4KDlP/tZP///AK9D7kE38fYi8wNxPzh3vPvCU6qtHv5jWBzF93FJoKP
H4lWvUtwVtL34h6C+UsWPMIJXtUYGTL0//2YT154EnyUd53R1P/X474+aUPw
F9OO+X8E79mQixsI/h9nKDHL
      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Xc4le8bAHB773msgyORVCJSyblTUUYoyUq+VlIZhUoikiShMjKSEA0h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      "]]}, 
    {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4lN0bB/CxzDyPLEMzGpnJTJb0ZgvRQtyllSwVLXi1IVGkQouQJEqi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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{0, 0.2},
  PlotRange->{{1, 10}, {-4, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"-", "0.01"}], ",", 
      RowBox[{"+", "0.01"}], ",", "0.002"}], "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.26586783333333325`"}], ",", 
   RowBox[{"-", "0.26437141333333336`"}], ",", 
   RowBox[{"-", "0.2628697533333332`"}], ",", 
   RowBox[{"-", "0.26136285333333337`"}], ",", 
   RowBox[{"-", "0.2598507133333332`"}], ",", 
   RowBox[{"-", "0.2583333333333334`"}], ",", "0.08818514666666645`", ",", 
   "0.0897005866666666`", ",", "0.09121298666666644`", ",", 
   "0.0927223466666666`", ",", "0.09422866666666646`"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funktionen mit Ged\[ADoubleDot]chntis", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"Switch", "[", 
    RowBox[{"n", ",", "0", ",", "0", ",", "1", ",", "1", ",", "_", ",", 
     RowBox[{
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392923219-2819462"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "n_", "]"}], ":=", 
         RowBox[{
          RowBox[{"fib", "[", "n", "]"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{
           "n", ",", "\[IndentingNewLine]", "0", ",", "0", ",", 
            "\[IndentingNewLine]", "1", ",", "1", ",", "\[IndentingNewLine]", 
            "_", ",", 
            RowBox[{
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "1"}], "]"}], "+", 
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392923219-2819462"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "6", "]"}]], "Input"],

Cell[BoxData["8"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392923231-8882356"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "0", "]"}], "=", "0"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "2", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "3", "]"}], "=", "2"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "4", "]"}], "=", "3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "5", "]"}], "=", "5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "6", "]"}], "=", "8"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "n_", "]"}], ":=", 
         RowBox[{
          RowBox[{"fib", "[", "n", "]"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{
           "n", ",", "\[IndentingNewLine]", "0", ",", "0", ",", 
            "\[IndentingNewLine]", "1", ",", "1", ",", "\[IndentingNewLine]", 
            "_", ",", 
            RowBox[{
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "1"}], "]"}], "+", 
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392923231-8882356"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "fib", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392923246-8288062"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "0", "]"}], "=", "0"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "n_", "]"}], ":=", 
         RowBox[{
          RowBox[{"fib", "[", "n", "]"}], "=", 
          RowBox[{
           RowBox[{"fib", "[", 
            RowBox[{"n", "-", "1"}], "]"}], "+", 
           RowBox[{"fib", "[", 
            RowBox[{"n", "-", "2"}], "]"}]}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392923246-8288062"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "6", "]"}]], "Input"],

Cell[BoxData["8"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392923255-3975449"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "0", "]"}], "=", "0"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "2", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "3", "]"}], "=", "2"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "4", "]"}], "=", "3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "5", "]"}], "=", "5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "6", "]"}], "=", "8"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "n_", "]"}], ":=", 
         RowBox[{
          RowBox[{"fib", "[", "n", "]"}], "=", 
          RowBox[{
           RowBox[{"fib", "[", 
            RowBox[{"n", "-", "1"}], "]"}], "+", 
           RowBox[{"fib", "[", 
            RowBox[{"n", "-", "2"}], "]"}]}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392923255-3975449"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "1000", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], \
"Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], \
"Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"54122222371037658776676579571233761483351206693809497", " ", 
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"745", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"745", "-", "2"}], "]"}]}], "]"}]}], "+", 
  RowBox[{"87571595343018854458033386304178158174356588264390370", " ", 
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"746", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"746", "-", "2"}], "]"}]}], "]"}]}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerische Funktionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "-", 
  FractionBox[
   SuperscriptBox["x", "6"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "10"], "120"], "-", 
  FractionBox[
   SuperscriptBox["x", "14"], "5040"], "+", 
  FractionBox[
   SuperscriptBox["x", "18"], "362880"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ivar\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(2\\) is not a valid variable.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ivar\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(2\\) is not a valid variable.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"-", "0.7568024953079282`"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "/.", 
   RowBox[{"x", "->", "2"}]}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "0.6617283950617284`"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392923295-1995550"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{"Normal", "[", 
          RowBox[{"Series", "[", 
           RowBox[{
            RowBox[{"Sin", "[", 
             SuperscriptBox["x", "2"], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392923295-1995550"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "0.6617283950617284`"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392923315-8046651"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], "=", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          FractionBox[
           SuperscriptBox["x", "6"], "6"], "+", 
          FractionBox[
           SuperscriptBox["x", "10"], "120"], "-", 
          FractionBox[
           SuperscriptBox["x", "14"], "5040"], "+", 
          FractionBox[
           SuperscriptBox["x", "18"], "362880"]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392923315-8046651"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox["x", "2"], "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1m3k0Ve/7/s85OCjvpJShQUkiQ4Uoyb0LTUqmSgMhGigyRCEyhEgpisxT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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw1mnk81N/3x8eW0mYLoZIkohKKJGdkyZYtlU+pEG1Ei1QISUgSkuxkTfYt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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{-Pi, Pi}, {1.1, -2}}, {{-3.141592653589793, 3.141592653589793}, {
     1.1, -2}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["268", "405"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "-", 
  FractionBox[
   SuperscriptBox["a", "6"], "6"], "+", 
  FractionBox[
   SuperscriptBox["a", "10"], "120"], "-", 
  FractionBox[
   SuperscriptBox["a", "14"], "5040"], "+", 
  FractionBox[
   SuperscriptBox["a", "18"], "362880"]}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392923347-4532818"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"f", "/:", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{"f", "[", "x_", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"MachinePrecision", ",", "MachinePrecision"}], "}"}]}], 
          "]"}], "=", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          FractionBox[
           SuperscriptBox["x", "6"], "6"], "+", 
          FractionBox[
           SuperscriptBox["x", "10"], "120"], "-", 
          FractionBox[
           SuperscriptBox["x", "14"], "5040"], "+", 
          FractionBox[
           SuperscriptBox["x", "18"], "362880"], "-", 
          FractionBox[
           SuperscriptBox["x", "22"], "39916800"], "+", 
          FractionBox[
           SuperscriptBox["x", "26"], "6227020800"], "-", 
          FractionBox[
           SuperscriptBox["x", "30"], "1307674368000"], "+", 
          FractionBox[
           SuperscriptBox["x", "34"], "355687428096000"], "-", 
          FractionBox[
           SuperscriptBox["x", "38"], "121645100408832000"]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392923347-4532818"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "0.7568025787396145`"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "-", 
  RowBox[{"0.16666666666666666`", " ", 
   SuperscriptBox["a", "6"]}], "+", 
  RowBox[{"0.008333333333333333`", " ", 
   SuperscriptBox["a", "10"]}], "-", 
  RowBox[{"0.0001984126984126984`", " ", 
   SuperscriptBox["a", "14"]}], "+", 
  RowBox[{"2.7557319223985893`*^-6", " ", 
   SuperscriptBox["a", "18"]}], "-", 
  RowBox[{"2.505210838544172`*^-8", " ", 
   SuperscriptBox["a", "22"]}], "+", 
  RowBox[{"1.6059043836821613`*^-10", " ", 
   SuperscriptBox["a", "26"]}], "-", 
  RowBox[{"7.647163731819816`*^-13", " ", 
   SuperscriptBox["a", "30"]}], "+", 
  RowBox[{"2.8114572543455206`*^-15", " ", 
   SuperscriptBox["a", "34"]}], "-", 
  RowBox[{"8.22063524662433`*^-18", " ", 
   SuperscriptBox["a", "38"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", "20"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "2.`20.", "]"}]], "Output"]
}, Open  ]],

Cell["\<\
Zusatzdefinition, damit f in beliebiger Genauigkeit berechnet werden kann\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ",", "_"}], "]"}], "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3392923409-8527092"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"f", "/:", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{"f", "[", "x_", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"MachinePrecision", ",", "MachinePrecision"}], "}"}]}], 
          "]"}], "=", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          FractionBox[
           SuperscriptBox["x", "6"], "6"], "+", 
          FractionBox[
           SuperscriptBox["x", "10"], "120"], "-", 
          FractionBox[
           SuperscriptBox["x", "14"], "5040"], "+", 
          FractionBox[
           SuperscriptBox["x", "18"], "362880"], "-", 
          FractionBox[
           SuperscriptBox["x", "22"], "39916800"], "+", 
          FractionBox[
           SuperscriptBox["x", "26"], "6227020800"], "-", 
          FractionBox[
           SuperscriptBox["x", "30"], "1307674368000"], "+", 
          FractionBox[
           SuperscriptBox["x", "34"], "355687428096000"], "-", 
          FractionBox[
           SuperscriptBox["x", "38"], "121645100408832000"]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{"f", "[", "x_", "]"}], ",", "_"}], "]"}], "=", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          FractionBox[
           SuperscriptBox["x", "6"], "6"], "+", 
          FractionBox[
           SuperscriptBox["x", "10"], "120"], "-", 
          FractionBox[
           SuperscriptBox["x", "14"], "5040"], "+", 
          FractionBox[
           SuperscriptBox["x", "18"], "362880"], "-", 
          FractionBox[
           SuperscriptBox["x", "22"], "39916800"], "+", 
          FractionBox[
           SuperscriptBox["x", "26"], "6227020800"], "-", 
          FractionBox[
           SuperscriptBox["x", "30"], "1307674368000"], "+", 
          FractionBox[
           SuperscriptBox["x", "34"], "355687428096000"], "-", 
          FractionBox[
           SuperscriptBox["x", "38"], "121645100408832000"]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3392923409-8527092"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", "20"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "0.75680257873961450258765806167352880905`20."}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox["x", "2"], "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1m3k0Ve/7/s85OCjvpJShQUkiQ4Uoyb0LTUqmSgMhGigyRCEyhEgpisxT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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt23k8VN/7APCZQUVCUVJSSUqkQpHkmYoihSylopA2ikIU2UuiRBRZsic7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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{-Pi, Pi}, {1, -2}}, {{-3.141592653589793, 3.141592653589793}, {
     1, -2}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNfXl81cd17w0Y8JLEGDtO27wkdtzGbZy+1rWTNE39mr68OturnT9cN3l5
tY3xghdsvMZ246apl9ox2GaRBFrQBkhCEosQEgJJiEWgBQkJhISE9g20oRUk
gfC835nffOeeuXfu714w79PkE8ncn2bO+Z7zOzNzzpkzc/9x4cuLH1+y8OWn
Fi285YcvLly6+KlFL91y7/MvOo9mf8bn+8xin883fIuP/i2cf6pfwvm/eIp+
0ZPL/3e8/M8ccdNNN4kHHnhAvPTSS/KHmFwl/zZb3HHHHeJnP/uZ/DRLte/s
7BT333+/ePHFF8V9991Hn30FJsm2tjZxzz33iPz8fHoi7rrrLk0yKipKZGZm
GiQffPBBkZ2dLds6f6PPIBlF/5lDoGYrAiMjI+Lee+8Vq1at8l2rCCxYsECc
OXNGEhgcHBQ33ngjCHxedTu+pVT+i36Wq2fT09Mknli9erXvGkWKVHzx4kVJ
amZmRsyaNcvFPocUk6R61m/1U/ucyagqeZf+04fqGWGaP3++/HR1CMzOe4CS
fO6LdmmkKBrla3JDseR/+kCR/+lPfyqGhoYk+fr6enHbbbdpGQP1/fOf/9yT
9ZH1hZfCOj4+Xvz4xz8WTzzxhLSUqqoqzbqrq0uqnKyH/tvd3e3J+vC6naFY
H04sCGx+qYrjgnmR8FBApCQ8BClfu8NsLilEAL8iLi8i3tWpnx4+U7aHCVzm
e6hK2hWZICm7P601cFbh3sP/P4PyeCNBL9Wwhsr4/JAaYBbmxbsyISSJ6uTd
kcEP/R6ugDVw5VymEiPWRWh1VsRGZg0e6gyyBuNVeigx0oHtoUQO6zJfpQNf
fPLJJyFJJKt2FyantaifDyYxPT4ZloTTRtSml9hIHMvcFxGJqdGzepEPIOE8
FpMjE2FJjJ8+40XC+XPAq+QdT+6qsnU8ueuw2TEE7zNtp0OTqBLDHX1hSQy1
9Iq2vUdtJJqLjtCfw5Lob+gUHQeP20g4jyMicaq2VXSVN4QicfpYm/z0O/n7
KjE1NcVdz1n0D99ccr00ZecHnqjrMc4VtbW14rnnnhNLliwRixYtkg5sR0eH
zZOQuGYRrOtNNN2VjfRUfoJHyDu6xOYYHitBoSEBZ7S0tFR8//vfV2xDK4Uk
B68ApZC+emua5ae36bf0Qa+yAPosrG18XMyZMycipgMnukIxxXu2yQ53bfny
5dJlGxsbk/q+++67mTecqHq27T+mTSOA0UBTd0SM6NFPfvITkkt861vfEnV1
dVa/ELLRmAjBkoZB695aw8ouXLggcnJypEfvULvOgmRuGG5jp4Zs3JyBqcct
uDnxgygqKhKvv/46CcS4ieeff55+HDt3fnsJeGJHuZ43AljSbNO0szLsSJRz
Vt+wlUTfsJ7pwpHA5BtAgqbsSEjUpO3xIoGFI3hSpbXDWVpsHT+5+InZMQRv
vgArEterP/ElNtmDBHcKA0hwV9KLBHdGAkjwVdqLBHfMAkhw6p6CMF/hMkl4
oIhUEO6mh1OnYQ3cU7vMV+nBm0vmRYKLGYiC+YuXaQ3cob1MEvwt/9ehCHoj
5qsMrcRIhxRvd5mWyDFe+fEQqSDcai7TrPn7CiDBPXgbCaSznDZ6rrw+mASm
b/+rREc+gwd0PL75gNkxBG8iUbOx2ErCWX0m+kfCkpga87v+ASQa8yv0MupF
gtbU+m0HbSS4++1FwnEQtCcQQKK1pFZ7K+/L35fq+Lp+nj37anMjAIqcIcf5
t4GS7mGj6x4uU8+C/d/IM7ZeMAaZGxgAo7OsQbvGb9HvkP4vfEVbtteLOTm7
Dhcbc+58/6ki33q0S3z0T8tEwtJEscL576HtVb6HPeD4PDPGS1WrbasKRMzC
KLFyYbSIemilaKvr8v2Zotp7pFmrIADg6bo2rbjb1bPuk6dFzKIYMXl2Sr2Q
2SL5tY2iJL1MfvqXS9BdqKzzC/L3PIfmIRH7XJI2x3POaI1+NFrUlbUohamw
rq7NBl+GpPvckPTr6tnMzCdixQO/E+PDZ/Vrjn06XnQ2uAPkF2qAWH32yJPX
S2FfDb0i/jkVqsAcT42Ilf/0gXxt0CoPYgKk4D4+pMheliuKM8qMkTI2fFZ8
/H9XGlJYY4HI8+CQYs3itVJhnF1lfq3Iei/HgCUnq/bTNiloinOiCvnpT9Sz
89MXxJon1spPKgASaW+kiX2byjh7A9Lzqt2BrHKx7eN8o++aJ2Mds5w2eDTm
V+opOADSuTPjeuJG880fbBdVhXUG2YuOv+9YfFhIKx9chqGo+x7edUzDBA+5
sAyM2CC5mag9RvM1i2M1q3nq2baVO0VFfg1nb0B6TrUrz6vR7K8GvcfW6HZ/
rJ4dy/KnuQIgXZy5qBdZ3fxAk8j63XaD7OTZ8yL2mXg/JIkIQNYujhMzF2aM
HpsdI67d22BQpgX/vAq7FJD56k/cI7lNPVv3QrIY7h9lk4z7bOj0CNeDoZsl
qt3o4LhYtzTF6Dsxek4PV0DizlQAJP4nQFr7VJx+BrInq9pF+n9kh4WU/tZm
ais/XQureiQmiAdXRQAk7j1+TT2r2VOvreA6C8wlHpCcF6efAVLWsjxxpPi4
AYl7owGQePAESOueXCtGBscMSGn/nkXLX0hIz6p2HQ09YuNvMo2+w6dHReKS
BFNLzLsNgMTzzoC04pFo/QxkT7UPitTX08JCWv/rDFoY5SckytYuig7iwb3l
AEg8drpVPaO1dsO/bZKfPmd5Ic96QOLtAMmhJU619BuQON8ASDyBAUgZ72wR
TdXtBiTHtKVHEQrSM5YXh740NDa9uy1SLXHLB6TYpxP0M5B14JA9+SFJRACy
6d2tWghkdeKeWRdEmadfAi2I2bsNCMjy1/CMh254u89revFBPDzGGdfNLUy9
Wb/LYc1nOxNckvTeQkF6WrXjkyH6Oiu+1hwg8ZjXYzYCJK58kC3dfFgUrT8Q
FlLBuhJqa/RtOdopMt7aEjEklocBJP7iQNZZrbT0XpAcu9ErG3hgHeQ8LvHF
cXOcb4H5tAckzn6+hR548InZw7y/qp7RZLj+XzPkpxvUM2c464nPBukp1a6+
okUkL11n9N3g9O1p6TMgcYPxWEYAKW9NoagqOGaQrS9rJtfCD0kiApANv90s
wwfew6FAlCJ9XRwjgMQvWUfurPy0wPK6nvLQDR/mgDQ9ed4JAZMNSB6rPi/7
+aqFPSDFsFnGExKzoAUWmF9Rzy46gwSrxHwTUs2GIjE9MWk0d8eUG8/dqJ6t
+9dN4sTh1pCQFqt2TVVteiZD37glCQ7NiwYPcqGPZpTYIPGdWDQ/UlwvcqN3
G2QpBseM4gWJZjJn9jH65qzaKY7tbzR4nB0c1YFGAKQTuf6Nlq9osts02Zss
yl/sAYm/OECiCdKBavDguzgBkHjGCc3jlvht6ZIhsXboy2ejL6tnPFkUAKn9
QJ0Yau4xIHHzBtn032brQH6xHvpPqr8213RqV+MLoPJsQhCQgcYunfUIANJV
cULnStBcDtUXkgyyNbuPiey3MkPqBpAoBKovO2n0dRYdbdTgQZmi7sNNNkjy
T5WNRnN31d9ukL0wPSPino0PC4nWM0Sx6EtRsTP+DB5d5f7MWQAknm9D8x0x
hTqwvtliGU96QOLttIadmGb76gKDR0fpcTF4sscGiYyrpfiI0dwJ/rQfBEhJ
r27QAaUN0hOqHQWPiS+nGn25Ieg3wTIiAZCcxzqvg+Z8XIDsvqxyUZTqzh5u
MaxXIvZao2zW+bmUagVIV5iyX7tZX7RMAf9NPWvM8+e3A6TjRSlftpCAdOPD
ZyliN6QLnd/9dPUQEI8yBI5za4jHbQzi0XpxbmjMJt5E/4guw0XzodMjIvk1
N1j8AwvZH9FvmbFFItuWS460zgLCcJOBMI6XJvo6hwx0teklOsUTIAxfMtF8
b0YZpV8NYeAO08/9SgRb/jmy+o1Fiqoz12nK4LQ/s1xzByJKDV00HG0twCcX
L+qgEc1Tf50u+ruGDLIyelHzGASw5aQvtS7kcUXfWfgpNWfw7O8cIiwGNu7J
KVHg+HEv90uWVwyyzqqhvVyIYktOIwXF4dqKTSAC92n+0DJugYlnUAJFSLCI
wEhABEpOO36zIYItM81ECF/BAjm4I+QlB9d3gBw8u/dH2lhnNOY/srB63AvS
0xZI7NV6QFJ5X19W5jH9J+SCuboB6aTjLGd/kGs8o+XunJoAbDAfU+1Gh8Zp
Q8fom/YfjmN1oteAyQNpYHn/vZIAK9PQE+Irg6HHB0PfGb9HVOTXGs8KEvdS
KjssdNovwj4U+vLUgk3DwBIfVxEK+pqYsqDmPOICq6RX1ouRoQnj2an2AT38
JXSJHIATX0olfRs9BntHROobaQZgnokDgnUJlaEAp6fX+s6ePR9W13HPBlsf
t9LHPHTN29lGOXjw/CJ2RSYmpkVGei3Dp6HvLWn1NTcPhbVw21jm69OVgM4n
AEBvaRkSJXtabNCbmgZ8B/a3hTQTjHnaTwJUvlo5phISOhZLioIdb9zoGyn0
0gPtovHEgA2680J85gsxFylAb67uEJve2Wqwpz2mnXHFYaFv+XCHOFHZYvRN
f3uz6KjvMaBzvoCenXVMjI5McuhqF8kXPAzMDA2g74jeLYoT9xrsJ89O6y0g
L+g8z4C++7MrxZ6NBw3o3FCBheOLALrNYNY6M3dP+6D8BF+aLzqLvKHrZ4B+
qm1QbPy3zLAGk7jucCjo/E9objMYzp6FATrClDAl8kfVX7k7qNMPbJUEZf6O
I9C1DTB5lDPnZwyyWNw5YB6l23QN6LQtumV5ngnd4vicPztF6TFjtHnoesvm
474zZ84Z0Pm5BJsvAejOgNPzhRd08oyx8wjoXBWAzvfMgWXSiXs3bnBX56tN
6GWHOn3H6/qM5idyy3TQCLKnWvv1zpDOLV70G4IXdK5h9E10VuIxtRKDx9ip
M1QNYGBpaz0jiotbbNDb24d9RYXNRvPmwmodzetQJbtCFKt5QKde2eB81AO6
LaWaH7tHVO06ZvCQ2Ys9NQaWgwc7RH19nw361NQF34b1R4zmVCbT39BpkKXt
5vb6bgN6wgtJuobCBn0hDMGJGRG3o+/xsmax9cMdBo++4+06FwQsW7ccF2eG
znHoysc3pkQV+1KJlOipPmmQ5Us92DuLkC6K8IJelnOEPEqj7/TUBZHwfJKf
xyxiaxucEQAeONFFuSgDMLdSMO1p6aNNkLCAuXNwi0UBCPvrtx0M0rUHdP4n
QB/p7NdpGw2deYm3WMSRMCXyhZa/6h4s0wrALcU1uuopAsBc18gHVVRUiNde
elU8cv8vZKiel5enc0uTE1Ni3Yvu8v6Hqr3twDnyR3w43uFysRdKzjYKJf/c
8urujLz77RbuczzQQjracsLGo6vQuZTSFyX5heLNN9+UIbTSyOzwunU8LN/o
6CTjfpUz2Y+J0hVbRF9fn7jZ+Z+icmzfCSooNNRqO3QPrsm/2kD1GfLTf1fP
uK7+0qK/uy3tULA40H1GF2XM9eAPvJnO2tZypMNQFNUHnxseB22IiIJGZwYV
mEGvYYoyqkMr4vNEVlaWuPXWWzWv3KjdujTmhqAe/PYAPOOJtj/WPeZcAT0V
pZbqLO48CwKMwoPbq8XupL2GflzXSO5nyrSekhP6cRZHgcWR68dB13xy0Ldv
b5sxpr/9jTvFNddcI8rKyrSmkmmJPuMu0QjC+JUIsB5KRyS9uuGKWU/iy6m6
lvFqC1/goypNhOHQCvM5xQ9+8APIBK2Ul3eJurrTNq2Mj0/7MjcdNbRSkZAv
EhMTyW411wQ2rcNd5/c32KaqP78CWuH0rrHwZZOObnez0gqLeqStKJmglW3b
6sXAwATXiiokMyZ01JjTjEnFtw5VukJCXH/99WzDyL+GYOaxXTVxlUWqb8jf
QYW9f2VR1J32pndYqM71QGHbOYHOHEuCpLKPkhQ6cyZqfXQiQGd8DofO2tvb
xcsvvyz+5UcPSCQZGRnWNwad2e7IgM7IKexs7DV0FlBGLHUmVXanvcE3FC2q
wsLO8zwP3l+0YGXWpeV75ZVXIB/TVIDhWq0L8ymPGrGV6MxCFDDIT6gdpJKQ
HTFu0u0Ri4k8rNptX11AJQRG35TX08SZU8PGuOF854SHbnPNeL4V0Kt31Ym8
tcUGe6qqRumIF3R3n3nG6Lsrca84lFP1aaCnp9X6JicvhIXuBApUqiM/odSW
j6yHPaDzEQXoTUc6xeb3c0zojC/s+/z5GbE+tVp+utaEvjO/0dfTPWpA52lT
QF+3NJkCBgM6TxHZoD+k2tEGAuCj78yMfyPEC3pX14jYteukDfrR2lO+ysqu
sND5DAr2W5bn6fSGF3Ta3cpZ5RoDitPjWWwAHtxg9GmBii5BGC3Qh4bOyhRH
uGHKXzqgu0VB28NCp5Ka5ppOAzqnBx48gQfo23MaRH//BId+nWWYonl18m69
TYm6FDrhFqdWdrCnKRMZG/fMzBxZcdnb2icl6G3tp4oCLQIfG34R/NoHr/Pn
pvSJNjZcKevMRZBeAN3x5fuM+8C2maaCLENO2djn02d/6IDFaM8g52fQcH2s
ucYz54dyp2J/VkXoLuazeSHbXYVnqqBjOnTT/6pn8zREMliaeOlEDRWzsmNI
Rj9Xu/PE2PAE7V6JlT//SPbDjEn/u/b3SE4dMrK00CVAtL0yuLqFThhzcOth
ppbw9JAdGO0epDtQDMO1BcO2VzD7040LOtE10NR9yeMi7d8zRVfT6Ss5Ligx
Vp5X8/s3LiREseKfPxQb38ygmiobRJgWTY50RCTm8bW/r9Z/cFuV2K0yi1fI
+msONovENzZdlvUPNffo84+B1h+cS7Navzox6EtOqvJhBQm09J7qk3SIVH7S
BZ5LAiM1kzyOEp1q6dcnXG63tLtdaXbo9LB0seigjTPFX2NpOk81Jf+XCkFj
n4mnIqg/szTFeUVZI6TqpK6ztEMGVDpoav2+SSlX3jRU0WjVCLVPSa5idLUi
c3MbfH1949Zu/P4jXWX7bNDWlwERJ5W4wr/uITJVzNNhPCoPs4mM4J8OVNG5
2C0f78RRWys9ztdGD5tTsc/4292oVNhxqF701XdYdXHq1JjI23EiWIWzfVVV
Pb6aml5uuvICq+bCakN1PJrUSVa2M/OP6hllmGg9ppH7OQ8Vp7+/Xax5eBXN
U6peyfTKbrfwRQ021YGOdPUbmB0ZBMliEbGnZ1RGI7y5PEGbW26QpZLTdSrW
w4Ho5NfSdLr1f6tntDMZ5UCnt/55i4goOqRqlahHVssiOaiHp1vBI/6xKHF+
6ryBhV/4A8wFO5sEIqoAES84wVJKcrXRnK5SOJa1zyDbQMc5Pswz2FN54J4N
7i7kT9Wz3LVFItoRkYIweTpCSojzYDQpUGWz01MrhapcnRnboJy9fIdoVEUK
QMAPxwJpako1RZJcMKVDS1LLLVDEDjvIFiTsERUFRw32ZIqJL7llxT9hIzb1
DbeCCElA/u5wYImKPlF8iL5U6YpkJ3iU59USbwNLVfIuOuhriMidGw8RdYTH
QiccGZGZ/wG3gBaZRj5h/Eg9y/zPbVQeIj/dYBERdZ5bPsrTZ0B+bKEHEYcH
Rh2T3WiIaItKuRwBItpCO05igWbvH+xaRLYR/0P1jDwX1AYssIiIokNKKCFl
BvXwSUbzYIniBR4ierzFpET/mu4lIp+6wZ5XGN+rnuWsKtC1BjdaRFyg2+3U
qkBffkYF2UM+j16miLTanj49Hv4tPhssYnmuf5v4H9Qz8qQdY5WfbrKICGNz
jFTXRKEvvVkcd4eI4d4i5o8zQ+do11x++qwpom015CRgWHRiIenVjQZ7qn9C
qvB/qWdUL4np5gsWEbG6kgU4KjL6ukmwGYMHlWJMjJwNK2J9fR/VNNhEtK2G
NhGPFB4XeWvdmc2WrP+f6hmlpdc86d6qIPNtUkKWZ9JF4j+wUIFguc68XFt0
PKxgJXtaRGvLkE0w2xrI51EIlrMiTxwrbTIE48eE/l49o8MUqx9aKQs4vmh5
dxCRkpArHlwmBrvPaKXwyB08avc1iu0q46dFZIlJiJi2sUacO3eeiwhHyrYa
ytVGmQlETHwxRdedgD3dcoGzdN9XzyhtFr0wWtZD/IFFRORPu5t6RMxja2Sh
GdTDwzPwmBibEkkvphpYKF0HMW1LRQQi1m0+IKbGzxlk+VkzsOfzHkSkHUpM
FDYRsVtSkV+jYyf0dRw1ctjkp2/CoBlfrKSTIxNUQ2aIyOfRCERsyDmk67gg
Ip+ywZ6Pnf+hnm1+P8dZ8N3CYFtUg8CL8rbkstGnv/OPzyAenC9EHO3x534i
EJEi3BnlAkFEqk9xIouAt+gt4j0wwJOnxaqH5DcIoMjSGhhR5IFT0FAPj1K8
3qK8bLSk1sBMxgsxP2eKmJ/X6HPiKqN59+EmJ5RtMci6Qblbl4TNZZruUYP0
t+oZlWpStEAe5pc8RKQkJo1ZGotQDzd88Eh5I10M9gwZWOh2qp6qJgPzQP8E
7SoHiTjLd6S6B6+a7n5F8gPEDm6pFEXrSw2mdEMPdvogGOUFava4DGyC6VJl
ZwSmv7XZ6OvupjQbPCiFWZpdYWBp3Vurz7RCsKO1p2inxPbu6L3R++PNeUQI
slnvbhWt6i4OsOdXGXxPPasqrNO1Z7LQQEqIQgyKIZ2Y0ejBD4aCcmfTaX2x
DRA0bD+krzcC0l0FTaJbxYEBgtGYg72i+fnJaX0NEsiSAPBWUQfCx9131bPJ
s1MiamGUhPply7v7ElMKGS+dAP2ehR5ElNX6anrxX4xSJGamzxuYeURoXmVu
2bK3XXRgbqZBxHUvpegIDiJS5RfqNm0ionCEzrHjQCr6ynIatdn9F356QVi4
G2LLmEcgYvAlHObkDRGdSJ4OucpPf62eHdpepSO9r1hERH0zXUeDCyBk31lU
TPWXFm626zUjEMy28gVfIeqabLxypaFXyqFB199h5om58KsegpGfQ2ZMl0pA
Kfy0EHgkvJAipiYmTREtLhqXI0BE8kAvXDBXvuDrVZ2BfbBJpgPpEzTMV6pv
q2d0DAqbrTYRUel8/OBJfZ8I1MNDZ4i4ddUuUbevwRSR4UPKkHb24U2bVza7
O/s9o2FFzF+zWxwuPG6IyIOab6lnjnumZ89bLCJ+Fap4dYO+6wZ9ZQWAEhM8
avc3ilzlaNtGIESsru4VmzYds4lIMSCyiV6GmkxGNHzOYC8P56tRdDeDSQZI
ostrdaSEEEya8aNRhmC8ZgaUz1IJrooqvAQ7wM4mBQhG2fIctdp7CcZnMbAf
7D2jj2RDMNobgHt9q+XdoWC5dMthfcIWfWldxIbBnbAP5pjZvgEEImak14qJ
cduN4j7HZQtaA49mlOj7U/QdVWyBAHu+ZqliNqrf0ueavmYR0X9hVbzO4txl
oQceXLXIqDrRjY4gbPOoeRmwMY9CIzIp3tlvkKXL1ZFT+ys/e1kKwZ/FPL5W
z4VeItIc7LjYRl8+AvEs7vlEHZMCC50YgX91mSJy9xpke5t6xUblNYK9E5aS
wRlap2dIIt1mERHXpeXG7NYXRKAvHcrLiy0yeGQuyxUnK5sNLHRUof1AnSEi
P6kbICKXHiLywykguy+tVJRkVhjsKQrAlRkYn7R/EaPuo3RZXZG7LWz3JaBO
jO6uhUMFGHR/rTNVGHDLdx4VBbGFhlh8wwriOyunXnXMqzN9FKMMqMohNJcH
qDYfMMimvZkuutsChiFbWLEQUjodJyihrStxV4ZtXxnqogtsHR/UUJdtyhkd
PitSXkk15KJvkcAXV0D+zk5/DVuAungmE81pOoA7A7JxLB8NdXE3GX4l3feD
yvHrlUoivXHDphIUndEiAP8GvCh7lvCYux5iseDeJ3jwyAEyHjrUIXBILkAl
5LPg9Llt7fushRVUcmBzpdidvM+ASTfknjPueb30GzwkDnmDx9eY8FSVwTmR
U4/MjZdCbCulPO07OsUVgo0v2wTESWCvljbcYpckGuxpskEYjOiuJL1M+yzz
Q9hIuBtBbLMNKvRyo3frGwnAc8VjsfreIa2a5/zLj5dq+C0FEaiG2wpU03W8
S2x4293DgOv28UL/JbNITdKWqeMAyk83hJhtQt0wYqteQsVAzKPR2p+2JdCg
koz3t4uWqlZDJbyk1VYBHqASvpJpa2HBEVRSnFQi9ufUGCpJWprkrNSnDJXQ
Jt5R5TpCJZd0Y4nNVKAXuokOuRQwpLIX+K8AdnBHrShMKA5rKh56oZ0/5Dq1
qcQHm8qG1zaIflVK4Pfya8W2FW5bbIXQHTcYWbZiEVRGUCjliGT0pd1AuOPg
Mdg/LlJ/tZ6JOFfsfS9N0yPzoxqb5KSqG0zJaGlxlhhDMvoOoPNqvNnKZcCV
Qm4su0BHHjIQe0lGhRPQgO5riY25B48aKMfL118/p/3G7lG9TJqXHfkoTCo9
0G40byk+ohPV11lYgT2v+cdmOe2awe5sxVJoR1d9IrGJZ5QBxtj9jhY7IUhE
usMe5TnAfLDUf4A5QES6uyRtY43RvK+uXX+PAtdcvDrgCfbyiljlSQMmJVwg
thRRSoi/Sif00WijB2WFcSUoKMc7kTPqQICA+/c80Bsfn+KCuVY6N7BgVF4j
1pBzCK/sRGmDyPpop8F1uH9Ul4TA2mgr2VneubUZrwxb2M7yT/ow+tLuElUw
cR5ZKwpE/b56QzJZ1909GHJKCZCMBz8kmap4gWQFq/NF+R43fY10Fr/yGOsl
7WDigvo7LJJhbNHWHkLCr1voQbLDe5tE3so8Q7LqVH22UUvG4ZvXQFnDuv0f
ZulnmOyTXkiS96hwEWnBwIWUEJFeAG7L9hKRbvjCzUHoS5tK63+dYfCYGJ8W
ySrLCxFt6wFfDANEzMykw79T5vBcvS1IRJ6dA3sKELALCQ+ZNnfgeX/TIiKW
N/LaoR70pWmmo8HNY33XwtfFYpw6lAY3PHxObM6uW2BKJmOKI2ZMwZWDE6CO
PTg+mKvEv1HPuFOCcIg70F6SSTtWJQaQjNsnJIulCVnFA6Ekc/BTnWCAZHRY
O1NdB+YlWW9dh0h5a5shmdzMC7gHnjxhzHi2E+1w1SjbgNo79O1tHdA1I5rH
f+aKjuoWAwtNCvC/9PHQrf7joWoxdyWda7hvpAh1aBvWWBxXKPbn1Rlc6XxF
4GXg5MgiySDDEykYvPHoR6P0TIIetO2MQBuU9+88LgrX7DLkmegf1t/bZPPQ
A+QJnCPlFapHWyFP8hMxgg5D0SfsSPGvaUBikkbI8YMn/fIEvClIRhdhI78O
ybgNQjJH+2L9Kyl+yWZRSbctGxQgDy0HrChcjPUO0ZWgkCeWjVrIQ5aH+8KR
SybfCf7YX1jkQUiZsDRZWy36ttd364tjsAPLx+08Naboagx8mRdBpV09B/6N
pkC7d5/0dXQM61Yy+7Bupz4m7sS5capWBMzI9OGhA5Tz0vQlsl4C0dKOF4K+
VMDh0DR4xL+Qoh1YCEQHiHFCmKCSw1iws8kQaLavtXXIt6fYdE9s92ud3HtM
JC9zByZ26DF90Q92paiCBqV7tiPmyFRR5Q629LDdgywslyzlg52i5UC9IVng
9Ldvb5s42TQYINn58xd961OPGJLxEAaS7XgvW1SWdRqS5ccVaxcRe6U0SWBf
7k6LZMh98elCX626t0GXr4JHxcE2kff+Zk/JUpLllrGS7MYQs0Rt+h5ydPW1
f88n+lBrdQ8DD6sHqKQl8eKY2jXzEojPEuhLYQKyaeAxNjolop6INZRLm564
yMrmZiwIlozPF+o2bVBz1kFnHnDX4L+DtPLLfNwRiaqL+oo2Ef2MG2uFPr7v
ehfwJNCX1mXEaeAR++hqcUEVs89Rr6qvvkMfxcB84Uh2kylQPjswTK3ODY1R
5RcEovk9/u0dBjNyjfDFJP4LAS9KuyLHQmbv2Nl6FzL9lSwTYsjv0FA1iqAc
/84OHSBBDFoxz6objAmgzL4WNBliuFdd0dQXapZASc3u5VtEZoZbboSCMz6q
edUWSkPvsrwgnWLPPSLW/ybb0AVfoCDZzh0nRNHyLYZkHB9JRhUmnR3DAZLR
xhoM0kuylBeT9a2TkCwvtkgHWSi5a6pu19nwuy2SIfcatTheV2igL+Vj4WCB
R2/vmNj4q1Qm2RxjFiPJyKFwCzdV7e1cH/cxqIksxesbhjS0IxP7uuuSo/ZR
1mqpLzG7mT+TJTDTSIJYpZFfu/fLj+StRZBmjaqt5DziXsvQh1zgPtD3UuLC
OFsYeaMpGWWmUKJGklHiwIlEIRmlz+Oi3N0TFK4m/WazOLDJvUAHBa50TCwg
qWRIhhxjec5hPRrRtzS7XGT+ZpPBIy6qVN94PFtZ4NFNJY6f1KyhOiG/SE+r
MV7VbF9t7SlfQUETk3+eKH57g/H6yM3Y9X62r9AZg6g4puv61z7sfpsfSq4p
Q4iI8NsWqZDIon0iOIjo+9EvV4optW5BKjqds+v9LOKvpSqL2W5go0tD64/3
BUhF4yo+rtKQqiat2Jhr6rL2ibRVRfLqQhSIU+IC6XAUFNP5ItqUI2v6jodU
KNiis02os6cjPKjRh+YcfmLjikIq3tQWR9/AgRvO2UKlD8WracOV8tqg8UXV
siq2kpc37vtgky8utgKHF8hvgE8wn6GlWZvQylBZCoU8HO1Ko7gChaVUjO9Q
kp/+Qb2NtWvKRdFv16MQgL7SjDbeMbjefXuPxmmIMNtHd9Q2Ng4wiefIksM9
724k+HTjoryQCDLQ5Q4I4yEDLb6ov/5ry5tBkoVOl6HcAH2dcFA0lLcwaebI
fR3yl4n/nnc2EB49Tzizr76J8QumKJRUgavnNr9KTI2dk2ZLF0cM9E/8kHFF
gh5FE7RWour7uxYpkMgoiC/RZzvQlzw7BLb3KtZ0MpHuNKJR67gNmJrWp1br
8g4lgJpnfbFry+WIkf3Vs+jVhzQCvAOymdUPr5I2g81OunsUp7r+xoJeSjSL
nHL08NvWRX2CKCbaf4M1NE4uzdo17vObGeBZvoryLsCk3MkBlWwGMdqU+Pj/
rBDjo5M62UxK3vKRu7B+zwITsSZVx2a8s0WNM/cZ5V/pcCL5eTjVVVLSKoqL
mg3AFRVd4nBldxBgNR+tWnmQN/ct+2Cf9jZB9lh5i4j+xXJZOXI1Y7/qFx87
NlKiUolX8uuRbTs+CIbp6rdVjiLJ7wOa4f4x8fEDH8gNZpzioxKD5cvMUhtH
Wh3/KWWoW8p8ZWUdvlQ1XuiH9hFycxtw7BFnPKngC54qXZxONtNc26Hzjxzx
pX4bs01qxHyN5c1yxqRL78CfruQk/h1Nvep45lx5mxpu2ibau3Y1icOHu10n
U/maV8lbq9PSan0bNhzxbc6uu08+vka61HSn7cp/Xi6dgcz3tkmHLspxW6If
WiX3fL9pEdTrW579G99/q7gQxRW/XCFin1jjWP8OkbMiX8Q8HSfPoZKl05J2
nzIpB5xYG1MunBlLOIPf9Xd9iR4YbBvzO8N3s21fq27xCsslfLlxQM9L+EJh
1VOCeyryf/s+8/8AO/fPww==\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{620, 571},
WindowMargins->{{Automatic, 208}, {Automatic, 108}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3392922012-7672565"->{
  Cell[144113, 3337, 77, 1, 43, "Print",
   CellTags->"Info3392922012-7672565"],
  Cell[144193, 3340, 830, 24, 24, "Print",
   CellTags->"Info3392922012-7672565"]},
 "Info3392922034-8418612"->{
  Cell[145858, 3403, 77, 1, 43, "Print",
   CellTags->"Info3392922034-8418612"],
  Cell[145938, 3406, 792, 23, 29, "Print",
   CellTags->"Info3392922034-8418612"]},
 "Info3392922312-7412908"->{
  Cell[156711, 3840, 76, 1, 43, "Print",
   CellTags->"Info3392922312-7412908"],
  Cell[156790, 3843, 831, 25, 51, "Print",
   CellTags->"Info3392922312-7412908"]},
 "Info3392922589-4789835"->{
  Cell[161990, 4067, 76, 1, 43, "Print",
   CellTags->"Info3392922589-4789835"],
  Cell[162069, 4070, 1288, 40, 109, "Print",
   CellTags->"Info3392922589-4789835"]},
 "Info3392922924-7502732"->{
  Cell[215198, 5169, 76, 1, 43, "Print",
   CellTags->"Info3392922924-7502732"],
  Cell[215277, 5172, 1705, 46, 47, "Print",
   CellTags->"Info3392922924-7502732"]},
 "Info3392923219-2819462"->{
  Cell[304708, 7163, 78, 1, 43, "Print",
   CellTags->"Info3392923219-2819462"],
  Cell[304789, 7166, 1213, 33, 85, "Print",
   CellTags->"Info3392923219-2819462"]},
 "Info3392923231-8882356"->{
  Cell[306212, 7215, 78, 1, 43, "Print",
   CellTags->"Info3392923231-8882356"],
  Cell[306293, 7218, 1871, 61, 291, "Print",
   CellTags->"Info3392923231-8882356"]},
 "Info3392923246-8288062"->{
  Cell[308807, 7306, 78, 1, 43, "Print",
   CellTags->"Info3392923246-8288062"],
  Cell[308888, 7309, 1161, 36, 80, "Print",
   CellTags->"Info3392923246-8288062"]},
 "Info3392923255-3975449"->{
  Cell[310259, 7361, 78, 1, 43, "Print",
   CellTags->"Info3392923255-3975449"],
  Cell[310340, 7364, 1631, 56, 225, "Print",
   CellTags->"Info3392923255-3975449"]},
 "Info3392923295-1995550"->{
  Cell[314672, 7538, 76, 1, 43, "Print",
   CellTags->"Info3392923295-1995550"],
  Cell[314751, 7541, 992, 28, 24, "Print",
   CellTags->"Info3392923295-1995550"]},
 "Info3392923315-8046651"->{
  Cell[316335, 7600, 76, 1, 43, "Print",
   CellTags->"Info3392923315-8046651"],
  Cell[316414, 7603, 1078, 31, 36, "Print",
   CellTags->"Info3392923315-8046651"]},
 "Info3392923347-4532818"->{
  Cell[367473, 8509, 76, 1, 43, "Print",
   CellTags->"Info3392923347-4532818"],
  Cell[367552, 8512, 1687, 46, 87, "Print",
   CellTags->"Info3392923347-4532818"]},
 "Info3392923409-8527092"->{
  Cell[371401, 8653, 76, 1, 43, "Print",
   CellTags->"Info3392923409-8527092"],
  Cell[371480, 8656, 2625, 72, 163, "Print",
   CellTags->"Info3392923409-8527092"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3392922012-7672565", 429132, 9672},
 {"Info3392922034-8418612", 429326, 9677},
 {"Info3392922312-7412908", 429520, 9682},
 {"Info3392922589-4789835", 429714, 9687},
 {"Info3392922924-7502732", 429910, 9692},
 {"Info3392923219-2819462", 430105, 9697},
 {"Info3392923231-8882356", 430300, 9702},
 {"Info3392923246-8288062", 430496, 9707},
 {"Info3392923255-3975449", 430691, 9712},
 {"Info3392923295-1995550", 430887, 9717},
 {"Info3392923315-8046651", 431081, 9722},
 {"Info3392923347-4532818", 431276, 9727},
 {"Info3392923409-8527092", 431471, 9732}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 42, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[657, 27, 41, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[723, 31, 61, 1, 28, "Input"],
Cell[787, 34, 113, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[937, 42, 68, 1, 28, "Input"],
Cell[1008, 45, 108, 2, 28, "Output"]
}, Open  ]],
Cell[1131, 50, 399, 10, 127, "SmallText"],
Cell[1533, 62, 679, 21, 94, "Input"],
Cell[2215, 85, 582, 10, 144, "SmallText"],
Cell[CellGroupData[{
Cell[2822, 99, 295, 9, 28, "Input"],
Cell[3120, 110, 362, 12, 30, "Output"]
}, Open  ]],
Cell[3497, 125, 238, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[3760, 133, 947, 30, 69, "Input"],
Cell[4710, 165, 16025, 277, 233, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20784, 448, 56, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[20865, 452, 58, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[20948, 456, 136, 2, 28, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],
Cell[21087, 460, 237, 7, 28, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}]
}, Open  ]],
Cell[21339, 470, 219, 8, 44, "Output"],
Cell[21561, 480, 212, 5, 41, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],
Cell[21776, 487, 229, 7, 46, "Output"],
Cell[22008, 496, 117, 2, 28, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],
Cell[22128, 500, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22193, 505, 64, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[22282, 509, 66, 1, 28, "Input"],
Cell[22351, 512, 87, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22475, 519, 272, 9, 30, "Input"],
Cell[22750, 530, 183, 5, 24, "Message"],
Cell[22936, 537, 182, 5, 24, "Message"],
Cell[23121, 544, 182, 5, 24, "Message"],
Cell[23306, 551, 223, 5, 45, "Message"],
Cell[23532, 558, 1749, 32, 242, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25318, 595, 312, 10, 30, "Input"],
Cell[25633, 607, 29273, 487, 235, 19434, 324, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[54921, 1097, 120, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[55066, 1104, 322, 11, 30, "Input"],
Cell[55391, 1117, 29273, 487, 235, 19434, 324, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84701, 1609, 337, 11, 52, "Input"],
Cell[85041, 1622, 29273, 487, 235, 19434, 324, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[114363, 2115, 73, 2, 45, "Subsection"],
Cell[114439, 2119, 949, 23, 195, "SmallText"],
Cell[CellGroupData[{
Cell[115413, 2146, 410, 14, 52, "Input"],
Cell[115826, 2162, 855, 29, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116718, 2196, 160, 5, 28, "Input"],
Cell[116881, 2203, 1325, 45, 77, "Output"]
}, Open  ]],
Cell[118221, 2251, 495, 13, 93, "SmallText"],
Cell[CellGroupData[{
Cell[118741, 2268, 54, 1, 28, "Input"],
Cell[118798, 2271, 1357, 46, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120192, 2322, 55, 1, 28, "Input"],
Cell[120250, 2325, 313, 10, 28, "Output"]
}, Open  ]],
Cell[120578, 2338, 167, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[120770, 2347, 563, 19, 72, "Input"],
Cell[121336, 2368, 1321, 50, 54, "Output"],
Cell[122660, 2420, 3480, 130, 225, "Output"]
}, Open  ]],
Cell[126155, 2553, 163, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[126343, 2562, 368, 15, 38, "Input"],
Cell[126714, 2579, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126779, 2584, 83, 2, 28, "Input"],
Cell[126865, 2588, 313, 10, 28, "Output"]
}, Open  ]],
Cell[127193, 2601, 364, 10, 93, "SmallText"],
Cell[CellGroupData[{
Cell[127582, 2615, 231, 10, 36, "Input"],
Cell[127816, 2627, 31, 0, 28, "Output"]
}, Open  ]],
Cell[127862, 2630, 264, 9, 59, "SmallText"],
Cell[CellGroupData[{
Cell[128151, 2643, 233, 10, 36, "Input"],
Cell[128387, 2655, 199, 9, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128623, 2669, 65, 1, 28, "Input"],
Cell[128691, 2672, 31, 0, 28, "Output"]
}, Open  ]],
Cell[128737, 2675, 295, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[129057, 2686, 522, 20, 63, "Input"],
Cell[129582, 2708, 430, 18, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130049, 2731, 126, 3, 28, "Input"],
Cell[130178, 2736, 430, 18, 51, "Output"]
}, Open  ]],
Cell[130623, 2757, 104, 2, 42, "SmallText"],
Cell[CellGroupData[{
Cell[130752, 2763, 364, 11, 30, "Input"],
Cell[131119, 2776, 223, 8, 28, "Output"]
}, Open  ]],
Cell[131357, 2787, 508, 9, 127, "SmallText"],
Cell[CellGroupData[{
Cell[131890, 2800, 302, 10, 42, "Input"],
Cell[132195, 2812, 255, 8, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132487, 2825, 65, 1, 28, "Input"],
Cell[132555, 2828, 48, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132640, 2834, 89, 2, 28, "Input"],
Cell[132732, 2838, 1162, 34, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133931, 2877, 54, 1, 28, "Input"],
Cell[133988, 2880, 111, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134136, 2887, 65, 1, 28, "Input"],
Cell[134204, 2890, 48, 1, 42, "Output"]
}, Open  ]],
Cell[134267, 2894, 410, 11, 76, "SmallText"],
Cell[CellGroupData[{
Cell[134702, 2909, 97, 3, 28, "Input"],
Cell[134802, 2914, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134870, 2919, 92, 3, 28, "Input"],
Cell[134965, 2924, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135033, 2929, 166, 6, 30, "Input"],
Cell[135202, 2937, 32, 0, 28, "Output"]
}, Open  ]],
Cell[135249, 2940, 199, 8, 42, "SmallText"],
Cell[CellGroupData[{
Cell[135473, 2952, 200, 7, 30, "Input"],
Cell[135676, 2961, 32, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135745, 2966, 199, 7, 30, "Input"],
Cell[135947, 2975, 31, 0, 28, "Output"]
}, Open  ]],
Cell[135993, 2978, 282, 7, 93, "SmallText"],
Cell[CellGroupData[{
Cell[136300, 2989, 144, 4, 28, "Input"],
Cell[136447, 2995, 120, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136604, 3003, 79, 2, 28, "Input"],
Cell[136686, 3007, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136751, 3012, 103, 3, 28, "Input"],
Cell[136857, 3017, 148, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137042, 3027, 57, 1, 28, "Input"],
Cell[137102, 3030, 28, 0, 28, "Output"]
}, Open  ]],
Cell[137145, 3033, 192, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[137362, 3043, 340, 10, 49, "Input"],
Cell[137705, 3055, 28, 0, 28, "Output"]
}, Open  ]],
Cell[137748, 3058, 291, 9, 59, "SmallText"],
Cell[CellGroupData[{
Cell[138064, 3071, 197, 9, 36, "Input"],
Cell[138264, 3082, 198, 9, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138499, 3096, 365, 14, 40, "Input"],
Cell[138867, 3112, 266, 6, 68, "Message"],
Cell[139136, 3120, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139201, 3125, 232, 10, 36, "Input"],
Cell[139436, 3137, 279, 6, 68, "Message"],
Cell[139718, 3145, 202, 9, 37, "Output"]
}, Open  ]],
Cell[139935, 3157, 288, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[140248, 3168, 50, 1, 28, "Input"],
Cell[140301, 3171, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140369, 3176, 212, 5, 28, "Input"],
Cell[140584, 3183, 50, 0, 30, "Output"]
}, Open  ]],
Cell[140649, 3186, 254, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[140928, 3196, 223, 6, 28, "Input"],
Cell[141154, 3204, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141222, 3209, 251, 7, 28, "Input"],
Cell[141476, 3218, 32, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141545, 3223, 314, 9, 28, "Input"],
Cell[141862, 3234, 31, 0, 28, "Output"]
}, Open  ]],
Cell[141908, 3237, 253, 8, 59, "SmallText"],
Cell[CellGroupData[{
Cell[142186, 3249, 59, 1, 28, "Input"],
Cell[142248, 3252, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142316, 3257, 473, 17, 40, "Input"],
Cell[142792, 3276, 27, 0, 24, "Print"],
Cell[142822, 3278, 27, 0, 24, "Print"],
Cell[142852, 3280, 28, 0, 28, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[142941, 3287, 40, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[143006, 3291, 54, 0, 45, "Subsection"],
Cell[143063, 3293, 76, 1, 28, "Input"],
Cell[143142, 3296, 161, 5, 28, "Input"],
Cell[CellGroupData[{
Cell[143328, 3305, 325, 10, 42, "Input"],
Cell[143656, 3317, 371, 12, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144064, 3334, 46, 1, 28, "Input"],
Cell[144113, 3337, 77, 1, 43, "Print",
 CellTags->"Info3392922012-7672565"],
Cell[144193, 3340, 830, 24, 24, "Print",
 CellTags->"Info3392922012-7672565"]
}, Open  ]],
Cell[145038, 3367, 132, 4, 28, "Input"],
Cell[CellGroupData[{
Cell[145195, 3375, 325, 10, 42, "Input"],
Cell[145523, 3387, 249, 8, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145809, 3400, 46, 1, 28, "Input"],
Cell[145858, 3403, 77, 1, 43, "Print",
 CellTags->"Info3392922034-8418612"],
Cell[145938, 3406, 792, 23, 29, "Print",
 CellTags->"Info3392922034-8418612"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146779, 3435, 52, 0, 45, "Subsection"],
Cell[146834, 3437, 190, 6, 36, "Input"],
Cell[147027, 3445, 355, 12, 66, "Input"],
Cell[CellGroupData[{
Cell[147407, 3461, 164, 5, 28, "Input"],
Cell[147574, 3468, 202, 5, 24, "Message"],
Cell[147779, 3475, 573, 21, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148389, 3501, 161, 5, 28, "Input"],
Cell[148553, 3508, 407, 14, 42, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[149009, 3528, 52, 0, 45, "Subsection"],
Cell[149064, 3530, 602, 18, 86, "Input"],
Cell[CellGroupData[{
Cell[149691, 3552, 164, 5, 28, "Input"],
Cell[149858, 3559, 426, 13, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150333, 3578, 37, 0, 45, "Subsection"],
Cell[150373, 3580, 451, 13, 82, "Input"],
Cell[CellGroupData[{
Cell[150849, 3597, 89, 2, 28, "Input"],
Cell[150941, 3601, 155, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151133, 3609, 164, 5, 28, "Input"],
Cell[151300, 3616, 413, 14, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151750, 3635, 336, 8, 97, "Input"],
Cell[152089, 3645, 92, 2, 28, "Output"],
Cell[152184, 3649, 94, 2, 28, "Output"],
Cell[152281, 3653, 93, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152411, 3660, 182, 6, 28, "Input"],
Cell[152596, 3668, 77, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152710, 3675, 179, 6, 28, "Input"],
Cell[152892, 3683, 92, 2, 28, "Output"]
}, Open  ]],
Cell[152999, 3688, 575, 18, 82, "Input"],
Cell[CellGroupData[{
Cell[153599, 3710, 164, 5, 28, "Input"],
Cell[153766, 3717, 394, 14, 42, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154209, 3737, 31, 0, 45, "Subsection"],
Cell[154243, 3739, 423, 12, 62, "Input"],
Cell[CellGroupData[{
Cell[154691, 3755, 164, 5, 44, "Input"],
Cell[154858, 3762, 394, 14, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155289, 3781, 181, 4, 85, "Input"],
Cell[155473, 3787, 252, 8, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155762, 3800, 195, 4, 85, "Input"],
Cell[155960, 3806, 282, 9, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156279, 3820, 122, 3, 65, "Input"],
Cell[156404, 3825, 223, 7, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156664, 3837, 44, 1, 44, "Input"],
Cell[156711, 3840, 76, 1, 43, "Print",
 CellTags->"Info3392922312-7412908"],
Cell[156790, 3843, 831, 25, 51, "Print",
 CellTags->"Info3392922312-7412908"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157658, 3873, 70, 2, 48, "Input"],
Cell[157731, 3877, 25, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157793, 3882, 53, 1, 44, "Input"],
Cell[157849, 3885, 32, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157918, 3890, 69, 2, 48, "Input"],
Cell[157990, 3894, 272, 10, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158299, 3909, 203, 6, 65, "Input"],
Cell[158505, 3917, 172, 4, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158726, 3927, 60, 0, 45, "Subsection"],
Cell[158789, 3929, 203, 7, 58, "Input"],
Cell[158995, 3938, 274, 8, 44, "Input"],
Cell[CellGroupData[{
Cell[159294, 3950, 92, 2, 44, "Input"],
Cell[159389, 3954, 240, 7, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159666, 3966, 110, 2, 44, "Input"],
Cell[159779, 3970, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159862, 3975, 92, 2, 44, "Input"],
Cell[159957, 3979, 28, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[160034, 3985, 75, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[160134, 3989, 316, 11, 46, "Input"],
Cell[160453, 4002, 249, 9, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160739, 4016, 317, 11, 46, "Input"],
Cell[161059, 4029, 29, 0, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[161149, 4036, 77, 2, 55, "Section"],
Cell[CellGroupData[{
Cell[161251, 4042, 68, 0, 45, "Subsection"],
Cell[161322, 4044, 596, 16, 125, "Input"],
Cell[CellGroupData[{
Cell[161943, 4064, 44, 1, 44, "Input"],
Cell[161990, 4067, 76, 1, 43, "Print",
 CellTags->"Info3392922589-4789835"],
Cell[162069, 4070, 1288, 40, 109, "Print",
 CellTags->"Info3392922589-4789835"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163394, 4115, 340, 11, 44, "Input"],
Cell[163737, 4128, 2943, 54, 254, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166717, 4187, 187, 6, 44, "Input"],
Cell[166907, 4195, 73, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167017, 4202, 173, 6, 44, "Input"],
Cell[167193, 4210, 341, 12, 44, "Output"]
}, Open  ]],
Cell[167549, 4225, 582, 16, 125, "Input"],
Cell[CellGroupData[{
Cell[168156, 4245, 187, 6, 44, "Input"],
Cell[168346, 4253, 73, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168456, 4260, 340, 11, 44, "Input"],
Cell[168799, 4273, 2943, 54, 254, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[171779, 4332, 319, 11, 44, "Input"],
Cell[172101, 4345, 317, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172455, 4359, 333, 12, 44, "Input"],
Cell[172791, 4373, 228, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173056, 4384, 361, 12, 44, "Input"],
Cell[173420, 4398, 34025, 565, 236, 27126, 450, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[207494, 4969, 59, 0, 45, "Subsection"],
Cell[207556, 4971, 423, 10, 65, "Input"],
Cell[CellGroupData[{
Cell[208004, 4985, 581, 19, 65, "Input"],
Cell[208588, 5006, 4297, 78, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212922, 5089, 340, 12, 44, "Input"],
Cell[213265, 5103, 380, 9, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213694, 5118, 48, 0, 45, "Subsection"],
Cell[213745, 5120, 639, 19, 85, "Input"],
Cell[214387, 5141, 739, 21, 69, "Input"],
Cell[CellGroupData[{
Cell[215151, 5166, 44, 1, 44, "Input"],
Cell[215198, 5169, 76, 1, 43, "Print",
 CellTags->"Info3392922924-7502732"],
Cell[215277, 5172, 1705, 46, 47, "Print",
 CellTags->"Info3392922924-7502732"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217019, 5223, 581, 19, 65, "Input"],
Cell[217603, 5244, 11318, 175, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228958, 5424, 406, 12, 44, "Input"],
Cell[229367, 5438, 964, 31, 111, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230368, 5474, 333, 11, 44, "Input"],
Cell[230704, 5487, 73, 2, 44, "Output"]
}, Open  ]],
Cell[230792, 5492, 684, 21, 61, "Input"],
Cell[CellGroupData[{
Cell[231501, 5517, 168, 5, 44, "Input"],
Cell[231672, 5524, 4079, 67, 241, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[235788, 5596, 72, 2, 44, "Input"],
Cell[235863, 5600, 773, 24, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[236673, 5629, 73, 2, 44, "Input"],
Cell[236749, 5633, 921, 29, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237707, 5667, 208, 6, 44, "Input"],
Cell[237918, 5675, 926, 27, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238881, 5707, 326, 10, 46, "Input",
 CellID->897672834],
Cell[239210, 5719, 4460, 152, 461, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243707, 5876, 381, 9, 44, "Input"],
Cell[244091, 5887, 793, 22, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[244921, 5914, 72, 2, 44, "Input"],
Cell[244996, 5918, 964, 31, 111, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246021, 5956, 44, 0, 55, "Section"],
Cell[246068, 5958, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[246169, 5963, 131, 4, 46, "Input"],
Cell[246303, 5969, 115, 3, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[246455, 5977, 129, 4, 46, "Input"],
Cell[246587, 5983, 174, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[246798, 5993, 57, 1, 44, "Input"],
Cell[246858, 5996, 386, 13, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247281, 6014, 75, 2, 44, "Input"],
Cell[247359, 6018, 217, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247613, 6031, 46, 1, 44, "Input"],
Cell[247662, 6034, 76, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247775, 6041, 54, 1, 44, "Input"],
Cell[247832, 6044, 57, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247926, 6050, 42, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[247993, 6054, 46, 1, 44, "Input"],
Cell[248042, 6057, 67, 2, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[248146, 6064, 49, 1, 44, "Input"],
Cell[248198, 6067, 117, 4, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[248352, 6076, 57, 1, 44, "Input"],
Cell[248412, 6079, 437, 15, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[248886, 6099, 72, 2, 44, "Input"],
Cell[248961, 6103, 67, 2, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249065, 6110, 57, 1, 44, "Input"],
Cell[249125, 6113, 48, 1, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249210, 6119, 219, 7, 44, "Input"],
Cell[249432, 6128, 48, 1, 58, "Output"]
}, Open  ]],
Cell[249495, 6132, 260, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[249780, 6142, 384, 13, 44, "Input"],
Cell[250167, 6157, 258, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250462, 6170, 250, 8, 44, "Input"],
Cell[250715, 6180, 212, 7, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[250976, 6193, 46, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[251047, 6197, 72, 1, 44, "Input"],
Cell[251122, 6200, 174, 4, 44, "Output"]
}, Open  ]],
Cell[251311, 6207, 243, 7, 44, "Input"],
Cell[CellGroupData[{
Cell[251579, 6218, 92, 2, 44, "Input"],
Cell[251674, 6222, 230, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[251941, 6235, 1087, 36, 85, "Input"],
Cell[253031, 6273, 50170, 833, 251, 40449, 672, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[303238, 7111, 288, 10, 44, "Input"],
Cell[303529, 7123, 489, 10, 65, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[304079, 7140, 56, 0, 55, "Section"],
Cell[304138, 7142, 76, 1, 44, "Input"],
Cell[304217, 7145, 417, 11, 65, "Input"],
Cell[CellGroupData[{
Cell[304659, 7160, 46, 1, 44, "Input"],
Cell[304708, 7163, 78, 1, 43, "Print",
 CellTags->"Info3392923219-2819462"],
Cell[304789, 7166, 1213, 33, 85, "Print",
 CellTags->"Info3392923219-2819462"]
}, Open  ]],
Cell[CellGroupData[{
Cell[306039, 7204, 56, 1, 44, "Input"],
Cell[306098, 7207, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[306163, 7212, 46, 1, 44, "Input"],
Cell[306212, 7215, 78, 1, 43, "Print",
 CellTags->"Info3392923231-8882356"],
Cell[306293, 7218, 1871, 61, 291, "Print",
 CellTags->"Info3392923231-8882356"]
}, Open  ]],
Cell[308179, 7282, 554, 17, 105, "Input"],
Cell[CellGroupData[{
Cell[308758, 7303, 46, 1, 44, "Input"],
Cell[308807, 7306, 78, 1, 43, "Print",
 CellTags->"Info3392923246-8288062"],
Cell[308888, 7309, 1161, 36, 80, "Print",
 CellTags->"Info3392923246-8288062"]
}, Open  ]],
Cell[CellGroupData[{
Cell[310086, 7350, 56, 1, 44, "Input"],
Cell[310145, 7353, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[310210, 7358, 46, 1, 44, "Input"],
Cell[310259, 7361, 78, 1, 43, "Print",
 CellTags->"Info3392923255-3975449"],
Cell[310340, 7364, 1631, 56, 225, "Print",
 CellTags->"Info3392923255-3975449"]
}, Open  ]],
Cell[CellGroupData[{
Cell[312008, 7425, 59, 1, 44, "Input"],
Cell[312070, 7428, 180, 5, 24, "Message"],
Cell[312253, 7435, 180, 5, 24, "Message"],
Cell[312436, 7442, 562, 15, 105, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[313047, 7463, 40, 0, 55, "Section"],
Cell[313090, 7465, 369, 12, 66, "Input"],
Cell[CellGroupData[{
Cell[313484, 7481, 54, 1, 44, "Input"],
Cell[313541, 7484, 301, 10, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[313879, 7499, 78, 2, 44, "Input"],
Cell[313960, 7503, 164, 5, 24, "Message"],
Cell[314127, 7510, 164, 5, 24, "Message"],
Cell[314294, 7517, 63, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314394, 7523, 128, 4, 44, "Input"],
Cell[314525, 7529, 63, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314625, 7535, 44, 1, 44, "Input"],
Cell[314672, 7538, 76, 1, 43, "Print",
 CellTags->"Info3392923295-1995550"],
Cell[314751, 7541, 992, 28, 24, "Print",
 CellTags->"Info3392923295-1995550"]
}, Open  ]],
Cell[315758, 7572, 324, 11, 46, "Input"],
Cell[CellGroupData[{
Cell[316107, 7587, 78, 2, 44, "Input"],
Cell[316188, 7591, 63, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[316288, 7597, 44, 1, 44, "Input"],
Cell[316335, 7600, 76, 1, 43, "Print",
 CellTags->"Info3392923315-8046651"],
Cell[316414, 7603, 1078, 31, 36, "Print",
 CellTags->"Info3392923315-8046651"]
}, Open  ]],
Cell[CellGroupData[{
Cell[317529, 7639, 437, 14, 46, "Input"],
Cell[317969, 7655, 48460, 803, 259, 35441, 588, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[366466, 8463, 54, 1, 44, "Input"],
Cell[366523, 8466, 70, 2, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[366630, 8473, 54, 1, 44, "Input"],
Cell[366687, 8476, 301, 10, 62, "Output"]
}, Open  ]],
Cell[367003, 8489, 398, 13, 66, "Input"],
Cell[CellGroupData[{
Cell[367426, 8506, 44, 1, 44, "Input"],
Cell[367473, 8509, 76, 1, 43, "Print",
 CellTags->"Info3392923347-4532818"],
Cell[367552, 8512, 1687, 46, 87, "Print",
 CellTags->"Info3392923347-4532818"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369276, 8563, 54, 1, 44, "Input"],
Cell[369333, 8566, 55, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369425, 8572, 54, 1, 44, "Input"],
Cell[369482, 8575, 55, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369574, 8581, 78, 2, 44, "Input"],
Cell[369655, 8585, 63, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369755, 8591, 78, 2, 44, "Input"],
Cell[369836, 8595, 786, 20, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[370659, 8620, 107, 3, 44, "Input"],
Cell[370769, 8625, 60, 1, 44, "Output"]
}, Open  ]],
Cell[370844, 8629, 102, 2, 42, "SmallText"],
Cell[370949, 8633, 380, 13, 46, "Input"],
Cell[CellGroupData[{
Cell[371354, 8650, 44, 1, 44, "Input"],
Cell[371401, 8653, 76, 1, 43, "Print",
 CellTags->"Info3392923409-8527092"],
Cell[371480, 8656, 2625, 72, 163, "Print",
 CellTags->"Info3392923409-8527092"]
}, Open  ]],
Cell[CellGroupData[{
Cell[374142, 8733, 107, 3, 44, "Input"],
Cell[374252, 8738, 88, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[374377, 8744, 435, 14, 46, "Input"],
Cell[374815, 8760, 53886, 893, 267, 40139, 666, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
