(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1379422,      34562]
NotebookOptionsPosition[   1326037,      32845]
NotebookOutlinePosition[   1326461,      32864]
CellTagsIndexPosition[   1326418,      32861]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Gleichungen und Ungleichungen", "Title"],

Cell[CellGroupData[{

Cell["Solve und Reduce", "Section"],

Cell[CellGroupData[{

Cell["\<\
Lineare und algebraische Gleichungen\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell["\<\
Die Menge der Variablen muss nicht unbedingt angegeben werden, wenn klar ist, \
dass nach allen Variablen aufgel\[ODoubleDot]st werden soll.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", "x"}], "+", "2"}], "\[Equal]", "0"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}]}], "\[Equal]", "11"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "13"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "7"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Enth\[ADoubleDot]lt ein Ausdruck \[UDoubleDot]berz\[ADoubleDot]hlige \
Variablen, die als Parameter betrachtet werden sollen, dann ist das zweite \
Argument erforderlich. Je nachdem, welche Variable als Parameter gesetzt \
wird, ergeben sich unterschiedliche L\[ODoubleDot]sungen (es sind ja auch \
unterschiedliche Aufgaben).\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input",\

 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"6", " ", "y"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"6", " ", "y"}]}]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", "y"}], "]"}]], "Input",\

 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "L\[ADoubleDot]sst man das zweite Argument weg, so ist das Ergebnis dasselbe \
wie in der Notation, wo alle Variablen als zweites Argument angegeben werden. \
In diesem Fall entscheidet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " selbst, welche Variablen als Parameter betrachtet werden. Der Nutzer hat \
auf diese Auswahl keinen Einfluss. Insbesondere zeigt dieses Beispiel, dass \
die Reihenfolge der Variablen auf diese Auswahl keinen Einfluss hat."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beachten Sie, dass f\[UDoubleDot]r einen Parameter ",
 StyleBox["y",
  FontSlant->"Italic"],
 " die L\[ODoubleDot]sungen \[UDoubleDot]ber dem K\[ODoubleDot]rper",
 StyleBox[" Q(y) ",
  FontSlant->"Italic"],
 "bestimmt werden. Dabei k\[ODoubleDot]nnen L\[ODoubleDot]sungen, die nur f\
\[UDoubleDot]r spezielle ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-Werte existieren, unter den Tisch fallen. \n\nDie Warnung, dass nicht alle \
L\[ODoubleDot]sungen gefunden wurden, ist also ernst zu nehmen. Sie bedeutet \
allerdings nicht, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " falsch rechnet (das tut es beim Gleichungsl\[ODoubleDot]sen gelegentlich \
auch), sondern dass es zwei Interpretationen der Aufgabenstellung ",
 StyleBox["Solve",
  FontSlant->"Italic"],
 " gibt und Sie vielleicht gerade die andere meinen.\n\nDer Unterschied wird \
am folgenden einfachen Beispiel bereits deutlich."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", "b"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["b", "a"]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " findet die allgemeine L\[ODoubleDot]sung, d.h. die L\[ODoubleDot]sung im K\
\[ODoubleDot]rper Q(a,b), diesmal sogar ohne Warnungen. \nDass es noch eine L\
\[ODoubleDot]sung ",
 StyleBox["x - beliebig ",
  FontSlant->"Italic"],
 "f\[UDoubleDot]r die speziellen Parameterwerte a\[Equal]b\[Equal]0 gibt \
bleibt dabei au\[SZ]er Betracht.\nEine vollst\[ADoubleDot]ndige \
\[CapitalUDoubleDot]bersicht \[UDoubleDot]ber alle L\[ODoubleDot]sungen, auch \
f\[UDoubleDot]r spezielle Parameterwerte, produziert das Kommando ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "x"}], "-", "b"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     FractionBox["b", "a"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"u", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", "b"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "x"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"a", " ", "x"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Sie k\[ODoubleDot]nnen im ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Kommando ein drittes Argument angeben, um Abh\[ADoubleDot]ngigkeiten \
explizit zu eliminieren. Das Ergebnis ist dasselbe wie bei einem herk\
\[ODoubleDot]mmlichen ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Aufruf mit dem Ergebnis einer Eliminationsaufgabe."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], "\[Equal]", "2"}]}], "}"}], ",", "x", ",", 
   "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["3", "2"]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "-", "y"}], "\[Equal]", "2"}]}], "}"}], ",", "y"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"u", ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "\[Equal]", "3"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["3", "2"]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " m\[UDoubleDot]ssen Gleichungen als Gleichungen angeschrieben werden. Eine \
Liste von Polynomen wird nicht akzeptiert - die aus anderen CAS bekannte \
Interpretation als Aufgabe zur Nullstellenbestimmung muss explizit \
angeschrieben werden. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "-", "2"}], ",", 
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      SuperscriptBox["y", "2"], "-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"eqf\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\(\\(-2\\)\\) + \\(\\(3\\\\ x\\)\\) - y\\^2\\) is \
not a well-formed equation.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"eqf\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\(\\(-2\\)\\) + \\(\\(3\\\\ x\\)\\) - y\\^2\\) is \
not a well-formed equation.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["x", "2"], "+", "y"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"3", " ", "x"}], "-", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"sys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}], "+", "z"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       RowBox[{"7", "z"}]}], "\[Equal]", "5"}]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", "sys", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["101", "41"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["49", "41"]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["14", "41"]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], " ", "/.", " ", 
  RowBox[{
  "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["101", "41"], ",", 
   RowBox[{"-", 
    FractionBox["49", "41"]}], ",", 
   RowBox[{"-", 
    FractionBox["14", "41"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"2", "3", "1"},
      {"1", 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"3", "0", "7"}
     }], ")"}]}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"(", GridBox[{
      {"x1"},
      {"x2"},
      {"x3"}
     }], ")"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"(", GridBox[{
      {"1"},
      {"4"},
      {"5"}
     }], ")"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Aus dieser komplexeren Notation lassen sich die Zutaten f\[UDoubleDot]r das \
",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Kommando wie folgt extrahieren:"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vars", "=", 
  RowBox[{"Flatten", "[", "x", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], "]"}], " "}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x1", "\[Rule]", 
     FractionBox["101", "41"]}], ",", 
    RowBox[{"x2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["49", "41"]}]}], ",", 
    RowBox[{"x3", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["14", "41"]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Die Antwort wird wieder als Substitutionsliste gegeben, woraus sich die L\
\[ODoubleDot]sung in Matrixnotation wie folgt gewinnen l\[ADoubleDot]sst. \
Auch die Probe l\[ADoubleDot]sst sich leicht ausf\[UDoubleDot]hren.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["101", "41"]},
      {
       RowBox[{"-", 
        FractionBox["49", "41"]}]},
      {
       RowBox[{"-", 
        FractionBox["14", "41"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], ")"}], "/.", 
  "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"mat", ".", "x"}], "-", "b"}], ")"}], "/.", "sol"}], 
   ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0"},
      {"0"},
      {"0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transzendente Gleichungen ", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " verwendet beim L\[ODoubleDot]sen transzendenter Gleichungen intern den \
Mechanismus der ",
 StyleBox["InverseFunction",
  FontWeight->"Bold"],
 ". Da die meisten transzendenten Funktionen keine Inverse \[UDoubleDot]ber \
dem ganzen Definitionsbereich besitzen, ist das Ergebnis von beschr\
\[ADoubleDot]nkter Aussagekraft. Meist wird nur eine L\[ODoubleDot]sung, der \
Hauptwert, angegeben.\nMit dem folgenden Ergebnis w\[UDoubleDot]rden Sie im \
Abitur sicher nur mittelm\[ADoubleDot]\[SZ]ig abschneiden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
    FractionBox["1", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Solve\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "6"]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Kommando ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " hilft weiter. Die Verbindung zu ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " m\[UDoubleDot]ssen Sie aber selbst herstellen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
     FractionBox["1", "2"]}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["\[Pi]", "6"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox[
       RowBox[{"5", " ", "\[Pi]"}], "6"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Es ist auch deutlich besser mit Zusatzinformationen konditionierbar als ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
      FractionBox["1", "2"]}], "&&", 
     RowBox[{
      RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"7", " ", "\[Pi]"}], "6"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox["\[Pi]", "6"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{"5", " ", "\[Pi]"}], "6"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"u", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"7", " ", "\[Pi]"}], "6"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["\[Pi]", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{"5", " ", "\[Pi]"}], "6"]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{
     RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"eqf\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(x < 5\\) is not a well-formed equation.\"\>"}]], \
"Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"eqf\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(x < 5\\) is not a well-formed equation.\"\>"}]], \
"Message", "MSG"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{
     RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"sol", "&&", 
     RowBox[{
      RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     FractionBox["\[Pi]", "6"]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Equal]", 
       RowBox[{"-", "1"}]}], "||", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Equal]", "0"}]}], ")"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", "\[Pi]"}], "+", 
        RowBox[{"12", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"u", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", 
      FractionBox["\[Pi]", "6"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "\[Pi]"}], "+", 
         RowBox[{"12", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "\[Pi]"}], "+", 
         RowBox[{"12", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "//.", "v"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "6"], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"7", " ", "\[Pi]"}], "6"]}], ",", 
   FractionBox[
    RowBox[{"5", " ", "\[Pi]"}], "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell["Beispiel: Eine Exponentialgleichung", "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "x"], "+", 
     SuperscriptBox["a", 
      RowBox[{"2", "x"}]]}], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Solve\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}], ")"}]}], "]"}], 
      RowBox[{"Log", "[", "a", "]"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["5"]}], ")"}]}], "]"}]}], 
      RowBox[{"Log", "[", "a", "]"}]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Messages", "[", "Solve", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"Solve", "::", "\"\<ifun\>\""}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Solve", "::", "\<\"eqf\"\>"}], "]"}], 
    "\[RuleDelayed]", "\<\"`1` is not a well-formed equation.\"\>"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Solve", "::", "\<\"ifun\"\>"}], "]"}], 
    "\[RuleDelayed]", "\<\"Inverse functions are being used by `1`, so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Solve", "::", "\<\"ifun2\"\>"}], "]"}], 
    "\[RuleDelayed]", "\<\"Cannot obtain a solution with the InverseFunctions \
-> False option setting.\"\>"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Solve", "::", "\<\"svars\"\>"}], "]"}], 
    "\[RuleDelayed]", "\<\"Equations may not give solutions for all \\\"solve\
\\\" variables.\"\>"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "+", 
      SuperscriptBox["u", "2"]}], "\[Equal]", "1"}], ",", "u"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "x"], "\[Equal]", "u"}], ",", "x"}], "]"}], "/.", 
  RowBox[{
  "sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}], "]"}], 
     RowBox[{"Log", "[", "a", "]"}]]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "x"], "+", 
     SuperscriptBox["a", 
      RowBox[{"2", "x"}]]}], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["5"]}], ")"}]}], "]"}]}], 
      RowBox[{"Log", "[", "a", "]"}]]}], "||", 
    RowBox[{"x", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SqrtBox["5"]}], ")"}]}], "]"}]}], 
      RowBox[{"Log", "[", "a", "]"}]]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rsol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "x"], "+", 
       SuperscriptBox["a", 
        RowBox[{"2", "x"}]]}], "\[Equal]", "1"}], "&&", 
     RowBox[{"a", ">", "0"}]}], ",", "x", ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"a", ">", "0"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}], "]"}], 
    RowBox[{"Log", "[", "a", "]"}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rsol", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "//",
   "ToRules"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}], "]"}], 
    RowBox[{"Log", "[", "a", "]"}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"rsol", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
   ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}], "]"}], 
     RowBox[{"Log", "[", "a", "]"}]]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Bei transzendenten Gleichungen ist die explizite Angabe der Variablen, nach \
der aufgel\[ODoubleDot]st werden soll, oftmals erforderlich, um \
Fehlinterpertationen der Gleichung durch ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "zu vermeiden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "\[Equal]", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], ";", " ", 
  RowBox[{"Solve", "[", "eq", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "-", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "So findet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " die (wichtigsten der) L\[ODoubleDot]sungen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"eq", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"ArcCos", "[", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SqrtBox["2"], "-", 
         SqrtBox["6"]}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"ArcCos", "[", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SqrtBox["2"], "+", 
          SqrtBox["6"]}], ")"}]}], "]"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " findet die gesamte L\[ODoubleDot]sungsmenge und durch \
zus\[ADoubleDot]tzliche Beschr\[ADoubleDot]nkung auf ein Intervall lassen \
sich auch einzelne L\[ODoubleDot]sungen isolieren. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eq", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"ArcTan", "[", 
        FractionBox[
         RowBox[{"2", "-", 
          SqrtBox["6"]}], 
         RowBox[{"2", "+", 
          SqrtBox["2"]}]], "]"}]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"ArcTan", "[", 
        FractionBox[
         RowBox[{"2", "+", 
          SqrtBox["6"]}], 
         RowBox[{"2", "+", 
          SqrtBox["2"]}]], "]"}]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"eq", "&&", 
       RowBox[{"0", "<", "x", "<", "2"}]}], ",", "x"}], "]"}], "//", 
    "Simplify"}], "//", "ToRules"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", "+", 
       SqrtBox["6"]}], 
      RowBox[{"2", "+", 
       SqrtBox["2"]}]], "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Und hier die Probe mit beiden L\[ODoubleDot]sungen. ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " hat sowohl Schwierigkeiten, unterschiedliche Wurzelausdr\[UDoubleDot]cke \
als gleichwertig zu erkennen, als auch Ausdr\[UDoubleDot]cke mit \
trigonometrischen und Arcusfunktionen zu analysieren. ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " schafft es in allen (diesen) F\[ADoubleDot]llen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "/.", "sol1"}], "//", "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["3"]}]]}], "\[Equal]", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["6"]}]}], ",", "True"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "/.", "sol2"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/.", 
    RowBox[{"sol1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
   ")"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol2"}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCos", "[", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SqrtBox["2"], "-", 
      SqrtBox["6"]}], ")"}]}], "]"}], "\[Equal]", 
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"2", "+", 
      SqrtBox["6"]}], 
     RowBox[{"2", "+", 
      SqrtBox["2"]}]], "]"}]}]}]], "Output"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Diese L\[ODoubleDot]sung gibt ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " als Antwort. Auch deren Gleichwertigkeit findet ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " heraus. Beachten Sie, dass Klammern gesetzt werden m\[UDoubleDot]ssen, da \
die Bindungskraft des Infixoperators \[Equal] h\[ODoubleDot]her ist als der \
von /. . Ohne Klammern w\[UDoubleDot]rde die zweite Zeile als ",
 StyleBox["x /. (sol1\[LeftDoubleBracket]2\[RightDoubleBracket] \[Equal] x) \
/. sol3",
  FontWeight->"Bold"],
 " gr\[UDoubleDot]ndlich missverstanden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol3", "=", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["3"], "-", "1"}], 
      RowBox[{
       SqrtBox["3"], "+", "1"}]], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/.", 
    RowBox[{"sol1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   ")"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol3"}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  RowBox[{"-", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["3"]}], 
     RowBox[{"1", "+", 
      SqrtBox["3"]}]], "]"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"ArcCos", "[", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       SqrtBox["2"], "+", 
       SqrtBox["6"]}], ")"}]}], "]"}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["3"]}], 
     RowBox[{"1", "+", 
      SqrtBox["3"]}]], "]"}]}]}]], "Output"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell["\<\
Und hier noch einige Beispiele.
Transzendente Gleichungen sehr unterschiedlicher Struktur k\[ODoubleDot]nnen \
gel\[ODoubleDot]st werden.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox[
      RowBox[{"x", "+", "1"}]], "+", 
     SqrtBox[
      RowBox[{"x", "-", "1"}]]}], "\[Equal]", "a"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{"4", "+", 
      SuperscriptBox["a", "4"]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Diese Wurzelgleichung ist \[ADoubleDot]quivalent zu einer Eliminationsaufgabe \
mit folgendem System\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "1"}], "\[Equal]", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{
      RowBox[{"x", "-", "1"}], "\[Equal]", 
      SuperscriptBox["z", "2"]}], ",", 
     RowBox[{
      RowBox[{"y", "+", "z"}], "\[Equal]", "a"}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{"4", "+", 
      SuperscriptBox["a", "4"]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "und dieses wiederum zu diesem ",
 StyleBox["Eliminate",
  FontWeight->"Bold"],
 "-Kommando"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "1"}], "\[Equal]", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{
      RowBox[{"x", "-", "1"}], "\[Equal]", 
      SuperscriptBox["z", "2"]}], ",", 
     RowBox[{
      RowBox[{"y", "+", "z"}], "\[Equal]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "4"], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", "x"}]}], "\[Equal]", 
  RowBox[{"-", "4"}]}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{"4", "+", 
      SuperscriptBox["a", "4"]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["Ein weiteres Beispiel.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "3"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox["\[ExponentialE]", "3"], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["\[ExponentialE]", "3"]}], "+", 
          SuperscriptBox["\[ExponentialE]", "6"]}]]}], ")"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox["\[ExponentialE]", "3"], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["\[ExponentialE]", "3"]}], "+", 
          SuperscriptBox["\[ExponentialE]", "6"]}]]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.252638518723276`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "16.83289840446439`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Diese Gleichung l\[ADoubleDot]sst sich auf eine algebraische \
zur\[UDoubleDot]ckf\[UDoubleDot]hren.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "2"], 
     RowBox[{"x", "-", "1"}]], "\[Equal]", 
    SuperscriptBox["E", "3"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox["\[ExponentialE]", "3"], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["\[ExponentialE]", "3"]}], "+", 
          SuperscriptBox["\[ExponentialE]", "6"]}]]}], ")"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox["\[ExponentialE]", "3"], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["\[ExponentialE]", "3"]}], "+", 
          SuperscriptBox["\[ExponentialE]", "6"]}]]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Bei wirklich transzendenten Gleichungen wei\[SZ] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dann gelegentlich auch nicht weiter."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The equations appear to involve the variables to be solved \
for in an essentially non-algebraic way.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}]}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"This system cannot be solved with the methods available to \
Reduce.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}]}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["2"], 
     RowBox[{"Log", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "-", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3k01PsbB3BjDMbYsi+Fol3qh1LE86lbWlC5ZLqDuraWW6GF3K6LspSK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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1, 5}, {-2.4854545634032155`, 3.92022486336346}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.6757604974239815`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     SuperscriptBox["E", "x"]}], "\[Equal]", "12"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"12", "-", 
     RowBox[{"ProductLog", "[", 
      SuperscriptBox["\[ExponentialE]", "12"], "]"}]}]}], "}"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "2.2747278714800956`"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"On", "[", 
   RowBox[{"Solve", "::", "\"\<ifun\>\""}], "]"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sungen weiterverarbeiten", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell["\<\
L\[ODoubleDot]sungen werden in Form von Substitutionslisten ausgegeben. Diese \
sind besonders einfach f\[UDoubleDot]r die verschiedensten Zwecke der \
Weiterverarbeitung einzusetzen. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y", "-", "2"}], "\[Equal]", "0"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       SuperscriptBox["y", "2"], "-", "2"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["L\[ODoubleDot]sungstupel extrahieren", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
L\[ODoubleDot]sungen in Ausdr\[UDoubleDot]cke einsetzen\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], "/.", "sol"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Expand"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "8", ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], "2"]}]}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "8", ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Die Probe", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "\[Equal]", "0"}], ",", "True"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "\[Equal]", "0"}], ",", "True"}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"First", "/@", "sys"}], ")"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       FractionBox["3", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       FractionBox["3", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], "2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Weiterarbeit mit einzelnen L\[ODoubleDot]sungen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "n"], "+", 
      SuperscriptBox["y", "n"]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "/.", 
   RowBox[{"sol", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], "//",
   "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{
    RowBox[{"-", "10"}], "+", 
    RowBox[{"6", " ", "\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], ",", 
   RowBox[{"31", "+", 
    RowBox[{"24", " ", "\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], ",", 
   RowBox[{"119", "-", 
    RowBox[{"48", " ", "\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
L\[ODoubleDot]sungen in der komplexen Zahlenebene darstellen\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "5"], "+", 
       RowBox[{"7", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], "]"}], "//",
    "N"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.14284864552500443`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.1130779765477108`"}], "-", 
      RowBox[{"1.1517343621516742`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.1130779765477108`"}], "+", 
      RowBox[{"1.1517343621516742`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.184502299310213`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.1513900754088373`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.184502299310213`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.1513900754088373`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "x", "]"}], ",", 
      RowBox[{"Im", "[", "x", "]"}]}], "}"}], "/.", "l"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.03", "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
    PointBox[{{-0.14284864552500443`, 
     0.}, {-1.1130779765477108`, -1.1517343621516742`}, {-1.1130779765477108`,
      1.1517343621516742`}, {1.184502299310213, -1.1513900754088373`}, {
     1.184502299310213, 1.1513900754088373`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1.1130779765477108`, 1.184502299310213}, {-1.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " kann auch dazu verwendet werden, um implizite Formeln nach einzelnen  \
Variablen aufzul\[ODoubleDot]sen und so Parameterdarstellungen zu gewinnen. \n\
Hier wird eine Kreisgleichung, die zum Vergleich  leicht in die Normalform ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"y", "-", "4"}], ")"}], "2"]}], "\[Equal]"}], 
   TraditionalForm]]],
 "117 gebracht werden kann, nach ",
 StyleBox["y",
  FontSlant->"Italic"],
 " aufgel\[ODoubleDot]st."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", "x"}], "+", 
      SuperscriptBox["y", "2"], "-", 
      RowBox[{"8", "y"}]}], "\[Equal]", "100"}], ",", "y"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"4", "-", 
      SqrtBox[
       RowBox[{"116", "-", 
        RowBox[{"2", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"4", "+", 
      SqrtBox[
       RowBox[{"116", "-", 
        RowBox[{"2", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f1", "[", "x_", "]"}], ",", 
    RowBox[{"f2", "[", "x_", "]"}]}], "}"}], "=", 
  RowBox[{"y", "/.", "lsg"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", "-", 
    SqrtBox[
     RowBox[{"116", "-", 
      RowBox[{"2", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]]}], ",", 
   RowBox[{"4", "+", 
    SqrtBox[
     RowBox[{"116", "-", 
      RowBox[{"2", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f1", "[", "3", "]"}], ",", 
    RowBox[{"f2", "[", "4", "]"}]}], "}"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6.04987562112089`"}], ",", "13.591663046625438`"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "[", "x", "]"}], ",", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "12"}], ",", "10"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", " ", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4VN8fB/ChsW/ZuWOdwSAtllDhHqJFkiKVKHyRhERJUlEqCaWERIQk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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8lV8YAHDJzEj2dgcu8ipCA92noSHRVIlERmSVUhllZkSSWUghhRIN
aTnHLysVhaSMEpGVPTJ/p7/u5/u55773vM8553meQ7fz2OPAycHB4bmIg+Pf
p84qZiJfBgvPeNk2bwIR+BJ1Vsw4nYVvDzMbXxxbBp2ztIKPKSzsZvHA/q6I
KAy5VptaJbNwb0BTc0CsKMy1ePV0x7NwjNlk289ZUViyU+GSVywLP/+ueazT
UgykXlcwFqJZ2GS1h1rYQzFQpjxRZCQLm354uYc2JwZGQm+mbgezsNTfgtev
w8XBxN81gQpgYe/V6xUjqsTBYkBC57kfC2cc4zanc0uA54fjJz6eYeHWlqpi
K28J8DcS5bM6xcKMww/bbuZJQOSDl1nd7izsPpMnMtEmAZnRwm3zTiwsn3ah
6SZIQuPOJ7soSxauUweTtFFJ6HhtPVBswcLf7q9kRCtIwRDFG7l5LwsnB7ei
kC1SwC9s+eawKQv3V9pVvE2QAsOaBb3I9SwcMZQmvXS5NGSa7ZDrZrBwVYJ3
nv8aGRgppe9TU2Lht4r7qq5ZygDoTUU5y7Gwo/2aSyw/GWiTuzPfJ8bCvo+8
Yzpfy4BMz3z7EBcLC/QZ+C43lIWY4Ef3prtUcWLs9Clxlhy0TYS3G3SoYosd
b59ybpIDTRcbWf/vqjg8mtvt7hE5qN4lGLXwRRVHCd9xk0+QA25FRw+ut6p4
uFpTuGdeDnyLZfSF81Qxz1bnBM9KeahePuRuflcVjx0X2nXtuzxIp1fcvZqp
ijlX2NUETcpDUaiXjFiqKr6xy2Vrg6oCDO/5MCsVrYrtlCf89gUrgNNAwBu6
hyqesYtxj9RVhL2M37v0VpHvr5XUxfopgexTebGiFarYcXeUU9kVJfi5dfdn
fU1VfMnoRW7bLSXwdHtxaI2KKjYprY58V6YEUcVRdgZSqnhj67lnldw0KDPT
Pr1hRgXTjpeLBJjQQNfXJ2nnGxXsGyzZc/M9DSQbBNsc9qrggW1dCe+K6fDH
r3PFlLkKFl60ftd1RIcKlVeBkaYqODDGW9a2gg7eZ0+oPDRWwakt95Z+r6fD
Z9lq16nVKljS8PC7hD90iLcNm4mUV8FqQfFeUwwGiA4ukin4pYxvWAk6fAtj
wNIlk3unzyrjxm4pnsFNTFArmtmw8bQy1tILS+E2YcJGO46VkZ7KOH/nqkKp
XUzwfsEvKOusjKv3SvpoWTGhzUW+bK2lMl6yx3Yr6zQT7r/boHveUBnL31nx
ckcmE0yio8SnOMh4jRR8eZ4JoSKMz+MRTFz98OJBiVxlEB5veFCfx8BRJxUC
j75VAfHcqljpl3R8XF37VOlXVdjVEXiktIaGK/oiP3qVs8BoPJT7eqcS9mvj
EL4boQYNZRH2/jyK+G91u43+NnW4uivtlOo2ebzsvkxhSbc6FHca7Em6JovZ
dSZzj09rQLOM1bbGZ9J4cTQfq2dOA5gCUQNfZyXx7Za4yX2ey8EhzSgnT14C
80rrLI1vWw7ia3z0jY3F8KqelLliI034faXiVGb0Mny6puqcw2VNcBVSv5xu
uxQPd7w6TW/QBMGZ1WLP9i7FIPVrWPazJuT93pJSY7wUvzvbVCPWqAm9b+zz
5tSX4hOHfe4tbtIEZ59b7w6PCOOJrzKtzc2a4NgtJSgdLIxnHnHZuHdowtFS
nuirWUI46VHxYfkRTdh7pvNKYLcAXqWnUHBLiIJpj7thHk0CuCGk3jREmIIM
F5cA67cCWCPfdpXTUgqGbIZOrs0TwGanbNs0llFwxWR237C7AH5Dc8vPEaeg
WklcznZiCT4eZ2MSKkcBVG+6C9xL8Mq4y0ueqlHwu4znltYEP9bnoQsFqVMQ
g94my3cTf9tkZaZBQdsT88ipKn5ch4J+dC6nwC/9sFtBFD82ypcO5l9BwbPT
Xqto4vxY9/r0Bm09CrSUMtECgw9PWi2jZoACmVMjE6vE+fDA16n4/A0UcJVv
0DrOzYd7mnT22G6k4KvLj9SP3bx4f1T7+7JNFIQUKfjcvs+LX0rPlgVvoaB5
Z7LuJn1eHPHFr6Z9BwXhftE5l7bz4LrE4qeKFhR41bb8eLGOBwdxsLpfER9h
aEoPLufBK9Z+97A8QMGqqupLB4R5MJeDU1jcQfI+Ynz2avXc2G7e5eOcJQV6
eUGK1VbcWCghp/GRDQU/v56NE/LkwmfvfRVLP05Bfi57iG3HhX1f9cgoOVPg
48u789Q+Ltw4lHblJrGoQhLPlzVcuN9ArizFhYKNR4vO31rEhRkaQUdjXMl6
dY3ZrIpbjLFoutNhTwpsR09qHirixH5DPsOXzlKgWbY24vI9Tnz265u2MeKp
+EVdr29w4s3HWw3szlFwVT82nXGREw9+yTI2OE8BPl8g2r+VE3dzeiV3+VBA
4xicuvB1EdY9sn8j4wIFPwRdy7NmOXDRa77vVAgFT3q7rz0Y4MD+mqpXYonD
q44dLWrjwBtdBuPHiFeEHJ6pxBx4R2xOTnEoBRdmTLT7QjgwExcNrQmjQKFX
PU1biANvfvxpViaSxCdmx+fTswvIz6haw4s4Yscmz0ttC+ji7qmCd8RN/+lk
52QsoAcHJSp8LlPgXbhMdEhjAf23Tlv8UxQFj6/U9vgZzCNh04dbjsRQYGlS
GXJFYR6pXLw7c5+Ykwcp3VqYQ3ZK5vwzxHv88/e/eTOHdGaqtBKukv1+IrqU
33QOreDUyCyNJfHbvuN6otUsou0NXT0TR0H24sptBf7TSGZv/LrhJApEXj7U
KrGdRimrh4GVTNbvVLL4e+NpxLNBqciK2Kzd+Ue30DQKj1noLyeeKBE8p3Tz
LxrU3Bwde50CY589d6+UTKGQBfMUoRSyH7QNolMzppAvpF9dRyzdw/TKvTSF
vFLnxhyJ+w+Mr68wm0IrY8aXlBDH6yU3zrVNolTQdnVIpaBzqJXbbWECHaNy
eK6nkf+/V9Hn0zGBHF57/XlFXGzz8FN45QTSaLlo/IM4qiYgLStmAinWOW1Q
uUn2832mXovSBPp2utTzHnHqMUG53sUTSP9WR10lMY/cOMdU9zh6ud0qq4v4
W0TFe7GCcaRfZJnASKcgyMnZfgeMo4Ha9w/jiPsV95gcUh5Hu6Q6o/KJLRrX
rXTiG0dlI8e+VhFrGAvOBn0cQ7eT7+AZ4jrGw7gXR8fQ3jCnKstbFBh+Szpf
tXkM9dyZpp0kzo4NsGlUG0M4kbvnErEPx57lI0OjKK4oorKAmN429p964Chy
6z5bMkcsumVCpcxhFB02KV639DZZ//zJ8CMmo2ituZwmjbjTf9osTmwU3dxp
5g7EDb9mCqmpEeTyhIbMict3zolXtYyggiTZ0CPE2QoczbN3RhBlEOHpQ5wU
umh9UuQIWhDnSAwjDh/gvK3tMYLCbmasjCd2fs3t5LhmBE0HuJfnEVuq8FZz
KIygrvTrqIjYJJqPSlk0gqKmR7VKiTWtBUZrq4cRw2+tWwOxQrmghcvDYRQs
oWrYSixMCT/niieu3Rzwi3g+fql8+rlhtH574toB4sFZkYtrrYeRrZTc8THi
H/aiP+s3DKPlZfUCM8Qf34sZu6sOo+O1WHlRBgWluhL3+ASGkVf+z0c8xI9S
JQUyB4fQuvdriwSIM7ik3Y0ahtCaiAotEeI4V5lPX4qHkJ9BhLw4cUiDrO6p
tCGUoRV0UYr4tKF8kmDQEPqWWXhAltghS2E623EItX+SuiNPbCGoZL1hxxDi
+/XESZF4y2kabl4xhLQWwtOViFe30Jne4kOocnW8KY14V/gWQfrIIGpIaXT/
Z+2D2+v2vxxE3dQunn8WVTNNjgwZRKwuDrF/vx+bNDuCdg6irY9+xysQf67c
rTwmOYiunOGNkiMuStrXq/bjD6rns56SJk52OlBgnfMHXVzX81WC+PxqS+9r
p/6giJq8laLElrzWhpUGf5DvhaxZIWLDLzacs1x/kMffOiN+YoW7dlUrawbQ
0k79scXE894OVxySBlBiU63S/L/4bzm+78bRAVTjmIYniUslT8jWqg8gMfH0
xqHb/+qRZ/aaV/1o+r6hXTux4yUvV7fQfkTz+PKliXirhbdOhlk/spzL/K+W
eMmEb4lAex/SK66dfEncV34hBHL7UJ0TtbGQ+H1CoMkZrz50tuf5omziGL2w
xjbuPjQwfvhHNLEnd2SqWG0vUi3wWAgg3vM5ym5bci8yTMmP8yIWP3PtT6FG
L2oazJE7QHzjSRpPqHkPOv/qbI4UcUqxZ4yYeA9aXWk7zkWc+mqTdEbTb1T2
rCVtmJy3tLIedWT7G/XZXuB6S3yrQW/nX69uVLnXSM3zn5v4GsPWdKP/Tvge
PEh8u6X5iORcF7qvZPCLTZzRGei56lIXSsnQFxcivjP2Ic4t+Rcy/dZamU7y
Q/bULflZq1+oZvZ3c9A/z3rdiaT/QqO1dqYOxPe4ZJ/dze1EGvNJG9WIc8Ud
v7W/6kC5IS+Ds0m+KtCdp1m0tyO7InOLEJL/CtZ8yum8044aIvpWWBMXGmbp
eLm0I2OTcgc94kebTTZfHf2BPtoqd3WQ/Pp0X6JTNfcPVG+vsXYt8ZkeKyv/
fS2I4+iwcvkNUo+GOd1vtDaj+ZlMHEd87u+9i88cm9Fyhf3FtsQ+/OMZw+e+
IRXR2y9nSP4PUI/ucUhrQpKBNsvUiCOdX3ubdTWg/SWbxm1JfYk/ynpidbYB
pU71mGsQpx+IHXbha0CGWuflRhJJ/TV2cA3TqEf9/Bu4A4i/04XssPsnxHHx
LyMhgYLjT57fsP/zDjVJcgRnkfrlnxEtESjyDhU6Les9Rnztqu3VNJ1qZHEZ
lzKIX7vyX2r0rkKcox3/3bxGzpfKoZPbFsrQbqt8gaukHvosH445SHuFLN9n
PTpA6mcW7/XQWPsXqN9Ehi5MXNsBvtX3itGMwOeFN1coUE696mio/RSpKQkI
axGnyRz1gZD76F3oe9cZUq9x+MuU6b8HEZeOhZYvqe+65mIvww++ZAvfL4gX
Jv3C0rqe/MC1r9lBerameaSf6N2HM3xkEXujjInlVuJdD/SN9d1L2Qtd6ef8
g0l9etyhqbaynJ1Xta+kPZD0byVGswJP3rO3LzvrEEn6l+zecx96Wj+znY7V
Nx8m/ZD1ZfclahaN7BRxp60d3mT/a9pvdaxpZFdt7eN1IQ50My/9WfKFnf45
KezMGQqshlSeNqd/Zd/ZAAEhXiQ+E3WpH2xb2XXtl02DPChAAZJFTad+smU9
T83MOlIgOGTzre3BT3bT/S1hJ4ktbXLmO3//ZBsHlbj+ciD9gJHh1uEjHWyH
RofN7+xJfztj28S/o5O9LkNdJcaOnK8zD6bXMbvY+y0W3560JvF32cxOq+9h
H9vsz9ixjwI5jbWdK28Msb9fvyT9dz0FHF2uec+eDrE7ns41mRN33r51av2n
IfaLXxe5s41IfyHDt8iUb5jdOueWscuQ9Ov8XxScvIfZu72ce2+upcD+9+kD
aXtG2AZtp7KVdMn47IJqfoEx9iq95OOFpJ/fyFQr/Ok7ybZfafBEVIQCqfLR
xFfXJ9kybP9QHXJf6HdEfonPJtm7wpSzdpP7RGKuxTaT0Uk2gu1vowXJ+mmH
fi90mWJf5T1dMMdHQSz8FAo89JftprKz7eUiki+tU12UVs+w7/f7ihWS+8rF
ZBFlq5F5dsWywdPn6zQhTtjarX2ME3JvhUdHX9GEpThFhduGByjl5j0fN2hC
4oovBVFiS0D4q1RXxs/lUK862hoZLkTyikyG4IXlIPSH22MiUwT0XFytdi9e
DlFRnPjnMVGIfaeT3R2kAemM02xeOXHwlP1tNDGhDs+k7O9ZT0oAeHg4/9qp
Drm7NtsNPpaCkNoHrkI31SDzdwb34wQZ0Bq4mqfwlgUrznl/yXeXgxtG01de
tKpC4o51079YClAvpJIt1KUCiy/48ZjzKIEH8+qE32NlUPH5UnjejgZaP+/k
dDoygePtH5dfDjRwefSx8ogtE1qkeJR3O9PgRkeF1ufDTIh/qpuo5kmDzmJ2
aRG5T3MOx/p88aeBRqyllek6JvxwMt2kd50GjX1vDr4SZELq/tKGoVoa3I8L
tA/OZ8C5rKZoq3oa6GZRTT73GLBvdHBLVSN53q3v5W4ZDBCIVXye3kqDIIft
Q8aJDPB575tm1kcDyehbGSX+DDiwSd/xPg8dnAqT9ap3MEBUO2/SyYgOn1N1
+Jd00uG+X4K44gY6KHwSC6xpocOWqovaDZvpUPHnIUR9psN5m30nwJSM56AO
j1bQ4Uf0XJv0YTqcCnxs6p5Dh/xe84q35+iQfUn/HZ8bHUyyxuKXP6FDFKes
mdkfMs/BtsL2Z3TgLBi6JtNFgwsGb2uSXtJhhv6rsJnMu7AujY/rDR0MQ0Fq
8wcaSC/a6tfyiQ7veUziMvJo0GV9/Vj0IB2EQzyU/B3Je0qt1xnUYACvXW3+
ubtKkLWputxBiwFPnAOU4hOUoNzD4lCLNgOuBj//nBSsBHxV7gFv1zCAJ1u7
3MJGCa6cS6/J3MIArbk8pRwJJbj+lePEQTsG7Hn6p3aHvyK84I6er3FgQG7K
kQHkrAgt2jLXjJ0Z4NfyWUDSQhEUI7Wf63gyQFx80UFHLUXIWmfHK3SBAXKu
nsXhrQpQkPIms/Q6AwzYJaf36ilAXaX56jVpZD59f8uzlBRgdLS5Ov8WA/ja
vlrW8CuAvunYcMpdBmSFYuW7rfLwalYZvJ8yoOSgge+BYHmosr7UovGJARZ0
2bCv5XLQGyHqebuBAfIP6+XZD+RAoOjmYukm8rzJk9tc4+XATPiZBvd3BjgH
vL8uZScHDSXd5773M+BiWe5k6LQsfFfaLhHPx4TeqLOb5BRloWTbPcH9ZN8V
id7OL5iXgZsnebkkRZhwXGbKqaVNBqzflI8kSTHBpRrt7kqTgWbHjR9TVJng
1CK1GyRl4EXM7UorDSY8bSjq5h6VhhvFHEhBiwmRLG+jNbXScGgJepCux4QX
/Qf5K0Kl4csDg8uZm5lwL751e3yvFBQ13giy38aE0pHZtx9LpSBx4e95FVMm
PLdtUFieLAX7dxcfv7uXCY/edUnPbpACXR+po8cPMEElMjfZXEIKxDO9D6iT
cxbRd2jyfLck1I/pbsmzY8Ls/JLJoTBJeKQQb+RKzmmPTMrOxRaScG3LqC7l
woQOszfm3gxJ2J1cyHx4kgnqXMOGH55KwMpSETnPM0zQCTIQ3uQnASK9HqLa
55nw5pu37hqQgFoDrUWPA5iQwF/fSUPikG8fPeUVwgTHGIF0kfPicCW6f1A3
nAkXlnrY2GiJg3vRju7xy0z4L91MYlGbGOz8nttWFMOE9SK8309eEgNNviWN
Z+OYcEw/V91SRQwEtZ0/rEliwnfajwevi0Sh/1BV2d8bTIjKsKws1BGFd0Gs
Vy9uMmF1ZL7N7+BlcHTs7Q25DCY8ydkYNC4vAv8Dqr65pw==
     "]]}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-12, 10}, {-6.816653693864204, 14.816653693864204`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nullstellen von Polynomen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Die Root-Notation", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nst", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Roots",
  FontWeight->"Bold"],
 " und ",
 StyleBox["ToRules",
  FontWeight->"Bold"]
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"%", "//", "ToRules"}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Weiterverarbeitung von Root-Ausdr\[UDoubleDot]cken\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"nst", ",", "20"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.16730397826141868425604589985484218072`20."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "0.18123244446987538390180023778112063997`19.367753129139917"}], 
      "-", 
      RowBox[{
      "1.08395410131771066843034449298076657427`20.14452807380574", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "0.18123244446987538390180023778112063997`19.367753129139917"}], 
      "+", 
      RowBox[{
      "1.08395410131771066843034449298076657427`20.14452807380574", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.76488443360058472602982318770854173033`20.108700620161105", "-", 
      RowBox[{
      "0.35247154603172624931794709140258105439`19.772228861064615", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.76488443360058472602982318770854173033`20.108700620161105", "+", 
      RowBox[{
      "0.35247154603172624931794709140258105439`19.772228861064608", " ", 
       "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x", ",", "30"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "-", "1.167303978261418684256045899854842180720560371526`29.\
979162831012903"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "0.181232444469875383901800237781120639968716466184`29.\
260560857045952"}], "-", 
      RowBox[{
      "1.083954101317710668430344492980766574273640243155`30.037335801711777",
        " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "0.181232444469875383901800237781120639968716466184`29.\
260560857045952"}], "+", 
      RowBox[{
      "1.083954101317710668430344492980766574273640243155`30.037335801711777",
        " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.764884433600584726029823187708541730328996651948`29.67613525416428", 
      "-", 
      RowBox[{
      "0.352471546031726249317947091402581054394206480824`29.339663495067786",
        " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.764884433600584726029823187708541730328996651948`29.67613525416428", 
      "+", 
      RowBox[{
      "0.352471546031726249317947091402581054394206480824`29.339663495067786",
        " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "nst"}], ")"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5"}], "}"}]], "/.", "nst"}], ")"}]}], "//",
   "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "4", ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Parameterabh\[ADoubleDot]ngige Root-Ausdr\[UDoubleDot]cke\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nst", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "+", 
      RowBox[{"a", " ", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"a", "\[Rule]", "1"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToRadicals"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["2", 
           RowBox[{"25", "-", 
            RowBox[{"3", " ", 
             SqrtBox["69"]}]}]], ")"}], 
         RowBox[{"1", "/", "3"}]], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"25", "-", 
             RowBox[{"3", " ", 
              SqrtBox["69"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"25", "-", 
            RowBox[{"3", " ", 
             SqrtBox["69"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "+", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], 
       RowBox[{"3", " ", 
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"25", "-", 
           RowBox[{"3", " ", 
            SqrtBox["69"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"25", "-", 
            RowBox[{"3", " ", 
             SqrtBox["69"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "+", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], 
       RowBox[{"3", " ", 
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"25", "-", 
           RowBox[{"3", " ", 
            SqrtBox["69"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"r1", "[", "a_", "]"}], "=", 
   RowBox[{"x", "/.", 
    RowBox[{"nst", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}],
   ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"r1", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx/ExOzMi92922RJJJXLZrUhtvl8xi12GiN1qqVzWnqFcolgq
ItrKaRnCDCkcTLJd9lQ4te9v0WVSo8KQUTtYQ43JDOYiYj97zv7wOs/z+Ade
q6ISQ2KpFAqFhfZfj40FTi0uYmRvnbOSe0UL0szPVeJ5jCzuXlLxkK8Flsnf
mjuzGLli044NikYt2HgkfUqcxsjsZHIZs0ELD84UL5FIMTKgP14ur9XCEue+
leRzjBxZndO6rUoLJan7v8/mYSTtOrvy8XktNOkcrqO4Y+StGKf86lQt0GN9
v7aMMCMjZGLj81u0gPU/TKgpMiW5juwgxYIGQtq50eufmpBrDgiNZB0ayJzc
nvD7iDEpTJLeXpengZajXPa1ICOy6WR1zzBTA6ziMJuFCgNSzGLyfCga8K26
x/Kb0CfX7k9jVLSqof5xhujwXj0y3Ce+NDlNDZF5JeZdjbrkkHgff9xeDcf3
f/bHUoxBXr0Y6id4qwKKkzV4n6KRuctpeBxHBQNnKwqaeqkkbU8jK8BTBSv0
f+HP7NAhT9josI7JZiB+swNdvGIRNhOd9IbCGYh2f9vY3j4HSesbns9umAGH
9K2Lh+q00KP0+DFQOA2X34R2ZHip4Ak/On1V1DSM5Zh/42sxBQV347riNFPQ
VmrPHA+Xg+rbD23NWVPg+u71jEuVFJRN9BbjeSX4tIn1PoVLID52n3tXphKS
+Ne0plg3MLYO0tKkCgj/efXlV1mtcJVdrNQEKeDxs9dnNoa24Bzqr/asA5Ow
1en+zeCybrzHrlkkeycH6hHzwRhLCa530GJelTABugbBOVEfpLjEd7ufY/N7
yJWIvFNq5XjqBJdxqWccrvPyg49PKfHlMZNr8xljkFgTY/JPuAoHQyO9j/qj
EMnmWhXkaHHDCcd1afgI/LbziMfGyjn8QkZ1BPCGgLasVHri4wK+5eXRL1Ko
EujrPKXIM9YhCp/Zm9fGvoGwzCg3bjuVsLIN8HeWD0DCUpmtcA+NSFYE3+PL
+8G66dEFxns6YbGbLuK490Fmi3eoMU+XSP5Okc0s74Wk+oTbbi56RKQtb6PM
uwcMqO5RzqP6xE112d3NC6+AeXBXqQPHgOjvCndcM/ISLFqtEpl2RoSlm8WQ
SP0CilNOF7n2GRPqwL2aOJMXEJIf5FR124SgjXnMeFQKwWFvXljdMVNiuiCl
xNLrOYikejWcMDPCLpGelvWuE4RRo15m1hgRYFUau9j+FLilpoyMWYwgb3AN
xdUCGM5/sIqDPNy0s6oVeX364e3NyGG1+5zKkVv29KYOIY/nZbPCkEXWFSP+
HzFiTN5b0nVRANgVm/tfzmFEoKvwq44qAZz7yyXr7jxGpBKyq808AfRck5SJ
kJ/9cML3HPLyy0V/KpB/2sEeZiNfyZ1+b/cJIwbO+ljaIz/xu7O7EPl8p/7Z
Gq4AaN2e7pELGMHtGzxeViGAgI7JkHTk63lvVh5B5ty6dKgYeXZyE+xCti2n
1j9CHp4bo5ghExGPlrksYkRoR+Tpc+UCOM066uqP7Olp7hiP3IXbB0Qjv423
FfojR9qeyS1D1gwS5rrI9di26hvIL6xCWkfLBPCBNtHWiWxt2BbRgeymrhSN
Ihfx06m1yP//GTGgLGzIQf4XkBmW0A==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-5, 5}, {-1.5416516705684462`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rechnen mit algebraischen Zahlen", "Subsection"],

Cell[TextData[StyleBox["RootReduce",
 FontWeight->"Bold"]], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"3", "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]}]], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 SqrtBox[
  RowBox[{"3", "+", 
   RowBox[{"2", " ", 
    SqrtBox["2"]}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  SqrtBox["2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"11", "-", 
    RowBox[{"6", " ", 
     SqrtBox["2"]}]}]], "+", 
  SqrtBox[
   RowBox[{"11", "+", 
    RowBox[{"6", " ", 
     SqrtBox["2"]}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input"],

Cell[BoxData["6"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData["6"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mehrere ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdr\[UDoubleDot]cke zum selben Polynom\nSimultane Zuweisung an die \
Variablen ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["a", "1"], ",", "...", ",", 
   SubscriptBox["a", "5"]}]]],
 ":"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nst", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",",
      "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", 
    SubscriptBox["a", "2"], ",", 
    SubscriptBox["a", "3"], ",", 
    SubscriptBox["a", "4"], ",", 
    SubscriptBox["a", "5"]}], "}"}], "=", 
  RowBox[{"x", "/.", "nst"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["a", "1"], "-", 
   SubscriptBox["a", "2"]}], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2869", "+", 
     RowBox[{"5000", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"400", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"3750", " ", 
      SuperscriptBox["#1", "6"]}], "-", 
     RowBox[{"40", " ", 
      SuperscriptBox["#1", "8"]}], "+", 
     RowBox[{"625", " ", 
      SuperscriptBox["#1", "10"]}], "-", 
     RowBox[{"95", " ", 
      SuperscriptBox["#1", "12"]}], "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "16"]}], "+", 
     SuperscriptBox["#1", "20"]}], "&"}], ",", "4"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"1", "+", 
    SubscriptBox["a", "1"]}], 
   RowBox[{"1", "-", 
    SubscriptBox["a", "1"]}]], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"13", " ", "#1"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"18", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SubscriptBox["a", "1"], "+", 
    SubscriptBox["a", "2"]}], 
   RowBox[{
    SubscriptBox["a", "3"], "+", 
    SubscriptBox["a", "4"]}]], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"20", " ", "#1"}], "+", 
     RowBox[{"185", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"1065", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"4339", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"13520", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"34005", " ", 
      SuperscriptBox["#1", "6"]}], "+", 
     RowBox[{"71890", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     RowBox[{"132279", " ", 
      SuperscriptBox["#1", "8"]}], "+", 
     RowBox[{"219722", " ", 
      SuperscriptBox["#1", "9"]}], "+", 
     RowBox[{"342269", " ", 
      SuperscriptBox["#1", "10"]}], "+", 
     RowBox[{"512915", " ", 
      SuperscriptBox["#1", "11"]}], "+", 
     RowBox[{"736779", " ", 
      SuperscriptBox["#1", "12"]}], "+", 
     RowBox[{"986252", " ", 
      SuperscriptBox["#1", "13"]}], "+", 
     RowBox[{"1191549", " ", 
      SuperscriptBox["#1", "14"]}], "+", 
     RowBox[{"1272045", " ", 
      SuperscriptBox["#1", "15"]}], "+", 
     RowBox[{"1191549", " ", 
      SuperscriptBox["#1", "16"]}], "+", 
     RowBox[{"986252", " ", 
      SuperscriptBox["#1", "17"]}], "+", 
     RowBox[{"736779", " ", 
      SuperscriptBox["#1", "18"]}], "+", 
     RowBox[{"512915", " ", 
      SuperscriptBox["#1", "19"]}], "+", 
     RowBox[{"342269", " ", 
      SuperscriptBox["#1", "20"]}], "+", 
     RowBox[{"219722", " ", 
      SuperscriptBox["#1", "21"]}], "+", 
     RowBox[{"132279", " ", 
      SuperscriptBox["#1", "22"]}], "+", 
     RowBox[{"71890", " ", 
      SuperscriptBox["#1", "23"]}], "+", 
     RowBox[{"34005", " ", 
      SuperscriptBox["#1", "24"]}], "+", 
     RowBox[{"13520", " ", 
      SuperscriptBox["#1", "25"]}], "+", 
     RowBox[{"4339", " ", 
      SuperscriptBox["#1", "26"]}], "+", 
     RowBox[{"1065", " ", 
      SuperscriptBox["#1", "27"]}], "+", 
     RowBox[{"185", " ", 
      SuperscriptBox["#1", "28"]}], "+", 
     RowBox[{"20", " ", 
      SuperscriptBox["#1", "29"]}], "+", 
     SuperscriptBox["#1", "30"]}], "&"}], ",", "6"}], "]"}]], "Output"]
}, Open  ]],

Cell["Rationalmachen des Nenners", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", "=", 
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]]}], "\[IndentingNewLine]", 
 RowBox[{"u1", "=", 
  RowBox[{"u", "//", "RootReduce"}]}], "\[IndentingNewLine]", 
 RowBox[{"u2", "=", 
  RowBox[{"u1", "//", "ToRadicals"}]}], "\[IndentingNewLine]", 
 RowBox[{"u3", "=", 
  RowBox[{"u2", "//", "FullSimplify"}]}]}], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}]]], "Output"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]], "Output"],

Cell[BoxData[
 SqrtBox[
  RowBox[{"5", "-", 
   RowBox[{"2", " ", 
    SqrtBox["6"]}]}]]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["2"]}], "+", 
  SqrtBox["3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "/@", 
  RowBox[{"{", 
   RowBox[{"u", ",", "u1", ",", "u2", ",", "u3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13", ",", "16", ",", "13", ",", "13"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"], "+", 
     SqrtBox["5"]}]], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"], "+", 
   SqrtBox["5"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "//", "RootReduce"}], "//", "ToRadicals"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      SqrtBox["6"], "-", 
      SqrtBox["10"], "-", 
      SqrtBox["15"]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell["\<\
Alle Variablen mit Subscript l\[ODoubleDot]schen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Clear", "[", "Subscript", "]"}]], "Input"],

Cell[TextData[{
 "Inverse zu ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"], "+", 
   SqrtBox["5"]}]]],
 "als Linearkombination mit unbestimmten Koeffizienten ansetzen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inv", "=", 
   RowBox[{
    SubscriptBox["a", "0"], "+", 
    RowBox[{
     SubscriptBox["a", "1"], 
     SqrtBox["2"]}], "+", 
    RowBox[{
     SubscriptBox["a", "2"], 
     SqrtBox["3"]}], "+", 
    RowBox[{
     SubscriptBox["a", "3"], 
     SqrtBox["5"]}], "+", 
    RowBox[{
     SubscriptBox["a", "4"], 
     SqrtBox["6"]}], "+", 
    RowBox[{
     SubscriptBox["a", "5"], 
     SqrtBox["10"]}], "+", 
    RowBox[{
     SubscriptBox["a", "6"], 
     SqrtBox["15"]}], "+", 
    RowBox[{
     SubscriptBox["a", "7"], 
     SqrtBox["30"]}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ex", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"inv", 
     RowBox[{"(", 
      RowBox[{
       SqrtBox["2"], "+", 
       SqrtBox["3"], "+", 
       SqrtBox["5"]}], ")"}]}], "-", "1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{
   SqrtBox["2"], " ", 
   SubscriptBox["a", "0"]}], "+", 
  RowBox[{
   SqrtBox["3"], " ", 
   SubscriptBox["a", "0"]}], "+", 
  RowBox[{
   SqrtBox["5"], " ", 
   SubscriptBox["a", "0"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{
   SqrtBox["6"], " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{
   SqrtBox["10"], " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{
   SqrtBox["6"], " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{
   SqrtBox["15"], " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{
   SqrtBox["10"], " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{
   SqrtBox["15"], " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{"3", " ", 
   SqrtBox["2"], " ", 
   SubscriptBox["a", "4"]}], "+", 
  RowBox[{"2", " ", 
   SqrtBox["3"], " ", 
   SubscriptBox["a", "4"]}], "+", 
  RowBox[{
   SqrtBox["30"], " ", 
   SubscriptBox["a", "4"]}], "+", 
  RowBox[{"5", " ", 
   SqrtBox["2"], " ", 
   SubscriptBox["a", "5"]}], "+", 
  RowBox[{"2", " ", 
   SqrtBox["5"], " ", 
   SubscriptBox["a", "5"]}], "+", 
  RowBox[{
   SqrtBox["30"], " ", 
   SubscriptBox["a", "5"]}], "+", 
  RowBox[{"5", " ", 
   SqrtBox["3"], " ", 
   SubscriptBox["a", "6"]}], "+", 
  RowBox[{"3", " ", 
   SqrtBox["5"], " ", 
   SubscriptBox["a", "6"]}], "+", 
  RowBox[{
   SqrtBox["30"], " ", 
   SubscriptBox["a", "6"]}], "+", 
  RowBox[{"5", " ", 
   SqrtBox["6"], " ", 
   SubscriptBox["a", "7"]}], "+", 
  RowBox[{"3", " ", 
   SqrtBox["10"], " ", 
   SubscriptBox["a", "7"]}], "+", 
  RowBox[{"2", " ", 
   SqrtBox["15"], " ", 
   SubscriptBox["a", "7"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"ex", ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", 
     SqrtBox["3"], ",", 
     SqrtBox["5"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{
   SqrtBox["5"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["a", "5"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["a", "6"]}]}], ")"}]}], "+", 
  RowBox[{
   SqrtBox["3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["a", "4"]}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["a", "6"]}], "+", 
     RowBox[{
      SqrtBox["5"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "2"], "+", 
        SubscriptBox["a", "3"], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["a", "7"]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["a", "4"]}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["a", "5"]}], "+", 
     RowBox[{
      SqrtBox["5"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "3"], "+", 
        RowBox[{"3", " ", 
         SubscriptBox["a", "7"]}]}], ")"}]}], "+", 
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "2"], "+", 
        RowBox[{
         SqrtBox["5"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["a", "4"], "+", 
           SubscriptBox["a", "5"], "+", 
           SubscriptBox["a", "6"]}], ")"}]}], "+", 
        RowBox[{"5", " ", 
         SubscriptBox["a", "7"]}]}], ")"}]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Das zugeh\[ODoubleDot]rige lineare Gleichungssystem extrahieren und l\
\[ODoubleDot]sen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lhs", "=", 
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{"ex", ",", 
     RowBox[{"{", 
      RowBox[{
       SqrtBox["2"], ",", 
       SqrtBox["3"], ",", 
       SqrtBox["5"]}], "}"}]}], "]"}], "//", "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "1"]}], "+", 
    RowBox[{"3", " ", 
     SubscriptBox["a", "2"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["a", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "0"], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "5"]}], "+", 
    RowBox[{"3", " ", 
     SubscriptBox["a", "6"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "0"], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "4"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["a", "6"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "2"], "+", 
    SubscriptBox["a", "3"], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["a", "7"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "0"], "+", 
    RowBox[{"3", " ", 
     SubscriptBox["a", "4"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["a", "5"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "1"], "+", 
    SubscriptBox["a", "3"], "+", 
    RowBox[{"3", " ", 
     SubscriptBox["a", "7"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "1"], "+", 
    SubscriptBox["a", "2"], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["a", "7"]}]}], ",", 
   RowBox[{
    SubscriptBox["a", "4"], "+", 
    SubscriptBox["a", "5"], "+", 
    SubscriptBox["a", "6"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"lhs", "\[Equal]", "0"}], " ", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "1"], "\[Rule]", 
     FractionBox["1", "4"]}], ",", 
    RowBox[{
     SubscriptBox["a", "2"], "\[Rule]", 
     FractionBox["1", "6"]}], ",", 
    RowBox[{
     SubscriptBox["a", "3"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "0"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "4"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "5"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "6"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "7"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "12"]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u2", "=", 
  RowBox[{
   RowBox[{"inv", "/.", 
    RowBox[{"sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "//",
    "Together"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SqrtBox["2"]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}], "-", 
    SqrtBox["30"]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u2", "\[Equal]", "u"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "/@", 
  RowBox[{"{", 
   RowBox[{"u", ",", "u1", ",", "u2"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", "33", ",", "26"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["RootSum",
 FontWeight->"Bold"]], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nst", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]], "/.", 
     "nst"}], ")"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "4", ",", 
   RowBox[{"-", "5"}], ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "-", "x"}]], "/.", "nst"}], ")"}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["z", "4"]}]}], 
  RowBox[{"1", "-", "z", "+", 
   SuperscriptBox["z", "5"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "-", "#"}]], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["z", "4"]}]}], 
  RowBox[{"1", "-", "z", "+", 
   SuperscriptBox["z", "5"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      RowBox[{"3", "#", "z"}], "+", 
      SuperscriptBox["#", "3"]}]], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"15", " ", "z"}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["z", "2"]}], "-", 
   RowBox[{"171", " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{"36", " ", 
    SuperscriptBox["z", "5"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["z", "8"]}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"3", " ", "z"}], "-", 
   SuperscriptBox["z", "2"], "-", 
   RowBox[{"39", " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{"15", " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{"243", " ", 
    SuperscriptBox["z", "5"]}], "-", 
   RowBox[{"126", " ", 
    SuperscriptBox["z", "6"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["z", "7"]}], "+", 
   SuperscriptBox["z", "10"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", "#1", "]"}], "&"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Normal"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}], 
   "]"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynome dritten und vierten Grades", "Subsection"],

Cell[CellGroupData[{

Cell["Polynome dritten Grades ", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", "x"}], "+", "1"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl3k8VG0bx8cyji1tWgihh7TSLsp9l1IRbbZEu5YnRaGshbImW/ZkLZGS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-6.994521969479707, 8.995004893269037}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " verwendet die Cardanoschen Formeln zur Darstellung der Nullstellen eines \
Polynoms dritten Grades. Besonders im casus irreducibilis ist es schwer zu \
entscheiden, dass es sich bei den L\[ODoubleDot]sunngen um reelle Zahlen \
handelt."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"2", "/", "3"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"]}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "-", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol"}], ")"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.532088886237956`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.3472963553338608`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.1102230246251565`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.8793852415718169`"}], "-", 
    RowBox[{"1.1102230246251565`*^-16", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ComplexExpand",
  FontWeight->"Bold"],
 " findet sogar die trigonometrische Darstellung der entsprechenden \
aklgebraischen Zahlen, die im casus irreducibilis eigentlich verwendet werden \
sollte. Mit trigonometrischen Ausdr\[UDoubleDot]cken kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " aber als algebraische Zahlen schlechter rechnen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"sol", "//", "ComplexExpand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "9"], "]"}], "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "9"], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "9"], "]"}], "-", 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "9"], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "9"], "]"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Deutlich besser kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " mit der Darstellung  der Nullstellen in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation umgehen, die man etwa wie folgt erzeugen kann:"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}], "//", "ToRules"}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.8793852415718169`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.3472963553338607`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.532088886237956`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol2"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Rekombination der Nullstellen zum Ausgangspolynom in den drei Darstellungen.
Zun\[ADoubleDot]chst die Darstellung durch Wurzelausdr\[UDoubleDot]cke.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol"}], ")"}]}], ")"}]}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"]}], "2"], "-", 
  FractionBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}]], "-", 
  RowBox[{"3", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Together"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"3", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Hier die ausgef\[UDoubleDot]hrten Schritte im Einzelnen. A=",
 Cell[BoxData[
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox["3"]}]],
  CellChangeTimes->{3.35946701622635*^9, 3.35947181917236*^9}],
 " ist der einzige Kern im Absolutglied. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], "-", 
   FractionBox["A", "2"], "-", 
   FractionBox["2", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "A"}]]}], "//", "Together"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "5"}], "+", 
   RowBox[{"2", " ", "A"}], "-", 
   SuperscriptBox["A", "2"]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "A"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   SuperscriptBox["A", "2"], "\[Rule]", 
   RowBox[{"-", "3"}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   RowBox[{"2", " ", "A"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "A"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Cancel"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell["Nun die trigonometrische Darstellung.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol1"}], ")"}]}], ")"}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "-", 
  RowBox[{"3", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "9"], "]"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "9"], "]"}], "3"]}], "-", 
  RowBox[{"3", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox["\[Pi]", "9"], "]"}], "2"]}], "-", 
  RowBox[{"6", " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "9"], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox["\[Pi]", "9"], "]"}], "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"3", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Und schlie\[SZ]lich die durch ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdr\[UDoubleDot]cke."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol2"}], ")"}]}], ")"}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "-", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"3", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Generell l\[ADoubleDot]sst sich feststellen, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zwar wei\[SZ], dass die folgenden Ausdr\[UDoubleDot]cke algebraische \
Zahlen sind, aber nur zu wenigen die ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "--Darstellung berechnen kann."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", 
    RowBox[{"Range", "[", 
     RowBox[{"3", ",", "15"}], "]"}]], "]"}], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox["3"], "2"], ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"5", "-", 
       RowBox[{"20", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}], ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "7"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "8"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "9"], "]"}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "11"], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "13"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "14"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "15"], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"#", "\[Element]", "Algebraics"}], "&"}], "/@", "%"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", 
    RowBox[{"Range", "[", 
     RowBox[{"3", ",", "15"}], "]"}]], "]"}], "//", 
  "FunctionExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox["3"], "2"], ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   SqrtBox[
    RowBox[{
     FractionBox["5", "8"], "-", 
     FractionBox[
      SqrtBox["5"], "8"]}]], ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "7"], "]"}], ",", 
   FractionBox[
    SqrtBox[
     RowBox[{"2", "-", 
      SqrtBox["2"]}]], "2"], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "9"], "]"}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "11"], "]"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["3"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "13"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "14"], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "8"]}], " ", 
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]]}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynome vierten Grades", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", 
    RowBox[{
     SuperscriptBox["x", "4"], "-", 
     RowBox[{"4", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"7", "x"}], "+", "1"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl3k8lN8Xx81gZmzTMGNEshcJSZIKz6lkqyzRQiohIpWvJJUiylIKpZIk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-2, 5}, {-5.752405496888656, 62.97531004868265}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Mit solchen L\[ODoubleDot]sungsformeln kann man wirklich nichts mehr \
anfangen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Dass es sich um vier reelle L\[ODoubleDot]sungen handelt, erkennt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " aus dieser Form nur mit M\[UDoubleDot]he. Selbst das m\[ADoubleDot]chtige \
",
 StyleBox["FullSImplify",
  FontWeight->"Bold"],
 " braucht daf\[UDoubleDot]r einige Zeit."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.0930643576779349`"}], "+", 
      RowBox[{"1.034631496526776`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.14464913994286688`"}], "-", 
      RowBox[{"1.891890041361728`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.8882865623435747`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.3784208232423209`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"3.349426935277227`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.211622784073688`*^-18", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol"}], "]"}], " ", "//", 
  "Timing"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"83.71000000000001`", ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit dem Ergebnis von ",
 StyleBox["ComplexExpand",
  FontWeight->"Bold"],
 " kann man wohl auch kaum etwas anfangen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"ComplexExpand", " ", "/@", " ", "sol"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.0930643576779349`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.14464913994286688`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.8882865623435745`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.3494269352772275`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit der Darstellung in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation dagegen kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gut umgehen. Alle relevanten Informationen \[UDoubleDot]ber die \
Nullstellen sind ohne weitere Vereinfachungen verf\[UDoubleDot]gbar."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}], "//", "ToRules"}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.093064357677935`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.14464913994286677`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.8882865623435747`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.3494269352772266`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol2", " "}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "F\[UDoubleDot]r diese Kontrollrechnung schafft es erst das \
m\[ADoubleDot]chtige ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 ", die geschachtelten Wurzelausdr\[UDoubleDot]cke aufzul\[ODoubleDot]sen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol"}], ")"}]}], ")"}]}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["7", "3"], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"585", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["50991"]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]], 
   SuperscriptBox["3", 
    RowBox[{"2", "/", "3"}]]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"585", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["50991"]}]}], ")"}], 
    RowBox[{"2", "/", "3"}]], 
   RowBox[{"12", " ", 
    SuperscriptBox["2", 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "3"}]]}]], "+", 
  FractionBox["256", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"585", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["50991"]}]}], ")"}]}], ")"}], 
    RowBox[{"2", "/", "3"}]]], "-", 
  FractionBox["32", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"585", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["50991"]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"585", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["50991"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]], "+", 
      FractionBox["32", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["3", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"585", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["50991"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], ")"}]}]], "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["7", "3"], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"585", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["50991"]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]], 
   SuperscriptBox["3", 
    RowBox[{"2", "/", "3"}]]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"585", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["50991"]}]}], ")"}], 
    RowBox[{"2", "/", "3"}]], 
   RowBox[{"12", " ", 
    SuperscriptBox["2", 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "3"}]]}]], "+", 
  FractionBox["256", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"585", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["50991"]}]}], ")"}]}], ")"}], 
    RowBox[{"2", "/", "3"}]]], "-", 
  FractionBox["32", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"585", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["50991"]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"585", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["50991"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]], "+", 
      FractionBox["32", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["3", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"585", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["50991"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], ")"}]}]], "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", "//", "N"}], "//", "Chop"}]], "Input"],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"7.`", " ", "x"}], "-", 
  RowBox[{"4.`", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit der Ausgabe von ",
 StyleBox["ComplexExpand",
  FontWeight->"Bold"],
 " kommt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dagegen \[UDoubleDot]berraschend gut zurecht."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol1"}], ")"}]}], ")"}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"], "-", 
  RowBox[{"8", " ", 
   SqrtBox[
    FractionBox["2", "3"]], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       SqrtBox[
        FractionBox["16997", "3"]], "195"], "]"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["32", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        SqrtBox[
         FractionBox["16997", "3"]], "195"], "]"}]}], "]"}], "2"]}], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"8", " ", 
       SqrtBox[
        FractionBox["2", "3"]], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            FractionBox["16997", "3"]], "195"], "]"}]}], "]"}]}]}], 
     ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit der ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation bereitet diese Vereinfachung ebenfalls keine Schwierigkeiten."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{
   RowBox[{"Times", "@@", 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"(", 
       RowBox[{"x", "/.", "sol2"}], ")"}]}], ")"}]}], "//", 
   "Expand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "4"], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"7", " ", "#1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Auch andere abgeleitete Ausdr\[UDoubleDot]cke wie diese Potenzsummen kann \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " deutlich einfacher vereinfachen, wenn die Nullstellen in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation vorliegen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "/.", "sol"}], 
    ")"}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "43", ",", "140", ",", "444"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "/.", "sol2"}], 
    ")"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "43", ",", "140", ",", "444"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["y", "2"], "-", 
       RowBox[{"x", " ", "y"}], "-", 
       SuperscriptBox["x", "3"]}]], "/.", "sol"}], ")"}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Schreibt man dieselbe Aufgabe mit den Nullstellen in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation an, so gelingt die Vereinfachung mit ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 ", nachdem ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " der Tipp gegeben wird, es doch einmal mit der rationalen Normalform zu \
versuchen. Der ",
 StyleBox["LeafCount",
  FontWeight->"Bold"],
 " ist deutlich kleiner geworden. ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " stellt \[UDoubleDot]brigens Z\[ADoubleDot]hler und Nenner \
zus\[ADoubleDot]tzlich nach dem Hornerschema dar, was den ",
 StyleBox["LeafCount",
  FontWeight->"Bold"],
 " noch einmal verringert. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["y", "2"], "-", 
       RowBox[{"x", " ", "y"}], "-", 
       SuperscriptBox["x", "3"]}]], "/.", "sol2"}], ")"}]}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "LeafCount"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["y", "2"], "-", 
    RowBox[{"y", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "3"]}]], "+", 
  
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["y", "2"], "-", 
    RowBox[{"y", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "3"]}]], "+", 
  
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["y", "2"], "-", 
    RowBox[{"y", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "3"]}]], "+", 
  
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["y", "2"], "-", 
    RowBox[{"y", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], 
     "3"]}]]}]], "Output"],

Cell[BoxData["213"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["y", "2"], "-", 
         RowBox[{"x", " ", "y"}], "-", 
         SuperscriptBox["x", "3"]}]], "/.", "sol2"}], ")"}]}], "//", 
    "Together"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"%", "//", "LeafCount"}]}], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"331", "+", 
   RowBox[{"427", " ", "y"}], "+", 
   RowBox[{"506", " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{"71", " ", 
    SuperscriptBox["y", "3"]}], "-", 
   RowBox[{"129", " ", 
    SuperscriptBox["y", "4"]}], "-", 
   RowBox[{"12", " ", 
    SuperscriptBox["y", "5"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["y", "6"]}]}], 
  RowBox[{"1", "+", 
   RowBox[{"49", " ", "y"}], "+", 
   RowBox[{"389", " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{"443", " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"312", " ", 
    SuperscriptBox["y", "4"]}], "+", 
   RowBox[{"39", " ", 
    SuperscriptBox["y", "5"]}], "-", 
   RowBox[{"43", " ", 
    SuperscriptBox["y", "6"]}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["y", "7"]}], "+", 
   SuperscriptBox["y", "8"]}]]], "Output"],

Cell[BoxData["71"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "LeafCount"}]}], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"331", "+", 
   RowBox[{"y", " ", 
    RowBox[{"(", 
     RowBox[{"427", "+", 
      RowBox[{"y", " ", 
       RowBox[{"(", 
        RowBox[{"506", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"71", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "129"}], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "y"}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
  RowBox[{"1", "+", 
   RowBox[{"y", " ", 
    RowBox[{"(", 
     RowBox[{"49", "+", 
      RowBox[{"y", " ", 
       RowBox[{"(", 
        RowBox[{"389", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"443", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"312", "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{"39", "+", 
                  RowBox[{"y", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "43"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "y"}], ")"}], " ", "y"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}]]], "Output"],

Cell[BoxData["58"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynomiale Gleichungssysteme", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Beispiel 1: Ein System mit Symmetrien", "Subsection"],

Cell[TextData[{
 "Das folgende Gleichungssystem ist invariant unter zyklischer Vertauschung \
der Variablen. Diese Eigenschaft hat deshalb auch die \
L\[ODoubleDot]sungsmenge. An der Ausgabe des ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Kommandos ist das nicht so recht sichtbar."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "+", "x", "+", "y", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x", "+", "z", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "+", "z", "-", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["2"]}], "-", 
       FractionBox["4", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]], "+", 
       FractionBox[
        SqrtBox["2"], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       RowBox[{"4", "-", 
        SqrtBox["2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}]]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SqrtBox["2"]}], "+", 
       FractionBox["4", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]], "+", 
       FractionBox[
        SqrtBox["2"], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "4"}], "-", 
        SqrtBox["2"]}], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}]]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3.`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3.`"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3.`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}], ",", 
     RowBox[{"z", "\[Rule]", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.4142135623730951`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2.414213562373095`"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1.4142135623730951`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.4142135623730951`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.41421356237309515`"}]}], ",", 
     RowBox[{"z", "\[Rule]", "1.4142135623730951`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.41421356237309515`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.4142135623730951`"}], ",", 
     RowBox[{"z", "\[Rule]", "1.4142135623730951`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.414213562373095`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.4142135623730951`"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1.4142135623730951`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.4142135623730954`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.414213562373095`"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "0.41421356237309515`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.4142135623730954`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.414213562373095`"}]}], ",", 
     RowBox[{"z", "\[Rule]", "2.414213562373095`"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       RowBox[{"4", "-", 
        SqrtBox["2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}]]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       RowBox[{"4", "-", 
        SqrtBox["2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}]]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", "+", 
         SqrtBox["2"]}], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", "+", 
         SqrtBox["2"]}], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Statt ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " k\[ODoubleDot]nnen Sie auch ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " einsetzen, um Gleichungssysteme in einfachere Form zu bringen. In Ergebnis \
wird das Problem in eine boolesche Kombination mehrerer Teilprobleme zerlegt, \
die sich mit ",
 StyleBox["LogicalExpand",
  FontWeight->"Bold"],
 " in die distributive Normalform bringen l\[ADoubleDot]sst."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rsys", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], ",", "vars"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox["2"]}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       SqrtBox["2"]}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox[
           RowBox[{"9", "-", 
            RowBox[{"4", " ", "x"}]}]]}], ")"}]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{"9", "-", 
            RowBox[{"4", " ", "x"}]}]]}], ")"}]}]}]}], ")"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"1", "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "3"}]}], "||", 
      RowBox[{"x", "\[Equal]", "1"}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"1", "-", 
        SqrtBox["2"]}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"1", "+", 
        SqrtBox["2"]}]}]}], ")"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"3", "-", 
      SuperscriptBox["x", "2"], "-", "y"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rsys", "//", "LogicalExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "3"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"3", "-", 
      SuperscriptBox["x", "2"], "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"3", "-", 
      SuperscriptBox["x", "2"], "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox[
         RowBox[{"9", "-", 
          RowBox[{"4", " ", "x"}]}]]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"1", "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox[
         RowBox[{"9", "-", 
          RowBox[{"4", " ", "x"}]}]]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"1", "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox["2"]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox[
         RowBox[{"9", "-", 
          RowBox[{"4", " ", "x"}]}]]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"1", "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox["2"]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox[
         RowBox[{"9", "-", 
          RowBox[{"4", " ", "x"}]}]]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"1", "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"1", "-", 
      SqrtBox["2"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"3", "-", 
      SuperscriptBox["x", "2"], "-", "y"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"1", "+", 
      SqrtBox["2"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"3", "-", 
      SuperscriptBox["x", "2"], "-", "y"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " kann auch mit solchen booleschen Kombinationen von Gleichungen aufgerufen \
werden. Hier liefert es gleich die Antwort, welche ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " auf dem Ausgangssystem erst nach Anwendung von ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " gefunden hat."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"rsys", ",", "vars"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"x", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Das Vorgehen beim L\[ODoubleDot]sen dieses Systems folgt grob dieser Idee:\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "8"}], " ", "z"}], "+", 
   RowBox[{"19", " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["z", "3"]}], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["z", "4"]}], "+", 
   SuperscriptBox["z", "6"]}], "\[Equal]", "6"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"f", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
   RowBox[{"f", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "z"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["z", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", "z"}], "+", 
    SuperscriptBox["z", "2"]}], ")"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Beispiel 2",
  FontWeight->"Bold"],
 ": Bestimmung der kritischen Punkte einer Funktion"
}], "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"6", 
     SuperscriptBox["x", "3"], 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["x", "3"], 
     SuperscriptBox["y", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["x", "4"], 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"f", ",", "x"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"f", ",", "y"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Union"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}], ",", 
   "vars"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weitere Beispiele ", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "+", "x", "+", "y", "+", "z"}], ",", 
     RowBox[{
      RowBox[{"w", " ", "x"}], "+", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"w", " ", "z"}], "+", 
      RowBox[{"y", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"w", " ", "x", " ", "y"}], "+", 
      RowBox[{"w", " ", "x", " ", "z"}], "+", 
      RowBox[{"w", " ", "y", " ", "z"}], "+", 
      RowBox[{"x", " ", "y", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"w", " ", "x", " ", "y", " ", "z"}], "-", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "z"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "z"]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "\[Rule]", 
      FractionBox["1", "z"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "z"]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "w"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["1", "w"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "w"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "w"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "w"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "w"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "w"]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "w"]}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", "w"}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"-", "x"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "w"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "w"]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "w"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "w"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["1", "w"]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "w"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"t", " ", 
       RowBox[{"x", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"6", " ", "t", " ", "x", " ", "y", " ", "z"}], "+", 
      RowBox[{"3", " ", "t", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"2", " ", "t", " ", 
       RowBox[{"z", "^", "3"}]}], "-", 
      RowBox[{"6", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"6", " ", "x", " ", "y", " ", "z"}], "-", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "t"}], " ", 
       RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
      RowBox[{"3", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"10", " ", "t", " ", 
       RowBox[{"y", "^", "3"}]}], "-", 
      RowBox[{"15", " ", "t", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"3", " ", "t", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"3", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"10", " ", 
       RowBox[{"y", "^", "3"}]}], "+", 
      RowBox[{"x", " ", "y", " ", "z"}], "+", 
      RowBox[{"15", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"5", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"18", " ", "t", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"3", " ", "t", " ", 
       RowBox[{"x", "^", "3"}], " ", "z"}], "-", 
      RowBox[{"18", " ", "t", " ", 
       RowBox[{"x", "^", "2"}], " ", "y", " ", "z"}], "+", 
      RowBox[{"12", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"5", " ", "t", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"12", " ", "t", " ", "x", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"6", " ", "t", " ", "x", " ", 
       RowBox[{"z", "^", "3"}]}], "-", 
      RowBox[{"8", " ", "t", " ", 
       RowBox[{"z", "^", "4"}]}], "-", 
      RowBox[{"18", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"x", "^", "2"}], " ", "y", " ", "z"}], "-", 
      RowBox[{"12", " ", "x", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"12", " ", "x", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"6", " ", "x", " ", 
       RowBox[{"z", "^", "3"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "63"}], " ", 
       RowBox[{"t", "^", "2"}], " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"t", "^", "2"}], " ", 
       RowBox[{"x", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"63", " ", 
       RowBox[{"t", "^", "2"}], " ", "x", " ", "y", " ", "z"}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"t", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"27", " ", 
       RowBox[{"t", "^", "2"}], " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"18", " ", 
       RowBox[{"t", "^", "2"}], " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"t", "^", "2"}], " ", 
       RowBox[{"z", "^", "3"}]}], "+", 
      RowBox[{"78", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"78", " ", "t", " ", "x", " ", "y", " ", "z"}], "-", 
      RowBox[{"18", " ", "t", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"24", " ", "t", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"18", " ", "t", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"9", " ", "t", " ", 
       RowBox[{"z", "^", "3"}]}], "-", 
      RowBox[{"15", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"15", " ", "x", " ", "y", " ", "z"}], "-", 
      RowBox[{"5", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "1"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"t", "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"t", "\[Rule]", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      FractionBox["z", "2"]}], ",", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "3"]}]}], ",", 
     RowBox[{"x", "\[Rule]", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      FractionBox["z", "2"]}], ",", 
     RowBox[{"t", "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "z"}], ",", 
     RowBox[{"t", "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "z"}], ",", 
     RowBox[{"t", "\[Rule]", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "z"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"%", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["z", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "0"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "1"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "x"}]}], ",", 
     RowBox[{"t", "\[Rule]", 
      FractionBox["1", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "x"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "x"}]}], ",", 
     RowBox[{"t", "\[Rule]", 
      FractionBox["1", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      FractionBox["x", "2"]}], ",", 
     RowBox[{"z", "\[Rule]", "x"}], ",", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "3"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Vergleich der beiden L\[ODoubleDot]sungen.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Sort", "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"sol1", ",", "sol2"}], "}"}]}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "z", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["z", "2"], ",", "z", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "z", ",", "z", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "0", ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "z"}], ",", "0", ",", "z", ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "z"}], ",", "z", ",", "z", ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       FractionBox["z", "2"], ",", "z", ",", 
       RowBox[{"-", 
        FractionBox["1", "3"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "z", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["z", "2"], ",", "z", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "z", ",", "z", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "0", ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"-", "x"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "x"}], ",", 
       RowBox[{"-", "x"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       FractionBox["x", "2"], ",", "x", ",", 
       RowBox[{"-", 
        FractionBox["1", "3"]}]}], "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eine Geometrieaufgabe", "Subsection"],

Cell[TextData[{
 "Ein Geometrieproblem: Im Dreieck mit den Eckpunkten A(0,0), B(2,0), C(u,1) \
ist P(x1,x2) der Schnittpunkt der Winkelhalbierenden durch A und B. Da sich \
Innen- und Au\[SZ]enwinkelhalbierende algebraisch nicht unterscheiden lassen, \
erhalten wir ein System ",
 StyleBox["whpolys",
  FontWeight->"Bold"],
 " mit zwei Polynomen zweiten Grades und daraus vier m\[ODoubleDot]gliche \
Schnittpunkte der Winkelhalbierdendenpaare durch A und B. Die \
L\[ODoubleDot]sung h\[ADoubleDot]ngt von einem Parameter u ab.\n\n",
 StyleBox["whcon",
  FontWeight->"Bold"],
 " ist die Bedingung, dass P auch auf dem WInkelhalbierendenpaar durch C \
liegt. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whpolys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "-", 
      RowBox[{"4", " ", "x1"}], "+", 
      SuperscriptBox["x1", "2"], "-", 
      RowBox[{"8", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x2"}], "+", 
      RowBox[{"4", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
      SuperscriptBox["x2", "2"]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"2", " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x1", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x1", "2"]}], "-", 
      RowBox[{"4", " ", "x2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["u", "2"], " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "3"], " ", "x2"}], "+", 
      RowBox[{"2", " ", "x1", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1", " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x2", "2"]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x2", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whcon", "=", 
   RowBox[{
    SuperscriptBox["x1", "2"], "-", 
    RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           SuperscriptBox["u", "2"]}]], "-", 
         RowBox[{"u", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}]}], ")"}]}]}], 
     ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["u", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]]}], "-", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"1", "+", 
              SuperscriptBox["u", "2"]}]]}], ")"}]}], "-", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"5", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}], "-", 
             RowBox[{"2", " ", "u", " ", 
              SqrtBox[
               RowBox[{"1", "+", 
                SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           SuperscriptBox["u", "2"]}]], "+", 
         RowBox[{"u", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}]}], ")"}]}]}], 
     ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["u", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]]}], "-", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"1", "+", 
              SuperscriptBox["u", "2"]}]]}], ")"}]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"5", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}], "-", 
             RowBox[{"2", " ", "u", " ", 
              SqrtBox[
               RowBox[{"1", "+", 
                SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SqrtBox[
          RowBox[{"1", "+", 
           SuperscriptBox["u", "2"]}]], "-", 
         RowBox[{"u", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "+", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "+", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}]}], ")"}]}]}], 
     ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["u", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]]}], "+", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            SqrtBox[
             RowBox[{"1", "+", 
              SuperscriptBox["u", "2"]}]]}], ")"}]}], "-", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"5", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}], "+", 
             RowBox[{"2", " ", "u", " ", 
              SqrtBox[
               RowBox[{"1", "+", 
                SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SqrtBox[
          RowBox[{"1", "+", 
           SuperscriptBox["u", "2"]}]], "+", 
         RowBox[{"u", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "+", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}], "+", 
              RowBox[{"2", " ", "u", " ", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}]}], ")"}]}]}], 
     ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["u", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]]}], "+", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            SqrtBox[
             RowBox[{"1", "+", 
              SuperscriptBox["u", "2"]}]]}], ")"}]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"5", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}], "+", 
             RowBox[{"2", " ", "u", " ", 
              SqrtBox[
               RowBox[{"1", "+", 
                SuperscriptBox["u", "2"]}]]}]}], ")"}]}]]}], ")"}]}]}]}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Hier ein Bild, in welches die berechneten Daten unmittelbar eingehen. Die \
Punkte sind so benannt, weil C und D Protected sind und deshalb nicht ohne \
weiteres f\[UDoubleDot]r Zuweisungen zur Verf\[UDoubleDot]gung stehen. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PA", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"PB", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], ";", 
  RowBox[{"PC", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "1"}], "}"}]}], ";", 
  RowBox[{"PP", "=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u0", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"txt1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<A\>\"", ",", 
        RowBox[{"PA", "+", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".1"}], ",", 
           RowBox[{"-", ".1"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<B\>\"", ",", 
        RowBox[{"PB", "+", 
         RowBox[{"{", 
          RowBox[{".1", ",", 
           RowBox[{"-", ".1"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<C\>\"", ",", 
        RowBox[{"PC", "+", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".1"}], "}"}]}]}], "]"}]}], "}"}], "/.", 
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"txt2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{"\"\<P\>\"", ",", "#"}], "]"}], ",", 
          RowBox[{"PP", "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "#"], 
            RowBox[{"{", 
             RowBox[{"0", ",", ".2"}], "}"}]}]}]}], "]"}], "/.", 
        RowBox[{
        "sol", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}]}], "/.",
        
       RowBox[{"u", "\[Rule]", "u0"}]}], ")"}], "&"}], "/@", 
    RowBox[{"Range", "[", "4", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{"PA", ",", "PB", ",", "PC", ",", "PA"}], "}"}], "]"}], "/.", 
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"PA", ",", "PP"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"PB", ",", "PP"}], "}"}]}], "}"}], "]"}], "/.", "sol"}], "/.",
     
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{"PC", ",", "PP"}], "}"}], "]"}], "/.", "sol"}], "/.", 
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Thick", ",", "l", ",", "Blue", ",", "w1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", "w2"}], "}"}], ",", "txt1", ",", 
    "txt2"}], "}"}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[Large], LineBox[{{0, 0}, {2, 0}, {0.2, 1}, {0, 0}}], 
    {RGBColor[0, 0, 1], 
     LineBox[{{{0, 0}, {0.48033893726057864`, 0.39378373539390643`}}, {{2, 
        0}, {0.48033893726057864`, 0.39378373539390643`}}}], 
     LineBox[{{{0, 0}, {2.5394649654579786`, 2.081863289499496}}, {{2, 0}, {
        2.5394649654579786`, 2.081863289499496}}}], 
     LineBox[{{{0, 0}, {1.5196610627394214`, -1.8536884951389763`}}, {{2, 
        0}, {1.5196610627394214`, -1.8536884951389763`}}}], 
     LineBox[{{{0, 0}, {-0.5394649654579785, 0.6580414702455737}}, {{2, 
        0}, {-0.5394649654579785, 0.6580414702455737}}}]}}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], 
    LineBox[{{0.2, 1}, {0.48033893726057864`, 0.39378373539390643`}}], 
    LineBox[{{0.2, 1}, {2.5394649654579786`, 2.081863289499496}}], 
    LineBox[{{0.2, 1}, {1.5196610627394214`, -1.8536884951389763`}}], 
    LineBox[{{0.2, 1}, {-0.5394649654579785, 0.6580414702455737}}]}, {
    InsetBox["\<\"A\"\>", {-0.1, -0.1}], InsetBox["\<\"B\"\>", {2.1, -0.1}], 
    InsetBox["\<\"C\"\>", {0.2, 1.1}]}, {InsetBox[
     SubscriptBox["\<\"P\"\>", 
      "1"], {0.48033893726057864`, 0.19378373539390642`}], InsetBox[
     SubscriptBox["\<\"P\"\>", 
      "2"], {2.5394649654579786`, 2.2818632894994964`}], InsetBox[
     SubscriptBox["\<\"P\"\>", 
      "3"], {1.5196610627394214`, -2.0536884951389762`}], InsetBox[
     SubscriptBox["\<\"P\"\>", 
      "4"], {-0.5394649654579785, 0.8580414702455736}]}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"whcon", "/.", "sol"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", "\[Equal]", 
       RowBox[{"2", "-", "\[ImaginaryI]"}]}], "||", 
      RowBox[{"u", "\[Equal]", 
       RowBox[{"2", "+", "\[ImaginaryI]"}]}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"4", " ", "u"}], "+", 
          RowBox[{"4", " ", "x1"}], "-", 
          RowBox[{"2", " ", "u", " ", "x1"}], "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"4", " ", "x1"}], "-", 
               RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"4", "-", 
               RowBox[{"4", " ", "x1"}], "+", 
               SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}], "||", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"4", " ", "u"}], "+", 
          RowBox[{"4", " ", "x1"}], "-", 
          RowBox[{"2", " ", "u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"4", " ", "x1"}], "-", 
               RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"4", "-", 
               RowBox[{"4", " ", "x1"}], "+", 
               SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}]}], 
     ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "1"}], "&&", 
    RowBox[{"x1", "\[Equal]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["2"]}]}], "||", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"1", "-", 
        SqrtBox["2"]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"1", "+", 
        SqrtBox["2"]}]}]}], ")"}], "&&", 
    RowBox[{"x2", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "-", 
      RowBox[{"4", " ", "u"}], "+", 
      SuperscriptBox["u", "2"]}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "-", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "-", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "+", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "+", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}]}], ")"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "u"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x2", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x1", "-", 
       RowBox[{"2", " ", "u", " ", "x1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x1", "2"]}], "+", 
       RowBox[{"u", " ", 
        SuperscriptBox["x1", "2"]}], "-", 
       SuperscriptBox["x1", "3"]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "u"}]]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", 
      RowBox[{"2", "-", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"4", " ", "u"}], "+", 
         RowBox[{"4", " ", "x1"}], "-", 
         RowBox[{"2", " ", "u", " ", "x1"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"4", " ", "x1"}], "-", 
              RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              RowBox[{"4", " ", "x1"}], "+", 
              SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", 
      RowBox[{"2", "-", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"4", " ", "u"}], "+", 
         RowBox[{"4", " ", "x1"}], "-", 
         RowBox[{"2", " ", "u", " ", "x1"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"4", " ", "x1"}], "-", 
              RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              RowBox[{"4", " ", "x1"}], "+", 
              SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", 
      RowBox[{"2", "+", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"4", " ", "u"}], "+", 
         RowBox[{"4", " ", "x1"}], "-", 
         RowBox[{"2", " ", "u", " ", "x1"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"4", " ", "x1"}], "-", 
              RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              RowBox[{"4", " ", "x1"}], "+", 
              SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", 
      RowBox[{"2", "+", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"4", " ", "u"}], "+", 
         RowBox[{"4", " ", "x1"}], "-", 
         RowBox[{"2", " ", "u", " ", "x1"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"4", " ", "x1"}], "-", 
              RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              RowBox[{"4", " ", "x1"}], "+", 
              SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", "1"}], ",", 
     RowBox[{"x1", "\[Rule]", "1"}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", "1"}], ",", 
     RowBox[{"x1", "\[Rule]", "1"}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", "1"}], ",", 
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"1", "-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"x2", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "\[Rule]", "1"}], ",", 
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"x2", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "-", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "-", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "+", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "+", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"sol1", ",", 
    RowBox[{
     RowBox[{"!", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"u", "/.", "#"}], ",", "u"}], "]"}]}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "-", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "-", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "+", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", "u"}], "+", 
            SuperscriptBox["u", "2"], "+", 
            SqrtBox[
             RowBox[{"5", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["u", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["u", "3"]}], "+", 
              SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x1", "-", 
        RowBox[{"2", " ", "u", " ", "x1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"whcon", "//.", "sol"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weitere Aufgabenstellungen", "Section"],

Cell[CellGroupData[{

Cell["Elimination von Variablen ", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"glsys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}], "+", "z"}], "\[Equal]", "a"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "b"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", "y", "+", 
       RowBox[{"7", "z"}]}], "\[Equal]", "c"}]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"glsys", ",", "z"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "a"}], "+", 
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}]}]}], "&&", 
  RowBox[{
   RowBox[{"11", " ", "x"}], "\[Equal]", 
   RowBox[{
    RowBox[{"7", " ", "a"}], "-", "c", "-", 
    RowBox[{"20", " ", "y"}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "19"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "a"}], "+", 
        RowBox[{"10", " ", "b"}], "+", "c"}], ")"}]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      FractionBox["1", "38"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", " ", "a"}], "-", 
        RowBox[{"11", " ", "b"}], "-", 
        RowBox[{"3", " ", "c"}]}], ")"}]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Eine Aufgabe aus der holl\[ADoubleDot]ndischen Mathematikolympiade (Quelle \
[Heck 1993]):\nWie gro\[SZ] ist ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "4"], "+", 
   SuperscriptBox["b", "4"], "+", 
   SuperscriptBox["c", "4"]}]], "Input"],
 ", wenn ",
 StyleBox["a",
  FontSlant->"Italic"],
 ",",
 StyleBox["b",
  FontSlant->"Italic"],
 " und ",
 StyleBox["c",
  FontSlant->"Italic"],
 " reelle Zahlen sind und folgende Annahmen gelten: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", "b", "+", "c"}], "\[Equal]", "3"}], ",", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[Equal]", "9", " "}]}]], "Input"],
 "sowie",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["b", "3"], "+", 
     SuperscriptBox["c", "3"]}], "\[Equal]", "24"}]}]], "Input"],
 "."
}], "SmallText",
 Background->None],

Cell[BoxData[{
 RowBox[{
  RowBox[{"glsys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "+", "b", "+", "c"}], "\[Equal]", "3"}], ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], "\[Equal]", "9"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       SuperscriptBox["b", "3"], "+", 
       SuperscriptBox["c", "3"]}], "\[Equal]", "24"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sum", "=", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox["b", "4"], "+", 
    SuperscriptBox["c", "4"]}]}], ";"}]}], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " produziert zwar riesige, aber von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leicht zu verarbeitende Menge von Wurzeltermen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"glsys", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"sum", "/.", "sol"}], "//", "Simplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"69", ",", "69", ",", "69", ",", "69", ",", "69", ",", "69"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dieser Zugang mit ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " transformiert zun\[ADoubleDot]chst in eine logisch gleichwertige Form: a \
als Nullstellen einer Gleichung vom Grad 3, zu jeder L\[ODoubleDot]sung f\
\[UDoubleDot]r a zwei Werte f\[UDoubleDot]r b als (bereits explizit \
berechnete) Nullstellen eines Polynoms vom Grad 2 und schlie\[SZ]lich zu \
jedem (a,b) ein aus einer linearen Formel zu berechnender Wert c. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"glsys", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}], ")"}], "&&",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", "a", "-", 
        RowBox[{
         SqrtBox["3"], " ", 
         SqrtBox[
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "a"}], "-", 
           SuperscriptBox["a", "2"]}]]}]}], ")"}]}]}], "||", 
    RowBox[{"b", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", "a", "+", 
        RowBox[{
         SqrtBox["3"], " ", 
         SqrtBox[
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "a"}], "-", 
           SuperscriptBox["a", "2"]}]]}]}], ")"}]}]}]}], ")"}], "&&", 
  RowBox[{"c", "\[Equal]", 
   RowBox[{"3", "-", "a", "-", "b"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Ein nachgeschaltetes Solve liefert eine L\[ODoubleDot]sung in \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"red", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"sum", "/.", "sol"}], "//", "Simplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"69", ",", "69", ",", "69", ",", "69", ",", "69", ",", "69"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["Das geht dagegen (noch) nicht.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"sum", ",", "red"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "4"], "+", 
  SuperscriptBox["b", "4"], "+", 
  SuperscriptBox["c", "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{"glsys", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sum", "/.", "sol"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "69.00000000000865`", ",", "68.99999999999937`", ",", "69.`", ",", 
   "69.00000000000001`", ",", "68.99999999999731`", ",", 
   "69.00000000000036`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Das sollte so eigentlich gar nicht gehen, denn die angegebene \
L\[ODoubleDot]sung gilt nicht f\[UDoubleDot]r beliebige Werte von (a,b,c), \
sondern nur f\[UDoubleDot]r 6 spezielle Tripel.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sys", "=", 
  RowBox[{"Append", "[", 
   RowBox[{"glsys", ",", 
    RowBox[{"x", "\[Equal]", "sum"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"sys", ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", "b", "+", "c"}], "\[Equal]", "3"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[Equal]", "9"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["b", "3"], "+", 
     SuperscriptBox["c", "3"]}], "\[Equal]", "24"}], ",", 
   RowBox[{"x", "\[Equal]", 
    RowBox[{
     SuperscriptBox["a", "4"], "+", 
     SuperscriptBox["b", "4"], "+", 
     SuperscriptBox["c", "4"]}]}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "69"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Union"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "69"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Auch das sollte eine leere L\[ODoubleDot]sungsmenge ergeben.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Reduce", "[", 
  RowBox[{"sys", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"c", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"c", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}], ")"}], "&&",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", "c", "-", 
        RowBox[{
         SqrtBox["3"], " ", 
         SqrtBox[
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}]]}]}], ")"}]}]}], "||", 
    RowBox[{"b", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", "c", "+", 
        RowBox[{
         SqrtBox["3"], " ", 
         SqrtBox[
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}]]}]}], ")"}]}]}]}], ")"}], "&&", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{"3", "-", "b", "-", "c"}]}], "&&", 
  RowBox[{"x", "\[Equal]", "69"}]}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "69"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Einzig diese (\[ADoubleDot]quivalenten) Kommandos reagieren \"wie es im Buche \
steht\".\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"sys", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "69"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "69"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nullstellen z\[ADoubleDot]hlen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    SuperscriptBox["x", "5"], "-", 
    RowBox[{"5", "x"}], "+", "1"}]}], ";"}], "\n", 
 RowBox[{"CountRoots", "[", 
  RowBox[{"p", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"p", "\[Equal]", "0"}], ",", "x"}], "]"}]}], "Input"],

Cell[BoxData["3"], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.5416516841045247`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.049456407933505434`"}], "-", 
      RowBox[{"1.4994413672391491`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.049456407933505434`"}], "+", 
      RowBox[{"1.4994413672391491`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.20006410262997537`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.4405003973415602`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"p", ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"p", ",", "Complexes"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], "-", 
        RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    SuperscriptBox["x", "5"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], "x"}], "+", "1"}]}], ";"}], "\n", 
 RowBox[{"CountRoots", "[", 
  RowBox[{"p", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"I", "+", "5"}]}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{
     RowBox[{"p", "\[Equal]", "0"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", "#", "]"}], ",", 
        RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{"x", "/.", "sol"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "LightBlue", ",", "v"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"PointSize", "[", "0.03", "]"}], ",", "u"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.87, 0.94, 1], EdgeForm[Thickness[Large]], 
    PolygonBox[{{0, 0}, {2, 0}, {2, 1}, {0, 1}, {0, 0}}]}, 
   {RGBColor[0, 0, 1], PointSize[0.03], 
    PointBox[{-1.1875715946694774`, -0.13679260696315576`}], 
    PointBox[{-0.2949190217822172, 1.1763870841192163`}], 
    PointBox[{6.774844109052275*^-17, -1.}], 
    PointBox[{0.47841559234963843`, -0.42659510275056084`}], 
    PointBox[{1.004075024102056, 0.3870006255945004}]}},
  Axes->True]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ungleichungen und Ungleichungssysteme", "Subsection"],

Cell[TextData[{
 "Die fr\[UDoubleDot]here Verwendung von ",
 StyleBox["InequalitySolve",
  FontWeight->"Bold"],
 " wird in der Version 6 vollst\[ADoubleDot]ndig von der Funktionalit\
\[ADoubleDot]t des Kommandos ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " abgedeckt. Mit algebraischen Ungleichungen und Ungleichungssystemen kommt \
",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " dabei ganz gut zurecht. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", 
   RowBox[{"Re", "[", "x", "]"}], "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Re", "[", "x", "]"}], "2"]}]]}], "<", 
   RowBox[{"Im", "[", "x", "]"}], "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Re", "[", "x", "]"}], "2"]}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "<", "x", "<", "1"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "<", "x", "<", "1"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", "x"}], ">", "2"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", 
   RowBox[{"-", "2"}]}], "||", 
  RowBox[{"x", ">", "1"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "5"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "-", "y"}], "\[LessEqual]", "1"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[LessEqual]", "2"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", 
     RowBox[{"5", "-", "x"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "2"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", ">", "2"}], "&"}], "/@", "polys"}], " ", ",", "vars"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[LessEqual]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}], "<", "y", "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", "x"}]]}]}], "||", 
      RowBox[{"y", ">", 
       SqrtBox[
        RowBox[{"2", "-", "x"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "<", "x", "<", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"y", ">", 
     SqrtBox[
      RowBox[{"2", "-", "x"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&",
     
    RowBox[{"y", ">", 
     RowBox[{"2", "-", 
      SuperscriptBox["x", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "<", "x", "\[LessEqual]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"y", ">", 
     SqrtBox[
      RowBox[{"2", "-", "x"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}], "<", "x", "\[LessEqual]", "2"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}], "<", "y", "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", "x"}]]}]}], "||", 
      RowBox[{"y", ">", 
       SqrtBox[
        RowBox[{"2", "-", "x"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "2"}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{"2", "-", 
      SuperscriptBox["x", "2"]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "-", "2"}], "&"}], "/@", "polys"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x", "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gb", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", ">", "2"}], "&"}], "/@", "polys"}], " ", ",", "vars"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[LessEqual]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}], "<", "y", "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", "x"}]]}]}], "||", 
      RowBox[{"y", ">", 
       SqrtBox[
        RowBox[{"2", "-", "x"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "<", "x", "<", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"y", ">", 
     SqrtBox[
      RowBox[{"2", "-", "x"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&",
     
    RowBox[{"y", ">", 
     RowBox[{"2", "-", 
      SuperscriptBox["x", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "<", "x", "\[LessEqual]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"y", ">", 
     SqrtBox[
      RowBox[{"2", "-", "x"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}], "<", "x", "\[LessEqual]", "2"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}], "<", "y", "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", "x"}]]}]}], "||", 
      RowBox[{"y", ">", 
       SqrtBox[
        RowBox[{"2", "-", "x"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "2"}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{"2", "-", 
      SuperscriptBox["x", "2"]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "3"], "+", "x"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", ">", "2"}], "&"}], "/@", "polys"}], " ", ",", "vars"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[LessEqual]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"6", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", "x", "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"6", "+", 
         RowBox[{"7", " ", "#1"}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], "<", "x", 
     "\[LessEqual]", "1"}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{"2", "-", 
      SuperscriptBox["x", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "1"}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", "x", "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "-", "2"}], "&"}], "/@", "polys"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "6"}], "-", "x", "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "6"]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"gb", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit trigonometrischen Ungleichungen und anderen komplizierteren Fragen kann \
",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " dagegen oft (noch) nichts anfangen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[GreaterEqual]", 
    FractionBox["1", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"This system cannot be solved with the methods available to \
Reduce.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[GreaterEqual]", 
    FractionBox["1", "2"]}], ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], ">", "0"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"This system cannot be solved with the methods available to \
Reduce.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], ">", "0"}], ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], ">", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], "+", 
    FractionBox["x", "\[Pi]"]}], "\[NotElement]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", 
      RowBox[{"4", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}], "<", "x", "<", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Gleichungen \[UDoubleDot]ber anderen Grundbereichen l\[ODoubleDot]sen\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Gleichungen \[UDoubleDot]ber den reellen Zahlen\
\>", "Subsubsection"],

Cell[TextData[{
 "Nach den Ausf\[UDoubleDot]hrungen im vorigen Punkt ist klar, dass ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " in der Lage ist, die reellen L\[ODoubleDot]sungen von Gleichungen und \
Gleichungssystemen zu finden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "3"], "+", "x"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "||", 
    RowBox[{"x", "\[Equal]", "0"}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "#1"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "#1"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}]}], ")"}], "&&",
   
  RowBox[{"y", "\[Equal]", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.288794992188485`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.660992531890119`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.3390928377617097`"}], "+", 
       RowBox[{"0.44663009999752257`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.5936911819209169`"}], "+", 
       RowBox[{"1.1961583360709527`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.3390928377617097`"}], "-", 
       RowBox[{"0.44663009999752257`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.5936911819209169`"}], "-", 
       RowBox[{"1.1961583360709527`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.9999999999999998`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.389390683334934`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8483748957319533`"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "6"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"gb", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData["2"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "#1"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "#1"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "//.", "sol"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "#1"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "#1"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             SuperscriptBox["#1", "3"], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "2"]}], 
       "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "#1"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             SuperscriptBox["#1", "3"], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "4"]}], 
       "-", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "#1"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "6"]}], 
      "\[Equal]", "1"}], ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "#1"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "#1"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             SuperscriptBox["#1", "3"], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}], 
       "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "#1"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             SuperscriptBox["#1", "3"], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "4"]}], 
       "-", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "#1"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "6"]}], 
      "\[Equal]", "1"}], ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Zwei Einheitskreise mit Mittenabstand u schneiden sich. ", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"x", ",", "y", ",", "u"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "u"}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "\[LessEqual]", "u", "<", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     FractionBox["u", "2"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["u", "2"], "+", 
          RowBox[{"2", " ", "u", " ", "x"}], "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"], "+", 
         RowBox[{"2", " ", "u", " ", "x"}], "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "u", "\[LessEqual]", "2"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     FractionBox["u", "2"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["u", "2"], "+", 
          RowBox[{"2", " ", "u", " ", "x"}], "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"], "+", 
         RowBox[{"2", " ", "u", " ", "x"}], "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["Dasselbe mit variablen Radien.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", 
      SuperscriptBox["r1", "2"]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "u"}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", 
      SuperscriptBox["r2", "2"]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", ">", "0"}], ",", 
       RowBox[{"r1", ">", "0"}], ",", 
       RowBox[{"r2", ">", "0"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", ">", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0", "<", "r2", "<", "u"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "r2"}], "+", "u"}], "\[LessEqual]", "r1", "\[LessEqual]",
        
       RowBox[{"r2", "+", "u"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["r1", "2"], "-", 
         SuperscriptBox["r2", "2"], "+", 
         SuperscriptBox["u", "2"]}], 
        RowBox[{"2", " ", "u"}]]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["r2", "2"], "-", 
            SuperscriptBox["u", "2"], "+", 
            RowBox[{"2", " ", "u", " ", "x"}], "-", 
            SuperscriptBox["x", "2"]}]]}]}], "||", 
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["r2", "2"], "-", 
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"2", " ", "u", " ", "x"}], "-", 
           SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"r2", "\[Equal]", "u"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "r2"}], "+", "u"}], "<", "r1", "\[LessEqual]", 
       RowBox[{"r2", "+", "u"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["r1", "2"], "-", 
         SuperscriptBox["r2", "2"], "+", 
         SuperscriptBox["u", "2"]}], 
        RowBox[{"2", " ", "u"}]]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["r2", "2"], "-", 
            SuperscriptBox["u", "2"], "+", 
            RowBox[{"2", " ", "u", " ", "x"}], "-", 
            SuperscriptBox["x", "2"]}]]}]}], "||", 
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["r2", "2"], "-", 
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"2", " ", "u", " ", "x"}], "-", 
           SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"r2", ">", "u"}], "&&", 
      RowBox[{
       RowBox[{"r2", "-", "u"}], "\[LessEqual]", "r1", "\[LessEqual]", 
       RowBox[{"r2", "+", "u"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["r1", "2"], "-", 
         SuperscriptBox["r2", "2"], "+", 
         SuperscriptBox["u", "2"]}], 
        RowBox[{"2", " ", "u"}]]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["r2", "2"], "-", 
            SuperscriptBox["u", "2"], "+", 
            RowBox[{"2", " ", "u", " ", "x"}], "-", 
            SuperscriptBox["x", "2"]}]]}]}], "||", 
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["r2", "2"], "-", 
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"2", " ", "u", " ", "x"}], "-", 
           SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", ">", "0"}], ",", 
       RowBox[{"r1", ">", "r2", ">", "0"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r2", ">", "0"}], "&&", 
  RowBox[{"r1", ">", "r2"}], "&&", 
  RowBox[{
   RowBox[{"r1", "-", "r2"}], "\[LessEqual]", "u", "\[LessEqual]", 
   RowBox[{"r1", "+", "r2"}]}], "&&", 
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["r1", "2"], "-", 
     SuperscriptBox["r2", "2"], "+", 
     SuperscriptBox["u", "2"]}], 
    RowBox[{"2", " ", "u"}]]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["r2", "2"], "-", 
        SuperscriptBox["u", "2"], "+", 
        RowBox[{"2", " ", "u", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["r2", "2"], "-", 
       SuperscriptBox["u", "2"], "+", 
       RowBox[{"2", " ", "u", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "u"}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "\[LessEqual]", "u", "<", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["u", "2"]}], "+", 
         SuperscriptBox["u", "4"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "u"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["u", "2"], "+", 
          RowBox[{"2", " ", "u", " ", "x"}], "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"], "+", 
         RowBox[{"2", " ", "u", " ", "x"}], "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "2"}], "]"}], "<", "u", "<",
      "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"-", "1"}]}], "&&", 
        RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", "0"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", "1"}]}], "||", 
          RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "u", "<", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["u", "2"]}], "+", 
             SuperscriptBox["u", "4"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "u"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", "u", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}]}], "&&",
         
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"2", " ", "u", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}]}], "||", 
          RowBox[{"y", "\[Equal]", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "3"}], "]"}], "<", "u", 
     "\[LessEqual]", "2"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["u", "2"]}], "+", 
         SuperscriptBox["u", "4"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "u"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "3"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["u", "2"], "+", 
          RowBox[{"2", " ", "u", " ", "x"}], "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"], "+", 
         RowBox[{"2", " ", "u", " ", "x"}], "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"18", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"10", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"6", 
     SuperscriptBox["x", "6"]}], "+", 
    SuperscriptBox["x", "8"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "-", 
      RowBox[{"18", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["#1", "6"]}], "+", 
      SuperscriptBox["#1", "8"]}], "&"}], ",", "2"}], "]"}], "//", 
  "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "0.3440219262237548`"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Reduce", "[", 
       RowBox[{
        RowBox[{"polys", "/.", 
         RowBox[{"u", "->", "i"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
      "ToRules"}], "}"}], "//", "Length"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "2", ",", "6", ",", "6", ",", "6", ",", "4", ",", "6", ",", "6", 
   ",", "6", ",", "2", ",", "2"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"polys", "/.", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"-", ".1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.988780273020509`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.4583335317097468`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.1082925845069157`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.9999656159299656`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.09378102069273174`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.9999806619612077`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.09378102069273547`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.999980661961208`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.10829258450691097`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.9999656159299658`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.9908538782202068`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.435846513841821`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.9908538782202068`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.435846513841821`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.9887802730205598`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.458333531709709`"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "u_", "]"}], ":=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "+", 
        RowBox[{"Sin", "[", "a", "]"}]}], ",", 
       RowBox[{"Cos", "[", "a", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", 
        RowBox[{"-", "0.1"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.2"}], ",", "1.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None"}], 
         "}"}]}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", 
        RowBox[{"-", "0.1"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.97"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.44", ",", "0.47"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.44", ",", "0.45", ",", "0.46", ",", "0.47"}], "}"}], 
          ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", ".98"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", 
        RowBox[{"-", "0.1"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".15"}], ",", 
          RowBox[{"-", "0.05"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".9995", ",", "1.0002"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.9995", ",", "0.9997", ",", "0.9999", ",", "1.0001"}], 
           "}"}], ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".14"}], ",", 
            RowBox[{"-", ".07"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}], "}"}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXtwTncax1NMuy47s7rrUmpGldZaUWnXVofdx9TWpYpi2SqqCLKV1NKN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        "], {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          TagBox[
           TooltipBox[LineBox[CompressedData["
1:eJwl1WV7EAQUBeCN7u4e3TBijIYxukf3go6NwUZ3jBi9gYISSiihhJK2hEka
oKCELaGkAYrvHj+85/6Cc25QdFxEbGBAQMA6kXbTkZ4MZCQTmclCVrKRnRzk
JBe5yUNe8pGfAhSkEIUpQlGKUZwSlKQUpSlDEGUpR3kqUJFKVKYKValGdWpQ
k1rUJpg61KUe9QmhAaE0pBGNaUJTmtGcFrQkjFaE05o2tKUd7elARzrRmS50
pRvdiaAHPelFb/rQl370ZwADGcRghhBJFNHEMJRhDGcEIxnFaMYwlnHEEsd4
4pnARBJIZBKTmcJUpjGdGcxkFrOZw1zmMZ8FLCSJRSxmCUtJZhnLWcFKVrGa
NaSQylrW8QzPsp4NPMfzbGQTm9nCC7zIVraxnR28xMvsZBe72cMrvMpe9rGf
A7zG6xzkEIc5wlGO8QZv8hZv8w7v8h7vc5wTnOQUH/AhH/Exn/AppznDWc5x
ngt8xud8wZdc5BJf8TWXucI3fMtVrnGdG3zH9/zAj/zEz/zCr9zkFre5w2/8
zl3ucZ8HPOQRf/Anf/E3j3nCP/zLU9LKH0g60pOBjGQiM1nISjayk4Oc5CI3
echLPvJTgIIUojBFKEoxilOCkpSiNGUIoizlKE8FKlKJylShKtWoTg1qUova
BFOHutSjPiE0IJSGNKIxTWhKM5rTgpaE0YpwWtOGtrSjPR3oSCc604WudKM7
EfSgJ73oTR/60o/+DGAggxjMECKJIpoYhjKM4YxgJKMYzRjGMo608Y5jPPFM
YCIJJDKJyUxhKtOYzgxmMovZzGEu85jPAhaSxCIWs4SlJLOM5axgJatYzRpS
SGVt4P9/5T/zNK6f
             "]],
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "4"], "+", 
                SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
           
           Annotation[#, $CellContext`x^4 + $CellContext`y^4 == 1, 
            "Tooltip"]& ]}}], {{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd23c8le/7AHDS0FBWaUfJqKysCl3RJBklVCJJSTKLiIySlJBNMrJFkT0v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          "]]}}},
      AspectRatio->1,
      Frame->True,
      FrameTicks->{{Automatic, None}, {{{-1, 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}}, None}},
      PlotRange->{{-1.2, 1.1}, {-1.1, 1.1}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXtwTncax1NMuy47s7rrUmpGldZaUWnXVofdx9TWpYpi2SqqCLKV1NKN
XhajBqtUkBK3VlWnumtd2lCXleSp6NKKS4WJS8Qtl5LEe2JtqZKxb87v+Zzs
e/LPOyfenPM7z+/7fD/f5+ehsZMHj68TFxeXcU9cXM1n2m/njP28T6a0GXff
6mt3PY3zfz7Lcp9Vur5t3/S2fTP17t2vD1VF/71xVfK5FdHr9Hl/zaj5fr/c
vafefSZXkx9d27hF9Hq1//1crZd9YvkD0eutx88NzX0uV7sta7G4efS6Rd+6
fdaPyNO0xHaFb932tHhHSuGOlDzddndlXufodaPEuwsfm5WnO5YVHh8Tvd5w
uHh6ecd8nf+H/t9fuuZphn//fO39bb9Rq6LXyZGiivwJ+dpkTZfj7aPX5asP
3yxbUaArm765rvs5T/9Vc/vCAt1SvetG8RlP/zvhm5Zl7U7quLrvHN4XvX4u
veaGp/VXRxo+Pe9QdP3VXd/9z+LTOvxg6rmBBz19Ku+FB/OunNH4BamtG+R4
et5fb6EmHRmY1HynpzMbvLy8Xv2zmlBw78PDMz1dp1sHfFKvSJtPnV5VssHT
qTXf3lGkrRL2qaz1tPC9zJmSfk4PPTz7Zv90TxMWdL69pMl5bfbMyhlfL/C0
jl/3CxrZtqTl3OmePhk/q+fzKRf0rP9cT9e8vj7n74su6KDSGalN/+TpwF7D
OqWvvKDbdv/jWMrE6H7473NRKwo2ZtQZ4GnWxe0L8uZf1PbZk37YIJ6eKGk/
8fqti/rG5tsX13bwdJlfz0s6xd8wT+Of7jYvK6lYd/qvGdE5iRnXc5KL9aWW
9Y6mnolokb+OYi1s28h7Knp9KrN+l4mTizVriozKPh3RR2pul16igz/u1jwy
N6JfLXk9pXWjUm3+yI2UjDERHV/3bzk/di7Vzcv/ed+ioRGd7NenVIctvrV2
eJuItn+plZf2VZm+6v/+qg7tXtx95Ikybbgx5/o3W6/qLn9dZVp1oPsndTdd
1UnNkqp3V5XpnoQOjy7+6Kr2rf/F+WmDLmvK4N71viyu1Eb5A1qOPH1Z2/nr
qtRn/fpc0efn9V/+2uhKfax+0xUHN13RvfGjf+l9X6Hv+fUo1/xtDT/Nn16h
rSv79u75YrnVv0JfWXqklVwuDz75Pd/j77gP9+U5PJd1sC7Wybp5D96L91yd
Mm7puk21dRhZkpJY57OrumFa+uZlJ2rrRh2pK3Wm7uwD+8I+Fce1Gtpnfu0+
pua+9ecmayJa+kHCuapBJVqQnfnFieg+50zIODtwcq0O0EXjtIVJM6LXT55s
tWh/cq2O0BU6Q3foEF2iU3SLjtE1Okf39AF9QZ/QN/QRfUWf0Xf0IX1557WW
qcvX1PYtfUxf0+f0PT6ALxQVHHrw/ixPVyXe16Sw9EzgM/jOzGb7k0+erfUl
fArfwsfwNXwO38MH8UV8Et/87s6ceVP+z1fxWXwXH8aX8Wl8Gx/H1/F5fP9Y
zXKi13ABbmxxHFG4AUfgxmz3feF+1zz/fsLzurnnCetZ4NYjrPdDt17hfRq4
9xHe97h7X6Eed8b59RDqtdbVS6hnmqunUO9EV29hPy65/RD2K9Ptl7CflW4/
hf1e6vZb0MNJpwdBL6lOL4KeVjk9SbXp7RWnN0GP+U6Pgl47OL0Ker5zt+bn
vKD33zi9C/2wwvWDBFxw/SKV1k+9XT8J/bbL9Zu8af141PWjTLV+XeL6Vejn
Tq6f5X7r91+7fpci84PTzg/klPnFLucXMs385JLzEykxv2nj/EZamh/lOD+S
LeZXY51fyR/NzyY5P5NOuwuPd743oh39zzIJ+Z+MMn/82PmjvG/+ud35p6j5
6zjnr7LwZ+O/XP6Lq1rt1/c7edX8uJfzYwn5tQwxP+/l/Fz2md/HO7+XAuPB
YscDgRcPOV7IrGMjGlcXl+t09yntjCOn3PckxCNJMI6oe46EeCaNjSOunpXy
rHFkknsPmWgcyXbvLXDEuCKfGkdGuLpJR+NIsqurdHZ11nhXdwnxWybE8l1y
jSsPuH0VuGKckTLjinFGsowrJ51uBK6cdbqSrsYV44w8blxx7RaRUJ6R/Ni8
I9mxeUhCeUkGxOYpeT82b8nvjCuFru8klNfkidg8J6dj856E8qB8FJsXZUZs
npRQ3hS4Yr4j12PzrITyroTysLT3639CB/a4Z3fksieh/CyhfC2h/C2hfC6h
/C6hfC85/nr26xtjDk07XO1JaB6Q0LwgoXlCQvOGwB3jkMAd45CE5heBO8Yh
gTvcL89f/x7xyxu9hkM8Hw6xPjjE+uEQ7wuHqAccol4/+L5yVA706HEj7aYn
cIn6wiXqD5fYH7jEfsIl9rvCuIQefu/mG7H5RuAU+oFT6Osvxin0t9o4hT7h
lHFLvjVOHTZ9dzROoX84RX9Y/wj9s9I4RX/1NU5tt/6DU7c+yP9310Ge7DZO
0b9HjFPGLYFTxi15wjiFP3QxThm3BE4Zt2Snccq4JcXGKeOWwKlS868s45Rx
K1p3xynjlsCpF8wfzU8FPx3i5hux+UbgknFKRhuX9ppf9zEO2ZyA3wt+D4eM
S9LJOGRziMAh4xK8EXgz0zjEJ7//sFn+xiF9yoP7cF+ew3NZB+tinayb9+C9
eE/emzpQF+pE3agjdaXO1J19YF+GuDk02LccN6fKMTe3BvuODka7OVdmu7k3
0A06QlfoDN2hQ3SJTtEtOkbX6Bzd0wf0BX1C39BH9BV9Rt/Rh3CFPqVv6WP6
mj6n7/EBO+eQx925h7zozkFkiTsXCXwEX8Fn8B18CF/Cp/AtfAxfw+fwPXwQ
X8Q38VF8FZ/Fd/FhfBmfxrfxcXwdn4cDcAFOwA04EppnAg7x93CK+8Mxng/n
WB8cZP1wk/eDq7w/3KU+cJn6wW3qC9epPzmA/SEnsH/kCLhAzkAf5BD0Q05B
X+QY9EfOIfeQg9AvOQl9k6NC+g9yFzmMXEZOI7eR4+g/ch65jxxILiQn0t/k
SDvnkrl27kXuJIdmm38U2LmXnXMFuZacS+4lB5OLycnk5pC/aQPzv2F27mXn
XEFOJ7eT48n15PyQ/wZzAXNCVWbJz5N+rJAxaWve7vn5Fd3db8tPWx+okMzF
P3l5j3clmDOYO/B/5pIkd+4lyXb+xRzDXBPiSzAHMReF+BTMUcxVzFnMXcxl
zGkhPupg40QjOx9k7mMOhBPMjWNj+RzMmcydcMK4ofnGCeOGhvKCvm2cMG4E
czFzciiPBHM1c/au2DwTzOXM6cztzPErYvNSMPdzDhDKW8G5AecInCtwzgAn
OJ9eFZv3gnMLzjFCeVETjBOcjy81Thg3NJQ/g3MTzlFC+VVD+VZD+VdD+VhD
+VlDeVtDeVxDeV1DeV5DeV9D84CG5ofgXItzsfD/p/wPOMpGyA==
        "], {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          TagBox[
           TooltipBox[LineBox[CompressedData["
1:eJwl1WV7EAQUBeCN7u4e3TBijIYxukf3go6NwUZ3jBi9gYISSiihhJK2hEka
oKCELaGkAYrvHj+85/6Cc25QdFxEbGBAQMA6kXbTkZ4MZCQTmclCVrKRnRzk
JBe5yUNe8pGfAhSkEIUpQlGKUZwSlKQUpSlDEGUpR3kqUJFKVKYKValGdWpQ
k1rUJpg61KUe9QmhAaE0pBGNaUJTmtGcFrQkjFaE05o2tKUd7elARzrRmS50
pRvdiaAHPelFb/rQl370ZwADGcRghhBJFNHEMJRhDGcEIxnFaMYwlnHEEsd4
4pnARBJIZBKTmcJUpjGdGcxkFrOZw1zmMZ8FLCSJRSxmCUtJZhnLWcFKVrGa
NaSQylrW8QzPsp4NPMfzbGQTm9nCC7zIVraxnR28xMvsZBe72cMrvMpe9rGf
A7zG6xzkEIc5wlGO8QZv8hZv8w7v8h7vc5wTnOQUH/AhH/Exn/AppznDWc5x
ngt8xud8wZdc5BJf8TWXucI3fMtVrnGdG3zH9/zAj/zEz/zCr9zkFre5w2/8
zl3ucZ8HPOQRf/Anf/E3j3nCP/zLU9LKH0g60pOBjGQiM1nISjayk4Oc5CI3
echLPvJTgIIUojBFKEoxilOCkpSiNGUIoizlKE8FKlKJylShKtWoTg1qUova
BFOHutSjPiE0IJSGNKIxTWhKM5rTgpaE0YpwWtOGtrSjPR3oSCc604WudKM7
EfSgJ73oTR/60o/+DGAggxjMECKJIpoYhjKM4YxgJKMYzRjGMo608Y5jPPFM
YCIJJDKJyUxhKtOYzgxmMovZzGEu85jPAhaSxCIWs4SlJLOM5axgJatYzRpS
SGVt4P9/5T/zNK6f
             "]],
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "4"], "+", 
                SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
           
           Annotation[#, $CellContext`x^4 + $CellContext`y^4 == 1, 
            "Tooltip"]& ]}}], {{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd23c8le/7AHDS0FBWaUfJqKysCl3RJBklVCJJSTKLiIySlJBNMrJFkT0v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          "]]}}},
      AspectRatio->1,
      Frame->True,
      FrameTicks->{{{{0.44, 
           FormBox["0.44`", TraditionalForm]}, {0.45, 
           FormBox["0.45`", TraditionalForm]}, {0.46, 
           FormBox["0.46`", TraditionalForm]}, {0.47, 
           FormBox["0.47`", TraditionalForm]}}, None}, {{{-1, 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {-0.98, 
           FormBox[
            RowBox[{"-", "0.98`"}], TraditionalForm]}}, None}},
      PlotRange->{{-1, -0.97}, {0.44, 0.47}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXtwTncax1NMuy47s7rrUmpGldZaUWnXVofdx9TWpYpi2SqqCLKV1NKN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        "], {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          TagBox[
           TooltipBox[LineBox[CompressedData["
1:eJwl1WV7EAQUBeCN7u4e3TBijIYxukf3go6NwUZ3jBi9gYISSiihhJK2hEka
oKCELaGkAYrvHj+85/6Cc25QdFxEbGBAQMA6kXbTkZ4MZCQTmclCVrKRnRzk
JBe5yUNe8pGfAhSkEIUpQlGKUZwSlKQUpSlDEGUpR3kqUJFKVKYKValGdWpQ
k1rUJpg61KUe9QmhAaE0pBGNaUJTmtGcFrQkjFaE05o2tKUd7elARzrRmS50
pRvdiaAHPelFb/rQl370ZwADGcRghhBJFNHEMJRhDGcEIxnFaMYwlnHEEsd4
4pnARBJIZBKTmcJUpjGdGcxkFrOZw1zmMZ8FLCSJRSxmCUtJZhnLWcFKVrGa
NaSQylrW8QzPsp4NPMfzbGQTm9nCC7zIVraxnR28xMvsZBe72cMrvMpe9rGf
A7zG6xzkEIc5wlGO8QZv8hZv8w7v8h7vc5wTnOQUH/AhH/Exn/AppznDWc5x
ngt8xud8wZdc5BJf8TWXucI3fMtVrnGdG3zH9/zAj/zEz/zCr9zkFre5w2/8
zl3ucZ8HPOQRf/Anf/E3j3nCP/zLU9LKH0g60pOBjGQiM1nISjayk4Oc5CI3
echLPvJTgIIUojBFKEoxilOCkpSiNGUIoizlKE8FKlKJylShKtWoTg1qUova
BFOHutSjPiE0IJSGNKIxTWhKM5rTgpaE0YpwWtOGtrSjPR3oSCc604WudKM7
EfSgJ73oTR/60o/+DGAggxjMECKJIpoYhjKM4YxgJKMYzRjGMo608Y5jPPFM
YCIJJDKJyUxhKtOYzgxmMovZzGEu85jPAhaSxCIWs4SlJLOM5axgJatYzRpS
SGVt4P9/5T/zNK6f
             "]],
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "4"], "+", 
                SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
           
           Annotation[#, $CellContext`x^4 + $CellContext`y^4 == 1, 
            "Tooltip"]& ]}}], {{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd23c8le/7AHDS0FBWaUfJqKysCl3RJBklVCJJSTKLiIySlJBNMrJFkT0v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          "]]}}},
      AspectRatio->1,
      Frame->True,
      FrameTicks->{{{{0.9995, 
           FormBox["0.9995`", TraditionalForm]}, {0.9997, 
           FormBox["0.9997`", TraditionalForm]}, {0.9999, 
           FormBox["0.9999`", TraditionalForm]}, {1.0001, 
           FormBox["1.0001`", TraditionalForm]}}, None}, {{{-0.14, 
           FormBox[
            RowBox[{"-", "0.14`"}], TraditionalForm]}, {-0.07, 
           FormBox[
            RowBox[{"-", "0.07`"}], TraditionalForm]}}, None}},
      PlotRange->{{-0.15, -0.05}, {0.9995, 1.0002}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "->", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"DefaultDuration", "->", "10"}], ",", 
   RowBox[{"AnimationDirection", "->", "ForwardBackward"}]}], "]"}]], "Input"],

Cell["\<\
Noch einmal die Sache mit den Winkelhalbierenden.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"u", ",", "x1", ",", "x2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whpolys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "-", 
      RowBox[{"4", " ", "x1"}], "+", 
      SuperscriptBox["x1", "2"], "-", 
      RowBox[{"8", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x2"}], "+", 
      RowBox[{"4", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
      SuperscriptBox["x2", "2"]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"2", " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x1", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x1", "2"]}], "-", 
      RowBox[{"4", " ", "x2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["u", "2"], " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "3"], " ", "x2"}], "+", 
      RowBox[{"2", " ", "x1", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1", " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x2", "2"]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x2", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whcon", "=", 
   RowBox[{
    SuperscriptBox["x1", "2"], "-", 
    RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", "\[Equal]", 
       RowBox[{"2", "-", "\[ImaginaryI]"}]}], "||", 
      RowBox[{"u", "\[Equal]", 
       RowBox[{"2", "+", "\[ImaginaryI]"}]}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"4", " ", "u"}], "+", 
          RowBox[{"4", " ", "x1"}], "-", 
          RowBox[{"2", " ", "u", " ", "x1"}], "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"4", " ", "x1"}], "-", 
               RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"4", "-", 
               RowBox[{"4", " ", "x1"}], "+", 
               SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}], "||", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"4", " ", "u"}], "+", 
          RowBox[{"4", " ", "x1"}], "-", 
          RowBox[{"2", " ", "u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"4", " ", "x1"}], "-", 
               RowBox[{"2", " ", "u", " ", "x1"}]}], ")"}], "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"4", "-", 
               RowBox[{"4", " ", "x1"}], "+", 
               SuperscriptBox["x1", "2"]}], ")"}]}]}]]}], ")"}]}]}]}], 
     ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "1"}], "&&", 
    RowBox[{"x1", "\[Equal]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["2"]}]}], "||", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"1", "-", 
        SqrtBox["2"]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"1", "+", 
        SqrtBox["2"]}]}]}], ")"}], "&&", 
    RowBox[{"x2", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "-", 
      RowBox[{"4", " ", "u"}], "+", 
      SuperscriptBox["u", "2"]}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "-", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "-", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "+", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}], "||", 
      RowBox[{"x1", "\[Equal]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           SqrtBox[
            RowBox[{"3", "-", 
             RowBox[{"2", " ", "u"}], "+", 
             SuperscriptBox["u", "2"], "+", 
             SqrtBox[
              RowBox[{"5", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["u", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["u", "3"]}], "+", 
               SuperscriptBox["u", "4"]}]]}]]}]}], ")"}]}]}]}], ")"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "u"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x2", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x1", "-", 
       RowBox[{"2", " ", "u", " ", "x1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x1", "2"]}], "+", 
       RowBox[{"u", " ", 
        SuperscriptBox["x1", "2"]}], "-", 
       SuperscriptBox["x1", "3"]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "u"}]]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "<", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "-", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}]}], ")"}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", "\[Equal]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"1", "-", 
          SqrtBox["2"]}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox["2"], "+", 
          SqrtBox[
           RowBox[{"8", "-", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SqrtBox["2"]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                SqrtBox["2"]}], ")"}], "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", "1"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x2", "\[Equal]", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            SqrtBox["2"]}]}], "||", 
          RowBox[{"x2", "\[Equal]", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"1", "+", 
          SqrtBox["2"]}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["2"], "+", 
          SqrtBox[
           RowBox[{"8", "-", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SqrtBox["2"]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SqrtBox["2"]}], ")"}], "2"]}]}]]}]}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"u", ">", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "-", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
        RowBox[{"x2", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"2", " ", "u"}], "+", 
          RowBox[{"2", " ", "x1"}], "-", 
          RowBox[{"u", " ", "x1"}], "+", 
          SqrtBox[
           RowBox[{"20", "-", 
            RowBox[{"16", " ", "u"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"20", " ", "x1"}], "+", 
            RowBox[{"16", " ", "u", " ", "x1"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["u", "2"], " ", "x1"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["x1", "2"]}], "-", 
            RowBox[{"4", " ", "u", " ", 
             SuperscriptBox["x1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"whpolys", "\[Equal]", "0"}], "&&", 
     RowBox[{"u", "<", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "<", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "+", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "+", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "-", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "+", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ToRules", "[", 
    RowBox[{
     RowBox[{"u", "<", "1"}], "&&", 
     RowBox[{"x1", "\[Equal]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
     RowBox[{"x2", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "+", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "]"}], ",", 
   RowBox[{"ToRules", "[", 
    RowBox[{
     RowBox[{"u", "<", "1"}], "&&", 
     RowBox[{"x1", "\[Equal]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
     RowBox[{"x2", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "+", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "]"}], ",", 
   RowBox[{"ToRules", "[", 
    RowBox[{
     RowBox[{"u", "<", "1"}], "&&", 
     RowBox[{"x1", "\[Equal]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
     RowBox[{"x2", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "-", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "]"}], ",", 
   RowBox[{"ToRules", "[", 
    RowBox[{
     RowBox[{"u", "<", "1"}], "&&", 
     RowBox[{"x1", "\[Equal]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
     RowBox[{"x2", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "+", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"red", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "//",
     "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "+", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "+", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "-", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", "u"}], "+", 
       RowBox[{"2", " ", "x1"}], "-", 
       RowBox[{"u", " ", "x1"}], "+", 
       SqrtBox[
        RowBox[{"20", "-", 
         RowBox[{"16", " ", "u"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"]}], "-", 
         RowBox[{"20", " ", "x1"}], "+", 
         RowBox[{"16", " ", "u", " ", "x1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "2"], " ", "x1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x1", "2"]}], "-", 
         RowBox[{"4", " ", "u", " ", 
          SuperscriptBox["x1", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          SuperscriptBox["x1", "2"]}]}]]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"whcon", "//.", "sol"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "2"]}]}], 
     ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}]}], 
     ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{"8", "-", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "2"]}]}], 
     ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], "2"]}]}], 
     ")"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"whcon", "//.", "sol"}], ",", 
    RowBox[{"u", "<", "1"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "2"]}]}], 
     ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}]}], 
     ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{"8", "-", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "2"]}]}], 
     ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"2", " ", "u"}], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
            ")"}], "2"]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "u"}], ")"}], " ", "u"}], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "u"}], ")"}], " ", "u"}]}], ")"}], 
            " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Root", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                   SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
              ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "u"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"4", " ", "u"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "u"}], "-", 
               SuperscriptBox["u", "2"]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], "2"]}]}], 
     ")"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "/.", 
  RowBox[{"u", "\[Rule]", "0.3"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8.881784197001252`*^-15"}], ",", 
   RowBox[{"-", "2.6645352591003757`*^-15"}], ",", "7.105427357601002`*^-15", 
   ",", "1.4210854715202004`*^-14"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"res", "+", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFlQtMU2cYhstNhSngBR2jNXJTFFTYoHVq8zOUTeSiEkFmBwibLgMR0qwD
qcHOEcVlE8VL8JJCBBVEEQTH6sCf62AExq1yK4O2tHBabEsUaukaULK/305y
0jx53//93u+c5NQ1MTXyuCWNRkt8fy/+bkNr1QsLOryBtnhNo8gLnWWfxOuw
YGHx0qH0ruyUb19oQReLP1A3JGiAM9rZZ00vXmEaYUZ96hoW/X9WOX20oujM
FA4kec+Sm20c/lHjQKLbmYyZM9vVkHfsF7/poXMqXE/8j3Kja8NkFK6f/48N
efwcjCjw/93t01N2eRK4yH7UOV82AXxnvx+376ISOJcTwstSKSD/3MmEjM0h
CugzX2NjCL89Dsy3epjO1chhH23D7giPUDnoCYIuj/4SGeT/KxyOE9nKwH+9
Tpl/J0mKpWQed6tR+Jo/BvrzMa/lj9xGIU+b7r9JIB3BjoTdHQODDgsl0DeJ
8U20y2fDoD/dkpMkHx8EfaylcgOT2Q+ceLqoNFMvhnlKn+sf49/6gPlRBdV6
Ti8uJP6VWaXMbRY9kL/J2bWTxu8C9mHqfO696YB9YtjarO3Mdtj/p72ablFG
K54melhHZ4VtWzP4nQ6XX/5yXSP2Jf5TB67k123GuILoT/UtDm0ez6FfEPer
ZGFVNcy/J1H+qsouh7wtlsaqZE4xXkb02EP0asnX17AXYYHYS+zSxAZdZMd/
2ci7isz5f1XF7628WIzM+QFyi/U/xjwBvSAtrpldUw26+/QfczsbRcicd/R2
zf6Tn2Jk7h9SNNQZEdOIzP2+MPAo16UtcD44fJXV7LNW9CHhpP6ZhjxmOzI/
r9z4AYFvTQfkX5rPCadSuqBPawRjxcFVPaib+I/uuBl8JboX5mlcnbJ6b/XB
eb/QQl3FoBhRROd9752Qu7Yf0Yl+30s4lJk6gNYQHhhxjDzRNgj59LL7dJbd
MFpO9GOnd08uDZOAntcr+l1ZMgLzm7xZPzfZjMI+ywoGHp8PHYPzG21rqeJ9
Uph/V756XRQlhX6M2uRgmxwZ7GvPYb3dFSCHfjSjZSlXLof9TJ5SK3r2OMx7
e6gursVTgdYT/bs99uxZsQL6SfzjXTyzlXB+45+sG+6+E8iacNoRx5VuIxNo
hvibeUb/q2cmwe98TRFjzaDAr0gPopnaKXif5ZzCB28yVMhg/r50OBhiXdTI
RPgI++y+tjo15FtH/BBgETuF7Mn5yrgUt52mKdhf7D+YN1fyCi0hbLDbYyWK
0oDueQrTp/Qa2D+yZxeTka+F56mf8+57+bkO8m+60dMuzeqgj8LXeWurUQfv
g/wfgP8dLaroAw==
     "]], LineBox[CompressedData["
1:eJw9VQsw23ccj9eUKWroTNKbZxVVNpKube6nWuY9daVpVVS77kE9zupR6amZ
dbqt1Wq7aWu4UWPMKKYx/OdVmaMq0ojHiAgiRNyKhmYslf//+7/L5T73eXwf
v1/+sTqbEHpek0QiJag+r79dkLl0c1OO6ZO2Hs/Qb/oq34+SY4Y4Tu3Pjvu0
dRFb2Nx6kH0op9LUeBF4Hu9NaVu0DBPgfFoP/YqydQHTxnnKXwmmNPIC+OfM
3tlecnke24bzDbGdOkb/SDElzusr19OX90lBf+Z7t6XhrDnoryo3vDlwUgJ+
RR4rB0MS4J8+cx6ovDmLiXF/ieG4Rf7kDGaM88VVuk8aPGYwBc4X+LslDV6b
xt7A+dwIv+SMOTEmwfmsC9Fpe/zE4N9o1FEEPZiC+Vlav6YmyUSYJo4X2w4F
2waIoL/ozH5bfvkk+F8VjjDZepPYEp5/t2U6vyBGiBngfNLe9cJ/WRMwf9OE
g0GV9ThmSuSnuu/OFI5BfzbGnl7HC0dhnhjKx+GWh0dgn48cc2JEUwLox1dR
4G1wfQjOZ6Kr9l0qlQ/7O3uppCJ9lYeRcDztfPc97I9B8LPCiupXI7iYCY53
ZFRQXTQGoP/dFlZ9JFY/+J2pcueHL3rhPBj0xYx91B6Y/6ujsmfstG7QB/b2
1ehxOuE8zI5X3zy5sx36jf/oVn7LHgz0j1a7jDi2TdgynueVdDq2sK4e8h+O
Tl+fy66G/ThqrtfFRpSCP/IYuX703B3gM3kOPMsOOuSx9VnP25NvIyLv77qo
o7XXShHRj4dIY9eXjN8BFyUyO+mN9YjYl83Sn2sH2tmIqHfqQaP/hQ8wROT7
lQz3BTPaQf+hIllipdsFed5BJlorDd2gj+Evt+VRexCx79yooUzXxl5E3L8b
GzlBkrh+RMzTHUzZHmIyAPjU/nvet8K5iLgfMiuzDO79QcBuAcXyGgEP9MkX
naJzzfmQX+ZQOJyeMATzDI0Zh37CEQAmV5aRafoj4D9z6dCsbuAo8Hlc9uPp
8jHAHU60bzt0xhFxn7cVDf12NWACEffRXq9ZUuorBP3Pord2hkmE0C+lOdZb
J2cS6hlG0F4e9BABJq1rViSJROBX2gm1yNlTsO+Xx1qYXXZiwJ8fMaSv8MSg
H3WPsrTLnobzt39C+8HGdQb2kXjCeIf12AzoO5PX3W9fnoX6FnfEDG2KBPTi
VC+SskeCiN93dUTxLy/S5uC8s3qNFJGWUujnBP2KL6dFCvW1g1M8NCLnYV+1
zDjrA8p5qMdzF+StlS8gIY4V+ke02GEyRLx/7OIx8vyqDPJCBw5SKfmLkLe6
5jT43EcOefesyYk3VuQoRL1w1Fpx/6mjQo6u6uHzuFrs7V6Xo2Z1w54pFxmn
zZRyxJlR6/Ue//jduf/kqEodiLgnaSX6G3L0trlaX/CK31Srwg6H1Tizt8xH
Z1PlVy/M8/xPKVyGCn9Wo/YLvmbmZ6nw/i/U2D/eh1mlwiEUtb453MWWr8Ku
uza2ePz/DTWZt7zu0PN/piNPTA==
     "]], LineBox[CompressedData["
1:eJxFlQlMU3ccxwvYAJ3jcKIjtIucIjCEDVqnNn+mwriHBLCKgOjcAXKEyCEY
6JBN3KYo6obIgAxkMBgTgSEMeJzSkSJQajkHpbRQjvaRKFiwgxX6+ttLXppP
vsf/9/vnJTU/Hxd4UZtEIsWo3q1fR7RnYXMTx/aRth49t8DrfZUfRuAYieDk
/qyYL1rlmBvBNoGcyt1Gcky4ufXouvH5by20R8rAn9LLzFC2LoFOa4vbzaAu
gV4f3UU2/GcBmKJcT3118H8+94Pz8mjmPMxTlRPS7DsthT5Fblo2hqSgPx9w
GKy8PQf5EoNJ07zpWfAXV+k+q3edBb3A2zlh6IYEOCfUKzF9Xgx9mZciUw54
iUHfaCAr/B7OgJ6m81tygkyEOREsbz/qb+UjwgaI8yLZ/VaC8mnIvykcC2/U
n4b7u98iySuIEmLLhL9pynZnlcUkzCtPdtnPFk5A3tLI7VhQ4Tj0R9E+CzH7
eAzmeWKXHSWaGYG8p6LAfefNYZhvqrtmH50ugL7zV0oqUlf5wBKH+x9gfw4B
pwUX1a2G8qDPOL2C7qg1CLzf1LyPlNYPfgc67vDoJReYxZSnH6T3Al87IRto
TOmBvC+377E+pwv2Nwmqvn16bwdmRPhjP72T13IAg/yT1W5DjlUT5I8lnI0u
rK0D/dG45OZ8VjXodtrrtdGhpXA/YSepdeMX7gGz+bZ8s04m5BspaS86Eu8i
zX39XRtxouZGKdLM4yrSeu9r1h/ARfHhXcyGOmDL5b/WDnc0Ik3fmYcN3pc+
woC9Skb7/FkdSLPvJ4pEqbluN+jufrt0Vup7oC9K8Ko9l96LNPvkRAyznRq4
4L+1ke0njelHmu+hx5/2dsCuQcifOfTA/U4ID/wyc5N0Xv4QsLNPMf54hA/9
iZftI3P2CEAvsy0cTY0bhr7hCaPAzzkjwNTKMiqDMgb7nLtydE7XdxzyubzG
p5LyCbjPTnvGd53kSdD1ioZ//9ZnCkmJvI1+s7TUU4j0CP0X0Tt7g6VC6Kc1
R7uTs6dBNwhlvD7iKoI8aV27IkEkQu8SutJaqEPNmoH9Xp9sCe+2FiMFwV8d
N2Cu8MUwz7hLhJl1lgRpvg+bZ4wfLZ1mQY8/ZWRsMTEL+3clrrvcvToH85ne
E7N20KRwvjj5GEnZK0W2BFeHFv/6MmUe9EyuoSLMbAFxiPwpZoYnp2UB7muH
f5KrVtgizFMTHmNxWLkI5/FdRnLXypegX0E5rtMYLENsQreOxaiLqzIUQOiB
g0fotDw5+pLg1TX7oRceOOzzwIIaf2sFRwMUNbdW5D+3U+DIjaPuEzuZvt+z
jqM2rpqTLrPOmihxVOyl9us//en7C//iKN5EzbzTjBLKBo5IGWp/wRtBU42K
Fdc2tpnNLfMgb+JoBFfrF39O4rFUvDynzo98E56XqeKAfK1t9o71CK9ScVuQ
2t8c4mglULHtVfK2Tvx/oUPexn1b+n/JW8uc
     "]], LineBox[CompressedData["
1:eJxFVQtMU2cULq8hDKE60DHaZTxFQYUN2k1tLkPZQB6bjSCzA8TNLQMR0qwD
qUHGyMRliuIjqKSQgQ4GYzJgWAf+8pKOwHhVWmgHbWmhLbQlE2rpGtlI/nv2
Jzc3X853vnPOd/6b63syl33KnkKhnPrv2XjvIbbp19dNaHl943hEsS8MN76V
YUKelI1DjcofKc35/JERuWEcxBY1elKNSIv5YvHL+u5MA9qE4wWDrPO2R0uQ
T3+c68mkLSFHjHVer22uPbeIRDi/PbvPyeMvPei52qyFK3v1UO/E9+HLUyU6
RMO4qTylM0GphXqWCn4ZIrQoAOM/R0PHGq8sAL/Wfca7UjkP+jVNzk/aI+eR
BeOqw+HciYsa0CvnxPGKdGrgl5zOLNgZp4b+X3Q4WRLvzCEFjvMdfsrnGlSg
Z+w+kBQQr0L1GGcWjwRM1isRBef/I5hOF7ooURjGN7o0lVVZCqjH3W0V/M2f
BfxwNtityW8G8o35ETuKFXKY158aFX1UIEOPMT+L/mmKz7vTwP91V1mWak4K
/cdaqmLcLklQMMaz/S1vMBiTsK+TZ2sbCs1i8F8TeuNN9NsExPnJ1W1mzjga
xfW2FDUw9tiNgR87vH2HKfwRRMX8UIYp9O6zIeCnsoxFexmDSIrxN4cMo8KC
AfAvYWj4vouoD+6j19HmKx9t70GvYr0zH1yt7NqJ/p/P3O8hCngIfkVzP84W
tLaB3l2Z5pKutBn0dtlbW7M5daCXdoTWJvvkOuy/WBws9ullgb7Qlf+0h3eN
IPl/tGYcarlYR5DxSJXd61+n/kKQ/lbnpfexOtoI0i//5d/X9vUICdLP43c6
Dp9+BxFkf3G1U8NJqT0E6df7Fp7W17kf6sUkbnVYbR8AnDW50l3BGCQe4Pzy
DElxWMcQ5F9+UZaozRkhyO9rIIm++cOtYwQ5//G3b8VcTRknyHkNvl5F47cn
YJ7w+BrTfamYIPfJ+zIks3zbJMx3L1gwVZgrgXyJnMr+TCSF/miN92hM12ng
nzh7YME5QQb1K8aFDzT1cuD3hjC/63WaAf6masnP38bPQj9BLp3aulgFxH9Q
vbI9WasgyH3TO7NjnMqUwHfnMJ/vj1QR9hhTrPYNXJUK4rZAhQOtdA78f36k
K70/UE3YMP7ioDtrVawGviwiwyewVAP7C3rCvOkfNk+8hHHeMeoWP/k86PXx
rBHXzi0Qcoy9r6tTHelaiKvzoym2QS3cj2ZOzY/PCnSgXzLkYUnz0RMrmH+M
dT5W1KWHeo5JX0XapS0CvyU9x2+fbRH6FUdIK9bql6CexfWggzDZAP4HnkG0
RbMB+Oyx/Qx6pRGweS1k4ul7JvD7lh8t7/KqCfxWh3nvHrCaQB//P+D+/QtR
j7iN
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1, 1}, {0, 4.000000000000043}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"whpolys", ",", 
    RowBox[{"{", 
     RowBox[{"x2", ",", "x1"}], "}"}], ",", 
    RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"4", " ", "u"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["u", "2"]}]}], ")"}], " ", "x1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"2", " ", "u"}], "+", 
       SuperscriptBox["u", "2"]}], ")"}], " ", 
     SuperscriptBox["x1", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x1", "3"]}], "-", 
    SuperscriptBox["x1", "4"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "u"}]}], ")"}], " ", "x1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "-", "u"}], ")"}], " ", 
     SuperscriptBox["x1", "2"]}], "+", 
    SuperscriptBox["x1", "3"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "u"}], ")"}], " ", "x2"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"gb", "\[Equal]", "0"}], "&&", 
     RowBox[{"u", "<", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "<", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "||", 
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}], ")"}], "&&",
   
  RowBox[{"x2", "\[Equal]", 
   FractionBox[
    RowBox[{"1", "-", "x1", "+", 
     RowBox[{"2", " ", "u", " ", "x1"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["x1", "2"]}], "-", 
     RowBox[{"u", " ", 
      SuperscriptBox["x1", "2"]}], "+", 
     SuperscriptBox["x1", "3"]}], 
    RowBox[{"1", "-", "u"}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"red", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "&&",
      
     RowBox[{"red", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
    "//", "ToRules"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"whcon", "//.", "sol"}], "//", "Simplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{"1", "-", "x1", "+", 
        RowBox[{"2", " ", "u", " ", "x1"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{"1", "-", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{"1", "-", "x1", "+", 
        RowBox[{"2", " ", "u", " ", "x1"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{"1", "-", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{"1", "-", "x1", "+", 
        RowBox[{"2", " ", "u", " ", "x1"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{"1", "-", "u"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", " ", "u"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "u"}], "-", 
             SuperscriptBox["u", "2"]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      FractionBox[
       RowBox[{"1", "-", "x1", "+", 
        RowBox[{"2", " ", "u", " ", "x1"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x1", "2"]}], "-", 
        RowBox[{"u", " ", 
         SuperscriptBox["x1", "2"]}], "+", 
        SuperscriptBox["x1", "3"]}], 
       RowBox[{"1", "-", "u"}]]}]}], "}"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Rationale und ganzzahlige L\[ODoubleDot]sungen\
\>", "Subsubsection"],

Cell[TextData[{
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " findet auch ganzzahlige L\[ODoubleDot]sungen von Gleichungen und \
Gleichungssystemen, hier etwa von linearen diophantischen Gleichungen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}]], "Input",
 CellID->489327928],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "x"}], "+", 
    RowBox[{"3", "y"}]}], ",", "red"}], "]"}]], "Input"],

Cell[BoxData["5"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "&&", 
    RowBox[{
     RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "+", 
        RowBox[{"3", "y"}]}], "\[Equal]", "5"}], "&&", 
      RowBox[{
       RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
   "ToRules"}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{"y", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Der Unterschied zwischen gebundenen und ungebundenen Variablen ist ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " noch nicht sehr gel\[ADoubleDot]ufig. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"6", "x"}], "+", 
      RowBox[{"10", "y"}], "+", 
      RowBox[{"15", "z"}]}], "\[Equal]", "11"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
   "]"}]}]], "Input",
 CellID->1679927154],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"red", "&&", 
   RowBox[{
    RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], "]"}]], "Input",
 CellID->1138987686],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Equal]", "0"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "&&", 
    RowBox[{
     RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", "Integers"}], 
  "]"}]], "Input",
 CellID->1212744502],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "3", "]"}], "|", 
     RowBox[{"C", "[", "4", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "4", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "3", "]"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "4", "]"}]}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "3", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}]}]}], "&&", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "3", "]"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "4", "]"}]}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "3", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}]}]}], "&&", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "\[Equal]", 
       RowBox[{"1", "+", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"6", "x"}], "+", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"15", "z"}]}], "\[Equal]", "11"}], "&&", 
     RowBox[{
      RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], "]"}], 
  "\:ffff"}]], "Input",
 CellID->1497086605],

Cell[BoxData[
 RowBox[{"\:ffff", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "|", 
       RowBox[{"C", "[", "2", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&",
     
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "\[Equal]", 
         RowBox[{"2", "+", 
          RowBox[{"3", " ", 
           RowBox[{"C", "[", "1", "]"}]}], "-", 
          RowBox[{"3", " ", 
           RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "1", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "2", "]"}]}]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"C", "[", "1", "]"}]}], "-", 
          RowBox[{"3", " ", 
           RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "1", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "2", "]"}]}]}]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"6", "x"}], "+", 
        RowBox[{"10", "y"}], "+", 
        RowBox[{"15", "z"}]}], "\[Equal]", "11"}], "&&", 
      RowBox[{
       RowBox[{"Abs", "[", "#", "]"}], "<", "10"}]}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"FindInstance", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers", ",", "100"}], 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "7"}]}], ",", 
     RowBox[{"z", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"z", "\[Rule]", "7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"z", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "7"}]}], ",", 
     RowBox[{"z", "\[Rule]", "7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"z", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"z", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{"y", "\[Rule]", "8"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", "5"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", "8"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{"y", "\[Rule]", "5"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "7"}]}], ",", 
     RowBox[{"z", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"z", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "7"}]}], ",", 
     RowBox[{"z", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "5"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "8"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "5"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "8"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "7"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "Length"}]], "Input"],

Cell[BoxData["24"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "9"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "3"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "3"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "5"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "3"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "5"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Noch einfacher ist es in diesem Beispiel mit rationalen \
L\[ODoubleDot]sungen - dazu m\[UDoubleDot]ssen einfach die ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdr\[UDoubleDot]cke aussortiert werden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "3"], "+", "x"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{"polys", " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Rationals"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "+", "x", "+", "y", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x", "+", "z", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "+", "z", "-", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars", ",", "Integers"}], 
    "]"}], ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Und nun noch einmal unser Beispiel mit den Winkelhalbierenden.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"u", ",", "x1", ",", "x2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whpolys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "-", 
      RowBox[{"4", " ", "x1"}], "+", 
      SuperscriptBox["x1", "2"], "-", 
      RowBox[{"8", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x2"}], "+", 
      RowBox[{"4", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
      SuperscriptBox["x2", "2"]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"2", " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x1", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x1", "2"]}], "-", 
      RowBox[{"4", " ", "x2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["u", "2"], " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "3"], " ", "x2"}], "+", 
      RowBox[{"2", " ", "x1", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1", " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x2", "2"]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x2", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whcon", "=", 
   RowBox[{
    SuperscriptBox["x1", "2"], "-", 
    RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gb", "=", 
   RowBox[{"GroebnerBasis", "[", 
    RowBox[{"whpolys", ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "x1"}], "}"}], ",", 
     RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], "]"}]}],
   ";"}]}], "Input"],

Cell["\<\
Es passiert nix au\[SZ]er Backsubstitution und Erg\[ADoubleDot]nzung einer \
Rationals-Klausel.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "<", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "+", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "+", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "-", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", "x1"}], "-", 
        RowBox[{"u", " ", "x1"}], "+", 
        SqrtBox[
         RowBox[{"20", "-", 
          RowBox[{"16", " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"20", " ", "x1"}], "+", 
          RowBox[{"16", " ", "u", " ", "x1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "2"], " ", "x1"}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x1", "2"]}], "-", 
          RowBox[{"4", " ", "u", " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["u", "2"], " ", 
           SuperscriptBox["x1", "2"]}]}]]}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Rationals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"u", "|", "x1", "|", "x2"}], ")"}], "\[Element]", "Rationals"}], "&&",
   
  RowBox[{"u", "<", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "-", 
        RowBox[{"u", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "+", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"20", "-", 
           RowBox[{"16", " ", "u"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"]}], "-", 
           RowBox[{"20", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "+", 
           
           RowBox[{"16", " ", "u", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "-", 
           
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"], " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "+", 
           
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], 
             "2"]}], "-", 
           RowBox[{"4", " ", "u", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], 
             "2"]}], "+", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], 
             "2"]}]}], ")"}]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "-", 
        RowBox[{"u", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"20", "-", 
           RowBox[{"16", " ", "u"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"]}], "-", 
           RowBox[{"20", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
           
           RowBox[{"16", " ", "u", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "-", 
           
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"], " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
           
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
             "2"]}], "-", 
           RowBox[{"4", " ", "u", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
             "2"]}], "+", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], 
             "2"]}]}], ")"}]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "-", 
        RowBox[{"u", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "-", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"20", "-", 
           RowBox[{"16", " ", "u"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"]}], "-", 
           RowBox[{"20", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
           
           RowBox[{"16", " ", "u", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "-", 
           
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"], " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
           
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], 
             "2"]}], "-", 
           RowBox[{"4", " ", "u", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], 
             "2"]}], "+", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], 
             "2"]}]}], ")"}]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"2", " ", "u"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "-", 
        RowBox[{"u", " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"4", " ", "u"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "u"}], "-", 
                SuperscriptBox["u", "2"]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"20", "-", 
           RowBox[{"16", " ", "u"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"]}], "-", 
           RowBox[{"20", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
           
           RowBox[{"16", " ", "u", " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "-", 
           
           RowBox[{"4", " ", 
            SuperscriptBox["u", "2"], " ", 
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
           
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], 
             "2"]}], "-", 
           RowBox[{"4", " ", "u", " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], 
             "2"]}], "+", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Root", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"4", " ", "u"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "u"}], "-", 
                    SuperscriptBox["u", "2"]}], ")"}], " ", 
                  SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["#1", "3"]}], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], 
             "2"]}]}], ")"}]}]}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["Und hier dasselbe.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gb", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "<", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "||", 
    RowBox[{"x1", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "u"}], "-", 
            SuperscriptBox["u", "2"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}], ")"}], "&&",
   
  RowBox[{"x2", "\[Equal]", 
   FractionBox[
    RowBox[{"1", "-", "x1", "+", 
     RowBox[{"2", " ", "u", " ", "x1"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["x1", "2"]}], "-", 
     RowBox[{"u", " ", 
      SuperscriptBox["x1", "2"]}], "+", 
     SuperscriptBox["x1", "3"]}], 
    RowBox[{"1", "-", "u"}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gb", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Rationals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"u", "|", "x1", "|", "x2"}], ")"}], "\[Element]", "Rationals"}], "&&",
   
  RowBox[{"u", "<", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "u"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"4", " ", "u"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "u"}], "-", 
                 SuperscriptBox["u", "2"]}], ")"}], " ", 
               SuperscriptBox["#1", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
              SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "-", 
          RowBox[{"2", " ", "u", " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "2"]}],
           "+", 
          RowBox[{"u", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "2"]}],
           "-", 
          SuperscriptBox[
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "3"]}], 
         ")"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "u"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"4", " ", "u"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "u"}], "-", 
                 SuperscriptBox["u", "2"]}], ")"}], " ", 
               SuperscriptBox["#1", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
              SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "-", 
          RowBox[{"2", " ", "u", " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}],
           "+", 
          RowBox[{"u", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}],
           "-", 
          SuperscriptBox[
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "3"]}], 
         ")"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "u"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"4", " ", "u"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "u"}], "-", 
                 SuperscriptBox["u", "2"]}], ")"}], " ", 
               SuperscriptBox["#1", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
              SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "-", 
          RowBox[{"2", " ", "u", " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "2"]}],
           "+", 
          RowBox[{"u", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "2"]}],
           "-", 
          SuperscriptBox[
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], "3"]}], 
         ")"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x1", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"4", " ", "u"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "u"}], "-", 
              SuperscriptBox["u", "2"]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "&&", 
      RowBox[{"x2", "\[Equal]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "u"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"4", " ", "u"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "u"}], "-", 
                 SuperscriptBox["u", "2"]}], ")"}], " ", 
               SuperscriptBox["#1", "2"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["#1", "3"]}], "+", 
              SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], "-", 
          RowBox[{"2", " ", "u", " ", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], "2"]}],
           "+", 
          RowBox[{"u", " ", 
           SuperscriptBox[
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "u"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", " ", "u"}], "-", 
                   SuperscriptBox["u", "2"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], "2"]}],
           "-", 
          SuperscriptBox[
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"4", " ", "u"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["u", "2"]}]}], ")"}], " ", "#1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "u"}], "-", 
                  SuperscriptBox["u", "2"]}], ")"}], " ", 
                SuperscriptBox["#1", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], "3"]}], 
         ")"}]}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "\[CapitalUDoubleDot]ber den ganzen Zahlen kommt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zu folgenden Ergebnissen. Beachten Sie, dass ",
 StyleBox["whpolys",
  FontWeight->"Bold"],
 " und ",
 StyleBox["gb",
  FontWeight->"Bold"],
 " als Gleichungssysteme nur \[ADoubleDot]quivalent in Q(u)[x1,x2] sind, \
nicht aber f\[UDoubleDot]r konkrete Werte des Parameters u."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"gb", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "\[Equal]", "1"}], "&&", 
  RowBox[{"x1", "\[Equal]", "1"}], "&&", 
  RowBox[{"x2", "\[Element]", "Integers"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"whpolys", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "\[Rule]", "1"}], ",", 
    RowBox[{"x1", "\[Rule]", "1"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}], ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "\[Rule]", "1"}], ",", 
    RowBox[{"x1", "\[Rule]", "1"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
L\[ODoubleDot]sungen einer Pellschen Gleichung\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "-", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "-", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "-", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "-", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "<", "x", "<", "5"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"This system cannot be solved with the methods available to \
Reduce.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
        RowBox[{"x", "\[Equal]", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"3", "-", 
                RowBox[{"2", " ", 
                 SqrtBox["2"]}]}], ")"}], 
              RowBox[{"C", "[", "1", "]"}]]}], "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "-", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]], "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]]}], 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
        RowBox[{"x", "\[Equal]", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"3", "-", 
                RowBox[{"2", " ", 
                 SqrtBox["2"]}]}], ")"}], 
              RowBox[{"C", "[", "1", "]"}]]}], "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
        RowBox[{"y", "\[Equal]", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{"2", " ", 
               SqrtBox["2"]}]}], ")"}], 
            RowBox[{"C", "[", "1", "]"}]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", 
               SqrtBox["2"]}]}], ")"}], 
            RowBox[{"C", "[", "1", "]"}]]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
        RowBox[{"x", "\[Equal]", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "-", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "-", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]], "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]]}], 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
        RowBox[{"x", "\[Equal]", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "-", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"]}]}], ")"}], 
             RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
        RowBox[{"y", "\[Equal]", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{"2", " ", 
               SqrtBox["2"]}]}], ")"}], 
            RowBox[{"C", "[", "1", "]"}]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", 
               SqrtBox["2"]}]}], ")"}], 
            RowBox[{"C", "[", "1", "]"}]]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]]}]}], ")"}]}], ")"}], "&&", 
    RowBox[{
     RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"0", "<", "x", "<", 
     SuperscriptBox["10", "3"]}], "&&", 
    RowBox[{"0", "<", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "17"}], "&&", 
    RowBox[{"y", "\[Equal]", "12"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "99"}], "&&", 
    RowBox[{"y", "\[Equal]", "70"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "577"}], "&&", 
    RowBox[{"y", "\[Equal]", "408"}]}], ")"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Gleichungen \[UDoubleDot]ber Restklassenringen\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "\[Equal]", "4"}], ",", 
     RowBox[{"Modulus", "\[Equal]", "12"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "10"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "4"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "12"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"x", "\[Equal]", "4"}], "||", 
  RowBox[{"x", "\[Equal]", "8"}], "||", 
  RowBox[{"x", "\[Equal]", "10"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "3"}], ",", "x", ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["3"]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"primeList", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"5", ",", "50"}], "]"}], ",", "PrimeQ"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"Reduce", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "\[Equal]", "3"}], ",", "x", ",", 
        RowBox[{"Modulus", "->", "#"}]}], "]"}]}], "}"}], "&"}], "/@", 
   "primeList"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "5"}], "||", 
      RowBox[{"x", "\[Equal]", "6"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "4"}], "||", 
      RowBox[{"x", "\[Equal]", "9"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "7"}], "||", 
      RowBox[{"x", "\[Equal]", "16"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "15"}], "||", 
      RowBox[{"x", "\[Equal]", "22"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "12"}], "||", 
      RowBox[{"x", "\[Equal]", "35"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"3", ",", "2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"primeList", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"JacobiSymbol", "[", 
      RowBox[{"3", ",", "#"}], "]"}], "\[Equal]", "1"}], "&"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", "13", ",", "23", ",", "37", ",", "47"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", 
    SuperscriptBox["x", "4"], "\[Equal]", "4"}], ",", "x", ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
     RowBox[{"x", "\[Rule]", "10"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "+", "x", "+", "y", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x", "+", "z", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "+", "z", "-", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "6"}], "-", 
    RowBox[{"8", " ", "z"}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "3"]}], "-", 
    RowBox[{"10", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    SuperscriptBox["z", "6"]}], ",", 
   RowBox[{"6", "-", 
    RowBox[{"4", " ", "y"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"2", " ", "y", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", "y"}], "+", 
    SuperscriptBox["y", "2"], "+", "z", "-", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x", "+", "y", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", "23"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"polys", "\[Equal]", "0"}], ",", 
      RowBox[{"Modulus", "\[Equal]", "p"}]}], "}"}], ",", "vars"}], 
   "]"}]}], "\n", 
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"polys", "/.", "sol"}], ",", "p"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "5"}], ",", 
     RowBox[{"y", "\[Rule]", "5"}], ",", 
     RowBox[{"z", "\[Rule]", "19"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "5"}], ",", 
     RowBox[{"y", "\[Rule]", "19"}], ",", 
     RowBox[{"z", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "18"}], ",", 
     RowBox[{"z", "\[Rule]", "18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "18"}], ",", 
     RowBox[{"y", "\[Rule]", "6"}], ",", 
     RowBox[{"z", "\[Rule]", "18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "18"}], ",", 
     RowBox[{"y", "\[Rule]", "18"}], ",", 
     RowBox[{"z", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "19"}], ",", 
     RowBox[{"y", "\[Rule]", "5"}], ",", 
     RowBox[{"z", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "23"}], ",", 
     RowBox[{"x", "\[Rule]", "20"}], ",", 
     RowBox[{"y", "\[Rule]", "20"}], ",", 
     RowBox[{"z", "\[Rule]", "20"}]}], "}"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], ",", "vars", ",", 
    RowBox[{"Modulus", "\[Rule]", "p"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"polys", "/.", "sol"}], ",", "p"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}]}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "3"}], ",", 
     RowBox[{"z", "\[Rule]", "3"}]}], "}"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Differenzialgleichungen", "Section"],

Cell[CellGroupData[{

Cell["DSolve: y versus y[x]", "Subsection"],

Cell["\<\
Differentialgleichungen k\[ODoubleDot]nnen mit y[x] oder y als zweitem \
Parameter angeschrieben werden. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "1"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "x"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Die zweite Form ist f\[UDoubleDot]r die weitere Verarbeitung besser geeignet.\
\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "sol1"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "sol2"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], " ", 
   RowBox[{"C", "[", "1", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", 
   RowBox[{"t", "-", "2"}], "]"}], "/.", "sol2"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", "-", "t"}]], " ", 
    RowBox[{"C", "[", "1", "]"}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zwei Beispiele", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Beispiel 1: Freier Fall",
 FontWeight->"Bold"]], "Subsubsection"],

Cell["\<\
Freier Fall aus 10 m H\[ODoubleDot]he mit Anfangsgeschwindigkeit 0 m/s.

Der Ansatz\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dgl", "=", 
   RowBox[{
    RowBox[{"m", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "'"}], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", "m"}], " ", "g"}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dgl", ",", 
      RowBox[{
       RowBox[{"z", "[", "0", "]"}], "\[Equal]", "10"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "z", ",", "t"}], "]"}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"20", "-", 
         RowBox[{"g", " ", 
          SuperscriptBox["t", "2"]}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["Die L\[ODoubleDot]sungsfunktion z=z[t]", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "t", "]"}], " ", "/.", " ", "lsg"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"20", "-", 
     RowBox[{"g", " ", 
      SuperscriptBox["t", "2"]}]}], ")"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Die Geschwindigkeit w\[ADoubleDot]chst linear.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"z", "'"}], "[", "t", "]"}], " ", "/.", " ", "lsg"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "g"}], " ", "t"}], "}"}]], "Output"]
}, Open  ]],

Cell["Die Probe", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"dgl", ",", 
    RowBox[{"z", "[", "0", "]"}], ",", " ", 
    RowBox[{
     RowBox[{"z", "'"}], "[", "0", "]"}]}], "}"}], " ", "/.", " ", 
  "lsg"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "10", ",", "0"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["Bestimmung des Aufschlagzeitpunkts", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tlsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", "[", "t", "]"}], "\[Equal]", "0"}], "/.", "lsg"}], ",", 
    "t"}], "]"}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox["5"]}], 
       SqrtBox["g"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["5"]}], 
      SqrtBox["g"]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t0", "=", 
  RowBox[{
   RowBox[{"t", "/.", 
    RowBox[{"tlsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "/.", 
   RowBox[{"g", "\[Rule]", "9.81"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData["1.4278431229270645`"], "Output"]
}, Open  ]],

Cell["Die Kurve des raum-zeitlichen Verlaufs des Experiments", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", "[", "t", "]"}], "/.", "lsg"}], "/.", 
    RowBox[{"g", "\[Rule]", "9.81"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "t0"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk41dkfB/Cb0qKRXZbLcL+SmslgbONXfY4tqZTLzUhGuKXSQgvTpVRE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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1.4278431229270645`}, {0., 9.999999999999996}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Beispiel 2: Ged\[ADoubleDot]mpfte Schwingung",
 FontWeight->"Bold"]], "Subsubsection"],

Cell["\<\
m\tMasse
c\tFederkonstante
k\tReibungskoeffizient\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", "1"}], ";", " ", 
  RowBox[{"c", "=", "1"}], ";", " ", 
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"lsg", "=", 
  RowBox[{"DSolve", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"m", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"y", "'"}], "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"k", " ", 
         RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", "\n", 
      "\t\t", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    " ", "y", ",", "t"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "t"}], "/", "2"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "+", 
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "t"}], "2"], "]"}]}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], " ", "/.", " ", "lsg"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4lN8XAHD7OmOrbLNYRrKGilTqHmUpCRVFpIZo9yWSSIuUyJasM0mW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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {-0.1630334654508337, 0.503827888533991}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Randbedingungen und Integrationskonstanten", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "1"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "&&", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "2"}]}], ",", "y", ",", "x"}],
    "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", "x"]}], ")"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "x"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", "U"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "x"}]], " ", 
        RowBox[{"U", "[", "1", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "C", "}"}], ",", "C"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"C$119632", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "x"}]]}]}]}], "]"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "->", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "3"}], ",", "5", ",", ".7"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"Axes", "->", "None"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzn0803sUB/BRHiYxMoSQjIZSWE/KT6RbmiJFj3SrpaJMSd3r1mUh11Ut
SR56lWRRSfR09Zs630qlyW1X5cZ1MYaw2ZKFWfv164/zOq/365zzOp+ZO+PX
c3QpFMpasn70XXf4CoIgYF5J6+EGNxaymLBx8dUQYM8RxpxnsFDdSsG2pDEC
RLeYedscWcil/dFrmZKAS0UZV4fpLDRg3H2tRUKA818e++fosBB3P2vTvecE
8GNreP//64NOMFrRnlMEyDrfiBkZPqiwaFZOowkB7Kn91j/1eqMrHZnxYVQt
qBezLTlFXshSHL6OSf8GEsWedcpj81F9aPiKBoYGpqZ6ClPi5qFVTEbiLKcJ
MDfxyDJ8MBctqdx2/a2nGppFoqPU9x5InbVnmhdzHPirQ3QH+92QarT0QpTr
GCT5Zg1udWGin81W23QsGIWKRI7N5EJXdIkHLXSvrzD0a9lorZ4LWlVcVFTs
p4KIWvekthJn5Lm24pBq3QiMmEcqWrbMQj3hZ9MoIV9gVcr5r7IpTshY/2N+
9NZhGJW+i/rc44h0aF/6Ejd+Bn7A3OjMRAc0/2YAe8MGJWgs2kNXsGegMomC
Y/p6CIJiA+z+jLFFmfZEeReSQRM8jBg8Nh2x77cot/83ACe23Lr75KUVuj2+
qTKo8ROkdjmkJhhborTo5XlP63uh4tWO2LFEC+Rnr+L19ErBM+2eV5jpNJSb
HdJzpK0LPGrniy+WmKHG8AR25UgnaLxnPz64k4bGkjRClUc72D2jz6EdMUFn
BdGiGIdW8E8fFw1ZGyNZ+uYuZmQzVCjy+AJ9I8R7camnblkTDARXNy8aMEDU
7N3JtPg3oKK+eRU8pocKlbV+C+V1kOEectk/cDJa4hpa7ZDzCIwKsEBOui66
vVfXyulJKVTblmr0tBSUMGhulzAjBxP9/oGaOZsA5hyOjHP3PrY09YRWEKSB
eXEPHlhJn2IPl904bv14HDafFFwONhNhhmFVXRLXUUi29cGHWsTY+vj0vw93
j0CUT6DYNP89lniOzTVqGAaDIcOJyLKPmLa4UZZXpoRB1UK70IQ2jNtQVWZ9
Rg5r3prcWLiyE7OoborqxPvB7WT+dO/gLiy4TyGv8ekFl/aI9Ax3KWaRWFzV
adcN6X9wkw+wejHDaMEwb6ADdNqexFXYfcLybwn6Sna0goFJqXekuh/LlyRZ
Ogd8AC5fmnaBIsPEzftcnA3FMPpo8z/uUjmmLPAWcLpfgsTbrXyjUoHRmi8z
fzMXQjZNPyyX9A7CqyuMJoRFcsl4E+ni5MlXXE2EwL9esCb0swLzZ0cz3lGF
4DedqggeVmCOnC+73XSEUKjtY/mPKDCK15k7LQocwl8LnruNkftOGw75NuKg
FaTG7SPNLeDdNWvA4SZvO72ctOMW+de+ehx0l9JjGONknotHs3PrcKiqTDNy
VJP/LaMG5EIcjHN3hdE15HwwNuHqTRxquJg6nHSn1VbV0XIcdoXYXsshXUXN
OL72Og64/rsR02/kvc3ZwomrOOz9JSDfSKvAUowOGEQU4GARYb98NWn/pMW3
PS7iAF7q/lOk0e7lkZMu4GApq/bVI8h85ZNqqvg4PKs/LQ0knSJ7fPDUGRwO
Cvad5pH2z7nHjMrGwYYXtODpD5+TfvLJwuFF1MwOgjRNEloxJROH7zlgpOg=

     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3s0lHkcBnCpFJLLuJRbLk0uybiEtnbnJxEVUtPFFCk1qG0z2lJ7tC1j
SrXEWrbRdKrFjKnk0uZUsr4/vWoR2+i2SBg7dDHMuEwYl3ff/eM5z/n885zz
2Mcmbudoa2lphVP5vw+W5yhJkoSKCb0le2YY2HTKcsW6aRLyHBVn2GoGrt8o
ikqeIGE5YVO/Z5CBV3Q9alSoSBjaUDoe+56BPy/6t6hdRoJptPGHi38yMPeI
T+QfBAl2bSv5nmcZ+Cy9A8dlkDAvJVss12Lgq0LH3JbFJEgiOewn+u74RveF
xG26s/Aq+F1zvJEbNpeytrqYzcDIL2yaHssVN0SwAp/Tp+Fa2qgB94EzDnGh
n3B0mAJ/3vtIFs0Jry2LEr9gaEBv+bOm7EI61lyKo3m5TMJjg4XPWlyXY/V4
cf4+pwkoYbr/LZQ64APGmyy7fcfBhq8rq71pj6/xoN3M6wukO9QIm4/Y4ZCb
QuFNphpsk2+5naiyxYzw0uPqrWPQ+WkgOq3WGvexsvlaYaNQWZ/SM1pjiRfp
tAli9o7A3PA7b1ZpluA5RqMfTuwcBpedaa2l7hbY83ZA6I4dKmh97pUUlGGG
S2RKjmHjEFh5nIoV00zxBVtS0osVMMiVOXMFJjj0frsq+t1nsEoTeeduMcZ3
JyPLglo+gttX58NHVIaYH7P+t7qGfoji5P3qlGqAmbZqXl+/HEIO+TzFe/Vx
XmZY38nOXqhmRR/gueniFlZSaNlYDyTpFz8WrF+AJ5KnH6vdumBeiGuNLGU+
zhbFNMUv6wD576a0B6VzseIcu9dl91uQNvALXMy1Me/ptb76b15C6BUv5ttT
Wlg381CKUWIzxHle5riPzcBVVQ3Tb7Aeug5lgMGuKVjrFFG5LPcRSD7/ZZxw
ewLuJmhbONQWQ8B4xPGw7V8gacDEOskmFxVmzvlJ6DQGLqs4Cs69+yizg8mx
Hx4Gj6NVVRbyOtRbSF8jJZXAThdd32zchJhnPNSjugpIsVpdPdQuRebGgW/V
2R9h3+oNUkPBa6TTrYhPZvfBgqGFU7tL2pBH6LosXZNeGFD7WUckdSKFn6fJ
kdgu2PJi8S2/jT3oYUBy4TC/DVzTBUu9N/cit4FUi2KbV7Cia9e58yvlKGem
I0Jd2wznLnJTvvPpRzmJ7/z9TQiY01l7tNT6I5KW5E+ynatgweJi792aTyhV
+9jw7Jt84ObI+flaCtTj//7nOEcRGn/Ebl0pH0Rtw3U0VtFDJPN2lexUKRHW
7A9y/5FAmUY62/IoS8Q3arXPEmjNoGzyJWXTEKbvP5RzxAVbIoaVaMlpoV1q
KoGYS3WVm0eUaGH/G1lrOoGuzn7w8R9TIucnYeYnLxGI1SgiXCeUqAJigquv
EGhWlHb0MOXVQUWZlwUEus2LNpNQnqYHS2MLCKT9tVk8fZLa16nYri8kUEUZ
X89Oo0SnC3QCo64TaFHewW1m00rU9rqxbaaYQA+5SMOi7JFpOu+liEAHw6yK
cikXt8IqsZhA1TqvxgxnqD+0NWfCJQRK+CFAoDerREYt5fNv3CGQ6S7b9Zso
J4STjt+XEgi8NJ8yKAeeKvcPvksgc0XluvmkEu1v9jypLCPQk4Ys+QbKY7Nz
s4hyAh0THc7iUW7u8y26UkEgS16Qbx1lI37Tg28rCfR0n303SVnVWduE7hHo
P40Qmj8=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzn801Xccx/HrdigqJJfyM3EZaeRHWspnIUcu7uUqdfzK71oK/V5U28Xc
NZVj6txo1cbFhJSY2tb7U7Go7oipfGvXpXtFrr7iXrmXfPfdH6/zOo//nnZJ
mZGpTAaDEU7v/0++UUxSFAWM+t3B1mI2Np21cPSdo2A8N9Gl6CobtwWJY4/O
UNDy+UjM3CU2dpTe6VROUFDN49TJzrHxuyVvKvoHKXjD6dS0HmfjrK+8dzY9
pMC+f5hZE8rGp9gETiukwN2r4PpJtQMuK7cvkRhS0Hpx5pvpEAd8dUCYGaE/
D82WNvt1363GZt18rjPrEzgEKgo9b9vhDh4/8Al7Dmx1hGLphVU42Jl92H71
LMiU1txNb2zwxobYqi43LZzSCnxdh6yw9kzacg9nDUgqCpYnvrDA6o+VF+Kd
ZuBWXmXib+oVOHHZNouB9R/B1imGOxVuji8LoJ/lMQ0epT+fbr3KwsHXysuv
+amh+NBshhvbFLuF1x1Uc1XQU+/8b/gjE6zgn89nhE1Bn7C7d2nSMrxE76Uo
IWYSVvY0jB//zBjrGE+9Pbz9Awi7agp/ebYUr6v1D42KmgCerpH92fzFuHqQ
TDXqfA/y0eiIvNP6WGhD1QxhJZgGrpgezVyIQ2/3T8S9egdHuGjvk2u6uF6z
s2GrZASi65+W6XQuwPkJWy7e7xiGJN90XrwZE/vZqAWKYTl44gXsAREDlxaF
KY68HgK/+IbAWqd5kPCzQxtUMngZR2qqc2dh5ujc72pXKRDlJy+m6WrgvDjh
cbotASYnE1rmv5kGZcGuIefo56AMUATGcFQgaL+saNvcA7sfpXPeGkyCflFK
jnHmU+j4adGxcyQJZRN/+PmMt0GKYiTfi6OEjU68m7Yld+BUkN3GxaUjUL+H
ab76XiUEH2h6bh2hgOwxE6ts6xKk9YgZiQsbAue1qcrUW7dRVtec26GDUnDP
aG42l99HraUfRqUG/bArT3wlZNljJKtjhAQLeyHH0uvu+/5u5G6o3mycIoF4
r4BuI9E/SJTB/DPhUBssfL9oNrr6JXJvIvRcqltgTO1jxct+jRjFS3lrz5QB
p8vwV58gGWpU/NU+Fl+BXPJEKz1DhpBMdqypqrUVOUp3FHy3Ro5c+56sEqkf
oILvs3L2ew8jufTH5ILGTqTz+l5GndUIir3R3Dcm6kILDSs9o7WjKNhu24aU
wh6UVSzPv8BQokVOiZ2feH3o451dz9bIx5Gs/URs7MMXaNDTpWb7BIn8Gzu4
ki0EKjLWiyilnZvm6mPuT6AN44OaHtraNMo6kXZx1SUO7wOJXDhToyrafiv1
yZBJEvHAJMcqkEBl82+9v1SRqDZ8nWBfEIH4neKHLjMk2tShstfnEGhe/G3G
XtpnxgI0kbRrBXGsGtqCXObfl2kzN7HS2RoSEWOSI+6hBGpsyDdYpSWRje2V
e9FhBFpSmhzBmiORqMvBu4pLoNYspOXTdozcpzNBOznMsqKEtkGUneQLHoHu
6vWqjD7RfcSrJAntPV/7iwzm6T6jHwpVEQQy3WGzZRvt6ethXL9IAoGHdrSQ
dlb3aTMhbTPlTV9dikRJLR4VlnwCPeg4Kw+gbXKiaU8q7QPivWcFtGMfV6y9
QdtCsHX9fdrxNQsmZ2i3x9sNULQ9WL3N/lEE+g8lOZnu
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx38803kcwPFtOqWHY2TzsJxS0Vn10A+k0j5XfjykKZqfRbo01EPZOvW4
ctejFqnOjpN6aC0pP8L5UfrxMHXeX6RSKT+WtjiMzaRl82N+LNl97o/X4/V4
Oh5M2sOlkEikXbj/H1uVpTUajXC7IXGUuE4nbL4ynLfMGiGjvKLq9yt04plf
UdTJaSMI3bjqLUI64dwjadbojPC0Vlr/9CydGDYfKJArjHDgBMWuNZ5O8I64
RzxoNIL/Q2+TrR504ozTRyIu3QiPP+oPrJHSCNGN5dktFkbIKrUNDrWhEbd6
LyYFm83B6t56hl/6IoLeytntQvsGpRrFtIRpTbwM4vi8dpoFH/Km06IhKuHv
4pS8fNlXOFNGlhcgS2JzZVTxO1cDtEaON/DnzAnD5bhF611mwD9i0j2weiGh
nyq8un/lNDBt5IHHchYQP1vtYPR6TIFJhp+krcaUEAtATls/CZLnVzOrOuYR
/vk3buSz9EDpF+1972JCuO4qP67fPQHCgbc1nvlkQsXJTCUFjoPuesCfuy1I
hLmpLDdm3xjURjTTqfu+AZk6rk4OHYXTn27KOv8wwLqy7eyQEB3MqngvHPRT
cFeh5Vo2j8AyteDJL1V6uOhgLOknNJDL7nJTR48D+6FcF901DIc2xXcqQ0ah
Yiai0rdlCEwvsMXeqSOQGrPtWv3LQcjzHXILqR4GloNeoBpUQjLPf9FkuBpy
MgJVJ7r7wZTpI7ylGYAWDp9dOdEHOTvWzHhp+mD65OwT/eoeKM8TtTuzuyGz
KOZV/JKPkCgPY2y90wmatMh+l/BOkMpM9glL20DQJFY929oOnmROB3VdM5hl
HEqhJr0B6vNiW/JjAJHuKWvjl2eQT11bLiushM0rg+4vyZYAaXVh8Yeok6gi
gWK7rK4QajJlkhnre4j/2dqe/0M2yhJxj8gL/kEua7gabvVDJL5mcoQFTWht
4qNHtsp6dM+z1bOp4zWKPF+UF2D1CjXkxYSFm7ShlMVutSPyVkSxuXKs60kH
2u/m3WqZK0XJwR+shagTzR9Z8DX8rgy9YZnZnmmVoc/6jfZB/G40kuaasMKq
C+18Z1G60a8POc+qr5RH/YuY53PtNgT0o/wuL/7UqV7k3BOWdmGVEhlKxYcu
lfWhtEu8lKPugyjiNamhXaxA5O66xHL7IVSS8T3zHL8fzbco3BBu+ISi/pK6
2ngMIF6WMvUqSYMMewoOvJgbQFOSyLZVyi/objrFMFqpRIoNzJJQnRZl83l1
5w6qUAbVNDgHu/231PRr2J5fFDPt2JPSpKC/sbOKr+8MGtWiFUffKKTYLDsz
bcCYFr31vUn5MVaFRHNq958mtGhpz02vt9ic5qJG5rQWBcnssxlcFZorOpd4
GJvFWBzmil0miKaVYM97oLPzwaZ40eKdZrQodNjx9lHse5WpC5catIj4VVxB
YJvnxAbTZrXo4N6xurg4FarhIQMHm+EadzYFOzZwcUE29p2Y+9uysGtNOyYs
v2lR3PuWRgl2wqntuQvntCjBfslz83gVsglz2LYDO1oWeMERG9YbPqVj3xrj
+Hlg0zX3t3xn1CK292BTDHbDS6HSGzvk9PG0ZOxjRYeFAuxhaqfPJWyGwNej
HnvvfKt5edhN+x17jdiT0csbq7H/A/GFnog=
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx38803kcwPFRR8rDj27TL+dHzmqWlgk96Lyl9FCt0iQqpiM/upPRlYdu
nbtm+nHlkcdOnV+PcmW1ejAUd+jqgxQ6e+Qkv1rDbH5uvsMmluw+98fr8Xo8
nWO47DhTEol0APf/Y8tzCKPRiFZX8Z3P5coR+dNaqt+CEbXNZD3ckiFHTbtF
kWlzRqStK+ZOJcgRVV7bqtYaUUWgeyXfT47GLYfu9Q4aUTHDdWRI8QGlfOcV
8eQF9snCFcXMDyjDta8+/rIRdbaTJbPv3qOCQheh1MqI5o4plvTRe9Gd/ivc
QxaLaDQ5vYoifovs2kMP0iifUYCzGxT9IUUtIaG7/nFdQE4WAZv0kiYUTHM9
67L+EwpIINIVa/5CvpLI+28YBlQfEp1yOagIGX6N/5JJm0cVjaLmyat3Qf+x
5CZnwxzapng/vYtdA9/a7lnb7/0RJcX+1shsaoQiPuqlMGeRU/l5E4eLrRBc
XFhY7K9HpR4rWYHfvwHGgdIz+oM6xC4pDYpJ7QBV6A0Baf8MYk1yIpR+78DS
rCcv+vg0ajp+92ur8m4wsZkZORs2hZK3hKdHbe4Dj0eBrMOHtUhs0MrO8GTw
YJCIs26dRGQ7seTCL3K44mAUK+rVaPrDzNIVwQPAqurVRr0fR4ERJ/YVMAah
bD5CEiQdReyH+cyf1ylAEL3jVkPLMGLFtHW36xTg76Dnq4aVSOmYcTrnyRDk
Xt+vOidToOTEzmRKmhKkoaksiW4AXdkoMOlyUsFc2sJT/SY5Ms8/cez+cxXc
EEW/TnDsQ7VOiez66GFQZx1V0MK70JLyV5tpmmHgvyxSNX3TgahWVPfdP42A
xfWTPBtuGwpSO3hYmY5CgfZvfx9NE2IPxXDz00bBd0NIpaOwFjG6n+ZlaEah
LNF01frnJchbSAuShY1B6sRK+9SvhHAnXxd4+M8xoLnHqeMeV8EyT5K0Z/U4
bEmqrl6lbIAnwyds2dxxOJopur3X9jV46KN5vOZx4K3bWjfZ2w7Z4TYZ/eQJ
4Gzd2W6d1wkF6lWmcZETYD657FP4gx5g3lSGx4omYELvYx+SKgPudHnHOdUE
7Htj9dBn9wC8zr7W/YyqBrfMvDWeexWQ2S8tUMSogSo/knWJrgQxx6yh9Hc1
ZF1N4Z32GobZ2/Z0gVQNJrLnSaX2o/BjWRmneUEN5lYlnuGGMSALBTvTNmog
JUcpuElSQ8rKWzLrMA18rD36L12pAU5p80uvCxoY9HQTh2kJWHptodO+RAPX
bcwO5WInvDrzgzP2Ns3gfAc2d7bfloqdcz9/X8gUAY+33jnAwPZfY0HsnSZA
R69s3oFdsDjiFaAjYJzsUhOPHdoqeuE2R0AmC4QV2Iuii0mnsGv8cxnV2I/4
URQxdsuGgbZabNPtlATXeQKeySPNX2BXSATLnQwETA2O8d5hW+bGHqIsEDDP
YscasGtSwBCKvb7ajmTEjt2/7p4QO4DSUbREpIE6s7c6688ElDxz77LETjwf
mLd8kQBDRXqwIzb5iMOOPdioT6d0wUZMw9hlbLPPCRc3YtupK/2+MBIQT/es
88BubMlW7sQu9rl2xBs7WXQqm48t2t437Yu9lh/k3YCd5et0A7Bfcpz7jdhs
jyj6Luz/AAgToos=
     "]]}, 
   {Hue[0.8503398874989481, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3s0lGkcwPHBRlNymcKSS7SjpfYkl2oVvyeiyK0knIpdt8gspm11Otou
06CLKc3SGZfadjNSOymtNqrtGdtUQ8mlTjWyiUhKXswMZox599k/vud7Ps5J
2VtSDRkMRgTp/ydfK6ZomsaOnLXhno9YaMG0nesaHY1ZIwfKb91nIVmweEfu
FI09HLiNflIWcn3T2Dw8SuM01rXMsEYW+mj67qKil8acNofKH/9goZzdPnF/
3qdx/YZ2g6HTLHSQ3SVNK6RxJfI6mRXPQuUVi4WtZjT2TKiw6BqxRL/2HMve
zNTjqA7PlECWJbJuj450s5rBJaGU94UoCySPil7/mK3DKQYfI7atMUcb3dh7
F7tMY2b9nrpZT+ch39od1W3Ltbioe4V4u8AUaU+kzfd00+CEAi9JZfBcpJ6s
Kk1YMoXDO43PCW3noO8tQ+x6Vk5i7pTIMs6SiSp5WGHlOYHP6WSRz4xmo40X
Kiou+Kvx6q8dqvxsTNDyCMkedaQK/2bqG3pmrTEaiD7NZ4QrMT8mqWrjzlnI
1PiVKHH7OI4IFJRsKvsCGVgoB/fGjGGFNKWF12GEVlwJCNu6dRTX1KnsOLZG
6FIvlWrePIKt92cyFfsM0TFHuqZPOoyDSgftNZ0GKKxeMbrz9Uf8XP6uGAIM
0FVNXG1Q6wfsPpF4uL2WgfiJ6842yd/jUwGL9s+4MpC/o5o38L4fO8a57DuZ
SENJUfjAT919mPtzrk8qRw+t0dywWtVbvKXV7qDq7AxM5eruqJe9wTeQifn1
Dh2cFie27HLqwgtezogiZ+tgOD++zy32BV4tLswvip0G3oPKAZlfJw7LKt6Q
flELzKKUPIvsJ7g6riwga0YD5aN3/Vd9luEXyTJvaaYGfJdE1TkJG7Ghl1WT
88spuJpuaONyrwr7MosuS7ZOAfcTy57rIIQJiJBYd0+C2zepw6k36sFbiunR
7ybBg3Pzpk1/E5zvCd6tUE1A/FHx+VDLFjg8Ty4WF0xA3kLv2yOKdhAIM3//
wJ6ABO/AdnPRc/D7MunvI0/UYDIyezr20is4FOTSGchVwyf1KvsobjcoLaoa
ljmrYVOb2eVVwW+h6dSZG8I2FbgfFdl6hfZBRc3Beyl8Fbi+2ZZfsLQfJMwG
s/QAFeQfz8n7wec9hH5r32JHK8Gg+x5HYv8BXAerm41lSjAxq/KK1Q5BWkj5
Uo5ACTnF/fxSxjAo09cvk8QoYbIxvmNp/2c4kf5QfvcrJfR6udfEjFLgu0Wm
fj0+DkUWxptLiPWF15e/IF79uVfTSayaW5PRTlxcXbYpaoyCRfqGf2XE/rZM
KnScgnnHkx5eJS7XD/ogFQVd7Odlh4ijm8X33aco2P7WI2QxsV58hJNBXFZX
wHcgvsLbaVVDHPR0ENsQG6612sXWUCAcerzSlPh6LX/OIi0FZ8QL2eqxcTAt
Sd5spaNA7qQwekTckAPaaOLSc++giTg5fOFFIXF2qibvDvFt42cq8xkKxjqD
VdeI0/cHiOboKXjokjEgIl6wzXFdCHHxSKvzL8TYUztUSHzLyD9BQGw9XLdm
Fk2BlIleHiH+Ry7oDyTO1XbMP0CcJc4Q8Ig9vLOjconteEErm4hf/WUjyCF+
kODcQxPH8R437yb+D4Pfkag=
     "]]}, 
   {Hue[0.08640786499873876, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k41GkAwPExFY21jBjtDLlmR9FhNzmWzfuieiJnakoxVpaORzHW9tQz
qaVRKkpWdkK3yZF0qXU9vQ0SSsluMq3N0JBj+E0xzWH47bt/fJ/v83HYlbw5
gUqhUEJx/z/+Th5BkiRCGRu/vGlgQ8sZlpOPnkR3l7TbVfzJhi0bxNEHNSQy
Yk+uS3/Ahk7v69oVShIdOeKVsewWG46ZfLghHSDRqIbbcLqIDVP2uW9/0Ewi
qeNK6tHDbHiU8+5J4kkSOX68AW292LComJ3faUoiGr9e5lXrCK/0ZydH0OZQ
a0GPufCOA7TqigxzZswi1tS42OmZPWwLj1z3nKNHtw2CNZ0yO7jRmZPGdpxB
N/lcn/0uttC7OvrmK1cd+tfn+oprFTZQdzrRYrWzFvV6l77MdrCGKnXpBd5S
DWrZ5XMqsJYJ48wDWf0easSNEQo8BN/AkkwkZaz+gr51rYvt8FwMN14tLr7q
q0KVhY3nP1hbQdfQqlRV2DSK9u/nCBgMOBR5TkgJmUJXEvt4p2mW0MSwVxS7
8zPKXxJwf4etBTSgT31M2/oJdYf0fy5ZtQh+X+kfvGWLEs1e40zURJjDsgEi
wax9EtWof/N9fY4Os23J8sEnCvS1W/4h4nczGFwjVcb8M4YKBcRZkZcpvK3d
Xr2+cwSRGcw1kh4TKIz1K5S0DaPspJDG1ryvoK+tKnNoWI44XU07y1KNYUFO
yNCvfYOIGy+R9ofSYGckP7h6WoZcm+tmH4cuhJqD+gbVivcohZV8yHCXETwn
ju3YbfcODb+MF8amGEJFVtSg87YedEj75gf/kgUw82nJUMvabtQ8tqHRqmU+
pOX8LKAnv0AFlyIejennwSJlo6/nRAui3hrvZYbOg95Lw+/Z5dchj7XDrKZi
Kry9h7rY8XEpqir1E7mTBpA/vsiGvyQfnGWeL844YACdVyYoEu7XgNQHx17U
v6PA75IePlwslwCleHJofhQFRh0XXw4y7wB77GW5uRUkEFivqZ+UdoEt2pdZ
cZI5wFsT0GUm+hus8q7Vdo3NAqPJhTPbynpBAtyseWM2C8ZVnjbh/D5wZ5ny
5OUwPdj0yrTCc4MMXOLGHG49MwNcjouYbkGDIC2u0HX7Wx1wes/NOrFcDubJ
FY1aLx3IOpUi2O8+DFjsyqO//KEFBn2Pk6psRsBZ9ZcPFTQtMDItddumGwVN
ganul05oQEqeXHiBogDVbWv3dVE0QF0X9Xq5fAIM6cqreWfUYMDNpXyrkgBT
POOMCgs1yKEbRhRgt1WViYuxvSYGtN3Yd21+6sjFzrt5cVP4JwKMxDlapmL7
MmlE0GcC2B9RlHtjF819dIfTBICSwrfPF6lBZLu42UVDgDSWf+CkuRrMiTOS
9mL3BATwZdiVmTGMcuyy7NiL3djUHxm7OVoCtMaPjj7CvlstNLbXEcBlh3/O
MWyTgvgIhp4AFkxaDx27NgXoIrFFsgaSih0fYn0jH9v3ySlnFV0N6g3/mjab
JQD92cF0Kfaew/4i4znsiQtO17EtubZ+gdiSZIeIAmy0Wjd6EntsYZvgBLaV
4p7PApIAnemJr/dhN7XlygOwbaJ4+mjsA+K9uZnYpkH8pWHYrMz1HhLsA+FX
NvthP+U59JPYhkkj6W7Y/wFCQH6r
     "]]}, 
   {Hue[0.3224758424985268, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0nk41HkAx/EhjeMZhsmQo3GF0IwzivL9TnQNRY1zK2ql2GodK9XTLdSu
UdayjqR2Gc0q03bYlo5vaXRSarvEuhoKk9/kWHOZ33774/O8n9f/H4dv0zYk
61IolHV4X5t0uYggSRKltY+3Msw50Fxt7RKkIVGchJ+ZbcyBkpXCTdkKEmXf
cGroonKgS0/TY5mcRJK0irZ6JRuO0D7UdPaTyNbonGhjLxumf7co7tp9Er1z
yDyuf5ENDzu/v7v9BImm2eKgvBA2rDzjVNxuQiKlj2uT3v6F8FzvybT1hlo0
dPeXjKHX7tCigx/hxpxBw3CL90yyG3wUyQ996qxBUcd+3qYwWwBXuzlnOTmq
Ua1E+Wz0LxcYKN5U99xThZol0SG8fGeo+mn7HB83JeLGl9X0R8yHU9O1pQmu
CuQtVvZLvZ3gVrM11r3+02iJHWtvn78jrMpBnUyf/5CGeFjw2t8Brj5/5sz5
4ClUFd64wDzGHnquu5Q5FTGJUg7/VtdAs4OD/NO5lLUT6ODvJ3amb5sHadR3
5Ykbx9HBClBJl9tAHdOJj1nRX9DiIMHRfVnW0Lt+eXhUlBy5jna0XbOwghf6
iWT64zHU4xOuaPxgCU+ySNHAXRnamcIayay3gOHXO+Wbu0YQu+zQg31lTNig
jBOvaP+ERvOHJ+KOmMPcRO6v9x4NIW7YbXLVoTkwmDWVMzgkRaxA1SFJJQOW
CNYO7ukeQKr7SYIH18xgOz8jXDzZh7rovj06w6ZQka25ObWwB4XyGrIq2abw
tDDxyQ6794h7dfXSsm4TKMuLH3CLfYP49p+87giMYU5r1aBk2Uu0pbo1ar8/
DRoKth0wTWtDb07FhLHURrBSfis44LMEWc3fU8YfMoSBrpFX7IqbkKyPGz3x
1AA2pOhaOt6pRbdCb3eZv9KHGaMM24x5xcBxjrpveowK3djJsuSr18GTfDur
GT0q9NrV2GgpvQcY3U0WZwNmw/jjwmqe2RMgstI0B27Xgwds/JrHOjuAsVeF
327xLJjgF9JBL38F6Bx9myK9WVB/zEAde+EdqJvHpfvF6sLRqQDbyIxu4G9f
7WGAdGDYc5M/Alb2gaWnze1nnHSg+/FyK1/eAHA1ju1wLqXgf8fk5XtIAae3
qLHVkgLzfkw/sHvREBimLfZt8ySBTvedXZdsPwGF/ipteIQW6JvU+saqhgGL
xwPPjsyA9CJpbilFBlIXBIgmL2rAdFP8Cw/pZwALC0oo42rQ7+suipYT4NLO
SNpePzUQmFLXl2AXv6i22Yq9+HO/8iX2bvZcjzDsorqKsMgvBLjcWsCzww62
MiR44wTwS8sueOirBpXaj4vgJAGEm+KZc7H5j4X33RUEOBXFX9PkrQZa4bFd
qdiMN+TmGuz6nM1MEbZByNvMQmzdpcwdzkoCqP6lnt2K/ac418heRYAWk9QJ
Q2xaSdJ6poYACYwlom+81ODvdKDiY1c5laBQ7KS1NjXF2DQb67cc7GbqP5P0
GQJ43ayjzsJO2b+83EhLgLgbLTsueqqBeQyLuwZ7XJ51tBQb+aiGT2CzTDZU
HMG2kF0Jmk0S4P0XwVM+dsujQmkIdsuNEeky7O+FqYU52LLEH7Su2NY5K/zv
YeuNuMxlYLcmOPSS2I3Rs300HDX4HytAa20=
     "]]}, 
   {Hue[0.5585438199983166, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0ms01GkABvChzUizyJiRe2FkmMpl0BHzvko1iTEaRCm7ZVxKLhXb6mxl
DKmmyFLSvWaYnYou2lbb8WqxB5tSW52UkmmQkv8Uchvz33c/POc5v0/Pl2fh
1oz1YkMKhSLA+b+31ZYQJEmiYtmj9kV+XGg5beO6XEeig74Z6kteXNi8WhGf
M0GiEcU1E/vFXOj6tr5tSEuiQq+Zo0wXLvxIe3+lq5dE1cdGQpkWXJi53Tf2
dhOJdpRskvCHfeB+1qvGpEMkSgqIt82p9oGVZ5xLO0xJlD3Vxv9g5wMv9BRl
RM7RI0mOMsVF7wWZnaIINmMGxa/Z/jbV0Au2CkUh/7B0aPDg/v5ma0/IZ7P2
ODtNo2whn3IpdgkMqImverx0ChXu2KhtusuBU0eS6N7sScQo7+7Rm3rAsXF5
+ZZFE4hURZPyQ2z447y1Nj1+46jVLPcGy9MNnpWgLob3N5TMvz3Q8sQV8i+e
OXORN4Y04bIiv/MsuFRwbddYxCgKeHOTrs1zgX2iYiklfARxMqwDryY4Q5rR
y4qETV9RnYlDsPoHJ2hgPjKwJ/oLEpTZUd03L4ReqhVhUVFa5GbDi+nauQBW
9xJis7ZhZJxudavS3xEWOZBKdeMQirg7YjV8xB6G1XVpN7/+iI5n5q9SWNjB
65OxNas6PqDnYX+HR/5qA6UJwScftPYj3jvRJY63NeQ5jEn6+jXIjUYX+Oqs
YJksvC+7W434L/o97BuZsEOUFVYz+g458A4HyVUMOJGj+3OM8xYJqc7XvVSW
sFiR0J7s+Ao9amfmJsvpcKggTs3e8AKdcp6hn2uwgJKWs33NQU+R3u3yt53P
5sE5ssR95hkPEa1xsVapM4eV2vs8/8/NqEJAqlYDcxiwSHjTsbQeXZaeK3bR
mcLrKYZWTg1y9FCzzHFU+T3M+mRhl2VfCu7QxK7pGTTIXiweEt+qA04bkRgs
nQs90+7csdI8AFyLgjW+TBMYl684HzqvHdg5G9fWjBvDfbbce8NdnSDzfWgV
W0eFW7grO80qngEq8K6/S6dC6rDx9Ibql2C+bZzTL65G8NOYv50wqxtYckLo
wTGz4brHpr/5r34H3HfnzrKSfAfd8yusfULVoGxQXXShYRb+d0xBoYcGxIVd
lZnSZ8GCw5n7dvr2g/hp9W6LRENo0N2Qds3uA/CUraPtbTeAVFO5z4apQRDE
OiE/EGgAM0s00nLKELAImb9bdpUCx+vjnnhoPoNHZv5BkRwK7PVxV0ZrCSDe
e/JUSDQJZOZGkWXY8d/KT7hiL/vcO/kU253XedQYu6Tq9DrhFwLksMcOPowi
Ac96DhH6lQBrtlLSo7Ar9QO+cJQAJhO2okQRCURtiib3CQJUHU9cK40kgV6R
l5aKHZFyPzQJWyXZzFBib58RhPGxDQMZyaxJAiyJdRHSsG/USE0WTBFgU1Px
xjIhCWhl2yIZOgKo5qbmyiNI8EcmmBJhX0xKO1CIvS3c9kop9utslTQF+57R
v6NmM3iv9kUxBzvl5xUVJnoCXM4jlHUCEljGOASvxXbZ1Vp7Eht5Tw0ewl5P
7/59LzZz6Oby2SQBBsS3WwKx/2o9plmJncL8qcMBO12RekyC3Z6d/ZyCbSNZ
5fcA+3R+zRt1OAlatizsIbETgVN/M/Z/l69fmg==
     "]]}, 
   {Hue[0.7946117974981064, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzX8w1Hkcx/FdHVIsivxeJdQud+RnE+fzttihuNatWk7ikis3mx+nuuuM
ubOotmOU2ZwwZUTURLmhkPNJF0NSfnQNcX7dWkvL16/1Y23c5/54zXMef732
nEr8Ok6DRqNxyf5vUv/yIk9nA9uoe5fDbnjArm7+UZbxJ+yfYGv7d6g7tPP4
/p12arzft7Ywh+0GgSy783tt1vHehE5Th08ucKj6xL23TirMEj96c3vpAKiu
fbfThbWGL8oNGIxJZ1CulN08uW8Vv62osYz7xwm+NQwyH/FYwQLa+6nvWV9A
sQgPGLss476S235PhI4QWFJUVOKjxA5HY+XhMjY4ffXwB+XRJQzrO8LEaSyY
4Odm0kIWsYVeIoeptx90tfoLoiMX8P1Ay7qmDnugGyxOnj82jzW2L3aZ/GoH
Bx5wgsPC5vCfzTvbwnm2UDFGxel3zOJbYfN1OGAvXGVuVo4/V2DzDGlprbsN
BNcOzEUNTuPVMv9xOXcPVK2FVwd0yXGMuKevjL8bMqN981vaZdj7wjTHcJIJ
PkylaEImxW7DDsx7UVYgyQ6ZuDA0jn+Xx3emvLaALn5ycPXSKD4lHCnmCs1h
9aL6mdJxGJ94WTDRbm8GueXRr85Yf8Bp3jrHMz6YgCIrYpwleI81PS/rDz7Z
BaLW4omXX/biLtEY506OMehkn041SHyNqw4+bnyRagSFc00+njMvse12/2ux
v+2EQ/t4NdZ5DdhRopay83dA1VkNE5vmMpzA+aZmqtkQkj/usEy2ykO2GZPu
CysGwPo8ThH3Ry1qzncaeO5oAM7CujoTaQsSBPJ+6lpiQERG+e3Dhq/QDUej
uzZiPUi1cGucHehGfflqE1mQLpx08+vWL3iHaLwowYjNdtCe3bouqOhH2abJ
7m1KHfio9LTkJQ+hBc9p1aWZrXDkLeO+J3cUmQpGZc6j2sDOKDBzPTyO6G0J
vmZyLbAfPp512UGKshpaYwUMLcgSJ6Wec5ch/znWGx9nTaAPNQsfWspRnCTl
VtC5z0CbUeYqUE0hoV0ay7RhCyRdl2bepCnQ3KJRHpO+BVYaInocpDNIHb7f
uTRaA8Zc2ZXH5iiUy0kw1HlGh2wDrVAJsSSnbctyIx0Ozoyt9RKn7PNfHie+
fu/WEd48he5wHw02EfuY6VCHFyhUxQ6oTCIu3Jh0hyUK1QclBvY30IHfUf4X
e5VCMdLGsop6OmyUpwvjiblpTUUS4geiKONKYlnkv3npxBrexmfs1ijkMlWS
Hkn8uDpz224VhVRegzH6xLqS2FBjNYV+FgXb//iUDvVJSMUn7g0rtT5NHBti
cTeP+NhZK7NQ4katviX9TxR6Gpqh60B89hKnYNsGhZbtGMrhJ3QwOs70DSJ+
sJZDdRJjF9XUFWI/XdfpeuJdihovzU3yr1CM5BG/aM+R+hFfbaQP/kKcUB6f
IyJ+1+r1XkhsLgrwaCEuYBT1RBC3ntwzskksllh3cYn/AzPUIfw=
     "]]}, 
   {Hue[0.030679774997896203`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx30w1HkcwPHN1jqStYRb5CnPEZblqHw/OJss4VBMhy4kd8rDlLvG3Mi2
pJCHoTydXKxU2sNorlzje+QhLuMhE7JTOJTz8BM2a3Pc9/54z3teRmcSvolR
oNFonqT/X8V7eZS3JsfGm0OfggucwFX8bW2/rRzflNiLTuVyQX7jrAbHcgNH
ZjrUV/AcQbpeUxxhLsPHhxi/FLId4DvWMZ13Tus4WVbCCmVxoEKAxzQ5n3Dl
Zof/K7o9eFeVl1e5SbGLxb6aI9p2YHu8Plnqv4a92BeLjC8fhJmgPCHNbxUr
PezwLmixBhXGaEnkqRVcmaljeZtzAHaorb6/GPIRN6f3FO2qtgT7Bx6+wcHL
ODBqjjvKsYB7k1QMs2cJ26y8Vm+izCBLf7tu6s8FnG3V77IiMgXf5rHl8PF/
cF1Bt1Ga0AQebYSKvfo+4JAFTPs1fD8II91vtb2YxXoZsCL3MwY3falgZnYa
G4Qa/5gdaQRFOX4zlyRTOPnnFG5MvCH0BSX5itcmsKiMu/nBxgBkKZt/SK3f
4th0Vf3T1fsgTxTZG2vwBluJP9vfUdODhYywKcuTr3GyD3M3+zcdEHRWzHQc
GcLlEsO8AR4blHKiU9USXmK/Rk6GRK4NZcvP3JwXO7C4OyvuyogWuJoHNBoU
PsWMs1YCT7EmPDqnoG3cWoMvqX8ZFHZ/LyTNq+sl7StES2kVoTZPNMDSJmYh
pqkZxV1J255sUwe7+MePtafb0GGcO9w0x4Kwq6JKH1YvUtDN5/P3sCBV17Fl
aWwA6ZqOfD3IV4MIR88BZskwWj+dJWVwmKC49MXnk/dG0ZbmdW9m5x6Ylzrr
BSRJUL9n/lSTUAX4/ar3nXkTiHGI1+vjthusrpawHXym0Pm78o1CljKYvT2R
kXlgGjWYTbhWKSlBxvXE1PPcWWQ9k2jxw6Yi7JC0xtfrfUClFeVmumqKoKha
43BSPodKTePEDVwGJOZPC4tpC6ivmtXYcGIXrD8NGzwwvYgs77L3rxbuhEkH
q7qQZQrNe7NGEv6iQ44aI7CIWGbQ3hpK/NXi5MYQ8aBtVa07cX5tKT/gI4UE
sr9TNIjd2EqUzwqFnExusH/vpUPZ1nsurFHo+9sBsVs9dAjqET23klEoPv25
Se4LOmyJ0uPjiKO7dNRTiB8IwjXriLVc7mxHECsc1ow13aAQv9Z23I64QSxU
NpRTiHfrQtFwNx1UiqICNTcpZJgWzdQjfpKI5EHEwSk3t3cSR/npVhcSPyue
oRa76NDCeLXG/JdCXXzdQUx87rJHifIWhXSya4qjiPee0Hc/RuzR4nzNlxhz
5HPXiCWqsp+4xFoLjYd2bVOIZk4LVyRuf5E77Un8Zu6o/3InHS6I4nIFxO0D
z9zHiHUEXk5txGfGIxzbiTsjjN5tE59WOmj+kPg/YX4DjA==
     "]]}, 
   {Hue[0.266747752497686, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyXkwHGYcxvGl3XVU7CLrjBVClFAJsTQR7w+ROoM6NqqIijpG6miaqSxm
skGOodQRhLRmakvFSrOhiSNedyXDOJpoHBNhlhDLbrBsxNG3fzzznc88xt8k
fRmjSKFQXMj+r/73AmlcpBybbI9uBP3MBtlmdUmEuRz/Ndx4L/U0G6I0PPWn
2Zu4WXqmYWufPVTy8DjTdgM/r23J8B6xA4+qiooqZxmeqlV+frbVFmzO1qfK
/NYxvyLhbXjLMZgLzM+i+K7hdNM8c8XGo6BGe1kWGbaKi3p076ZU2IACY+3N
peB3OFb+a9harzUcq3P1CQqS4nklzOcwraBmRhJDf7qCu/LbkqrLLeEGa692
tkOMd0aah220LcCncVwaPvkWh2Z6RTG7zEHw/lyD++AC9vZrsL4bexiyIl1u
d/bP44qhT9wufmoGziwZb25ehE07P5t2Y5hCca7v3A9Ts/gOzTG7YNUEBgNT
fBrWX+NLol5B76YxyC9vt8qsXuETRq73PtCNIZ8f+SzWaAKL6Zs54YcOgjg7
dNaCM4Zfh5fRODUs4PVWzvWcGsXx7POTChRDUMm9wGUkDeAViya/jTQDuCNt
c3ZY7sGfZw163D2kDyfM/R8YFTbjGYdzRl/36YIgTlHHpL0aZ8y+WO8v0oGU
Jc0DKYaF6FF6ADfuR22wsI4RxwgbETNhyOwjDhOOJjY16Yg6ke9Xa+Ldc/sh
9Br/Fy+NZ6jN6LY7NUQLuAbHW1bGh9HA7v2M+6maEHHcbZhe9hzJH497llZp
gNKK8gdOzUv0+OawtdUzBizJHA74p0yhMXODOdk+BngPqf/hcOY1WmfVCy5U
qoPltTI9O69ZNJGZI1Q7uQ8OvwrJzjkiQlNFWxqLH6tB9s1k7kX7eaQ18YhX
2q8KClPtifUHFtBgdfdDsVAFlNSr7Thbi+hvs2A7T6EyJBeIskooYlQXqD7s
Wq8Em82hI0dEyyhkSVX7dB8NZuwsa4OlEuTh11g5NkmFXAYtoJg4QvgkrZXY
cXnm/SixjeN2SBVxwe/l3v7vJOjbOl3NBGJnPRWJ16oEdRgO3dqZoMKd3Tf2
sC5BhnPHckyJA5/yuy3lEpTGGqhOfUmFXf7VxHhiHj3tBoe4jhfOrCX+Qjss
0YlY0YkZa/ZegmKi24/TiP9syFI9uCVBhVKF/vJ/qaBWHB3A3JagPm66vGOM
Co+T0VYg8VjplWk+cbSvwW+FxKbdgr5bxC20f9bpO+R3f1gSRByX5lqmuitB
ztIT7IUXVNgfwnLxJJ68MsMaJMa2W4vXiS9rPFESEmuLH5yk7kmQUpTWBJe4
qz9P5EZsrfdT93ni7/jxeTxi4eQpgTuxPs+d3UlsVWtSakncG2E8vUfskOl0
lU78H3KQAyQ=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{-2, 1}, {-21.167166939618426`, 22.567702700147613`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Verwechseln Sie in der Notation nicht = (Set) und \[Equal] (Equal). Bei \
Funktionsausdr\[UDoubleDot]cken ist das besonders l\[ADoubleDot]stig.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "=", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"deqn\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equation or list of equations expected instead of \
\\!\\(0\\) in the first argument \\!\\({\\(\\(\\(\\(\\(\\(2\\\\ x\\\\ \
\\(\\(y[x]\\)\\)\\)\\) + \\(\\(\\(\\(\\*SuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\)\\) \
\[Equal] \\(\\(4\\\\ x\\)\\)\\)\\), 0}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Einfaches Korrigieren der Eingabe hilft nicht, da  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]],
  CellChangeTimes->{3.36430942397709*^9}],
 " ja nun durch 0 ersetzt wird."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"deqn\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equation or list of equations expected instead of \
\\!\\(True\\) in the first argument \\!\\({\\(\\(\\(\\(\\(\\(2\\\\ x\\\\ \
\\(\\(y[x]\\)\\)\\)\\) + \\(\\(\\(\\(\\*SuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\)\\) \
\[Equal] \\(\\(4\\\\ x\\)\\)\\)\\), True}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", "True"}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Unset",
  FontWeight->"Bold"],
 " l\[ODoubleDot]scht die Zuweisung."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Unset", "[", 
  RowBox[{
   RowBox[{"y", "'"}], "[", "1", "]"}], "]"}], "\n", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", "2"}], "}"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve im Einsatz", "Subsection"],

Cell["\<\
Eine Testfunktion zum Ausgeben und Pr\[UDoubleDot]fen des Ergebnisses, mal \
als CompoundExpression.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "[", "eqn_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"DSolve", "[", 
       RowBox[{"eqn", ",", "y", ",", "x"}], "]"}], "//", "Simplify"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "//", "Simplify"}]}], 
   ")"}]}]], "Input"],

Cell["Lineare homogene DGl. mit konstanten Koeffizienten", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}], "-", 
     RowBox[{"7", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"6", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "3"}], " ", "x"}]], " ", 
    RowBox[{"C", "[", "1", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], " ", 
    RowBox[{"C", "[", "2", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]], " ", 
    RowBox[{"C", "[", "3", "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
\[CapitalADoubleDot]hnliche Gleichung, aber mit einem St\[ODoubleDot]rterm\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{"3", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    SuperscriptBox["E", "x"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "x", "+", 
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}], ")"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Lineare DGl. erster Ordnung mit nichtkonstanten Koeffizienten\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"4", " ", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"C", "[", "1", "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Bernoullische DGL",
  FontWeight->"Bold"],
 ": Das sind DGL der Form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]"], "[", "x", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "x", "]"}], " ", 
     RowBox[{"y", "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"B", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "a"]}]}]}]]],
 ", die mit der Substitution ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SuperscriptBox["y", 
     RowBox[{"1", "-", "a"}]]}], TraditionalForm]]],
 "in eine lineare DGL \[UDoubleDot]berf\[UDoubleDot]hrt werden \
k\[ODoubleDot]nnen."
}], "SmallText",
 Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "x"}], "-", "1"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"y", "[", "x", "]"}], "3"]}]}], ")"}]}]}], "\[Equal]", 
    "0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]]}], ",", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"1", "/", "3"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]], ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Riccatische DGL",
  FontWeight->"Bold"],
 ": Das sind DGL der Form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]"], "[", "x", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "x", "]"}], " ", 
     RowBox[{"y", "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"B", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}], "+", 
    RowBox[{"C", "[", "y", "]"}]}]}]]],
 ". \nIst eine spezielle L\[ODoubleDot]sung bekannt, so kann eine solche \
Gleichung in eine lineare DGL \[UDoubleDot]berf\[UDoubleDot]hrt werden. "
}], "SmallText",
 Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}], "+", 
     SuperscriptBox["x", "2"], "+", "x", "+", "1"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Dabei k\[ODoubleDot]nnen sich Integrale ergeben, die keine elementaren \
Stammfunktionen haben.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}], "+", 
     SuperscriptBox["x", "2"], "+", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], ")"}], " ", 
      RowBox[{"AiryBi", "[", 
       RowBox[{
        FractionBox["1", "4"], "+", "x"}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"AiryBiPrime", "[", 
       RowBox[{
        FractionBox["1", "4"], "+", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "x"}]}], ")"}], " ", 
         RowBox[{"AiryAi", "[", 
          RowBox[{
           FractionBox["1", "4"], "+", "x"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"AiryAiPrime", "[", 
          RowBox[{
           FractionBox["1", "4"], "+", "x"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"AiryBi", "[", 
        RowBox[{
         FractionBox["1", "4"], "+", "x"}], "]"}], "+", 
       RowBox[{
        RowBox[{"AiryAi", "[", 
         RowBox[{
          FractionBox["1", "4"], "+", "x"}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}], ")"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Und hier noch ein Bild verschiedener dieser L\[ODoubleDot]sungstrajektorien:\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzX8w23ccx/EvSRrL0cqObFU6VbR0W1W19WveH7XJ3NHSIQmt0VaKlZmz
YkoV6Q8LbeLsZqYuVT/TaqebmW1STrDZnFulTv2MEk0wiZ8R+bHP/njd8x5/
vfad//xMojlBEAjv/05+UyRoZ07DK6bTC3XirMR7InUgUCiHP3u0Y06t05Iu
XUHocNUriHh9QtccNCJJkvT3dxbOQXZ4XYrr8t+SygsNdrbx8xDqvWGQyDol
77HlG8ZEJZwsoMUFZBZLJldPD6KQBXAvPMCzOP0TrEzt9mBELcHxOi8hJb0X
7oq/usRiLcM/n5yxvVI4BK67LMKyq9TgnnmWfpcug7b0AnFZjQZK5o4k8ppG
YdilnBohXAGOv8wytHkCnIueHzxXuQr64ji1x+Q0+IRPedVUrcFvDxhoXTID
E+m8gFL+Oixzj1zKS5mFVh+OlVSwAVLkScvarwBGdN9oI28TbO6nvpx4NA8w
Qwi6M7Wg8VeFPHBSQiUjyco1ewt0PNsrsiYVFN5LvnksRQdyN2r7ZctFqB78
trcsfRsaQ+w/QkVLkJdWrnbI0AM169OemIV/YSHh4Nuc8wb48mNtvtRODV8b
VORJrhG4AfRrnAE1dCwyl3fGmOAtcU3txTQNvHDxnvF1JtAbD/uGtZYrkOR2
4XB5HYHaRHuDrdpXoCs6Njdwrxmqd/BaobNW4Shb1WQjMkOmfqHSgbQGl4uC
Rz7YY46qFezAp7VrcItroTMrN0cT8pF3Pgxch98dEkwqGxJiDiX6XF9ch1+M
N0juZSREHx3fJeVvwODTIFUpnYzu9Cnqd/ptgtSR28sXktFtTzJ5VrEJxT9H
ieQ0CjLSOrbmbmrhrNN4XGwpBfmaxdlHnNiC7bbDew5Rd6DZfce5yrEtuEpS
/lWRvwNd89Ncp+frgOHsk+BCUFFjd+rg6/e3ISsteo2WQ0Wy8vQDfwxvg4ZP
S7HVU5HifguDd1sP9sWBNi7YInvBs++wmbnZnV7Ytc5ZKU+wq5MVb0ZifzEV
1jmGHRLc/asQ241w5XqW6EFkyrGyNlCR/1JB2xR2RIbyCc2I/9PkHF++Hq4m
O8baYR99fIwcjt0Qz6K4Y8/llbYkYhtOSTkh2B1SJkmA3XRIZH4LW2tUPJzH
NptjR1JM2IwhoqJUD++O3zHaYH/mc07cjM163tvojK1WLkU9w37U5WUIwvZb
3y1ewObcs64vxK778fuok2V6KK5ghgux65nBBBv7MT9fJ8JuTVptTsWm5C6e
6sJei2QTldgeGfu3hrDdHK3FLdixyTG109gXcwaierBvxAvC1NgN8SXES+wf
WP2bJmyNLFS8jP0fpjn72g==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k423ccwPGIkFbnaB3TKI+5VkcfVqpou89PHVk6lDkSQl2PqzNT1FFX
F0e1S1Tk0TEto4561KxFO6zyxObodCYPc7SI2xL3UYok9t0f7+f9vD4J+far
MDwOh3NG/X+lhiteD4/1wCxZb3g9bI5LyQzOafHpgT+cRt9a28xxX6aETVTz
+8HxnM7N6E+nuGN+X5vHJQ3CvLLLPa3QUe5xMiuch42ADmNC7VITn6syFPb8
PP0dfJaCN+6w7Obq60bX5YQIwPBytYy0tZlrM/FNn33hNEScJ9Mrzalc3v5t
l6HSWaCxhd6uGs0Qye3t7WDMg3ZDpaBJ1AklobUk9aBFSCQ0nylS7oMztOkd
aZgQnk6/jip/yofJrav9GGUJpq1pkSbu/8Cm4KSFhvcKOJIr1kRHx6Cg/lYE
lboGHvEnTtJvj4OR8hHX5NJ1WKWRdvY4AngRe7s+v3wDXCYh4VbINAwZcoge
hZvwkc5QaubADBhkDZ4OKNmCq4lEpR63ObB1F1iVl27Dsy+zVFta52EiNudz
FvM9jGzOmK3iF+G5ra9iF3sHdlbOLvgH/gsaPj1jT3J2IVi/q0CzTAgwg2N3
JnyA7W2S7wO+CEo0IhWNkvdA7DbJ7yUtA6Ms6s656/swFWBsKriyAo/6i7vz
Yw8gVZiZqFC4CukxnHXtODEcI5ge/sxfg6Xg05q+IRLIfxW7m5++Dt9LRITJ
cCkkPKBe7NLZgLZl8pqS3yFUvyUkx7dswLChzYydAQ4z85dK7lE2IdI41JxT
jcOEN7qXRkWbwPOhp9rryGB48651ZcYWWNJEdWoVMlhwwYXueaNtiM5yHrmk
hccCTXJ/+523DXnhR/ZlOHhsdjLdheX3Hl5pBx+K1GQx6+JRXoTMDrRKc2VN
8mUxu4viOZuyHehvchCxjhOw8JvFzEDKLnTphnczCwmYacnllarNXch+6V0x
rSCHZRi/tqtlfwB/vfFrdJYcVtymruUIe3DwwlzLlCiPDSx00hJn9iBNVvim
KEMeI+k5cVKy9kHDwDbYEEfEmmYc5imWB5AU47OtkELEBvMz8EGjB7DBVLiu
LiZixY2UhQimGE5l26sZIre3v0lLRyanJndYIXvyPVU5yI+iFk54Ib/TjME6
kCnOne2FyHzNwR/VWGKoOExRVJEQMaWxa+48ZI844S8KUiLGgPQO0n0xpEXp
0knI8vHfeVsg1wZR5UyQsxvvLjshS9y6fCnIEQ41pBvIdaYV+Dxkp2HlpB5k
mXmal9whEVOtrrJIKBCD2fh9qRpyRriw5y4ydbD7iQHyY4uzgeXIDTwriQPy
x4K/WX8i+5ap1DCQraouLOmyxZBdRHYvRCbV/8SwRm5kZuxXID9sO0pyQZZL
XXbjIcdvLX6RhGwRp783gMw7FTDFRKZH+T2eQv7BbTipEjk3iO26jizJ81T+
FfkZtXf3EHmhb6jmL+T/ADqBKMo=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0ntU0nccxnHECx5bhUspy5qbgmZ1zOYO1bLPz3lOThdmmRKapeYNMy+4
jKLQY6LNgFJzXZy3moWZ3eye9gu81SrXpkfnvFukoKKAYnLRfffHc97n9f/z
dXTKnlgigUAIRPu/n39KLg1KSd3u7nPJxTtPhufGuLr9SQuEp2NrPR1jZPg7
1cdEEe0AiB+d7Db3keFTdb7CJFoypGsuasb1UjybonXcT+ODx4OdBmqKFH/T
GiAPpolh+fZlZE/WSzylIuP1LloZtGoaqjzj63GpUPicQbsN9Vvlw97EB7il
FYekSMSh26VYl0YX4P6ZUYKHoa1QQeFJAlyr4fHx2L6qv9ogV2q7iCd5Bt1h
hz04x9phuIyr68ltAls/UZwU6wIxa+mpgd4/gNwRe58e3gPtEUsYGbfeg7NT
UrUgegAaDqXqnG63w+a+I298CocgX8Lv3c/sBKk+a2dHyQdoXEPN19p3QwL+
6tWLbDloHj55yMvrgcuHbqy0jxwBJSet9ER7H2zYN6Sbj1VAV7CvfYTjIPRr
d7Vh/mPg8CvjccbGIdAMOGykhEzApmW24oI9w3C+5kQ8kzkJkTefLH8Z/wFo
S60Z3JIpIANW3BPzER6lZtWIy9XQ0vghaoIjhw5qEWl3oQZEZHnGF0mfwOV0
u1vEZS1cCZ4kWnNHYEvQgFd5yTQsi5bLGPxR6EsVbBcJZ2CUraa4pivg/hbW
4uYCHdTlfx9755QSKKGt3RLBLEzyTNnbuGMAw4QC2c+f4ew5ZYtF6jhcpiQs
pnHnQO2c9JU0cwKyy9h53yXqwb948zQvSwWlbZdaxKkG8OzJc8i5Mgmnkoum
VnOMcK1GUoOzpmAsym0FK9oErZH2k3X9U3DWpLToj5uHH9QB76zT1PBs3G9y
SdgCWHddl9ca1NBJ3Ty81YWAEVk1F3IEGkhYe8ijqIqA3TvSdGnrai1IQ8N5
PmvMsPJFoXLZLS18u09ZbVdphlVV/M04ETANSad3dHmvImL9v2XG3B2YhjNx
1nqzIiJGkv/DbkifgYbVUQtKO3Os5MbRg94UHTydzzV3F5tj63cdW1p5Rwdt
db5Kka0FNnFh/V0JcxaaneJahIUWGH+072bk/CzkPA6pHLKxxLJVv8zElHyG
/d/0HggXWWJqx22vvfzmwPDIY9U6khWW4W+qN1PMwUlzxdtivhW28+rIxcEz
eqC4bImiEkhY09PfGTfpBjiWHDptc5yEOW/gsnU9BlALbRLtjSSMjpUcDjhn
BMccHzsqsupfmeogsh+P+8IL2V6vSjuKXMr+9OVe5PLmvdwKZP8dsueFyKPn
QwU65MqF44vJJhKWptlUcfW8EXZzFHdt5knY7vuB3foCI5xkO4WvRA5qs4og
FxrhRiTT0h1ZcaRxkIpsCmxm+SN30gNGg5Cr11USzyC/nxHNXkc2k+/ba7lA
wtLtVJTgIiOs7z03b4dsHa+6koDMbG+RuCC/2aZdw0eulXqZfJGb02xcq5FZ
ZeTr2chdhBT6AnJOsV9QIbJHUtFzuwtGuCPk6yuRM8PqwR3ZkjceKEU24Kt+
DEHeyHGee4+8gr7nbSJyODvs2iCyracoKAs5N7KAMYU8Uvu2oxj5HvPV7AJy
fi0ZPcwI/wEM/m3Y
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Hs81Xccx/HjcPzs2FE2jpJKc84hxyarPUoPzueHcrIJZ+LkGhrFjstO
c5tCLifmUM5hlAeylsi0RVF5TLGHWDUzlJTTyfXkuB2XXI5zjn33x/vxejz/
fe8Ki/06nEggEDzQ/u/qVzHlXrFxrEN3nzEp9F4QfGNp9Q/DA86fGOw0sOuF
v2fHovIZwbBSCpYUx15QNLoIeYwYaHrdYEfw6YUM6qJZICMV3tXEpz/M6oWn
nV+OezMKAN5TQq6N9kLs1YS/PBkVkD8Spqtd2QdtQmHLUcYt6NykzrX/8DmQ
dPnYZNRD2LUjsDRobQDc0kKz7/p2Qu6pIuHQ+VfQnBwuuf5vN7w0Z8koPUMw
6P+tLT+xDzqUGiLFXAqG7PyINnwASm4NxZlefAub+8Mb9ge8BsHN+w5HCobB
wpxXmx0mhbGoiXr3+BE4IIl+6iQahjvRRiaujqPQpkx37y8bhXDSyNsQbAxO
P+zqas0YB06wQ7D7vTG4fPKGqXGIDArtXch3Asfh0+PDy5rwSeDY1nBssQl4
s+jZjbtNgTY9OGX06gQsSLfuofrMQF4JiylxkcGluh9OcblzEOQ8E+cxIgPG
Jr2jSWUKUE1z9fkJ76ApLr2uoHIeuLHmZoe3TkI/XYxxRAvQ5e2HNd6ZBFpm
n1XQ5UWY2HLb+0iYHOy9pPsqy5ZAn/hz2s6Pp0ASl83KF74Hmx/p5xpbp6DB
3o/SUbgMNRQBpS59Gqi+nYM12SsgEjeQWxxnAEYIhe3frwIt2lrnjWYGLlNP
UxhJaxBRrT7BGZyFjIrIC19EKcECrskq6+egvLv0cUHcOph6CnP5Hgo4FyNW
bOerwNin6UFClwKmQq22+IWpof/Sr89YrHnIU8t13kRoYDbPx8u6fR4eTLPn
DPw3wDjWt9LEaQFe0A+MHKQRcIFD/AvZowU4vfukrfg6AafvP1Gy13MR2nwD
Upx2aOHs8dti5sAi7D0urzWq0sIdFWmzr6OXgJfpOuC4jYhLpiyTk9VLkBOh
p9QSE/HDPJPyfvTDH9tDN+RG2rjhRCuDyFyG+xqBtnWBNn5KrrqifrQM3Y0u
8nxDHTxtfs5EHr4CHeYRj4UiHdznCQs3Ia9CVrNP1TCZhFd/MM7ceX0VAj8Z
Cg7IJ+HfPe+ztPBcg/Um221MTBe3o50R582twVntyWfFqbr4nwuMS64FSqDS
7EPpBAy/or6HkR3WITHGd4mcjOHpvDOBQuk6zAvJUcYqDM/MuVVtI1KBWZaT
ER3ZoD6V6ozMTklq3Yfc0+Mt4CKXR058dAx5wJgSkYHs5treIkIeLmqhv0Su
2kimbFZj+C/BetWZYhVw+JO/kzUYLpOE3HxVpIKzkeYBpsjqFz2mCuQbIVyS
NTK1+3AeqVgFao8OPzdkvInF24Ncy6wi5iAfjOZ9JkDWGj9+jLSB4aLo5ka7
n1RgM3RRY4Rc7pxIYyNz+x7X0JCpxg7Fgcj1bfvULsg2Df0JF5D9KjZXZyBL
nzodlCBnFbO9RMheebvrFpB/E6Yqq5CH2VQzvRIVkFKmPdqQ3e5p1J8j7+Fb
rPUg6/OUMUeQAyL9r71F7jRblwYhC0IKjyqQE58QOGeQb3O7VjaQKfH67TnI
/wEj/FhD
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0X8003scx/H5MQth1aaLErHlRpfu1V1LeX/dTmluidJGq47JZMtdrtMR
N7+OH7s6d1bsukiRupHrKqnm0A9nnSNL+dGl3JKwmmyGMWQzcz/3j9d5nsff
L/eYM4e45jgcLhTt/y78KLgadiYxsDF54n5pwzAIYzd5dVNDwa9YpwDpMHRO
fuIXUE+Ala5ij/LhMGjv7RYlUAXA8LSu3dw+DNmOunXHqBnQ1L9FVTk4DC/a
Q5SHqWJIrN/P8rcZgTPXkp8fpFZAus19Gj5mBGQi0cMD1NuQfPHCAmOlAvBW
SQQVvxVo2fzDRO5HYGRy8h4w2yFT7nQ44MInaErlDt581QXWuQFUvkgJb4+e
9k061wvBB+tqHPJHYVVwQZwM64fMpJBTP0d+BmIft5HGHoCdm+bH3DeMgYdb
Qm1ezBDU/J0a8Uo+BtsHf3oRVDQCr89KGooOqUBmyNrfV/4RMmdIJd/0qSC+
VS5/kq2Eaztbe7Bdaig7WeNMjv4M7Hccrq5EDVsiR+ZNXBXUp/PcKqbU8EF3
sAtjjINpy61L9B3jMDPk5Od4ZAL+vLxPkCIch0t1v5xisaaA+X3k4/bucaA6
rDiQUq4FfYkik0fWgDQxq05cOQ0n9+UH6mI10EeREMKLZoDlHDDq/kADnjm9
XsfLdNBOy1RfIU0APWzIv7J8FnKvO8++SZuAwcS8wALRHPz7bb1n09gENNKj
7NoK54FHjlsbwZ8ER2b721t5XwBvF281OjUJoMAVPj27AOf8iWOmjCkoc4y3
o6bogTnZ+ZcZSQvZFbxft/ENcEObcDqcp4WrXaXPxImL8Hpu4fjdl1pIF0i0
65OMUMziDKzcNg3jHK+vomKW0C+KSvqVafhtSW35Ic4EFhRCs+/qGWjRBE/Z
H10G32TrH+7nzcAbynbFDk8c1tffNyddnIH4r0/6Sm7iMKccoU9blg5kTPb5
IFczjLlm6VGI2Sx8F6muJVWZYdRNW8m2hbOQkLO3f5eLOabZ3kHf4DIH+XEr
DGYSc6w629W29+YcPF7PWVaTLDC6B9lHCvPQbBJabBZbYLRDPpLQf+ah695u
dcEqS2yd0KvD4+wXaHOLeyYqssTs1R0NcvIC5DYdqRqxwWPK57Kh17cX4NjG
9yfYBXis0/CB5sDSw6LU18WbYIVZ2ze+XzOvhzQL1cviDCvslXd4Wp3EAI6e
dA4FR8AiWbVreNginBMwZ21SCZjrHuGA+8dFmBbZ8MlGAqZvFpfYFxthXW4Q
iYJ8N8Z21gM5+HzKE39kv7yCMDryVd7o6ghkNu26dSwyY+/Th0XIxlC7tGbk
quVUO+ISAavG1JzYP4wQnqRqsDERsHdvnmxtKTFCGs+N7Yz86Jpa3I1cE83C
b0YeULhoPiEvhbZFMZBvdIurHUqNUOtdZZ6PrGFIXbjIZsrICPwyAbsttSUQ
y4zg8/6iiYR8xSSOpSCzep/d8kRefrz26Q7kepn/0m5k/XV6Ohc5qoJYnY2c
YNmqa0HOLQ4OK0JusRKE9yDfEWUYqpCdsjbeUSLjz2tCZcgT/eV84mUj+CV5
6HuQ90qj5RRkNu/ojWHkLFtvagCyMLrwgBb5935DThjyXZb8yzKywLlnhIv8
HwPNYM4=
     "]]}, 
   {Hue[0.8503398874989481, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Gk4VWsbB3CRoRGhY6hQ7BTSoKJT/ltIiuREpjKkRJxImo6SBkSUMUPI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     "]]}, 
   {Hue[0.08640786499873876, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8VW8cB3BlJqVEmYWMsgtFxZeW0cAvUbaUrMxkVVRS9krDliRSilJG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     "]]}, 
   {Hue[0.3224758424985268, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VG0UB3CRJZUlSyIqWcpSWSoUZ2ghLShbRCKyJYQoWUrIUiiV8BIS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{0, 3}, {-0.6374439413359564, 1.78979066862376}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Auch wesentlich nichtlineare Gleichungen wie dieser hier, wo y' im Quadrat \
vorkommt, kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " l\[ODoubleDot]sen. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "2"], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     FractionBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Am Bild der L\[ODoubleDot]sungsschar erkennen wir, dass es eine Einh\
\[UDoubleDot]llende gibt, die ebenfalls L\[ODoubleDot]sung der Gleichung ",
 StyleBox["eqn",
  FontWeight->"Bold"],
 " ist."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "100"}]}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1H8803kcB/CdYykULXck1kSxYtOuRK3vO3F058T8qFFrDUtr+IaYsJQf
SZc0wxhFSaKUrmM8yj5S6nE5uTBKdVT0y0Me6S6hOd8e98f78Xo8H+/H+4/X
P2+aIJoTrkMikXxmh8iUV798mJlhodqr+KeZGQkMJ333T/80C+FGjolztRLw
Mf77U8NnFnISvZtcOC2BpS74l+hxFrq+TKi1nZDArWyZ/sAwCzUWhOh5j0lA
37HXCv3JQneSf6QoBiQgj+P/nKpkoSdeSxjMFgnUfBNbQXJmIYPBu0L+EQno
hXuuNt+5Gi07I1YzJhOA0ndHfPaUEzK8MJWml5QAnNbiUPs/mIjSBM+42nhI
es8W575gIE1wF80yIR5UCcWiK1sdkcjD96/hiQPgIwtcqi1ahVQ3F4uo+AHw
LL3p4zVCR8s3KRWaN3FQeTdRExtij8Lmk1lycRzw0uWmD6pWIN7e5nr0Mhak
/G9rDSjLkd383ZXj4bFAcqCqN2fYIOPmxpXn38TA4+NFR2t6rNH1qV3FdwQx
sGRexMWPbjRknzYWN/JyP+xbQ9frX0JFXEXHuiM79kOo87Oq1lYLVKUSyAo0
ONAlrjNRFWaozXpwWx0Xh/Kn/rcTN5kitzXBRvEV0fDqsOkGT7OFSKFqcyu4
EAVN+XYer4OMUPi2jp/k+ZHAfPPoI6OUjHBDN+nJLDG4N/XP/RJEQhaB2ccK
T+wD/OKVCRPKuJrdGLknJUUEQcJl5Q+TH6lJdbaW+KG9cLf9UTbLvw8jqbdo
d2VGgKtDyzXfwnFM8lr/moNkD+jEmz4JMydB7vkStn6yEOYY+h4WjJKBKr2v
RKJwSBvQbI45ZwQjYqFtPC8MriozfaUfTID7vidzXVgoRJ8NM34ZZArsEwNN
fQEC4ImKLY8eNoNbzeq2jG274ZhfvAurxAIyyAZaxi4+6C7KHz40aQXSrucL
8HM86L2fMZa+gAaslu1dRZd2QGCSYG1xqzVohnQ3HDoeDGKDd9YdwTbQ6BQc
IM3ZDtSatgLyW1swrz7amqAMgiTVZv8FyhUg5L7rXSUNALxSXL+WYQ8fGRPK
qXQOGOo4CxyH6ICz1+tl7vYFj8iAfHreKugevZRtmusNZo2W0R42juBet0bE
Oe8FspisU8xeBsgH6XKy0B04mVsdSuuZEMGPsRyNAqCHpAdWpDgBH++ukn/v
AprhuWfzAldD2VRJzfoqJnQIhjYtpLJgwHPRY5mMBsX5JuTEzywgkeZ1436d
2PPMW7Q8wu21RSuNOzF7SSz7MuEfLjS3lz7AVME9cYOEI1x7GhQdmIZa9GLL
5Kw7+To5Oe0YpXppy+KpWZdd3uF68B72azMj+cb0rN09TfL8ENZ9ZaBQQ1hF
czE5rcYsyk/9NkZ47PrWaUUzVp02/tbmy6z5/ckPc25g97wauCcIM+16pQdV
mG7XRmeedtZ9Lcd7/a5i3rffcySEjavdM4pqsbzfy6JkhFM794ecvIRZK3Qq
2wjzLdvnJFVhsLNtEWOG6NuQyueUYVk+CcwthFFTSGRuCfYAs/MOJVw2p948
WYHxrLPTCglDuSjGPxerpKw/U/f1/skxtjQLG9UdabpPOPXAxoLAVGztvyWa
oa97q+GnXBz7/5/NmlRx2mpw43+9ZDm5
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1HtUjAkYBvCRJJSM0RpSTTXpIjPz9Z1qFfUmtrFSKROlZjOFdJlmaoZS
qDWhsmubSia3JBEbyaV0yEtUB+sSRjZLKw3SZkzY7rOfc/aP9zznd55znj9f
G1FyyHoDGo0WSN233PZ2hU6vJ9G9bfmA/ic5aDK++9IxQmLtiRdXvIRyCJz2
6t+6QRJd0pMytkTKgbVAMprcT6Ita99Y3xo53MxTGndqSDQVtxm+XCkHY84z
K/yDxDeTwulX/eRQJItennWQxELfDc5pDnI4My61guZBorYmK1LbJ4MJ6/1d
Z0W54mNHvotQJgNG++3E8gIC85Zxoz6Mk0FIU2mM0x0evjSdyK8rSIWMj4sS
f+viYkSC9AiNmQr1W0rjzwVx8HfpsGBTZQoEKgWsMZULzqUz04PmpYD/4WuB
/F5nXLjKPkxWK4XKlnR16londICQonpfKQgVReYPTjmg522699YWCWyPHn92
CmMusvu1/LUCCdDmW1/3y2FjcG62xdc7yfBnvmr3mae2eFr4QyavXQxzJsdV
fV5sgzU5Px6t+pIECW7OEzrmWKPRq1SVJS0JYjxenmpqssCiHdsnmpklgnOa
p15cwcR70lYPH04CHPsr9Fa6rzkK9nv4xHvGw9ts84X+zOmYa6IxfhK2CRqK
HZe+CzPFqZeuVH0fHQe8988/cw8b4d0KceNs8UZY0tAxaTSMhq4aUbHX3g0g
qTo3QGf0X+8Jz/RbXbIewjbYHWvLfH59hfXTC+drY6Hl3vM8MrTdRzPP7EBu
Wwx4zr9RG1zS79MWLw6NfCUCg83mL2Jn0SBu2ORR0sg6mGgSnC3qM4Kgxof2
W43Wwc5OtV/KcVMQt8r7xptHQ83BXcHbdXRI4l/UHdgohOTy2GlvwsyhPLbl
svWOSBDGl1ruzmbCPHa43q4uAnJXbl5AHrIAu5Rqrt3AGjCcUazZMWQFjeyA
qUzGanh2N0erMLOBs1s3SfMCBSDIELmXNtkCuD36WRcTColTPtjej2DD3MI6
ZrtqJVifad5v1GMPQ2PoIj0fBBn1fqFmBx2gt+ykwrJrOUgqEy+7c51AkZvf
fUvABxMDDxGn2xlivQyPr85cAkuTVhU7F7oAe7IBr/MiAPOKZfJSNgem+Qzl
t0R6gjJlTwHvGRckI7OkJ+pcIWRX0PzDl3kAv8Y91Dk6gPNahaBiGwEsTsxg
16rpoNZMKi8UuAL0tipz6MZ4X9TtO92ahCwdq5zPZWNpMd0ofZCEuMVH3H1v
E/h6102bQsraa2quSzOBTmmpi6opSxaYOc1sIbA+4qnsb8ppvCyLf1oJVFur
upYNkbDHSkRT3SOQcZp1Y/YwCaeG7O9oHxO4t5GbeXWE2qutjip7TeCTc50l
asoSjiYsv4tAi2MFF7Tf+iqr4M1vCDy9s7+HPUrCQNm+xQEaAlv5deG/UDbe
J3UYeE+g4WNvD+EYCawEt09BnwgMuPUxJI1yjSapx1NHYOGlMrGSsqOossu+
n0DbAwaVzZR54TPVw58JhKjmGVw9CeA/2HBygMA9gVt4yyi33iQuKgcJfODj
GBBDme8dX71tiEChbd7OEsrBbh1HQ0cIrGR4HT1Pub2GofIeJbDPsLfhLuVo
lwCl0xiB7l8PqbspvzupyJ+hJ/D/fwZxdtcUesr/AVOSREQ=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Pk/1Akcx/HJYtHh7qHcR4apGL4bW9jvp5BjwzSiwxIjR8jMdFE2qxy1
4lGRxrkbq9nQIVuRbfNBSYRKZkgtrYzIlowlYma/+3jsD+/H6/H8B96mHC47
QoFGo/lS+6/HRnwm5XIC70ktZ+VyPkiSlv/TP0+g1OX03D4ZH3w1BmZqZwmk
n/rwuX+eDybreQtcKYFnDepktbN8aMrMURmUEBjm7qXIk/JBxUZshB0EKgpi
1QclfDh/MPTblCICvTdUr8IOPlQtOlBOcyRQlLKenVLEB6UID/sVwfZ4osa8
IMuGD9q9D+LKztmh2jjH4WkrD9jNheHWbUysCOu4oRPBg6QPLnFnh2zx3oyR
Q+tHLtQlFMZc97PBl04+t8R0LvjmBJjICtYg/RFDQ74lHjxK/vD1HGdgeWcI
3eLwPhA+PCI6EGSN3UPO7+5cjYOQtPO6XZfpaLupLTPqeSwkh35xbbG2JZLV
i8TpqrFAW2vc4JpugSkXzgyUboqBF6cLTlb1mOHfDx4398TsBQO16IqpTaa4
TOnmtqOl0RC7jqHUb2CMQdnejQ4PoyDc8c/Lzc362JftODYxEQmMxA3y+HI9
VPups0HfOhJKX/nfP7JRF6NndPghrAgYOa7r7KGnhUdDlbo0M/ZAfZ6V+9vA
pVirdUnlVWU4MEf7pmxLlNHSpUh2qZsDbvX9qguBNPRMcCodUOMAr+L6J01t
aYNgLtPYzi4MAiPNS59939dQkJ3mLY0IhYeP+zIJ/16y0K4iPNJlN2xY21jD
EkjJnS9+HdXNDgaFw7ov96ygQUrZXKtwNgi+XMI6znmvDLL5qt1RbrsgdVDk
uv+XpTDgocY1F+yA6qIMVvKkJljV3BWj8nbglu3ReBOoC63XOmaytwVASEyh
4cnjevC0zZ7v3OAPP249vJ4o1gdnsVu4xI4Nijp5kh/mjEB26NYSPMECcXv6
RJq6KbCjp4ymB30gIInjUNhsBoGqTrntid4Qt/idWecuC7Aata4P9/YA46qW
C8pjq6CpYv+zydVukFTn6q9eRAe1M4k7Xz8C4AnjbjvYWgNE+liucnWCJQqO
HJthBjyZMU/YHPsVuO/blsfIXQO9ed8FVEWuBr07hlx3CxtIibdYVvG7IeTs
P3WOKbYFWm2LU23UG5Kd4be25DYToG2i4lL3cmQEpQWUH7ODizXuO9xf0FEk
US3LDbCHagc/jZIr9tjJGd6oZUwAb/lq9ZxPX2NhnqbykVkCnlzJYra2k/hX
RpNpLmUNR51lBY9JtE484HKVsmdj0bu9HSTW7eo5+Joy9lQKF3eRKDIuGPKa
I6Ba1mrg94xE7UqTxpWfCchnKamKeknMumf7/d15AkKnjr0eGibx+fVBgYjy
xWSlhpsSEvVLz/02QblXJbs4fYTEylTpmMUCASzD4u30URJbPWt3ZlOGzfUd
MeMkKnZ/4xgiI8Akf/rOx0kSt9z/wE6kHGqWLGiSkph762J8DuX8K0qHcqdI
NMtXELZQ1mjUYa6bJhGCW3Rs5QTQxuyFibMknvJNYHpRhoP1qV5zJHaRVlvC
KSfKNoat/ExiiFlmqoDyhNZWg7vzJAq1nX6+QZlZ0jubtUDie8Xx+nbKPHqo
OFhGosN0sWiYcvWNkZs2chL//zN468TNkVP+F1vJWlU=
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Gs01HkcBvAxySWl0ZjOlDRMYzGHmcm/2LTytf52xqahGSSW7CCaZhAd
TTuxRJfVfZgsseWSXGpra5Os8nNJbSmdyi0Vi4SEZYrcZv97Ti+e85zPu+fV
YymJEUWQSSSSkMj/nfhuy7hWi6ETbF2NtkYO/crlHztnMbTrcnwC3JGDkNI1
eeszhnBO71RylRwsNsTOxUxgaHZt3ZzOTTnUpasMuvsxJN2QrK9bJgcDTttq
9BhDfMHsSoNMOWTuDd2cfA5D5J0aN0qUHMp14otIThhKyO87ZUGRw8IIvsOK
YAcUrpg3StgqA2r7PVnBmbWIYm7PiD6/G0T1OWG2D3loQGrt1DcmBeWoi+x0
Lxc10oO4pzApVO7LkV715qDQzMK7rw7uAqHKz2I+2w6RY604O+qjgJ93RygY
ZqNmTVzBDv0oKL6/vzU+yBYF8FuukAMiISQtk9ZcYo0GP8dmv8zeCUmhC343
on6FnH6yXOU3EAEke0aN+yEWulaYV7jFOQJeHss+Ut7CRDx7sZEyMRxWLYoq
1XxriWRp5os2Pw6D3evZCztXMdC1jZaD3sZhEOb0pqS+3gytzh1reiaSAFvh
rI0uoiPPhy/4U4U/Qv5rccN+NxpSBowXiPpD4V0K7Rs+fRmS/slSe68PhSq1
jceA/xJU223RTH4fArzBDg03Tw+Ry08lSuKCAa/qNJzzJ6Eaik2gPvUHiC29
OmVCnag56ohN0s4Ggv/ONfnPDnTUNE1G1u1y2A73mzrSMXG7a6TRuqzbLdvA
2b72uk/WhKtxV5xdfJA/kBNor8JXkIAn7BzdM+0L+ot9UiQjehCSWBH/UimG
1O5W97jCJdA7b6PjqiuCa+cO+ySNm0Cv2b3qgYs+EFMQTunzp0HXv5f2TImF
ECLNMT+SQoeRHnpj6cnN8MvWhA1YrhmUKCrtxW0C0DVV9/88vRoOnHRZ/rTP
A9oeHRpLW2oJgk5aUBvLHfyUEseceibYlTy3uG4LIDN6z3wSyAKDgL8Pceqc
gVHeeFZvyApMSwVjA17rQVnpLl56zhouaKxuZ9ZxILZYVuHItYWxOP0FKTfX
wGKyk4Tzlg2occbtw4gxeMh91ewMO0ie2OhXQich+m3zGA8WB3wYF6hNM+ZI
FXf0DK+NCyTmX9PiHjYSHfa2z6vgAVy2c/Gad0DsoDS/osS1YJP0m39SzNeo
td+wIMPPAdq9PaINt21CTyRv3ZYxMHjaUdBfM+yGctQmevs/Y5B7zEVtPYij
nsN1lhmE6e02nw4StlXEu1whfJpluu0N4crAlr3/EE67M0RXD+GolZHd6zmN
gWw0K5c8jCNqmUXtyhkMcPF44esRHB2/yz1QPYvBwMpL1zM0OHpxtTurlXBU
pIo6Stgs/8yNMcLdNxL3fv8RR2WpE0OsOQxeePk66nzC0QPBre0nCFcn6VRF
T+JI9/kmp5B5Yk9PUK3nNI68GkZFCsIGXD7zIuGMmxeiVYTTlA6ppBkcMX8l
FzcSVpgaetwiDMGNplwtBqHfVTxgzeHoqHAfz5PwK1W+bTLhZlcbrzDCvl3H
0zsJhzDTU7MICxRhXqp5HBVTN57/g3BDg/DKB8IjusNVjwiDibOxpxZHjp9y
W98Srg62iiki/OXPYF0Z5amW8H8eg05c
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Pk/1Akcx/FZW3Qo4ypNrBlLmSlGvkWUfOxkv1pHk8l0LTGDiVzRI2NJ
JLLKo1wrRylZD8djF4WwbT7l6lrKagopEV2DlnJmZr/7eOwP78fr8fwH3ixR
qLufCo1Gc6P2X4+/cR1XKgm8FNzwWamUwHD0is+9XwiUP380VTQvATf6y6kb
MwTauryZ2TEnAaZN2HzoBIHPODqKjEkJ3ElJX9Q/TKDW22BV0xEJLDJ/+g3+
RWCSiLWS3yOBzKPeznF5BIbuSd58uVoC5V9FFNGsCQQHYTQESGChH2m5ytMS
m8/UDHW2+IP2s5agwrQNuFyU+djGzB/cm3LF7PsWGKtVvaQg2w+ix+yCzg9y
sd0m21T42RfqInMDK3aa45B8pu2Vpy+4pXswFTnrsW8F06WxXgzkxT/dnOQc
nGWcNsjTE0NxW5Qs4gAbX5QFhzmfFIHXqUzdjpK1eLVqZYnrSx+I9f7696Xa
a5C73cHHmPQBmplhIy/RGPsryyUzVd7QcybndPkTIwzP7HZn0r1Bf8mh0k/f
sTBLbfkJ63EvOLyJs7BX3xAXdY2xOss8QWz9oqSpaTW27BYcDAj4EThSW2VI
kR7SR2oKSu0OwJU+QXOUgy7qRxSUpk7vgzfxultJPS2spSfXMu7thYYsU8e3
wmWonT911jluD1i86/7EvaiK9b1v56V2Qtje0Lt4XkjDEcvuIzvpHhBWWjGt
qT3ROBDJr7h3TwBC/2+vdMZ0N/p3tY7JL7hD28PuFELwzJ4YunVfPWQX2Jrd
vsbPnrBvGrQLfcTmg8ox3ee+q2jQOBFp9tOkK6ip8+NFo6oQOxevkefvDAn9
Ml741WXQcfjcmpoBJ6jMS+LHjmvC1qV5PFbK9xBa6Et/LdQFs6TqiS4FD7wC
cw1Ox+uBrcXD0p5LDvDzrmM2RP5quJbYzr6etQ0W6GQNn5j9BmZ9mGsg2Qae
Pkj8eEqDBTH5IeZHHm8Ej2iRVW6TEdD0q+pFgVwIWvrBqH2/MUj/OG6+7qUJ
GJa3/qL63gTOz1aMVqqtgug6nkAjby3QAlzFzJFx+7DioForLhvicrkMVrA6
qqtYi8yHOOCk/oPrioMsdAzencXJWA+Xz82eUIavQ716g1BHY3NwWrfP9VGQ
JaaHJ6dZPOVC3Z6c6rREa3RP2ml2sdYC5CZ9GhXkVuQcOOVRdHwDxGqm0kak
gLLhxYUZHpZwstpguIHGw3bRkIOWIQGBppUtVp6OmJulqRo1Q0A7btQ6LCdx
IOkOK4NycSbpV0+ZLY2w+41yzKH9dWojJNbtf3L0FWVTepxXEWWZYc7gjlkC
Th58UNY3SqJ2GfM2Y46AzQofHv8fEs/e4sbc/EJA0ZZzRzdNkthV0Z8toxyj
UdiWQHn1lbTrHynzB6sZnZTLEibeG88ToEjpwZApEu863diXSnlvj8mykmkS
F/y9zdpLQYB61M1fGXMkujSPuUspv3bpmD5EOaPmckg65TrmgPMNykYXVIpb
KfvfVRsXfCERPFt1uEoCcKVgW+o8iclukRY7KF/44JfWS7nD3tRFTDmoUfqa
rSDRyyglIZsyQ3IppZVysfaWgirK47ZVfTpKEkcXyBseUL6/vNlCTNlqMl82
RLlwQJZQRfn/PwNp7TuZkvK/F+5dug==
     "]]}, 
   {Hue[0.8503398874989481, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Gs0lAkcBvBZi6ixxZjdKWRoKixm9LqsLvyRekVDMy4hdnqT7UghbdiR
kpK0nULElEPWsV0Wld1Mtsy/Edku7FYGq1qyKXEyNcnd7Ns5++E5z/l9eL4+
VlSCaLsOg8EQ0vnU+19tfK/VElhzJXFMq6BgQPrlaM80gYlGjmmGjRQIF/wz
Vj9BoFPc0KTJTQq47okzCRoCf10SO7tUToEyN9+gd4DAG0WRegFXKDBw7FyM
DwlsTl/HKi6n4PReif/BswQ+Jc35gkwKLn+WXMlwI3Be391YiTcFetvXr1gY
tQKXlMUr+A1bgdXVHF+R54TMn6ey9FZtBVGTbJvtPQGyGuB5eKMEpCNr4k/1
81EV8djKwk0C8hRZXG2gIz7OLa94mPQtCPNDuLMl9pgkdXniIYmG9aW3hOSw
HQYccnWqFkdB1d00VXKkLbaaM2NtwrdA9OHT7PYLy/H3R+m7Mv0iIUPyec08
1jIMNFcGvPKPAIaDpcLnCA+56clhG8Th8PfxkqOXO6xxx5jC+bjvZjCfu+Pi
B28rFOn3DXb5hcFOFzu9HnNLvCYoTdJ1D4Vtbs8vNDWZYWBSM8/BIQTsUldq
d1dy8ISvspYiguH8M/GdNC82ertEGO3jieFVJnv1eo4JFstbvIuWi6Ch0Mb3
dagRbg9r23CavQkEg90f+KX6mMj0zjhpEARrG3oMZ0IZ6HLJlMU3E0Lixdpx
Y5ZG8cOenrbJSX8IjV1y/lF6t0K71X9l76wf3H3QnUuIuzwZGQXTCiYJKx1u
Xws6o/Ec+dM4JlLtCzr72E9jFjKA6+8uXTDuA3OYQZnUW33wmC5yy+zwgqxe
lc+en4ygpq6ksCvNE66czQ7KeG8MMbfCzF6cWgUJFTEL/g1lw6jzoSFK7AbR
cTKLo5kcmDs1u+iraAKObdrnTpwzAxvnzeoDE46ga1o4cGByMYxvPO6JJ5ZB
5/0j6sPzraDYsEXWFmMBIVLKVdZkDZIoIWrqDSB+3pB1WwQPMC95ME4yrLC8
3FKk/2YpfFOr7PfisVAq9xHPP7scdshE5QFzrDGxKv66K98WBGB5ynjYFpk6
bpTjSzvgHjk2qlnthL67ggvtCuzB3lj8/ZsEF+TcsEjw5TnCTeG9wuoId8zf
k5Mn6ORD/OKOnRMla1CUHehQel0AD9rXvctpBbSLPBxSud8JXvff61jU4I2q
AcOKgpAVwLnNYb/rWItt1EsvE0sCdFNuVVY/XIeyQmP9tAkCGB+/PlkzQuKL
bKVVAW3nTbFPRmjbpiavqaYd+0v5Qic1ifKIjr19tB9Q7Mo62irLkn6/SQKK
22fl8ncksi5xby+aIkBw8a8XSg2JPzby029OExC9JcW1c4zEJ7W9Z1S08+uv
SjnjJJqdz6tT075jMozhtC9lad7wZgiw+UPi/5R2K1kffoL2B5cNkr4JEnUf
e7hFzxKQO98id2iKxIA7I6JU2o1xYe320yQW/Fa+O5+2ujnPdDdt62Kdqhba
wen6ZWraENViytcSwB0cqRudITFHmCLwox281m7CdZbEdk+bgG20s8tiPFJp
R1vnZp2hPRzS3TpJu4q1quzqp/1V1hertSS+1R1uuP9pzxSK99N2/XhO9ZJ2
znc5xY20//8zkCuVz7S0/wP6DlP8
     "]]}, 
   {Hue[0.08640786499873876, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1HtUzHkYx/GRShHKNE4mpBqNhmZGP2Y2pXmaJr9iupia0DDsxNrDdDmx
ScktkbBUuigh27ZRYV1CGz2UskV2l0pEJWXRpq1cSpn9OrN/POd9Xn9/znls
NRGKdQYMBsOP3NfGv/Lt0+ko1FcFXXGT3z8dplBfFfiZt368OkihviqY4RI5
EtFPob4quJ2catLWRaG+KjDhN03H+xTqq4Kjm9cs2ZlDob4qKBq1KZ8hplBf
FRito52nrHJGfUOA+fiO9nTKXNR3BSgqs0Mda4Wo73KIe7dQe6RDgDc/Thfd
/XcZXNuSveG8Px9bXH2vNHGXgV+qcsaXY3OQ+zvPXCcPBjr3hp93Nw/z69Vc
TrQSCmq2Nm5SOeLDDre310uCQL3nKOtBIRcF0trk9Y8CYfua0efGMR1QcmFU
U6JpIDCcbCo8Ezm4M+Nwa55UAU8OHNtX1GCH/9y5V9mwYSlMHfv9mQGpLU4w
uhwUmxcAG+fzjJ5OtcFSdvrusB/9IVT8vLCy0hovWkc8am/3BV7MAl14vhWy
3HJ3iBVyyHsWWLXVg4V/9Di+KD+1GF7tYrnRVpNwAMeesDfzgbL0WV5/B4/H
8JmLLcqUNAhfNw8Ico1RHisaWfKLF8jKnpqOBDMwpSdaWsGSQeSZ858smP0V
/PcsiUYjheDv7PP+2tZcQVmbpnfVAdTca06mAh9L5oUqau7FusMCp1sXAzL7
JRcv+z+czXYFg2hWy9opDNDJ3qf49othjFnALk2PMQwPLquoT5oHCW2NnlE/
jYebhy2fL+LPhQs5ewO291nAqbt96tHWcyDi9Frzl8EssPtN1CpWzAT1huxp
+3ZZQVJwxv6OwWmwf2m0C3XcGlquO7CpwxZgaJnetWNoOmDFuYxRy3slTXWJ
vXsm2kLkjZUm/p8YqIzTiLIr7aDwCfPSn1Mno3bcW7v6EA5ccCo+8M1GW7Qp
qs4wfjMTthWzVWyyY9w1z8CJOVzobp/gu1DLx8gCbalI4Aht8mZtmNoZzQzE
Gn4nD6wMw6tW1s5Hr7CgdF7aHEh+UshTOrig1fVpEV4cPgijXJ8ne7thalRS
irBJAJxOc/tvz0lQsdffKbdUCPlmJ0MWhHkgT7VHmR8/F4JKTYq8P0uxscv0
dJrSGYrvM2XcIhnWazo9JtlQcPxObQLHfRFmp1sYbx2kYN5se7O+Phpf7L1t
m0ZcNT7R06GfRseYTQtLiBW9XbEhxNdCGja3E0deOfv6NnGjzbEOnyEKiiXO
NWkDNDLPzrjF/kyBQ5DH7vkfaDx4U7CtfJgCq/jVn2IGaXx0vi2zkbhw9S1B
CbF1XsqlXmKR1H59O/HZhP43nBEKgsa8avAZovGu99UVh4iPpIRfYn+m0fCh
u1j9hQKTgvjw8mEa5VXvFDHEWUmtP/cSp105FZ5K7LDR4xlnhEa7LIOCamKZ
0Eh+iBhWVVsKdBTsLDvoqP5CY5LfFqEPsXluz5pU4geSWfJQ4hM7ArKqidV2
yQmZxOUyyzECHY0FTNeTvxLLudHuocQ9ht1ldcQtpo9/yCQWfTje2Ems7XYp
qSP+/5/BUH3OSx3xf4TdUpA=
     "]]}, 
   {Hue[0.3224758424985268, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx/FJQje5jI0oZtbGOBj6ZtxG3pOZ0MplBu0qsiObWpeiVXZy
WyUp22ZMiqSQJVtKF9a25u1aR6WyJbctu0KFpkiSy+xnz9kfXud5Hv/AiyGO
EYar0Gg0b7L/mji0aUyppPBsVO2EMlkEg5LPJnpmKBzpfThZkigCb63nk9VT
FDp5DU15SkRg4rh7Nmacwk4L+pw0XgQNmdkafYMU6ryMUjOPEoGG9dNVeJ/C
dDFjuW+QCHL2hn6Zkk9hzOYMh3NrRVAxL66EZk8h8AIl8EoIC8Ld1xgEr8Gm
ozcG2gVC0O1sjiw6YYua4pxHjpf8QNiYF8ZqtcEkneuLCpf7gUThEvlzPxvb
HHPNA7/3hZp9ebsqfayxtWv8eOPvPuCdHWAyd9oSa63gVFKcN7gX/OHtMWKB
E3aazhzbTVB6O6EjbgsLbwX09J1U9YKQgzl6D8rMcEMY2ze/biMkhc6/vFh3
NYZk/Njg8ZMn0KyM5W6HTBG/2fxgLMwDuo+ePlzxhIkvzK9dABN3MFoUUf5+
PQNl6prJ9mMC+M7OYkGPkTFqPFYw2i/yIcz+WVljoyE2+4u27dzpBhb7nZTR
JfqoNXqjsNxlPZz/S9SUwNNDo7jC8qyPAEOpelx3fR2MYmhF2WW7Qq3MXPAy
cCmudlAY5NJcwOZV13t2gRrGVj+afveDE/BrexbOBtKwO7yq/6yJA+wur/yo
rTsub1acC5FK7SDw28/Ptx/okt8ry3reZUvB7XtdmZSo03VHa6LMoNcGnKzq
q3xzx10XHZ+8xfvFElTi9Xq3G9AgaUgR9H7EDNSX+KaK36jB9If5xpz7TEjr
63CLLV4K3EqXvMeZhnAlP903aUwb3lpGah4y14GYou1aLwL14KHYw9lnVOka
sitv5eFUfUh5N34swLNTfsQv3pE6YwgOr5q/osoXoCpdNpj8aRUs4cqvJSvo
+PTuobcHlzFA4zazeGXwKgyQiDl5jUygxZoVt200xcjFw8y2IFPgM+sjdmmx
0Lii5aTa6y9g6zz/Jt06K5TUuImW5ZtBTc7AzMkIW9xdGnmTw2ZB2VSRdnsL
hUtU7MXWAxagkyaUNm/moCDKX2YhtYSXxXPP5b0OqP/byhiBqTWUyH5dHcFx
xuzYjBM2T9nQW+HVfafBBYXpPlYFN21A4jnZOKwNaLHlYEBJoi3IMzakxHN5
2DG4sEgasAZ43ZpxwSnrsU08wNMxpsCO3inOv+yGeTJttYQpCnaErjhi94GP
/6Q3MKTEotbiqq3ErP1xLpeI16216k0jrgl6svdvYroGsNuJO4xP93t+oqC+
MvxJ9CQfdS+a1K+YpsBIeYVR9pGPx+rYB27NUNBe4F67YpqPjyv7cjuI69Qf
9fOIDc+fuPaWuGxP0NKdxBfTxl+bzlKQLIgKrSa+41H9dRax5Wi2mv8MH1X/
XGcfMkdBOveZMGuWj15NCuF+4tjSHQeuE0tvnIvOJt6q9e5CDzHzlEppCzH1
Yv4Ua46PENxCZysp6DvKKmwhzvDeZ+NJfG+i6s4o8QNXc68w4pvbuGN0JR9D
mJlpucRZlI8gjLhU17nwKnFCQWd0JvEb1ZHau8Th6uJTV4k5H850DBD77Rmu
7yT+/8+A27N3WEn8Lw4FWvk=
     "]]}, 
   {Hue[0.5585438199983166, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P071Xccx/EzRYS5OWmi3BwnhyMOvpwzN/m+3e2wSSbsGgsXqVXHzVVN
muiGIktX7nbcJrJzidRWF8ks7yK1Gu1aHAzLvW5MhlRuOvvs+u6H1/W8Hv/A
yzQqPjBGicVi+ZP915TJbbMKBYVMxTCRvP51/zKFTMXgr/30zc13FDIVg4lT
wkr8HIVMxXA3K1d1aIJCpmJQtekxwg4KmYoh/1DkZ8dLKGQqhtoPDlaxRBQy
FYNyjNh+w057ZPoJsHvvSSpz7JCpNwS2FkdbPrRFpl6Q/Gqr5PyoAG+/MRI+
+McTGg8X77u23QYHXLbV9/A8wT832OR90Rbk/crXVvh5gLjsF3+fKT5WdYbz
uInuILt/RH4wzBKfjLq+vFUHEJ6er/e4modMaUiNXHVVnW2OTN2AZW3c4nmK
i0xd4c/vijJquznI1Bk2rv368ryHKTJ1gv2OfOX+jcbYYFBwMvacCKJFf1W3
thridcP4ruFhR+AnOSviqvRRz7XsmCjQASoGd7QdcdfD36ctR5ov2sPkCT1X
sb4uzuPaC2YadtBUYOH9LEQTBz/N5xyqtQHb533zgjIVLJyXLEr9rcCrqV9t
JYSFnMG/01OtLCDh8rW3Ouy5lq9eWKW2tXEhZLdZxR9H+1pihLr8Dqkp3P+t
L4va0Uvvaa86V/R6Izhb37keIJ2jo/eWy75wWA9KiXoDuzawYJndLRZ2aMEa
jYATUdMqMDsZseJspgRpQ3LPA5c04dmSz3Ds2Aj9Y8npgNRZHWD9vFd1nPeq
Jb5yl/ZYiB40n8l1Px+mjOH7ijdlnNCH5i4Hlw9X6eCZzxOdqFJD0L00dWD3
xx/h6nUFE8cWjUDVgt+hmN+EPY9OzaRrmcJVqfqwmjEHg5OjhMWtHKhZaJM4
ZGxGifpLTmcoF3rXy71L6y3QuLb9e5UXm8EtJNtas8sKkxs9d2iV8GAhIUNm
JBRggkzSIBRYAlM71FASRdmM84GpPXrHBhXw87YAUwfUv7Up3ptrA0yFmHsg
M8e2RwBMRRh4ert1WYMtVGmUhzrHOiE/LD24KsUOghpUa32WnFE+oVaZF2wP
VzrYXrxaV+yMGnfXNaag9N7DNK6bGxYX6KgceUeBg5WZxuwsjSOn75rmEbdp
nvI0n6PRMung1jriwJmJb0OJG0O7Dw0TJ9TXPL9LLDcuGvVdpOAKbX8/b55G
do3JHYMlCsyD3E86LtB49rbgaPMyBfopEW+T3tHYdW1IKieujrgjqCM2rMi5
MUMs9DDbM0xckzb3grtCQdCayW7fRRof+Nz8Mpv4fE7cDYMlGlc/cROFv6dA
VZYS17xMo1/bq8Ak4sLMpz/MEOfVX4zLJTbf7z7IXaGRU6gkayf2slX2yyaG
ne3rBAoKjjedtQx/T2Om/2FbX2LtsunIXOLHtIVfNPGFYwGF7cThnKw0KXGz
17o1AgWNMrZL+U/EfrxEt2ji6dVTTY+IB9R6v5ESCxdK5ePEkimnukfE//8Z
LHaWjCmI/wWacE+a
     "]]}, 
   {Hue[0.7946117974981064, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1PlT1HUYwPGNKxAYF9dlkGsP7kV298PXZUfUeAwJKFyJqwlHhgFtGluE
EUZhEIxALqmJK2SRMYgYhUHKRkSm3AchxCicChcJMUhAE1MT0rikbz398Mzr
ef8BzyNLSY85YCYQCHT8/Gvevd1P19Y4JDUwm+v41/gKh6QGdMJfn19a5JDU
gHRrxmr6PIekBq6WV1lPznJIasBaOeqOP3BIaqAmK/mN9xs4JDXQ/lJmi0DL
IakBywPhgZv2BSK5BUS3vtU3VzIkOYjpM6T6fadGMhByH+/Qf3xXhVeeuwcN
/smg+6jhYOceJd7etvviqA8DXVW89EX9ZvS5rhCuRakhvPEbXcRDBZJKaL2W
Y8rc64dkACQV1YhvnPVB0h/yk83P24q8kVSAIEBiDD3hiaQv/HKyvqT9phxJ
b3Bd9+65hVdlSHrBexqF5birBLucaz9I+8gDUrV3zvb1ueAFl/SRqSkZKLKD
1w61OKF4e+NxbYwUmiZi+3N2ipF0g3sF4u3hThuQdIaeWt+w+wn2OPF6jTyr
3RHUv48tqBqt8NSCfqlOJ4JdPeM2qwkClE/8UZTvL4SMc51/O4jmjd0jb62U
ltlAwjseTT8dGzMO6T3jDCpzuPb9WDkXeytkuCLSjZtbDAkO6L0QXTcfUvF5
niHpx/shZkfEt/dvEoDgv6XM+LJddEHKIytwVYNl+eU5Y+GkKfTwZ/Zg1dtR
Mv3asvGLhuLo/KcOkKy1b1qZNsf05v3C6QQx3Nl1XTrYsQ6TDhrcSgqcgBRi
2ZtHtnKnXYAUocXG2tnjS+5AOuLo0IknRetlcL7OdspG4ozxuSlBhj45tD3r
128pcUO97Zx8ONETSClK2gc+sXrgBaQMc7tDY9c3+ADpgRmt+q4glR+QXmhn
pk1RziiA9MawtLhaRfVmIH3R6bJbepinEkgFVh0urVSPqoD0x5jiPQGNXWpo
sTuTGJwWgIq9RfEteQziuqzbI5aVaJq1aa6ODwRSjcMpMzs3SDggGRpqHaxy
FjkgGf5WfFVWzTfJ0C87c0cH3yTD7sSbWVN8kwxNkvq7kUsckPydtEl7nZc5
IBlWXFEd+3qFA5LhSOdknYlvkqFLU+VXT/gmGbYVzj/wXOWAZDgYcentD/km
GVr8/Io26QUHJMOo/scx2XyTDKsvfnqoim+SofyUWesA3yRD2DewUbXGAcmw
VHdUHck3yfBGiG9UKt8kwyR5eWEd3yTDVtG2M1/yTTJ8ZPGwZ4hvkmHQs9Om
Gb5J9v8f44Bk+A9D40/R
     "]]}, 
   {Hue[0.030679774997896203`, 0.6, 0.6], LineBox[CompressedData["
1:eJxN1H0s1AEYB/BfFxdhXs61k5dz1xV34+645UYJ6Yalo9PdFnOzQ2u6nGFe
dijzmmrLnUsOK7Kbl5VeFrLKy4mWYqsc0ouSUzLM6YVw1cbz+z3bd999/vv+
9VAkMkEiDkEQ/r/879yZY0tGI6cb2Ty9fNePiTXUfJuPv9pXULv6pqzLDKh7
yxRmk3rUZsxRl+6XqCvS446er0bdsi2tAeGiNk0M8XaI9QYTxp5K68u9wAKt
Op7+nA2WL/hLr0yxwB2Z6qTWCCa6VyF03ajyAIfUPuaHzjHAmoFsXVoMHSwu
rCAON7qB8+K237Yg7AMjnuSu4CIa+O3FqpKWESrYaefppuXDFPCZ/QzTCScy
OJ77oVGrdQQzsvyMyQ0kcN37qL7sICJ4Jp94MIRkB+5UufO+iqzA7G/jy6xa
PPhI54T5uggBpzS1/rYlGLq2LDq1p+5Vzjh44MV4GSdqLGDLfp499yIrDWBc
BvFdggMSuOUdlpH5knk8uGBSF5x60wp8p7o4Mm/JFiyrT7D5IiKCxUlq55J8
EvjC8QxfTo0j2MRepT+36gIeHSxaLLSmgIVyiY9aSwVLLb5Th6JpYHJL/1X8
7F6wvCM4yrraDZyikbb5sOhgSxxXwpxmgHlnT6gYSg8w6aGzjEdjghWppeXs
URZYUBzhWdvGBjNiCoUNuV5gnd68Xin0Bg9JpoPsyBywWmWLz15B/bm4l6LE
mJ6V5n8L447okfRPGOvIVVNhq6gJza49u/+gvvSElfNoDfWb1slKHcaOdeX3
FzFuLjDM0tZRPwttP3kZY5PXh7jiDdThfQuCLIyVD24kKzCmXsNp+jEOjO23
ZxlRl/Iz2WEYDwe4h8djLKaWFVRirCEcuH4X43mTuc5BjH1+1uimMd78Z+C/
mm4lJQ==
     "]]}, 
   {Hue[0.266747752497686, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1PtTlGUYxvEVkAQxDssqiLgHDu4uwu7L2wNh2d6CDKC24hI4ysgwi1pD
BCQMh0Es4iCiMXESWWAC3AhhCLMShGofXYImEi1zkaCiDAxw0HHtAIn0Nu/9
wzWf+f4Dl1SfoTtiIxAItNz+t/Dey49WVljKy9CZgvV/TjxhUYZqXX75u3eR
RRkqCctczrCyKEOvVVSvmZphUYauCRrbTK+zKENrs5N3v93IogztWpVlFISy
KENXH4kK9jwUjKqp8M5XaW1VDPW/eHp8p4+K6syGFMU3amosI8O62kBa8GB7
2nt3VWgA7cs1pPbsDUKVVFsdL3nasBWV06jmL7TR95WoP20fzrdkJSpQP5pU
Uiu60bEF9aEnkm0/Wiv0R2VUECg2RZT6ohL64+mGk123ZfTTDazz/i5vusnx
tQuPw6X0efebutnSjfR1olw9sUmMbqApoT93mM1eqJAq87atpBs9UBfa+lPc
YP4OEQ0f+LDc+o4jvVckejHKw42O2gbkVartaH+dPPKPhHU0O2Bfxc3uJZN6
dvyxqtmeUuOrt0zZc6ad/RMOywkCKqhayAk3fWDKvNDzj6vQapJ0tzw7OT6r
STjq0/r98XFTqn/v/pGWRc3wt+MVbNwdTUNY4ptHHW1hW+DVS7H1Vk3z2eQD
HSMOYJMjmjzsKYBVA47pl5xc4Bmn2CL9gj3Y2XcAkyuE4ilLxLHz6yA8c156
5bv1cLGxLPbEI1fUEzLaDrv8niBCvSEp1eB9ssgDVOR6pRkkcGpfThjb5AWD
8oEmz1Ep2LnXzby1tBlsKnZZNYU+MDZS+rDEWYr6QXyBPsRglqH+kLZ2XjZ6
0BeVg7hr6Kz9nB+qgIK+iDjnxi1oAGS2p10OUSnQQHCyCdUHTSvRIIh845U6
Zc1WaAvp3FUXowaPK94Zkb5BcGayslfmxkD1sfIq9ZgKYsIGo8/NM6Ar2xvY
fFmNBoMysSTeWMigLFhmHNpq4oPR52BUP73DTcyiBAx1rvb5iyxK4Leya9Ia
rnkJKPKytndzzUug7+Dt7F+55iVgETfcjVliUQLCTsnVjf+yKIEzX6qOf/6E
RQn80DNVb+Gal4BXa9UnD7nmJdBZbJ3zXWZRAl9H9x54l2teAna3XgpNesqi
BPYMPtDlcc1LoOazlvRqrnkJyM7ZtA9xzUsADg25q1ZYlEC5NlcdwzUvgRsa
+Z4UrnkJJMkqiuu55iXQLnzh/Y+55iWwYHe/f4RrXgIhfzVZprnmJYB/hhL4
Dw+MRyU=
     "]]}, 
   {Hue[0.5028157299974758, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P031nccx/ErN9ckHSF3IzdXyHW5uS7XN9flEr5vZJ9L6cIldkY5HbSz
Y4ajjpsjluOu0ZxFUi5tmOOIFWsbQnmHtFOobXXF1LIVLZw4aWvMzb473+8P
r/M4z3/g5ZiQpj6qw+PxVMz+N+/FgdcbGxSujGmeb2zQOJNr8dfkKoUjb91n
u5ZpVG17+rZrmcI6hxsLaUs0OijS19KWKISMqZWnMzQOlFUaTM1QWGTubIKj
NBp4PrLDUQq3Hbrif1JD49njR/af1FDo+hLP8eQ0tm061sSTUxijO6PclBqA
+keJ1PqwFA3vVCRJe/zQbPxWSuMZL3TpKJ/Yu3MPqgdrE4V3JNhU4n1bfVaB
uQv+KV88E3PKsTurNrk93JNThqrKaIf1C+6cu5FcvK5Szos4pdh8O0d7LE7I
6YXxRWfN77Xswj4DoduXkWLMP6J7ZYuZC64i/5ClizvyPOz7g4udkBcbkF9q
KMRfyy+Utj0U4PeWlPH7bc5oa/jRpTdBjuiz/b76ZbEAP/YW6U/a2qM2+aBh
p8IOE+W/tQwO2uBwal9kaaklirJ9N1KbrPDg4vH1J0oTbHgSNZQTaI5FmeEm
L/T18UWBuR+xMkUf42+mFAOL/T3VriF/xmxFibpXe105TUteTrwRX+RjvUeY
Rf0tHdjbM7l5LYaH2eXKeX21MaRfav/HxGypX+nWopuVaQExH+5s+PnERL93
1WTb0fu2cHtkooyKGqdH6i77UMWO4Otx82pEzRKt2t/h/mDaCXQyzR8nWfNg
U69h6lUjV3jHKKIg4RUf9Pgt4JXlBoVT2uCMr7dCUPqc47WfPKFDUxKR/9oE
xg8Eu9LLEkhrTNr2PMYcfCKlBhltUohPrt1RWmAFYu/RikHYDZ9FZiqoOhsY
cu2tsx7zBr3t1TOfrtiBTtm+JTpPDo/uFi8WGTtyKiA6N0FWOyjg9IWULXOC
sVgnTj+wbxs+x5915vSH3O7gKGPNLk4a0ptTOmViIfhEyeI0NQBGOvIEz2kR
8AtsvGoyAiHkk4PVoip3aJS17qsODQKrazvSQpw84fTjii6BaTBUZpw6I3kk
hlDFkPL8XDCoS8I9LnZKOPeCKK4ouinPizMEtDObG6uipZzvwVjCdKCpPcVJ
oLbahJ+zTHES+KNkwLGKaVYCwuxj/peZZiXQHfvw+O9MsxLQ2l94FrpCcRIw
a3W4+e6/FCeB0zfEJ/pWKU4CD9qnarRMsxKwaTjz3SLTrARaC5dmndYoTgI/
Krs++JxpVgJ6vwTI49cpTgJhQwvqbKZZCVT9UJ9ayTQrAcF5neZhplkJwOHh
7eINipPAKVWWJJRpVgL3aNewRKZZCcQLygprmGYl0Gy256tvmWYl8Epvvucu
06wEZH/XaaeZZiXA/Rkngf8AirJGVg==
     "]]}, 
   {Hue[0.7388837074972656, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx/FZySKdSFNCBqMwm5nR17WS95hxkLuJSpGDOiXFIpdccgvp
sjsGZaR1W0u6ykbW8i6XtrTalVxbKRmlC+XSBc1+9pz94XWe5/EPvPQCw7z2
ytFoNDey/5o45vpBJqNw82DUa5lMgNL4lTOD8xT23yqZcJoToJvq0491nyk8
cq5zSjwrQF3r8IWwKQqveRvNG74V4J3sHMVhKYXMvwZVPAYEqMju1cE/KVRp
s2MX1wowNyrAObmQwqErqt/DAQFWfxNZTrOkMDn10mxyFx8X73XYsNpvA2at
Otjx80k7VO9rCy0VmaJ2q1FZpC8PvVokQcb3uThnsJ++hQMYP2ET+uMIB63G
dpfueGyD9TGSkKvubMy9McbIjNmEbjneul8L1mPUrmTugtQKHYp+d3N8w8Lx
g9rRoYEWWHE3ridylzHGVt+8baJkhv7pufSHlYZ4qt2/2CLRFJMCFl1Zor4O
Y/WUlZnWbKSZMJr5xw2Qluln0/GDMQ6cLMisfqyPZ8oe5MulGKC28v6qaTs9
rNwc/uk3EQMPmrMWD2ozEIqTlol86BhkOVTZ0qKFHi7mM3n5CsiK3Sg7XK6B
tKzZgYfdQ80l/whb43h0tOpU3Lc2hgZjKfTNDhrL0eVoszOrTg0a8ozsX/os
xf0M/rmyBS3gvuqf5hQpoLZot6K2MhMEDYNKCz40dDUrtLrTZAjhVVc/qalP
NUfrNtn1960Hn33Mkq6E/maz7RG66zq5cPdBfzYl7LMtME8NkTIp2Ghyu8bj
7JRtvFW63p5L5iAXTX8SvJoGPJWsruNKVvCtikdK4DsFSJVPmgwu2Ahpwz38
iLKlYJob3r91jQ1cK8zwSPqgBq3TwY1DR2whrDRY9YUPHcYb12bk0XjgHyJZ
k5miASNjq6tzuHZwwjPamjqvBbn+p8zFvnyQX5EnPfZFB1LHYmYnigTQ23F8
Mn2ZHjzbEVxb1mEP3vGBFpIWfUh+cq/yxnIHCF3yWr/T1wBEjlyJpsARGNXt
+Qrja2E7jf4+PcwJ4uv5wmWFhrD7fkSSc+1WCK8IvWnBMYbuhL8VD4w4g4qc
ZSB7lAUneFX3nn/nCvaHtuWxxOth2lM2seewG2jcWhNmb8CGrq0+6maF7pAT
kSXi9nLgI0tsURPuAV4Z7iZFN7nQVD73bEbRE1i70r3LE00hQMCETRc8oUeq
VCr23gC6hzJvscELOgNHecsZFGgqh1537fUCSZ6aQtxnCsy4p1s144XwPOOO
npiYNeq5k01sHBtpc5mYIVn5jkdc7/s46hmxsnzxqgPEPYyCEacvFAz31oTU
Eatf1L2tOUfBmWN9qtsShHCqiZPQOE/Bq06m3+lEIXRfHT7bQ/w07eX7YmKt
EtGNSeJuq8sZtcQX06bGDRYowFKLa4PEfzjW7TxNnB/ttIiVJAT5R1ss/b9S
wNcJq2ondmmd8Ioltn5EbRkgFv9afDiHmJ31qestsf45uYp2Ys0PKfMrjgkB
/NpXcGQUTLblugcRZ7nFcJ2IpUd3vogmfmhr5BJEPMjRicsm9tfPTjtL3F7w
S+l14gr1TT9dJ250C7VsI34n/6ahg7hmkemDPmKL2fM9o8SV9TMBb4j//zO4
cKhhRkb8L/ooRQo=
     "]]}, 
   {Hue[0.9749516849970554, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P071Xccx/GTu+nGctNxaRIOCsPhfOMkdN7udpDbgxM+cjXUXGUYFq6T
5ly5aWrmJonDFXJZWKltIW28w7KVm10bYqlshSWLdbpjyr67vt8fXtfjev4D
L9PYZMkBFQ6HE0jvf7NnA56trlK4PKR4tLoqxhmZ/ou7KxQOvLKZa18SY6D2
g1ftSxRWm3QtJCvFaOKc8iZZSSGkTi0/mBFjT2Gp5tQMhblcCx0cFKOm3Z2t
OEihdvQltxyFGE+n79+To6DQ8jGe4QjF2LImrYEjpFCqOuOzJukDVD8gFmze
J8B1t4riBZ1eqDf+Y2J9iQNuu3xywsvMEyW9VXFWt+yxId+xX3LaHWULbonF
D/n48r5s3KRfhB0ZVYdag+wwZWHHaMw5VwwsDTd5W2mD1eYtsEI5o7jmh0Cf
eWss2iWrKR53xMb+rLE0YoX+Xyq/nm0TYEzuae7whe2YqSORup63w2P7VS+t
19uGr+VaHXb+lsixNe72zDNHzndHV97l8vD3k5UFLaM8/CVmwDX6oj5uWZfQ
9NzDFLEu54wfXw0PO1qr391ijLWSa1Hn4udFccL7F3p7DTGdVxD9z6I2WGfu
Wk1qMMAIY31VryQjqLsX2pflzsUur4iMDdkWMCvnuooNdFGwMlLwyfD70Flu
6f2XVAvNrh6+dzLMAewfTzzn12hgwvoy9YQrO8Cr8+7aN1IO3ufpyuQjQkhp
an2to6fsbuCOyF1cXEB60Kzu16MT3Yqf/x4VJOyG/oGJQip0XHRwSFpd2QOw
y/bGN8EVStFXFhH6c6keoHKEOxm/mQM5+9SFkRpe8M6GYHnsUw1QUQ2rPXvd
G45PjXmmntcC044XxZMJYrisyA8+9kwHxgM8LUVLPpBcH6/9SMqFnSECzdQW
P4g5VGVUIDcAvuNgUS/4w+chR5ypakPos7xevXkoANQ2lc98trwVVAr9lKLs
ILhzO28xd6MpzE97ZPYUBEO4LNapqpcHzW4OhoMfhkDi+ie8oShzaMv7VOcj
WwkYt9w8ozFnAcXhcXtUX0hA1uEZulGxHXZP1jUVDIZCSmNimxPfCnaGOhFF
RRhsUBHG2k1bg4bc0KEiNRy8Pw4rty6zgXqnZr9yXykYXDNK9ja3g1OTRe08
3b1QmnqixP4OH3yd+3zOPtkLkvwg25o2e9YIsCa54Q3ZDqyRMDaztr4sXMAa
BUOx0+66xhQrgapyHY2sJYqVwJ/5PaZldDMSsMpMc7tINyOBjqjR9D/oZiQw
Zlz50HeZYiWg12xy471/KVYCp7r4R79foVgJjLROVYzRzUjAsK7k20W6GQk0
H1fOmb+hWAn85NMe+QXdjATUftstjHlLsRLw71uQZNLNSKDsam1SKd2MBHhn
VRpv0s1IAPbd3MRfpVgJnAjMsPelm5HAsMjSP45uRgIxvMLjFXQzEmjUczl3
hW5GAk/V5jtv081IwOll9dg03YwE2D9jJfAfGGFL4w==
     "]]}, 
   {Hue[0.21101966249684523`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Gs01Hkcx/FxLVFyGYeUMdOUTMyM+W9mFc1XwlRjEsYWy/Lvsm1N7hUN
bS6plD3rnpFscmzllEI12xY/TOx2P5VxqTaJQSxOowuaZn/O2Qff8zmvB++n
XzoZG7RTn0KhiPHNbtpgwHudjkCKlpZXOp0QqWU2H158IRBapehf9lmIxAtf
f7o5RSDlhcsjmyaEyNEjThurIdCTX05PlfQKUUtO/txeNYH6w2Ko3GYhmsvu
dEAPCWStsQuIyhCiwqSoTUfKCJSwNP42MhSiGr3EKgqfQC5ZtLJ0E39ktNOf
ZxfBQ6dS67SNQ+uRVdddaWWeG+KeGTO3GV2Hglrl253vcZFoSD/lxylAsnEv
6a9vOahBJV8wrPBCioPyPbWb2Ui0MiPHvd0DifMljl9LXZDy347AmSOrkH/5
HbFwlIW4Jj3KBrEbqm5PUSWGOyNQR3F9/mahyKxC6uMLTqirSL3XVMRAh6MM
rphaLUcTSvqDpEZrRHGlNfkcZSLK3Ncvi55ONvWcLD1W08FAFCu93aXiObB4
3u6Lk+voaEg+Hh1P2sPeVSyjF4tpKOmQTeJL/nLYzv/nQmurPTq+/3l3cTEb
WMmrdTFVtujB8EfYzyPg3KtgZYo3FX1ildxziuHDYDrV09/WElUsGZisjl4D
t4pW+A6FzkfSyrbnVy4KgDvcPckpN0b0QZnBmzFvWH/rhYk2lILuS0ZGn/T7
QNzF2s8WVpqm7Fymm5GRH4TuWnruaWp3k97Zhrs0PSG0P+jOIYK7BJQMqQFo
NsBq1+a6wBKNwIIzVlZlLgL9A9SXO+wo0NvQljU+RwxzzALTyTFjeJP+zQ4B
NRAye1U+Cefng3VBac8J+ha4WpYdePi9Bfy+kJXSbh8EsZU7FvaHUqE1gebr
tDIYIvfIlxxLt4W13uBxaEUInNhywIM4Yw+yqUm9J44SMLQuUv887QDexQs+
+7NDofP+0Yksczrsqgi2qXf+DiQy0l3eygBqrjYaVm8FqekI41EYE5iDTzvQ
t9uAVtNWbPxuGUyyPB3W88JApvAJNi9zgoDgeYXDEA5x1dIb7hxnMB4y4GV4
fQ9m+nySPcACYTSp9dwcAb77QopYBS6wSRlSPh0eCbZ/LIn1ZbKhtiBhZ03o
D5CfcDyP28mBR+cPuQqIKAjK3uxafoMLmvotnoy6KGCFZ0mq0txgWpFwPZsd
DSq1SWWBhAd+XD/f1OvR8Igc8LakEdAcwflpL0GCvMjCOGWKgCPae+dH/iSh
L7uFXoAdUGj3YQbbOTnR6zL2opW7/cxuk6AI60h6g12/1WjYBVtFK327YZoA
db2AHYNtdcmxedEMAaI9DYoJ7FONnNTbXwiw7Sx/+OEOCc9re0tU2P37Rh2M
G0mwP5dXP4F9zXBNnA32pUzNO6aWgI28Lks+9l/Cm9tysdNyLbcmYxs+W8uP
/EpAn8+xvmlskXI8KBn7ak8HYdpEQsH132LysVPjmUftsRmn9avbsKkVzU6e
2BDRZs3RESCcnpGmYR8XH+RuwKbmbWzMxX4sWCHajt3nVGp+FjuSkZNZgi2T
uNc1Yldbram4NtuPZhk8xh4zHL11f7bPfBbyGtv94xnVwGxvx6gex/7/n8GV
q3GfdNj/AR3xSHg=
     "]]}, 
   {Hue[0.44708763999663503`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx/EJ2VRqSjIuuUUy1czkWzPp5m1dhi33KGTONIbBjigdRrqQ
a7Y6MdQa2Z0kq2hlVm7H5hNiT0p7pHHbzSiXWLfcE81+9pz94XWe5/EPvEx4
EZ5BKiQSyRXvv14ccplSKgkkqhiWK5VsNBi3ebZniUCyKLte8RwbuZJ75ys/
E2iEkTdkMcZGxtaRyxHTBOIWuy+4dbNRfXrmKsUggRyllbrScjZaReswRK8I
RElPPgmhbJR1jnskPpdAtQEm7+PbHFHxiqgCEotApJW+YyvuO6CVQWwr3QAr
RKbLbx3RsUNanc+F+Rm70b40D8ehckCeDZJAyxcMNCqWei/UHkRxE4eENz/Q
UWRrtX3ZQxaqipGElbrR0HbBa5t1E1bINdPb+GvOTvRn+Ir6mdwdiJ33u6vT
KBUVlZ7pLLtqggqbY+VR/pYI+T/RPO1MRpykLO3XRRYonmYxs8N30uYSV/XX
NVrbkPH5jo4ofR0g7TKqs0s2Q6Qp++RQhRl0/5CTWvzWFPVXBbctLtPAYHXI
g5lvTVBJX7OqKWsPfL+XurLHwAgpSkFUecwaAlnvihoa9NFoieyKn99hoIr2
K08XUJDCPAuVJNnC3b+9GmNttVGz7rOS/nX2MJSgfZBN2YjE7yYyX4Q7Qk32
doePPpqou5k8GKJ0AsZw1ww9Tx3dcKKprUs+AvY1PRrLPiS0TeJicKrXBSIf
lC5s0JquM0wrdWcy3cEneOvdtgtddZId1mQtgQc0v+xKJ7w6bV7p2e6dzvCE
/bueydxvT9scMqi/SZd7gUq09l98XRIYq9sP16t5wzdr3RN44+pgq2Ijkh31
gUSF3O7sPU2gfFclvH/jODzOTXG/NLUBeOetOBM1JyAin0/u99GGkVrzlGyS
H3DCJFtSEyjwYUi3OJPhD1c9oq2JO/qQxbm2V+x3EtQ2ZQ9eXjSEK0MxcxN5
AdDRkjyZtN4E+k7wy++1cMA7jseUNJgCjPPbfTW4IFzzj2mrnxk4mVFcNPO5
YFTcdEt9xBx2xqeL6lmnIK7Kzmt9rgXQgqzrzLtPQWShsIJJt4SwpyFJ5Wd4
sFaFxaMNUKFR2s7/pB0IDuHHsqninbBYpJynVwYCpXpLhIMZDULNizUkLnzI
PJuWweigwzxVzJRN8sEzxW1XXgUDnhZ86ZtNCwKqf5J3wcXdwLXfCgcMg0E+
qJEv9rYC4/DUahoKhlbegO1GIwL0VgvLXI4LQJK9QT32MwF7GNcb9b4I4H1K
vYkYmzrg4UvDthRFHXqEbSTZPG6LXeX39lwf9mo1qU4ottwo54PzIgGKDllY
JbbWQ+Nnel8IuHG5k3xsSQDXntIv1C4RMNy6NeD6sgDaSxW35di9iR8/SbH1
72b8Nondvu9RSjn2w8TpEbNlAlA+83EP9h9Olb7XsW9FO6tSvwpA7c1hFucr
AXaGEQ+asI82TniKsK3fEIe7scVPpKczsWlpC21j2KY/qhQ2YetNJSxtUgoA
Apo20ZUETD7PcgvETnONYThjD5737Y/Gfm2z/Wggdg/dMDYdm2Oanngbuynn
l/wy7EKtAz+XYde6ClnPscfVRmtasGWqu192YjPn7sgHsIuqZrmj2P//GfwU
XjOrxP4XqTBVhw==
     "]]}, 
   {Hue[0.6831556174964248, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P0703scx/GRtO7Hco6OstmZU1bb5CtKR95mRDc4bubqTjN0Flt2lRMu
3UjKTXSOreUm60RL5JykG0pHPqUoE0m25ByRqOTEcVNuYudzruv88Lqe1+Mf
eFmJovzCDUkkkjfefz30dsuQXk8g+8uUp3o9H/XGfzXa/oVA6rLGNoNRPvKm
vPpcMU4gyu307hl9fERfK5uKGibQYB3586znfHQ/TU7u7CVQUQ/JklLER2SO
zhI9IdASq38i6b58dDpauCnhLIHI2c2zXM+7oRKD/WqSI4FeHJe7JAIPzQzf
YLd4px2i1wzvunpyPaK+eCgpyFyFkt6Jx2WTa5BfTW6oTb0tgqB1t62SCRQ/
4Cz5pZuLhOllo0NrVqBbMbkRpT4cRPZY26dh05G3PJA+nbMSJZB2pGp0JLRB
VeXt2c9C0MAL/Xr5Aiisi9Pu326DYtNKGK1HGBCcdNqsqWgZkoUMigUiDhwW
zrgyl/od8uSMWAZV2QOJTat2O85ECa9Nu+VsJ3h5Mie5pJWBeJuuP6POAVgy
R1w8wrNCPh9TdS31PIhczZrZvoSGeCbx21GtO4Q6dhTV1Fig1J+dG27c8ARW
rJN+r9octWt/67SUbYL8v/wfxLmaIeo5h+ibu73h7VGz7zeYm6IVWeWtQqUv
VCqXu78TzEcutFe2U4v8wPZ92whXZYymA2SJqgx/4Fe2z54SkJDrgO7iWH8A
yIpLx0yow9WxjxvIfXsEINj9bf6zg23V9uRs5zNPgqCuoS2N8H/hkjOiEXuw
toIT+94136xhlyF6Rku6ehsYHjD7M2wxCZ6WMSmnZu6AWfN8j4o+GkNBole6
ddJOONapddt3YT4sNdBNo8lguHr2hO/hIRNYsE+VP5cthKiCMMobgRmkzDjT
bfBBCMERuUuTj5oDvy7uVGBeCKT+cGAtkWcB2q5M+xUbRWC0SNl7ZMISQvJk
ExrjUNBpjg8mLbQCTqqTTX15KATGixxyaxgwaqaJUfwUBpK5HxiN25igf+7B
rVwWDrSS2jPGfdbQ0fepS6QNh/hbbv4Lzy6D8vPSG1rFbpAVSsoduDbQnNI0
cIn/I8wzdBRxeljQQxnbyDcSg7s0QMlSrITGgYB8ERKD+e2lUe5MDkyQVMKO
qD0g35eSaavjAv1aiYs1JwL8TviwVeW2kKK8mPz4VQSwticFqg+tgodNLfUD
GZGg7Z1doAi0g8niR+yujRJoFPW4mtIIiC4vGudOSiBXaWIcN07AW5FPj1el
FF6fuG+lwDZ2SKsSYtvE7nf+HZs5+6EyBvvWttboLuyQUiePi9haWk631wQB
7ZPWl0h3pEC9TL/3zSQBzae/iCuw0+9yD/7xhYDK2uJ+ZpUUnpd2ZmmxX+a8
ebAO2yI/8/og9piEpvLDvnxsuI85RcBqqnJLAvYjz4qtGdiluxKutGMbtax3
DJ4mQD0mkMnvSmHzgwG/WOz7mkzPYmzFzfN75dhd5xroCJuRbVhYi23pzmv+
Gxt21i7i6gnIzmTbeVVLIcU7xtYLuyJMPEeI3eSyfHModqvjhdcHsIMZacey
sE07zBVq7ELqul/LsFeV+Ufewf5o1F+pwfZNOuX2DNvhU562Bzsq6LHFe+z/
/wwyWEYjeux/AW61VUo=
     "]]}, 
   {Hue[0.9192235949962146, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P0703scx/GZm5ObTuamQyt3ObK52fh2OFL2LhSl5VjbEYfYRI1sS4V0
t5A43WiIyBE5SzrqON3hEh83iULnFCtZ6QY55irHUumknU/XdX54Xc/r8Q+8
bPmikC1kEonExvvSfa/WT2k0BBrzFsk0GhYaTZs/PfiJQMyhK1VDoyzENh56
f2OGQOJDH5qae1jIxks8K1ITiNQlVR0oYaHWHNmcZ6MEMubl+5E8WWiO60Mr
1EMgENe/IyX6oPydUesOlhDobKV2OFm5HF3USqokeRIodG7RYt06L6S7ZY27
ZYQ7cnT0lnWNuSPTR7cSKk66IaY0otthAQ2FtBULaHeYCIShSc7+lijtzYqE
3JcMRMo0bs0TKVl1ycXCyxtc0cGMUJ6+LhXYMq7N59POKHc7Z/ZrphOsKb3J
Dpigo+Ec/VtP2UtBfjtVkRROQ1ufW8iZsmUQmZFvfq9qCfJ7r+iLvgSwP0r7
kqGpA9JhzZwbG/AFkot1s2+mPSLJW6Qp06vh8c+nsy7226Ggse7Jqo1rYaHB
1gtvV9miThWjZv6e9RD/HV13cKE1Wjsi3CeTBIPA82lVWxsVsYdznaysQoCe
skyTWGmBVG38g501HCh/wmlPXWmOmBTFIt/NXHglNV++xsIEGbGmo5VqHjQU
OPqP8eYi2eNrr/2rQ4H598BbRqkeuprZRb4aGgZ+DYP6szwSElGyb8J4OIgv
XP5AMVU33zcYR6WlEcCLXVx+f+9Ac8/wO6Hl0s1wu3sgh+A8YhFxTr1B0VGw
zKXlj+BCNavPxNlwl1c0kHebK2MsSYAuHSpx1ubDV0bBUv5rPZBq0YO7n/Ah
/ZnCd8e5uWCs3BOQeFUAv5ccDt4/RYEJuW1+2d4YEFXEGA/zzOGMo6VOPXcL
RAqLF2VJLaCoOPZ2tE0sZP+w24s4QwV+fkSv0atY0DErGD3w0Qq0/H+dKWuK
g4d3Mycz5tnCxMiqlNasrcBN43sUt9lB9Qo3ak/0NkgwVNn1htnD9cxdlDgX
IVhf7DilN/4t5HIF67SnhZBW58uZV7IEfJTlF7J64kEsT7juwaDB9xyP8JLC
BDAie/JdR+igJ6W6Fe7YDv7bNxbQ85yhwqN6bUFgIljULxL527vCUeXxG3Ym
IpDtOHKS+ZABgV7tAUUqEYQc3uBSep0JtLbzp9jhYqCHZ3Ar97lBgUsr/X6T
GBSj+hV5XHeIV+v81UWXQC9/ZKWJNQFxtVM22SckUFxA0UudIaDnzpz0xk8S
eHG41TYPW+L7PLcLm5aStKIG26yx/hcFdl1Y/87n2D/VCBsmsRXWp18GfiRA
daL7H/tZCZhW27Qs+JcAA25u1DHso02MvY2fCFg99I1P5GcJ9F1+VqjAHv9x
cl08NrX85JVJ7ON/dm5Kwa5OV4/bzxLQ35K6S4bdGXBj0zHsmMrB3zqwdR74
eEZ+JuDQtjIqQyOBoPY3ISnYDi+Sacux866dTZRh3wkL9gzEtisiyzuwKUFa
HAE2RHSYMTQEnHUV5BRiH2EnMwOx/c57F1Vi32M5Bgmwx6zN5LXYkXY56YXY
DMqtlrvYclPvslrsB9ml9x5hv9aZaLiLnUze/WQE2+PdGcUINjWNrZrC/v/P
oEntMKPB/g/lv07Y
     "]]}, 
   {Hue[0.15529157249600445`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx/HJLaVWGpyp5DqUSTPG98RiW29JFI2imW3JNI1LjMEwrqub
danVrjMzWBHrmhVK5aRZ3T4uUdp0H7fdGoVka8hYWy3Nfvacfnid53n8Ay8r
fnxghBaJRGLh/d/Dr3bOaDQEirK5nq3RMNF4hunfw/MEooT0ll99yUSsFc//
ufKBQEjW35raw0SWrqKFeDWBLLVmJqbymagjT6avHCfQA6XdTuVaJtKn95uj
ewTy/UVi0u7uiAqTeH7HThOI53TbX3fKATUuEteSXAhEMjeVGDyzRboRPk6r
Qp3QsWhjqiljKSIP3BJWS5kIuYVE7V5qCIGdpWH2vY4ItpprTO/YQsbUZqHk
JQPt3fGaMnfUCeSppYLmADqCMd9KQYkrsGRsy08lDuhBiodL9hkAn/LrLN83
NGTJfcoKFW6Fup50hTjEHvV+ig11n/EBbnahyf36dchBkWBI7/KDIzzt8wZk
OzQamSa3ZQcAaaPFTa8cKuK9nb9NFuyGoZMlxxufWqPGLeLFFQFBYLY06uzs
FitUOStobzJmQ8wmmu6wmQWa9aTc69JwIMzlWX1n5xo0QNJ+NzKyF2hpbpq4
WgqKMouXZNYEQ9WfQV3pniaI81iSueHkPniVafKVD2UlUo0Tqm8CudBWtN57
grMczezYxumx4IHj68FZRrke2hQi9RwzOgBb24aXLHBIqG9VuaBLfQBEZ5vf
G5HVN03rsq7VT/CBE2lT9ejQ4M0WJc2fdS8Men4fzCOCBjxWP5k+mHIuHNw2
tl/aVaz2oBdJm2oqI0ArxeSP8FUkOKWjpsuyImHxsl2ZfJUeXPRkDOWkH4Qs
pcIrsWY5yFzyjOYFUXDhdO6uIzNG0Dt8Jpfwj4b46vAVoxwTaN5ZRhWBALiC
0rXHMykwGRtEiqPGwA+7U1yJsjWg2mYfpdIWgo5x0fjRj+ZQ9XbwvXhOCP13
c6azDa3g7Ba/nraBWGBn8J1LO62BF1F8Q68vDoQGf1n3BVMh1rlWTW6JB4vG
7p/1Jm3BSnlw6OF2EWTIvYIMT6+DFwYxAWWdIhDVCVudGfbwIJ8V5rMpAZZp
ufDpYzQoTKswSL6QAN6xe4poBQ5w7YbmQ5h9IlB+WxvvTaWD4T44TpQmgizx
hNSxnwGuPFV9jrEYAnMDNpa3OkL+1UPR8lwx0EKy2bWHmeArXi1qmhODYnxJ
dQHbCQaktgY2oiTo4495rrQgoHCxkfd3I0lQWmSkl/6BALvRaPKefcnwIrfD
qgD7ecxCBx/bPk28+Rx2sVqSmIAtD36aNIKtry1/mI+tsCh5uf0jARNWepI7
2OQGy/bV/xLQsL96mUdoMvx4g3Ho2jwBjOEhXRo3GZ40K4sV2K/4cZe/xF5T
JW2Zxq6YXBThg92QpZ6kLhCw4uP6rnDs275Xvv0Je5qS+n0Fts7jr124nwi4
xCFrjPcng3/XVGAadsyzuvM22AWXK+Nk2NaRblwnbOtTWnXd2AXJB64HYENo
tzFDQ0BSYXNGHvYJVqrjdmwHM68NJdj3Pdb7h2GP1iiGfsXmWudlFWOzWxZc
b2HXkd0rLmJ/4S59/RhbpfOm7S52dwe15AW281yZYgz7yA657zvsz38Gzo/8
3muw/wMBakD3
     "]]}, 
   {Hue[0.39135954999579425`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1G001HkUwPFJjNo4QtMSGSalmcUM/10imtvKUzE0YaXl2EEmBmPGwwhF
RGlVBhUapSYVZ5P0IGfxk2JXWzoqj+2SQspJa7K2Ycz+nLMv7rn38+L79lrw
ErhRGiQSiYNnaWdO+M6o1QTCp7zS7PW28fS1s0MLS6ZT4/itbM7q4bl7X7Al
N+Sb+d1scyehKkGBzUqMJvOH2Q8KpCtGxrFP9njNRk+zV9j2maEn2Ftz7k9F
q9klSeG7sioIhIqGEt9F60HtMrGc5EggaNbmjEdTQSvK09441B4903VYqRnK
AsP+R4JLRXYITrmjq35bgNteHkHvYiE+U6lrpwuQPu0qOP2GiXzoUX+v9dwB
janlMXV+tuj2i8zk37d4AUcaaL5YZo1cDBh1mod9wFPWzPGaYiD+vFR2Jdgf
qjvTesX76EjYMUHU+XIhLLeE0n3NChWEkDeqBAFwKHz5jVWGmxCvM32/HT8I
SDbUVrejlghpG++O3RsMgyfK8mtf0hBLP+vMZFIImH7Fv/75ewsUqnC15gh+
hNjvGFpDplQkq3xkOlcYBhGOf11rbzdB9Sedh3q44cCQOKvj5UZI3OTqL/P5
Car+3PMwbTsFtXRdmTm+jwcT2RQXTyMDxPd0aj4QHAFNpZvd3wXpooprdndi
YyKBNTnwmSkjo9OK5mxhahTsaBpaqQoiobGa5BS+aD8Ir9f9q2+oaG33kJ47
ciQagvZvqOrJGGgl+Q2OnsriQ+cfAwXEnn42afvdZRfTDoCzTdst/7MK9rGv
53x78mNAI4XyKtKYBMKQiAdzObGgreOfzftIhtfZ30aySwWQM9LrJrqsC2uK
ywaPV8XBzYo8/0Mz+nB1NSOtsyIeEi5Frn4bRIF2EdXdqjYBwmLK1+dnG8EF
84umrgFCOL47xYk4bwItGUoS/5kQNNeUjh9WmoH5Lu2FDT8kQt/jo59y9Syg
oZt+YuBFIgSm8xzK22lQ0LHIMg8VgWDVB9rTEEuQiidjwl+JgFrbcYb8fiMc
pJjp0faKIb3RbY9ehRVU07W6kkbEIKwW3HVg0mH552XGbWFJoKPhyLMdY4Cc
VX+ociIJ3OMCShnF1rCJV8NRxSWD0f31Ce6WttDvff9W4IdkkIqOFbH6mPD0
8kEbtjgFuHl+NrK7LFA07HahzaQAY19uoDzTDpSNojt58anQO77yUnGgPXiw
PNwzZlPhKW9suwGVgLZQ5oFYsQTKS/XJaV8IyFJ1Xf4wL4HRvAcWxdi+Jcaz
89h0idj1F+x13/A9dBYk0BjyMuk1dkOw1qQ1di+17I23koDxBrZtPLZhjXnb
unkCfGJuN37C/rmFmfHrAgFGfbInsyoJvKgbOduL/TZuyoy8KAGTqqKGT9j1
mluFa7FrchTvLVUE7LTvN3DE/s3r3t5C7MxCg2AJtubzbY5hiwSMuuWPKrF9
Hk5zJdg3B18Sq9QSKL5zMV6KnZFoedQEm3ZOo7oDm3KhzcoFG0I71jDVBHgp
5wWZ2Mc4qSxvbErRzpZC7G72Zp8I7FGrMr1K7DBaQc5Z7PRAh1st2NWGWy/U
L/VTucu7sT9qTjU9XupzngcMYzv8c753bKk3plVPY///z+DGTeGcGvs/kCZE
aQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -100},
  PlotRange->{{-20, 20}, {-100, 399.9999918367347}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Da es sich offensichtlich um eine Parabel handelt, k\[ODoubleDot]nnen wir \
die entsprechende L\[ODoubleDot]sung durch einen Ansatz ",
 Cell[BoxData[
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "2"], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{
     SubscriptBox["a", "1"], "x"}], "+", 
    SubscriptBox["a", "0"]}]}]], "Input",
  CellChangeTimes->{{3.36594277260371*^9, 3.36594285897091*^9}}],
 " mit unbestimmten Koeffizienten finden. Die Zusatzbedingung ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["a", "2"], "\[NotEqual]", "0"}]],
  CellChangeTimes->{{3.36594283251054*^9, 3.36594292667731*^9}}],
 " schlie\[SZ]t uninteressante L\[ODoubleDot]sungen aus."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "2"], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{
     SubscriptBox["a", "1"], "x"}], "+", 
    SubscriptBox["a", "0"]}]}], ";"}], "\n", 
 RowBox[{"sys", "=", 
  RowBox[{
   RowBox[{"First", "[", "eqn", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{"f", ",", "x"}], "]"}]}]}], "}"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], "+", 
     RowBox[{"2", " ", "x", " ", 
      SubscriptBox["a", "2"]}]}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], "+", 
     RowBox[{"2", " ", "x", " ", 
      SubscriptBox["a", "2"]}]}], ")"}], "2"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["a", "0"]}], "-", 
     RowBox[{"x", " ", 
      SubscriptBox["a", "1"]}], "-", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SubscriptBox["a", "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{"sys", ",", "x"}], "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     SubscriptBox["a", "2"], "\[NotEqual]", " ", "0"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "0"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["a", "2"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "8"]}]}], ",", 
    RowBox[{
     SubscriptBox["a", "1"], "\[Rule]", "0"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], "8"]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Aber selbst bei Angabe der entsprechenden Anfangsbedingung wird diese \
spezielle L\[ODoubleDot]sung nicht gefunden. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", "0"}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Dasselbe gilt f\[UDoubleDot]r dieses Beispiel, wo Einh\[UDoubleDot]llende \
sogar die konstanten Funktionen y[x]=\[PlusMinus]1 sind.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], "-", "1"}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{"eqn", ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
   "Simplify"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["x"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["x"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "&&", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Solve\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Solve\\), so \
some solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", 
      SqrtBox["x"]}], "]"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{
       "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "/.", 
      
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
       RowBox[{"\[ImaginaryI]", " ", "i"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "7", ",", ".5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Hk4VN8bAHBmhiwpqbTINlcbUqhI6ry2RKWSpQVZEpKtFBJKKpSl0mIv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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk0Vd/7B3DTxb3X3CiFopQmKh+Z2k+kQvkqaURFJSqJlJASZR5CSIQM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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc8ld8fAHAjst1rZWSFjGhIZcTnRMtIU0MSMhKhhZTqq2WvkIxQNKRC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     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4lF0UAHBSkkqYxVaWUoS0IW3O1UJJi6SkPmoSyRKVJUSlskWIqGSX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     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13dcje0bAPAGUsYbaZxz2qlQSkIlum5KSG+IFCUUhSIZDTTIi2hLykpL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     "]]}, 
   {Hue[0.8503398874989481, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VF8bAHBLKqksbW+WmbGEspQWLdRzSiVLkq1SESmKFKVsbRRJCiFU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     "]]}, 
   {Hue[0.08640786499873876, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c4VW8cAPB7r5HRkKKB3HuuKCOkJfF+RcuqhJYKKSOJskuUCkUkKZWR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     "]]}, 
   {Hue[0.3224758424985268, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk0Ff8bB3AXl3vttFAKWbIkqZSkeh4kbVSiUkTXFpVokaVSlizRKm3W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     "]]}, 
   {Hue[0.5585438199983166, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc8Vu0bAHA781koqYwoEWnIrK47kpdK9aJUkhUpK1tpkZTISCgyelFJ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     "]]}, 
   {Hue[0.7946117974981064, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VG8XAHBSCWHMjC1CJUukfSPOgwoRZatUQgoREZGEVD8lUVJU1jaF
UpIS9dj3fd/XLGOWa022vPf9az7fz9yZe5/znOecc9fZuZmeX8bFxfWCm4vr
/5+x/nYrt9nf1/r7VtnXUKICFzbIGR2Xc4JXzdE2PaaNeKn41y05uWsQOGlW
PijagoUiMj/xtwaBEt1jrYhqG47NfSC7Qu4eOGS3xe4ZaceqhH3YkkM49Obs
Ugi62Im7hOL+LbREwJSArKZPQReWf8u3e27+CWybuME9vtCNXTS9Ls3IPoOx
59fepgr14i+Nva+ndGNAps+E70lkL55zNuocd4iHzpoNZxpE+vCBqkcb/7S8
BO8+9b75P314JFovb8rpNVR7G2xKsOnHofaLpyfn34BuwcbqLUX9uGHeMXJM
9j2MCMSK8t8cwFdLZLYSn5Nhh9mwpVzbAF7zuLGCrZsK4yZ/VfI2/8Z2mxAP
0yENkoJ1Aj5W/cbL5n1rpvw+AVM0wsRFchA39lqsnTr4GeqkrlOf2w1in1SB
rImWdNhTuiprmD2ID0cMrZxI+AIn2GE2xluHsLRPnvm4UwZYRPO9/3J5COfq
eo8R81+hrkjFcpA5hHk7+hXZslmgZCoUdLJ6GLfm/vRijWRBjNWuYU2eEZz8
NrqA+fkHNBV4XSvaPYKNPYzPjurmwLGLRyOmn43gp3w/ng47YDDU8qKqmjJw
hvdhjysSubDVg7H59g0GjhndIznplwtr3yyEtSUxsGst1WHiYB6s1JM+EDvL
wNSY0mXjLfmQJlSjcCJiFM8LZb6/vL8A7H8ZVV3KHMW/b746OpZQAGnU3a++
t43iTAf/OMKpENgJK+N5ZJjYasdOdc58EXRflE6ZjWVi3bfr+i7ZFEOz0P2E
gzlMrCopfJddWAxnggW9WW1M/O8fo4n1oARkfP6usqKxcGJ5vDtTtgwyOSZ2
4gEsPBX9dVNPaBnk5lGCfz5n4UMOFQP1s2WQtO76w7yvLMzimbH40VAOYX33
H4wzWHivprH6veBK4FF5knjEkI3vC9hP+k1VAvL9cQHZsXF327XUy7ZVEPZr
2jbZh41vX30jc0KjGlZ0hb/kvGLj2rSFZYpEDWSGFsn6T7ExFfisBdVqITnM
Scydl4M1FCLVg+1r4aRX7jWOJAeHTb2f9K2rBS0HuZKHmhy881HTebuUOli4
pTX1PoCDrX1sdDr76mDL2SQtxXAODj7LlLGUqIe4sRXcWnEc3L6Zu9XgTj3I
KrT7a2VzcEC56uFtZxtANsH8b+YYB7/7/E0h5UkDoFdoTGWRg+ujdXg2VjaA
ZVmi5yE+Ass7nMiR2NcIZXW/fN3lCGxsPBAd4dYIkYdmHt9WIbD3Llev1W8b
wZBvm5PObgKX89xW46I1gb+jz/qCwwSeGhUS8DVogkfFMnZ3zQm8tv7Z8GRA
E9wz8xBdPEPgywlpCcOsJhgb4j4460ZgMc0Oak1xM9iULHpYPSQwkr9A6C82
A/de4U1ZUQR2EhivyN/RAquF/KJq4gic07byTmZCCzxqXH5UMZXAQ7mPbLe2
tIAr7xmXi+kEFn4nrZUs2Ar6JfV9jt8JbHd1+0ysbys0T9zQf1FA4NAzPxvE
P7fCLvttw7WlBP56QP/To+FW+GOrqV5UReBVNGunO+ZtgA63qLCbCbx9buTg
UkgbuX9iJ9Z3EPhU35X11/LaYPsmPXPJHgJ/TLvX4aLWDnEecp9Mhgg8Sh0N
PWzbDokXQOkUg8CKVw9rKUW2w+rrO/u3swhs35ZMrChph/je8UstHAIn7BdI
HJhtB4NHq08ajBO4M97ZNE+1A/SFK9TuTRJYkqeSJ/5sB+Sk7PCJmiaw5QXV
r34RHWBzck2O5wyBI8pCL1gVdQBTWC1g3SyBq1XZ4nv/doBT4YoDcXMEFnh4
pExUpRMS51TvM+cJrD/5wXfyTCfcmNzSwLdI4NuWQqp1DztB2i8pepZ0bpZr
18eCTgDbA5bZ/wi8KF0TFvqnE86EtN82WSKweuAWdFG5C7Kx84tM0lcHwsf1
TndBpMx24XHS6YfGXm4M74LTWslmS6SJ90fNefK7YIovtr2PtKrg5xV9U10Q
bKJMf0ba8bLIt1+K3fCdr8p1I+nXDe6OMVbdEG/vejyYvH/f7npJ3wfdMB1o
vw+TzyfzfHvF8dxuaJgJ8K9aILDVYoTfrslukFxHC08n1/fUZnIzTaEHfsjM
1bmS628oMOsZO9EDAx9fpi4j40NRzHhYfb8H/hTTbrmS8TMKoeuk/uqBHbNT
39LJ+N5le07eG++BwbdPUmvI+Nu9u1i/g9oLRVxTuUXk/sQLVNwSOdgL/Rpe
+VpsAmtpXj8daN0LH/6oO+WPkvvnqrKL8O6FJ9WUV3IjBJaovz9UmdwLxgHs
Xa79BM7k2Y81CnuBoyYM1mT+mO9iRSV39cI7uSCNTZ0EfhRtZHCX0gcCUkfs
jjcReGv5wroZZdLxxI6sOnJ/51Pnzuv2wYGMIL2/ZL7ynxVM1b3aBwFJ6d7C
xQS+tbFaaKmjD66Vp79IziDw+uP+w5em++BmYeSGpTRyf++q5XYK9UNubbXV
jhQCLzDD3H9o90PgvscLGokE9ko3afRK6ofFZd/6m+4T2AHqnrE8BsDczQk5
niIw18s/PzruD4CPStnrWfJ8Ry+X7ix/PQC8Hfa8l40JXFp2QeZ98wBUJfz5
sFqbwErmCy/Pq/8GXf1rHwQ2EnjEUTG1m3sQ1N4p/jMZ4eDACqOqqjWDsEnJ
Xcqwl4Ml1Dw4OTsG4QrvSLhaK4fM15ytL84PgrjycZ20Eg5+f8P06/GyQXj0
+ItQ7BsOvhhx41ftwyGwcUhpMT3DwcumX/bg90OgrE91ZZhx8PPjpVxp+UNw
ZLR+j/NhDi6Xpuk+mBoCjysTgtv2cLBK0rsSgxPD0EY8NiwX5mBWdkNtvuwI
lHv8pVv+ZGPXQeWBjI8MiF4mktrGz8a91m2r8soYUMu/rXj9PxY2a72rVvWb
AYYGzp0nxsl+UTF8bXDNKCRacyWGtrAwz+c3FLHgUZB5PD0u9oqFo/3WaXmf
ZcLQ1Y7G1t0snEeTfLaPwoY/YORENWVi/nW3FXv2jkHi3iaNm9YMHEap2JRo
Mwk719U6UI0GsV2HOeap/AObtXa+lr3Zi92Lbtu5Kc7B97lDGREHW/Dny6vN
JAwWISBC6/STU5U48brz6NbjXIh7n/ElcZl0HBS/cGyKxY3KrzAx33+fgKuh
F+X48qBHmoJ14baloOB5wcd80wp0Yducuad1I/yejrIU+LkSbfkQM3PNqQMO
D168EeG+Cmk7ardYqfWB8e+HKjIy/AgvD/Z8p/EbRgvsAks/CCBNRdulqNwh
UBNpXqt7VhAdOlzv7i7HgKEHQ0FPzguiuuW+rOdKDIjlnxkedhZEi/92IbyV
AauXS6SH+ggiV/FVnn8RA0b/nDzU/EgQpQkJiG62ZcCbzi5Xp0JBdFj/qX98
AgOk3w3icGUhJOrfI58iNQr8MG3bOSmEUlRlYt2XMcFHW2lV5pwQ2s2MXD3M
R8Zd99THcG5htCwwJcRShAn5+nlzOsLCKFxtNmODHBN8TR88fr9JGG3lFqi/
qskE5vmNRVdthdHb74afuLyZUBlqoSRSI4yKVLz2Jg0yQT38bvVokzASlrF8
eZbFhHePsj0LO4VRnMMZNeokE24/XZfnPSqMgs4EpZ3nYoFM7R9VYhkFbagu
cixew4LmtvwiCxkK6lEOMXYzZoEe22pmvQUFmTGdis99ZkEc/VZDwAkKokUl
jBz8xoIpjZS0zlMUtJpV4bP+JwsSQuYdntpRUH90/WB5KQvmFGNa+S5TEN/r
gJVtPSxItevKGguhIM/MgzzM1WygtJ71+5VLQUel9lOYdmy4sBR8QqqQgmz0
yk9KO7IhR+HTTp8SCqpwmlHSv8QGJy8u9rZqCvKSMjgV7s2GfGrimTcdFMSb
lbix8z4bPI/0a4X+oaA72rHcl7+woTXfnttKVQQNjFh5/fePDWPa7WtubBFB
kXqnE3KWcYA3z2RnwnYRtNLh0FrOSg7sxuoOQ3tF0Dq5MGFdYQ5EZlOqPA6K
oGweCiNDlgMmGTnR961F0HjgJv4s4EDxG/rWnw9FUNLbAww9Pw50y4cY9D4W
QW8LPrxnBHBg+tWSHU+UCDKQ86j/7xYH5F+OPjGIFUHnd4yf/RLCgaC43Pmm
9yJIp3pNQFM0B7SiXEo4+SKo61yGu1YGB77eLbSWmyZ/3zts/m6YA+8OV0gE
/xVBN6aO2s2NcuD56vp69rwI2uLxfaMehwOBD3sOZS+jou+cc/W1Uxwwip5T
s6RQkWSsc/drbgL6k7Yu3VehokmNqzFH1xDQ5LQna0KNio5Y/vU3XktAqYrW
lZPbqSjiwiZFPTkCPqQZDivso6ILzKhKJQUCfL5dqMk7REVpNwKCP2wjQKgk
Jn7GlooOmg3F/tQjgPveq5PW56koS8nezPEwAVOHk2lFjlRk/TCxW/AIAW3V
34Ij3KjID5x9DUwJeN1c77b5BhVd1P81EHSaAPWhVehcNBXF8cTZLbkRcGGF
V291NRVxHdE0UnhMwBrZspb5Oio6pdp/UeAJAdV719YoNVHRvxNfNrKeErDb
pehnUAcV/dA/fCXhOQErG0Rf7B6hImqj/X+NiQS8Sci0iOOmIbOS1iPOaQSc
+MF/pGI5Del6VD/l/0zA6kbrA395aUjta+m9N+kEePLy7jAVoqGUOH336q8E
HHA9TlkpRUP202PWrGwCfmv8Lb+0k4aUjzteO1lCQLSFUf7zPTT0Xr+q4ksp
AUZuCVkl6jTUQzvYzFdOQMZL/XfrtGnIsHJG7H0lAbf5nt1pOkJDlCwtm4w6
AvZuYPstO0ZDWwSEQln1BLD2a3tuMachGwd+b7lGAswvM+zuWdFQ4581Ydeb
CZBv2Yc0HWjo5sLztn/tBLSOPdhz8SINXWuqFRftJCCUv18t6hINjXNbSSt2
kfuhGbJ2/AoNff27cF2rh4DC1+1zrwNpaCPnw0f1AQLOeVz/uvo5DdV+eJLi
NErGc3v3V+VYGrLU1EnYyySAfwJlHkqgoQpi82MeFgGf3Fd+C3xLQxn1at4P
2AQsXH70fSqdhkxLGkzcxwio2Tr1XSSThtpDvYzlxgl4OWaZpZZFQ8Yx200r
SBtclv7hiGnoWaibi+gkAU/dkrI7K2io8z1tue80AU5b+HNmq2lI490HXb4/
BOwnXHLE6mlo7Qf98EjSA67bfx5tJe/nMnMkfoaATLUnPy910JCgWXG+zF8C
QjgzP0O6aSgverXec9JbXX/+KvxNXq/kffPOLAE8anK4b5iGruDj+6ZJN7OD
8L9RGko3UVpuO0eA3yX93L3jZDz9aM2q8wSYbE7JtZiiIb2bzO5Q0uvZgnke
MzR0zkTt3wjpMpeGvNRFGrr19PKtJwsExKjuzi/joiP+B2rMQdKXWdH5Qzx0
dFev0WX7IgG6qfP5PLx0NHFSm+86aTEX6wI5fjri8rXII+dLYKjkFWgK0tGS
/9gTrn8E5DA3FFpR6CjJdiJYk7SdM6MwUoyOcvRTSlJI71IxKvosSUd8v9eL
d5FexfxYVC1NR7YhQcH8SwR0JosUM2XpqKs1WXIn6bSLnsWrNtDRVKhf9UnS
QZtaijcq0JHB7da310lbju4r0VGmo6Cc+FfkfAzKyTElZ1XpSNLsS9EX0gtO
SyV+W+ho+50pwXLSNcp2pc+205Fb2oEbnaRfMgpLM3fRET5yh84kffW9YlnD
XjrSmI9qnCZt4BRSNqZBR5Pu1r8WSEsrs8sEgY4KQn7Uk/M6jI2YlG/SoSNV
zTDq/13wLr1c7yAdbYjP9p8j/dRRtMJen44Yv+UlJkg7KflU3DSko16b1J5B
0vtH2ivijOno1K2dzU2khd9pVmYfoyPf9viFPNL9DgmVreZ0NC9SZ5ZM+qsi
T9X0cToSnEzuDCN9d/h8FfUUHanYU6LdSJ9OKq3aYk1HbMff/xmR3uKgUm1k
S8ZzHX8y+b4A3U6ybh/s6WhL4pY9M2T8Q11oFCFHOrJ7SRgXklZ34/3s6kxH
XyJdJkJJM9znj9W4kvkgVLb+GOloT2Jiiwe53irFPgrpQ94Djx960VF4Ropa
JZkPr/wqmo750ZHSkbTru0ibBuCr6QF0ZHLH68YAmV9cQV/EabfoKG6STX1A
+kzwi5ON98h8kLm9WE/m5+qQ8LmdD+jofijD3I30j9BbL548pKPgJw8P8JIW
j3Dusoyio5uuO8eVyfwvjjzr/+05HSXQfT9lkOfDM8pMViKOjv5xPV6tQbou
RsO27TUdzfXWxauT5+t+ksDgqXQ6+q/lkekK8nyqJy/dyflKfl/tL3GJPM8j
qZMKa7PoKHTR8XbtFAEH0zscuzGZf4GVpiHk+V/KSWHZVNGRzcg8o4ysHx9x
/IO8WjIfrywuCZE+nf9YbX0jHbmGqRWZEARklVy/PNBOR+q82baFZP25Um84
dX6Ejj63FfL4kvVrfRM8KWbSkVHXvS8xDAJqW3bsViToyCXnu1T2CAGbu6R8
RqbpKNJrUpI5RMDwMHP+Io8ourUBOOJkPXw62hNTsVIUDQdk3JToJ+s/u0FT
lV8UPb7Z1EzvIyBxIjuATSGv9/1ZzkXW01OL93kuy4gixo2E2TdkPa6hqgp4
7RNFoj6D3gpkfde6dInxYr8oEurNsZutIddX8rEkH0SRzumUlNJqAsL8tt2m
HBJFN+9HnTpN9gejod2LKaaiaOW73cYnyP5SnqVN9DuLIjp9jdmrHDK+9FtV
fG6iiC92x6P9ZD9Kdi1M2eohimR1I/fXZxFwb4Oeo7+PKDqlPds9kUmA/gOj
Psk7omgb/5wLH9nvimyONxyNE0XXAw/fCn1NwM7s6M/eiaKoV2vjKvZLsj+L
tofHvRZFK54H8x0m++ft8tNGrGRRtNfk653ZWAJ0dtoVBX8TRSrdV/3VogjI
5b307VetKAqVrtUbv0tA9segF6o8YkhcyobT60T2YyOLNVErxZBxgWDCWwcC
jjEUn3HziyGWjJ6F43ky/huqnjZTxFB1r3ZNjw0BtGfiEYEyYmiXYOyG+OME
ON9Kvdu4TwwVFICNzQECpE40e/ldFkN+ngd+TZPzzIXpd1NDV8SQGNqurSVB
wOeI61eOeYuhCVcGJ0iUAL0qOXcFfzHUszOuhotC5ouOs0vtfTH0/EdIafVy
AipUuc7JJ4khf6hLyWBz4Dr3pqOVXWLI1dmi8VMOB4YOCLQq9ImhHatgKTyL
A0fvss7e/C2GQupOxzlnkvOdcJrbbqYYGm3v0pT4xIFK6Z3hCX/F0OXqyPV6
rzggs1er2pMmjqJtGoIX7nIg39XUaK2BONJfHsuoOsYB/k5ffdcMcbT9EY+e
URsbdnu/Fwz/Jo6ypFyOPG1igy21tT7thzjS8W/z76pjw3f9XWfGc8XRDOfu
hXPl5Pz8lXD3rCL/78zrc0ey2ZAXZv/Cd0gcWQ3yjzyPYZPvH8ac/yQkkImP
cfr6M2wYfLsuMt5PAq3uyZ2XbGZBpJLk8iwLSSQVWqe6JowJD59fKLGVW4NG
YvDW8R2jYBV5pnr18BpUOitB7/s1An8PvJmN/yWFOlMeH3BYNQwDgzo++cHS
6Jh69YCH2SC81NwmVWW7Fs3V/ba8cXYAPtzxEnHYLIOsSiaexXj3QbDFOUOe
aRnEecFzNlekB3Z1Jr4PrpJFgb6J+4vz2yFa+cWHKkM5RHvBfb8+qRkCch9E
G2bJodMz1Uf15OvhiJTFm3L5dWhdGCtrzLICtF1LToncW4e6oj0VMmfyIV7a
Tr5yeh3q0w/9t6X6C8gXJD01PrUeXU9r2GPQGgwPN+dvqv+1Hrke7VJN/5KM
L0wuryvbtAEdl2RE7Kj7he0+T8jdC9+ADh2bqgx0LMGl5atu5SxsQDd5Leg6
/TXYRbfvYRnpHg15Xp2BGkzJyYprJo1Y4rPav2vwiQ8Xf4yRdvri0q49VIOH
wyvH5Rc3IJfrFRHaozV4pcVDmwekX01ZtaOJGqzbI65l/W8D0qwyt5PlrsVD
x8cMnUk/buEyjicdUlt60oe0IUNrn+yyWlyfd80rgnS+lLuQLE8ttnvdkVpM
etODD19kVtTiQKd4qS1LGxBj/R3GWr5aLN/vrbyftHzT0epY0qVWR/cYkD55
5WP6Wv5aTDHiNjtHusBF1netQC2OVzsXEkVaWb6VZ61gLdZJ0oh+TfrQyh2D
MaSHZOlvP///+mLZYmmhWqwmUpRXQbqz4+N/0sLk892LrWklvaB67EIM6avL
rnYNkv5oceegNKUWr7luzJwgTTc3lI8h/WtSYXaJdJzCq2XSIrX4f3GXKb8=

     "]]}, 
   {Hue[0.030679774997896203`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4lVsXAHDSVVFKpnOQORqkuihRrR0ZkgaiZKpQEpkKFZVSmcsYkkgq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