(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[  16825678,     274689]
NotebookOptionsPosition[  16805640,     274084]
NotebookOutlinePosition[  16806078,     274103]
CellTagsIndexPosition[  16806035,     274100]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Grafiken", "Title"],

Cell[CellGroupData[{

Cell["Einfache Grafiken aus Primitiven erstellen", "Section"],

Cell[CellGroupData[{

Cell["Ein Gitter", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterPunkte", "[", 
   RowBox[{
   "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", "ny_Integer"}], 
   "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"P0", "+", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "*", "dx"}], ",", 
       RowBox[{"j", "*", "dy"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "nx"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "ny"}], "}"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GitterPunkte", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".3"}], ",", 
       RowBox[{"-", ".3"}]}], "}"}], ",", ".1", ",", ".1", ",", "5", ",", 
     "7"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "//", "Chop"}], "//", "MatrixForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {
           RowBox[{"-", "0.3`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {
           RowBox[{"-", "0.19999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {
           RowBox[{"-", "0.09999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {"0.10000000000000003`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {"0.2`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {"0.3000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.3`"}]},
          {"0.4000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {
           RowBox[{"-", "0.3`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {
           RowBox[{"-", "0.19999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {
           RowBox[{"-", "0.09999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {"0.10000000000000003`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {"0.2`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {"0.3000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.19999999999999998`"}]},
          {"0.4000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {
           RowBox[{"-", "0.3`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {
           RowBox[{"-", "0.19999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {
           RowBox[{"-", "0.09999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {"0.10000000000000003`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {"0.2`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {"0.3000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "0.09999999999999998`"}]},
          {"0.4000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {
           RowBox[{"-", "0.3`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {
           RowBox[{"-", "0.19999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {
           RowBox[{"-", "0.09999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0.10000000000000003`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0.2`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0.3000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0.4000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {
           RowBox[{"-", "0.3`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {
           RowBox[{"-", "0.19999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {
           RowBox[{"-", "0.09999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {"0.10000000000000003`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {"0.2`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {"0.3000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.10000000000000003`"},
          {"0.4000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {
           RowBox[{"-", "0.3`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {
           RowBox[{"-", "0.19999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {
           RowBox[{"-", "0.09999999999999998`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {"0.10000000000000003`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {"0.2`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {"0.3000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.2`"},
          {"0.4000000000000001`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Primitiv kann auch mit Liste von Punktlisten als Argument verwendet werden \
und ist in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Code meist in dieser Form anzutreffen. Ist ein Design-Problem.. Besser w\
\[ADoubleDot]re der Name ",
 StyleBox["PolygonList",
  FontWeight->"Bold"],
 " gewesen. \n\nWir verwenden deshalb nur einfache Polygone."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gitter", "[", "g_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Dimensions", "[", "g", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{"i", ",", "j"}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{"i", ",", 
            RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", 
            RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", "j"}], "\[RightDoubleBracket]"}]}], 
         "}"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}]}], "]"}]}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"g1", "=", 
     RowBox[{"Gitter", "[", "g", "]"}]}], ")"}], ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.3`"}], ",", 
         RowBox[{"-", "0.3`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.3`"}], ",", 
         RowBox[{"-", "0.19999999999999998`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.19999999999999998`"}], ",", 
         RowBox[{"-", "0.19999999999999998`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.19999999999999998`"}], ",", 
         RowBox[{"-", "0.3`"}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "33", "\[RightSkeleton]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.10000000000000003`", ",", "0.3000000000000001`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"0.10000000000000003`", ",", "0.4000000000000001`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", "0.4000000000000001`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", "0.3000000000000001`"}], "}"}]}], "}"}], "]"}]}],
    "}"}],
  Short[#, 7]& ]], "Output"]
}, Open  ]],

Cell["\<\
Daraus eine 2D-Grafik erzeugen, mit gr\[UDoubleDot]nen Fl\[ADoubleDot]chen \
sowie kurz-gestrichelten schwarzen Kanten, gesteuert durch geeignete \
Grafikprimitive.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
     RowBox[{"EdgeForm", "[", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "Black"}], "}"}], "]"}], ",", "g1"}], "}"}], 
   ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[{GrayLevel[0], Dashing[{0, Small}]}], FaceForm[RGBColor[
   0.87, 0.94, 1]], 
   PolygonBox[{{-0.3, -0.3}, {-0.3, -0.19999999999999998`}, \
{-0.19999999999999998`, -0.19999999999999998`}, {-0.19999999999999998`, \
-0.3}}], PolygonBox[{{-0.3, -0.19999999999999998`}, {-0.3, \
-0.09999999999999998}, {-0.19999999999999998`, -0.09999999999999998}, \
{-0.19999999999999998`, -0.19999999999999998`}}], 
   PolygonBox[{{-0.3, -0.09999999999999998}, {-0.3, 
    5.551115123125783*^-17}, {-0.19999999999999998`, 
    5.551115123125783*^-17}, {-0.19999999999999998`, -0.09999999999999998}}], 
   PolygonBox[{{-0.3, 5.551115123125783*^-17}, {-0.3, 
    0.10000000000000003`}, {-0.19999999999999998`, 
    0.10000000000000003`}, {-0.19999999999999998`, 5.551115123125783*^-17}}], 
   PolygonBox[{{-0.3, 0.10000000000000003`}, {-0.3, 
    0.2}, {-0.19999999999999998`, 0.2}, {-0.19999999999999998`, 
    0.10000000000000003`}}], 
   PolygonBox[{{-0.3, 0.2}, {-0.3, 
    0.3000000000000001}, {-0.19999999999999998`, 
    0.3000000000000001}, {-0.19999999999999998`, 0.2}}], 
   PolygonBox[{{-0.3, 0.3000000000000001}, {-0.3, 
    0.4000000000000001}, {-0.19999999999999998`, 
    0.4000000000000001}, {-0.19999999999999998`, 0.3000000000000001}}], 
   PolygonBox[{{-0.19999999999999998`, -0.3}, {-0.19999999999999998`, \
-0.19999999999999998`}, {-0.09999999999999998, -0.19999999999999998`}, \
{-0.09999999999999998, -0.3}}], 
   PolygonBox[{{-0.19999999999999998`, -0.19999999999999998`}, \
{-0.19999999999999998`, -0.09999999999999998}, {-0.09999999999999998, \
-0.09999999999999998}, {-0.09999999999999998, -0.19999999999999998`}}], 
   PolygonBox[{{-0.19999999999999998`, -0.09999999999999998}, \
{-0.19999999999999998`, 5.551115123125783*^-17}, {-0.09999999999999998, 
    5.551115123125783*^-17}, {-0.09999999999999998, -0.09999999999999998}}], 
   PolygonBox[{{-0.19999999999999998`, 
    5.551115123125783*^-17}, {-0.19999999999999998`, 
    0.10000000000000003`}, {-0.09999999999999998, 
    0.10000000000000003`}, {-0.09999999999999998, 5.551115123125783*^-17}}], 
   PolygonBox[{{-0.19999999999999998`, 
    0.10000000000000003`}, {-0.19999999999999998`, 
    0.2}, {-0.09999999999999998, 0.2}, {-0.09999999999999998, 
    0.10000000000000003`}}], 
   PolygonBox[{{-0.19999999999999998`, 0.2}, {-0.19999999999999998`, 
    0.3000000000000001}, {-0.09999999999999998, 
    0.3000000000000001}, {-0.09999999999999998, 0.2}}], 
   PolygonBox[{{-0.19999999999999998`, 
    0.3000000000000001}, {-0.19999999999999998`, 
    0.4000000000000001}, {-0.09999999999999998, 
    0.4000000000000001}, {-0.09999999999999998, 0.3000000000000001}}], 
   PolygonBox[{{-0.09999999999999998, -0.3}, {-0.09999999999999998, \
-0.19999999999999998`}, {5.551115123125783*^-17, -0.19999999999999998`}, {
    5.551115123125783*^-17, -0.3}}], 
   PolygonBox[{{-0.09999999999999998, -0.19999999999999998`}, \
{-0.09999999999999998, -0.09999999999999998}, {
    5.551115123125783*^-17, -0.09999999999999998}, {
    5.551115123125783*^-17, -0.19999999999999998`}}], 
   PolygonBox[{{-0.09999999999999998, -0.09999999999999998}, \
{-0.09999999999999998, 5.551115123125783*^-17}, {5.551115123125783*^-17, 
    5.551115123125783*^-17}, {5.551115123125783*^-17, -0.09999999999999998}}],
    PolygonBox[{{-0.09999999999999998, 
    5.551115123125783*^-17}, {-0.09999999999999998, 0.10000000000000003`}, {
    5.551115123125783*^-17, 0.10000000000000003`}, {5.551115123125783*^-17, 
    5.551115123125783*^-17}}], 
   PolygonBox[{{-0.09999999999999998, 
    0.10000000000000003`}, {-0.09999999999999998, 0.2}, {
    5.551115123125783*^-17, 0.2}, {5.551115123125783*^-17, 
    0.10000000000000003`}}], 
   PolygonBox[{{-0.09999999999999998, 0.2}, {-0.09999999999999998, 
    0.3000000000000001}, {5.551115123125783*^-17, 0.3000000000000001}, {
    5.551115123125783*^-17, 0.2}}], 
   PolygonBox[{{-0.09999999999999998, 
    0.3000000000000001}, {-0.09999999999999998, 0.4000000000000001}, {
    5.551115123125783*^-17, 0.4000000000000001}, {5.551115123125783*^-17, 
    0.3000000000000001}}], 
   PolygonBox[{{5.551115123125783*^-17, -0.3}, {
    5.551115123125783*^-17, -0.19999999999999998`}, {
    0.10000000000000003`, -0.19999999999999998`}, {
    0.10000000000000003`, -0.3}}], 
   PolygonBox[{{5.551115123125783*^-17, -0.19999999999999998`}, {
    5.551115123125783*^-17, -0.09999999999999998}, {
    0.10000000000000003`, -0.09999999999999998}, {
    0.10000000000000003`, -0.19999999999999998`}}], 
   PolygonBox[{{5.551115123125783*^-17, -0.09999999999999998}, {
    5.551115123125783*^-17, 5.551115123125783*^-17}, {0.10000000000000003`, 
    5.551115123125783*^-17}, {0.10000000000000003`, -0.09999999999999998}}], 
   PolygonBox[{{5.551115123125783*^-17, 5.551115123125783*^-17}, {
    5.551115123125783*^-17, 0.10000000000000003`}, {0.10000000000000003`, 
    0.10000000000000003`}, {0.10000000000000003`, 5.551115123125783*^-17}}], 
   PolygonBox[{{5.551115123125783*^-17, 0.10000000000000003`}, {
    5.551115123125783*^-17, 0.2}, {0.10000000000000003`, 0.2}, {
    0.10000000000000003`, 0.10000000000000003`}}], 
   PolygonBox[{{5.551115123125783*^-17, 0.2}, {5.551115123125783*^-17, 
    0.3000000000000001}, {0.10000000000000003`, 0.3000000000000001}, {
    0.10000000000000003`, 0.2}}], 
   PolygonBox[{{5.551115123125783*^-17, 0.3000000000000001}, {
    5.551115123125783*^-17, 0.4000000000000001}, {0.10000000000000003`, 
    0.4000000000000001}, {0.10000000000000003`, 0.3000000000000001}}], 
   PolygonBox[{{0.10000000000000003`, -0.3}, {
    0.10000000000000003`, -0.19999999999999998`}, {
    0.2, -0.19999999999999998`}, {0.2, -0.3}}], 
   PolygonBox[{{0.10000000000000003`, -0.19999999999999998`}, {
    0.10000000000000003`, -0.09999999999999998}, {
    0.2, -0.09999999999999998}, {0.2, -0.19999999999999998`}}], 
   PolygonBox[{{0.10000000000000003`, -0.09999999999999998}, {
    0.10000000000000003`, 5.551115123125783*^-17}, {0.2, 
    5.551115123125783*^-17}, {0.2, -0.09999999999999998}}], 
   PolygonBox[{{0.10000000000000003`, 5.551115123125783*^-17}, {
    0.10000000000000003`, 0.10000000000000003`}, {0.2, 
    0.10000000000000003`}, {0.2, 5.551115123125783*^-17}}], 
   PolygonBox[{{0.10000000000000003`, 0.10000000000000003`}, {
    0.10000000000000003`, 0.2}, {0.2, 0.2}, {0.2, 0.10000000000000003`}}], 
   PolygonBox[{{0.10000000000000003`, 0.2}, {0.10000000000000003`, 
    0.3000000000000001}, {0.2, 0.3000000000000001}, {0.2, 0.2}}], 
   PolygonBox[{{0.10000000000000003`, 0.3000000000000001}, {
    0.10000000000000003`, 0.4000000000000001}, {0.2, 0.4000000000000001}, {
    0.2, 0.3000000000000001}}]},
  Axes->True]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Dasselbe als ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Objekt:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterComplex", "[", 
   RowBox[{
   "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", "ny_Integer"}], 
   "]"}], ":=", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Join", "@@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"P0", "+", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "*", "dx"}], ",", 
           RowBox[{"j", "*", "dy"}]}], "}"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "nx"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "ny"}], "}"}]}], "]"}]}], "//", "Chop"}],
     ",", 
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
           "1"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
           "2"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "2"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "1"}]}], "}"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"nx", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"ny", "-", "1"}]}], "}"}]}], "]"}]}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gc", "=", 
   RowBox[{"GitterComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".3"}], ",", 
       RowBox[{"-", ".3"}]}], "}"}], ",", ".1", ",", ".1", ",", "5", ",", 
     "7"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "gc"}], "}"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[RGBColor[0.87, 0.94, 1]], 
   GraphicsComplexBox[{{-0.3, -0.3}, {-0.3, -0.19999999999999998`}, {-0.3, \
-0.09999999999999998}, {-0.3, 0}, {-0.3, 0.10000000000000003`}, {-0.3, 
     0.2}, {-0.3, 0.3000000000000001}, {-0.3, 
     0.4000000000000001}, {-0.19999999999999998`, -0.3}, \
{-0.19999999999999998`, -0.19999999999999998`}, {-0.19999999999999998`, \
-0.09999999999999998}, {-0.19999999999999998`, 0}, {-0.19999999999999998`, 
     0.10000000000000003`}, {-0.19999999999999998`, 
     0.2}, {-0.19999999999999998`, 
     0.3000000000000001}, {-0.19999999999999998`, 
     0.4000000000000001}, {-0.09999999999999998, -0.3}, \
{-0.09999999999999998, -0.19999999999999998`}, {-0.09999999999999998, \
-0.09999999999999998}, {-0.09999999999999998, 0}, {-0.09999999999999998, 
     0.10000000000000003`}, {-0.09999999999999998, 
     0.2}, {-0.09999999999999998, 0.3000000000000001}, {-0.09999999999999998, 
     0.4000000000000001}, {0, -0.3}, {0, -0.19999999999999998`}, {
     0, -0.09999999999999998}, {0, 0}, {0, 0.10000000000000003`}, {0, 0.2}, {
     0, 0.3000000000000001}, {0, 0.4000000000000001}, {
     0.10000000000000003`, -0.3}, {
     0.10000000000000003`, -0.19999999999999998`}, {
     0.10000000000000003`, -0.09999999999999998}, {0.10000000000000003`, 0}, {
     0.10000000000000003`, 0.10000000000000003`}, {0.10000000000000003`, 
     0.2}, {0.10000000000000003`, 0.3000000000000001}, {0.10000000000000003`, 
     0.4000000000000001}, {0.2, -0.3}, {0.2, -0.19999999999999998`}, {
     0.2, -0.09999999999999998}, {0.2, 0}, {0.2, 0.10000000000000003`}, {0.2, 
     0.2}, {0.2, 0.3000000000000001}, {0.2, 0.4000000000000001}}, {
     PolygonBox[{1, 2, 10, 9}], PolygonBox[{2, 3, 11, 10}], 
     PolygonBox[{3, 4, 12, 11}], PolygonBox[{4, 5, 13, 12}], 
     PolygonBox[{5, 6, 14, 13}], PolygonBox[{6, 7, 15, 14}], 
     PolygonBox[{7, 8, 16, 15}], PolygonBox[{9, 10, 18, 17}], 
     PolygonBox[{10, 11, 19, 18}], PolygonBox[{11, 12, 20, 19}], 
     PolygonBox[{12, 13, 21, 20}], PolygonBox[{13, 14, 22, 21}], 
     PolygonBox[{14, 15, 23, 22}], PolygonBox[{15, 16, 24, 23}], 
     PolygonBox[{17, 18, 26, 25}], PolygonBox[{18, 19, 27, 26}], 
     PolygonBox[{19, 20, 28, 27}], PolygonBox[{20, 21, 29, 28}], 
     PolygonBox[{21, 22, 30, 29}], PolygonBox[{22, 23, 31, 30}], 
     PolygonBox[{23, 24, 32, 31}], PolygonBox[{25, 26, 34, 33}], 
     PolygonBox[{26, 27, 35, 34}], PolygonBox[{27, 28, 36, 35}], 
     PolygonBox[{28, 29, 37, 36}], PolygonBox[{29, 30, 38, 37}], 
     PolygonBox[{30, 31, 39, 38}], PolygonBox[{31, 32, 40, 39}], 
     PolygonBox[{33, 34, 42, 41}], PolygonBox[{34, 35, 43, 42}], 
     PolygonBox[{35, 36, 44, 43}], PolygonBox[{36, 37, 45, 44}], 
     PolygonBox[{37, 38, 46, 45}], PolygonBox[{38, 39, 47, 46}], 
     PolygonBox[{39, 40, 48, 47}]}]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzt3M9P22UcwPGHfKN/ByczEWaBSr/fUhgFSis/bCeFlfGrBcpAx1iguiUe
IB6m6IlND1sisVnSpFqTplm1SS87GHud3vXgX7D/4GOf55sle4gkuoP28E54
Hj6fN4dXnt7pXK6wk9/LFXY3c93xg9ztnd3Nw+6p/YN2crqU6vLap9qt9CxK
vbik/SNhfeny6vPr+tewajabylH1el2Vy2WzeX6TSqUitVpNTBO/lUolaTQa
VisWi3qyWqvVMoo+r73ktalkOqMeV5vmuOZ21NHJfbV9q2A2z2+yuLoh904f
iWnit/hMSh6WqlZzI2N6stpKdusi/ubhXfXHczHHNbejfmi21Jdfn5nN85sc
fPKp/PTLb2Ka+C2ztim//vncahPxGT1Zbb9wFx4eHh4eHh4eHh4eHh4eHh4e
Hh4eHh4eHh4eHv4f8v3BkFpa3zLHNbejJhOzKjwSNZvnN+kfDMl0Ki2mid96
AwMyv7RmtTfe7NWT1a6Mxy7il7N59fTZ7+a45nbUg2/L6s7xZ2bz/CbZG3ty
9v2PYpr4bSa1IPWfn1ktPBrVk9Wy+d0O/fDh4eHh4eHh4eHh4eHh4eHh4eHh
4eHh4eHh4eHhz/FD3rBKL62Z45rbUdFYQoWvjJvN85sEBkOSmLsqponfLvcH
JbmwZLWe3rf1ZLWJqXc79PXw8PDw8PDw8PDw8PDw8PDw8PDw8PDw8PDw8PDw
ncV7I2NqObdtjmtuR+KzSRmdiIvePPHbYCgs781nrNYfDMm1lZzV+gIDerJa
fHruX7xe2q+X9uutF/x3Hz48PDw8PDw8PDw8PDw8PDw8PDw8PDw8PDw8PDz8
/8iHvIhaz39gjmtux/y/7Ug0JnrzxG+DQ2FJppesFhgYMt+b/HJ763JAT1ab
TEx36Ovh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHhO4sfCIbU9t6hOa65
HZl9f1Ei0ZjozRO/BYfCMp9ZtZr+LuX17Q+tdqmnT09Wi05Mdejr4eHh4eHh
4eHh4eHh4eHh4eHh4eHh4eHh4eHh4c/xV69dV6UnT81xze3I8RcPZOf2x6I3
T/y2sJyVk6/OrDaZmJNvvntitXe8iJ6sdn1t4yLeHR5VRyen5rjmdmQtf1Om
U2nRmyd+GxmflBv7H1lNf7/ynePPrdbTF9CT1WKJ2Q798OHh4eHh4eHh4eHh
4eHh4eHh4eHh4eHh4eHh4eHP8cl0Rj2uNs1xze3I0cl92b5VEL154rfF1Q25
d/rIavGZlDwsVa3mRsb0ZLWV7Nbf8sOq2dR/r9frUi6XRW+e+K1SqUitVrNa
qVSSRqNhtWKxqCertVqt855Zwq82q66/AAc2Dh8=\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GitterPlot und ParametricPlot3D", "Subsection"],

Cell[TextData[{
 "g ist das Gitter der Parameterwerte, f: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["R", "2"], "\[Rule]", " ", 
    SuperscriptBox["R", "3"]}], TraditionalForm]]],
 " die darzustellende parametrisierte Fl\[ADoubleDot]che. ",
 StyleBox["GitterPlot",
  FontWeight->"Bold"],
 " erzeugt wieder ein komplexes Grafikprimitiv vom Typ ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 ". \nZu beachten ist, dass in unserer Anwendung f einstellig ist und als \
Argument einen Punkt ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "\[Element]", 
    SuperscriptBox["R", "2"]}], TraditionalForm]]],
 "\[UDoubleDot]bergeben bekommt. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterPlot", "[", 
   RowBox[{"f_", ",", "g_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Dimensions", "[", "g", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"f", "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", "j"}], "\[RightDoubleBracket]"}], ",", 
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", 
             RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", 
             RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "j"}], "\[RightDoubleBracket]"}]}],
           "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}]}], "]"}]}]}], " ", "]"}]}]], "Input"],

Cell[TextData[{
 "Anwendung : Die Tangentialfl\[ADoubleDot]che an die getwistete Kubik ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"t", ",", 
     SuperscriptBox["t", "2"], ",", 
     SuperscriptBox["t", "3"]}], ")"}], TraditionalForm]]],
 "."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"t_", ",", "u_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t", "+", "u"}], ",", 
    RowBox[{
     SuperscriptBox["t", "2"], "+", 
     RowBox[{"2", "t", " ", "u"}]}], ",", 
    RowBox[{
     SuperscriptBox["t", "3"], "+", 
     RowBox[{"3", 
      SuperscriptBox["t", "2"], "u"}]}]}], "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"GitterPlot", "[", 
    RowBox[{"f", ",", "g"}], "]"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Daraus wird mit entsprechenden Direktiven ein ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekt erzeugt. \nHier eins, das in einem dunklen Raum in der Telekomfarbe \
gl\[UDoubleDot]ht."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Glow", "[", "Magenta", "]"}], ",", "g2"}], "}"}], ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "Black", "}"}]}], ",", 
   RowBox[{"Boxed", "->", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {Glow[
    RGBColor[1, 0, 1]], 
   Polygon3DBox[{{-0.6, 0.27, -0.108}, {-0.5, 
    0.20999999999999996`, -0.08099999999999999}, {-0.39999999999999997`, 
    0.11999999999999998`, -0.031999999999999994`}, {-0.5, 
    0.15999999999999998`, -0.044}}], 
   Polygon3DBox[{{-0.5, 
    0.20999999999999996`, -0.08099999999999999}, {-0.39999999999999997`, 
    0.14999999999999997`, -0.05399999999999999}, {-0.29999999999999993`, 
    0.07999999999999999, -0.019999999999999993`}, {-0.39999999999999997`, 
    0.11999999999999998`, -0.031999999999999994`}}], 
   Polygon3DBox[{{-0.39999999999999997`, 
    0.14999999999999997`, -0.05399999999999999}, {-0.29999999999999993`, 
    0.08999999999999997, -0.026999999999999982`}, {-0.19999999999999993`, 
    0.03999999999999997, -0.007999999999999991}, {-0.29999999999999993`, 
    0.07999999999999999, -0.019999999999999993`}}], 
   Polygon3DBox[{{-0.29999999999999993`, 
    0.08999999999999997, -0.026999999999999982`}, {-0.19999999999999996`, 
    0.029999999999999978`, 
    1.3877787807814457`*^-17}, {-0.09999999999999995, \
-1.3877787807814457`*^-17, 0.004000000000000005}, {-0.19999999999999993`, 
    0.03999999999999997, -0.007999999999999991}}], 
   Polygon3DBox[{{-0.19999999999999996`, 0.029999999999999978`, 
    1.3877787807814457`*^-17}, {-0.09999999999999998, -0.03, 
    0.026999999999999996`}, {2.7755575615628914`*^-17, -0.04000000000000001, 
    0.015999999999999993`}, {-0.09999999999999995, -1.3877787807814457`*^-17, 
    0.004000000000000005}}], 
   Polygon3DBox[{{-0.09999999999999998, -0.03, 0.026999999999999996`}, {
    1.1102230246251565`*^-16, -0.09000000000000005, 0.05400000000000002}, {
    0.10000000000000012`, -0.08000000000000003, 0.028000000000000004`}, {
    2.7755575615628914`*^-17, -0.04000000000000001, 0.015999999999999993`}}], 
   Polygon3DBox[{{1.1102230246251565`*^-16, -0.09000000000000005, 
    0.05400000000000002}, {0.10000000000000009`, -0.15000000000000005`, 
    0.08100000000000002}, {0.2000000000000001, -0.12000000000000004`, 0.04}, {
    0.10000000000000012`, -0.08000000000000003, 0.028000000000000004`}}], 
   Polygon3DBox[{{-0.5, 0.15999999999999998`, -0.044}, {-0.39999999999999997`,
     0.11999999999999998`, -0.031999999999999994`}, {-0.29999999999999993`, 
    0.04999999999999998, -0.006999999999999996}, {-0.39999999999999997`, 
    0.06999999999999998, -0.009999999999999993}}], 
   Polygon3DBox[{{-0.39999999999999997`, 
    0.11999999999999998`, -0.031999999999999994`}, {-0.29999999999999993`, 
    0.07999999999999999, -0.019999999999999993`}, {-0.19999999999999996`, 
    0.029999999999999985`, -0.0039999999999999975`}, {-0.29999999999999993`, 
    0.04999999999999998, -0.006999999999999996}}], 
   Polygon3DBox[{{-0.29999999999999993`, 
    0.07999999999999999, -0.019999999999999993`}, {-0.19999999999999993`, 
    0.03999999999999997, -0.007999999999999991}, {-0.09999999999999992, 
    0.009999999999999985, -0.0009999999999999976}, {-0.19999999999999996`, 
    0.029999999999999985`, -0.0039999999999999975`}}], 
   Polygon3DBox[{{-0.19999999999999993`, 
    0.03999999999999997, -0.007999999999999991}, {-0.09999999999999995, \
-1.3877787807814457`*^-17, 0.004000000000000005}, {
    5.551115123125783*^-17, -0.010000000000000009`, 
    0.002}, {-0.09999999999999992, 
    0.009999999999999985, -0.0009999999999999976}}], 
   Polygon3DBox[{{-0.09999999999999995, -1.3877787807814457`*^-17, 
    0.004000000000000005}, {2.7755575615628914`*^-17, -0.04000000000000001, 
    0.015999999999999993`}, {0.10000000000000003`, -0.03, 
    0.004999999999999998}, {5.551115123125783*^-17, -0.010000000000000009`, 
    0.002}}], 
   Polygon3DBox[{{2.7755575615628914`*^-17, -0.04000000000000001, 
    0.015999999999999993`}, {0.10000000000000012`, -0.08000000000000003, 
    0.028000000000000004`}, {0.20000000000000012`, -0.05000000000000001, 
    0.008}, {0.10000000000000003`, -0.03, 0.004999999999999998}}], 
   Polygon3DBox[{{0.10000000000000012`, -0.08000000000000003, 
    0.028000000000000004`}, {0.2000000000000001, -0.12000000000000004`, 
    0.04}, {0.3000000000000001, -0.07, 0.010999999999999996`}, {
    0.20000000000000012`, -0.05000000000000001, 0.008}}], 
   Polygon3DBox[{{-0.39999999999999997`, 
    0.06999999999999998, -0.009999999999999993}, {-0.29999999999999993`, 
    0.04999999999999998, -0.006999999999999996}, {-0.19999999999999993`, \
-2.2204460492503126`*^-17, -1.848892746611746*^-33}, {-0.29999999999999993`, \
-3.330669073875469*^-17, -2.7733391199176194`*^-33}}], 
   Polygon3DBox[{{-0.29999999999999993`, 
    0.04999999999999998, -0.006999999999999996}, {-0.19999999999999996`, 
    0.029999999999999985`, -0.0039999999999999975`}, {-0.09999999999999992, \
-1.110223024625156*^-17, -9.244463733058728*^-34}, {-0.19999999999999993`, \
-2.2204460492503126`*^-17, -1.848892746611746*^-33}}], 
   Polygon3DBox[{{-0.19999999999999996`, 
    0.029999999999999985`, -0.0039999999999999975`}, {-0.09999999999999992, 
    0.009999999999999985, -0.0009999999999999976}, {1.1102230246251565`*^-16, 
    9.244463733058732*^-33, 
    6.842277657836021*^-49}, {-0.09999999999999992, -1.110223024625156*^-17, \
-9.244463733058728*^-34}}], 
   Polygon3DBox[{{-0.09999999999999992, 
    0.009999999999999985, -0.0009999999999999976}, {
    5.551115123125783*^-17, -0.010000000000000009`, 0.002}, {
    0.10000000000000009`, 1.1102230246251572`*^-17, 9.244463733058737*^-34}, {
    1.1102230246251565`*^-16, 9.244463733058732*^-33, 
    6.842277657836021*^-49}}], 
   Polygon3DBox[{{5.551115123125783*^-17, -0.010000000000000009`, 0.002}, {
    0.10000000000000003`, -0.03, 0.004999999999999998}, {0.20000000000000007`,
     2.2204460492503135`*^-17, 1.8488927466117467`*^-33}, {
    0.10000000000000009`, 1.1102230246251572`*^-17, 9.244463733058737*^-34}}],
    Polygon3DBox[{{0.10000000000000003`, -0.03, 0.004999999999999998}, {
    0.20000000000000012`, -0.05000000000000001, 0.008}, {0.30000000000000016`,
     3.3306690738754713`*^-17, 2.7733391199176207`*^-33}, {
    0.20000000000000007`, 2.2204460492503135`*^-17, 
    1.8488927466117467`*^-33}}], 
   Polygon3DBox[{{0.20000000000000012`, -0.05000000000000001, 0.008}, {
    0.3000000000000001, -0.07, 0.010999999999999996`}, {0.40000000000000013`, 
    4.4408920985006276`*^-17, 3.6977854932234934`*^-33}, {
    0.30000000000000016`, 3.3306690738754713`*^-17, 
    2.7733391199176207`*^-33}}], 
   Polygon3DBox[{{-0.29999999999999993`, -3.330669073875469*^-17, \
-2.7733391199176194`*^-33}, {-0.19999999999999993`, \
-2.2204460492503126`*^-17, -1.848892746611746*^-33}, {-0.09999999999999995, \
-0.03, -0.005000000000000003}, {-0.19999999999999996`, -0.05000000000000001, \
-0.008000000000000005}}], 
   Polygon3DBox[{{-0.19999999999999993`, -2.2204460492503126`*^-17, \
-1.848892746611746*^-33}, {-0.09999999999999992, -1.110223024625156*^-17, \
-9.244463733058728*^-34}, {
    5.551115123125783*^-17, -0.009999999999999997, -0.002}, \
{-0.09999999999999995, -0.03, -0.005000000000000003}}], 
   Polygon3DBox[{{-0.09999999999999992, -1.110223024625156*^-17, \
-9.244463733058728*^-34}, {1.1102230246251565`*^-16, 9.244463733058732*^-33, 
    6.842277657836021*^-49}, {0.10000000000000009`, 0.010000000000000018`, 
    0.0010000000000000028`}, {
    5.551115123125783*^-17, -0.009999999999999997, -0.002}}], 
   Polygon3DBox[{{1.1102230246251565`*^-16, 9.244463733058732*^-33, 
    6.842277657836021*^-49}, {0.10000000000000009`, 1.1102230246251572`*^-17, 
    9.244463733058737*^-34}, {0.20000000000000007`, 0.03000000000000002, 
    0.004000000000000004}, {0.10000000000000009`, 0.010000000000000018`, 
    0.0010000000000000028`}}], 
   Polygon3DBox[{{0.10000000000000009`, 1.1102230246251572`*^-17, 
    9.244463733058737*^-34}, {0.20000000000000007`, 2.2204460492503135`*^-17, 
    1.8488927466117467`*^-33}, {0.30000000000000004`, 0.050000000000000024`, 
    0.0070000000000000045`}, {0.20000000000000007`, 0.03000000000000002, 
    0.004000000000000004}}], 
   Polygon3DBox[{{0.20000000000000007`, 2.2204460492503135`*^-17, 
    1.8488927466117467`*^-33}, {0.30000000000000016`, 
    3.3306690738754713`*^-17, 2.7733391199176207`*^-33}, {
    0.40000000000000013`, 0.07000000000000005, 0.01000000000000001}, {
    0.30000000000000004`, 0.050000000000000024`, 0.0070000000000000045`}}], 
   Polygon3DBox[{{0.30000000000000016`, 3.3306690738754713`*^-17, 
    2.7733391199176207`*^-33}, {0.40000000000000013`, 
    4.4408920985006276`*^-17, 3.6977854932234934`*^-33}, {0.5000000000000001, 
    0.09000000000000005, 0.013000000000000012`}, {0.40000000000000013`, 
    0.07000000000000005, 0.01000000000000001}}], 
   Polygon3DBox[{{-0.19999999999999996`, -0.05000000000000001, \
-0.008000000000000005}, {-0.09999999999999995, -0.03, -0.005000000000000003}, \
{2.7755575615628914`*^-17, -0.039999999999999994`, -0.016}, \
{-0.09999999999999998, -0.07999999999999999, -0.028000000000000004`}}], 
   Polygon3DBox[{{-0.09999999999999995, -0.03, -0.005000000000000003}, {
    5.551115123125783*^-17, -0.009999999999999997, -0.002}, {
    0.10000000000000003`, 1.3877787807814457`*^-17, -0.003999999999999998}, {
    2.7755575615628914`*^-17, -0.039999999999999994`, -0.016}}], 
   Polygon3DBox[{{5.551115123125783*^-17, -0.009999999999999997, -0.002}, {
    0.10000000000000009`, 0.010000000000000018`, 0.0010000000000000028`}, {
    0.20000000000000007`, 0.04000000000000003, 0.008000000000000009}, {
    0.10000000000000003`, 1.3877787807814457`*^-17, -0.003999999999999998}}], 
   Polygon3DBox[{{0.10000000000000009`, 0.010000000000000018`, 
    0.0010000000000000028`}, {0.20000000000000007`, 0.03000000000000002, 
    0.004000000000000004}, {0.30000000000000004`, 0.08000000000000002, 
    0.020000000000000007`}, {0.20000000000000007`, 0.04000000000000003, 
    0.008000000000000009}}], 
   Polygon3DBox[{{0.20000000000000007`, 0.03000000000000002, 
    0.004000000000000004}, {0.30000000000000004`, 0.050000000000000024`, 
    0.0070000000000000045`}, {0.4, 0.12000000000000002`, 
    0.03200000000000001}, {0.30000000000000004`, 0.08000000000000002, 
    0.020000000000000007`}}], 
   Polygon3DBox[{{0.30000000000000004`, 0.050000000000000024`, 
    0.0070000000000000045`}, {0.40000000000000013`, 0.07000000000000005, 
    0.01000000000000001}, {0.5000000000000001, 0.16000000000000006`, 
    0.04400000000000002}, {0.4, 0.12000000000000002`, 0.03200000000000001}}], 
   Polygon3DBox[{{0.40000000000000013`, 0.07000000000000005, 
    0.01000000000000001}, {0.5000000000000001, 0.09000000000000005, 
    0.013000000000000012`}, {0.6000000000000001, 0.20000000000000004`, 
    0.05600000000000002}, {0.5000000000000001, 0.16000000000000006`, 
    0.04400000000000002}}]},
  Boxed->False,
  Lighting->{
    GrayLevel[0]},
  ViewPoint->{2, 0, 3}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Und hier dasselbe Bild mit ",
 StyleBox["ParametricPlot3D",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "u"}], ",", 
     RowBox[{
      SuperscriptBox["t", "2"], "+", 
      RowBox[{"2", "t", " ", "u"}]}], ",", 
     RowBox[{
      SuperscriptBox["t", "3"], "+", 
      RowBox[{"3", 
       SuperscriptBox["t", "2"], "u"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", ".3"}], ",", ".2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", ".3"}], ",", ".4"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "3"}], ",", 
   RowBox[{"Mesh", "->", "All"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "->", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJw1lH8w1Gkcx5dKclcnZ7qycRmSJl3rx5Cozw7O5hxFV9eWrtrYxbXrR9TZ
mBTVpI1Lan2drq21RbQJ2xLuQ62K3dmS7cdYZDu5s6si1ZUO5/p+PTPPP898
5v1+P6/P83wcOQmRMeY0Gg0m97TJ/brjy2F3zz9xn/fToXJWO6hctm3ukdXj
kKP4ZTT3EQZJxN0PpRLQTijN6lN24csEu0ExUYf54xe+6hHW4Prr2s1mFcVo
/Mzxr7GJe9jAvlMXVisHjeXdkG7ZcaRR6xdbOcsgjMb3ZcMPwjgMGCDr4QZV
H+v0j4t5hQiGSH2wbuqc7u55C085m2bwGmpgmMwDOs4JCw9PKX4fn7I3/AQP
Rsj8sMRN8fdpohW6B5+hWUUFkPfqwOXJe5b4WVXD2XeM0TQ4SeUvQ8HXJcIA
Qw4u1oY/7ZRtRdK3DGKP1f+qk5aiku6/0zkqj9LvAC1HF/XatQTmNOsjy1hJ
YIzeHhvN7cF7FvJXLlHNwPfXzFykl1DcbuOHDN/8dbW5kNvGZiXFRlB8EPsV
m9IDDTmwSPQNkT4vBF/M64p399Sj3HF+qcKhBXqWnDErsruKg41nB9o0GmQ0
8hZO+uJD/rJGC/M9SN6rGnTBY8YuYTZ6h1zMoVWkI8kToY/Sn0m39o5p+IHi
dhsWBlnSe4UFKDr3gFFIsOEFqQ8uO4JpYxP1OPuuudNuGwnFrRoDOtrd/Kwu
odCpKqqcdR6onBB68FS5TtoEXVvuOx80nQcTyQFsRCEvWjWVwN7vudl3Rwal
cwtLmmCGmDgNsYdK+0c28KbeDzxz6FOLiYPAHDpeqf+wZqrv6NXHnJ+4+hD+
Nr/FPsQne0oHVO/jiMJEPuRVrYzlxs4Fkk8XKnLmFeicVLAt9ECA3bdlOCx8
mKDW6NBl4WwffCuH4q3TP0oSsyjfVrQtfffkqkMq6mSC3iPEgimeeLl0aTB/
dQketXQddYrKwsFP9QSYK4t2ra/Nx+K4JodiuwQg+3sdLluMB/pbHUVLqzzZ
sqowKn8r/Che1U8/fAXjN1rNCuUchjdUvzIVFwrZeUo05saJ1vqUTOUHptc5
D4vHN0AtFgR33isAQXGdm1rzBPuRlxVkuAENyr7p3UKCyk9gm9zCPZcIQVH/
z0NMztAfb9wikwuJdkxKz88fm6gC7xlzPrJ8CpD0leIrvexalukkvvEoEze0
ZUDNK+aGGG4vhrNMKovHathiX1BxmlBQ3FQoyNyWVM6qRJH/eIz9kRNI6jfj
5y3W9QGGIvzJcSIlwxRHcZNOjhEmbymdsUaoGS15JFtG1bcDvZbu5mt1BUR3
GIrm0MPwmuwLrOO1rHgekQk7VwQfkac4UecqGKfVXhMvaMbQ6ufyaZpyeEv6
At8msmTEtQZHtRF+qQNiUJD5oW6T83f//5cuKTu5OfQSCAL3l0dzO6FHL6xR
abKBb7d1xaDOFRJInpDWWE0PNFwGr9+PbhzesA+8bp238fA04AgjIw1TW+Gp
MqPKuLsSU9jDVWrNfbw5sfjmQEQh2D6Plo24RlHz4RjyL5krfCf/RbhzQ2Pm
JNcUWrV7DPcBSIpW9rZpqtGUrJxlzxABLfFTPRi8vriPb2txvXdQjf+OK1O+
4Da0J3PsQBNor7H/fdRHTL0r1L8PY4qJNFjUtEpWf24VNR/UaFw7fmYX9yKM
x4/2LLc8hIPkObCsjX6BhiLQ3tkuubmXC6lkfniWPdf2QuJZnNUtYM1ezoH/
AG/iHXw=
   "], {
    {EdgeForm[GrayLevel[0.]], 
     GraphicsGroup3DBox[
      Polygon3DBox[{{31, 15, 10}, {41, 17, 10}, {33, 19, 11}, {34, 21, 12}, {
       47, 24, 13}, {40, 15, 11}, {61, 26, 16}, {37, 23, 12}, {48, 21, 13}, {
       39, 30, 14}, {44, 33, 18}, {45, 32, 18}, {42, 28, 16}, {50, 36, 22}, {
       62, 29, 20}, {53, 38, 25}, {46, 27, 20}, {60, 26, 15}, {55, 32, 15}, {
       41, 16, 4}, {34, 16, 5}, {43, 30, 17}, {36, 63, 8}, {27, 19, 6}, {47, 
       20, 6}, {28, 23, 4}, {63, 36, 21}, {35, 29, 21}, {49, 37, 22}, {51, 38,
        24}, {19, 27, 11}, {52, 48, 25}, {15, 26, 10}, {16, 26, 5}, {20, 27, 
       6}, {16, 28, 4}, {23, 28, 12}, {21, 29, 13}, {54, 30, 1}, {17, 30, 
       10}, {20, 29, 5}, {55, 31, 2}, {18, 32, 2}, {15, 32, 11}, {56, 33, 
       3}, {39, 31, 10}, {31, 14, 2}, {45, 33, 11}, {35, 34, 5}, {42, 34, 
       12}, {60, 40, 5}, {29, 35, 5}, {21, 36, 12}, {57, 36, 8}, {58, 37, 
       7}, {50, 37, 12}, {24, 38, 13}, {59, 38, 9}, {30, 39, 10}, {31, 39, 
       14}, {46, 40, 11}, {40, 46, 20}, {61, 41, 10}, {28, 42, 12}, {34, 42, 
       16}, {17, 41, 4}, {30, 43, 1}, {32, 45, 11}, {33, 45, 18}, {27, 46, 
       11}, {33, 44, 3}, {24, 47, 6}, {40, 20, 5}, {62, 47, 13}, {26, 60, 
       5}, {38, 51, 9}, {37, 50, 22}, {53, 48, 13}, {37, 49, 7}, {48, 52, 
       8}, {48, 53, 25}, {30, 54, 14}, {34, 35, 21}, {38, 53, 13}, {36, 50, 
       12}, {31, 55, 15}, {32, 55, 2}, {36, 57, 22}, {37, 58, 23}, {38, 59, 
       25}, {40, 60, 15}, {41, 61, 16}, {26, 61, 10}, {33, 56, 19}, {29, 62, 
       13}, {47, 62, 20}, {63, 48, 8}, {48, 63, 21}}]]}, {}, {}, {}},
   VertexNormals->CompressedData["
1:eJyVlF1I02EUxv8r1n8hRdGmDkIIipIutjHTZrgHwbopIQatyywQQhIhb+xG
MEjBK2n5QTrnR34U5iI2lC46uBuJzBBCkvV3IqVIH/MmAk1w8J7dvHCgLt67
h995znPOeU/daQrVHzAMA7l3MPdKXReKYp53cPjnZ+17X/H+WGTYDG2iu6mw
2H27FW/tR+PxvykgcW/x9FgWhdudu6Vlb3DfN/Wkv26Nht0Xy15d/Y6zikOm
4tCC4hBziDnEHHIqDjEHzCH2Qw6N0yNwTgic592/GzvmEhiyraRT4xY+xHc9
tVU/ULlkpTzpLlSN3AjvFS1QyZfybycrshhTehpQelpUegooPbEerKcJ5seY
z3o8FnJjPQ1qfD1/7lf06RTyl3xKuUl+pDm6hJwvCXUPzbRcv3J3BP6WgmKr
+RMSTwOZ5Wu/8Ch+OXnk4wtkzj/bOnPrM/XebPBHO39i0mn9GX0wRy/rVsPu
+nXarI6Ga5a2yG74H868DpLXXNmZ9Yyi73jFfHAnS6wH67Gh9LBxXR/XTXLd
w4oDn+IQc9Au+DEUh7yKQ8yhXiFPST8h9MU5ENcF16VJYa9M9u/V/OdzmNZy
GP/PfZNy4PkiqO1hQNjPNu7L4r76uC+HMEcpn7z/qOZf+jdMgS/tp74/XBc8
X5B2vy7h7qS5nxPuSJp7RPg3+F9CVNuHfF/Bf7z3fS15ET0=
    "]],
  Boxed->False,
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{2, 0, 3}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "In einer Realisierung als ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Objekt m\[UDoubleDot]ssen nur die Punkte transformiert werden. \nSie \
brauchen weiter die Funktion ",
 StyleBox["GitterComplex",
  FontWeight->"Bold"],
 " aus dem letzten Abschnitt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterComplexPlot", "[", 
   RowBox[{
   "f_", ",", "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", 
    "ny_Integer"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gc", "=", 
      RowBox[{"GitterComplex", "[", 
       RowBox[{"P0", ",", "dx", ",", "dy", ",", "nx", ",", "ny"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{
      RowBox[{"f", "/@", 
       RowBox[{"gc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
       ",", 
      RowBox[{"gc", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
     "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"GitterComplexPlot", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".3"}], ",", 
       RowBox[{"-", ".3"}]}], "}"}], ",", ".1", ",", ".1", ",", "5", ",", 
     "7"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Glow", "[", "Yellow", "]"}], ",", "g3"}], "}"}], ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "Black", "}"}]}], ",", 
   RowBox[{"Boxed", "->", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {Glow[
    RGBColor[1, 1, 0]], 
   GraphicsComplex3DBox[{{-0.6, 0.27, -0.108}, {-0.5, 
     0.20999999999999996`, -0.08099999999999999}, {-0.39999999999999997`, 
     0.14999999999999997`, -0.05399999999999999}, {-0.3, 
     0.09, -0.026999999999999996`}, {-0.19999999999999996`, 
     0.029999999999999978`, 
     1.3877787807814457`*^-17}, {-0.09999999999999998, -0.03, 
     0.026999999999999996`}, {1.1102230246251565`*^-16, -0.09000000000000005, 
     0.05400000000000002}, {0.10000000000000009`, -0.15000000000000005`, 
     0.08100000000000002}, {-0.5, 
     0.15999999999999998`, -0.044}, {-0.39999999999999997`, 
     0.11999999999999998`, -0.031999999999999994`}, {-0.29999999999999993`, 
     0.07999999999999999, -0.019999999999999993`}, {-0.19999999999999998`, 
     0.039999999999999994`, -0.007999999999999998}, {-0.09999999999999995, \
-1.3877787807814457`*^-17, 0.004000000000000005}, {
     2.7755575615628914`*^-17, -0.04000000000000001, 0.015999999999999993`}, {
     0.10000000000000012`, -0.08000000000000003, 0.028000000000000004`}, {
     0.2000000000000001, -0.12000000000000004`, 0.04}, {-0.39999999999999997`,
      0.06999999999999998, -0.009999999999999993}, {-0.29999999999999993`, 
     0.04999999999999998, -0.006999999999999996}, {-0.19999999999999996`, 
     0.029999999999999985`, -0.0039999999999999975`}, {-0.09999999999999998, 
     0.009999999999999995, -0.0009999999999999994}, {
     5.551115123125783*^-17, -0.010000000000000009`, 0.002}, {
     0.10000000000000003`, -0.03, 0.004999999999999998}, {
     0.20000000000000012`, -0.05000000000000001, 0.008}, {
     0.3000000000000001, -0.07, 
     0.010999999999999996`}, {-0.3, 0, 0}, {-0.19999999999999998`, 0, 
      0}, {-0.09999999999999998, 0, 0}, {0, 0, 0}, {
     0.10000000000000003`, 0, 0}, {0.2, 0, 0}, {0.3000000000000001, 0, 0}, {
     0.4000000000000001, 0, 
      0}, {-0.19999999999999996`, -0.05000000000000001, \
-0.008000000000000005}, {-0.09999999999999995, -0.03, -0.005000000000000003}, \
{5.551115123125783*^-17, -0.009999999999999997, -0.002}, {
     0.10000000000000003`, 0.010000000000000007`, 0.001000000000000001}, {
     0.20000000000000007`, 0.03000000000000002, 0.004000000000000004}, {
     0.30000000000000004`, 0.050000000000000024`, 0.0070000000000000045`}, {
     0.40000000000000013`, 0.07000000000000005, 0.01000000000000001}, {
     0.5000000000000001, 0.09000000000000005, 
     0.013000000000000012`}, {-0.09999999999999998, -0.07999999999999999, \
-0.028000000000000004`}, {
     2.7755575615628914`*^-17, -0.039999999999999994`, -0.016}, {
     0.10000000000000003`, 1.3877787807814457`*^-17, -0.003999999999999998}, {
     0.2, 0.04000000000000001, 0.008000000000000002}, {0.30000000000000004`, 
     0.08000000000000002, 0.020000000000000007`}, {0.4, 0.12000000000000002`, 
     0.03200000000000001}, {0.5000000000000001, 0.16000000000000006`, 
     0.04400000000000002}, {0.6000000000000001, 0.20000000000000004`, 
     0.05600000000000002}}, {Polygon3DBox[{1, 2, 10, 9}], 
     Polygon3DBox[{2, 3, 11, 10}], Polygon3DBox[{3, 4, 12, 11}], 
     Polygon3DBox[{4, 5, 13, 12}], Polygon3DBox[{5, 6, 14, 13}], 
     Polygon3DBox[{6, 7, 15, 14}], Polygon3DBox[{7, 8, 16, 15}], 
     Polygon3DBox[{9, 10, 18, 17}], Polygon3DBox[{10, 11, 19, 18}], 
     Polygon3DBox[{11, 12, 20, 19}], Polygon3DBox[{12, 13, 21, 20}], 
     Polygon3DBox[{13, 14, 22, 21}], Polygon3DBox[{14, 15, 23, 22}], 
     Polygon3DBox[{15, 16, 24, 23}], Polygon3DBox[{17, 18, 26, 25}], 
     Polygon3DBox[{18, 19, 27, 26}], Polygon3DBox[{19, 20, 28, 27}], 
     Polygon3DBox[{20, 21, 29, 28}], Polygon3DBox[{21, 22, 30, 29}], 
     Polygon3DBox[{22, 23, 31, 30}], Polygon3DBox[{23, 24, 32, 31}], 
     Polygon3DBox[{25, 26, 34, 33}], Polygon3DBox[{26, 27, 35, 34}], 
     Polygon3DBox[{27, 28, 36, 35}], Polygon3DBox[{28, 29, 37, 36}], 
     Polygon3DBox[{29, 30, 38, 37}], Polygon3DBox[{30, 31, 39, 38}], 
     Polygon3DBox[{31, 32, 40, 39}], Polygon3DBox[{33, 34, 42, 41}], 
     Polygon3DBox[{34, 35, 43, 42}], Polygon3DBox[{35, 36, 44, 43}], 
     Polygon3DBox[{36, 37, 45, 44}], Polygon3DBox[{37, 38, 46, 45}], 
     Polygon3DBox[{38, 39, 47, 46}], Polygon3DBox[{39, 40, 48, 47}]}]},
  Boxed->False,
  Lighting->{
    GrayLevel[0]},
  ViewPoint->{2, 0, 3}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ein Torus", "Subsection"],

Cell["Ein  Torus als GitterPlot. ", "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"tf", ",", "s", ",", "d"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tf", "[", 
   RowBox[{"{", 
    RowBox[{"u_", ",", "t_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"b", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"r", "+", 
     RowBox[{"s", " ", "r", "*", 
      RowBox[{"Sin", "[", "u", "]"}]}], "+", 
     RowBox[{"s", " ", "b", "*", 
      RowBox[{"Cos", "[", "u", "]"}]}]}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "20"}], ";", 
  RowBox[{"s", "=", ".3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g4", "=", 
   RowBox[{"GitterPlot", "[", 
    RowBox[{"tf", ",", 
     RowBox[{"GitterPunkte", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "d"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "d"}]}], ",", "d", ",", "d"}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{"g4", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[
    NCache[{{1, 0, 0.3}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.3}, {
      1.0392243041390246`, 0.33766444521870537`, 0.285316954888546}, {
      1.0927050983124842`, 0, 0.285316954888546}}, {{1, 0, 0.3}, {
      0.9510565162951535, 0.30901699437494745`, 0.3}, {1.0392243041390246`, 
      0.33766444521870537`, 0.285316954888546}, {
      1.0927050983124842`, 0, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {
      0.8840169943749474, 0.6422759418928752, 0.285316954888546}, {
      1.0392243041390246`, 0.33766444521870537`, 0.285316954888546}}, {{
     0.9510565162951535, 0.30901699437494745`, 0.3}, {0.8090169943749475, 
     0.5877852522924731, 0.3}, {0.8840169943749474, 0.6422759418928752, 
     0.285316954888546}, {1.0392243041390246`, 0.33766444521870537`, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0.3}, {
      0.6422759418928752, 0.8840169943749474, 0.285316954888546}, {
      0.8840169943749474, 0.6422759418928752, 0.285316954888546}}, {{
     0.8090169943749475, 0.5877852522924731, 0.3}, {0.5877852522924731, 
     0.8090169943749475, 0.3}, {0.6422759418928752, 0.8840169943749474, 
     0.285316954888546}, {0.8840169943749474, 0.6422759418928752, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {
      0.33766444521870537`, 1.0392243041390246`, 0.285316954888546}, {
      0.6422759418928752, 0.8840169943749474, 0.285316954888546}}, {{
     0.5877852522924731, 0.8090169943749475, 0.3}, {0.30901699437494745`, 
     0.9510565162951535, 0.3}, {0.33766444521870537`, 1.0392243041390246`, 
     0.285316954888546}, {0.6422759418928752, 0.8840169943749474, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {0, 1, 0.3}, {
      0, 1.0927050983124842`, 0.285316954888546}, {0.33766444521870537`, 
      1.0392243041390246`, 0.285316954888546}}, {{0.30901699437494745`, 
      0.9510565162951535, 0.3}, {0, 1, 0.3}, {
      0, 1.0927050983124842`, 0.285316954888546}, {0.33766444521870537`, 
      1.0392243041390246`, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{0, 1, 0.3}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {-0.33766444521870537`, 1.0392243041390246`, 
      0.285316954888546}, {0, 1.0927050983124842`, 0.285316954888546}}, {{
      0, 1, 0.3}, {-0.30901699437494745`, 0.9510565162951535, 
      0.3}, {-0.33766444521870537`, 1.0392243041390246`, 0.285316954888546}, {
      0, 1.0927050983124842`, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
       0.3}, {-0.6422759418928752, 0.8840169943749474, 
      0.285316954888546}, {-0.33766444521870537`, 1.0392243041390246`, 
      0.285316954888546}}, {{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.5877852522924731, 0.8090169943749475, 
     0.3}, {-0.6422759418928752, 0.8840169943749474, 
     0.285316954888546}, {-0.33766444521870537`, 1.0392243041390246`, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {-0.8840169943749474, 0.6422759418928752, 
      0.285316954888546}, {-0.6422759418928752, 0.8840169943749474, 
      0.285316954888546}}, {{-0.5877852522924731, 0.8090169943749475, 
     0.3}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8840169943749474, 0.6422759418928752, 
     0.285316954888546}, {-0.6422759418928752, 0.8840169943749474, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 
       0.3}, {-1.0392243041390246`, 0.33766444521870537`, 
      0.285316954888546}, {-0.8840169943749474, 0.6422759418928752, 
      0.285316954888546}}, {{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.9510565162951535, 0.30901699437494745`, 
     0.3}, {-1.0392243041390246`, 0.33766444521870537`, 
     0.285316954888546}, {-0.8840169943749474, 0.6422759418928752, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.3}, {-1, 0, 
       0.3}, {-1.0927050983124842`, 0, 
       0.285316954888546}, {-1.0392243041390246`, 0.33766444521870537`, 
      0.285316954888546}}, {{-0.9510565162951535, 0.30901699437494745`, 
      0.3}, {-1, 0, 0.3}, {-1.0927050983124842`, 0, 
       0.285316954888546}, {-1.0392243041390246`, 0.33766444521870537`, 
      0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-1, 0, 
       0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 
       0.3}, {-1.0392243041390246`, -0.33766444521870537`, 
      0.285316954888546}, {-1.0927050983124842`, 0, 0.285316954888546}}, {{-1,
        0, 0.3}, {-0.9510565162951535, -0.30901699437494745`, 
      0.3}, {-1.0392243041390246`, -0.33766444521870537`, 
      0.285316954888546}, {-1.0927050983124842`, 0, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0.3}, {-0.8840169943749474, -0.6422759418928752, 
      0.285316954888546}, {-1.0392243041390246`, -0.33766444521870537`, 
      0.285316954888546}}, {{-0.9510565162951535, -0.30901699437494745`, 
     0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8840169943749474, -0.6422759418928752, 
     0.285316954888546}, {-1.0392243041390246`, -0.33766444521870537`, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       0.3}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
       0.3}, {-0.6422759418928752, -0.8840169943749474, 
      0.285316954888546}, {-0.8840169943749474, -0.6422759418928752, 
      0.285316954888546}}, {{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.5877852522924731, -0.8090169943749475, 
     0.3}, {-0.6422759418928752, -0.8840169943749474, 
     0.285316954888546}, {-0.8840169943749474, -0.6422759418928752, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0.3}, {-0.33766444521870537`, -1.0392243041390246`, 
      0.285316954888546}, {-0.6422759418928752, -0.8840169943749474, 
      0.285316954888546}}, {{-0.5877852522924731, -0.8090169943749475, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.33766444521870537`, -1.0392243041390246`, 
     0.285316954888546}, {-0.6422759418928752, -0.8840169943749474, 
     0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0.3}, {0, -1, 0.3}, {
      0, -1.0927050983124842`, 
       0.285316954888546}, {-0.33766444521870537`, -1.0392243041390246`, 
      0.285316954888546}}, {{-0.30901699437494745`, -0.9510565162951535, 
      0.3}, {0, -1, 0.3}, {
      0, -1.0927050983124842`, 
       0.285316954888546}, {-0.33766444521870537`, -1.0392243041390246`, 
      0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{0, -1, 0.3}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {
      0.33766444521870537`, -1.0392243041390246`, 0.285316954888546}, {
      0, -1.0927050983124842`, 0.285316954888546}}, {{0, -1, 0.3}, {
      0.30901699437494745`, -0.9510565162951535, 0.3}, {
      0.33766444521870537`, -1.0392243041390246`, 0.285316954888546}, {
      0, -1.0927050983124842`, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.3}, {
      0.6422759418928752, -0.8840169943749474, 0.285316954888546}, {
      0.33766444521870537`, -1.0392243041390246`, 0.285316954888546}}, {{
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.5877852522924731, -0.8090169943749475, 0.3}, {
     0.6422759418928752, -0.8840169943749474, 0.285316954888546}, {
     0.33766444521870537`, -1.0392243041390246`, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {
      0.8840169943749474, -0.6422759418928752, 0.285316954888546}, {
      0.6422759418928752, -0.8840169943749474, 0.285316954888546}}, {{
     0.5877852522924731, -0.8090169943749475, 0.3}, {
     0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.8840169943749474, -0.6422759418928752, 0.285316954888546}, {
     0.6422759418928752, -0.8840169943749474, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0.3}, {
      1.0392243041390246`, -0.33766444521870537`, 0.285316954888546}, {
      0.8840169943749474, -0.6422759418928752, 0.285316954888546}}, {{
     0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.9510565162951535, -0.30901699437494745`, 0.3}, {
     1.0392243041390246`, -0.33766444521870537`, 0.285316954888546}, {
     0.8840169943749474, -0.6422759418928752, 0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0.3}, {
      1, 0, 0.3}, {1.0927050983124842`, 0, 0.285316954888546}, {
      1.0392243041390246`, -0.33766444521870537`, 0.285316954888546}}, {{
      0.9510565162951535, -0.30901699437494745`, 0.3}, {1, 0, 0.3}, {
      1.0927050983124842`, 0, 0.285316954888546}, {
      1.0392243041390246`, -0.33766444521870537`, 0.285316954888546}}]], 
   Polygon3DBox[{{1.0927050983124842`, 0, 0.285316954888546}, {
     1.0392243041390246`, 0.33766444521870537`, 0.285316954888546}, {
     1.1187616146076378`, 0.3635076839753495, 0.2427050983124842}, {
     1.1763355756877418`, 0, 0.2427050983124842}}], 
   Polygon3DBox[{{1.0392243041390246`, 0.33766444521870537`, 
    0.285316954888546}, {0.8840169943749474, 0.6422759418928752, 
    0.285316954888546}, {0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {1.1187616146076378`, 0.3635076839753495, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.8840169943749474, 0.6422759418928752, 
    0.285316954888546}, {0.6422759418928752, 0.8840169943749474, 
    0.285316954888546}, {0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.6422759418928752, 0.8840169943749474, 
    0.285316954888546}, {0.33766444521870537`, 1.0392243041390246`, 
    0.285316954888546}, {0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.33766444521870537`, 1.0392243041390246`, 
     0.285316954888546}, {0, 1.0927050983124842`, 0.285316954888546}, {
     0, 1.1763355756877418`, 0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, 0.2427050983124842}}], 
   Polygon3DBox[{{
     0, 1.0927050983124842`, 0.285316954888546}, {-0.33766444521870537`, 
     1.0392243041390246`, 0.285316954888546}, {-0.3635076839753495, 
     1.1187616146076378`, 0.2427050983124842}, {
     0, 1.1763355756877418`, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.33766444521870537`, 1.0392243041390246`, 
    0.285316954888546}, {-0.6422759418928752, 0.8840169943749474, 
    0.285316954888546}, {-0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.6422759418928752, 0.8840169943749474, 
    0.285316954888546}, {-0.8840169943749474, 0.6422759418928752, 
    0.285316954888546}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.8840169943749474, 0.6422759418928752, 
    0.285316954888546}, {-1.0392243041390246`, 0.33766444521870537`, 
    0.285316954888546}, {-1.1187616146076378`, 0.3635076839753495, 
    0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-1.0392243041390246`, 0.33766444521870537`, 
     0.285316954888546}, {-1.0927050983124842`, 0, 
      0.285316954888546}, {-1.1763355756877418`, 0, 
      0.2427050983124842}, {-1.1187616146076378`, 0.3635076839753495, 
     0.2427050983124842}}], 
   Polygon3DBox[{{-1.0927050983124842`, 0, 
      0.285316954888546}, {-1.0392243041390246`, -0.33766444521870537`, 
     0.285316954888546}, {-1.1187616146076378`, -0.3635076839753495, 
     0.2427050983124842}, {-1.1763355756877418`, 0, 0.2427050983124842}}], 
   Polygon3DBox[{{-1.0392243041390246`, -0.33766444521870537`, 
    0.285316954888546}, {-0.8840169943749474, -0.6422759418928752, 
    0.285316954888546}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-1.1187616146076378`, -0.3635076839753495, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.8840169943749474, -0.6422759418928752, 
    0.285316954888546}, {-0.6422759418928752, -0.8840169943749474, 
    0.285316954888546}, {-0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.6422759418928752, -0.8840169943749474, 
    0.285316954888546}, {-0.33766444521870537`, -1.0392243041390246`, 
    0.285316954888546}, {-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {-0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.33766444521870537`, -1.0392243041390246`, 
     0.285316954888546}, {0, -1.0927050983124842`, 0.285316954888546}, {
     0, -1.1763355756877418`, 
      0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}}], 
   Polygon3DBox[{{0, -1.0927050983124842`, 0.285316954888546}, {
     0.33766444521870537`, -1.0392243041390246`, 0.285316954888546}, {
     0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
     0, -1.1763355756877418`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.33766444521870537`, -1.0392243041390246`, 
    0.285316954888546}, {0.6422759418928752, -0.8840169943749474, 
    0.285316954888546}, {0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.6422759418928752, -0.8840169943749474, 
    0.285316954888546}, {0.8840169943749474, -0.6422759418928752, 
    0.285316954888546}, {0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.8840169943749474, -0.6422759418928752, 
    0.285316954888546}, {1.0392243041390246`, -0.33766444521870537`, 
    0.285316954888546}, {1.1187616146076378`, -0.3635076839753495, 
    0.2427050983124842}, {0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{1.0392243041390246`, -0.33766444521870537`, 
     0.285316954888546}, {1.0927050983124842`, 0, 0.285316954888546}, {
     1.1763355756877418`, 0, 0.2427050983124842}, {
     1.1187616146076378`, -0.3635076839753495, 0.2427050983124842}}], 
   Polygon3DBox[{{1.1763355756877418`, 0, 0.2427050983124842}, {
     1.1187616146076378`, 0.3635076839753495, 0.2427050983124842}, {
     1.1818827815832975`, 0.38401699437494746`, 0.17633557568774194`}, {
     1.2427050983124843`, 0, 0.17633557568774194`}}], 
   Polygon3DBox[{{1.1187616146076378`, 0.3635076839753495, 
    0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}, {1.1818827815832975`, 0.38401699437494746`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}, {0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}, {1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {0.38401699437494746`, 1.1818827815832975`, 
    0.17633557568774194`}, {0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0, 1.1763355756877418`, 0.2427050983124842}, {
     0, 1.2427050983124843`, 0.17633557568774194`}, {0.38401699437494746`, 
     1.1818827815832975`, 0.17633557568774194`}}], 
   Polygon3DBox[{{
     0, 1.1763355756877418`, 0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, 0.2427050983124842}, {-0.38401699437494746`, 
     1.1818827815832975`, 0.17633557568774194`}, {
     0, 1.2427050983124843`, 0.17633557568774194`}}], 
   Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}, {-0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}, {-0.38401699437494746`, 1.1818827815832975`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.6914327031362311, 0.9516754718192205, 
    0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}, {-0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.1187616146076378`, 0.3635076839753495, 
    0.2427050983124842}, {-1.1818827815832975`, 0.38401699437494746`, 
    0.17633557568774194`}, {-1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-1.1187616146076378`, 0.3635076839753495, 
     0.2427050983124842}, {-1.1763355756877418`, 0, 
      0.2427050983124842}, {-1.2427050983124843`, 0, 
      0.17633557568774194`}, {-1.1818827815832975`, 0.38401699437494746`, 
     0.17633557568774194`}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0, 
      0.2427050983124842}, {-1.1187616146076378`, -0.3635076839753495, 
     0.2427050983124842}, {-1.1818827815832975`, -0.38401699437494746`, 
     0.17633557568774194`}, {-1.2427050983124843`, 0, 0.17633557568774194`}}],
    Polygon3DBox[{{-1.1187616146076378`, -0.3635076839753495, 
    0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}, {-1.1818827815832975`, -0.38401699437494746`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}, {-0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}, {-1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {-0.38401699437494746`, -1.1818827815832975`, 
    0.17633557568774194`}, {-0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0, -1.1763355756877418`, 0.2427050983124842}, {
     0, -1.2427050983124843`, 
      0.17633557568774194`}, {-0.38401699437494746`, -1.1818827815832975`, 
     0.17633557568774194`}}], 
   Polygon3DBox[{{0, -1.1763355756877418`, 0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
     0.38401699437494746`, -1.1818827815832975`, 0.17633557568774194`}, {
     0, -1.2427050983124843`, 0.17633557568774194`}}], 
   Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}, {0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}, {0.38401699437494746`, -1.1818827815832975`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.6914327031362311, -0.9516754718192205, 
    0.2427050983124842}, {0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}, {0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {1.1187616146076378`, -0.3635076839753495, 
    0.2427050983124842}, {1.1818827815832975`, -0.38401699437494746`, 
    0.17633557568774194`}, {1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{1.1187616146076378`, -0.3635076839753495, 
     0.2427050983124842}, {1.1763355756877418`, 0, 0.2427050983124842}, {
     1.2427050983124843`, 0, 0.17633557568774194`}, {
     1.1818827815832975`, -0.38401699437494746`, 0.17633557568774194`}}], 
   Polygon3DBox[{{1.2427050983124843`, 0, 0.17633557568774194`}, {
     1.1818827815832975`, 0.38401699437494746`, 0.17633557568774194`}, {
     1.2224090654513957`, 0.3971847822188184, 0.09270509831248423}, {
     1.285316954888546, 0, 0.09270509831248423}}], 
   Polygon3DBox[{{1.1818827815832975`, 0.38401699437494746`, 
    0.17633557568774194`}, {1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}, {1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {1.2224090654513957`, 0.3971847822188184, 
    0.09270509831248423}}], 
   Polygon3DBox[{{1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}, {0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}, {0.7554903506049574, 1.0398432596630913`, 
    0.09270509831248423}, {1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}, {0.38401699437494746`, 1.1818827815832975`, 
    0.17633557568774194`}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {0.7554903506049574, 1.0398432596630913`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.38401699437494746`, 1.1818827815832975`, 
     0.17633557568774194`}, {0, 1.2427050983124843`, 0.17633557568774194`}, {
     0, 1.285316954888546, 0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}}], 
   Polygon3DBox[{{
     0, 1.2427050983124843`, 0.17633557568774194`}, {-0.38401699437494746`, 
     1.1818827815832975`, 0.17633557568774194`}, {-0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {
     0, 1.285316954888546, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.38401699437494746`, 1.1818827815832975`, 
    0.17633557568774194`}, {-0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}, {-0.7554903506049574, 1.0398432596630913`, 
    0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.7304437297367462, 1.0053695435311896`, 
    0.17633557568774194`}, {-1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-0.7554903506049574, 1.0398432596630913`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.0053695435311896`, 0.7304437297367462, 
    0.17633557568774194`}, {-1.1818827815832975`, 0.38401699437494746`, 
    0.17633557568774194`}, {-1.2224090654513957`, 0.3971847822188184, 
    0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.1818827815832975`, 0.38401699437494746`, 
     0.17633557568774194`}, {-1.2427050983124843`, 0, 
      0.17633557568774194`}, {-1.285316954888546, 0, 
      0.09270509831248423}, {-1.2224090654513957`, 0.3971847822188184, 
     0.09270509831248423}}], 
   Polygon3DBox[{{-1.2427050983124843`, 0, 
      0.17633557568774194`}, {-1.1818827815832975`, -0.38401699437494746`, 
     0.17633557568774194`}, {-1.2224090654513957`, -0.3971847822188184, 
     0.09270509831248423}, {-1.285316954888546, 0, 0.09270509831248423}}], 
   Polygon3DBox[{{-1.1818827815832975`, -0.38401699437494746`, 
    0.17633557568774194`}, {-1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-1.2224090654513957`, -0.3971847822188184, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}, {-0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}, {-0.7554903506049574, -1.0398432596630913`, 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}, {-0.38401699437494746`, -1.1818827815832975`, 
    0.17633557568774194`}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {-0.7554903506049574, -1.0398432596630913`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.38401699437494746`, -1.1818827815832975`, 
     0.17633557568774194`}, {0, -1.2427050983124843`, 0.17633557568774194`}, {
     0, -1.285316954888546, 
      0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}}], 
   Polygon3DBox[{{0, -1.2427050983124843`, 0.17633557568774194`}, {
     0.38401699437494746`, -1.1818827815832975`, 0.17633557568774194`}, {
     0.3971847822188184, -1.2224090654513957`, 0.09270509831248423}, {
     0, -1.285316954888546, 0.09270509831248423}}], 
   Polygon3DBox[{{0.38401699437494746`, -1.1818827815832975`, 
    0.17633557568774194`}, {0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}, {0.7554903506049574, -1.0398432596630913`, 
    0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.7304437297367462, -1.0053695435311896`, 
    0.17633557568774194`}, {1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {0.7554903506049574, -1.0398432596630913`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{1.0053695435311896`, -0.7304437297367462, 
    0.17633557568774194`}, {1.1818827815832975`, -0.38401699437494746`, 
    0.17633557568774194`}, {1.2224090654513957`, -0.3971847822188184, 
    0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{1.1818827815832975`, -0.38401699437494746`, 
     0.17633557568774194`}, {1.2427050983124843`, 0, 0.17633557568774194`}, {
     1.285316954888546, 0, 0.09270509831248423}, {
     1.2224090654513957`, -0.3971847822188184, 0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0, 0.09270509831248423}, {
     1.2224090654513957`, 0.3971847822188184, 0.09270509831248423}, {
     1.2363734711836996`, 0.4017220926874317, 0}, {1.3, 0, 0}}], 
   Polygon3DBox[{{1.2224090654513957`, 0.3971847822188184, 
     0.09270509831248423}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.0517220926874318`, 0.7641208279802151, 0}, {
     1.2363734711836996`, 0.4017220926874317, 0}}], 
   Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.7554903506049574, 1.0398432596630913`, 
     0.09270509831248423}, {0.7641208279802151, 1.0517220926874318`, 0}, {
     1.0517220926874318`, 0.7641208279802151, 0}}], 
   Polygon3DBox[{{0.7554903506049574, 1.0398432596630913`, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.4017220926874317, 1.2363734711836996`, 0}, {
     0.7641208279802151, 1.0517220926874318`, 0}}], 
   Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0, 1.285316954888546, 0.09270509831248423}, {
     0, 1.3, 0}, {0.4017220926874317, 1.2363734711836996`, 0}}], 
   Polygon3DBox[{{
     0, 1.285316954888546, 0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, 
     0.09270509831248423}, {-0.4017220926874317, 1.2363734711836996`, 0}, {
     0, 1.3, 0}}], 
   Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.7554903506049574, 1.0398432596630913`, 
     0.09270509831248423}, {-0.7641208279802151, 1.0517220926874318`, 
      0}, {-0.4017220926874317, 1.2363734711836996`, 0}}], 
   Polygon3DBox[{{-0.7554903506049574, 1.0398432596630913`, 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0517220926874318`, 0.7641208279802151, 
      0}, {-0.7641208279802151, 1.0517220926874318`, 0}}], 
   Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.2224090654513957`, 0.3971847822188184, 
     0.09270509831248423}, {-1.2363734711836996`, 0.4017220926874317, 
      0}, {-1.0517220926874318`, 0.7641208279802151, 0}}], 
   Polygon3DBox[{{-1.2224090654513957`, 0.3971847822188184, 
     0.09270509831248423}, {-1.285316954888546, 0, 
      0.09270509831248423}, {-1.3, 0, 0}, {-1.2363734711836996`, 
      0.4017220926874317, 0}}], 
   Polygon3DBox[{{-1.285316954888546, 0, 
      0.09270509831248423}, {-1.2224090654513957`, -0.3971847822188184, 
     0.09270509831248423}, {-1.2363734711836996`, -0.4017220926874317, 
      0}, {-1.3, 0, 0}}], 
   Polygon3DBox[{{-1.2224090654513957`, -0.3971847822188184, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0517220926874318`, -0.7641208279802151, 
      0}, {-1.2363734711836996`, -0.4017220926874317, 0}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.7554903506049574, -1.0398432596630913`, 
     0.09270509831248423}, {-0.7641208279802151, -1.0517220926874318`, 
      0}, {-1.0517220926874318`, -0.7641208279802151, 0}}], 
   Polygon3DBox[{{-0.7554903506049574, -1.0398432596630913`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.4017220926874317, -1.2363734711836996`, 
      0}, {-0.7641208279802151, -1.0517220926874318`, 0}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0, -1.285316954888546, 0.09270509831248423}, {
     0, -1.3, 0}, {-0.4017220926874317, -1.2363734711836996`, 0}}], 
   Polygon3DBox[{{0, -1.285316954888546, 0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, 0.09270509831248423}, {
     0.4017220926874317, -1.2363734711836996`, 0}, {0, -1.3, 0}}], 
   Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.7554903506049574, -1.0398432596630913`, 
     0.09270509831248423}, {0.7641208279802151, -1.0517220926874318`, 0}, {
     0.4017220926874317, -1.2363734711836996`, 0}}], 
   Polygon3DBox[{{0.7554903506049574, -1.0398432596630913`, 
     0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {1.0517220926874318`, -0.7641208279802151, 0}, {
     0.7641208279802151, -1.0517220926874318`, 0}}], 
   Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {1.2224090654513957`, -0.3971847822188184, 
     0.09270509831248423}, {1.2363734711836996`, -0.4017220926874317, 0}, {
     1.0517220926874318`, -0.7641208279802151, 0}}], 
   Polygon3DBox[{{1.2224090654513957`, -0.3971847822188184, 
     0.09270509831248423}, {1.285316954888546, 0, 0.09270509831248423}, {
     1.3, 0, 0}, {1.2363734711836996`, -0.4017220926874317, 0}}], 
   Polygon3DBox[{{1.3, 0, 0}, {1.2363734711836996`, 0.4017220926874317, 0}, {
     1.2224090654513957`, 0.3971847822188184, -0.09270509831248423}, {
     1.285316954888546, 0, -0.09270509831248423}}], 
   Polygon3DBox[{{1.2363734711836996`, 0.4017220926874317, 0}, {
     1.0517220926874318`, 0.7641208279802151, 0}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.2224090654513957`, 
     0.3971847822188184, -0.09270509831248423}}], 
   Polygon3DBox[{{1.0517220926874318`, 0.7641208279802151, 0}, {
     0.7641208279802151, 1.0517220926874318`, 0}, {0.7554903506049574, 
     1.0398432596630913`, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{0.7641208279802151, 1.0517220926874318`, 0}, {
     0.4017220926874317, 1.2363734711836996`, 0}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.7554903506049574, 
     1.0398432596630913`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.4017220926874317, 1.2363734711836996`, 0}, {0, 1.3, 0}, {
     0, 1.285316954888546, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{
     0, 1.3, 0}, {-0.4017220926874317, 1.2363734711836996`, 
      0}, {-0.3971847822188184, 1.2224090654513957`, -0.09270509831248423}, {
     0, 1.285316954888546, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.4017220926874317, 1.2363734711836996`, 
      0}, {-0.7641208279802151, 1.0517220926874318`, 0}, {-0.7554903506049574,
      1.0398432596630913`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.7641208279802151, 1.0517220926874318`, 
      0}, {-1.0517220926874318`, 0.7641208279802151, 
      0}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.7554903506049574, 
     1.0398432596630913`, -0.09270509831248423}}], 
   Polygon3DBox[{{-1.0517220926874318`, 0.7641208279802151, 
      0}, {-1.2363734711836996`, 0.4017220926874317, 
      0}, {-1.2224090654513957`, 
     0.3971847822188184, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{-1.2363734711836996`, 0.4017220926874317, 0}, {-1.3, 0, 
      0}, {-1.285316954888546, 
      0, -0.09270509831248423}, {-1.2224090654513957`, 
     0.3971847822188184, -0.09270509831248423}}], 
   Polygon3DBox[{{-1.3, 0, 0}, {-1.2363734711836996`, -0.4017220926874317, 
      0}, {-1.2224090654513957`, -0.3971847822188184, -0.09270509831248423}, \
{-1.285316954888546, 0, -0.09270509831248423}}], 
   Polygon3DBox[{{-1.2363734711836996`, -0.4017220926874317, 
      0}, {-1.0517220926874318`, -0.7641208279802151, 
      0}, {-1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, \
{-1.2224090654513957`, -0.3971847822188184, -0.09270509831248423}}], 
   Polygon3DBox[{{-1.0517220926874318`, -0.7641208279802151, 
      0}, {-0.7641208279802151, -1.0517220926874318`, 
      0}, {-0.7554903506049574, -1.0398432596630913`, -0.09270509831248423}, \
{-1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.7641208279802151, -1.0517220926874318`, 
      0}, {-0.4017220926874317, -1.2363734711836996`, 
      0}, {-0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.7554903506049574, -1.0398432596630913`, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.4017220926874317, -1.2363734711836996`, 0}, {
     0, -1.3, 0}, {
     0, -1.285316954888546, -0.09270509831248423}, {-0.3971847822188184, \
-1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{0, -1.3, 0}, {
     0.4017220926874317, -1.2363734711836996`, 0}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0, -1.285316954888546, -0.09270509831248423}}], 
   Polygon3DBox[{{0.4017220926874317, -1.2363734711836996`, 0}, {
     0.7641208279802151, -1.0517220926874318`, 0}, {
     0.7554903506049574, -1.0398432596630913`, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.7641208279802151, -1.0517220926874318`, 0}, {
     1.0517220926874318`, -0.7641208279802151, 0}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.7554903506049574, -1.0398432596630913`, -0.09270509831248423}}], 
   Polygon3DBox[{{1.0517220926874318`, -0.7641208279802151, 0}, {
     1.2363734711836996`, -0.4017220926874317, 0}, {
     1.2224090654513957`, -0.3971847822188184, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{1.2363734711836996`, -0.4017220926874317, 0}, {1.3, 0, 0}, {
     1.285316954888546, 0, -0.09270509831248423}, {
     1.2224090654513957`, -0.3971847822188184, -0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0, -0.09270509831248423}, {
     1.2224090654513957`, 0.3971847822188184, -0.09270509831248423}, {
     1.1818827815832975`, 0.38401699437494746`, -0.17633557568774194`}, {
     1.2427050983124843`, 0, -0.17633557568774194`}}], 
   Polygon3DBox[{{1.2224090654513957`, 
    0.3971847822188184, -0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}, {1.1818827815832975`, 
    0.38401699437494746`, -0.17633557568774194`}}], 
   Polygon3DBox[{{1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.7554903506049574, 
    1.0398432596630913`, -0.09270509831248423}, {0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}, {1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.7554903506049574, 
    1.0398432596630913`, -0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {0.38401699437494746`, 
    1.1818827815832975`, -0.17633557568774194`}, {0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {
     0, 1.285316954888546, -0.09270509831248423}, {
     0, 1.2427050983124843`, -0.17633557568774194`}, {0.38401699437494746`, 
     1.1818827815832975`, -0.17633557568774194`}}], 
   Polygon3DBox[{{
     0, 1.285316954888546, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.38401699437494746`, 
     1.1818827815832975`, -0.17633557568774194`}, {
     0, 1.2427050983124843`, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.7554903506049574, 
    1.0398432596630913`, -0.09270509831248423}, {-0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}, {-0.38401699437494746`, 
    1.1818827815832975`, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.7554903506049574, 
    1.0398432596630913`, -0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}, {-0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}}], 
   Polygon3DBox[{{-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-1.2224090654513957`, 
    0.3971847822188184, -0.09270509831248423}, {-1.1818827815832975`, 
    0.38401699437494746`, -0.17633557568774194`}, {-1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}}], 
   Polygon3DBox[{{-1.2224090654513957`, 
     0.3971847822188184, -0.09270509831248423}, {-1.285316954888546, 
      0, -0.09270509831248423}, {-1.2427050983124843`, 
      0, -0.17633557568774194`}, {-1.1818827815832975`, 
     0.38401699437494746`, -0.17633557568774194`}}], 
   Polygon3DBox[{{-1.285316954888546, 
      0, -0.09270509831248423}, {-1.2224090654513957`, -0.3971847822188184, \
-0.09270509831248423}, {-1.1818827815832975`, -0.38401699437494746`, \
-0.17633557568774194`}, {-1.2427050983124843`, 0, -0.17633557568774194`}}], 
   Polygon3DBox[{{-1.2224090654513957`, -0.3971847822188184, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0053695435311896`, -0.7304437297367462, \
-0.17633557568774194`}, {-1.1818827815832975`, -0.38401699437494746`, \
-0.17633557568774194`}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.7554903506049574, -1.0398432596630913`, \
-0.09270509831248423}, {-0.7304437297367462, -1.0053695435311896`, \
-0.17633557568774194`}, {-1.0053695435311896`, -0.7304437297367462, \
-0.17633557568774194`}}], 
   Polygon3DBox[{{-0.7554903506049574, -1.0398432596630913`, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.38401699437494746`, -1.1818827815832975`, \
-0.17633557568774194`}, {-0.7304437297367462, -1.0053695435311896`, \
-0.17633557568774194`}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {0, -1.285316954888546, -0.09270509831248423}, {
     0, -1.2427050983124843`, -0.17633557568774194`}, {-0.38401699437494746`, \
-1.1818827815832975`, -0.17633557568774194`}}], 
   Polygon3DBox[{{0, -1.285316954888546, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.38401699437494746`, -1.1818827815832975`, -0.17633557568774194`}, {
     0, -1.2427050983124843`, -0.17633557568774194`}}], 
   Polygon3DBox[{{
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    0.7554903506049574, -1.0398432596630913`, -0.09270509831248423}, {
    0.7304437297367462, -1.0053695435311896`, -0.17633557568774194`}, {
    0.38401699437494746`, -1.1818827815832975`, -0.17633557568774194`}}], 
   Polygon3DBox[{{
    0.7554903506049574, -1.0398432596630913`, -0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    1.0053695435311896`, -0.7304437297367462, -0.17633557568774194`}, {
    0.7304437297367462, -1.0053695435311896`, -0.17633557568774194`}}], 
   Polygon3DBox[{{
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    1.2224090654513957`, -0.3971847822188184, -0.09270509831248423}, {
    1.1818827815832975`, -0.38401699437494746`, -0.17633557568774194`}, {
    1.0053695435311896`, -0.7304437297367462, -0.17633557568774194`}}], 
   Polygon3DBox[{{
     1.2224090654513957`, -0.3971847822188184, -0.09270509831248423}, {
     1.285316954888546, 0, -0.09270509831248423}, {
     1.2427050983124843`, 0, -0.17633557568774194`}, {
     1.1818827815832975`, -0.38401699437494746`, -0.17633557568774194`}}], 
   Polygon3DBox[{{1.2427050983124843`, 0, -0.17633557568774194`}, {
     1.1818827815832975`, 0.38401699437494746`, -0.17633557568774194`}, {
     1.1187616146076378`, 0.3635076839753495, -0.2427050983124842}, {
     1.1763355756877418`, 0, -0.2427050983124842}}], 
   Polygon3DBox[{{1.1818827815832975`, 
    0.38401699437494746`, -0.17633557568774194`}, {1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {1.1187616146076378`, 
    0.3635076839753495, -0.2427050983124842}}], 
   Polygon3DBox[{{1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}, {0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}, {0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}, {0.38401699437494746`, 
    1.1818827815832975`, -0.17633557568774194`}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}}], 
   Polygon3DBox[{{0.38401699437494746`, 
     1.1818827815832975`, -0.17633557568774194`}, {
     0, 1.2427050983124843`, -0.17633557568774194`}, {
     0, 1.1763355756877418`, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{
     0, 1.2427050983124843`, -0.17633557568774194`}, {-0.38401699437494746`, 
     1.1818827815832975`, -0.17633557568774194`}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {
     0, 1.1763355756877418`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.38401699437494746`, 
    1.1818827815832975`, -0.17633557568774194`}, {-0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}, {-0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.7304437297367462, 
    1.0053695435311896`, -0.17633557568774194`}, {-1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}}], 
   Polygon3DBox[{{-1.0053695435311896`, 
    0.7304437297367462, -0.17633557568774194`}, {-1.1818827815832975`, 
    0.38401699437494746`, -0.17633557568774194`}, {-1.1187616146076378`, 
    0.3635076839753495, -0.2427050983124842}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{-1.1818827815832975`, 
     0.38401699437494746`, -0.17633557568774194`}, {-1.2427050983124843`, 
      0, -0.17633557568774194`}, {-1.1763355756877418`, 
      0, -0.2427050983124842}, {-1.1187616146076378`, 
     0.3635076839753495, -0.2427050983124842}}], 
   Polygon3DBox[{{-1.2427050983124843`, 
      0, -0.17633557568774194`}, {-1.1818827815832975`, \
-0.38401699437494746`, -0.17633557568774194`}, {-1.1187616146076378`, \
-0.3635076839753495, -0.2427050983124842}, {-1.1763355756877418`, 
      0, -0.2427050983124842}}], 
   Polygon3DBox[{{-1.1818827815832975`, -0.38401699437494746`, \
-0.17633557568774194`}, {-1.0053695435311896`, -0.7304437297367462, \
-0.17633557568774194`}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.1187616146076378`, -0.3635076839753495, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-1.0053695435311896`, -0.7304437297367462, \
-0.17633557568774194`}, {-0.7304437297367462, -1.0053695435311896`, \
-0.17633557568774194`}, {-0.6914327031362311, -0.9516754718192205, \
-0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.7304437297367462, -1.0053695435311896`, \
-0.17633557568774194`}, {-0.38401699437494746`, -1.1818827815832975`, \
-0.17633557568774194`}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.6914327031362311, -0.9516754718192205, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.38401699437494746`, -1.1818827815832975`, \
-0.17633557568774194`}, {0, -1.2427050983124843`, -0.17633557568774194`}, {
     0, -1.1763355756877418`, -0.2427050983124842}, {-0.3635076839753495, \
-1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0, -1.2427050983124843`, -0.17633557568774194`}, {
     0.38401699437494746`, -1.1818827815832975`, -0.17633557568774194`}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0, -1.1763355756877418`, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.38401699437494746`, -1.1818827815832975`, -0.17633557568774194`}, {
    0.7304437297367462, -1.0053695435311896`, -0.17633557568774194`}, {
    0.6914327031362311, -0.9516754718192205, -0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.7304437297367462, -1.0053695435311896`, -0.17633557568774194`}, {
    1.0053695435311896`, -0.7304437297367462, -0.17633557568774194`}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    0.6914327031362311, -0.9516754718192205, -0.2427050983124842}}], 
   Polygon3DBox[{{
    1.0053695435311896`, -0.7304437297367462, -0.17633557568774194`}, {
    1.1818827815832975`, -0.38401699437494746`, -0.17633557568774194`}, {
    1.1187616146076378`, -0.3635076839753495, -0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{
     1.1818827815832975`, -0.38401699437494746`, -0.17633557568774194`}, {
     1.2427050983124843`, 0, -0.17633557568774194`}, {
     1.1763355756877418`, 0, -0.2427050983124842}, {
     1.1187616146076378`, -0.3635076839753495, -0.2427050983124842}}], 
   Polygon3DBox[{{1.1763355756877418`, 0, -0.2427050983124842}, {
     1.1187616146076378`, 0.3635076839753495, -0.2427050983124842}, {
     1.0392243041390246`, 0.33766444521870537`, -0.285316954888546}, {
     1.0927050983124842`, 0, -0.285316954888546}}], 
   Polygon3DBox[{{1.1187616146076378`, 
    0.3635076839753495, -0.2427050983124842}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.8840169943749474, 
    0.6422759418928752, -0.285316954888546}, {1.0392243041390246`, 
    0.33766444521870537`, -0.285316954888546}}], 
   Polygon3DBox[{{0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}, {0.6422759418928752, 
    0.8840169943749474, -0.285316954888546}, {0.8840169943749474, 
    0.6422759418928752, -0.285316954888546}}], 
   Polygon3DBox[{{0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {0.33766444521870537`, 
    1.0392243041390246`, -0.285316954888546}, {0.6422759418928752, 
    0.8840169943749474, -0.285316954888546}}], 
   Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {
     0, 1.1763355756877418`, -0.2427050983124842}, {
     0, 1.0927050983124842`, -0.285316954888546}, {0.33766444521870537`, 
     1.0392243041390246`, -0.285316954888546}}], 
   Polygon3DBox[{{
     0, 1.1763355756877418`, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.33766444521870537`, 
     1.0392243041390246`, -0.285316954888546}, {
     0, 1.0927050983124842`, -0.285316954888546}}], 
   Polygon3DBox[{{-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}, {-0.6422759418928752, 
    0.8840169943749474, -0.285316954888546}, {-0.33766444521870537`, 
    1.0392243041390246`, -0.285316954888546}}], 
   Polygon3DBox[{{-0.6914327031362311, 
    0.9516754718192205, -0.2427050983124842}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-0.8840169943749474, 
    0.6422759418928752, -0.285316954888546}, {-0.6422759418928752, 
    0.8840169943749474, -0.285316954888546}}], 
   Polygon3DBox[{{-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-1.1187616146076378`, 
    0.3635076839753495, -0.2427050983124842}, {-1.0392243041390246`, 
    0.33766444521870537`, -0.285316954888546}, {-0.8840169943749474, 
    0.6422759418928752, -0.285316954888546}}], 
   Polygon3DBox[{{-1.1187616146076378`, 
     0.3635076839753495, -0.2427050983124842}, {-1.1763355756877418`, 
      0, -0.2427050983124842}, {-1.0927050983124842`, 
      0, -0.285316954888546}, {-1.0392243041390246`, 
     0.33766444521870537`, -0.285316954888546}}], 
   Polygon3DBox[{{-1.1763355756877418`, 
      0, -0.2427050983124842}, {-1.1187616146076378`, -0.3635076839753495, \
-0.2427050983124842}, {-1.0392243041390246`, -0.33766444521870537`, \
-0.285316954888546}, {-1.0927050983124842`, 0, -0.285316954888546}}], 
   Polygon3DBox[{{-1.1187616146076378`, -0.3635076839753495, \
-0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8840169943749474, -0.6422759418928752, \
-0.285316954888546}, {-1.0392243041390246`, -0.33766444521870537`, \
-0.285316954888546}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.6914327031362311, -0.9516754718192205, \
-0.2427050983124842}, {-0.6422759418928752, -0.8840169943749474, \
-0.285316954888546}, {-0.8840169943749474, -0.6422759418928752, \
-0.285316954888546}}], 
   Polygon3DBox[{{-0.6914327031362311, -0.9516754718192205, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.33766444521870537`, -1.0392243041390246`, \
-0.285316954888546}, {-0.6422759418928752, -0.8840169943749474, \
-0.285316954888546}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {0, -1.1763355756877418`, -0.2427050983124842}, {
     0, -1.0927050983124842`, -0.285316954888546}, {-0.33766444521870537`, \
-1.0392243041390246`, -0.285316954888546}}], 
   Polygon3DBox[{{0, -1.1763355756877418`, -0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}, {
     0, -1.0927050983124842`, -0.285316954888546}}], 
   Polygon3DBox[{{
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.6914327031362311, -0.9516754718192205, -0.2427050983124842}, {
    0.6422759418928752, -0.8840169943749474, -0.285316954888546}, {
    0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}}], 
   Polygon3DBox[{{
    0.6914327031362311, -0.9516754718192205, -0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    0.8840169943749474, -0.6422759418928752, -0.285316954888546}, {
    0.6422759418928752, -0.8840169943749474, -0.285316954888546}}], 
   Polygon3DBox[{{
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    1.1187616146076378`, -0.3635076839753495, -0.2427050983124842}, {
    1.0392243041390246`, -0.33766444521870537`, -0.285316954888546}, {
    0.8840169943749474, -0.6422759418928752, -0.285316954888546}}], 
   Polygon3DBox[{{
     1.1187616146076378`, -0.3635076839753495, -0.2427050983124842}, {
     1.1763355756877418`, 0, -0.2427050983124842}, {
     1.0927050983124842`, 0, -0.285316954888546}, {
     1.0392243041390246`, -0.33766444521870537`, -0.285316954888546}}], 
   Polygon3DBox[
    NCache[{{1.0927050983124842`, 0, -0.285316954888546}, {
      1.0392243041390246`, 
      0.33766444521870537`, -0.285316954888546}, {(Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}, {1, 0, -0.3}}, {{
      1.0927050983124842`, 0, -0.285316954888546}, {1.0392243041390246`, 
      0.33766444521870537`, -0.285316954888546}, {0.9510565162951535, 
      0.30901699437494745`, -0.3}, {1, 0, -0.3}}]], 
   Polygon3DBox[
    NCache[{{1.0392243041390246`, 0.33766444521870537`, -0.285316954888546}, {
      0.8840169943749474, 0.6422759418928752, -0.285316954888546}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}, {(Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}}, {{1.0392243041390246`, 
     0.33766444521870537`, -0.285316954888546}, {0.8840169943749474, 
     0.6422759418928752, -0.285316954888546}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.9510565162951535, 
     0.30901699437494745`, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0.8840169943749474, 0.6422759418928752, -0.285316954888546}, {
      0.6422759418928752, 
      0.8840169943749474, -0.285316954888546}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}}, {{
     0.8840169943749474, 0.6422759418928752, -0.285316954888546}, {
     0.6422759418928752, 0.8840169943749474, -0.285316954888546}, {
     0.5877852522924731, 0.8090169943749475, -0.3}, {0.8090169943749475, 
     0.5877852522924731, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0.6422759418928752, 0.8840169943749474, -0.285316954888546}, {
      0.33766444521870537`, 1.0392243041390246`, -0.285316954888546}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}}, {{0.6422759418928752, 
     0.8840169943749474, -0.285316954888546}, {0.33766444521870537`, 
     1.0392243041390246`, -0.285316954888546}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.5877852522924731, 
     0.8090169943749475, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0.33766444521870537`, 1.0392243041390246`, -0.285316954888546}, {
      0, 1.0927050983124842`, -0.285316954888546}, {0, 1, -0.3}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}}, {{
      0.33766444521870537`, 1.0392243041390246`, -0.285316954888546}, {
      0, 1.0927050983124842`, -0.285316954888546}, {0, 1, -0.3}, {
      0.30901699437494745`, 0.9510565162951535, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0, 
       1.0927050983124842`, -0.285316954888546}, {-0.33766444521870537`, 
      1.0392243041390246`, -0.285316954888546}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0, 1, -0.3}}, {{
      0, 1.0927050983124842`, -0.285316954888546}, {-0.33766444521870537`, 
      1.0392243041390246`, -0.285316954888546}, {-0.30901699437494745`, 
      0.9510565162951535, -0.3}, {0, 1, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.33766444521870537`, 
      1.0392243041390246`, -0.285316954888546}, {-0.6422759418928752, 
      0.8840169943749474, -0.285316954888546}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}}, {{-0.33766444521870537`, 
     1.0392243041390246`, -0.285316954888546}, {-0.6422759418928752, 
     0.8840169943749474, -0.285316954888546}, {-0.5877852522924731, 
     0.8090169943749475, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.6422759418928752, 
      0.8840169943749474, -0.285316954888546}, {-0.8840169943749474, 
      0.6422759418928752, -0.285316954888546}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[
        1, 2], -0.3}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}}, {{-0.6422759418928752, 
     0.8840169943749474, -0.285316954888546}, {-0.8840169943749474, 
     0.6422759418928752, -0.285316954888546}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.5877852522924731, 
     0.8090169943749475, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.8840169943749474, 
      0.6422759418928752, -0.285316954888546}, {-1.0392243041390246`, 
      0.33766444521870537`, -0.285316954888546}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}}, {{-0.8840169943749474, 
     0.6422759418928752, -0.285316954888546}, {-1.0392243041390246`, 
     0.33766444521870537`, -0.285316954888546}, {-0.9510565162951535, 
     0.30901699437494745`, -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-1.0392243041390246`, 
      0.33766444521870537`, -0.285316954888546}, {-1.0927050983124842`, 
       0, -0.285316954888546}, {-1, 
       0, -0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}}, {{-1.0392243041390246`,
       0.33766444521870537`, -0.285316954888546}, {-1.0927050983124842`, 
       0, -0.285316954888546}, {-1, 0, -0.3}, {-0.9510565162951535, 
      0.30901699437494745`, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-1.0927050983124842`, 
       0, -0.285316954888546}, {-1.0392243041390246`, -0.33766444521870537`, \
-0.285316954888546}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), -0.3}, {-1, 
       0, -0.3}}, {{-1.0927050983124842`, 
       0, -0.285316954888546}, {-1.0392243041390246`, -0.33766444521870537`, \
-0.285316954888546}, {-0.9510565162951535, -0.30901699437494745`, -0.3}, {-1, 
       0, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-1.0392243041390246`, -0.33766444521870537`, \
-0.285316954888546}, {-0.8840169943749474, -0.6422759418928752, \
-0.285316954888546}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.3}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 - 5^
        Rational[
         1, 2]), -0.3}}, {{-1.0392243041390246`, -0.33766444521870537`, \
-0.285316954888546}, {-0.8840169943749474, -0.6422759418928752, \
-0.285316954888546}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.9510565162951535, -0.30901699437494745`, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.8840169943749474, -0.6422759418928752, -0.285316954888546}, \
{-0.6422759418928752, -0.8840169943749474, -0.285316954888546}, {-(
         Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.3}}, {{-0.8840169943749474, -0.6422759418928752, \
-0.285316954888546}, {-0.6422759418928752, -0.8840169943749474, \
-0.285316954888546}, {-0.5877852522924731, -0.8090169943749475, -0.3}, \
{-0.8090169943749475, -0.5877852522924731, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.6422759418928752, -0.8840169943749474, -0.285316954888546}, \
{-0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.3}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^
        Rational[
         1, 2]), -0.3}}, {{-0.6422759418928752, -0.8840169943749474, \
-0.285316954888546}, {-0.33766444521870537`, -1.0392243041390246`, \
-0.285316954888546}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.5877852522924731, -0.8090169943749475, -0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.33766444521870537`, -1.0392243041390246`, \
-0.285316954888546}, {0, -1.0927050983124842`, -0.285316954888546}, {
      0, -1, -0.3}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.3}}, {{-0.33766444521870537`, -1.0392243041390246`, \
-0.285316954888546}, {0, -1.0927050983124842`, -0.285316954888546}, {
      0, -1, -0.3}, {-0.30901699437494745`, -0.9510565162951535, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0, -1.0927050983124842`, -0.285316954888546}, {
      0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0, -1, -0.3}}, {{0, -1.0927050983124842`, -0.285316954888546}, {
      0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}, {
      0.30901699437494745`, -0.9510565162951535, -0.3}, {0, -1, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}, \
{0.6422759418928752, -0.8840169943749474, -0.285316954888546}, {(
        Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}}, {{
     0.33766444521870537`, -1.0392243041390246`, -0.285316954888546}, {
     0.6422759418928752, -0.8840169943749474, -0.285316954888546}, {
     0.5877852522924731, -0.8090169943749475, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0.6422759418928752, -0.8840169943749474, -0.285316954888546}, {
      0.8840169943749474, -0.6422759418928752, -0.285316954888546}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {(
        Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), -0.3}}, {{
     0.6422759418928752, -0.8840169943749474, -0.285316954888546}, {
     0.8840169943749474, -0.6422759418928752, -0.285316954888546}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.5877852522924731, -0.8090169943749475, -0.3}}]], 
   Polygon3DBox[
    NCache[{{0.8840169943749474, -0.6422759418928752, -0.285316954888546}, {
      1.0392243041390246`, -0.33766444521870537`, -0.285316954888546}, {(
        Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 - 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}}, {{
     0.8840169943749474, -0.6422759418928752, -0.285316954888546}, {
     1.0392243041390246`, -0.33766444521870537`, -0.285316954888546}, {
     0.9510565162951535, -0.30901699437494745`, -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}}]], 
   Polygon3DBox[
    NCache[{{1.0392243041390246`, -0.33766444521870537`, -0.285316954888546}, \
{1.0927050983124842`, 0, -0.285316954888546}, {
      1, 0, -0.3}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), -0.3}}, {{
      1.0392243041390246`, -0.33766444521870537`, -0.285316954888546}, {
      1.0927050983124842`, 0, -0.285316954888546}, {1, 0, -0.3}, {
      0.9510565162951535, -0.30901699437494745`, -0.3}}]], 
   Polygon3DBox[
    NCache[{{1, 0, -0.3}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}, {
      0.8628887284512825, 0.28036954353118954`, -0.285316954888546}, {
      0.9072949016875158, 0, -0.285316954888546}}, {{1, 0, -0.3}, {
      0.9510565162951535, 0.30901699437494745`, -0.3}, {0.8628887284512825, 
      0.28036954353118954`, -0.285316954888546}, {
      0.9072949016875158, 0, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0.7340169943749475, 0.5332945626920711, -0.285316954888546}, {
      0.8628887284512825, 0.28036954353118954`, -0.285316954888546}}, {{
     0.9510565162951535, 0.30901699437494745`, -0.3}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.7340169943749475, 
     0.5332945626920711, -0.285316954888546}, {0.8628887284512825, 
     0.28036954353118954`, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}, {0.5332945626920711, 
      0.7340169943749475, -0.285316954888546}, {0.7340169943749475, 
      0.5332945626920711, -0.285316954888546}}, {{0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.5877852522924731, 
     0.8090169943749475, -0.3}, {0.5332945626920711, 
     0.7340169943749475, -0.285316954888546}, {0.7340169943749475, 
     0.5332945626920711, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0.28036954353118954`, 0.8628887284512825, -0.285316954888546}, {
      0.5332945626920711, 0.7340169943749475, -0.285316954888546}}, {{
     0.5877852522924731, 0.8090169943749475, -0.3}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.28036954353118954`, 
     0.8628887284512825, -0.285316954888546}, {0.5332945626920711, 
     0.7340169943749475, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0, 1, -0.3}, {0, 0.9072949016875158, -0.285316954888546}, {
      0.28036954353118954`, 0.8628887284512825, -0.285316954888546}}, {{
      0.30901699437494745`, 0.9510565162951535, -0.3}, {0, 1, -0.3}, {
      0, 0.9072949016875158, -0.285316954888546}, {0.28036954353118954`, 
      0.8628887284512825, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{0, 1, -0.3}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}, {-0.28036954353118954`, 
      0.8628887284512825, -0.285316954888546}, {
      0, 0.9072949016875158, -0.285316954888546}}, {{
      0, 1, -0.3}, {-0.30901699437494745`, 
      0.9510565162951535, -0.3}, {-0.28036954353118954`, 
      0.8628887284512825, -0.285316954888546}, {
      0, 0.9072949016875158, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^
       Rational[
        1, 2], -0.3}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}, {-0.5332945626920711, 
      0.7340169943749475, -0.285316954888546}, {-0.28036954353118954`, 
      0.8628887284512825, -0.285316954888546}}, {{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.5877852522924731, 
     0.8090169943749475, -0.3}, {-0.5332945626920711, 
     0.7340169943749475, -0.285316954888546}, {-0.28036954353118954`, 
     0.8628887284512825, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], -0.3}, {-0.7340169943749475, 
      0.5332945626920711, -0.285316954888546}, {-0.5332945626920711, 
      0.7340169943749475, -0.285316954888546}}, {{-0.5877852522924731, 
     0.8090169943749475, -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.7340169943749475, 
     0.5332945626920711, -0.285316954888546}, {-0.5332945626920711, 
     0.7340169943749475, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[
        1, 2], -0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}, {-0.8628887284512825, 
      0.28036954353118954`, -0.285316954888546}, {-0.7340169943749475, 
      0.5332945626920711, -0.285316954888546}}, {{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.9510565162951535, 
     0.30901699437494745`, -0.3}, {-0.8628887284512825, 
     0.28036954353118954`, -0.285316954888546}, {-0.7340169943749475, 
     0.5332945626920711, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), -0.3}, {-1, 
       0, -0.3}, {-0.9072949016875158, 
       0, -0.285316954888546}, {-0.8628887284512825, 
      0.28036954353118954`, -0.285316954888546}}, {{-0.9510565162951535, 
      0.30901699437494745`, -0.3}, {-1, 0, -0.3}, {-0.9072949016875158, 
       0, -0.285316954888546}, {-0.8628887284512825, 
      0.28036954353118954`, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-1, 
       0, -0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (1 - 5^
        Rational[
         1, 2]), -0.3}, {-0.8628887284512825, -0.28036954353118954`, \
-0.285316954888546}, {-0.9072949016875158, 0, -0.285316954888546}}, {{-1, 
       0, -0.3}, {-0.9510565162951535, -0.30901699437494745`, -0.3}, \
{-0.8628887284512825, -0.28036954353118954`, -0.285316954888546}, \
{-0.9072949016875158, 0, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.3}, {-0.7340169943749475, -0.5332945626920711, \
-0.285316954888546}, {-0.8628887284512825, -0.28036954353118954`, \
-0.285316954888546}}, {{-0.9510565162951535, -0.30901699437494745`, -0.3}, \
{-0.8090169943749475, -0.5877852522924731, -0.3}, {-0.7340169943749475, \
-0.5332945626920711, -0.285316954888546}, {-0.8628887284512825, \
-0.28036954353118954`, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.3}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^
        Rational[
         1, 2]), -0.3}, {-0.5332945626920711, -0.7340169943749475, \
-0.285316954888546}, {-0.7340169943749475, -0.5332945626920711, \
-0.285316954888546}}, {{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.5877852522924731, -0.8090169943749475, -0.3}, {-0.5332945626920711, \
-0.7340169943749475, -0.285316954888546}, {-0.7340169943749475, \
-0.5332945626920711, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.3}, {-0.28036954353118954`, -0.8628887284512825, \
-0.285316954888546}, {-0.5332945626920711, -0.7340169943749475, \
-0.285316954888546}}, {{-0.5877852522924731, -0.8090169943749475, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.28036954353118954`, \
-0.8628887284512825, -0.285316954888546}, {-0.5332945626920711, \
-0.7340169943749475, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.3}, {0, -1, -0.3}, {
      0, -0.9072949016875158, -0.285316954888546}, {-0.28036954353118954`, \
-0.8628887284512825, -0.285316954888546}}, {{-0.30901699437494745`, \
-0.9510565162951535, -0.3}, {0, -1, -0.3}, {
      0, -0.9072949016875158, -0.285316954888546}, {-0.28036954353118954`, \
-0.8628887284512825, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{0, -1, -0.3}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0.28036954353118954`, -0.8628887284512825, -0.285316954888546}, {
      0, -0.9072949016875158, -0.285316954888546}}, {{0, -1, -0.3}, {
      0.30901699437494745`, -0.9510565162951535, -0.3}, {
      0.28036954353118954`, -0.8628887284512825, -0.285316954888546}, {
      0, -0.9072949016875158, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {(
        Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), -0.3}, {
      0.5332945626920711, -0.7340169943749475, -0.285316954888546}, {
      0.28036954353118954`, -0.8628887284512825, -0.285316954888546}}, {{
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.5877852522924731, -0.8090169943749475, -0.3}, {
     0.5332945626920711, -0.7340169943749475, -0.285316954888546}, {
     0.28036954353118954`, -0.8628887284512825, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), -0.3}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {
      0.7340169943749475, -0.5332945626920711, -0.285316954888546}, {
      0.5332945626920711, -0.7340169943749475, -0.285316954888546}}, {{
     0.5877852522924731, -0.8090169943749475, -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.7340169943749475, -0.5332945626920711, -0.285316954888546}, {
     0.5332945626920711, -0.7340169943749475, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.3}, {(
        Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 - 5^Rational[1, 2]), -0.3}, {
      0.8628887284512825, -0.28036954353118954`, -0.285316954888546}, {
      0.7340169943749475, -0.5332945626920711, -0.285316954888546}}, {{
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.9510565162951535, -0.30901699437494745`, -0.3}, {
     0.8628887284512825, -0.28036954353118954`, -0.285316954888546}, {
     0.7340169943749475, -0.5332945626920711, -0.285316954888546}}]], 
   Polygon3DBox[
    NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), -0.3}, {
      1, 0, -0.3}, {0.9072949016875158, 0, -0.285316954888546}, {
      0.8628887284512825, -0.28036954353118954`, -0.285316954888546}}, {{
      0.9510565162951535, -0.30901699437494745`, -0.3}, {1, 0, -0.3}, {
      0.9072949016875158, 0, -0.285316954888546}, {
      0.8628887284512825, -0.28036954353118954`, -0.285316954888546}}]], 
   Polygon3DBox[{{0.9072949016875158, 0, -0.285316954888546}, {
     0.8628887284512825, 0.28036954353118954`, -0.285316954888546}, {
     0.7833514179826693, 0.2545263047745454, -0.2427050983124842}, {
     0.8236644243122581, 0, -0.2427050983124842}}], 
   Polygon3DBox[{{0.8628887284512825, 
    0.28036954353118954`, -0.285316954888546}, {0.7340169943749475, 
    0.5332945626920711, -0.285316954888546}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.7833514179826693, 
    0.2545263047745454, -0.2427050983124842}}], 
   Polygon3DBox[{{0.7340169943749475, 
    0.5332945626920711, -0.285316954888546}, {0.5332945626920711, 
    0.7340169943749475, -0.285316954888546}, {0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.5332945626920711, 
    0.7340169943749475, -0.285316954888546}, {0.28036954353118954`, 
    0.8628887284512825, -0.285316954888546}, {0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}}], 
   Polygon3DBox[{{0.28036954353118954`, 
     0.8628887284512825, -0.285316954888546}, {
     0, 0.9072949016875158, -0.285316954888546}, {
     0, 0.8236644243122581, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{
     0, 0.9072949016875158, -0.285316954888546}, {-0.28036954353118954`, 
     0.8628887284512825, -0.285316954888546}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {
     0, 0.8236644243122581, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.28036954353118954`, 
    0.8628887284512825, -0.285316954888546}, {-0.5332945626920711, 
    0.7340169943749475, -0.285316954888546}, {-0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.5332945626920711, 
    0.7340169943749475, -0.285316954888546}, {-0.7340169943749475, 
    0.5332945626920711, -0.285316954888546}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.7340169943749475, 
    0.5332945626920711, -0.285316954888546}, {-0.8628887284512825, 
    0.28036954353118954`, -0.285316954888546}, {-0.7833514179826693, 
    0.2545263047745454, -0.2427050983124842}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.8628887284512825, 
     0.28036954353118954`, -0.285316954888546}, {-0.9072949016875158, 
      0, -0.285316954888546}, {-0.8236644243122581, 
      0, -0.2427050983124842}, {-0.7833514179826693, 
     0.2545263047745454, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.9072949016875158, 
      0, -0.285316954888546}, {-0.8628887284512825, -0.28036954353118954`, \
-0.285316954888546}, {-0.7833514179826693, -0.2545263047745454, \
-0.2427050983124842}, {-0.8236644243122581, 0, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.8628887284512825, -0.28036954353118954`, \
-0.285316954888546}, {-0.7340169943749475, -0.5332945626920711, \
-0.285316954888546}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.7833514179826693, -0.2545263047745454, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.7340169943749475, -0.5332945626920711, \
-0.285316954888546}, {-0.5332945626920711, -0.7340169943749475, \
-0.285316954888546}, {-0.48413780144871527`, -0.6663585169306744, \
-0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.5332945626920711, -0.7340169943749475, \
-0.285316954888546}, {-0.28036954353118954`, -0.8628887284512825, \
-0.285316954888546}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.48413780144871527`, -0.6663585169306744, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.28036954353118954`, -0.8628887284512825, \
-0.285316954888546}, {0, -0.9072949016875158, -0.285316954888546}, {
     0, -0.8236644243122581, -0.2427050983124842}, {-0.2545263047745454, \
-0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0, -0.9072949016875158, -0.285316954888546}, {
     0.28036954353118954`, -0.8628887284512825, -0.285316954888546}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0, -0.8236644243122581, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.28036954353118954`, -0.8628887284512825, -0.285316954888546}, {
    0.5332945626920711, -0.7340169943749475, -0.285316954888546}, {
    0.48413780144871527`, -0.6663585169306744, -0.2427050983124842}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.5332945626920711, -0.7340169943749475, -0.285316954888546}, {
    0.7340169943749475, -0.5332945626920711, -0.285316954888546}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.48413780144871527`, -0.6663585169306744, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.7340169943749475, -0.5332945626920711, -0.285316954888546}, {
    0.8628887284512825, -0.28036954353118954`, -0.285316954888546}, {
    0.7833514179826693, -0.2545263047745454, -0.2427050983124842}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{
     0.8628887284512825, -0.28036954353118954`, -0.285316954888546}, {
     0.9072949016875158, 0, -0.285316954888546}, {
     0.8236644243122581, 0, -0.2427050983124842}, {
     0.7833514179826693, -0.2545263047745454, -0.2427050983124842}}], 
   Polygon3DBox[{{0.8236644243122581, 0, -0.2427050983124842}, {
     0.7833514179826693, 0.2545263047745454, -0.2427050983124842}, {
     0.7202302510070095, 0.23401699437494744`, -0.17633557568774194`}, {
     0.7572949016875158, 0, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.7833514179826693, 
    0.2545263047745454, -0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}, {0.7202302510070095, 
    0.23401699437494744`, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}, {0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}, {0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}, {0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {0.23401699437494744`, 
    0.7202302510070095, -0.17633557568774194`}, {0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {
     0, 0.8236644243122581, -0.2427050983124842}, {
     0, 0.7572949016875158, -0.17633557568774194`}, {0.23401699437494744`, 
     0.7202302510070095, -0.17633557568774194`}}], 
   Polygon3DBox[{{
     0, 0.8236644243122581, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.23401699437494744`, 
     0.7202302510070095, -0.17633557568774194`}, {
     0, 0.7572949016875158, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}, {-0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}, {-0.23401699437494744`, 
    0.7202302510070095, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.48413780144871527`, 
    0.6663585169306744, -0.2427050983124842}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}, {-0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.7833514179826693, 
    0.2545263047745454, -0.2427050983124842}, {-0.7202302510070095, 
    0.23401699437494744`, -0.17633557568774194`}, {-0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.7833514179826693, 
     0.2545263047745454, -0.2427050983124842}, {-0.8236644243122581, 
      0, -0.2427050983124842}, {-0.7572949016875158, 
      0, -0.17633557568774194`}, {-0.7202302510070095, 
     0.23401699437494744`, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.8236644243122581, 
      0, -0.2427050983124842}, {-0.7833514179826693, -0.2545263047745454, \
-0.2427050983124842}, {-0.7202302510070095, -0.23401699437494744`, \
-0.17633557568774194`}, {-0.7572949016875158, 0, -0.17633557568774194`}}], 
   Polygon3DBox[{{-0.7833514179826693, -0.2545263047745454, \
-0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.6126644452187053, -0.44512677484820007`, \
-0.17633557568774194`}, {-0.7202302510070095, -0.23401699437494744`, \
-0.17633557568774194`}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.48413780144871527`, -0.6663585169306744, \
-0.2427050983124842}, {-0.44512677484820007`, -0.6126644452187053, \
-0.17633557568774194`}, {-0.6126644452187053, -0.44512677484820007`, \
-0.17633557568774194`}}], 
   Polygon3DBox[{{-0.48413780144871527`, -0.6663585169306744, \
-0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.23401699437494744`, -0.7202302510070095, \
-0.17633557568774194`}, {-0.44512677484820007`, -0.6126644452187053, \
-0.17633557568774194`}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {0, -0.8236644243122581, -0.2427050983124842}, {
     0, -0.7572949016875158, -0.17633557568774194`}, {-0.23401699437494744`, \
-0.7202302510070095, -0.17633557568774194`}}], 
   Polygon3DBox[{{0, -0.8236644243122581, -0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.23401699437494744`, -0.7202302510070095, -0.17633557568774194`}, {
     0, -0.7572949016875158, -0.17633557568774194`}}], 
   Polygon3DBox[{{
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.48413780144871527`, -0.6663585169306744, -0.2427050983124842}, {
    0.44512677484820007`, -0.6126644452187053, -0.17633557568774194`}, {
    0.23401699437494744`, -0.7202302510070095, -0.17633557568774194`}}], 
   Polygon3DBox[{{
    0.48413780144871527`, -0.6663585169306744, -0.2427050983124842}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.6126644452187053, -0.44512677484820007`, -0.17633557568774194`}, {
    0.44512677484820007`, -0.6126644452187053, -0.17633557568774194`}}], 
   Polygon3DBox[{{
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.7833514179826693, -0.2545263047745454, -0.2427050983124842}, {
    0.7202302510070095, -0.23401699437494744`, -0.17633557568774194`}, {
    0.6126644452187053, -0.44512677484820007`, -0.17633557568774194`}}], 
   Polygon3DBox[{{
     0.7833514179826693, -0.2545263047745454, -0.2427050983124842}, {
     0.8236644243122581, 0, -0.2427050983124842}, {
     0.7572949016875158, 0, -0.17633557568774194`}, {
     0.7202302510070095, -0.23401699437494744`, -0.17633557568774194`}}], 
   Polygon3DBox[{{0.7572949016875158, 0, -0.17633557568774194`}, {
     0.7202302510070095, 0.23401699437494744`, -0.17633557568774194`}, {
     0.6797039671389115, 0.22084920653107648`, -0.09270509831248423}, {
     0.714683045111454, 0, -0.09270509831248423}}], 
   Polygon3DBox[{{0.7202302510070095, 
    0.23401699437494744`, -0.17633557568774194`}, {0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.6797039671389115, 
    0.22084920653107648`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}, {0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}, {0.4200801539799889, 
    0.5781907290868035, -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}, {0.23401699437494744`, 
    0.7202302510070095, -0.17633557568774194`}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {0.4200801539799889, 
    0.5781907290868035, -0.09270509831248423}}], 
   Polygon3DBox[{{0.23401699437494744`, 
     0.7202302510070095, -0.17633557568774194`}, {
     0, 0.7572949016875158, -0.17633557568774194`}, {
     0, 0.714683045111454, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{
     0, 0.7572949016875158, -0.17633557568774194`}, {-0.23401699437494744`, 
     0.7202302510070095, -0.17633557568774194`}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {
     0, 0.714683045111454, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.23401699437494744`, 
    0.7202302510070095, -0.17633557568774194`}, {-0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}, {-0.4200801539799889, 
    0.5781907290868035, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.44512677484820007`, 
    0.6126644452187053, -0.17633557568774194`}, {-0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.4200801539799889, 
    0.5781907290868035, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.6126644452187053, 
    0.44512677484820007`, -0.17633557568774194`}, {-0.7202302510070095, 
    0.23401699437494744`, -0.17633557568774194`}, {-0.6797039671389115, 
    0.22084920653107648`, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.7202302510070095, 
     0.23401699437494744`, -0.17633557568774194`}, {-0.7572949016875158, 
      0, -0.17633557568774194`}, {-0.714683045111454, 
      0, -0.09270509831248423}, {-0.6797039671389115, 
     0.22084920653107648`, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.7572949016875158, 
      0, -0.17633557568774194`}, {-0.7202302510070095, -0.23401699437494744`, \
-0.17633557568774194`}, {-0.6797039671389115, -0.22084920653107648`, \
-0.09270509831248423}, {-0.714683045111454, 0, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.7202302510070095, -0.23401699437494744`, \
-0.17633557568774194`}, {-0.6126644452187053, -0.44512677484820007`, \
-0.17633557568774194`}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6797039671389115, -0.22084920653107648`, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.6126644452187053, -0.44512677484820007`, \
-0.17633557568774194`}, {-0.44512677484820007`, -0.6126644452187053, \
-0.17633557568774194`}, {-0.4200801539799889, -0.5781907290868035, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.44512677484820007`, -0.6126644452187053, \
-0.17633557568774194`}, {-0.23401699437494744`, -0.7202302510070095, \
-0.17633557568774194`}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.4200801539799889, -0.5781907290868035, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.23401699437494744`, -0.7202302510070095, \
-0.17633557568774194`}, {0, -0.7572949016875158, -0.17633557568774194`}, {
     0, -0.714683045111454, -0.09270509831248423}, {-0.22084920653107648`, \
-0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0, -0.7572949016875158, -0.17633557568774194`}, {
     0.23401699437494744`, -0.7202302510070095, -0.17633557568774194`}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0, -0.714683045111454, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.23401699437494744`, -0.7202302510070095, -0.17633557568774194`}, {
    0.44512677484820007`, -0.6126644452187053, -0.17633557568774194`}, {
    0.4200801539799889, -0.5781907290868035, -0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.44512677484820007`, -0.6126644452187053, -0.17633557568774194`}, {
    0.6126644452187053, -0.44512677484820007`, -0.17633557568774194`}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.4200801539799889, -0.5781907290868035, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.6126644452187053, -0.44512677484820007`, -0.17633557568774194`}, {
    0.7202302510070095, -0.23401699437494744`, -0.17633557568774194`}, {
    0.6797039671389115, -0.22084920653107648`, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{
     0.7202302510070095, -0.23401699437494744`, -0.17633557568774194`}, {
     0.7572949016875158, 0, -0.17633557568774194`}, {
     0.714683045111454, 0, -0.09270509831248423}, {
     0.6797039671389115, -0.22084920653107648`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0, -0.09270509831248423}, {
     0.6797039671389115, 0.22084920653107648`, -0.09270509831248423}, {
     0.6657395614066075, 0.2163118960624632, 0}, {0.7, 0, 0}}], 
   Polygon3DBox[{{0.6797039671389115, 
     0.22084920653107648`, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {
     0.5663118960624632, 0.4114496766047312, 0}, {
     0.6657395614066075, 0.2163118960624632, 0}}], 
   Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.4200801539799889, 
     0.5781907290868035, -0.09270509831248423}, {
     0.4114496766047312, 0.5663118960624632, 0}, {
     0.5663118960624632, 0.4114496766047312, 0}}], 
   Polygon3DBox[{{0.4200801539799889, 
     0.5781907290868035, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {
     0.2163118960624632, 0.6657395614066075, 0}, {
     0.4114496766047312, 0.5663118960624632, 0}}], 
   Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {
     0, 0.714683045111454, -0.09270509831248423}, {0, 0.7, 0}, {
     0.2163118960624632, 0.6657395614066075, 0}}], 
   Polygon3DBox[{{
     0, 0.714683045111454, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2163118960624632, 
      0.6657395614066075, 0}, {0, 0.7, 0}}], 
   Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.4200801539799889, 
     0.5781907290868035, -0.09270509831248423}, {-0.4114496766047312, 
      0.5663118960624632, 0}, {-0.2163118960624632, 0.6657395614066075, 0}}], 
   Polygon3DBox[{{-0.4200801539799889, 
     0.5781907290868035, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5663118960624632, 
      0.4114496766047312, 0}, {-0.4114496766047312, 0.5663118960624632, 0}}], 
   Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6797039671389115, 
     0.22084920653107648`, -0.09270509831248423}, {-0.6657395614066075, 
      0.2163118960624632, 0}, {-0.5663118960624632, 0.4114496766047312, 0}}], 
   Polygon3DBox[{{-0.6797039671389115, 
     0.22084920653107648`, -0.09270509831248423}, {-0.714683045111454, 
      0, -0.09270509831248423}, {-0.7, 0, 0}, {-0.6657395614066075, 
      0.2163118960624632, 0}}], 
   Polygon3DBox[{{-0.714683045111454, 
      0, -0.09270509831248423}, {-0.6797039671389115, -0.22084920653107648`, \
-0.09270509831248423}, {-0.6657395614066075, -0.2163118960624632, 0}, {-0.7, 
      0, 0}}], Polygon3DBox[{{-0.6797039671389115, -0.22084920653107648`, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5663118960624632, -0.4114496766047312, 
      0}, {-0.6657395614066075, -0.2163118960624632, 0}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.4200801539799889, -0.5781907290868035, \
-0.09270509831248423}, {-0.4114496766047312, -0.5663118960624632, 
      0}, {-0.5663118960624632, -0.4114496766047312, 0}}], 
   Polygon3DBox[{{-0.4200801539799889, -0.5781907290868035, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2163118960624632, -0.6657395614066075, 
      0}, {-0.4114496766047312, -0.5663118960624632, 0}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {0, -0.714683045111454, -0.09270509831248423}, {
     0, -0.7, 0}, {-0.2163118960624632, -0.6657395614066075, 0}}], 
   Polygon3DBox[{{0, -0.714683045111454, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2163118960624632, -0.6657395614066075, 0}, {0, -0.7, 0}}], 
   Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.4200801539799889, -0.5781907290868035, -0.09270509831248423}, {
     0.4114496766047312, -0.5663118960624632, 0}, {
     0.2163118960624632, -0.6657395614066075, 0}}], 
   Polygon3DBox[{{
     0.4200801539799889, -0.5781907290868035, -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5663118960624632, -0.4114496766047312, 0}, {
     0.4114496766047312, -0.5663118960624632, 0}}], 
   Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6797039671389115, -0.22084920653107648`, -0.09270509831248423}, {
     0.6657395614066075, -0.2163118960624632, 0}, {
     0.5663118960624632, -0.4114496766047312, 0}}], 
   Polygon3DBox[{{
     0.6797039671389115, -0.22084920653107648`, -0.09270509831248423}, {
     0.714683045111454, 0, -0.09270509831248423}, {0.7, 0, 0}, {
     0.6657395614066075, -0.2163118960624632, 0}}], 
   Polygon3DBox[{{0.7, 0, 0}, {0.6657395614066075, 0.2163118960624632, 0}, {
     0.6797039671389115, 0.22084920653107648`, 0.09270509831248423}, {
     0.714683045111454, 0, 0.09270509831248423}}], 
   Polygon3DBox[{{0.6657395614066075, 0.2163118960624632, 0}, {
     0.5663118960624632, 0.4114496766047312, 0}, {0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {0.6797039671389115, 
     0.22084920653107648`, 0.09270509831248423}}], 
   Polygon3DBox[{{0.5663118960624632, 0.4114496766047312, 0}, {
     0.4114496766047312, 0.5663118960624632, 0}, {0.4200801539799889, 
     0.5781907290868035, 0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.4114496766047312, 0.5663118960624632, 0}, {
     0.2163118960624632, 0.6657395614066075, 0}, {0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {0.4200801539799889, 
     0.5781907290868035, 0.09270509831248423}}], 
   Polygon3DBox[{{0.2163118960624632, 0.6657395614066075, 0}, {0, 0.7, 0}, {
     0, 0.714683045111454, 0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{
     0, 0.7, 0}, {-0.2163118960624632, 0.6657395614066075, 
      0}, {-0.22084920653107648`, 0.6797039671389115, 0.09270509831248423}, {
     0, 0.714683045111454, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.2163118960624632, 0.6657395614066075, 
      0}, {-0.4114496766047312, 0.5663118960624632, 0}, {-0.4200801539799889, 
     0.5781907290868035, 0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.4114496766047312, 0.5663118960624632, 
      0}, {-0.5663118960624632, 0.4114496766047312, 0}, {-0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {-0.4200801539799889, 
     0.5781907290868035, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.5663118960624632, 0.4114496766047312, 
      0}, {-0.6657395614066075, 0.2163118960624632, 0}, {-0.6797039671389115, 
     0.22084920653107648`, 0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.6657395614066075, 0.2163118960624632, 0}, {-0.7, 0, 
      0}, {-0.714683045111454, 0, 0.09270509831248423}, {-0.6797039671389115, 
     0.22084920653107648`, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.7, 0, 0}, {-0.6657395614066075, -0.2163118960624632, 
      0}, {-0.6797039671389115, -0.22084920653107648`, 
     0.09270509831248423}, {-0.714683045111454, 0, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.6657395614066075, -0.2163118960624632, 
      0}, {-0.5663118960624632, -0.4114496766047312, 
      0}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6797039671389115, -0.22084920653107648`, 
     0.09270509831248423}}], 
   Polygon3DBox[{{-0.5663118960624632, -0.4114496766047312, 
      0}, {-0.4114496766047312, -0.5663118960624632, 
      0}, {-0.4200801539799889, -0.5781907290868035, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}}], 
   Polygon3DBox[{{-0.4114496766047312, -0.5663118960624632, 
      0}, {-0.2163118960624632, -0.6657395614066075, 
      0}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.4200801539799889, -0.5781907290868035, 
     0.09270509831248423}}], 
   Polygon3DBox[{{-0.2163118960624632, -0.6657395614066075, 0}, {
     0, -0.7, 0}, {
     0, -0.714683045111454, 
      0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}}], 
   Polygon3DBox[{{0, -0.7, 0}, {0.2163118960624632, -0.6657395614066075, 0}, {
     0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
     0, -0.714683045111454, 0.09270509831248423}}], 
   Polygon3DBox[{{0.2163118960624632, -0.6657395614066075, 0}, {
     0.4114496766047312, -0.5663118960624632, 0}, {
     0.4200801539799889, -0.5781907290868035, 0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{0.4114496766047312, -0.5663118960624632, 0}, {
     0.5663118960624632, -0.4114496766047312, 0}, {
     0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
     0.4200801539799889, -0.5781907290868035, 0.09270509831248423}}], 
   Polygon3DBox[{{0.5663118960624632, -0.4114496766047312, 0}, {
     0.6657395614066075, -0.2163118960624632, 0}, {
     0.6797039671389115, -0.22084920653107648`, 0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.6657395614066075, -0.2163118960624632, 0}, {0.7, 0, 0}, {
     0.714683045111454, 0, 0.09270509831248423}, {
     0.6797039671389115, -0.22084920653107648`, 0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0, 0.09270509831248423}, {
     0.6797039671389115, 0.22084920653107648`, 0.09270509831248423}, {
     0.7202302510070095, 0.23401699437494744`, 0.17633557568774194`}, {
     0.7572949016875158, 0, 0.17633557568774194`}}], 
   Polygon3DBox[{{0.6797039671389115, 0.22084920653107648`, 
    0.09270509831248423}, {0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}, {0.7202302510070095, 0.23401699437494744`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {0.4200801539799889, 0.5781907290868035, 
    0.09270509831248423}, {0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}, {0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.4200801539799889, 0.5781907290868035, 
    0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {0.23401699437494744`, 0.7202302510070095, 
    0.17633557568774194`}, {0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0, 0.714683045111454, 0.09270509831248423}, {
     0, 0.7572949016875158, 0.17633557568774194`}, {0.23401699437494744`, 
     0.7202302510070095, 0.17633557568774194`}}], 
   Polygon3DBox[{{
     0, 0.714683045111454, 0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {-0.23401699437494744`, 
     0.7202302510070095, 0.17633557568774194`}, {
     0, 0.7572949016875158, 0.17633557568774194`}}], 
   Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {-0.4200801539799889, 0.5781907290868035, 
    0.09270509831248423}, {-0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}, {-0.23401699437494744`, 0.7202302510070095, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.4200801539799889, 0.5781907290868035, 
    0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {-0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}, {-0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {-0.6797039671389115, 0.22084920653107648`, 
    0.09270509831248423}, {-0.7202302510070095, 0.23401699437494744`, 
    0.17633557568774194`}, {-0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.6797039671389115, 0.22084920653107648`, 
     0.09270509831248423}, {-0.714683045111454, 0, 
      0.09270509831248423}, {-0.7572949016875158, 0, 
      0.17633557568774194`}, {-0.7202302510070095, 0.23401699437494744`, 
     0.17633557568774194`}}], 
   Polygon3DBox[{{-0.714683045111454, 0, 
      0.09270509831248423}, {-0.6797039671389115, -0.22084920653107648`, 
     0.09270509831248423}, {-0.7202302510070095, -0.23401699437494744`, 
     0.17633557568774194`}, {-0.7572949016875158, 0, 0.17633557568774194`}}], 
   Polygon3DBox[{{-0.6797039671389115, -0.22084920653107648`, 
    0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}, {-0.7202302510070095, -0.23401699437494744`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.4200801539799889, -0.5781907290868035, 
    0.09270509831248423}, {-0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}, {-0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.4200801539799889, -0.5781907290868035, 
    0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {-0.23401699437494744`, -0.7202302510070095, 
    0.17633557568774194`}, {-0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0, -0.714683045111454, 0.09270509831248423}, {
     0, -0.7572949016875158, 
      0.17633557568774194`}, {-0.23401699437494744`, -0.7202302510070095, 
     0.17633557568774194`}}], 
   Polygon3DBox[{{0, -0.714683045111454, 0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
     0.23401699437494744`, -0.7202302510070095, 0.17633557568774194`}, {
     0, -0.7572949016875158, 0.17633557568774194`}}], 
   Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.4200801539799889, -0.5781907290868035, 
    0.09270509831248423}, {0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}, {0.23401699437494744`, -0.7202302510070095, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.4200801539799889, -0.5781907290868035, 
    0.09270509831248423}, {0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}, {0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {0.6797039671389115, -0.22084920653107648`, 
    0.09270509831248423}, {0.7202302510070095, -0.23401699437494744`, 
    0.17633557568774194`}, {0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}}], 
   Polygon3DBox[{{0.6797039671389115, -0.22084920653107648`, 
     0.09270509831248423}, {0.714683045111454, 0, 0.09270509831248423}, {
     0.7572949016875158, 0, 0.17633557568774194`}, {
     0.7202302510070095, -0.23401699437494744`, 0.17633557568774194`}}], 
   Polygon3DBox[{{0.7572949016875158, 0, 0.17633557568774194`}, {
     0.7202302510070095, 0.23401699437494744`, 0.17633557568774194`}, {
     0.7833514179826693, 0.2545263047745454, 0.2427050983124842}, {
     0.8236644243122581, 0, 0.2427050983124842}}], 
   Polygon3DBox[{{0.7202302510070095, 0.23401699437494744`, 
    0.17633557568774194`}, {0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}, {0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.7833514179826693, 0.2545263047745454, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}, {0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}, {0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}, {0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}, {0.23401699437494744`, 0.7202302510070095, 
    0.17633557568774194`}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.23401699437494744`, 0.7202302510070095, 
     0.17633557568774194`}, {0, 0.7572949016875158, 0.17633557568774194`}, {
     0, 0.8236644243122581, 0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, 0.2427050983124842}}], 
   Polygon3DBox[{{
     0, 0.7572949016875158, 0.17633557568774194`}, {-0.23401699437494744`, 
     0.7202302510070095, 0.17633557568774194`}, {-0.2545263047745454, 
     0.7833514179826693, 0.2427050983124842}, {
     0, 0.8236644243122581, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.23401699437494744`, 0.7202302510070095, 
    0.17633557568774194`}, {-0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}, {-0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.44512677484820007`, 0.6126644452187053, 
    0.17633557568774194`}, {-0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.6126644452187053, 0.44512677484820007`, 
    0.17633557568774194`}, {-0.7202302510070095, 0.23401699437494744`, 
    0.17633557568774194`}, {-0.7833514179826693, 0.2545263047745454, 
    0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.7202302510070095, 0.23401699437494744`, 
     0.17633557568774194`}, {-0.7572949016875158, 0, 
      0.17633557568774194`}, {-0.8236644243122581, 0, 
      0.2427050983124842}, {-0.7833514179826693, 0.2545263047745454, 
     0.2427050983124842}}], 
   Polygon3DBox[{{-0.7572949016875158, 0, 
      0.17633557568774194`}, {-0.7202302510070095, -0.23401699437494744`, 
     0.17633557568774194`}, {-0.7833514179826693, -0.2545263047745454, 
     0.2427050983124842}, {-0.8236644243122581, 0, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.7202302510070095, -0.23401699437494744`, 
    0.17633557568774194`}, {-0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.7833514179826693, -0.2545263047745454, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}, {-0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}, {-0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}, {-0.23401699437494744`, -0.7202302510070095, 
    0.17633557568774194`}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {-0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.23401699437494744`, -0.7202302510070095, 
     0.17633557568774194`}, {0, -0.7572949016875158, 0.17633557568774194`}, {
     0, -0.8236644243122581, 
      0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}}], 
   Polygon3DBox[{{0, -0.7572949016875158, 0.17633557568774194`}, {
     0.23401699437494744`, -0.7202302510070095, 0.17633557568774194`}, {
     0.2545263047745454, -0.7833514179826693, 0.2427050983124842}, {
     0, -0.8236644243122581, 0.2427050983124842}}], 
   Polygon3DBox[{{0.23401699437494744`, -0.7202302510070095, 
    0.17633557568774194`}, {0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}, {0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.44512677484820007`, -0.6126644452187053, 
    0.17633557568774194`}, {0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.6126644452187053, -0.44512677484820007`, 
    0.17633557568774194`}, {0.7202302510070095, -0.23401699437494744`, 
    0.17633557568774194`}, {0.7833514179826693, -0.2545263047745454, 
    0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.7202302510070095, -0.23401699437494744`, 
     0.17633557568774194`}, {0.7572949016875158, 0, 0.17633557568774194`}, {
     0.8236644243122581, 0, 0.2427050983124842}, {
     0.7833514179826693, -0.2545263047745454, 0.2427050983124842}}], 
   Polygon3DBox[{{0.8236644243122581, 0, 0.2427050983124842}, {
     0.7833514179826693, 0.2545263047745454, 0.2427050983124842}, {
     0.8628887284512825, 0.28036954353118954`, 0.285316954888546}, {
     0.9072949016875158, 0, 0.285316954888546}}], 
   Polygon3DBox[{{0.7833514179826693, 0.2545263047745454, 
    0.2427050983124842}, {0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.7340169943749475, 0.5332945626920711, 
    0.285316954888546}, {0.8628887284512825, 0.28036954353118954`, 
    0.285316954888546}}], 
   Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}, {0.5332945626920711, 0.7340169943749475, 
    0.285316954888546}, {0.7340169943749475, 0.5332945626920711, 
    0.285316954888546}}], 
   Polygon3DBox[{{0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {0.28036954353118954`, 0.8628887284512825, 
    0.285316954888546}, {0.5332945626920711, 0.7340169943749475, 
    0.285316954888546}}], 
   Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0, 0.8236644243122581, 0.2427050983124842}, {
     0, 0.9072949016875158, 0.285316954888546}, {0.28036954353118954`, 
     0.8628887284512825, 0.285316954888546}}], 
   Polygon3DBox[{{
     0, 0.8236644243122581, 0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, 0.2427050983124842}, {-0.28036954353118954`, 
     0.8628887284512825, 0.285316954888546}, {
     0, 0.9072949016875158, 0.285316954888546}}], 
   Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}, {-0.5332945626920711, 0.7340169943749475, 
    0.285316954888546}, {-0.28036954353118954`, 0.8628887284512825, 
    0.285316954888546}}], 
   Polygon3DBox[{{-0.48413780144871527`, 0.6663585169306744, 
    0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.7340169943749475, 0.5332945626920711, 
    0.285316954888546}, {-0.5332945626920711, 0.7340169943749475, 
    0.285316954888546}}], 
   Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.7833514179826693, 0.2545263047745454, 
    0.2427050983124842}, {-0.8628887284512825, 0.28036954353118954`, 
    0.285316954888546}, {-0.7340169943749475, 0.5332945626920711, 
    0.285316954888546}}], 
   Polygon3DBox[{{-0.7833514179826693, 0.2545263047745454, 
     0.2427050983124842}, {-0.8236644243122581, 0, 
      0.2427050983124842}, {-0.9072949016875158, 0, 
      0.285316954888546}, {-0.8628887284512825, 0.28036954353118954`, 
     0.285316954888546}}], 
   Polygon3DBox[{{-0.8236644243122581, 0, 
      0.2427050983124842}, {-0.7833514179826693, -0.2545263047745454, 
     0.2427050983124842}, {-0.8628887284512825, -0.28036954353118954`, 
     0.285316954888546}, {-0.9072949016875158, 0, 0.285316954888546}}], 
   Polygon3DBox[{{-0.7833514179826693, -0.2545263047745454, 
    0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.7340169943749475, -0.5332945626920711, 
    0.285316954888546}, {-0.8628887284512825, -0.28036954353118954`, 
    0.285316954888546}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}, {-0.5332945626920711, -0.7340169943749475, 
    0.285316954888546}, {-0.7340169943749475, -0.5332945626920711, 
    0.285316954888546}}], 
   Polygon3DBox[{{-0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {-0.28036954353118954`, -0.8628887284512825, 
    0.285316954888546}, {-0.5332945626920711, -0.7340169943749475, 
    0.285316954888546}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0, -0.8236644243122581, 0.2427050983124842}, {
     0, -0.9072949016875158, 
      0.285316954888546}, {-0.28036954353118954`, -0.8628887284512825, 
     0.285316954888546}}], 
   Polygon3DBox[{{0, -0.8236644243122581, 0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, 0.2427050983124842}, {
     0.28036954353118954`, -0.8628887284512825, 0.285316954888546}, {
     0, -0.9072949016875158, 0.285316954888546}}], 
   Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}, {0.5332945626920711, -0.7340169943749475, 
    0.285316954888546}, {0.28036954353118954`, -0.8628887284512825, 
    0.285316954888546}}], 
   Polygon3DBox[{{0.48413780144871527`, -0.6663585169306744, 
    0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.7340169943749475, -0.5332945626920711, 
    0.285316954888546}, {0.5332945626920711, -0.7340169943749475, 
    0.285316954888546}}], 
   Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.7833514179826693, -0.2545263047745454, 
    0.2427050983124842}, {0.8628887284512825, -0.28036954353118954`, 
    0.285316954888546}, {0.7340169943749475, -0.5332945626920711, 
    0.285316954888546}}], 
   Polygon3DBox[{{0.7833514179826693, -0.2545263047745454, 
     0.2427050983124842}, {0.8236644243122581, 0, 0.2427050983124842}, {
     0.9072949016875158, 0, 0.285316954888546}, {
     0.8628887284512825, -0.28036954353118954`, 0.285316954888546}}], 
   Polygon3DBox[
    NCache[{{0.9072949016875158, 0, 0.285316954888546}, {0.8628887284512825, 
      0.28036954353118954`, 
      0.285316954888546}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.3}, {
      1, 0, 0.3}}, {{0.9072949016875158, 0, 0.285316954888546}, {
      0.8628887284512825, 0.28036954353118954`, 0.285316954888546}, {
      0.9510565162951535, 0.30901699437494745`, 0.3}, {1, 0, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.8628887284512825, 0.28036954353118954`, 0.285316954888546}, {
      0.7340169943749475, 0.5332945626920711, 0.285316954888546}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.3}}, {{
     0.8628887284512825, 0.28036954353118954`, 0.285316954888546}, {
     0.7340169943749475, 0.5332945626920711, 0.285316954888546}, {
     0.8090169943749475, 0.5877852522924731, 0.3}, {0.9510565162951535, 
     0.30901699437494745`, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.7340169943749475, 0.5332945626920711, 0.285316954888546}, {
      0.5332945626920711, 0.7340169943749475, 
      0.285316954888546}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}}, {{
     0.7340169943749475, 0.5332945626920711, 0.285316954888546}, {
     0.5332945626920711, 0.7340169943749475, 0.285316954888546}, {
     0.5877852522924731, 0.8090169943749475, 0.3}, {0.8090169943749475, 
     0.5877852522924731, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.5332945626920711, 0.7340169943749475, 0.285316954888546}, {
      0.28036954353118954`, 0.8628887284512825, 0.285316954888546}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0.3}}, {{
     0.5332945626920711, 0.7340169943749475, 0.285316954888546}, {
     0.28036954353118954`, 0.8628887284512825, 0.285316954888546}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.5877852522924731, 
     0.8090169943749475, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.28036954353118954`, 0.8628887284512825, 0.285316954888546}, {
      0, 0.9072949016875158, 0.285316954888546}, {0, 1, 0.3}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}}, {{
      0.28036954353118954`, 0.8628887284512825, 0.285316954888546}, {
      0, 0.9072949016875158, 0.285316954888546}, {0, 1, 0.3}, {
      0.30901699437494745`, 0.9510565162951535, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0, 0.9072949016875158, 
       0.285316954888546}, {-0.28036954353118954`, 0.8628887284512825, 
      0.285316954888546}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {
      0, 1, 0.3}}, {{
      0, 0.9072949016875158, 0.285316954888546}, {-0.28036954353118954`, 
      0.8628887284512825, 0.285316954888546}, {-0.30901699437494745`, 
      0.9510565162951535, 0.3}, {0, 1, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.28036954353118954`, 0.8628887284512825, 
      0.285316954888546}, {-0.5332945626920711, 0.7340169943749475, 
      0.285316954888546}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}}, {{-0.28036954353118954`, 0.8628887284512825, 
     0.285316954888546}, {-0.5332945626920711, 0.7340169943749475, 
     0.285316954888546}, {-0.5877852522924731, 0.8090169943749475, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.5332945626920711, 0.7340169943749475, 
      0.285316954888546}, {-0.7340169943749475, 0.5332945626920711, 
      0.285316954888546}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
       0.3}}, {{-0.5332945626920711, 0.7340169943749475, 
     0.285316954888546}, {-0.7340169943749475, 0.5332945626920711, 
     0.285316954888546}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.5877852522924731, 0.8090169943749475, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.7340169943749475, 0.5332945626920711, 
      0.285316954888546}, {-0.8628887284512825, 0.28036954353118954`, 
      0.285316954888546}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}}, {{-0.7340169943749475, 0.5332945626920711, 
     0.285316954888546}, {-0.8628887284512825, 0.28036954353118954`, 
     0.285316954888546}, {-0.9510565162951535, 0.30901699437494745`, 
     0.3}, {-0.8090169943749475, 0.5877852522924731, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.8628887284512825, 0.28036954353118954`, 
      0.285316954888546}, {-0.9072949016875158, 0, 0.285316954888546}, {-1, 0,
        0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 
       0.3}}, {{-0.8628887284512825, 0.28036954353118954`, 
      0.285316954888546}, {-0.9072949016875158, 0, 0.285316954888546}, {-1, 0,
        0.3}, {-0.9510565162951535, 0.30901699437494745`, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.9072949016875158, 0, 
       0.285316954888546}, {-0.8628887284512825, -0.28036954353118954`, 
      0.285316954888546}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 - 5^Rational[1, 2]), 0.3}, {-1, 0, 
       0.3}}, {{-0.9072949016875158, 0, 
       0.285316954888546}, {-0.8628887284512825, -0.28036954353118954`, 
      0.285316954888546}, {-0.9510565162951535, -0.30901699437494745`, 
      0.3}, {-1, 0, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.8628887284512825, -0.28036954353118954`, 
      0.285316954888546}, {-0.7340169943749475, -0.5332945626920711, 
      0.285316954888546}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       0.3}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 
       0.3}}, {{-0.8628887284512825, -0.28036954353118954`, 
     0.285316954888546}, {-0.7340169943749475, -0.5332945626920711, 
     0.285316954888546}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.9510565162951535, -0.30901699437494745`, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.7340169943749475, -0.5332945626920711, 
      0.285316954888546}, {-0.5332945626920711, -0.7340169943749475, 
      0.285316954888546}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0.3}}, {{-0.7340169943749475, -0.5332945626920711, 
     0.285316954888546}, {-0.5332945626920711, -0.7340169943749475, 
     0.285316954888546}, {-0.5877852522924731, -0.8090169943749475, 
     0.3}, {-0.8090169943749475, -0.5877852522924731, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.5332945626920711, -0.7340169943749475, 
      0.285316954888546}, {-0.28036954353118954`, -0.8628887284512825, 
      0.285316954888546}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       0.3}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
       0.3}}, {{-0.5332945626920711, -0.7340169943749475, 
     0.285316954888546}, {-0.28036954353118954`, -0.8628887284512825, 
     0.285316954888546}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.5877852522924731, -0.8090169943749475, 0.3}}]], 
   Polygon3DBox[
    NCache[{{-0.28036954353118954`, -0.8628887284512825, 0.285316954888546}, {
      0, -0.9072949016875158, 0.285316954888546}, {0, -1, 0.3}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0.3}}, {{-0.28036954353118954`, -0.8628887284512825, 
      0.285316954888546}, {0, -0.9072949016875158, 0.285316954888546}, {
      0, -1, 0.3}, {-0.30901699437494745`, -0.9510565162951535, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0, -0.9072949016875158, 0.285316954888546}, {
      0.28036954353118954`, -0.8628887284512825, 0.285316954888546}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}, {
      0, -1, 0.3}}, {{0, -0.9072949016875158, 0.285316954888546}, {
      0.28036954353118954`, -0.8628887284512825, 0.285316954888546}, {
      0.30901699437494745`, -0.9510565162951535, 0.3}, {0, -1, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.28036954353118954`, -0.8628887284512825, 0.285316954888546}, {
      0.5332945626920711, -0.7340169943749475, 
      0.285316954888546}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}}, {{
     0.28036954353118954`, -0.8628887284512825, 0.285316954888546}, {
     0.5332945626920711, -0.7340169943749475, 0.285316954888546}, {
     0.5877852522924731, -0.8090169943749475, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.5332945626920711, -0.7340169943749475, 0.285316954888546}, {
      0.7340169943749475, -0.5332945626920711, 0.285316954888546}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.3}}, {{
     0.5332945626920711, -0.7340169943749475, 0.285316954888546}, {
     0.7340169943749475, -0.5332945626920711, 0.285316954888546}, {
     0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.5877852522924731, -0.8090169943749475, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.7340169943749475, -0.5332945626920711, 0.285316954888546}, {
      0.8628887284512825, -0.28036954353118954`, 
      0.285316954888546}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0.3}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0.3}}, {{
     0.7340169943749475, -0.5332945626920711, 0.285316954888546}, {
     0.8628887284512825, -0.28036954353118954`, 0.285316954888546}, {
     0.9510565162951535, -0.30901699437494745`, 0.3}, {
     0.8090169943749475, -0.5877852522924731, 0.3}}]], 
   Polygon3DBox[
    NCache[{{0.8628887284512825, -0.28036954353118954`, 0.285316954888546}, {
      0.9072949016875158, 0, 0.285316954888546}, {
      1, 0, 0.3}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0.3}}, {{
      0.8628887284512825, -0.28036954353118954`, 0.285316954888546}, {
      0.9072949016875158, 0, 0.285316954888546}, {1, 0, 0.3}, {
      0.9510565162951535, -0.30901699437494745`, 0.3}}]]},
  AspectRatio->1,
  Boxed->False]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Und als ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 ". "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"torusFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t_", ",", "u_"}], "}"}], ",", "s_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"b", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"r", "+", 
      RowBox[{"s", " ", "r", "*", 
       RowBox[{"Sin", "[", "u", "]"}]}], "+", 
      RowBox[{"s", " ", "b", "*", 
       RowBox[{"Cos", "[", "u", "]"}]}]}], "//", "N"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Torus", "[", 
   RowBox[{"s_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"GitterComplexPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"torusFunction", "[", 
      RowBox[{"#", ",", "s", ",", "d"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", "d", ",", "d"}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g5", "=", 
   RowBox[{"Torus", "[", 
    RowBox[{".4", ",", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{"g5", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{1., 0., 0.4}, {1.3804226065180614`, 0., 
   0.12360679774997899`}, {1.2351141009169893`, 0., -0.323606797749979}, {
   0.7648858990830107, 0., -0.323606797749979}, {0.6195773934819386, 0., 
   0.12360679774997899`}, {1., 0., 0.4}, {0.30901699437494745`, 
   0.9510565162951535, 0.4}, {0.4265740448334421, 1.312859915170143, 
   0.12360679774997899`}, {0.38167124717548356`, 
   1.1746633140451326`, -0.323606797749979}, {0.23636274157441134`, 
   0.7274497185451746, -0.323606797749979}, {0.19145994391645282`, 
   0.5892531174201641, 0.12360679774997899`}, {0.30901699437494745`, 
   0.9510565162951535, 0.4}, {-0.8090169943749475, 0.5877852522924731, 
   0.4}, {-1.1167853480924728`, 0.8113920500424521, 
   0.12360679774997899`}, {-0.9992282976339781, 
   0.7259818534174837, -0.323606797749979}, {-0.6188056911159168, 
   0.4495886511674626, -0.323606797749979}, {-0.5012486406574221, 
   0.3641784545424942, 0.12360679774997899`}, {-0.8090169943749475, 
   0.5877852522924731, 0.4}, {-0.8090169943749475, -0.5877852522924731, 
   0.4}, {-1.1167853480924728`, -0.8113920500424521, 
   0.12360679774997899`}, {-0.9992282976339781, -0.7259818534174837, \
-0.323606797749979}, {-0.6188056911159168, -0.4495886511674626, \
-0.323606797749979}, {-0.5012486406574221, -0.3641784545424942, 
   0.12360679774997899`}, {-0.8090169943749475, -0.5877852522924731, 0.4}, {
   0.30901699437494745`, -0.9510565162951535, 0.4}, {
   0.4265740448334421, -1.312859915170143, 0.12360679774997899`}, {
   0.38167124717548356`, -1.1746633140451326`, -0.323606797749979}, {
   0.23636274157441134`, -0.7274497185451746, -0.323606797749979}, {
   0.19145994391645282`, -0.5892531174201641, 0.12360679774997899`}, {
   0.30901699437494745`, -0.9510565162951535, 0.4}, {1., 0., 0.4}, {
   1.3804226065180614`, 0., 0.12360679774997899`}, {1.2351141009169893`, 
   0., -0.323606797749979}, {0.7648858990830107, 0., -0.323606797749979}, {
   0.6195773934819386, 0., 0.12360679774997899`}, {1., 0., 
   0.4}}, {Polygon3DBox[{1, 2, 8, 7}], Polygon3DBox[{2, 3, 9, 8}], 
    Polygon3DBox[{3, 4, 10, 9}], Polygon3DBox[{4, 5, 11, 10}], 
    Polygon3DBox[{5, 6, 12, 11}], Polygon3DBox[{7, 8, 14, 13}], 
    Polygon3DBox[{8, 9, 15, 14}], Polygon3DBox[{9, 10, 16, 15}], 
    Polygon3DBox[{10, 11, 17, 16}], Polygon3DBox[{11, 12, 18, 17}], 
    Polygon3DBox[{13, 14, 20, 19}], Polygon3DBox[{14, 15, 21, 20}], 
    Polygon3DBox[{15, 16, 22, 21}], Polygon3DBox[{16, 17, 23, 22}], 
    Polygon3DBox[{17, 18, 24, 23}], Polygon3DBox[{19, 20, 26, 25}], 
    Polygon3DBox[{20, 21, 27, 26}], Polygon3DBox[{21, 22, 28, 27}], 
    Polygon3DBox[{22, 23, 29, 28}], Polygon3DBox[{23, 24, 30, 29}], 
    Polygon3DBox[{25, 26, 32, 31}], Polygon3DBox[{26, 27, 33, 32}], 
    Polygon3DBox[{27, 28, 34, 33}], Polygon3DBox[{28, 29, 35, 34}], 
    Polygon3DBox[{29, 30, 36, 35}]}],
  AspectRatio->1,
  Boxed->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Die Farbsysteme von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section"],

Cell[CellGroupData[{

Cell["Die verschiedenen Farbsysteme", "Subsection"],

Cell["\<\
Die Farbsysteme RGB und CMYK entsprechen einander nicht genau. -- Nun doch.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Cyan", ",", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{
   RasterBox[{{{1., 1., 0.}, {1., 1., 0.}}, {{1., 0., 1.}, {1., 0., 1.}}, {{
    0., 1., 1.}, {0., 1., 1.}}}, {{0, 0}, {2, 3}}, {0, 1}], {
    {GrayLevel[
      NCache[-1 + GoldenRatio, 0.6180339887498949]], 
     StyleBox[
      LineBox[{{{0, 3}, {2, 3}}, {{0, 2}, {2, 2}}, {{0, 1}, {2, 1}}, {{0, 
       0}, {2, 0}}}],
      Antialiasing->False]}, 
    {GrayLevel[
      NCache[-1 + GoldenRatio, 0.6180339887498949]], 
     StyleBox[LineBox[{{{0, 0}, {0, 3}}, {{1, 0}, {1, 3}}, {{2, 0}, {2, 3}}}],
      
      Antialiasing->False]}}},
  Frame->False,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Der Zusammenhang zwischen ",
 StyleBox["Hue",
  FontWeight->"Bold"],
 " und RGB:"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Hue", "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Red", ",", "Yellow", ",", "Green", ",", "Cyan", ",", "Blue", ",", 
           "Magenta", ",", "Red"}], "}"}], ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}]}], "}"}],
    ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{
   RasterBox[{{{1., 0., 0.}, {1., 0.6000000000000001, 0.}, {
    0.7999999999999998, 1., 0.}, {0.19999999999999962`, 1., 0.}, {0., 1., 
    0.4000000000000002}, {0., 1., 1.}, {0., 0.39999999999999936`, 1.}, {
    0.20000000000000054`, 0., 1.}, {0.8000000000000002, 0., 1.}, {1., 0., 
    0.6}, {1., 0., 0.}}, {{1., 0., 0.}, {1., 0.6000000000000001, 0.}, {
    0.7999999999999998, 1., 0.}, {0.19999999999999973`, 1., 0.}, {0., 1., 
    0.40000000000000036`}, {0., 1., 1.}, {0., 0.39999999999999947`, 1.}, {
    0.20000000000000018`, 0., 1.}, {0.8000000000000007, 0., 1.}, {1., 0., 
    0.5999999999999996}, {1., 0., 0.}}}, {{0, 0}, {11, 2}}, {0, 1}], {
    {GrayLevel[
      NCache[-1 + GoldenRatio, 0.6180339887498949]], 
     StyleBox[
      LineBox[{{{0, 2}, {11, 2}}, {{0, 1}, {11, 1}}, {{0, 0}, {11, 0}}}],
      Antialiasing->False]}, 
    {GrayLevel[
      NCache[-1 + GoldenRatio, 0.6180339887498949]], 
     StyleBox[
      LineBox[{{{0, 0}, {0, 2}}, {{1, 0}, {1, 2}}, {{2, 0}, {2, 2}}, {{3, 
       0}, {3, 2}}, {{4, 0}, {4, 2}}, {{5, 0}, {5, 2}}, {{6, 0}, {6, 2}}, {{7,
        0}, {7, 2}}, {{8, 0}, {8, 2}}, {{9, 0}, {9, 2}}, {{10, 0}, {10, 
       2}}, {{11, 0}, {11, 2}}}],
      Antialiasing->False]}}},
  Frame->False,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Hue",
  FontWeight->"Bold"],
 " mit dem S\[ADoubleDot]ttigungsparameter "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "White"}], "}"}], ",", 
        RowBox[{"1", "-", "i"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{{1., 1., 1.}, {1., 0.9, 0.9}, {1., 0.8, 0.8}, {1., 0.7, 0.7}, {
   1., 0.6, 0.6}, {1., 0.5, 0.5}, {1., 0.3999999999999999, 
   0.3999999999999999}, {1., 0.29999999999999993`, 0.29999999999999993`}, {1.,
    0.19999999999999996`, 0.19999999999999996`}, {1., 0.09999999999999998, 
   0.09999999999999998}, {1., 0., 0.}}, {{1., 1., 1.}, {1., 0.9, 0.9}, {1., 
   0.8, 0.8}, {1., 0.7, 0.7}, {1., 0.6, 0.6}, {1., 0.5, 0.5}, {1., 
   0.3999999999999999, 0.3999999999999999}, {1., 0.29999999999999993`, 
   0.29999999999999993`}, {1., 0.19999999999999996`, 0.19999999999999996`}, {
   1., 0.09999999999999998, 0.09999999999999998}, {1., 0., 0.}}}, {{0, 0}, {
   11, 2}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Hue",
  FontWeight->"Bold"],
 " mit dem Helligkeitsparameter."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "1", ",", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Black"}], "}"}], ",", 
        RowBox[{"1", "-", "i"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{{0., 0., 0.}, {0.09999999999999998, 0., 0.}, {
   0.19999999999999996`, 0., 0.}, {0.30000000000000004`, 0., 0.}, {0.4, 0., 
   0.}, {0.5, 0., 0.}, {0.6000000000000001, 0., 0.}, {0.7000000000000001, 0., 
   0.}, {0.8, 0., 0.}, {0.9, 0., 0.}, {1., 0., 0.}}, {{0., 0., 0.}, {0.1, 0., 
   0.}, {0.2, 0., 0.}, {0.30000000000000004`, 0., 0.}, {0.4, 0., 0.}, {0.5, 
   0., 0.}, {0.6000000000000001, 0., 0.}, {0.7000000000000001, 0., 0.}, {0.8, 
   0., 0.}, {0.9, 0., 0.}, {1., 0., 0.}}}, {{0, 0}, {11, 2}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stellt eine gro\[SZ]e Menge von Farbpaletten aus den verschiedensten \
Anwendungsgebieten bereit. Diese k\[ODoubleDot]nnen aus der mitgelieferten ",
 StyleBox["ColorData",
  FontWeight->"Bold"],
 "-Sammlung \[UDoubleDot]ber ein Schl\[UDoubleDot]sselwort als ",
 StyleBox["ColorDataFunction",
  FontWeight->"Bold"],
 "-Objekt extrahiert werden. Eine solche ",
 StyleBox["ColorDataFunction",
  FontWeight->"Bold"],
 " ist eine Funktion aus einem meist als reelles Intervall gegebenen \
Argumentbereich in ein Farbspektrum spezieller, genauestens ausgew\
\[ADoubleDot]hlter (\"carefully chosen\") RGB-Werte."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"c", "=", 
  RowBox[{
  "ColorData", "[", "\"\<Rainbow\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"c", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".01"}], "}"}]}], "]"}], "}"}], 
   ",", 
   RowBox[{"AspectRatio", "->", ".1"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVVHk01AsDRaKiT4RUKusj5VU8IukmirI8XtPykp3X9lVk6aOSLPUQoQUV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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJwVVHk01AsDRaKiT4RUKusj5VU8IukmirI8XtPykp3X9lVk6aOSLPUQoQUV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   "], {{0, 0}, {101, 1}}, {0, 1}],
  AspectRatio->0.1,
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Gradients\"\>", ",", "\<\"Indexed\"\>", ",", "\<\"Named\"\>", 
   ",", "\<\"Physical\"\>"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<Physical\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BlackBodySpectrum\"\>", ",", "\<\"HypsometricTints\"\>", 
   ",", "\<\"VisibleSpectrum\"\>"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"380", ",", "750"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzN1f1P00ccB/AvT0UYD6KIVRgbINhIdDKUKnYcCshwIlaEOQQljGInD4WU
AAJDhIGMbUARyoMSM7PBkIRnLDIoz+IQR8tqgVKwPJVCW6hmQ0DE4dM16fkH
+Ekuubx+uNzl3vc5iyDaKYoGhmFq64OyPl7NvdzvlEc2sQD2tuqrSF96MTjA
4HgKJ96HDd3RzOyysxUPhBDKEo7EdUBvzXjeYNcwCHi79LN7uruhn/5PILN0
HwEZlbl1G/17oYcEHix3shWBvsMc7m1mP/SW8NIjpE2TIGMOF3eLOgB9S8Jm
4cHlaeDbYzq2IuVB/5dqSGhgSYCfXnpW8KFB6C/ddCOtrKXAh6xw+jtzWOmW
Wo2MXDnwYvotEAUj0N+UAjBXTnif1xciPnrOhZXujPqOTqJpJR31GtdPPWxT
0fULlw2SJjAB4smVL2qLkoYQv9Zxqa1C8gjxJrKRq6MtF3F5OzmbMXIf8d42
td0B7WzEPczF8ceuNgAjy9GfIo0qwDvPepbHoBX/8db/hD5/P6aBUJQBbg9P
U409u6C/W5Finp6/+LQPPApLqrTmzENnfJ9DaXf9B1A/sV0K3yCHrpAGJGtv
HAKr3MHDd5yl0K8zG6l2e4RAsrOG7k2bhb5ia/J87ckYqIrGogszZ6CXie4e
FQtE4HK7V/To79PQT1ZIDB+SJsAJg5vRlu2T0Om/GBJHGJMgx23A1HX7BPR8
msO5WfEU4CZqdVLoIuhsckDas0NigKdG8QyKRqHb7LWvm701A8w8t9skLyhz
JiSyF/s2zYKh4JckfTwfeiHwcKxOmQM/JE55Fzsr823feaPnqlAKMoZI2/Kd
+qCn5TWfdtGVA5BDCPmWp3xvfRTh+BpxHjBeey10c+JqRBNlQeWeMazJYmxA
PQ91H702h686UH+y+GvxNQXqb0rxwXrwUbOz5eR7QJ3ipl3zWLl/jdfOB1q9
mQZBrUq/vs9HE7SIgPZnnC2bbyq91C2Xb/rjFBAUFBz/GKd03Qss5l+RM6BN
uypAsFeZ7/AMoW/smTlQGnsvouCsMt/px3S6YspkILxY40wuRQa91g43tNwl
B9OaQTvU9yhzz8NryBIn5gGV1qaIWpxVOa8CiIbNW8bZEsRPVoamb8XPIN6f
0ujlGTWNOPhaa1tq7yTiFgD/lPRgHHH/6FpePHiMeOzFfd0JErSfEXipPfgS
tG/pRfqdj+H2IZ5De+XNiGPvrQ/HQ3Q5kio++k7cAy4YsvxQ31m9tp89No+4
ngbTvzsI9QZNK85iswzxMFy1C2GrFHHjDV+wvolSzQ2G/UzPypYOqOYDw3bR
3A/sPiBG+8VFbDyiZArxjxZau/brq+YGwyLsmzx1clVzg2Hc2Hq+0ESE+JW4
gNZA4ijidi9WlgqWVPO0/s9fKfy8/67q/4hhv+EcwnAJfMQb+YMF34XyEDer
k3kE0gcQp2WrrfomcBC3FqcpbKgPEdfpCD314EYv4vIScj2N24P43CWiiTGu
G/H/ARV7Ius=
      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalUDoubleDot]berdeckungen und Transparenz in 2D-Grafiken \
\>", "Subsection"],

Cell["\<\
Zweidimensionale Fl\[ADoubleDot]chen \[UDoubleDot]berdecken sich, was \
passiert? Hier ein Beispiel mit teilweiser Durchsichtigkeit.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{"Green", ",", "r1", ",", 
     RowBox[{"Opacity", "[", ".7", "]"}], ",", "Yellow", ",", "r2"}], "}"}], 
   "]"}]}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 1, 0], RectangleBox[{-2, -1}, {2, 1}]}, 
   {RGBColor[1, 1, 0], Opacity[0.7], 
    RectangleBox[{-1, -2}, {1, 2}]}}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ColorOutput",
  FontWeight->"Bold"],
 " funktioniert nicht und ist als obsolet markiert, aber der Ersatz ",
 StyleBox["ColorFunction",
  FontWeight->"Bold"],
 " ist noch nicht einsatzbereit.\nDer Punkt muss grau sein und nicht gr\
\[UDoubleDot]n (und ist es auch in Version 5.1)."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", ".3", "]"}], ",", "Green", ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 0], PointSize[0.3], PointBox[{0, 0}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 0], PointSize[0.3], PointBox[{0, 0}]},
  ColorOutput->GrayLevel]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Farbgebung und Rastergrafiken ", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gOut", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nk0lN//AHBLZAszYynLzKCQilZFPt6XdimlSJIKSVkTRWlRIiRLZKmI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<test.gif\>\"", ",", "gOut"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gIn", "=", 
  RowBox[{"Import", "[", "\"\<test.gif\>\"", "]"}]}]}], "Input"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnXl8VFcVxxlardgqoqFSWymlYLGllNhCUdRCtIWUGLBZTDIS0mCgQCCy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   "], {{0, 0}, {360, 217}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzFmdduXFUUhg3iAei9iEegt0CegdC7hMQ1vQd4hRSnN6644iK2U5w4cYxA
QoCQ4jjFTpzYUzwOYGJI78Ba29/Zmn9pa+CK7+aX51trnzNnztl7z/ju199c
8MaVXf9wRVfXVV2d+GP+1c6ikPjrne6Q+Nudr0O2j78xJP5G56uQ+GucnpD4
a53ekPjrnL6Q+Jud/pD425yBkPg7ncGQ7e9/KCR+8SJjKCR+yWLjm5D47qXG
tyHxNznfh8Qv6za+C4lfvcr4ISR+zWrjx5D4tWuMn0K2X5/dIfF3OD+HxD/p
DIdsvz4jIfEje5yQ7ffHaEj8885oSPzYqBMSf4szFhL/gjMWEn/ooBMSP37I
CYlft9YYD4k/PO6ExB857ITET044IfETR5yQ+Necier155zpyg/vNiZD4t9y
JkO2P1+1kPjjfxq1kPgFTj0kPs03jZD4+5xGyPb7txESv6nPaITE7x0xGiHx
aT5vhsSn+Shft9EDRr7+PRuNsr/Hqc3N27W55+do5Z92miHxp04azZD4Z5yp
kPj3namQ+C2bjamQ+A+cVkj8mdNGKyT+IWc6JP5DZzoknuupiX/bqc3Ne7W5
+edouH/3DBu1+R852af1sl7VrVppZN/bY9Sq1H5e57lRf69Tr46j46vf1m9k
/46Tn6s0f0bPONq/dIlRr+q0n3FL/X29Rr0aR/vTepH9ubNGuV89/dSpP3Hc
qFd1aX34Jcwv1KnX8fX8mW8YR/vVP+Jk/5ST5y317zqNqi6tX9kzn1GnntdL
Xvs/drJnPqROPfMhdepPnjDyvJn2P9kzX1LXyW/fZmR/v5PnXfXMh9R18gfH
jOzfc/K8qj7t95pVXSd//pwRPeOr37zJaFZ16vftNZpV3a3Or2H+p079Dc5U
VVfy5KNOuV/9A065n/WGuhed7FlvqCt58hMn++XLjLLXfh2f9YxxtH//PmOq
yrR/z/70KSP7ge1G9un7WquqU/+g06rq0v607LX/WadV1Wn/iuVGXpcvnDei
J9XTx3HUb91i5P70/e+3yh/Yb7SqOvXsB6h7zImeVJ++r00XPfsJ6l5ysme/
TF3Jk5862eu+RP3KFUbZ83pp/P6txnQ1Tvp+GD2pXvdFOwaM7M+eMcqe/Sh1
JU+qf9jJPn2/yp75SBPPfKuJZz3VxLPf4zwuXjDy8dmPUaee/VgnT6bfd2aC
5zjaz3mRen3Yb5XGZ77VxDNfaeJ5njXxnK8mnv0S5znPyefHfo069eynqHvZ
mQmfL3Xq2e+QC53YT6pnP1PqZ79CXfr+P1O8P3fuMLJnPS957nfq0u8H0ZPq
2e9wnnp+3A+lfr1vLl00Zor3T/p96ffKs16yrmo/6xX9jzu5n/WKLHnGUa/3
7StO9qw3nTypnvUE/5kTPame9YRUz3yPX7/OyJ75nLqSJzv5wZ1G9sw3zNvq
ed6pS79fRU+qZ74iL18ysud+1cTzvGjiuZ818cwXzDt6fDyZfp8+Vnn6Sv3M
F6T2cz008dRr4jmeZun6PeEcC9ev5PW6qed5Jl91smc++Lf+cyd6Uj19nJ+O
z3xAaj/PM7lhvZE9z2MnT6rneSN3DRrlfvU8b6R6vW/S77zR069e76u/Lhvl
+6uT1/E5bun9cz+Vjo/XxPN5a+L5PDTx3A+apePr+elx73Jmi+Or53po4qnX
LI2fmC2+/5Iv9et5pf8nZM/nTarXfh2f60lqv/ovnNni9VHP8cgvNxjZczxS
PX9rlsbX96fjD+0yyv3qeT+kej0v9fytWfLp/0vZ87dmyfP6f8sS/7//G8+p
kso=
      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{360, 217},
  PlotRange->{{0, 360}, {0, 217}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", 
  RowBox[{"{", 
   RowBox[{"gOut", ",", "gIn"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10032", ",", "321584"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gIn", "//", "Head"}]], "Input"],

Cell[BoxData["Graphics"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"List", "@@", 
  RowBox[{"Head", "/@", "gIn"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Raster", ",", "Rule", ",", "Rule", ",", "Rule"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gIn", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "4"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"360", ",", "217"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "217"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", "None"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"gIn", ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnXl8VFcVxxlardgqoqFSWymlYLGllNhCUdRCtIWUGLBZTDIS0mCgQCCy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   "], {{0, 0}, {360, 217}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzFmdduXFUUhg3iAei9iEegt0CegdC7hMQ1vQd4hRSnN6644iK2U5w4cYxA
QoCQ4jjFTpzYUzwOYGJI78Ba29/Zmn9pa+CK7+aX51trnzNnztl7z/ju199c
8MaVXf9wRVfXVV2d+GP+1c6ikPjrne6Q+Nudr0O2j78xJP5G56uQ+GucnpD4
a53ekPjrnL6Q+Jud/pD425yBkPg7ncGQ7e9/KCR+8SJjKCR+yWLjm5D47qXG
tyHxNznfh8Qv6za+C4lfvcr4ISR+zWrjx5D4tWuMn0K2X5/dIfF3OD+HxD/p
DIdsvz4jIfEje5yQ7ffHaEj8885oSPzYqBMSf4szFhL/gjMWEn/ooBMSP37I
CYlft9YYD4k/PO6ExB857ITET044IfETR5yQ+Necier155zpyg/vNiZD4t9y
JkO2P1+1kPjjfxq1kPgFTj0kPs03jZD4+5xGyPb7txESv6nPaITE7x0xGiHx
aT5vhsSn+Shft9EDRr7+PRuNsr/Hqc3N27W55+do5Z92miHxp04azZD4Z5yp
kPj3namQ+C2bjamQ+A+cVkj8mdNGKyT+IWc6JP5DZzoknuupiX/bqc3Ne7W5
+edouH/3DBu1+R852af1sl7VrVppZN/bY9Sq1H5e57lRf69Tr46j46vf1m9k
/46Tn6s0f0bPONq/dIlRr+q0n3FL/X29Rr0aR/vTepH9ubNGuV89/dSpP3Hc
qFd1aX34Jcwv1KnX8fX8mW8YR/vVP+Jk/5ST5y317zqNqi6tX9kzn1GnntdL
Xvs/drJnPqROPfMhdepPnjDyvJn2P9kzX1LXyW/fZmR/v5PnXfXMh9R18gfH
jOzfc/K8qj7t95pVXSd//pwRPeOr37zJaFZ16vftNZpV3a3Or2H+p079Dc5U
VVfy5KNOuV/9A065n/WGuhed7FlvqCt58hMn++XLjLLXfh2f9YxxtH//PmOq
yrR/z/70KSP7ge1G9un7WquqU/+g06rq0v607LX/WadV1Wn/iuVGXpcvnDei
J9XTx3HUb91i5P70/e+3yh/Yb7SqOvXsB6h7zImeVJ++r00XPfsJ6l5ysme/
TF3Jk5862eu+RP3KFUbZ83pp/P6txnQ1Tvp+GD2pXvdFOwaM7M+eMcqe/Sh1
JU+qf9jJPn2/yp75SBPPfKuJZz3VxLPf4zwuXjDy8dmPUaee/VgnT6bfd2aC
5zjaz3mRen3Yb5XGZ77VxDNfaeJ5njXxnK8mnv0S5znPyefHfo069eynqHvZ
mQmfL3Xq2e+QC53YT6pnP1PqZ79CXfr+P1O8P3fuMLJnPS957nfq0u8H0ZPq
2e9wnnp+3A+lfr1vLl00Zor3T/p96ffKs16yrmo/6xX9jzu5n/WKLHnGUa/3
7StO9qw3nTypnvUE/5kTPame9YRUz3yPX7/OyJ75nLqSJzv5wZ1G9sw3zNvq
ed6pS79fRU+qZ74iL18ysud+1cTzvGjiuZ818cwXzDt6fDyZfp8+Vnn6Sv3M
F6T2cz008dRr4jmeZun6PeEcC9ev5PW6qed5Jl91smc++Lf+cyd6Uj19nJ+O
z3xAaj/PM7lhvZE9z2MnT6rneSN3DRrlfvU8b6R6vW/S77zR069e76u/Lhvl
+6uT1/E5bun9cz+Vjo/XxPN5a+L5PDTx3A+apePr+elx73Jmi+Or53po4qnX
LI2fmC2+/5Iv9et5pf8nZM/nTarXfh2f60lqv/ovnNni9VHP8cgvNxjZczxS
PX9rlsbX96fjD+0yyv3qeT+kej0v9fytWfLp/0vZ87dmyfP6f8sS/7//G8+p
kso=
      "], #]]& ),
   ColorFunctionScaling->False],
  Axes->True,
  Background->None,
  ImageSize->{360, 217},
  PlotRange->{{0, 360}, {0, 217}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"gIn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"List", "@@", 
  RowBox[{"Head", "/@", "r"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"List", ",", "List", ",", "Rule", ",", "Rule"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "//", 
  "Dimensions"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"217", ",", "360"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"360", ",", "217"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"r", "\[LeftDoubleBracket]", 
    RowBox[{"4", ",", "2"}], "\[RightDoubleBracket]"}]}], ";"}], "\n", 
 RowBox[{"c", "//", "Short"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   RowBox[{"RGBColor", "@@", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"\[LeftSkeleton]", "254", "\[RightSkeleton]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}], 
     "\[LeftDoubleBracket]", "#1", "\[RightDoubleBracket]"}]}], "&"}],
  Short]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"5", ",", "9"}], "]"}], ",", 
    RowBox[{"Range", "[", 
     RowBox[{"7", ",", "12"}], "]"}]}], "\[RightDoubleBracket]"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"251", "251", "251", "251", "251", "251"},
     {"251", "221", "48", "1", "49", "221"},
     {"251", "251", "251", "1", "251", "251"},
     {"251", "251", "251", "1", "251", "251"},
     {"251", "251", "251", "1", "251", "251"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{
    RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "\[LeftDoubleBracket]", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"5", ",", "25"}], "]"}], ",", 
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", "55"}], "]"}]}], "\[RightDoubleBracket]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{"r1", "/", "300"}], "]"}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[
  RasterBox[
   NCache[{{Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[1, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[221, 300], Rational[4, 25], Rational[1, 300], Rational[
      49, 300], Rational[221, 300], Rational[251, 300], Rational[1, 15], 
      Rational[251, 300], Rational[63, 100], Rational[1, 10], Rational[4, 25],
       Rational[1, 10], Rational[19, 30], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[1, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[38, 75], 
      Rational[251, 300], Rational[9, 100], Rational[31, 150], Rational[
      251, 300], Rational[61, 300], Rational[29, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[1, 300], Rational[1, 300], Rational[1, 300],
       Rational[1, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[1, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[13, 300], Rational[221, 300], Rational[251, 300], 
      Rational[33, 50], Rational[1, 20], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[1, 300], Rational[1, 300], 
      Rational[1, 300], Rational[1, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[7, 300], Rational[247, 300], Rational[
      251, 300], Rational[241, 300], Rational[2, 75], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[7, 150], Rational[197, 300], Rational[
      251, 300], Rational[49, 75], Rational[1, 20], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[83, 100], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[7, 75], Rational[31, 150], Rational[
      251, 300], Rational[61, 300], Rational[29, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[37, 50], Rational[2, 15], Rational[3, 100], Rational[251, 300],
       Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[19, 30], Rational[31, 300], Rational[49, 300], 
      Rational[31, 300], Rational[191, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[1, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      1, 300], Rational[1, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}, {
     Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[1, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300], Rational[251, 300], 
      Rational[251, 300], Rational[251, 300], Rational[251, 300], Rational[
      251, 300], Rational[251, 300], Rational[251, 300]}}, CompressedData["
1:eJxTTMoPSmViYGAQBWJzID42KV7n59FX9kON9pd+saXRL3vA3THU6MkgatJz
+2qRde4Pq47AwxFESr84ApeHqRcEg41wvmZM/6GvGk/sZ80EgZ1wc2B8FzB4
MhpvA5z+zS9kMs81ewDnc11fXGDLtd2+5JbDct6SU3BxdqvcBZfZTtnvj/jU
rbp/x2i8ERnuuGhql1sG0/4kndRfhpEv5VtfB+6QewrNdyvJdu9ovFInv6HT
T8W96zY+mW4fCcpWEQjxraBidstLqHmzR/PboIy35fbAwhNYgj6Fi0PqxydE
57eB9vdQpUGti5h+cuNttH6jNw1q/Ymsew5tJx603yEHqpjmEa0f1l6ExNsu
eDsUxk8AqpoUP9qeHG70aLwNTXo03oYmPRpvQ5MejbehSY/G29CkR8dHhiY9
Gk9Dkx6Nt6FJj8bb0KRH421o0qPxNjTp0XgbmvRIjzcAlwtKkw==
    "]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{
    RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
    
    RowBox[{"ColorFunction", "->", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GrayLevel", "[", 
        RowBox[{"#", "/", "256"}], "]"}], "&"}], ")"}]}]}], "]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnXl8VFcVxxlardgqoqFSWymlYLGllNhCUdRCtIWUGLBZTDIS0mCgQCCy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   "],
   ColorFunction->(GrayLevel[#/256]& )]]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gIn", "=", 
  RowBox[{"Import", "[", "\"\<ExampleData/rose.gif\>\"", "]"}]}]], "Input",
 CellID->1193134083],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztvXt8U+eZLjq2jCWFlrAP7dj4tg/YartP6yQmO/u0TXJCwMzunn3CJKTM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   "], {{0, 0}, {223, 164}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzFlzmOFEEQRRvEATBxOUnfgSMgYXMVZmGTQOojYDCLiYGBgdFCLcQswNDs
wyIOwAyQ3Xpdypf1p8YjnFL16x8RGRm51NXrN6/duDj6ZxdGo0ujzi4vbDIe
VfZr9X5lYbsNX+oejc/mk/HtzWJPo37tVrEnq3dz9ObEvX+v2LPGP36THv7w
QbHn0T96/m+O3tzxzck7cX7nf0O8rnPnP/G7d4q9XM2T63ewvzDVxfWdqr6T
sTnx6z7p/Kf+ePtmYZFTD+Kk+jhP6zfWi72I9YOfPX+zQX3dp62ePoLXcadN
/er6zJr+Nbe+rluqzzTWB04fDek9PuvN914tLNaX8aX41if/KT79yf+Snv+Z
k1/S13WfrepU9+9sld8Q5x3O7346Pvkl//U6bf0n/vpwYdE/nKe562//cPQe
n/0n7j5K4yMPc48z5ce7+yPx5fwcxfN1fa3Yu8iX9ZzH/ROezs+tx8U+RD28
7uuO72wX+xT57k6xz5EzPvrC+xv5133Tjo8+T/r+c7CLD/f+ab059Un5bW8V
+xg59RnS133b8nQ+4L9eV238Wj9p9OeN7/rYf6ov68oc/3CPD95/j+niJz18
SA93fu4fn0+Mr/8e1I7P9w+Pz9zjS3r2H8dHn7jj+3yj/9Gbo2cfNHf8/vP3
i/aHrj/394p9jevHfEjv+V+O+3jQf1of5vZ/eFDsW9yfTn4X+x79m6f8U3+j
r8+lzv/pSbEf5+b2/+e02M9BTn+k8af1B0dvbv/mzE9an66f1xec/jW3f38f
wNEnTv7mjm/O/KT17fqZo0/ceq9f6/u/f+aq77Th6H1/5P6U7qfwdP9j//J3
FJz9KXH2p5QfvztPc84R3h0fvetH/fvvkV3/998ju/5J/tHD0/zjP81/4vaf
9PRB0ide3w+PmvnnfKrHN4t6z5+556++v84bTv9RH39fkF/i3L8Tt3/2AXPy
G+LOv77ftry+37b+3X9eP6wv8u//PjyO81ef3/OGu38d3zzpNzeKvY/c3xGp
f62H199p7fjS/Nf3p3n4fj1e5W/O/SRx+0/zi97c/s29/h0fnvTk53uq4/ue
7PlD7/ien8R9z3f+Kb71Q9zrz+cL6wRe9/189e71T32tJy4cP3DevQ8ljh84
+wc8xfc+lPTm/O6nOf7N8Z84v7NP8269/cDR+X+pv10f1p/PudT/iZOHOfHh
rq/15u5/+6e/fQ9K3P7N3V/kn+YP7j5K3PNn7vmjPt5HnT/fAc7feucHRz/E
nT/9A3f+zs/6+vvvuOHsr0P+0SeOn7Q+8M97Gh9P6/0/6z0PiQ/peXd9kv/6
+7jNz/Wz3vVLes+z4zuP5D+Nz09z9gmeyb/1zn+I84Sf75ns//O/eAO3Yg==

      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{223, 164},
  PlotRange->{{0, 223}, {0, 164}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"gIn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Raster", "[", 
    RowBox[{
     RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",",
      
     RowBox[{"ColorFunction", "->", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"GrayLevel", "[", 
         RowBox[{"#", "/", "256"}], "]"}], "&"}], ")"}]}]}], "]"}], ",", " ", 
   
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztvXt8U+eZLjq2jCWFlrAP7dj4tg/YartP6yQmO/u0TXJCwMzunn3CJKTM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   "],
   ColorFunction->(GrayLevel[#/256]& )],
  Axes->True]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Das Beleuchtungsmodell", "Section"],

Cell[CellGroupData[{

Cell["Visualisierung der Standardbeleuchtung ", "Subsection"],

Cell["\<\
Standard-Lichtquellen auf einer stark spiegelnden Kugel: Ambientes Licht und \
drei (die Dokumentation behauptet vier) Lichtquellen in den Farben Rot, Gr\
\[UDoubleDot]n, Blau, die mit der Kamera starr verbunden sind.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"1", ",", "300"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}]], "Input",
 CellID->1315025100],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 300], SphereBox[{0, 0, 0}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{"g", ",", 
   RowBox[{"viewOptions", "=", 
    RowBox[{"{", 
     RowBox[{"ViewPoint", ",", "ViewCenter", ",", "ViewVertical"}], "}"}]}]}],
   "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.3`", ",", 
      RowBox[{"-", "2.4`"}], ",", "2.`"}], "}"}]}], ",", 
   RowBox[{"ViewCenter", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}]}], ",", 
   RowBox[{"ViewVertical", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ImageScaled",
  FontWeight->"Bold"],
 " ist angeblich relativ zum ",
 StyleBox["ImageSize",
  FontWeight->"Bold"],
 ". Im 2D-Fall ist plausibel, was darunter zu verstehen ist, nicht aber im \
3D-Fall."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"ImageScaled", "/@", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", "0.1"}], "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
    "v"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{LineBox[{ImageScaled[{1, 0}], ImageScaled[{0.1, 0.1}]}], 
   LineBox[{ImageScaled[{0, 1}], ImageScaled[{0.1, 0.1}]}]},
  Axes->True]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Obwohl ",
 StyleBox["ImageScaled",
  FontWeight->"Bold"],
 " ... und sie bewegt sich doch."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"ImageScaled", "/@", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "]"}], "&"}], "/@",
     "v"}], ",", 
   RowBox[{"Boxed", "->", "False"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[{Line3DBox[{ImageScaled[{1, 0, 0}], ImageScaled[{0, 0, 0}]}], 
   Line3DBox[{ImageScaled[{0, 1, 0}], ImageScaled[{0, 0, 0}]}], 
   Line3DBox[{ImageScaled[{0, 0, 1}], ImageScaled[{0, 0, 0}]}]},
  Boxed->False]], "Output"]
}, Open  ]],

Cell["\<\
Fr\[UDoubleDot]her gab es drei Lichtquellen. Ist auch jetzt noch so im \
Gegensatz zur Beschreibung im Hilfesystem. Allein ambientes Licht scheint \
noch eine weitere Portion dabei zu sein. 
Der eps-Export funktioniert hier nicht richtig - die Spielegeffekte werden \
falsch dargestellt.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l0", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Ambient\>\"", ",", 
     RowBox[{"GrayLevel", "[", "0.1", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"ImageScaled", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"u", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"g", ",", 
      RowBox[{"Show", "[", 
       RowBox[{"g", ",", 
        RowBox[{"Lighting", "\[Rule]", "l"}]}], "]"}], ",", 
      RowBox[{"Show", "[", 
       RowBox[{"g", ",", 
        RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}], "}"}], 
    "}"}], "]"}]}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[
      {GrayLevel[0.5], Specularity[
        GrayLevel[1], 300], SphereBox[{0, 0, 0}]}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[
      {GrayLevel[0.5], Specularity[
        GrayLevel[1], 300], SphereBox[{0, 0, 0}]},
      Lighting->{{"Directional", 
         RGBColor[1, 0, 0], {
          ImageScaled[{1, 0, 1}], 
          ImageScaled[{0.5, 0.5, 0.5}]}}, {"Directional", 
         RGBColor[0, 1, 0], {
          ImageScaled[{1, 1, 1}], 
          ImageScaled[{0.5, 0.5, 0.5}]}}, {"Directional", 
         RGBColor[0, 0, 1], {
          ImageScaled[{0, 1, 1}], 
          ImageScaled[{0.5, 0.5, 0.5}]}}}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[
      {GrayLevel[0.5], Specularity[
        GrayLevel[1], 300], SphereBox[{0, 0, 0}]},
      Lighting->"Neutral"], {967.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output"]
}, Open  ]],

Cell["\<\
Leider funktioniert der eps-Export dieser Grafik nicht. Deshalb der Umweg \
\[UDoubleDot]ber eine jpg-Grafik mit leidlicher Aufl\[ODoubleDot]sung. Bei gr\
\[ODoubleDot]\[SZ]eren Aufl\[ODoubleDot]sungen hat auch der jpg-Export so \
seine Probleme.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.jpg\>\"", ",", "u", ",", 
   RowBox[{"ImageSize", "->", 
    RowBox[{"30", 
     RowBox[{"{", 
      RowBox[{"60", ",", "25"}], "}"}]}]}]}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Probleme mit der Beleuchtung (1)", "Subsection"],

Cell[TextData[{
 "Obwohl ",
 StyleBox["ImageScaled",
  FontWeight->"Bold"],
 " bewegen sich die Lichtreflexe mit der Grafik und sind au\[SZ]erdem an der \
falschen Stelle."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 300], SphereBox[{0, 0, 0}]},
  Axes->True,
  Lighting->{{"Point", 
     RGBColor[1, 0, 0], 
     ImageScaled[{1, 0, 1}]}, {"Point", 
     RGBColor[0, 1, 0], 
     ImageScaled[{1, 1, 1}]}, {"Point", 
     RGBColor[0, 0, 1], 
     ImageScaled[{0, 1, 1}]}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Hier werden absolute Koordinaten f\[UDoubleDot]r die Lichtquellenpunkte \
verwendet und es sieht gut aus.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 300], SphereBox[{0, 0, 0}]},
  Axes->True,
  Lighting->{{"Point", 
     RGBColor[1, 0, 0], {1, 0, 1}}, {"Point", 
     RGBColor[0, 1, 0], {1, 1, 1}}, {"Point", 
     RGBColor[0, 0, 1], {0, 1, 1}}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Mit Spot-Licht ist es nicht viel anders.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"ImageScaled", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"50", "\[Degree]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 300], SphereBox[{0, 0, 0}]},
  Axes->True,
  Lighting->NCache[{{"Spot", 
      RGBColor[1, 0, 0], {
       ImageScaled[{1, 0, 1}], 
       ImageScaled[{0.5, 0.5, 0.5}]}, 50 Degree}, {"Spot", 
      RGBColor[0, 1, 0], {
       ImageScaled[{1, 1, 1}], 
       ImageScaled[{0.5, 0.5, 0.5}]}, 50 Degree}, {"Spot", 
      RGBColor[0, 0, 1], {
       ImageScaled[{0, 1, 1}], 
       ImageScaled[{0.5, 0.5, 0.5}]}, 50 Degree}}, {{"Spot", 
      RGBColor[1, 0, 0], {
       ImageScaled[{1, 0, 1}], 
       ImageScaled[{0.5, 0.5, 0.5}]}, 0.8726646259971648}, {"Spot", 
      RGBColor[0, 1, 0], {
       ImageScaled[{1, 1, 1}], 
       ImageScaled[{0.5, 0.5, 0.5}]}, 0.8726646259971648}, {"Spot", 
      RGBColor[0, 0, 1], {
       ImageScaled[{0, 1, 1}], 
       ImageScaled[{0.5, 0.5, 0.5}]}, 0.8726646259971648}}]]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
       RowBox[{"50", "\[Degree]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 300], SphereBox[{0, 0, 0}]},
  Axes->True,
  Lighting->NCache[{{"Spot", 
      RGBColor[1, 0, 0], {{1, 0, 1}, {0.5, 0.5, 0.5}}, 50 Degree}, {"Spot", 
      RGBColor[0, 1, 0], {{1, 1, 1}, {0.5, 0.5, 0.5}}, 50 Degree}, {"Spot", 
      RGBColor[0, 0, 1], {{0, 1, 1}, {0.5, 0.5, 0.5}}, 50 Degree}}, {{
     "Spot", 
      RGBColor[1, 0, 0], {{1, 0, 1}, {0.5, 0.5, 0.5}}, 0.8726646259971648}, {
     "Spot", 
      RGBColor[0, 1, 0], {{1, 1, 1}, {0.5, 0.5, 0.5}}, 0.8726646259971648}, {
     "Spot", 
      RGBColor[0, 0, 1], {{0, 1, 1}, {0.5, 0.5, 0.5}}, 
      0.8726646259971648}}]]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Probleme mit der Beleuchtung (2)", "Subsection"],

Cell["\<\
Kurz - mit der Beleuchtung scheint noch vieles im Argen zu liegen. Hier ein \
kleines Testbeispiel, an welchem die Beleuchtungverh\[ADoubleDot]ltnisse \
\[UDoubleDot]berschaubar sind: zwei \[UDoubleDot]bereinander liegende \
Quadrate und eine einzige Lichtquelle. Wengistens den Schatten sollte man ja \
dann sehen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{".5", 
       RowBox[{"RotateRight", "/@", "v"}]}], "]"}], ",", 
     RowBox[{"Polygon", "[", "v", "]"}], ",", 
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", "v", "]"}], ",", ".3", ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".3"}], "}"}]}], "]"}]}], "}"}], 
   "]"}]}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{0, 0, 0}, {0, 0, 0.5}, {0, 0.5, 0.5}, {0, 0.5, 0}}], 
   Polygon3DBox[{{0, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}}], 
   InterpretationBox[
    Polygon3DBox[{{0.35, 0.35, 0.21}, {0.35, 0.6499999999999999, 0.21}, {
     0.6499999999999999, 0.6499999999999999, 0.21}, {0.6499999999999999, 0.35,
      0.21}},
     VertexColors->Automatic,
     VertexNormals->Automatic],
    Scale[
     Polygon[{{0, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}}], 0.3, {0.5, 0.5, 
     0.3}]]}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Point\>\"", ",", "White", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Point\>\"", ",", "White", ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Point\>\"", ",", "White", ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
     RowBox[{"Scaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d3", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
     RowBox[{"ImageScaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"40", "\[Degree]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
     RowBox[{"Scaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"40", "\[Degree]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
     RowBox[{"ImageScaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"40", "\[Degree]"}]}], "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "p1", "}"}]}]}], "]"}]], "Input"],

Cell["\<\
And this are the reults with the version of April 20:
p1 - no shadow, location plausible, moving with the picture
p2 - no shadow, location plausible, moving with the picture
p3 - no shadow, location wrong, moving with the picture
d1 - no shadow, location plausible, moving with the picture
d2 - no shadow, location plausible, moving with the picture
d3 - no shadow, location wrong, moving with the picture
s1 - small shadow, location plausible, moving with the picture
s2 - no shadow, location not plausible, moving with the picture
s3 - no shadow, location wrong, moving with the picture\
\>", "SmallText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CutOut (Durchsichtige 3D-Objekte)", "Section"],

Cell[CellGroupData[{

Cell["Eine erste L\[ODoubleDot]sung", "Subsection"],

Cell["\<\
Wir beginnen mit Grafikobjekten, die aus einfachen Primitiven zusammengesetzt \
sind. 
Als Startpunkt verwenden wir unseren weiter oben definierten Torus.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GitterComplex", "[", 
    RowBox[{
    "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", "ny_Integer"}], 
    "]"}], ":=", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Join", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"P0", "+", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "*", "dx"}], ",", 
            RowBox[{"j", "*", "dy"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "nx"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "ny"}], "}"}]}], "]"}]}], "//", 
      "Chop"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"Join", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
            "1"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
            "2"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], 
             RowBox[{"(", 
              RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "2"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], 
             RowBox[{"(", 
              RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "1"}]}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", 
           RowBox[{"nx", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", 
           RowBox[{"ny", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GitterComplexPlot", "[", 
    RowBox[{
    "f_", ",", "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", 
     "ny_Integer"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gc", "=", 
       RowBox[{"GitterComplex", "[", 
        RowBox[{"P0", ",", "dx", ",", "dy", ",", "nx", ",", "ny"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{
       RowBox[{"f", "/@", 
        RowBox[{
        "gc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ",", 
       RowBox[{"gc", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
       "]"}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"torusFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_"}], "}"}], ",", "s_", ",", "d_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"b", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"r", "+", 
       RowBox[{"s", " ", "r", "*", 
        RowBox[{"Sin", "[", "u", "]"}]}], "+", 
       RowBox[{"s", " ", "b", "*", 
        RowBox[{"Cos", "[", "u", "]"}]}]}], "//", "N"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Torus", "[", 
   RowBox[{"s_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"GitterComplexPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"torusFunction", "[", 
      RowBox[{"#", ",", "s", ",", "d"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", "d", ",", "d"}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Ein solches ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Objekt kann mit ",
 StyleBox["Normal",
  FontWeight->"Bold"],
 " in eine Liste einfacher Grafikprimitive transformiert werden. Dabei werden \
alls Abk\[UDoubleDot]rzungen aufgel\[ODoubleDot]st, auch die, dass ein ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Objekt mit einer Liste von Listen von Punkten als Liste von ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Objekten interpretiert wird."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"Torus", "[", 
    RowBox[{".3", ",", "10"}], "]"}], ",", "3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{"Torus", "[", 
      RowBox[{".3", ",", "10"}], "]"}], "//", "Normal"}]}], ",", "7"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.`", ",", "0.`", ",", "0.3`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.1763355756877418`", ",", "0.`", ",", "0.2427050983124842`"}], "}"}],
       ",", 
      RowBox[{"\[LeftSkeleton]", "117", "\[RightSkeleton]"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "0.8236644243122581`", ",", "0.`", ",", "0.2427050983124842`"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "0.`", ",", "0.3`"}], "}"}]}], "}"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "13", ",", "12"}], "}"}], ",", 
       RowBox[{"\[LeftSkeleton]", "99", "\[RightSkeleton]"}]}], "}"}], 
     "]"}]}], "]"}],
  Short[#, 3]& ]], "Output"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.`", ",", "0.`", ",", "0.3`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "1.1763355756877418`", ",", "0.`", ",", "0.2427050983124842`"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "0.9516754718192205`", ",", "0.6914327031362311`", ",", 
          "0.2427050983124842`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "0.8090169943749475`", ",", "0.5877852522924731`", ",", "0.3`"}], 
         "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"\[LeftSkeleton]", "98", "\[RightSkeleton]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.6663585169306744`", ",", 
          RowBox[{"-", "0.48413780144871527`"}], ",", "0.2427050983124842`"}],
          "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.8090169943749475`", ",", 
          RowBox[{"-", "0.5877852522924731`"}], ",", "0.3`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "0.`", ",", "0.3`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "0.8236644243122581`", ",", "0.`", ",", "0.2427050983124842`"}], 
         "}"}]}], "}"}], "]"}]}], "}"}], "}"}],
  Short[#, 7]& ]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"torus", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"t", ",", " ", 
    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{1., 0., 0.3}, {1.1763355756877418`, 0., 
    0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
    1.285316954888546, 0., 0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, 0.09270509831248423}, {0.9516754718192205, 
    0.6914327031362311, 0.2427050983124842}}], 
   Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
    1.285316954888546, 0., -0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, 0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
    1.1763355756877418`, 0., -0.2427050983124842}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {1., 
    0., -0.3}, {0.8090169943749475, 0.5877852522924731, -0.3}, {
    0.9516754718192205, 0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{1., 0., -0.3}, {0.8236644243122581, 
    0., -0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.8090169943749475, 
    0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
    0.714683045111454, 0., -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
    0.714683045111454, 0., 0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
    0.8236644243122581, 0., 0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, 0.2427050983124842}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {1., 0., 
    0.3}, {0.8090169943749475, 0.5877852522924731, 0.3}, {0.6663585169306744, 
    0.48413780144871527`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
    0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
    0.3635076839753495, 1.1187616146076378`, 0.2427050983124842}, {
    0.30901699437494745`, 0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, 0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.8090169943749475, 
    0.5877852522924731, -0.3}, {0.30901699437494745`, 
    0.9510565162951535, -0.3}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
    0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
    0.2545263047745454, 0.7833514179826693, -0.2427050983124842}, {
    0.30901699437494745`, 0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
    0.30901699437494745`, 0.9510565162951535, 0.3}, {0.2545263047745454, 
    0.7833514179826693, 0.2427050983124842}}], 
   Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
    0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, 0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
    0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.2545263047745454, 0.7833514179826693, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.8090169943749475, 0.5877852522924731, 
    0.3}, {-0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
    0.3}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.1763355756877418`, 0., 0.2427050983124842}, {-1.,
     0., 0.3}}], 
   Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-1.285316954888546, 0., 
    0.09270509831248423}, {-1.1763355756877418`, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-1.285316954888546, 
    0., -0.09270509831248423}, {-1.285316954888546, 0., 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-1.1763355756877418`, 
    0., -0.2427050983124842}, {-1.285316954888546, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-1., 0., -0.3}, {-1.1763355756877418`, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.8236644243122581, 
    0., -0.2427050983124842}, {-1., 0., -0.3}}], 
   Polygon3DBox[{{-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.714683045111454, 
    0., -0.09270509831248423}, {-0.8236644243122581, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {-0.714683045111454, 0., 
    0.09270509831248423}, {-0.714683045111454, 0., -0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.8236644243122581, 0., 
    0.2427050983124842}, {-0.714683045111454, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 0.3}, {-1.,
     0., 0.3}, {-0.8236644243122581, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{-1., 0., 0.3}, {-1.1763355756877418`, 0., 
    0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0., 
    0.2427050983124842}, {-1.285316954888546, 0., 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-1.285316954888546, 0., 
    0.09270509831248423}, {-1.285316954888546, 
    0., -0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.285316954888546, 
    0., -0.09270509831248423}, {-1.1763355756877418`, 
    0., -0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0., -0.2427050983124842}, {-1., 
    0., -0.3}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.9516754718192205, -0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{-1., 0., -0.3}, {-0.8236644243122581, 
    0., -0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{-0.8236644243122581, 
    0., -0.2427050983124842}, {-0.714683045111454, 
    0., -0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.714683045111454, 
    0., -0.09270509831248423}, {-0.714683045111454, 0., 
    0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.714683045111454, 0., 
    0.09270509831248423}, {-0.8236644243122581, 0., 
    0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.8236644243122581, 0., 0.2427050983124842}, {-1., 0., 
    0.3}, {-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.3635076839753495, \
-1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.30901699437494745`, -0.9510565162951535, 
    0.3}, {-0.2545263047745454, -0.7833514179826693, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
    0.3}, {-0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.30901699437494745`, -0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.2545263047745454, -0.7833514179826693, 0.2427050983124842}}], 
   Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
    0.8090169943749475, -0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, 0.09270509831248423}}], 
   Polygon3DBox[{{
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.8090169943749475, -0.5877852522924731, -0.3}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.8090169943749475, -0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.8090169943749475, -0.5877852522924731, 0.3}, {
    0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
    0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
    1.1763355756877418`, 0., 0.2427050983124842}, {1., 0., 0.3}}], 
   Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}, {
    1.1763355756877418`, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    1.285316954888546, 0., -0.09270509831248423}, {1.285316954888546, 0., 
    0.09270509831248423}}], 
   Polygon3DBox[{{
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    1.1763355756877418`, 0., -0.2427050983124842}, {1.285316954888546, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    0.8090169943749475, -0.5877852522924731, -0.3}, {1., 0., -0.3}, {
    1.1763355756877418`, 0., -0.2427050983124842}}], 
   Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.8236644243122581, 0., -0.2427050983124842}, {1., 0., -0.3}}], 
   Polygon3DBox[{{
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.714683045111454, 0., -0.09270509831248423}, {0.8236644243122581, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
    0.714683045111454, 0., 0.09270509831248423}, {0.714683045111454, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}, {
    0.714683045111454, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {1., 
    0., 0.3}, {0.8236644243122581, 0., 0.2427050983124842}}]},
  Boxed->False]], "Output"]
}, Open  ]],

Cell["\<\
Ein so normalisierter Torus besteht aus Polygonen mit vier Eckpunkten, woraus \
das folgende Kommando Polygone mit drei Eckpunkten macht. Damit wird der \
Torus \"durchsichtig\".\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"torushohl", " ", "=", " ", 
  RowBox[{"torus", " ", "/.", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{"p1_", ",", "p2_", ",", "p3_", ",", "p4_"}], "}"}], "]"}], 
    "\[Rule]", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}]}]}]}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{1., 0., 0.3}, {1.1763355756877418`, 0., 
    0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
    1.285316954888546, 0., 0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, 0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
    1.285316954888546, 0., -0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
    1.1763355756877418`, 0., -0.2427050983124842}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {1., 
    0., -0.3}, {0.8090169943749475, 0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{1., 0., -0.3}, {0.8236644243122581, 
    0., -0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
    0.714683045111454, 0., -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
    0.714683045111454, 0., 0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
    0.8236644243122581, 0., 0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {1., 0., 
    0.3}, {0.8090169943749475, 0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
    0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
    0.3635076839753495, 1.1187616146076378`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.8090169943749475, 
    0.5877852522924731, -0.3}, {0.30901699437494745`, 
    0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
    0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
    0.2545263047745454, 0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
    0.30901699437494745`, 0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
    0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
    0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.30901699437494745`, 0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.8090169943749475, 0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
    0.3}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.1763355756877418`, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-1.285316954888546, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-1.285316954888546, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-1.1763355756877418`, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-1., 0., -0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.8236644243122581, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.714683045111454, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {-0.714683045111454, 0., 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.8236644243122581, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 0.3}, {-1.,
     0., 0.3}}], 
   Polygon3DBox[{{-1., 0., 0.3}, {-1.1763355756877418`, 0., 
    0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0., 
    0.2427050983124842}, {-1.285316954888546, 0., 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.285316954888546, 0., 
    0.09270509831248423}, {-1.285316954888546, 
    0., -0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-1.285316954888546, 
    0., -0.09270509831248423}, {-1.1763355756877418`, 
    0., -0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0., -0.2427050983124842}, {-1., 
    0., -0.3}, {-0.8090169943749475, -0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{-1., 0., -0.3}, {-0.8236644243122581, 
    0., -0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.8236644243122581, 
    0., -0.2427050983124842}, {-0.714683045111454, 
    0., -0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.714683045111454, 
    0., -0.09270509831248423}, {-0.714683045111454, 0., 
    0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.714683045111454, 0., 
    0.09270509831248423}, {-0.8236644243122581, 0., 
    0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.8236644243122581, 0., 0.2427050983124842}, {-1., 0., 
    0.3}, {-0.8090169943749475, -0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.30901699437494745`, -0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
    0.3}, {-0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.30901699437494745`, -0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, 0.2427050983124842}}], 
   Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.8090169943749475, -0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.8090169943749475, -0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
    0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
    1.1763355756877418`, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    1.285316954888546, 0., -0.09270509831248423}}], 
   Polygon3DBox[{{
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    1.1763355756877418`, 0., -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    0.8090169943749475, -0.5877852522924731, -0.3}, {1., 0., -0.3}}], 
   Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.8236644243122581, 0., -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.714683045111454, 0., -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
    0.714683045111454, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {1., 
    0., 0.3}}]},
  Boxed->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CutOut - L\[ODoubleDot]cher in Polygone schneiden\
\>", "Subsection"],

Cell["\<\
Regul\[ADoubleDot]res Polygon \[UDoubleDot]ber Punkte in der Gau\[SZ]schen \
Zahlenebene als Grafikprimitiv konstruieren.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"regularPolygon", "[", "n_Integer", "]"}], "/;", 
    RowBox[{"n", ">", "0"}]}], ":=", 
   RowBox[{"Polygon", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "[", "#", "]"}], ",", 
         RowBox[{"Im", "[", "#", "]"}], ",", "0"}], "}"}], "&"}], "/@", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", 
           RowBox[{"i", "/", "n"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], "//", "N"}], "]"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"regularPolygon", "[", "6", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"ViewPoint", "->", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{0.5, 0.8660254037844386, 0.}, {-0.5, 0.8660254037844386, 
   0.}, {-1., 0., 0.}, {-0.5, -0.8660254037844386, 0.}, {
   0.5, -0.8660254037844386, 0.}, {1., 0., 0.}}],
  Boxed->False,
  ViewPoint->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"cutout", "[", 
   RowBox[{"p_List", ",", "\[Alpha]_"}], "]"}], ":=", "\[IndentingNewLine]", 
  "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"l", ",", "q"}], "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"q", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
            RowBox[{"Mean", "[", "p", "]"}]}], "+", 
           RowBox[{"\[Alpha]", "#"}]}], ")"}], "&"}], ",", "p"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"l", "=", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"RotateLeft", "[", "p", "]"}], ",", 
         RowBox[{"RotateLeft", "[", "q", "]"}], ",", "q"}], "}"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"Polygon", "/@", "l"}]}]}], "\n", "\t  ", "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"torus", "/.", " ", 
  RowBox[{
   RowBox[{"Polygon", "[", "x_", "]"}], " ", "\[Rule]", 
   RowBox[{"cutout", "[", 
    RowBox[{"x", ",", ".66"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 Graphics3DBox[{{
    Polygon3DBox[{{1., 0., 0.3}, {1.1763355756877418`, 0., 
     0.2427050983124842}, {1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}, {0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
     0.9627531949606478, 0.5650791102813524, 0.2524452315993619}, {
     1.1110288635138719`, 0.10873352621143985`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.8685985998474277, 0.49667179272447215`, 0.2902598667131223}, {
     0.9627531949606478, 0.5650791102813524, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {1., 0., 
     0.3}, {0.9946473835599623, 0.10873352621143985`, 0.2902598667131223}, {
     0.8685985998474277, 0.49667179272447215`, 0.2902598667131223}}]}, {
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     1.285316954888546, 0., 0.09270509831248423}, {1.2268287475014212`, 
     0.122988459568001, 0.11820509831248423`}, {1.1549010372288906`, 
     0.122988459568001, 0.21720509831248422`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.0398432596630913`, 0.7554903506049574, 0.09270509831248423}, {
     1.0648161086526213`, 0.6216120909672729, 0.11820509831248423`}, {
     1.2268287475014212`, 0.122988459568001, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}, {1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1549010372288906`, 0.122988459568001, 0.21720509831248422`}, {
     1.0066253686756665`, 0.5793340436379135, 0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.285316954888546, 0., -0.09270509831248423}, {1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}, {1.2435864267002186`, 
     0.12843335960284274`, 0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.0398432596630913`, 0.7554903506049574, -0.09270509831248423}, {
     1.0815737878514187`, 0.6270569910021146, -0.061185364886239595`}, {
     1.2435864267002186`, 0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, 0.09270509831248423}, {1.0815737878514187`, 
     0.6270569910021146, 0.061185364886239595`}, {1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}, {
     1.2435864267002186`, 0.12843335960284274`, 0.061185364886239595`}, {
     1.0815737878514187`, 0.6270569910021146, 0.061185364886239595`}}]}, {
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.1763355756877418`, 0., -0.2427050983124842}, {1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}, {1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     0.9516754718192205, 0.6914327031362311, -0.2427050983124842}, {
     1.0066253686756665`, 0.5793340436379135, -0.21720509831248422`}, {
     1.1549010372288906`, 0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}, {1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.285316954888546, 
     0., -0.09270509831248423}, {1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}, {1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {1., 
     0., -0.3}, {0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}, {1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., -0.3}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}, {0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.9516754718192205, 0.6914327031362311, -0.2427050983124842}, {
     0.9627531949606478, 0.5650791102813524, -0.2524452315993619}, {
     0.8685985998474277, 0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {1.1763355756877418`, 
     0., -0.2427050983124842}, {1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}, {0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}}]}, {
    Polygon3DBox[{{1., 0., -0.3}, {0.8236644243122581, 
     0., -0.2427050983124842}, {0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}, {0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
     0.7202150157017648, 0.41064440852415307`, -0.2524452315993619}, {
     0.8240369145736102, 0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}, {0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {1., 
     0., -0.3}, {0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}, {0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.714683045111454, 0., -0.09270509831248423}, {0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}, {0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.5781907290868035, 0.4200801539799889, -0.09270509831248423}, {
     0.6181521020097914, 0.3541114278382325, -0.11820509831248423`}, {
     0.7082370305860608, 0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}, {0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.8236644243122581, 
     0., -0.2427050983124842}, {0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}, {0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.714683045111454, 0., 0.09270509831248423}, {0.6914793513872635, 
     0.0714136261765981, 0.061185364886239595`}, {0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.5781907290868035, 0.4200801539799889, 0.09270509831248423}, {
     0.6013944228109941, 0.3486665278033908, 0.061185364886239595`}, {
     0.6914793513872635, 0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}, {0.6013944228109941, 
     0.3486665278033908, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.714683045111454, 
     0., -0.09270509831248423}, {0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}, {0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.8236644243122581, 0., 0.2427050983124842}, {0.7801647408585914, 
     0.07685852621143985, 0.21720509831248422`}, {0.7082370305860608, 
     0.07685852621143985, 0.11820509831248423`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}, {
     0.6763428419867462, 0.39638947516759193`, 0.21720509831248422`}, {
     0.7801647408585914, 0.07685852621143985, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}, {0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.714683045111454, 0., 0.09270509831248423}, {
     0.7082370305860608, 0.07685852621143985, 0.11820509831248423`}, {
     0.6181521020097914, 0.3541114278382325, 0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {1., 0., 
     0.3}, {0.9404183945275197, 0.091113459568001, 0.2902598667131223}, {
     0.8240369145736102, 0.091113459568001, 0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8090169943749475, 0.5877852522924731, 
     0.3}, {0.8143696108149852, 0.4790517260810333, 0.2902598667131223}, {
     0.9404183945275197, 0.091113459568001, 0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}, {
     0.7202150157017648, 0.41064440852415307`, 0.2524452315993619}, {
     0.8143696108149852, 0.4790517260810333, 0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}, {
     0.8240369145736102, 0.091113459568001, 0.2524452315993619}, {
     0.7202150157017648, 0.41064440852415307`, 0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
     0.834929268686965, 0.7410136514080896, 0.2524452315993619}, {
     0.7407746735737448, 0.6726063338512094, 0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}, {0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.4107746735737448, 0.9123653680929784, 0.2902598667131223}, {
     0.4467385287100102, 1.023050732979218, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.8090169943749475, 0.5877852522924731, 0.3}, {0.7407746735737448, 
     0.6726063338512094, 0.2902598667131223}, {0.4107746735737448, 
     0.9123653680929784, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}, {0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}, {0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}, {0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}, {0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}, {0.9305913184975649, 
     0.834866532128852, 0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}, {0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {0.5064367233843448, 
     1.1430328839275012`, 0.061185364886239595`}, {0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9305913184975649, 0.834866532128852, 
     0.061185364886239595`}, {0.5064367233843448, 1.1430328839275012`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}, {0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}, {0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}, {0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}, {0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}, {0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.30901699437494745`, 0.9510565162951535, -0.3}, {0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}, {0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.3635076839753495, 1.1187616146076378`, -0.2427050983124842}, {
     0.4467385287100102, 1.023050732979218, -0.2524452315993619}, {
     0.4107746735737448, 0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}, {0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
     0.6131047200629298, 0.558069082937768, -0.2524452315993619}, {
     0.70725931517615, 0.6264764004946483, -0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}, {0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}, {0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.8090169943749475, 0.5877852522924731, -0.3}, {0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}, {0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}, {0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}, {0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}, {0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}, {0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {0.5174426702523299, 
     0.4642162022170057, 0.061185364886239595`}, {0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.2815972653655501, 0.6355679189018946, 
     0.061185364886239595`}, {0.5174426702523299, 0.4642162022170057, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}, {0.2815972653655501, 
     0.6355679189018946, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}, {0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}, {0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}, {0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}, {0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}, {0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.70725931517615, 0.6264764004946483, 0.2902598667131223}, {
     0.6131047200629298, 0.558069082937768, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.3772593151761501, 
     0.8662354347364173, 0.2902598667131223}, {0.70725931517615, 
     0.6264764004946483, 0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.2545263047745454, 0.7833514179826693, 0.2427050983124842}, {
     0.3412954600398847, 0.7555500698501777, 0.2524452315993619}, {
     0.3772593151761501, 0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}, {0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.3635076839753495, 1.1187616146076378`, 0.2427050983124842}, {
     0.23991507142373067`, 1.0902517478945155`, 0.2524452315993619}, {
     0.20395121628746532`, 0.9795663830082759, 0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}, {0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.20395121628746532`, 0.9795663830082759, 
     0.2902598667131223}, {-0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.20395121628746532`, 
     0.9795663830082759, 0.2902598667131223}, {-0.20395121628746532`, 
     0.9795663830082759, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}, {0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}, {0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}, {-0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}, {-0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}, {0.26214195626442016`, 
     1.2224090654513957`, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}, {0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {-0.26214195626442016`, 
     1.2224090654513957`, 0.061185364886239595`}, {-0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, 1.2224090654513957`, 
     0.061185364886239595`}, {-0.26214195626442016`, 1.2224090654513957`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}, {0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}, {0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}, {-0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}, {-0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}, {0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}, {0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}, {-0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}, {-0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.2545263047745454, 0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, 0.8118612846957916, -0.2524452315993619}, {
     0.20395121628746532`, 0.9225466495820311, -0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}, {0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}, {-0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.30901699437494745`, 0.9510565162951535, -0.3}, {0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}, {-0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}, {0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}, {0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}, {-0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}, {-0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {0.14576047631051048`, 
     0.6797039671389115, 0.061185364886239595`}, {0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, 0.6797039671389115, 
     0.061185364886239595`}, {0.14576047631051048`, 0.6797039671389115, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}, {-0.14576047631051048`, 
     0.6797039671389115, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}, {-0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}, {0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}, {0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}, {-0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}, {-0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}, {
     0.16798736115119997`, 0.8118612846957916, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}, {
     0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}, {-0.20395121628746532`, 0.9225466495820311, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}, {-0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}, {-0.4107746735737448, 0.9123653680929784, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}, {-0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.7407746735737448, 0.6726063338512094, 
     0.2902598667131223}, {-0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.4107746735737448, 0.9123653680929784, 
     0.2902598667131223}, {-0.7407746735737448, 0.6726063338512094, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}, {-0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}, {-0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}, {-0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}, {-0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}, {-0.5064367233843448, 
     1.1430328839275012`, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}, {-0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, 0.09270509831248423}, {-0.9305913184975649, 
     0.834866532128852, 0.061185364886239595`}, {-0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.5064367233843448, 1.1430328839275012`, 
     0.061185364886239595`}, {-0.9305913184975649, 0.834866532128852, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}, {-0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}, {-0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}, {-0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}, {-0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}, {-0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}, {-0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}, {-0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}, {-0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}, {-0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}, {-0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}, {-0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}, {-0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}, {-0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}, {-0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}, {-0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}, {-0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {-0.2815972653655501, 
     0.6355679189018946, 0.061185364886239595`}, {-0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5174426702523299, 0.4642162022170057, 
     0.061185364886239595`}, {-0.2815972653655501, 0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}, {-0.5174426702523299, 
     0.4642162022170057, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}, {-0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}, {-0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}, {-0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}, {-0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}, {-0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.3772593151761501, 0.8662354347364173, 
     0.2902598667131223}, {-0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.8090169943749475, 0.5877852522924731, 0.3}, {-0.70725931517615,
      0.6264764004946483, 0.2902598667131223}, {-0.3772593151761501, 
     0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}, {-0.70725931517615, 0.6264764004946483, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}, {-0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.9627531949606478, 0.5650791102813524, 
     0.2524452315993619}, {-0.8685985998474277, 0.49667179272447215`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}, {-0.9627531949606478, 0.5650791102813524, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 0.2427050983124842}, {-1., 0., 
     0.3}, {-0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}, {-1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8685985998474277, 0.49667179272447215`, 
     0.2902598667131223}, {-0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}, {-1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2268287475014212`, 0.122988459568001, 
     0.11820509831248423`}, {-1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1549010372288906`, 0.122988459568001, 
     0.21720509831248422`}, {-1.2268287475014212`, 0.122988459568001, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}, {-1.1549010372288906`, 0.122988459568001, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}, {-1.0815737878514187`, 
     0.6270569910021146, 0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}, {-1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2435864267002186`, 0.12843335960284274`, 
     0.061185364886239595`}, {-1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0815737878514187`, 0.6270569910021146, 
     0.061185364886239595`}, {-1.2435864267002186`, 0.12843335960284274`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}, {-1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}, {-1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}, {-1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}, {-1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}, {-0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, -0.3}, {-1., 
     0., -0.3}, {-0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}, {-0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{-1., 0., -0.3}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}, {-0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}, {-1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}, {-0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}, {-0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., -0.2427050983124842}, {-1., 
     0., -0.3}, {-0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}, {-0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}, {-0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}, {-0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}, {-0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}, {-0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}, {-0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {-0.6013944228109941, 
     0.3486665278033908, 0.061185364886239595`}, {-0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.6914793513872635, 0.0714136261765981, 
     0.061185364886239595`}, {-0.6013944228109941, 0.3486665278033908, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}, {-0.6914793513872635, 
     0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}, {-0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}, {-0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.7801647408585914, 0.07685852621143985, 
     0.21720509831248422`}, {-0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.7082370305860608, 0.07685852621143985, 
     0.11820509831248423`}, {-0.7801647408585914, 0.07685852621143985, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}, {-0.7082370305860608, 0.07685852621143985, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8143696108149852, 0.4790517260810333, 
     0.2902598667131223}, {-0.7202150157017648, 0.41064440852415307`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 0.3}, {-1., 0., 
     0.3}, {-0.9404183945275197, 0.091113459568001, 
     0.2902598667131223}, {-0.8143696108149852, 0.4790517260810333, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.8240369145736102, 0.091113459568001, 
     0.2524452315993619}, {-0.9404183945275197, 0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.7202150157017648, 0.41064440852415307`, 
     0.2524452315993619}, {-0.8240369145736102, 0.091113459568001, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-1., 0., 0.3}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1110288635138719`, -0.10873352621143985`, 
     0.2524452315993619}, {-0.9946473835599623, -0.10873352621143985`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.9627531949606478, -0.5650791102813524, 
     0.2524452315993619}, {-1.1110288635138719`, -0.10873352621143985`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8685985998474277, -0.49667179272447215`, 
     0.2902598667131223}, {-0.9627531949606478, -0.5650791102813524, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 0.3}, {-1., 0., 
     0.3}, {-0.9946473835599623, -0.10873352621143985`, 
     0.2902598667131223}, {-0.8685985998474277, -0.49667179272447215`, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2268287475014212`, -0.122988459568001, 
     0.11820509831248423`}, {-1.1549010372288906`, -0.122988459568001, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}, {-1.2268287475014212`, -0.122988459568001, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}, {-1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1549010372288906`, -0.122988459568001, 
     0.21720509831248422`}, {-1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2435864267002186`, -0.12843335960284274`, \
-0.061185364886239595`}, {-1.2435864267002186`, -0.12843335960284274`, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0815737878514187`, -0.6270569910021146, \
-0.061185364886239595`}, {-1.2435864267002186`, -0.12843335960284274`, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0815737878514187`, -0.6270569910021146, 
     0.061185364886239595`}, {-1.0815737878514187`, -0.6270569910021146, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2435864267002186`, -0.12843335960284274`, 
     0.061185364886239595`}, {-1.0815737878514187`, -0.6270569910021146, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1549010372288906`, -0.122988459568001, \
-0.21720509831248422`}, {-1.2268287475014212`, -0.122988459568001, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0066253686756665`, -0.5793340436379135, \
-0.21720509831248422`}, {-1.1549010372288906`, -0.122988459568001, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0648161086526213`, -0.6216120909672729, \
-0.11820509831248423`}, {-1.0066253686756665`, -0.5793340436379135, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2268287475014212`, -0.122988459568001, \
-0.11820509831248423`}, {-1.0648161086526213`, -0.6216120909672729, \
-0.11820509831248423`}}]}, {
    Polygon3DBox[{{-1.1763355756877418`, 0., -0.2427050983124842}, {-1., 
     0., -0.3}, {-0.9946473835599623, -0.10873352621143985`, \
-0.2902598667131223}, {-1.1110288635138719`, -0.10873352621143985`, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-1., 
     0., -0.3}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}, \
{-0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, \
{-0.9627531949606478, -0.5650791102813524, -0.2524452315993619}, \
{-0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1110288635138719`, -0.10873352621143985`, \
-0.2524452315993619}, {-0.9627531949606478, -0.5650791102813524, \
-0.2524452315993619}}]}, {
    Polygon3DBox[{{-1., 0., -0.3}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.8240369145736102, -0.091113459568001, \
-0.2524452315993619}, {-0.9404183945275197, -0.091113459568001, \
-0.2902598667131223}}], 
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.7202150157017648, -0.41064440852415307`, \
-0.2524452315993619}, {-0.8240369145736102, -0.091113459568001, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.8143696108149852, -0.4790517260810333, -0.2902598667131223}, \
{-0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, {-1., 
     0., -0.3}, {-0.9404183945275197, -0.091113459568001, \
-0.2902598667131223}, {-0.8143696108149852, -0.4790517260810333, \
-0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.7082370305860608, -0.07685852621143985, \
-0.11820509831248423`}, {-0.7801647408585914, -0.07685852621143985, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6181521020097914, -0.3541114278382325, \
-0.11820509831248423`}, {-0.7082370305860608, -0.07685852621143985, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.6763428419867462, -0.39638947516759193`, \
-0.21720509831248422`}, {-0.6181521020097914, -0.3541114278382325, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.7801647408585914, -0.07685852621143985, \
-0.21720509831248422`}, {-0.6763428419867462, -0.39638947516759193`, \
-0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.6914793513872635, -0.0714136261765981, 
     0.061185364886239595`}, {-0.6914793513872635, -0.0714136261765981, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6013944228109941, -0.3486665278033908, 
     0.061185364886239595`}, {-0.6914793513872635, -0.0714136261765981, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6013944228109941, -0.3486665278033908, \
-0.061185364886239595`}, {-0.6013944228109941, -0.3486665278033908, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.6914793513872635, -0.0714136261765981, \
-0.061185364886239595`}, {-0.6013944228109941, -0.3486665278033908, \
-0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.7801647408585914, -0.07685852621143985, 
     0.21720509831248422`}, {-0.7082370305860608, -0.07685852621143985, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}, {-0.7801647408585914, -0.07685852621143985, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}, {-0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.7082370305860608, -0.07685852621143985, 
     0.11820509831248423`}, {-0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.8236644243122581, 0., 0.2427050983124842}, {-1., 0., 
     0.3}, {-0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}, {-0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8143696108149852, -0.4790517260810333, 
     0.2902598667131223}, {-0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.7202150157017648, -0.41064440852415307`, 
     0.2524452315993619}, {-0.8143696108149852, -0.4790517260810333, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}, {-0.7202150157017648, -0.41064440852415307`, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}, {-0.7407746735737448, -0.6726063338512094, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}, {-0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.4107746735737448, -0.9123653680929784, 
     0.2902598667131223}, {-0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.7407746735737448, -0.6726063338512094, 
     0.2902598667131223}, {-0.4107746735737448, -0.9123653680929784, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}, {-0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}, {-0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}, {-0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}, {-0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9305913184975649, -0.834866532128852, \
-0.061185364886239595`}, {-0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.5064367233843448, -1.1430328839275012`, \
-0.061185364886239595`}, {-0.9305913184975649, -0.834866532128852, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}, {-0.5064367233843448, -1.1430328839275012`, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}, {-0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8620437632031863, -0.7783335514429314, \
-0.21720509831248422`}, {-0.9202345031801411, -0.8206115987722907, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.4738530232262314, -1.0603706330140596`, \
-0.21720509831248422`}, {-0.8620437632031863, -0.7783335514429314, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.4960799080669209, -1.12877795057094, \
-0.11820509831248423`}, {-0.4738530232262314, -1.0603706330140596`, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9202345031801411, -0.8206115987722907, \
-0.11820509831248423`}, {-0.4960799080669209, -1.12877795057094, \
-0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.7407746735737448, -0.6726063338512094, -0.2902598667131223}, \
{-0.834929268686965, -0.7410136514080896, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.4107746735737448, \
-0.9123653680929784, -0.2902598667131223}, {-0.7407746735737448, \
-0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.4467385287100102, -1.023050732979218, -0.2524452315993619}, \
{-0.4107746735737448, -0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.834929268686965, -0.7410136514080896, \
-0.2524452315993619}, {-0.4467385287100102, -1.023050732979218, \
-0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, \
{-0.6131047200629298, -0.558069082937768, -0.2524452315993619}, \
{-0.70725931517615, -0.6264764004946483, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.3412954600398847, -0.7555500698501777, \
-0.2524452315993619}, {-0.6131047200629298, -0.558069082937768, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.3772593151761501, -0.8662354347364173, -0.2902598667131223}, \
{-0.3412954600398847, -0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.8090169943749475, -0.5877852522924731, -0.3}, {-0.70725931517615, \
-0.6264764004946483, -0.2902598667131223}, {-0.3772593151761501, \
-0.8662354347364173, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5277994855697539, -0.47847113557356685`, \
-0.11820509831248423`}, {-0.5859902255467087, -0.5207491829029263, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.29195408068297396`, -0.6498228522584557, \
-0.11820509831248423`}, {-0.5277994855697539, -0.47847113557356685`, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.3141809655236635, -0.7182301698153359, \
-0.21720509831248422`}, {-0.29195408068297396`, -0.6498228522584557, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5859902255467087, -0.5207491829029263, \
-0.21720509831248422`}, {-0.3141809655236635, -0.7182301698153359, \
-0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}, {-0.5174426702523299, -0.4642162022170057, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}, {-0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2815972653655501, -0.6355679189018946, \
-0.061185364886239595`}, {-0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5174426702523299, -0.4642162022170057, \
-0.061185364886239595`}, {-0.2815972653655501, -0.6355679189018946, \
-0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}, {-0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}, {-0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}, {-0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}, {-0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.70725931517615, -0.6264764004946483, 
     0.2902598667131223}, {-0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.3772593151761501, -0.8662354347364173, 
     0.2902598667131223}, {-0.70725931517615, -0.6264764004946483, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}, {-0.3772593151761501, -0.8662354347364173, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}, {-0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}, {-0.20395121628746532`, -0.9795663830082759, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}, {-0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}, {
     0.23991507142373067`, -1.0902517478945155`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}, {
     0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}, {-0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}, {-0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}, {0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}, {0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.26214195626442016`, -1.2224090654513957`, \
-0.061185364886239595`}, {-0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}, \
{-0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, 0.09270509831248423}, {
     0.26214195626442016`, -1.2224090654513957`, 0.061185364886239595`}, {
     0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}, {0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.23991507142373067`, -1.1363816812510765`, \
-0.21720509831248422`}, {-0.26214195626442016`, -1.2047889988079568`, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}, \
{-0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}, {
     0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}, {
     0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}, \
{-0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}, \
{-0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}, {
     0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}, {
     0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}, \
{-0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}, \
{-0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}, {
     0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.20395121628746532`, \
-0.9225466495820311, -0.2902598667131223}, {
     0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.14576047631051048`, -0.6973240337823503, \
-0.11820509831248423`}, {-0.16798736115119997`, -0.7657313513392304, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}, \
{-0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}, {
     0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}, {
     0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}, {-0.14576047631051048`, -0.6797039671389115, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}, {-0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}, {
     0.14576047631051048`, -0.6797039671389115, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, \
{-0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, \
{-0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}, {
     0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}, {-0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}, {-0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}, {0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}, {0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}, {-0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}, {-0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.2545263047745454, -0.7833514179826693, 0.2427050983124842}, {
     0.16798736115119997`, -0.8118612846957916, 0.2524452315993619}, {
     0.20395121628746532`, -0.9225466495820311, 0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}, {0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
     0.4467385287100102, -1.023050732979218, 0.2524452315993619}, {
     0.4107746735737448, -0.9123653680929784, 0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}, {0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.7407746735737448, -0.6726063338512094, 0.2902598667131223}, {
     0.834929268686965, -0.7410136514080896, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.4107746735737448, -0.9123653680929784, 0.2902598667131223}, {
     0.7407746735737448, -0.6726063338512094, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}, {0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}, {0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}, {0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}, {0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.5064367233843448, -1.1430328839275012`, -0.061185364886239595`}, {
     0.5064367233843448, -1.1430328839275012`, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9305913184975649, -0.834866532128852, -0.061185364886239595`}, {
     0.5064367233843448, -1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, 0.09270509831248423}, {
     0.9305913184975649, -0.834866532128852, 0.061185364886239595`}, {
     0.9305913184975649, -0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}, {0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.4738530232262314, -1.0603706330140596`, -0.21720509831248422`}, {
     0.4960799080669209, -1.12877795057094, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.8620437632031863, -0.7783335514429314, -0.21720509831248422`}, {
     0.4738530232262314, -1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9202345031801411, -0.8206115987722907, -0.11820509831248423`}, {
     0.8620437632031863, -0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.4960799080669209, -1.12877795057094, -0.11820509831248423`}, {
     0.9202345031801411, -0.8206115987722907, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.4107746735737448, -0.9123653680929784, -0.2902598667131223}, {
     0.4467385287100102, -1.023050732979218, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.7407746735737448, -0.6726063338512094, -0.2902598667131223}, {
     0.4107746735737448, -0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.834929268686965, -0.7410136514080896, -0.2524452315993619}, {
     0.7407746735737448, -0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.4467385287100102, -1.023050732979218, -0.2524452315993619}, {
     0.834929268686965, -0.7410136514080896, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.3412954600398847, -0.7555500698501777, -0.2524452315993619}, {
     0.3772593151761501, -0.8662354347364173, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.6131047200629298, -0.558069082937768, -0.2524452315993619}, {
     0.3412954600398847, -0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.70725931517615, -0.6264764004946483, -0.2902598667131223}, {
     0.6131047200629298, -0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.3772593151761501, -0.8662354347364173, -0.2902598667131223}, {
     0.70725931517615, -0.6264764004946483, -0.2902598667131223}}]}, {
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.29195408068297396`, -0.6498228522584557, -0.11820509831248423`}, {
     0.3141809655236635, -0.7182301698153359, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5277994855697539, -0.47847113557356685`, -0.11820509831248423`}, {
     0.29195408068297396`, -0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.5859902255467087, -0.5207491829029263, -0.21720509831248422`}, {
     0.5277994855697539, -0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.3141809655236635, -0.7182301698153359, -0.21720509831248422`}, {
     0.5859902255467087, -0.5207491829029263, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
     0.2815972653655501, -0.6355679189018946, 0.061185364886239595`}, {
     0.2815972653655501, -0.6355679189018946, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}, {0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5174426702523299, -0.4642162022170057, -0.061185364886239595`}, {
     0.5174426702523299, -0.4642162022170057, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2815972653655501, -0.6355679189018946, -0.061185364886239595`}, {
     0.5174426702523299, -0.4642162022170057, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}, {0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}, {0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}, {0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}, {0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.3772593151761501, -0.8662354347364173, 0.2902598667131223}, {
     0.3412954600398847, -0.7555500698501777, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.70725931517615, -0.6264764004946483, 0.2902598667131223}, {
     0.3772593151761501, -0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}, {
     0.6131047200629298, -0.558069082937768, 0.2524452315993619}, {
     0.70725931517615, -0.6264764004946483, 0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}, {0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
     0.9627531949606478, -0.5650791102813524, 0.2524452315993619}, {
     0.8685985998474277, -0.49667179272447215`, 0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1110288635138719`, -0.10873352621143985`, 0.2524452315993619}, {
     0.9627531949606478, -0.5650791102813524, 0.2524452315993619}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {1., 0., 
     0.3}, {0.9946473835599623, -0.10873352621143985`, 0.2902598667131223}, {
     1.1110288635138719`, -0.10873352621143985`, 0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8090169943749475, -0.5877852522924731, 
     0.3}, {0.8685985998474277, -0.49667179272447215`, 0.2902598667131223}, {
     0.9946473835599623, -0.10873352621143985`, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}, {1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}, {
     1.2268287475014212`, -0.122988459568001, 0.11820509831248423`}, {
     1.0648161086526213`, -0.6216120909672729, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1549010372288906`, -0.122988459568001, 0.21720509831248422`}, {
     1.2268287475014212`, -0.122988459568001, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
     1.0066253686756665`, -0.5793340436379135, 0.21720509831248422`}, {
     1.1549010372288906`, -0.122988459568001, 0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0815737878514187`, -0.6270569910021146, -0.061185364886239595`}, {
     1.0815737878514187`, -0.6270569910021146, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.285316954888546, 0., -0.09270509831248423}, {
     1.2435864267002186`, -0.12843335960284274`, -0.061185364886239595`}, {
     1.0815737878514187`, -0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.285316954888546, 0., 0.09270509831248423}, {
     1.2435864267002186`, -0.12843335960284274`, 0.061185364886239595`}, {
     1.2435864267002186`, -0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, 0.09270509831248423}, {
     1.0815737878514187`, -0.6270569910021146, 0.061185364886239595`}, {
     1.2435864267002186`, -0.12843335960284274`, 0.061185364886239595`}}]}, {
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.0066253686756665`, -0.5793340436379135, -0.21720509831248422`}, {
     1.0648161086526213`, -0.6216120909672729, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.1763355756877418`, 0., -0.2427050983124842}, {
     1.1549010372288906`, -0.122988459568001, -0.21720509831248422`}, {
     1.0066253686756665`, -0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     1.285316954888546, 0., -0.09270509831248423}, {
     1.2268287475014212`, -0.122988459568001, -0.11820509831248423`}, {
     1.1549010372288906`, -0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0648161086526213`, -0.6216120909672729, -0.11820509831248423`}, {
     1.2268287475014212`, -0.122988459568001, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}, {
     0.9627531949606478, -0.5650791102813524, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {1., 
     0., -0.3}, {
     0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}, {
     0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{1., 0., -0.3}, {1.1763355756877418`, 
     0., -0.2427050983124842}, {
     1.1110288635138719`, -0.10873352621143985`, -0.2524452315993619}, {
     0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.9627531949606478, -0.5650791102813524, -0.2524452315993619}, {
     1.1110288635138719`, -0.10873352621143985`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}, {
     0.8143696108149852, -0.4790517260810333, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.8236644243122581, 0., -0.2427050983124842}, {
     0.8240369145736102, -0.091113459568001, -0.2524452315993619}, {
     0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {1., 
     0., -0.3}, {
     0.9404183945275197, -0.091113459568001, -0.2902598667131223}, {
     0.8240369145736102, -0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.8143696108149852, -0.4790517260810333, -0.2902598667131223}, {
     0.9404183945275197, -0.091113459568001, -0.2902598667131223}}]}, {
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6181521020097914, -0.3541114278382325, -0.11820509831248423`}, {
     0.6763428419867462, -0.39638947516759193`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.714683045111454, 0., -0.09270509831248423}, {
     0.7082370305860608, -0.07685852621143985, -0.11820509831248423`}, {
     0.6181521020097914, -0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.8236644243122581, 0., -0.2427050983124842}, {
     0.7801647408585914, -0.07685852621143985, -0.21720509831248422`}, {
     0.7082370305860608, -0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.6763428419867462, -0.39638947516759193`, -0.21720509831248422`}, {
     0.7801647408585914, -0.07685852621143985, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
     0.6013944228109941, -0.3486665278033908, 0.061185364886239595`}, {
     0.6013944228109941, -0.3486665278033908, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.714683045111454, 0., 0.09270509831248423}, {
     0.6914793513872635, -0.0714136261765981, 0.061185364886239595`}, {
     0.6013944228109941, -0.3486665278033908, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.714683045111454, 0., -0.09270509831248423}, {
     0.6914793513872635, -0.0714136261765981, -0.061185364886239595`}, {
     0.6914793513872635, -0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6013944228109941, -0.3486665278033908, -0.061185364886239595`}, {
     0.6914793513872635, -0.0714136261765981, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}, {0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}, {
     0.7801647408585914, -0.07685852621143985, 0.21720509831248422`}, {
     0.6763428419867462, -0.39638947516759193`, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.714683045111454, 0., 0.09270509831248423}, {
     0.7082370305860608, -0.07685852621143985, 0.11820509831248423`}, {
     0.7801647408585914, -0.07685852621143985, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
     0.6181521020097914, -0.3541114278382325, 0.11820509831248423`}, {
     0.7082370305860608, -0.07685852621143985, 0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.8143696108149852, -0.4790517260810333, 0.2902598667131223}, {
     0.7202150157017648, -0.41064440852415307`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {1., 0., 
     0.3}, {0.9404183945275197, -0.091113459568001, 0.2902598667131223}, {
     0.8143696108149852, -0.4790517260810333, 0.2902598667131223}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8236644243122581, 0., 
     0.2427050983124842}, {0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}, {0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}, {
     0.7202150157017648, -0.41064440852415307`, 0.2524452315993619}, {
     0.8240369145736102, -0.091113459568001, 0.2524452315993619}}]}},
  Boxed->False]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"g_Graphics3D", ",", " ", 
    RowBox[{"\[Alpha]_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", "<", "#", "<", "1"}], "&"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{"g", " ", "/.", " ", 
   RowBox[{
    RowBox[{"Polygon", "[", "x_", "]"}], " ", "\[Rule]", 
    RowBox[{"cutout", "[", 
     RowBox[{"x", ",", "\[Alpha]"}], "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"liste", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cutout", "[", 
  RowBox[{"liste", ",", "0.5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.333333333333333`", ",", "4.`", ",", "4.666666666666667`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.8333333333333333`", ",", "2.5`", ",", "3.166666666666667`"}], 
       "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.833333333333333`", ",", "2.5`", ",", "2.166666666666667`"}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.333333333333333`", ",", "4.`", ",", "4.666666666666667`"}], 
       "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1.8333333333333333`", ",", "2.5`", ",", "3.166666666666667`"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"2.833333333333333`", ",", "2.5`", ",", "2.166666666666667`"}],
        "}"}]}], "}"}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"CutOut", "[", 
   RowBox[{"p", ",", "0.5"}], "]"}]}]], "Input"],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{0.5, 0.8660254037844386, 0.}, {-0.5, 0.8660254037844386, 
    0.}, {-0.25, 0.4330127018922193, 0.}, {0.25, 0.4330127018922193, 0.}}], 
   Polygon3DBox[{{-0.5, 0.8660254037844386, 0.}, {-1., 0., 0.}, {-0.5, 0., 
    0.}, {-0.25, 0.4330127018922193, 0.}}], 
   Polygon3DBox[{{-1., 0., 0.}, {-0.5, -0.8660254037844386, 
    0.}, {-0.25, -0.4330127018922193, 0.}, {-0.5, 0., 0.}}], 
   Polygon3DBox[{{-0.5, -0.8660254037844386, 0.}, {0.5, -0.8660254037844386, 
    0.}, {0.25, -0.4330127018922193, 0.}, {-0.25, -0.4330127018922193, 0.}}], 
   Polygon3DBox[{{0.5, -0.8660254037844386, 0.}, {1., 0., 0.}, {0.5, 0., 
    0.}, {0.25, -0.4330127018922193, 0.}}], 
   Polygon3DBox[{{1., 0., 0.}, {0.5, 0.8660254037844386, 0.}, {0.25, 
    0.4330127018922193, 0.}, {0.5, 0., 0.}}]},
  Boxed->False,
  ViewPoint->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das ist eine sehr simple Version zum Entfernen der Bildkanten, die nur mit \
einfachen ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekten funktioniert. Hierzu wird in die Liste ",
 StyleBox["a",
  FontSlant->"Italic"],
 " der Grafikprimitive, aus denen das ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekt aufgebaut ist, an erster Stelle die Grafikdirektive ",
 StyleBox["EdgeForm[] ",
  FontWeight->"Bold"],
 "eingef\[UDoubleDot]gt. Diese bewirkt, dass alle folgenden Grafikprimitive \
ohne Kanten dargestellt werden. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NoEdges", "[", "g_Graphics3D", "]"}], ":=", 
  RowBox[{"g", "/.", 
   RowBox[{
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"{", "a__", "}"}], ",", "b___"}], "]"}], "->", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "]"}], ",", "a"}], "}"}], ",", "b"}], 
     "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"torushohl", "//", "NoEdges"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], 
   Polygon3DBox[{{1., 0., 0.3}, {1.1763355756877418`, 0., 
    0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
    1.285316954888546, 0., 0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, 0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
    1.285316954888546, 0., -0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
    1.1763355756877418`, 0., -0.2427050983124842}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {1., 
    0., -0.3}, {0.8090169943749475, 0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{1., 0., -0.3}, {0.8236644243122581, 
    0., -0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
    0.714683045111454, 0., -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
    0.714683045111454, 0., 0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
    0.8236644243122581, 0., 0.2427050983124842}, {0.6663585169306744, 
    0.48413780144871527`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {1., 0., 
    0.3}, {0.8090169943749475, 0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
    0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
    0.3635076839753495, 1.1187616146076378`, 0.2427050983124842}}], 
   Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {0.8090169943749475, 
    0.5877852522924731, -0.3}, {0.30901699437494745`, 
    0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
    0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
    0.2545263047745454, 0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
    0.30901699437494745`, 0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
    0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
    0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.30901699437494745`, 0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
    0.2427050983124842}, {-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, 
    1.2224090654513957`, -0.09270509831248423}, {-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, 
    1.1187616146076378`, -0.2427050983124842}, {-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, 
    0.9510565162951535, -0.3}, {-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, 
    0.7833514179826693, -0.2427050983124842}, {-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, 
    0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
    0.6797039671389115, 0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
    0.09270509831248423}, {-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
    0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
    0.3}, {-0.8090169943749475, 0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
    0.3}, {-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.1763355756877418`, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
    0.2427050983124842}, {-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-1.285316954888546, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
    0.09270509831248423}, {-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-1.285316954888546, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, 
    0.7554903506049574, -0.09270509831248423}, {-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-1.1763355756877418`, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, 
    0.6914327031362311, -0.2427050983124842}, {-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-1., 0., -0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, 
    0.5877852522924731, -0.3}, {-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.8236644243122581, 
    0., -0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, 
    0.48413780144871527`, -0.2427050983124842}, {-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.714683045111454, 
    0., -0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, 
    0.4200801539799889, -0.09270509831248423}, {-0.5781907290868035, 
    0.4200801539799889, 0.09270509831248423}, {-0.714683045111454, 0., 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
    0.09270509831248423}, {-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.8236644243122581, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
    0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 0.3}, {-1.,
     0., 0.3}}], 
   Polygon3DBox[{{-1., 0., 0.3}, {-1.1763355756877418`, 0., 
    0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0., 
    0.2427050983124842}, {-1.285316954888546, 0., 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.285316954888546, 0., 
    0.09270509831248423}, {-1.285316954888546, 
    0., -0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-1.285316954888546, 
    0., -0.09270509831248423}, {-1.1763355756877418`, 
    0., -0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-1.1763355756877418`, 0., -0.2427050983124842}, {-1., 
    0., -0.3}, {-0.8090169943749475, -0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{-1., 0., -0.3}, {-0.8236644243122581, 
    0., -0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.8236644243122581, 
    0., -0.2427050983124842}, {-0.714683045111454, 
    0., -0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.714683045111454, 
    0., -0.09270509831248423}, {-0.714683045111454, 0., 
    0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.714683045111454, 0., 
    0.09270509831248423}, {-0.8236644243122581, 0., 
    0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.8236644243122581, 0., 0.2427050983124842}, {-1., 0., 
    0.3}, {-0.8090169943749475, -0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}}], 
   Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
    0.3}, {-0.30901699437494745`, -0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
    0.3}, {-0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}}], 
   Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}}], 
   Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}}], 
   Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.30901699437494745`, -0.9510565162951535, 0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, 0.2427050983124842}}], 
   Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
    0.2427050983124842}, {0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}}], 
   Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
    0.09270509831248423}, {
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
    0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.8090169943749475, -0.5877852522924731, -0.3}}], 
   Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
    0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, 0.09270509831248423}}], 
   Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
    0.09270509831248423}, {0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}}], 
   Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
    0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
    0.8090169943749475, -0.5877852522924731, 0.3}}], 
   Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
    0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
    1.1763355756877418`, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
    0.2427050983124842}, {1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
    0.09270509831248423}, {
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    1.285316954888546, 0., -0.09270509831248423}}], 
   Polygon3DBox[{{
    1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    1.1763355756877418`, 0., -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
    0.8090169943749475, -0.5877852522924731, -0.3}, {1., 0., -0.3}}], 
   Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.8236644243122581, 0., -0.2427050983124842}}], 
   Polygon3DBox[{{
    0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.714683045111454, 0., -0.09270509831248423}}], 
   Polygon3DBox[{{
    0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
    0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
    0.714683045111454, 0., 0.09270509831248423}}], 
   Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
    0.09270509831248423}, {0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}}], 
   Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
    0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {1., 
    0., 0.3}}]},
  Boxed->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CutOut", "[", 
  RowBox[{"torus", ",", ".66"}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[{{
    Polygon3DBox[{{1., 0., 0.3}, {1.1763355756877418`, 0., 
     0.2427050983124842}, {1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}, {0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
     0.9627531949606478, 0.5650791102813524, 0.2524452315993619}, {
     1.1110288635138719`, 0.10873352621143985`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.8685985998474277, 0.49667179272447215`, 0.2902598667131223}, {
     0.9627531949606478, 0.5650791102813524, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {1., 0., 
     0.3}, {0.9946473835599623, 0.10873352621143985`, 0.2902598667131223}, {
     0.8685985998474277, 0.49667179272447215`, 0.2902598667131223}}]}, {
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     1.285316954888546, 0., 0.09270509831248423}, {1.2268287475014212`, 
     0.122988459568001, 0.11820509831248423`}, {1.1549010372288906`, 
     0.122988459568001, 0.21720509831248422`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.0398432596630913`, 0.7554903506049574, 0.09270509831248423}, {
     1.0648161086526213`, 0.6216120909672729, 0.11820509831248423`}, {
     1.2268287475014212`, 0.122988459568001, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}, {1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1549010372288906`, 0.122988459568001, 0.21720509831248422`}, {
     1.0066253686756665`, 0.5793340436379135, 0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.285316954888546, 0., -0.09270509831248423}, {1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}, {1.2435864267002186`, 
     0.12843335960284274`, 0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.0398432596630913`, 0.7554903506049574, -0.09270509831248423}, {
     1.0815737878514187`, 0.6270569910021146, -0.061185364886239595`}, {
     1.2435864267002186`, 0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, 0.09270509831248423}, {1.0815737878514187`, 
     0.6270569910021146, 0.061185364886239595`}, {1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}, {
     1.2435864267002186`, 0.12843335960284274`, 0.061185364886239595`}, {
     1.0815737878514187`, 0.6270569910021146, 0.061185364886239595`}}]}, {
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.1763355756877418`, 0., -0.2427050983124842}, {1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}, {1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     0.9516754718192205, 0.6914327031362311, -0.2427050983124842}, {
     1.0066253686756665`, 0.5793340436379135, -0.21720509831248422`}, {
     1.1549010372288906`, 0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}, {1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.285316954888546, 
     0., -0.09270509831248423}, {1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}, {1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {1., 
     0., -0.3}, {0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}, {1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., -0.3}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}, {0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.9516754718192205, 0.6914327031362311, -0.2427050983124842}, {
     0.9627531949606478, 0.5650791102813524, -0.2524452315993619}, {
     0.8685985998474277, 0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {1.1763355756877418`, 
     0., -0.2427050983124842}, {1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}, {0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}}]}, {
    Polygon3DBox[{{1., 0., -0.3}, {0.8236644243122581, 
     0., -0.2427050983124842}, {0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}, {0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
     0.7202150157017648, 0.41064440852415307`, -0.2524452315993619}, {
     0.8240369145736102, 0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}, {0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {1., 
     0., -0.3}, {0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}, {0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.714683045111454, 0., -0.09270509831248423}, {0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}, {0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.5781907290868035, 0.4200801539799889, -0.09270509831248423}, {
     0.6181521020097914, 0.3541114278382325, -0.11820509831248423`}, {
     0.7082370305860608, 0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}, {0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.8236644243122581, 
     0., -0.2427050983124842}, {0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}, {0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.714683045111454, 0., 0.09270509831248423}, {0.6914793513872635, 
     0.0714136261765981, 0.061185364886239595`}, {0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.5781907290868035, 0.4200801539799889, 0.09270509831248423}, {
     0.6013944228109941, 0.3486665278033908, 0.061185364886239595`}, {
     0.6914793513872635, 0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}, {0.6013944228109941, 
     0.3486665278033908, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.714683045111454, 
     0., -0.09270509831248423}, {0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}, {0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.8236644243122581, 0., 0.2427050983124842}, {0.7801647408585914, 
     0.07685852621143985, 0.21720509831248422`}, {0.7082370305860608, 
     0.07685852621143985, 0.11820509831248423`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}, {
     0.6763428419867462, 0.39638947516759193`, 0.21720509831248422`}, {
     0.7801647408585914, 0.07685852621143985, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}, {0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.714683045111454, 0., 0.09270509831248423}, {
     0.7082370305860608, 0.07685852621143985, 0.11820509831248423`}, {
     0.6181521020097914, 0.3541114278382325, 0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {1., 0., 
     0.3}, {0.9404183945275197, 0.091113459568001, 0.2902598667131223}, {
     0.8240369145736102, 0.091113459568001, 0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8090169943749475, 0.5877852522924731, 
     0.3}, {0.8143696108149852, 0.4790517260810333, 0.2902598667131223}, {
     0.9404183945275197, 0.091113459568001, 0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}, {
     0.7202150157017648, 0.41064440852415307`, 0.2524452315993619}, {
     0.8143696108149852, 0.4790517260810333, 0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}, {
     0.8240369145736102, 0.091113459568001, 0.2524452315993619}, {
     0.7202150157017648, 0.41064440852415307`, 0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
     0.834929268686965, 0.7410136514080896, 0.2524452315993619}, {
     0.7407746735737448, 0.6726063338512094, 0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}, {0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.4107746735737448, 0.9123653680929784, 0.2902598667131223}, {
     0.4467385287100102, 1.023050732979218, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.8090169943749475, 0.5877852522924731, 0.3}, {0.7407746735737448, 
     0.6726063338512094, 0.2902598667131223}, {0.4107746735737448, 
     0.9123653680929784, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}, {0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}, {0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}, {0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}, {0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}, {0.9305913184975649, 
     0.834866532128852, 0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}, {0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {0.5064367233843448, 
     1.1430328839275012`, 0.061185364886239595`}, {0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9305913184975649, 0.834866532128852, 
     0.061185364886239595`}, {0.5064367233843448, 1.1430328839275012`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}, {0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}, {0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}, {0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}, {0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}, {0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.30901699437494745`, 0.9510565162951535, -0.3}, {0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}, {0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.3635076839753495, 1.1187616146076378`, -0.2427050983124842}, {
     0.4467385287100102, 1.023050732979218, -0.2524452315993619}, {
     0.4107746735737448, 0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}, {0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
     0.6131047200629298, 0.558069082937768, -0.2524452315993619}, {
     0.70725931517615, 0.6264764004946483, -0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}, {0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}, {0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.8090169943749475, 0.5877852522924731, -0.3}, {0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}, {0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}, {0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}, {0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}, {0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}, {0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {0.5174426702523299, 
     0.4642162022170057, 0.061185364886239595`}, {0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.2815972653655501, 0.6355679189018946, 
     0.061185364886239595`}, {0.5174426702523299, 0.4642162022170057, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}, {0.2815972653655501, 
     0.6355679189018946, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}, {0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}, {0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}, {0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}, {0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}, {0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.70725931517615, 0.6264764004946483, 0.2902598667131223}, {
     0.6131047200629298, 0.558069082937768, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.3772593151761501, 
     0.8662354347364173, 0.2902598667131223}, {0.70725931517615, 
     0.6264764004946483, 0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.2545263047745454, 0.7833514179826693, 0.2427050983124842}, {
     0.3412954600398847, 0.7555500698501777, 0.2524452315993619}, {
     0.3772593151761501, 0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}, {0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.3635076839753495, 1.1187616146076378`, 0.2427050983124842}, {
     0.23991507142373067`, 1.0902517478945155`, 0.2524452315993619}, {
     0.20395121628746532`, 0.9795663830082759, 0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}, {0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.20395121628746532`, 0.9795663830082759, 
     0.2902598667131223}, {-0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.20395121628746532`, 
     0.9795663830082759, 0.2902598667131223}, {-0.20395121628746532`, 
     0.9795663830082759, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}, {0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}, {0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}, {-0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}, {-0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}, {0.26214195626442016`, 
     1.2224090654513957`, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}, {0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {-0.26214195626442016`, 
     1.2224090654513957`, 0.061185364886239595`}, {-0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, 1.2224090654513957`, 
     0.061185364886239595`}, {-0.26214195626442016`, 1.2224090654513957`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}, {0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}, {0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}, {-0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}, {-0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}, {0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}, {0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}, {-0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}, {-0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.2545263047745454, 0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, 0.8118612846957916, -0.2524452315993619}, {
     0.20395121628746532`, 0.9225466495820311, -0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}, {0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}, {-0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.30901699437494745`, 0.9510565162951535, -0.3}, {0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}, {-0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}, {0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}, {0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}, {-0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}, {-0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {0.14576047631051048`, 
     0.6797039671389115, 0.061185364886239595`}, {0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, 0.6797039671389115, 
     0.061185364886239595`}, {0.14576047631051048`, 0.6797039671389115, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}, {-0.14576047631051048`, 
     0.6797039671389115, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}, {-0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}, {0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}, {0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}, {-0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}, {-0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}, {
     0.16798736115119997`, 0.8118612846957916, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}, {
     0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}, {-0.20395121628746532`, 0.9225466495820311, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}, {-0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}, {-0.4107746735737448, 0.9123653680929784, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}, {-0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.7407746735737448, 0.6726063338512094, 
     0.2902598667131223}, {-0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.4107746735737448, 0.9123653680929784, 
     0.2902598667131223}, {-0.7407746735737448, 0.6726063338512094, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}, {-0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}, {-0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}, {-0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}, {-0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}, {-0.5064367233843448, 
     1.1430328839275012`, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}, {-0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, 0.09270509831248423}, {-0.9305913184975649, 
     0.834866532128852, 0.061185364886239595`}, {-0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.5064367233843448, 1.1430328839275012`, 
     0.061185364886239595`}, {-0.9305913184975649, 0.834866532128852, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}, {-0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}, {-0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}, {-0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}, {-0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}, {-0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}, {-0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}, {-0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}, {-0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}, {-0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}, {-0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}, {-0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}, {-0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}, {-0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}, {-0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}, {-0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}, {-0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {-0.2815972653655501, 
     0.6355679189018946, 0.061185364886239595`}, {-0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5174426702523299, 0.4642162022170057, 
     0.061185364886239595`}, {-0.2815972653655501, 0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}, {-0.5174426702523299, 
     0.4642162022170057, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}, {-0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}, {-0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}, {-0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}, {-0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}, {-0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.3772593151761501, 0.8662354347364173, 
     0.2902598667131223}, {-0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.8090169943749475, 0.5877852522924731, 0.3}, {-0.70725931517615,
      0.6264764004946483, 0.2902598667131223}, {-0.3772593151761501, 
     0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}, {-0.70725931517615, 0.6264764004946483, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}, {-0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.9627531949606478, 0.5650791102813524, 
     0.2524452315993619}, {-0.8685985998474277, 0.49667179272447215`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}, {-0.9627531949606478, 0.5650791102813524, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 0.2427050983124842}, {-1., 0., 
     0.3}, {-0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}, {-1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8685985998474277, 0.49667179272447215`, 
     0.2902598667131223}, {-0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}, {-1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2268287475014212`, 0.122988459568001, 
     0.11820509831248423`}, {-1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1549010372288906`, 0.122988459568001, 
     0.21720509831248422`}, {-1.2268287475014212`, 0.122988459568001, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}, {-1.1549010372288906`, 0.122988459568001, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}, {-1.0815737878514187`, 
     0.6270569910021146, 0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}, {-1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2435864267002186`, 0.12843335960284274`, 
     0.061185364886239595`}, {-1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0815737878514187`, 0.6270569910021146, 
     0.061185364886239595`}, {-1.2435864267002186`, 0.12843335960284274`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}, {-1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}, {-1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}, {-1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}, {-1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}, {-0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, -0.3}, {-1., 
     0., -0.3}, {-0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}, {-0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{-1., 0., -0.3}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}, {-0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}, {-1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}, {-0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}, {-0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., -0.2427050983124842}, {-1., 
     0., -0.3}, {-0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}, {-0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}, {-0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}, {-0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}, {-0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}, {-0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}, {-0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {-0.6013944228109941, 
     0.3486665278033908, 0.061185364886239595`}, {-0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.6914793513872635, 0.0714136261765981, 
     0.061185364886239595`}, {-0.6013944228109941, 0.3486665278033908, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}, {-0.6914793513872635, 
     0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}, {-0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}, {-0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.7801647408585914, 0.07685852621143985, 
     0.21720509831248422`}, {-0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.7082370305860608, 0.07685852621143985, 
     0.11820509831248423`}, {-0.7801647408585914, 0.07685852621143985, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}, {-0.7082370305860608, 0.07685852621143985, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8143696108149852, 0.4790517260810333, 
     0.2902598667131223}, {-0.7202150157017648, 0.41064440852415307`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 0.3}, {-1., 0., 
     0.3}, {-0.9404183945275197, 0.091113459568001, 
     0.2902598667131223}, {-0.8143696108149852, 0.4790517260810333, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.8240369145736102, 0.091113459568001, 
     0.2524452315993619}, {-0.9404183945275197, 0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.7202150157017648, 0.41064440852415307`, 
     0.2524452315993619}, {-0.8240369145736102, 0.091113459568001, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-1., 0., 0.3}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1110288635138719`, -0.10873352621143985`, 
     0.2524452315993619}, {-0.9946473835599623, -0.10873352621143985`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.9627531949606478, -0.5650791102813524, 
     0.2524452315993619}, {-1.1110288635138719`, -0.10873352621143985`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8685985998474277, -0.49667179272447215`, 
     0.2902598667131223}, {-0.9627531949606478, -0.5650791102813524, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 0.3}, {-1., 0., 
     0.3}, {-0.9946473835599623, -0.10873352621143985`, 
     0.2902598667131223}, {-0.8685985998474277, -0.49667179272447215`, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2268287475014212`, -0.122988459568001, 
     0.11820509831248423`}, {-1.1549010372288906`, -0.122988459568001, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}, {-1.2268287475014212`, -0.122988459568001, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}, {-1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1549010372288906`, -0.122988459568001, 
     0.21720509831248422`}, {-1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2435864267002186`, -0.12843335960284274`, \
-0.061185364886239595`}, {-1.2435864267002186`, -0.12843335960284274`, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0815737878514187`, -0.6270569910021146, \
-0.061185364886239595`}, {-1.2435864267002186`, -0.12843335960284274`, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0815737878514187`, -0.6270569910021146, 
     0.061185364886239595`}, {-1.0815737878514187`, -0.6270569910021146, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2435864267002186`, -0.12843335960284274`, 
     0.061185364886239595`}, {-1.0815737878514187`, -0.6270569910021146, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1549010372288906`, -0.122988459568001, \
-0.21720509831248422`}, {-1.2268287475014212`, -0.122988459568001, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0066253686756665`, -0.5793340436379135, \
-0.21720509831248422`}, {-1.1549010372288906`, -0.122988459568001, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0648161086526213`, -0.6216120909672729, \
-0.11820509831248423`}, {-1.0066253686756665`, -0.5793340436379135, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2268287475014212`, -0.122988459568001, \
-0.11820509831248423`}, {-1.0648161086526213`, -0.6216120909672729, \
-0.11820509831248423`}}]}, {
    Polygon3DBox[{{-1.1763355756877418`, 0., -0.2427050983124842}, {-1., 
     0., -0.3}, {-0.9946473835599623, -0.10873352621143985`, \
-0.2902598667131223}, {-1.1110288635138719`, -0.10873352621143985`, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-1., 
     0., -0.3}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}, \
{-0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, \
{-0.9627531949606478, -0.5650791102813524, -0.2524452315993619}, \
{-0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1110288635138719`, -0.10873352621143985`, \
-0.2524452315993619}, {-0.9627531949606478, -0.5650791102813524, \
-0.2524452315993619}}]}, {
    Polygon3DBox[{{-1., 0., -0.3}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.8240369145736102, -0.091113459568001, \
-0.2524452315993619}, {-0.9404183945275197, -0.091113459568001, \
-0.2902598667131223}}], 
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.7202150157017648, -0.41064440852415307`, \
-0.2524452315993619}, {-0.8240369145736102, -0.091113459568001, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.8143696108149852, -0.4790517260810333, -0.2902598667131223}, \
{-0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, {-1., 
     0., -0.3}, {-0.9404183945275197, -0.091113459568001, \
-0.2902598667131223}, {-0.8143696108149852, -0.4790517260810333, \
-0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.7082370305860608, -0.07685852621143985, \
-0.11820509831248423`}, {-0.7801647408585914, -0.07685852621143985, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6181521020097914, -0.3541114278382325, \
-0.11820509831248423`}, {-0.7082370305860608, -0.07685852621143985, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.6763428419867462, -0.39638947516759193`, \
-0.21720509831248422`}, {-0.6181521020097914, -0.3541114278382325, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.7801647408585914, -0.07685852621143985, \
-0.21720509831248422`}, {-0.6763428419867462, -0.39638947516759193`, \
-0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.6914793513872635, -0.0714136261765981, 
     0.061185364886239595`}, {-0.6914793513872635, -0.0714136261765981, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6013944228109941, -0.3486665278033908, 
     0.061185364886239595`}, {-0.6914793513872635, -0.0714136261765981, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6013944228109941, -0.3486665278033908, \
-0.061185364886239595`}, {-0.6013944228109941, -0.3486665278033908, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.6914793513872635, -0.0714136261765981, \
-0.061185364886239595`}, {-0.6013944228109941, -0.3486665278033908, \
-0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.7801647408585914, -0.07685852621143985, 
     0.21720509831248422`}, {-0.7082370305860608, -0.07685852621143985, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}, {-0.7801647408585914, -0.07685852621143985, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}, {-0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.7082370305860608, -0.07685852621143985, 
     0.11820509831248423`}, {-0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.8236644243122581, 0., 0.2427050983124842}, {-1., 0., 
     0.3}, {-0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}, {-0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8143696108149852, -0.4790517260810333, 
     0.2902598667131223}, {-0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.7202150157017648, -0.41064440852415307`, 
     0.2524452315993619}, {-0.8143696108149852, -0.4790517260810333, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}, {-0.7202150157017648, -0.41064440852415307`, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}, {-0.7407746735737448, -0.6726063338512094, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}, {-0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.4107746735737448, -0.9123653680929784, 
     0.2902598667131223}, {-0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.7407746735737448, -0.6726063338512094, 
     0.2902598667131223}, {-0.4107746735737448, -0.9123653680929784, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}, {-0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}, {-0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}, {-0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}, {-0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9305913184975649, -0.834866532128852, \
-0.061185364886239595`}, {-0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.5064367233843448, -1.1430328839275012`, \
-0.061185364886239595`}, {-0.9305913184975649, -0.834866532128852, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}, {-0.5064367233843448, -1.1430328839275012`, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}, {-0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8620437632031863, -0.7783335514429314, \
-0.21720509831248422`}, {-0.9202345031801411, -0.8206115987722907, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.4738530232262314, -1.0603706330140596`, \
-0.21720509831248422`}, {-0.8620437632031863, -0.7783335514429314, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.4960799080669209, -1.12877795057094, \
-0.11820509831248423`}, {-0.4738530232262314, -1.0603706330140596`, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9202345031801411, -0.8206115987722907, \
-0.11820509831248423`}, {-0.4960799080669209, -1.12877795057094, \
-0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.7407746735737448, -0.6726063338512094, -0.2902598667131223}, \
{-0.834929268686965, -0.7410136514080896, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.4107746735737448, \
-0.9123653680929784, -0.2902598667131223}, {-0.7407746735737448, \
-0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.4467385287100102, -1.023050732979218, -0.2524452315993619}, \
{-0.4107746735737448, -0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.834929268686965, -0.7410136514080896, \
-0.2524452315993619}, {-0.4467385287100102, -1.023050732979218, \
-0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, \
{-0.6131047200629298, -0.558069082937768, -0.2524452315993619}, \
{-0.70725931517615, -0.6264764004946483, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.3412954600398847, -0.7555500698501777, \
-0.2524452315993619}, {-0.6131047200629298, -0.558069082937768, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.3772593151761501, -0.8662354347364173, -0.2902598667131223}, \
{-0.3412954600398847, -0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.8090169943749475, -0.5877852522924731, -0.3}, {-0.70725931517615, \
-0.6264764004946483, -0.2902598667131223}, {-0.3772593151761501, \
-0.8662354347364173, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5277994855697539, -0.47847113557356685`, \
-0.11820509831248423`}, {-0.5859902255467087, -0.5207491829029263, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.29195408068297396`, -0.6498228522584557, \
-0.11820509831248423`}, {-0.5277994855697539, -0.47847113557356685`, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.3141809655236635, -0.7182301698153359, \
-0.21720509831248422`}, {-0.29195408068297396`, -0.6498228522584557, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5859902255467087, -0.5207491829029263, \
-0.21720509831248422`}, {-0.3141809655236635, -0.7182301698153359, \
-0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}, {-0.5174426702523299, -0.4642162022170057, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}, {-0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2815972653655501, -0.6355679189018946, \
-0.061185364886239595`}, {-0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5174426702523299, -0.4642162022170057, \
-0.061185364886239595`}, {-0.2815972653655501, -0.6355679189018946, \
-0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}, {-0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}, {-0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}, {-0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}, {-0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.70725931517615, -0.6264764004946483, 
     0.2902598667131223}, {-0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.3772593151761501, -0.8662354347364173, 
     0.2902598667131223}, {-0.70725931517615, -0.6264764004946483, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}, {-0.3772593151761501, -0.8662354347364173, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}, {-0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}, {-0.20395121628746532`, -0.9795663830082759, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}, {-0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}, {
     0.23991507142373067`, -1.0902517478945155`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}, {
     0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}, {-0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}, {-0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}, {0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}, {0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.26214195626442016`, -1.2224090654513957`, \
-0.061185364886239595`}, {-0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}, \
{-0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, 0.09270509831248423}, {
     0.26214195626442016`, -1.2224090654513957`, 0.061185364886239595`}, {
     0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}, {0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.23991507142373067`, -1.1363816812510765`, \
-0.21720509831248422`}, {-0.26214195626442016`, -1.2047889988079568`, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}, \
{-0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}, {
     0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}, {
     0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}, \
{-0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}, \
{-0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}, {
     0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}, {
     0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}, \
{-0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}, \
{-0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}, {
     0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.20395121628746532`, \
-0.9225466495820311, -0.2902598667131223}, {
     0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.14576047631051048`, -0.6973240337823503, \
-0.11820509831248423`}, {-0.16798736115119997`, -0.7657313513392304, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}, \
{-0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}, {
     0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}, {
     0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}, {-0.14576047631051048`, -0.6797039671389115, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}, {-0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}, {
     0.14576047631051048`, -0.6797039671389115, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, \
{-0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, \
{-0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}, {
     0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}, {-0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}, {-0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}, {0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}, {0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}, {-0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}, {-0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.2545263047745454, -0.7833514179826693, 0.2427050983124842}, {
     0.16798736115119997`, -0.8118612846957916, 0.2524452315993619}, {
     0.20395121628746532`, -0.9225466495820311, 0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}, {0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
     0.4467385287100102, -1.023050732979218, 0.2524452315993619}, {
     0.4107746735737448, -0.9123653680929784, 0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}, {0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.7407746735737448, -0.6726063338512094, 0.2902598667131223}, {
     0.834929268686965, -0.7410136514080896, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.4107746735737448, -0.9123653680929784, 0.2902598667131223}, {
     0.7407746735737448, -0.6726063338512094, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}, {0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}, {0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}, {0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}, {0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.5064367233843448, -1.1430328839275012`, -0.061185364886239595`}, {
     0.5064367233843448, -1.1430328839275012`, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9305913184975649, -0.834866532128852, -0.061185364886239595`}, {
     0.5064367233843448, -1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, 0.09270509831248423}, {
     0.9305913184975649, -0.834866532128852, 0.061185364886239595`}, {
     0.9305913184975649, -0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}, {0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.4738530232262314, -1.0603706330140596`, -0.21720509831248422`}, {
     0.4960799080669209, -1.12877795057094, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.8620437632031863, -0.7783335514429314, -0.21720509831248422`}, {
     0.4738530232262314, -1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9202345031801411, -0.8206115987722907, -0.11820509831248423`}, {
     0.8620437632031863, -0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.4960799080669209, -1.12877795057094, -0.11820509831248423`}, {
     0.9202345031801411, -0.8206115987722907, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.4107746735737448, -0.9123653680929784, -0.2902598667131223}, {
     0.4467385287100102, -1.023050732979218, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.7407746735737448, -0.6726063338512094, -0.2902598667131223}, {
     0.4107746735737448, -0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.834929268686965, -0.7410136514080896, -0.2524452315993619}, {
     0.7407746735737448, -0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.4467385287100102, -1.023050732979218, -0.2524452315993619}, {
     0.834929268686965, -0.7410136514080896, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.3412954600398847, -0.7555500698501777, -0.2524452315993619}, {
     0.3772593151761501, -0.8662354347364173, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.6131047200629298, -0.558069082937768, -0.2524452315993619}, {
     0.3412954600398847, -0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.70725931517615, -0.6264764004946483, -0.2902598667131223}, {
     0.6131047200629298, -0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.3772593151761501, -0.8662354347364173, -0.2902598667131223}, {
     0.70725931517615, -0.6264764004946483, -0.2902598667131223}}]}, {
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.29195408068297396`, -0.6498228522584557, -0.11820509831248423`}, {
     0.3141809655236635, -0.7182301698153359, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5277994855697539, -0.47847113557356685`, -0.11820509831248423`}, {
     0.29195408068297396`, -0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.5859902255467087, -0.5207491829029263, -0.21720509831248422`}, {
     0.5277994855697539, -0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.3141809655236635, -0.7182301698153359, -0.21720509831248422`}, {
     0.5859902255467087, -0.5207491829029263, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
     0.2815972653655501, -0.6355679189018946, 0.061185364886239595`}, {
     0.2815972653655501, -0.6355679189018946, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}, {0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5174426702523299, -0.4642162022170057, -0.061185364886239595`}, {
     0.5174426702523299, -0.4642162022170057, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2815972653655501, -0.6355679189018946, -0.061185364886239595`}, {
     0.5174426702523299, -0.4642162022170057, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}, {0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}, {0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}, {0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}, {0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.3772593151761501, -0.8662354347364173, 0.2902598667131223}, {
     0.3412954600398847, -0.7555500698501777, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.70725931517615, -0.6264764004946483, 0.2902598667131223}, {
     0.3772593151761501, -0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}, {
     0.6131047200629298, -0.558069082937768, 0.2524452315993619}, {
     0.70725931517615, -0.6264764004946483, 0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}, {0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
     0.9627531949606478, -0.5650791102813524, 0.2524452315993619}, {
     0.8685985998474277, -0.49667179272447215`, 0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1110288635138719`, -0.10873352621143985`, 0.2524452315993619}, {
     0.9627531949606478, -0.5650791102813524, 0.2524452315993619}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {1., 0., 
     0.3}, {0.9946473835599623, -0.10873352621143985`, 0.2902598667131223}, {
     1.1110288635138719`, -0.10873352621143985`, 0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8090169943749475, -0.5877852522924731, 
     0.3}, {0.8685985998474277, -0.49667179272447215`, 0.2902598667131223}, {
     0.9946473835599623, -0.10873352621143985`, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}, {1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}, {
     1.2268287475014212`, -0.122988459568001, 0.11820509831248423`}, {
     1.0648161086526213`, -0.6216120909672729, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1549010372288906`, -0.122988459568001, 0.21720509831248422`}, {
     1.2268287475014212`, -0.122988459568001, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, 0.2427050983124842}, {
     1.0066253686756665`, -0.5793340436379135, 0.21720509831248422`}, {
     1.1549010372288906`, -0.122988459568001, 0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0815737878514187`, -0.6270569910021146, -0.061185364886239595`}, {
     1.0815737878514187`, -0.6270569910021146, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.285316954888546, 0., -0.09270509831248423}, {
     1.2435864267002186`, -0.12843335960284274`, -0.061185364886239595`}, {
     1.0815737878514187`, -0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.285316954888546, 0., 0.09270509831248423}, {
     1.2435864267002186`, -0.12843335960284274`, 0.061185364886239595`}, {
     1.2435864267002186`, -0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, 0.09270509831248423}, {
     1.0815737878514187`, -0.6270569910021146, 0.061185364886239595`}, {
     1.2435864267002186`, -0.12843335960284274`, 0.061185364886239595`}}]}, {
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.0066253686756665`, -0.5793340436379135, -0.21720509831248422`}, {
     1.0648161086526213`, -0.6216120909672729, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.1763355756877418`, 0., -0.2427050983124842}, {
     1.1549010372288906`, -0.122988459568001, -0.21720509831248422`}, {
     1.0066253686756665`, -0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     1.285316954888546, 0., -0.09270509831248423}, {
     1.2268287475014212`, -0.122988459568001, -0.11820509831248423`}, {
     1.1549010372288906`, -0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0648161086526213`, -0.6216120909672729, -0.11820509831248423`}, {
     1.2268287475014212`, -0.122988459568001, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}, {
     0.9627531949606478, -0.5650791102813524, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {1., 
     0., -0.3}, {
     0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}, {
     0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{1., 0., -0.3}, {1.1763355756877418`, 
     0., -0.2427050983124842}, {
     1.1110288635138719`, -0.10873352621143985`, -0.2524452315993619}, {
     0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.9627531949606478, -0.5650791102813524, -0.2524452315993619}, {
     1.1110288635138719`, -0.10873352621143985`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}, {
     0.8143696108149852, -0.4790517260810333, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.8236644243122581, 0., -0.2427050983124842}, {
     0.8240369145736102, -0.091113459568001, -0.2524452315993619}, {
     0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {1., 
     0., -0.3}, {
     0.9404183945275197, -0.091113459568001, -0.2902598667131223}, {
     0.8240369145736102, -0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.8143696108149852, -0.4790517260810333, -0.2902598667131223}, {
     0.9404183945275197, -0.091113459568001, -0.2902598667131223}}]}, {
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6181521020097914, -0.3541114278382325, -0.11820509831248423`}, {
     0.6763428419867462, -0.39638947516759193`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.714683045111454, 0., -0.09270509831248423}, {
     0.7082370305860608, -0.07685852621143985, -0.11820509831248423`}, {
     0.6181521020097914, -0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.8236644243122581, 0., -0.2427050983124842}, {
     0.7801647408585914, -0.07685852621143985, -0.21720509831248422`}, {
     0.7082370305860608, -0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.6763428419867462, -0.39638947516759193`, -0.21720509831248422`}, {
     0.7801647408585914, -0.07685852621143985, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
     0.6013944228109941, -0.3486665278033908, 0.061185364886239595`}, {
     0.6013944228109941, -0.3486665278033908, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.714683045111454, 0., 0.09270509831248423}, {
     0.6914793513872635, -0.0714136261765981, 0.061185364886239595`}, {
     0.6013944228109941, -0.3486665278033908, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.714683045111454, 0., -0.09270509831248423}, {
     0.6914793513872635, -0.0714136261765981, -0.061185364886239595`}, {
     0.6914793513872635, -0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6013944228109941, -0.3486665278033908, -0.061185364886239595`}, {
     0.6914793513872635, -0.0714136261765981, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}, {0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}, {
     0.7801647408585914, -0.07685852621143985, 0.21720509831248422`}, {
     0.6763428419867462, -0.39638947516759193`, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.714683045111454, 0., 0.09270509831248423}, {
     0.7082370305860608, -0.07685852621143985, 0.11820509831248423`}, {
     0.7801647408585914, -0.07685852621143985, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, 0.09270509831248423}, {
     0.6181521020097914, -0.3541114278382325, 0.11820509831248423`}, {
     0.7082370305860608, -0.07685852621143985, 0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.8143696108149852, -0.4790517260810333, 0.2902598667131223}, {
     0.7202150157017648, -0.41064440852415307`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {1., 0., 
     0.3}, {0.9404183945275197, -0.091113459568001, 0.2902598667131223}, {
     0.8143696108149852, -0.4790517260810333, 0.2902598667131223}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8236644243122581, 0., 
     0.2427050983124842}, {0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}, {0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}, {
     0.7202150157017648, -0.41064440852415307`, 0.2524452315993619}, {
     0.8240369145736102, -0.091113459568001, 0.2524452315993619}}]}},
  Boxed->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"torus", ",", ".66"}], "]"}], "//", "NoEdges"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[
   None], {Polygon3DBox[{{1., 0., 0.3}, {1.1763355756877418`, 0., 
     0.2427050983124842}, {1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}, {0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
     0.9627531949606478, 0.5650791102813524, 0.2524452315993619}, {
     1.1110288635138719`, 0.10873352621143985`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.8685985998474277, 0.49667179272447215`, 0.2902598667131223}, {
     0.9627531949606478, 0.5650791102813524, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {1., 0., 
     0.3}, {0.9946473835599623, 0.10873352621143985`, 0.2902598667131223}, {
     0.8685985998474277, 0.49667179272447215`, 0.2902598667131223}}]}, {
    Polygon3DBox[{{1.1763355756877418`, 0., 0.2427050983124842}, {
     1.285316954888546, 0., 0.09270509831248423}, {1.2268287475014212`, 
     0.122988459568001, 0.11820509831248423`}, {1.1549010372288906`, 
     0.122988459568001, 0.21720509831248422`}}], 
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.0398432596630913`, 0.7554903506049574, 0.09270509831248423}, {
     1.0648161086526213`, 0.6216120909672729, 0.11820509831248423`}, {
     1.2268287475014212`, 0.122988459568001, 0.11820509831248423`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}, {1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.1763355756877418`, 0., 0.2427050983124842}, {
     1.1549010372288906`, 0.122988459568001, 0.21720509831248422`}, {
     1.0066253686756665`, 0.5793340436379135, 0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.285316954888546, 0., 0.09270509831248423}, {
     1.285316954888546, 0., -0.09270509831248423}, {1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}, {1.2435864267002186`, 
     0.12843335960284274`, 0.061185364886239595`}}], 
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.0398432596630913`, 0.7554903506049574, -0.09270509831248423}, {
     1.0815737878514187`, 0.6270569910021146, -0.061185364886239595`}, {
     1.2435864267002186`, 0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, 0.09270509831248423}, {1.0815737878514187`, 
     0.6270569910021146, 0.061185364886239595`}, {1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.285316954888546, 0., 0.09270509831248423}, {
     1.2435864267002186`, 0.12843335960284274`, 0.061185364886239595`}, {
     1.0815737878514187`, 0.6270569910021146, 0.061185364886239595`}}]}, {
    Polygon3DBox[{{1.285316954888546, 0., -0.09270509831248423}, {
     1.1763355756877418`, 0., -0.2427050983124842}, {1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}, {1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}}], 
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {
     0.9516754718192205, 0.6914327031362311, -0.2427050983124842}, {
     1.0066253686756665`, 0.5793340436379135, -0.21720509831248422`}, {
     1.1549010372288906`, 0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}, {1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {1.285316954888546, 
     0., -0.09270509831248423}, {1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}, {1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{1.1763355756877418`, 0., -0.2427050983124842}, {1., 
     0., -0.3}, {0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}, {1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., -0.3}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}, {0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.9516754718192205, 0.6914327031362311, -0.2427050983124842}, {
     0.9627531949606478, 0.5650791102813524, -0.2524452315993619}, {
     0.8685985998474277, 0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {1.1763355756877418`, 
     0., -0.2427050983124842}, {1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}, {0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}}]}, {
    Polygon3DBox[{{1., 0., -0.3}, {0.8236644243122581, 
     0., -0.2427050983124842}, {0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}, {0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
     0.7202150157017648, 0.41064440852415307`, -0.2524452315993619}, {
     0.8240369145736102, 0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}, {0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {1., 
     0., -0.3}, {0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}, {0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.8236644243122581, 0., -0.2427050983124842}, {
     0.714683045111454, 0., -0.09270509831248423}, {0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}, {0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.5781907290868035, 0.4200801539799889, -0.09270509831248423}, {
     0.6181521020097914, 0.3541114278382325, -0.11820509831248423`}, {
     0.7082370305860608, 0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}, {0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.8236644243122581, 
     0., -0.2427050983124842}, {0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}, {0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.714683045111454, 0., -0.09270509831248423}, {
     0.714683045111454, 0., 0.09270509831248423}, {0.6914793513872635, 
     0.0714136261765981, 0.061185364886239595`}, {0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.5781907290868035, 0.4200801539799889, 0.09270509831248423}, {
     0.6013944228109941, 0.3486665278033908, 0.061185364886239595`}, {
     0.6914793513872635, 0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}, {0.6013944228109941, 
     0.3486665278033908, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.714683045111454, 
     0., -0.09270509831248423}, {0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}, {0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.714683045111454, 0., 0.09270509831248423}, {
     0.8236644243122581, 0., 0.2427050983124842}, {0.7801647408585914, 
     0.07685852621143985, 0.21720509831248422`}, {0.7082370305860608, 
     0.07685852621143985, 0.11820509831248423`}}], 
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {
     0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}, {
     0.6763428419867462, 0.39638947516759193`, 0.21720509831248422`}, {
     0.7801647408585914, 0.07685852621143985, 0.21720509831248422`}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}, {0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.714683045111454, 0., 0.09270509831248423}, {
     0.7082370305860608, 0.07685852621143985, 0.11820509831248423`}, {
     0.6181521020097914, 0.3541114278382325, 0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.8236644243122581, 0., 0.2427050983124842}, {1., 0., 
     0.3}, {0.9404183945275197, 0.091113459568001, 0.2902598667131223}, {
     0.8240369145736102, 0.091113459568001, 0.2524452315993619}}], 
    Polygon3DBox[{{1., 0., 0.3}, {0.8090169943749475, 0.5877852522924731, 
     0.3}, {0.8143696108149852, 0.4790517260810333, 0.2902598667131223}, {
     0.9404183945275197, 0.091113459568001, 0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.6663585169306744, 0.48413780144871527`, 0.2427050983124842}, {
     0.7202150157017648, 0.41064440852415307`, 0.2524452315993619}, {
     0.8143696108149852, 0.4790517260810333, 0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.8236644243122581, 0., 0.2427050983124842}, {
     0.8240369145736102, 0.091113459568001, 0.2524452315993619}, {
     0.7202150157017648, 0.41064440852415307`, 0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.9516754718192205, 0.6914327031362311, 0.2427050983124842}, {
     0.834929268686965, 0.7410136514080896, 0.2524452315993619}, {
     0.7407746735737448, 0.6726063338512094, 0.2902598667131223}}], 
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}, {0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.4107746735737448, 0.9123653680929784, 0.2902598667131223}, {
     0.4467385287100102, 1.023050732979218, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.8090169943749475, 0.5877852522924731, 0.3}, {0.7407746735737448, 
     0.6726063338512094, 0.2902598667131223}, {0.4107746735737448, 
     0.9123653680929784, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}, {0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}, {0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}, {0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}, {0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}, {0.9305913184975649, 
     0.834866532128852, 0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}, {0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {0.5064367233843448, 
     1.1430328839275012`, 0.061185364886239595`}, {0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {0.9305913184975649, 0.834866532128852, 
     0.061185364886239595`}, {0.5064367233843448, 1.1430328839275012`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}, {0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}, {0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}, {0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}, {0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.8090169943749475, 
     0.5877852522924731, -0.3}, {0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}, {0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.30901699437494745`, 0.9510565162951535, -0.3}, {0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}, {0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.3635076839753495, 1.1187616146076378`, -0.2427050983124842}, {
     0.4467385287100102, 1.023050732979218, -0.2524452315993619}, {
     0.4107746735737448, 0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}, {0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, -0.3}, {
     0.6663585169306744, 0.48413780144871527`, -0.2427050983124842}, {
     0.6131047200629298, 0.558069082937768, -0.2524452315993619}, {
     0.70725931517615, 0.6264764004946483, -0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}, {0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}, {0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.8090169943749475, 0.5877852522924731, -0.3}, {0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}, {0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}, {0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}, {0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}, {0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}, {0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {0.5174426702523299, 
     0.4642162022170057, 0.061185364886239595`}, {0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.2815972653655501, 0.6355679189018946, 
     0.061185364886239595`}, {0.5174426702523299, 0.4642162022170057, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}, {0.2815972653655501, 
     0.6355679189018946, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}, {0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}, {0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}, {0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}, {0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}, {0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.70725931517615, 0.6264764004946483, 0.2902598667131223}, {
     0.6131047200629298, 0.558069082937768, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, 0.5877852522924731, 0.3}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.3772593151761501, 
     0.8662354347364173, 0.2902598667131223}, {0.70725931517615, 
     0.6264764004946483, 0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.2545263047745454, 0.7833514179826693, 0.2427050983124842}, {
     0.3412954600398847, 0.7555500698501777, 0.2524452315993619}, {
     0.3772593151761501, 0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}, {0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.3635076839753495, 1.1187616146076378`, 0.2427050983124842}, {
     0.23991507142373067`, 1.0902517478945155`, 0.2524452315993619}, {
     0.20395121628746532`, 0.9795663830082759, 0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}, {0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.20395121628746532`, 0.9795663830082759, 
     0.2902598667131223}, {-0.23991507142373067`, 1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.30901699437494745`, 0.9510565162951535, 0.3}, {0.20395121628746532`, 
     0.9795663830082759, 0.2902598667131223}, {-0.20395121628746532`, 
     0.9795663830082759, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}, {0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}, {0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}, {-0.26214195626442016`, 1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}, {-0.23991507142373067`, 1.1363816812510765`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}, {0.26214195626442016`, 
     1.2224090654513957`, 0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}, {0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, 0.09270509831248423}, {-0.26214195626442016`, 
     1.2224090654513957`, 0.061185364886239595`}, {-0.26214195626442016`, 
     1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, 1.2224090654513957`, 
     0.061185364886239595`}, {-0.26214195626442016`, 1.2224090654513957`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}, {0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}, {0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}, {-0.23991507142373067`, 
     1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}, {-0.26214195626442016`, 
     1.2047889988079568`, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.30901699437494745`, 
     0.9510565162951535, -0.3}, {0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}, {0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}, {0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}, {-0.20395121628746532`, 
     0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}, {-0.23991507142373067`, 
     1.0902517478945155`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.2545263047745454, 0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, 0.8118612846957916, -0.2524452315993619}, {
     0.20395121628746532`, 0.9225466495820311, -0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}, {0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}, {-0.16798736115119997`, 
     0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, -0.3}, {
     0.30901699437494745`, 0.9510565162951535, -0.3}, {0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}, {-0.20395121628746532`, 
     0.9225466495820311, -0.2902598667131223}}]}, {
    Polygon3DBox[{{0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}, {0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}, {0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}, {-0.14576047631051048`, 
     0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}, {-0.16798736115119997`, 
     0.7657313513392304, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {0.14576047631051048`, 
     0.6797039671389115, 0.061185364886239595`}, {0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, 0.6797039671389115, 
     0.061185364886239595`}, {0.14576047631051048`, 0.6797039671389115, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}, {-0.14576047631051048`, 
     0.6797039671389115, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}, {-0.14576047631051048`, 
     0.6797039671389115, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}, {0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}, {0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}, {-0.16798736115119997`, 0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}, {-0.14576047631051048`, 0.6973240337823503, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.30901699437494745`, 0.9510565162951535, 0.3}, {
     0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}, {
     0.16798736115119997`, 0.8118612846957916, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}, {
     0.20395121628746532`, 0.9225466495820311, 0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}, {-0.20395121628746532`, 0.9225466495820311, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}, {-0.16798736115119997`, 0.8118612846957916, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}, {-0.4107746735737448, 0.9123653680929784, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}, {-0.4467385287100102, 1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.7407746735737448, 0.6726063338512094, 
     0.2902598667131223}, {-0.834929268686965, 0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.4107746735737448, 0.9123653680929784, 
     0.2902598667131223}, {-0.7407746735737448, 0.6726063338512094, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}, {-0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}, {-0.4960799080669209, 1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}, {-0.9202345031801411, 0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.3635076839753495, 1.1187616146076378`, 
     0.2427050983124842}, {-0.4738530232262314, 1.0603706330140596`, 
     0.21720509831248422`}, {-0.8620437632031863, 0.7783335514429314, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}, {-0.5064367233843448, 
     1.1430328839275012`, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}, {-0.5064367233843448, 
     1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, 0.09270509831248423}, {-0.9305913184975649, 
     0.834866532128852, 0.061185364886239595`}, {-0.9305913184975649, 
     0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-0.3971847822188184, 1.2224090654513957`, 
     0.09270509831248423}, {-0.5064367233843448, 1.1430328839275012`, 
     0.061185364886239595`}, {-0.9305913184975649, 0.834866532128852, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}, {-0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}, {-0.4738530232262314, 
     1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}, {-0.8620437632031863, 
     0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.3971847822188184, 
     1.2224090654513957`, -0.09270509831248423}, {-0.4960799080669209, 
     1.12877795057094, -0.11820509831248423`}, {-0.9202345031801411, 
     0.8206115987722907, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}, {-0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}, {-0.4107746735737448, 
     0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}, {-0.7407746735737448, 
     0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.3635076839753495, 
     1.1187616146076378`, -0.2427050983124842}, {-0.4467385287100102, 
     1.023050732979218, -0.2524452315993619}, {-0.834929268686965, 
     0.7410136514080896, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}, {-0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}, {-0.3412954600398847, 
     0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}, {-0.6131047200629298, 
     0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.30901699437494745`, 
     0.9510565162951535, -0.3}, {-0.3772593151761501, 
     0.8662354347364173, -0.2902598667131223}, {-0.70725931517615, 
     0.6264764004946483, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}, {-0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}, {-0.29195408068297396`, 
     0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}, {-0.5277994855697539, 
     0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.2545263047745454, 
     0.7833514179826693, -0.2427050983124842}, {-0.3141809655236635, 
     0.7182301698153359, -0.21720509831248422`}, {-0.5859902255467087, 
     0.5207491829029263, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, 0.09270509831248423}, {-0.2815972653655501, 
     0.6355679189018946, 0.061185364886239595`}, {-0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5174426702523299, 0.4642162022170057, 
     0.061185364886239595`}, {-0.2815972653655501, 0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}, {-0.5174426702523299, 
     0.4642162022170057, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.22084920653107648`, 
     0.6797039671389115, -0.09270509831248423}, {-0.2815972653655501, 
     0.6355679189018946, -0.061185364886239595`}, {-0.5174426702523299, 
     0.4642162022170057, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}, {-0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}, {-0.3141809655236635, 0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}, {-0.5859902255467087, 0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.22084920653107648`, 0.6797039671389115, 
     0.09270509831248423}, {-0.29195408068297396`, 0.6498228522584557, 
     0.11820509831248423`}, {-0.5277994855697539, 0.47847113557356685`, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.3772593151761501, 0.8662354347364173, 
     0.2902598667131223}, {-0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, 0.9510565162951535, 
     0.3}, {-0.8090169943749475, 0.5877852522924731, 0.3}, {-0.70725931517615,
      0.6264764004946483, 0.2902598667131223}, {-0.3772593151761501, 
     0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}, {-0.70725931517615, 0.6264764004946483, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.2545263047745454, 0.7833514179826693, 
     0.2427050983124842}, {-0.3412954600398847, 0.7555500698501777, 
     0.2524452315993619}, {-0.6131047200629298, 0.558069082937768, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-0.9627531949606478, 0.5650791102813524, 
     0.2524452315993619}, {-0.8685985998474277, 0.49667179272447215`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}, {-0.9627531949606478, 0.5650791102813524, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 0.2427050983124842}, {-1., 0., 
     0.3}, {-0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}, {-1.1110288635138719`, 0.10873352621143985`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8685985998474277, 0.49667179272447215`, 
     0.2902598667131223}, {-0.9946473835599623, 0.10873352621143985`, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}, {-1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2268287475014212`, 0.122988459568001, 
     0.11820509831248423`}, {-1.0648161086526213`, 0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1549010372288906`, 0.122988459568001, 
     0.21720509831248422`}, {-1.2268287475014212`, 0.122988459568001, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-0.9516754718192205, 0.6914327031362311, 
     0.2427050983124842}, {-1.0066253686756665`, 0.5793340436379135, 
     0.21720509831248422`}, {-1.1549010372288906`, 0.122988459568001, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}, {-1.0815737878514187`, 
     0.6270569910021146, 0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}, {-1.0815737878514187`, 
     0.6270569910021146, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2435864267002186`, 0.12843335960284274`, 
     0.061185364886239595`}, {-1.2435864267002186`, 
     0.12843335960284274`, -0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.0398432596630913`, 0.7554903506049574, 
     0.09270509831248423}, {-1.0815737878514187`, 0.6270569910021146, 
     0.061185364886239595`}, {-1.2435864267002186`, 0.12843335960284274`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}, {-1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}, {-1.0066253686756665`, 
     0.5793340436379135, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}, {-1.1549010372288906`, 
     0.122988459568001, -0.21720509831248422`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.0398432596630913`, 
     0.7554903506049574, -0.09270509831248423}, {-1.0648161086526213`, 
     0.6216120909672729, -0.11820509831248423`}, {-1.2268287475014212`, 
     0.122988459568001, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}, {-0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, -0.3}, {-1., 
     0., -0.3}, {-0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}, {-0.8685985998474277, 
     0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{-1., 0., -0.3}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}, {-0.9946473835599623, 
     0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-0.9516754718192205, 
     0.6914327031362311, -0.2427050983124842}, {-0.9627531949606478, 
     0.5650791102813524, -0.2524452315993619}, {-1.1110288635138719`, 
     0.10873352621143985`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}, {-0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}, {-0.7202150157017648, 
     0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., -0.2427050983124842}, {-1., 
     0., -0.3}, {-0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}, {-0.8240369145736102, 
     0.091113459568001, -0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., -0.3}, {-0.8090169943749475, 
     0.5877852522924731, -0.3}, {-0.8143696108149852, 
     0.4790517260810333, -0.2902598667131223}, {-0.9404183945275197, 
     0.091113459568001, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}, {-0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}, {-0.6181521020097914, 
     0.3541114278382325, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}, {-0.7082370305860608, 
     0.07685852621143985, -0.11820509831248423`}}], 
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.6663585169306744, 
     0.48413780144871527`, -0.2427050983124842}, {-0.6763428419867462, 
     0.39638947516759193`, -0.21720509831248422`}, {-0.7801647408585914, 
     0.07685852621143985, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, 0.09270509831248423}, {-0.6013944228109941, 
     0.3486665278033908, 0.061185364886239595`}, {-0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.6914793513872635, 0.0714136261765981, 
     0.061185364886239595`}, {-0.6013944228109941, 0.3486665278033908, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}, {-0.6914793513872635, 
     0.0714136261765981, 0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.5781907290868035, 
     0.4200801539799889, -0.09270509831248423}, {-0.6013944228109941, 
     0.3486665278033908, -0.061185364886239595`}, {-0.6914793513872635, 
     0.0714136261765981, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}, {-0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.7801647408585914, 0.07685852621143985, 
     0.21720509831248422`}, {-0.6763428419867462, 0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.7082370305860608, 0.07685852621143985, 
     0.11820509831248423`}, {-0.7801647408585914, 0.07685852621143985, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.5781907290868035, 0.4200801539799889, 
     0.09270509831248423}, {-0.6181521020097914, 0.3541114278382325, 
     0.11820509831248423`}, {-0.7082370305860608, 0.07685852621143985, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.8090169943749475, 0.5877852522924731, 
     0.3}, {-0.8143696108149852, 0.4790517260810333, 
     0.2902598667131223}, {-0.7202150157017648, 0.41064440852415307`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, 0.5877852522924731, 0.3}, {-1., 0., 
     0.3}, {-0.9404183945275197, 0.091113459568001, 
     0.2902598667131223}, {-0.8143696108149852, 0.4790517260810333, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.8240369145736102, 0.091113459568001, 
     0.2524452315993619}, {-0.9404183945275197, 0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.6663585169306744, 0.48413780144871527`, 
     0.2427050983124842}, {-0.7202150157017648, 0.41064440852415307`, 
     0.2524452315993619}, {-0.8240369145736102, 0.091113459568001, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-1., 0., 0.3}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1110288635138719`, -0.10873352621143985`, 
     0.2524452315993619}, {-0.9946473835599623, -0.10873352621143985`, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.9627531949606478, -0.5650791102813524, 
     0.2524452315993619}, {-1.1110288635138719`, -0.10873352621143985`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8685985998474277, -0.49667179272447215`, 
     0.2902598667131223}, {-0.9627531949606478, -0.5650791102813524, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 0.3}, {-1., 0., 
     0.3}, {-0.9946473835599623, -0.10873352621143985`, 
     0.2902598667131223}, {-0.8685985998474277, -0.49667179272447215`, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2268287475014212`, -0.122988459568001, 
     0.11820509831248423`}, {-1.1549010372288906`, -0.122988459568001, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}, {-1.2268287475014212`, -0.122988459568001, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}, {-1.0648161086526213`, -0.6216120909672729, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.1763355756877418`, 0., 
     0.2427050983124842}, {-1.1549010372288906`, -0.122988459568001, 
     0.21720509831248422`}, {-1.0066253686756665`, -0.5793340436379135, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.285316954888546, 0., 
     0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2435864267002186`, -0.12843335960284274`, \
-0.061185364886239595`}, {-1.2435864267002186`, -0.12843335960284274`, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0815737878514187`, -0.6270569910021146, \
-0.061185364886239595`}, {-1.2435864267002186`, -0.12843335960284274`, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0815737878514187`, -0.6270569910021146, 
     0.061185364886239595`}, {-1.0815737878514187`, -0.6270569910021146, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.285316954888546, 0., 
     0.09270509831248423}, {-1.2435864267002186`, -0.12843335960284274`, 
     0.061185364886239595`}, {-1.0815737878514187`, -0.6270569910021146, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.285316954888546, 
     0., -0.09270509831248423}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1549010372288906`, -0.122988459568001, \
-0.21720509831248422`}, {-1.2268287475014212`, -0.122988459568001, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-1.1763355756877418`, 
     0., -0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0066253686756665`, -0.5793340436379135, \
-0.21720509831248422`}, {-1.1549010372288906`, -0.122988459568001, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.0648161086526213`, -0.6216120909672729, \
-0.11820509831248423`}, {-1.0066253686756665`, -0.5793340436379135, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-1.285316954888546, 
     0., -0.09270509831248423}, {-1.2268287475014212`, -0.122988459568001, \
-0.11820509831248423`}, {-1.0648161086526213`, -0.6216120909672729, \
-0.11820509831248423`}}]}, {
    Polygon3DBox[{{-1.1763355756877418`, 0., -0.2427050983124842}, {-1., 
     0., -0.3}, {-0.9946473835599623, -0.10873352621143985`, \
-0.2902598667131223}, {-1.1110288635138719`, -0.10873352621143985`, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-1., 
     0., -0.3}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}, \
{-0.9946473835599623, -0.10873352621143985`, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, \
{-0.9627531949606478, -0.5650791102813524, -0.2524452315993619}, \
{-0.8685985998474277, -0.49667179272447215`, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-1.1763355756877418`, 
     0., -0.2427050983124842}, {-1.1110288635138719`, -0.10873352621143985`, \
-0.2524452315993619}, {-0.9627531949606478, -0.5650791102813524, \
-0.2524452315993619}}]}, {
    Polygon3DBox[{{-1., 0., -0.3}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.8240369145736102, -0.091113459568001, \
-0.2524452315993619}, {-0.9404183945275197, -0.091113459568001, \
-0.2902598667131223}}], 
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.7202150157017648, -0.41064440852415307`, \
-0.2524452315993619}, {-0.8240369145736102, -0.091113459568001, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.8143696108149852, -0.4790517260810333, -0.2902598667131223}, \
{-0.7202150157017648, -0.41064440852415307`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, {-1., 
     0., -0.3}, {-0.9404183945275197, -0.091113459568001, \
-0.2902598667131223}, {-0.8143696108149852, -0.4790517260810333, \
-0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.7082370305860608, -0.07685852621143985, \
-0.11820509831248423`}, {-0.7801647408585914, -0.07685852621143985, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6181521020097914, -0.3541114278382325, \
-0.11820509831248423`}, {-0.7082370305860608, -0.07685852621143985, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.6763428419867462, -0.39638947516759193`, \
-0.21720509831248422`}, {-0.6181521020097914, -0.3541114278382325, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.8236644243122581, 
     0., -0.2427050983124842}, {-0.7801647408585914, -0.07685852621143985, \
-0.21720509831248422`}, {-0.6763428419867462, -0.39638947516759193`, \
-0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.714683045111454, 
     0., -0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.6914793513872635, -0.0714136261765981, 
     0.061185364886239595`}, {-0.6914793513872635, -0.0714136261765981, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6013944228109941, -0.3486665278033908, 
     0.061185364886239595`}, {-0.6914793513872635, -0.0714136261765981, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.6013944228109941, -0.3486665278033908, \
-0.061185364886239595`}, {-0.6013944228109941, -0.3486665278033908, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.714683045111454, 
     0., -0.09270509831248423}, {-0.6914793513872635, -0.0714136261765981, \
-0.061185364886239595`}, {-0.6013944228109941, -0.3486665278033908, \
-0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.714683045111454, 0., 
     0.09270509831248423}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.7801647408585914, -0.07685852621143985, 
     0.21720509831248422`}, {-0.7082370305860608, -0.07685852621143985, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}, {-0.7801647408585914, -0.07685852621143985, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}, {-0.6763428419867462, -0.39638947516759193`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.714683045111454, 0., 
     0.09270509831248423}, {-0.7082370305860608, -0.07685852621143985, 
     0.11820509831248423`}, {-0.6181521020097914, -0.3541114278382325, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.8236644243122581, 0., 0.2427050983124842}, {-1., 0., 
     0.3}, {-0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}, {-0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-1., 0., 0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.8143696108149852, -0.4790517260810333, 
     0.2902598667131223}, {-0.9404183945275197, -0.091113459568001, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.7202150157017648, -0.41064440852415307`, 
     0.2524452315993619}, {-0.8143696108149852, -0.4790517260810333, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.8236644243122581, 0., 
     0.2427050983124842}, {-0.8240369145736102, -0.091113459568001, 
     0.2524452315993619}, {-0.7202150157017648, -0.41064440852415307`, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}, {-0.7407746735737448, -0.6726063338512094, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}, {-0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.4107746735737448, -0.9123653680929784, 
     0.2902598667131223}, {-0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.7407746735737448, -0.6726063338512094, 
     0.2902598667131223}, {-0.4107746735737448, -0.9123653680929784, 
     0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}, {-0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}, {-0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}, {-0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {-0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}, {-0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9305913184975649, -0.834866532128852, \
-0.061185364886239595`}, {-0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.5064367233843448, -1.1430328839275012`, \
-0.061185364886239595`}, {-0.9305913184975649, -0.834866532128852, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}, {-0.5064367233843448, -1.1430328839275012`, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {-0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}, {-0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8620437632031863, -0.7783335514429314, \
-0.21720509831248422`}, {-0.9202345031801411, -0.8206115987722907, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.4738530232262314, -1.0603706330140596`, \
-0.21720509831248422`}, {-0.8620437632031863, -0.7783335514429314, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.4960799080669209, -1.12877795057094, \
-0.11820509831248423`}, {-0.4738530232262314, -1.0603706330140596`, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-1.0398432596630913`, -0.7554903506049574, \
-0.09270509831248423}, {-0.9202345031801411, -0.8206115987722907, \
-0.11820509831248423`}, {-0.4960799080669209, -1.12877795057094, \
-0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.7407746735737448, -0.6726063338512094, -0.2902598667131223}, \
{-0.834929268686965, -0.7410136514080896, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.4107746735737448, \
-0.9123653680929784, -0.2902598667131223}, {-0.7407746735737448, \
-0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.4467385287100102, -1.023050732979218, -0.2524452315993619}, \
{-0.4107746735737448, -0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.9516754718192205, -0.6914327031362311, \
-0.2427050983124842}, {-0.834929268686965, -0.7410136514080896, \
-0.2524452315993619}, {-0.4467385287100102, -1.023050732979218, \
-0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, -0.3}, \
{-0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, \
{-0.6131047200629298, -0.558069082937768, -0.2524452315993619}, \
{-0.70725931517615, -0.6264764004946483, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.3412954600398847, -0.7555500698501777, \
-0.2524452315993619}, {-0.6131047200629298, -0.558069082937768, \
-0.2524452315993619}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.3772593151761501, -0.8662354347364173, -0.2902598667131223}, \
{-0.3412954600398847, -0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.8090169943749475, -0.5877852522924731, -0.3}, {-0.70725931517615, \
-0.6264764004946483, -0.2902598667131223}, {-0.3772593151761501, \
-0.8662354347364173, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5277994855697539, -0.47847113557356685`, \
-0.11820509831248423`}, {-0.5859902255467087, -0.5207491829029263, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.29195408068297396`, -0.6498228522584557, \
-0.11820509831248423`}, {-0.5277994855697539, -0.47847113557356685`, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.3141809655236635, -0.7182301698153359, \
-0.21720509831248422`}, {-0.29195408068297396`, -0.6498228522584557, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, \
-0.2427050983124842}, {-0.5859902255467087, -0.5207491829029263, \
-0.21720509831248422`}, {-0.3141809655236635, -0.7182301698153359, \
-0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}, {-0.5174426702523299, -0.4642162022170057, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}, {-0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.2815972653655501, -0.6355679189018946, \
-0.061185364886239595`}, {-0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, \
-0.09270509831248423}, {-0.5174426702523299, -0.4642162022170057, \
-0.061185364886239595`}, {-0.2815972653655501, -0.6355679189018946, \
-0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}, {-0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}, {-0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}, {-0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {-0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}, {-0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.70725931517615, -0.6264764004946483, 
     0.2902598667131223}, {-0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.8090169943749475, -0.5877852522924731, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.3772593151761501, -0.8662354347364173, 
     0.2902598667131223}, {-0.70725931517615, -0.6264764004946483, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}, {-0.3772593151761501, -0.8662354347364173, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {-0.6131047200629298, -0.558069082937768, 
     0.2524452315993619}, {-0.3412954600398847, -0.7555500698501777, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}, {-0.20395121628746532`, -0.9795663830082759, 
     0.2902598667131223}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}, {-0.23991507142373067`, -1.0902517478945155`, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}, {
     0.23991507142373067`, -1.0902517478945155`, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}, {
     0.20395121628746532`, -0.9795663830082759, 0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}, {-0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}, {-0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}, {0.26214195626442016`, -1.2047889988079568`, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {-0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}, {0.23991507142373067`, -1.1363816812510765`, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.26214195626442016`, -1.2224090654513957`, \
-0.061185364886239595`}, {-0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}, \
{-0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, 0.09270509831248423}, {
     0.26214195626442016`, -1.2224090654513957`, 0.061185364886239595`}, {
     0.26214195626442016`, -1.2224090654513957`, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {-0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}, {0.26214195626442016`, -1.2224090654513957`, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.3971847822188184, -1.2224090654513957`, \
-0.09270509831248423}, {-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.23991507142373067`, -1.1363816812510765`, \
-0.21720509831248422`}, {-0.26214195626442016`, -1.2047889988079568`, \
-0.11820509831248423`}}], 
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}, \
{-0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}, {
     0.23991507142373067`, -1.1363816812510765`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, \
{-0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}, {
     0.26214195626442016`, -1.2047889988079568`, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.3635076839753495, -1.1187616146076378`, \
-0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}, \
{-0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}, \
{-0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}, {
     0.20395121628746532`, -0.9795663830082759, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, \
{-0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}, {
     0.23991507142373067`, -1.0902517478945155`, -0.2524452315993619}}]}, {
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}, \
{-0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}, \
{-0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}, {
     0.16798736115119997`, -0.8118612846957916, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.30901699437494745`, -0.9510565162951535, -0.3}, \
{-0.30901699437494745`, -0.9510565162951535, -0.3}, {-0.20395121628746532`, \
-0.9225466495820311, -0.2902598667131223}, {
     0.20395121628746532`, -0.9225466495820311, -0.2902598667131223}}]}, {
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, \
-0.2427050983124842}, {-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.14576047631051048`, -0.6973240337823503, \
-0.11820509831248423`}, {-0.16798736115119997`, -0.7657313513392304, \
-0.21720509831248422`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}, \
{-0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}, {
     0.14576047631051048`, -0.6973240337823503, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, \
{-0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}, {
     0.16798736115119997`, -0.7657313513392304, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, \
-0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}, {-0.14576047631051048`, -0.6797039671389115, \
-0.061185364886239595`}}], 
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}, {-0.14576047631051048`, -0.6797039671389115, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}, {
     0.14576047631051048`, -0.6797039671389115, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, \
{-0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, \
{-0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}, {
     0.14576047631051048`, -0.6797039671389115, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}, {-0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}, {-0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}, {0.16798736115119997`, -0.7657313513392304, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {-0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}, {0.14576047631051048`, -0.6973240337823503, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.30901699437494745`, -0.9510565162951535, 
     0.3}, {-0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}, {-0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}}], 
    Polygon3DBox[{{-0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}, {-0.20395121628746532`, -0.9225466495820311, 
     0.2902598667131223}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.2545263047745454, -0.7833514179826693, 0.2427050983124842}, {
     0.16798736115119997`, -0.8118612846957916, 0.2524452315993619}, {
     0.20395121628746532`, -0.9225466495820311, 0.2902598667131223}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {-0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}, {0.16798736115119997`, -0.8118612846957916, 
     0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.3635076839753495, -1.1187616146076378`, 0.2427050983124842}, {
     0.4467385287100102, -1.023050732979218, 0.2524452315993619}, {
     0.4107746735737448, -0.9123653680929784, 0.2902598667131223}}], 
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.834929268686965, -0.7410136514080896, 
     0.2524452315993619}, {0.4467385287100102, -1.023050732979218, 
     0.2524452315993619}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.7407746735737448, -0.6726063338512094, 0.2902598667131223}, {
     0.834929268686965, -0.7410136514080896, 0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.4107746735737448, -0.9123653680929784, 0.2902598667131223}, {
     0.7407746735737448, -0.6726063338512094, 0.2902598667131223}}]}, {
    Polygon3DBox[{{0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}, {0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}, {0.4960799080669209, -1.12877795057094, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}, {0.9202345031801411, -0.8206115987722907, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.9516754718192205, -0.6914327031362311, 
     0.2427050983124842}, {0.3635076839753495, -1.1187616146076378`, 
     0.2427050983124842}, {0.4738530232262314, -1.0603706330140596`, 
     0.21720509831248422`}, {0.8620437632031863, -0.7783335514429314, 
     0.21720509831248422`}}]}, {
    Polygon3DBox[{{0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.5064367233843448, -1.1430328839275012`, -0.061185364886239595`}, {
     0.5064367233843448, -1.1430328839275012`, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9305913184975649, -0.834866532128852, -0.061185364886239595`}, {
     0.5064367233843448, -1.1430328839275012`, -0.061185364886239595`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     1.0398432596630913`, -0.7554903506049574, 0.09270509831248423}, {
     0.9305913184975649, -0.834866532128852, 0.061185364886239595`}, {
     0.9305913184975649, -0.834866532128852, -0.061185364886239595`}}], 
    Polygon3DBox[{{1.0398432596630913`, -0.7554903506049574, 
     0.09270509831248423}, {0.3971847822188184, -1.2224090654513957`, 
     0.09270509831248423}, {0.5064367233843448, -1.1430328839275012`, 
     0.061185364886239595`}, {0.9305913184975649, -0.834866532128852, 
     0.061185364886239595`}}]}, {
    Polygon3DBox[{{
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.4738530232262314, -1.0603706330140596`, -0.21720509831248422`}, {
     0.4960799080669209, -1.12877795057094, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.8620437632031863, -0.7783335514429314, -0.21720509831248422`}, {
     0.4738530232262314, -1.0603706330140596`, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.9202345031801411, -0.8206115987722907, -0.11820509831248423`}, {
     0.8620437632031863, -0.7783335514429314, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     1.0398432596630913`, -0.7554903506049574, -0.09270509831248423}, {
     0.3971847822188184, -1.2224090654513957`, -0.09270509831248423}, {
     0.4960799080669209, -1.12877795057094, -0.11820509831248423`}, {
     0.9202345031801411, -0.8206115987722907, -0.11820509831248423`}}]}, {
    Polygon3DBox[{{
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.4107746735737448, -0.9123653680929784, -0.2902598667131223}, {
     0.4467385287100102, -1.023050732979218, -0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.7407746735737448, -0.6726063338512094, -0.2902598667131223}, {
     0.4107746735737448, -0.9123653680929784, -0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.834929268686965, -0.7410136514080896, -0.2524452315993619}, {
     0.7407746735737448, -0.6726063338512094, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.9516754718192205, -0.6914327031362311, -0.2427050983124842}, {
     0.3635076839753495, -1.1187616146076378`, -0.2427050983124842}, {
     0.4467385287100102, -1.023050732979218, -0.2524452315993619}, {
     0.834929268686965, -0.7410136514080896, -0.2524452315993619}}]}, {
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.3412954600398847, -0.7555500698501777, -0.2524452315993619}, {
     0.3772593151761501, -0.8662354347364173, -0.2902598667131223}}], 
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.6131047200629298, -0.558069082937768, -0.2524452315993619}, {
     0.3412954600398847, -0.7555500698501777, -0.2524452315993619}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.70725931517615, -0.6264764004946483, -0.2902598667131223}, {
     0.6131047200629298, -0.558069082937768, -0.2524452315993619}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, -0.3}, {
     0.30901699437494745`, -0.9510565162951535, -0.3}, {
     0.3772593151761501, -0.8662354347364173, -0.2902598667131223}, {
     0.70725931517615, -0.6264764004946483, -0.2902598667131223}}]}, {
    Polygon3DBox[{{
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.29195408068297396`, -0.6498228522584557, -0.11820509831248423`}, {
     0.3141809655236635, -0.7182301698153359, -0.21720509831248422`}}], 
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5277994855697539, -0.47847113557356685`, -0.11820509831248423`}, {
     0.29195408068297396`, -0.6498228522584557, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.5859902255467087, -0.5207491829029263, -0.21720509831248422`}, {
     0.5277994855697539, -0.47847113557356685`, -0.11820509831248423`}}], 
    Polygon3DBox[{{
     0.6663585169306744, -0.48413780144871527`, -0.2427050983124842}, {
     0.2545263047745454, -0.7833514179826693, -0.2427050983124842}, {
     0.3141809655236635, -0.7182301698153359, -0.21720509831248422`}, {
     0.5859902255467087, -0.5207491829029263, -0.21720509831248422`}}]}, {
    Polygon3DBox[{{
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, 0.09270509831248423}, {
     0.2815972653655501, -0.6355679189018946, 0.061185364886239595`}, {
     0.2815972653655501, -0.6355679189018946, -0.061185364886239595`}}], 
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.5174426702523299, -0.4642162022170057, 
     0.061185364886239595`}, {0.2815972653655501, -0.6355679189018946, 
     0.061185364886239595`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.5174426702523299, -0.4642162022170057, -0.061185364886239595`}, {
     0.5174426702523299, -0.4642162022170057, 0.061185364886239595`}}], 
    Polygon3DBox[{{
     0.5781907290868035, -0.4200801539799889, -0.09270509831248423}, {
     0.22084920653107648`, -0.6797039671389115, -0.09270509831248423}, {
     0.2815972653655501, -0.6355679189018946, -0.061185364886239595`}, {
     0.5174426702523299, -0.4642162022170057, -0.061185364886239595`}}]}, {
    Polygon3DBox[{{0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}, {0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}}], 
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}, {0.3141809655236635, -0.7182301698153359, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}, {0.5859902255467087, -0.5207491829029263, 
     0.21720509831248422`}}], 
    Polygon3DBox[{{0.5781907290868035, -0.4200801539799889, 
     0.09270509831248423}, {0.22084920653107648`, -0.6797039671389115, 
     0.09270509831248423}, {0.29195408068297396`, -0.6498228522584557, 
     0.11820509831248423`}, {0.5277994855697539, -0.47847113557356685`, 
     0.11820509831248423`}}]}, {
    Polygon3DBox[{{0.2545263047745454, -0.7833514179826693, 
     0.2427050983124842}, {0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.3772593151761501, -0.8662354347364173, 0.2902598667131223}, {
     0.3412954600398847, -0.7555500698501777, 0.2524452315993619}}], 
    Polygon3DBox[{{0.30901699437494745`, -0.9510565162951535, 0.3}, {
     0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.70725931517615, -0.6264764004946483, 0.2902598667131223}, {
     0.3772593151761501, -0.8662354347364173, 0.2902598667131223}}], 
    Polygon3DBox[{{0.8090169943749475, -0.5877852522924731, 0.3}, {
     0.6663585169306744, -0.48413780144871527`, 0.2427050983124842}, {
     0.6131047200629298, -0.558069082937768, 0.2524452315993619}, {
     0.70725931517615, -0.6264764004946483, 0.2902598667131223}}], 
    Polygon3DBox[{{0.6663585169306744, -0.48413780144871527`, 
     0.2427050983124842}, {0.2545263047745454, -0.7833514179826693, 