(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72303,       2811]
NotebookOptionsPosition[     60331,       2396]
NotebookOutlinePosition[     61149,       2427]
CellTagsIndexPosition[     61021,       2421]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nutzen"
}], "Title"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als Taschenrechner f\[UDoubleDot]r Zahlen"
}], "Section"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " f\[UDoubleDot]hrt (jenseits numerischer N\[ADoubleDot]herungen) grunds\
\[ADoubleDot]tzlich alle Rechungen exakt aus und verwendet dazu eine \
BigInteger-Arithmetik."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.23", "+", "2.25"}]], "Input"],

Cell[BoxData["3.48`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"12", "+", "23"}]], "Input"],

Cell[BoxData["35"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["2", "100"]], "Input"],

Cell[BoxData["1267650600228229401496703205376"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", "!"}]], "Input"],

Cell[BoxData["3628800"], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kennt eine gro\[SZ]e Zahl zahlentheoretischer Funktionen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["2", "30"], "-", "1"}], ",", 
   RowBox[{
    SuperscriptBox["3", "20"], "-", "1"}]}], "]"}]], "Input"],

Cell[BoxData["11"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{
   RowBox[{"12", "!"}], "+", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"13", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2834329", ",", "1"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{
   RowBox[{"12", "!"}], "-", "1"}], "]"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell["Auch mit rationalen Zahlen wird exakt gerechnet.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox["2", "3"]}]], "Input"],

Cell[BoxData[
 FractionBox["7", "6"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "i"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "50"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["13943237577224054960759", "3099044504245996706400"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input"],

Cell[BoxData["4.499205338329425`"], "Output"]
}, Open  ]],

Cell["\<\
Symbolische Ausdr\[UDoubleDot]cke wie \[Pi] werden als \"Bezeichner mit \
Eigenschaften\" behandelt. Eine Eigenschaft ist oft ein Verfahren zur \
Berechnung numerischer N\[ADoubleDot]herungen beliebiger Genauigkeit.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData["Pi"], "Input"],

Cell[BoxData["\[Pi]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "30"}], "]"}]], "Input"],

Cell[BoxData["3.141592653589793238462643383279502884197167679584`30."], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "\[Pi]", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"\[Pi]", "/", "4"}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["2"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"\[Pi]", "/", "5"}], "]"}]], "Input"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   FractionBox["5", "8"], "-", 
   FractionBox[
    SqrtBox["5"], "8"]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Aus numerischen N\[ADoubleDot]herungswerten kann man eine Beziehung wie \
Sin[\[Pi]]\[Equal]0 ",
 StyleBox["prinzipiell",
  FontSlant->"Italic"],
 " nicht ",
 StyleBox["exakt",
  FontSlant->"Italic"],
 " herleiten. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", "10"}], "]"}]}], ";", 
  RowBox[{"Sin", "[", "p", "]"}]}]], "Input"],

Cell[BoxData["0``9.502850127305868"], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kann nat\[UDoubleDot]rlich auch mit komplexen Zahlen rechnen. Aus \
innermathematischen Gr\[UDoubleDot]nden wird f\[UDoubleDot]r jede Variable \
angenommne, dass sie komplexwertig ist, wenn nicht anderes vereinbart ist."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{"-", "12"}]]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", 
  SqrtBox["3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "1"}], ")"}], "+", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "1"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"1", "+", 
    RowBox[{"3", "I"}]}]}], ";", " ", 
  SuperscriptBox["z", "2"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "8"}], "+", 
  RowBox[{"6", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"z", "+", "1"}], 
  RowBox[{"z", "-", "1"}]]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "1"}], ")"}], "+", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "+", "1"}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SqrtBox["2"], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "F\[UDoubleDot]r geschachtelte Wurzelausdr\[UDoubleDot]cke kennt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " manchmal verbl\[UDoubleDot]ffende Vereinfachungen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u1", "=", 
  SqrtBox[
   RowBox[{"4", "+", 
    RowBox[{"2", 
     SqrtBox["3"]}]}]]}]], "Input"],

Cell[BoxData[
 SqrtBox[
  RowBox[{"4", "+", 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "u1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  SqrtBox["3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u2", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"11", "-", 
    RowBox[{"6", " ", 
     SqrtBox["2"]}]}]], "+", 
  SqrtBox[
   RowBox[{"11", "+", 
    RowBox[{"6", " ", 
     SqrtBox["2"]}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "u2", "]"}]], "Input"],

Cell[BoxData["6"], "Output"]
}, Open  ]],

Cell[TextData[{
 "An anderen Stellen verh\[ADoubleDot]lt sich ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dagegen sehr eigenwillig. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u3", "=", 
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]]}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"RootReduce", "[", "u3", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["2"]}], "+", 
  SqrtBox["3"]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als Taschenrechner f\[UDoubleDot]r Formeln und symbolische Ausdr\
\[UDoubleDot]cke"
}], "Section"],

Cell["\<\
Komplizierte rationale Ausdr\[UDoubleDot]cke lassen sich gelegentlich in eine \
verbl\[UDoubleDot]ffend einfache Form bringen.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
   FractionBox["b", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}]}]], "+", 
   FractionBox["c", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"c", "-", "b"}], ")"}]}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["a", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
  FractionBox["b", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}]}]], "+", 
  FractionBox["c", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "b"}], "+", "c"}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "//", "Simplify"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", "n"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
   FractionBox[
    SuperscriptBox["b", "n"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}]}]], "+", 
   FractionBox[
    SuperscriptBox["c", "n"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"c", "-", "b"}], ")"}]}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["a", "n"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox["b", "n"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox["c", "n"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "b"}], "+", "c"}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " ist daf\[UDoubleDot]r nicht immer der rcihtige Operator."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "/.", 
      RowBox[{"n", "\[Rule]", "i"}]}], "//", "Simplify"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "7"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "+", 
    RowBox[{"b", " ", "c"}], "+", 
    SuperscriptBox["c", "2"], "+", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "3"], "+", 
    SuperscriptBox["b", "3"], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"b", " ", "c"}], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["a", "6"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{
      FractionBox[
       SuperscriptBox["b", "6"], 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b"}]], "+", 
      FractionBox[
       SuperscriptBox["c", "6"], 
       RowBox[{"a", "-", "c"}]]}], 
     RowBox[{"b", "-", "c"}]]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["a", "7"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{
      FractionBox[
       SuperscriptBox["b", "7"], 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b"}]], "+", 
      FractionBox[
       SuperscriptBox["c", "7"], 
       RowBox[{"a", "-", "c"}]]}], 
     RowBox[{"b", "-", "c"}]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das richtige Kommando ist hier ",
 StyleBox["Together",
  FontWeight->"Bold"],
 ", mit dem der Hauptnenner gebildet und dann Z\[ADoubleDot]hler und Nenner \
vereinfacht wird."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u6", "=", 
  RowBox[{
   RowBox[{"u", "/.", 
    RowBox[{"n", "\[Rule]", "6"}]}], "//", "Together"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "4"], "+", 
  RowBox[{
   SuperscriptBox["a", "3"], " ", "b"}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "2"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "3"]}], "+", 
  SuperscriptBox["b", "4"], "+", 
  RowBox[{
   SuperscriptBox["a", "3"], " ", "c"}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "2"], " ", "c"}], "+", 
  RowBox[{
   SuperscriptBox["b", "3"], " ", "c"}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"a", " ", "b", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox["c", "3"]}], "+", 
  SuperscriptBox["c", "4"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Aber auch das Ergebnis von ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " war richtig, denn f\[UDoubleDot]r n>5 sind die geschachtelten rationalen \
Ausdr\[UDoubleDot]cke in der Tat \"einfacher\". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vergleicht dazu die Anzahl derBausteine, aus denen die verschiedenen m\
\[ODoubleDot]glichen Ergebnisse bestehen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "/@", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "18", ",", "39", ",", "50", ",", "50"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", "u6", "]"}]], "Input"],

Cell[BoxData["79"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listen, Matrizen, Substitutionslisten ", "Section"],

Cell["\<\
Listen und Tabellen sind die grundlegende Datenstruktur, in der Aggregationen \
von symbolischen Ausdr\[UDoubleDot]cken verwaltet werden. Hier sehen Sie die \
wichtigsten Kommandos f\[UDoubleDot]r Listen in Aktion. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["i", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", "l"}], "]"}]], "Input"],

Cell[BoxData["55"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", " ", "@@", "l"}]], "Input"],

Cell[BoxData["55"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "70"}], "}"}]}], "]"}], ",", "PrimeQ"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "13", ",", "17", ",", 
   "19", ",", "23", ",", "29", ",", "31", ",", "37", ",", "41", ",", "43", 
   ",", "47", ",", "53", ",", "59", ",", "61", ",", "67"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1`", ",", "0.09983341664682815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0.19866933079506122`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30000000000000004`", ",", "0.2955202066613396`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.3894183423086505`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.479425538604203`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6000000000000001`", ",", "0.5646424733950355`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7000000000000001`", ",", "0.6442176872376911`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "0.7173560908995228`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", "0.7833269096274834`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.8414709848078965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1`", ",", "0.8912073600614354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2000000000000002`", ",", "0.9320390859672264`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3`", ",", "0.963558185417193`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4000000000000001`", ",", "0.9854497299884603`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "0.9974949866040544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6`", ",", "0.9995736030415051`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7000000000000002`", ",", "0.9916648104524686`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8`", ",", "0.9738476308781951`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9000000000000001`", ",", "0.9463000876874145`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "0.9092974268256817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1`", ",", "0.8632093666488737`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2`", ",", "0.8084964038195901`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3000000000000003`", ",", "0.74570521217672`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4000000000000004`", ",", "0.6754631805511506`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "0.5984721441039565`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6`", ",", "0.5155013718214642`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7`", ",", "0.4273798802338298`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8000000000000003`", ",", "0.33498815015590466`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"2.9000000000000004`", ",", "0.23924932921398198`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"3.`", ",", "0.1411200080598672`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"Grid", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      InterpretationBox["\<\" 0.0000\"\>",
       0.,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.0000\"\>",
       0.,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.1000\"\>",
       0.1,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.1000\"\>",
       0.09983341664682815,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.2000\"\>",
       0.2,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.2000\"\>",
       0.19866933079506122`,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.3000\"\>",
       0.30000000000000004`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.3000\"\>",
       0.2955202066613396,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.4000\"\>",
       0.4,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.4000\"\>",
       0.3894183423086505,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.5000\"\>",
       0.5,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.5000\"\>",
       0.479425538604203,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.6000\"\>",
       0.6000000000000001,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.6000\"\>",
       0.5646424733950355,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.7000\"\>",
       0.7000000000000001,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.6000\"\>",
       0.6442176872376911,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.8000\"\>",
       0.8,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.7000\"\>",
       0.7173560908995228,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 0.9000\"\>",
       0.9,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.8000\"\>",
       0.7833269096274834,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 1.0000\"\>",
       1.,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.8000\"\>",
       0.8414709848078965,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 1.0000\"\>",
       1.1,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.9000\"\>",
       0.8912073600614354,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 1.0000\"\>",
       1.2000000000000002`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.9000\"\>",
       0.9320390859672264,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 1.0000\"\>",
       1.3,
       AutoDelete->True], 
      InterpretationBox["\<\" 1.0000\"\>",
       0.963558185417193,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 1.0000\"\>",
       1.4000000000000001`,
       AutoDelete->True], 
      InterpretationBox["\<\" 1.0000\"\>",
       0.9854497299884603,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       1.5,
       AutoDelete->True], 
      InterpretationBox["\<\" 1.0000\"\>",
       0.9974949866040544,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       1.6,
       AutoDelete->True], 
      InterpretationBox["\<\" 1.0000\"\>",
       0.9995736030415051,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       1.7000000000000002`,
       AutoDelete->True], 
      InterpretationBox["\<\" 1.0000\"\>",
       0.9916648104524686,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       1.8,
       AutoDelete->True], 
      InterpretationBox["\<\" 1.0000\"\>",
       0.9738476308781951,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       1.9000000000000001`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.9000\"\>",
       0.9463000876874145,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       2.,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.9000\"\>",
       0.9092974268256817,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       2.1,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.9000\"\>",
       0.8632093666488737,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       2.2,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.8000\"\>",
       0.8084964038195901,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       2.3000000000000003`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.7000\"\>",
       0.74570521217672,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 2.0000\"\>",
       2.4000000000000004`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.7000\"\>",
       0.6754631805511506,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 3.0000\"\>",
       2.5,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.6000\"\>",
       0.5984721441039565,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 3.0000\"\>",
       2.6,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.5000\"\>",
       0.5155013718214642,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 3.0000\"\>",
       2.7,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.4000\"\>",
       0.4273798802338298,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 3.0000\"\>",
       2.8000000000000003`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.3000\"\>",
       0.33498815015590466`,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 3.0000\"\>",
       2.9000000000000004`,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.2000\"\>",
       0.23924932921398198`,
       AutoDelete->True]},
     {
      InterpretationBox["\<\" 3.0000\"\>",
       3.,
       AutoDelete->True], 
      InterpretationBox["\<\" 0.1000\"\>",
       0.1411200080598672,
       AutoDelete->True]}
    },
    ColumnsEqual->False,
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Grid"],
  PaddedForm[#, {1, 4}]& ]], "Output"]
}, Open  ]],

Cell["\<\
Auch Vektoren und Matrizen werden intern als Listen dargestellt. Die gewohnte \
mathematische Notation kann mit verschiedenen *Form-Kommandos hergestellt \
werden.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "=", 
  RowBox[{"(", GridBox[{
     {"a", "b", "c"},
     {"d", "e", "f"}
    }], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b", "c"},
     {"d", "e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", "mat", "]"}], "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "d"},
     {"b", "e"},
     {"c", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die L\[ODoubleDot]sung von Gleichungssystemen wird als ",
 StyleBox["Substitutionsliste",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ckgegeben. Zusammen mit dem Substitutionsoperator ",
 StyleBox["/. ",
  FontWeight->"Bold"],
 "ist eine solche Form f\[UDoubleDot]r die weitere Verarbeitung besonders gut \
geeignet."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y", "-", "2"}], "\[Equal]", "0"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       SuperscriptBox["y", "2"], "-", "2"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "/.", "sol"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "8", ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sys", "/.", "sol"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dabei wird vom Attribut Listable von /. (der InfixForm von ReplaceAll) \
Gebrauch gemacht, das als Anwendung einer Liste von Substitutionen auf einen \
Ausdruck eine Liste von Ergebnissen zur\[UDoubleDot]ckgibt.  In Wirklichkeit \
kommt ",
 StyleBox["Map[sys /. # & , sol] ",
  FontWeight->"Bold"],
 "oder kurz "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"sys", "/.", "#"}], "&"}], ")"}], "/@", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "\[Equal]", "0"}], ",", "True"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "\[Equal]", "0"}], ",", "True"}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
zum Einsatz. 

In Versionen < 6 wurden an dieser Stelle Warnungen ausgel\[ODoubleDot]st. \
Diese r\[UDoubleDot]hrten daher, dass beide Seiten von \[Equal] numerisch \
auswertbar (Eigenschaft NumericQ) sind und deshalb zun\[ADoubleDot]chst \
versucht wurde, die Gleichheit durch numerische N\[ADoubleDot]herung zu \
falsifizieren. Erst danach bekam Simplify das Kommando. Dieser Zugang ist \
hier nat\[UDoubleDot]rlich zwecklos und wurde mit Version 6 \
ge\[ADoubleDot]ndert.

Mit dem folgenden komplexen Kommando (k\[ODoubleDot]nnen Sie es \
dechiffrieren?) wird gezeigt, dass alle linken Seiten in der Probe tats\
\[ADoubleDot]chlich die Eigenschaft NumericQ haben.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"NumericQ", "/@", "#"}], ")"}], "&"}], "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"First", "/@", "sys"}], "/.", "sol"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als mathematisches Expertensystem"
}], "Section"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kennt mathematisch-algorithmische Verfahren aus vielen Gebieten der \
Mathematik."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  SuperscriptBox["x", "n"]}]], "Input"],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "x"}]], 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "2"], 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Log", "[", "x", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], "+", 
  RowBox[{"4", " ", "x", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Log", "[", "x", "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Log", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "5"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "20"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "-", 
        SqrtBox["5"], "+", 
        RowBox[{"4", " ", "x"}]}], 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           SqrtBox["5"]}], ")"}]}]]], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"10", "-", 
       RowBox[{"2", " ", 
        SqrtBox["5"]}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        SqrtBox["5"], "+", 
        RowBox[{"4", " ", "x"}]}], 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]], "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}], ")"}], " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Manchmal stimmt die Form des Ergebnisses aber nicht mit den Erwartungen \
\[UDoubleDot]berein. Die Gleichwertigkeit von Ergebnissen zu \
pr\[UDoubleDot]fen oder gar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zu \"\[UDoubleDot]berreden\", ein Ergebnis in einer bestimmten Form zur\
\[UDoubleDot]ckzugeben, ist eine hohe Kunst und bedarf oft genauerer \
Kenntnisse \[UDoubleDot]ber Interna der Darstellung und Rechnungen. \n\nHier \
etwa kommen komplexwertige Argumente an einer Stelle vor, wo sie gar nicht \
erforderlich sind. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  FractionBox[
   RowBox[{
    RowBox[{"2", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"2", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", "x"}], "-", "2"}], 
   RowBox[{
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "2"], "+", "1"}]]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "3"]}]}], 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "4"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"p", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", 
         SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], "+", 
    RowBox[{"3", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", 
         SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       SqrtBox["3"], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]], "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "4"]}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"p", "//", "Apart"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"3", " ", "x"}]}], 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "-", "x"}], 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}]]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Eine solche Zerlegung half noch bei ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.1, eine Darstellung mit reellwertigen Argumenten zu finden."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"p1", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", 
         SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], "+", 
    RowBox[{"3", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", 
         SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       SqrtBox["3"], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]], "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "4"]}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 findet dasselbe Ergebnis nur, wenn die beiden Summanden wirklich \
getrennt integriert und dann die Ergebnisse addiert werden. Wir verwenden \
dabei als Interna, dass ",
 StyleBox["Map",
  FontWeight->"Bold"],
 " nicht nur f\[UDoubleDot]r Listen, sondern auch f\[UDoubleDot]r Summen \
funktioniert."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", "p1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   SqrtBox["3"]], "-", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   SqrtBox["3"]], "+", 
  RowBox[{
   FractionBox["3", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell["Und hier ein paar Rechnungen aus der Analysis.", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["x", "2"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"FresnelS", "[", 
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Tan", "[", "x", "]"}]}], 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["2"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "7"], "30"], "+", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["x", "9"]}], "756"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 7, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 30], 0, 
    Rational[29, 756]}, 7, 11, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   SuperscriptBox["k", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "n"], 
  SuperscriptBox["k", "3"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  SuperscriptBox["n", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "n"}], ",", "n"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "27"], " ", 
  RowBox[{"(", 
   RowBox[{"18", "+", 
    RowBox[{
     SqrtBox["3"], " ", "\[Pi]"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "n"}], ",", "n"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "k"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["2", "27"], " ", 
   RowBox[{"(", 
    RowBox[{"18", "+", 
     RowBox[{
      SqrtBox["3"], " ", "\[Pi]"}]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["4", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "k"}]], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"2", "+", "k"}], "]"}], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{"1", ",", 
      RowBox[{"2", "+", "k"}], ",", 
      RowBox[{
       FractionBox["3", "2"], "+", "k"}], ",", 
      FractionBox["1", "4"]}], "]"}]}], 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["3", "2"], "+", "k"}], "]"}]]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Die Notation von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uFactors", "=", 
  RowBox[{"FactorInteger", "[", 
   RowBox[{
    RowBox[{"12", "!"}], "+", "1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"13", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2834329", ",", "1"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input"],

Cell[BoxData["\<\"Global`\"\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Tan", "]"}]], "Input"],

Cell[BoxData["\<\"System`\"\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PacletManager`\"\>", ",", "\<\"WebServices`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  RowBox[{"2", " ", "a", " ", "b"}], "+", 
  SuperscriptBox["b", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  RowBox[{"2", " ", "a", " ", "b"}], "+", 
  SuperscriptBox["b", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", "x", "+", "3"}], "\[Equal]", "0"}], ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["11"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["11"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "\[LeftDoubleBracket]", "1", 
  "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["11"]}]}], ")"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"3", "/", "2"}]]}], "3"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SqrtBox["x"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"3", "/", "2"}]]}], "3"]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"<<", " ", "Calendar`"}], " ", "oder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EasterSunday", "/@", 
  RowBox[{"(", 
   RowBox[{"2006", "+", 
    RowBox[{"Range", "[", "10", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2008", ",", "3", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2009", ",", "4", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2010", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2011", ",", "4", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2012", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "3", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "4", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2016", ",", "3", ",", "27"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Bevor Symbole und Funktionen aus Paketen verwendet werden, muss der \
entsprechende Namensraum in den ",
 StyleBox["$ContextPath ",
  FontWeight->"Bold"],
 "aufgenommen werden.\n\nWas passiert, wenn obige Funktion aufgerufen wird, \
aber das Paket nicht geladen wurde? \nProbieren wir es aus. ",
 StyleBox["Mit ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["Evaluation | Quit Kernel",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" starten wir den Kernel neu",
  FontColor->RGBColor[1, 0, 0]],
 ", was alle bisherigen Setzungen l\[ODoubleDot]scht. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{"$ContextPath", "\[IndentingNewLine]", 
 RowBox[{"EasterSunday", "[", "2007", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PacletManager`\"\>", ",", "\<\"WebServices`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"EasterSunday", "[", "2007", "]"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", "\<\"EasterSunday\"\>", "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beim ersten Aufruf wurde der unausgewertete Funktionsausdruck zur\
\[UDoubleDot]ckgegeben. Beim nachtr\[ADoubleDot]glichen Laden des Pakets ",
 StyleBox["Calendar ",
  FontWeight->"Bold"],
 "wird ein zweiter Bezeichner ",
 StyleBox["EasterSunday",
  FontWeight->"Bold"],
 " im Kontext ",
 StyleBox["Calendar`",
  FontWeight->"Bold"],
 " angelegt. Die Warnung weist darauf hin, dass beide Bezeichner denselben \
unqualifizierten Namen haben.\n\nSeit Version 6 wird beim zweiten Aufruf der \
zuletzt geladene (und damit gew\[UDoubleDot]nschte) Bezeichner verwendet. Mit \
dem folgenden Kommando k\[ODoubleDot]nnen Sie sich \[UDoubleDot]berzeugen, \
dass tats\[ADoubleDot]chlich beide Bezeichner existieren.  "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EasterSunday", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"EasterSunday\\\"\\) appears in multiple \
contexts \\!\\({\\\"Calendar`\\\", \\\"Global`\\\"}\\); definitions in \
context \\!\\(\\\"Calendar`\\\"\\) may shadow or be shadowed by other \
definitions.\"\>"}]], "Message", "MSG"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"$ContextPath", "\[IndentingNewLine]", 
 RowBox[{"EasterSunday", "[", "2007", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Names", "[", "\"\<*`EasterSunday\>\"", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Calendar`\"\>", ",", "\<\"PacletManager`\"\>", 
   ",", "\<\"WebServices`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "4", ",", "8"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"EasterSunday\"\>", ",", "\<\"Global`EasterSunday\"\>"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Mit ",
 StyleBox["Remove",
  FontWeight->"Bold"],
 " und dem qualifizierten Namen kann der falsche Bezeichner aus der \
Symboltabelle entfernt werden (bzw. -- in fr\[UDoubleDot]heren ",
 StyleBox["Mathematica-V",
  FontSlant->"Italic"],
 "ersionen -- ",
 StyleBox["muss",
  FontWeight->"Bold"],
 " zum ordnungsgem\[ADoubleDot]\[SZ]en Funktionieren entfernt werden)"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Remove", "[", "Global`EasterSunday", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Names", "[", "\"\<*`EasterSunday\>\"", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", "\<\"EasterSunday\"\>", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Solve"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Solve\\\", \\\"[\\\", RowBox[{StyleBox[\\\
\"eqns\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"vars\\\", \\\"TI\\\"]}], \
\\\"]\\\"}]\\) attempts to solve an equation or set of equations for the \
variables \\!\\(\\*StyleBox[\\\"vars\\\", \\\"TI\\\"]\\). \
\\n\\!\\(\\*RowBox[{\\\"Solve\\\", \\\"[\\\", RowBox[{StyleBox[\\\"eqns\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"vars\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"elims\\\", \\\"TI\\\"]}], \\\"]\\\"}]\\) attempts to solve the \
equations for \\!\\(\\*StyleBox[\\\"vars\\\", \\\"TI\\\"]\\), eliminating the \
variables \\!\\(\\*StyleBox[\\\"elims\\\", \\\"TI\\\"]\\). \"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3392917247-1132742"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "Mod"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Mod\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"m\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"n\\\", \
\\\"TI\\\"]}], \\\"]\\\"}]\\) gives the remainder on division of m by n. \
\\n\\!\\(\\*RowBox[{\\\"Mod\\\", \\\"[\\\", RowBox[{StyleBox[\\\"m\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"n\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\
\\\"d\\\", \\\"TI\\\"]}], \\\"]\\\"}]\\) uses an offset d. \"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3392917255-3793923"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Mod", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
       "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Mod"],
  Editable->False]], "Print",
 CellTags->"Info3392917255-3793923"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{674, 647},
WindowMargins->{{Automatic, 230}, {Automatic, 74}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3392917247-1132742"->{
  Cell[58454, 2347, 751, 11, 104, "Print",
   CellTags->"Info3392917247-1132742"]},
 "Info3392917255-3793923"->{
  Cell[59292, 2366, 511, 8, 64, "Print",
   CellTags->"Info3392917255-3793923"],
  Cell[59806, 2376, 485, 15, 24, "Print",
   CellTags->"Info3392917255-3793923"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3392917247-1132742", 60721, 2410},
 {"Info3392917255-3793923", 60834, 2413}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 88, 4, 90, "Title"],
Cell[CellGroupData[{
Cell[703, 31, 125, 4, 55, "Section"],
Cell[831, 37, 251, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[1107, 47, 55, 1, 28, "Input"],
Cell[1165, 50, 32, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1234, 55, 51, 1, 28, "Input"],
Cell[1288, 58, 29, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1354, 63, 52, 1, 30, "Input"],
Cell[1409, 66, 58, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1504, 71, 45, 1, 28, "Input"],
Cell[1552, 74, 34, 0, 28, "Output"]
}, Open  ]],
Cell[1601, 77, 143, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[1769, 85, 181, 6, 30, "Input"],
Cell[1953, 93, 29, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2019, 98, 109, 3, 28, "Input"],
Cell[2131, 103, 178, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2346, 114, 102, 3, 28, "Input"],
Cell[2451, 119, 31, 0, 28, "Output"]
}, Open  ]],
Cell[2497, 122, 69, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[2591, 126, 91, 3, 42, "Input"],
Cell[2685, 131, 48, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2770, 137, 161, 5, 42, "Input"],
Cell[2934, 144, 91, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3062, 150, 54, 1, 28, "Input"],
Cell[3119, 153, 45, 0, 28, "Output"]
}, Open  ]],
Cell[3179, 156, 244, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[3448, 164, 28, 0, 28, "Input"],
Cell[3479, 166, 32, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3548, 171, 78, 2, 28, "Input"],
Cell[3629, 175, 83, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3749, 181, 60, 1, 28, "Input"],
Cell[3812, 184, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3877, 189, 83, 2, 28, "Input"],
Cell[3963, 193, 60, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4060, 200, 83, 2, 28, "Input"],
Cell[4146, 204, 120, 5, 63, "Output"]
}, Open  ]],
Cell[4281, 212, 251, 9, 42, "SmallText"],
Cell[CellGroupData[{
Cell[4557, 225, 161, 5, 28, "Input"],
Cell[4721, 232, 47, 0, 30, "Output"]
}, Open  ]],
Cell[4783, 235, 305, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[5113, 245, 57, 2, 32, "Input"],
Cell[5173, 249, 84, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5294, 256, 171, 7, 36, "Input"],
Cell[5468, 265, 62, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5567, 272, 145, 5, 30, "Input"],
Cell[5715, 279, 103, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5855, 287, 93, 3, 42, "Input"],
Cell[5951, 292, 107, 3, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6095, 300, 192, 8, 36, "Input"],
Cell[6290, 310, 177, 7, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6504, 322, 59, 1, 28, "Input"],
Cell[6566, 325, 86, 3, 31, "Output"]
}, Open  ]],
Cell[6667, 331, 205, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[6897, 340, 121, 5, 36, "Input"],
Cell[7021, 347, 100, 4, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7158, 356, 66, 1, 28, "Input"],
Cell[7227, 359, 62, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7326, 366, 225, 10, 36, "Input"],
Cell[7554, 378, 204, 9, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7795, 392, 66, 1, 28, "Input"],
Cell[7864, 395, 28, 0, 28, "Output"]
}, Open  ]],
Cell[7907, 398, 161, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[8093, 407, 123, 5, 48, "Input"],
Cell[8219, 414, 97, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8353, 423, 103, 2, 28, "Input"],
Cell[8459, 427, 93, 4, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8601, 437, 166, 5, 79, "Section"],
Cell[8770, 444, 155, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[8950, 451, 526, 20, 44, "Input"],
Cell[9479, 473, 567, 22, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10083, 500, 57, 1, 28, "Input"],
Cell[10143, 503, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10208, 508, 604, 23, 45, "Input"],
Cell[10815, 533, 642, 25, 45, "Output"]
}, Open  ]],
Cell[11472, 561, 138, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[11635, 569, 261, 8, 28, "Input"],
Cell[11899, 579, 1863, 65, 109, "Output"]
}, Open  ]],
Cell[13777, 647, 210, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[14012, 657, 137, 4, 28, "Input"],
Cell[14152, 663, 933, 31, 52, "Output"]
}, Open  ]],
Cell[15100, 697, 405, 10, 76, "SmallText"],
Cell[CellGroupData[{
Cell[15530, 711, 60, 1, 28, "Input"],
Cell[15593, 714, 120, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15750, 722, 63, 1, 28, "Input"],
Cell[15816, 725, 29, 0, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15894, 731, 57, 0, 55, "Section"],
Cell[15954, 733, 244, 4, 59, "SmallText"],
Cell[16201, 739, 94, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[16320, 745, 192, 6, 30, "Input"],
Cell[16515, 753, 105, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16657, 760, 84, 2, 28, "Input"],
Cell[16744, 764, 29, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16810, 769, 58, 1, 28, "Input"],
Cell[16871, 772, 29, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16937, 777, 212, 7, 28, "Input"],
Cell[17152, 786, 269, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17458, 796, 263, 8, 28, "Input"],
Cell[17724, 806, 2691, 67, 169, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20452, 878, 167, 5, 28, "Input"],
Cell[20622, 885, 6146, 225, 459, "Output"]
}, Open  ]],
Cell[26783, 1113, 192, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[27000, 1121, 130, 5, 39, "Input"],
Cell[27133, 1128, 191, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27361, 1139, 61, 1, 28, "Input"],
Cell[27425, 1142, 593, 17, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28055, 1164, 97, 2, 28, "Input"],
Cell[28155, 1168, 600, 18, 69, "Output"]
}, Open  ]],
Cell[28770, 1189, 350, 9, 59, "SmallText"],
Cell[CellGroupData[{
Cell[29145, 1202, 494, 18, 52, "Input"],
Cell[29642, 1222, 1325, 45, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31004, 1272, 99, 3, 28, "Input"],
Cell[31106, 1277, 1042, 37, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32185, 1319, 157, 5, 30, "Input"],
Cell[32345, 1326, 131, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32513, 1335, 83, 2, 28, "Input"],
Cell[32599, 1339, 313, 10, 28, "Output"]
}, Open  ]],
Cell[32927, 1352, 347, 8, 76, "SmallText"],
Cell[CellGroupData[{
Cell[33299, 1364, 122, 4, 28, "Input"],
Cell[33424, 1370, 1357, 46, 77, "Output"]
}, Open  ]],
Cell[34796, 1419, 695, 14, 178, "SmallText"],
Cell[CellGroupData[{
Cell[35516, 1437, 207, 7, 28, "Input"],
Cell[35726, 1446, 313, 10, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36088, 1462, 117, 4, 55, "Section"],
Cell[36208, 1468, 167, 5, 42, "SmallText"],
Cell[36378, 1475, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[36479, 1480, 100, 3, 28, "Input"],
Cell[36582, 1485, 118, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36737, 1494, 237, 8, 30, "Input"],
Cell[36977, 1504, 518, 15, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37532, 1524, 180, 6, 43, "Input"],
Cell[37715, 1532, 293, 11, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38045, 1548, 180, 6, 43, "Input"],
Cell[38228, 1556, 1776, 64, 173, "Output"]
}, Open  ]],
Cell[40019, 1623, 575, 11, 127, "SmallText"],
Cell[CellGroupData[{
Cell[40619, 1638, 314, 11, 47, "Input"],
Cell[40936, 1651, 317, 11, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41290, 1667, 106, 3, 41, "Input"],
Cell[41399, 1672, 1364, 46, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42800, 1723, 78, 2, 28, "Input"],
Cell[42881, 1727, 325, 12, 43, "Output"]
}, Open  ]],
Cell[43221, 1742, 188, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[43434, 1751, 107, 3, 41, "Input"],
Cell[43544, 1756, 1364, 46, 98, "Output"]
}, Open  ]],
Cell[44923, 1805, 386, 10, 76, "SmallText"],
Cell[CellGroupData[{
Cell[45334, 1819, 163, 5, 28, "Input"],
Cell[45500, 1826, 686, 26, 60, "Output"]
}, Open  ]],
Cell[46201, 1855, 67, 0, 42, "SmallText"],
Cell[CellGroupData[{
Cell[46293, 1859, 163, 5, 41, "Input"],
Cell[46459, 1866, 189, 7, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46685, 1878, 277, 9, 45, "Input"],
Cell[46965, 1889, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47030, 1894, 296, 9, 28, "Input"],
Cell[47329, 1905, 472, 16, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47838, 1926, 163, 5, 30, "Input"],
Cell[48004, 1933, 210, 7, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48251, 1945, 130, 4, 52, "Input"],
Cell[48384, 1951, 178, 6, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48599, 1962, 257, 8, 28, "Input"],
Cell[48859, 1972, 164, 6, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49060, 1983, 247, 8, 28, "Input"],
Cell[49310, 1993, 688, 24, 65, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50047, 2023, 106, 5, 55, "Section"],
Cell[50156, 2030, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[50257, 2035, 141, 4, 28, "Input"],
Cell[50401, 2041, 178, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50616, 2052, 55, 1, 28, "Input"],
Cell[50674, 2055, 42, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50753, 2060, 62, 1, 28, "Input"],
Cell[50818, 2063, 42, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50897, 2068, 38, 0, 28, "Input"],
Cell[50938, 2070, 165, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51140, 2078, 132, 4, 30, "Input"],
Cell[51275, 2084, 141, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51453, 2093, 128, 4, 30, "Input"],
Cell[51584, 2099, 141, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51762, 2108, 208, 7, 30, "Input"],
Cell[51973, 2117, 517, 18, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52527, 2140, 98, 2, 28, "Input"],
Cell[52628, 2144, 234, 8, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52899, 2157, 177, 5, 28, "Input"],
Cell[53079, 2164, 125, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53241, 2173, 161, 5, 36, "Input"],
Cell[53405, 2180, 125, 4, 46, "Output"]
}, Open  ]],
Cell[53545, 2187, 214, 6, 49, "Input"],
Cell[CellGroupData[{
Cell[53784, 2197, 146, 4, 28, "Input"],
Cell[53933, 2203, 779, 22, 49, "Output"]
}, Open  ]],
Cell[54727, 2228, 604, 15, 127, "SmallText"],
Cell[CellGroupData[{
Cell[55356, 2247, 183, 2, 69, "Input"],
Cell[55542, 2251, 165, 3, 28, "Output"],
Cell[55710, 2256, 69, 1, 28, "Output"],
Cell[55782, 2259, 69, 1, 28, "Output"]
}, Open  ]],
Cell[55866, 2263, 742, 16, 127, "SmallText"],
Cell[CellGroupData[{
Cell[56633, 2283, 74, 1, 28, "Input"],
Cell[56710, 2286, 348, 7, 65, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57095, 2298, 189, 2, 69, "Input"],
Cell[57287, 2302, 195, 4, 28, "Output"],
Cell[57485, 2308, 86, 2, 28, "Output"],
Cell[57574, 2312, 121, 3, 28, "Output"]
}, Open  ]],
Cell[57710, 2318, 400, 12, 59, "SmallText"],
Cell[CellGroupData[{
Cell[58135, 2334, 159, 2, 49, "Input"],
Cell[58297, 2338, 69, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58403, 2344, 48, 1, 28, "Input"],
Cell[58454, 2347, 751, 11, 104, "Print",
 CellTags->"Info3392917247-1132742"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59242, 2363, 47, 1, 28, "Input"],
Cell[59292, 2366, 511, 8, 64, "Print",
 CellTags->"Info3392917255-3793923"],
Cell[59806, 2376, 485, 15, 24, "Print",
 CellTags->"Info3392917255-3793923"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
