(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    187462,       5815]
NotebookOptionsPosition[    165144,       5036]
NotebookOutlinePosition[    165808,       5063]
CellTagsIndexPosition[    165721,       5058]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Listen", "Title"],

Cell[CellGroupData[{

Cell[TextData[{
 "Listen im allt\[ADoubleDot]glichen Umgang mit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"4", "y"}]}], "\[Equal]", "6"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "-", "y"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"3", "x"}], "]"}], "3"], ",", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"5", "x"}], "]"}], "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Hk0VV3cB3BUplIJRVHSJClTkanv5akUZao0GEIppEyFnpRGpUGmpAFF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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwlmnk8VO8Xxy0zdiGSZFeRPUTWc5PKUva0WEIS2ihps6RElrJUWlHWVCh7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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwlm3k8Vd/3/+81XESlUJEKpUGUSqiwdt6FVJREmWkgZCyZh5I5JFNKJKRk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, Pi}, {-0.3333332456382144, 0.9999999707682925}}, {{
     0, 3.141592653589793}, {-0.3333332456382144, 0.9999999707682925}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFfQd8XsWV72BkgwkBQkvehs2aGhKWhNDCJrC0YEIJJjwgJG+TLBBa6GBY
WNbEBBKbGDfc5SJsY3CRe7dlW7Kq1SWrS5as3mUVq1uenf+551zNFfd+slmy
L79Y0pxv5syZM6fPzMcvHh//7FMvPj7+uScfH3P3a4+/8uxzT74+ZuzLrxnQ
qacodcqzSqmDYxT+1uZP/qHN//Vz+KHUGPp1qnI+0M4//BxrfX6qM3YIdLhR
Qz5fSD/D9LHePt3Z3Ka7247qY339nwWPmEs/z9ItZXU6YfYGnbxgi06N2Knj
pq3VKYu26bgZ63Xa0t16/0drdOqSHc5n09fR78bCyqXBmGfRz5H6SHk99U4O
36qLd6XqjoZWdQZ/1tPRpQ/tzdDJC7cR9uZDNWpJMMoZPOz48eO6NDpTJ87Z
pPM3Jeq+7l51Dn+GpRftSNExU1abz5LQl9nii3I6c6w+97BZ6zqdv5mGXOB0
1VWpRTrh4/W6MrlQhQdjmcpYuprbiajiXWn6+MDxbzEY9JbFHtRJczfp9tqW
+UO3/SOeDewBK7Cei6ytTF8epfM2JgDl3GAi/sZYuluP6sTZG3VNRon0001F
VWbb1uqjhvlzglF8yN0P7cskbvQe7VaXMAyEHJi/RVenFavZwSgmCwqzrenL
d+uBgQF1OWAjDG8TZwUP/CsPBLOw4MNxOepKhlUmFxgp3AUGqJnBKP7C3Qf6
j9E2QJy+z7CW0loj4Bt1v+HtjGAUH3D3/p4+HT9zvW6vaVb/zDDs7s53luje
jm6WG2sP3+dO5kPidGdzu/qBBYudukb3tHeqacFz/1m6HzUopkVS92uGoO06
0sHS5oviPe7e19mjY4GirVNdK7DuXkIL8j8KRjFR9rvvGHEAM15vUQFLACZO
CUbxJ3cf+nXirA1G6o6oG4WJRzqIMoOeJVaNZtWtqKjQ48aN06+99pp+4IEH
0FZhPOyqq67SDz74ILVGcP/zzz9fP/zww/r111+nfyAhzIecdy3JAvU1mSXq
JoYZ0kjBjxsx/dBLzqOPPqrXrl2Lll6zZg3aLjlz5swBzENOWVmZvuWWW/T2
7dtpzHXXXReSnINr9sPsUOtfGGYkFsJvaZIyo7XzBy3wVBdkpjz33HN1S0sL
dWhqatLnnXce29ZTdWtrqx47dqyeNWuWGglYGIb/mj4dpXt6OnR5SZw+bP7l
Z23UtVXZurur9R95cFlMNjSYWj9lWHlini7cnkKtiwRNd5s+fChOHyrYqwuy
t+iqwym6rbXmKS8nQTvsAMg8duyYHjFihPqaiFRvLzZWz54925dbv6KfZ+qG
2nwdu3uqToyeqzOTP9MH0yMN0Vm6JG+3LiuO1Qn7ZukD++frlLhFWMz/YfSN
BZU68/N91LqFYXkb4nV1ejG1HBP9dd1Ql6/joqbR8IwDn+qs1FW6qjxVV5Qm
6KLcnTo9aalOjluok2MX6pKCPUaWBtTj3lUO3QwjnupMsb+mfc455/D6vrjK
hxmHQatLi6LNKmfrQ4V7Dbf61OnWZ2XF+3XC3o91WuInRIL4KYhx0vzN5O1u
ZVjK4u26raqRWhewN8F2J0bPoSX09/fYqAtyttG0RXk7zWYdU78PrQ2PPfaY
+9l9992nm5ub6bO8vDx96aWX+u7l/xVb3FSmozZP1NUV6eoshtXX5uq4PTN0
Y12hOk+MMCyWMXowN7dZtl2smPRrbizV8XtmYsNcfI11BTp+70xsrPqddymV
lZUkcrAz+F1VVeV+tmjRIn3PPffop59+mmxRWlqa71J+yQwF57LT1tA/w7Vz
LHCeUauslJX4+xzLApFNbelQdwxxDrBA9vDcjHVGqGd6sR4nrJkpnwP8b8EW
+EFG3tPdbrg6XTc3lKjzGXak+bCONaLedbRZnc2w9GW7yVuidSfDjOwgGqGW
cLW39yhxuqm+yMJXTqrT0Van/l8wSeOs7kBhLJC6UFxTbxeJdXPjIfV1hiGA
QAyA1l0MQzhWsPWAYxKEzCNVhM9YLxefURvDu9m6sb5Y/SaYpAe4e111Dik3
NOpb1lalJiyBLXFtFULZjE8d63w3w7JXRevmkmpqiemtr83TSTHzvoBv/64p
RubT2AhbwcMvLELSE52g+tsMgwgZC0St00UxTHQCxYDM/FwmGIBsrdN9XT0s
zQ4hxlR48MFwlpcmWsbVlzf3+5Ak3iElfhEsPbVOYxjC+6ONrdS6h2Hw9SYO
8/QzkmPGL/bgy0lfq6vL06j1aDBJ93F3mH0h6Z9EgJOW6fqaXEeLGVa8O01X
Hsj3js06pAu2JHn6QSKTY8PJeAo++ABsPVqPBJN0ryWE+7Y58efFLpcWA27b
fJIg8e+y6dmrYxCfe/odbW/Quzf/iSTIxgcF0a6/8CXJZX7nETKAsOUSw8Ou
QFV7je6NsGXJxPqQpQfcfo6dMmGk28+MIXxwSTY+wAy5oUgSEYVa7t/9EU1/
GcFGEVqQhJUaCOU/Jkt5kD/mZIY+wmxQITPksiEY+/u62buEJADeu72tllqX
s1HF1sHrl+zJ0BWJeQ8xuDarFIIiu3jFEK5CVh4aqsZiE/KzN+maykxqfVeE
MSNa75zvRLziB/dFzNE5CVs9/RqNfmSnrabWL4NXNFY0vCZX52Sss1CEYSfJ
OuRmbIRayYog5mmJS2mzj/X1S25VlLtDV5YlU+vB4AkdBoQK0s/wBOnYsKys
LP3SSy/pF198UT/55JMUrJeXl4vlNhabrDR4KS6up6fHjudH4A8jBiZqdCkB
Zp7p1GGJGknqxa6NAsTOo03sJ052thEskwHLcrj2Nd+0BFiMjIqk6+9990p9
27U/UaEWMIY/A747b7tOv/Tic0PSnBPmuKBKTk7WEyZMoGnuvfdevW3btpAZ
lh9ZXx9eRoIzp5GezMlR6uOu1YuPj9e33eZEeuJzERaYqINaEu/Zc4bKyPzo
cOY6DcUrnbs+3qXD2h3XZ39xnhOn33EkZ/pmhfiNKLyr08kWgHPWhA9RWglF
uuwiUN5888166qSnyQAOJponTp5Y8Pr6en3hhRw3nSQrT0AS/BJUUf+Ojg49
cqTjhCVyQnRrghZqSXxp4w3KtYD3Cw7NWnpLUymiZmp90wevH01jWN3tRBrz
5TnpssPx06nQhEoNPvIhS7w3sNxxx636zdd/64a49mzSD/lxZGSkvvjii0Ou
9gSY75d2C8qpU6dSHtTe3k4G4/rrr3c3wQQZOjt1FbUu8GFWqLReNgHJJ4qN
tormZ292Y6oLQ+D1o+0StthSLpg8aQLCxpG8CT1tnaiuEik+ZIm0Y/Rdd/5U
f/D+mycw26n6zjvv1KNHj9ZJSUkhV/0lNAHVARslzLGRBX3DDTfonJwcN4SH
giMvhl0KZtrpvvjxtwmAUc6V8BtlEoRfJ7K3Q0m6lPvX1lTqM88cTQo2is0p
MjPE235kyDi0v27G9XS3uUUNv3ncirPhbkREBMxnyCLLl/BIg9UL7/LF6yDz
Qz6rXa8Tpvv7+/WmTZuILDPka7xyH9QUtSbN2+zma4h0kmKc2v25odB5qbmE
qbfrK6uWT9SXXHIxox5FRysPjfvlUBLEeA0tzZihkIHTQ8yGoMgQR0PMUH32
2WeHrALZ7CfuC9OD6yw0sX755Zfxz4Rd5qdQVFGWhGqi5QHCoG56z549+u23
34agCOd98OuEWRvo1ELmQQ2vOG8Xtb4RCp0PSeJvpSb0m8fG6bt+djPVhIT9
OBVZN3GhfnCch44xTKJPOYnS18KcbW5GHDjv4cOH9fjx4/Ubb7xB+7hq1aqQ
NawQeiDVM6QvJgimlpsA7Eihkri2/DDyBEmU7nLHtpixCzz9mkuq9cHI/R58
SJ0l7703mCQpUyLXRJDX19vpomivbcZ5j0clHUM4nQzhz6yxyMb6TPonLjx7
TQwOe6glSdXAQD+NNb9PhCSKQriYICikvGIyJ9d/w1EeTI+kllTNUAWvr3HK
Vme6Ywc46zrmLhFpp+EUte4JJulfuTtKplmpKz2MNox3S09SoDuYvsYtEtzu
M5X0a6tq0hmf7vHgM0Lppq0/DyZJyuj2hggKnF+YDaCW1Bap6GD6oXBwmw9M
iqP5mxPd8xDBh/RQov+7hyfJFlvZOJxjSa3sGyJfrTVuBUk23STdCBOp5a3X
rqMCtJAEWy5qwCTRYQPZ0nH4cYoDlVLSwLEBorWhulYcgof4075imDUHlArm
/iuYY5QHhvXW5xzWBVsOjDxBNJLqIgLp6+1y4fjf6JNf2kkvw4lCwzwB1fBT
66qUwv/x1KcxAQyD+MASj/qKV3iCm6e7Ozv1vHd+b+KwTtq8UyyhtbRLh7/z
wt9FQIcTWmbPV75uHIDTWe/x4ycrtPB9ybHh/9+E1jZsJyC0kpN+lULrmJLZ
/3tCO9KzeYsnjteZcUlOwhEksaumTdVbI5apHwYTSUeo5Yecws/lPhOhAI3L
G990+8fi2JRa5/vglWylttKEdblU5JGYxXd+SlVNbhA0f3VFOs5g5fKIB4dE
tXsj1+nlk9638DIbBrdr/n8+o2sOV/phkcCz62gzKuLUumLI8IrEPF0akyXH
6DgewXkhWuf5oJTqBc4H4W/QOjPEAnCh59BeJ9S47IuqSiRA5jva668Owcs2
kwHOe/sPJq47zqi/wIfq0nK94J1n5L6HE2k63kciBMrW5js7IgvGiaTU+X/M
MJPB0Smj3Q+31qTO4UYc/b10ImmPDZ/wvC7KzLeYIOU8z+ZvjViuV86Y4t6W
KTi4BSdw1JIABHe7cPqN1j8wrLGuEOUQat3AsOL83XQibveTa00g7UprbG7m
es/YLUsWGmX6mFpn2OR+cZvC33lF56WmyRUhO9h0M4ydqe6Fi4sYhjM/nPWj
dR3DjIXDrnv64QKH1GndDCNpua44lOAZW3u4TM9/64+W+lkZqWNH9dG2o0Yv
ntD9fb1yKWpg4JgbiA5mHy067RMn+5AjSjfTMLJzrQsb0Ls3TaCx32FY1spo
3KX0yAOyj5hdUyAX1tjjesF/PaWry2pZUXwDWymnJW2N1hEf/Ae1fiRcMHlW
a0uFZyo7S5H4E2ouAauMxQ0ak1JQ6zvuWOfYyM5SOtrq3ANkGbtm1od6Y/in
lo77ki6l14j3Juj4rc4hF9tlXVIQ5R5y+WUzY8RMlB3QJflRnrE4kM7P3uzp
52QzUR58uOIi59zuvNkZesHbr1IrRLYsN3RM5K7nvfUHfaShzr3LZ5dy/LIe
cQe2x77ato57P/b0K9h6QNcdLPPgw5mjVJ9kbF9Pl57/zhP6SGMbJ3G+pEut
tSizRC/60zMU5cr9Rcm0Uf+TqezsSOp0FCFHTaOTY5netn3SD7EUbht4bJ8Z
G71jkmfs0smv6uj1TpEgBOlyHL9q+nIjX87tt6ssa9FQm+/hEi6Ettc6PknO
g1tbKnV60nLPWFxoktsK0q+rpUPqxS4+nI8OHRu9fpFeMsG5cHn2sKQrw2A9
f/ybuiA9xr14Wld9EAUFz1TwrnK97gqLTCPv1Poew3B/QwoM0s8kJKi0evAd
KtznxigytrY8R88b/7Lu6ennfNYyiBLF1Vcf0eFvP2ukrd5FhrsHQyW8s6nN
vQsksNT4JW6dR7a/09ganGzZ/gWXeVsrG7xjEyJ0W2u1ZyxqU4vfe1bnpJRz
ou7La4letn8Wp1d89CKusbm8wSEebgjgOoBMJcUX5PDCG1jkqE3vGoluc8eK
1GOs288YgDi+rHql1Q8XEVGWkLHwBJHz3tTLp2zg+q4v6RK2LHhjvt6y4i3i
0mUuiuOkZLhKIdOTM+FSlojT0Y5GN7i4nGFImMReSD+U0FIjdnq4PnjgPuCO
jd0xW895YbpCCDU86aq9rVvPe/4vOi1+qUs6HJHUnGSqGmN/5J6N2J+mhmI4
Ho8NQb3KaIinX2l0li5PyPXgQ/0rPWmZZ2xe5ka9+NX3dOXhFg5KfUmXZClx
X6Fe8e4HiKkGrW/2FvfmkculwSsnrtXHvUnTl1oXWzBxTtKPbq/wLSjBZ/C7
BkDGIqlY99FkvWFZEicVvqRzmVUtmbRN71wyS5cWxbg+z57elXW+t4PwkG6O
j0AX15seTnatiXhEumLJt39E7MwQnZYQQS0niAijRexZOV3PeXM1rNywNIep
7u5+NefFpfrAjgjYte9Y3DCb7jFVJr7TDflOJCNRBiJfwyVqSRCG28VyMCn9
cK9fLvgKvnwz1rh/a2wYhQ1Ju8N1+AtLVHNz5wVDLeLXmOy8nDq14tUlOiNh
Ba7FSBhaU5lhZHeFZxpDss5Z65AoYShKx2LFv22TzdGO9MNZWXlingcf6q+l
RdHW2DA6LEiJXazXvPmJjo05dGEw38/kBXy6JFnt+stKnZexHleIJfJH2iub
LxPCC+JNBGzJDdYC5MBEkhyImoyVfkh8xKoPLmA7pa6DY8PoAAbRZsz0dTp8
Rsw3h1vASNXXN6BmTtyqMj/fS6KYl7nBvZEBcyHUyawUwhgjDQP/Y2u18Xuc
dx6SyOP4GecuaEl+Jc4BR0ZiOcuKYlBqJ644Y0carmyiGASSOvm1SNXZ2adC
LMWJLUep0tJm9en7GxTSXeT1cVFTdXd3m9xsgCuBt8R5gUQcsCAS1UjSisv5
8A0I3Oyx8MDI8OT1AO5b4gAMlMtq5B50jzt2FLk/eGBcMcY9t8i/blCpKVXf
Cl7QWbygtZEH1a4pkaqj/oiJl8r03m0f4Ib1uZaF3735XaTt7oIKthzQ1WlF
1PqJmFg4IhOJIqSTsdCwfdv/SkGzPDnAsyVRblkQXi6ghgyzfS4vyKRBlMWh
rt/Z3K6j/hapPl2e4cjg3/19icOc08mFzpwWq2KnrVUDRihhjcFi+EeTN57F
GoHSAq6r4pag8cTCp9rsUjfRvZm7yoVvJBNm3TYG55HCShP+9MrpB24wit8U
rKmJEXS1GdvPdCJiQqBLJx7If3Gl3tCsZ0yJhvIN4drf6xmME06PVjU17WrZ
vFiVOHuDMgumMZ1Hm+hOprG4RpYaxKfQcxNQjc+MjEnAwK8fqHUrd4WI4RQf
KExWMIihHS6EeGJCptsYg0n3dWtFg8U6wRBBe2XiWsFg6KE71LhLaDDYF14+
XxCnyspauNoS8vpO4CudIVySJyM7theq+I3pKnt1DKeno4hLUG1QAimpMb7C
RK9yTRFLbagtoBgHegqJGaynuXfIUSq4w8KIABEYczPXk05aGFHYwpknJgNG
cMawQF4yuMbURB9X8xAwMTP5c71n6/tkvOtr80GYYOzv7zZGo4Q8B6LYBLMc
M4PUDnB3M2VbptqwPpc94pd7U0TlQGHl3NmJqiAqU5VEpSu5P4TKU4aRFCga
WIob7jDWoMtIj0RLFKTP30wP2sbKUGNzMlM+I/bCBoEpsea3cVNIj+SiLqJK
PD5DKvFDFiVkWohzkgy7D8SGj4AzgJNLW4NklP250xUxcd7WZPXxzHjEX98O
LWEn8/SIb0WotrYeNW9ukso3Ubux12KCMz6Ncl+GzGFYR10LnoJaJt15QHtw
zX61ZHGKamw4elFoI/JlXg/xxRmVllqlonYXKxR86vPKxfnhIYb4mXkMA1FZ
K/dZzjSMnrUYZVVJiRUqJrr0H72EfhVvg/jCkFq2NE3V1rQpsMrMKrGJkTu3
9r2AYRVJ+XjhS60bRTrwNNFEZ61HOtWC+RxA+3pnZ0IncpoxPU4dMwY9+sPV
uqmkyo3XjGNwE7KFDCuNydKF252r39fzIuWhKaKp2bMS1NGjvSrE1Ofz1DB7
q1ZmmeFdxpesoSRIYt3K5EI3Tl7MMLyQlgrItdbUUBHYj+3bClV2Vi3nH75T
X8BTb96Ur/Jy6ymVwctSPK6S7ADFEphMtCIYhopbEb9jvIan7m7t1Lv4aW91
VZta8WkGz2mlCM6Eo6B/atbHCaqrq8+dtLOpTYwEbtzJnEsZlmq8Q9l+5+rj
D9j2yXLN3BQ6YOfMDo4JXvGFTEBLS5daGE77RgQg5TOx+NUWb/M3O5VPKmeN
wC6LRUZ8hPdmcoSw8vMsVV5+5OLgab/J0yYmlkNjaFrYejxnN6bBrdGti4OZ
otYKS+q8Adwo+FkqHULCADl4sE5t2Zx/STAB32IC2LY4BPAz8YrEPMl+8dw4
ZdF2evi+kmGIqhBS4xLGlUxA3cEyeq503HEfJOJmPy8djoBTFWppM2fE03aJ
4y/cnoIXpdSSogpecEd/uIoOPVYzDDVqKJZxBIM1v52pZDTRYnxkg2GL0QrB
E87NVElJs4pcc9BGQcWXpHmbqTgrxRLkyZgeL8IjGWY+p3yhsaBysPjb20ex
jOGr6y527SxS6elOtS4ElzjVVOvW5qiiokYPSUhNoiYu19UZxW4RBIpohIP2
Zh0bPWyrsRX0OPr4wHEpXeDdFHI843lcqqCny5elU+uy4amC1mLvUJc41Z7N
iC0KbYYKqTOgdgadMsKjNjEMNf79UyNJuKSmgPIghsL1mL+FsP5+Y4anxdHv
y4caES4KqKamTrVoYQq7isFVYl7M8Q/WHDgagR82odoWBps/SdYxtdkyyfJL
92XR+Y/B5IaTJhFSVYZXgwLqyyeudKi42DIVH3eYjauDFm8xIShNxdXu2xkc
NRHcuCgz3Q4Gw70CBNE2XS50wU0UOWFvrfsXGUaqIF1oXRFMG2+MYViyamzs
tGgLo/QfOohj0ZKoNLleCzmGgO17f4WuyymLYjBqNvK1IcYCSm+YCWgMhMEE
xlIeb2vrJn1E67vDkwfREvPAdxhIxAq3pdBXZ0gsxZUO2lt4Cxgo6BwODqP5
M2PPdYKRBbD9cFwOqHLHtRg5MWGNPrBgK73UhyGTexTinGDUrgwmmctxqqy0
Ra1e5TgmJ875Bt1QQH0qacEWsmJIjop2pOpiE7jU5ZSTU603NhSBDC7txRq1
AJnoh8+gz3GMC8tHiQGmGsuM+dsqo9sx5BhwCoLj3fKkPHqXmfnZXrrODFag
L2x0V3O7WwVFFlCQbx8k+C6Nzz3hUyiEQMvh3GiyeE0l1WZHDpCE5kTGmqWm
mkgomzgO0lO5L9wJIl2Qlr0qBjGbzjbaju9BgLzgcSTfBFWFhY1k9tD6XjBp
AkMK0t7u2PhOhqGkhI3DBn5/qNWQgR0dTlRmDwSy1lbHmX8/eG62uionp05t
2uhUHjsYhmgrgw38VcEouGqu1qzOVocOOTWqNoYdPnyEoia0/nl4FFQrYWvc
yjDbu14djII9Faq4av48RzmPuAYixTUQjOJkqz9y5au0tFSqPvS7q6vLN3/i
UxBykMjS0Wpm2N69hyhqQusHXnJOtKwiJtie0o8MDj0QhFPZEa1GhsH6L1vq
eMofesnwq004n43Sp512mn7iiSfocjpmwm/DBZqdMmpZumymCYhVA8P6TJ6L
iBZO8BrvnH6p+2g2xJMnT9bvvUdfY4N+fiURDp4oCpb9r2fY4kUpqq7OEetr
Qq908AGO8xbj9ttv142NjUGz8imlysysUVu3FFCrlmExMaWuy/xR6G1G4iu1
n8zMTP3WW2/R1vpNyXEt2efioiZqVTMMVbOlnzgHV9d6p/RLYaUy8sEHH7iS
5Je6ypTkRWbGk1GSl+mUXU6jHIVTO1/15LI8maS5c5wspJJhEUtSVW1tO7VC
oOBSrzqYXas2sqkqF16bBCSOeX19MApOStTGDbmUYKBVxjCT7VBQhNYNFgrC
wDVFsqpHjjhW9RDDIN9ioG4MnltQwLZBBdBdUMyx0IZAcbUPqcUMW78uV+Xm
OBL/42AUcvPPZlghw+AWkTajdVMwCrlGiW2r5ggyn2G29f2X4VFQTGx4AZ7k
WWYDAgXYT4JR8FdgUcQsM+Yy7JOINFVZ6TgQGwVh+JElRogd0DrIsD17SlRC
vCNUPw2em69rqS1b8lVmhlMFy2IYVBLJM1o3B6PgKghKOKq+3jFNGQyDJMCd
Q91uGR6FaCAYlm4xEUVBxHv/GoyCr+dR+gxK0EqzmFhR4TAxBIobfNiZIuyM
KlGJCQ47bw1GcaMPOw8wDBnjypUOO28LRsFVNKp/VFc7Mpnow87bh0qDDAQT
ZzHDEizYx2zu7giem8/jyLQBBXgfzzBIpnieECi4Wkn8hlqhFcsw2Pm8XEex
7wxGwYdoKi2tmmJctGIYBi+EvUDrZ8EofmrtA9CgtY9hKCiIyXGefn3pA7Sa
mhr9q1/9Sj/zzDP6/vvv17m5ub5e52aGIXqTTHWPCKyJ5mCLsadjveSc7MkU
SJdTqezsbH3jjTeGJAfbO31aLElKFMOgepAU/L7bS05wKDVSn3HGGbqz03kk
bn7Tq+/BkwmZkApRBjnEcRfDsG44DfDh594Jg+OokTosLIy+6QGTTZo0KXCt
/L5MNbBdwHQ7GYZwXsL8n4deq/2a+ZprrtGvvvqqPuuss/SVV16pMzIyfKe+
lWGYQjKH7T6CeU/oXbef8q5evVo/8sgjuq+vT/k9VODjPnUgqcLNgbb6qM69
3in9Iio5Dty4caN+/PHH9QsvvKCff/55v4XyOzyaUTzxZoZB36V8d1+wwvIR
G4V8YiI2Mgwag8ooWvcPj0IKBBi2wTKcEDJI/C+CUdxpmcuPpuynYessxZCE
7oGhtpffa5J9FWcVaWkZ6IEEjgue+y6LVMwDGlZbS0KoiSWF+AqbsZasSxi3
yjI9IushUNxt8VzU5XOGwWjK3oT45h7+LiLyd1K+5HI5lRBE7B8KRsFf8UQp
pwjPcoZtNymoCFmIb0TiL66iGEicCB9WUDqza5cTbtrf6kQY7rM6oWyAVoSl
QqJWIb40i79aTO0z2bFkzHwuREGEBBchvgqMvzuLFPaTTxw3ulBQmIQbMTJa
Ib7gjL/rSm3bWkB5OloLLPsgKB4LRjHO4nn0PgcFHz2q5AOVdFsGrV8Ho3jQ
omJ/jJOhzBEUyZXu9ob4FrtfMgw2UxYyy0KxhlHY381HGB7iTrt3F7tbOZNh
sfvLXA6E+J5B/iYrkjipf033QfvbYBQPMyw1pUp9tsI5Fp0qS9o8uKTfBaN4
hGEobSGoglZOYRhWL5Hp74NRPMqwkuImUmzYBv42ZNJSqY79u4Piy0ZEu3fv
Jg8C/4jfUVFRIb711AkTYRxhVfkLkok0mKu8vHr1hJeck42ILrjgAnwDEPWv
q6ujbwLyI+cxhiHpQwICI8zflEykIehGJflJLzmhIqJrr71WL168mL5tAgfr
QdeEfs0w5N5wHcj2/myTY5JK/P6Dd+pQsVFJSQmRhj6GJF1cXGwFY7+22Iwk
A6n2RIZhjbIdT4Veqx0R3XTTTTo8PNxdq2n7rvXfGIYaHo5h0JpgqQcSNZD1
dOhdty9XYH2NjVQI1A0NDUSW39S/ZRjsvpjwd8S8GSUWH/GMd+pQ1yUg6wjG
XnnlFbpGFyTrv2MYHB/qdygVvGVtAq5R4LJGiG/T/z3DUFuCfKJU8CbDkKxB
SKBKfwxG8e+WOOPIB0Wj8QyDq0Z4hPDl+WAUTzAM/kuqK69afMW2wjS9MNQQ
P8mdkBLD+KB2+hLDjh0bIJsGDrwUPPcfGIbYBqtFueYFhiF1AAxBy8vBKJ5i
GPiPWAbncn9kGFwTbA6480owimesrURAhjjvaUuBwxccoIjjtWAUzzIMR28w
K7DpsjhYPKgfKr+vB6MQoiGz4DlY6GxvGP0NGPbH7MX4YCzPMwwHG4gWcfIk
ogovAWOEz94MRvECT4pNh3fGPho2/IbBvb3HiNGQFyPo/zFULEQEYN7ATYRX
YolRhgYr6mo71NvBFLzCMMREczmLFIeLzUHeANF8JxjFq0wtth6qiIjEBN8P
MhhxOAwGTKVxC/8VjOh1HgFFhIYhgjScud9iEnw9VlpW1vJuMKI3LHUBD/Bb
4ln4aaTQKFJNDEbxpjUp6IB2G0MvGYIoPMT+z8FY3mIssFKIdkD6jh2FdzAY
NIDpYLCRu/eH7u9/OobSybl3FFJfoIEC3syfAfWWzXnqw0nRRCjafwmmaAJP
jfNIWBIU1Iwm8d03Uhwc3oH92dl1k4MR/Ynnh8B8/lkmIYMQYf5rLdoQ5tJE
n2dR378Fo3zPWi7EFxIDjSgsaORi9UiiG4wHShgR9A3x3ypwYpBRdHKIOjfs
CxJToDccv4I/PnbsOGVm8J/ogtuDRg/5v+HgPG366r961EvqJPp5GqkRonLQ
AosK5sK0YNO/w33wN0QQ+QOuPHw4OZqUH8t0Xo/6fl3YyX4Vph+ZTth8Ot1A
gvRjg/APEgPnjM0ydut87gaPCBB8BfYTXVCjQDZkhG1uMLGhYsTBYMz5r2Vc
RDtYZSI/pCWoFWEOzIVTzY+mxJAxXrcuh9RnzapsipZ2bi8y4llBOSKWAgu8
xCwFnEdIL7SixAc8yGHgIo1Yhw9Pt1+A6cdQJx88k/Yd5X8UGZKMIg2lEPIJ
6a+sbIP/X3bynAsK7ejnWK+s+375nH8keaIofb9VzT9CHA6ln6rbn9Pfz4X+
W53y38zBlqU=\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iteratoren", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   SuperscriptBox["i", "2"], ",", 
   SuperscriptBox["i", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "9", ",", "16"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "4", ",", 
     FractionBox["1", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   FractionBox["25", "4"], ",", "9", ",", 
   FractionBox["49", "4"], ",", "16"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "9", ",", "4"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", "5", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"3", ",", "5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "5"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"3", ",", "5", ",", "0.3"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.`", ",", "3.3`", ",", "3.6`", ",", "3.9`", ",", "4.2`", ",", "4.5`", ",",
    "4.8`"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listen erzeugen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["x", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "4", ",", "9", ",", "16"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "2"], "&"}], ",", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "4"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "4", ",", "9", ",", "16"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["x", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "50", ",", "10"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "100", ",", "400", ",", "900", ",", "1600", ",", "2500"}],
   "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["x", "y"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "2", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SuperscriptBox["x", "y"], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "2", ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "//", " ", "Grid"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0", "0"},
    {"1", "1", "1"},
    {"4", "8", "16"},
    {"9", "27", "81"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["n", "m"], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     SuperscriptBox["n", "m"], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      SuperscriptBox["x", "n"], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "l"}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["x", "3"], "]"}], ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["x", "4"], "]"}], ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["x", "5"], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   SuperscriptBox["x", "3"]}], ";"}], "\[IndentingNewLine]", "l"}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "3"], ",", 
   SuperscriptBox["x", "6"], ",", 
   SuperscriptBox["x", "9"], ",", 
   SuperscriptBox["x", "12"], ",", 
   SuperscriptBox["x", "15"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"x", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "[", "1", "]"}], ",", 
   RowBox[{"x", "[", "2", "]"}], ",", 
   RowBox[{"x", "[", "3", "]"}], ",", 
   RowBox[{"x", "[", "4", "]"}], ",", 
   RowBox[{"x", "[", "5", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"x", ",", "5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "[", "1", "]"}], ",", 
   RowBox[{"x", "[", "2", "]"}], ",", 
   RowBox[{"x", "[", "3", "]"}], ",", 
   RowBox[{"x", "[", "4", "]"}], ",", 
   RowBox[{"x", "[", "5", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "l", "]"}]], "Input"],

Cell[BoxData["3"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"l", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
  "]"}]], "Input"],

Cell[BoxData["4"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input"],

Cell[BoxData["3"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input"],

Cell[BoxData["2"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", "l", "]"}]], "Input"],

Cell[BoxData["3"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Depth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "c"}]}], "]"}], ",", 
   RowBox[{"Depth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "/", "c"}]}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"c", "+", "d"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData["3"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auf Listenelemente zugreifen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData["b"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData["d"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData["List"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "\[LeftDoubleBracket]", "0", 
  "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData["Plus"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4"}], "}"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", "2"}], "]"}]], "Input"],

Cell[BoxData["b"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "4"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"2", ";;", "4"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "//", "Grid"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b", "c"},
    {"d", "e", "f"},
    {"g", "h", "i"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData["c"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", "1", ",", "3"}], "]"}]], "Input"],

Cell[BoxData["c"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a", ",", 
     SuperscriptBox["b", "c"], ",", 
     SqrtBox["3"]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Head", "[", "l", "]"}], ",", " ", 
   RowBox[{"First", "[", "l", "]"}], ",", 
   RowBox[{"Last", "[", "l", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"List", ",", "1", ",", 
   SqrtBox["3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input"],

Cell[BoxData["Plus"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funktionen und Listen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"5", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"5", " ", "a"}], ",", 
   RowBox[{"5", " ", "b"}], ",", 
   RowBox[{"5", " ", "c"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"d", ",", "e", ",", "f"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "d"}], ",", 
   RowBox[{"b", "+", "e"}], ",", 
   RowBox[{"c", "+", "f"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    FractionBox["i", 
     RowBox[{"i", "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["2", "3"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["4", "5"], ",", 
   FractionBox["5", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5`", ",", "0.6666666666666666`", ",", "0.75`", ",", "0.8`", ",", 
   "0.8333333333333334`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "3"], ",", 
   SuperscriptBox["x", "4"], ",", 
   SuperscriptBox["x", "5"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "+", 
  RowBox[{"f", "[", "b", "]"}], "+", 
  RowBox[{"f", "[", "c", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listen manipulieren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"l", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ";"}], 
  " "}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{"l", ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "7"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["l"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{"l", ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"First", "[", "l", "]"}], ",", 
   RowBox[{"Rest", "[", "l", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "5", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "4", ",", "5", ",", "3"}],
   "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h"}],
   "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"l", ",", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", "100"}], "]"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Partition", "[", 
  RowBox[{"l", ",", "5"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"84", ",", "80", ",", "9", ",", "32", ",", "99"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "29", ",", "75", ",", "14", ",", "84"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "8", ",", "47", ",", "81", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "66", ",", "95", ",", "83", ",", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "47", ",", "11", ",", "39", ",", "59"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "42", ",", "91", ",", "80", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "16", ",", "100", ",", "66", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "48", ",", "89", ",", "27", ",", "49"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "6", ",", "90", ",", "31", ",", "50"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "85", ",", "7", ",", "15", ",", "59"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"l", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}], "&"}],
   "/@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "i"}], "+", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "5"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"84", ",", "80", ",", "9", ",", "32", ",", "99"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "29", ",", "75", ",", "14", ",", "84"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "8", ",", "47", ",", "81", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "66", ",", "95", ",", "83", ",", "69"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "47", ",", "11", ",", "39", ",", "59"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "42", ",", "91", ",", "80", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "16", ",", "100", ",", "66", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "48", ",", "89", ",", "27", ",", "49"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "6", ",", "90", ",", "31", ",", "50"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "85", ",", "7", ",", "15", ",", "59"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "f"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "f"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"l", "\[LeftDoubleBracket]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "#"}], "\[RightDoubleBracket]"}], 
   "&"}], "/@", 
  RowBox[{"Range", "[", "3", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "f"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "a"}], ",", 
   RowBox[{"2", "+", "b"}], ",", 
   RowBox[{"3", "+", "c"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "==", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], " ", "//", 
  "Thread"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Equal]", "a"}], ",", 
   RowBox[{"2", "\[Equal]", "b"}], ",", 
   RowBox[{"3", "\[Equal]", "c"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"glsys", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{"y", "-", "z"}], ",", 
      RowBox[{"z", "+", 
       RowBox[{"2", "x"}]}]}], "}"}], "==", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"glsys", "//", "Thread"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", "y"}], "\[Equal]", "1"}], ",", 
   RowBox[{
    RowBox[{"y", "-", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", "z"}], "\[Equal]", "3"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"glsys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "4"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "3"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "5"}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Substitutionslisten", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gls", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "3"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x"}], "\[Equal]", "3"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "3"}], ",", 
   RowBox[{
    RowBox[{"x", "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "3"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"gls", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["13"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox[
        SqrtBox["13"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["13"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "#"}], "&"}], ",", "sol"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["13"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["13"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], "+", 
      FractionBox[
       SqrtBox["13"], "2"]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["13"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["13"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["13"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], "+", 
      FractionBox[
       SqrtBox["13"], "2"]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["13"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "i"], "+", " ", 
         SuperscriptBox["y", "i"]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], "/.", "#"}], 
     "&"}], ",", "sol"}], "]"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["13"]}], ",", 
     RowBox[{"7", "+", 
      SqrtBox["13"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "-", 
      RowBox[{"4", " ", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"31", "+", 
      RowBox[{"7", " ", 
       SqrtBox["13"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["13"]}], ",", 
     RowBox[{"7", "-", 
      SqrtBox["13"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "+", 
      RowBox[{"4", " ", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"31", "-", 
      RowBox[{"7", " ", 
       SqrtBox["13"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "i"], "+", " ", 
      SuperscriptBox["y", "i"]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], "/.", "sol"}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["13"]}], ",", 
     RowBox[{"7", "+", 
      SqrtBox["13"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "-", 
      RowBox[{"4", " ", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"31", "+", 
      RowBox[{"7", " ", 
       SqrtBox["13"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["13"]}], ",", 
     RowBox[{"7", "-", 
      SqrtBox["13"]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "+", 
      RowBox[{"4", " ", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"31", "-", 
      RowBox[{"7", " ", 
       SqrtBox["13"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Beispiel: Nullstellen eines Polynoms \[UDoubleDot]ber ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "p"], TraditionalForm]]]
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"primeList", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", "50", "]"}], ",", "PrimeQ"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "13", ",", "17", ",", 
   "19", ",", "23", ",", "29", ",", "31", ",", "37", ",", "41", ",", "43", 
   ",", "47"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"werteTafel", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "3"], "+", "x", "+", "1"}], ",", "31"}], "]"}]}],
      "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "30"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "30"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"werteTafel", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
     "\[Equal]", "0"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "&"}], ",", "%"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "14"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "30"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["#", "3"], "+", "#", "+", "1"}], ",", "31"}], "]"}], 
     "\[Equal]", "0"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "14"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "[", 
   RowBox[{"p_", "?", "PrimeQ"}], "]"}], ":=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"p", "-", "1"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "3"], "+", "#", "+", "1"}], ",", "p"}], "]"}], 
      "\[Equal]", "0"}], "&"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "sol"}]], "Input"],

Cell["Global`sol", "Print", "PrintUsage",
 CellTags->"Info3392904800-7722620"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"sol", "[", 
          RowBox[{"p_", "?", "PrimeQ"}], "]"}], ":=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", 
             RowBox[{"p", "-", "1"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{
                SuperscriptBox["#1", "3"], "+", "#1", "+", "1"}], ",", "p"}], 
              "]"}], "\[Equal]", "0"}], "&"}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["sol"],
  Editable->False]], "Print",
 CellTags->"Info3392904800-7722620"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "[", "13", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "7", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"sol", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
  "primeList"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", "2", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", "7", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{"{", "11", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{"{", "4", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", 
     RowBox[{"{", "26", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "14"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", 
     RowBox[{"{", "25", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", 
     RowBox[{"{", "38", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "34", ",", "35"}], "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "3"], "+", "x", "+", "1"}], ",", 
       RowBox[{"Modulus", "\[Rule]", "#"}]}], "]"}]}], "}"}], "&"}], "/@", 
  "primeList"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"9", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"2", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"11", "+", 
        RowBox[{"7", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"11", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"19", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"17", "+", 
        RowBox[{"4", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"10", "+", 
        RowBox[{"26", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"17", "+", "x"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"28", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"12", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"34", "+", 
        RowBox[{"25", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"26", "+", 
        RowBox[{"38", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"12", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"13", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"22", "+", "x"}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Beispiel: Punkte auf einer elliptischen Kurve \[UDoubleDot]ber ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "p"], TraditionalForm]]]
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{"l1", ",", "4"}], "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "9", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], "}"}],
  Short[#, 4]& ]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"Join", "@@", "l1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{"l2", ",", "5"}], "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "87", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "}"}],
  Short[#, 5]& ]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ec11", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"l2", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "2"], "-", 
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "3"], "-", "1"}], ",", "11"}], "]"}], "\[Equal]", "0"}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ec11", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "2"], "-", 
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "3"], "-", "1"}], ",", "11"}], "]"}], "\[Equal]", "0"}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"ec11", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
    PointBox[{{-4., -5.}, {-4., 5.}, {-2., -2.}, {-2., 2.}, {-1., 0.}, {
     0., -1.}, {0., 1.}, {2., -3.}, {2., 3.}, {5., -4.}, {5., 4.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-4., 5.}, {-5., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ec", "[", 
   RowBox[{"p_", "?", "PrimeQ"}], "]"}], ":=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "p"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "p"}], "}"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "2"], "-", 
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "3"], "-", "1"}], ",", "p"}], "]"}], "\[Equal]", "0"}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"primeList", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Range", "[", "50", "]"}], ",", "PrimeQ"}], "]"}]}], ";", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"ec", "[", "#", "]"}], "]"}]}], "}"}], "&"}], ",", 
    "primeList"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "47"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "47"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teillisten und Muster", "Section"],

Cell[CellGroupData[{

Cell["Select, MatchQ und Cases", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a", ",", 
     SuperscriptBox["b", "c"], ",", 
     SuperscriptBox["d", "3"], ",", 
     RowBox[{"e", "+", "f"}], ",", 
     SqrtBox["3"]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["_", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["b", "c"], ",", 
   SuperscriptBox["d", "3"], ",", 
   SqrtBox["3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      SuperscriptBox["_", "_"]}], "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["b", "c"], ",", 
   SuperscriptBox["d", "3"], ",", 
   SqrtBox["3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["x_", "y_Integer"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  SuperscriptBox["d", "3"], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      SuperscriptBox["_", "_Integer"]}], "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  SuperscriptBox["d", "3"], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    SuperscriptBox["x_", "y_Integer"], "\[Rule]", 
    SuperscriptBox["x", 
     RowBox[{"2", "y"}]]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  SuperscriptBox["d", "6"], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{"l", ",", 
    RowBox[{
     RowBox[{"MatchQ", "[", 
      RowBox[{"#", ",", 
       SuperscriptBox["_", "_Integer"]}], "]"}], "&"}]}], "]"}], "/.", 
  RowBox[{
   SuperscriptBox["x_", "y_Integer"], "\[Rule]", 
   SuperscriptBox["x", 
    RowBox[{"2", "y"}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  SuperscriptBox["d", "6"], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["_", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "a", ",", 
   RowBox[{"e", "+", "f"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"#", ",", 
       SuperscriptBox["_", "_"]}], "]"}]}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "a", ",", 
   RowBox[{"e", "+", "f"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{"12", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "5"]}], "//", "Expand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"12", "+", 
  RowBox[{"60", " ", "x"}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"u", ",", 
   RowBox[{"12", 
    SuperscriptBox["_", "_"]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "5"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"u", ",", 
   RowBox[{"__", " ", "_"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"60", " ", "x"}], ",", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"60", " ", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"u", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"_", " ", "__"}]}], "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"60", " ", "x"}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"List", "@@", "%"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"60", " ", "x"}], ",", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"60", " ", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData["l"], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weitere Listenkommandos", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", "_Symbol"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "a", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{"l", ",", "_Symbol"}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"l", ",", "_Times"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"l", ",", "_Power"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"l", ",", "_Times"}], "]"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{"u", ",", "_Times"}], "]"}]], "Input"],

Cell[BoxData["5"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"u", ",", "_Power"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"u", ",", "_Power"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zusammengesetzte Muster und Defaultmuster", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     SuperscriptBox["x", "2"], ",", 
     SuperscriptBox["a", 
      RowBox[{"b", "+", "c"}]], ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], 
      RowBox[{"c", "+", "d"}]]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    SuperscriptBox["x_", "_"], "]"}], ":=", 
   RowBox[{"x", "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "l"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "5", "]"}], ",", 
   RowBox[{"3", "+", "x"}], ",", 
   RowBox[{"3", "+", "a"}], ",", 
   RowBox[{"3", "+", "a", "+", "b"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ":", 
     SuperscriptBox["_", "_"]}], "]"}], ":=", 
   RowBox[{"x", "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "l"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "5", "]"}], ",", 
   RowBox[{"3", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"3", "+", 
    SuperscriptBox["a", 
     RowBox[{"b", "+", "c"}]]}], ",", 
   RowBox[{"3", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], 
     RowBox[{"c", "+", "d"}]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     SuperscriptBox["x", "2"], ",", "a", ",", 
     RowBox[{"a", " ", "x"}], ",", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["x", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  SuperscriptBox["x", "2"], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["x", "_."]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   RowBox[{"_", " ", 
    SuperscriptBox["x", "_."]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "x"}], ",", 
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   RowBox[{"_.", 
    SuperscriptBox["x", "_."]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"a", " ", "x"}], ",", 
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spezielle listenbasierte Datenstrukturen", "Section"],

Cell[CellGroupData[{

Cell["Mengen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ";", " ", 
  RowBox[{"l2", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "4", ",", "3"}], "}"}]}], ";", 
  RowBox[{"l3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "1", ",", "2"}], "}"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l1", "\[Union]", "l2"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", "l3", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l3", "\[Union]", 
  RowBox[{"{", "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l1", "\[Intersection]", "l2"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"l1", ",", "l2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"l1", ",", "1"}], "]"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vektoren und Matrizen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11", ",", "12"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"m", "//", "MatrixForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3"},
     {"4", "5", "6"},
     {"7", "8", "9"},
     {"10", "11", "12"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", "v"}], "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"14"},
      {"32"},
      {"50"},
      {"68"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", ".", "v"}]], "Input"],

Cell[BoxData["14"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "m", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"ml", "=", 
    RowBox[{"Transpose", "[", "m", "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "4", "7", "10"},
     {"2", "5", "8", "11"},
     {"3", "6", "9", "12"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ml", "//", "Dimensions"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weitere Beispiele", "Section"],

Cell[CellGroupData[{

Cell["\<\
Komplexe Zahlen in Real- und Imagin\[ADoubleDot]rteil aufspalten\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", "Complex", "]"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.0330211946991378`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46547336970111364`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15508351833087866`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.8899896303481603`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.821288492651961`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.22134645173710651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.14491720394831212`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.09097420786871445`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.22342365171290804`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.8069003703406307`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"l", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
      "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"l", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"Length", "[", "l", "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.0330211946991378`", ",", "0.46547336970111364`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.15508351833087866`", ",", "0.8899896303481603`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.821288492651961`", ",", "0.22134645173710651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14491720394831212`", ",", "0.09097420786871445`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0.22342365171290804`", ",", "0.8069003703406307`"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], ",", "l"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.0330211946991378`", ",", "0.46547336970111364`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.15508351833087866`", ",", "0.8899896303481603`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.821288492651961`", ",", "0.22134645173710651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14491720394831212`", ",", "0.09097420786871445`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0.22342365171290804`", ",", "0.8069003703406307`"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "#", "]"}], ",", 
     RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], " ", "/@", " ", 
  "l"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.0330211946991378`", ",", "0.46547336970111364`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.15508351833087866`", ",", "0.8899896303481603`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.821288492651961`", ",", "0.22134645173710651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14491720394831212`", ",", "0.09097420786871445`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0.22342365171290804`", ",", "0.8069003703406307`"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Re", "[", "l", "]"}], ",", " ", 
    RowBox[{"Im", "[", "l", "]"}]}], "}"}], "//", "Thread"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.0330211946991378`", ",", "0.46547336970111364`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.15508351833087866`", ",", "0.8899896303481603`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.821288492651961`", ",", "0.22134645173710651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14491720394831212`", ",", "0.09097420786871445`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0.22342365171290804`", ",", "0.8069003703406307`"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Komplexe Zahlen aus zwei Listen konstruieren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Random", "[", "]"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Random", "[", "]"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.5239016151527356`", ",", "0.6160141171654988`", ",", 
     "0.42165643046213247`", ",", "0.19426321588951792`", ",", 
     "0.8530701788378958`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.23112180629004678`", ",", "0.05173956933195533`", ",", 
     "0.46100621046049245`", ",", "0.9576233067381316`", ",", 
     "0.6678226125726421`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"l", "\[LeftDoubleBracket]", 
     RowBox[{"1", ",", "i"}], "\[RightDoubleBracket]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"l", "\[LeftDoubleBracket]", 
      RowBox[{"2", ",", "i"}], "\[RightDoubleBracket]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
    
    RowBox[{"I", " ", 
     RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
   "&"}], "/@", 
  RowBox[{"Thread", "[", "l", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Apply", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", "+", 
        RowBox[{"I", " ", "#2"}]}], "&"}], ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"Transpose", "[", "l", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",",
      
     RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
    "}"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "->", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#1", "+", 
      RowBox[{"I", "#2"}]}], ")"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#1", "+", 
      RowBox[{"I", "#2"}]}], ")"}], "&"}], "[", 
   RowBox[{
    RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
    
    RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"#1", "+", 
     RowBox[{"I", "#2"}]}], ")"}], "&"}], "[", 
  RowBox[{
   RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
  RowBox[{"I", " ", 
   RowBox[{
   "l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5239016151527356`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23112180629004678`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6160141171654988`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.05173956933195533`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.42165643046213247`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.46100621046049245`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.19426321588951792`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9576233067381316`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.8530701788378958`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6678226125726421`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gleitender Durchschnitt", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", "20"}], "]"}], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "17", ",", "11", ",", "3", ",", "0", ",", "1", ",", "10", ",", "11", ",", 
   "6", ",", "11", ",", "12"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sublists", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"l", "\[LeftDoubleBracket]", 
     RowBox[{"i", "+", 
      RowBox[{"Range", "[", "4", "]"}]}], "\[RightDoubleBracket]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "6"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"17", ",", "11", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10", ",", "11", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "6", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "6", ",", "11", ",", "12"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"l", ",", "4", ",", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"17", ",", "11", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10", ",", "11", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "6", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "6", ",", "11", ",", "12"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sums", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Apply", "[", 
     RowBox[{"Plus", ",", "#"}], "]"}], "&"}], "/@", "sublists"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "31", ",", "15", ",", "14", ",", "22", ",", "28", ",", "38", ",", "40"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", "sublists", ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "31", ",", "15", ",", "14", ",", "22", ",", "28", ",", "38", ",", "40"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sums", "/", "4"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["31", "4"], ",", 
   FractionBox["15", "4"], ",", 
   FractionBox["7", "2"], ",", 
   FractionBox["11", "2"], ",", "7", ",", 
   FractionBox["19", "2"], ",", "10"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"gleitenderDurchschnitt", "[", 
   RowBox[{"l_List", ",", 
    RowBox[{"n_Integer", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", ">", "0"}], "&"}], ")"}]}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Apply", "[", 
       RowBox[{"Plus", ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"l", "\[LeftDoubleBracket]", 
        RowBox[{"i", "+", 
         RowBox[{"Range", "[", "n", "]"}]}], "\[RightDoubleBracket]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{
          RowBox[{"Length", "[", "l", "]"}], "-", "n"}]}], "}"}]}], "]"}]}], 
    ")"}], "/", "n"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"Sin", "[", "x", "]"}]}], "+", 
        RowBox[{"Random", "[", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Pi]", ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"gleitenderDurchschnitt", "[", 
    RowBox[{"l1", ",", "20"}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"l1", ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"l2", ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], "}"}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw913lczen3APDP3a+mRkMalKWNxPjamn6E82TaJpWtQSQREUVaBqH6IjEj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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0., 3.14}, {0., 2.975000424002947}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12HlcTekbAPB7lntvlhimmTJTMSTJLBfZ5XlMRswMDWYqI8ZWyFKkSQ0i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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0., 3.045}, {0, 2.624494789043587}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{537, 594},
WindowMargins->{{Automatic, 193}, {Automatic, 42}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3392904800-7722620"->{
  Cell[89663, 2644, 78, 1, 43, "Print",
   CellTags->"Info3392904800-7722620"],
  Cell[89744, 2647, 1189, 34, 45, "Print",
   CellTags->"Info3392904800-7722620"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3392904800-7722620", 165534, 5050}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 23, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[638, 27, 135, 5, 79, "Section"],
Cell[776, 34, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[877, 39, 138, 4, 30, "Input"],
Cell[1018, 45, 204, 7, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1259, 57, 350, 12, 28, "Input"],
Cell[1612, 71, 159, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1808, 81, 397, 13, 43, "Input"],
Cell[2208, 96, 47204, 785, 223, 34506, 575, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49449, 886, 32, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[49506, 890, 130, 4, 30, "Input"],
Cell[49639, 896, 158, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49834, 906, 155, 5, 30, "Input"],
Cell[49992, 913, 83, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50112, 920, 165, 5, 30, "Input"],
Cell[50280, 927, 84, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50401, 934, 199, 6, 42, "Input"],
Cell[50603, 942, 150, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50790, 951, 196, 6, 30, "Input"],
Cell[50989, 959, 84, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51110, 966, 58, 1, 28, "Input"],
Cell[51171, 969, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51311, 976, 81, 2, 28, "Input"],
Cell[51395, 980, 83, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51515, 987, 93, 2, 28, "Input"],
Cell[51611, 991, 150, 4, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51810, 1001, 37, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[51872, 1005, 126, 3, 28, "Input"],
Cell[52001, 1010, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52141, 1017, 192, 6, 30, "Input"],
Cell[52336, 1025, 104, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52477, 1032, 182, 6, 30, "Input"],
Cell[52662, 1040, 104, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52803, 1047, 204, 6, 30, "Input"],
Cell[53010, 1055, 128, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53175, 1063, 263, 8, 28, "Input"],
Cell[53441, 1073, 332, 10, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53810, 1088, 319, 10, 28, "Input"],
Cell[54132, 1100, 332, 10, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54501, 1115, 63, 1, 28, "Input"],
Cell[54567, 1118, 266, 10, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54870, 1133, 234, 7, 28, "Input"],
Cell[55107, 1142, 216, 7, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55360, 1154, 288, 9, 28, "Input"],
Cell[55651, 1165, 216, 7, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55904, 1177, 281, 9, 49, "Input"],
Cell[56188, 1188, 352, 11, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56577, 1204, 153, 4, 52, "Input"],
Cell[56733, 1210, 230, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57000, 1222, 169, 5, 28, "Input"],
Cell[57172, 1229, 248, 7, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57457, 1241, 81, 2, 28, "Input"],
Cell[57541, 1245, 248, 7, 28, "Output"]
}, Open  ]],
Cell[57804, 1255, 318, 11, 28, "Input"],
Cell[CellGroupData[{
Cell[58147, 1270, 59, 1, 28, "Input"],
Cell[58209, 1273, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58274, 1278, 129, 3, 28, "Input"],
Cell[58406, 1283, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58471, 1288, 92, 2, 28, "Input"],
Cell[58566, 1292, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58631, 1297, 115, 3, 28, "Input"],
Cell[58749, 1302, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58814, 1307, 58, 1, 28, "Input"],
Cell[58875, 1310, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58940, 1315, 240, 8, 28, "Input"],
Cell[59183, 1325, 73, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59293, 1332, 140, 4, 28, "Input"],
Cell[59436, 1338, 28, 0, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59513, 1344, 50, 0, 45, "Subsection"],
Cell[59566, 1346, 136, 4, 28, "Input"],
Cell[CellGroupData[{
Cell[59727, 1354, 93, 1, 28, "Input"],
Cell[59823, 1357, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59888, 1362, 111, 2, 28, "Input"],
Cell[60002, 1366, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60067, 1371, 93, 1, 28, "Input"],
Cell[60163, 1374, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60231, 1379, 143, 4, 28, "Input"],
Cell[60377, 1385, 31, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60445, 1390, 140, 3, 28, "Input"],
Cell[60588, 1395, 73, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60698, 1402, 80, 2, 28, "Input"],
Cell[60781, 1406, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60846, 1411, 129, 4, 28, "Input"],
Cell[60978, 1417, 73, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61088, 1424, 138, 4, 28, "Input"],
Cell[61229, 1430, 83, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61349, 1437, 117, 2, 28, "Input"],
Cell[61469, 1441, 83, 2, 28, "Output"]
}, Open  ]],
Cell[61567, 1446, 315, 10, 28, "Input"],
Cell[CellGroupData[{
Cell[61907, 1460, 58, 1, 28, "Input"],
Cell[61968, 1463, 242, 9, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62247, 1477, 93, 1, 28, "Input"],
Cell[62343, 1480, 83, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62463, 1487, 116, 2, 28, "Input"],
Cell[62582, 1491, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62647, 1496, 90, 2, 28, "Input"],
Cell[62740, 1500, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62805, 1505, 214, 6, 28, "Input"],
Cell[63022, 1513, 171, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63230, 1524, 188, 6, 28, "Input"],
Cell[63421, 1532, 171, 6, 28, "Output"]
}, Open  ]],
Cell[63607, 1541, 178, 6, 36, "Input"],
Cell[CellGroupData[{
Cell[63810, 1551, 184, 5, 28, "Input"],
Cell[63997, 1558, 99, 3, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64133, 1566, 80, 2, 28, "Input"],
Cell[64216, 1570, 31, 0, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64296, 1576, 43, 0, 45, "Subsection"],
Cell[64342, 1578, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[64443, 1583, 138, 4, 28, "Input"],
Cell[64584, 1589, 170, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64791, 1599, 107, 3, 28, "Input"],
Cell[64901, 1604, 170, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65108, 1614, 101, 3, 28, "Input"],
Cell[65212, 1619, 155, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65404, 1629, 66, 1, 28, "Input"],
Cell[65473, 1632, 170, 4, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65680, 1641, 163, 5, 28, "Input"],
Cell[65846, 1648, 155, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66038, 1658, 205, 7, 42, "Input"],
Cell[66246, 1667, 213, 7, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66496, 1679, 50, 1, 28, "Input"],
Cell[66549, 1682, 156, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66742, 1691, 127, 3, 30, "Input"],
Cell[66872, 1696, 203, 6, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67112, 1707, 140, 4, 28, "Input"],
Cell[67255, 1713, 88, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67380, 1720, 107, 3, 28, "Input"],
Cell[67490, 1725, 88, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67615, 1732, 113, 3, 28, "Input"],
Cell[67731, 1737, 144, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67912, 1746, 112, 3, 28, "Input"],
Cell[68027, 1751, 175, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68239, 1761, 115, 3, 28, "Input"],
Cell[68357, 1766, 88, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68482, 1773, 112, 3, 28, "Input"],
Cell[68597, 1778, 88, 2, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68734, 1786, 41, 0, 45, "Subsection"],
Cell[68778, 1788, 76, 1, 28, "Input"],
Cell[68857, 1791, 160, 6, 28, "Input"],
Cell[CellGroupData[{
Cell[69042, 1801, 82, 2, 28, "Input"],
Cell[69127, 1805, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69267, 1812, 27, 0, 28, "Input"],
Cell[69297, 1814, 93, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69427, 1821, 83, 2, 28, "Input"],
Cell[69513, 1825, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69653, 1832, 137, 4, 28, "Input"],
Cell[69793, 1838, 132, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69962, 1847, 218, 6, 28, "Input"],
Cell[70183, 1855, 139, 4, 28, "Output"]
}, Open  ]],
Cell[70337, 1862, 450, 16, 28, "Input"],
Cell[CellGroupData[{
Cell[70812, 1882, 60, 1, 28, "Input"],
Cell[70875, 1885, 139, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71051, 1894, 83, 2, 28, "Input"],
Cell[71137, 1898, 289, 10, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71463, 1913, 311, 9, 49, "Input"],
Cell[71777, 1924, 991, 23, 109, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72805, 1952, 373, 12, 28, "Input"],
Cell[73181, 1966, 991, 23, 109, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74209, 1994, 218, 7, 28, "Input"],
Cell[74430, 2003, 191, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74658, 2014, 59, 1, 28, "Input"],
Cell[74720, 2017, 230, 8, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74987, 2030, 62, 1, 28, "Input"],
Cell[75052, 2033, 230, 8, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75319, 2046, 250, 8, 28, "Input"],
Cell[75572, 2056, 230, 8, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75839, 2069, 163, 5, 28, "Input"],
Cell[76005, 2076, 155, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76197, 2086, 170, 5, 28, "Input"],
Cell[76370, 2093, 171, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76578, 2103, 205, 7, 28, "Input"],
Cell[76786, 2112, 176, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76999, 2122, 387, 13, 49, "Input"],
Cell[77389, 2137, 280, 10, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77706, 2152, 144, 4, 28, "Input"],
Cell[77853, 2158, 242, 8, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78144, 2172, 41, 0, 45, "Subsection"],
Cell[78188, 2174, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[78289, 2179, 274, 10, 30, "Input"],
Cell[78566, 2191, 239, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78842, 2204, 160, 5, 28, "Input"],
Cell[79005, 2211, 1176, 43, 109, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80218, 2259, 182, 7, 28, "Input"],
Cell[80403, 2268, 895, 35, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81335, 2308, 99, 3, 44, "Input"],
Cell[81437, 2313, 895, 35, 99, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82369, 2353, 393, 13, 46, "Input"],
Cell[82765, 2368, 919, 34, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83721, 2407, 292, 10, 46, "Input"],
Cell[84016, 2419, 919, 34, 89, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84996, 2460, 161, 5, 80, "Section"],
Cell[85160, 2467, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[85261, 2472, 154, 4, 44, "Input"],
Cell[85418, 2478, 225, 5, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85680, 2488, 366, 12, 46, "Input"],
Cell[86049, 2502, 1922, 64, 125, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88008, 2571, 218, 6, 28, "Input"],
Cell[88229, 2579, 172, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88438, 2590, 172, 5, 44, "Input"],
Cell[88613, 2597, 74, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88724, 2604, 327, 11, 46, "Input"],
Cell[89054, 2617, 74, 2, 44, "Output"]
}, Open  ]],
Cell[89143, 2622, 446, 15, 46, "Input"],
Cell[CellGroupData[{
Cell[89614, 2641, 46, 1, 44, "Input"],
Cell[89663, 2644, 78, 1, 43, "Print",
 CellTags->"Info3392904800-7722620"],
Cell[89744, 2647, 1189, 34, 45, "Print",
 CellTags->"Info3392904800-7722620"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90970, 2686, 57, 1, 44, "Input"],
Cell[91030, 2689, 50, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91117, 2695, 161, 6, 44, "Input"],
Cell[91281, 2703, 1386, 49, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92704, 2757, 299, 10, 46, "Input"],
Cell[93006, 2769, 3263, 110, 173, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96318, 2885, 170, 5, 81, "Section"],
Cell[96491, 2892, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[96592, 2897, 405, 13, 65, "Input"],
Cell[97000, 2912, 1671, 53, 105, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98708, 2970, 182, 5, 65, "Input"],
Cell[98893, 2977, 2235, 73, 125, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101165, 3055, 503, 15, 30, "Input"],
Cell[101671, 3072, 704, 24, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102412, 3101, 844, 26, 50, "Input"],
Cell[103259, 3129, 912, 34, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104208, 3168, 166, 4, 44, "Input"],
Cell[104377, 3174, 456, 12, 251, "Output"]
}, Open  ]],
Cell[104848, 3189, 830, 26, 66, "Input"],
Cell[CellGroupData[{
Cell[105703, 3219, 393, 13, 65, "Input"],
Cell[106099, 3234, 961, 32, 85, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107109, 3272, 40, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[107174, 3276, 46, 0, 45, "Subsection"],
Cell[107223, 3278, 251, 8, 52, "Input"],
Cell[CellGroupData[{
Cell[107499, 3290, 106, 3, 44, "Input"],
Cell[107608, 3295, 146, 5, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107791, 3305, 190, 6, 44, "Input"],
Cell[107984, 3313, 146, 5, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108167, 3323, 115, 3, 46, "Input"],
Cell[108285, 3328, 74, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108396, 3335, 197, 6, 46, "Input"],
Cell[108596, 3343, 74, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108707, 3350, 193, 6, 46, "Input"],
Cell[108903, 3358, 74, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109014, 3365, 334, 11, 46, "Input"],
Cell[109351, 3378, 74, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109462, 3385, 112, 3, 44, "Input"],
Cell[109577, 3390, 107, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109721, 3398, 213, 7, 44, "Input"],
Cell[109937, 3407, 107, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110081, 3415, 177, 6, 46, "Input"],
Cell[110261, 3423, 313, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110611, 3438, 127, 4, 44, "Input"],
Cell[110741, 3444, 99, 3, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110877, 3452, 106, 3, 44, "Input"],
Cell[110986, 3457, 334, 11, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111357, 3473, 190, 6, 44, "Input"],
Cell[111550, 3481, 302, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111889, 3496, 53, 1, 44, "Input"],
Cell[111945, 3499, 334, 11, 46, "Output"]
}, Open  ]],
Cell[112294, 3513, 27, 0, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112358, 3518, 45, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[112428, 3522, 87, 2, 44, "Input"],
Cell[112518, 3526, 50, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112605, 3532, 87, 2, 44, "Input"],
Cell[112695, 3536, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112760, 3541, 88, 2, 44, "Input"],
Cell[112851, 3545, 32, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112920, 3550, 86, 2, 44, "Input"],
Cell[113009, 3554, 32, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113078, 3559, 86, 2, 44, "Input"],
Cell[113167, 3563, 31, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113235, 3568, 86, 2, 44, "Input"],
Cell[113324, 3572, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113389, 3577, 88, 2, 44, "Input"],
Cell[113480, 3581, 32, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113549, 3586, 86, 2, 44, "Input"],
Cell[113638, 3590, 32, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[113719, 3596, 63, 0, 45, "Subsection"],
Cell[113785, 3598, 326, 11, 46, "Input"],
Cell[CellGroupData[{
Cell[114136, 3613, 307, 9, 85, "Input"],
Cell[114446, 3624, 204, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114687, 3635, 332, 10, 85, "Input"],
Cell[115022, 3647, 377, 13, 46, "Output"]
}, Open  ]],
Cell[115414, 3663, 263, 8, 46, "Input"],
Cell[CellGroupData[{
Cell[115702, 3675, 106, 3, 44, "Input"],
Cell[115811, 3680, 74, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115922, 3687, 107, 3, 44, "Input"],
Cell[116032, 3692, 98, 3, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116167, 3700, 132, 4, 44, "Input"],
Cell[116302, 3706, 147, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116486, 3716, 128, 4, 44, "Input"],
Cell[116617, 3722, 192, 6, 46, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116870, 3735, 59, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[116954, 3739, 28, 0, 45, "Subsection"],
Cell[116985, 3741, 76, 1, 44, "Input"],
Cell[117064, 3744, 361, 11, 44, "Input"],
Cell[CellGroupData[{
Cell[117450, 3759, 58, 1, 44, "Input"],
Cell[117511, 3762, 116, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117664, 3770, 59, 1, 44, "Input"],
Cell[117726, 3773, 83, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117846, 3780, 75, 2, 44, "Input"],
Cell[117924, 3784, 83, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118044, 3791, 65, 1, 44, "Input"],
Cell[118112, 3794, 73, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118222, 3801, 88, 2, 44, "Input"],
Cell[118313, 3805, 73, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118423, 3812, 84, 2, 44, "Input"],
Cell[118510, 3816, 31, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118590, 3822, 43, 0, 45, "Subsection"],
Cell[118636, 3824, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[118737, 3829, 142, 4, 44, "Input"],
Cell[118882, 3835, 31, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118950, 3840, 183, 6, 44, "Input"],
Cell[119136, 3848, 32, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119205, 3853, 209, 7, 44, "Input"],
Cell[119417, 3862, 31, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119485, 3867, 219, 7, 44, "Input"],
Cell[119707, 3876, 32, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119776, 3881, 456, 14, 65, "Input"],
Cell[120235, 3897, 640, 19, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120912, 3921, 82, 2, 44, "Input"],
Cell[120997, 3925, 655, 21, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121689, 3951, 49, 1, 44, "Input"],
Cell[121741, 3954, 29, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121807, 3959, 63, 1, 44, "Input"],
Cell[121873, 3962, 73, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121983, 3969, 148, 5, 44, "Input"],
Cell[122134, 3976, 633, 18, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122804, 3999, 60, 1, 44, "Input"],
Cell[122867, 4002, 73, 2, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123001, 4011, 36, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[123062, 4015, 94, 2, 45, "Subsection"],
Cell[123159, 4019, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[123260, 4024, 171, 5, 44, "Input"],
Cell[123434, 4031, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124172, 4049, 435, 13, 44, "Input"],
Cell[124610, 4064, 548, 16, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125195, 4085, 223, 8, 44, "Input"],
Cell[125421, 4095, 548, 16, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126006, 4116, 194, 7, 44, "Input"],
Cell[126203, 4125, 548, 16, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126788, 4146, 169, 5, 44, "Input"],
Cell[126960, 4153, 548, 16, 85, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127557, 4175, 66, 0, 45, "Subsection"],
Cell[127626, 4177, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[127727, 4182, 334, 11, 44, "Input"],
Cell[128064, 4195, 450, 12, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128551, 4212, 485, 13, 44, "Input"],
Cell[129039, 4227, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129777, 4245, 298, 9, 44, "Input"],
Cell[130078, 4256, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130816, 4274, 276, 9, 44, "Input"],
Cell[131095, 4285, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131833, 4303, 407, 13, 44, "Input"],
Cell[132243, 4318, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132981, 4336, 175, 6, 44, "Input"],
Cell[133159, 4344, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133897, 4362, 352, 11, 44, "Input"],
Cell[134252, 4375, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134990, 4393, 306, 9, 44, "Input"],
Cell[135299, 4404, 701, 13, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136037, 4422, 211, 5, 44, "Input"],
Cell[136251, 4429, 701, 13, 85, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137001, 4448, 45, 0, 45, "Subsection"],
Cell[137049, 4450, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[137150, 4455, 199, 6, 44, "Input"],
Cell[137352, 4463, 166, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137555, 4472, 304, 8, 44, "Input"],
Cell[137862, 4482, 620, 16, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138519, 4503, 95, 2, 44, "Input"],
Cell[138617, 4507, 620, 16, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139274, 4528, 165, 5, 44, "Input"],
Cell[139442, 4535, 136, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139615, 4544, 125, 3, 44, "Input"],
Cell[139743, 4549, 136, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139916, 4558, 52, 1, 44, "Input"],
Cell[139971, 4561, 238, 7, 58, "Output"]
}, Open  ]],
Cell[140224, 4571, 769, 24, 85, "Input"],
Cell[140996, 4597, 385, 13, 44, "Input"],
Cell[141384, 4612, 145, 4, 44, "Input"],
Cell[CellGroupData[{
Cell[141554, 4620, 594, 19, 85, "Input"],
Cell[142151, 4641, 22941, 389, 147, 10255, 179, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
