(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    209426,       5368]
NotebookOptionsPosition[    195663,       4923]
NotebookOutlinePosition[    197358,       4976]
CellTagsIndexPosition[    197142,       4968]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Mathematik mit dem Computer", "Title"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Texte und mathematische Texte"
}], "Section"],

Cell[TextData[{
 "Zum Austausch mit anderen Dokumenten ist es oftmals n\[UDoubleDot]tzlich, \
die Ausgaben der Kommandos nicht in der zweidimensionalen ",
 StyleBox["OutputForm",
  FontWeight->"Bold"],
 ", sondern in der eindimensionalen ",
 StyleBox["InputForm",
  FontWeight->"Bold"],
 " ausgeben zu lassen."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$PrePrint", "=", "InputForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "3"], "]"}]}], "Input"],

Cell["x^3 + 3*x^2*y + 3*x*y^2 + y^3", "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "$PrePrint", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "3"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"3", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematische Experimente und mathematische Beweise", "Section"],

Cell[TextData[{
 "Mathematik zu treiben bedeutet, einerseits mathematische ",
 StyleBox["Regelm\[ADoubleDot]\[SZ]igkeiten und Zusammenh\[ADoubleDot]nge",
  FontSlant->"Italic"],
 " zu entdecken und andererseits diese Beobachtungen mit (streng deduktiven \
Anspr\[UDoubleDot]chen gen\[UDoubleDot]genden) ",
 StyleBox["Beweisen ",
  FontSlant->"Italic"],
 "zu Gesetzm\[ADoubleDot]\[SZ]igkeiten zu verdichten. F\[UDoubleDot]r beide \
Phasen des \"Doing Mathematics\"  bietet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vielf\[ADoubleDot]ltige Unterst\[UDoubleDot]tzung."
}], "SmallText"],

Cell[CellGroupData[{

Cell["Beispiel 1: Potenzreste", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["3", "100"]], "Input"],

Cell[BoxData["515377520732011331036461129765621272702107522001"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["3", 
  SuperscriptBox["10", "10"]]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Overflow occurred in computation.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     SuperscriptBox["3", "k"], ",", "10"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "9", ",", "7", ",", "1", ",", "3", ",", "9", ",", "7", 
   ",", "1", ",", "3", ",", "9", ",", "7", ",", "1", ",", "3", ",", "9", ",", 
   "7", ",", "1", ",", "3", ",", "9", ",", "7", ",", "1", ",", "3", ",", "9", 
   ",", "7", ",", "1", ",", "3", ",", "9", ",", "7", ",", "1", ",", "3", ",", 
   "9", ",", "7", ",", "1", ",", "3", ",", "9", ",", "7", ",", "1", ",", "3", 
   ",", "9", ",", "7", ",", "1"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     SuperscriptBox["3", "k"], ",", "7"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "2", ",", "6", ",", "4", ",", "5", ",", "1", ",", "3", 
   ",", "2", ",", "6", ",", "4", ",", "5", ",", "1", ",", "3", ",", "2", ",", 
   "6", ",", "4", ",", "5", ",", "1", ",", "3", ",", "2", ",", "6", ",", "4", 
   ",", "5", ",", "1", ",", "3", ",", "2", ",", "6", ",", "4", ",", "5", ",", 
   "1", ",", "3", ",", "2", ",", "6", ",", "4", ",", "5", ",", "1", ",", "3", 
   ",", "2", ",", "6", ",", "4"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     SuperscriptBox["3", "k"], ",", "17"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "9", ",", "10", ",", "13", ",", "5", ",", "15", ",", 
   "11", ",", "16", ",", "14", ",", "8", ",", "7", ",", "4", ",", "12", ",", 
   "2", ",", "6", ",", "1", ",", "3", ",", "9", ",", "10", ",", "13", ",", 
   "5", ",", "15", ",", "11", ",", "16", ",", "14", ",", "8", ",", "7", ",", 
   "4", ",", "12", ",", "2", ",", "6", ",", "1", ",", "3", ",", "9", ",", 
   "10", ",", "13", ",", "5", ",", "15", ",", "11", ",", "16"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   SuperscriptBox["10", "10"], ",", "10"}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   SuperscriptBox["10", "10"], ",", 
   SuperscriptBox["10", "15"]}], "]"}]], "Input"],

Cell[BoxData["552200000000001"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beispiel 2: Perfekte Zahlen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DivisorSum", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", 
    RowBox[{"Divisors", "[", "n", "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "2"}], ",", 
   RowBox[{"i", "<", "800"}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DivisorSum", "[", "i", "]"}], "\[Equal]", 
      RowBox[{"2", "i"}]}], ",", 
     RowBox[{"Print", "[", "i", "]"}]}], "]"}]}], "]"}]], "Input"],

Cell[BoxData["6"], "Print"],

Cell[BoxData["28"], "Print"],

Cell[BoxData["496"], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "800", "]"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DivisorSum", "[", "#", "]"}], "\[Equal]", 
      RowBox[{"2", "#"}]}], ")"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "28", ",", "496"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"tb", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", "=", 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"k", "-", "1"}]], 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["2", "k"], "-", "1"}], ")"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"DivisorSum", "[", "n", "]"}], "\[Equal]", 
          RowBox[{"2", "n"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "n", ",", "\"\<ja\>\""}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "n", ",", "\"\<nein\>\""}], "}"}]}], "]"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "2", ",", "40"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Prepend", "[", 
    RowBox[{"tb", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<k\>\"", ",", "\"\<n\>\"", ",", "\"\<Perfekte Zahl\>\""}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", "True", "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", 
        RowBox[{"{", "False", "}"}], ",", "True"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"4", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", 
        RowBox[{"{", ".5", "}"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Right", "}"}], ",", "Center"}], "}"}], "}"}]}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"k\"\>", "\<\"n\"\>", "\<\"Perfekte Zahl\"\>"},
    {"2", "6", "\<\"ja\"\>"},
    {"3", "28", "\<\"ja\"\>"},
    {"4", "120", "\<\"nein\"\>"},
    {"5", "496", "\<\"ja\"\>"},
    {"6", "2016", "\<\"nein\"\>"},
    {"7", "8128", "\<\"ja\"\>"},
    {"8", "32640", "\<\"nein\"\>"},
    {"9", "130816", "\<\"nein\"\>"},
    {"10", "523776", "\<\"nein\"\>"},
    {"11", "2096128", "\<\"nein\"\>"},
    {"12", "8386560", "\<\"nein\"\>"},
    {"13", "33550336", "\<\"ja\"\>"},
    {"14", "134209536", "\<\"nein\"\>"},
    {"15", "536854528", "\<\"nein\"\>"},
    {"16", "2147450880", "\<\"nein\"\>"},
    {"17", "8589869056", "\<\"ja\"\>"},
    {"18", "34359607296", "\<\"nein\"\>"},
    {"19", "137438691328", "\<\"ja\"\>"},
    {"20", "549755289600", "\<\"nein\"\>"},
    {"21", "2199022206976", "\<\"nein\"\>"},
    {"22", "8796090925056", "\<\"nein\"\>"},
    {"23", "35184367894528", "\<\"nein\"\>"},
    {"24", "140737479966720", "\<\"nein\"\>"},
    {"25", "562949936644096", "\<\"nein\"\>"},
    {"26", "2251799780130816", "\<\"nein\"\>"},
    {"27", "9007199187632128", "\<\"nein\"\>"},
    {"28", "36028796884746240", "\<\"nein\"\>"},
    {"29", "144115187807420416", "\<\"nein\"\>"},
    {"30", "576460751766552576", "\<\"nein\"\>"},
    {"31", "2305843008139952128", "\<\"ja\"\>"},
    {"32", "9223372034707292160", "\<\"nein\"\>"},
    {"33", "36893488143124135936", "\<\"nein\"\>"},
    {"34", "147573952581086478336", "\<\"nein\"\>"},
    {"35", "590295810341525782528", "\<\"nein\"\>"},
    {"36", "2361183241400462868480", "\<\"nein\"\>"},
    {"37", "9444732965670570950656", "\<\"nein\"\>"},
    {"38", "37778931862819722756096", "\<\"nein\"\>"},
    {"39", "151115727451553768931328", "\<\"nein\"\>"},
    {"40", "604462909806764831539200", "\<\"nein\"\>"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Right}, Center}},
   GridBoxDividers->{
    "Columns" -> {{True}}, "Rows" -> {True, True, {False}, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}, "Rows" -> {2, 2, {0.5}, 2}},
   RowsEqual->False],
  "Grid"]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beispiel 3: Der Vietasche Wurzelsatz", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "7"], "-", 
      RowBox[{"3", 
       SuperscriptBox["x", "6"]}], "+", "x", "-", "1"}], "\[Equal]", "0"}], 
    ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.7561465100699936`"}], "-", 
      RowBox[{"0.4594035196742389`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.7561465100699936`"}], "+", 
      RowBox[{"0.4594035196742389`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.06607891130541203`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.8612948608912899`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.06607891130541203`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.8612948608912899`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.691445023196984`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.305088518350185`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.691445023196984`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.305088518350185`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.997245151135195`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"x", "/.", "s"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"3.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", "a", " ", "x"}], "+", "b"}], "\[Equal]", "0"}], ",", 
     "x"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "-", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "-", "b"}]]}], ",", 
   RowBox[{
    RowBox[{"-", "a"}], "+", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "-", "b"}]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
  RowBox[{
  "s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "a"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "Expand"}]], "Input"],

Cell[BoxData["b"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"x", "-", 
        SubscriptBox["x", "i"]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"], "-", 
       SubscriptBox["x", "3"]}], ")"}]}], "-", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["x", "3"]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"]}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["x", "4"], "+", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"], "-", 
       SubscriptBox["x", "3"], "-", 
       SubscriptBox["x", "4"]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["x", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "4"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "4"]}], "+", 
       RowBox[{
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}]}], ")"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "1"]}], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "4"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}], "-", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["x", "5"], "+", 
    RowBox[{
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"], "-", 
       SubscriptBox["x", "3"], "-", 
       SubscriptBox["x", "4"], "-", 
       SubscriptBox["x", "5"]}], ")"}]}], "-", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["x", "4"], " ", 
     SubscriptBox["x", "5"]}], "+", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "4"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "4"]}], "+", 
       RowBox[{
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "5"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "5"]}], "+", 
       RowBox[{
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "5"]}], "+", 
       RowBox[{
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "1"]}], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "4"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}], "-", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "5"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "5"]}], "-", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "5"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}], "-", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}], "-", 
       RowBox[{
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}]}], ")"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "5"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}], "+", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["x", "4"], " ", 
        SubscriptBox["x", "5"]}]}], ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programmierung ", "Section"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stellt eine voll ausgebaute imperative Programmiersprache zur Verf\
\[UDoubleDot]gung, die um (effizient implementierte) Elemente einer \
funktionalen Programmiersprache erweitert ist, und die vor allem beim \
Arbeiten mit rekursiv definierten Datenstrukturen wie z.B. Listen hilfreich \
sind. Der eingebaute Patternmatcher erlaubt regelbasiertes Programmieren, das \
 besonders f\[UDoubleDot]r die gezielte Simplifikation von \
Ausdr\[UDoubleDot]cken eingesetzt werden kann. Konzepte der Modularisierung, \
Kapselung, Paketbildung sowie inkrementelle Kompilierung stehen nicht nur den \
Entwicklern, sondern auch den Anwendern zur Verf\[UDoubleDot]gung."
}], "SmallText"],

Cell[CellGroupData[{

Cell["Steuerstrukturen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "3"}], ",", "x", ",", 
    RowBox[{"x", "+", "1"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"x", 
      RowBox[{"x", "<", "3"}]},
     {
      RowBox[{"x", "+", "1"}], "True"}
    }]}]}]], "Input"],

Cell["oder", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", "<", "3"}]}], "}"}], "}"}], ",", 
    RowBox[{"x", "+", "1"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFzXs0lHkcx/HJ9YmYZ8yN+eFMYRJ1OIs2TsvX2jWUW7eZUB1ihISdlcuy
ctfWjA3ZTbaL05awUVJU1sYel9Yme2q7bVJIkS2XUqlhnz3P0/P88Tmv8/7r
s3h7wnqFFovFyiT2v2/Xxh8JSshy/2hB5FLbG5JtHh+9/mI4Vi2Jp50476WK
k2TS5gimzbdIimh7utY82SA5SptwPPlaoKSOtk2luuIvaaXV1VPqj8beoPXd
E55/QXaHtilN0X/yr4e090J2OihThmg5UnVUGzylxW8pGj4NfU5rJY6rzt/+
knZV/64ez5JJ2rbZLL9bFdO00b91d7fmvKYtj6gS8cPe0K7Y/HhmTvGO9uF0
YC/4vqedGjBzFGzS0B6o/WaHXD5PK2Fj/qkVLPjoxcSs2qJjC2hv2ZTqryvR
orXOvWm7tVyb1jVowPlYhQ5tf2K+u1qlS9vgGmzUUaxHaz2176eDZYxlNS32
keWMqUi8RruS0V0zUuB5lrHnahKrtZdxWHpg+qKhPq2M1Z5TwGbsap7myLiM
Ncvkjq9FjImGlruc7Bg1vbUj9T6MAlnXvdP5jN6rfwbFd4wpS7KrFqsZ775w
2334IGNFYR2uOsEovlQmTWhjDDqmrLPvYMzOD+Q/62YcXLdwKKyP8eRYRub6
AcbbfcFPjIcY9ZpW+vWMMEbnTph98YLxUMz1LNYU47XAmqctrxlnXQoD0t4x
2plHXnDRMIZoeZpPsTBYkS02TmPhsP+ZRW6dDgber4o85Vo4tPTOjsZiGGzb
oUly0cFhvPFO0NJFGCTf33maq4eDRUVj0xAbgyL/+/9M6uMQkF1seZyLQdVV
H3bfQhzq/deOmyIM7p6ySVYZ4fDIyXbD35YYTJgdrI5l44CLdC8XL8EAU2v1
+3BwUI60FhrYYeD69YCXLh8H5z2fWH1YhcFhj3JOpjkOCgV7X/NqDBoa9L/c
YonDD2vHJ5IAgx6b5FQ3MQ5vhKda/5Vi8MFww8CMFQ6Xz5qFDMgw2Hp30ZkE
exw8BlnF7UkYiL/K8gl3I/73TFn2pWKw1yONHb0ah0E0/Et/BgaTRsrb8e44
5G3q6n6bh0F7TURkxuc4/NGtZjmUYaAY9s76cQ0OsnpRYsUFDGrlRs3XQ3CI
y3AOTJrBYKX74aVu6TiUC6KNJKkLwc+wUY/bgkPO0ZhCl1gD8LzR+LvIhQNH
eg91FiUaQsAOvwhpMwe+jS+dsFAuAvcm37fGribwPNzWNHi7Ecw48lTLz5nA
fs2YzsMoY+jM3K2V4MSFy+PSl8YhbNg6cyJF/wwXbtusGnSzxil5EL0swqH0
JE7JgzZZaLqnJYeSD06bx6p5lRxKPsTlet/5DJlQCmBvFDa7oNSEUgC/WoTP
j/G4lEK4NFegbVfEpRRC73mvMTWHR2kKHeKoTlUJj9IU8po2VT424FOawZYl
D7aFqvmUZvD+ogOy1xdQiiBDe/TPskwBpQgE1q7hNiwhJYKUeNkrgzQhJYJJ
lUEs/4OQEoF5nifPhmhSBNL01FZnokkRHIkZMdlINCkCX+/2KyVEkyKonE8z
wjVCSgTrlKNnDeaElAgyYsShIqJJEVSFyXXtiCZFoAnoCPYlmhRBtX2l1l6i
SREseLJ5o+68kBLB8gffz/GIJkUgv9l52ppoUgRn2pw1XkSTIgg+ip/KIZoU
QV6ZNKiEaFIE9arM2UqiSRHopo8HtBFNisBRafWuj2hSBKExISceEU2KoCCs
2H+CaFIE5+Tdb+aJJkXwH23aU70=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 6}, {0., 6.99999987755102}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFzXs0lHkcx/HJ9YmYZ8yN+eFMYRJ1OIs2TsvX2jWUW7eZUB1ihISdlcuy
ctfWjA3ZTbaL05awUVJU1sYel9Yme2q7bVJIkS2XUqlhnz3P0/P88Tmv8/7r
s3h7wnqFFovFyiT2v2/Xxh8JSshy/2hB5FLbG5JtHh+9/mI4Vi2Jp50476WK
k2TS5gimzbdIimh7utY82SA5SptwPPlaoKSOtk2luuIvaaXV1VPqj8beoPXd
E55/QXaHtilN0X/yr4e090J2OihThmg5UnVUGzylxW8pGj4NfU5rJY6rzt/+
knZV/64ez5JJ2rbZLL9bFdO00b91d7fmvKYtj6gS8cPe0K7Y/HhmTvGO9uF0
YC/4vqedGjBzFGzS0B6o/WaHXD5PK2Fj/qkVLPjoxcSs2qJjC2hv2ZTqryvR
orXOvWm7tVyb1jVowPlYhQ5tf2K+u1qlS9vgGmzUUaxHaz2176eDZYxlNS32
keWMqUi8RruS0V0zUuB5lrHnahKrtZdxWHpg+qKhPq2M1Z5TwGbsap7myLiM
Ncvkjq9FjImGlruc7Bg1vbUj9T6MAlnXvdP5jN6rfwbFd4wpS7KrFqsZ775w
2334IGNFYR2uOsEovlQmTWhjDDqmrLPvYMzOD+Q/62YcXLdwKKyP8eRYRub6
AcbbfcFPjIcY9ZpW+vWMMEbnTph98YLxUMz1LNYU47XAmqctrxlnXQoD0t4x
2plHXnDRMIZoeZpPsTBYkS02TmPhsP+ZRW6dDgber4o85Vo4tPTOjsZiGGzb
oUly0cFhvPFO0NJFGCTf33maq4eDRUVj0xAbgyL/+/9M6uMQkF1seZyLQdVV
H3bfQhzq/deOmyIM7p6ySVYZ4fDIyXbD35YYTJgdrI5l44CLdC8XL8EAU2v1
+3BwUI60FhrYYeD69YCXLh8H5z2fWH1YhcFhj3JOpjkOCgV7X/NqDBoa9L/c
YonDD2vHJ5IAgx6b5FQ3MQ5vhKda/5Vi8MFww8CMFQ6Xz5qFDMgw2Hp30ZkE
exw8BlnF7UkYiL/K8gl3I/73TFn2pWKw1yONHb0ah0E0/Et/BgaTRsrb8e44
5G3q6n6bh0F7TURkxuc4/NGtZjmUYaAY9s76cQ0OsnpRYsUFDGrlRs3XQ3CI
y3AOTJrBYKX74aVu6TiUC6KNJKkLwc+wUY/bgkPO0ZhCl1gD8LzR+LvIhQNH
eg91FiUaQsAOvwhpMwe+jS+dsFAuAvcm37fGribwPNzWNHi7Ecw48lTLz5nA
fs2YzsMoY+jM3K2V4MSFy+PSl8YhbNg6cyJF/wwXbtusGnSzxil5EL0swqH0
JE7JgzZZaLqnJYeSD06bx6p5lRxKPsTlet/5DJlQCmBvFDa7oNSEUgC/WoTP
j/G4lEK4NFegbVfEpRRC73mvMTWHR2kKHeKoTlUJj9IU8po2VT424FOawZYl
D7aFqvmUZvD+ogOy1xdQiiBDe/TPskwBpQgE1q7hNiwhJYKUeNkrgzQhJYJJ
lUEs/4OQEoF5nifPhmhSBNL01FZnokkRHIkZMdlINCkCX+/2KyVEkyKonE8z
wjVCSgTrlKNnDeaElAgyYsShIqJJEVSFyXXtiCZFoAnoCPYlmhRBtX2l1l6i
SREseLJ5o+68kBLB8gffz/GIJkUgv9l52ppoUgRn2pw1XkSTIgg+ip/KIZoU
QV6ZNKiEaFIE9arM2UqiSRHopo8HtBFNisBRafWuj2hSBKExISceEU2KoCCs
2H+CaFIE5+Tdb+aJJkXwH23aU70=
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 6}, {0., 6.99999987755102}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{1.2244897959183673`*^-7, 1.2244897959183673`*^-7}, {
          0.0018403075233577606`, 0.0018403075233577606`}, {
          0.0036804925977359294`, 0.0036804925977359294`}, {
          0.007360862746492267, 0.007360862746492267}, {0.014721603044004942`,
           0.014721603044004942`}, {0.029443083639030292`, 
          0.029443083639030292`}, {0.05888604482908099, 
          0.05888604482908099}, {0.11777196720918238`, 
          0.11777196720918238`}, {0.2454501425127519, 0.2454501425127519}, {
          0.3646673014209126, 0.3646673014209126}, {0.4815458929132563, 
          0.4815458929132563}, {0.6083308149489667, 0.6083308149489667}, {
          0.7266547205892683, 0.7266547205892683}, {0.8548849567729366, 
          0.8548849567729366}, {0.980776625540788, 0.980776625540788}, {
          1.0982072779132306`, 1.0982072779132306`}, {1.2255442608290397`, 
          1.2255442608290397`}, {1.3444202273494401`, 1.3444202273494401`}, {
          1.4609576264540236`, 1.4609576264540236`}, {1.5874013561019737`, 
          1.5874013561019737`}, {1.705384069354515, 1.705384069354515}, {
          1.833273113150423, 1.833273113150423}, {1.958823589530514, 
          1.958823589530514}, {2.0759130495151963`, 2.0759130495151963`}, {
          2.2029088400432455`, 2.2029088400432455`}, {2.3214436141758856`, 
          2.3214436141758856`}, {2.4498847188518926`, 2.4498847188518926`}, {
          2.5759872561120827`, 2.5759872561120827`}, {2.693628776976864, 
          2.693628776976864}, {2.821176628385012, 2.821176628385012}, {
          2.823037360182086, 2.823037360182086}, {2.82489809197916, 
          2.82489809197916}, {2.828619555573308, 2.828619555573308}, {
          2.836062482761604, 2.836062482761604}, {2.8509483371381967`, 
          2.8509483371381967`}, {2.8807200458913815`, 2.8807200458913815`}, {
          2.8825807776884558`, 2.8825807776884558`}, {2.8844415094855296`, 
          2.8844415094855296`}, {2.8881629730796776`, 2.8881629730796776`}, {
          2.8956059002679737`, 2.8956059002679737`}, {2.9104917546445663`, 
          2.9104917546445663`}, {2.940263463397751, 2.940263463397751}, {
          2.9420876550789528`, 2.9420876550789528`}, {2.943911846760155, 
          2.943911846760155}, {2.9475602301225585`, 2.9475602301225585`}, {
          2.9548569968473664`, 2.9548569968473664`}, {2.9694505302969816`, 
          2.9694505302969816`}, {2.971274721978183, 2.971274721978183}, {
          2.9730989136593853`, 2.9730989136593853`}, {2.976747297021789, 
          2.976747297021789}, {2.984044063746597, 2.984044063746597}, {
          2.985868255427799, 2.985868255427799}, {2.9876924471090005`, 
          2.9876924471090005`}, {2.9913408304714046`, 2.9913408304714046`}, {
          2.9931650221526063`, 2.9931650221526063`}, {2.9949892138338083`, 
          2.9949892138338083`}, {2.9968134055150104`, 2.9968134055150104`}, {
          2.9980867346938775`, 2.9980867346938775`}}], 
         LineBox[CompressedData["
1:eJwtzX9M1GUAx/Hj4OTx4LjnfsM9cpFwaeCGC2jCDD5EcZBClsrxQ51IIJAD
uwhhXGh6U6Z3NCA0dbpuLpSSUKMgMhY0ifWDaC11pmFkLvBa0AyNOOhp3+eP
z157//V5dEf1i6VymUz2DN//fp//iPleIEH5ebXn7wCKI79HHvggiCDzfnO6
XU5xeXRuspIQbNvpr0kKovD1XNuwIpSg9sbL53RLKCJP9vT+qiZozrnx00ww
Re4bLZZ3dARnP89Sjy2l6M5Z5wtnBNc7rLVuFcXthJUbf7QQTEe81VmppqBm
RX/LcgLikd/K0lA47g4cUsYSJL86nqEwUCTufSJ6fg3BibTjmsZlFKWl6sN9
awkuXQp+douF4ug633QNCL621talRFE8MHUM/GEjmA/ZOD4bTdF/IaJwPI9g
6/XQruo4irQJWctQDUHUK/uyilP4/96/LGN1BE1p9erytRQT7M75W06CGZXj
alUqhWvzlyMPXQRD75W85Hya4qsRjyy+naD0Tua+Y89R5HWbd5/8iOB9u6rv
20KKXc7E52tmCZ5MPbEipYHiuLFc9VjdUqwP6Vmiu0yx/3TFoaRKJdK/6/nC
nKTBqdG3h5t3hyB35/oSW58Gr1e1TUc6QpHam/0wLFmLe8Urwwt2qDC7Wu9e
dVGLI/6poJ/LwjDc+Jq8OkGHfp/tz7BCNbbOntkT3KXDVeuaiZQYKtSj/PGS
+LZ3qVCPwbyihnSLRmhAQv5Up96rERqw60DmtaeYVmhEUxmZC2jTCo34LLJ4
cUqvE5rwycLBwNhmndCE0Q8zpjwavTAcV6LKht2temE4XL2bvb8oDcIIbFl+
c1uRxyCMwL8fx7O4YKPQDGfg5DftjUahGcaY5GKrzCRk2FOVd19ZbxIyzLiV
lYZ5k5BhmStdb+UtyWBrqBtI5C3JcKrirnYTb0mG7MyhT1t5SzJ4F+tV1G8S
MrzgmLygXDAJGZwVUUVm3pIMZ7fbFbG8JRn8uVcKsnlLMnTGeeVNvCUZAn7L
36RYNAkZVt18c0HPW5LB/sPwuRjekgxdg4n+DN6SDAWnacd+3pIMrnbbhlbe
kgzd7sY5L29JBkWDL3eQtyTDakf0P2O8JRmKKgrP3OYtyXBwe0vONG9Jhov2
kQeLvCUZ/gM00rnh
          "]]}, {}}, {{}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 6}, {0., 6.99999987755102}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Meist werden die mathematischen EIgenschaften st\[UDoubleDot]ckweiser \
Funktionen von ",
 StyleBox["Piecewise",
  FontWeight->"Bold"],
 " pr\[ADoubleDot]ziser ber\[UDoubleDot]cksichtigt als in ",
 StyleBox["If",
  FontWeight->"Bold"],
 "-Konstrukten. \nHier etwa wird die Ableitung mathematisch \
pr\[ADoubleDot]ziser ermittelt und auch deren Graph ist an den Sprungstellen \
richtig dargestellt."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "1"}], ",", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", "3"}], ",", 
    RowBox[{"6", "-", 
     SuperscriptBox["x", "2"]}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "3"}], ",", 
       RowBox[{"x", "<", "1"}]}], "}"}], "}"}], ",", 
    RowBox[{"6", "-", 
     SuperscriptBox["x", "2"]}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f1", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "<", "1"}], ",", "2", ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"2", 
     RowBox[{"x", "<", "1"}]},
    {
     RowBox[{
      RowBox[{"-", "2"}], " ", "x"}], 
     RowBox[{"x", ">", "1"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f1", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f2", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xs01NsXAPBBMgbDzDc0Htcj6UFFiqTsXZRCykWvn6uHErm6kluyUoRf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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 2.},
      PlotRange->{{0, 2}, {2.0000001632653044`, 4.99969211705406}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{4.081632653061224*^-8, 3.000000081632653}, {
          0.0006134358411192535, 3.0012268716822383`}, {
          0.0012268308659119764`, 3.002453661731824}, {0.0024536209154974223`,
           3.004907241830995}, {0.004907201014668314, 3.0098144020293365`}, {
          0.009814361213010098, 3.0196287224260203`}, {0.019628681609693666`, 
          3.039257363219387}, {0.0392573224030608, 3.0785146448061216`}, {
          0.08181671417091729, 3.163633428341835}, {0.12155576714030418`, 
          3.2431115342806085`}, {0.1605152976377521, 3.3210305952755044`}, {
          0.20277693831632224`, 3.4055538766326445`}, {0.24221824019642277`, 
          3.4844364803928456`}, {0.2849616522576456, 3.5699233045152914`}, {
          0.32692554184692935`, 3.6538510836938585`}, {0.3660690926377435, 
          3.732138185275487}, {0.4085147536096799, 3.8170295072193596`}, {
          0.44814007578314674`, 3.8962801515662937`}, {0.48698587548467454`, 
          3.973971750969349}, {0.5291337853673247, 4.05826757073465}, {
          0.5684613564515052, 4.136922712903011}, {0.611091037716808, 
          4.222182075433616}, {0.6529411965101717, 4.305882393020344}, {
          0.6919710165050659, 4.383942033010132}, {0.7343029466810822, 
          4.468605893362165}, {0.773814538058629, 4.547629076117258}, {
          0.816628239617298, 4.633256479234596}, {0.858662418704028, 
          4.717324837408056}, {0.8978762589922885, 4.795752517984577}, {
          0.9403922094616711, 4.8807844189233425`}, {0.9410124533940292, 
          4.882024906788058}, {0.9416326973263871, 4.883265394652774}, {
          0.9428731851911032, 4.885746370382206}, {0.9453541609205353, 
          4.89070832184107}, {0.9503161123793994, 4.900632224758799}, {
          0.9602400152971277, 4.9204800305942555`}, {0.9608602592294857, 
          4.921720518458971}, {0.9614805031618436, 4.922961006323687}, {
          0.9627209910265597, 4.925441982053119}, {0.9652019667559918, 
          4.930403933511983}, {0.9701639182148559, 4.940327836429712}, {
          0.9800878211325842, 4.960175642265169}, {0.9806958850263181, 
          4.961391770052636}, {0.9813039489200521, 4.962607897840105}, {
          0.9825200767075202, 4.965040153415041}, {0.984952332282456, 
          4.969904664564912}, {0.9898168434323278, 4.979633686864656}, {
          0.9904249073260618, 4.980849814652124}, {0.9910329712197957, 
          4.982065942439592}, {0.9922490990072637, 4.984498198014528}, {
          0.9946813545821995, 4.989362709164399}, {0.9952894184759336, 
          4.990578836951867}, {0.9958974823696675, 4.991794964739335}, {
          0.9971136101571354, 4.99422722031427}, {0.9977216740508694, 
          4.995443348101739}, {0.9983297379446033, 4.9966594758892064`}, {
          0.9989378018383372, 4.9978756036766745`}, {0.9993622448979592, 
          4.998724489795919}}], LineBox[CompressedData["
1:eJwV1GswnHcUBvC1a+MWi/d1aV2KtY1R21EaRExzDpVWXbYVNNqKNDGlqiuI
ZsiQIrQhodURTC0hpI3rhiAyNkFQFQ0SuUhcMtXSItXXZdUuu9u/D2ee+c3z
+Tn2x08c+ozNYrGQ3E7+Pmcqk7AZaF2v+6ZFTeOnDM225TCwPKo+nEj8OG+7
XMJloM1ef6+risZAhzl3S10GLL2+mlnZorFHdm+0VJ8BO3M83Kqk0ePDjjgz
Qwb6O7+oTFbQyM/7tsKYYmBR9Lx0dYPGMn6iZ6EpA2Jfp4BWOY08WcR9AwsG
Crce3E1ap1Gx7MTVsWag5fZBT2aFxrGw375UvcpAwrmrssUXNApfhBs8CWZA
7WY00j5BY2dYUHf+BwyUD4v8wp/Q+PYt35MHQhlwkO3JXH9E48eFLpNXIhhg
ai/5u43TmPeGXkNKNANnL7ZbN9yjcT5FFkClMfDDatL9ojs0Vqn4+cG1DIgk
QvGbjTTSRoxuv5IBn+Y68eAZGrW7y6UOkhUQHayz/t6Rxvi9XU/1Aleh6nnC
6eQBChveO151e2MV7BS2pzOOUShfsjSeL1mDf7OGJBwtCttD3+UU+63DmsCc
/azYBL/2z73UNr8OU8dMU78TmqD9dMBETa4cHE4mxrv3GeN+z5zil902gHow
6xobbIyRr4wqtMY34KeulHlxpxHK7xbMJmb9B39F1vBnu3hYph2VckiwCXnS
lyw+GTJEeqb9Mrt/E5IGr8QHPtqN3IysMK8kBXgJ6kdyBwyQVRclnaWUoEt1
Zfj16mPyj9IC6o4SVCu9E7pVenjL+ZyuScIWrKSfavw1XRdNApKF2bxt4BRB
5cUYHZx6fWw8TbYNYZRB20PXXXitEgR/Rqlgwb3CakGfi0ekHiY2ahUMe/hE
5/3Bwczc6qypejXs/sgOKQkbm/62KecFaeBUMW95OVoLQ0x4+waVGqCre9oT
9VmYz2VbTRF78yUb7xD3K+Qqhlh8NNLThthjdrrPcksDa4bnO4f0WGh5ven9
BOKz3tU3+cSzYcGxZtsaaJ641vFQh4UpZRdKolUaeM3qiGQfl4VNFzLTUoml
NmNPecTzmSmRBcQHphwt5rRZGBEXyb9BfKYgt6iI+K39wmZ9NXGPImeRw8Jd
U8MDLcT5nw/ESNgshLHuq78Qy5xzLicTp/ZfPz9JrKx3nPEnXmwsD+FqNFAy
bR0u12LhSEb8dARxCN3jIyLWST7aIyZ+1lGbLiDGmNCabOIT5gk3lGS2rSLv
uEbim3pS4c/ES74uQb07fcWe2AxigaeDy2Nil3+yq0OJo5wtqCXizc2+SSfi
UlsDuYZ4pGfBbOcN/A9bS98j
          "]]}, {}}, {{}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 2.},
      PlotRange->{{0, 2}, {2.0000001632653044`, 4.998724489795919}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f1", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f2", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFy39M1HUcx/EPBwcHyH04iBgQGr8qhQZzBmHqm9RFImQIOWwEpgNFk4xu
U2wmOMn4uf5gygIKlGbGr4wfNcF4J5ctI34kaSU/6iIijuFH5ZADjuvb3uvD
e3vtsecf74C9b+7MUDHGXlf2n3EZEwP4T8YmRhdT47XjvSKfcvi/8zUtTxb6
1MlO2V3bLO61yna15afGruySHZI4PdFdbJB9tDcaKma+l+3dqhuxs+uT3W7c
0tO34SfZ1w5W++2eGpRtfmIjbzx8W7bKUu/uF/Kb7EjbnvakpiHZPafX9V5f
Myp71Qcmy6Xp32WbHo6O/BxhlF032XFDW/anbK3/xbtjY2OyS7LaMmuCx2XP
xtSPHTj5t2z9WkPro90TskebDMUDAZOyFw4OVq4+bpId+rzTUmbHlOzY8wH7
L3tPL/+n49ZtV5b7qH964B+pd2VHxOeklzcs98TxgqrYxeWe3BV6oJYJIBnu
EZ6qVfYCSIa3Chcrq9QCSIbbg/56xlcjgGSInT/2nXMRQDKM3NWe5eUmgGQY
WHim2t1DAMmwIvBIVNkjAkiG2s6UAVdvASRDy/RqtdNjAkiG/ck9b1hDBJAM
X5hudXznKQEkw84z1TVzawSQDC9eyR58EC6AZPju47oNk9ECSIZhU6+43k4Q
QDL8Kjm+q+hlASTDLVc3v70pSQDJ8NWy8DufpAggGRZGONfr9wkgGY7rO+M8
cgWQDGusgUUJdQJIhp5caAzzAkiGDl2VzUFV94C0w0PrOn513n4fSBXWb9tb
8/XsfSBVaDb5uo+ffQCkPbYlxdqXb50B0gFPvljwcev4DJAOGDAc98uFAjOQ
alwfdbrcZ+0skI6YurLPYndzFkhHNN8oNR7JfwikE1Y4pOl3Bs8BqUHPkbbz
KsMckBpUn8hPjn7LAqQzsktpzUaPeSBdMOfD5lKPa/NAuuDV0Pc1uuwFIF1R
F5cTdkq7COQKHHq6/2Zu5yKQK/DzjyB4LM0KpBu+1hyp81+yAumGeQW1+UOf
LQGpxcYJ/0ptvA1Ijok67bPfzduA5FikVvkNKU1yNFjMVqE0yTHSONztu2AD
kqNvS+OObKVJjsbkhP1eizYgOeorSs7us9qA5NhYkpd7TGmS43iePrVUaZJj
SlZq4JdKkxw3rg9rclmyAcnRceiHby8rTXKE/q5PrytNcjxmaCm+ozTJcbKh
MlFtswHJsffEoeEUpUmOTjnpeFhpkmNMZtKFU0qTHL946bmsBqVJjqbN4fHf
KE1yDI4KCr+lNMkxLdTbw6Q0yfHcKlezTWmS47+DSZ1u
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 2}, {-3.999999918367347, 2.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{4.081632653061224*^-8, 2.}, {0.019628681609693666`, 2.}, {
          0.0392573224030608, 2.}, {0.08181671417091729, 2.}, {
          0.12155576714030418`, 2.}, {0.1605152976377521, 2.}, {
          0.20277693831632224`, 2.}, {0.24221824019642277`, 2.}, {
          0.2849616522576456, 2.}, {0.32692554184692935`, 2.}, {
          0.3660690926377435, 2.}, {0.4085147536096799, 2.}, {
          0.44814007578314674`, 2.}, {0.48698587548467454`, 2.}, {
          0.5291337853673247, 2.}, {0.5684613564515052, 2.}, {
          0.611091037716808, 2.}, {0.6529411965101717, 2.}, {
          0.6919710165050659, 2.}, {0.7343029466810822, 2.}, {
          0.773814538058629, 2.}, {0.816628239617298, 2.}, {0.858662418704028,
           2.}, {0.8978762589922885, 2.}, {0.9403922094616711, 2.}, {
          0.9602400152971277, 2.}, {0.9800878211325842, 2.}, {
          0.9898168434323278, 2.}, {0.9993622448979592, 2.}}], 
         LineBox[CompressedData["
1:eJwlx39M1HUcx/GPBwfHr/t4h851ZSjQloqjuYI0692IZSFoCjbmEJuuGrPI
6P6QNRWYzCDgLwYssCh1WkpoajU946WibpqKs1lNcIsFa9DcJ/AIkOPbp73+
eO6x5+JtH2x826WUyrX97x9D80IdLiNU4S2T7EqJMkIV7tbNtHe4jVCFtWlD
zwU8RqgCQjdutcYboQpZb35fNj/JCFVIrdt/YK7fCFVoS92Z3TTPCFXwhopv
JywwQhWmHixxxz5hhCr0Ff38XuQpI1Th1QenYz5+2ghVCO0/0Dm51AhVOHK2
/JfxTCNUYc8i3+qRlUaoQsbfmxJ+LTBCFX4syu+pf8MIVXjlfM5HLxUaoQqb
mzLvHS42QhXqnok7FtxuhCoMB0N5/kojVKEzklpfcMgIVUjWxtM7bYQqRPe0
d6d1/CN0DnY8e+73uLVjQl049vq2zp8mxoS6EB4NzB1uGRcahTOFa6Kacx8K
jcbe12q/OD38UGg0Fg/k/XawNizUjVXZ+5ofWzEhNAYlT96amnNnQmgMwtca
B3dW/ys0Fm3RpcGN6ZNCPUi+f+YrV++kUA/cu6uLVn44JTQO6uvS7kH/tNB4
VHzW3ei/OC00HueXfeLxlT8SmgBfXkVGjXdGaCL6l/fdqQzNCE3Eic8l/c/S
iNAkbOnO8i2cjQhNQlXtl9X938wK9aLrr4Xt3nxHqMYGn/f5q9OOUI16t+vx
fvtUo3cqHDH2qUbW4MClwCNHqEbgVNf6cvtUY7Co4N35M45QjWBbQ8v2iCNU
o6uhqnKXfaoxXBUsabRPNYrLSlJ/sE81XlyV8W38rCNUI6b/+uWT9qmG9PUc
vWKfauzqPfXpPftUY+R4+wa34wjVuLl7x0CxfaoRW7EV79unGi+/U3iwxj7V
+G7dC2XH7VON0ZzM/Av2qUZ6dlrmXftUo3TZAv+ofarRmpIQduxTjf8A32Qd
4g==
          "]]}, {}}, {{}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 2}, {-3.999999918367347, 2.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output"]
}, Open  ]],

Cell["\<\
Allerdings hilft das nicht immer. Hier wird beim Bestimmen der Ableitung in \
beiden F\[ADoubleDot]llen offensichtlich das boolesche Pr\[ADoubleDot]dikat \
zu fr\[UDoubleDot]h ausgewertet.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"OddQ", "[", 
     RowBox[{"Floor", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"x", "+", "1"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"g2", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", "1"}], ",", 
       RowBox[{"OddQ", "[", 
        RowBox[{"Floor", "[", "x", "]"}], "]"}]}], "}"}], "}"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"g2", "'"}], "[", "x", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Auch der Graph ist in beiden Varianten eine durchgezogene Linie.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g1", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g2", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Xk0lF/8B/BnJsyMbZ4xCH2VEKmkhAq5VyFKm0JpUUibJLIVKiIJZcme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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-5, 5}, {-3.9999997959183675`, 4.999322071130442}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Xk0lF/8B/BnJsyMbZ4xCH2VEKmkhAq5VyFKm0JpUUibJLIVKiIJZcme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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-5, 5}, {-3.9999997959183675`, 4.999322071130442}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Und selbst die numerische Auswertung ergibt f\[UDoubleDot]r die Ableitung ein \
falsches Bild.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g2", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{-4.9999997959183675`, -1.}, {-4.901856591951532, -1.}, \
{-4.803713387984696, -1.}, {-4.590916429145413, -1.}, {-4.392221164298479, \
-1.}, {-4.197423511811239, -1.}, {-3.986115308418389, -1.}, \
{-3.788908799017886, -1.}, {-3.575191738711772, -1.}, {-3.3653722907653534`, \
-1.}, {-3.169654536811282, -1.}, {-2.9574262319516, -1.}, \
{-2.759299621084266, -1.}, {-2.565070622576627, -1.}, {-2.354331073163377, \
-1.}, {-2.157693217742475, -1.}, {-1.9445448114159614`, -1.}, \
{-1.735294017449143, -1.}, {-1.5401449174746724`, -1.}, \
{-1.3284852665945908`, -1.}, {-1.130927309706857, -1.}, {-0.9168588019135122, \
-1.}, {-0.7066879064798623, -1.}, {-0.5106187050385604, -1.}, \
{-0.2980389526916474, -1.}, {-0.09956089433708235, -1.}, {
         0.09501955165778773, -1.}, {0.306110548558269, -1.}, {
         0.5030998514664022, -1.}, {0.7165997052801466, -1.}, {
         0.9262019467341961, -1.}, {1.1217024941958975`, -1.}, {
         1.3337135925632102`, -1.}, {1.5316229969381747`, -1.}, {
         1.7256347889534445`, -1.}, {1.9361571318743254`, -1.}, {
         2.132577780802858, -1.}, {2.345508980637002, -1.}, {
         2.5443384864787983`, -1.}, {2.739270379960899, -1.}, {
         2.9507128243486114`, -1.}, {3.148053574743976, -1.}, {
         3.3619048760449513`, -1.}, {3.5718585649862313`, -1.}, {
         3.767710559935164, -1.}, {3.9800731057897076`, -1.}, {
         4.178333957651903, -1.}, {4.3726971971544035`, -1.}, {
         4.583570987562515, -1.}, {4.780343083978279, -1.}, {
         4.9936257312996535`, -1.}, {4.996812763609011, -1.}, {
         4.9999997959183675`, -1.}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-5, 5}, {-1., -1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{-4.9999997959183675`, -1.}, {-4.901856591951532, -1.}, \
{-4.803713387984696, -1.}, {-4.590916429145413, -1.}, {-4.392221164298479, \
-1.}, {-4.197423511811239, -1.}, {-3.986115308418389, -1.}, \
{-3.788908799017886, -1.}, {-3.575191738711772, -1.}, {-3.3653722907653534`, \
-1.}, {-3.169654536811282, -1.}, {-2.9574262319516, -1.}, \
{-2.759299621084266, -1.}, {-2.565070622576627, -1.}, {-2.354331073163377, \
-1.}, {-2.157693217742475, -1.}, {-1.9445448114159614`, -1.}, \
{-1.735294017449143, -1.}, {-1.5401449174746724`, -1.}, \
{-1.3284852665945908`, -1.}, {-1.130927309706857, -1.}, {-0.9168588019135122, \
-1.}, {-0.7066879064798623, -1.}, {-0.5106187050385604, -1.}, \
{-0.2980389526916474, -1.}, {-0.09956089433708235, -1.}, {
         0.09501955165778773, -1.}, {0.306110548558269, -1.}, {
         0.5030998514664022, -1.}, {0.7165997052801466, -1.}, {
         0.9262019467341961, -1.}, {1.1217024941958975`, -1.}, {
         1.3337135925632102`, -1.}, {1.5316229969381747`, -1.}, {
         1.7256347889534445`, -1.}, {1.9361571318743254`, -1.}, {
         2.132577780802858, -1.}, {2.345508980637002, -1.}, {
         2.5443384864787983`, -1.}, {2.739270379960899, -1.}, {
         2.9507128243486114`, -1.}, {3.148053574743976, -1.}, {
         3.3619048760449513`, -1.}, {3.5718585649862313`, -1.}, {
         3.767710559935164, -1.}, {3.9800731057897076`, -1.}, {
         4.178333957651903, -1.}, {4.3726971971544035`, -1.}, {
         4.583570987562515, -1.}, {4.780343083978279, -1.}, {
         4.9936257312996535`, -1.}, {4.996812763609011, -1.}, {
         4.9999997959183675`, -1.}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-5, 5}, {-1., -1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, ImageScaled[{0.5, 0.5}],
      {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Damit es funktioniert muss ",
 StyleBox["OddQ",
  FontWeight->"Bold"],
 " durch ein \"weicheres\" boolesches Pr\[ADoubleDot]dikat ersetzt werden. \
Wir verwenden hier eine Version mit Equal (==)."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Floor", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]", "1"}],
     ",", 
    RowBox[{"x", "+", "1"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"g2", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", "1"}], ",", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"Floor", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]", 
        "1"}]}], "}"}], "}"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"g2", "'"}], "[", "x", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"Floor", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]", 
      "1"}], ",", "1", ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", 
   RowBox[{"\[Piecewise]", GridBox[{
      {"1", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"Floor", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]", 
        "1"}]},
      {
       RowBox[{"-", "1"}], 
       TagBox["True",
        "PiecewiseDefault",
        AutoDelete->False,
        DeletionWarning->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.84]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g2", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1nk4FHgYB/CZ2TEaRgxm1lSDYjusyTGOsuUq1GPlijY92QxalShlJBQl
qfVsYcjZMTxytZZSVEs1IkKSK/ezMrkbV5Frj2e97+953uf3fP55n/f9/vWu
5fk7eZMIBELuP/XvH/bRbmJpSekZ4b8nMROcPmQbnorOI57KJBijpbxt9FkH
FcFKbS99hbF0cJGd7kA/B+0kSvHcVKMAPt7wgwpdgI7u6qydOYhmenHujlii
M4bCIno3oIc4WX5uq9C6J+sPNNHQpAsqrQFUdFMcz4lOQWdl5NcVkNBjPqOx
aYvyyy43yGecZ46jQz5t973eh07h+g7fYqFLglKOFtivBO+Jc1FfTKaBbdL/
3LNrRAbML0pV7NZAZ1UFt5w6QAU38c2zasZWgEnrpflrL6CTw4a6am3Rus11
VmcYaA3zmqJ7K9HMvEq1Pmk0lSmKUSGi58PLZ+2+SkMef7mWvCsZQVdpF97T
6EHHtQk9ZkVo90gB40022m/itcdoFwV87tA3v8sqoQkctfIdl8jg9l+TL+c1
k8BzNeEqDjT0GhmfnClLIthyz/2exmYC+EjcIqPQBx3gGZvhY4cONdDUU9dH
E9NHv4RooqOkHpW1MtGvSlcLpRTQMn7hl7hU9I/r+n08SGjVe/FJql+Wypfz
3DneXT9/BX3MUEuqYw36FyPyPvsTC2BP4+5skWgOrHXGZMkvcwZ8p8u5Ithi
GlxRYBDemz8J/hjB2GajMgHWNCgOVNw+DuaJ9xZ0eUjAuZ3RzCBr9ETj0zCF
79HMele9g2y0SbXkQ4482r3iatJnIpp0fndS1MCnZZup/8QyHDmLNtMbfOso
hw7ti5Zl64+BHydstBpwHQUHmhHZtK+DYN3B91M66WLwzscd1AXXXvCJnIIZ
utI7MOXizG3rgGqw62GNO42hpWBV7i5tIT0XLElK9hpP5uF8JMFL6y27zZb3
25ziWaVs5A/uZhWOycqHgp25bU+jLCLBcs+GNSrcroNPHj42WCFIBKftNzTx
jLwDJhCKlzzL7oK91ru91GcVgatq31/lOpeAfW8HJbDzq8EmnOdFDjfegUl8
RqcXqxcsTXOI4I2JwVb8eN7QriHwxd6WHQEZo2D3vLBrGcfGsD9fs6OJ+wmc
3fElfPQGmmnxej1lHr1FTn1jlIxk2Wbi4PZt1G/RArHAMUYDbelsf1heF31T
u+IaYzd6Vmpr6Woeuqmhh2ynNQ7+IzXK4dwEWuFWoG5h5iTYX+il8MF1Gux+
NIV9OWIGfMWRv5WbNgeuLJK6vt92AUxWThCf/7oIDv7Q9x395yXw2AN9b6EI
TTtCKa7sRG9it5OHp9Fpcx6JpkSC+XJeGQOuuZel0bnNtmUNcuiiF+aNLGX0
G77yOlMOekRr4CTPGs2bMyqczEW3vr4kiZQnghM1TsdfG0S7hPCMUkQksK/s
8Lp6NzJYLa8ykTIkBa7Tk5q++oICDinZ4SyfKg12s+FXOz5Am7Rkmwnq0Lns
F2cN29Es747iFjG6YYWP84ZRdHT+lCRoEm3uEPHbq1n0zKScNouwYtlmj+in
VG7qo/k6bWQNb/TkUWGXdg36RJbvQyMdKti0yTFGX0YGTCMZ8zb3o62O703Q
iqeBVUrZ/laaK8HNDGfCkwV0XEB0rG6rPJi34W1Pbx+a28naHCtBpxmZugx+
RpNjeaEWC+iHgaK3tUQF2H9I6NI/Q0Y/2XeTm0NHx9A+RuxXRXP4Z1QfG6Pr
e6hPVjmiFe5rT3VcRDtF2XPSH6LLJEeeq6+ig7UORLpkhqFbxFRhvIsi9uf1
WyiqKYFTEuiU4Fl0TJlO6NN59P/3KPhvyu5yew==
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-5, 5}, {-1., 1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1nk4FHgYB/CZ2TEaRgxm1lSDYjusyTGOsuUq1GPlijY92QxalShlJBQl
qfVsYcjZMTxytZZSVEs1IkKSK/ezMrkbV5Frj2e97+953uf3fP55n/f9/vWu
5fk7eZMIBELuP/XvH/bRbmJpSekZ4b8nMROcPmQbnorOI57KJBijpbxt9FkH
FcFKbS99hbF0cJGd7kA/B+0kSvHcVKMAPt7wgwpdgI7u6qydOYhmenHujlii
M4bCIno3oIc4WX5uq9C6J+sPNNHQpAsqrQFUdFMcz4lOQWdl5NcVkNBjPqOx
aYvyyy43yGecZ46jQz5t973eh07h+g7fYqFLglKOFtivBO+Jc1FfTKaBbdL/
3LNrRAbML0pV7NZAZ1UFt5w6QAU38c2zasZWgEnrpflrL6CTw4a6am3Rus11
VmcYaA3zmqJ7K9HMvEq1Pmk0lSmKUSGi58PLZ+2+SkMef7mWvCsZQVdpF97T
6EHHtQk9ZkVo90gB40022m/itcdoFwV87tA3v8sqoQkctfIdl8jg9l+TL+c1
k8BzNeEqDjT0GhmfnClLIthyz/2exmYC+EjcIqPQBx3gGZvhY4cONdDUU9dH
E9NHv4RooqOkHpW1MtGvSlcLpRTQMn7hl7hU9I/r+n08SGjVe/FJql+Wypfz
3DneXT9/BX3MUEuqYw36FyPyPvsTC2BP4+5skWgOrHXGZMkvcwZ8p8u5Ithi
GlxRYBDemz8J/hjB2GajMgHWNCgOVNw+DuaJ9xZ0eUjAuZ3RzCBr9ETj0zCF
79HMele9g2y0SbXkQ4482r3iatJnIpp0fndS1MCnZZup/8QyHDmLNtMbfOso
hw7ti5Zl64+BHydstBpwHQUHmhHZtK+DYN3B91M66WLwzscd1AXXXvCJnIIZ
utI7MOXizG3rgGqw62GNO42hpWBV7i5tIT0XLElK9hpP5uF8JMFL6y27zZb3
25ziWaVs5A/uZhWOycqHgp25bU+jLCLBcs+GNSrcroNPHj42WCFIBKftNzTx
jLwDJhCKlzzL7oK91ru91GcVgatq31/lOpeAfW8HJbDzq8EmnOdFDjfegUl8
RqcXqxcsTXOI4I2JwVb8eN7QriHwxd6WHQEZo2D3vLBrGcfGsD9fs6OJ+wmc
3fElfPQGmmnxej1lHr1FTn1jlIxk2Wbi4PZt1G/RArHAMUYDbelsf1heF31T
u+IaYzd6Vmpr6Woeuqmhh2ynNQ7+IzXK4dwEWuFWoG5h5iTYX+il8MF1Gux+
NIV9OWIGfMWRv5WbNgeuLJK6vt92AUxWThCf/7oIDv7Q9x395yXw2AN9b6EI
TTtCKa7sRG9it5OHp9Fpcx6JpkSC+XJeGQOuuZel0bnNtmUNcuiiF+aNLGX0
G77yOlMOekRr4CTPGs2bMyqczEW3vr4kiZQnghM1TsdfG0S7hPCMUkQksK/s
8Lp6NzJYLa8ykTIkBa7Tk5q++oICDinZ4SyfKg12s+FXOz5Am7Rkmwnq0Lns
F2cN29Es747iFjG6YYWP84ZRdHT+lCRoEm3uEPHbq1n0zKScNouwYtlmj+in
VG7qo/k6bWQNb/TkUWGXdg36RJbvQyMdKti0yTFGX0YGTCMZ8zb3o62O703Q
iqeBVUrZ/laaK8HNDGfCkwV0XEB0rG6rPJi34W1Pbx+a28naHCtBpxmZugx+
RpNjeaEWC+iHgaK3tUQF2H9I6NI/Q0Y/2XeTm0NHx9A+RuxXRXP4Z1QfG6Pr
e6hPVjmiFe5rT3VcRDtF2XPSH6LLJEeeq6+ig7UORLpkhqFbxFRhvIsi9uf1
WyiqKYFTEuiU4Fl0TJlO6NN59P/3KPhvyu5yew==
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-5, 5}, {-1., 1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Funktionsdefinitionen und Bl\[ODoubleDot]cke\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"3", "x"}], "+", "5"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4VdsbB/CD7DOQKUSJTpEodAkZz0IZIhFRooFGydB1G/0ilDJEooQm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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 4.},
  PlotRange->{{-4, 2}, {2.750000733553761, 14.999999142857158`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mySqrt", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "x"}], " ", ",", 
      RowBox[{"z", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"y", "-", "z"}], "]"}], ">", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], ",", 
       RowBox[{
        RowBox[{"y", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "+", "z"}], ")"}], "/", "2."}]}], ";", 
        RowBox[{"z", "=", 
         RowBox[{"x", "/", "y"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "y"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mySqrt", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "12", ",", "1221", ",", "21121121"}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.4142156862745097`", ",", "1.7320508100147274`", ",", 
   "3.4641016533502986`", ",", "34.9428104193253`", ",", 
   "4595.772078773568`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mySqrt", "[", "x", "]"}]], "Input"],

Cell[BoxData["x"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beispiele", "Section"],

Cell[CellGroupData[{

Cell["Symmetrische Polynome", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "[", 
   RowBox[{"d_Integer", ",", "x_List"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "x", "]"}], "<", "d"}], ",", "0", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"d", "\[Equal]", "1"}], ",", 
      RowBox[{"Apply", "[", 
       RowBox[{"Plus", ",", "x"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{"e", "[", 
         RowBox[{"d", ",", 
          RowBox[{"Rest", "[", "x", "]"}]}], "]"}], "+", 
        RowBox[{
         RowBox[{"e", "[", 
          RowBox[{
           RowBox[{"d", "-", "1"}], ",", 
           RowBox[{"Rest", "[", "x", "]"}]}], "]"}], "*", 
         RowBox[{"First", "[", "x", "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "[", 
  RowBox[{"5", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "6"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}], "+", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["x", "4"], " ", 
   SubscriptBox["x", "5"], " ", 
   SubscriptBox["x", "6"], " ", 
   SubscriptBox["x", "7"]}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"d_Integer", ",", "x_List"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"d", "\[Equal]", "0"}], ",", "1", ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "x", "]"}], "\[Equal]", "1"}], ",", 
      SuperscriptBox[
       RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
       "d"], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{"h", "[", 
         RowBox[{"d", ",", 
          RowBox[{"Rest", "[", "x", "]"}]}], "]"}], "+", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{
           RowBox[{"d", "-", "1"}], ",", "x"}], "]"}], "*", 
         RowBox[{"First", "[", "x", "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    RowBox[{"a", " ", "b"}], "+", 
    SuperscriptBox["b", "2"], "+", 
    RowBox[{"a", " ", "c"}], "+", 
    RowBox[{"b", " ", "c"}], "+", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{
    SuperscriptBox["a", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["b", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", 
    RowBox[{"a", " ", "b", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "3"]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Der Euklidsche Algorithmus", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Euklid", "[", 
   RowBox[{"a0_Integer", ",", "b0_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "a0"}], ",", 
      RowBox[{"b", "=", "b0"}], ",", "q", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"b", "!=", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"q", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "r"}], ")"}], "/", "b"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "a", ",", "\"\< = \>\"", " ", ",", "q", ",", "\"\<*\>\"", ",", "b", 
          ",", "\"\< + \>\"", " ", ",", "r"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"b", ",", "r"}], "}"}]}]}]}], "\[IndentingNewLine]", "]"}], 
     ";", "a"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Euklid", "[", 
  RowBox[{"12", ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" + \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm[12, " = ", 1, "*", 7, " + ", 5],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "7", "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" + \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm[7, " = ", 1, "*", 5, " + ", 2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" + \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[5, " = ", 2, "*", 2, " + ", 1],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" + \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[2, " = ", 2, "*", 1, " + ", 0],
  Editable->False]], "Print"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtendedEuklid", "[", 
   RowBox[{"a0_Integer", ",", "b0_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "a0"}], ",", 
      RowBox[{"b", "=", "b0"}], ",", "q", ",", "r", ",", 
      RowBox[{"ua", "=", "1"}], ",", 
      RowBox[{"ub", "=", "0"}], ",", 
      RowBox[{"va", "=", "0"}], ",", 
      RowBox[{"vb", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"b", "!=", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}], ";", 
        RowBox[{"q", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "r"}], ")"}], "/", "b"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"b", ",", "r"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ua", ",", "ub"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"ub", ",", 
           RowBox[{"ua", "-", 
            RowBox[{"q", "*", "ub"}]}]}], "}"}]}], ";", "\[IndentingNewLine]",
         
        RowBox[{
         RowBox[{"{", 
          RowBox[{"va", ",", "vb"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"vb", ",", 
           RowBox[{"va", "-", 
            RowBox[{"q", "*", "vb"}]}]}], "}"}]}], ";", "\[IndentingNewLine]",
         
        RowBox[{"Print", "[", 
         RowBox[{
         "r", ",", "\"\< = (\>\"", ",", "ub", ",", "\"\<)*\>\"", ",", "a0", 
          ",", "\"\<+(\>\"", ",", "vb", ",", "\"\<)*\>\"", ",", "b0", ",", 
          "\"\< = \>\"", ",", 
          RowBox[{
           RowBox[{"ub", "*", "a0"}], "+", 
           RowBox[{"vb", "*", "b0"}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
      "]"}], ";", 
     RowBox[{"{", 
      RowBox[{"a", ",", "ua", ",", "va"}], "}"}]}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExtendedEuklid", "[", 
  RowBox[{"12", ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\" = (\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"+(\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]",
    "7", "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm[5, " = (", 1, ")*", 12, "+(", -1, ")*", 7, " = ", 5],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" = (\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]",
    "12", "\[InvisibleSpace]", "\<\"+(\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm[2, " = (", -1, ")*", 12, "+(", 2, ")*", 7, " = ", 2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" = (\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"+(\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5"}], "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]",
    "7", "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[1, " = (", 3, ")*", 12, "+(", -5, ")*", 7, " = ", 1],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" = (\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "7"}], "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]",
    "12", "\[InvisibleSpace]", "\<\"+(\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\")*\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[0, " = (", -7, ")*", 12, "+(", 12, ")*", 7, " = ", 0],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ein Grafikbeispiel", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"kreisPunkt", "[", "t_", "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"180", " ", "\[Degree]"}], "-", "t"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"180", " ", "\[Degree]"}], "-", "t"}], "]"}]}], "}"}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"w", "=", 
    RowBox[{"230", "\[Degree]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"P2", "=", 
  RowBox[{"kreisPunkt", "[", "w", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"a", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"P2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
    ")"}], "/", 
   RowBox[{
   "P2", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "a"}], "}"}]}], ";", 
  RowBox[{"P4", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"90", "\[Degree]"}]}], ";", 
  RowBox[{"u", "=", 
   RowBox[{"90", "\[Degree]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6427876096865393`", ",", 
   RowBox[{"-", "0.766044443118978`"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"-", "2.1445069205095586`"}]], "Output"]
}, Open  ]],

Cell["\<\
Die Formel f\[UDoubleDot]r die st\[UDoubleDot]ckweise definierte Funktion, \
mit der das Grundger\[UDoubleDot]st der Zwei erzeugt wird.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "t_", "]"}], ":=", 
   RowBox[{"Which", "[", "\n", "       ", 
    RowBox[{
     RowBox[{"t", "\[LessEqual]", "w"}], ",", 
     RowBox[{"kreisPunkt", "[", "t", "]"}], ",", "\n", "       ", 
     RowBox[{"t", "\[LessEqual]", 
      RowBox[{"w", "+", "s"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t", "-", "w"}], ")"}], "/", "s"}]}], ")"}], "P2"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"t", "-", "w"}], ")"}], "/", "s"}], "*", "P3"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"t", "\[LessEqual]", 
      RowBox[{"w", "+", "s", "+", "u"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t", "-", "w", "-", "s"}], ")"}], "/", "u"}]}], ")"}], 
       "P3"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"t", "-", "w", "-", "s"}], ")"}], "/", "u"}], "*", 
       "P4"}]}]}], "]"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Hier noch die 5 fetten Punkte, die Ticks auf den Achsen sowie die \
Beschriftungen als Text-Konstrukte. Die verschiedenen Grafikteile werden mit \
",
 StyleBox["Show",
  FontWeight->"Bold"],
 " gemeinsam angezeigt."
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fatPoints", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"P", "[", "0", "]"}], ",", "P2", ",", "P3", ",", "P4"}], "}"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"pointLabels", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "0"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".2"}], ",", 
         RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", 
         RowBox[{"-", "0.2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "2"], ",", 
       RowBox[{"{", 
        RowBox[{"1.0", ",", 
         RowBox[{"-", "1.0"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "3"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.3"}], ",", 
         RowBox[{"-", "2.2"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "4"], ",", 
       RowBox[{"{", 
        RowBox[{"1.3", ",", 
         RowBox[{"-", "2.2"}]}], "}"}]}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"tx", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{".1", "i"}], ","}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "30"}], ",", "20"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{".5", "i"}], ",", ",", ".02"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "5"}], ",", "10"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"fatPoints", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", "0.03", "]"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"P", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"w", "+", "s", "+", "u"}]}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", "pointLabels", "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"tx", ",", "tx"}], "}"}]}], ",", 
   RowBox[{"TextStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "20"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
     PointBox[{{0., 0.}, {-1., 0.}, {
      0.6427876096865393, -0.766044443118978}, {-1., -2.1445069205095586`}, {
      1., -2.1445069205095586`}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF2nk8VG/4N3CUEkVpob1EKmUpZYkukiREKCpbJKVClmyRZC9r2SNKtuyU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      "]]}}, {InsetBox[
     SubscriptBox["P", "0"], {-0.2, -0.2}], InsetBox[
     SubscriptBox["P", "1"], {-1.2, -0.2}], InsetBox[
     SubscriptBox["P", "2"], {1., -1.}], InsetBox[
     SubscriptBox["P", "3"], {-1.3, -2.2}], InsetBox[
     SubscriptBox["P", "4"], {1.3, -2.2}]}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 20},
  PlotRange->{{-2, 2}, {-2.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{-3., ""}, {-2.9000000000000004`, ""}, {-2.8000000000000003`, 
      ""}, {-2.7, ""}, {-2.6, ""}, {-2.5, ""}, {-2.4000000000000004`, 
      ""}, {-2.3000000000000003`, ""}, {-2.2, ""}, {-2.1, ""}, {-2., 
      ""}, {-1.9000000000000001`, ""}, {-1.8, ""}, {-1.7000000000000002`, 
      ""}, {-1.6, ""}, {-1.5, ""}, {-1.4000000000000001`, ""}, {-1.3, 
      ""}, {-1.2000000000000002`, ""}, {-1.1, ""}, {-1., ""}, {-0.9, 
      ""}, {-0.8, ""}, {-0.7000000000000001, ""}, {-0.6000000000000001, 
      ""}, {-0.5, ""}, {-0.4, ""}, {-0.30000000000000004`, ""}, {-0.2, 
      ""}, {-0.1, ""}, {0, ""}, {0.1, ""}, {0.2, ""}, {
     0.30000000000000004`, ""}, {0.4, ""}, {0.5, ""}, {
     0.6000000000000001, ""}, {0.7000000000000001, ""}, {0.8, ""}, {
     0.9, ""}, {1., ""}, {1.1, ""}, {1.2000000000000002`, ""}, {1.3, ""}, {
     1.4000000000000001`, ""}, {1.5, ""}, {1.6, ""}, {
     1.7000000000000002`, ""}, {1.8, ""}, {1.9000000000000001`, ""}, {
     2., ""}, {-2.5, "", 0.02}, {-2., "", 0.02}, {-1.5, "", 0.02}, {-1., "", 
      0.02}, {-0.5, "", 0.02}, {0, "", 0.02}, {0.5, "", 0.02}, {
     1., "", 0.02}, {1.5, "", 0.02}, {2., "", 0.02}, {2.5, "", 0.02}, {
     3., "", 0.02}, {3.5, "", 0.02}, {4., "", 0.02}, {4.5, "", 0.02}, {
     5., "", 0.02}}, {{-3., ""}, {-2.9000000000000004`, 
      ""}, {-2.8000000000000003`, ""}, {-2.7, ""}, {-2.6, ""}, {-2.5, 
      ""}, {-2.4000000000000004`, ""}, {-2.3000000000000003`, ""}, {-2.2, 
      ""}, {-2.1, ""}, {-2., ""}, {-1.9000000000000001`, ""}, {-1.8, 
      ""}, {-1.7000000000000002`, ""}, {-1.6, ""}, {-1.5, 
      ""}, {-1.4000000000000001`, ""}, {-1.3, ""}, {-1.2000000000000002`, 
      ""}, {-1.1, ""}, {-1., ""}, {-0.9, ""}, {-0.8, 
      ""}, {-0.7000000000000001, ""}, {-0.6000000000000001, ""}, {-0.5, 
      ""}, {-0.4, ""}, {-0.30000000000000004`, ""}, {-0.2, ""}, {-0.1, ""}, {
     0, ""}, {0.1, ""}, {0.2, ""}, {0.30000000000000004`, ""}, {0.4, ""}, {
     0.5, ""}, {0.6000000000000001, ""}, {0.7000000000000001, ""}, {
     0.8, ""}, {0.9, ""}, {1., ""}, {1.1, ""}, {1.2000000000000002`, ""}, {
     1.3, ""}, {1.4000000000000001`, ""}, {1.5, ""}, {1.6, ""}, {
     1.7000000000000002`, ""}, {1.8, ""}, {1.9000000000000001`, ""}, {
     2., ""}, {-2.5, "", 0.02}, {-2., "", 0.02}, {-1.5, "", 0.02}, {-1., "", 
      0.02}, {-0.5, "", 0.02}, {0, "", 0.02}, {0.5, "", 0.02}, {
     1., "", 0.02}, {1.5, "", 0.02}, {2., "", 0.02}, {2.5, "", 0.02}, {
     3., "", 0.02}, {3.5, "", 0.02}, {4., "", 0.02}, {4.5, "", 0.02}, {
     5., "", 0.02}}}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"P", "[", "t", "]"}], ",", 
        RowBox[{"P", "[", 
         RowBox[{"t", "+", "s"}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"w", "+", "u"}], ",", " ", 
       RowBox[{"5", " ", "\[Degree]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics", "[", "data", "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{-1., 0.}, {0., 1.}}], 
   LineBox[{{-0.9961946980917455, 0.08715574274765817}, {0.08715574274765817, 
    0.9961946980917455}}], 
   LineBox[{{-0.984807753012208, 0.17364817766693033`}, {0.17364817766693033`,
     0.984807753012208}}], 
   LineBox[{{-0.9659258262890683, 0.25881904510252074`}, {
    0.25881904510252074`, 0.9659258262890683}}], 
   LineBox[{{-0.9396926207859084, 0.3420201433256687}, {0.3420201433256687, 
    0.9396926207859084}}], 
   LineBox[{{-0.9063077870366499, 0.42261826174069944`}, {
    0.42261826174069944`, 0.9063077870366499}}], 
   LineBox[{{-0.8660254037844386, 0.5}, {0.5, 0.8660254037844386}}], 
   LineBox[{{-0.8191520442889918, 0.573576436351046}, {0.573576436351046, 
    0.8191520442889918}}], 
   LineBox[{{-0.766044443118978, 0.6427876096865393}, {0.6427876096865393, 
    0.766044443118978}}], 
   LineBox[{{-0.7071067811865476, 0.7071067811865476}, {0.7071067811865476, 
    0.7071067811865476}}], 
   LineBox[{{-0.6427876096865393, 0.766044443118978}, {0.766044443118978, 
    0.6427876096865393}}], 
   LineBox[{{-0.573576436351046, 0.8191520442889918}, {0.8191520442889918, 
    0.573576436351046}}], 
   LineBox[{{-0.5, 0.8660254037844386}, {0.8660254037844386, 0.5}}], 
   LineBox[{{-0.42261826174069944`, 0.9063077870366499}, {0.9063077870366499, 
    0.42261826174069944`}}], 
   LineBox[{{-0.3420201433256687, 0.9396926207859084}, {0.9396926207859084, 
    0.3420201433256687}}], 
   LineBox[{{-0.25881904510252074`, 0.9659258262890683}, {0.9659258262890683, 
    0.25881904510252074`}}], 
   LineBox[{{-0.17364817766693033`, 0.984807753012208}, {0.984807753012208, 
    0.17364817766693033`}}], 
   LineBox[{{-0.08715574274765817, 0.9961946980917455}, {0.9961946980917455, 
    0.08715574274765817}}], LineBox[{{0., 1.}, {1., 0.}}], 
   LineBox[{{0.08715574274765817, 0.9961946980917455}, {
    0.9961946980917455, -0.08715574274765817}}], 
   LineBox[{{0.17364817766693033`, 0.984807753012208}, {
    0.984807753012208, -0.17364817766693033`}}], 
   LineBox[{{0.25881904510252074`, 0.9659258262890683}, {
    0.9659258262890683, -0.25881904510252074`}}], 
   LineBox[{{0.3420201433256687, 0.9396926207859084}, {
    0.9396926207859084, -0.3420201433256687}}], 
   LineBox[{{0.42261826174069944`, 0.9063077870366499}, {
    0.9063077870366499, -0.42261826174069944`}}], 
   LineBox[{{0.5, 0.8660254037844386}, {0.8660254037844386, -0.5}}], 
   LineBox[{{0.573576436351046, 0.8191520442889918}, {
    0.8191520442889918, -0.573576436351046}}], 
   LineBox[{{0.6427876096865393, 0.766044443118978}, {
    0.766044443118978, -0.6427876096865393}}], 
   LineBox[{{0.7071067811865476, 0.7071067811865476}, {
    0.7071067811865476, -0.7071067811865476}}], 
   LineBox[{{0.766044443118978, 0.6427876096865393}, {
    0.6427876096865393, -0.766044443118978}}], 
   LineBox[{{0.8191520442889918, 0.573576436351046}, {
    0.5515216313706204, -0.842625691862899}}], 
   LineBox[{{0.8660254037844386, 0.5}, {
    0.46025565305470156`, -0.9192069406068203}}], 
   LineBox[{{0.9063077870366499, 0.42261826174069944`}, {
    0.36898967473878275`, -0.9957881893507414}}], 
   LineBox[{{0.9396926207859084, 0.3420201433256687}, {
    0.2777236964228639, -1.0723694380946627`}}], 
   LineBox[{{0.9659258262890683, 0.25881904510252074`}, {
    0.186457718106945, -1.1489506868385837`}}], 
   LineBox[{{0.984807753012208, 0.17364817766693033`}, {
    0.09519173979102619, -1.2255319355825047`}}], 
   LineBox[{{0.9961946980917455, 0.08715574274765817}, {
    0.00392576147510737, -1.302113184326426}}], 
   LineBox[{{1., 0.}, {-0.0873402168408115, -1.378694433070347}}], 
   LineBox[{{
    0.9961946980917455, -0.08715574274765817}, {-0.17860619515673037`, \
-1.4552756818142683`}}], 
   LineBox[{{
    0.984807753012208, -0.17364817766693033`}, {-0.26987217347264925`, \
-1.5318569305581895`}}], 
   LineBox[{{
    0.9659258262890683, -0.25881904510252074`}, {-0.3611381517885681, \
-1.6084381793021107`}}], 
   LineBox[{{
    0.9396926207859084, -0.3420201433256687}, {-0.4524041301044869, \
-1.6850194280460316`}}], 
   LineBox[{{
    0.9063077870366499, -0.42261826174069944`}, {-0.5436701084204058, \
-1.761600676789953}}], 
   LineBox[{{
    0.8660254037844386, -0.5}, {-0.6349360867363246, -1.838181925533874}}], 
   LineBox[{{
    0.8191520442889918, -0.573576436351046}, {-0.7262020650522435, \
-1.9147631742777953`}}], 
   LineBox[{{
    0.766044443118978, -0.6427876096865393}, {-0.8174680433681623, \
-1.991344423021716}}], 
   LineBox[{{
    0.7071067811865476, -0.7071067811865476}, {-0.9087340216840811, \
-2.067925671765637}}], 
   LineBox[{{
     0.6427876096865393, -0.766044443118978}, {-1, -2.1445069205095586`}}], 
   LineBox[NCache[{{0.5515216313706204, -0.842625691862899}, {
      Rational[-8, 9], -2.1445069205095586`}}, {{
     0.5515216313706204, -0.842625691862899}, {-0.8888888888888888, \
-2.1445069205095586`}}]], 
   LineBox[NCache[{{0.46025565305470156`, -0.9192069406068203}, {
      Rational[-7, 9], -2.1445069205095586`}}, {{
     0.46025565305470156`, -0.9192069406068203}, {-0.7777777777777778, \
-2.1445069205095586`}}]], 
   LineBox[NCache[{{0.36898967473878275`, -0.9957881893507414}, {
      Rational[-2, 3], -2.1445069205095586`}}, {{
     0.36898967473878275`, -0.9957881893507414}, {-0.6666666666666666, \
-2.1445069205095586`}}]], 
   LineBox[NCache[{{0.2777236964228639, -1.0723694380946627`}, {
      Rational[-5, 9], -2.1445069205095586`}}, {{
     0.2777236964228639, -1.0723694380946627`}, {-0.5555555555555556, \
-2.1445069205095586`}}]], 
   LineBox[NCache[{{0.186457718106945, -1.1489506868385837`}, {
      Rational[-4, 9], -2.1445069205095586`}}, {{
     0.186457718106945, -1.1489506868385837`}, {-0.4444444444444444, \
-2.1445069205095586`}}]], 
   LineBox[NCache[{{0.09519173979102619, -1.2255319355825047`}, {
      Rational[-1, 3], -2.144506920509558}}, {{
     0.09519173979102619, -1.2255319355825047`}, {-0.3333333333333333, \
-2.144506920509558}}]], 
   LineBox[NCache[{{0.00392576147510737, -1.302113184326426}, {
      Rational[-2, 9], -2.1445069205095586`}}, {{
     0.00392576147510737, -1.302113184326426}, {-0.2222222222222222, \
-2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.0873402168408115, -1.378694433070347}, {
      Rational[-1, 
        9], -2.1445069205095586`}}, {{-0.0873402168408115, \
-1.378694433070347}, {-0.1111111111111111, -2.1445069205095586`}}]], 
   LineBox[{{-0.17860619515673037`, -1.4552756818142683`}, {
     0, -2.1445069205095586`}}], 
   LineBox[NCache[{{-0.26987217347264925`, -1.5318569305581895`}, {
      Rational[1, 
        9], -2.1445069205095586`}}, {{-0.26987217347264925`, \
-1.5318569305581895`}, {0.1111111111111111, -2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.3611381517885681, -1.6084381793021107`}, {
      Rational[2, 
        9], -2.1445069205095586`}}, {{-0.3611381517885681, \
-1.6084381793021107`}, {0.2222222222222222, -2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.4524041301044869, -1.6850194280460316`}, {
      Rational[1, 
        3], -2.144506920509558}}, {{-0.4524041301044869, \
-1.6850194280460316`}, {0.3333333333333333, -2.144506920509558}}]], 
   LineBox[NCache[{{-0.5436701084204058, -1.761600676789953}, {
      Rational[4, 
        9], -2.1445069205095586`}}, {{-0.5436701084204058, \
-1.761600676789953}, {0.4444444444444444, -2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.6349360867363246, -1.838181925533874}, {
      Rational[5, 
        9], -2.1445069205095586`}}, {{-0.6349360867363246, \
-1.838181925533874}, {0.5555555555555556, -2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.7262020650522435, -1.9147631742777953`}, {
      Rational[2, 
        3], -2.1445069205095586`}}, {{-0.7262020650522435, \
-1.9147631742777953`}, {0.6666666666666666, -2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.8174680433681623, -1.991344423021716}, {
      Rational[7, 
        9], -2.1445069205095586`}}, {{-0.8174680433681623, \
-1.991344423021716}, {0.7777777777777778, -2.1445069205095586`}}]], 
   LineBox[NCache[{{-0.9087340216840811, -2.067925671765637}, {
      Rational[8, 
        9], -2.1445069205095586`}}, {{-0.9087340216840811, \
-2.067925671765637}, {0.8888888888888888, -2.1445069205095586`}}]], 
   LineBox[{{-1, -2.1445069205095586`}, {
     1, -2.1445069205095586`}}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Berechnung der Kettenbruchentwicklung rationaler Zahlen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearA", 
  RowBox[{"ll", "[", "\"\<Global`*\>\"", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ClearA", " ", 
  RowBox[{"ll", "[", "\<\"Global`*\"\>", "]"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Kettenbruch", "[", "r0_Rational", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "=", "r0"}], ",", 
      RowBox[{"l", "=", 
       RowBox[{"{", "}"}]}], ",", "v"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"r", ",", "_Integer"}], "]"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{
        RowBox[{"v", "=", 
         RowBox[{"Floor", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"r", "-", "v"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"l", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"l", ",", "v"}], "]"}]}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Append", "[", 
      RowBox[{"l", ",", "r"}], "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Probe", "[", "l_List", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "l", "]"}], "==", "1"}], ",", 
    RowBox[{"First", "[", "l", "]"}], ",", 
    RowBox[{
     RowBox[{"First", "[", "l", "]"}], "+", 
     RowBox[{"1", "/", 
      RowBox[{"Probe", "[", 
       RowBox[{"Rest", "[", "l", "]"}], "]"}]}]}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kettenbruch", "[", 
  RowBox[{"31", "/", "245"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "7", ",", "1", ",", "9", ",", "3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Probe"}]], "Input"],

Cell[BoxData[
 FractionBox["31", "245"]], "Output"]
}, Open  ]],

Cell["\<\
Und hier eine rekursive Version, die aber auch nicht um einen Block \
herumkommt.  

Die erste Variante liefert mysteri\[ODoubleDot]se Ergebnisse:\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "KRec", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KRec", "[", "r_Rational", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"r", ",", "_Integer"}], "]"}], ",", 
      RowBox[{"{", "r", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"u", "=", 
        RowBox[{"Floor", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"KRec", "[", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", "u"}], ")"}]}], "]"}], ",", "u"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"KRec", "[", 
   RowBox[{"31", "/", "245"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"KRec", "[", 
  RowBox[{"0", ",", "7", ",", "1", ",", "9", ",", "3"}], "]"}]], "Output"]
}, Open  ]],

Cell["\<\
Der Grund ist, dass ganze Zahlen _Rational nicht passieren, so dass KRec[3] \
symbolisch bleibt. 
Zu allem \[CapitalUDoubleDot]berfluss funktioniert auch Prepend nicht nur f\
\[UDoubleDot]r Listen, sondern ebenso f\[UDoubleDot]r allgemeinere Ausdr\
\[UDoubleDot]cke. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{"u", ",", "a"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"KRec", "[", 
  RowBox[{
   RowBox[{"-", "2.1445069205095586`"}], ",", "0", ",", "7", ",", "1", ",", 
   "9", ",", "3"}], "]"}]], "Output"]
}, Open  ]],

Cell["So ist's korrekt:", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "KRec", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"KRec", "[", "r_Integer", "]"}], ":=", 
   RowBox[{"{", "r", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KRec", "[", "r_Rational", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", "=", 
      RowBox[{"Floor", "[", "r", "]"}]}], "}"}], ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"KRec", "[", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"r", "-", "u"}], ")"}]}], "]"}], ",", "u"}], "]"}]}], 
   "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KRec", "[", 
  RowBox[{"31", "/", "245"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "7", ",", "1", ",", "9", ",", "3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Probe"}]], "Input"],

Cell[BoxData[
 FractionBox["31", "245"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"31", "/", "245"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "7", ",", "1", ",", "9", ",", "3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  SqrtBox["31"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "3", ",", "5", ",", "3", ",", "1", ",", "1", ",", 
     "10"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Schnelles modulares Potenzieren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"modPower", "[", 
   RowBox[{"a0_Integer", ",", "n0_Integer", ",", "m_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "a0"}], ",", 
      RowBox[{"n", "=", "n0"}], ",", 
      RowBox[{"p", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"n", ">", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "p", ",", "\"\<*\>\"", ",", "a", ",", "\"\<^\>\"", ",", "n", ",", 
          "\"\< = \>\""}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OddQ", "[", "n", "]"}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{"a", "*", "p"}], ",", "m"}], "]"}]}], ";", 
           RowBox[{"n", "-=", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"a", "*", "a"}], ",", "m"}], "]"}]}], ";", 
        RowBox[{"n", "/=", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "p"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"modPower", "[", 
  RowBox[{"2", ",", "107", ",", "163"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "107", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[1, "*", 2, "^", 107, " = "],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[2, "*", 4, "^", 53, " = "],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[8, "*", 16, "^", 26, " = "],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "93", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[8, "*", 93, "^", 13, " = "],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "92", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[92, "*", 10, "^", 6, " = "],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "92", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "100", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[92, "*", 100, "^", 3, " = "],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "72", "\[InvisibleSpace]", "\<\"*\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\"^\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \"\>"}],
  SequenceForm[72, "*", 57, "^", 1, " = "],
  Editable->False]], "Print"],

Cell[BoxData["29"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", "107", ",", "163"}], "]"}]], "Input"],

Cell[BoxData["29"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fibonaccizahlen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{"n", ",", "0", ",", "0", ",", "1", ",", "1", ",", "_", ",", 
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392917824-7018970"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
         RowBox[{"Switch", "[", 
          RowBox[{
          "n", ",", "\[IndentingNewLine]", "0", ",", "0", ",", 
           "\[IndentingNewLine]", "1", ",", "1", ",", "\[IndentingNewLine]", 
           "_", ",", 
           RowBox[{
            RowBox[{"fib", "[", 
             RowBox[{"n", "-", "1"}], "]"}], "+", 
            RowBox[{"fib", "[", 
             RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392917824-7018970"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"fib", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"fib", "[", "25", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.45`", ",", "75025"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Timing", "[", 
       RowBox[{"fib", "[", "i", "]"}], "]"}], "\[LeftDoubleBracket]", "1", 
      "\[RightDoubleBracket]"}], "//", "Chop"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "25"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0.010000000000000215`", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0.009999999999999985`", ",", "0", ",", "0.010000000000000198`", ",", 
   "0.019999999999999966`", ",", "0.03999999999999995`", ",", 
   "0.08999999999999991`", ",", "0.09000000000000005`", ",", 
   "0.1400000000000002`", ",", "0.20000000000000007`", ",", 
   "0.3299999999999999`", ",", "0.5299999999999998`", ",", 
   "0.8499999999999995`", ",", "1.4`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"l", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}], ",", " ", 
   RowBox[{"PlotRange", "->", "All"}], " ", ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
    PointBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {5., 0.}, {6., 0.}, {7.,
      0.}, {8., 0.010000000000000215`}, {9., 0.}, {10., 0.}, {11., 0.}, {12., 
     0.}, {13., 0.009999999999999985}, {14., 0.}, {15., 
     0.010000000000000198`}, {16., 0.019999999999999966`}, {17., 
     0.03999999999999995}, {18., 0.08999999999999991}, {19., 
     0.09000000000000005}, {20., 0.1400000000000002}, {21., 
     0.20000000000000007`}, {22., 0.3299999999999999}, {23., 
     0.5299999999999998}, {24., 0.8499999999999995}, {25., 1.4}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"l", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",",
      
     RowBox[{"{", 
      RowBox[{"i", ",", "10", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"l1", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
    PointBox[{{4., -4.605170185988093}, {6., -4.605170185988071}, {
     7., -3.9120230054281477`}, {8., -3.218875824868202}, {
     9., -2.407945608651873}, {10., -2.4079456086518713`}, {
     11., -1.9661128563728312`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{4., -4.605170185988093},
  FrameTicks->{{{{-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.050\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.500\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-3.912023005428146, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.020\"", 0.02, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-1.6094379124341003`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.200\"", 0.2, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-3.506557897319982, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.030\"", 0.03, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-1.203972804325936, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\"0.300\"", 0.30000000000000004`, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-4.199705077879927, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.015\"", 0.015, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-1.897119984885881, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\"0.150\"", 0.15000000000000002`, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-2.659260036932778, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.070\"", 0.07, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-0.3566749439387323, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\"0.700\"", 0.7000000000000001, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-4.487387150331708, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.382026634673882, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.286716454869556, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.135166556742356, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.074541934925921, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.017383521085972, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.9633162998156966`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.2072749131897207`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.040220828526554, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.9661128563728327`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.8170772772123447`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.7429693050586228`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6739764335716714`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-4.605170185988091, 
       FormBox["\" \"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\" \"", TraditionalForm]}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm]}, {-0.6931471805599453, 
       FormBox["\" \"", TraditionalForm]}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm]}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm]}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm]}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm]}, {-4.199705077879927, 
       FormBox["\" \"", TraditionalForm]}, {-1.897119984885881, 
       FormBox["\" \"", TraditionalForm]}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm]}, {-0.3566749439387323, 
       FormBox["\" \"", TraditionalForm]}, {-4.487387150331708, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.382026634673882, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.286716454869556, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.135166556742356, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.074541934925921, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.017383521085972, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.9633162998156966`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.2072749131897207`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.040220828526554, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.9661128563728327`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.8170772772123447`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.7429693050586228`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6739764335716714`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{4., 11.}, {-4.605170185988093, -1.9661128563728312`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{-4.605170185988091, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-2.3025850929940455`, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.050\"", 0.05, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-0.6931471805599453, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.500\"", 0.5, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.020\"", 0.02, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.200\"", 0.2, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-3.506557897319982, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.030\"", 0.03, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-1.203972804325936, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"0.300\"", 0.30000000000000004`, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-4.199705077879927, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.015\"", 0.015, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-1.897119984885881, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"0.150\"", 0.15000000000000002`, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-2.659260036932778, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.070\"", 0.07, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-0.3566749439387323, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"0.700\"", 0.7000000000000001, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-4.487387150331708, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.382026634673882, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.286716454869556, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.135166556742356, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.074541934925921, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.017383521085972, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.9633162998156966`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[-Log[25], -3.2188758248682006`], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[-Log[
         Rational[50, 3]], -2.8134107167600364`], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.2072749131897207`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.120263536200091, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.040220828526554, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.9661128563728327`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.8170772772123447`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.7429693050586228`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6739764335716714`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[-Log[
         Rational[5, 2]], -0.9162907318741551], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[-Log[
         Rational[5, 3]], -0.5108256237659907], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "fib", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{"Switch", "[", 
    RowBox[{"n", ",", "0", ",", "0", ",", "1", ",", "1", ",", "_", ",", 
     RowBox[{
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392917863-6913071"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
         RowBox[{
          RowBox[{"fib", "[", "n", "]"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{
           "n", ",", "\[IndentingNewLine]", "0", ",", "0", ",", 
            "\[IndentingNewLine]", "1", ",", "1", ",", "\[IndentingNewLine]", 
            "_", ",", 
            RowBox[{
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "1"}], "]"}], "+", 
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392917863-6913071"]
}, Open  ]],

Cell[TextData[{
 "Achtung, ",
 StyleBox["$RecursionLimit",
  FontWeight->"Bold"],
 " wird jetzt bei jedem rekursiven Aufruf hochgez\[ADoubleDot]hlt und nicht \
nur bei verschachtelten. "
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "20", "]"}]], "Input"],

Cell[BoxData["6765"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392917940-9867669"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "0", "]"}], "=", "0"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "2", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "3", "]"}], "=", "2"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "4", "]"}], "=", "3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "5", "]"}], "=", "5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "6", "]"}], "=", "8"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "7", "]"}], "=", "13"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "8", "]"}], "=", "21"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "9", "]"}], "=", "34"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "10", "]"}], "=", "55"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "11", "]"}], "=", "89"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "12", "]"}], "=", "144"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "13", "]"}], "=", "233"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "14", "]"}], "=", "377"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "15", "]"}], "=", "610"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "16", "]"}], "=", "987"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "17", "]"}], "=", "1597"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "18", "]"}], "=", "2584"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "19", "]"}], "=", "4181"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "20", "]"}], "=", "6765"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
         RowBox[{
          RowBox[{"fib", "[", "n", "]"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{
           "n", ",", "\[IndentingNewLine]", "0", ",", "0", ",", 
            "\[IndentingNewLine]", "1", ",", "1", ",", "\[IndentingNewLine]", 
            "_", ",", 
            RowBox[{
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "1"}], "]"}], "+", 
             RowBox[{"fib", "[", 
              RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392917940-9867669"]
}, Open  ]],

Cell["\<\
Auch die Gr\[ODoubleDot]\[SZ]e der Fibonaccizahlen w\[ADoubleDot]chst \
exponentiell, so dass wir uns in den folgenden Beispielen auf die Berechnung \
der jeweils letzten 20 Ziffern beschr\[ADoubleDot]nken.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "fib", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "0"}], ",", 
      RowBox[{"b", "=", "1"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], "=", 
        RowBox[{"{", 
         RowBox[{"b", ",", 
          RowBox[{"Mod", "[", 
           RowBox[{
            RowBox[{"a", "+", "b"}], ",", 
            SuperscriptBox["10", "20"]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], ";", "a"}]}], "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"fib", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610", ",", "987", ",", "1597", ",", "2584", ",", "4181", ",", "6765"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["Global`fib", "Print", "PrintUsage",
 CellTags->"Info3392917958-7884077"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"a", "=", "0"}], ",", 
             RowBox[{"b", "=", "1"}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"Do", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"a", ",", "b"}], "}"}], "=", 
               RowBox[{"{", 
                RowBox[{"b", ",", 
                 RowBox[{"Mod", "[", 
                  RowBox[{
                   RowBox[{"a", "+", "b"}], ",", 
                   SuperscriptBox["10", "20"]}], "]"}]}], "}"}]}], ",", 
              RowBox[{"{", "n", "}"}]}], "]"}], ";", "a"}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["fib"],
  Editable->False]], "Print",
 CellTags->"Info3392917958-7884077"]
}, Open  ]],

Cell["\<\
Diese Definition hat nicht die Laufzeitprobleme der zuerst gegebenen \
rekursiven Definition und auch nicht die Speicherplatzprobleme der zweiten. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"fib", "[", "1000", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000000358`", ",", "76137795166849228875"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Und so geht es noch schneller (obwohl ",
 StyleBox["MatrixPower",
  FontWeight->"Bold"],
 " nicht mit modularem Rechnen gekoppelt werden kann):"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"matfib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MatrixPower", "[", 
      RowBox[{
       RowBox[{"(", GridBox[{
          {"1", "1"},
          {"1", "0"}
         }], ")"}], ",", "n"}], "]"}], " ", ".", 
     RowBox[{"(", GridBox[{
        {"1"},
        {"0"}
       }], ")"}]}], ")"}], "\[LeftDoubleBracket]", 
   RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matfib", "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610", ",", "987", ",", "1597", ",", "2584", ",", "4181", ",", "6765"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"First", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"fib", "[", 
      SuperscriptBox["10", "n"], "]"}], "//", "Timing"}], ",", 
    RowBox[{
     RowBox[{"matfib", "[", 
      SuperscriptBox["10", "n"], "]"}], "//", "Timing"}]}], "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0299999999999998`", ",", "0.009999999999999646`"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     SuperscriptBox["10", "3"], "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"fib", "[", "#", "]"}], ",", 
         SuperscriptBox["10", "2"]}], "]"}], "\[Equal]", "99"}], ")"}], 
     "&"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "52", ",", "298", ",", "352", ",", "598", ",", "652", ",", "898", ",", 
   "952"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "/@", "l"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "32951280099", ",", "63883732297726369399", ",", "50176124155306760699", 
   ",", "13614497857812538799", ",", "71110319794282041299", ",", 
   "50341132602138508199", ",", "10659067317997121899"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{741, 571},
WindowMargins->{{171, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PostScriptOutputFile":>FrontEnd`FileName[{
  "home", "graebe", "Kofler-Buch", "Notebooks"}, "kap02.nb.ps", 
  CharacterEncoding -> "WindowsANSI"]},
ShowSelection->True,
CellLabelAutoDelete->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3392917824-7018970"->{
  Cell[165096, 4038, 78, 1, 43, "Print",
   CellTags->"Info3392917824-7018970"],
  Cell[165177, 4041, 1142, 31, 85, "Print",
   CellTags->"Info3392917824-7018970"]},
 "Info3392917863-6913071"->{
  Cell[184544, 4520, 78, 1, 43, "Print",
   CellTags->"Info3392917863-6913071"],
  Cell[184625, 4523, 1220, 33, 85, "Print",
   CellTags->"Info3392917863-6913071"]},
 "Info3392917940-9867669"->{
  Cell[186265, 4580, 78, 1, 43, "Print",
   CellTags->"Info3392917940-9867669"],
  Cell[186346, 4583, 3232, 117, 697, "Print",
   CellTags->"Info3392917940-9867669"]},
 "Info3392917958-7884077"->{
  Cell[191129, 4757, 78, 1, 43, "Print",
   CellTags->"Info3392917958-7884077"],
  Cell[191210, 4760, 1429, 40, 24, "Print",
   CellTags->"Info3392917958-7884077"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3392917824-7018970", 196366, 4945},
 {"Info3392917863-6913071", 196561, 4950},
 {"Info3392917940-9867669", 196756, 4955},
 {"Info3392917958-7884077", 196953, 4960}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 44, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[659, 27, 113, 4, 55, "Section"],
Cell[775, 33, 327, 9, 59, "SmallText"],
Cell[CellGroupData[{
Cell[1127, 46, 218, 6, 50, "Input"],
Cell[1348, 54, 47, 0, 28, "Output"]
}, Open  ]],
Cell[1410, 57, 66, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[1501, 62, 132, 4, 30, "Input"],
Cell[1636, 68, 234, 7, 30, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[1919, 81, 70, 0, 55, "Section"],
Cell[1992, 83, 595, 13, 76, "SmallText"],
Cell[CellGroupData[{
Cell[2612, 100, 45, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[2682, 104, 52, 1, 30, "Input"],
Cell[2737, 107, 75, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2849, 112, 76, 2, 33, "Input"],
Cell[2928, 116, 162, 5, 24, "Message"],
Cell[3093, 123, 57, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3187, 129, 225, 7, 30, "Input"],
Cell[3415, 138, 486, 8, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3938, 151, 224, 7, 30, "Input"],
Cell[4165, 160, 486, 8, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4688, 173, 225, 7, 30, "Input"],
Cell[4916, 182, 508, 9, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5461, 196, 122, 3, 30, "Input"],
Cell[5586, 201, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5651, 206, 148, 4, 30, "Input"],
Cell[5802, 212, 42, 0, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5893, 218, 49, 0, 45, "Subsection"],
Cell[5945, 220, 191, 5, 28, "Input"],
Cell[CellGroupData[{
Cell[6161, 229, 378, 11, 49, "Input"],
Cell[6542, 242, 27, 0, 24, "Print"],
Cell[6572, 244, 28, 0, 24, "Print"],
Cell[6603, 246, 29, 0, 24, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6669, 251, 257, 8, 28, "Input"],
Cell[6929, 261, 86, 2, 28, "Output"]
}, Open  ]],
Cell[7030, 266, 875, 27, 52, "Input"],
Cell[CellGroupData[{
Cell[7930, 297, 933, 29, 89, "Input"],
Cell[8866, 328, 2173, 50, 691, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11088, 384, 58, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[11171, 388, 268, 9, 30, "Input"],
Cell[11442, 399, 1257, 30, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12736, 434, 109, 3, 28, "Input"],
Cell[12848, 439, 110, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12995, 446, 269, 9, 30, "Input"],
Cell[13267, 457, 297, 12, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13601, 474, 186, 4, 28, "Input"],
Cell[13790, 480, 68, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13895, 487, 212, 5, 28, "Input"],
Cell[14110, 494, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14175, 499, 391, 13, 28, "Input"],
Cell[14569, 514, 6793, 222, 136, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21423, 743, 34, 0, 55, "Section"],
Cell[21460, 745, 740, 12, 110, "SmallText"],
Cell[CellGroupData[{
Cell[22225, 761, 38, 0, 45, "Subsection"],
Cell[22266, 763, 192, 6, 28, "Input"],
Cell[22461, 771, 211, 8, 37, "Input"],
Cell[22675, 781, 25, 0, 42, "SmallText"],
Cell[22703, 783, 270, 9, 28, "Input"],
Cell[CellGroupData[{
Cell[22998, 796, 168, 5, 28, "Input"],
Cell[23169, 803, 2141, 41, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25347, 849, 462, 15, 28, "Input"],
Cell[25812, 866, 12189, 206, 131, 7006, 119, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[38016, 1075, 433, 11, 76, "SmallText"],
Cell[38452, 1088, 612, 21, 52, "Input"],
Cell[CellGroupData[{
Cell[39089, 1113, 73, 2, 28, "Input"],
Cell[39165, 1117, 157, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39359, 1127, 73, 2, 28, "Input"],
Cell[39435, 1131, 835, 26, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40307, 1162, 464, 15, 28, "Input"],
Cell[40774, 1179, 7903, 132, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48714, 1316, 512, 17, 28, "Input"],
Cell[49229, 1335, 4309, 81, 131, "Output"]
}, Open  ]],
Cell[53553, 1419, 217, 4, 59, "SmallText"],
Cell[53773, 1425, 592, 19, 49, "Input"],
Cell[CellGroupData[{
Cell[54390, 1448, 172, 6, 28, "Input"],
Cell[54565, 1456, 111, 4, 28, "Output"]
}, Open  ]],
Cell[54691, 1463, 93, 2, 42, "SmallText"],
Cell[CellGroupData[{
Cell[54809, 1469, 514, 17, 28, "Input"],
Cell[55326, 1488, 27646, 464, 131, 21317, 359, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[82987, 1955, 123, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[83135, 1962, 562, 19, 28, "Input"],
Cell[83700, 1983, 4187, 75, 131, "Output"]
}, Open  ]],
Cell[87902, 2061, 231, 6, 59, "SmallText"],
Cell[88136, 2069, 734, 25, 49, "Input"],
Cell[CellGroupData[{
Cell[88895, 2098, 172, 6, 28, "Input"],
Cell[89070, 2106, 1193, 37, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90300, 2148, 562, 19, 28, "Input"],
Cell[90865, 2169, 4751, 89, 131, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95665, 2264, 74, 2, 45, "Subsection"],
Cell[95742, 2268, 156, 5, 30, "Input"],
Cell[CellGroupData[{
Cell[95923, 2277, 189, 6, 28, "Input"],
Cell[96115, 2285, 5967, 103, 235, "Output"]
}, Open  ]],
Cell[102097, 2391, 750, 24, 71, "Input"],
Cell[CellGroupData[{
Cell[102872, 2419, 157, 4, 28, "Input"],
Cell[103032, 2425, 201, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103270, 2435, 59, 1, 28, "Input"],
Cell[103332, 2438, 28, 0, 28, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103421, 2445, 28, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[103474, 2449, 43, 0, 45, "Subsection"],
Cell[103520, 2451, 76, 1, 28, "Input"],
Cell[103599, 2454, 938, 27, 69, "Input"],
Cell[CellGroupData[{
Cell[104562, 2485, 223, 7, 28, "Input"],
Cell[104788, 2494, 3768, 127, 89, "Output"]
}, Open  ]],
Cell[108571, 2624, 943, 26, 71, "Input"],
Cell[CellGroupData[{
Cell[109539, 2654, 257, 8, 28, "Input"],
Cell[109799, 2664, 873, 27, 30, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110721, 2697, 48, 0, 45, "Subsection"],
Cell[110772, 2699, 76, 1, 28, "Input"],
Cell[110851, 2702, 1213, 35, 169, "Input"],
Cell[CellGroupData[{
Cell[112089, 2741, 83, 2, 28, "Input"],
Cell[112175, 2745, 324, 7, 24, "Print"],
Cell[112502, 2754, 322, 7, 24, "Print"],
Cell[112827, 2763, 322, 7, 24, "Print"],
Cell[113152, 2772, 322, 7, 24, "Print"],
Cell[113477, 2781, 28, 0, 28, "Output"]
}, Open  ]],
Cell[113520, 2784, 2092, 59, 189, "Input"],
Cell[CellGroupData[{
Cell[115637, 2847, 91, 2, 28, "Input"],
Cell[115731, 2851, 492, 9, 24, "Print"],
Cell[116226, 2862, 489, 8, 24, "Print"],
Cell[116718, 2872, 492, 9, 24, "Print"],
Cell[117213, 2883, 491, 8, 24, "Print"],
Cell[117707, 2893, 102, 3, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117858, 2902, 40, 0, 45, "Subsection"],
Cell[117901, 2904, 76, 1, 28, "Input"],
Cell[117980, 2907, 365, 12, 28, "Input"],
Cell[CellGroupData[{
Cell[118370, 2923, 861, 28, 109, "Input"],
Cell[119234, 2953, 127, 3, 28, "Output"],
Cell[119364, 2958, 63, 1, 28, "Output"]
}, Open  ]],
Cell[119442, 2962, 164, 3, 42, "SmallText"],
Cell[119609, 2967, 1143, 36, 89, "Input"],
Cell[120755, 3005, 250, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[121030, 3016, 3046, 98, 229, "Input"],
Cell[124079, 3116, 22111, 368, 381, 14863, 248, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146227, 3489, 507, 15, 49, "Input"],
Cell[146737, 3506, 8316, 163, 444, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[155102, 3675, 77, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[155204, 3679, 93, 2, 28, "Input"],
Cell[155300, 3683, 99, 2, 28, "Output"]
}, Open  ]],
Cell[155414, 3688, 1026, 30, 149, "Input"],
Cell[156443, 3720, 404, 12, 28, "Input"],
Cell[CellGroupData[{
Cell[156872, 3736, 90, 2, 28, "Input"],
Cell[156965, 3740, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157105, 3747, 54, 1, 28, "Input"],
Cell[157162, 3750, 51, 1, 42, "Output"]
}, Open  ]],
Cell[157228, 3754, 175, 5, 76, "SmallText"],
Cell[157406, 3761, 813, 22, 129, "Input"],
Cell[CellGroupData[{
Cell[158244, 3787, 107, 3, 28, "Input"],
Cell[158354, 3792, 111, 2, 28, "Output"]
}, Open  ]],
Cell[158480, 3797, 296, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[158801, 3807, 83, 2, 28, "Input"],
Cell[158887, 3811, 162, 4, 28, "Output"]
}, Open  ]],
Cell[159064, 3818, 38, 0, 42, "SmallText"],
Cell[159105, 3820, 637, 20, 69, "Input"],
Cell[CellGroupData[{
Cell[159767, 3844, 83, 2, 28, "Input"],
Cell[159853, 3848, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159993, 3855, 54, 1, 28, "Input"],
Cell[160050, 3858, 51, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160138, 3864, 96, 2, 28, "Input"],
Cell[160237, 3868, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160377, 3875, 83, 2, 36, "Input"],
Cell[160463, 3879, 194, 6, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[160706, 3891, 53, 0, 45, "Subsection"],
Cell[160762, 3893, 76, 1, 28, "Input"],
Cell[160841, 3896, 1279, 35, 165, "Input"],
Cell[CellGroupData[{
Cell[162145, 3935, 98, 2, 44, "Input"],
Cell[162246, 3939, 293, 7, 24, "Print"],
Cell[162542, 3948, 291, 7, 24, "Print"],
Cell[162836, 3957, 293, 7, 24, "Print"],
Cell[163132, 3966, 293, 7, 24, "Print"],
Cell[163428, 3975, 293, 7, 24, "Print"],
Cell[163724, 3984, 295, 7, 24, "Print"],
Cell[164022, 3993, 293, 7, 24, "Print"],
Cell[164318, 4002, 29, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164384, 4007, 98, 2, 44, "Input"],
Cell[164485, 4011, 29, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164563, 4017, 37, 0, 45, "Subsection"],
Cell[164603, 4019, 76, 1, 44, "Input"],
Cell[164682, 4022, 340, 9, 44, "Input"],
Cell[CellGroupData[{
Cell[165047, 4035, 46, 1, 44, "Input"],
Cell[165096, 4038, 78, 1, 43, "Print",
 CellTags->"Info3392917824-7018970"],
Cell[165177, 4041, 1142, 31, 85, "Print",
 CellTags->"Info3392917824-7018970"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166356, 4077, 162, 5, 44, "Input"],
Cell[166521, 4084, 164, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166722, 4093, 90, 2, 44, "Input"],
Cell[166815, 4097, 81, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166933, 4104, 335, 10, 44, "Input"],
Cell[167271, 4116, 565, 10, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167873, 4131, 323, 8, 44, "Input"],
Cell[168199, 4141, 819, 16, 254, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169055, 4162, 440, 13, 65, "Input"],
Cell[169498, 4177, 14475, 320, 250, "Output"]
}, Open  ]],
Cell[183988, 4500, 482, 13, 65, "Input"],
Cell[CellGroupData[{
Cell[184495, 4517, 46, 1, 44, "Input"],
Cell[184544, 4520, 78, 1, 43, "Print",
 CellTags->"Info3392917863-6913071"],
Cell[184625, 4523, 1220, 33, 85, "Print",
 CellTags->"Info3392917863-6913071"]
}, Open  ]],
Cell[185860, 4559, 203, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[186088, 4569, 57, 1, 44, "Input"],
Cell[186148, 4572, 31, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186216, 4577, 46, 1, 44, "Input"],
Cell[186265, 4580, 78, 1, 43, "Print",
 CellTags->"Info3392917940-9867669"],
Cell[186346, 4583, 3232, 117, 697, "Print",
 CellTags->"Info3392917940-9867669"]
}, Open  ]],
Cell[189593, 4703, 235, 4, 59, "SmallText"],
Cell[189831, 4709, 728, 23, 66, "Input"],
Cell[CellGroupData[{
Cell[190584, 4736, 162, 5, 44, "Input"],
Cell[190749, 4743, 294, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191080, 4754, 46, 1, 44, "Input"],
Cell[191129, 4757, 78, 1, 43, "Print",
 CellTags->"Info3392917958-7884077"],
Cell[191210, 4760, 1429, 40, 24, "Print",
 CellTags->"Info3392917958-7884077"]
}, Open  ]],
Cell[192654, 4803, 176, 3, 59, "SmallText"],
Cell[CellGroupData[{
Cell[192855, 4810, 92, 2, 44, "Input"],
Cell[192950, 4814, 115, 3, 44, "Output"]
}, Open  ]],
Cell[193080, 4820, 179, 5, 42, "SmallText"],
Cell[193262, 4827, 457, 16, 53, "Input"],
Cell[CellGroupData[{
Cell[193744, 4847, 135, 4, 44, "Input"],
Cell[193882, 4853, 294, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194213, 4864, 360, 11, 49, "Input"],
Cell[194576, 4877, 114, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194727, 4885, 388, 13, 46, "Input"],
Cell[195118, 4900, 143, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195298, 4909, 52, 1, 44, "Input"],
Cell[195353, 4912, 258, 5, 65, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
