(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    172293,       5716]
NotebookOptionsPosition[    154832,       5139]
NotebookOutlinePosition[    155850,       5175]
CellTagsIndexPosition[    155677,       5168]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Vektoren und Matrizen, Lineare Algebra", "Title",
 Evaluatable->False,
 CellHorizontalScrolling->False],

Cell[CellGroupData[{

Cell["Vektoren", "Section"],

Cell[CellGroupData[{

Cell["Vektoren eingeben. Zusammengesetzte Bezeichner", "Subsection",
 CellChangeTimes->{{3354642755.18096, 3354642777.33945}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.35463829357606*^9, 3.35463829634192*^9}, {
  3.35658445488923*^9, 3.35658446045872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["v2", "\[RightVector]"], "^=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35463857550503*^9, 3.3546386080428*^9}, {
  3.35658611475138*^9, 3.35658611549525*^9}}],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], " "}]]],
 "und ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["v2", "\[RightVector]"], " "}]]],
 "sind zusammengesetzte Bezeichner, bei deren Verwendung einige \
Besonderheiten zu beachten sind.\n\nZun\[ADoubleDot]chst entsprechen diesen \
Bezeichnern keine eigenst\[ADoubleDot]ndigen Eintr\[ADoubleDot]ge in der \
Symboltabelle, weil sie selbst zusammengesetzte Ausdr\[UDoubleDot]cke sind, \
wie die ",
 StyleBox["FullForm",
  FontWeight->"Bold"],
 " an den Tag bringt. "
}], "SmallText",
 CellChangeTimes->{{3.35463836830404*^9, 3.35463844603806*^9}, {
  3.35463848116053*^9, 3.35463854141838*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "//", "Hold"}], "//", 
  "FullForm"}]], "Input",
 CellChangeTimes->{{3.35463846542419*^9, 3.35463847241221*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Hold", "[", 
    RowBox[{"OverVector", "[", "v1", "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Werte der einzelnen Variablen werden standardm\[ADoubleDot]\[SZ]ig als \
",
 StyleBox["DownValue",
  FontWeight->"Bold"],
 " unter dem Funktionsbezeichner, hier also ",
 StyleBox["OverVector",
  FontWeight->"Bold"],
 ", gespeichert. Sie k\[ODoubleDot]nnen aber auch als ",
 StyleBox["UpValue",
  FontWeight->"Bold"],
 " wie hier auf dem Bezeichner v2 selbst gespeichert werden. "
}], "SmallText",
 CellChangeTimes->{{3.35463855847504*^9, 3.35463856449081*^9}, {
  3.35463862976086*^9, 3.35463866788538*^9}, {3.35463921201461*^9, 
  3.35463921250804*^9}, {3.35463937727804*^9, 3.35463939233864*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"?", "OverVector"}], "\n", 
 RowBox[{"DownValues", "[", "OverVector", "]"}], "\n", 
 RowBox[{"UpValues", "[", "v2", "]"}]}], "Input",
 CellChangeTimes->{{3.35463832085024*^9, 3.35463835150691*^9}, 
   3.35463942361712*^9, {3.3565875669133*^9, 3.3565875821543*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*RowBox[{\\\"OverVector\\\", \\\"[\\\", \
StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\"]\\\"}]\\) displays with a right \
vector over \\!\\(\\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\\).\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3392918671-3538003"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    OverscriptBox["v1", "\[RightVector]"], "]"}], "\[RuleDelayed]", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    OverscriptBox["v2", "\[RightVector]"], "]"}], "\[RuleDelayed]", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "v2"}]], "Input",
 CellChangeTimes->{{3.35463858292639*^9, 3.35463861562719*^9}}],

Cell["Global`v2", "Print", "PrintUsage",
 CellTags->"Info3392918680-2514319"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         OverscriptBox["v2", "\[RightVector]"], "^=", 
         RowBox[{"{", 
          RowBox[{"u", ",", "v", ",", "w"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["v2"],
  Editable->False]], "Print",
 CellTags->"Info3392918680-2514319"]
}, Open  ]],

Cell["\<\
Je nachdem, wie Sie die Werte abspeichern, m\[UDoubleDot]ssen Sie \
verschiedene Kommandos zum L\[ODoubleDot]schen verwenden.\
\>", "SmallText",
 CellChangeTimes->{{3.35658834252362*^9, 3.35658837007078*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"v1", ",", "v2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], ",", " ", 
   OverscriptBox["v2", "\[RightVector]"]}], "}"}]}], "Input",
 CellChangeTimes->{{3.35658819848727*^9, 3.35658826696244*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   OverscriptBox["v2", "\[RightVector]"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "OverVector", "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], ",", " ", 
   OverscriptBox["v2", "\[RightVector]"]}], "}"}]}], "Input",
 CellChangeTimes->{{3.3565883775421*^9, 3.35658839774455*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], ",", 
   OverscriptBox["v2", "\[RightVector]"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " ist ein Formatierungskommando, das sowohl auf Vektoren als auch auf \
Matrizen angewendet werden kann. \n\nBeachten Sie, dass einspaltige Matrizen \
und Vektoren intern unterschiedlich dargestellt sind, von MatrixForm aber in \
gleicher Form ausgegeben werden."
}], "SmallText",
 CellChangeTimes->{{3.35463949288494*^9, 3.3546395764788*^9}, {
   3.35658759120801*^9, 3.35658759190482*^9}, 3.35658873650425*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["v2", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "+", 
   OverscriptBox["v2", "\[RightVector]"]}], " ", "//", 
  "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.35463946823981*^9, 3.35463947821211*^9}, {
  3.35658876700708*^9, 3.35658877264087*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"a", "+", "u"}]},
      {
       RowBox[{"b", "+", "v"}]},
      {
       RowBox[{"c", "+", "w"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   OverscriptBox["v1", "\[RightVector]"], 
   OverscriptBox["v2", "\[RightVector]"]]]],
 " sieht mathematisch recht seltsam (und nicht sehr sinnvoll) aus; die \
Auswertung gelingt, weil ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Vektoren eigentlich nicht kennt, sondern als gew\[ODoubleDot]hnliche \
Listen betrachtet"
}], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   OverscriptBox["v1", "\[RightVector]"], 
   OverscriptBox["v2", "\[RightVector]"]], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       SuperscriptBox["a", "u"]},
      {
       SuperscriptBox["b", "v"]},
      {
       SuperscriptBox["c", "w"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Es gibt drei verschiedene Multiplikationsvarianten: Multiplikation eines \
Vektors mit einem Skalar, das skalare Produkt zweier Vektoren (Eingabe: ein \
einfacher Punkt . ) und das Kreuzprodukt (Eingabe: \[VeryThinSpace]\
\[EscapeKey]cross\[EscapeKey] oder Cross[",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], " ", ",", " ", 
   OverscriptBox["v2", "\[RightVector]"]}]]],
 "], nur f\[UDoubleDot]r Vektoren im ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "3"], TraditionalForm]]],
 ")"
}], "SmallText",
 CellChangeTimes->{{3.35463963671219*^9, 3.35463970176289*^9}, {
  3.35463984348307*^9, 3.35463986990219*^9}, {3.35658898098529*^9, 
  3.35658898169048*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   OverscriptBox["v1", "\[RightVector]"]}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"3", " ", "a"}]},
      {
       RowBox[{"3", " ", "b"}]},
      {
       RowBox[{"3", " ", "c"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["v1", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["v2", "\[RightVector]"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "u"}], "+", 
  RowBox[{"b", " ", "v"}], "+", 
  RowBox[{"c", " ", "w"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], " ", "\[Cross]", 
   OverscriptBox["v2", "\[RightVector]"]}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], " ", "v"}], "+", 
        RowBox[{"b", " ", "w"}]}]},
      {
       RowBox[{
        RowBox[{"c", " ", "u"}], "-", 
        RowBox[{"a", " ", "w"}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "u"}], "+", 
        RowBox[{"a", " ", "v"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Kreuzprodukt ist allgemein f\[UDoubleDot]r (n-1)-Tupel von Vektoren im \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "n"], TraditionalForm]]],
 "definiert."
}], "SmallText",
 CellChangeTimes->{{3.35463982044389*^9, 3.35463983535769*^9}, {
  3.35463988175668*^9, 3.35463991655779*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35463973182355*^9, 3.35463974573895*^9}, {
  3.35463978822457*^9, 3.35463979980039*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", "12", ",", "12", ",", 
   RowBox[{"-", "18"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beispiel: Schnitt Gerade-Ebene", "Subsection"],

Cell[TextData[{
 "Schnitt Gerade mit Ebene\nP, Q\tPunkte im 3D Raum\n",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]]],
 "\tVektoren\ng\tGerade\n\[Epsilon]\tEbene"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "OverVector", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "3", ",", "5"}], "}"}]}], ";", " ", 
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "4"}], "}"}]}], ";", " "}]}], "Input",
 CellChangeTimes->{{3.35659061606178*^9, 3.3565906346954*^9}}],

Cell["\<\
Verbundzuweisung und Darstellung als Liste von Vektoren in zweidimensionaler \
Notation.\
\>", "SmallText",
 CellChangeTimes->{{3.35659102584859*^9, 3.3565910554371*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], ",", 
      OverscriptBox["v", "\[RightVector]"], ",", " ", 
      OverscriptBox["w", "\[RightVector]"]}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "4"}], "}"}]}], "}"}]}], ")"}]}]], "Input",\

 CellChangeTimes->{{3.35659054047115*^9, 3.35659060906552*^9}, {
  3.35659064015652*^9, 3.35659064261113*^9}, {3.35659083966131*^9, 
  3.35659085064723*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"0"},
        {
         RowBox[{"-", "1"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3"},
        {"2"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"1"},
        {"4"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dieselbe Liste von Listen als Matrix in zweidimensionaler Notation. Obige \
Vektoren sind die ",
 StyleBox["Zeilen",
  FontWeight->"Bold"],
 " dieser Matrix."
}], "SmallText",
 CellChangeTimes->{{3.35659106402335*^9, 3.35659110090357*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], ",", 
    OverscriptBox["v", "\[RightVector]"], ",", " ", 
    OverscriptBox["w", "\[RightVector]"]}], "}"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35659101185171*^9, 3.35659101409344*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      RowBox[{"-", "1"}]},
     {"3", "2", "1"},
     {"0", "1", "4"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"g", "=", 
    RowBox[{"P", "+", 
     RowBox[{"a", " ", 
      OverscriptBox["u", "\[RightVector]"]}]}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35659047677087*^9, 3.3565904970156*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"12", "+", "a"}]},
      {"3"},
      {
       RowBox[{"5", "-", "a"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"\[CurlyEpsilon]", "=", 
    RowBox[{"Q", "+", 
     RowBox[{"b", " ", 
      OverscriptBox["v", "\[RightVector]"]}], " ", "+", " ", 
     RowBox[{"c", " ", 
      OverscriptBox["w", "\[RightVector]"]}]}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35659048259623*^9, 3.35659050973383*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"9", "+", 
        RowBox[{"3", " ", "b"}]}]},
      {
       RowBox[{"8", "+", 
        RowBox[{"2", " ", "b"}], "+", "c"}]},
      {
       RowBox[{"4", "+", "b", "+", 
        RowBox[{"4", " ", "c"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"g", "\[Equal]", "\[CurlyEpsilon]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.387964852161771*^9, 3.387964852862003*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", "21"}]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", "6"}]}], ",", 
    RowBox[{"c", "\[Rule]", "7"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", " ", "/.", " ", 
  RowBox[{"lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
  " "}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "9"}], ",", "3", ",", "26"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beachten Sie, dass Wertzuweisungen an zusammengesetzte Symbole nur \
\[UDoubleDot]ber den Bezeichner gel\[ODoubleDot]scht werden \
k\[ODoubleDot]nnen, dem sie zugeordnet sind, hier also dem \
Funktionsbezeichner ",
 StyleBox["OverVector",
  FontWeight->"Bold"],
 ". "
}], "SmallText",
 CellChangeTimes->{{3.35464012372758*^9, 3.35464018381096*^9}, {
  3.35659366608474*^9, 3.35659366664038*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "OverVector"}]], "Input",
 CellChangeTimes->{{3.35464005547486*^9, 3.35464006100857*^9}, 
   3.387964925858163*^9}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*RowBox[{\\\"OverVector\\\", \\\"[\\\", \
StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\"]\\\"}]\\) displays with a right \
vector over \\!\\(\\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\\).\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3392918790-6024457"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         OverscriptBox["u", "\[RightVector]"], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         OverscriptBox["v", "\[RightVector]"], "=", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", "1"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         OverscriptBox["w", "\[RightVector]"], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "4"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["OverVector"],
  Editable->False]], "Print",
 CellTags->"Info3392918790-6024457"]
}, Open  ]],

Cell[TextData[{
 "L\[ODoubleDot]schen solches Symbole ist jetzt schwieriger, weil sie im \
Kontext ",
 StyleBox["System'",
  FontWeight->"Bold"],
 " gespeichert sind. "
}], "SmallText",
 CellChangeTimes->{{3.387964985610853*^9, 3.387965011458713*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  OverscriptBox["v", "\[RightVector]"], " "}]}], "Input",
 CellChangeTimes->{{3.35464007327616*^9, 3.35464009284334*^9}, 
   3.387964914051935*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", "1"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "OverVector", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["v", "\[RightVector]"], " ", " "}]}], "Input",
 CellChangeTimes->{{3.35464002030765*^9, 3.35464002068251*^9}, {
  3.35464019586012*^9, 3.35464020218287*^9}, {3.387964964583727*^9, 
  3.387964975333577*^9}}],

Cell[BoxData[
 OverscriptBox["v", "\[RightVector]"]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Unterscheiden Sie zwischen Vektoren und einspaltigen Matrizen!\
\>", "Subsection",
 CellChangeTimes->{{3354641237.26055, 3354641254.90719}}],

Cell["\<\
Vorsicht: Vektoren und einspaltige Matrizen haben unterschiedliche interne \
Darstellungen, werden aber von MatrixForm auf dieselbe Weise dargestellt.

\[CapitalUDoubleDot]ber Palette oder 3D-Eingabe k\[ODoubleDot]nnen nur \
einspaltige Matrizen eingegeben werden.\
\>", "SmallText",
 CellChangeTimes->{{3354640744.94964, 3354640832.79208}}],

Cell[TextData[{
 Cell[BoxData[
  OverscriptBox["a", "\[RightVector]"]], "Input",
  CellChangeTimes->{{3354640388.21048, 3354640425.79998}, {3354640514.40265, 
   3354640523.44683}, {3354640608.1391, 3354640678.0396}},
  FontWeight->"Plain"],
 " und ",
 Cell[BoxData[
  StyleBox[
   OverscriptBox["b", "\[RightVector]"],
   FontWeight->"Plain"]], "Input",
  CellChangeTimes->{{3354640388.21048, 3354640425.79998}, {3354640514.40265, 
   3354640523.44683}, {3354640608.1391, 3354640678.0396}}],
 " sind einspaltige Matrizen, ",
 Cell[BoxData[
  OverscriptBox["c", "\[RightVector]"]], "Input",
  CellChangeTimes->{{3354640388.21048, 3354640425.79998}, {3354640514.40265, 
   3354640523.44683}, {3354640608.1391, 3354640678.0396}},
  FontWeight->"Plain"],
 " dagegen ein Vektor. Das merkt man bei den ersten beiden Kommandos noch \
nicht, denn sie werden komponentenweise ausgef\[UDoubleDot]hrt."
}], "SmallText",
 CellChangeTimes->{{3354640846.20261, 3354640898.03258}, {3356621444.48362, 
  3356621485.61496}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], "=", 
   RowBox[{"(", GridBox[{
      {"a1"},
      {"a2"},
      {"a3"}
     }], ")"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["b", "\[RightVector]"], "=", 
   RowBox[{"(", GridBox[{
      {"b1"},
      {"b2"},
      {"b3"}
     }], ")"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["c", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35464038821048*^9, 3.35464042579998*^9}, {
  3.35464051440265*^9, 3.35464052344683*^9}, {3.3546406081391*^9, 
  3.3546406780396*^9}, {3.35662132562093*^9, 3.35662135104775*^9}, {
  3.35662150526405*^9, 3.35662151869813*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], ",", 
   OverscriptBox["b", "\[RightVector]"], ",", " ", 
   OverscriptBox["c", "\[RightVector]"]}], "}"}]], "Input",
 CellChangeTimes->{{3.35662152318402*^9, 3.35662154033244*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a1", "}"}], ",", 
     RowBox[{"{", "a2", "}"}], ",", 
     RowBox[{"{", "a3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "b1", "}"}], ",", 
     RowBox[{"{", "b2", "}"}], ",", 
     RowBox[{"{", "b3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"MatrixForm", "/@", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], ",", 
     OverscriptBox["b", "\[RightVector]"], ",", " ", 
     OverscriptBox["c", "\[RightVector]"]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.35464068387677*^9, 3.3546407242058*^9}, {
  3.3566215472949*^9, 3.35662155652375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a1"},
       {"a2"},
       {"a3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"b1"},
       {"b2"},
       {"b3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"c1"},
        {"c2"},
        {"c3"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  OverscriptBox["a", "\[RightVector]"], "]"}]], "Input",
 CellChangeTimes->{{3.35662156060063*^9, 3.35662156168775*^9}}],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell["\<\
Einspaltige Matrizen k\[ODoubleDot]nnen wie Vektoren addiert und skalar \
vervielfacht werden. Das Ergebnis ist wieder eine einspaltige Matrix.\
\>", "SmallText",
 CellChangeTimes->{{3.3546409824036*^9, 3.35464102116419*^9}, {
  3.35464105934856*^9, 3.35464108680613*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], "+", 
   OverscriptBox["b", "\[RightVector]"]}], " ", "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.3566215659475*^9, 3.35662157047832*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a1", "+", "b1"}]},
     {
      RowBox[{"a2", "+", "b2"}]},
     {
      RowBox[{"a3", "+", "b3"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Selbst die Summe einer einspaltigen Matrix und eines Vektors kann gebildet \
werden. Das Ergebnis ist eine einspaltige Matrix.\
\>", "SmallText",
 CellChangeTimes->{{3.35464109245615*^9, 3.35464115407025*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], "+", 
  OverscriptBox["c", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35464104772817*^9, 3.35464104895804*^9}, {
  3.35662137539683*^9, 3.356621376041*^9}, {3.35662157705807*^9, 
  3.35662158201651*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a1", "+", "c1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a2", "+", "c2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a3", "+", "c3"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{
  3.35464113026268*^9, {3.35662136656316*^9, 3.35662136966506*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a1", "+", "c1"}]},
     {
      RowBox[{"a2", "+", "c2"}]},
     {
      RowBox[{"a3", "+", "c3"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Als einspaltige Matrizen sind ",
 Cell[BoxData[
  OverscriptBox["a", "\[RightVector]"]]],
 " und ",
 Cell[BoxData[
  RowBox[{" ", 
   OverscriptBox["b", "\[RightVector]"]}]]],
 " nicht verkettet - deshalb endet dieses Dot-Kommando mit einer \
Fehlermeldung. W\[ADoubleDot]ren es Vektoren, w\[UDoubleDot]rde es als \
Skalarprodukt interpretiert und ausgef\[UDoubleDot]hrt."
}], "SmallText",
 CellChangeTimes->{{3.35662160354959*^9, 3.35662163522957*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["b", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35662158855663*^9, 3.35662159356681*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dot", "::", "\<\"dotsh\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Tensors \\!\\({\\(\\({a1}\\)\\), \\(\\({a2}\\)\\), \
\\(\\({a3}\\)\\)}\\) and \\!\\({\\(\\({b1}\\)\\), \\(\\({b2}\\)\\), \
\\(\\({b3}\\)\\)}\\) have incompatible shapes.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a1", "}"}], ",", 
    RowBox[{"{", "a2", "}"}], ",", 
    RowBox[{"{", "a3", "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "b1", "}"}], ",", 
    RowBox[{"{", "b2", "}"}], ",", 
    RowBox[{"{", "b3", "}"}]}], "}"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Dasselbe gilt f\[UDoubleDot]r das Vektorprodukt, das ebenfalls nur f\
\[UDoubleDot]r Vektoren, nicht aber f\[UDoubleDot]r einspaltige Matrizen \
definiert ist. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], " ", "\[Cross]", 
  OverscriptBox["b", "\[RightVector]"], " "}]], "Input",
 CellChangeTimes->{{3.35662164884991*^9, 3.35662166070606*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cross", "::", "\<\"nonn1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The arguments are expected to be vectors of equal length, \
and the number of arguments is expected to be 1 less than their \
length.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a1", "}"}], ",", 
    RowBox[{"{", "a2", "}"}], ",", 
    RowBox[{"{", "a3", "}"}]}], "}"}], "\[Cross]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "b1", "}"}], ",", 
    RowBox[{"{", "b2", "}"}], ",", 
    RowBox[{"{", "b3", "}"}]}], "}"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Verkettet sind hingegen ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], " "}]], "Input",
  CellChangeTimes->{{3.35662158855663*^9, 3.35662159356681*^9}},
  FontWeight->"Plain"],
 "und die zu ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["b", "\[RightVector]"], " "}]], "Input",
  CellChangeTimes->{{3.35662158855663*^9, 3.35662159356681*^9}},
  FontWeight->"Plain"],
 "transponierte Matrix, und zwar in beiden Reihenfolgen. \nIm ersten Fall \
ergibt sich eine 3\[Times]3-Matrix, deren Eintr\[ADoubleDot]ge die paarweisen \
Produkte sind; im zweiten Fall eine 1\[Times]1-Matrix mit dem Skalarprodukt \
als Eintrag."
}], "SmallText",
 CellChangeTimes->{{3.35662204098694*^9, 3.35662215045451*^9}, {
  3.35662224668827*^9, 3.35662225529259*^9}, {3.35662239014366*^9, 
  3.35662243188979*^9}, {3.35662287529611*^9, 3.35662287975284*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], " ", ".", 
   RowBox[{"Transpose", "[", " ", 
    OverscriptBox["b", "\[RightVector]"], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.3566219358723*^9, 3.35662198503249*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a1", " ", "b1"}], 
      RowBox[{"a1", " ", "b2"}], 
      RowBox[{"a1", " ", "b3"}]},
     {
      RowBox[{"a2", " ", "b1"}], 
      RowBox[{"a2", " ", "b2"}], 
      RowBox[{"a2", " ", "b3"}]},
     {
      RowBox[{"a3", " ", "b1"}], 
      RowBox[{"a3", " ", "b2"}], 
      RowBox[{"a3", " ", "b3"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", " ", 
    OverscriptBox["b", "\[RightVector]"], " ", "]"}], ".", 
   OverscriptBox["a", "\[RightVector]"]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35662199819489*^9, 3.35662200939643*^9}, {
  3.3566223637578*^9, 3.35662236829544*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"a1", " ", "b1"}], "+", 
       RowBox[{"a2", " ", "b2"}], "+", 
       RowBox[{"a3", " ", "b3"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Auf die Kombination von Matrix und Vektor wirkt . nicht als Skalarprodukt, \
sondern als Produkt von Matrix und Vektor. Daf\[UDoubleDot]r \
m\[UDoubleDot]ssen beide verkettet sein. Als Ergebnis ergibt sich ein \
1-Vektor, dessen Eintrag der Wert des Skalarprodukts ist.\
\>", "SmallText",
 CellChangeTimes->{{3.35662332267448*^9, 3.35662339987597*^9}, {
  3.3566238944243*^9, 3.35662399303223*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["c", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35662185365544*^9, 3.35662185408099*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dot", "::", "\<\"dotsh\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Tensors \\!\\({\\(\\({a1}\\)\\), \\(\\({a2}\\)\\), \
\\(\\({a3}\\)\\)}\\) and \\!\\({c1, c2, c3}\\) have incompatible \
shapes.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a1", "}"}], ",", 
    RowBox[{"{", "a2", "}"}], ",", 
    RowBox[{"{", "a3", "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["c", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["b", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35662186738257*^9, 3.35662186798493*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b1", " ", "c1"}], "+", 
   RowBox[{"b2", " ", "c2"}], "+", 
   RowBox[{"b3", " ", "c3"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrizen erzeugen", "Section"],

Cell[CellGroupData[{

Cell["Matrizen definieren", "Subsection",
 CellChangeTimes->{{3354643416.14757, 3354643418.98227}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.387966637792579*^9, 3.387966640512899*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3"},
     {"4", "5", "6"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", "5", "6"}
     }], ")"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat1", "=", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"mat1", " ", "//", "MatrixForm"}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.38796665309784*^9, {3.388420619115562*^9, 3.388420640297991*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "=", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "5"}]}], "}"}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"mat2", " ", "//", " ", "MatrixForm"}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.387966658310715*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "0", "0"},
     {"0", "3", "0"},
     {"0", "0", 
      RowBox[{"-", "5"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", "j"}], ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat3", " ", "//", " ", "MatrixForm"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1"},
     {"0", "1", "1", "1"},
     {"0", "0", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", "]"}], ",", 
    RowBox[{"{", "3", "}"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6302496150740782`", "0.25560086911412583`", "0.9949470798993222`"},
     {"0.7606246190120012`", "0.675664190821661`", "0.615576565415297`"},
     {"0.16610181059712464`", "0.3371023723511001`", "0.7963162784882222`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "UDM", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UDM", "[", 
    RowBox[{"f_Function", ",", 
     RowBox[{"n_Integer", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", ">", "0"}], "&"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", "j"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"i", ",", "j"}], "]"}], ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.35464292636531*^9, 3.35464297799485*^9}, {
  3.35464306196606*^9, 3.35464309204954*^9}, {3.35464320423884*^9, 
  3.35464320917479*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UDM", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "#2"], "&"}], ",", "3"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35464307924299*^9, 3.35464308151646*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1"},
     {"0", "4", "8"},
     {"0", "0", "27"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UDM", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", "3"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35464307924299*^9, 3.35464311315499*^9}, {
  3.35464322082281*^9, 3.35464327951711*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"x", "[", 
       RowBox[{"1", ",", "1"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"1", ",", "2"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"1", ",", "3"}], "]"}]},
     {"0", 
      RowBox[{"x", "[", 
       RowBox[{"2", ",", "2"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"2", ",", "3"}], "]"}]},
     {"0", "0", 
      RowBox[{"x", "[", 
       RowBox[{"3", ",", "3"}], "]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HilbertMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], "]"}], " ", "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.387966962490349*^9, 3.38796696454259*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      FractionBox["1", "2"], 
      FractionBox["1", "3"]},
     {
      FractionBox["1", "2"], 
      FractionBox["1", "3"], 
      FractionBox["1", "4"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"u", "v", "w"},
     {"v", "w", "0"},
     {"w", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "\[Degree] ist die Kurzform der Konstanten ",
 StyleBox["Degree",
  FontWeight->"Bold"],
 ", kann auch als \[EscapeKey]deg\[EscapeKey] eingegeben werden. In \
entsprechenden Kontexten wird sie durch ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Pi]", "180"], TraditionalForm]]],
 "ersetzt."
}], "SmallText",
 CellChangeTimes->{{3.35856807584416*^9, 3.35856813423044*^9}, {
  3.358568467253*^9, 3.35856849899993*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   RowBox[{"12", "\[Degree]"}], "+", 
   RowBox[{"\[Pi]", "/", "180"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35856804588822*^9, 3.35856806205735*^9}, {
   3.35856834252373*^9, 3.35856842809305*^9}, {3.35856876757436*^9, 
   3.35856876934537*^9}, 3.387969467797075*^9}],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   RowBox[{"12", " ", "\[Degree]"}], "+", 
   FractionBox["\[Pi]", "180"]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{"12", "\[Degree]"}], "+", 
    RowBox[{"\[Pi]", "/", "180"}]}], "]"}], "//", "FullForm"}]], "Input",
 CellChangeTimes->{{3.35856804588822*^9, 3.35856806205735*^9}, {
  3.35856834252373*^9, 3.35856842809305*^9}, {3.35856876757436*^9, 
  3.35856876934537*^9}, {3.387969452848524*^9, 3.387969456668433*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Sin", "[", 
    RowBox[{"Plus", "[", 
     RowBox[{
      RowBox[{"Times", "[", 
       RowBox[{"12", ",", "Degree"}], "]"}], ",", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"Rational", "[", 
         RowBox[{"1", ",", "180"}], "]"}], ",", "Pi"}], "]"}]}], "]"}], "]"}],
   
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{"12", "\[Degree]"}], "+", 
    RowBox[{"\[Pi]", "/", "180"}]}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.35856804588822*^9, 3.35856806205735*^9}, {
  3.35856834252373*^9, 3.35856842809305*^9}, {3.35856876757436*^9, 
  3.35856876934537*^9}, {3.387969472078628*^9, 3.387969472786707*^9}}],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox[
   RowBox[{"13", " ", "\[Pi]"}], "180"], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix", "[", 
   RowBox[{"30", "\[Degree]"}], "]"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35856802744712*^9, 3.35856802972589*^9}, {
  3.387966988387414*^9, 3.387966988526247*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       SqrtBox["3"], "2"], 
      RowBox[{"-", 
       FractionBox["1", "2"]}]},
     {
      FractionBox["1", "2"], 
      FractionBox[
       SqrtBox["3"], "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix", "[", 
   RowBox[{
    RowBox[{"30", "\[Degree]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.387966993299266*^9, 3.387966993493971*^9}, {
  3.387968590387275*^9, 3.387968620786258*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["3"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SqrtBox["3"]}], ")"}]}], 
      FractionBox["1", "3"]},
     {
      FractionBox["1", "3"], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["3"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SqrtBox["3"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SqrtBox["3"]}], ")"}]}], 
      FractionBox["1", "3"], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["3"]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Matrizen mit indizierten Variablen.
Die erste M\[ODoubleDot]glichkeit x als zweistellige Funktion\
\>", "SmallText",
 CellChangeTimes->{{3.388402777407233*^9, 3.388402827286153*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.38840269522547*^9, 3.38840269985684*^9}, {
  3.388405426749979*^9, 3.388405433934113*^9}, {3.388405465429489*^9, 
  3.388405468568237*^9}, {3.388409309140423*^9, 3.388409346955918*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"x", "[", 
       RowBox[{"0", ",", "0"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"0", ",", "1"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"0", ",", "2"}], "]"}]},
     {
      RowBox[{"x", "[", 
       RowBox[{"1", ",", "0"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"1", ",", "1"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"1", ",", "2"}], "]"}]},
     {
      RowBox[{"x", "[", 
       RowBox[{"2", ",", "0"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"2", ",", "1"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{"2", ",", "2"}], "]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Die zweite M\[ODoubleDot]glichkeit: x mit Subscript-Indizes\
\>", "SmallText",
 CellChangeTimes->{{3.3566272831412*^9, 3.35662729056033*^9}, {
  3.388402847170167*^9, 3.388402866049031*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"i", ",", "j"}]], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.388409369873056*^9, 3.388409380743565*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["x", 
       RowBox[{"0", ",", "0"}]], 
      SubscriptBox["x", 
       RowBox[{"0", ",", "1"}]], 
      SubscriptBox["x", 
       RowBox[{"0", ",", "2"}]]},
     {
      SubscriptBox["x", 
       RowBox[{"1", ",", "0"}]], 
      SubscriptBox["x", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["x", 
       RowBox[{"1", ",", "2"}]]},
     {
      SubscriptBox["x", 
       RowBox[{"2", ",", "0"}]], 
      SubscriptBox["x", 
       RowBox[{"2", ",", "1"}]], 
      SubscriptBox["x", 
       RowBox[{"2", ",", "2"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Aber beachten Sie, dass es sich auch hierbei um zusammengesetzte Bezeichner \
handelt!\
\>", "SmallText",
 CellChangeTimes->{{3.35662730752292*^9, 3.35662732213685*^9}, {
  3.388409431413052*^9, 3.388409435781635*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.388409406695901*^9, 3.388409407481087*^9}}],

Cell["\<\
{{Subscript[x, 0, 0], Subscript[x, 0, 1], Subscript[x, 0, 2]}, 
 {Subscript[x, 1, 0], Subscript[x, 1, 1], Subscript[x, 1, 2]}, 
 {Subscript[x, 2, 0], Subscript[x, 2, 1], Subscript[x, 2, 2]}}\
\>", "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auf einzelne Matrixelemente zugreifen", "Subsection",
 CellChangeTimes->{{3.35464336898686*^9, 3.35464337263787*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b", "c", "d"},
      {"e", "f", "g", "h"},
      {"i", "j", "k", "l"}
     }], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.38797036267026*^9, {3.388396948276271*^9, 3.388396980239339*^9}, {
   3.388397072516185*^9, 3.388397075646106*^9}, {3.388397115980092*^9, 
   3.388397119344919*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "\[LeftDoubleBracket]", 
  RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}]], "Input",
 CellChangeTimes->{3.387970364235021*^9}],

Cell[BoxData["g"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Achtung, das ist die zweite Zeile obiger Matrix, aber ein Vektor und von ",
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " als Spaltenvektor dargestellt. "
}], "SmallText",
 CellChangeTimes->{{3.35662735943868*^9, 3.35662740185557*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], " ", 
  "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{3.387970368328846*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"e"},
      {"f"},
      {"g"},
      {"h"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "mat", "]"}], "\[LeftDoubleBracket]", "2", 
   "\[RightDoubleBracket]"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{3.387970370615101*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"b"},
      {"f"},
      {"j"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3"}], "}"}]}], "\[RightDoubleBracket]"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.387970290169791*^9, 3.387970389391142*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"e", "h", "g"},
     {"i", "l", "k"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"2", ";;", "3"}], ",", 
    RowBox[{"1", ";;", "4"}]}], "\[RightDoubleBracket]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.387970290169791*^9, 3.387970389391142*^9}, {
  3.388396846085384*^9, 3.388396891013654*^9}, {3.388397155404086*^9, 
  3.388397158095708*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"e", "f", "g", "h"},
     {"i", "j", "k", "l"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"2", ",", "3"}], "]"}], ",", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", "4"}], "]"}]}], "\[RightDoubleBracket]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.3884183049729*^9, 3.388418334594627*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"e", "f", "g", "h"},
     {"i", "j", "k", "l"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mit Matrizen rechnen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.3546435000076*^9, 3.35464350759723*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b"},
      {"c", "c"},
      {"e", "f"}
     }], ")"}]}], ";", " ", 
  RowBox[{"mat2", "=", 
   RowBox[{"(", GridBox[{
      {"r", "s", "t"},
      {"u", "v", "w"}
     }], ")"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "mat1"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"3", " ", "a"}], 
      RowBox[{"3", " ", "b"}]},
     {
      RowBox[{"3", " ", "c"}], 
      RowBox[{"3", " ", "c"}]},
     {
      RowBox[{"3", " ", "e"}], 
      RowBox[{"3", " ", "f"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat2", " ", "+", " ", 
   RowBox[{"Transpose", "[", "mat1", "]"}]}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a", "+", "r"}], 
      RowBox[{"c", "+", "s"}], 
      RowBox[{"e", "+", "t"}]},
     {
      RowBox[{"b", "+", "u"}], 
      RowBox[{"c", "+", "v"}], 
      RowBox[{"f", "+", "w"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat1", " ", ".", " ", "mat2"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"a", " ", "r"}], "+", 
       RowBox[{"b", " ", "u"}]}], 
      RowBox[{
       RowBox[{"a", " ", "s"}], "+", 
       RowBox[{"b", " ", "v"}]}], 
      RowBox[{
       RowBox[{"a", " ", "t"}], "+", 
       RowBox[{"b", " ", "w"}]}]},
     {
      RowBox[{
       RowBox[{"c", " ", "r"}], "+", 
       RowBox[{"c", " ", "u"}]}], 
      RowBox[{
       RowBox[{"c", " ", "s"}], "+", 
       RowBox[{"c", " ", "v"}]}], 
      RowBox[{
       RowBox[{"c", " ", "t"}], "+", 
       RowBox[{"c", " ", "w"}]}]},
     {
      RowBox[{
       RowBox[{"e", " ", "r"}], "+", 
       RowBox[{"f", " ", "u"}]}], 
      RowBox[{
       RowBox[{"e", " ", "s"}], "+", 
       RowBox[{"f", " ", "v"}]}], 
      RowBox[{
       RowBox[{"e", " ", "t"}], "+", 
       RowBox[{"f", " ", "w"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b", "c"},
      {"d", "e", "f"},
      {"g", "h", "i"}
     }], ")"}]}], ";", " ", 
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35663064417879*^9, 3.35663064515475*^9}, {
  3.35856657754603*^9, 3.35856657870574*^9}}],

Cell[TextData[{
 "Bei der Multiplikation mit einer Matrix von links wird ein Vektor als \
Zeilenvektor, bei der Multiplikation von rechts als Spaltenvektor \
interpretiert.  In beiden F\[ADoubleDot]llen wird ein Vektor erzeugt, der im \
ersten Fall aber von ",
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " als Spaltenvektor und nicht als Zeilenvektor dargestellt wird."
}], "SmallText",
 CellChangeTimes->{{3.35464363231653*^9, 3.3546436927707*^9}, {
  3.35464378635233*^9, 3.35464384221892*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", " ", ".", " ", "mat"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35663065122827*^9, 3.35663065262919*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"a", " ", "u"}], "+", 
        RowBox[{"d", " ", "v"}], "+", 
        RowBox[{"g", " ", "w"}]}]},
      {
       RowBox[{
        RowBox[{"b", " ", "u"}], "+", 
        RowBox[{"e", " ", "v"}], "+", 
        RowBox[{"h", " ", "w"}]}]},
      {
       RowBox[{
        RowBox[{"c", " ", "u"}], "+", 
        RowBox[{"f", " ", "v"}], "+", 
        RowBox[{"i", " ", "w"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", " ", ".", " ", "vec"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35663065478881*^9, 3.35663065505418*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"a", " ", "u"}], "+", 
        RowBox[{"b", " ", "v"}], "+", 
        RowBox[{"c", " ", "w"}]}]},
      {
       RowBox[{
        RowBox[{"d", " ", "u"}], "+", 
        RowBox[{"e", " ", "v"}], "+", 
        RowBox[{"f", " ", "w"}]}]},
      {
       RowBox[{
        RowBox[{"g", " ", "u"}], "+", 
        RowBox[{"h", " ", "v"}], "+", 
        RowBox[{"i", " ", "w"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Besser ist es deshalb, wenn Sie in diesen F\[ADoubleDot]llen nicht mit \
Vektoren, sondern mit einzeiligen oder einspaltigen Matrizen rechnen. Eine \
einzeilige Matrix l\[ADoubleDot]sst sich aus einem Vektor einfach durch zus\
\[ADoubleDot]tzliche Listenklammern herstellen, eine einspaltige Matrix durch \
",
 StyleBox["List/@...",
  FontWeight->"Bold"],
 " . Das Produkt wird nun von ",
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " auch wie erwartet dargestellt. "
}], "SmallText",
 CellChangeTimes->{{3.35464384593001*^9, 3.35464397704927*^9}, {
  3.3566309349305*^9, 3.35663093567768*^9}, {3.35663099245506*^9, 
  3.3566310466927*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"esm", "=", 
    RowBox[{"List", "/@", "vec"}]}], ")"}], "//", "MatrixForm"}], "\n", 
 RowBox[{
  RowBox[{"mat", ".", "esm"}], " ", "//", "MatrixForm"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "esm", "]"}], ".", " ", "mat"}], " ", "//", 
  "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.35464371491509*^9, 3.35464371930597*^9}, {
   3.35663066538681*^9, 3.35663066595576*^9}, {3.35663070844244*^9, 
   3.35663091744949*^9}, {3.35663105415498*^9, 3.35663107762228*^9}, 
   3.35856650061956*^9, {3.35856653940113*^9, 3.3585666149232*^9}, {
   3.35856978362283*^9, 3.35856979384399*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"u"},
     {"v"},
     {"w"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"a", " ", "u"}], "+", 
       RowBox[{"b", " ", "v"}], "+", 
       RowBox[{"c", " ", "w"}]}]},
     {
      RowBox[{
       RowBox[{"d", " ", "u"}], "+", 
       RowBox[{"e", " ", "v"}], "+", 
       RowBox[{"f", " ", "w"}]}]},
     {
      RowBox[{
       RowBox[{"g", " ", "u"}], "+", 
       RowBox[{"h", " ", "v"}], "+", 
       RowBox[{"i", " ", "w"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"a", " ", "u"}], "+", 
       RowBox[{"d", " ", "v"}], "+", 
       RowBox[{"g", " ", "w"}]}], 
      RowBox[{
       RowBox[{"b", " ", "u"}], "+", 
       RowBox[{"e", " ", "v"}], "+", 
       RowBox[{"h", " ", "w"}]}], 
      RowBox[{
       RowBox[{"c", " ", "u"}], "+", 
       RowBox[{"f", " ", "v"}], "+", 
       RowBox[{"i", " ", "w"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", 
       RowBox[{"-", "5"}], "6"},
      {"9", "8", "7"}
     }], ")"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "mat1", "]"}]], "Input"],

Cell[BoxData["200"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat2", "=", 
   RowBox[{"Inverse", "[", "mat1", "]"}]}], ";", " ", 
  RowBox[{"mat2", " ", "//", "MatrixForm"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["83", "200"]}], 
      FractionBox["1", "20"], 
      FractionBox["27", "200"]},
     {
      FractionBox["13", "100"], 
      RowBox[{"-", 
       FractionBox["1", "10"]}], 
      FractionBox["3", "100"]},
     {
      FractionBox["77", "200"], 
      FractionBox["1", "20"], 
      RowBox[{"-", 
       FractionBox["13", "200"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPower", "[", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b"},
       {"c", "d"}
      }], ")"}], ",", " ", "3"}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"b", " ", "c"}]}], ")"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{"c", " ", "d"}]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "b"}], "+", 
          RowBox[{"b", " ", "d"}]}], ")"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "c"}], "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}]},
     {
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"b", " ", "c"}]}], ")"}]}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{"c", " ", "d"}]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "b"}], "+", 
          RowBox[{"b", " ", "d"}]}], ")"}]}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "c"}], "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPower", "[", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"1", "2"},
       {"3", "4"}
      }], ")"}], ",", " ", "20"}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"95799031216999", "139620104992450"},
     {"209430157488675", "305229188705674"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixExp", "[", 
   RowBox[{"(", GridBox[{
      {"0.1", "0.2"},
      {"0.3", "0.4"}
     }], ")"}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.1420935489195727`", "0.26035074754069265`"},
     {"0.3905261213110389`", "1.5326196702306114`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"MatrixPower", "[", 
      RowBox[{
       RowBox[{"(", GridBox[{
          {"0.1", "0.2"},
          {"0.3", "0.4"}
         }], ")"}], ",", "i"}], "]"}], 
     RowBox[{"i", "!"}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.3546441428813*^9, 3.35464415409144*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.1420849166666667`", "0.2603381666666667`"},
     {"0.39050725`", "1.5325921666666666`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["D\[UDoubleDot]nn besetzte Matrizen", "Section",
 CellChangeTimes->{{3.388417997512327*^9, 3.388418038908612*^9}}],

Cell[TextData[{
 "Gro\[SZ]e Matrizen (und allgemeiner Tensoren) k\[ODoubleDot]nnen mit ",
 StyleBox["SparseArray",
  FontWeight->"Bold"],
 " erzeugt werden.\nDiese d\[UDoubleDot]nne Darstellung verwendet intern eine \
andere Speicherform als die bisher betrachtete dichte Darstellung von \
Matrizen."
}], "SmallText",
 CellChangeTimes->{{3.388402899470959*^9, 3.388402952526662*^9}, {
   3.388416849915383*^9, 3.388416981487954*^9}, 3.388417043846337*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "4"}]}], "}"}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388415882014799*^9, 3.388415883265332*^9}, {
  3.388416447025492*^9, 3.388416448685906*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "4"},
     {"0", "2", "0", "0", "0"},
     {"0", "0", "3", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {3, 5}, 0, {
     1, {{0, 2, 3, 4}, {{1}, {5}, {2}, {3}}}, {1, 4, 2, 3}}]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "4"}]}], "}"}], ",", "5", 
    ",", "x"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388415763489433*^9, 3.388415844982011*^9}, {
  3.388416465445933*^9, 3.388416478738977*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "x", "x", "x", "4"},
     {"x", "2", "x", "x", "x"},
     {"x", "x", "3", "x", "x"},
     {"x", "x", "x", "x", "x"},
     {"x", "x", "x", "x", "x"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, $CellContext`x, {
     1, {{0, 2, 3, 4, 4, 4}, {{1}, {5}, {2}, {3}}}, {1, 4, 2, 
      3}}]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_", ",", "i_"}], "}"}], "->", "2"}], "}"}], ",", 
    "3"}], "]"}], "//", "TensorRank"}]], "Input",
 CellChangeTimes->{{3.388416711674093*^9, 3.388416809449733*^9}}],

Cell[BoxData["3"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}], "}"}], ",", "100"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.388402058936471*^9, 3.388402085168126*^9}, 
   3.388402310420872*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "100", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 100, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", 
  RowBox[{"{", 
   RowBox[{"m", ",", 
    RowBox[{"IdentityMatrix", "[", "100", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.388402111845301*^9, 3.38840231383557*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1656", ",", "40080"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "\[Equal]", 
  RowBox[{"IdentityMatrix", "[", "100", "]"}]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "+", 
   RowBox[{"IdentityMatrix", "[", "100", "]"}]}], "//", "Shallow"}]], "Input",\

 CellChangeTimes->{{3.388410626942874*^9, 3.388410629216228*^9}, {
  3.388410678361852*^9, 3.388410699837553*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2",
      ",", "0", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "2", ",", "0", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "2", ",", 
     RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "\[Rule]", "2"}], "}"}], 
    ",", "10"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388404366330223*^9, 3.388404410117987*^9}, {
  3.388404601963774*^9, 3.388404757090385*^9}, {3.388404826799876*^9, 
  3.388404868204702*^9}, {3.388404916630098*^9, 3.388404932539763*^9}, {
  3.38840498701661*^9, 3.388405030730197*^9}, {3.388405405122549*^9, 
  3.388405416504605*^9}, {3.388405481430343*^9, 3.388405517720421*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "2", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "2", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "2", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "2", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "2", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "2", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "2", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "2", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "2"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {10, 10}, 0, {
     1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {{1}, {2}, {3}, {4}, {5}, {6}, {
       7}, {8}, {9}, {10}}}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}}]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", "10"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388404366330223*^9, 3.388404410117987*^9}, {
  3.388404601963774*^9, 3.388404757090385*^9}, {3.388404826799876*^9, 
  3.388404868204702*^9}, {3.388404916630098*^9, 3.388404932539763*^9}, {
  3.38840498701661*^9, 3.3884049888197*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "1", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "2", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "2", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "2", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "2", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {10, 10}, 0, {
     1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {{1}, {2}, {3}, {4}, {5}, {6}, {
       7}, {8}, {9}, {10}}}, {2, 1, 2, 1, 2, 1, 2, 1, 2, 1}}]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[Rule]", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"m", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.388404366330223*^9, 3.388404410117987*^9}, {
  3.388404601963774*^9, 3.388404757090385*^9}, {3.388404826799876*^9, 
  3.388404868204702*^9}, {3.388404916630098*^9, 3.388404932539763*^9}, {
  3.388405044466926*^9, 3.388405048381427*^9}, {3.388405557367668*^9, 
  3.388405567395705*^9}, {3.388406673194089*^9, 3.388406738135728*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "2", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "2", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "2", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "2", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 10}, 0, {
     1, {{0, 1, 2, 3, 4, 5}, {{1}, {3}, {5}, {7}, {9}}}, {2, 2, 2, 2, 
      2}}]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "//", "ArrayRules"}]], "Input",
 CellChangeTimes->{{3.388405421709444*^9, 3.388405434584054*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "7"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "9"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sparsemat", ":=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "2"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "1"}]}], "}"}], 
     ",", "n"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.388405195251311*^9, 3.388405231279466*^9}, {
  3.388407888062723*^9, 3.388407893962496*^9}, {3.388413271122929*^9, 
  3.388413344337377*^9}, {3.388413384629726*^9, 3.388413407224919*^9}, {
  3.38841346260664*^9, 3.388412875607566*^9}, {3.388412973308769*^9, 
  3.388412985284624*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "5"}], "}"}], ",", 
   RowBox[{"sparsemat", "//", "MatrixForm"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.388413682271654*^9, 3.388413906648613*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "1", "0", "0", "0"},
     {"1", "2", "1", "0", "0"},
     {"0", "1", "2", "1", "0"},
     {"0", "0", "1", "2", "1"},
     {"0", "0", "0", "1", "2"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 2, 5, 8, 11, 13}, {{2}, {1}, {2}, {3}, {1}, {3}, {4}, {2}, {4}, {
       5}, {3}, {4}, {5}}}, {1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 
      2}}]]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "=", "#"}], ";", 
     RowBox[{"ByteCount", "/@", 
      RowBox[{"{", 
       RowBox[{"sparsemat", ",", 
        RowBox[{"sparsemat", "//", "Normal"}]}], "}"}]}]}], ")"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"10", ",", "20", ",", "50"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.388413223934214*^9, 3.388413230164698*^9}, {
  3.388413506088732*^9, 3.388413534213648*^9}, {3.388413564677396*^9, 
  3.388413724651474*^9}, {3.388413765386848*^9, 3.388409572664346*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"736", ",", "480"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1016", ",", "1680"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1856", ",", "10080"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lineare Gleichungssysteme l\[ODoubleDot]sen", "Section",
 CellChangeTimes->{{3358652743.52556, 3358652744.81013}}],

Cell[TextData[{
 "Die einfachste und allgemeinste Weg zum L\[ODoubleDot]sen eines linearen \
Gleichungssystems geht \[UDoubleDot]ber die ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Funktion. \[CapitalUDoubleDot]ber die ausgegebenen Warnungen muss man sich \
keine Gedanken machen.Wir verwenden im Gegensatz zum ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Handbuch die Notation der Vektoren als einspaltige Matrizen."
}], "SmallText",
 CellChangeTimes->{{3358652655.12218, 3358652774.07678}, {3358652959.5341, 
  3358652994.75142}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3", "1"},
      {"3", "1", "2", 
       RowBox[{"-", "1"}]},
      {"2", "3", "1", "0"}
     }], ")"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"(", GridBox[{
      {"14"},
      {"12"},
      {"7"}
     }], ")"}]}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"(", GridBox[{
      {"x1"},
      {"x2"},
      {"x3"},
      {"x4"}
     }], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35857169851264*^9, 3.35857177080088*^9}, {
  3.35857217294834*^9, 3.35857217578182*^9}, {3.35857222072866*^9, 
  3.35857227270377*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35857016701897*^9, 3.35857017090084*^9}, {
  3.35857177853777*^9, 3.35857180537616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x1", "\[Rule]", 
     RowBox[{
      FractionBox["7", "6"], "+", 
      FractionBox[
       RowBox[{"2", " ", "x4"}], "3"]}]}], ",", 
    RowBox[{"x2", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], "-", 
      FractionBox["x4", "3"]}]}], ",", 
    RowBox[{"x3", "\[Rule]", 
     RowBox[{
      FractionBox["25", "6"], "-", 
      FractionBox["x4", "3"]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Solve-Funktion gibt als Anwort eine Substitutionsliste \
zur\[UDoubleDot]ck, aus der sich die allgemeine L\[ODoubleDot]sung durch \
Substitution in die einspaltige Matrix ",
 StyleBox["x",
  FontWeight->"Bold"],
 " gewinnen l\[ADoubleDot]sst. Beachten Sie, dass die L\[ODoubleDot]sung eine \
einelementige ",
 StyleBox["Menge",
  FontSlant->"Italic"],
 " ist."
}], "SmallText",
 CellChangeTimes->{{3.35865279637057*^9, 3.35865294148766*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "/.", "sol"}], "/.", 
    RowBox[{"x4", "\[Rule]", "t"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.35857180901215*^9, 3.35857187356302*^9}, {
  3.35857404024004*^9, 3.35857406112246*^9}, {3.35865443553511*^9, 
  3.35865448063429*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{
        FractionBox["7", "6"], "+", 
        FractionBox[
         RowBox[{"2", " ", "t"}], "3"]}]},
      {
       RowBox[{
        FractionBox["1", "6"], "-", 
        FractionBox["t", "3"]}]},
      {
       RowBox[{
        FractionBox["25", "6"], "-", 
        FractionBox["t", "3"]}]},
      {"t"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Gelegentlich muss die Menge der Variablen angegeben werden, etwa wenn die \
Ausdr\[UDoubleDot]cke noch weitere Parameter enthalten. Diese \
m\[UDoubleDot]ssen dazu aus ",
 StyleBox["x",
  FontWeight->"Bold"],
 " extrahiert werden.  "
}], "SmallText",
 CellChangeTimes->{{3.35865300590346*^9, 3.35865308382804*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vars", "=", 
  RowBox[{"Flatten", "[", "x", "]"}]}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], ",", "vars"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.35857326385022*^9, 3.35857327075319*^9}, {
  3.35857330672971*^9, 3.35857331245965*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x1", "\[Rule]", 
     RowBox[{
      FractionBox["7", "6"], "+", 
      FractionBox[
       RowBox[{"2", " ", "x4"}], "3"]}]}], ",", 
    RowBox[{"x2", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], "-", 
      FractionBox["x4", "3"]}]}], ",", 
    RowBox[{"x3", "\[Rule]", 
     RowBox[{
      FractionBox["25", "6"], "-", 
      FractionBox["x4", "3"]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Lineare Gleichungssysteme lassen sich auch mit dem Kommando ",
 StyleBox["LinearSolve",
  FontWeight->"Bold"],
 " l\[ODoubleDot]sen. Dieses ist besonders dann angebracht, wenn es sich um \
gro\[SZ]e lineare Gleichungssysteme handelt oder ein und dasselbe System mit \
vielen verschiedenen rechten Seiten gel\[ODoubleDot]st werden soll. \nEs gibt \
zwei Aufrufvarianten des Kommandos ",
 StyleBox["LinearSolve",
  FontWeight->"Bold"],
 ". Die erste Variante ",
 StyleBox["LinearSolve[mat] ",
  FontWeight->"Bold"],
 "bekommt nur die Koeffizientenmatrix als  Parameter \[UDoubleDot]bergeben \
und generiert daraus ein ",
 StyleBox["LinearSolveFunction",
  FontWeight->"Bold"],
 "-Objekt."
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, 3.35865386937932*^9, 
   3.35865489250533*^9, {3.35865499438126*^9, 3.35865499584768*^9}, {
   3.35865517295396*^9, 3.35865519226922*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lsol", "=", 
  RowBox[{"LinearSolve", "[", "mat", "]"}]}]], "Input",
 CellChangeTimes->{
  3.35857020049414*^9, {3.35857271914962*^9, 3.35857272012829*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"sqmat1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The matrix \\!\\({\\(\\({1, 2, 3, 1}\\)\\), \\(\\({3, 1, \
2, \\(\\(-1\\)\\)}\\)\\), \\(\\({2, 3, 1, 0}\\)\\)}\\) is not square so a \
factorization will not be saved.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Es handelt sich dabei wie bei einer ",
 StyleBox["InterpolatingFunction",
  FontWeight->"Bold"],
 " um eine namenlose Funktion, von der auch die Berechnungsvorschrift nicht \
explizit bekannt ist. Sie berechnet zu einer vorgegebenen rechten Seite ",
 StyleBox["b",
  FontWeight->"Bold"],
 " eine L\[ODoubleDot]sung des Gleichungssystems."
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, 3.35865386937932*^9, 
   3.35865489250533*^9, {3.35865499438126*^9, 3.35865499584768*^9}, {
   3.35865518093976*^9, 3.35865520311125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"lsol", "[", "b", "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35857272352404*^9, 3.35857274042781*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["7", "6"]},
     {
      FractionBox["1", "6"]},
     {
      FractionBox["25", "6"]},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die zweite Aufrufvariante  ",
 StyleBox["LinearSolve[mat,b] ",
  FontWeight->"Bold"],
 "bekommt als zweiten Parameter die rechte Seite \[UDoubleDot]bergeben und \
entspricht dem Aufruf ",
 StyleBox["LinearSolve[mat][b]. ",
  FontWeight->"Bold"]
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, 3.35865386937932*^9, 
   3.35865489250533*^9, {3.35865499438126*^9, 3.35865499584768*^9}, 
   3.35865520939116*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"l0", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"mat", ",", "b"}], "]"}]}], ")"}], "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.35857017786415*^9, 3.35857018033564*^9}, {
  3.3586524045888*^9, 3.35865241522429*^9}, {3.35865381809516*^9, 
  3.35865382033892*^9}, {3.35865414152423*^9, 3.35865414476544*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["7", "6"]},
     {
      FractionBox["1", "6"]},
     {
      FractionBox["25", "6"]},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Im Gegensatz zu ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " gibt ",
 StyleBox["LinearSolve",
  FontWeight->"Bold"],
 " (im Fall eines l\[ODoubleDot]sbaren Systems) immer nur eine spezielle L\
\[ODoubleDot]sung zur\[UDoubleDot]ck. Da die allgemeine L\[ODoubleDot]sung \
eines linearen Gleichungssystems sich zusammensetzt aus einer solchen \
speziellen L\[ODoubleDot]sung und der allgemeinen L\[ODoubleDot]sung des \
zugeh\[ODoubleDot]rigen homogenen linearen Gleichungssystems, bleibt eine \
Basis des L\[ODoubleDot]sungsraums des homogenen Systems zu bestimmen. Dies \
kann mit dem Kommando ",
 StyleBox["NullSpace",
  FontWeight->"Bold"],
 " erfolgen.  "
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, {3.35865387680041*^9, 
   3.3586539331338*^9}, {3.3586539679735*^9, 3.3586540446349*^9}, 
   3.3586541744818*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"ns", "=", 
    RowBox[{"NullSpace", "[", "mat", "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.3586537537539*^9, 3.35865378587705*^9}, {
  3.35865382402268*^9, 3.35865382791245*^9}, {3.35865408873657*^9, 
  3.35865412621901*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", 
    TagBox[GridBox[{
       {"2"},
       {
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "1"}]},
       {"3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.5599999999999999]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Column], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Beachten Sie, dass ",
 StyleBox["NullSpace",
  FontWeight->"Bold"],
 " eine Liste von ",
 StyleBox["Vektoren",
  FontSlant->"Italic"],
 " und nicht von ",
 StyleBox["einspaltigen Matrizen ",
  FontSlant->"Italic"],
 "zur\[UDoubleDot]ckgibt, so dass noch einige Transformationen erforderlich \
sind, um daraus die allgemeine L\[ODoubleDot]sung zu extrahieren. "
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
  3.3586534398062*^9, 3.35865372430013*^9}, {3.35865387680041*^9, 
  3.3586539331338*^9}, {3.3586539679735*^9, 3.3586540446349*^9}, {
  3.35865417975986*^9, 3.35865419282355*^9}, {3.35865449448116*^9, 
  3.35865459990464*^9}, {3.35865465879999*^9, 3.35865470311631*^9}, {
  3.35865773425295*^9, 3.35865773524704*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ".", "ns"}], "}"}], "//", "Transpose"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865421138221*^9, 3.3586543142061*^9}, {
  3.35865434443796*^9, 3.35865437111272*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", " ", "t"}]},
     {
      RowBox[{"-", "t"}]},
     {
      RowBox[{"-", "t"}]},
     {
      RowBox[{"3", " ", "t"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"l0", "+", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ".", "ns"}], "}"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865413041175*^9, 3.35865413355736*^9}, {
  3.35865438562387*^9, 3.35865441974542*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["7", "6"], "+", 
       RowBox[{"2", " ", "t"}]}]},
     {
      RowBox[{
       FractionBox["1", "6"], "-", "t"}]},
     {
      RowBox[{
       FractionBox["25", "6"], "-", "t"}]},
     {
      RowBox[{"3", " ", "t"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Und hier noch ein Beispiel mit einer mehrdimensionalen \
L\[ODoubleDot]sungsraum.\
\>", "SmallText",
 CellChangeTimes->{{3.35865795499313*^9, 3.35865797741762*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3", "1"},
      {"3", "1", "2", 
       RowBox[{"-", "1"}]}
     }], ")"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"(", GridBox[{
      {"14"},
      {"12"}
     }], ")"}]}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"(", GridBox[{
      {"x1"},
      {"x2"},
      {"x3"},
      {"x4"}
     }], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35857169851264*^9, 3.35857177080088*^9}, {
  3.35857217294834*^9, 3.35857217578182*^9}, {3.35857222072866*^9, 
  3.35857227270377*^9}, {3.35865791191847*^9, 3.35865791640448*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"l0", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"mat", ",", "b"}], "]"}]}], ")"}], "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2"},
     {"6"},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"ns", "=", 
    RowBox[{"NullSpace", "[", "mat", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3"},
        {
         RowBox[{"-", "4"}]},
        {"0"},
        {"5"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "1"}]},
        {
         RowBox[{"-", "7"}]},
        {"5"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t1", ",", "t2"}], "}"}], ".", "ns"}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"3", " ", "t1"}], "-", "t2"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", "t1"}], "-", 
       RowBox[{"7", " ", "t2"}]}]},
     {
      RowBox[{"5", " ", "t2"}]},
     {
      RowBox[{"5", " ", "t1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"l0", "+", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t1", ",", "t2"}], "}"}], ".", "ns"}], "}"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865801490474*^9, 3.35865802679471*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", "+", 
       RowBox[{"3", " ", "t1"}], "-", "t2"}]},
     {
      RowBox[{"6", "-", 
       RowBox[{"4", " ", "t1"}], "-", 
       RowBox[{"7", " ", "t2"}]}]},
     {
      RowBox[{"5", " ", "t2"}]},
     {
      RowBox[{"5", " ", "t1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Es geht allerdings auch einfacher, da die Summe einer einspaltigen Matrix und \
eines Vektors berechnet werden kann und wieder eine einspaltige Matric \
ergibt.\
\>", "SmallText",
 CellChangeTimes->{{3.35866053277858*^9, 3.35866058934788*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"l0", "+", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t1", ",", "t2"}], "}"}], ".", "ns"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865999950662*^9, 3.3586600101839*^9}, {
  3.35866005197154*^9, 3.35866008404596*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", "+", 
       RowBox[{"3", " ", "t1"}], "-", "t2"}]},
     {
      RowBox[{"6", "-", 
       RowBox[{"4", " ", "t1"}], "-", 
       RowBox[{"7", " ", "t2"}]}]},
     {
      RowBox[{"5", " ", "t2"}]},
     {
      RowBox[{"5", " ", "t1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
Und nun noch einmal Matrizen in d\[UDoubleDot]nner Darstellung.\
\>", "SmallText",
 CellChangeTimes->{{3.388417296010137*^9, 3.388417340612983*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"m", ",", "n", ",", "x", ",", "b"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", ":=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "2"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "1"}]}], "}"}], 
     ",", "n"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vx", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.388405195251311*^9, 3.388405231279466*^9}, {
  3.388407888062723*^9, 3.388407893962496*^9}, {3.388413271122929*^9, 
  3.388413344337377*^9}, {3.388413384629726*^9, 3.388413407224919*^9}, {
  3.38841346260664*^9, 3.388412875607566*^9}, {3.388412973308769*^9, 
  3.388412985284624*^9}, {3.388417422684388*^9, 3.388417487774962*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "=", "#"}], ";", 
     RowBox[{"Det", "[", "m", "]"}]}], ")"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"5", ",", "15"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.38841772573443*^9, 3.388417801361173*^9}, {
  3.388421079223832*^9, 3.388421080992675*^9}, {3.388422151408666*^9, 
  3.38842217500108*^9}, {3.388422210517702*^9, 3.388422212317177*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", "7", ",", "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", 
   "13", ",", "14", ",", "15", ",", "16"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Rechnung legt nahe, dass die Determinante gleich ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]]],
 " ist. Zum Beweis dieser Beziehung muss aus der Definition der Determinante \
eine Rekursionsbeziehung hergeleitet werden, die zusammen mit den \
entsprechenden Startwerten dann von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gel\[ODoubleDot]st werden kann."
}], "SmallText",
 CellChangeTimes->{{3.388422250887229*^9, 3.388422560310745*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "n", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"d", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], "-", 
       RowBox[{"d", "[", 
        RowBox[{"n", "-", "2"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"d", "[", "1", "]"}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{"d", "[", "2", "]"}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"d", "[", "n", "]"}], ",", "n"}], "]"}]}], "Input",
 CellChangeTimes->{{3.388421894573548*^9, 3.388422133240942*^9}, {
  3.388422185749061*^9, 3.388422244227123*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"d", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"1", "+", "n"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "100"}], ";", 
    RowBox[{"sol1", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"m", ".", "vx"}], "==", "b"}], ",", "vx"}], "]"}]}], ";"}], 
   ")"}], "//", "Timing"}]], "Input",
 CellChangeTimes->{{3.388393781907393*^9, 3.388393826387709*^9}, 
   3.388394055610569*^9, {3.388394127267804*^9, 3.38839412877967*^9}, {
   3.38839436440316*^9, 3.388394417636768*^9}, 3.388394480233984*^9, {
   3.388394731843327*^9, 3.388394760989847*^9}, 3.388403980278135*^9, 
   3.388404579092726*^9, 3.388404633546138*^9, 3.388407493388757*^9, {
   3.388407538861857*^9, 3.38840754184186*^9}, {3.388417571869402*^9, 
   3.388417572622283*^9}, {3.388418925610679*^9, 3.388418942507562*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "Null"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"vx", "/.", "sol1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.388403901340141*^9, 3.388403941550554*^9}, {
  3.388404261392629*^9, 3.388404274481972*^9}, {3.388404416824658*^9, 
  3.388404418261565*^9}, {3.388404467723196*^9, 3.388404469293966*^9}, {
  3.388404963797136*^9, 3.388404994690466*^9}, {3.388407367297989*^9, 
  3.388407369718864*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlVtIVFEYhTcDUURQwTwkSlSE2BW7mGXW+cfLaOM4zpnrkRBCkqCXIHqx
h9hQD0UEQQVBVBBCGCEEIYgx7LBiSszupd0IIogifJR66RxnnYe1B4bhm7XP
3v/+L+us7T+WGYgopQ773+C38plzrp44uvr7yFcHf8i/mf6B+fgZ8BIp9zkH
7y4L9RXQL4OjMh+P+lt8Aa8C3wDXyIb6n2+ay5/Ba/D8EHid9FaVVi6qDfX1
cvLi+KlRbxhcK+cil1JTpz+B67D/CHijjP06cv7Kt4/gzfLAf7qqdA+8VYLT
+5xQr8f598HbZOH467Pg7dLUsPz4++lR8A5J3P4R+/N3BrwT8Y2BG8Chvgvx
jIMb5c5gsOADeDfiL4H3yGwQTjTUm6TGPfRqeNCA98rS5EJE4Gbc7yF4H+J9
B94vQbHORibAjgTVvbkl1AX3f1RhLXJtcRDxW+gx8GPoMZmcu1DnlxB6C857
Ar0F+4V6K+5Tht4qmyYab5mh19DbkK+n0NsQb6i3ox7PoLeLn8xqPyXQ48jv
JPQ48vESegf6aQp6h/wOlleHeify/xx6J/L9AvoBqczDNHSLVYLX6wTvp7r4
PN3F8agkx6uTfB/VzffV3ZwPleJ86RTnU/VwvnUP10OluV6StuqZ5nqbNPeD
crlfxLX6yeV+M67VjxnuV8lwP+sM97vJWPOQ5XmRLM+TzvK8maw1jzmeV8nx
POscz7vJWX6QZ7+QPPuJzrPfmLzlRwX2Kymwn+kC+50pWH5YZL+UIvupLrLf
mqLlxx77tXjs59pjvzee9T7olfB98R/hKOE1
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 0.49504950495049505`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "100"}], ";", 
    RowBox[{"sol2", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"m", ",", "b"}], "]"}]}], ";"}], ")"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{{3.388393781907393*^9, 3.388393826387709*^9}, 
   3.388394055610569*^9, {3.388394127267804*^9, 3.38839412877967*^9}, {
   3.38839436440316*^9, 3.388394417636768*^9}, {3.388394456898857*^9, 
   3.388394486202117*^9}, {3.388394771121911*^9, 3.38839478063522*^9}, {
   3.388407122751504*^9, 3.388407123969682*^9}, {3.388407161753186*^9, 
   3.388407162589661*^9}, {3.388407239213498*^9, 3.388407248208892*^9}, {
   3.388407294072629*^9, 3.388407323732937*^9}, {3.388407379360445*^9, 
   3.388407391035347*^9}, {3.388407506336564*^9, 3.388407506946062*^9}, {
   3.388407557186571*^9, 3.388407557829658*^9}, {3.388425427317228*^9, 
   3.388425430805955*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3655743202889425`*^-14", ",", "Null"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "sol2", "]"}]], "Input",
 CellChangeTimes->{{3.388403901340141*^9, 3.388403941550554*^9}, {
  3.388404261392629*^9, 3.388404274481972*^9}, {3.388404416824658*^9, 
  3.388404418261565*^9}, {3.388404467723196*^9, 3.388404469293966*^9}, {
  3.388404963797136*^9, 3.388404994690466*^9}, {3.38840706549112*^9, 
  3.388407066015884*^9}, {3.388407271628988*^9, 3.388407281449524*^9}, {
  3.388407338675714*^9, 3.388407341493985*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlVtIVFEYhTcDUURQwTwkSlSE2BW7mGXW+cfLaOM4zpnrkRBCkqCXIHqx
h9hQD0UEQQVBVBBCGCEEIYgx7LBiSszupd0IIogifJR66RxnnYe1B4bhm7XP
3v/+L+us7T+WGYgopQ773+C38plzrp44uvr7yFcHf8i/mf6B+fgZ8BIp9zkH
7y4L9RXQL4OjMh+P+lt8Aa8C3wDXyIb6n2+ay5/Ba/D8EHid9FaVVi6qDfX1
cvLi+KlRbxhcK+cil1JTpz+B67D/CHijjP06cv7Kt4/gzfLAf7qqdA+8VYLT
+5xQr8f598HbZOH467Pg7dLUsPz4++lR8A5J3P4R+/N3BrwT8Y2BG8Chvgvx
jIMb5c5gsOADeDfiL4H3yGwQTjTUm6TGPfRqeNCA98rS5EJE4Gbc7yF4H+J9
B94vQbHORibAjgTVvbkl1AX3f1RhLXJtcRDxW+gx8GPoMZmcu1DnlxB6C857
Ar0F+4V6K+5Tht4qmyYab5mh19DbkK+n0NsQb6i3ox7PoLeLn8xqPyXQ48jv
JPQ48vESegf6aQp6h/wOlleHeify/xx6J/L9AvoBqczDNHSLVYLX6wTvp7r4
PN3F8agkx6uTfB/VzffV3ZwPleJ86RTnU/VwvnUP10OluV6StuqZ5nqbNPeD
crlfxLX6yeV+M67VjxnuV8lwP+sM97vJWPOQ5XmRLM+TzvK8maw1jzmeV8nx
POscz7vJWX6QZ7+QPPuJzrPfmLzlRwX2Kymwn+kC+50pWH5YZL+UIvupLrLf
mqLlxx77tXjs59pjvzee9T7olfB98R/hKOE1
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 0.49504950495049505`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "a", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"b", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SubscriptBox["a", "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.388406529077686*^9, 3.388406581987385*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "10"}], ";", 
    RowBox[{"sol1", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"m", ".", "vx"}], "==", "b"}], ",", "vx"}], "]"}]}], ";"}], 
   ")"}], "//", "Timing"}], "\[IndentingNewLine]", "sol1"}], "Input",
 CellChangeTimes->{
  3.388406613870429*^9, 3.388406656280715*^9, {3.388406750712912*^9, 
   3.388406753766881*^9}, {3.388406847454853*^9, 3.388406851064973*^9}, {
   3.388406885061146*^9, 3.388406897033666*^9}, {3.388407754637655*^9, 
   3.388407764537419*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.019999999999984086`", ",", "Null"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", " ", 
         SubscriptBox["a", "1"]}], "-", 
        RowBox[{"9", " ", 
         SubscriptBox["a", "2"]}], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "3"]}], "-", 
        RowBox[{"7", " ", 
         SubscriptBox["a", "4"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "5"]}], "-", 
        RowBox[{"5", " ", 
         SubscriptBox["a", "6"]}], "+", 
        RowBox[{"4", " ", 
         SubscriptBox["a", "7"]}], "-", 
        RowBox[{"3", " ", 
         SubscriptBox["a", "8"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["a", "9"]}], "-", 
        SubscriptBox["a", "10"]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "9"}], " ", 
         SubscriptBox["a", "1"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["a", "2"]}], "-", 
        RowBox[{"16", " ", 
         SubscriptBox["a", "3"]}], "+", 
        RowBox[{"14", " ", 
         SubscriptBox["a", "4"]}], "-", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "5"]}], "+", 
        RowBox[{"10", " ", 
         SubscriptBox["a", "6"]}], "-", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "7"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "8"]}], "-", 
        RowBox[{"4", " ", 
         SubscriptBox["a", "9"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SubscriptBox["a", "1"]}], "-", 
        RowBox[{"16", " ", 
         SubscriptBox["a", "2"]}], "+", 
        RowBox[{"24", " ", 
         SubscriptBox["a", "3"]}], "-", 
        RowBox[{"21", " ", 
         SubscriptBox["a", "4"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["a", "5"]}], "-", 
        RowBox[{"15", " ", 
         SubscriptBox["a", "6"]}], "+", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "7"]}], "-", 
        RowBox[{"9", " ", 
         SubscriptBox["a", "8"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "9"]}], "-", 
        RowBox[{"3", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "4"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "7"}], " ", 
         SubscriptBox["a", "1"]}], "+", 
        RowBox[{"14", " ", 
         SubscriptBox["a", "2"]}], "-", 
        RowBox[{"21", " ", 
         SubscriptBox["a", "3"]}], "+", 
        RowBox[{"28", " ", 
         SubscriptBox["a", "4"]}], "-", 
        RowBox[{"24", " ", 
         SubscriptBox["a", "5"]}], "+", 
        RowBox[{"20", " ", 
         SubscriptBox["a", "6"]}], "-", 
        RowBox[{"16", " ", 
         SubscriptBox["a", "7"]}], "+", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "8"]}], "-", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "9"]}], "+", 
        RowBox[{"4", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "5"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SubscriptBox["a", "1"]}], "-", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "2"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["a", "3"]}], "-", 
        RowBox[{"24", " ", 
         SubscriptBox["a", "4"]}], "+", 
        RowBox[{"30", " ", 
         SubscriptBox["a", "5"]}], "-", 
        RowBox[{"25", " ", 
         SubscriptBox["a", "6"]}], "+", 
        RowBox[{"20", " ", 
         SubscriptBox["a", "7"]}], "-", 
        RowBox[{"15", " ", 
         SubscriptBox["a", "8"]}], "+", 
        RowBox[{"10", " ", 
         SubscriptBox["a", "9"]}], "-", 
        RowBox[{"5", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "6"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         SubscriptBox["a", "1"]}], "+", 
        RowBox[{"10", " ", 
         SubscriptBox["a", "2"]}], "-", 
        RowBox[{"15", " ", 
         SubscriptBox["a", "3"]}], "+", 
        RowBox[{"20", " ", 
         SubscriptBox["a", "4"]}], "-", 
        RowBox[{"25", " ", 
         SubscriptBox["a", "5"]}], "+", 
        RowBox[{"30", " ", 
         SubscriptBox["a", "6"]}], "-", 
        RowBox[{"24", " ", 
         SubscriptBox["a", "7"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["a", "8"]}], "-", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "9"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "7"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SubscriptBox["a", "1"]}], "-", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "2"]}], "+", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "3"]}], "-", 
        RowBox[{"16", " ", 
         SubscriptBox["a", "4"]}], "+", 
        RowBox[{"20", " ", 
         SubscriptBox["a", "5"]}], "-", 
        RowBox[{"24", " ", 
         SubscriptBox["a", "6"]}], "+", 
        RowBox[{"28", " ", 
         SubscriptBox["a", "7"]}], "-", 
        RowBox[{"21", " ", 
         SubscriptBox["a", "8"]}], "+", 
        RowBox[{"14", " ", 
         SubscriptBox["a", "9"]}], "-", 
        RowBox[{"7", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "8"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SubscriptBox["a", "1"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "2"]}], "-", 
        RowBox[{"9", " ", 
         SubscriptBox["a", "3"]}], "+", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "4"]}], "-", 
        RowBox[{"15", " ", 
         SubscriptBox["a", "5"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["a", "6"]}], "-", 
        RowBox[{"21", " ", 
         SubscriptBox["a", "7"]}], "+", 
        RowBox[{"24", " ", 
         SubscriptBox["a", "8"]}], "-", 
        RowBox[{"16", " ", 
         SubscriptBox["a", "9"]}], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "9"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SubscriptBox["a", "1"]}], "-", 
        RowBox[{"4", " ", 
         SubscriptBox["a", "2"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "3"]}], "-", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "4"]}], "+", 
        RowBox[{"10", " ", 
         SubscriptBox["a", "5"]}], "-", 
        RowBox[{"12", " ", 
         SubscriptBox["a", "6"]}], "+", 
        RowBox[{"14", " ", 
         SubscriptBox["a", "7"]}], "-", 
        RowBox[{"16", " ", 
         SubscriptBox["a", "8"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["a", "9"]}], "-", 
        RowBox[{"9", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["x", "10"], "\[Rule]", 
     RowBox[{
      FractionBox["1", "11"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["a", "1"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SubscriptBox["a", "3"]}], "+", 
        RowBox[{"4", " ", 
         SubscriptBox["a", "4"]}], "-", 
        RowBox[{"5", " ", 
         SubscriptBox["a", "5"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["a", "6"]}], "-", 
        RowBox[{"7", " ", 
         SubscriptBox["a", "7"]}], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["a", "8"]}], "-", 
        RowBox[{"9", " ", 
         SubscriptBox["a", "9"]}], "+", 
        RowBox[{"10", " ", 
         SubscriptBox["a", "10"]}]}], ")"}]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "10"}], ";", 
    RowBox[{"sol2", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"m", ",", "b"}], "]"}]}], ";"}], ")"}], "//", 
  "Timing"}], "\[IndentingNewLine]", "sol2"}], "Input",
 CellChangeTimes->{{3.388393781907393*^9, 3.388393826387709*^9}, 
   3.388394055610569*^9, {3.388394127267804*^9, 3.38839412877967*^9}, {
   3.38839436440316*^9, 3.388394417636768*^9}, {3.388394456898857*^9, 
   3.388394486202117*^9}, {3.388394771121911*^9, 3.38839478063522*^9}, {
   3.388406950007522*^9, 3.388406973035318*^9}, {3.388407592295928*^9, 
   3.388407601517266*^9}, {3.388407783710961*^9, 3.388407793064355*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.020000000000020446`", ",", "Null"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SubscriptBox["a", "1"]}], "-", 
      RowBox[{"9", " ", 
       SubscriptBox["a", "2"]}], "+", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "3"]}], "-", 
      RowBox[{"7", " ", 
       SubscriptBox["a", "4"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "5"]}], "-", 
      RowBox[{"5", " ", 
       SubscriptBox["a", "6"]}], "+", 
      RowBox[{"4", " ", 
       SubscriptBox["a", "7"]}], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["a", "8"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["a", "9"]}], "-", 
      SubscriptBox["a", "10"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "9"}], " ", 
       SubscriptBox["a", "1"]}], "+", 
      RowBox[{"18", " ", 
       SubscriptBox["a", "2"]}], "-", 
      RowBox[{"16", " ", 
       SubscriptBox["a", "3"]}], "+", 
      RowBox[{"14", " ", 
       SubscriptBox["a", "4"]}], "-", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "5"]}], "+", 
      RowBox[{"10", " ", 
       SubscriptBox["a", "6"]}], "-", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "7"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "8"]}], "-", 
      RowBox[{"4", " ", 
       SubscriptBox["a", "9"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", 
       SubscriptBox["a", "1"]}], "-", 
      RowBox[{"16", " ", 
       SubscriptBox["a", "2"]}], "+", 
      RowBox[{"24", " ", 
       SubscriptBox["a", "3"]}], "-", 
      RowBox[{"21", " ", 
       SubscriptBox["a", "4"]}], "+", 
      RowBox[{"18", " ", 
       SubscriptBox["a", "5"]}], "-", 
      RowBox[{"15", " ", 
       SubscriptBox["a", "6"]}], "+", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "7"]}], "-", 
      RowBox[{"9", " ", 
       SubscriptBox["a", "8"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "9"]}], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], " ", 
       SubscriptBox["a", "1"]}], "+", 
      RowBox[{"14", " ", 
       SubscriptBox["a", "2"]}], "-", 
      RowBox[{"21", " ", 
       SubscriptBox["a", "3"]}], "+", 
      RowBox[{"28", " ", 
       SubscriptBox["a", "4"]}], "-", 
      RowBox[{"24", " ", 
       SubscriptBox["a", "5"]}], "+", 
      RowBox[{"20", " ", 
       SubscriptBox["a", "6"]}], "-", 
      RowBox[{"16", " ", 
       SubscriptBox["a", "7"]}], "+", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "8"]}], "-", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "9"]}], "+", 
      RowBox[{"4", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SubscriptBox["a", "1"]}], "-", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "2"]}], "+", 
      RowBox[{"18", " ", 
       SubscriptBox["a", "3"]}], "-", 
      RowBox[{"24", " ", 
       SubscriptBox["a", "4"]}], "+", 
      RowBox[{"30", " ", 
       SubscriptBox["a", "5"]}], "-", 
      RowBox[{"25", " ", 
       SubscriptBox["a", "6"]}], "+", 
      RowBox[{"20", " ", 
       SubscriptBox["a", "7"]}], "-", 
      RowBox[{"15", " ", 
       SubscriptBox["a", "8"]}], "+", 
      RowBox[{"10", " ", 
       SubscriptBox["a", "9"]}], "-", 
      RowBox[{"5", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SubscriptBox["a", "1"]}], "+", 
      RowBox[{"10", " ", 
       SubscriptBox["a", "2"]}], "-", 
      RowBox[{"15", " ", 
       SubscriptBox["a", "3"]}], "+", 
      RowBox[{"20", " ", 
       SubscriptBox["a", "4"]}], "-", 
      RowBox[{"25", " ", 
       SubscriptBox["a", "5"]}], "+", 
      RowBox[{"30", " ", 
       SubscriptBox["a", "6"]}], "-", 
      RowBox[{"24", " ", 
       SubscriptBox["a", "7"]}], "+", 
      RowBox[{"18", " ", 
       SubscriptBox["a", "8"]}], "-", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "9"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SubscriptBox["a", "1"]}], "-", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "2"]}], "+", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "3"]}], "-", 
      RowBox[{"16", " ", 
       SubscriptBox["a", "4"]}], "+", 
      RowBox[{"20", " ", 
       SubscriptBox["a", "5"]}], "-", 
      RowBox[{"24", " ", 
       SubscriptBox["a", "6"]}], "+", 
      RowBox[{"28", " ", 
       SubscriptBox["a", "7"]}], "-", 
      RowBox[{"21", " ", 
       SubscriptBox["a", "8"]}], "+", 
      RowBox[{"14", " ", 
       SubscriptBox["a", "9"]}], "-", 
      RowBox[{"7", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SubscriptBox["a", "1"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "2"]}], "-", 
      RowBox[{"9", " ", 
       SubscriptBox["a", "3"]}], "+", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "4"]}], "-", 
      RowBox[{"15", " ", 
       SubscriptBox["a", "5"]}], "+", 
      RowBox[{"18", " ", 
       SubscriptBox["a", "6"]}], "-", 
      RowBox[{"21", " ", 
       SubscriptBox["a", "7"]}], "+", 
      RowBox[{"24", " ", 
       SubscriptBox["a", "8"]}], "-", 
      RowBox[{"16", " ", 
       SubscriptBox["a", "9"]}], "+", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SubscriptBox["a", "1"]}], "-", 
      RowBox[{"4", " ", 
       SubscriptBox["a", "2"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "3"]}], "-", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "4"]}], "+", 
      RowBox[{"10", " ", 
       SubscriptBox["a", "5"]}], "-", 
      RowBox[{"12", " ", 
       SubscriptBox["a", "6"]}], "+", 
      RowBox[{"14", " ", 
       SubscriptBox["a", "7"]}], "-", 
      RowBox[{"16", " ", 
       SubscriptBox["a", "8"]}], "+", 
      RowBox[{"18", " ", 
       SubscriptBox["a", "9"]}], "-", 
      RowBox[{"9", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "11"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["a", "1"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["a", "2"]}], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["a", "3"]}], "+", 
      RowBox[{"4", " ", 
       SubscriptBox["a", "4"]}], "-", 
      RowBox[{"5", " ", 
       SubscriptBox["a", "5"]}], "+", 
      RowBox[{"6", " ", 
       SubscriptBox["a", "6"]}], "-", 
      RowBox[{"7", " ", 
       SubscriptBox["a", "7"]}], "+", 
      RowBox[{"8", " ", 
       SubscriptBox["a", "8"]}], "-", 
      RowBox[{"9", " ", 
       SubscriptBox["a", "9"]}], "+", 
      RowBox[{"10", " ", 
       SubscriptBox["a", "10"]}]}], ")"}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigenwerte und Eigenvektoren", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.35866063062494*^9, 3.35866066366085*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", "5", "6"},
      {"1", 
       RowBox[{"-", "1"}], "0"}
     }], ")"}]}], " ", ";"}]], "Input",
 CellChangeTimes->{{3.35866071108885*^9, 3.35866071143023*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{"mat", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.3586606950156*^9, 3.3586606971978*^9}, {
  3.35866073590874*^9, 3.35866074997513*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "9"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  SuperscriptBox["x", "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"mat", "-", 
   RowBox[{"x", " ", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "9"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  SuperscriptBox["x", "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ew", "=", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"mat", "//", "N"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35866071769948*^9, 3.35866071802753*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.725448735301109`", ",", "1.3985344442047047`", ",", 
   RowBox[{"-", "1.1239831795058126`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"ev", "=", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"mat", "//", "N"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.35866072603082*^9, 3.35866072656601*^9}, {
  3.35866202156935*^9, 3.35866204092975*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.3295745502901419`"},
        {"0.9381275161775833`"},
        {
         RowBox[{"-", "0.10628913016639514`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "0.06931047379663571`"}]},
        {
         RowBox[{"-", "0.8342744832363285`"}]},
        {"0.5469754517735169`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.782984162046372`"},
        {"0.09141020216157247`"},
        {
         RowBox[{"-", "0.6152885314430304`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", " ", ".", 
   RowBox[{"ev", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "==",
   " ", 
  RowBox[{
   RowBox[{"ew", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], " ", 
   
   RowBox[{
   "ev", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]], "Input",\

 CellChangeTimes->{{3.35866079659399*^9, 3.35866080608567*^9}, {
  3.35866197648761*^9, 3.35866198028292*^9}}],

Cell[BoxData["True"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{647, 571},
WindowMargins->{{Automatic, 109}, {Automatic, 127}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3392918671-3538003"->{
  Cell[3580, 120, 291, 5, 43, "Print",
   CellTags->"Info3392918671-3538003"]},
 "Info3392918680-2514319"->{
  Cell[4472, 150, 77, 1, 43, "Print",
   CellTags->"Info3392918680-2514319"],
  Cell[4552, 153, 806, 23, 28, "Print",
   CellTags->"Info3392918680-2514319"]},
 "Info3392918790-6024457"->{
  Cell[22183, 762, 291, 5, 43, "Print",
   CellTags->"Info3392918790-6024457"],
  Cell[22477, 769, 1181, 36, 91, "Print",
   CellTags->"Info3392918790-6024457"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3392918671-3538003", 155194, 5152},
 {"Info3392918680-2514319", 155303, 5155},
 {"Info3392918790-6024457", 155491, 5160}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 109, 2, 90, "Title",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[724, 29, 27, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[776, 33, 126, 1, 45, "Subsection"],
Cell[905, 36, 187, 3, 44, "Input"],
Cell[1095, 41, 410, 11, 48, "Input"],
Cell[1508, 54, 683, 18, 114, "SmallText"],
Cell[CellGroupData[{
Cell[2216, 76, 189, 5, 48, "Input"],
Cell[2408, 83, 221, 8, 44, "Output"]
}, Open  ]],
Cell[2644, 94, 620, 15, 76, "SmallText"],
Cell[CellGroupData[{
Cell[3289, 113, 288, 5, 85, "Input"],
Cell[3580, 120, 291, 5, 43, "Print",
 CellTags->"Info3392918671-3538003"],
Cell[3874, 127, 223, 6, 51, "Output"],
Cell[4100, 135, 223, 6, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4360, 146, 109, 2, 44, "Input"],
Cell[4472, 150, 77, 1, 43, "Print",
 CellTags->"Info3392918680-2514319"],
Cell[4552, 153, 806, 23, 28, "Print",
 CellTags->"Info3392918680-2514319"]
}, Open  ]],
Cell[5373, 179, 218, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[5616, 187, 303, 7, 71, "Input"],
Cell[5922, 196, 170, 5, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6129, 206, 286, 6, 71, "Input"],
Cell[6418, 214, 149, 4, 51, "Output"]
}, Open  ]],
Cell[6582, 221, 476, 9, 110, "SmallText"],
Cell[CellGroupData[{
Cell[7083, 234, 582, 17, 72, "Input"],
Cell[7668, 253, 722, 23, 67, "Output"]
}, Open  ]],
Cell[8405, 279, 396, 11, 70, "SmallText"],
Cell[CellGroupData[{
Cell[8826, 294, 164, 4, 56, "Input"],
Cell[8993, 300, 725, 23, 71, "Output"]
}, Open  ]],
Cell[9733, 326, 708, 17, 80, "SmallText"],
Cell[CellGroupData[{
Cell[10466, 347, 128, 4, 48, "Input"],
Cell[10597, 353, 722, 23, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11356, 381, 133, 3, 48, "Input"],
Cell[11492, 386, 129, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11658, 395, 178, 5, 48, "Input"],
Cell[11839, 402, 946, 31, 67, "Output"]
}, Open  ]],
Cell[12800, 436, 314, 9, 42, "SmallText"],
Cell[CellGroupData[{
Cell[13139, 449, 409, 10, 44, "Input"],
Cell[13551, 461, 116, 3, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13716, 470, 52, 0, 45, "Subsection"],
Cell[13771, 472, 219, 6, 112, "SmallText"],
Cell[13993, 480, 362, 9, 65, "Input"],
Cell[14358, 491, 180, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[14563, 499, 732, 21, 46, "Input"],
Cell[15298, 522, 2058, 63, 67, "Output"]
}, Open  ]],
Cell[17371, 588, 257, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[17653, 599, 302, 8, 46, "Input"],
Cell[17958, 609, 637, 19, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18632, 633, 263, 8, 46, "Input"],
Cell[18898, 643, 695, 22, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19630, 670, 364, 10, 46, "Input"],
Cell[19997, 682, 829, 26, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20863, 713, 194, 4, 44, "Input"],
Cell[21060, 719, 243, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21340, 732, 137, 3, 44, "Input"],
Cell[21480, 737, 103, 3, 44, "Output"]
}, Open  ]],
Cell[21598, 743, 413, 10, 59, "SmallText"],
Cell[CellGroupData[{
Cell[22036, 757, 144, 3, 44, "Input"],
Cell[22183, 762, 291, 5, 43, "Print",
 CellTags->"Info3392918790-6024457"],
Cell[22477, 769, 1181, 36, 91, "Print",
 CellTags->"Info3392918790-6024457"]
}, Open  ]],
Cell[23673, 808, 251, 7, 42, "SmallText"],
Cell[CellGroupData[{
Cell[23949, 819, 232, 5, 66, "Input"],
Cell[24184, 826, 83, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24304, 833, 315, 6, 66, "Input"],
Cell[24622, 841, 63, 1, 46, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24734, 848, 150, 3, 45, "Subsection"],
Cell[24887, 853, 351, 7, 93, "SmallText"],
Cell[25241, 862, 1008, 23, 63, "SmallText"],
Cell[26252, 887, 721, 23, 67, "Input"],
Cell[CellGroupData[{
Cell[26998, 914, 262, 6, 52, "Input"],
Cell[27263, 922, 425, 14, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27725, 941, 367, 9, 52, "Input"],
Cell[28095, 952, 1928, 58, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30060, 1015, 160, 3, 46, "Input"],
Cell[30223, 1020, 32, 0, 44, "Output"]
}, Open  ]],
Cell[30270, 1023, 282, 5, 59, "SmallText"],
Cell[CellGroupData[{
Cell[30577, 1032, 226, 6, 48, "Input"],
Cell[30806, 1040, 672, 21, 67, "Output"]
}, Open  ]],
Cell[31493, 1064, 219, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[31737, 1072, 277, 6, 46, "Input"],
Cell[32017, 1080, 236, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32290, 1093, 147, 3, 44, "Input"],
Cell[32440, 1098, 672, 21, 67, "Output"]
}, Open  ]],
Cell[33127, 1122, 471, 12, 63, "SmallText"],
Cell[CellGroupData[{
Cell[33623, 1138, 195, 4, 48, "Input"],
Cell[33821, 1144, 293, 6, 24, "Message"],
Cell[34117, 1152, 320, 11, 44, "Output"]
}, Open  ]],
Cell[34452, 1166, 189, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[34666, 1174, 202, 4, 48, "Input"],
Cell[34871, 1180, 259, 6, 65, "Message"],
Cell[35133, 1188, 327, 11, 44, "Output"]
}, Open  ]],
Cell[35475, 1202, 873, 20, 80, "SmallText"],
Cell[CellGroupData[{
Cell[36373, 1226, 270, 7, 48, "Input"],
Cell[36646, 1235, 876, 27, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37559, 1267, 314, 7, 48, "Input"],
Cell[37876, 1276, 688, 20, 44, "Output"]
}, Open  ]],
Cell[38579, 1299, 408, 7, 76, "SmallText"],
Cell[CellGroupData[{
Cell[39012, 1310, 195, 4, 46, "Input"],
Cell[39210, 1316, 251, 6, 24, "Message"],
Cell[39464, 1324, 245, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39746, 1337, 195, 4, 48, "Input"],
Cell[39944, 1343, 161, 5, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40166, 1355, 36, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[40227, 1359, 99, 1, 45, "Subsection"],
Cell[40329, 1362, 310, 9, 44, "Input"],
Cell[CellGroupData[{
Cell[40664, 1375, 66, 1, 44, "Input"],
Cell[40733, 1378, 593, 17, 53, "Output"]
}, Open  ]],
Cell[41341, 1398, 152, 6, 53, "Input"],
Cell[CellGroupData[{
Cell[41518, 1408, 317, 9, 65, "Input"],
Cell[41838, 1419, 615, 18, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42490, 1442, 383, 12, 65, "Input"],
Cell[42876, 1456, 659, 20, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43572, 1481, 432, 13, 65, "Input"],
Cell[44007, 1496, 630, 18, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44674, 1519, 210, 6, 44, "Input"],
Cell[44887, 1527, 777, 18, 67, "Output"]
}, Open  ]],
Cell[45679, 1548, 829, 24, 85, "Input"],
Cell[CellGroupData[{
Cell[46533, 1576, 234, 7, 46, "Input"],
Cell[46770, 1585, 616, 18, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47423, 1608, 312, 9, 44, "Input"],
Cell[47738, 1619, 975, 30, 71, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48750, 1654, 220, 6, 44, "Input"],
Cell[48973, 1662, 718, 22, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49728, 1689, 165, 5, 44, "Input"],
Cell[49896, 1696, 615, 18, 67, "Output"]
}, Open  ]],
Cell[50526, 1717, 434, 12, 68, "SmallText"],
Cell[CellGroupData[{
Cell[50985, 1733, 319, 7, 44, "Input"],
Cell[51307, 1742, 141, 4, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51485, 1751, 375, 8, 44, "Input"],
Cell[51863, 1761, 451, 16, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52351, 1782, 379, 8, 44, "Input"],
Cell[52733, 1792, 109, 3, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52879, 1800, 246, 5, 44, "Input"],
Cell[53128, 1807, 740, 24, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53905, 1836, 337, 9, 44, "Input"],
Cell[54245, 1847, 1464, 51, 109, "Output"]
}, Open  ]],
Cell[55724, 1901, 192, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[55941, 1909, 668, 16, 85, "Input"],
Cell[56612, 1927, 1155, 36, 71, "Output"]
}, Open  ]],
Cell[57782, 1966, 200, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[58007, 1974, 443, 12, 65, "Input"],
Cell[58453, 1988, 1101, 36, 79, "Output"]
}, Open  ]],
Cell[59569, 2027, 228, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[59822, 2036, 131, 2, 44, "Input"],
Cell[59956, 2040, 216, 4, 78, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60221, 2050, 123, 1, 45, "Subsection"],
Cell[60347, 2053, 480, 14, 91, "Input"],
Cell[CellGroupData[{
Cell[60852, 2071, 160, 3, 44, "Input"],
Cell[61015, 2076, 28, 0, 44, "Output"]
}, Open  ]],
Cell[61058, 2079, 257, 6, 59, "SmallText"],
Cell[CellGroupData[{
Cell[61340, 2089, 178, 4, 44, "Input"],
Cell[61521, 2095, 651, 21, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62209, 2121, 216, 5, 44, "Input"],
Cell[62428, 2128, 638, 20, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63103, 2153, 333, 9, 44, "Input"],
Cell[63439, 2164, 593, 17, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64069, 2186, 371, 9, 44, "Input"],
Cell[64443, 2197, 603, 17, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65083, 2219, 339, 9, 44, "Input"],
Cell[65425, 2230, 603, 17, 55, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66089, 2254, 39, 0, 55, "Section"],
Cell[66131, 2256, 139, 2, 44, "Input"],
Cell[66273, 2260, 285, 12, 67, "Input"],
Cell[CellGroupData[{
Cell[66583, 2276, 90, 2, 44, "Input"],
Cell[66676, 2280, 762, 24, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67475, 2309, 143, 4, 44, "Input"],
Cell[67621, 2315, 755, 23, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68413, 2343, 103, 2, 44, "Input"],
Cell[68519, 2347, 1362, 45, 67, "Output"]
}, Open  ]],
Cell[69896, 2395, 385, 12, 69, "Input"],
Cell[70284, 2409, 501, 10, 76, "SmallText"],
Cell[CellGroupData[{
Cell[70810, 2423, 165, 3, 44, "Input"],
Cell[70978, 2428, 1013, 32, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72028, 2465, 165, 3, 44, "Input"],
Cell[72196, 2470, 1013, 32, 69, "Output"]
}, Open  ]],
Cell[73224, 2505, 662, 15, 93, "SmallText"],
Cell[CellGroupData[{
Cell[73911, 2524, 656, 15, 85, "Input"],
Cell[74570, 2541, 585, 18, 67, "Output"],
Cell[75158, 2561, 948, 30, 69, "Output"],
Cell[76109, 2593, 934, 28, 44, "Output"]
}, Open  ]],
Cell[77058, 2624, 199, 8, 67, "Input"],
Cell[CellGroupData[{
Cell[77282, 2636, 59, 1, 44, "Input"],
Cell[77344, 2639, 30, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77411, 2644, 159, 4, 44, "Input"],
Cell[77573, 2650, 929, 30, 109, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78539, 2685, 208, 7, 55, "Input"],
Cell[78750, 2694, 1887, 61, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80674, 2760, 209, 7, 53, "Input"],
Cell[80886, 2769, 638, 17, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81561, 2791, 181, 6, 53, "Input"],
Cell[81745, 2799, 656, 17, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82438, 2821, 454, 15, 70, "Input"],
Cell[82895, 2838, 647, 17, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83591, 2861, 119, 1, 55, "Section"],
Cell[83713, 2864, 455, 9, 76, "SmallText"],
Cell[CellGroupData[{
Cell[84193, 2877, 632, 19, 44, "Input"],
Cell[84828, 2898, 740, 21, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85605, 2924, 682, 20, 44, "Input"],
Cell[86290, 2946, 830, 24, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87157, 2975, 312, 9, 44, "Input"],
Cell[87472, 2986, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87537, 2991, 318, 10, 44, "Input"],
Cell[87858, 3003, 356, 12, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88251, 3020, 215, 5, 44, "Input"],
Cell[88469, 3027, 80, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88586, 3034, 99, 2, 44, "Input"],
Cell[88688, 3038, 31, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88756, 3043, 240, 6, 44, "Input"],
Cell[88999, 3051, 2277, 53, 145, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91313, 3109, 720, 17, 44, "Input"],
Cell[92036, 3128, 1295, 29, 165, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93368, 3162, 676, 18, 44, "Input"],
Cell[94047, 3182, 1295, 29, 165, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95379, 3216, 928, 24, 65, "Input"],
Cell[96310, 3242, 951, 24, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97298, 3271, 125, 2, 44, "Input"],
Cell[97426, 3275, 599, 20, 44, "Output"]
}, Open  ]],
Cell[98040, 3298, 991, 26, 85, "Input"],
Cell[CellGroupData[{
Cell[99056, 3328, 238, 6, 44, "Input"],
Cell[99297, 3336, 899, 25, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100233, 3366, 557, 15, 44, "Input"],
Cell[100793, 3383, 247, 8, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[101089, 3397, 120, 1, 55, "Section"],
Cell[101212, 3400, 546, 12, 76, "SmallText"],
Cell[101761, 3414, 613, 24, 81, "Input"],
Cell[CellGroupData[{
Cell[102399, 3442, 252, 6, 44, "Input"],
Cell[102654, 3450, 193, 5, 24, "Message"],
Cell[102850, 3457, 463, 16, 58, "Output"]
}, Open  ]],
Cell[103328, 3476, 463, 12, 76, "SmallText"],
Cell[CellGroupData[{
Cell[103816, 3492, 325, 8, 44, "Input"],
Cell[104144, 3502, 915, 30, 123, "Output"]
}, Open  ]],
Cell[105074, 3535, 332, 8, 59, "SmallText"],
Cell[CellGroupData[{
Cell[105431, 3547, 357, 10, 65, "Input"],
Cell[105791, 3559, 97, 2, 44, "Output"],
Cell[105891, 3563, 193, 5, 24, "Message"],
Cell[106087, 3570, 463, 16, 58, "Output"]
}, Open  ]],
Cell[106565, 3589, 970, 22, 127, "SmallText"],
Cell[CellGroupData[{
Cell[107560, 3615, 180, 4, 44, "Input"],
Cell[107743, 3621, 300, 6, 65, "Message"],
Cell[108046, 3629, 196, 7, 44, "Output"]
}, Open  ]],
Cell[108257, 3639, 622, 13, 76, "SmallText"],
Cell[CellGroupData[{
Cell[108904, 3656, 154, 3, 44, "Input"],
Cell[109061, 3661, 673, 22, 123, "Output"]
}, Open  ]],
Cell[109749, 3686, 505, 12, 59, "SmallText"],
Cell[CellGroupData[{
Cell[110279, 3702, 378, 9, 44, "Input"],
Cell[110660, 3713, 673, 22, 123, "Output"]
}, Open  ]],
Cell[111348, 3738, 919, 21, 110, "SmallText"],
Cell[CellGroupData[{
Cell[112292, 3763, 304, 7, 44, "Input"],
Cell[112599, 3772, 742, 24, 81, "Output"]
}, Open  ]],
Cell[113356, 3799, 778, 18, 59, "SmallText"],
Cell[CellGroupData[{
Cell[114159, 3821, 280, 8, 44, "Input"],
Cell[114442, 3831, 695, 23, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115174, 3859, 313, 9, 44, "Input"],
Cell[115490, 3870, 812, 27, 123, "Output"]
}, Open  ]],
Cell[116317, 3900, 174, 4, 42, "SmallText"],
Cell[116494, 3906, 616, 22, 81, "Input"],
Cell[CellGroupData[{
Cell[117135, 3932, 175, 5, 44, "Input"],
Cell[117313, 3939, 597, 19, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117947, 3963, 147, 4, 44, "Input"],
Cell[118097, 3969, 1478, 47, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119612, 4021, 203, 7, 44, "Input"],
Cell[119818, 4030, 819, 27, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120674, 4062, 296, 9, 44, "Input"],
Cell[120973, 4073, 815, 26, 81, "Output"]
}, Open  ]],
Cell[121803, 4102, 253, 5, 59, "SmallText"],
Cell[CellGroupData[{
Cell[122081, 4111, 274, 8, 44, "Input"],
Cell[122358, 4121, 815, 26, 81, "Output"]
}, Open  ]],
Cell[123188, 4150, 158, 3, 42, "SmallText"],
Cell[123349, 4155, 1431, 41, 105, "Input"],
Cell[CellGroupData[{
Cell[124805, 4200, 441, 11, 44, "Input"],
Cell[125249, 4213, 177, 4, 44, "Output"]
}, Open  ]],
Cell[125441, 4220, 501, 12, 76, "SmallText"],
Cell[CellGroupData[{
Cell[125967, 4236, 745, 21, 65, "Input"],
Cell[126715, 4259, 158, 5, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126910, 4269, 783, 17, 44, "Input"],
Cell[127696, 4288, 78, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127811, 4295, 433, 8, 44, "Input"],
Cell[128247, 4305, 1182, 25, 259, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129466, 4335, 906, 18, 44, "Input"],
Cell[130375, 4355, 99, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130511, 4362, 466, 7, 44, "Input"],
Cell[130980, 4371, 1182, 25, 259, "Output"]
}, Open  ]],
Cell[132177, 4399, 326, 9, 65, "Input"],
Cell[CellGroupData[{
Cell[132528, 4412, 583, 15, 65, "Input"],
Cell[133114, 4429, 96, 2, 44, "Output"],
Cell[133213, 4433, 8537, 266, 373, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141787, 4704, 692, 14, 65, "Input"],
Cell[142482, 4720, 96, 2, 44, "Output"],
Cell[142581, 4724, 7466, 245, 373, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150096, 4975, 47, 0, 55, "Section"],
Cell[150146, 4977, 140, 2, 44, "Input"],
Cell[150289, 4981, 267, 9, 67, "Input"],
Cell[CellGroupData[{
Cell[150581, 4994, 211, 4, 44, "Input"],
Cell[150795, 5000, 150, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150982, 5010, 148, 4, 44, "Input"],
Cell[151133, 5016, 150, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151320, 5026, 179, 4, 44, "Input"],
Cell[151502, 5032, 155, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151694, 5040, 288, 7, 44, "Input"],
Cell[151985, 5049, 2297, 66, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154319, 5120, 439, 12, 44, "Input"],
Cell[154761, 5134, 31, 0, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
