(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    729626,      14560]
NotebookOptionsPosition[    708121,      13852]
NotebookOutlinePosition[    708496,      13869]
CellTagsIndexPosition[    708453,      13866]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Numerische Verfahren", "Title"],

Cell[CellGroupData[{

Cell["\<\
Numerische Auswertung 
symbolischer Ergebnisse\
\>", "Section"],

Cell[CellGroupData[{

Cell["Numerische Auswertung von Ausdr\[UDoubleDot]cken", "Subsection",
 CellChangeTimes->{{3360065644.24372, 3360065656.88156}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.3600656759901*^9, 3.36006568365043*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", "4"], "]"}], "]"}]], "Input"],

Cell[BoxData["0.7071067811865476`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "4"], "]"}], ",", "60"}], "]"}]], "Input"],

Cell[BoxData["0.\
70710678118654752440084436210484903928483593768847403658833986899536623923105`\
60."], "Output"]
}, Open  ]],

Cell[TextData[{
 "Ist das Argument numerischer Natur und tr\[ADoubleDot]gt der verarbeitende \
Funktionsbezeichner das Attribut ",
 StyleBox["NumericFunction",
  FontWeight->"Bold"],
 ", so wird beim Auswerten eine numerische N\[ADoubleDot]herungsroutine \
aufgerufen. Da die Auswertung der ",
 StyleBox["FullForm",
  FontWeight->"Bold"],
 " ",
 StyleBox["Sin[Times[Pi,Power[4.,-1]]]] ",
  FontSlant->"Italic"],
 "von innen nach au\[SZ]en stets einen numerischen Wert als Argument f\
\[UDoubleDot]r den n\[ADoubleDot]chsten Funktionsaufruf liefert, wird \
letztlich ein numerischr Wert zur\[UDoubleDot]ckgegeben."
}], "SmallText",
 CellChangeTimes->{{3.36006408949384*^9, 3.36006413156917*^9}, {
  3.36006416723493*^9, 3.36006426312986*^9}, {3.36006432545209*^9, 
  3.3600643835311*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox["\[Pi]", "4."], "]"}]], "Input",
 CellChangeTimes->{{3.36006414138428*^9, 3.36006417763139*^9}}],

Cell[BoxData["0.7071067811865475`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Hier die Best\[ADoubleDot]tigung, dass alle beteiligten Funktionen das \
Attribut ",
 StyleBox["NumericFunction",
  FontWeight->"Bold"],
 " tragen."
}], "SmallText",
 CellChangeTimes->{{3.36006428627043*^9, 3.36006431806073*^9}, {
  3.36006439046014*^9, 3.36006439184031*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemberQ", "[", 
    RowBox[{
     RowBox[{"Attributes", "[", "#", "]"}], ",", "NumericFunction"}], "]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Sin", ",", "Times", ",", "Power"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.36006395416064*^9, 3.36006395720117*^9}, {
  3.36006399608393*^9, 3.36006407425259*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    SqrtBox["2"], "]"}], 
   RowBox[{"N", "[", 
    SqrtBox["8"], "]"}]}], "-", "4"}]], "Input"],

Cell[BoxData["8.881784197001252`*^-16"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Chop"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], 
   SqrtBox["8"]}], "-", "4"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rechengenauigkeit", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["$MachinePrecision"], "Input"],

Cell[BoxData["15.954589770191003`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Rechnungen werden standardm\[ADoubleDot]\[SZ]ig mit Maschinengenauigkeit \
ausgef\[UDoubleDot]hrt. ",
 StyleBox["Precision",
  FontWeight->"Bold"],
 " gibt in diesem Fall den symbolischem Wert ",
 StyleBox["MachinePrecision",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ck, der numerisch (mit ",
 StyleBox["N",
  FontWeight->"Bold"],
 ") zu einem Zahlenwert ausgewertet wird, der auch in der Systemkonstanten ",
 StyleBox["$MachinePrecision",
  FontWeight->"Bold"],
 " gespeichert ist. \nIn fr\[UDoubleDot]heren Versionen war dieser Wert \
ganzzahlig. "
}], "SmallText",
 CellChangeTimes->{{3.36006697765804*^9, 3.36006712760619*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox["2."]], "Input"],

Cell[BoxData["1.4142135623730951`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Precision"}]], "Input",
 CellChangeTimes->{{3.36006584308278*^9, 3.36006584643004*^9}}],

Cell[BoxData["MachinePrecision"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellChangeTimes->{{3.36006585118774*^9, 3.3600658522166*^9}}],

Cell[BoxData["15.954589770191003`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox["2.`30"]], "Input"],

Cell[BoxData["1.414213562373095048801688724209698078569671875377`30.\
30102999566398"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Precision"}]], "Input"],

Cell[BoxData["30.30102999566398`"], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["a", "1"], "=", "0.3"}], ";", 
  RowBox[{"b", "=", 
   FractionBox["1", "10"]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["c", "1"], "=", 
  RowBox[{"N", "[", 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["a", "1"], "b"], ",", "40"}], "]"}]}]], "Input"],

Cell[BoxData["0.8865681505652133`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", "b", ",", 
    SubscriptBox["c", "1"]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MachinePrecision", ",", "\[Infinity]", ",", "MachinePrecision"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["0.3`25"], "Input"],

Cell[BoxData["0.3`25."], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["a", "2"], "=", "0.3000000000000000000000000"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["c", "2"], "=", 
  RowBox[{"N", "[", 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["a", "2"], "b"], ",", "40"}], "]"}]}]}], "Input"],

Cell[BoxData["0.88656815056521333451542708864927862108`25.477121254719666"], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Precision", "/@", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "2"], ",", "b", ",", 
     SubscriptBox["c", "2"]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.3600664981756*^9, 3.36006652117472*^9}, {
  3.36006656339399*^9, 3.36006656383342*^9}, {3.389066866597204*^9, 
  3.389066872655051*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24.477121254719666`", ",", "\[Infinity]", ",", "25.477121254719666`"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", 
    SubscriptBox["a", "2"], ",", 
    SubscriptBox["c", "1"], ",", 
    SubscriptBox["c", "2"]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "False"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["a", "3"], "=", 
  RowBox[{"N", "[", 
   RowBox[{
    SuperscriptBox["\[Pi]", "2"], ",", "30"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["b", "3"], "=", 
  SuperscriptBox[
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", "35"}], "]"}], "2"]}]}], "Input"],

Cell[BoxData["9.86960440108935861883449099987615113532`30."], "Output"],

Cell[BoxData["9.86960440108935861883449099987615113531369940724`34.\
69897000433602"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["a", "3"], "//", "InputForm"}]], "Input"],

Cell["9.86960440108935861883449099987615113532`30.", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Precision", "[", "12345.1234567890123456789", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Accuracy", "[", "12345.1234567890123456789", "]"}]}], "Input",
 CellChangeTimes->{{3.36006690753897*^9, 3.36006692611695*^9}}],

Cell[BoxData["23.091495437429888`"], "Output"],

Cell[BoxData["19.`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["c", "3"], "=", 
  RowBox[{
   SubscriptBox["a", "3"], "-", 
   SubscriptBox["b", "3"]}]}]], "Input"],

Cell[BoxData["0``29.005691568808952"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "3"], ",", 
    SubscriptBox["b", "3"], ",", 
    SubscriptBox["c", "3"]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30.`", ",", "34.69897000433602`", ",", "0.`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Ungenaue Eingaben an wenig signifikanter Stelle haben auf die \
Ergebnisgenauigkeit geringen Einfluss, so dass sich in einem solchen Fall die \
Genauigkeit auch vergr\[ODoubleDot]\[SZ]ern kann.\
\>", "SmallText",
 CellChangeTimes->{{3.36006785504319*^9, 3.36006786891357*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["10", "5"], "+", 
  SubscriptBox["c", "2"]}]], "Input"],

Cell[BoxData["100000.88656815056521333451542708864927862108`30.\
529412979547192"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Precision"}]], "Input"],

Cell[BoxData["30.529412979547192`"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
N\[ADoubleDot]herungswerte in exakte Werte verwandeln\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36006976518695*^9, 3.36006977113265*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", "=", 
  FractionBox["5.", "17"]}], "\[IndentingNewLine]", 
 RowBox[{"Rationalize", "[", "u", "]"}]}], "Input",
 CellChangeTimes->{{3.36006954249774*^9, 3.36006957542142*^9}, {
  3.36006962924975*^9, 3.36006975462327*^9}}],

Cell[BoxData["0.29411764705882354`"], "Output"],

Cell[BoxData[
 FractionBox["5", "17"]], "Output"]
}, Open  ]],

Cell["\<\
Diese beiden Rechnungen sehen zwar gleich aus, sind es aber nicht!\
\>", "SmallText",
 CellChangeTimes->{{3.36007038431491*^9, 3.36007039601667*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u1", "=", "3.14159"}], "\[IndentingNewLine]", 
 RowBox[{"Rationalize", "[", "u1", "]"}]}], "Input",
 CellChangeTimes->{{3.36007045953866*^9, 3.36007047290723*^9}, {
  3.36007094724237*^9, 3.36007094857967*^9}}],

Cell[BoxData["3.14159`"], "Output"],

Cell[BoxData[
 FractionBox["314159", "100000"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u2", "=", 
  RowBox[{"N", "[", "\[Pi]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Rationalize", "[", "u2", "]"}]}], "Input",
 CellChangeTimes->{{3.36007000326434*^9, 3.36007002547848*^9}, {
  3.36007043441272*^9, 3.36007044678256*^9}, {3.36007095155426*^9, 
  3.36007095267303*^9}}],

Cell[BoxData["3.141592653589793`"], "Output"],

Cell[BoxData["3.141592653589793`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{"u1", ",", "u2"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.36007031624477*^9, 3.36007036523798*^9}, {
  3.36007095931364*^9, 3.36007096298474*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["3.14159",
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[3.14159],
    AutoDelete->True,
    Editable->True], ",", 
   InterpretationBox[
    StyleBox["3.141592653589793",
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[3.141592653589793],
    AutoDelete->True,
    Editable->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Die Umwandlung kann man erzwingen, indem als Pr\[ADoubleDot]zision 0 \
angegeben wird.\
\>", "SmallText",
 CellChangeTimes->{{3.36007074473782*^9, 3.3600707651762*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rationalize", "[", 
  RowBox[{"u2", ",", "0.007"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{"\[Pi]", ",", "20"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36007019692727*^9, 3.36007020223471*^9}, {
  3.36007077494757*^9, 3.36007077876127*^9}, {3.36007148905984*^9, 
  3.36007152188951*^9}, {3.389090417690626*^9, 3.389090444740647*^9}}],

Cell[BoxData[
 FractionBox["22", "7"]], "Output"],

Cell[BoxData["0.0012644892673496186802137595778095415`16.604765274825265"], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rationalize", "[", 
  RowBox[{"u2", ",", "0"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{"\[Pi]", ",", "25"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36007019692727*^9, 3.36007020223471*^9}, {
   3.36007077494757*^9, 3.36007077876127*^9}, {3.36007148905984*^9, 
   3.36007152188951*^9}, 3.389090417690626*^9, {3.389090465714779*^9, 
   3.389090478283494*^9}}],

Cell[BoxData[
 FractionBox["245850922", "78256779"]], "Output"],

Cell[BoxData[
 RowBox[{"-", "7.817936619907543540017`8.395942272586538*^-17"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rationalize", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", "40"}], "]"}], ",", "0"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{"\[Pi]", ",", "50"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36007153553836*^9, 3.36007154165061*^9}, {
  3.389090492493067*^9, 3.389090523733323*^9}}],

Cell[BoxData[
 FractionBox["262452630335382199398", "83541266890691994833"]], "Output"],

Cell[BoxData["1.011863226985447255746002793`9.507971940422461*^-40"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gleichungen numerisch l\[ODoubleDot]sen", "Section"],

Cell[CellGroupData[{

Cell["Solve und NSolve", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36007169926176*^9, 3.36007171164551*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.38909107234888*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`"}], "-", 
      RowBox[{"1.4142135623730951`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`"}], "+", 
      RowBox[{"1.4142135623730951`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3."}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.389091075159512*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`"}], "-", 
      RowBox[{"1.414213562373095`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`"}], "+", 
      RowBox[{"1.414213562373095`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.389091075935499*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`"}], "-", 
      RowBox[{"1.414213562373095`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`"}], "+", 
      RowBox[{"1.414213562373095`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x", ",", " ", 
   "30"}], "]"}]], "Input",
 CellChangeTimes->{3.389091076847848*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`29.458164896261245"}], "-", 
      RowBox[{
      "1.414213562373095048801688724209698078569671875377`29.608679894093235",
        " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.`29.458164896261245"}], "+", 
      RowBox[{
      "1.414213562373095048801688724209698078569671875377`29.608679894093235",
        " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "3"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["x", "3"]}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"esol", "=", 
        RowBox[{"Solve", "[", 
         RowBox[{"sys", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ")"}], "//", "N"}]}], 
    ";"}], ")"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.389091078080382*^9, 3.389091078974056*^9}, {
  3.389092283400374*^9, 3.389092355757645*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16.390000000000015`", ",", "Null"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "//", "Length"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "//", "Union"}], "//", "Length"}]}], "Input",
 CellChangeTimes->{{3.36007214468996*^9, 3.36007214753337*^9}, {
  3.36007222207059*^9, 3.36007222718873*^9}, {3.389091797793416*^9, 
  3.38909180305842*^9}}],

Cell[BoxData["16"], "Output"],

Cell[BoxData["12"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"esol", "//", "ByteCount"}]], "Input",
 CellChangeTimes->{{3.389093194072033*^9, 3.38909319871478*^9}, {
  3.38909326335778*^9, 3.389093266199753*^9}}],

Cell[BoxData["291208"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389093477973332*^9, 3.389093495789392*^9}, {
  3.389093525884508*^9, 3.389093552783522*^9}, {3.38909512719456*^9, 
  3.38909515354374*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "5"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "5"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"3", "+", 
           RowBox[{"5", " ", "#1"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"red", "//", "N"}], "//", "ToRules"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.389095251753577*^9, 3.389095262438842*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.3802775690976141`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.3802775690976141`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.8191725133961645`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8191725133961645`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.2194474721492752`"}], "-", 
       RowBox[{"0.9144736629677265`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.2194474721492752`"}], "-", 
       RowBox[{"0.9144736629677265`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.2194474721492752`"}], "+", 
       RowBox[{"0.9144736629677265`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.2194474721492752`"}], "+", 
       RowBox[{"0.9144736629677265`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.044139920059583`"}], "-", 
       RowBox[{"0.3904248754092434`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.18864569587880117`"}], "+", 
       RowBox[{"1.1829768679246913`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.044139920059583`"}], "+", 
       RowBox[{"0.3904248754092434`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.18864569587880117`"}], "-", 
       RowBox[{"1.1829768679246913`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.18864569587880112`"}], "-", 
       RowBox[{"1.1829768679246913`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.044139920059583`"}], "+", 
       RowBox[{"0.39042487540924337`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.18864569587880112`"}], "+", 
       RowBox[{"1.1829768679246913`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.044139920059583`"}], "-", 
       RowBox[{"0.39042487540924337`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.232785615938384`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.275985368583906`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.23278561593838387`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.275985368583906`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.232785615938384`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.275985368583906`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.23278561593838387`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.275985368583906`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"sys", ",", "y"}], "]"}]], "Input",
 CellChangeTimes->{{3.389094741459798*^9, 3.389094742363982*^9}, {
  3.389095719917422*^9, 3.389095720274616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   SuperscriptBox["x", "5"], "-", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   RowBox[{"7", " ", 
    SuperscriptBox["x", "7"]}], "-", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "8"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   SuperscriptBox["x", "10"], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "11"]}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "12"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "13"]}], "+", 
   SuperscriptBox["x", "14"]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FactorList", "[", 
   RowBox[{"First", "[", "%", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389094626911241*^9, 3.389094627248435*^9}, {
  3.389094685031011*^9, 3.389094690601983*^9}, {3.389094737385077*^9, 
  3.38909473787402*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"5", " ", "x"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "5"]}], "+", 
      SuperscriptBox["x", "6"]}], ",", "1"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"Prepend", "[", 
    RowBox[{"sys", ",", 
     RowBox[{
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"5", ",", "1"}], "\[RightDoubleBracket]"}], "\[Equal]", 
      "0"}]}], " ", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.389094645421779*^9, 3.38909465390985*^9}, {
  3.389094753191833*^9, 3.389094886886545*^9}, {3.389095730532009*^9, 
  3.389095732447599*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "+", 
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    SuperscriptBox["x", "6"]}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", "y"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "/.", "sol"}]], "Input",
 CellChangeTimes->{{3.389096008193856*^9, 3.389096020402485*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"esys", "=", 
  RowBox[{"First", "/@", "sys"}]}]], "Input",
 CellChangeTimes->{{3.389096050652382*^9, 3.38909608383105*^9}, {
  3.389096130393757*^9, 3.389096153094387*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["y", "3"]}], ",", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["y", "4"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"esys", "/.", "sol"}]], "Input",
 CellChangeTimes->{{3.389096088380737*^9, 3.389096160599109*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "+", 
      RowBox[{"4.440892098500626`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "-", 
      RowBox[{"4.440892098500626`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.0000000000000004`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.1102230246251565`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.0000000000000004`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.1102230246251565`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}]}],
   "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NSolve",
  FontWeight->"Bold"],
 " liefert dasselbe Ergebnis wie ",
 StyleBox["Solve[sys,vars]//N",
  FontWeight->"Bold"],
 ", jedoch deutlich schneller und in einer anderen Reihenfolge."
}], "SmallText",
 CellChangeTimes->{{3.36007471813369*^9, 3.36007481901441*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"nsol", "=", 
     RowBox[{"NSolve", "[", 
      RowBox[{"sys", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ";"}], ")"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{3.389095998134172*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.08999999999994995`", ",", "Null"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"nsol", "//", "Length"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsol", "//", "Union"}], "//", "Length"}]}], "Input",
 CellChangeTimes->{{3.389091833817414*^9, 3.389091844675533*^9}, {
  3.389097292337571*^9, 3.389097298940567*^9}}],

Cell[BoxData["16"], "Output"],

Cell[BoxData["12"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "/.", "nsol"}]], "Input",
 CellChangeTimes->{{3.36007359794651*^9, 3.36007364378939*^9}, {
   3.3600737222694*^9, 3.36007375627459*^9}, 3.36007539030512*^9, {
   3.3600758040885*^9, 3.36007580679351*^9}, {3.389097397979791*^9, 
   3.389097404393256*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"esys", "/.", "nsol"}]], "Input",
 CellChangeTimes->{{3.36007359794651*^9, 3.36007364378939*^9}, {
   3.3600737222694*^9, 3.36007375627459*^9}, 3.36007539030512*^9, {
   3.3600758040885*^9, 3.36007580679351*^9}, {3.389097397979791*^9, 
   3.38909743085538*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.0000000000000138`", "\[InvisibleSpace]", "-", 
      RowBox[{"3.552713678800501`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000158`", "\[InvisibleSpace]", "+", 
      RowBox[{"5.551115123125783`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.0000000000000138`", "\[InvisibleSpace]", "+", 
      RowBox[{"3.552713678800501`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000158`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.551115123125783`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.999999999999993`", "\[InvisibleSpace]", "+", 
      RowBox[{"5.773159728050814`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9999999999999949`", "\[InvisibleSpace]", "-", 
      RowBox[{"4.218847493575595`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.999999999999993`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.773159728050814`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9999999999999949`", "\[InvisibleSpace]", "+", 
      RowBox[{"4.218847493575595`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.9999999999999859`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.3988810110276972`*^-14", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000098`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.9984014443252818`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.9999999999999859`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.3988810110276972`*^-14", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.0000000000000098`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.9984014443252818`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999978`", ",", "0.9999999999999983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999978`", ",", "0.9999999999999983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999978`", ",", "0.9999999999999983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0000000000000848`", ",", "1.000000000000377`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.000000000000003`", "\[InvisibleSpace]", "+", 
      RowBox[{"5.773159728050814`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.000000000000007`", "\[InvisibleSpace]", "+", 
      RowBox[{"6.8833827526759706`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.000000000000003`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.773159728050814`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.000000000000007`", "\[InvisibleSpace]", "-", 
      RowBox[{"6.8833827526759706`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.0000000000000013`", ",", "1.0000000000000013`"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Chop"}]], "Input",
 CellChangeTimes->{{3.3600753955299*^9, 3.36007539953827*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.0000000000000138`", ",", "1.0000000000000158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0000000000000138`", ",", "1.0000000000000158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999999999999993`", ",", "0.9999999999999949`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999999999999993`", ",", "0.9999999999999949`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999859`", ",", "1.0000000000000098`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999859`", ",", "1.0000000000000098`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999978`", ",", "0.9999999999999983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999978`", ",", "0.9999999999999983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999978`", ",", "0.9999999999999983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0000000000000848`", ",", "1.000000000000377`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.000000000000003`", ",", "1.000000000000007`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.000000000000003`", ",", "1.000000000000007`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0000000000000013`", ",", "1.0000000000000013`"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389091310862248*^9, 3.389091326258983*^9}, {
   3.389091400598585*^9, 3.389091401445021*^9}, 3.389092251592049*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["#1", "3"], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"red", "//", "N"}], "//", "ToRules"}], "}"}]], "Input",
 CellChangeTimes->{{3.389091369410377*^9, 3.389091370204546*^9}, {
  3.389091641965744*^9, 3.389091657537798*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.3802775690976141`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.3802775690976141`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.8191725133961645`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8191725133961645`"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"nsol", "//", "Union"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "/.", "#"}], ")"}], "\[Element]", "Reals"}], "&"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.389091719431737*^9, 3.389091767500763*^9}, 
   3.389092387691032*^9, {3.389097356129688*^9, 3.389097357369535*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.3802775690976532`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.3802775690976712`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.8191725133961639`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8191725133961656`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.9999999999999994`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nullstellenbestimmung mit FindRoot", "Subsection",
 CellChangeTimes->{{3360075826.15024, 3360075840.85747}}],

Cell[TextData[{
 "Essentiell transzendente Gleichungen lassen sich mit den Kommandos ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 ", ",
 StyleBox["NSolve",
  FontWeight->"Bold"],
 " oder ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " nicht bearbeiten."
}], "SmallText",
 CellChangeTimes->{{3.36007644589768*^9, 3.36007650744319*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}], "+", "x"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.38909865462651*^9, 3.389098677170375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.3890910791485*^9, 3.389098677916531*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The equations appear to involve the variables to be solved \
for in an essentially non-algebraic way.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"3", "+", "x"}], "]"}]}], "\[Equal]", "5"}], ",", "x"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.36007595984762*^9, 3.36007596277636*^9}, {
   3.389090869120862*^9, 3.389090879439979*^9}, 3.389091079261645*^9, 
   3.389098679076361*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"This system cannot be solved with the methods available to \
Reduce.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"3", "+", "x"}], "]"}]}], "\[Equal]", "5"}], ",", "x"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.389091079338902*^9, 3.389098680854107*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The equations appear to involve the variables to be solved \
for in an essentially non-algebraic way.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"3", "+", "x"}], "]"}]}], "\[Equal]", "5"}], ",", "x"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.36007595984762*^9, 3.36007596277636*^9}, {
   3.389090869120862*^9, 3.389090894526888*^9}, 3.389091079520486*^9, 
   3.389098682463591*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "::", "\<\"nsmet\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The methods available to FindInstance are insufficient to \
find the requested instances or prove they do not exist.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"3", "+", "x"}], "]"}]}], "\[Equal]", "5"}], ",", "x"}], 
  "]"}]], "Output"]
}, Open  ]],

Cell["\<\
Der Plot zeigt, dass eine relle L\[ODoubleDot]sung von g1\[Equal]5 in der N\
\[ADoubleDot]he von x\[Equal]2 liegt. \
\>", "SmallText",
 CellChangeTimes->{{3.36007653820643*^9, 3.36007659833257*^9}, 
   3.38909868949809*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36007626139348*^9, 3.36007628496297*^9}, {
   3.36007633771846*^9, 3.36007642383248*^9}, {3.36007696083505*^9, 
   3.36007696613085*^9}, 3.389098691303842*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0.7046885463660756, 2.5471327689198597`}, {0.7165997052801466, 
     2.569754316453145}, {0.9262019467341961, 2.9494246403620976`}, {
     1.1217024941958975`, 3.2901876286503224`}, {1.3337135925632102`, 
     3.647599224987314}, {1.5316229969381747`, 3.9715637475687107`}, {
     1.7256347889534445`, 4.281338038805082}, {1.9361571318743254`, 
     4.609845880169789}, {2.132577780802858, 4.9100420429076905`}, {
     2.345508980637002, 5.229384589774059}, {2.5443384864787983`, 
     5.522467338973166}, {2.739270379960899, 5.8054929775307755`}, {
     2.9507128243486114`, 6.108119863634101}, {3.148053574743976, 
     6.386828320641936}, {3.208909966821653, 6.471720338648084}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{-4.9999997959183675`, 5.}, {-4.901856591951532, 
     5.}, {-4.803713387984696, 5.}, {-4.590916429145413, 
     5.}, {-4.392221164298479, 5.}, {-4.197423511811239, 
     5.}, {-3.986115308418389, 5.}, {-3.788908799017886, 
     5.}, {-3.575191738711772, 5.}, {-3.3653722907653534`, 
     5.}, {-3.169654536811282, 5.}, {-2.9574262319516, 
     5.}, {-2.759299621084266, 5.}, {-2.565070622576627, 
     5.}, {-2.354331073163377, 5.}, {-2.157693217742475, 
     5.}, {-1.9445448114159614`, 5.}, {-1.735294017449143, 
     5.}, {-1.5401449174746724`, 5.}, {-1.3284852665945908`, 
     5.}, {-1.130927309706857, 5.}, {-0.9168588019135122, 
     5.}, {-0.7066879064798623, 5.}, {-0.5106187050385604, 
     5.}, {-0.2980389526916474, 5.}, {-0.09956089433708235, 5.}, {
     0.09501955165778773, 5.}, {0.306110548558269, 5.}, {0.5030998514664022, 
     5.}, {0.7165997052801466, 5.}, {0.9262019467341961, 5.}, {
     1.1217024941958975`, 5.}, {1.3337135925632102`, 5.}, {
     1.5316229969381747`, 5.}, {1.7256347889534445`, 5.}, {
     1.9361571318743254`, 5.}, {2.132577780802858, 5.}, {2.345508980637002, 
     5.}, {2.5443384864787983`, 5.}, {2.739270379960899, 5.}, {
     2.9507128243486114`, 5.}, {3.148053574743976, 5.}, {3.3619048760449513`, 
     5.}, {3.5718585649862313`, 5.}, {3.767710559935164, 5.}, {
     3.9800731057897076`, 5.}, {4.178333957651903, 5.}, {4.3726971971544035`, 
     5.}, {4.583570987562515, 5.}, {4.780343083978279, 5.}, {
     4.9936257312996535`, 5.}, {4.996812763609011, 5.}, {4.9999997959183675`, 
     5.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 2.5},
  PlotRange->{{-5, 5}, {2.5471327689198597`, 6.471720338648084}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Diese kann mit ",
 StyleBox["FindRoot",
  FontWeight->"Bold"],
 " bestimmt werden."
}], "SmallText",
 CellChangeTimes->{{3.36007661766164*^9, 3.3600766404589*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36007630822087*^9, 3.36007631610474*^9}, {
   3.36007634772443*^9, 3.36007634958703*^9}, 3.389091079706916*^9, 
   3.389098693881547*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.1921549535928273`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g1", " ", "/.", " ", "%"}]], "Input",
 CellChangeTimes->{3.389098695348811*^9}],

Cell[BoxData["4.999999999999998`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "=", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"3", "+", "x"}], "]"}], "-", "x"}]}]], "Input",
 CellChangeTimes->{{3.36007895620801*^9, 3.36007897419477*^9}, 
   3.389090937017077*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"3", "+", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"g2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36007851258226*^9, 3.36007856652343*^9}, {
   3.36007861734892*^9, 3.36007863749143*^9}, {3.3600786790354*^9, 
   3.3600786953484*^9}, {3.36007898033526*^9, 3.36007898251125*^9}, 
   3.3890909393428*^9, {3.389099020218315*^9, 3.389099065265135*^9}, {
   3.389099150167825*^9, 3.389099154108057*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk0VP//B3Bblkjqg8pSKlkiinwqyWsoaUGyR1KWLAlZKhJCkiYqytYi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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-2, 4}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007951584244*^9}, 3.389090948852283*^9, {3.389099052024542*^9, 
   3.38909905219318*^9}, {3.38909927684121*^9, 3.38909928377543*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.20942669172202868`"}], "+", 
    RowBox[{"1.6658936308637091`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "1"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, 3.389090950756417*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"1.2742775055249624`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.324687714003715`*^-21", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "1"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, {3.36007954503472*^9, 3.36007955784933*^9}, 
   3.38909095332799*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "0.21051107467915794`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, {3.36007954503472*^9, 3.36007957602125*^9}, 
   3.38909095465242*^9, {3.389099513306256*^9, 3.389099513505991*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"nlnum\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The function value \\!\\({Indeterminate}\\) is not a list \
of numbers with dimensions \\!\\({1}\\) at \\!\\({x}\\) = \
\\!\\({\\(-1.`\\)}\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.4192518347260895`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "/.", "%"}]], "Input",
 CellChangeTimes->{{3.36007960889669*^9, 3.3600796212355*^9}, 
   3.389090990392324*^9}],

Cell[BoxData["1.1602997864518558`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"0", "+", 
      RowBox[{"0.001", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, {3.36007954503472*^9, 3.36007957602125*^9}, {
   3.36007976118401*^9, 3.36007982729906*^9}, 3.389090997362078*^9, {
   3.38909971408733*^9, 3.389099714463232*^9}, {3.389105416314259*^9, 
   3.389105458752028*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.20942669172202857`"}], "+", 
    RowBox[{"1.6658936308637087`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "10"}], ",", " ", 
     RowBox[{
      SuperscriptBox["x", "y"], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{"sys", " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389091057075512*^9, 3.389091058898647*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.2704333456136054`"}], ",", 
   RowBox[{"y", "\[Rule]", "2.8958589596789794`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", ":=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     SuperscriptBox["x", "2"], "]"}], "-", 
    FractionBox["x", "3"]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.36008071278601*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3k8lF8XwIcZDAYlW1FJQmVLthT3CZUlEkIqIRXKmiR7tp9UQhFCkiRK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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-4, 4}, {-2.3219876164983453`, 2.182733205511812}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36008072294103*^9, {3.389100222640972*^9, 3.389100225513729*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xk4VmkbAPCXcxAS2ZIlKkqKVCqGPE8mWwtRSaWFr4wi29BEtrImJGUp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., 0},
  PlotRange->{{2, 3}, {-1.9111302046184613`, 0.1666801407959171}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell["Nullstellenbestimmung mit dem Newtonverfahren.", "SmallText",
 CellChangeTimes->{{3.36021737045651*^9, 3.36021739010928*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.6"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.389091060752723*^9, 3.389091065473746*^9}, {
  3.389100373305137*^9, 3.389100391556699*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.371500399013327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.607739533346793`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Nullstellenbestimmung mit dem Sekantenverfahren. Hierf\[UDoubleDot]r muss",
 StyleBox[" f ",
  FontSlant->"Italic"],
 "nicht symbolisch differenzierbar sein. "
}], "SmallText",
 CellChangeTimes->{{3.36021737045651*^9, 3.36021739010928*^9}, {
  3.36021742169729*^9, 3.36021744485678*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2.4", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36021739588267*^9, 3.3602174028364*^9}, 
   3.389091066356257*^9, {3.389105505302523*^9, 3.389105559284412*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.607739533346793`"}], "}"}]], "Output"]
}, Open  ]],

Cell["Problem: Die Nullstelle kann in einem Extremwert liegen. ", "SmallText",
 CellChangeTimes->{{3.36021746197*^9, 3.36021748004205*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["f", "2"], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36008075190213*^9, {3.383383829257607*^9, 3.383383831685763*^9}, 
   3.389091067091527*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.6077395684207962`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Analyse in der N\[ADoubleDot]he von x=3.5: Suche mit Startwert und \
Intervallbegrenzung\
\>", "SmallText",
 CellChangeTimes->{{3.3600808830413*^9, 3.36008093428165*^9}, {
  3.36021618255396*^9, 3.3602161871564*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3.5", ",", "3.3", ",", "3.7"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.36008086520548*^9, 3.36008087739672*^9}, 
   3.389091067827691*^9, {3.389105868554471*^9, 3.389105868835657*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"lstol\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "3.5382550749920787`"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36008123376027*^9, 3.36008124581634*^9}, {
  3.36008128206075*^9, 3.36008130485945*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.18052837732747895`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.5382550755743796`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.36008114110913*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk8FV0fAHC5wy2JHooSIoqEtJLoSKUiEiqJUKLQaleW4pGiQoVKkbJU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-3., 0},
  PlotRange->{{-3, -1}, {-0.41367467890389076`, 1.8377423245846218`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1.5"}]}], "}"}]}]], "Input",
 CellChangeTimes->{3.389091068501084*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.996097496968613`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.43914014286382`"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.36008117231338*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VF8bAPAZSoPLRSrih0gkWyWR5dwkSUhCmyJ7QpJkKUuLvGQpGmv2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-4., 0},
  PlotRange->{{-4, -3}, {0., 2.182738705969471}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36008118764146*^9, {3.38910605057238*^9, 3.389106062219138*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VO0XAPBJykzKUm+2iFRosSQk25mUaJFsEdJQIvtSloSxvBJJlu7M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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-3.2, 0},
  PlotRange->{{-3.2, -3}, {0., 0.3809598533732642}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.389091069404374*^9, {3.38910684122126*^9, 3.389106841492409*^9}, {
   3.389106942292418*^9, 3.389106943146304*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"lstol\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "3.061095274048021`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.1"}], ",", 
     RowBox[{"-", "3.0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.389091069404374*^9, {3.38910684122126*^9, 3.389106841492409*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Failed to converge to the requested accuracy or precision \
within \\!\\(100\\) iterations.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "3.1007487001631855`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36008123376027*^9, 3.36008124581634*^9}, {
  3.36008128206075*^9, 3.36008130485945*^9}, {3.36008133971593*^9, 
  3.36008135752188*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.021848415618382577`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "3.0610952748000466`"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerische Integration", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36012439327498*^9, 3.36012440323138*^9}, {
  3.389107478403149*^9, 3.389107479658545*^9}}],

Cell["\<\
Numerische Bestimmung definiter Integrale ist eine M\[ODoubleDot]glichkeit, \
wenn keine Stammfunktion in Termini anderer Funktionen berechnet werden kann.\
\
\>", "SmallText",
 CellChangeTimes->{{3.36012406871449*^9, 3.36012414745808*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36012400145919*^9, 3.36012403938*^9}}],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "2"], 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellChangeTimes->{{3.36012404949584*^9, 3.36012405235663*^9}}],

Cell[BoxData["1.4820284164298259`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Ergebnis von ",
 StyleBox["Integrate[f,{x,a,b}]//N ",
  FontWeight->"Bold"],
 "und ",
 StyleBox["NIntegrate[f,{x,a,b}]",
  FontWeight->"Bold"],
 " ist dasselbe.\n",
 StyleBox["NIntegrate",
  FontWeight->"Bold"],
 " geht in einem solchen Fall aber schneller, weil der Aufwand zur \
Feststellung, dass es keine Stammfunktion in geschlossner Form gibt, nicht \
anf\[ADoubleDot]llt."
}], "SmallText",
 CellChangeTimes->{{3.36012416125896*^9, 3.36012426718613*^9}, {
  3.36012430013903*^9, 3.36012433260889*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36012400145919*^9, 3.36012402892309*^9}}],

Cell[BoxData["1.4820284164298259`"], "Output"]
}, Open  ]],

Cell["\<\
Integration einer Funktion mit Sprungstelle im Integrationsintervall. \
\>", "SmallText",
 CellChangeTimes->{{3.36012434505273*^9, 3.36012436114145*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", "x", "]"}]}]]]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.36012438491806*^9, 3.36012438709391*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Hk0ldv/B3AkkUrGKDI1ytVgqtDnUInyVRSlImSOMkWDQmS+QjIPRaiu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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, Pi}, {-1.4142135507036997`, 1.4142134725273803`}}, {{
     0, 3.141592653589793}, {-1.4142135507036997`, 1.4142134725273803`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sf", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{"f", " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"Sin", "[", "x", "]"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"\[Pi]", "/", "2"}]], 
  RowBox[{"f", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData["2"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["2.000000000000004`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"3", 
    RowBox[{"\[Pi]", "/", "4"}]}]], 
  RowBox[{"f", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", "-", 
  SqrtBox[
   RowBox[{"4", "-", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "//", "N"}]], "Input"],

Cell[BoxData["0.9176077997076062`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sf", "[", 
    FractionBox[
     RowBox[{"3", "\[Pi]"}], "4"], "]"}], "-", 
   RowBox[{"sf", "[", "0", "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.3602194284618*^9, 3.36021946671504*^9}}],

Cell[BoxData[
 RowBox[{"2", "-", 
  SqrtBox[
   RowBox[{"4", "-", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"sf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.3601244914122*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw11fs/1Ikex3G3ZEqLhLSVUCpsNizbztTnm3LvSCknRy5NONNUcgtrXcpl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, Pi}, {-1.9999999358858631`, 0.}}, {{
     0, 3.141592653589793}, {-1.9999999358858631`, 0.}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({1.5692989651348017`}\\). NIntegrate obtained \\!\\(0.9170805749970934`\
\\) and \\!\\(0.0008453999243025678`\\) for the integral and error estimates.\
\"\>"}]], "Message", "MSG"],

Cell[BoxData["0.9170805749970934`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3602198108093*^9, 3.36021982169651*^9}, {
  3.36021989020716*^9, 3.36021989121504*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData["0.9176072876547609`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "40"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36021984286223*^9, 3.36021984325235*^9}, {
  3.36021990108399*^9, 3.36022002182653*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData["0.9176077997238781395445788176612483553`20."], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox["\[Pi]", "2"], ",", " ", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["0.9176077997076337`"], "Output"]
}, Open  ]],

Cell["Beispiel: Mehrdimensionales Integral", "SmallText",
 CellChangeTimes->{{3.3601251221729*^9, 3.3601251228908*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", ":=", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "+", 
     FractionBox["21", "10"]}]]}], ";"}]}], "Input",
 CellChangeTimes->{3.3602355640818*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36012496944293*^9, {3.36022236206055*^9, 3.36022236663199*^9}, {
   3.36022240808796*^9, 3.36022240848814*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyUnXlcTd/3/5tL422e53mekeKeEDLLTGTIECIyU8iUmUyZh2RK3iWSDPcq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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNnQf0FLX39mf7zO7OrooVOwKCFXtX7L2jYAFEQMUOiF0pIthRmohYQIoi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         "]], Polygon3DBox[CompressedData["
1:eJxFnXn8DuX3/+deZ+577rlv7aUNrWihEmnRKilr0a6SFtlSkSKkUoSiQrTK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         "]], 
        Polygon3DBox[CompressedData["
1:eJwl13m4l2MaB/D3pLOf3zmVqKQ47Sl1pE6LFlooaWGSZSaMGVyGRBg1TUWr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         "]], 
        Polygon3DBox[{{2873, 2961, 1856, 2099, 3855, 2872}, {2882, 2968, 1860,
          2767, 3896, 2881}}]}]}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1lktsVVUUhnd77rntPeXeUsMjSkFwwkRjgi1GKTEptEZoIy3oQEc2kURU
SoSxDrQ8jOhQGQESg4ImtjVRnACFFgoFE3mZqI2JsQ3EmBhhAgj+X/7lYOeu
vc9er3/9a+27bGCwf2t9SmlSK9NaWE7przyld7QZq6TUX6R0VfImnW/Uaq9L
aWJOSverKT0uxe90Z6iwzP33Ja+p99mxis8XS2+JVk12l2m/VvYek50fZWN7
U0o/yO8npZTW6XyFzo9KbtVaKblXej1ln5/T94dlo1M2zkr3NemOS3dM8pu1
lE7r+1s6+1f7izr/THcntJbq/knFPFm1/2HF1dxg3eM675DuEuKM2Dgf1Nk2
rRbp7y75HF18ocP9KZ0t1Pe2et/HB3fGM/uckJ1ZySsltyn+6/qdm1v3uO7f
VqyP1tnP1vBFflcy54jd9ZKfqLONnsx2jgQ+4LxdehNVY7O/5DuX5fdwyXXD
zquSRyX/It1vlPcO5d+r/R3VaJ72fcL3TNW2sAOuYAQOuzLHQCwLFNt54pH8
vb73FMZgRr8bG22/Wbbmam2Wz3HdH82d4z3ZXyv7i3Q+LJ83pf+Q5OuZc/k1
OUZinaf7XzY6zi75+lRnu7TaJU9HPvjanTlfsLkQcV6SneXSG2gw3hsUy/Nl
8+Hj4BicvKMcX6+ZkyO6+2zh3KnNzpJjxh9+wX++7k1m5iqcBXNkeLi6Zly6
5Get1lBmvsAbMFyl7/tqtvWy7OzR75WI88NG8+5gyTao7y3duZkbD1Zd7nxb
Ay/6YlC679Jr2r+UO2Zi/6jR/KO/yPFUzTKYgR3Y/i69byvuqa+V+23t1ynu
V4In3HlbZ/XSby27VvQU9YIXOwv3GhxnTsDzU7lnB/sHde+W7tzLzYs/Csf/
or6/EDNkKjgFtoeq7gVyGY8+I2Y4uaXZc4TzB2J+kNPdJt9h/nQXrs2WJvcR
8UxK76LkfwrPj/UxQ6Z0/4PCMcAPMKPW9OMlrbHcfXi+Ej2bmbNgDr/aI+aa
7B0KzKj14oi5pewegP8nZOO5wv38Rck9Rz9ONzt+cDomn+urrs2Qfg/q27aK
+dATvUbu1BW84c+M9o9I7i6bc0OBzXjUAh6hj+7h8Dut8wMl4078zKUFDe6d
1bLRofVknXuU2U7OYDAbnFyae55gZ0/wmBj2Kr9FsnMjM/fXRDzotkSszGZ4
A2fG5rhOxIm9z0vGpDs4SR05J2589YbcGX0J108n9+yGwnXZkRk/ODZf55sb
PAPfqLnHqc0B4TdSMSb0Ykf0I+/byYp9Eit50Zvwl/rcZz5o/ZS7L+h13hEw
prajDa4vfUzd8MVcJAawpk//1n46d9+MBA6z4Q9fYL0vOMZ84i1kRp2RzrXA
+W7VvCEmepYeXhEz4UjMT+o5GzZ/C179nJtX9NiamLVH4+24nNsH9nkX+gpz
oCf40xby/uAS7zWcJl/qTh8tzx0zs5UZ+7Tq/1TZc3tDYEte5HwgZmlf4Iav
vfp+Q/vO4OCq4CF4DwfmvDXUjxjA46uImdh2x3tHHPQqOPC2D8T7/l7mPqfH
/4xazgv+w9GZeDcuRG/Dx3PRp7xZ/J8gL94sZkd7zIFd8db839vcvyrMT2g9
U/bM76qZq8zPa5L7Y/5tihn4H/8TPHg=
         "],
         VertexColors->None], Polygon3DBox[CompressedData["
1:eJxFlU1sVlUQhk+/r/fW+5XvFpoiUUStm24gJFQkoRbESitFFLpwwY4uSOSn
JcAaFgpWQnGpJCRUqokGTSw10boRCi0USU3ozwasRAJJy09CKC5oqT4v7zUs
JjlzZ86ceWfemVvd2t7SlgshtCOlyL/FEAbnhXAcZTHyThrCHN+GsX2BfhZ9
HFkTh3ACvbcshA0Fn1eV+O6OihCaCo7xcxJCI+cvOa/AfotzB9/250O4jn6c
WHXIBeJvjULYTryFyCLOV/DZiW0XUoGeIj8gq3j7M+K9RuITvDVLfq9y/vy5
ELYQ/yfub+Lud/jsLXf+wjLJt/28/T1+E8E+94h3F6kilwliPOB+Oz4N2P6K
/P4MMZZhX4K9Hv0S8Qa430HMo/hfSRy7Bv/fwN+P/QJ6LXcOYL9dMNaSDN97
6Ce5Oxqc+yVifhMZQzfYHnHu5f42fLo5L4mNXTWYRT5EX0m8KXzeTP2m3voU
/0psA/gsRT+MfoL4famxqebvYm9C/uDtIfT3OW+K3Ztm9KGiMQpbNXcGiXUe
OZh3fjfJ/UcwNHNnAzKM71CFe3oHv7OJOSI+iBePqV03MT/JO6evI+eo3NRz
5af7D/GdwnYfGUEGg98Uz+pjc0sxu+jdr4m50YU+yP19vPEKdy7nja0ROZQ3
xh58P8L+PPbDvNGJ/nfBNvnobeWg2gjDMeLXqJ855yzufYXPxwXXvwrsM5w3
x56JMez985yv8latFU9YTiNnEuesXMWJXLk5IS6ciswF4anNmRPiiuwvEf8f
7NOZX0nGiRH1O3UteyPPq2ZUs7k851pc5dtY3jWZyjALawMxW9D7xW98T5ca
zzR6C7Ytqhv2XxJzYyH3N2b8EZZrSCv+Fcj8yDXag609NVcq+fak6HiKq/qo
ppr5yegZP1T/dbz1VuzaqsaarT2J+7U7dXy9o7Pm6eWcvz3O+Ce+buT+ucSY
hOWNEud7I/VcP+V84n0g/qzPmd/n6Nfr6L/nzQ3Ns87iiLirHJXbWuSD2DOi
2RCeHu2h2LOpnaHeiwOjkffRkay+45qXyPOpHafdJgyKrf6If6rDZuRMmbn7
bal358VixmVsi7F1Frxb/gy2a8eq131ZLdXft2PXVNjUjwWRMbal7lFlNlNN
2XuqlfZzY9ZvxdOOlv8OanI77xg6C6Ow6dtsuXeudq124vpsf2v3nPp/HlNz
RxjFB+1g7ccXS90vYRZW1UjzoblU7TUD2qU9ZfbVnTowrY7dO/VQ/NN8ii/a
wdq/qo92oXai/kf6B2j3awa0W7VjX0Cfi8y3Q0Xvd830f5FC+SI=
         "],
         VertexColors->None], 
        Polygon3DBox[{{3799, 2548, 1969, 309, 1619}, {2789, 2131, 1126, 1552, 
         1513}, {2487, 2787, 1609, 1608, 969}, {3699, 3527, 2489, 2693, 
         1301}, {3491, 3461, 2416, 2190, 900}, {3779, 3067, 1294, 1566, 
         1533}, {2131, 2790, 1526, 1553, 1126}, {3066, 3775, 1474, 1503, 
         835}, {3068, 3779, 1533, 1535, 1049}, {2691, 2415, 1502, 1443, 
         1295}},
         VertexColors->None]}]}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtkztMFVEQhg/s3b3seh8aY6EWhtiCxBgSAS3UGK2tBF8IEVETID54SCgo
tLDRXqC3thE6NTGxMCFU3KsRn1GjEh+98fvzn2Ky5/xnduaff2bah8ZPjbWG
EEawBPtbDmE2D2GyhXMphEXAHvCDaQi93E9y/o5PVoQwgc8S74fA73DeBE8L
++2vh7CtZp9O7oexu5znwPdgu3K/d1bs8477C+xN4vj9hXNPFeYzwLnEuQ3r
IdZ6NYQZ/n8NfoJ4vViDt3IGB6yr5Psv7Cb3z/D/hA3hf5t4f8Dfp65RNYj/
FH6T2DjnBWKvYbPcL2Mj2EPwZfyfYBcQrQmHJj7XMscUV/GcBmvwdr3FOnzE
Et4y8LdYJo58S1gHsWp8t9asm/D5mjV7hV9Pbt2egbWj1RDnli3UT7xH8O9O
zUcaLuL7s+x66vhXa9ZK78vRZwBeHRXXeC8xX8Vs4LsdGybnS74b+NzIrLl4
iMNT8AMVz8Yg9e8ruUblfd5mrFyYg3D1cCF3H3fA+VvVGn6F83LqvMo/HDnk
hettS8xTPf1HzB/gTewqPAbBV2r22YiarKSu6WjVdc3l1met1bVLo47YZ/Vb
83yFWKOxp4sR1wwcq1g3nWd4n47zoLm4Fc/qr2Zvb+q5uBTjHKmawyp5l3jb
Db5J3A/U0VXxfkwoRua5Vd+VT7nUJ+2Y9mundiHzjPXVrdu/xPuh/dKOHAd7
UHWN2okk7sVonFfxOcf3bObapZt6IFx9U371qC/uuDj043s65tV+rcJvLPOu
SlPl+g3H+5lnR9pMRU3E+XHh2sVdfVcc5T8TOWh2tPuan/m4+5rz9bgL5/G7
qB7HeVONmnvNRpO8X1JzkCaNumdCc9ede/a0c9JZdf0HDAyZHA==
         "],
         VertexColors->None], Polygon3DBox[CompressedData["
1:eJwtlM9vTVEQx8/T987rq953iVhgQWPbEosm2hJBhJWFlVZEtRIbtCz8aiws
WNjwB5R/wqbtDkkTC0nTVVuiTStCRIUmluLzydzF5J45M2dmvt+ZuT1jExdu
bUspnUfqyFQrpa1mSuMdKY0g0+jzOaUBbC+94zyMXOHRDA9Wu1N6307pDnej
3C1ynkauN1I6wN1jzg2kF99+7nrwf4v+lfMcMov8Rp4Re6yW0k3e3EA+oR/k
/gG+942P7SN3BefTxDiKbYCYK+grRfj7brBM6SzST93/qOckthn0X10pPcT+
HFlvBDZzvsD+CPte/Bfxz/j9aAbWIeLv3g4ufDrRz8HBa+x7WoFfjO868UV/
1REczXNeM3flb61tahysR823yT+ZA8uhetS+XMYbMfTiP1JE7cZbLgK/XGiX
W/FYh/ntzzDn2XrUtIGtbAc3HdzvaEf+J/B3jLsv2OfQr1HDX+zrZfhoa6K/
4ZwV7BvEP1VETdayQPzvRXAiNjF+rvwP877Bmz58d6IfR+9D/sh7K/iW90s5
ZsjZcSbslTPk7NiziznmRmziGa76MVkLjGK3p9YiB+LZRb4T2Fpdgf9IGf65
wi/GzWb0oNEVPbJ+dbnyjb7221jGlJtx6vjZDF7kxx53cq4jT2uBca7yN7cz
Yi+HyuBmrdod52Wh6qf7dQ/fTd7erQVf7oi7Yc3is8dTOWZ2jO/VHPnEaD3O
m3y5EwOtyK1NnwXeLhUxXxM5emNPzWWP6tqRyzn4d/7PFLF77rz7uYr9WyPu
3A19tPlfGHX3c/TWfO69M+0sW9P+Mt7oa84t4jRz5FaX3+V24LLmJWqvMU8r
jdg/8XzI0R/59CzfzrN3+3LENJYcHu6O/toj+fD/YE/tpTPvTLmjcu9O/Qfd
ppwK
         "],
         VertexColors->None], 
        Polygon3DBox[{{3295, 3911, 2777, 1652, 1651}, {3123, 3777, 1507, 1509,
          866}, {3601, 3889, 2563, 2568, 1085}, {3119, 3545, 988, 2565, 
         2030}, {3871, 3123, 866, 2429, 2330}, {3778, 3397, 722, 1511, 
         1510}, {2776, 2429, 866, 1508, 1449}, {3588, 3589, 1069, 1631, 
         1630}, {3770, 3424, 411, 1637, 1636}, {3394, 3393, 1658, 1657, 
         367}, {4057, 3546, 1643, 1642, 2778}, {2679, 2426, 1505, 1438, 
         1262}, {3705, 3544, 1646, 1645, 1315}},
         VertexColors->None], 
        Polygon3DBox[{{3898, 3418, 367, 1653, 2800, 2777}, {3561, 3899, 2778, 
         2796, 1641, 411}},
         VertexColors->None]}]}, {}}, {{
      Line3DBox[{1250, 1, 1055, 314, 2821, 16, 1053, 2825, 31, 355, 2827, 46, 
       870, 376, 3495, 918, 61, 3145, 395, 76, 3607, 1092, 91, 2855, 106, 
       2870, 2871, 121, 2888, 136, 2892, 151, 2897, 166, 3575, 1042, 181, 
       3264, 543, 1569, 1570, 1571, 1572, 3787, 1573, 1574, 2807, 1575, 1576, 
       1577, 1578, 1579, 1580, 2808, 1581, 3796, 1582, 1583, 1584, 1585, 1586,
        1587, 3786, 1588, 1589, 1590, 1592, 1447, 1815, 214, 1187, 1816, 215, 
       2213, 570, 216, 1381, 2215, 572, 1308, 217, 2738, 1382, 574, 1310, 218,
        2218, 576, 1817, 219, 1000, 1818, 220, 1623, 1463, 1486, 1462, 1482, 
       3781, 1536, 1446, 2798, 1452, 1480, 1504, 1481, 1460, 1476, 2795, 1461,
        1494, 1527, 1493, 1519, 1560, 1483, 1555, 2809, 1520, 1484, 1528, 
       1485, 3782, 1556, 1464, 1487, 1500, 1501, 1448, 223, 2635, 1182, 224, 
       2744, 1394, 225, 1426, 2934, 210, 2920, 195, 2910, 180, 3633, 1137, 
       165, 3572, 1037, 150, 3323, 645, 950, 135, 3733, 1363, 467, 2886, 120, 
       992, 2868, 105, 990, 2853, 90, 415, 2840, 75, 1337, 3140, 391, 1268, 
       60, 864, 3121, 372, 916, 45, 3103, 351, 30, 3087, 332, 910, 15, 851, 
       331, 1719, 14, 1008, 1718, 13, 1717, 12, 1715, 11, 1713, 10, 1711, 9, 
       2511, 1006, 1709, 8, 322, 1252, 1708, 7, 848, 320, 2674, 1251, 6, 318, 
       1707, 5, 2509, 1003, 4, 1704, 3, 1702, 2, 2221, 583, 1250}], 
      Line3DBox[{1444, 196, 3653, 1186, 565, 973, 211, 903, 564, 1303, 1813, 
       212, 904, 566, 1814, 213, 1161, 1591, 1453, 1495, 1479, 1492, 3797, 
       1491, 1518, 1559, 1475, 1478, 1445, 3784, 1534, 2805, 1535, 1533, 1566,
        1565, 1443, 1502, 2801, 1503, 1474, 3795, 1459, 1477, 1554, 1444}], 
      Line3DBox[{1819, 221, 1194, 579, 2698, 1312, 222, 2220, 581, 1593, 1594,
        1595, 1596, 1597, 1598, 3798, 1599, 1600, 1601, 1602, 2794, 1603, 
       1604, 1605, 1606, 1607, 1608, 1609, 1610, 2810, 1611, 1612, 1613, 1614,
        1615, 1616, 2811, 1617, 1618, 3799, 1619, 1620, 1621, 1622, 1532, 
       1002, 1819}], 
      Line3DBox[{1660, 1557, 1489, 1558, 1439, 1544, 1538, 3783, 1537, 1539, 
       1469, 1545, 1547, 3793, 1546, 2812, 1455, 1471, 1548, 1470, 1549, 1472,
        2813, 1456, 1531, 3780, 1441, 1450, 1529, 3803, 1530, 1440, 1540, 
       1437, 3804, 1490, 1454, 2814, 1468, 1561, 1562, 1522, 1467, 1497, 2815,
        1567, 3805, 1660}], 
      Line3DBox[{1652, 1651, 3785, 1650, 1649, 1648, 1647, 3792, 1646, 1645, 
       1644, 3802, 1643, 1642, 2796, 1641, 1640, 1639, 1638, 1637, 1636, 2806,
        1635, 3801, 1634, 1633, 1632, 1631, 1630, 3800, 1629, 1628, 1627, 
       1626, 1625, 1624, 1568, 3794, 1659, 2799, 1658, 1657, 1656, 1655, 1654,
        1653, 2800, 1652}], 
      Line3DBox[{1679, 1506, 2802, 1505, 1438, 1563, 1523, 1543, 1541, 3806, 
       1542, 1507, 1509, 1508, 1449, 2817, 1498, 1511, 1510, 1466, 3807, 1512,
        1465, 1521, 1679}], 
      Line3DBox[{1699, 1525, 1524, 1442, 2818, 1564, 1526, 1553, 1551, 1552, 
       1513, 1515, 3790, 2803, 1514, 1451, 1499, 3808, 1517, 1516, 1458, 1496,
        1457, 1550, 1699}], 
      Line3DBox[{1698, 1697, 1696, 1695, 1694, 3791, 1693, 1692, 1691, 2819, 
       3901, 1690, 1689, 1688, 1687, 1686, 1685, 1684, 2804, 1683, 1682, 1681,
        1473, 1700, 1698}], 
      Line3DBox[{1666, 1665, 1664, 1663, 1662, 2816, 1661, 1488, 1680, 1678, 
       1677, 3788, 1676, 1675, 1674, 1673, 2797, 1672, 1671, 1670, 1669, 1668,
        3789, 1667, 1666}]}, {
      Line3DBox[{2821, 3076, 3275, 1820, 2820, 3753, 3754, 4092, 2935, 2822, 
       3077, 3584, 4063, 2936, 3078, 3706, 3707, 3552, 4054, 2937, 3079, 3708,
        2703, 3553, 2938, 3276, 3840, 3902, 3277, 3386, 2939, 3346, 3873, 
       4027, 3414, 3278, 3387, 2940, 3080, 3958, 2991, 3280, 3388, 3809, 4021,
        3279, 3082, 3903, 2941, 2823, 2992, 3084, 3960, 2942, 2824, 2993, 
       3085, 3961, 2943, 3281, 3842, 3904, 3086, 2944, 3554, 3828, 3905, 3543,
        3703, 2945, 3542, 2517, 3555, 3088, 3389, 2946, 3087}], 
      Line3DBox[{2825, 1054, 3089, 911, 4043, 3282, 852, 3347, 1829, 2826, 
       3090, 3556, 4055, 2947, 3283, 3091, 3679, 4082, 2948, 3284, 3843, 3906,
        3285, 713, 3348, 3841, 3907, 3286, 714, 3349, 4015, 3081, 3287, 2949, 
       3350, 4016, 3083, 3288, 3810, 3959, 3094, 2994, 3351, 3811, 3947, 3096,
        2995, 3098, 4022, 715, 3097, 1058, 3099, 4044, 913, 3352, 3829, 3908, 
       3559, 2950, 3100, 755, 3909, 3289, 716, 3101, 3963, 758, 855, 717, 
       3103}], Line3DBox[{2827, 3415, 2996, 3494, 3390, 3391, 4023, 3290, 
       3468, 3654, 3104, 3657, 3655, 3964, 3656, 3557, 3558, 2997, 3659, 2645,
        3658, 3291, 3470, 3107, 3587, 4064, 3585, 3586, 3353, 3844, 3910, 
       3292, 2951, 3354, 4017, 3092, 3293, 2952, 3355, 4018, 3093, 3294, 2953,
        3111, 3968, 3095, 3356, 3812, 3962, 3113, 3416, 2998, 3357, 3813, 
       3948, 3114, 3417, 2999, 3358, 3870, 3949, 3392, 3115, 3660, 3000, 
       3805}], Line3DBox[{2840, 3427, 3018, 3142, 3017, 3951, 3875, 2839, 
       3426, 3016, 3369, 3015, 3950, 3425, 2838, 3014, 3780}], 
      Line3DBox[{2853, 3563, 3028, 3610, 3027, 3431, 4032, 2852, 3430, 3026, 
       3159, 4031, 3831, 3429, 2851, 3171, 3547, 4052, 3851, 2850, 3477, 3850,
        3926, 3372, 3170, 2849, 3475, 3848, 3925, 3305, 3158, 2848, 4058, 
       3562, 3025, 3157, 3024, 2847, 4059, 3166, 3371, 3165, 3978, 2846, 3023,
        3370, 3022, 3720, 3618, 4070, 2845, 3616, 3617, 3154, 3304, 2062, 
       3718, 3613, 2844, 3502, 3612, 3151, 3303, 4047, 3847, 3611, 3504, 3682,
        3503, 3717, 3846, 4078, 3664, 3148, 3663, 2843, 3830, 3924, 3147, 
       3021, 3428, 2842, 3498, 4046, 3020, 3146, 3019, 3608, 2841, 4020, 3144,
        3302, 3143, 3714, 3607}], 
      Line3DBox[{2855, 3029, 3160, 3030, 3980, 2854, 3031, 3161, 3927, 3832, 
       2856, 3162, 3306, 3928, 3849, 2857, 3032, 3163, 3929, 3833, 2858, 3614,
        3719, 3615, 4069, 3164, 3433, 3505, 3432, 2859, 3476, 3665, 4005, 
       3882, 3307, 3507, 3683, 3506, 2860, 2588, 3721, 3619, 3167, 3509, 3684,
        3508, 2861, 3979, 3168, 3308, 3621, 3620, 4071, 2862, 3169, 3309, 
       3722, 4087, 3892, 2863, 3715, 3716, 3895, 4093, 3756, 2864, 3726, 3727,
        3930, 3758, 3757, 2865, 3852, 4006, 3310, 3172, 2866, 3853, 4007, 
       3311, 3479, 3478, 2867, 4033, 3434, 3435, 3173, 3565, 3564, 2868}], 
      Line3DBox[{2871, 3175, 3912, 2960, 3185, 3177, 3913, 2961, 2873, 3187, 
       3189, 3984, 2962, 3188, 3033, 3191, 4025, 3400, 2963, 3190, 3835, 3914,
        3373, 3401, 2964, 3192, 3442, 4034, 3878, 3194, 3402, 2965, 3193, 
       3879, 4035, 3445, 3316, 3666, 2966, 3667, 4079, 3480, 3481, 3317, 3742,
        1858, 3741, 3724, 3747, 4090, 2967, 3760, 3759, 3768, 4095, 2968, 
       2882, 3729, 3915, 2969, 3730, 3731, 2722, 3623, 2970, 3195, 3858, 3916,
        3732, 3752, 2971, 3566, 3888, 4060, 3567, 3374, 3624, 2972, 3733}], 
      Line3DBox[{2886, 3446, 3447, 3184, 3983, 3836, 2885, 3183, 3315, 4009, 
       3857, 2884, 3182, 3314, 4008, 3856, 2883, 3893, 3937, 3728, 2881, 3896,
        3936, 3765, 3767, 3766, 2880, 3897, 4094, 3761, 3725, 3723, 2879, 
       3860, 3935, 3685, 3686, 2683, 2878, 3443, 3510, 3444, 3181, 3513, 3622,
        4072, 3884, 2877, 3511, 3512, 3180, 3877, 3982, 3441, 2876, 3439, 
       3440, 3179, 3876, 3981, 3438, 2875, 3834, 3934, 3178, 3437, 3436, 2874,
        3859, 3933, 3186, 2872, 3855, 3932, 3313, 3176, 2869, 3854, 3931, 
       3312, 3174, 2870}], 
      Line3DBox[{2888, 3196, 3318, 3817, 3985, 2887, 3198, 3319, 4010, 2973, 
       2889, 3034, 3320, 4011, 2974, 3200, 3035, 3375, 4080, 3668, 2975, 3669,
        3625, 3734, 3626, 3917, 3202, 2976, 3376, 3448, 2386, 3203, 3791}], 
      Line3DBox[{2892, 3197, 3209, 3819, 3986, 3378, 3199, 3324, 3820, 3987, 
       2893, 3201, 3212, 3990, 2983, 3211, 3036, 3213, 3991, 2984, 3568, 3569,
        3710, 3837, 3922, 3215, 3405, 3406, 3214, 3711, 4085, 3037, 3570, 
       3629, 3630, 3216, 2603, 3631, 3038, 3217, 3549, 3550, 3548, 4053, 3571,
        3039, 3219, 3821, 3952, 3325, 3218, 3635, 3822, 3992, 2894, 1875, 
       2895, 3220, 3636, 4075, 2985, 3326, 3862, 3923, 3379, 2986, 2896, 3993,
        3221, 3327, 2987, 3573, 4061, 3574, 3040, 3328, 2988, 3572}], 
      Line3DBox[{2897, 3041, 3224, 3823, 3953, 3380, 3210, 3824, 3989, 3381, 
       3042, 3576, 3825, 3954, 3226, 3449, 3043, 3228, 4026, 3407, 3408, 3227,
        3450, 4036, 3044, 3231, 3409, 3410, 3230, 3451, 4037, 3045, 3234, 
       3514, 3515, 3233, 3891, 4074, 3046, 3237, 3411, 3412, 3236, 3994, 3452,
        3047, 3240, 3413, 3955, 3872, 3329, 3485, 3239, 3242, 3826, 3995, 
       3634, 3244, 3245, 3827, 3996, 3382, 3672, 3247, 3331, 2474, 3671, 3517,
        3330, 3486, 3746, 4042, 3248, 3333, 3688, 3689, 3687, 4083, 3222, 
       3335, 2989, 3632, 3890, 4073, 3223, 3337, 2990, 3633}], 
      Line3DBox[{2910, 3254, 3338, 3253, 3998, 2909, 3252, 3336, 3251, 3997, 
       2908, 3690, 3250, 3334, 2169, 3736, 3642, 2907, 3487, 3641, 3863, 3939,
        3332, 3249, 3673, 2906, 3459, 4039, 3065, 3246, 3064, 2905, 3881, 
       4038, 3063, 3243, 3062, 3458, 2904, 2409, 3061, 3241, 3060, 3490, 3457,
        4048, 3519, 3456, 3489, 3059, 3238, 3058, 3488, 3957, 3880, 2903, 
       3516, 3639, 3057, 3235, 3056, 3956, 3579, 2902, 3578, 3055, 3232, 1960,
        3455, 2901, 3454, 3838, 3938, 3229, 3054, 3453, 2900, 3712, 4086, 
       3053, 3577, 3052, 2899, 4000, 3051, 3050, 2898, 3999, 3049, 3225, 3048,
        3575}], 
      Line3DBox[{2920, 3749, 3748, 4091, 2919, 3271, 2204, 2918, 3651, 3269, 
       3383, 4050, 3867, 3678, 3525, 3698, 3521, 3773, 3943, 3262, 3772, 3466,
        2917, 3465, 3839, 3942, 3261, 3075, 3464, 2916, 4003, 3074, 3260, 
       3073, 3463, 2915, 4002, 3072, 3259, 3071, 3462, 4049, 3524, 3520, 3070,
        3640, 3069, 3650, 3523, 4084, 3697, 3518, 3649, 3258, 3674, 3257, 
       4089, 3739, 3648, 2914, 3647, 3738, 3267, 3551, 4076, 3866, 3646, 2913,
        3638, 3865, 3941, 3340, 3256, 2912, 3637, 3864, 3940, 3339, 3255, 
       2911, 3796}], 
      Line3DBox[{2934, 3274, 3750, 3751, 2750, 2933, 3492, 3493, 3345, 3886, 
       4013, 3541, 2932, 3539, 3540, 3782}], 
      Line3DBox[{3121, 3396, 3471, 3395, 3297, 3001, 3709, 2524, 3560, 2955, 
       3296, 3102, 4040, 3467, 3118, 2954, 3804}], 
      Line3DBox[{3140, 3605, 3604, 3141, 3122, 3969, 2828, 2959, 3368, 3120, 
       4097, 3803}], 
      Line3DBox[{3145, 3419, 3003, 3473, 3004, 4028, 3874, 2829, 3420, 3606, 
       3005, 3360, 3006, 4029, 3421, 2830, 3422, 3007, 3127, 3008, 4045, 3497,
        3680, 3499, 3609, 3129, 3662, 4077, 3845, 3500, 3681, 3501, 2041, 
       3299, 3130, 2831, 3974, 3149, 3363, 3150, 2832, 3975, 3152, 3365, 3153,
        2833, 3976, 3155, 3367, 3156, 3977, 2834, 3009, 3135, 3010, 4056, 
       3887, 2835, 3011, 3138, 3012, 4030, 3423, 2836, 3602, 3013, 3793}], 
      Line3DBox[{3264, 3460, 3771, 3787}], 
      Line3DBox[{3323, 2982, 3208, 3207, 4088, 3735, 2981, 3921, 3894, 2891, 
       2980, 3920, 3861, 3322, 2979, 3919, 3206, 2890, 2978, 3918, 3762, 3763,
        1866, 3764, 3743, 3745, 3744, 3321, 4081, 3818, 3670, 3205, 3628, 
       3627, 3988, 3204, 2977, 3404, 3377, 3483, 3482, 3901}], 
      Line3DBox[{3495, 3469, 3474, 3788}], 
      Line3DBox[{3781, 3268, 3774, 2929, 3869, 3945, 3385, 3273, 2928, 4014, 
       3676, 3677, 3344, 3537, 3536, 4051, 2927, 3534, 3535, 3343, 3533, 2492,
        2926, 3531, 3532, 3342, 3885, 4012, 3675, 3530, 2925, 3701, 3702, 
       3700, 2760, 3755, 2924, 3868, 3944, 3384, 3272, 2923, 3900, 4096, 3341,
        3786}], 
      Line3DBox[{3783, 3973, 3816, 3137, 3136, 3596, 3972, 3815, 3134, 3133, 
       3301, 3971, 3814, 3366, 3132, 4004, 3300, 2958, 3364, 3112, 3970, 3131,
        2957, 3362, 3110, 4019, 3361, 2956, 3298, 3109, 4065, 3595, 3128, 
       3594, 2556, 3661, 3002, 3593, 3125, 3496, 3967, 3883, 3126, 3108, 3592,
        3591, 3124, 3399, 3966, 3398, 3359, 3106, 3789}]}, {
      Line3DBox[{1702, 2758, 1821, 4092, 1703, 1993, 1829, 1721, 1064, 2520, 
       3964, 1200, 1728, 860, 2036, 3966, 723, 1736, 772, 4029, 2051, 724, 
       1269, 928, 4046, 2074, 728, 1750, 3927, 1930, 2098, 1849, 1758, 3932, 
       2099, 1856, 3913, 1766, 2124, 1863, 4010, 1774, 2125, 3987, 1870, 1784,
        2140, 2319, 3989, 1878, 1792, 1957, 4000, 2176, 1884, 1799, 2808}], 
      Line3DBox[{1704, 1974, 1975, 1822, 4063, 1705, 2709, 1994, 2230, 1830, 
       4055, 1722, 2677, 1915, 2239, 2645, 2647, 2646, 1729, 2428, 2648, 2016,
        2037, 3967, 2455, 2456, 2680, 2457, 1920, 4045, 2052, 2331, 2332, 
       1743, 3924, 1926, 2075, 1845, 1751, 3928, 2076, 1850, 1759, 3933, 2113,
        2114, 1857, 3984, 1767, 1940, 2126, 1864, 4011, 1775, 2127, 2141, 
       1871, 3990, 1785, 1950, 2155, 3954, 1879, 1793, 2708, 1958, 4086, 2177,
        1885, 1800, 2613, 3940, 2178, 2612, 2664, 2666, 2665, 1808, 4096, 
       2785, 2286, 1895, 1815}], 
      Line3DBox[{1707, 1900, 1977, 1901, 2703, 2510, 1996, 2232, 1997, 3906, 
       2233, 1998, 2298, 1999, 3910, 2240, 2459, 2017, 2039, 4065, 2018, 2558,
        2246, 2463, 2041, 2054, 2042, 2573, 2250, 2465, 4047, 2058, 2580, 
       2059, 2579, 2077, 2583, 4069, 1932, 2101, 1933, 2102, 3981, 2380, 1935,
        2116, 1936, 3914, 2312, 2469, 2128, 2268, 2129, 3917, 2596, 2130, 
       2597, 2705, 1943, 2706, 1944, 3922, 2537, 2143, 2389, 1952, 2157, 4036,
        1953, 2390, 2159, 2401, 1960, 2180, 1961, 2546, 2506, 2622, 4076, 
       2192, 2615, 2193, 2695, 2760, 2761, 2210, 2288, 2211, 2213}], 
      Line3DBox[{1708, 2447, 2448, 2291, 2348, 2347, 4027, 2224, 1983, 2293, 
       4015, 1984, 2235, 2002, 2300, 4018, 2003, 2242, 2022, 2043, 3970, 2023,
        2304, 2060, 3975, 2251, 2061, 2307, 2586, 4070, 2587, 2078, 2585, 
       2584, 2714, 2588, 2589, 2103, 2375, 2374, 2594, 4072, 2466, 2681, 2467,
        2118, 2384, 2383, 4035, 2265, 2470, 2804}], 
      Line3DBox[{1709, 2512, 2513, 1982, 3958, 1903, 2226, 1986, 2294, 4016, 
       1988, 2236, 2005, 2021, 3968, 2007, 2301, 2044, 2247, 4004, 2046, 2305,
        2064, 3976, 2253, 2066, 2308, 2081, 3978, 2255, 2083, 2256, 2084, 
       3979, 2311, 2085, 2682, 2683, 2685, 2684, 2264, 2436, 2654, 4079, 2435,
        2266, 2471, 2687, 2472, 2133, 2601, 3988, 2600, 2134, 2539, 2540, 
       2504, 2542, 4053, 2541, 2146, 2394, 2395, 2162, 2399, 3994, 2398, 2163,
        2406, 2477, 4048, 2407, 2185, 2411, 2410, 2187, 2417, 2485, 4049, 
       2418, 2197, 2628, 2735, 2627, 2284, 2494, 4051, 2697, 2495, 2216, 2199,
        2218}], 
      Line3DBox[{1711, 1985, 1825, 3903, 1712, 1908, 2008, 3947, 1833, 1725, 
       2355, 2356, 2025, 3948, 1836, 1732, 2560, 2561, 2559, 3972, 1838, 1739,
        2526, 2527, 4056, 2525, 1842, 1746, 2530, 4058, 2531, 2529, 1847, 
       1754, 4087, 2716, 2717, 2715, 2754, 1852, 1762, 4094, 2769, 2770, 2768,
        1859, 4090, 1770, 2774, 2775, 2772, 2773, 1866, 1778, 2145, 3992, 
       1874, 1788, 2730, 2731, 2611, 3995, 1881, 1796, 2412, 2413, 4038, 2188,
        2342, 1888, 1803, 1966, 4003, 2200, 1893, 1811, 3945, 2217, 2219, 
       2699, 1898, 1818}], 
      Line3DBox[{1713, 1904, 1826, 3960, 1714, 1909, 2009, 2324, 4022, 2325, 
       1726, 1916, 2026, 3949, 2327, 2328, 1733, 2562, 2047, 2792, 3973, 1839,
        1740, 2360, 1921, 4030, 2068, 1843, 1747, 2430, 3925, 2069, 2257, 
       2752, 2753, 1755, 4093, 2763, 2711, 2762, 1853, 1763, 3936, 2767, 1860,
        4095, 1771, 2771, 1867, 3918, 1779, 1875, 1789, 2164, 2320, 3996, 
       1882, 1797, 2414, 1964, 4039, 2321, 1889, 1804, 2419, 3942, 1967, 2201,
        2345, 2736, 2346, 2798}], 
      Line3DBox[{1715, 1905, 2227, 1827, 3961, 1716, 1910, 2295, 2452, 4044, 
       2453, 2675, 2454, 1917, 2781, 2788, 2815}], 
      Line3DBox[{1717, 1989, 2228, 1990, 3904, 1991, 2349, 1911, 2296, 1912, 
       3908, 2521, 2678, 1918, 2782, 2814}], 
      Line3DBox[{1718, 2704, 1906, 2514, 1907, 3905, 2501, 2519, 1913, 2010, 
       1914, 3909, 2350, 2237, 2424, 2012, 2028, 4040, 2013, 2425, 2244, 2031,
        2791, 4097, 2032, 2306, 2362, 1924, 3950, 2070, 1925, 2363, 2072, 
       2368, 4031, 1927, 2089, 1928, 2369, 2261, 4007, 2093, 2105, 2094, 2263,
        4009, 2109, 2121, 2110, 3916, 2725, 2723, 2724, 3921, 1782, 2150, 
       3993, 2151, 2275, 2152, 2688, 4083, 2153, 2279, 2171, 3997, 2689, 2172,
        1805, 2204, 2629, 2205, 2634, 2285, 4013, 2499, 2672, 2206, 2644, 
       2207, 2737, 2643, 2635}], 
      Line3DBox[{1719, 2515, 2516, 2500, 2518, 2517, 1992, 2351, 2352, 2011, 
       2354, 3963, 2353, 2014, 2550, 2551, 2522, 2524, 2523, 2245, 2033, 3969,
        2034, 2048, 2364, 2365, 3951, 2071, 2367, 2366, 2073, 2370, 4032, 
       2371, 2092, 2373, 2372, 2095, 2376, 4033, 2377, 2108, 2379, 2378, 2111,
        3983, 1939, 2533, 2535, 2534, 4060, 2313, 2727, 2728, 2726, 4088, 
       2138, 2139, 1948, 2543, 2545, 4061, 2544, 2276, 2154, 2605, 4073, 2607,
        2606, 2280, 2173, 3998, 2189, 2174, 1806, 2747, 4091, 2759, 2748, 
       2749, 2750, 2751, 2290, 2746, 2745, 2744}], 
      Line3DBox[{1816, 1896, 2287, 2209, 3944, 1809, 1891, 2614, 2181, 3941, 
       2616, 1801, 1886, 2179, 1959, 3938, 2400, 1794, 2338, 4026, 2337, 2156,
        1951, 1786, 3991, 1872, 2536, 1942, 1776, 2656, 4080, 2655, 2267, 
       1941, 2468, 1768, 2336, 4025, 2335, 2115, 1934, 3934, 1760, 2334, 2333,
        2100, 1931, 3929, 1752, 2578, 2577, 2712, 2055, 4078, 2653, 2464, 
       1744, 2572, 2652, 2571, 2053, 2040, 4077, 2651, 2462, 1737, 2557, 2650,
        2556, 2038, 1919, 2555, 2458, 1730, 2553, 2554, 4064, 2552, 2297, 
       2015, 1723, 4082, 1831, 2231, 1995, 2549, 1706, 4054, 1823, 1976, 1899,
        2702, 2509}], 
      Line3DBox[{1817, 1897, 2743, 2673, 2289, 2670, 4014, 2669, 1810, 1892, 
       2344, 2198, 4002, 1965, 1802, 1887, 2341, 2186, 2409, 2408, 1795, 1880,
        2339, 3955, 2277, 2397, 2396, 1787, 1873, 3952, 2272, 1947, 1777, 
       1865, 4081, 2657, 2269, 2439, 2438, 1769, 1858, 2741, 2740, 2120, 3935,
        1761, 1851, 2590, 2592, 4071, 2591, 1753, 1846, 2532, 4059, 2082, 
       1745, 1841, 2067, 3977, 2065, 1738, 1837, 3971, 2248, 2045, 1731, 1835,
        3962, 2024, 2006, 1724, 1832, 3959, 2004, 1987, 1710, 1824, 4021, 
       2323, 2225, 1902, 2511}], 
      Line3DBox[{2215, 2637, 2196, 2212, 2195, 2668, 2491, 4012, 2282, 2623, 
       2667, 2184, 2733, 4089, 2183, 2663, 2624, 2281, 2661, 2662, 1963, 2505,
        3956, 1962, 2547, 2161, 2391, 1955, 4037, 2158, 1954, 2538, 2707, 
       1946, 4085, 2142, 1945, 2599, 2598, 2132, 2386, 2441, 2780, 2314, 2779,
        2793, 2385, 2119, 4034, 2382, 2434, 1938, 2117, 1937, 2381, 3982, 
       2104, 2432, 2593, 2080, 2310, 2079, 2431, 4005, 2254, 2581, 2063, 2713,
        2062, 2582, 2252, 2057, 2249, 3974, 2056, 2303, 2020, 4019, 2302, 
       2019, 2241, 2001, 4017, 2299, 2000, 2234, 3907, 1981, 2292, 1980, 2423,
        2223, 3902, 1979, 2222, 1978, 2446, 2674}], 
      Line3DBox[{2221, 1973, 1820, 1701, 2421, 2422, 2229, 2449, 4043, 1828, 
       1720, 2450, 2676, 2451, 2238, 2326, 4023, 1834, 1727, 2816}], 
      Line3DBox[{2738, 2638, 2639, 2214, 2493, 2696, 2492, 2283, 2625, 2734, 
       2626, 2194, 2484, 4084, 2692, 2483, 2618, 2404, 2617, 2405, 2182, 3957,
        2403, 2402, 2610, 2608, 2609, 4074, 2160, 2393, 2392, 2604, 2602, 
       2729, 2603, 2144, 2388, 2473, 2387, 2315, 2437, 2819}], 
      Line3DBox[{2795, 3943, 2480, 2690, 2479, 2621, 2478, 2619, 2168, 3939, 
       2443, 2476, 2475, 2474, 2659, 2165, 2757, 2658, 1790, 4075, 1876, 2273,
        2147, 1780, 3919, 1868, 2270, 2135, 1772, 3915, 1861, 2720, 2719, 
       3937, 1764, 1854, 2764, 2718, 3930, 2766, 1756, 2756, 2755, 2258, 2086,
        3926, 2433, 1748, 2575, 2574, 2783, 1922, 2812}], 
      Line3DBox[{2797, 1735, 2358, 2359, 4028, 2049, 2570, 2710, 1840, 1742, 
       2050, 4020, 2309, 1844, 1749, 1929, 3980, 2096, 1848, 1757, 3931, 2097,
        2112, 1855, 3912, 1765, 2122, 3985, 1862, 1773, 2123, 2316, 3986, 
       1869, 1783, 1949, 2318, 3953, 1877, 1791, 1956, 3999, 2175, 2340, 1883,
        1798, 2807}], 
      Line3DBox[{2809, 2632, 2203, 2671, 2202, 4050, 2486, 2322, 2444, 2170, 
       2732, 2169, 2620, 2278, 2442, 2167, 4042, 2742, 2166, 2660, 2317, 3923,
        2149, 2274, 2148, 1781, 3920, 2137, 2271, 2136, 2595, 2722, 2107, 
       2721, 2106, 4008, 2262, 2091, 2765, 2090, 4006, 2260, 2088, 2259, 2087,
        4052, 2503, 2576, 1923, 2784, 2813}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJy0unk0ld/7xx0lc6aKVCI0qBQVEa4GCdEgKYoMoSIhGRskDYYMIfM8z/M8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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-3, 6}, {-3, 6}, {-29.043593009547283`, 28.927913699042897`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 StyleBox["Integrate",
  FontWeight->"Bold"],
 " kommt hier in vern\[UDoubleDot]nftiger Zeit gar nicht durch. Das Kommando \
ist deshalb auskommentiert."
}], "SmallText",
 CellChangeTimes->{{3.36022062361911*^9, 3.36022063951939*^9}, {
  3.36022067634922*^9, 3.3602206844156*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"i", "=", 
      RowBox[{"Integrate", "[", 
       RowBox[{"f", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}]}], ";"}], ")"}], "//",
    "Timing"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.36022936170543*^9, 3.36022936565486*^9}, {
  3.389108427820905*^9, 3.389108454823238*^9}, {3.38910884255939*^9, 
  3.389108853283103*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3799999999999817`", ",", 
   RowBox[{"-", "109.51957202249186`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"WorkingPrecision", "\[Rule]", "15"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{{3.36023557828643*^9, 3.36023561749004*^9}, {
  3.36023568143499*^9, 3.36023569381978*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12.660000000000004`", ",", 
   RowBox[{"-", "109.51957264482571441684160064853`15."}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "//", 
  "Precision"}]], "Input",
 CellChangeTimes->{{3.36023570493952*^9, 3.36023572476466*^9}, {
  3.36023652909542*^9, 3.36023655082495*^9}}],

Cell[BoxData["15.`"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Datenanalyse", "Section",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, 
   3.382549354421271*^9, 3.389343121278491*^9}],

Cell[CellGroupData[{

Cell["Fit mit vorgegebenen Basisfunktionen", "Subsection",
 CellChangeTimes->{{3.36756889017536*^9, 3.36756889371428*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"list1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Real", ",", "100"}], "]"}], ",", 
     RowBox[{"{", "80", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["#", "100"], "Pi"}], "]"}], "+", 
        RowBox[{"Random", "[", 
         RowBox[{"Real", ",", "0.3"}], "]"}]}]}], "}"}], "&"}], "/@", 
    "list1"}]}], ";", 
  RowBox[{"gr0", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"PointSize", "[", "0.01", "]"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.36756883836059*^9, 3.36756884012234*^9}, 
   3.36757108635275*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f1", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      SuperscriptBox["x", "2"]}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr1"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756895160975*^9, 3.36756896054408*^9}, {
  3.36756900319146*^9, 3.36756900903593*^9}, {3.382759557653988*^9, 
  3.382759564432809*^9}, {3.382864215456792*^9, 3.382864228708426*^9}}],

Cell[BoxData[
 RowBox[{"0.1167909661863167`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.03975626658206653`", " ", "x"}], "-", 
  RowBox[{"0.00039839245859642274`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.01], PointBox[CompressedData["
1:eJwVlPk3FAgcwJV1JGmVZ824kmPXUeSImcd8vzOuHLnGGGGtu1pSUmhqre2p
RInZIjmSM8m1GfLW4NnSwVtyDIOSMcy0Q8ZVa4vd9ofP+/wBn/c+ehEn/aK3
ysjI+Hzhf+dmcce8ut2RdNUhpThgCfTvZpPNYhZBWtBbaGD4CpKfLqweD1ZA
eeE901slo7BfmBUU8tkJ81MbuuU1pWBjo3Y54IQ5+h0ldasqCOH2zTqBWrkb
Vvq6OoUWLoP9+r+kIpI17rAyYdr2zsI3OYlc7zhHNKHYk79ufw8KRhNvp0IY
KLFJcLow9Bpk61W2qg0yMJ3jfiBzbgKSxFFdYTFuyO1q4QdlSiGo5NKCIImJ
66OEyAzsBYeqSPIhvV2Ymehny/TohbMmnCReny9SOPM3VF8tgnWgmeYdPxo6
CulJdItFMAiM0EmrIKP5ser+M0wp/C4avUpu9kdiZ98WQrAIlA9/NaxlEog7
7FSPlP3SA/3yqxYLFG/Efu6WuA4pWFiWBfjfMsaQ2D9ppAkhqJV5pq9w6Lj/
imXeg2kRiGRMCW1kJkZxT62Vx43Atk/nmcrZlhjfZyI3I/sOvGj8D9pdVria
yus+f0wE+xJaf7Cgk7BqIieKqCeGmhlO1/ynAPzn8WwYK3QCmtPbD1CczZGt
rfPCyFYEF0JP+fAT6GhfICluNhSDYV0QSYmkjy3P+TNk5Slos+woeeLvhDT2
dCZPZRFc2a2tOM5EQnris7cjQyAwOzETkeyITZI9V3anSiG5AwvkjO3Q2S7D
wNlBAo94pXeKGt2RsERq7DVdBYK9UsMeLxf87hE5rU6wBObScMXiqy7YfD8u
sV4iBdFwdeajUisUyufdZZ2aBSEW8pKz/FG/KptKnxSAqe5iifWkLnbLukRe
ChsG+4zw5bZ4S8zv0T5T+6MQNokVTcKjNJwql7lWcXYJ+Ct5W4PDGbj30Jb1
UhSB+ut3EQXtLphBGmRc7F8BdjtVC3LUMXlbodL1oiEY5SnVbHzyRBF1LUaD
IoWl5dh394yYSLGeYr0c5INBJzPeSELGk7u5OZRUMRzs3XHmcwoD01TIC380
zAFVx/xctB/iZqiP3EauBMwqFIJvBs2Cxo3N/CDPYWCvLz9QyTVCn+Qnjja0
ceiJlmgRSHtw00vZhTo3DouzjSPOirboKNn4lbYhhjFJ3W+VMl7oocnxMupY
AcbRgwuKneYYq9MVdaRwFlx5c00JHr7IYNUvW/HnYWqb1s6B1kB003XbfFU+
CPo1x7oOpRGxl0jP57P74E29Xs/AgC9ma4Q6oqUEOlJGW64R7VCd2KLe5TAH
FWqnzcr76ahqLPu4qFYMbUZ1I5an7TBUQae2NPU98M5F/02s8kZNGb+LZv4r
oNg9qurRoI6Tp/dWPkQ+uKtgdbitM06PjGlUGK/Cw9r70ZFJjvi8skkSH7YC
F0kfTWSHDiAjY591ZJIAcpPk8ta234W0w+PyrNwWaCsk/tukzUDWICf+Tucc
vHw6wNY1dsW3f8mzVL/0vP3mW/OPbQHYbRL/+uT0EOysCQkqczXDy505C+T9
02BFkL+0KXZDlnacUyx3BUjVUVTOkAsGknOnx84tQfTPL46MiOgYkEB95lIs
AfZlAWuXtgZm7TobMxnw5Q+ewdatL+zRoN3wgYJgHhq/D3525TgD27Z3/HSc
Ow0fopxTxFPeuFfv+uo6dRGcKrIlHXE0bMznr+nbL8F/Bx1ZXw==
      
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8FP8fB3AkKkcliQ4pfJ1JlxT6vFtrd2Z3SaLQJXLn7nTkTkq5SkWO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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 98.87207391489163}, {0., 1.260692299255487}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Dieselbe Aufgabe mit ",
 StyleBox["FindFit",
  FontWeight->"Bold"],
 "."
}], "SmallText",
 CellChangeTimes->{{3.382864340601213*^9, 3.382864370484761*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FindFit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"f1a", "=", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"b", " ", "x"}], "+", " ", "c"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"f1a", "/.", "%"}]}], "Input",
 CellChangeTimes->{{3.382862460263427*^9, 3.382862533898802*^9}, {
   3.382862715240472*^9, 3.382862716638054*^9}, {3.382864262564183*^9, 
   3.382864332440341*^9}, 3.382864399982234*^9}],

Cell[BoxData[
 RowBox[{"0.11679096618631593`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.03975626658206654`", " ", "x"}], "-", 
  RowBox[{"0.00039839245859642274`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f2", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f2", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756895160975*^9, 3.3675689870168*^9}, {
  3.36756911353827*^9, 3.36756911623518*^9}, {3.382759576030142*^9, 
  3.382759585730101*^9}, {3.382864421209583*^9, 3.382864435488599*^9}}],

Cell[BoxData[
 RowBox[{"0.6980344537162149`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.0008278114040870513`", " ", "x"}]}]], "Output"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.01], PointBox[CompressedData["
1:eJwVlPk3FAgcwJV1JGmVZ824kmPXUeSImcd8vzOuHLnGGGGtu1pSUmhqre2p
RInZIjmSM8m1GfLW4NnSwVtyDIOSMcy0Q8ZVa4vd9ofP+/wBn/c+ehEn/aK3
ysjI+Hzhf+dmcce8ut2RdNUhpThgCfTvZpPNYhZBWtBbaGD4CpKfLqweD1ZA
eeE901slo7BfmBUU8tkJ81MbuuU1pWBjo3Y54IQ5+h0ldasqCOH2zTqBWrkb
Vvq6OoUWLoP9+r+kIpI17rAyYdr2zsI3OYlc7zhHNKHYk79ufw8KRhNvp0IY
KLFJcLow9Bpk61W2qg0yMJ3jfiBzbgKSxFFdYTFuyO1q4QdlSiGo5NKCIImJ
66OEyAzsBYeqSPIhvV2Ymehny/TohbMmnCReny9SOPM3VF8tgnWgmeYdPxo6
CulJdItFMAiM0EmrIKP5ser+M0wp/C4avUpu9kdiZ98WQrAIlA9/NaxlEog7
7FSPlP3SA/3yqxYLFG/Efu6WuA4pWFiWBfjfMsaQ2D9ppAkhqJV5pq9w6Lj/
imXeg2kRiGRMCW1kJkZxT62Vx43Atk/nmcrZlhjfZyI3I/sOvGj8D9pdVria
yus+f0wE+xJaf7Cgk7BqIieKqCeGmhlO1/ynAPzn8WwYK3QCmtPbD1CczZGt
rfPCyFYEF0JP+fAT6GhfICluNhSDYV0QSYmkjy3P+TNk5Slos+woeeLvhDT2
dCZPZRFc2a2tOM5EQnris7cjQyAwOzETkeyITZI9V3anSiG5AwvkjO3Q2S7D
wNlBAo94pXeKGt2RsERq7DVdBYK9UsMeLxf87hE5rU6wBObScMXiqy7YfD8u
sV4iBdFwdeajUisUyufdZZ2aBSEW8pKz/FG/KptKnxSAqe5iifWkLnbLukRe
ChsG+4zw5bZ4S8zv0T5T+6MQNokVTcKjNJwql7lWcXYJ+Ct5W4PDGbj30Jb1
UhSB+ut3EQXtLphBGmRc7F8BdjtVC3LUMXlbodL1oiEY5SnVbHzyRBF1LUaD
IoWl5dh394yYSLGeYr0c5INBJzPeSELGk7u5OZRUMRzs3XHmcwoD01TIC380
zAFVx/xctB/iZqiP3EauBMwqFIJvBs2Cxo3N/CDPYWCvLz9QyTVCn+Qnjja0
ceiJlmgRSHtw00vZhTo3DouzjSPOirboKNn4lbYhhjFJ3W+VMl7oocnxMupY
AcbRgwuKneYYq9MVdaRwFlx5c00JHr7IYNUvW/HnYWqb1s6B1kB003XbfFU+
CPo1x7oOpRGxl0jP57P74E29Xs/AgC9ma4Q6oqUEOlJGW64R7VCd2KLe5TAH
FWqnzcr76ahqLPu4qFYMbUZ1I5an7TBUQae2NPU98M5F/02s8kZNGb+LZv4r
oNg9qurRoI6Tp/dWPkQ+uKtgdbitM06PjGlUGK/Cw9r70ZFJjvi8skkSH7YC
F0kfTWSHDiAjY591ZJIAcpPk8ta234W0w+PyrNwWaCsk/tukzUDWICf+Tucc
vHw6wNY1dsW3f8mzVL/0vP3mW/OPbQHYbRL/+uT0EOysCQkqczXDy505C+T9
02BFkL+0KXZDlnacUyx3BUjVUVTOkAsGknOnx84tQfTPL46MiOgYkEB95lIs
AfZlAWuXtgZm7TobMxnw5Q+ewdatL+zRoN3wgYJgHhq/D3525TgD27Z3/HSc
Ow0fopxTxFPeuFfv+uo6dRGcKrIlHXE0bMznr+nbL8F/Bx1ZXw==
      
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3lQk2cQBvCIgKWaEbypiEBFrlgDWDw4dkG5FAhXIFCtVkAiIXJaUYOg
qGiFIigeTYkoIocVBAWjlQi2HKIOIdpRoAOp1e/7KFgrGnAIMX39Y+eZ3+zs
zLPW21PCEwxYLFYImU9pU6SrkFm2ebUK6mKDoii49ZnDUrHwApwM5pw/SNyW
VXfZXlgPW31qnzUTd3DTEo2F90DvdCXSOpqCrgJVgCaxB7z0ZSHjxA/W5d0e
TRyCu5WFPuUxFHQXD6QxiW9APpbs+H4zBRtbZoRQiXpoKHCalMZR8JjtZmK4
xRSnP7d1/zydAp8i39Yq3iK8W7Phl7wcChJWTrKd2VbIdQnNuF1AQbBDwtsF
/svQSPV8gC2loPFp9u4Ha+zR+8ORTHE1Be5zHOsNczg4+PX1upFmChK1JWWV
Ai66OXZ6LW+nIKWDdq0PdkHNZQO9SEXBD7HGtrrkVThv9a/blGoK4jr373AW
uuHPvHNj8C/5f4Z5mChmDQ5abu8XaSlwNss9M5y5DnONauKaTWjY+s6TE5Ls
gSfS5y2ZtZCGclm7xUShF2rGp/bk2tLQ+OO6AVU44mIXlX2DKw0ZdzxDy4K8
sfrdQ5PXSIOiu3Ls+Dc+eOaRT4E/jwah/9qWnYL1OOI06HVtMw3SaucmUdIG
vHhpvMRZRMPJdy0HU/f4oplS65G+l4ZXtbu/F6b74XCe7ULFURp+8ys5d+iQ
P9rwHpXYl9LA4vW/KMoNwPvlZ71kl2jQY/O08r2BuKSGh8p6GvIXTgSr8jdi
X9fhv60UNKTExt2fyNuEU7sGmyUPaVAfXBUPpUGYy2lymuijYe6p8/3HLwaj
ojxrfAVDQ6Wp495OaQjGS7e9TdHQ0Jq+1NfuKg9F19oLldMZkFmVW3hGhmKf
Ly/Ww4yBFskkS6gMRYPSdkm8JQPWm2ZMfRkdhgVaOV7lMHCzx+FE39MwzGaU
q3RrGSjo+Mi12hKOPaMJ3eIABk5lDCdt+zMcj+1ZenKYz4BkvuVsm5gInJK3
X7WOY6DGwag7Ux2BvWbDwqw0BozfTzNv+zYS2W+5Uf0HGKjiNhyQ0ZFYS2te
xhYy4LC9NkQn5pM+VQ/OShkYCLzdyB/hY1tX9uBQNQOqin0rICMK1XN7T/vd
YuDDjTAPm7EoFL4K2C//nQG9PL3p6K5orBVfu0X1MrCJ6+cr0URjELuo1FXN
QOeWlTtFGQKMci2tOPGagXxdd8WIVoBtqYsiDKYYiDxtrtES9/4jZxsSWzkJ
/WZNCfCv+JguI+I7AqNhDvG0mJ88TYhHb8BXu4i9vS3sTYlDk27K/yNuNbPS
LSH+4lnZY42OuNGuai0xJR61NP4oQCWn6zt34huG7qkLiNVXhBaexEEuz+es
JmZJa4qROKdwjiCLGPOcJP7EL9fnv5gkvhexMoxPfL3/D9eZegH2PO6ZGU2c
nbbsyGLiIf/UDgHxggttdh7EevcG983EgZPa5GxiWOa6PO7TvnijopCYJ3ui
jid+YXd+tox466JM6Q5iCd+tUUGcM6vJNIk4YPTw9B7ioqP8hyLi+XlPIoeI
L7DGj4g/3ZvbXHlDXL/vDKYQ111PndATK967aVOJ/we5lXJW
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 98.87207391489163}, {0., 1.260692299255487}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f3", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "10"], "]"}], ",", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "20"], "]"}]}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f3", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756920059633*^9, 3.36756921908864*^9}, {
  3.382759596686402*^9, 3.382759602032047*^9}, {3.382864445230275*^9, 
  3.382864454683993*^9}}],

Cell[BoxData[
 RowBox[{"0.7464397094238614`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.15488755710100988`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "20"], "]"}]}], "-", 
  RowBox[{"0.1923379506440975`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "10"], "]"}]}]}]], "Output"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.01], PointBox[CompressedData["
1:eJwVlPk3FAgcwJV1JGmVZ824kmPXUeSImcd8vzOuHLnGGGGtu1pSUmhqre2p
RInZIjmSM8m1GfLW4NnSwVtyDIOSMcy0Q8ZVa4vd9ofP+/wBn/c+ehEn/aK3
ysjI+Hzhf+dmcce8ut2RdNUhpThgCfTvZpPNYhZBWtBbaGD4CpKfLqweD1ZA
eeE901slo7BfmBUU8tkJ81MbuuU1pWBjo3Y54IQ5+h0ldasqCOH2zTqBWrkb
Vvq6OoUWLoP9+r+kIpI17rAyYdr2zsI3OYlc7zhHNKHYk79ufw8KRhNvp0IY
KLFJcLow9Bpk61W2qg0yMJ3jfiBzbgKSxFFdYTFuyO1q4QdlSiGo5NKCIImJ
66OEyAzsBYeqSPIhvV2Ymehny/TohbMmnCReny9SOPM3VF8tgnWgmeYdPxo6
CulJdItFMAiM0EmrIKP5ser+M0wp/C4avUpu9kdiZ98WQrAIlA9/NaxlEog7
7FSPlP3SA/3yqxYLFG/Efu6WuA4pWFiWBfjfMsaQ2D9ppAkhqJV5pq9w6Lj/
imXeg2kRiGRMCW1kJkZxT62Vx43Atk/nmcrZlhjfZyI3I/sOvGj8D9pdVria
yus+f0wE+xJaf7Cgk7BqIieKqCeGmhlO1/ynAPzn8WwYK3QCmtPbD1CczZGt
rfPCyFYEF0JP+fAT6GhfICluNhSDYV0QSYmkjy3P+TNk5Slos+woeeLvhDT2
dCZPZRFc2a2tOM5EQnris7cjQyAwOzETkeyITZI9V3anSiG5AwvkjO3Q2S7D
wNlBAo94pXeKGt2RsERq7DVdBYK9UsMeLxf87hE5rU6wBObScMXiqy7YfD8u
sV4iBdFwdeajUisUyufdZZ2aBSEW8pKz/FG/KptKnxSAqe5iifWkLnbLukRe
ChsG+4zw5bZ4S8zv0T5T+6MQNokVTcKjNJwql7lWcXYJ+Ct5W4PDGbj30Jb1
UhSB+ut3EQXtLphBGmRc7F8BdjtVC3LUMXlbodL1oiEY5SnVbHzyRBF1LUaD
IoWl5dh394yYSLGeYr0c5INBJzPeSELGk7u5OZRUMRzs3XHmcwoD01TIC380
zAFVx/xctB/iZqiP3EauBMwqFIJvBs2Cxo3N/CDPYWCvLz9QyTVCn+Qnjja0
ceiJlmgRSHtw00vZhTo3DouzjSPOirboKNn4lbYhhjFJ3W+VMl7oocnxMupY
AcbRgwuKneYYq9MVdaRwFlx5c00JHr7IYNUvW/HnYWqb1s6B1kB003XbfFU+
CPo1x7oOpRGxl0jP57P74E29Xs/AgC9ma4Q6oqUEOlJGW64R7VCd2KLe5TAH
FWqnzcr76ahqLPu4qFYMbUZ1I5an7TBUQae2NPU98M5F/02s8kZNGb+LZv4r
oNg9qurRoI6Tp/dWPkQ+uKtgdbitM06PjGlUGK/Cw9r70ZFJjvi8skkSH7YC
F0kfTWSHDiAjY591ZJIAcpPk8ta234W0w+PyrNwWaCsk/tukzUDWICf+Tucc
vHw6wNY1dsW3f8mzVL/0vP3mW/OPbQHYbRL/+uT0EOysCQkqczXDy505C+T9
02BFkL+0KXZDlnacUyx3BUjVUVTOkAsGknOnx84tQfTPL46MiOgYkEB95lIs
AfZlAWuXtgZm7TobMxnw5Q+ewdatL+zRoN3wgYJgHhq/D3525TgD27Z3/HSc
Ow0fopxTxFPeuFfv+uo6dRGcKrIlHXE0bMznr+nbL8F/Bx1ZXw==
      
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc81P8fAHCJShRJRkayycgm5f0y7qyS3NkkIyRkZoRkZoQkSZKSLw1C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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 98.87207391489163}, {0., 1.260692299255487}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regressionsanalyse (Regress)", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f4", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "10"], "]"}]}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f4", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr4"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756920059633*^9, 3.36756921908864*^9}, {
  3.382759596686402*^9, 3.382759602032047*^9}, {3.382864445230275*^9, 
  3.382864454683993*^9}, {3.382864567655668*^9, 3.382864636665567*^9}}],

Cell[BoxData[
 RowBox[{"0.14586270151816805`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.0384731850660197`", " ", "x"}], "-", 
  RowBox[{"0.0003862090026458618`", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"0.03072765751130295`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "10"], "]"}]}], "-", 
  RowBox[{"0.0051077575276121`", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.01], PointBox[CompressedData["
1:eJwVlPk3FAgcwJV1JGmVZ824kmPXUeSImcd8vzOuHLnGGGGtu1pSUmhqre2p
RInZIjmSM8m1GfLW4NnSwVtyDIOSMcy0Q8ZVa4vd9ofP+/wBn/c+ehEn/aK3
ysjI+Hzhf+dmcce8ut2RdNUhpThgCfTvZpPNYhZBWtBbaGD4CpKfLqweD1ZA
eeE901slo7BfmBUU8tkJ81MbuuU1pWBjo3Y54IQ5+h0ldasqCOH2zTqBWrkb
Vvq6OoUWLoP9+r+kIpI17rAyYdr2zsI3OYlc7zhHNKHYk79ufw8KRhNvp0IY
KLFJcLow9Bpk61W2qg0yMJ3jfiBzbgKSxFFdYTFuyO1q4QdlSiGo5NKCIImJ
66OEyAzsBYeqSPIhvV2Ymehny/TohbMmnCReny9SOPM3VF8tgnWgmeYdPxo6
CulJdItFMAiM0EmrIKP5ser+M0wp/C4avUpu9kdiZ98WQrAIlA9/NaxlEog7
7FSPlP3SA/3yqxYLFG/Efu6WuA4pWFiWBfjfMsaQ2D9ppAkhqJV5pq9w6Lj/
imXeg2kRiGRMCW1kJkZxT62Vx43Atk/nmcrZlhjfZyI3I/sOvGj8D9pdVria
yus+f0wE+xJaf7Cgk7BqIieKqCeGmhlO1/ynAPzn8WwYK3QCmtPbD1CczZGt
rfPCyFYEF0JP+fAT6GhfICluNhSDYV0QSYmkjy3P+TNk5Slos+woeeLvhDT2
dCZPZRFc2a2tOM5EQnris7cjQyAwOzETkeyITZI9V3anSiG5AwvkjO3Q2S7D
wNlBAo94pXeKGt2RsERq7DVdBYK9UsMeLxf87hE5rU6wBObScMXiqy7YfD8u
sV4iBdFwdeajUisUyufdZZ2aBSEW8pKz/FG/KptKnxSAqe5iifWkLnbLukRe
ChsG+4zw5bZ4S8zv0T5T+6MQNokVTcKjNJwql7lWcXYJ+Ct5W4PDGbj30Jb1
UhSB+ut3EQXtLphBGmRc7F8BdjtVC3LUMXlbodL1oiEY5SnVbHzyRBF1LUaD
IoWl5dh394yYSLGeYr0c5INBJzPeSELGk7u5OZRUMRzs3XHmcwoD01TIC380
zAFVx/xctB/iZqiP3EauBMwqFIJvBs2Cxo3N/CDPYWCvLz9QyTVCn+Qnjja0
ceiJlmgRSHtw00vZhTo3DouzjSPOirboKNn4lbYhhjFJ3W+VMl7oocnxMupY
AcbRgwuKneYYq9MVdaRwFlx5c00JHr7IYNUvW/HnYWqb1s6B1kB003XbfFU+
CPo1x7oOpRGxl0jP57P74E29Xs/AgC9ma4Q6oqUEOlJGW64R7VCd2KLe5TAH
FWqnzcr76ahqLPu4qFYMbUZ1I5an7TBUQae2NPU98M5F/02s8kZNGb+LZv4r
oNg9qurRoI6Tp/dWPkQ+uKtgdbitM06PjGlUGK/Cw9r70ZFJjvi8skkSH7YC
F0kfTWSHDiAjY591ZJIAcpPk8ta234W0w+PyrNwWaCsk/tukzUDWICf+Tucc
vHw6wNY1dsW3f8mzVL/0vP3mW/OPbQHYbRL/+uT0EOysCQkqczXDy505C+T9
02BFkL+0KXZDlnacUyx3BUjVUVTOkAsGknOnx84tQfTPL46MiOgYkEB95lIs
AfZlAWuXtgZm7TobMxnw5Q+ewdatL+zRoN3wgYJgHhq/D3525TgD27Z3/HSc
Ow0fopxTxFPeuFfv+uo6dRGcKrIlHXE0bMznr+nbL8F/Bx1ZXw==
      
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8lV8YAHAZpahQZlIZhUpkJKPnMe51XeuaKRkZUUkikQgtkigpUtFO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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 98.87207391489163}, {0., 1.260692299255487}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Informationen \[UDoubleDot]ber die G\[UDoubleDot]te der Approximation \
liefert das Kommando ",
 StyleBox["Regress",
  FontWeight->"Bold"],
 " aus dem Paket ",
 StyleBox["LinearRegression",
  FontWeight->"Bold"],
 ". Standardm\[ADoubleDot]\[SZ]ig wird die Parametertabelle ausgegeben, es \
gibt aber auch andere interessante Optionen."
}], "SmallText",
 CellChangeTimes->{{3.382865155598654*^9, 3.382865223855791*^9}, {
  3.382865295604817*^9, 3.382865300789606*^9}, {3.382865348549828*^9, 
  3.382865464740365*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "10"], "]"}]}], "}"}], ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.382759675665724*^9, {3.38275973920773*^9, 3.382759772166177*^9}, {
   3.38275982812825*^9, 3.38275987064441*^9}, {3.382759944218985*^9, 
   3.382759945888483*^9}, {3.382864519150991*^9, 3.38286455216245*^9}, {
   3.382865005298074*^9, 3.382865009629333*^9}, {3.382865041303789*^9, 
   3.382865042422365*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "0.14586270151816097`", "0.032059327611307475`", 
         "4.549774196346978`", "0.00002029798862568377`"},
        {
         TagBox["x",
          HoldForm], "0.03847318506602004`", "0.0015976161829185194`", 
         "24.081619526247767`", "0.`"},
        {
         TagBox[
          SuperscriptBox["x", "2"],
          HoldForm], 
         RowBox[{"-", "0.0003862090026458648`"}], "0.000015805084574411848`", 
         
         RowBox[{"-", "24.435744132058005`"}], "1.8786252848977521`*^-37"},
        {
         TagBox[
          RowBox[{"Sin", "[", "x", "]"}],
          HoldForm], 
         RowBox[{"-", "0.005107757527611863`"}], "0.01500901959859874`", 
         RowBox[{"-", "0.34031253634239567`"}], "0.7345725151116047`"},
        {
         TagBox[
          RowBox[{"Sin", "[", 
           FractionBox["x", "10"], "]"}],
          HoldForm], 
         RowBox[{"-", "0.030727657511301562`"}], "0.017487111280756105`", 
         RowBox[{"-", "1.7571602889675764`"}], "0.08297148370899045`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      TableForm[
      BoxForm`e$, TableHeadings -> {{1, $CellContext`x, $CellContext`x^2, 
          Sin[$CellContext`x], 
          Sin[Rational[1, 10] $CellContext`x]}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9189148393556344`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9145902974546016`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.008560123419322817`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "4", "7.275706529612107`", "1.8189266324030267`", 
        "212.48836533094286`", "0.`"},
       {"\<\"Error\"\>", "75", "0.6420092564492113`", 
        "0.008560123419322817`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "79", 
        "7.917715786061318`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[2.0999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       4, 7.275706529612107, 1.8189266324030267`, 212.48836533094286`, 0.}, {
       75, 0.6420092564492113, 0.008560123419322817}, {
       79, 7.917715786061318}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RegressionReportValues[Regress]", "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "AdjustedRSquared", ",", "ANOVATable", ",", "BestFit", ",", 
   "BestFitParameters", ",", "BestFitParametersDelta", ",", "CatcherMatrix", 
   ",", "CoefficientOfVariation", ",", "CookD", ",", "CorrelationMatrix", ",",
    "CovarianceMatrix", ",", "CovarianceMatrixDetRatio", ",", "DurbinWatsonD",
    ",", "EigenstructureTable", ",", "EstimatedVariance", ",", "FitResiduals",
    ",", "HatDiagonal", ",", "JackknifedVariance", ",", 
   "MeanPredictionCITable", ",", "ParameterCITable", ",", 
   "ParameterConfidenceRegion", ",", "ParameterTable", ",", 
   "PartialSumOfSquares", ",", "PredictedResponse", ",", 
   "PredictedResponseDelta", ",", "RSquared", ",", "SequentialSumOfSquares", 
   ",", "SinglePredictionCITable", ",", "StandardizedResiduals", ",", 
   "StudentizedResiduals", ",", "SummaryReport", ",", "VarianceInflation"}], 
  "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nichtlineare Regression (FindFit)", "Subsection",
 CellChangeTimes->{{3.382869489177463*^9, 3.382869494746026*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"3", 
         RowBox[{"Sin", "[", 
          RowBox[{"5", "x"}], "]"}]}], " ", "+", "  ", 
        RowBox[{"Random", "[", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", " ", 
       RowBox[{"0.01", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"a", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.36757238659488*^9, 3.36757239994618*^9}, 
   3.382869515616863*^9, {3.382869983527439*^9, 3.382869992941007*^9}, {
   3.382870342681602*^9, 3.382870362649077*^9}, {3.382871141306282*^9, 
   3.382871153166371*^9}}],

Cell["\<\
Nichtlineare Fits sind sehr von den Anfangswerten f\[UDoubleDot]r die gew\
\[ADoubleDot]hlten Parameter abh\[ADoubleDot]ngig. Defaultstartwert f\
\[UDoubleDot]r alle Parameter ist 1, was hier weit von den wirklichen Werten \
entfernt ist. \
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", " ", "=", " ", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", "f", ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382869531760619*^9, 3.382869535952392*^9}, {
  3.382870013952154*^9, 3.382870047558389*^9}, {3.382870083343229*^9, 
  3.382870084372604*^9}, {3.382870374687735*^9, 3.382870406684775*^9}}],

Cell[BoxData[
 RowBox[{"0.33461140554176816`", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"1.6770210907933039`", " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Mit besseren Startwerten erhalten wir, trotz des hohen Rauschanteils in den \
Daten, einen sehr guten Fit.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", " ", "=", " ", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", "f", ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "5.2"}], "}"}]}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382870113493066*^9, 3.382870150881666*^9}, {
  3.382870428301223*^9, 3.382870462373022*^9}, {3.382870667944184*^9, 
  3.382870679108599*^9}, {3.382871223924885*^9, 3.38287127210097*^9}}],

Cell[BoxData[
 RowBox[{"3.049395983319945`", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"5.005039711782732`", " ", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", " ", 
   RowBox[{
    RowBox[{"ListPlot", "[", "data", "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f1", ",", "f2"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.36757245799955*^9, 3.36757247543997*^9}, {
   3.38287018878941*^9, 3.382870278169118*^9}, {3.382870489897605*^9, 
   3.382870550207166*^9}, {3.382873263322182*^9, 3.382873280725669*^9}, 
   3.389342310895373*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw1lgk4VPsbx2czixn7bFRqUqikRa4W+r1RSulvKcpyCZFK3HtFVFfRdkuL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      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Hk8VG8XAHDbjLGbGURKos1SKlKynIefIqFQkp1sSWUpSiIpCkmyVIgU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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c8Ve8fwN15Dte4LleDStpZEZXC86FURhKShJCW7IoySyEqSSgtlVnK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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.283185307179587}, {-2.9031450196814417`, 
   3.9900831112029214`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1fQl4VceRroIkhMA2GC+Jk0nixJnEsR3veMn4OvYkz3nO/macL/PefJMZ
Oy+JPbHj2Elm4mScjDdMbPAGBmyz2MZmB4lVbNolQGIVu9gEiF0CsyMQ0K+r
Tv9965xb59wrkvd9CF2d26e76+/q6qrq6urvPvibh3/62IO/eeQnD175zScf
/NXDj/zk11fe9/iT9lH+x/LyPvZwXl5e65V59NnYj+4/Y/+ZR+g/evLX+VzM
vwpNY2Ojefrpp82TTz5pvvWtb5nZs2cH5f45KHcB/8o3+/btM5dffnnwl/s/
6ByXzvsK/19gNsxqME3jK83iodPNumkL73bNnD1z1pT9xztm45wlpvzZMaat
uTUP3x3e2WYW/Ol9s2neUjP396PM6eMd7rsCs6VihVk4uNSsmVpnFg+bgVfO
nTtnKp7/kFurenGc2bVsY97Hgw4HvTMAL5/+L3REnDlzxkyePNl87nOfyyug
Z4VU5Br+trvZs2qraRg+EySZDTMXm72rW1Lu61UTqszBrbv5K2p/4RslprPj
9F3ua3pU9+oUc+7sWS5y/MAR0/jObLz90fZ9ZsUH5b7y9dMXmdaG9fjaQmX2
r9/hv7a0mo6jJwK883q5/n/96183xcXFZvHixUH/I4NwnauNELP98bVR3xY8
M+YuV82Jg0fN8vfm81/d3LMjew6YNVNq+a+/4/+LzOby5aZ8wmKzaNF2VMcd
/Wjb3jzUVWnRP3O6M1TXwiHTfPNfdc9On+gwDW/NCpU78ZHtx/tBPy4LU0oj
NXr0aJNKpVRKr3Xl2jftIp6SbMk8s2/d9lDzFnoiO1Susv9Yc7azU5QrMlP+
8IH5Wuot/lm4kOugQaaRdLAQVAc9VKhr1/JNZvuidaKuHmat5dnDu9pDo0BQ
ljwz3pw+eeqy8ETs6OgwnUFvzIEDB0zv3r0TKbc9olkV6sWZ02e4p/TXne7Z
ubPnzOLhM4L55J61LtlgWmpXi3KFlhk3mFlvzglRj4GqGjCeBjBUnhA9efgY
UwQGQXnLvb6/dzo0Fg9NPyMabf3czndTg83Upz+MoLFt2zbzm9/8xvz2t781
3/72t82ECRNUNK4RVIJyzPalo+YQzvzXHe7ZnqatZocbJ5QTcz7vdjGbp/5x
rKldsN72dBsoBIEHNu8ym+YvCwFiq/FERQFsGl/l2Q9d2d+80ywbPVfMiILQ
+1P/OM6B0jeBcCv5TGtjc4ggK0hMS/Uq0VpPU//6VNN5qjM0XJIppz0/iYb4
DtGRx1PPgxDUDEZKQ5Vv2jbutFNuZUAvvWCxcFOHWyDJ11zW6Bly5Yfl5tTR
k4LuQJ4TzKNHLzXTBpSQZMi7VBCfn5bT+WbJiDJIWU8yj//bs0IkkzSODojk
vB+mXjVzR1eD5IrJS82PUy+jaL57DIBKn5tIAGL0Vo6tMKeOnQzYngoEVIRY
vOaVyZ5qyWT5AmRMgVmDyyTBMaMNFmcmxTNHNv3c5kXUAbN+xiIxJt0zyL+H
eOxP40D+CktQXUUzmCPaxx+lXjHzP6i/I6EjNS9P8hIJHTlhV8HVk2uE9Akz
ecl/j08g+8uulmP7D5m1JfWBjHbPNs1bxguRbI1IJtLTg5IvGd0/k72/TaEo
2tN7U8Ot1J5wu+NWq6CE1vIYHjDb69eafWu35eE9Wpis5FDfO3v2rJ+bJNrp
u0uyI7NizALSUULIkOZh155Y6lBuXWk9Ict/9XPP7FJulr07T8yt9AygHzv3
QI3VXszulVv8V/X129T5Tyv/ig8WeBR44RLUxr23ecFyc2DL7lxQkNT1gJQY
Weaf3QopcS69SqDcwa17qKkQChZRv5qjHIutYydFuUJSokx9zRbPzaNGLdVI
YXKoXQmBnAUx7/FIWs33fCGQzwDBwZa9NHVC5QgWO7AhCJx8C5UjWLB49osh
JRhN4unuGfLQDgkJajRx8tAxVqrTQqqAXpdLVL5CycUCDMbiasgaq9ZC1hRF
eHfGoBnmWPthNE12w5HdB/iv4gS0NFStSsH8LMuRebPsvXlZBE+Bf7a5fAUx
HrpjF2teRpXXhTyKhyHCEwCEZqg1akKAYKz+V+p1M+ftin7hmrP2wKrr5syp
0/zXLZJ93GyD5JQyQ+hNkgC83rah1SujwetF6rJtVWnTPLvRcyipd1ADMIZk
nUCk5QCQHUavIUYBuodk/rMTowClmTU/NMUBEMt8Z3yAQlqSLMeFAIpQCIB4
ijjc8TrZvlYS5Ph6Br6Zoj89PJVTlpqtVU19s0MF+RA3yFaig2+sXeWL3uyK
dtpJs3zMAkCYhCBZhTCvQENLzSp2GeQAQXPZEnOodX8sBF3g0JsVBu+hs8l5
IpjEBWfPhRDct2YbhC/3V5mkwvDJoIGkkzUPc4HALrqk0IcQrHpxnK+ypzJ7
gmYKWdnHahqWJ5nqsZxK1ib23/WJx/JLwWxnHlk1sTrWmolbUMn9dHhnmyfL
KpXmePth/guuBzlOQE/OK5DPMt+pSihH6hM8K6hv59KNZveKzSGYWHndvk+B
IlNxkCJZ9k3CxCgF4PQhLjHl4xti7Z6vWZYdNWoJG1tkdAG8drsC2ZXoFgUH
0MLi33l7QLOcMVGjyY1NgVLlTe6ZndY0vYV46h59HSLhZvH1pCdHmkULW3zn
swgVkqEnnAzNyl9FTGdasRvOUIV11SLisQyIWX1+b54qeIChXetozQuBIGVe
gaNSWwPFxNewJPvn6N6DISy1aiw73yy+/iUb+mkqhSzXdIC9a6wauHh9blj2
DNbp9LzklgKld4l3rVhcoQHK6er7GRj4kGvwSfO6OrMhBAH5QzDbkpAU/EK6
IXgD1Uh0c0KS2c48mnrB3G0r1VgRZhdZjyvHVeYGX6EUPdyEUr2mYkZ7R4IZ
ev+FilS70T0jhbzjyPEQfpHpGMWPZA2sJeCXqXTo1Vic0cOOIyfM9D+XCNkd
xk8z7HrH4/dF1yqZn9Z2k+KUmtBawPpJtg9tQkhcttWt8RpIr4iUI4eu/Qza
Fw2e5quEP1PSToQ2ja/yWEnWjlY989WZ5ui+j1CU3Jetjc2xavp5YUQOw+2k
uPJf3SI9cKMF7pXzC9iQaQxFIHAGFcfxDE+ex6y8IdxBVe0rk32XwJsN76S9
Wje4Z4d3trN6l2ykdI9Im7fMP6ZeM/PerUZzvOi7+Y7m7ELufVcSMMYLMFHb
cOjjRTI64WwBHk545Kj8ZHrmfpV6ztTMXedlkRhMNFs1YFwGPHYOspaYbKKk
5djdTpZ9465h5HTVRB+ak/pKDvwUmGYBwRfokyWKVZIGpGGF6ua9V0teKFRn
5wptrfFfFykEAStyyJ86ejJnrOTyaMfjRkFUqSXIcTngIp3GCoxc4ZIdBFxo
mFYU+/kGNHiWTRGwd3adMdMLQ85UaycDsdbGDd5JAMTYM9h2KISY48KcJ19I
yqcRI7oeszS5RRSISSntEIPovPTSS80DDzxgfv3rX/MPIahtBeWC5mMSzWIW
KLMGz8kYYc1nrGlCsqnr3TMyS7CAAs/dKzdbwblJlHOs8+wEtIei0nZD0eqy
teb/pv4MzDxfC7lwURizlpYW2jo1ZWXBoN1yyy0qZn/rqqKNQ2eeuzmfnrDT
+k82nR2nbnBVk4OjfGLYuohuFrjn3ZWOXh/b+WCzALL0ejEBA34JDQ9UQMmp
gIvQnj+mLglZB5cWK4CxPXTokLnvvvvM4MGDoRio0JG1vLl8heDcfLOlciW7
rtO9KiSVjzeM5Nz4C3FDc1LZ+op7VjN3vflpakCsNgor1q7lEdbM58CHI3sO
htqQrO7Qg0Fz6tQp84Mf/MAMGTJERFVc5WjbUrXSVE5dGh0N6WRAuzUDJ/k2
tM0H+xnQrJ5UYzoOHw9DMyITGgkXoAF/xCmagIb3UdyuE9pwxkyoDdrnx+au
gwbs2d7ebvr06ePYJ46JCniO/b2zi8QMZ3eCm5bowcIh0zKoZOXUmZSgsuPo
CbNqUjX/1ScBjcBl+lGsrOuV8K6GOLk79jRt0aQSbeQfOMBed7Nu3Tpz1VVX
JUilAhaPYlporIieyMmNcoHJszRUTm5hABXyY3V2nA7X5zbm01RkaDBJM5IA
tcBqIIwYMcLcf//95mc/+5n5/ve/b5YtW5YIAu12iwnQWyH4uoQhP9t5xnuk
QBzNb7gJUE6KrK8olAGEiF6Com4DRMWLfmx3ExQhyNJM91b4GQjdty5tr1yc
UE6ChPqclyvraIPQR1L9TV3VJhSVdnS0KG9oPzM+gdAvuFpoISAVNG7SQX6s
mVLLsRCSKAqTgy6uQW1HDWuOpJ8mXVxzgbDN9Ls5rUwOMqDqHWl57shKijtB
UXbYb9wZC9PEJ0ZkmFkAhzaESKLF6eYAZ8fi9PYWwCHHnWV5IbnC4HhHUz5J
lwjDFEYnW2wXAJjmErIIhZjFhQldLJ85qYReswRyBvRFriuy13YN4O8vys5Z
tjne480G3pHdB3g3TXZDzneAF9mmRpUzX5nhHefXuqLEHqXPTULxbnE+2STw
rCpznRg2WqYXjK2nz8BPCjRtnqMc7am2Ow68MDtuNASkBSd7VjKnyLmzZ6l5
TWRqEDL/BbXvoN3Zpq0Cwu68xzl7SCgIL3mzR7e3bIeuE42T7fA/U2/S575K
PxFRKCUoUGQ1rXJlrihm+g6yzhENsZiNKebZsiWi04VWCKwz88cuDG1mXKhM
IUyxawUuj6bt0Fxx6SN6WF+92SpuU9KGfzI0GV6cWI8yxo4CJKa/XAoY/AwQ
YhjkzBw03XzzrjfDCmRhqIGytxZw9NG1ggRhgAIBOZcQdibn3MURrnaKQA4I
yJqBgMq9o+cCgQUTGsz/Tg2KjlJmHwtYKxNYaghU0G53dZMq71C1VAZBPrkJ
Ns5dmiv5+Wnzx+lkE6r4r0vcMxmlgO7PfnOe+U5qcC6Uwv8TsqjC3B7EXJUn
UkrRaAe37glRShEjCCcDpRG1N2GgQbN0J4Nma2N6vzEC7u1Am4X1LTxvRZCt
Zq1cozy7RMEI4VC8oeZcCSjn9IpQfWvFviDK0VY5dIgLslNLKy70sShm1bNX
m/UzFkckSeziDLtPOtSvUai8JFxfiHLenXMWDsp1HDlOfqnY+oJ2i9TZGGyZ
tydJfyAR7A6fUecJhVCWvjD52nDrWdSUNJBzrPBq37zrGsfr0utO1cSt2hcq
xAIoxALQX5cq7IVymZ4PPT4p2JvZkAtQspkoUF8LwnKvDRfNYilE4rpGVAIo
CgUHzyfhDaCk/gwAaJoi0ApAaYBmmos6UMfa2AGdE1AZKkmGWamtUX0joPyP
u4bahXQaQJEzNhdQrOz3nPJlBYB4UDKE9YUJM42eURWxa4kEWONYRBpxpJzT
k/oqqNl3AIWcsrlMJDojZReJXKDwO0BXu7asvcB2g+QHTYb3iueLzyuDfZl7
JoXmlwTV89+vtTbEIvp8WQJoGhXMqaX1sVyOcnSY69j+j0LUElLz3qv5a1Ar
xxMk0IkL+GtALbH7T6yuf39qCH1OolY+u0zp1Zfcs5OHj/vnKEcb0DBcQC0J
00M720I8fV7UFnL1Mq5cViWXcEk1aWH3BCBr1GhUaxPDvoNh3rd2u1nvPHio
Uvp+PNtY4YiNY5STOmQOBG+Y2WAVhTUqp0g9RjJ1SXrTEa2unlxDFkNo+GSM
2iUCLzRl9X8QzGFJzl5GldL/rM0TlKNQfZzFyIFg2myvr2sJEazJ0C8lNLl9
4VrSM0PlKB6IThrFUWtBA7WrJqV36S5PaFqbJyISM0QtEwsaZdQTuLirNNLR
BKulh8px/MXKzYLGTDuXpKDG8l0lVG6A5CCm5PbN5Uq12KCl85QIoEe5M6fS
z9AlmhdwU6OcNFq0rmskol25aHxcKdczO4mL3pyeE4ly5LSmUE6GnaA+tp4W
rj0vEnkGOK9eAokIYqYzp2JbvRt9sPx05oxXCILyQgeREgUt0NYm4qXQE5qf
iIP/uELFFxMoyxR6YSpQjoM6nXec6+tG53A/EU839rLk0Gp7L59z5aThDyLk
wvtFpSOXOWwxKcnFYj9rI6nhgq0QGSWIcnKbz8ckzW70J1kSRjzpVHyuaEjR
g6Z4J8bJwi8qzQMNiOFfpPqb+toWbVS13stNdrghUY7O4G6tagrPJxHljnJy
Nc7GB7xz/Vn3LR8S2hOGVorEXOj9t9TLpmrmqqBoIUL9QquCJkdANwVbIC1A
IO0zPdAUxtQ0vioJUrk+n+dUYKeIk1TaDPvbBDDQ4/kf1JudyzYCDIrVmvna
rJAaoAk3VC1nGcBQncuj5nxRtCx8nMBDRjBHRGJnZ6eZPn06JyCwMHRPgEQO
2CeUZxok6EHgym4U5Qo5LmHe+3UqHrQDhHNXWr1JeNg+AY+I1xu9gUWu4EEn
NcvLy81TTz1lCgsLk/CQ/dFYBH5guf6jnFybgQeZ3Yda96uTRQYkJuGhhqEO
KQUedNxQwYOnqfOwJ2gFSYygES4Px3w8MjfcMgFa5EELVMm2d+OGWJpRru7V
KZGmC8zxg0fMjIHTgIPWy+J4Qq8ELufSkcpXoKfvpT1GIFS6kUFoxGGeRABF
TyCIM6mc1DvQNC9ITnu6IguVTCRoI8kOWx8vysUVDbDz3kWcnQdtMtgbg9PZ
cYojgCKDI0MyvuDmBB8ht4uh5GlNjchhMPetTZsxIFh66cW2jXflZOFaSfAV
Sq8QE1Y5baX517t8qgUQLMcOBNMY11VuDgk1rykIx2QOBJPmBtsBvZOuFW2f
CuUoEAPGtbajl0Tt3HdrzQOp16LUymhHUEtYR0U4qJVOphyolZMDveMwT5dw
J4laedgBir88ovTJBGrpDFJN2RpwpzYHr3LUusOuKjNTWDJESA7Uyurje6dT
SzmEEBGEctLRhPqksXaVeAYW/GQsqXq7cjk4TxLlM9io0pRGOd4AcpFh6BIH
SGzaFSrHeyLuhIPmdU6CVpsOdOwXYd0xkldnA22BAoFH9x6kEDb+61NK4yjH
kdhHT4Q6vnNJs49OTCJQa5e3ct0u2qeUcj2yjaE+v+NJLQzSFTVsCEGjzajP
K6QEqlKmvUAiz46zJsVAvdwVQNVylmioJ1APg+p0wA2x+y19Y3rsFH+IDdL9
aAWRIHYVlMggIKbCezmEOgpi5S4QqpaC8jxBcVIgduelb0yPnTMAoJCVK1OR
SFC0yZEDKPSUAAUoMo0BiLVziSJ+Q1VLR/THXfeiQ0rjlKBZAxx5OAXnEnJz
WkWZzPMvAJMO2j59+tIRE1dX2CiG05byncGNAKq05ImIUM90WMXGal3gqtu6
dSuo4t8nTpzw2xQUuGyFF78SExEWbJD28K2MGTPH/PKXvzQP/+Rn5oH7vseH
aLZv366Za+jB7t27zY9+9CPz85//3HznO98xa9eudQRlMiAfoTp2MmHl8o4U
ijfeF2guCO7I9Dtkznu3al3l6BId1g64eNNQ7O5CoMnslTjgEZihwdr0N7GY
hHuK0RDBhXFRjhgNeYIMkoY3QOrrzT333JM0GhQeDgJXrVplbrvtttjRcMZC
xiKLMZCKijYGyKAi5ULQt6LQM+qLPBrjXSqWP2GcenVTpNuEs5HCr9e7xVtD
vdjRV1RUZB566CHz+OOP83yg33Y+YADomLJLIpf7AIRcIubo0aPk0UgagJ49
e5rjx3mXiH5TcT8AUWZ1ntAcpoOEs2tDEe4lwiLl+RtMAmlCYzhk9lAMx9aq
VV7PvUKR1U3uOHhPh/uAAQPMM888w4jYLl/qHsupmaN0op+BAwea1tZWUzO0
hCXVrbfeqvlUMBwFBQUsbmkoXnzxRZ4P2mGdHFZd7WRAtjGAIu6C90PCRB70
Cdyel4e8SATMaWt9bdlygBlyWuk6M+b95Wb0qKXm9dfqzPBhi80HY5bzszde
rzcj3mk0H36wwgx6uYZ/v/Tnav49cGBtN/P+e8vziv3r9BUVnzBhpV2IXjQ3
3XS72bvniOnsPOsTg3JiCCeBMcyh2NC3yzk2FMNMXtB7773XtLW1pYdZ0xUL
eXLS2leQX2D69etn1qxZ45GS+8cIyr3xxhvNE088YS666CJz9dVXmxUrVvhB
lP6lrIOoGw69BAXCj6udYgp6WRzaXKBx0o4pgdHb2o6Z5ct2mdKSteadx0Z1
M6NGLrE9GTSwxsyft8lsWL/frjVHaagdw1+IxK7m2DGr/a7cai644EJTNruZ
x+/FFyrNyBGNPI7j/zDWbNrYZnt8Vh0jOnRJUZUgZeXKleZ3v/sds622s/xJ
12WHHMIa03tbbT5zLqJ7Jk6caH74wx/a7p92M6DIiskOq+e0mnFjVxKxluqR
ZuBLNUxiUfwYfcZVieUuTucvdr2M+Jm1hDMYLz7nvi6dJUQ7UdXbld2794ip
rNzCc4smycgRS8zUqWt4DA8cOM788AkHdnzO2WLbvXOm/NVS8/Zbi80Tv5ph
nnt2Adc3dcoas94OOk22SxX5STFP5OSBMvH88897OeOjOGNmFS15P/7ej8y/
//Rh+uxn1cayJX7jC2drpk2bZh588EHz6KOPml/84hfB0tDTHD7cYZYu2RmI
Esuj77zdaMaPbzJNTXusFGVllngmYdHCONKp8XBG0fA4woqVUZXoMB3SRcKF
ix1b7bESak5ZM4NIPzRADYt2mJMnT/vFKXOyXsAeRyQugO5z8MAJU1e3zbw7
eikPsJWPpqpiC7FoNMrHOSw1AfVJZfjodMG+Ndv88ssZIHa2i2WjiEXCrJkb
PCUTJ6zy+GrGgJw0jDUgZhWqYX2sJQiIgyO7G0MQy3OpiK0n/q6yvP/2Ww3c
sZm2k62thyBssYufrqaQw4oi6PqcfJbFrYHTzOgSH439cKUVj/toasSdDrzS
PaZdHDrWEvIJRmLzpy5jpgbS0gVxgSPoxInTXAVJS0y+XTsPQ1bILcocJJP0
dX3aPZOnogBtplu9iMXB6tV7LRbLGF4SKZs2tovTJ0EmHZjB0tWFPMc4rYKT
RbQ+EBeTkKU6Z85Yb9WK49FTRBFo54+p50TGbrQ0aGsXNLPzT1OtegiCSI6R
oIDusWbNXl6MEJUu43FywFcOB/AlvwqOiWp+TSjXx46eMpV2BhOf0Ywmcjo6
Ov3Zrpr02S5odB2Hj/vsn71dNbt3H2EmoWpIwDRvaCPIo1kQ3ckGQDprcJn5
dmpIFFLNhaFBioNZxK011S1eLtTWttAzHL+Qnsgc0JQtaM80xTbf9VzCQLN2
48Y2Hx8Hqiqm8PyTm0OI6+grCKqq2uoJqrfMevJkp5dxYjfms652NnQt3Q6z
T+fY8W6uxb17j5qSqWt5OtD4kXolIh4P7djvj1LmAKFsIR7WYj7S54Qjz4t1
a/ex0COaZ0znSensrPSspBw60/9cAvhkvsrLHDHpqpb5+W1FtFTRsb2jYaJR
8Vk3e3GaYvOmdp65NNBkYdilSez9pJe6LoJ1haNAc19ZAK90Xx/a3W5mvz7L
80ddwB9XRKBycaeASkZiBkV7MMNOmbyaYSK9c6u1mua/V82XUdiGk+CRA/pp
gfyyxh1mxOPvMjTl5ZtJ2n4igSxbtTNAWP6yzvYv9N/HgqewZukYF6FHAqt8
wWbuMS1PtDjYZrWcDz2UZ0XpZ+a+1JuUuUPVsnKtr9AxhsOcv4LvA1uZWihH
fF09iO2J/fkrYjLLbAHTBcFFWo6UohybkNcfiHCMbn9BlQVO9kV8V1ymuEt1
BB6kr6eGmYdTL/LXxNy0SpNmbbWiXIHsnqaSHzsqtaLx41AYGlM+07lldzae
ivBPsTl48ASrgzQb3nt3mamt2YZygXm1dpv6fvyz7lGyuK7Fw2Yw1R/LmDqs
C/h6ujl+JRcJ0RdZYrhczyzzhk4+/Z/UoL/KvHEigb+CSMBeT67DjUVs8+YD
vOoS1iTUrOVDxbA4c6L1Ex0hCfSXMP7/x7kUSSdxHnOplzTEPMdZJZMNchKc
JEBJkFqBmvOoYWLVVmz8a02s8omN7GyJn1g95DPT0nLQjB+3kpl20qRVZteu
wy65k6eSwkmt+ty1acWsyI/l6lTxwofkMAl6LueWtqJjd0XqH8SL06exgiA3
XeeOKDcVk9NpWdOHcUM1woLkVCoude/FrppTp86wu4hdRbTWBmNZlGahDIe8
xpoy0GjaC5NYiUwHcCr0ZVcqgQO5YEmpeGt4YLe5+QiFuH3TTjPnnXLQ/ynX
cSkRcMEGaCb+XbE8zb/z5m0izwuSccq4EQ1O+IborCZ8Xd3jxxP2Ivl4oRyT
DKfVyNpISBAkM2Rp1WAQ2W6aFNhNF7mqd+48zNAQNxO7rFy5m4js2cVBhMOi
uazRW9raCCINWuep0zzYDnptELHYkNPFMjDXQrDTK3ahgCs/iJsO5P9nwi0y
n4BQUjRJUSZOpWqWWM61a5DmLdZGLuF+pl5u+tKKRrwBA4I0p7Vr9rFhHe+U
1vfE9u8/yhYlzS2qi7zI1oJAAgDtyBEsLrrda8eiIOL50w7uqhmrzL+lXsIQ
anD3dFQQh5NKSz5rwmrC+CZ2F5DvB+xLaVVxlP4zYvoKtxsIOX78NC/tEBJk
Cu3ff0xL2na1gJgR7u26RHUsrN/O7gH6IalL7ijyxBYppGjAYrknTxm5G+BY
GjpkEfsKiLyLlfcA1f7mHd7nAFQjDhkU5fCBUIqfIvbOyvEkKIhXiIQeSrNA
NeIKKhTVkc0FKkjpIFYjKrT8JhJap0Mhjd0lrspDh06aBfM3m1cG1nCVVDVJ
9NbWQ35vKRPkXqH9QJoBZLiT7oM6yBtBcpi6hr0LTjY1tiI0WNJoBcAbZjeY
6lmro1JCbvv3dd3fZeVYbe02v+RR0+TB2LfvqF82MgEuigJMkoWXztKStVa9
tETY9yZNDPiNJjIcEnLH78uZ6OIkBxY3QoYUB/KDWxbuRv2ztYz73QfsQN7Z
etgRXczOwY3Nbaa6eqsZ/cS7zDJEDVFWW9NCHOwtfUr/hIyU2r4xtt0pchsu
VgAexJgH18ld7tomxYE8C+T7AG/R7xK7Qkz503huG/0kQbFt20d2Nm02/V+o
MIP+dZgZbftKC27D4h1cFkEZbo861t/9hUwEEYAWkNDbnO7oNNVDZrLcHj58
MXeLhAHtBFA3qVlaG0nYkPyirtFkP3KkwytYRJ792+zZfZhhp3IVVhjYAc4L
hqSI4aZ6Xx1Uyy510ukbR81l+NIidj0dLMkKuyaUXE5e/utTQnbubP3ITHp6
LDFe0JViP/JEVpllnLq6FiZ/x45DPF1pA0XojkwaLXPkQ6mzWtSC+ZvM5Emr
HWk9PGkvDajmqU1ubGJM548CdS6+I3b/RxksBJyCcHnmJZBZF/HMam7eb1ZZ
4MlBSq4Z0qMJ6MCT1WCGDQ0GdsjghbwADXyppht9aZe80tK1ZjyxVkMrd9yK
QCeXMgM0XCITEBSEUx86r+FiD6FzY6OcPBgZyJbLaCxYBjU17TazZ23g8SK5
QZS9/lo9U/PKwIDSV16pYx/nsDcXs0pH0ptUdFImKywq69ft59mDhUGyG/rg
ZGBXBgnkoQqZDxb+s2iskSsDJAPH77kQknKd+RvlmS8nEnwgplAeYkU5KdNQ
nzvYl2W/LCObmAwsYAxQHzLdJJHueNiTLpgDXRWhSSoTaRAx6Xx6FUGUvBq6
859aLVgNIx3MjJrw7XixL7bUQWZ0rvA+zbvzksjcWt3kLzPEyElbAoTIu2BR
Tm6jfl5pQwulTSbY5WXLs33Pg5lma9QI0CJgtQZBqDwKgHJtwvJFfbWvTvHs
h3J8bM9h3VVCdbbt48TnIjut4aygu1tpJdL4BK1W9U9fGIAFmHMXOnUF5eTZ
a/ROpoZAOdrTh7avBcMnoSzLfTmerNmD5zCXaPJDAzOkV8wIYt+08xcoJ+OU
UZ9MK5F0tkALtKHbkEW6vghlkjN3LQ+EbBJlWly+u/4jK2VafRTlhKiRJMro
8nak0UFIBF2N+8/ualzauiY2zzDMvBAQxySu8pWmZSI6SXlscVFbEjEaV9GZ
Z2TV07gZ9bkjpCFi5oyoMN9PvRHyXkTtVTeEmV4Yv4MNavkUenVTqFXtZI2U
BLlSm3Syhi+6iDA5HWvGpi2ope21kUPrVWojolT3OXGPQK08j550VEqjQiKg
lftcZAzcrjxm1+6mLXzZhxsaL69EJjjQrDlCzp9mmSIwdBgu1KpOszwzgpGT
Z0s+H+mVMzhBcyQpZNJhskwfUjI3B35peOJtQY2MpJOOGrnyNAjKHdlz0J8a
yUJukAV/WC7kymfXZNLlKqflBJXTGyR/6ceS+1nHK1HNh0jVxCM6Exw+awh1
hoxmdzbDk4h6p784hXQ50QvZXNIMz0x/KYQt6RvzNvjvoerSWNLyST+L4Hwq
zNBiCQuMtwycxnhLWybpLLTMK6GNjHbGFE5h6dq5VufMeaOqzL51O4Ad3RHZ
ReJkehItybw4e+djV/xJckrz5JJEZCHOmz+oL4hMWZZJHCcYIf7jOzHmvF3O
egEiUINTaPMknzpfY6aK7s7do2cyMVLS+XONApn+IYlSefQd9clkcI7SxOxC
xWp2ITuc5hupoebnqRdZBUTt0hQEVfIWLp8JgG5sc0pLV6mXQecoR5mX4dhF
fZRunmJBZTl5sslRH59YpRCksnh6LBBPQVVs+uHGB+rQgrELOfm5SAeQLRNo
KBQ0wo9aWhItExHbNe4uZpSzE9yb3qhPnibKkW6n/2K5EZtD6eFEQgSaxpTE
kJIZihPzQCDOvQEE5En5dEqPtEjTEvegnAwt9LmY6Nyq80xriGZDgAHAi5n5
MgJ670mvh12lV85B0CEPSSfRK8OvtJxcWnKJrCPuN725+7ZZbU0D8RF9r6vs
LpMyorPBfVsbQ0TJgGIt1VQXiU/MF1QYoh8bYxrraEODM1zy0D7KyVUTvZNK
Zuiqwp3tsVQktSt3Ma4LU6tmAwpTS2KSEjd0lVrpUklK+ibHEfXJ8c5Crech
7aSco7avQhaFsFMqOClPABK6KzONoXrpO0kiS2NFqTonkSXX5csVSBLIQkYQ
TWygu1LLQ/UsNlx0QZfzMArtEuVcErNQfVKsoZxcLSRZTilmmtCmBgXqljk8
k9JiysW0q+kzZcYEJHiRWlyUpeTKED9kTCI1p01/dEdaxQhVjmSixmjIxdLv
YwYqUazs1cwWvCtTIoBqqaJTJA+ZvxpDd4FqKQbiU9NmXAsBqiVvoedODY5d
brWk5D75roi20aimz/ReVqq7Z1Dt4uo17ksiPHJ5WmCXZpoR7k4V1O4y42XF
gHynoFfLM63xO8zr88DA3VimpUr0iW7FqPiQguMn6XJh5mC6jmibfSbi6Lxt
FR0plorvzY9kFMg6HWR+zq6mGs+8py0WDJekSwPjKn2UAz4aNQeiQOymxZ2e
/4wODTgylJcwMg3l1Y5J2bjlFAYMMh+XhEHKd14WZzb4uuV6EvCdfu8AHJCY
ITxcyUkcPpOAp8UdKMgLOEHdaZH6KAkF6QYHCjLTahZmcPdPoQV5RVISFoiW
ARYiW1jcAX7NHZd0HYR8hqOu8ug8ytHyDKehTKgPuzoEgBbrrDclMQQS2jDi
LkFtjNBFjVNzI7mAr/ma+eoMtOnvaBCphbVLE86Tarmao1dyQyap98yJO/aH
6uM0xM70jb+Dp8DMHjrXfDftqQaV7NByTWlJBHKgUsp1caOAB+qahHK53o8j
NbVrQm2cDVFZ+sJkvsjGUZnE6fJZDlTSrhs2yLQqtFt7ENMn7wNDOe3+I2mK
oByd6cRVv6AycgmivHaAHTiBnZ5tOJnObqJpeFW0Y+9J5MklIeiLfhYTHZIe
Da6XnWvx96VkbEd43hcBiddnH0K5wZpIozgnCRo5z5VTR0Gjpj5q0xf18o6g
M2Q1FopS+7PUAFNb3iznADYyc6BWXtgOKsjqANPh/qIgifbBUDl5aXcctXJE
JYpJHBARWlkCC9McHewzbMPrFNlCaMS9nhnZ6b/KV3qMAGK5OQZ05MXw2pVv
AbWZWrszziJsFtvjz8eATCzlxz/wv8Rq/rCcyB2MO03RZXa/W4aIezcHxCTV
QEwKJyAmb1ZGcofIplpatqWvOcblUS6widGK0flyActl28oKFhsSzl0XCcH+
S8DSburEzV3kW+/Gu0f5/DnMShrQGUYy7q46529PEjewFsgbbLNheI7v0E3n
OyDagaGLiI9lWs21EgnGz2mKBhCmA3CIS5aMCkIW+0YAXcQnWZge/py9LwRe
yNC+WpA+atRS3sd4KPUSw4NXKIzCZbBJ1rbDXEiXfFIeFU1SXBehRKIln4VE
e8hPTwQ72n3oVaiWkckYRaUq4zyizDlz3D5zXUj/vloQebfLkecWYd8shQ4h
i+uXFVAouzItndGhTBCfjLsFD69Ip/oNOeFT4XIxKTwZOwE1t1Cpi9yTawRc
ldeEygdK5zuPjmQComMiwZHEHrbmIJnK8WuLbh7Wv1FqjrcfCV8D7O6zcQjh
PvtLL72UM0uKnV5tF4igcKjY4UxbgTixxRHwLv36NQpSZcPmkdtCrA3pnVdc
jBrivJGe87RwIKwRMh07ukJCCQmUAw7NSCLI9c0bXW3KxzeIU5JIz67hpGSs
VC/c0M6l8JmnbuT0wbXHkp625la2XjwjkoJ5TpqR+aFryvoIXKKDr915jGNZ
0koCLlHFhOqjiCXK7m4/Axd5parDBecPZTJJLYcA8JA+FvSIFUkXww9Kg9Er
F+UyrgFBUel66S1eT8pRrNl8eHdzeToGQ96/TSbjI6n+EhD5ugME26kynWN6
+1gz+nsrz65XJIPMziSOhAMGOncKYYYqKayRwhiTF9hw7D/eleeK5GXuvMn7
3+PkfJFs5mDAcUKZUVE7CA6+kKGl2gHCJEDqalr4RqIIIOSlguGHKuVlDKiS
zrUiJCqpaW3MFMohKbT8g0mSAgkb4qq/XnkGBNrtOFMSCTcz4sEK9DVcQYNy
MvYzCwKefVAfxdhQLpI4Frs2jIqW5S8JFek2QJPsZHf3H9zgntHODaLAUU7e
8XVDAiQaytLvi3IyxAj1yXg6lGMTcUlzrPAJhZLpZMt9aRwMptWb3P0yrAy8
ztv17hgRusHuTjfS6G7VgPEZ5EuRjHKS15EJDQ57WU5yDuqjzTfyYli1uavk
I2VgpTjmgIyjJJYrS1bI2EFPftC1xbGjiu42jav0XAKyOk91mvrXS/ivGxUu
Qbkddn4CYtRH55agcuIwepAcLq3suUj7DKcaaG0ckYbfSU2OLCx9bpIZPaLR
K+m2Hq+IYn3HXly24ZS5BoEnyYzVU8OavCZjQD8JDgTn3RhbrlDQn9ZHEjxR
gEGeZ3K3YXM8IcX/EgDPPVuumSuapoO1R85h9JjONiEaBz3etGC5GflKudJj
F5ThdJMLlbayIRHVWHNAQmQlV5EYPWppV5GQV/LcpPA4UjOXPDvRoxBFQt62
lp3CsHcf/ZAHZG/KjoRMbosb0o9ZA3Tq799nCWiFpGaiAQk5duiB9CbdFItY
odt3D83g9NogLnVEvW4DL1bmw7CXN57hXU4z5zacc0CFjB0MHqqg2PXtC9eF
yJLJ/1BOruA3yWehgcqIMtHkIhRdF7mXlXJ59hPdkZM+gfLuCc1TWN7x9sMh
ik4L4+EC5d0bHJVg3bKhc83BbXtRlNx9OBd8s3u2+K2ZGU27YO1Y1QeUy50d
tCGltKRcLA18DJKdegvrt9Fnn2hE8OvNyrNeShsgGZL5e3e9YcqGz+8lkKDM
1HNHVtJn1Fo7aFLkCuxwHpyblZaKRZUiIPTmbIwdCDmyOL+bGkyfNTI0cmGC
kiaKDdIbI+RSWK5dUGUW1p+mBphv3vUmfb5JdJkQqJi0hD7nijfyoSzk8Pdh
FP7OMiM0ebJS/j1rb/849TJ99onUz6b3XW/BlBmTjk4sjvSbRtA3mOHCk8QL
+/Em8fhb7OXkaO0k4uWcQ4p9ev1fUgMpFY0qBrIufAG7L6xrIXcafQYKMhAl
qCUdAkDeaKS52miF0OYFy3z2e+rRv1uz8N7gyo5bFIIkgKXpu9glJEGQ//P0
GR2i4ww4tBdgHfbk8AE+u9rKfPgzBs0wo96s6yo0Lr2c9HozTEQERoj25hBM
eb0YDer53bYxNFlbvskvW8WCQqLO8QIwClZOeUld4FIJu1fDkRgUVCx8A556
3odz6gzQkvphXfUWtuZ6ue/sdM/QKRKmkMsT4Y8cO9OAV7WzSHYVFiJJIGGL
SIJElJWkuQMgkegPX/wWTrwCkDTPLO1u0yW46B4rUm43WQMJ3YqflWL5iIOE
RqJt4854SPR5xUaGbQ/vkVYGk/xWweJYYYEFZVCAyz8JC1JOyYbsqdB2oxOt
SgAi/UZTyM+fFpSJvBKdTfx6ST1qYxvBHUvu556RnY/wXOTuoJBd6HL9FFB7
KM+0mYO9DBev6AGkKwARTIj6KYobPg3UT04tHFROoF7rDlJsURAdLmNAU7xF
7PIyi3e9ioNybBie6AiVk2N4qy5k0TR5S3DlEKqUS7mvkqfIuWxUusSZ0THu
lkC8ExWhHlBnURY9kF6JWwRRRNCCcYtI2UZRkg3YXu8nZC2tu/cEvI/WKWYP
ns/b0NILYzN6KXueA/2RyQ/6KWIQ/ONrfnuWfx09aBie1nehfh9x21ByUDGh
aZEteWYC6KfAYtwVIen/p9QrfImqoF/ShdZl1BZap7MFcOfeet7082kcN7dR
MwW84JhgUHN4Pd9g5z7Nc/SY1B9sWkVxoJ+SP43rocAIHKhquuOPdg3P4Tx3
EIqD9fV294zyWOD6VJQjqwOzXeIgIrViuD/QsKb+cRwew6KkCA3sEwMASVDN
3PV8aazGMBpga0rqzCErLNFlKcjuUIbdKYAs3JwLPG5DHSYeed5go3VPV+nL
JnBIjzSHUC5oc19qKH0GGDLTjQYGfSYAtHEDcbTvguUQ9VK0AC5BRDlKSgBO
AghV/cexxuEiDzSFEXp4w1vpcYDnmIxNSN9+uYHwj3e9ZhVlPseKHMEUbLp8
THnI1xwIncy1mNb5Y22HQCflX8L22Z3AdPiMjI5anP1oAQ+KdwzfyVXI2/oI
FHERBqoWDVCImWmLWdZBWbZ2rdgUWnGdDMXGhHYJpLYxAeBwEHbqf31An9ES
UVU1oynkpcZsptiJ6I1jUkAALdqQAoKIFTq856BZNLiU//qqe1Y7aLJ/NyjX
g/c8XGoPzQt9s5BB1Pv6qs1m6btzkTvZjhMn2ZMqmsPJuxLFHYzahh60OFpo
cIAIwpfs2UVDpsXGnvjlz06BzlOdoXfJfQQXPwCgqQc5AqBoIxFRiSi3cc4y
HyyMLLXUD9dusqwJh26M+OVoc+r4yfS47GrnCRDn/XK+Hejt8i5FjbuAHs3i
utemhhCgfW6SjnGRKUBv/9ptHim8u3jodO9oQ2rxyDzu56Y3UWMtXA8Orbt2
/qXc1/Wvl0iQeFvELlN3Cqxw9RDFTE17YYrHqmrAeL4uPc5fFsFKXnSY3kHH
fKXjMy5K1Rxo2WPF7RwVFXSM1EenrPPnFmtxuACXqHgHEmTxzn1qBC9fzLpv
TicJlXI10t6X217goIq6V6c6jiv2YWOodcpT7/tpSbo2OULvyGSN0aNHU3SJ
yhpwzdIeFq10dCJqYV2LNo/uxAjbTte/NtV2fBoZCYU6ube5x7RnR3xS8fxY
mm2362wCzDbOXWIm/+e7Zsrvx1gF6sjf8eNMjwBxU2X/sZz+4c6wxHU36gUj
eOCA6d27t0q4C/+IanR36P3roT++SX98lw4JkoynHw+XHr2nwoTE3zinExJR
zu7Q+5DSHyf2ONan4fvwn0HXNZWgr969fl3qXncd5+i6E2KmfP84bsv4Vv31
r2UnJsI0mNoxfo5E0RiTiSl2hCJTIV7iZdQg6WKyYqi5XX+9W1KtuT6+JXvX
cuOf8+ukOtKxncydL76rvxEz8M/qj2NEz1fjm+X/My9oD0mVO+Jfv19vMF9/
XJ2jLLgte4MRvPP1x/fq/fivHGe37Ad3o0jnpBjjNkZ+Zulr5PEfk0ZahQid
VB0Nua5WMSMY08l5XevNwvrtgUZUQB9lb57Xm71bf/y77M3KIeFmqaGgWTFS
gekTKAnR+xPtN7FK9H/Ed6CnDvc3dEr+4DogtVTpis6lA9x+T4Vu+/kb+rhl
azZOIU6g+x/0lr6q0w2VVQP+6eyNqHIuo+3K+Iq+l8xvXa8o8kYM48aw+e1d
rl9b0u3n/skCXbpfuJkYGGJUuv45ivEEZzDChyJs+sfkBrPJ6xwajEzHGOk6
QH+c4LaKqf85vaLAKZeHC2+2bt2Ksw38+8SJE6oLIwa153TUXCPwj2TuN4Ur
fz1HkJ2sR2xBUVGReeihh/g2aaqNftv+cwtsF7+azIsLZHUFZsCAAeaZZ55h
6ZOXp0bsv66TWxGuKHLFfFJFkcGpkIMTvgddq4X/fyB4ByazvIZbM7jkO/z5
kdw/533s/wE54t07\
\>"]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"20", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}], " ", "+", " ", 
        RowBox[{"10", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"0.2", " ", "x"}], "]"}]}], " ", "+", " ", 
        RowBox[{"10", " ", 
         RowBox[{"Random", "[", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", " ", 
       RowBox[{"0.01", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Sin", "[", " ", 
      RowBox[{"b", " ", "x"}], "]"}]}], " ", "+", " ", 
    RowBox[{"c", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"d", " ", "x"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.36757251442617*^9, 3.36757251521293*^9}, {
  3.382871383144356*^9, 3.382871406269256*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "=", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data1", ",", "f", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.3675725294559*^9, 3.36757253029556*^9}, {
   3.382871363752193*^9, 3.382871367683413*^9}, {3.382871416039097*^9, 
   3.382871455445528*^9}, {3.382871513563709*^9, 3.382871521232601*^9}, {
   3.382871553117335*^9, 3.382871555589398*^9}, 3.382871595918028*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"14.434018892539372`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"0.15868032467437693`", " ", "x"}]]}], "+", 
  RowBox[{"20.237834049679115`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2.997755047249934`", " ", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "=", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data1", ",", "f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "12."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "7."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "0.3"}], "}"}]}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382871466532498*^9, 3.382871528962218*^9}, {
  3.382871614533863*^9, 3.382871616843829*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"14.434018892597651`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"0.158680324673327`", " ", "x"}]]}], "+", 
  RowBox[{"20.23783404968469`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2.997755047256532`", " ", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", " ", 
  RowBox[{
   RowBox[{"ListPlot", "[", "data1", "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "f2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36757271792934*^9, 3.36757273393646*^9}, {
   3.38287164736062*^9, 3.382871673594124*^9}, 3.382875020776573*^9, {
   3.382875634766848*^9, 3.382875654763021*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw1lgk0VlsfxonXPL1e46cyD5GZkGE/vIZX5VYilIuUki4lJSFTboNUdI3d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      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl3c8lf8XwI177Xkv99ohScje6zmXa5XQENnZJCGjMlJfu5KEkFBGJHtE
1JVUKskKZQshe+9+z++v+3q/zufs85zXPSJOV8640lBRUUXRUlH9/5eWwtT+
W/mWzpusU61qw9JwZOatptBDB0T8e+/IeYHjsFMu6/Iz6Qqy0v/uaYD1cZjk
8tiqTbqJWJTK8pb0HodfBpHN+Un3keZP+tG032Xgh0PS0SdJ2YieWcimp4Mc
nPHm/ZWWVIbsPUCQ+pMK8GDFtio1iYIYEaPydBhU4B53hlYTaxMyyRjJWHtU
Bboqog4pn2lCLFemr/AZqoDNrO2k0EAT4sqpwlwUpQI+Nsx+K3PvkMJJKfYf
1KqQrO0Rm87RgnRskVKObKjCCLXoqz+WrYinclpDVps6iGWxZthmtiLPHAzc
xGbUwUNjO7RztBXxUKnuuofVgBX/Dt0Gz89IRv+/n0w6GoCZCG9PCPmCzD2Y
wxWUaIDkx4FJ5ew2JLm3vuRIjCZofjjBpHu1Axl2smULF9EGjp6C76oPO5CF
s1vutmraMDFOk3K8qgPpwZ/F8ZtpQwJVwyHe1Q4k6ZVjmlqoNoxrSikv+Xci
1xYuKi72aENsJbNjln8X8iVreUwkQgfs3rkfSU7qQnp79vUWk3VAoeP9bFxl
F5I2m8yVUaQDg/MhgYErXcgljOLZmC4dkD02F2/i34286KBJbhBFoDe7rWbH
rwdJifj1yK0RgeJSiZClBz2I0NZhwc12BCLeRMJURQ+yZOkS6jSGwLEBra+d
yz3Icx/PRxM0AKGEktFCvx/I+B6dsKc4wOF795gt/XoREptN7E9PgK3HMx0m
D3oRuWWJ+UU/gLYX+qm6Fb1ILodt1sp1gKDWfWGZ5V6kq4+S2xgH8IXWRwXr
14eIrw8GXCwE8L1herHKtx8JOMvyaHQM4ISPViFDYj+iEK9umDSN+nOSXLQr
60f8p4QE5RYBeo3pwhgW+pF8u4t0cnsA2rxv0+wu/UR2Ptn6INwkILC+HKmM
/4m0Wr6aNecnwRJVhjjDi5/IUu/XY6YiJMibDqyunP6JtCcPvWM+TgKmuuMd
9G6/EE4P60NJeiSYKOYn2kX9QoQSGIOojEnwNpvRvjLvF3LjsqOqtSkJ/GIm
/9r+/oXo9pM7v1uRoP/8E/pKxwGkudvNtNmbBPnrLIitzSAi7qHu2phIgvCZ
naiKG4PI77KUvcFkElgNTbfRZQwi8djlK9NpJGD50GJd0T+IgIn0N0oOCfyT
Q4Pozg8hdvOXnlwpI4FJrNcbm8AhxFdJzWyqkgTioVaYiuQhpGm2vsCwlgQ/
nZWSbLqHkAY3UdkvjSQAxbmScvNhJLLsP8b2VhLwHf21hvUdRriO1JxM/0qC
Vb5WTZv7w4juYh+DWTsJCmjyPmPbhxEqW6rx690kiNh4wGEzP4ycLb+1vvCD
BNazNy3LWUaQw9//+pv2k4C1y2bS+uQI4nPEP7NtkARTH4yly71GEPOecNLf
YRI01atexcaPILUnLXTXRkkQ8BRPXd46glxV0D35YYIEpinURtjpEcSz6+2p
e1MkSG4JNiyhHUXUCjtzkGkSXK5zTaA5PIqs88XJOv8lgYzxaWFqpVGErai2
cmUO7edPrcp/5FFEJTL/uccCCSq9JMgHFqPIl2ZTlg+LqL9dfO+e2ygi4zU3
TL9MApW7/9x3g0eRM1e3BeVXSLAp8Hd7O3YUiWuXb4VVEtSV9N7ZSh9FProl
DaqskeCGTrPg5gtUX+yCNX6dBFrfS8rWG0YR+gUMqRflfYd00lrbKELz0iLx
5gY6H0uR3StDo8iYgYkR+yZav1u+rssLo8j1QknPKJR1cbabi/9GEeaGq6tj
KNPmGsYtcIwh++5//4htkaBFUZF/XmQMWUhJNTRFObpFqOSvwhgiLN6At0fZ
yIIJmdUbQwyXR06dQ5lxar1j+twYkve+bVMO5S9BY05/XMeQ+1bx+DXU/l36
b2uTQWPIKQun3Ccom6bVRU/EjCEGeiNFx1HmOJbH8zttDMmMazuWh8bfVX//
xVjRGMLppiJOjfLDEyFao6/HEKtJz2dkNN9zA27tw1/HkNpfa0990PoQvM84
Dg2OIXR9+RI30fr172mvDMyPIbhDdzWC0Ppm3DsW+etgDDnzdHPgLFp/WyFu
wk/2cWRr9honzxIJBMuoCvuExxEvgbGRZrR/OR19X3t0xxEf03mbNrTfThff
23WfHUc+HQRySc2S4PBK6WKnyzgy+as0xBedjwJ8NP579DjiZvzWpwydJ488
v/xvj8aRs3Sh9EXjJJBUtlNtK0TtHa7ziEPnr+S8ks3nL+NIzIzG04MBEvj8
OTT/aWAc2ZX2jHn4kwRy15hvfpwbR1pHJs6y95GgOn382Xu238i3itNNDZ0k
eD2YOPvmzG9k4cLH/ukPJAi9HBra6Pwb0fB2G6tpJoH2gTtbQ8BvZIRvjOhF
Qef/EKJQl/obWXs9rBJbR4JPTvPXK3/9RkJfYt0yi0gQu9rPXPH3N2LN/xWT
l0+CE5EtT8r2fiM0i68lHj4lQXv+43cvhSYQ/zFnOYl0EvRMGzM+d5pA4nt8
smRiSLCYLqH/n/8Esu+yeubDbXR/naS/5XB7Akk8tMxqGI5+/yUtW8RnE0jW
+/ctzIEkKPZDpmPHJhC6gu6wxxdJcHtH6ZOX4yRygy1zbViFBE+K8bSGvpPI
7U/Xm6Xk0e/BdkXncMQk0lJEuugiRYL5t2W1A9mTyP0d6xPph9D99Z9kgcnI
JBLavXURT08CWRbhKBn7KUTncsCyRRe6v98cNDH5TCHTJ3Gdbl8BXHyG9qbC
ppDalZJrLi0AGR0ZAdlPphCjz3ecxWsB6FK4XTiGppDRRwPxH9MABgWZ9VZs
/iBhN3ObYqwB4mU3qGovTCNUVjIXxJ8icCPYWGrKaxqJubn3T/keAp6UTAtC
6DSittujJHQdASMzvRdBWdOIt/nQ0evmCNBfSTyr+nsaaRymc3HY14HIUsmC
Ou8ZRLLPkVrYXAfCjzucbLg5i7Btlg/zD2iBn1RrSlP+HNKasa15JUUdJlwn
InJq55DYgnFtwg11OJ9D5R3xaQ5J2GI68dxeHTS41XVhZg7BjIY/jT2qDjT/
ihYo0vPIsEOopnmdGiR13TGkVM0jPGG06oq9qlB53Wz7zbsFpIvadvoMVgV2
nC+VDvksIdf/9X35TFIApzfnzRPdVpAUR5rungBxUKjlwfFeWUG4KDWZAhri
QFP2q/tp8AqC8/7sE/nvCDzLsbesil1BMqM5ntbGH4Hx/9zse1+sIOzkbPva
Z2LgdCLIW2BxBVm4Fy5Q/FMUnPpSYguDVxHdtyNZEt+F0P8TlifkI1aRJdGR
alYXIaD5zMvyOnYVGaZgqq22BeHZ6yf3v6avIuUVnXNiRwRh/El+6kLDKhJZ
/Dum5hY/OLnU5ClRrSFqj/gGS8x4wHm5p6kpdg0hs9tSXTXAgeONRMu6xDXE
7fOy6sklTrClNVkoS1tDEnIli9IzOOE893v+7MI1hMFM3zVziQOM1CuCwlrX
kMwM6+gsMjvI3LonrcGwjri4PRSX0WACSSbj9/Ic60ijlMm0wxNGOPoQY32M
Zx1p2dC9m0rNCML5ITE8EutIXnmBMc83esB/9hzfMFxHyo8bvUvxxcIWh0Fa
Vcw6MuFRpVY5SwVr6dSyxffXkb3m2jsD9lSwLPrmw7NH60hhBe4XUvgPmVVS
Wn3wfB0ZHTM9fPDfPjJkJWrq+2kdWSp5WBl4fhtpzjmgPU6/gTh+FSy56bmM
vD32OkOMfQOh0mLMcwpaQhoqA+UFiCg/uGhqwLyIVLfM2TMf3UBydi+u3jn/
F3k+/at+xmADES54G5QrPoHclXt1pSAafX/nYFbz/Rfki0LfVGACym9uRhjf
akEYlDft9FNRvqkSz5ffiESqq5pM5KOcrHviQfADJET3lYTohw0kgmOLUUv2
A6WO3Je93IaySAN55scXyobBJuFdD8oFnQHBSh0U/5OqWMeJDQT6Mv9OFf2g
eJ17NfaEdhOhMvDjGGAbpRSe77O6zLyJRODVvQbMxyhTVpvftfCbyGiBsVj/
vXHKRTvVtwOiqHw/quD11gTFyu1VBq/uJpLz/fnrzgczFMNrr86mRGwicv+F
K13+s0SJvNH3xSV2E0nEt4YWOCxTmkM3SUqJm4gv9QLZ6McyReeWqlx3Nuo/
rrSwqW6FohL/ioWTsoksecmBq+MaJeBu33+jHzcRR9WB8eb3a5TKhM2dsnaU
bX9oR4itU44/VJ0xHd5EOoaPHCYMr1PEMl99uLu/iTTl6uCT5TcpTll9WrbY
LcScQ7m+5+YmJSdns0qKFeX5ntrLXzcpAvmqz74IbCEcojIB+dZbFOvnlrwZ
Yqj8RFG2btYWJa0oONFTegspnzi3ozSyRcGXvgpn0NpChFkczxIubFPMy/vW
+/S2EF87rr+0SduUhMpN7+cn0feF+RN6rdsUpleqNgY2WwjszvrUSe9QjOot
u7id0fcVtR//Wu9QohuCjSe9thA5uwdsV6J3KDRNr1Qjb2whVDxNms4/digv
WHEF+7fReG6UeNfu7lDO2HhzBd/ZQhL93vAOCe1Sdgo/3l56uIXkKL0t7tXZ
peRuCC97ZqL+bt94+Mxml2JCDnH4nYfKGRuMIXCXsvbgxzfbEjR+iqFZ2Z1d
SuaIrFZvDWpfYEZ6MWuXQj4e/8LsLSo38bz6r3SXMndjgufzxy1kVDelYaRh
l5LcqhOj+x2190674P6HXYoWIX29oW8LWdJXG2Rr26VMOq86K4+i8kkHNrvv
u5SEilNdpdNbSAdX6vp1lFX+PQeJZVR+4f0ZV/T9sAlN2dPtLcRxtm9B6OMu
JTrDVpCfZhuRU2vLKGjcpchM195JZtpGqFyfyu6V7VJ6lTl3WPHbiGP+xYRD
ObuU8P8uecTwbyNL94RzOO7tUo52fuilEttGhE/tWnwP2qV0CAnr35BGuYOn
yMZul3LN+0bVqtI2EtFdlFEDuxTh1z0il7VR+6PTikPCu5RWetnEKf1tJFGB
L7prf4fiaxF34GCKcuKdFyl9OxSe3N/eP9E9UE6f3CxeukNpWtIeOOOA6qc/
3Iy6tUPx1EkzbnPfRpo6Vm5Und6h4O6uvNL33UZGjUSjy4R2KK9/mohTrqHv
eTKsb0yj8xFITVsZh+aT6HIvzH+bUtls4yeVhPrL/phaq7BNseaoHcnL2EY6
RBIolMUtSnGxV+OjYtT/nzRBsuMW5dx2iyRnNfr+O51OE36LsmdwKD2+cRsx
Fzl+jq1lk2Iy3h0Y9m0bySGs3Rfl36SsycpMbPzYRnxv1YzOvNugZIbFnvEd
Rnn5cliU6wZlnkdb1nkRrX9Cs5FW7jolwaxg2ohzB8kpyy1o3FqlqDyhsmzm
3UFG30xnaUSvUoZnrT9oiu4gTW59rA85Vimy0ezPZBR3kPKPlbu9/CuUjsZr
NlwWO0jH6StRH1mWKNeYuj/fs0Pt1St2u9EsUoStjqvRu6E829CFnZyn+K6O
ce0Eodzw9WPmo78UTsmT7SNpO4jjiDLv1copyhR9Nmdrzg4ifBRH//fmJOX1
5Mq58sIdhMoHO0FvNEFxeZoxEFGH6gu8iVNvHaPU8cxOi/TvIBE3DnWGcf6k
2NPH0boQd9H7R1KmqjWHojg5aGByCOXpDjbOpwkIw3u5eKWjKFPYb0uolCOV
4f0cWNVdJKL0V5pGQwuC3TgqVHAelb/8kXz+eh/ycuKj2nTKLjJ6putZRdsM
cquZL7TjCSpfaqGzzP+LnM/xodTl7yIgJ1+4dXse9UswiKvZRTpsL8wnFiwh
Z7tdz0r+QNmgneN0whqy8w7j4821h3T0+zMGdO0hRtm6uUtJewgIX1hXvE8P
Ma0dQ7cf7yFWQx6iXmoM8HHZnoc7bw+JnbzvuzDOAPrkkHvqNXtInkY514Am
E+jOVAXf7ttDAt79IxH3WUBL8YgJl8A+oiIldqbbjhPkPtGvq+bvI6UJDlGX
EohAXGwzuPnqAHl6bFp8vEkU0h5QLs5QDhDr4huC9ruiwKNUGXq29QAJvFF8
i0XlMPBcf1R59OcBom3x5NJB8WHgo3US6tg5QCSfM6QdzRADIeLmurDOPyRx
WMaZ66Y4iCMi+c0t/5DDlooTnu6SkPHpNTWtJxVkJdY+qzaSBy1B0j9hF2rY
3XHbjuFQByPbHn8nD2ooXWUfz5ZXh3OP3adyvamBIU2vtviMOlziTfgmHkgN
+Pfd40+S1SGDe+CxdDQ1NBqHZP0masAWa6CaWiE1VDdff1bGrwnVB4V+ZnPU
MH/wTFySoA1N2lqTiUvU0KfNRi+hrA1tod+tutaoYVJQWorjnDb83llHLPap
QW0CT8h6oA24TV02GzYaSBU45FHIrAO+i4Mv3ORoQCc5yUR1VwekRjkmwgJo
oEsSesWdAUz/CDcHXaOB3AcB13l8AXwX5HKuhNKA18Pqrr1QgOo9c9uLkTRA
kxSh9SQVQIv3QQ85mQZOye/Sa3wGMDnD+YG5mgZ4WZnr29D/594tnAXpqzTQ
uka9VDBJgoSvIpFJmzTwksvpzxv03irvkne6s0sD1YI6IS27JFgbPS0URksL
bIYqQjmcuhC6/yDVEU8L7wvaxhK0dOGuCi7mqCItCEzkOqje14WSQpxHjT8t
5I1/EBY7qgeRPygk2mBaqHorttAspwe2NJf5T4fQwn8hhbdPaugBk+2n9rn/
aOHao8znvKf0wI09VFkshRaGma+GPPfTA+GgSZqHr2hBZerHcFCtHmw+Sxoc
baAFjxR3/sK3etD+HamVaaIF3aDV7ncf9SDsWIbnl1ZaoFHy8ynt1YNfg6Yd
1L9oIcH+i4nXuh4k69U98d2jhcRfeel2MmS45Osa/JYKA2lOqdZsymTQfYI7
zYLFQFBEUVyBJhmWN7wxhawYOMflvnnXiAymL0QujQhh4GJr3X9yF8lwpK+d
fPwwBt6d8hXndyfDHm2oUMhRDAw+0G6d8yZDsV1vJ0EOA/3XXXvJ18jAwHlH
zZSEgWd1Z1s/3iPDiLYaLlMfA4c0rFmnk8hQ6zX5d8YYA2uu9SuLj8jg2oJk
R53BQJ0HQ0DVUzI0B69h3zhjINz+kApDNRnS856OMHlgQLjozEW7OjL4dprW
W3ljYGW+ZDitkQyHpIq81wIw8FqrvqS5hQyhw3bdUtEYULg93DjaTYY1Q+0n
rvEY6Lip42TZRwbvCgH37AQMMOUMM9f8IoNN5MAO7hEGzF1unT0yRoau+dct
Jo8xEHpxZVJ1ggwnLDMSorMxEGke4Sr/hwwakhdEd55jwJIqivhzjgyVD9Xm
FF+i9UhygphFMkjuE2svl2OgvUtST2CFDHwdvcZjdRjou0T1cWeDDEnqtXj+
Nygn+uiQt8nAlJsydO4dBjTZ4m4F7JJhO/CcX+tnDEx/07aJ+4fmO6KoSdOO
gQQGpbnL1PowbYTHanVhICIjQUudVh8cK1faA3tRfXW+E38x+tDP35VW9gsD
4qK/cZF0+mAeVeE0M4yBG4eUU2gZ9KF1IVH68G8MxN59/N2TUR/q3pk1pf7F
AA0bp8cssz7IScnGdyyi+bcFtGBY9aEwme0c0xoGMGdTf2DZ9EH4YF6QvIWB
vT2dx/MoP3L/9idsD7X3Ppi7kV0f2DpfVryiwkKYdhzZj0MfojXuhixjsFCS
tSvByqkPB7mX9KUYsZBWm/r+PspBrCfZXVmxcG3hIvc2ygtBkj+zOLFQY5B3
yBinD26jjLn93FgoPTvx+ybKw8Yz3jg+LGyoTzs/Qfl8VauKiRAWfhTVPH2K
crtAIVW0KBZMfj3IvouyQXTMF4o4Fs7/R+1oj/LbRbfkbUnUXl/rJAFl5QsG
9oqyWOgJ+6tYi/p/2XxE4rIiFmJjX57SQllMGrtSoIqFPJ8ElSI0n8yUiYZR
TSyY05xd2UPz5fr3PooPsJDqvhupivJdj1yzc2QseDC1rlih9cF03eZNMMLC
3EM1uIjWM1TT6fcnEywYjDD7m7Pow1oeqYT6NBZeziP3xNH6e7OJBGtaYGHh
J+ej32h/JoKpSIEXUH9f95Nj0P7Zjo0wldlhoevP27s4en3oPkHpmb6IhV59
s8hIrD6cqM7KEnXDgtjQn1tD6Hw0C4Z72HphwSqY6q4gjT5ULmntfffHgkTS
l9EzB+i8Wgt8ZAzGgpJkvrrRHhmevd+9rxeChYSO0w1iO+i8pr4+/Oo/LGhq
H7Z6uE4GPy21k1nJWIgPPz9s+JcMVD7JN++nYSFESOVm4TQZErKXqiIysUCn
f7dxdZIML2iKBJzzUH+9B1InRskw3sq7cLQaC6/PTb3fRL9P351AUd46LByV
5j9e2kGGA6mu80yNWBB8bhhk9o0M/PfjKXPvsYCehd/OfCTDOYvdxIpuLFi7
XMu2e4Xai7b88KwPC0nHHnN7V6H26qq2Hw5gwfTgw2vXMjLc5fd2CvqNhawo
kTd8z8nwYWxQUXMVC325dv13U8ig4vO2twVHB016uuWPfcjQks3HXEuggwxj
zVAnTzKc6QxCnvPRQVeklSq3Cxl8lGQL40TpQLqer0LnAhme72RfN1WgA3dn
ZtVcXTLwxNwS6D9NB4nY49oUTjIU1A2Zf7agg1c+QS9PMpNBaVY96vUFOqDj
mt5owZDB/NTKfOZFOtAqI9iHb+pBHN6ZctEP5fqbZLZBPdjJJjv9TaQDZa2s
KxVP9UBnUztJPoUOxPRFr/uk68EtU9Xm4HQ6yFRWOUF4oAcM+8dEMc/oIOnh
m2fiEXrAbc0+LlBFB+T65V4TOz2Q4/p10fQHHbhZnTT6gNcD19grFyt46YGU
X/1d2F8XCkc8HmwK0kM//T2Mp7suzKk4vdMWpYeLTfIXs211wX/ynMgXSXq4
VlnF1GegCxG6GmPjmvSgqWsWFMinCxl7mItc9vTw11LjX9xbEnT4ZjgGP6MH
3akc7PoOgGQix25AAT2oPJoT51kE+K8sOsX/BT28HRIzlv0NoLLg/+VyJT2w
vTxOq/EV4Mmlk0ouzfQgtS8d3JIB4OW2R396nB7Cr0T9+6gKgLG1L5MUZYBc
+g2Woh4dUDcUPRh6ygAmjrcCvvhqwmd99ULIZAR/L+nHNdFKcO1TuMzNHEaQ
krD4w+CpBBLGLdVv8hihWRHj53pSCaJNzN5plDCC43eNME0OJSCfdf2l9JYR
ZAWSlV0yFKHJ8QHLsVFGYOi9UzFfrgCvQmZ8OcWYQOIhsYhuRg7c9mU2zSSY
YCbeOJ3vmxwQbgaEJUgzQfT457ukCjkIuP0vjlmZCQ7J7BV/vi4HCnHcuVgD
JvAJPIf5yiwHpamkH9vuTLCHuXyjwF0G8ivS1ceLmYA+X/fFgpQUeO3aSPaX
MQFbDLe68b4kyOkL8bdXMQG7zfCjnnZJaOx/tlffwARm7loRN/0loftfMeXB
Vya40/GZSqHxGFCbvtUn/WUCRVO/YI8LEmA3O346R5IZnNnDerfeHAFRpXzd
VBlmqC9+E6SZegSmw9wV7yoww9tXs8MNPkcggHOO65oGMzB0j0UGCx+BO2rr
fWYnmEHIXPbGRLQY1EfT2//zRN+zhfZNOhwG7sPSXvZFzCAuc1Z8kSwCiUl3
zheVMENGLxzfExUBJpq/umsVzKAb4nHfnloEqMaK+ONfM0P5UPacGEUY5rKO
fqv5ygzklsa7zTrC0MJ3WI51gRmsVLFiR54IARJ/W8BqhRlg59ILXRcheL09
xpC7wQwYpOEcQVoIyvtzxtT+MaP/y30rxt8IQmaq0EMXDhbgeXnOS2RWAAJw
fBsNCiwwwdtTSXHlh8Vb18fpVFmAwefrYpwaP3gt97ef1mSB0BnRGTwLPzh2
PHr+R48F5DKvKXnW8IFJAvcFvAVq709N/VFOPvi0H6Bvf4EFchYOXT2Y4QXd
yz3yRXYscE3i/H7ae15QM3nIhLixAOY6vyf/dV44zMTZ6BWM+vP84Oc0zwNZ
130La0JYQMIa99CljQd4Zr4nU0WgcjUffpmXPMDWmnA5NZYFpONC6Hh9eCBO
deHC2F3U3uM6FU1zHsA8P2Ug/YAFfN/zeoor8sBOFMuh5nQW4GoUvXBhlwiB
65eYWbPQeIfEep6OEmHJ5eum5TMW6Gnb/1r9kQhTevEd8y9YYFrjVqpmChG6
qBlu8zai+jfOj//QJMJCSbq9eRMa30LTZP9RIjBaS2nGtKDxDXy5+5SLCFBp
urbWhvovn+6PXCKArf1oh1QnC6idbqHJGSFAMJN/idMPtD6J337e+k6AUqcU
t44hFhC2+PhfRgUBvrAd1aMfZ4HBkxxtnbkEmHxdd0hnigXO5Wi+7EglAJX7
ib2AWRbofytk/SieAAL4wf7iBbS+admM4jcJoEa5XDO+wgItIlVzoQEEOHfp
3wPeTRZw6bVVzPQigC/xgY/5Lgs4kkqZIy8S4M570ZMx/1ggMf7jU6ULBCi4
Un30LS0r3GXoOlR6mgDN/AaYdXpWaOtjLF06QYDhT32jUiysEBBU5b9HJsDO
Vc83ThyswOUqnNSJEIAgvJuezsUKDG0lMr6aBJBvuxvUwcMKIN7i0a9KAJNr
QmfpBVnBZKnXnkmZAB5i5bI6IqxQbutynE6RAJEdJJbAI6xAxbq+8FWeANmh
3dPFx1hh4jt/ow3KryVcP4wfR+NxDiyuQbm3Z+MprwIq1yns/KlAgJWI2HBz
FVZIs3EhtSoRgPU4n02MBivIMTkz30L9S/wsVn2rg/r/5KaDQeMjR2lzreuy
Ag9R889pNH5H+e9LUoas0OhazeGF5hcy5PjN6SQrGM2VvTdB80+NWylKN2OF
vQw8/Y45ASqVI6M7zrIChqF9xM+KAO1j3M70VqxwzbnXvNqRADP3niM6tqzA
4itt886TAMJTX7aKXViBHPJXWTOcAFpJtj/GPVhhbiT84HkcASx1Fip4L7OC
749q85EUAiSkcl6KCWQFj8ZG75JyArzQzTV8e50VlpYOhMgUAnxYUBJbD2OF
2OAWqfx2AuwZWA05RbOCN4MQx8dFAvCsztSnx7PC4O9LTVHURFDMDkntSGCF
Ou6KUHZ0Xr02s8x0HqH1Z6OuiUDnOzpXTjrwMZq/FfeOuzkRnpo1M7zMZoXI
WKUhHjci9D+ffMdbyApr3YI7vQ+JsHY2OMv8Jdrf18bzv4uJwE7FGBJTjvbj
K3m5voUIBlbSSut1rNAysBzbtEWEGoarBR2fUX++rERFLx6YCr01//YbWh/H
Guur0ej3vnxfqaSTFfIOaRpczOWB0J8vm+N+skJytpCD/ggPkF9MDevOoPMZ
z2R6zIEXgoTWj8jPo++rXiZ2RvBCYRLt5UPLrKCGKZ45kssLzCHCu7tbqH7Q
qZ1OdB91nbQm1jCwQeHvXaz8TT7ANHnY57KwQbLirUDFAj5QUQrOf8DBBlbI
H5bRb3yQIZCs6MPDBi3FNTkqh/jh4vw3s6MSbMBh9zWu8zM/LCWQYtMNUc7Y
Fw7REQRRWvPvMSdR/U26ub0rgnAu2J4QZMYGHnq+i4efCUKdQ0jeGUvU/3E1
BUcGIbgpV9PE7M4GHdhyu5hBIWDrktgOi2aDytqrDZmnhUGam8PL6QMbRJzd
d3p0VhTwZQ0v8z+zASHNtlX1uijsGLkvTn9jA67ICZx8tii0hr4NuNLLBrE8
tNTH50TBZcL7ZugfVF4VVQXxh+FJ1efkVEZ26O3ukortFQO2M/9Rvpxih3tT
ZPrll0dh/a8MDdsZdii9Jc2/NXgUBqN+kU+fZ4fKy0MfTrJKwIt6+S999uxA
enhYuM9HAgxERnsmrrADy8elW37KxyB8SWv24AE7rDa52Jl1SMJiwgaXYi87
7OfXOdipy8DcklDz8V/scHRPIc7YRwZmzxhekRhmB85iKv5LuTIwQUj7LDjF
Di81+1tM2GThV5Z6OMMGO4hPjimFT8mCk+Xb1QUmDnCTciUKdMjBKXdquxZJ
Dpi1eLqwmqEAh2NiZK94ccDSuYmwfXcVGLce+KX7hwNeE3di1g10gEXb8rnj
DAcwSqXkgacOKB/qvhr+lwMqr2KuR9/RgdjfX1heL3JA1MtgBuoOHZD1fq0j
v8UBXUE1B4VWCISGpT87xMgJpzgrlBElAO4cS689SU6gXu24zQQkMJrs3q7x
4QQp+ZFMDKIHYVIJIWW+nNDNmThieEoPKv2M9gv9OaG8wywqwkYP+A8aqTKD
OKFM71JMZ7AeLBAK6G+Hc8Ku1QXjxTI9SDa6xm2awAnS161lqYXIMFosID9V
wgmGs1e0KEtk4F7prRwp44TYgR296/vova72QOlnBScklHSdPMKkD1UtWLW2
Gk5IY7uzeeYweo8OLehUvuEEvNckLY2FPkizvzMJ/8YJBi3nb6bX6MM1f1cP
wjwnbHUKnGS8ZACxJxfcNRY5odrNy68xyAAeiQW72y9zwm/X43U2tw2gtjfW
rWCdE6q+R2nZpxvAqsZLF5UDTnBf3iP5fjQAH9pVx/PsOHiNE96uEDCEsMEQ
xxucOCgHDJH/qCHcrcE4ZuFx4N9z+L2PvCEUuxMcpog4wBWsePzQN4Tpr+p2
QcI4aPPkvfTksiE4J0dcSJXHQcufj1hsvSH4X2a88FoRB12K5CSWZkO4bZBk
NayMg8bjMmf2vxhCzlaupbgGDnJiIgQzBg1h2PaTRa0uDpTa8z69PTAEqyNs
Z3rP4mBOodc6T8cIPA5ST+9Y4EBkKd5excAIgvsOnRayQuMX/hBYfsoI3f/y
5m62OEj6fDTb1tYIuufPmW644MCNo/P4w2tGYFr7+AQhCAf1tFlx3i9Re6tO
/7iv4SCWuZUFX2kE/8lJVnPfwIFVie1i7isjqHtRJ8gdjgPLirriyGYjEM3+
sYSPRvNPfbgDfUagNZiZj4/FQU86t5/6oBFY8rpY4+Nx0HpufJ9/zAjuPlx5
j0vAwRG5q+rZs0awEcP+iDMVBwujs7ZP9oyA40PvSc40HJi8GSucpDIGKZos
Ks4MHIw9tmknYo3BMVTaiyMLB6tu4nfUWY3hi6+xNnsBDsScpQX8BYxhooRj
ha0QB7ZuK7cZhI3h32xfAdsL1D5mISn2sDEoubpxsJWi9kd5M/QljSHrwn+/
WWpxINFz/l2lijHUpZ5IY6nDQapJ6FyKujF0d3OeYnmNAxmPQ0+ctIyBwTSn
lvktDvqT3kfUkYxB9I77JeYmHFz7o1xCIhuDdquMMHMzDviuM5ypNjAGf903
cUwfcXBBZmTb4qQx3L0ZqcPUioPo97ObkaeM4XnjyVXGLzigiXR1eWJmDIMq
v2wZ23EQ2TgVEX/WGDauPuVk7MCBQNSd4w4WxsBZ4fGRoQsH7SKDJEFLYzCQ
2pRl6MWB2c35TAtrtD4ebyfo+9F5nfk99t3GGELyo9Lpf+Hg3M3leEU7Y0gd
NzGlH8TBgX/5owh7Yyg/xEVLP4yD8b/z9K8c0HraDryiG8WBJN2LgV5HY5hM
f+ZNN46DpS4ifvSiMVD1eYrQTeCg0/JJaZeTMfBxyfdip9D+J3SXljqj9T29
FY+dxoHRxWiuABdjMEugINhZHDwsqR4VdTUGr6/Ra5g5HHhpJ3I1oBzJYFqE
WcDB349hFVpuaD/0ue0xS+i8THPVP0e5/vYgDrOC5iMufHwP5R5K7ifaNRyc
mcxk13A3hoU9r1DaDRzMujY4XUT5gtXJY9ubOHAqFmfxR7mlSqp3YRsHdPqH
mS+jLMPO8t/ELg7cPc2czqCc7jUn+2sfBzuq17hEUcZ8bBv8/g8HhKp0sUHU
n49ISdwHajzE1w+nRKD8M/SeSgMtHj7+y7nEjjK5//LvciweXjB4FsWi+ZQp
miYW0ONhWnDhzByaP999Ge1MRjzQGRG8NVCOmmWbfcCMhx39jS1/tF5L+oup
Max4sI/s3E9B62nz9LteGDsegIvvZi5a7497ZUv+nHjIeOp76zHaj8dVvifs
ufHwWaZK4CTaPzr205tniXi4IP+ZQoP219dLPs+YFw9zwqStPLT/BiIr+0qC
eKgKKEKKrIyhIrTrheQhPHjTqFozo/Mj0F9pKSyCB5lXjiJW6HytJFytYD6C
h9uBlPaK08bovXnWnvooHvgQ2ua36Hy26isxb0rgofAhVWgtOr9P9tZcxqVR
//GIo5uxMRh5BfHUK+EBeRBa14oYQ9WH8x9KVfBwDbZKpbWNQUhE1T9PDQ9K
JrRFIRrGsNq3+fW+Fh4aaFM+/1L6f/+v33Qj44F+TLYqS8IYGJ9ekLY1wIPn
Pd8GmyPGELCn/vO0ER5wfVfZMaLGYFy1o6BtggdMoGIzgd8Y1oRDp/Dn8FCH
DfLVZzEGh1Dbh4zn0f4I+q7aMaDz3acF/yzx0PYkldsJYwzZCfvpszaovr+H
y3F0/5zYCz/1zhkPkt9e+3ai++lp361qn6t4CEw+vnWhxQimPsiNJATiwZZe
0PbdWyOQrh5hLAtG9SOCKznrjaA2UdthMQQPFzU/h10uMYI2421G30g8SNNK
3senGMFWg6+DXwoeAtZ2bSUdjUDnxaH4B4/Qfh9zaTx2Ad23ae3VFel4cKH/
po8/YwRsgdJMK0/wEFmnL52vZwSHZaar/Qvw0PLPu/jjEXR/5zgwBbxC+/3O
X5dryhCSE9iUk+vx4FZ2t7FpyBCd1zcO1Q14sBCZ+G71wxBcLvDXrFHwwFzv
eMSkxRCu4/ocAlvxoBvjbaL71BDyIk1rgn7i0X2qqfafpSHseGg7Xt9F5cdj
scRaAzjRIAmB+3h4ulDLL/LSAB6z8gj7/UP7nTvgI/DMALQqV0Y8aLlAaXNY
9s89Awjffe5gxcwFX9S+DX93MQDaBJyDKj8X6IRZe2A4DICl6o/dugYXjO62
i1bb6oPg/gMbvxtcMDI0MWP5Qw+mDO98YcBwg96qfHibLIDTSUfhI3TcoEZ7
RUZRBGDIVDmIxMAN2EQ25cc4gB6LEZEbLNwgo7r6ZWQWgWZnxet/ubghmi/R
xTEIgSc3B462H+GGPcZXX+wTdODcK6moh4bcQF/UMR3SogXvxdsQoTvcEJR5
n0PPWh1OJIycINzjhmtT5gpTJHXoWF+xYLvPDbOMzlcyj6nDcAuv90ESN9zO
ohLX21aDLSf3tOEMbrA/nDZ5M10NpLNplrNecIPL7WuiM0OqkEpUf3boCzf8
mzTPxlxTAYGbJiXENm7g+rrmfd1JBXKnHOrY27khnePUaYZTKlBeE93+r5Mb
nFxo5AJFVeDr2Z6dkZ/coHPFfCOxXRmoEq+czZnhBjmfBO99KWXwYijAiDAS
AAfVT2j3FeErTew9PWYCJOFKHz+eUQTpfU+CGysBMrYigi/0KsLi8nGJYk4C
RBzLKjYsV4SAgZqTynwEYCMPiK25KkJY6YckYykC9NszsL/pV4Dhwuf83scJ
cI/vfU3bJwWA3Li8BFkC3BBZSMO+UgCatFO13ehdPIHXHF5NUYDoWz9+2mkR
4PAwW+cnCwVIPDcp7H8KvXPxgxeCh+Rh2fRTUbIZekcfNrsj/10ezhgXKbxC
73hvm7UF4jt54Na5TN6zIIBvgvyuZ748ZBxdd4+2J0DckFz3UV952BXpWypE
79azT/6RjZzlwVag/vpXJwIwUx/TSD0vD4c4w+5wuKPx+j0ybdCWh7wdTFnG
FQKMKJW7ybDJA3Z9SvWNHwGq3hlrU2jkwW2xtWnkKgGM8n2/hm/KwbGJu11i
1wiQRW7Ijh+Tg9JvXBulEQT44exB//OVHLzKEdN+/4AANF3biM9lORD7Rw55
95AAqoHpn2Jd5SDRzrWegt7FEbNeHd/s5MCDr0C5MZ0Af20N3/eZygFf8lGZ
mqcEOLZfWDivIAfRK4beVbkEsP8j/cpeWg5WzD1eVOSjd/71qK2dI3LwlbVI
vLSIACtNV1xreOUgNEby0PMKAhy/ps6uRCsH05Mn7PKrUH+Voo3Ue7JgQb70
OLeGACrFnSsry7IgQ/2SmFNPgLzaoNrBYVnIcGizyGogQJu5ZMyPH7JA93bu
YeYbApxLt7wm/k0WRm4c50h/R4AmQyXNzkZZMPl5yvTRewL8Ohp5QqpGFupU
fe6mfCBAkEjC+lCJLCSulTIkfSZApk32g1M5srB35rtB4lcC1F4Vec2UIQue
FYuRCd9Q/f4z88LJsqDrI0d9pxPVv6L1yypOFkrbzJG4bgJM8+t+uBEpC/xS
fmExP9D8nzwQ3LgpC7FxDxqi+gjg82Fs+0uILKz9qdj+7yc63y9EfbeDZcHR
oEv19gAB+ILDUm4FyEJb3kpgxBABdDTOhTv7yaJ7A18dPkKA8tcknWwfWci/
qLgSOobmd4J3WslbFnBNZ+VCfhOgJWvqnpiXLIQLBfhcn0Tt582Dj4cszIYm
vwz+QwATuxecOHdZOD9QPRs4Q4C7dR3sHG6y0Kz+QyLgLzrPfiYnPFxlQTZt
3c1/ngCl8/CdD+XMDe5830UChAoyvjyKMoOFym+fZQI42avOJ6AcUHVe5PIq
ASQcUrLMUXtjnMEOl9bR7wsr9tUb9Wfq++iJ5ybaXwv+sN9oPK/bXw24bxNA
2Gb2TTUar/jxfl63XQJ6h6umjqL5JN3ZsnTZJ8D4xWFW9yuycDDDk+r0jwCN
86tSRv6ycMlIvceRmgixh5s3/guUhf6CCzgHWiIkCX25ynddFsjYG+Z2WCLY
Zr1/zhwmC+XOGQk29ESAvcxUy1uyIND8uu0CIxEqRUP0DqLQ/ggPMFkxE8E8
ur78X7wsrIfvGp1nJUKp8OyITaIstGtqfTjDSQRrtxvRYpmyEF8XuGuAR9+7
4T9feSYLhspl8prcRFhZS9PDFclCk4xo1mFeIgiLDfbavpKFsGKbHiI/EXTa
qGcwFFnQkEhhYhEkgpbwxBHMJ1moEmEIXhMmAtenciaGflnwzSKVTIsSQcFY
sYBlTBak+UN+D4oRIXTp2VmPWVko4Fow+yBBBBxf+HuxA1lIo++RSJUjgmhF
SEA/lxxYRLI6xCsQYXfENaqWTw5w1IYp4UpEiORnX6cIy8GdnXpqdzUiuLc8
6zl3XA7C57N/qQIRRDirG6OM5EDD6yeHtC4RLgliFt6YycHmFM5QmEyE5qTX
WiKWcuA7GlXFYEQE+9w+Jk83OXDuvnT3pxkRzLiPkvai5UDYPL/522ki8Db8
p3r3vhwMtg1vvTtLhAyRpRWDNDk4//G06wtLInyQp43WeiEHRvWqOiEORHgz
Fpgn3iEHMtm0SwJXiID1Uu6ZOSwPs/za4px+RJhq23M7JCsPz9OCbLFXidAX
svE5XEMehJNmWueDiGDATPXq9Wl5wEd9f/o2nAimHYHEI7flYcvr8VnHBCJ8
FzgtXDkrD/dv5NLfTET17TtZirblQTy+uOFJEhGMAzrzvzMogEVRw+GBVCL0
Cso6Fx9VgMo/A6sW2Wj+D9wy0t0VwNtFIPlkOREYwx4tKi4pAG2AmJFXJREM
6+QdCDSKkPGf9F5sNRFer9jbiXMpwudnWi4f64jwiofPp11NEcTHbJVI74jA
/bAjTyNSEUbtnvSodBHB8vE9LsfDShB8OT/WoocIHjMdnxjUlIAtrEQroJcI
NffCrg+aKIF25pu8il9ov47RHMEEK0HGr6EA6d9EcL41lG32TQnOWQpxi64R
gWeo7XfJLWVoNc+2YCXwwJ3OuYcSDKrg1TL5lp6HBwKfWUvxCasCq5q0BA0f
D5ieYH4ppaYKZw7V72wI8sBn8umyEg9VGJjvyh49wgOS5eLpEl9VYSGebrZK
mQd8twV3vqeoAfeHy+HWFjzQstX2NAY0wEld6/nzZB44+nRxeW5EG571h3mP
CfKi3396gbuRHkhH73Qvo0wI5G1YQrlWMViTRogXMiI+f79urAdfE3yZDqPc
r1y3feeEHqyRnQtdUO7lbDUrN9EDgwqjiT8of7bww2yb68FsHN524RAv5KlM
34u/oAcBqonvD1C+87jvOd5aDw4mWKTYhXnBhzL/LhNl9LLZkUXZWejeRqmN
HmhtbD3yQ/mKfOLFbjs9SHAa7l5Due+Ku46Akx7wcNhoYkV4wcY6xzof5Wdv
+p5xoyx5eTdIxlkP7WunnwrKSlOEcnDRg9H29+zXUN4VHDjs6qYHXqEQHIty
iJ4gaQHltWNvhtNQpjO4aR/srgcMUbUl9ShfanyaHuehB0kKitxfUL7+5OIr
nKceCIyWhf5CeUQZfjxGueCe9MQsymJa2qtiXnogr1l0chflAzcrzlKU/wdJ
kBEr
      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl3c81f8Xx4177Xkv99orIeTam8+5XDNfpG2HrCSVUZmVkCQJoYySVZRN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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.283185307179587}, {-5.213416597360091, 
   52.42478865302914}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zur Genauigkeit numerischer Rechnungen", "Section",
 CellChangeTimes->{{3360126296.10338, 3360126305.41521}, {3360126344.45992, 
  3360126344.97358}}],

Cell[CellGroupData[{

Cell["PrecisionGoal, AccuracyGoal, WorkingPrecision", "Subsection",
 CellChangeTimes->{{3360126107.35653, 3360126125.12995}}],

Cell[TextData[{
 "Normalerweise rechnet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " mit Maschinengenauigkeit und verwendet dazu die schnelle interne \
Hardware-Arithmetik."
}], "SmallText",
 CellChangeTimes->{{3360215531.32076, 3360215576.38625}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36021542966276*^9, 3.36021543539202*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "10"}], ",", " ", 
     RowBox[{
      SuperscriptBox["x", "y"], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Precision"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36021546848598*^9, 3.36021547029298*^9}, {
   3.36023157965807*^9, 3.36023159212324*^9}, 3.36023163018712*^9, 
   3.36023188884662*^9, {3.36023207473844*^9, 3.36023207810307*^9}, {
   3.389091070302349*^9, 3.389091071098694*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.2704333456136054`"}], ",", 
   RowBox[{"y", "\[Rule]", "2.8958589596789794`"}]}], "}"}]], "Output"],

Cell[BoxData["MachinePrecision"], "Output"],

Cell[BoxData["15.954589770191003`"], "Output"],

Cell[BoxData["15.49281236409019`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "30"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.3602154767564*^9, 3.3602154784429*^9}, {
  3.36021559837167*^9, 3.3602156010192*^9}, {3.36021567055274*^9, 
  3.36021569001069*^9}, {3.36023250832507*^9, 3.36023251105944*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.2704333456136054`"}], ",", 
   RowBox[{"y", "\[Rule]", "2.8958589596789794`"}]}], "}"}]], "Output"],

Cell[BoxData["MachinePrecision"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Precision"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.3602154767564*^9, 3.3602154784429*^9}, {
  3.36021559837167*^9, 3.36021563154924*^9}, {3.36023154792005*^9, 
  3.36023156522889*^9}, {3.389109459929128*^9, 3.389109460519064*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.27043334561360537920641511548539876795`20."}], 
   ",", 
   RowBox[{"y", "\[Rule]", "2.89585895967897951523337243718235647711`20."}]}],
   "}"}]], "Output"],

Cell[BoxData["20.`"], "Output"],

Cell[BoxData["19.53822259389919`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}], ",", "\n", "\t", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}], ",", " ", 
    RowBox[{"AccuracyGoal", "\[Rule]", "4"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Precision"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.3602154767564*^9, 3.36021551762969*^9}, {
  3.360233064429*^9, 3.36023307053218*^9}, {3.389109572685782*^9, 
  3.389109572970664*^9}, {3.389109779212212*^9, 3.389109805151708*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.27043334561439410739698949375713930666`20."}], 
   ",", 
   RowBox[{"y", "\[Rule]", "2.89585895967884298362745200876995754999`20."}]}],
   "}"}]], "Output"],

Cell[BoxData["20.`"], "Output"],

Cell[BoxData["19.538222593899206`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"First", "/@", "sys"}], ")"}], "/.", 
  "sol"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36007774174031*^9, 3.36007778025906*^9}, {
  3.36023308824814*^9, 3.36023309065436*^9}, {3.389109765364823*^9, 
  3.389109765958895*^9}, {3.389109813865382*^9, 3.389109815353789*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10.00000000000121330063929556246`19.69897000433602", ",", 
   "2.00000000000353033540779972334`19.311761312416188"}], "}"}]], "Output"],

Cell[BoxData["18.698970004335965`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Bei schlecht konditionierten numerischen Problemen muss oft eine andere als \
die Standardeinstellung zwischen den verschiedenen \
Pr\[ADoubleDot]zisionsparametern verwendet werden. \nIm folgenden Beispiel \
lautet das exakte Ergebnis Null, so dass ein N\[ADoubleDot]herungsverfahren \
mit Stellenausl\[ODoubleDot]schung zu \"k\[ADoubleDot]mpfen\" hat. Dies ist \
klarerweise ein Wechselspiel zwischen ",
 StyleBox["AccuracyGoal",
  FontWeight->"Bold"],
 " - wieviele Stellen nach dem Komma garantiert werden sollen - und ",
 StyleBox["WorkingPrecision",
  FontWeight->"Bold"],
 " - auf wieviele Stellen genau daf\[UDoubleDot]r zu rechnen ist. ",
 StyleBox["PrecisionGoal",
  FontWeight->"Bold"],
 " - wieviele g\[UDoubleDot]ltige Ziffern zu produzieren sind - kann dagegen \
keine Role spielen, da das (erwartete) Ergebnis ja gleich Null ist und \
folglich \[UDoubleDot]berhaupt keine g\[UDoubleDot]ltigen Ziffern hat.  "
}], "SmallText",
 CellChangeTimes->{{3.36021573576664*^9, 3.36021576006748*^9}, {
   3.36022961409651*^9, 3.36022985978754*^9}, 3.36023369099824*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["x", "3"]], "-", 
    FractionBox["3", "8"]}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", "Yellow"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36022942393666*^9, {3.389110094649357*^9, 3.389110118672034*^9}, {
   3.389110212109944*^9, 3.389110219598219*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJw1lHs0lGkcgIclDLnUuBTKlHZrs6R0MeQn2jFJlmoztGkptk5SGVHZapFG
JbfWbruYckYjKsSZRuV4c783U2cbh123JlFZvsGYGeayb+es95zvfOc53/s8
vz/e873UyFN7o3RJJFIwfj6/3U5f0CeRCBgIpw5qtRJY1cVxjA4iwOKQ1FLq
8hY6yRfTskoI6C969z7/8BAozd7RphQEjF2NF1M4/bB0JNOrliEFU5H5ZE9T
H4wVTKfuuiOFA81Rr4xHe8DHdtjenJCCzbebv/A48QZCfk5X/uE3BVuGXS/1
fnwNoY9Yq28UToFzNFtgzRXBUPFoEf/fKTCfCD14PbAbVl22jOTunAZzh8aN
mf7t8GFlV0JH3jQobAKN13Y0Q0F2Sy9zZBpIi23153IagPzuwqUyjxlwS7p/
Zf3tOlCrBYmbM2ag6UQiw2mgBh7MlVelSmagdntJko9xNdBbP3i4u8ugklll
UR3+AKLCHi1be00Gt7N1rtLlReAt+tq9b1AGpDT7b+KfZcMdE9dHzRtmgcRo
qjPkrkbP1ksj49NnwVxwMODC0RxUv1wWfX1gFo4l7LwnK72L9oiSUa+zHBjb
nAS3K0rQr8faQsfT5HDa3Te2bbgc/dj6O2Nbjxwqr7+KpHCqkM1sWdqnLxXA
YPXygnP56IbBOb3IiwqofG/l9zq/BqUOdvdYvFRAOofGL9/9HG39s3/8yhol
ZA9y45pM61CPo2vQ4SQlDDJEtvSgF0h1drEhq1MJhzJ+EwhZ9eifUq6O/6o5
+MvrYfnRuw1oR3HDd2GsOUjfPd3p+aAR5cauGX/VMAfODYoWfnET4tj6dJgs
mwf7lI8OXF4zcskaVf1yfB4iYr3d1TdaUNII/UzNi3nYTavxXXS+FQXoutDW
LVFBxEEzgXVAGyJPhgXrRKrAk8N0IizaUWqdd1lBjQp+iHDKmhxoR8n7K0LO
GKmBzW+U1eZ1IFp3D90oQg1B1AAb832daNBy5xVDgRpS3pDFGXpdyGiNu9UO
Aw14yfKiDbldaMJq7INnuAaqn99LzPbrRkzhyiVxFRqoHd2aWtrXjSpC8tNN
tRoQdfQqKFEvUX2DyDv2ey2012yi2sleIuZM5h4DnhbS2AOT+glCVGZoUHBE
rYWq/tAWikqIurLS5rRaLVSEtMm1WiFazzGx3LSWAKFfm+LsUgl4BNA7H2u0
4HVEyyZrhGgD2/fmMgoBcV4rPG6lSyCujFdNxt/F248/NlMLkd7EyFsm7p06
usJfH/eq5sPbTcgEpGWTn2oaJZDZK/5KgOezxae9cvF8B3urEH28X8Er/MTG
/bE6fuxDzDEDydwU7E/zY35apE+AHZV/fnxYAnbSiYib2E/aYJS6D/vlbs45
f+P5FrQ42i7sJ4i776dg/3EzS+6L/bCSQjcxZuUTRmA9Zsot1pZUXQIuZ1Dj
pYQEJKq5S+dwz+1in6Mb7sV708pbcO94bcTwOtzb/ra3+ST2eRrpXUfsU6tL
g+sxb9xoqizCfCs/x/oT5vaTrtwhzMU68sIdOgSUJNokJSok0KKbvDgW98kn
is864j6T/sKzFvcPdD5zW477DmOH9x/Bvk5MroyCfb2nLkNPMIPP3sBczAlF
1rwhzKYBrQoR5so842syzP527D0E5kMO9TFGn//X/9fCfbfAC+e7wP8BRem4
aw==
   "], {{
     {RGBColor[1, 1, 0], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{51, 81, 79, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 
        31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 73, 67, 62, 58, 55, 53, 74, 68, 63, 59, 56, 75, 69, 64, 
        60, 76, 70, 65, 77, 71, 78}},
        VertexColors->None]]}, 
     {RGBColor[1, 1, 0], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 80, 79, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 
        7, 6, 5, 4, 3, 2, 52, 54, 57, 61, 66, 72}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 72, 66, 61, 57, 54, 52, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
       13, 14, 15, 16, 17, 18, 19, 79, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
        30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
       47, 48, 49, 50, 73, 67, 62, 58, 55, 53, 74, 68, 63, 59, 56, 75, 69, 64,
        60, 76, 70, 65, 77, 71, 78, 51}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  Method->{"AxesInFront" -> True},
  PlotRange->{{1, 2}, {-0.24999999617346932`, 0.624999938775513}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "1", "2"], 
  RowBox[{"f", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
In der Standardeinstellung kommt das richtige Ergebnis heraus, aber die n\
\[ODoubleDot]tige Konvergenzg\[UDoubleDot]te wird nicht erreicht.\
\>", "SmallText",
 CellChangeTimes->{{3.36022987953486*^9, 3.36022992695015*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022997075961*^9, 3.3602299750911*^9}, 
   3.36023003579674*^9, {3.36023017004137*^9, 3.36023017873887*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({1.0800936666405323`}\\). NIntegrate obtained \
\\!\\(-1.3010426069826053`*^-17\\) and \\!\\(1.7550522667109103`*^-17\\) for \
the integral and error estimates.\"\>"}]], "Message", "MSG"],

Cell[BoxData["0``16.75570994540549"], "Output"],

Cell[BoxData["16.75570994540549`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Wird ",
 StyleBox["AccuracyGoal",
  FontWeight->"Bold"],
 " heruntergesetzt, so verschwinden die Warnungen. Arbeits- und \
Ergebnisgenauigkeit sind im Einklang; das Ergebnis hat geringere ",
 StyleBox["Accuracy",
  FontWeight->"Bold"],
 "."
}], "SmallText",
 CellChangeTimes->{{3.36022987953486*^9, 3.36022996593315*^9}, {
   3.3602300541147*^9, 3.36023010712551*^9}, {3.36023014482042*^9, 
   3.36023016744045*^9}, 3.36023022090847*^9, {3.36023025245614*^9, 
   3.36023027673314*^9}, {3.36023661972394*^9, 3.36023662130364*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "4"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022945471236*^9, 3.36022948200521*^9}, {
  3.36022998361199*^9, 3.36023004753962*^9}, {3.36023018569826*^9, 
  3.36023020841398*^9}}],

Cell[BoxData["0``6.123626837081033"], "Output"],

Cell[BoxData["6.123626837081033`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dasselbe mit ",
 StyleBox["PrecisionGoal",
  FontWeight->"Bold"],
 " hat dagegen keinen Einfluss auf das Verhalten, selbst wenn die ",
 StyleBox["WorkingPrecision",
  FontWeight->"Bold"],
 " hochgesetzt wird."
}], "SmallText",
 CellChangeTimes->{{3.36023012064302*^9, 3.36023013612186*^9}, {
  3.36023030132711*^9, 3.36023030976798*^9}, {3.36023035882293*^9, 
  3.36023037201194*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "4"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022945471236*^9, 3.36022950362948*^9}, {
  3.36023028895906*^9, 3.3602302951311*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({1.0800936666405323`}\\). NIntegrate obtained \
\\!\\(-1.3010426069826053`*^-17\\) and \\!\\(1.7550522667109103`*^-17\\) for \
the integral and error estimates.\"\>"}]], "Message", "MSG"],

Cell[BoxData["0``16.75570994540549"], "Output"],

Cell[BoxData["16.75570994540549`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "4"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "80"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022945471236*^9, 3.36022948200521*^9}, {
  3.36022952522082*^9, 3.36022954779431*^9}, {3.36023032115032*^9, 
  3.3602303521504*^9}, {3.36023038689934*^9, 3.3602303900543*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \\!\\({\\(\
\[LeftSkeleton] 136 \[RightSkeleton]\\)}\\). NIntegrate obtained \\!\\(\
\[LeftSkeleton] 141 \[RightSkeleton]\\) and \\!\\(\[LeftSkeleton] 141 \
\[RightSkeleton]\\) for the integral and error estimates.\"\>"}]], "Message", \
"MSG"],

Cell[BoxData["2.\
112447061418290903415270254105907086941091786966236834357606441968485204946483\
067838248338194818`80.*^-87"], "Output"],

Cell[BoxData["166.675214165797`"], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["AccuracyGoal",
  FontWeight->"Bold"],
 " schon."
}], "SmallText",
 CellChangeTimes->{{3.36023041942121*^9, 3.36023042306719*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "30"}], ",", "  ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.360230406979*^9, 3.36023041012312*^9}}],

Cell[BoxData["0``30.58398110435118"], "Output"],

Cell[BoxData["30.58398110435118`"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExtraPrecision", "Subsection",
 CellChangeTimes->{{3360126225.24907, 3360126237.47473}}],

Cell[TextData[{
 "Die von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " verwendeten Algorithmen zur numerischen Auswertung\nmathematischer \
Funktionen sind so ausgelegt, dass sie die Genauigkeit so weit\nals m\
\[ODoubleDot]glich erhalten. Dazu wird intern an vielen Stellen mit h\
\[ODoubleDot]herer Pr\[ADoubleDot]zision gerechnet. "
}], "SmallText",
 CellChangeTimes->{{3360068218.80344, 3360068289.5948}, {3360068326.60259, 
  3360068358.57007}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["10", "10"], "]"}], ",", "30"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.3600679230649*^9, 3.36006792696891*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  "0.487506025087510691527794294348106041676447316923`30."}]], "Output"],

Cell[BoxData["30.`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Diese intern vorgesehen Pr\[ADoubleDot]zisionserh\[ODoubleDot]hung ist \
durch den in der Systemvariablen ",
 StyleBox["$MaxExtraPrecision",
  FontWeight->"Bold"],
 " gespeicherten Wert begrenzt, was an manchen Stellen nicht ausreicht."
}], "SmallText",
 CellChangeTimes->{{3.36006836851485*^9, 3.36006844829324*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["10", "100"], "]"}], ",", "30"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.36006793383255*^9, 3.36006793712645*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Internal precision limit $MaxExtraPrecision = \
\\!\\(50.`\\) reached while evaluating \
\\!\\(Sin[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\).\"\>"}]], "Message", "MSG"],

Cell[BoxData["0``0"], "Output"],

Cell[BoxData["0.`"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Verwenden Sie ",
 StyleBox["Block",
  FontWeight->"Bold"],
 ", um Systemvariablen intermedi\[ADoubleDot]r zu ver\[ADoubleDot]ndern, ohne \
dass dies globale Auswirkungen hat."
}], "SmallText",
 CellChangeTimes->{{3.36006846427262*^9, 3.36006853282211*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", " ", "=", " ", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox["10", "100"], "]"}], ",", "30"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.3600680696694*^9, 3.36006817858659*^9}, {
  3.36006831392927*^9, 3.36006831611745*^9}, {3.36006849299514*^9, 
  3.36006850421036*^9}, {3.36006949641559*^9, 3.36006950029108*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  "0.372376123661276688262086695553164295719667883568`30."}]], "Output"],

Cell[BoxData["30.`"], "Output"]
}, Open  ]],

Cell["\<\
Der vorherige globale Wert der Systemvariablen wird nach Verlassen des \
Block-Konstrukts automatisch wieder hergestellt.\
\>", "SmallText",
 CellChangeTimes->{{3.36006916086659*^9, 3.36006921568755*^9}}],

Cell[CellGroupData[{

Cell[BoxData["$MaxExtraPrecision"], "Input",
 CellChangeTimes->{{3.36006815566573*^9, 3.36006815644675*^9}}],

Cell[BoxData["50.`"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{659, 600},
WindowMargins->{{Automatic, 87}, {Automatic, 59}},
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 37, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[652, 27, 73, 3, 79, "Section"],
Cell[CellGroupData[{
Cell[750, 34, 128, 1, 45, "Subsection"],
Cell[881, 37, 139, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[1045, 43, 110, 3, 57, "Input"],
Cell[1158, 48, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1241, 53, 136, 4, 57, "Input"],
Cell[1380, 59, 114, 2, 44, "Output"]
}, Open  ]],
Cell[1509, 64, 787, 18, 127, "SmallText"],
Cell[CellGroupData[{
Cell[2321, 86, 146, 3, 57, "Input"],
Cell[2470, 91, 46, 0, 44, "Output"]
}, Open  ]],
Cell[2531, 94, 294, 8, 59, "SmallText"],
Cell[CellGroupData[{
Cell[2850, 106, 364, 10, 65, "Input"],
Cell[3217, 118, 92, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3346, 125, 153, 6, 52, "Input"],
Cell[3502, 133, 50, 0, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3589, 138, 53, 1, 44, "Input"],
Cell[3645, 141, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3710, 146, 93, 4, 48, "Input"],
Cell[3806, 152, 28, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3883, 158, 39, 0, 45, "Subsection"],
Cell[3925, 160, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[4026, 165, 43, 0, 44, "Input"],
Cell[4072, 167, 46, 0, 44, "Output"]
}, Open  ]],
Cell[4133, 170, 650, 17, 110, "SmallText"],
Cell[CellGroupData[{
Cell[4808, 191, 39, 1, 48, "Input"],
Cell[4850, 194, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4933, 199, 122, 2, 44, "Input"],
Cell[5058, 203, 43, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5138, 208, 113, 2, 44, "Input"],
Cell[5254, 212, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5337, 217, 42, 1, 48, "Input"],
Cell[5382, 220, 97, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5516, 226, 58, 1, 44, "Input"],
Cell[5577, 229, 45, 0, 44, "Output"]
}, Open  ]],
Cell[5637, 232, 148, 5, 58, "Input"],
Cell[CellGroupData[{
Cell[5810, 241, 175, 6, 46, "Input"],
Cell[5988, 249, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6071, 254, 163, 5, 44, "Input"],
Cell[6237, 261, 126, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6400, 269, 32, 0, 44, "Input"],
Cell[6435, 271, 34, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6506, 276, 297, 10, 66, "Input"],
Cell[6806, 288, 88, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6931, 294, 349, 9, 44, "Input"],
Cell[7283, 305, 135, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7455, 314, 226, 7, 44, "Input"],
Cell[7684, 323, 107, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7828, 330, 315, 11, 68, "Input"],
Cell[8146, 343, 71, 0, 44, "Output"],
Cell[8220, 345, 96, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8353, 351, 80, 2, 44, "Input"],
Cell[8436, 355, 62, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8535, 360, 241, 4, 65, "Input"],
Cell[8779, 366, 46, 0, 44, "Output"],
Cell[8828, 368, 31, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8896, 373, 140, 5, 44, "Input"],
Cell[9039, 380, 48, 0, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9124, 385, 187, 6, 44, "Input"],
Cell[9314, 393, 105, 2, 44, "Output"]
}, Open  ]],
Cell[9434, 398, 286, 5, 76, "SmallText"],
Cell[CellGroupData[{
Cell[9745, 407, 96, 3, 46, "Input"],
Cell[9844, 412, 93, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9974, 418, 58, 1, 44, "Input"],
Cell[10035, 421, 46, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10130, 427, 83, 2, 45, "Subsection"],
Cell[10216, 431, 140, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[10381, 437, 250, 5, 80, "Input"],
Cell[10634, 444, 47, 0, 44, "Output"],
Cell[10684, 446, 49, 1, 58, "Output"]
}, Open  ]],
Cell[10748, 450, 159, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[10932, 457, 235, 4, 65, "Input"],
Cell[11170, 463, 35, 0, 44, "Output"],
Cell[11208, 465, 58, 1, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11303, 471, 308, 6, 65, "Input"],
Cell[11614, 479, 45, 0, 44, "Output"],
Cell[11662, 481, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11744, 486, 218, 5, 44, "Input"],
Cell[11965, 493, 427, 16, 44, "Output"]
}, Open  ]],
Cell[12407, 512, 178, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[12610, 520, 405, 8, 65, "Input"],
Cell[13018, 530, 49, 1, 58, "Output"],
Cell[13070, 533, 87, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13194, 539, 429, 9, 65, "Input"],
Cell[13626, 550, 63, 1, 58, "Output"],
Cell[13692, 553, 90, 1, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13819, 559, 371, 10, 65, "Input"],
Cell[14193, 571, 87, 1, 58, "Output"],
Cell[14283, 574, 79, 0, 46, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14423, 581, 58, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[14506, 585, 38, 0, 45, "Subsection"],
Cell[14547, 587, 140, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[14712, 593, 239, 8, 46, "Input"],
Cell[14954, 603, 391, 14, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15382, 622, 50, 1, 44, "Input"],
Cell[15435, 625, 400, 13, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15872, 643, 241, 8, 46, "Input"],
Cell[16116, 653, 398, 13, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16551, 671, 241, 8, 46, "Input"],
Cell[16795, 681, 398, 13, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17230, 699, 258, 8, 46, "Input"],
Cell[17491, 709, 563, 16, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18091, 730, 805, 27, 68, "Input"],
Cell[18899, 759, 94, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19030, 766, 304, 6, 65, "Input"],
Cell[19337, 774, 29, 0, 44, "Output"],
Cell[19369, 776, 29, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19435, 781, 174, 3, 44, "Input"],
Cell[19612, 786, 33, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19682, 791, 382, 9, 44, "Input"],
Cell[20067, 802, 13294, 393, 591, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33398, 1200, 199, 5, 44, "Input"],
Cell[33600, 1207, 3690, 104, 225, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37327, 1316, 202, 4, 44, "Input"],
Cell[37532, 1322, 710, 23, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38279, 1350, 282, 6, 44, "Input"],
Cell[38564, 1358, 865, 29, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39466, 1392, 507, 13, 44, "Input"],
Cell[39976, 1407, 537, 17, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40550, 1429, 120, 2, 44, "Input"],
Cell[40673, 1433, 847, 26, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41557, 1464, 196, 4, 44, "Input"],
Cell[41756, 1470, 225, 8, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42018, 1483, 121, 2, 44, "Input"],
Cell[42142, 1487, 2658, 66, 171, "Output"]
}, Open  ]],
Cell[44815, 1556, 295, 8, 59, "SmallText"],
Cell[CellGroupData[{
Cell[45135, 1568, 292, 10, 44, "Input"],
Cell[45430, 1580, 95, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45562, 1587, 262, 5, 65, "Input"],
Cell[45827, 1594, 29, 0, 44, "Output"],
Cell[45859, 1596, 29, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45925, 1601, 284, 5, 44, "Input"],
Cell[46212, 1608, 1111, 34, 105, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47360, 1647, 284, 5, 44, "Input"],
Cell[47647, 1654, 3239, 75, 215, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50923, 1734, 116, 2, 44, "Input"],
Cell[51042, 1738, 1473, 35, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52552, 1778, 313, 7, 44, "Input"],
Cell[52868, 1787, 2029, 63, 129, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54934, 1855, 221, 5, 44, "Input"],
Cell[55158, 1862, 672, 21, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55867, 1888, 366, 10, 44, "Input"],
Cell[56236, 1900, 685, 20, 65, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56970, 1926, 114, 1, 45, "Subsection"],
Cell[57087, 1929, 336, 12, 59, "SmallText"],
Cell[57426, 1943, 283, 8, 44, "Input"],
Cell[CellGroupData[{
Cell[57734, 1955, 175, 4, 44, "Input"],
Cell[57912, 1961, 226, 5, 45, "Message"],
Cell[58141, 1968, 271, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58449, 1982, 276, 6, 44, "Input"],
Cell[58728, 1990, 195, 5, 24, "Message"],
Cell[58926, 1997, 272, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59235, 2011, 178, 4, 44, "Input"],
Cell[59416, 2017, 226, 5, 45, "Message"],
Cell[59645, 2024, 272, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59954, 2038, 282, 6, 44, "Input"],
Cell[60239, 2046, 251, 6, 65, "Message"],
Cell[60493, 2054, 278, 9, 44, "Output"]
}, Open  ]],
Cell[60786, 2066, 233, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[61044, 2075, 392, 10, 44, "Input"],
Cell[61439, 2087, 2623, 46, 268, "Output"]
}, Open  ]],
Cell[64077, 2136, 181, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[64283, 2146, 325, 8, 44, "Input"],
Cell[64611, 2156, 97, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64745, 2163, 103, 2, 44, "Input"],
Cell[64851, 2167, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64933, 2172, 285, 8, 44, "Input"],
Cell[65221, 2182, 186, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65444, 2193, 577, 13, 44, "Input"],
Cell[66024, 2208, 5636, 98, 278, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71697, 2311, 604, 12, 44, "Input"],
Cell[72304, 2325, 200, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72541, 2336, 511, 11, 44, "Input"],
Cell[73055, 2349, 204, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73296, 2359, 537, 11, 44, "Input"],
Cell[73836, 2372, 117, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73990, 2380, 583, 11, 44, "Input"],
Cell[74576, 2393, 271, 6, 45, "Message"],
Cell[74850, 2401, 97, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74984, 2408, 140, 3, 44, "Input"],
Cell[75127, 2413, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75210, 2418, 733, 15, 44, "Input"],
Cell[75946, 2435, 200, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76183, 2446, 584, 18, 68, "Input"],
Cell[76770, 2466, 169, 4, 44, "Output"]
}, Open  ]],
Cell[76954, 2473, 174, 6, 56, "Input"],
Cell[CellGroupData[{
Cell[77153, 2483, 201, 6, 44, "Input"],
Cell[77357, 2491, 34131, 567, 251, 24731, 411, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111525, 3063, 229, 6, 44, "Input"],
Cell[111757, 3071, 5651, 98, 233, "Output"]
}, Open  ]],
Cell[117423, 3172, 131, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[117579, 3177, 381, 11, 44, "Input"],
Cell[117963, 3190, 217, 6, 44, "Output"]
}, Open  ]],
Cell[118195, 3199, 305, 7, 42, "SmallText"],
Cell[CellGroupData[{
Cell[118525, 3210, 280, 6, 44, "Input"],
Cell[118808, 3218, 96, 2, 44, "Output"]
}, Open  ]],
Cell[118919, 3223, 139, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[119083, 3228, 306, 9, 46, "Input"],
Cell[119392, 3239, 97, 2, 44, "Output"]
}, Open  ]],
Cell[119504, 3244, 226, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[119755, 3253, 298, 7, 44, "Input"],
Cell[120056, 3262, 412, 8, 105, "Message"],
Cell[120471, 3272, 97, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120605, 3279, 249, 6, 44, "Input"],
Cell[120857, 3287, 184, 5, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121078, 3297, 222, 7, 44, "Input"],
Cell[121303, 3306, 9190, 156, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130530, 3467, 346, 12, 44, "Input"],
Cell[130879, 3481, 258, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131174, 3494, 222, 7, 44, "Input"],
Cell[131399, 3503, 11117, 188, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142553, 3696, 272, 8, 44, "Input"],
Cell[142828, 3706, 5432, 95, 244, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148297, 3806, 296, 8, 44, "Input"],
Cell[148596, 3816, 412, 8, 105, "Message"],
Cell[149011, 3826, 115, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149163, 3834, 279, 8, 44, "Input"],
Cell[149445, 3844, 220, 5, 45, "Message"],
Cell[149668, 3851, 116, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149821, 3859, 317, 8, 44, "Input"],
Cell[150141, 3869, 187, 5, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150389, 3881, 41, 0, 55, "Section"],
Cell[150433, 3883, 189, 3, 44, "Input"],
Cell[150625, 3888, 250, 5, 59, "SmallText"],
Cell[CellGroupData[{
Cell[150900, 3897, 343, 10, 46, "Input"],
Cell[151246, 3909, 255, 8, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151538, 3922, 114, 2, 44, "Input"],
Cell[151655, 3926, 46, 0, 44, "Output"]
}, Open  ]],
Cell[151716, 3929, 529, 15, 76, "SmallText"],
Cell[CellGroupData[{
Cell[152270, 3948, 347, 10, 46, "Input"],
Cell[152620, 3960, 46, 0, 44, "Output"]
}, Open  ]],
Cell[152681, 3963, 163, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[152869, 3970, 388, 12, 88, "Input"],
Cell[153260, 3984, 5896, 103, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159193, 4092, 200, 6, 57, "Input"],
Cell[159396, 4100, 136, 5, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159569, 4110, 172, 5, 79, "Input"],
Cell[159744, 4117, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159809, 4122, 173, 5, 57, "Input"],
Cell[159985, 4129, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160067, 4134, 192, 6, 79, "Input"],
Cell[160262, 4142, 126, 5, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160425, 4152, 55, 1, 44, "Input"],
Cell[160483, 4155, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160566, 4160, 251, 7, 58, "Input"],
Cell[160820, 4169, 126, 5, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160983, 4179, 213, 6, 44, "Input"],
Cell[161199, 4187, 2999, 56, 243, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164235, 4248, 195, 6, 58, "Input"],
Cell[164433, 4256, 317, 7, 85, "Message"],
Cell[164753, 4265, 417, 8, 85, "Message"],
Cell[165173, 4275, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165256, 4280, 357, 9, 58, "Input"],
Cell[165616, 4291, 317, 7, 85, "Message"],
Cell[165936, 4300, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166019, 4305, 414, 10, 58, "Input"],
Cell[166436, 4317, 317, 7, 85, "Message"],
Cell[166756, 4326, 70, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166863, 4331, 238, 7, 58, "Input"],
Cell[167104, 4340, 46, 0, 44, "Output"]
}, Open  ]],
Cell[167165, 4343, 119, 1, 42, "SmallText"],
Cell[167287, 4346, 434, 14, 96, "Input"],
Cell[CellGroupData[{
Cell[167746, 4364, 388, 11, 44, "Input"],
Cell[168137, 4377, 315300, 5135, 325, 236458, 3841, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[483452, 9515, 296, 7, 42, "SmallText"],
Cell[483751, 9524, 593, 17, 28, "Input"],
Cell[CellGroupData[{
Cell[484369, 9545, 295, 10, 44, "Input"],
Cell[484667, 9557, 317, 7, 85, "Message"],
Cell[484987, 9566, 128, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[485152, 9574, 486, 13, 65, "Input"],
Cell[485641, 9589, 317, 7, 85, "Message"],
Cell[485961, 9598, 146, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[486144, 9606, 239, 5, 44, "Input"],
Cell[486386, 9613, 31, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[486466, 9619, 143, 2, 55, "Section"],
Cell[CellGroupData[{
Cell[486634, 9625, 122, 1, 45, "Subsection"],
Cell[486759, 9628, 913, 28, 122, "Input"],
Cell[CellGroupData[{
Cell[487697, 9660, 738, 20, 88, "Input"],
Cell[488438, 9682, 211, 4, 46, "Output"],
Cell[488652, 9688, 15296, 260, 251, 7791, 135, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[503963, 9951, 173, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[504161, 9961, 583, 15, 68, "Input"],
Cell[504747, 9978, 212, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[504996, 9987, 699, 19, 85, "Input"],
Cell[505698, 10008, 133, 2, 44, "Output"],
Cell[505834, 10012, 3862, 70, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[509733, 10087, 783, 23, 98, "Input"],
Cell[510519, 10112, 292, 7, 56, "Output"],
Cell[510814, 10121, 20688, 348, 251, 13761, 233, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[531551, 10475, 50, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[531626, 10479, 849, 23, 98, "Input"],
Cell[532478, 10504, 399, 9, 56, "Output"],
Cell[532880, 10515, 26853, 449, 251, 19108, 320, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[559748, 10967, 534, 13, 76, "SmallText"],
Cell[CellGroupData[{
Cell[560307, 10984, 714, 16, 76, "Input"],
Cell[561024, 11002, 3899, 96, 272, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[564960, 11103, 48, 0, 44, "Input"],
Cell[565011, 11105, 899, 15, 205, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[565959, 11126, 121, 1, 45, "Subsection"],
Cell[566083, 11129, 947, 26, 85, "Input"],
Cell[567033, 11157, 268, 5, 59, "SmallText"],
Cell[CellGroupData[{
Cell[567326, 11166, 435, 9, 44, "Input"],
Cell[567764, 11177, 141, 3, 44, "Output"]
}, Open  ]],
Cell[567920, 11183, 135, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[568080, 11190, 555, 14, 44, "Input"],
Cell[568638, 11206, 138, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[568813, 11214, 590, 15, 44, "Input"],
Cell[569406, 11231, 60395, 1001, 255, 41654, 692, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[629816, 12235, 1043, 31, 65, "Input"],
Cell[CellGroupData[{
Cell[630884, 12270, 517, 11, 44, "Input"],
Cell[631404, 12283, 288, 7, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[631729, 12295, 586, 17, 44, "Input"],
Cell[632318, 12314, 285, 7, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[632640, 12326, 519, 13, 44, "Input"],
Cell[633162, 12341, 54474, 904, 245, 41187, 685, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[687697, 13252, 156, 2, 55, "Section"],
Cell[CellGroupData[{
Cell[687878, 13258, 125, 1, 45, "Subsection"],
Cell[688006, 13261, 258, 7, 59, "SmallText"],
Cell[688267, 13270, 140, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[688432, 13276, 972, 25, 128, "Input"],
Cell[689407, 13303, 169, 4, 44, "Output"],
Cell[689579, 13309, 43, 0, 44, "Output"],
Cell[689625, 13311, 46, 0, 44, "Output"],
Cell[689674, 13313, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[689756, 13318, 557, 13, 65, "Input"],
Cell[690316, 13333, 169, 4, 44, "Output"],
Cell[690488, 13339, 43, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[690568, 13344, 625, 14, 85, "Input"],
Cell[691196, 13360, 226, 6, 44, "Output"],
Cell[691425, 13368, 31, 0, 44, "Output"],
Cell[691459, 13370, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[691541, 13375, 695, 15, 105, "Input"],
Cell[692239, 13392, 226, 6, 44, "Output"],
Cell[692468, 13400, 31, 0, 44, "Output"],
Cell[692502, 13402, 46, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[692585, 13407, 375, 8, 65, "Input"],
Cell[692963, 13417, 178, 4, 44, "Output"],
Cell[693144, 13423, 46, 0, 44, "Output"]
}, Open  ]],
Cell[693205, 13426, 1090, 20, 144, "SmallText"],
Cell[CellGroupData[{
Cell[694320, 13450, 524, 15, 81, "Input"],
Cell[694847, 13467, 3087, 58, 233, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[697971, 13530, 144, 4, 79, "Input"],
Cell[698118, 13536, 28, 0, 44, "Output"]
}, Open  ]],
Cell[698161, 13539, 233, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[698419, 13547, 345, 8, 65, "Input"],
Cell[698767, 13557, 317, 7, 85, "Message"],
Cell[699087, 13566, 425, 8, 88, "Message"],
Cell[699515, 13576, 47, 0, 46, "Output"],
Cell[699565, 13578, 45, 0, 44, "Output"]
}, Open  ]],
Cell[699625, 13581, 547, 13, 59, "SmallText"],
Cell[CellGroupData[{
Cell[700197, 13598, 419, 9, 65, "Input"],
Cell[700619, 13609, 47, 0, 46, "Output"],
Cell[700669, 13611, 45, 0, 44, "Output"]
}, Open  ]],
Cell[700729, 13614, 402, 11, 59, "SmallText"],
Cell[CellGroupData[{
Cell[701156, 13629, 375, 9, 65, "Input"],
Cell[701534, 13640, 317, 7, 85, "Message"],
Cell[701854, 13649, 425, 8, 88, "Message"],
Cell[702282, 13659, 47, 0, 46, "Output"],
Cell[702332, 13661, 45, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[702414, 13666, 521, 11, 65, "Input"],
Cell[702938, 13679, 317, 7, 85, "Message"],
Cell[703258, 13688, 473, 9, 85, "Message"],
Cell[703734, 13699, 138, 2, 66, "Output"],
Cell[703875, 13703, 44, 0, 44, "Output"]
}, Open  ]],
Cell[703934, 13706, 156, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[704115, 13715, 389, 9, 65, "Input"],
Cell[704507, 13726, 47, 0, 46, "Output"],
Cell[704557, 13728, 45, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[704651, 13734, 94, 1, 45, "Subsection"],
Cell[704748, 13737, 460, 10, 76, "SmallText"],
Cell[CellGroupData[{
Cell[705233, 13751, 264, 7, 68, "Input"],
Cell[705500, 13760, 101, 2, 44, "Output"],
Cell[705604, 13764, 31, 0, 44, "Output"]
}, Open  ]],
Cell[705650, 13767, 335, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[706010, 13778, 266, 7, 68, "Input"],
Cell[706279, 13787, 332, 8, 85, "Message"],
Cell[706614, 13797, 31, 0, 44, "Output"],
Cell[706648, 13799, 30, 0, 44, "Output"]
}, Open  ]],
Cell[706693, 13802, 274, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[706992, 13813, 543, 13, 68, "Input"],
Cell[707538, 13828, 101, 2, 44, "Output"],
Cell[707642, 13832, 31, 0, 44, "Output"]
}, Open  ]],
Cell[707688, 13835, 214, 4, 59, "SmallText"],
Cell[CellGroupData[{
Cell[707927, 13843, 108, 1, 44, "Input"],
Cell[708038, 13846, 31, 0, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
