(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95053,       3440]
NotebookOptionsPosition[     83452,       3039]
NotebookOutlinePosition[     83863,       3057]
CellTagsIndexPosition[     83820,       3054]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Summen und Integrale", "Title",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, {
  3.382549130804531*^9, 3.382549138378205*^9}, {3.382669100417725*^9, 
  3.382669104129491*^9}}],

Cell[CellGroupData[{

Cell["Folgen und Partialsummen", "Section",
 CellChangeTimes->{{3.382549487164993*^9, 3.382549503138874*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     SuperscriptBox["i", "k"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.389302486781149*^9, 3.389302488512284*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox["n", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "30"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", "n"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox["n", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "n"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "42"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"3", " ", "n"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["n", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "4"]}]}], ")"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], 
    SuperscriptBox["x", "k"], 
    SuperscriptBox["y", 
     RowBox[{"n", "-", "k"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "n"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"x", "+", "y"}], "y"], ")"}], "n"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "PowerExpand"}]], "Input"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"x", "+", "y"}], ")"}], "n"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 SuperscriptBox["2", "n"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", "n", "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hypergeometrische Summen", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["4", "n"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", "n"}], "]"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"n", "!"}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", "1"}], "]"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "!"}], "-", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"n", "!"}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", "1"}], "]"}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "-", 
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{"2", "n"}], ",", "n"}], "]"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{"2", " ", "n"}], ",", "n"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["4", "n"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "2"], "+", "n"}], "]"}]}], 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], "2"]}]], "Input"],

Cell["\<\
Die Formel l\[ADoubleDot]sst sich \[UDoubleDot]ber lineare Rekursionen und \
doppeltes Summieren beweisen. 
f[n,k] etwa erf\[UDoubleDot]llt die folgende zweistellige lineare \
Rekursionsbeziehung.\
\>", "SmallText",
 CellChangeTimes->{{3.382508238709032*^9, 3.382508343972766*^9}, {
  3.38250840910117*^9, 3.382508445347786*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn1", "=", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"f", "[", 
     RowBox[{"n", ",", "k"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", "k"}], "]"}], "+", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", 
        RowBox[{"k", "-", "1"}]}], "]"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "2"}], ",", "k"}], "]"}], "-", 
      RowBox[{"2", 
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"n", "-", "2"}], ",", 
         RowBox[{"k", "-", "1"}]}], "]"}]}], "+", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "2"}], ",", 
        RowBox[{"k", "-", "2"}]}], "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{3.36422777706755*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "k"}]}], "]"}], "2"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"Binomial", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}]}], "]"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ",", "k"}], "]"}], "2"]}], ")"}]}], 
  "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "n"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "k"}]}], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ",", "k"}], "]"}], "2"]}], ")"}]}], 
  "+", 
  RowBox[{"n", " ", 
   SuperscriptBox[
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], "2"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das kann mit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " bis k=14 mit ",
 StyleBox["FullSImplify",
  FontWeight->"Bold"],
 " \[UDoubleDot]berpr\[UDoubleDot]ft werden."
}], "SmallText",
 CellChangeTimes->{{3.382508459947687*^9, 3.382508483202638*^9}, {
  3.382510121085491*^9, 3.382510144822508*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"eqn1", ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "2", ",", "14"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.3642277800087*^9, {3.382508048028452*^9, 3.382508057461228*^9}, {
   3.382508142700404*^9, 3.382508143509122*^9}, {3.382508487118475*^9, 
   3.382508526770288*^9}, {3.382509770393974*^9, 3.382509792581563*^9}, {
   3.382510114503443*^9, 3.38251011485649*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Bei gr\[ODoubleDot]\[SZ]eren Werten f\[UDoubleDot]r k muss noch ",
 StyleBox["FunctionExpand",
  FontWeight->"Bold"],
 " vorangestellt werden."
}], "SmallText",
 CellChangeTimes->{{3.382508535845833*^9, 3.382508569455341*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"eqn1", "/.", 
    RowBox[{"k", "\[Rule]", "15"}]}], ")"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "FunctionExpand"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.382508108997956*^9, 3.382508131325231*^9}, {
  3.382510154913345*^9, 3.382510186159529*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ",", "13"}], "]"}], "2"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"Binomial", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ",", "14"}], "]"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ",", "15"}], "]"}], "2"]}], ")"}]}], 
  "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "n"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ",", "14"}], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ",", "15"}], "]"}], "2"]}], ")"}]}], 
  "+", 
  RowBox[{"n", " ", 
   SuperscriptBox[
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "15"}], "]"}], "2"]}]}]], "Output"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Interessanterweise hat ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " mit demselben Ausdruck f\[UDoubleDot]r allgemeine k keine Probleme."
}], "SmallText",
 CellChangeTimes->{{3.382511257711999*^9, 3.382511275692878*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn1", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.3642277818817*^9, {3.382508644285171*^9, 3.382508654809138*^9}, {
   3.382508686619791*^9, 3.382508701817503*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Summiert man diese Relation \[UDoubleDot]ber alle k, so ergibt sich wegen \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"n"},
      {"k"}
     }], ")"}], TraditionalForm]]],
 "=0 f\[UDoubleDot]r k<0 und k>n f\[UDoubleDot]r \n     s[n] = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "k"], 
    RowBox[{"f", "[", 
     RowBox[{"n", ",", "k"}], "]"}]}], TraditionalForm]]],
 " \ndie Beziehung"
}], "SmallText",
 CellChangeTimes->{{3.382511361527639*^9, 3.382511562040403*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn2", "=", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"s", "[", "n", "]"}]}], "\[Equal]", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}], ")"}], 
    RowBox[{"s", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{3.36422778799814*^9, 3.389303693466614*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", " ", 
   RowBox[{"s", "[", "n", "]"}]}], "\[Equal]", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "n"}]}], ")"}], " ", 
   RowBox[{"s", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["RSolve",
  FontWeight->"Bold"],
 " liefert dann die eingangs von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gefundene Antwort."
}], "SmallText",
 CellChangeTimes->{{3.382511696917897*^9, 3.382511740881455*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eqn2", ",", 
      RowBox[{
       RowBox[{"s", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"s", "[", "n", "]"}], ",", "n"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36422779477748*^9, 3.36422780006068*^9}, 
   3.389303693474971*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", " ", "n"}]], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], "]"}]}], 
     RowBox[{
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "n"}], "]"}]}]]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Das bisher untersuchte Beispiel ist ein Spezialfall der folgenden \
allgemeineren Summationsaufgabe.\
\>", "SmallText",
 CellChangeTimes->{{3.382511750474981*^9, 3.382511780159805*^9}, {
  3.382512030491013*^9, 3.382512051468033*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{"n", ",", "k"}], "]"}], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "k"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], 
      RowBox[{"n", "-", "k"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "x"}], ")"}], "n"], " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"-", "n"}], ",", 
    RowBox[{"-", "n"}], ",", "1", ",", 
    FractionBox[
     RowBox[{"1", "+", "x"}], 
     RowBox[{"1", "-", "x"}]]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Ergebnis kann auch in Termini der (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ebenfalls bekannten) Legendre-Polynome ",
 StyleBox["LegendreP",
  FontWeight->"Bold"],
 " angegeben werden, wie ein Vergleich der Ergebnisse f\[UDoubleDot]r einige \
Werte von n zeigt."
}], "SmallText",
 CellChangeTimes->{{3.382512330887535*^9, 3.382512377299097*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"res", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}], "//", 
  "Together"}], "\n", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "n"], 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "x"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}], "//", 
  "Together"}]}], "Input",
 CellChangeTimes->{3.382512398937433*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"35", "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"63", "-", 
      RowBox[{"70", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"15", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"35", "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"63", "-", 
      RowBox[{"70", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"15", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " hat aber selbst mit ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " Schwierigkeiten, dies in symbolischer Form zu erkennen."
}], "SmallText",
 CellChangeTimes->{{3.382512811957578*^9, 3.382512877244542*^9}, {
   3.382512923852315*^9, 3.382512928487038*^9}, 3.382512965624206*^9, {
   3.382611879803169*^9, 3.382611880803445*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "x"}], ")"}], "n"], 
    RowBox[{"LegendreP", "[", 
     RowBox[{"n", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512500899923*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], "n"], " ", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}], ",", "1", ",", 
     FractionBox[
      RowBox[{"1", "+", "x"}], 
      RowBox[{"1", "-", "x"}]]}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["2", "n"], " ", 
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"LegendreP", "[", 
    RowBox[{"n", ",", 
     FractionBox["1", "x"]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "F\[UDoubleDot]r konkrete Werte von n dagegen wird bereits beim Einsetzen \
sowohl ",
 StyleBox["Hypergeometric2F1",
  FontWeight->"Bold"],
 " als auch ",
 StyleBox["LegendreP",
  FontWeight->"Bold"],
 " durch die entsprechende rationale Funktion ersetzt, so dass ein einfaches \
",
 StyleBox["Together",
  FontWeight->"Bold"],
 " zum Nachweis der Identit\[ADoubleDot]t ausreicht."
}], "SmallText",
 CellChangeTimes->{{3.382611527046444*^9, 3.382611541142561*^9}, {
  3.382611761957574*^9, 3.382611803773107*^9}, {3.382611839361049*^9, 
  3.382611865290029*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"res", "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "x"}], ")"}], "n"], 
       RowBox[{"LegendreP", "[", 
        RowBox[{"n", ",", 
         RowBox[{"1", "/", "x"}]}], "]"}]}]}], ")"}], "/.", 
    RowBox[{"n", "->", "#"}]}], "&"}], "/@", 
  RowBox[{"Range", "[", "10", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Together"}]}], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512600926745*^9}, {
  3.382512697574273*^9, 3.382512779226465*^9}, {3.382611670808178*^9, 
  3.382611706692546*^9}, {3.382611819614658*^9, 3.382611827671535*^9}, {
  3.382672449181648*^9, 3.38267245779078*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"35", "-", 
       RowBox[{"30", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{"35", "-", 
        RowBox[{"30", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"63", "-", 
       RowBox[{"70", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"15", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "5"], " ", 
      RowBox[{"(", 
       RowBox[{"63", "-", 
        RowBox[{"70", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"15", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "5"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"231", "-", 
       RowBox[{"315", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"105", " ", 
        SuperscriptBox["x", "4"]}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "6"]}]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "231"}], "+", 
        RowBox[{"315", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"105", " ", 
         SuperscriptBox["x", "4"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "6"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "6"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "8"}], " ", 
     RowBox[{"(", 
      RowBox[{"429", "-", 
       RowBox[{"693", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"315", " ", 
        SuperscriptBox["x", "4"]}], "-", 
       RowBox[{"35", " ", 
        SuperscriptBox["x", "6"]}]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "7"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "429"}], "+", 
        RowBox[{"693", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"315", " ", 
         SuperscriptBox["x", "4"]}], "+", 
        RowBox[{"35", " ", 
         SuperscriptBox["x", "6"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "7"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"6435", "-", 
       RowBox[{"12012", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"6930", " ", 
        SuperscriptBox["x", "4"]}], "-", 
       RowBox[{"1260", " ", 
        SuperscriptBox["x", "6"]}], "+", 
       RowBox[{"35", " ", 
        SuperscriptBox["x", "8"]}]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "8"], " ", 
      RowBox[{"(", 
       RowBox[{"6435", "-", 
        RowBox[{"12012", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"6930", " ", 
         SuperscriptBox["x", "4"]}], "-", 
        RowBox[{"1260", " ", 
         SuperscriptBox["x", "6"]}], "+", 
        RowBox[{"35", " ", 
         SuperscriptBox["x", "8"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "8"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"12155", "-", 
       RowBox[{"25740", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"18018", " ", 
        SuperscriptBox["x", "4"]}], "-", 
       RowBox[{"4620", " ", 
        SuperscriptBox["x", "6"]}], "+", 
       RowBox[{"315", " ", 
        SuperscriptBox["x", "8"]}]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "9"], " ", 
      RowBox[{"(", 
       RowBox[{"12155", "-", 
        RowBox[{"25740", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"18018", " ", 
         SuperscriptBox["x", "4"]}], "-", 
        RowBox[{"4620", " ", 
         SuperscriptBox["x", "6"]}], "+", 
        RowBox[{"315", " ", 
         SuperscriptBox["x", "8"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "9"]]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"46189", "-", 
       RowBox[{"109395", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"90090", " ", 
        SuperscriptBox["x", "4"]}], "-", 
       RowBox[{"30030", " ", 
        SuperscriptBox["x", "6"]}], "+", 
       RowBox[{"3465", " ", 
        SuperscriptBox["x", "8"]}], "-", 
       RowBox[{"63", " ", 
        SuperscriptBox["x", "10"]}]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "10"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "46189"}], "+", 
        RowBox[{"109395", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"90090", " ", 
         SuperscriptBox["x", "4"]}], "+", 
        RowBox[{"30030", " ", 
         SuperscriptBox["x", "6"]}], "-", 
        RowBox[{"3465", " ", 
         SuperscriptBox["x", "8"]}], "+", 
        RowBox[{"63", " ", 
         SuperscriptBox["x", "10"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "10"]]}]}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Dieselbe Simplifikationsfrage an ",
 StyleBox["FullSImplify",
  FontWeight->"Bold"],
 " mit einer logischen Restriktion als zweitem Parameter kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dagegen nicht vereinfachen, selbst wenn die Restriktion mit ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " in eine explizite endliche Alternative umgewandelt wird."
}], "SmallText",
 CellChangeTimes->{{3.382611894179518*^9, 3.382611998319406*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"res", "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "n"], 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "x"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"0", "<", "n", "<", "5"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512600926745*^9}, {
  3.382512697574273*^9, 3.382512698647642*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], "n"], " ", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}], ",", "1", ",", 
     FractionBox[
      RowBox[{"1", "+", "x"}], 
      RowBox[{"1", "-", "x"}]]}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["2", "n"], " ", 
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"LegendreP", "[", 
    RowBox[{"n", ",", 
     FractionBox["1", "x"]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"cc", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"0", "<", "n", "<", "5"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"res", "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "n"], 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "x"}]}], "]"}]}]}], ",", "cc"}], "]"}]}], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512600926745*^9}, {
  3.382512697574273*^9, 3.382512698647642*^9}, {3.382519354581516*^9, 
  3.382519412203306*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "\[Equal]", "1"}], "||", 
  RowBox[{"n", "\[Equal]", "2"}], "||", 
  RowBox[{"n", "\[Equal]", "3"}], "||", 
  RowBox[{"n", "\[Equal]", "4"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], "n"], " ", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}], ",", "1", ",", 
     FractionBox[
      RowBox[{"1", "+", "x"}], 
      RowBox[{"1", "-", "x"}]]}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["2", "n"], " ", 
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"LegendreP", "[", 
    RowBox[{"n", ",", 
     FractionBox["1", "x"]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Der Zusammenhang zur urspr\[UDoubleDot]nglichen Aufgabe.\
\>", "SmallText",
 CellChangeTimes->{{3.382612022188271*^9, 3.382612038583405*^9}, 
   3.382612374221625*^9, {3.382612600362625*^9, 3.382612602527993*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   RowBox[{"-", "n"}], ",", 
   RowBox[{"-", "n"}], ",", "1", ",", "1"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"htest", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{"2", "n"}], ",", "n"}], "]"}], "-", "res"}], "/.", 
     RowBox[{"x", "\[Rule]", "0"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Binomial", "[", 
   RowBox[{
    RowBox[{"2", " ", "n"}], ",", "n"}], "]"}], "-", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"-", "n"}], ",", 
    RowBox[{"-", "n"}], ",", "1", ",", "1"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"htest", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.389304835184927*^9, 3.389304855184733*^9}, 
   3.389304951008829*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ltest", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"2", "x"}], ")"}], "n"], 
        RowBox[{"LegendreP", "[", 
         RowBox[{"n", ",", 
          RowBox[{"1", "/", "x"}]}], "]"}]}], ",", 
       RowBox[{"x", "->", "0"}]}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{"res", "/.", 
       RowBox[{"x", "->", "0"}]}], ")"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.382612061438191*^9, 3.382612077893745*^9}, {
   3.382612112835775*^9, 3.382612162642808*^9}, {3.382612204701346*^9, 
   3.382612242694307*^9}, {3.382612292796706*^9, 3.38261229332567*^9}, {
   3.382612548233471*^9, 3.382612565970458*^9}, {3.389303693511234*^9, 
   3.389303693518682*^9}, 3.389304932103186*^9, {3.389305019019613*^9, 
   3.389305043724212*^9}, {3.38930507829969*^9, 3.389305104245807*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}], ",", "1", ",", "1"}], "]"}]}], "+", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SuperscriptBox["x", "n"], " ", 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       FractionBox["1", "x"]}], "]"}]}], ",", 
    RowBox[{"x", "\[Rule]", "0"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "F\[UDoubleDot]r konkrete Werte von n stehen auf beiden Seiten konkrete \
Zahlen, die ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nat\[UDoubleDot]rlich automatisch berechnet. "
}], "SmallText",
 CellChangeTimes->{{3.38261227194019*^9, 3.382612330559926*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"htest", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382612147056359*^9, 3.382612147805151*^9}, {
   3.38261223661036*^9, 3.382612237221981*^9}, 3.382612614207278*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"ltest", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.382612618079804*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Einige weitere Beispiele", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "k_", "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"k", " ", 
     RowBox[{"k", "!"}]}], 
    SuperscriptBox["n", "k"]], 
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"t", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["n"], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "k_", "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"t", "[", "k", "]"}]}], "k"]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "-", 
    RowBox[{"s", "[", "k", "]"}]}], "\[Equal]", 
   RowBox[{"t", "[", "k", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.389303693557333*^9}],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "k_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "k"], " ", 
   FractionBox[
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"4", "n"}], ",", 
      RowBox[{"2", "k"}]}], "]"}], 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "n"}], ",", "k"}], "]"}]]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"t", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", 
     RowBox[{"2", "n"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], 
   RowBox[{"2", " ", "n"}]], 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], " ", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"4", " ", "n"}], ",", 
      RowBox[{"2", " ", "k"}]}], "]"}]}], 
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{"2", " ", "n"}], ",", "k"}], "]"}]]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "k_", "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "k"}], "-", "1"}], ")"}], 
    RowBox[{"t", "[", "k", "]"}]}], 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", "n"}]}], ")"}]}]]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "-", 
    RowBox[{"s", "[", "k", "]"}]}], "\[Equal]", 
   RowBox[{"t", "[", "k", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.389303693572673*^9}],

Cell[BoxData["True"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unendliche Summen und Integrale", "Section",
 CellChangeTimes->{{3.382551899857107*^9, 3.382551902529866*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["n", "k"]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "n"}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["n", "k"]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Zeta", "[", "k", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "2", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[Pi]", "2"], "6"], ",", 
   RowBox[{"Zeta", "[", "3", "]"}], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "4"], "90"], ",", 
   RowBox[{"Zeta", "[", "5", "]"}], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "6"], "945"], ",", 
   RowBox[{"Zeta", "[", "7", "]"}], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "8"], "9450"], ",", 
   RowBox[{"Zeta", "[", "9", "]"}], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "10"], "93555"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6449340668482262`", ",", "1.2020569031595942`", ",", 
   "1.082323233711138`", ",", "1.0369277551433698`", ",", 
   "1.017343061984449`", ",", "1.0083492773819227`", ",", 
   "1.004077356197944`", ",", "1.0020083928260821`", ",", 
   "1.0009945751278178`"}], "}"}]], "Output"]
}, Open  ]],

Cell["Summation rationaler Ausdr\[UDoubleDot]cke", "SmallText",
 CellChangeTimes->{{3.382614335479635*^9, 3.382614346802322*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["n", "4"], "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382520664015535*^9, 3.382520664768492*^9}, {
  3.382520768128417*^9, 3.382520815198054*^9}, {3.382614238009372*^9, 
  3.382614238417599*^9}, {3.382685770591068*^9, 3.382685771001491*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["#1", "3"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Etwas Theorie", "Subsection",
 CellChangeTimes->{{3.382617623926793*^9, 3.382617628934409*^9}}],

Cell["Integration rationaler Funktionen.", "SmallText",
 CellChangeTimes->{{3.382618067847538*^9, 3.382618082469689*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"2", "x"}], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", "x", "+", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.382617641722755*^9, 3.382617751676256*^9}, {
  3.382617788635086*^9, 3.382617798693689*^9}, {3.382617899285596*^9, 
  3.382618009083145*^9}, {3.389306389241886*^9, 3.389306390231137*^9}, {
  3.389307040085554*^9, 3.389307047159539*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", "g1"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617853634622*^9}, {
  3.389307057984709*^9, 3.389307059556829*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"2", "+", "x"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "g2", "]"}]], "Input",
 CellChangeTimes->{{3.382618046132709*^9, 3.38261804964705*^9}, {
  3.389307071931403*^9, 3.389307074391685*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", "g2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617863399235*^9}, {
  3.382617913501571*^9, 3.382617913917586*^9}, {3.382628017708489*^9, 
  3.382628017862434*^9}, {3.382629940175316*^9, 3.382629940952445*^9}, {
  3.382630596362136*^9, 3.382630602169834*^9}, {3.382630718420045*^9, 
  3.382630747301005*^9}, {3.389307088349121*^9, 3.389307089325098*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "5"}], "-", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}], ")"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["5"], "-", 
     RowBox[{"2", " ", "x"}]}], "]"}]}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "5"}], "+", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}], ")"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox["5"], "+", 
     RowBox[{"2", " ", "x"}]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"g2", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.38262031389502*^9, 3.382620331595114*^9}, 
   3.389303693586491*^9, {3.38930710057476*^9, 3.389307102097179*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cc", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"3", 
       SuperscriptBox["x", "2"]}], "-", "2"}]], "/.", "sol"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.382620345181866*^9, 3.382620449273525*^9}, {
  3.382621612055052*^9, 3.382621619942384*^9}, {3.38262168262576*^9, 
  3.382621683241902*^9}, {3.382622372719325*^9, 3.382622377934803*^9}, {
  3.382622619219222*^9, 3.382622619678295*^9}, {3.382626246582672*^9, 
  3.382626254944598*^9}, {3.382627809042962*^9, 3.382627809202416*^9}, {
  3.382628233971275*^9, 3.382628264393035*^9}, {3.382630725435021*^9, 
  3.382630755678464*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["2", 
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}]], ",", 
   FractionBox["2", 
    RowBox[{"5", "-", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", 
       SqrtBox["5"]}]}], ")"}]}], " ", "-", 
   FractionBox["2", 
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}]]}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.382628312566352*^9, 3.382628333861993*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"3", 
         SuperscriptBox["x", "2"]}], "-", "2"}]]}], "}"}], "/.", "sol"}], "//",
    "Together"}]}]], "Input",
 CellChangeTimes->{{3.382620345181866*^9, 3.382620449273525*^9}, {
  3.382621612055052*^9, 3.382621619942384*^9}, {3.38262168262576*^9, 
  3.382621683241902*^9}, {3.382622372719325*^9, 3.382622377934803*^9}, {
  3.382622619219222*^9, 3.382622619678295*^9}, {3.382627817858345*^9, 
  3.382627818006138*^9}, {3.382630501137598*^9, 3.382630501424961*^9}, {
  3.382630555954098*^9, 3.382630556089591*^9}, {3.38931107007308*^9, 
  3.389311099547223*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}], ",", 
     FractionBox["2", 
      RowBox[{"5", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterpolatingPolynomial", "[", 
   RowBox[{"pts", ",", "a"}], "]"}], "//", 
  "Together"}], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{"%", "//", "ExpandDenominator"}]}]}], "Input",
 CellChangeTimes->{{3.38931117992498*^9, 3.389311204020933*^9}, {
  3.389314425248712*^9, 3.389314456036569*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"16", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "16"}], "+", 
      RowBox[{"9", " ", "a"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"]}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox["5"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SqrtBox["5"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", 
       SqrtBox["5"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"3", " ", 
       SqrtBox["5"]}]}], ")"}]}]]}]], "Output"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "16"}], "+", 
    RowBox[{"9", " ", "a"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"v", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", 
         SuperscriptBox["a", "2"]}], "-", "2"}], ")"}]}], "//", "Expand"}], 
    ")"}], "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], "->", 
      RowBox[{
       RowBox[{"2", "a"}], "-", "1"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "->", 
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["a", "2"]}], "-", "a"}]}]}], "}"}]}], "//", 
  "Expand"}]], "Input",
 CellChangeTimes->{{3.382621821757265*^9, 3.382621968903678*^9}, {
  3.38262211980398*^9, 3.382622178352168*^9}, {3.382627844574247*^9, 
  3.382627845166358*^9}}],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", "g3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617879619539*^9}, {
   3.382617927727184*^9, 3.382617928076934*^9}, {3.382618018470782*^9, 
   3.382618018840875*^9}, 3.382629670587845*^9, {3.389314528322145*^9, 
   3.389314529570279*^9}}],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", "#1", "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "#1"}], "]"}], 
     RowBox[{"1", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uneigentliche Integrale rationaler Funktionen", "Subsection",
 CellChangeTimes->{{3.382625241854328*^9, 3.382625266160474*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   FractionBox["1", "g1"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382625273473902*^9, 3.382625450061928*^9}, {
  3.382626486394353*^9, 3.382626502365661*^9}, {3.389314543200687*^9, 
  3.389314544722209*^9}}],

Cell[BoxData[
 RowBox[{"Log", "[", "2", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "2", "\[Infinity]"], 
   RowBox[{
    FractionBox["1", "g2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 CellChangeTimes->{{3.382625273473902*^9, 3.382625527474163*^9}, {
  3.382627243121328*^9, 3.38262724349537*^9}, {3.382627311591345*^9, 
  3.382627311860852*^9}, {3.382627455529826*^9, 3.382627460068427*^9}, {
  3.382630514325018*^9, 3.382630514875067*^9}, {3.382630564578892*^9, 
  3.382630564736223*^9}, {3.389314558422405*^9, 3.389314559750584*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "10"}], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "-", 
       SqrtBox["5"]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "+", 
       SqrtBox["5"]}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], 
       RowBox[{"Log", "[", 
        RowBox[{"x", "-", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "&"}], "/@", "pts"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617863399235*^9}, {
  3.382617913501571*^9, 3.382617913917586*^9}, {3.382627408448615*^9, 
  3.382627470026127*^9}, {3.382627604379738*^9, 3.382627732873547*^9}, {
  3.382627895472398*^9, 3.382627896095135*^9}, {3.382629995175527*^9, 
  3.382629995491649*^9}, {3.382630524575578*^9, 3.382630524972188*^9}, {
  3.382631881102105*^9, 3.382631909699358*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SqrtBox["5"]}], ")"}]}], "+", "x"}], "]"}]}], 
   RowBox[{
    RowBox[{"-", "5"}], "+", 
    RowBox[{"3", " ", 
     SqrtBox["5"]}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["5"]}], ")"}]}], "+", "x"}], "]"}]}], 
   RowBox[{"5", "+", 
    RowBox[{"3", " ", 
     SqrtBox["5"]}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r1", "+", 
   RowBox[{"(", 
    RowBox[{"r2", "/.", 
     RowBox[{"x", "\[Rule]", "2"}]}], ")"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.382627472823546*^9, 3.382627492596782*^9}, {
  3.382630085870224*^9, 3.382630111578101*^9}, {3.38263053895217*^9, 
  3.382630543234725*^9}, {3.382630576271477*^9, 3.382630577532034*^9}, {
  3.38263188681813*^9, 3.382631897519283*^9}, {3.382631930767228*^9, 
  3.38263193646925*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "cc"}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.382626302307017*^9, 3.382626305659774*^9}, {
  3.382630677820415*^9, 3.382630682088735*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "2", "\[Infinity]"], 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "1"}], "g2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382625551781773*^9, 3.382625555845148*^9}, {
  3.389314600545112*^9, 3.389314602545391*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"ArcCoth", "[", 
      SqrtBox["5"], "]"}]}], 
    SqrtBox["5"]]}], "+", 
  RowBox[{"Log", "[", "5", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g3", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382625721047543*^9, 3.382625775044933*^9}, {
   3.382632350180407*^9, 3.382632352081615*^9}, 3.389303693599935*^9, {
   3.389314622929713*^9, 3.389314624040934*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "0.6823278038280193`"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   FractionBox["1", "g3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382625273473902*^9, 3.382625482519494*^9}, {
  3.382625564511687*^9, 3.382625575698019*^9}, {3.382625785537286*^9, 
  3.382625808116691*^9}, {3.382632356413273*^9, 3.382632357581918*^9}, {
  3.389315831891648*^9, 3.389315836646775*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", "#1", "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"-", "#1"}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Unendliche Summen rationaler Ausdr\[UDoubleDot]cke\
\>", "Subsection",
 CellChangeTimes->{{3.382633846074672*^9, 3.382633860632035*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "g1"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.3893158763248*^9, 
   3.389315878134408*^9}}],

Cell[BoxData[
 FractionBox["n", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "n"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", "+", "1"}]], "-", 
   FractionBox["1", 
    RowBox[{"x", "+", "2"}]]}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.38931607498849*^9, 3.389316133910207*^9}}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], "-", 
   FractionBox["1", 
    RowBox[{"n", "+", "2"}]]}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.389316219998109*^9, 3.389316259356892*^9}}],

Cell[BoxData[
 FractionBox["n", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "n"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "g1"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.389316293060197*^9, 3.38931630101191*^9}, {
   3.389316348413158*^9, 3.38931634916853*^9}}],

Cell[BoxData[
 FractionBox["n", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "n"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "g1"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677716159894*^9}, {3.389316372154908*^9, 3.389316389771011*^9}}],

Cell[BoxData[
 FractionBox["1", "2"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.382678375739943*^9, 3.382678384802303*^9}, {
   3.382678425429395*^9, 3.382678427493474*^9}, {3.382678489907073*^9, 
   3.38267849041059*^9}, {3.389316410692564*^9, 3.389316421962447*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "+", 
      RowBox[{"10", " ", "#1"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"10", "+", 
       RowBox[{"12", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678445087843*^9, 3.382678448661394*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "+", 
      RowBox[{"10", " ", "#1"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"10", "+", 
       RowBox[{"12", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.382678375739943*^9, 3.382678384802303*^9}, {
   3.382678469933435*^9, 3.382678470556505*^9}, {3.389318109839228*^9, 
   3.38931813025315*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         SqrtBox["5"]}], ")"}]}], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         FractionBox["5", "2"], "-", 
         FractionBox[
          SqrtBox["5"], "2"]}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SqrtBox["5"]}], ")"}], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           SqrtBox["5"]}], ")"}]}]}], "]"}]}], "+", 
     RowBox[{"10", " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", "n"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         FractionBox["3", "2"], "-", 
         FractionBox[
          SqrtBox["5"], "2"], "+", "n"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         FractionBox["3", "2"], "+", 
         FractionBox[
          SqrtBox["5"], "2"], "+", "n"}]}], "]"}]}]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", "EulerGamma"}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["5"], " ", "\[Pi]", " ", 
       RowBox[{"Tan", "[", 
        FractionBox[
         RowBox[{
          SqrtBox["5"], " ", "\[Pi]"}], "2"], "]"}]}]}], ")"}]}], 
   RowBox[{"5", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox["5"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SqrtBox["5"]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"s2", ",", 
     RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.382678495427599*^9, 3.382678519736378*^9}, {
  3.3826785703306*^9, 3.382678579099327*^9}, {3.382679925680652*^9, 
  3.382679926456489*^9}, {3.382680274063422*^9, 3.382680276754158*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"10", " ", "EulerGamma"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"PolyGamma", "[", 
      RowBox[{"0", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "-", 
          SqrtBox["5"]}], ")"}]}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"PolyGamma", "[", 
      RowBox[{"0", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}]}]}], "]"}]}], "-", 
    RowBox[{"4", " ", 
     SqrtBox["5"], " ", "\[Pi]", " ", 
     RowBox[{"Tan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["5"], " ", "\[Pi]"}], "2"], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", "-", "s3"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678523920534*^9, 3.382678585061952*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s4", "=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g2"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2", ",", "9"}], "}"}]}], "]"}], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g2"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "10", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.382678375739943*^9, 3.382678384802303*^9}, {
   3.382678425429395*^9, 3.382678427493474*^9}, {3.382678489907073*^9, 
   3.38267849041059*^9}, {3.382678617395005*^9, 3.382678632884729*^9}, {
   3.382684370214802*^9, 3.38268437375771*^9}, {3.382684415282626*^9, 
   3.382684418794817*^9}, {3.389318341116185*^9, 3.389318389551152*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["124404198307", "439677789320"], "-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"981", "+", 
      RowBox[{"298", " ", "#1"}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"298", "+", 
       RowBox[{"60", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s1", "-", "s4"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678640392668*^9, 3.382678651616359*^9}, {
  3.382684425483586*^9, 3.382684426998467*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s3", "-", "s4"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678640392668*^9, 3.382678693164489*^9}, {
  3.382684347699823*^9, 3.3826844380787*^9}}],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", "//", "Normal"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.382684493906589*^9, 3.38268452210363*^9}, {
  3.382684653610793*^9, 3.382684671829711*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"10", " ", "EulerGamma"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"PolyGamma", "[", 
      RowBox[{"0", ",", 
       RowBox[{
        FractionBox["5", "2"], "-", 
        FractionBox[
         SqrtBox["5"], "2"]}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}], ")"}], " ", 
     RowBox[{"PolyGamma", "[", 
      RowBox[{"0", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}]}]}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s4", "//", "Normal"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.382684493906589*^9, 3.38268452210363*^9}, {
  3.382684653610793*^9, 3.382684653995378*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["19117450392", "7851389095"]}], "+", "EulerGamma", "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}], ")"}], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"21", "-", 
        SqrtBox["5"]}], ")"}]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"21", "+", 
        SqrtBox["5"]}], ")"}]}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"PolyGamma", "[", 
     RowBox[{"0", ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"21", "+", 
         SqrtBox["5"]}], ")"}]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox["5"]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g3"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382634734153226*^9, 3.382634755478537*^9}, {3.382634824217346*^9, 
   3.382634860004832*^9}, {3.382634902876293*^9, 3.382634903778039*^9}, {
   3.382684840604221*^9, 3.382684843282925*^9}, {3.389318664852327*^9, 
   3.389318683232594*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", "#1", "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g3"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382634734153226*^9, 3.382634755478537*^9}, {3.382634824217346*^9, 
   3.382634860004832*^9}, {3.382634902876293*^9, 3.382634903778039*^9}, {
   3.382684840604221*^9, 3.382684843282925*^9}, {3.389318664852327*^9, 
   3.389318717689133*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"PolyGamma", "[", 
        RowBox[{"0", ",", 
         RowBox[{"-", "#1"}]}], "]"}], 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}], "+", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "n"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"]}], "+", 
      SuperscriptBox["n", "3"], "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"6", " ", "n", " ", "#1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"], " ", "#1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"3", " ", "n", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"4", "+", 
       RowBox[{"6", " ", "n"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["n", "2"]}], "+", 
       RowBox[{"6", " ", "#1"}], "+", 
       RowBox[{"6", " ", "n", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g3"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g3"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "3", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382634734153226*^9, 3.382634755478537*^9}, {3.382634824217346*^9, 
   3.382634860004832*^9}, {3.382634902876293*^9, 3.382634903778039*^9}, {
   3.382684840604221*^9, 3.382684843282925*^9}, {3.389318664852327*^9, 
   3.389318683232594*^9}, {3.389318733388105*^9, 3.389318776820122*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["47", "33"], "-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"31", "+", 
      RowBox[{"28", " ", "#1"}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"28", "+", 
       RowBox[{"18", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die folgenden beiden Rechnungen schafft ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nicht."
}], "SmallText",
 CellChangeTimes->{{3.382685003897397*^9, 3.382685029954142*^9}}],

Cell[BoxData[
 RowBox[{"s4", "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"s2", ",", 
     RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.389319143901559*^9, 3.389319145254632*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s1", "-", "s4"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382634915438517*^9, 3.382634927918398*^9}, {
  3.382684789271179*^9, 3.382684790634335*^9}, {3.382684950884307*^9, 
  3.382684961321644*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s1", "-", "s3"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.389319512140721*^9, {3.389319644651015*^9, 3.389319645642273*^9}, 
   3.389319699857573*^9}],

Cell["Noch einmal unser Ausgangsbeispiel", "SmallText",
 CellChangeTimes->{{3.382685883835895*^9, 3.382685894710446*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["n", "4"], "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382520664015535*^9, 3.382520664768492*^9}, {
  3.382520768128417*^9, 3.382520815198054*^9}, {3.382614238009372*^9, 
  3.382614238417599*^9}, {3.382685770591068*^9, 3.382685771001491*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["#1", "3"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}]], "&"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res1", "=", 
  RowBox[{
   RowBox[{"res", "//", "Normal"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.38261427354401*^9, 3.382614316207895*^9}, {
  3.382685829274136*^9, 3.382685857190036*^9}, {3.382686571849822*^9, 
  3.382686573272099*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"1", "/", "4"}]], " ", "\[Pi]"}], "]"}], "+", 
       RowBox[{"Coth", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "\[Pi]"}], 
         SqrtBox["2"]], "]"}]}], ")"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res2", "=", 
  RowBox[{
   RowBox[{"res1", "//", "TrigExpand"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.382686577673514*^9, 3.382686647453793*^9}, {
  3.382686697306573*^9, 3.382686700102715*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         SqrtBox["2"], " ", "\[Pi]"}], "]"}], "-", 
       RowBox[{"Cosh", "[", 
        RowBox[{
         SqrtBox["2"], " ", "\[Pi]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     SqrtBox["2"], " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         SqrtBox["2"], " ", "\[Pi]"}], "]"}], "+", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         SqrtBox["2"], " ", "\[Pi]"}], "]"}]}], ")"}]}]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{
        SqrtBox["2"], " ", "\[Pi]"}], "]"}], "-", 
      RowBox[{"Cosh", "[", 
       RowBox[{
        SqrtBox["2"], " ", "\[Pi]"}], "]"}]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res1", "//", "N"}]], "Input",
 CellChangeTimes->{{3.382685907378193*^9, 3.382685907935993*^9}, {
   3.382686671413886*^9, 3.382686672237514*^9}, 3.382686707312093*^9}],

Cell[BoxData[
 RowBox[{"0.5784775796671369`", "\[InvisibleSpace]", "-", 
  RowBox[{"6.179952383167375`*^-17", " ", "\[ImaginaryI]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res2", "//", "N"}]], "Input",
 CellChangeTimes->{{3.382685907378193*^9, 3.382685907935993*^9}, {
  3.382686671413886*^9, 3.382686704035346*^9}}],

Cell[BoxData["0.5784775796671368`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["n", "4"], "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382686217016973*^9, 3.382686225671239*^9}}],

Cell[BoxData["0.5784775802847567`"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Die PolyGamma-Funktion", "Subsection",
 CellChangeTimes->{{3.382687407194282*^9, 3.382687423905347*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyGamma", "[", 
    RowBox[{"x", "+", "1"}], "]"}], "-", 
   RowBox[{"PolyGamma", "[", "x", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382687427024098*^9, 3.382687462459036*^9}, {
  3.382688718781804*^9, 3.382688734435562*^9}}],

Cell[BoxData[
 FractionBox["1", "x"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "k"], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "-", 
   RowBox[{"PolyGamma", "[", "n", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382687525113263*^9, 3.382687615038952*^9}}],

Cell[BoxData["EulerGamma"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellChangeTimes->{{3.382687623191907*^9, 3.382687623844848*^9}}],

Cell[BoxData["0.5772156649015329`"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{632, 680},
WindowMargins->{{Automatic, 107}, {Automatic, 65}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 199, 3, 90, "Title"],
Cell[CellGroupData[{
Cell[814, 30, 109, 1, 55, "Section"],
Cell[CellGroupData[{
Cell[948, 35, 352, 10, 30, "Input"],
Cell[1303, 47, 1708, 58, 112, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3048, 110, 303, 10, 30, "Input"],
Cell[3354, 122, 171, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3562, 133, 60, 1, 28, "Input"],
Cell[3625, 136, 98, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3760, 144, 199, 6, 28, "Input"],
Cell[3962, 152, 51, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4050, 158, 294, 10, 30, "Input"],
Cell[4347, 170, 68, 1, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4464, 177, 43, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[4532, 181, 257, 8, 30, "Input"],
Cell[4792, 191, 276, 10, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5105, 206, 157, 5, 28, "Input"],
Cell[5265, 213, 124, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5426, 222, 161, 5, 28, "Input"],
Cell[5590, 229, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5655, 234, 164, 5, 28, "Input"],
Cell[5822, 241, 413, 15, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6272, 261, 61, 1, 28, "Input"],
Cell[6336, 264, 28, 0, 28, "Output"]
}, Open  ]],
Cell[6379, 267, 189, 6, 30, "Input"],
Cell[6571, 275, 339, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[6935, 286, 1038, 36, 49, "Input"],
Cell[7976, 324, 1432, 52, 94, "Output"]
}, Open  ]],
Cell[9423, 379, 328, 10, 42, "SmallText"],
Cell[CellGroupData[{
Cell[9776, 393, 469, 11, 28, "Input"],
Cell[10248, 406, 190, 4, 28, "Output"]
}, Open  ]],
Cell[10453, 413, 244, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[10722, 423, 363, 9, 49, "Input"],
Cell[11088, 434, 1274, 46, 71, "Output"],
Cell[12365, 482, 28, 0, 28, "Output"]
}, Open  ]],
Cell[12408, 485, 247, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[12680, 495, 203, 4, 28, "Input"],
Cell[12886, 501, 28, 0, 28, "Output"]
}, Open  ]],
Cell[12929, 504, 534, 18, 89, "SmallText"],
Cell[CellGroupData[{
Cell[13488, 526, 352, 11, 28, "Input"],
Cell[13843, 539, 313, 11, 28, "Output"]
}, Open  ]],
Cell[14171, 553, 249, 8, 42, "SmallText"],
Cell[CellGroupData[{
Cell[14445, 565, 359, 10, 28, "Input"],
Cell[14807, 577, 439, 15, 58, "Output"]
}, Open  ]],
Cell[15261, 595, 244, 5, 42, "SmallText"],
Cell[CellGroupData[{
Cell[15530, 604, 476, 16, 30, "Input"],
Cell[16009, 622, 326, 11, 42, "Output"]
}, Open  ]],
Cell[16350, 636, 381, 10, 59, "SmallText"],
Cell[CellGroupData[{
Cell[16756, 650, 575, 20, 49, "Input"],
Cell[17334, 672, 820, 29, 30, "Output"],
Cell[18157, 703, 820, 29, 30, "Output"]
}, Open  ]],
Cell[18992, 735, 404, 10, 42, "SmallText"],
Cell[CellGroupData[{
Cell[19421, 749, 336, 10, 28, "Input"],
Cell[19760, 761, 528, 18, 42, "Output"]
}, Open  ]],
Cell[20303, 782, 579, 16, 76, "SmallText"],
Cell[CellGroupData[{
Cell[20907, 802, 728, 19, 49, "Input"],
Cell[21638, 823, 7676, 257, 476, "Output"],
Cell[29317, 1082, 160, 4, 28, "Output"]
}, Open  ]],
Cell[29492, 1089, 469, 12, 76, "SmallText"],
Cell[CellGroupData[{
Cell[29986, 1105, 521, 15, 28, "Input"],
Cell[30510, 1122, 528, 18, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31075, 1145, 657, 18, 49, "Input"],
Cell[31735, 1165, 193, 5, 28, "Output"],
Cell[31931, 1172, 528, 18, 42, "Output"]
}, Open  ]],
Cell[32474, 1193, 223, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[32722, 1201, 81, 2, 28, "Input"],
Cell[32806, 1205, 152, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32995, 1214, 293, 10, 28, "Input"],
Cell[33291, 1226, 262, 8, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33590, 1239, 237, 6, 28, "Input"],
Cell[33830, 1247, 160, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34027, 1256, 957, 24, 49, "Input"],
Cell[34987, 1282, 468, 15, 42, "Output"]
}, Open  ]],
Cell[35470, 1300, 286, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[35781, 1311, 282, 6, 28, "Input"],
Cell[36066, 1319, 160, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36263, 1328, 187, 5, 28, "Input"],
Cell[36453, 1335, 160, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36650, 1344, 46, 0, 45, "Subsection"],
Cell[36699, 1346, 252, 9, 44, "Input"],
Cell[CellGroupData[{
Cell[36976, 1359, 167, 5, 28, "Input"],
Cell[37146, 1366, 28, 0, 28, "Output"]
}, Open  ]],
Cell[37189, 1369, 175, 6, 43, "Input"],
Cell[CellGroupData[{
Cell[37389, 1379, 272, 8, 28, "Input"],
Cell[37664, 1389, 31, 0, 28, "Output"]
}, Open  ]],
Cell[37710, 1392, 387, 14, 45, "Input"],
Cell[CellGroupData[{
Cell[38122, 1410, 188, 6, 28, "Input"],
Cell[38313, 1418, 454, 16, 55, "Output"]
}, Open  ]],
Cell[38782, 1437, 314, 12, 45, "Input"],
Cell[CellGroupData[{
Cell[39121, 1453, 272, 8, 28, "Input"],
Cell[39396, 1463, 31, 0, 28, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39488, 1470, 116, 1, 55, "Section"],
Cell[CellGroupData[{
Cell[39629, 1475, 196, 6, 43, "Input"],
Cell[39828, 1483, 90, 3, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39955, 1491, 196, 6, 43, "Input"],
Cell[40154, 1499, 58, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40249, 1505, 173, 5, 28, "Input"],
Cell[40425, 1512, 542, 16, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41004, 1533, 50, 1, 28, "Input"],
Cell[41057, 1536, 321, 7, 49, "Output"]
}, Open  ]],
Cell[41393, 1546, 129, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[41547, 1551, 463, 11, 43, "Input"],
Cell[42013, 1564, 697, 23, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42747, 1592, 101, 1, 45, "Subsection"],
Cell[42851, 1595, 121, 1, 42, "SmallText"],
Cell[42975, 1598, 805, 21, 91, "Input"],
Cell[CellGroupData[{
Cell[43805, 1623, 244, 6, 44, "Input"],
Cell[44052, 1631, 158, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44247, 1641, 174, 3, 28, "Input"],
Cell[44424, 1646, 220, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44681, 1659, 483, 9, 44, "Input"],
Cell[45167, 1670, 705, 27, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45909, 1702, 276, 6, 28, "Input"],
Cell[46188, 1710, 544, 20, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46769, 1735, 663, 15, 43, "Input"],
Cell[47435, 1752, 261, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47733, 1767, 405, 14, 48, "Input"],
Cell[48141, 1783, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48206, 1788, 722, 17, 43, "Input"],
Cell[48931, 1807, 769, 30, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49737, 1842, 342, 8, 49, "Input"],
Cell[50082, 1852, 671, 26, 55, "Output"],
Cell[50756, 1880, 227, 8, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51020, 1893, 731, 25, 30, "Input"],
Cell[51754, 1920, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51819, 1925, 367, 8, 44, "Input"],
Cell[52189, 1935, 353, 12, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52591, 1953, 133, 1, 45, "Subsection"],
Cell[CellGroupData[{
Cell[52749, 1958, 335, 8, 44, "Input"],
Cell[53087, 1968, 57, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53181, 1974, 552, 11, 44, "Input"],
Cell[53736, 1987, 611, 23, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54384, 2015, 772, 19, 28, "Input"],
Cell[55159, 2036, 746, 29, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55942, 2070, 469, 10, 28, "Input"],
Cell[56414, 2082, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56479, 2087, 200, 4, 28, "Input"],
Cell[56682, 2093, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56747, 2098, 311, 8, 44, "Input"],
Cell[57061, 2108, 212, 8, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57310, 2121, 353, 8, 28, "Input"],
Cell[57666, 2131, 116, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57819, 2139, 430, 9, 44, "Input"],
Cell[58252, 2150, 377, 13, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58678, 2169, 146, 3, 45, "Subsection"],
Cell[CellGroupData[{
Cell[58849, 2176, 396, 9, 44, "Input"],
Cell[59248, 2187, 120, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59405, 2196, 239, 7, 42, "Input"],
Cell[59647, 2205, 169, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59853, 2216, 215, 6, 42, "Input"],
Cell[60071, 2224, 120, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60228, 2233, 492, 10, 44, "Input"],
Cell[60723, 2245, 120, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60880, 2254, 454, 9, 44, "Input"],
Cell[61337, 2265, 48, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61422, 2271, 627, 12, 44, "Input"],
Cell[62052, 2285, 548, 18, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62637, 2308, 127, 2, 28, "Input"],
Cell[62767, 2312, 548, 18, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63352, 2335, 571, 12, 44, "Input"],
Cell[63926, 2349, 2229, 80, 197, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66192, 2434, 398, 9, 28, "Input"],
Cell[66593, 2445, 959, 34, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67589, 2484, 152, 3, 28, "Input"],
Cell[67744, 2489, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67809, 2494, 950, 21, 44, "Input"],
Cell[68762, 2517, 601, 19, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69400, 2541, 234, 6, 28, "Input"],
Cell[69637, 2549, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69702, 2554, 232, 6, 28, "Input"],
Cell[69937, 2562, 28, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70002, 2567, 201, 4, 28, "Input"],
Cell[70206, 2573, 779, 28, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71022, 2606, 201, 4, 28, "Input"],
Cell[71226, 2612, 991, 36, 94, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72254, 2653, 582, 12, 44, "Input"],
Cell[72839, 2667, 412, 14, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73288, 2686, 572, 12, 44, "Input"],
Cell[73863, 2700, 1446, 45, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75346, 2750, 805, 19, 44, "Input"],
Cell[76154, 2771, 577, 19, 44, "Output"]
}, Open  ]],
Cell[76746, 2793, 203, 6, 42, "SmallText"],
Cell[76952, 2801, 256, 7, 28, "Input"],
Cell[77211, 2810, 283, 7, 28, "Input"],
Cell[77497, 2819, 236, 7, 28, "Input"],
Cell[77736, 2828, 121, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[77882, 2833, 463, 11, 43, "Input"],
Cell[78348, 2846, 697, 23, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79082, 2874, 282, 6, 28, "Input"],
Cell[79367, 2882, 713, 24, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80117, 2911, 235, 5, 28, "Input"],
Cell[80355, 2918, 869, 31, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81261, 2954, 191, 3, 28, "Input"],
Cell[81455, 2959, 146, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81638, 2966, 168, 3, 28, "Input"],
Cell[81809, 2971, 46, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81892, 2976, 289, 8, 43, "Input"],
Cell[82184, 2986, 46, 0, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82279, 2992, 110, 1, 45, "Subsection"],
Cell[CellGroupData[{
Cell[82414, 2997, 298, 7, 28, "Input"],
Cell[82715, 3006, 48, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82800, 3012, 358, 10, 42, "Input"],
Cell[83161, 3024, 37, 0, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83235, 3029, 116, 2, 28, "Input"],
Cell[83354, 3033, 46, 0, 28, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
