(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    156177,       5894]
NotebookOptionsPosition[    135013,       5162]
NotebookOutlinePosition[    135409,       5180]
CellTagsIndexPosition[    135366,       5177]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Umformung und Vereinfachung 
mathematischer Ausdr\[UDoubleDot]cke\
\>", "Title"],

Cell[CellGroupData[{

Cell["Die Simplifikationsproblematik", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.35882889854241*^9, 3.35882890592059*^9}}],

Cell[CellGroupData[{

Cell["Was Sie erwarten k\[ODoubleDot]nnen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"576", "+", 
   RowBox[{"816", " ", "x"}], "+", 
   RowBox[{"460", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"129", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"18", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   SuperscriptBox["x", "5"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"4", "+", "x"}], ")"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "-", "1"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"4", "+", "x"}], ")"}], "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "Expand"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"575", "+", 
  RowBox[{"816", " ", "x"}], "+", 
  RowBox[{"460", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"129", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"18", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"575", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"816", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"460", "+", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"129", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"18", "+", "x"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vereinfachen mit Simplify", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"105", " ", 
       SuperscriptBox["x", "4"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"9", "/", "2"}]]], "+", 
     FractionBox[
      RowBox[{"90", " ", 
       SuperscriptBox["x", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"7", "/", "2"}]]], "+", 
     FractionBox["9", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"5", "/", "2"}]]]}], ")"}]}], "+", 
  RowBox[{"8", " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"15", " ", 
       SuperscriptBox["x", "3"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"7", "/", "2"}]]], "+", 
     FractionBox[
      RowBox[{"9", " ", "x"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"5", "/", "2"}]]]}], ")"}]}], "+", 
  RowBox[{"12", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"5", "/", "2"}]]], "+", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Together"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"7", "+", 
     RowBox[{"51", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}], "4"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"7", "+", 
     RowBox[{"51", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], ")"}], 
   RowBox[{"9", "/", "2"}]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}], "]"}], "2"]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", "a", " ", "b"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gezielte Umformung von Ausdr\[UDoubleDot]cken", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "1"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "x"}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "x"}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "x"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"s1", "\[Equal]", "s2"}], "]"}]], "Input",
 CellChangeTimes->{{3.387977864923293*^9, 3.387977865764098*^9}, {
  3.387978327180446*^9, 3.387978337208455*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "1"}], "]"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.387977871657865*^9, 3.387977880995748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    SqrtBox["2"]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"s1", "\[Equal]", "s2"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.387977864923293*^9, 3.387977865764098*^9}, {
   3.387978327180446*^9, 3.387978349694897*^9}, 3.387978626188865*^9}],

Cell[BoxData["True"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vereinfachen und mathematische Exaktheit. Zusatzannahmen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sqrt", "[", "x", "]"}], "2"], ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Tan", "[", 
    RowBox[{"ArcSin", "[", "x", "]"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "3"], ",", 
   FractionBox["x", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Log", "[", 
     RowBox[{"Exp", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Sqrt", "[", 
     SuperscriptBox["x", "2"], "]"}]}], "}"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Log", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], ",", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.35882864590562*^9, {3.35883056335001*^9, 3.35883059365086*^9}, {
   3.35883075560573*^9, 3.35883077117818*^9}, {3.35883091789373*^9, 
   3.3588309197511*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd2Hk0Ff//B3DJdiUxk7KVtUIJEW16j1SWFLKlRQhtQpQiFbJkSdmypuyq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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-5, 5}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/.", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{"12", "\[Pi]"}], "5"]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], "5"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], "]"}]], "Input"],

Cell[BoxData["x"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Log", "[", 
    RowBox[{"Exp", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{3.35882874012939*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN1P8v1HEcwPFL5s63anW76WLGcunI0u3ifLnjHHfWDals7JLjcJmyw+ya
ryerdmzYnSnGVL6mRM1ayxDZ2nKY4xDNl7hJ7ZKOO+6k2ni9Pz889/gPni6J
GdHJFjgcLuJf/xUIF3V7e7z+A+fJgo3jZmTihGbTzYgUc4fNl9aRWefe2Dxc
QMq3yyjn3yPfVvrGJxQjSQPlqn5LJJc5U3BDHwaejDDgbbdCQfdsWc9rMwfs
6G4O8dOFgJPyhieqX2wwK5c+wVwIBiOKL3q/UAeBSobDcNQrFninafuzhSIQ
bPAteTRS7Q+yjdoOZTMDHNcV3iSV+oCNdgPqLgUdTBL6fSVk0sC6JXl4XJw3
SCNZ98lVXiBhUkyfrqSCCUtk29h6Cqi8zvC4HOMK5iUd28jlOIKa1mh+TzoR
HFXM5mim8KCBlR6On/vZZ9z3B6viFk6sYx1YIpXMn84nBB1YpCaf6HUmglZH
G11MbY5gFD8l7cw9V7CG3brslEEBCZ/yiXXPqeBvy0Mrq4+9QP3Gt8MNwd6g
zNNpvVxAA1XMFs+UK3TQg2waLMr2AbkjTe0yCQNcvSYNeCDyB2ubie5qWSBo
P4YXWeayQJ4wcTdgNAjkf7hatzMbDL5UZCa3a9hgLXczrkAbAmpTn0o5yxxQ
L1lJs/8SCpYmlMmNa2Gg7F38uEbLBXGmKu6UgQfWuNPWDBhpMWNlDkZkSpfN
eCzG4dRCwRzG6gmxZHEb6dXhX/vdhPw4Ox1oZ0YKrXMWPDEqRZ1utzHukN06
1zEO3T8ytLmLjO9uTyX9QRqXeDY+GKnMu5FSjBV6w8wORqprVd6pPeRg5AXn
AIxbz9JF+Rgrpq3x9RjPWrW09WIcoHH48xj3Pwb+BZP7aYM=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-50, 50}, {-49.99999795918367, 49.99999795918367}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"10", "I"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"10", " ", "\[ImaginaryI]"}], "-", 
  RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input"],

Cell[BoxData["x"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Sqrt", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Input"],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[GreaterEqual]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["x"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["x"], 
     SqrtBox["y"]}], "-", 
    SqrtBox[
     RowBox[{"x", " ", "y"}]]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["x"], " ", 
   SqrtBox["y"]}], "-", 
  SqrtBox[
   RowBox[{"x", " ", "y"}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w1", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "1"}], ",", 
      RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"w1", ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w2", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     SqrtBox["x"]], "-", 
    SqrtBox[
     FractionBox["1", "x"]]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    FractionBox["1", "x"]]}], "+", 
  FractionBox["1", 
   SqrtBox["x"]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w2", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w2", "/.", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"0.001", "I"}]}]}]}], "//", "Chop"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"w2", "/.", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"a", " ", "I"}]}]}], "}"}]}], ",", 
   RowBox[{"a", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "2"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"l", ",", 
   RowBox[{"x", ">", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigene Umformungsregeln vereinbaren", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sqrtRules", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["x_"], 
      SqrtBox["y_"]}], "\[Rule]", 
     SqrtBox[
      RowBox[{"x", " ", "y"}]]}], ",", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["y_"]], "\[Rule]", 
     SqrtBox[
      FractionBox["1", "y"]]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["x_"], " ", 
     SqrtBox["y_"]}], "\[Rule]", 
    SqrtBox[
     RowBox[{"x", " ", "y"}]]}], ",", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["y_"]], "\[Rule]", 
    SqrtBox[
     FractionBox["1", "y"]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"w1", ",", "w2", ",", 
    RowBox[{
     FractionBox[
      SqrtBox["x"], 
      SqrtBox["y"]], "-", 
     SqrtBox[
      FractionBox["x", "y"]]}]}], "}"}], "//.", "sqrtRules"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"w1", ",", "w2", ",", 
    RowBox[{
     FractionBox[
      SqrtBox["x"], 
      SqrtBox["y"]], "-", 
     SqrtBox[
      FractionBox["x", "y"]]}]}], "}"}], "//", "PowerExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynomiale, rationale und pseudorationale Ausdr\[UDoubleDot]cke", \
"Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Ausmultiplizieren polynomialer Ausdr\[UDoubleDot]cke", "Subsection",
 CellChangeTimes->{{3359005004.57914, 3359005012.74179}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "a"}], ")"}], "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "b"}], ")"}], "3"]}]}]], "Input",
 CellChangeTimes->{{3.35883227606644*^9, 3.35883227647481*^9}}],

Cell[BoxData[
 RowBox[{"x", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "b"}], "+", "x"}], ")"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "u", "]"}]], "Input",
 CellChangeTimes->{{3.35883228061837*^9, 3.35883228106071*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["a", "2"]}], " ", 
   SuperscriptBox["b", "3"], " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"6", " ", "a", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"6", " ", "a", " ", "b", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"3", " ", "b", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "a"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "b"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "b", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"], " ", "x"}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"], " ", "x"}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "a"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "b"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{"a", "+", "b"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "b"}], "+", 
    SuperscriptBox["b", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"b", "+", "x"}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "3"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "3"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "4"]], "]"}]], "Input",
 CellChangeTimes->{{3.35883237018546*^9, 3.3588323718145*^9}, {
  3.35883241756864*^9, 3.35883248904869*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"3", " ", "x"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   SuperscriptBox["x", "3"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandDenominator", "[", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "3"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]], "]"}], "Mfx\:ffff"}]], "Input",
 CellChangeTimes->{3.387982324694822*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Mfx\:ffff", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "3"]}], 
  RowBox[{"1", "-", 
   RowBox[{"4", " ", "x"}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   SuperscriptBox["x", "4"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "]"}], "+", "1"}], ")"}], "2"], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "2"], "]"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "2"], "]"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandAll", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "]"}], "+", "1"}], ")"}], "2"], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}], "2"]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ausdr\[UDoubleDot]cke ordnen und nach Variablen zusammenfassen", \
"Subsection",
 CellChangeTimes->{{3358940296.32144, 3358940313.63908}, {3358949119.53778, 
  3358949121.61005}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{
        SuperscriptBox["x", "2"], "y"}], "+", 
       RowBox[{"b", " ", "y"}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["y", "2"]}]}], ")"}], "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    RowBox[{
     SuperscriptBox["x", "4"], 
     SuperscriptBox["y", "2"]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35894032131768*^9, 3.35894038131373*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "-", 
  RowBox[{"4", " ", "x", " ", "y"}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", "c", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", "b", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Polynom wird als Polynom in x mit polynomialen Koeffizienten \
umsortiert, was eine gewisse Klammersetzung induziert.\nDas macht sich leider \
in der Ausgabe nur teilweise bemerkbar, weil die Summanden einer Summe (als \
Auswirkung des Attributs ",
 StyleBox["Orderless",
  FontWeight->"Bold"],
 " von ",
 StyleBox["Plus",
  FontWeight->"Bold"],
 ") defaultm\[ADoubleDot]\[SZ]ig nach einer inneren Ordnung sortiert werden, \
also nicht nach x-Potenzen. "
}], "SmallText",
 CellChangeTimes->{{3.35895190152591*^9, 3.35895203898415*^9}, {
  3.35895207499501*^9, 3.35895208448968*^9}, {3.35895213300441*^9, 
  3.35895214859406*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35894038750063*^9, 3.35894039274868*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "a", " ", "y"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "y"}], "+", 
     RowBox[{"2", " ", "c", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "/@", 
  RowBox[{"List", "@@", "u"}]}]], "Input",
 CellChangeTimes->{{3.35894093991702*^9, 3.35894096932638*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", 
   ",", "5", ",", "5"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "/@", "u"}]], "Input",
 CellChangeTimes->{{3.35900558193123*^9, 3.3590055867809*^9}}],

Cell[BoxData["31"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Selbst Sortieren hilft nichts, weil ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " die \"falsche\" Ordnung sofort erkennt und durch die seiner Meinung nach \
korrekte ersetzt. "
}], "SmallText",
 CellChangeTimes->{{3.35895209168313*^9, 3.35895212820098*^9}, {
  3.3589521612969*^9, 3.3589521831879*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"List", "@@", "u"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"#1", ",", "x"}], "]"}], ">", 
     RowBox[{"Exponent", "[", 
      RowBox[{"#2", ",", "x"}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894334839293*^9, 3.35894337071827*^9}, {
  3.387983024549984*^9, 3.38798302623695*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "2"]}], ",", 
   SuperscriptBox["x", "3"], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "a", " ", "y"}], "+", 
      RowBox[{"2", " ", "b", " ", 
       SuperscriptBox["y", "2"]}]}], ")"}]}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "y"}], "+", 
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox["y", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SuperscriptBox["y", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "c", " ", 
    SuperscriptBox["y", "3"]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"4", " ", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"2", " ", "a", " ", "b", " ", "y"}], ",", 
   SuperscriptBox["a", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"u", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"#1", ",", "x"}], "]"}], ">", 
     RowBox[{"Exponent", "[", 
      RowBox[{"#2", ",", "x"}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894334839293*^9, 3.35894337071827*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "a", " ", "y"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "y"}], "+", 
     RowBox[{"2", " ", "c", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das Ganze \[ADoubleDot]ndert sich erst, wenn das Attribut ",
 StyleBox["Orderless",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ckgesetzt wird. Nun ist die Ausgabe sowohl von ",
 StyleBox["Collect",
  FontWeight->"Bold"],
 " als auch von ",
 StyleBox["Sort",
  FontWeight->"Bold"],
 " nach x-Potenzen geordnet."
}], "SmallText",
 CellChangeTimes->{{3.35895219263398*^9, 3.35895224785148*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"Plus", ",", "Orderless"}], "]"}], ";"}], "\n", 
 RowBox[{"u", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Depth", "/@", 
  RowBox[{"List", "@@", "u"}]}], "\n", 
 RowBox[{"Sort", "[", 
  RowBox[{"u", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"#1", ",", "x"}], "]"}], ">", 
     RowBox[{"Exponent", "[", 
      RowBox[{"#2", ",", "x"}], "]"}]}], "&"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"Plus", ",", "Orderless"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.35894189811027*^9, 3.35894197285223*^9}, {
  3.35894338253776*^9, 3.35894338605427*^9}, {3.35894342249508*^9, 
  3.35894343199634*^9}, {3.35894820699297*^9, 3.35894821980127*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["y", "2"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "y"}], "+", 
     RowBox[{"2", " ", "c", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "a", " ", "y"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "5", ",", "5", 
   ",", "2", ",", "3"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "a", " ", "y"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "y"}], "+", 
     RowBox[{"2", " ", "c", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
  SuperscriptBox["a", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.35894882745902*^9, 3.35894885830214*^9}}],

Cell[BoxData["4"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.3589488368669*^9, 3.35894884876862*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"4", " ", "c", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", "y"}], "+", 
    RowBox[{"2", " ", "c", " ", 
     SuperscriptBox["y", "2"]}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "a", " ", "y"}], "+", 
    RowBox[{"2", " ", "b", " ", 
     SuperscriptBox["y", "2"]}]}], ",", "1", ",", 
   RowBox[{"2", " ", 
    SuperscriptBox["y", "2"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894886489751*^9, 3.35894887820722*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "a", " ", "y"}], "+", 
  RowBox[{"2", " ", "b", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", "x", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.35894888348223*^9, 3.35894889142233*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "4"}], " ", "y"}], "+", 
  RowBox[{"2", " ", "c", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894967085058*^9, 3.3589496779255*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b"}], "-", 
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{"4", "+", 
    SuperscriptBox["b", "2"], "+", 
    RowBox[{"2", " ", "c", " ", "x"}], "+", 
    RowBox[{"2", " ", "b", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "4"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894980631585*^9, 3.35894985154959*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "x"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "b"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]}], ")"}], " ", "y"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", "+", 
     SuperscriptBox["b", "2"], "+", 
     RowBox[{"2", " ", "c", " ", "x"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}], " ", 
   SuperscriptBox["y", "2"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35900992554888*^9, 3.35900993448457*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     RowBox[{"2", " ", "a", " ", "b"}], ",", 
     RowBox[{"4", "+", 
      SuperscriptBox["b", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "c"}], ",", 
     SuperscriptBox["c", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"2", " ", "c"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"2", " ", "a"}], ",", 
     RowBox[{"2", " ", "b"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", "x", ",", "Simplify"}], "]"}]], "Input",
 CellChangeTimes->{{3.3589507505919*^9, 3.35895083995361*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", "x", " ", "y", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"c", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "a", " ", "y"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"c", " ", "y"}]}], ")"}], "2"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Collect",
  FontWeight->"Bold"],
 " ist ein komplexes Kommando, welches auf ",
 StyleBox["Coefficient",
  FontWeight->"Bold"],
 " aufbaut. So h\[ADoubleDot]tte man das vorige Kommando auch so anschreiben \
k\[ODoubleDot]nnen:"
}], "SmallText",
 CellChangeTimes->{{3.35895226662428*^9, 3.35895230978761*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"Coefficient", "[", 
       RowBox[{"f", ",", "x", ",", "i"}], "]"}], "]"}], 
     RowBox[{"x", "^", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"Exponent", "[", 
       RowBox[{"f", ",", "x"}], "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35895085618304*^9, 3.35895101090977*^9}, {
  3.35895106789344*^9, 3.35895130542723*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", "a", " ", "b", " ", "y"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"2", " ", "x", " ", "y", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"c", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "a", " ", "y"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"c", " ", "y"}]}], ")"}], "2"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Und dies ist eine Alternative zu ",
 StyleBox["Collect",
  FontWeight->"Bold"],
 "[f,{y,a}]"
}], "SmallText",
 CellChangeTimes->{{3.35901049050706*^9, 3.35901050686345*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", "y", ",", 
   RowBox[{
    RowBox[{"Collect", "[", 
     RowBox[{"#", ",", "a"}], "]"}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35900986985126*^9, 3.35900987788463*^9}, {
  3.35900997308341*^9, 3.35900999829578*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "x"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "b"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]}], ")"}], " ", "y"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", "+", 
     SuperscriptBox["b", "2"], "+", 
     RowBox[{"2", " ", "c", " ", "x"}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}], " ", 
   SuperscriptBox["y", "2"]}], "-", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["y", "4"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Collect",
  FontWeight->"Bold"],
 " kann nat\[UDoubleDot]rlich auch mit verallgemeinerten Kernen aufgreufen \
werden."
}], "SmallText",
 CellChangeTimes->{{3.35901053411013*^9, 3.35901055779012*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "-", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35895248922278*^9, 3.35895252697953*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "4"], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"u", ",", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895253554787*^9, 3.35895254427002*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "4"], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zerlegen in Faktoren", "Subsection",
 CellChangeTimes->{{3358952626.15156, 3358952632.57063}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "-", 
   RowBox[{"4", "x"}], "+", 
   RowBox[{"6", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"4", 
    SuperscriptBox["x", "3"]}], "+", 
   SuperscriptBox["x", "4"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895264709324*^9, 3.35895267472325*^9}}],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   SuperscriptBox["x", "4"], "-", 
   SuperscriptBox["y", "4"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895267932358*^9, 3.35895268638204*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "-", "y"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"x", "+", "y"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35895270062605*^9, 3.35895273596737*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "4"]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"3", " ", "x"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "4"], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"3", " ", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Factor",
  FontWeight->"Bold"],
 " funktioniert auch f\[UDoubleDot]r pseudorationale Ausdr\[UDoubleDot]cke in \
verallgemeinerten Kernen. Mit vier Kernen ist keine (wesentliche) \
Faktorisierung m\[ODoubleDot]glich."
}], "SmallText",
 CellChangeTimes->{{3.35895287074766*^9, 3.35895293599764*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.35895274874391*^9, 3.35895275564026*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "9"}], " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], "+", 
    RowBox[{"9", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Reduziert man die Zahl der Kerne aber durch ",
 StyleBox["TrigExpand",
  FontWeight->"Bold"],
 " auf Sin[x] und Cos[x], so l\[ADoubleDot]sst sich der Ausdruck in zwei \
Faktoren zerlegen."
}], "SmallText",
 CellChangeTimes->{{3.35895294128296*^9, 3.35895301204206*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"s1", "//", "TrigExpand"}]}]], "Input",
 CellChangeTimes->{{3.35895278358409*^9, 3.3589527896899*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "4"]}], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"], "12"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "4"], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "3"], "12"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{"s2", "//", "Factor"}]}]], "Input",
 CellChangeTimes->{{3.35895279393521*^9, 3.3589528159196*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "-", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "9"}], "+", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.35895281810962*^9, 3.35895282485917*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "-", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x", "-", "6"}], 
   RowBox[{
    SuperscriptBox["x", "2"], "-", "1"}]], "]"}]], "Input",
 CellChangeTimes->{{3.35895302862068*^9, 3.35895306258705*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   FractionBox["1", "4"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895306802705*^9, 3.35895307986212*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895397333672*^9, 3.35895398118116*^9}, 
   3.35895408885574*^9, 3.387987020300385*^9}],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895398877321*^9, 3.35895399883866*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", "x"}], "+", "1"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    SqrtBox["5"]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895400718177*^9, 3.35895403035241*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SqrtBox["5"], "-", 
    RowBox[{"2", " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SqrtBox["5"], "+", 
    RowBox[{"2", " ", "x"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", 
     SqrtBox["2"], "x"}], "+", "2"}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.387987174722884*^9, 3.387987194849396*^9}}],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}], "2"]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbeiten mit rationalen Funktionen", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{"x", "+", 
   FractionBox["y", "z"]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"y", "+", 
   RowBox[{"x", " ", "z"}]}], "z"]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}]], "+", 
   FractionBox["1", 
    RowBox[{"x", "+", "1"}]], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"x", "-", "1"}]]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "3"]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", "+", "3"}]], "+", 
   FractionBox["1", 
    RowBox[{"x", "-", "1"}]], "+", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "1"}]]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"5", "+", 
   RowBox[{"5", " ", "x"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"1", "-", 
    SuperscriptBox["x", "10"]}], 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "9"]}]], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.35893613581338*^9, 3.35893617295782*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "x", "+", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "3"], "+", 
   SuperscriptBox["x", "4"], "+", 
   SuperscriptBox["x", "5"], "+", 
   SuperscriptBox["x", "6"], "+", 
   SuperscriptBox["x", "7"], "+", 
   SuperscriptBox["x", "8"], "+", 
   SuperscriptBox["x", "9"]}], 
  RowBox[{"1", "+", "x", "+", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "3"], "+", 
   SuperscriptBox["x", "4"], "+", 
   SuperscriptBox["x", "5"], "+", 
   SuperscriptBox["x", "6"], "+", 
   SuperscriptBox["x", "7"], "+", 
   SuperscriptBox["x", "8"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "3"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}], "2"]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Numerator", "[", "f", "]"}], ",", " ", 
    RowBox[{"Denominator", "[", "f", "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "3"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", "x"}], ")"}], "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Beide Kommandos sind reine Selektoren und bilden vorher keinen gemeinsamen \
Nenner.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "x"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox["b", "x"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["b", "x"], "+", 
  FractionBox[
   RowBox[{"a", " ", "x"}], 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{"Together", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", "x"}], 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], "+", 
    FractionBox["b", "x"]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "b"}], "-", 
  RowBox[{"a", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  FractionBox[
   RowBox[{"12", "-", 
    RowBox[{"8", "x"}], "-", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"]}], 
   RowBox[{
    RowBox[{"-", "18"}], "-", 
    RowBox[{"3", "x"}], "+", 
    RowBox[{"4", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "x"}], 
  RowBox[{"3", "+", "x"}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  FractionBox[
   RowBox[{"1", "-", 
    SuperscriptBox["x", "3"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "6"]]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   SuperscriptBox["x", "3"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "6"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   SuperscriptBox["x", "3"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "6"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "//", "Cancel"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "-", "x", "-", 
   SuperscriptBox["x", "2"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "5"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "20"], "-", "1"}], 
   RowBox[{
    SuperscriptBox["x", "7"], "-", "1"}]]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "20"]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "7"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "20"]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "7"]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "//", "Cancel"}]], "Input",
 CellChangeTimes->{{3.3589361983899*^9, 3.35893619969324*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "6"], "+", 
    SuperscriptBox["x", "7"], "+", 
    SuperscriptBox["x", "8"], "+", 
    SuperscriptBox["x", "9"], "+", 
    SuperscriptBox["x", "10"], "+", 
    SuperscriptBox["x", "11"], "+", 
    SuperscriptBox["x", "12"], "+", 
    SuperscriptBox["x", "13"], "+", 
    SuperscriptBox["x", "14"], "+", 
    SuperscriptBox["x", "15"], "+", 
    SuperscriptBox["x", "16"], "+", 
    SuperscriptBox["x", "17"], "+", 
    SuperscriptBox["x", "18"], "+", 
    SuperscriptBox["x", "19"]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "6"]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox["x", 
   RowBox[{
    SuperscriptBox["x", "4"], "-", "1"}]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "+", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox["x", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"2", "-", 
    RowBox[{"Sin", "[", "x", "]"}]}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{"x", " ", "y"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "2"]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x"}], "+", "y"}], ")"}], "2"]], "+", 
  FractionBox["x", 
   RowBox[{
    RowBox[{"-", "x"}], "+", "y"}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", "y"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "2"]], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["y", 
   RowBox[{"x", "-", "y"}]], "+", 
  FractionBox[
   SuperscriptBox["y", "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "2"]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", "y"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "2"]], ",", "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x"}], "+", "y"}], ")"}], "2"]], "+", 
  FractionBox["x", 
   RowBox[{
    RowBox[{"-", "x"}], "+", "y"}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", "y"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["y", 
     RowBox[{"x", "-", "y"}]], "+", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "y"}], ")"}], "2"]]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "x"}], "+", "y"}], ")"}], "2"]], "+", 
    FractionBox["x", 
     RowBox[{
      RowBox[{"-", "x"}], "+", "y"}]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "5"], "+", "1"}], 
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x", "+", "1"}]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "-", 
  FractionBox["x", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}]]}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometrische Umformungen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Einf\[UDoubleDot]hrung", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]], ",", 
   FractionBox["1", 
    RowBox[{"Cos", "[", "x", "]"}]], ",", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "x", "]"}]], ",", 
   FractionBox["1", 
    RowBox[{"Sin", "[", "x", "]"}]]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"Sec", "[", "x", "]"}], ",", 
   RowBox[{"Cot", "[", "x", "]"}], ",", 
   RowBox[{"Csc", "[", "x", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Cot", "[", "x", "]"}]}], "//", "TrigToExp"}]}]], "Input",
 CellChangeTimes->{{3.35901236014325*^9, 3.3590123603799*^9}, {
  3.35901407239032*^9, 3.3590140831623*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]]}], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}]]}]], "Output"]
}, Open  ]],

Cell["\<\
Das ist nun noch komplizierter als vorher, weil gleich im ersten Term Grad 4 \
statt Grad 3 entsteht.\
\>", "SmallText",
 CellChangeTimes->{{3.387989130476364*^9, 3.387989165926399*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u2", "=", 
  RowBox[{"u1", "//", "Together"}]}]], "Input",
 CellChangeTimes->{{3.35901236325017*^9, 3.35901237466643*^9}, {
  3.35901407463925*^9, 3.35901407644171*^9}, {3.3590142867875*^9, 
  3.35901428993705*^9}, {3.387989061550777*^9, 3.387989118052525*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "x"}]]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", "x"}]]}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u3", "=", 
  RowBox[{"u2", "//", "ExpToTrig"}]}]], "Input",
 CellChangeTimes->{{3.35901236668429*^9, 3.35901239264716*^9}, {
  3.35901409055622*^9, 3.35901409302918*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", " ", "x"}], "]"}]}], "+", 
       RowBox[{"Cos", "[", 
        RowBox[{"4", " ", "x"}], "]"}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"3", " ", "x"}], "]"}]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"4", " ", "x"}], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u3", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.35901238425093*^9, 3.35901239528736*^9}, {
  3.3590124649434*^9, 3.35901247551884*^9}, {3.35901409552575*^9, 
  3.35901409632401*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
  RowBox[{"Csc", "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"u3", "-", 
   RowBox[{"Sin", "[", "x", "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.35901239953177*^9, 3.35901240809544*^9}, {
  3.35901248564194*^9, 3.35901248677059*^9}, {3.35901291010563*^9, 
  3.35901291048115*^9}, {3.35901409845154*^9, 3.35901409926905*^9}}],

Cell[BoxData[
 RowBox[{"Cot", "[", "x", "]"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Die Standardkommandos", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[StyleBox["TrigExpand",
 FontWeight->"Bold"]], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"\[Alpha]", "+", "\[Beta]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", 
   RowBox[{"Cos", "[", "\[Beta]", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Sin", "[", "\[Alpha]", "]"}], " ", 
   RowBox[{"Sin", "[", "\[Beta]", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{
    RowBox[{"2", "x"}], "+", 
    FractionBox["\[Pi]", "4"]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], 
   SqrtBox["2"]], "-", 
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], 
   SqrtBox["2"]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "4"], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "4"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cot", "[", "x", "]"}], "2"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "4"]}], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cot", "[", "x", "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"]}], "8"], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "8"]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["TrigReduce",
 FontWeight->"Bold"]], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{"2", 
   RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", 
   RowBox[{"Cos", "[", "\[Beta]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"\[Alpha]", "-", "\[Beta]"}], "]"}], "+", 
  RowBox[{"Cos", "[", 
   RowBox[{"\[Alpha]", "+", "\[Beta]"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "5"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"10", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{"5", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", "x"}], "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cot", "[", "x", "]"}], "2"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"7", " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["TrigFactor",
 FontWeight->"Bold"]], "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "-", 
    RowBox[{"2", " ", "x"}]}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "+", 
    RowBox[{"2", " ", "x"}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"3", "x"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"4", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "+", 
     FractionBox["\[Pi]", "3"]}], "]"}], 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "-", 
     FractionBox["\[Pi]", "3"]}], "]"}]}], "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], "x"}], 
   "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", "x"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", 
      RowBox[{"2", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"4", " ", "x"}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", "x"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", "x"}], "]"}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ein trigonometrisches Regelsystem", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"s1", "=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "y", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}]}]}]}], "\n", 
 RowBox[{"c1", "=", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "y", "]"}]}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x_", "+", "y_"}], "]"}], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "y", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"x_", "+", "y_"}], "]"}], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Cos", "[", "y", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", "y", "+", "z"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "z", "]"}], " ", 
      RowBox[{"Sin", "[", "y", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "y", "]"}], " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "y", "]"}], " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{"Sin", "[", "y", "]"}], " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Die Regeln wurden mehrfach angewendet, aber Klammern nicht aufgel\
\[ODoubleDot]st. ",
 StyleBox["Expand",
  FontWeight->"Bold"],
 " erst im Nachhinein anzuwenden ist sinnvoll; besser w\[ADoubleDot]re es \
aber,  den Effekt des Zusammenfassens so fr\[UDoubleDot]h wie \
m\[ODoubleDot]glich in der Rechnung zu ber\[UDoubleDot]cksichtigen. \nNat\
\[UDoubleDot]rlich ist \[RuleDelayed] statt \[Rule] zu verwenden, denn \
Expand[a] soll ja zur Zeiit der Regelanwendung und nicht zur Zeit der \
Regeldefinition ausgef\[UDoubleDot]hrt werden. Die rechte Seite der Regel \
darf also w\[ADoubleDot]hrend der Definition nicht ausgewertet werden. \nDer \
folgende Ansatz scheitert trotzdem zun\[ADoubleDot]chst."
}], "SmallText",
 CellChangeTimes->{{3.359016500605*^9, 3.35901663624388*^9}, {
  3.35901679145504*^9, 3.35901688966746*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"a_", "\[RuleDelayed]", 
   RowBox[{"Expand", "[", "a", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.35901640571136*^9, 3.35901640594634*^9}, {
  3.35901680895699*^9, 3.35901681289424*^9}}],

Cell[BoxData[
 RowBox[{"a_", "\[RuleDelayed]", 
  RowBox[{"Expand", "[", "a", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "-", "y", "+", "z"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1", ",", "d1"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.35901633727962*^9, 3.35901633746815*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"y", "-", "z"}], "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"y", "-", "z"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Der Grund ist simpel: ",
 StyleBox["d1 ",
  FontWeight->"Bold"],
 "wurde auf Teilausdr\[UDoubleDot]cken gar nicht erst versucht, weil die \
Regel ja auch auf den Gesamtausdruck angewendet werden kann und dort keine \
\[CapitalADoubleDot]nderung hervorruft. Um \"unendliche Schleifen des \
Nichtstuns\" zu vermeiden bricht ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in solchen F\[ADoubleDot]llen das ",
 StyleBox["ReplaceRepeated",
  FontWeight->"Bold"],
 " ab. \nDie Regel d1 darf also nur angewendet werden, wenn sich wirklich \
etwas \[ADoubleDot]ndert, was hier mit =!= (",
 StyleBox["UnsameQ",
  FontWeight->"Bold"],
 ") gepr\[UDoubleDot]ft wird."
}], "SmallText",
 CellChangeTimes->{{3.35901664143312*^9, 3.35901676066004*^9}, {
  3.35901691213894*^9, 3.35901696678293*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{
   RowBox[{"a_", "/;", 
    RowBox[{
     RowBox[{"Expand", "[", "a", "]"}], "=!=", "a"}]}], ":>", 
   RowBox[{"Expand", "[", "a", "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a_", "/;", 
   RowBox[{
    RowBox[{"Expand", "[", "a", "]"}], "=!=", "a"}]}], "\[RuleDelayed]", 
  RowBox[{"Expand", "[", "a", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "-", "y", "+", "z"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1", ",", "d1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Cos", "[", "z", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cos", "[", "z", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "z", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "z", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"2", "x"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1", ",", "d1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"2", " ", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"s2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"n_Integer", " ", "x_"}], "]"}], "/;", 
    RowBox[{"n", ">", "1"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}]}]}]}], "\n", 
 RowBox[{"c2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"n_Integer", " ", "x_"}], "]"}], "/;", 
    RowBox[{"n", ">", "1"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"n_Integer", " ", "x_"}], "]"}], "/;", 
   RowBox[{"n", ">", "1"}]}], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "x"}], 
     "]"}]}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"n_Integer", " ", "x_"}], "]"}], "/;", 
   RowBox[{"n", ">", "1"}]}], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "x"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "x"}], 
     "]"}]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"12", "x"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s2", ",", "c2", ",", "d1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"12", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "11"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{"220", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "9"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
  RowBox[{"792", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "7"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "9"]}], "-", 
  RowBox[{"12", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "11"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sc", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x_", "]"}], "n_Integer"], "/;", 
    RowBox[{"n", ">", "1"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"n", "-", "2"}]]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x_", "]"}], "n_Integer"], "/;", 
   RowBox[{"n", ">", "1"}]}], "\[Rule]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"5", "x"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s2", ",", "c2", ",", "d1", ",", "sc"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], "-", 
  RowBox[{"12", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Sin", "[", "x", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "4"]}]}], ")"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Factor"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"5", "x"}], "]"}], "//", "TrigFactor"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}]}]}], ")"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eine Testserie", "Subsection"],

Cell["\<\
Mit dieser Funktion werden die Ergebnisse verschiedene \
Simplifikationsstrategien f\[UDoubleDot]r trigonometrische \
Ausdr\[UDoubleDot]cke aufgesammelt.\
\>", "SmallText",
 CellChangeTimes->{{3359020584.41773, 3359020633.08199}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"tests", "[", "h_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", "h", "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Simplify", ",", "TrigReduce", ",", "TrigExpand", ",", "TrigFactor"}], 
    "}"}]}]}]], "Input"],

Cell[TextData[{
 "Ein erstes einfaches Beispiel: Ein polynomialer Ausdruck in ",
 StyleBox["Sin",
  FontWeight->"Bold"],
 " mit Mehrfachwinkeln."
}], "SmallText",
 CellChangeTimes->{{3.35902064293312*^9, 3.35902068233458*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d1", "=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"3", "x"}], "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"5", "x"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"i1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d1", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"h1", "=", 
  RowBox[{"d1", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i1", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"3", " ", "x"}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"5", " ", "x"}], "]"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"8", " ", "x"}], "]"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"8", " ", "x"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"3", " ", "x"}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"5", " ", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h1", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Hier sehen Sie noch einmal die Wirkung der vier Simplifikationskommandos \
auf einen trigonometrischen Ausdruck. Das Ergebnis von ",
 StyleBox["TrigFactor",
  FontWeight->"Bold"],
 " ist wegen der komplexen Zahlen nicht zufriedenstellend."
}], "SmallText",
 CellChangeTimes->{3.388076637373515*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"8", " ", "x"}], "]"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"8", " ", "x"}], "]"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["7", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "-", 
    RowBox[{
     FractionBox["7", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "7"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[ImaginaryI]", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Im zweiten Beispiel muss der gemeinsame Kern ",
 Cell[BoxData[
  FormBox[
   FractionBox["x", "6"], TraditionalForm]]],
 "erst gefunden werden."
}], "SmallText",
 CellChangeTimes->{{3.35902071875337*^9, 3.35902077756017*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d2", "=", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}], 
   RowBox[{"Cos", "[", 
    FractionBox["x", "3"], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"i2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d2", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"h2", "=", 
  RowBox[{"d2", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i2", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox["x", "3"], "]"}], " ", 
  RowBox[{"Cos", "[", 
   FractionBox["x", "2"], "]"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "6"], "]"}]}], "+", 
  RowBox[{
   FractionBox["3", "5"], " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"5", " ", "x"}], "6"], "]"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["x", "6"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["x", "3"], "]"}], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"5", " ", "x"}], "6"], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"5", " ", "x"}], "6"], "]"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Cos", "[", 
    RowBox[{"Times", "[", 
     RowBox[{
      RowBox[{"Rational", "[", 
       RowBox[{"5", ",", "6"}], "]"}], ",", "x"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"5", " ", "x"}], "6"], "]"}], "//", "TrigExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", 
    FractionBox["x", "6"], "]"}], "5"], "-", 
  RowBox[{"10", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox["x", "6"], "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox["x", "6"], "]"}], "2"]}], "+", 
  RowBox[{"5", " ", 
   RowBox[{"Cos", "[", 
    FractionBox["x", "6"], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox["x", "6"], "]"}], "4"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h2", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["3", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       RowBox[{"Sin", "[", 
        FractionBox["x", "6"], "]"}]}], "+", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"5", " ", "x"}], "6"], "]"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["3", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       RowBox[{"Sin", "[", 
        FractionBox["x", "6"], "]"}]}], "+", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"5", " ", "x"}], "6"], "]"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "6"], "]"}]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       FractionBox["x", "6"], "]"}], "4"], " ", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "6"], "]"}]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       FractionBox["x", "6"], "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       FractionBox["x", "6"], "]"}], "3"]}], "+", 
    RowBox[{
     FractionBox["3", "5"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       FractionBox["x", "6"], "]"}], "5"]}]}], ",", 
   RowBox[{
    FractionBox["6", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{"Cos", "[", 
       FractionBox["x", "3"], "]"}], "+", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"2", " ", "x"}], "3"], "]"}]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     FractionBox["x", "6"], "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Das folgende Beispiel bereitete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vor Version 6 gro\[SZ]e Schwierigkeiten, weil der einfache Weg der \
Integration nicht gefunden wurde.  Relikte dieser \"Blindheit\" haben noch \
beim Ergebnis von ",
 StyleBox["TrigFactor",
  FontWeight->"Bold"],
 " auf diesem Ausdruck \[UDoubleDot]berlebt."
}], "SmallText",
 CellChangeTimes->{{3.35902079028381*^9, 3.35902084907129*^9}, {
  3.35902102263104*^9, 3.35902110030499*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"d3", "=", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"2", "x"}], "-", 
       FractionBox["\[Pi]", "6"]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       FractionBox["\[Pi]", "4"]}], "]"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"i3", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d3", ",", "x"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.35902085344425*^9, 3.35902085508933*^9}, {
   3.3590227181644*^9, 3.35902273380282*^9}, 3.388077222136884*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "10"]}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "12"], "+", 
     RowBox[{"5", " ", "x"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "12"], "-", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d3a", "=", 
  RowBox[{"d3", "//", "TrigReduce"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"d3a", ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{{3.35902210884183*^9, 3.35902216737781*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["\[Pi]", "12"], "-", "x"}], "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "12"], "+", 
      RowBox[{"5", " ", "x"}]}], "]"}]}], ")"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "10"]}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "12"], "+", 
     RowBox[{"5", " ", "x"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "12"], "-", "x"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"d3", "-", 
    RowBox[{"D", "[", 
     RowBox[{"i3", ",", "x"}], "]"}]}], "//", "tests"}]}]], "Input",
 CellChangeTimes->{
  3.35902090990497*^9, {3.35902270385838*^9, 3.35902274421138*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"\[ImaginaryI]", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "6"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"5", "/", "6"}]]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "12"], "-", "x"}], "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d3", "//", "TrigFactor"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"5", "/", "6"}]], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["\[Pi]", "12"], "-", "x"}], "]"}], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["\[Pi]", "12"], "+", "x"}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "12"], "-", "x"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "6"}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], ")"}], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"5", "/", "6"}]]}], ")"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Und nun noch einige Beispiele, die nicht im Buch besprochen sind.\
\>", "SmallText",
 CellChangeTimes->{{3359025456.8522, 3359025468.15545}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d4", "=", 
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"]]}], "\[IndentingNewLine]", 
 RowBox[{"i4", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d4", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"h4", "=", 
  RowBox[{"d4", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i4", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Sec", "[", "x", "]"}], "4"]], "Output"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "3"], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Tan", "[", "x", "]"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", "3"]}], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", "x", "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "4"]}], "3"], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h4", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Hier die Wirkung der 4 Simplifikationsbefehle, wenn auch andere \
Winkelfunktionen mit im Spiel sind.\
\>", "SmallText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i4", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"]}], ")"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "3"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "x"}], "]"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
     RowBox[{"Tan", "[", "x", "]"}]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "3"], "6"]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d5", "=", 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{"i5", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"d5", ",", "x"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"h5", "=", 
  RowBox[{"d5", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i5", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"Csc", "[", "x", "]"}], "2"], 
  RowBox[{"1", "-", 
   RowBox[{"Cos", "[", "x", "]"}]}]]], "Output"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], "+", 
   RowBox[{"Sin", "[", "x", "]"}]}], 
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]]], "Output"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox[
    RowBox[{"Csc", "[", "x", "]"}], "2"], 
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "x", "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], " ", 
       RowBox[{"Cot", "[", "x", "]"}]}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h5", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"], 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", "x", "]"}], "2"]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Cos", "[", "x", "]"}], "6"]}], "-", 
        RowBox[{
         FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Cos", "[", "x", "]"}], "6"]}], "+", 
        RowBox[{
         FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", "x", "]"}], "3"]}], "-", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", "x", "]"}], "3"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "24"]}], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        FractionBox[
         RowBox[{"Sin", "[", "x", "]"}], "24"]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "24"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        FractionBox[
         RowBox[{"Sin", "[", "x", "]"}], "24"]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "x"}], "]"}]}], "-", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "x"}], "]"}]}], "-", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "12"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "12"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "24"]}], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "24"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "24"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "24"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"12", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}]]}], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}]], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}], 
     RowBox[{"12", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"Cot", "[", "x", "]"}], " ", 
      RowBox[{"Csc", "[", "x", "]"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"], 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", "x", "]"}], "2"]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}]]}], ",", "0"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i5", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], " ", 
      RowBox[{"Cot", "[", "x", "]"}]}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"Cot", "[", "x", "]"}]}], "-", 
     RowBox[{"Csc", "[", "x", "]"}], "-", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      RowBox[{"Csc", "[", "x", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Cot", "[", "x", "]"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"Cot", "[", "x", "]"}]}], 
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"Csc", "[", "x", "]"}], 
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]]}], ",", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      FractionBox["x", "2"], "]"}], "3"], " ", 
    RowBox[{"Sec", "[", 
     FractionBox["x", "2"], "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d6", "=", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", "x"}], "]"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"Tan", "[", "x", "]"}]}], "+", "5"}], 
     ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{"i6", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"d6", ",", "x"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"h6", "=", 
  RowBox[{"d6", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i6", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"Csc", "[", 
   RowBox[{"2", " ", "x"}], "]"}], 
  RowBox[{"5", "+", 
   RowBox[{"3", " ", 
    RowBox[{"Tan", "[", "x", "]"}]}]}]]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "5"]}], " ", 
  RowBox[{"ArcTanh", "[", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"6", " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], "5"]}], "]"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Csc", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   RowBox[{"5", "+", 
    RowBox[{"3", " ", 
     RowBox[{"Tan", "[", "x", "]"}]}]}]], "+", 
  FractionBox[
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]}], 
   RowBox[{"25", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"6", " ", 
           RowBox[{"Tan", "[", "x", "]"}]}], "5"]}], ")"}], "2"]}], 
     ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h6", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i6", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "5"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"6", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}], "5"]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "5"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"6", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}], "5"]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "5"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"6", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}], "5"]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "5"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"6", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}], "5"]}], "]"}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{656, 622},
WindowMargins->{{Automatic, 292}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 90, 3, 121, "Title"],
Cell[CellGroupData[{
Cell[705, 30, 49, 0, 55, "Section"],
Cell[757, 32, 140, 2, 44, "Input"],
Cell[CellGroupData[{
Cell[922, 38, 57, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[1004, 42, 332, 10, 46, "Input"],
Cell[1339, 54, 196, 7, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1572, 66, 80, 2, 44, "Input"],
Cell[1655, 70, 243, 9, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1935, 84, 86, 2, 44, "Input"],
Cell[2024, 88, 290, 9, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2351, 102, 61, 1, 44, "Input"],
Cell[2415, 105, 406, 14, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2870, 125, 47, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[2942, 129, 295, 11, 69, "Input"],
Cell[3240, 142, 1804, 64, 124, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5081, 211, 57, 1, 44, "Input"],
Cell[5141, 214, 454, 17, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5632, 236, 57, 1, 44, "Input"],
Cell[5692, 239, 364, 13, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6093, 257, 198, 6, 46, "Input"],
Cell[6294, 265, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6359, 270, 411, 14, 52, "Input"],
Cell[6773, 286, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6838, 291, 236, 8, 46, "Input"],
Cell[7077, 301, 78, 2, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7204, 309, 67, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[7296, 313, 189, 6, 57, "Input"],
Cell[7488, 321, 367, 13, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7892, 339, 81, 2, 44, "Input"],
Cell[7976, 343, 414, 15, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8427, 363, 275, 9, 57, "Input"],
Cell[8705, 374, 429, 15, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9171, 394, 81, 2, 44, "Input"],
Cell[9255, 398, 400, 15, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9692, 418, 212, 4, 44, "Input"],
Cell[9907, 424, 397, 14, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10341, 443, 268, 8, 46, "Input"],
Cell[10612, 453, 235, 9, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10884, 467, 260, 9, 44, "Input"],
Cell[11147, 478, 117, 4, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11301, 487, 279, 6, 44, "Input"],
Cell[11583, 495, 31, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11663, 501, 78, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[11766, 505, 295, 9, 46, "Input"],
Cell[12064, 516, 198, 7, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12299, 528, 314, 10, 46, "Input"],
Cell[12616, 540, 259, 8, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12912, 553, 600, 17, 65, "Input"],
Cell[13515, 572, 5185, 90, 267, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18737, 667, 126, 4, 58, "Input"],
Cell[18866, 673, 75, 2, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18978, 680, 138, 4, 44, "Input"],
Cell[19119, 686, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19184, 691, 336, 10, 65, "Input"],
Cell[19523, 703, 1266, 26, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20826, 734, 99, 3, 44, "Input"],
Cell[20928, 739, 135, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21100, 747, 121, 3, 44, "Input"],
Cell[21224, 752, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21289, 757, 105, 3, 46, "Input"],
Cell[21397, 762, 63, 2, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21497, 769, 121, 3, 44, "Input"],
Cell[21621, 774, 57, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21715, 780, 122, 3, 44, "Input"],
Cell[21840, 785, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21905, 790, 195, 8, 48, "Input"],
Cell[22103, 800, 135, 6, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22275, 811, 378, 13, 44, "Input"],
Cell[22656, 826, 92, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22785, 834, 109, 3, 44, "Input"],
Cell[22897, 839, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22962, 844, 181, 7, 70, "Input"],
Cell[23146, 853, 138, 6, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23321, 864, 234, 8, 44, "Input"],
Cell[23558, 874, 129, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23724, 883, 179, 6, 44, "Input"],
Cell[23906, 891, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23971, 896, 272, 9, 44, "Input"],
Cell[24246, 907, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24311, 912, 319, 11, 46, "Input"],
Cell[24633, 925, 288, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24958, 940, 98, 3, 44, "Input"],
Cell[25059, 945, 76, 1, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25172, 951, 128, 4, 44, "Input"],
Cell[25303, 957, 28, 0, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25380, 963, 57, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[25462, 967, 344, 14, 69, "Input"],
Cell[25809, 983, 307, 13, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26153, 1001, 239, 9, 70, "Input"],
Cell[26395, 1012, 83, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26515, 1019, 240, 9, 70, "Input"],
Cell[26758, 1030, 83, 2, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26902, 1039, 85, 1, 55, "Section"],
Cell[26990, 1042, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[27091, 1047, 132, 1, 45, "Subsection"],
Cell[CellGroupData[{
Cell[27248, 1052, 293, 9, 46, "Input"],
Cell[27544, 1063, 248, 9, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27829, 1077, 123, 2, 44, "Input"],
Cell[27955, 1081, 1087, 34, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29079, 1120, 287, 10, 46, "Input"],
Cell[29369, 1132, 521, 18, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29927, 1155, 311, 11, 46, "Input"],
Cell[30241, 1168, 298, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30576, 1183, 198, 6, 46, "Input"],
Cell[30777, 1191, 422, 13, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31236, 1209, 351, 10, 65, "Input"],
Cell[31590, 1221, 284, 10, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31911, 1236, 318, 10, 65, "Input"],
Cell[32232, 1248, 357, 12, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32626, 1265, 253, 9, 52, "Input"],
Cell[32882, 1276, 327, 11, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33246, 1292, 256, 9, 52, "Input"],
Cell[33505, 1303, 345, 11, 48, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33899, 1320, 185, 3, 45, "Subsection"],
Cell[CellGroupData[{
Cell[34109, 1327, 630, 20, 52, "Input"],
Cell[34742, 1349, 872, 26, 68, "Output"]
}, Open  ]],
Cell[35629, 1378, 651, 15, 110, "SmallText"],
Cell[CellGroupData[{
Cell[36305, 1397, 171, 4, 44, "Input"],
Cell[36479, 1403, 947, 31, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37463, 1439, 145, 3, 44, "Input"],
Cell[37611, 1444, 160, 4, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37808, 1453, 117, 2, 44, "Input"],
Cell[37928, 1457, 29, 0, 44, "Output"]
}, Open  ]],
Cell[37972, 1460, 329, 8, 59, "SmallText"],
Cell[CellGroupData[{
Cell[38326, 1472, 396, 11, 44, "Input"],
Cell[38725, 1485, 1020, 33, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39782, 1523, 320, 9, 44, "Input"],
Cell[40105, 1534, 947, 31, 68, "Output"]
}, Open  ]],
Cell[41067, 1568, 408, 12, 59, "SmallText"],
Cell[CellGroupData[{
Cell[41500, 1584, 861, 23, 125, "Input"],
Cell[42364, 1609, 947, 31, 68, "Output"],
Cell[43314, 1642, 160, 4, 44, "Output"],
Cell[43477, 1648, 947, 31, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44461, 1684, 148, 3, 44, "Input"],
Cell[44612, 1689, 28, 0, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44677, 1694, 154, 3, 44, "Input"],
Cell[44834, 1699, 823, 26, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45694, 1730, 176, 4, 46, "Input"],
Cell[45873, 1736, 151, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46061, 1745, 161, 3, 44, "Input"],
Cell[46225, 1750, 150, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46412, 1760, 219, 5, 44, "Input"],
Cell[46634, 1767, 580, 18, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47251, 1790, 196, 5, 44, "Input"],
Cell[47450, 1797, 901, 30, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48388, 1832, 204, 5, 44, "Input"],
Cell[48595, 1839, 792, 24, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49424, 1868, 163, 3, 44, "Input"],
Cell[49590, 1873, 879, 29, 46, "Output"]
}, Open  ]],
Cell[50484, 1905, 334, 9, 59, "SmallText"],
Cell[CellGroupData[{
Cell[50843, 1918, 512, 14, 44, "Input"],
Cell[51358, 1934, 879, 29, 46, "Output"]
}, Open  ]],
Cell[52252, 1966, 191, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[52468, 1976, 285, 7, 44, "Input"],
Cell[52756, 1985, 901, 30, 46, "Output"]
}, Open  ]],
Cell[53672, 2018, 226, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[53923, 2028, 463, 14, 52, "Input"],
Cell[54389, 2044, 430, 13, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54856, 2062, 178, 4, 44, "Input"],
Cell[55037, 2068, 433, 14, 46, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55519, 2088, 100, 1, 45, "Subsection"],
Cell[CellGroupData[{
Cell[55644, 2093, 310, 9, 46, "Input"],
Cell[55957, 2104, 118, 4, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56112, 2113, 196, 5, 46, "Input"],
Cell[56311, 2120, 253, 9, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56601, 2134, 321, 9, 46, "Input"],
Cell[56925, 2145, 449, 16, 59, "Output"]
}, Open  ]],
Cell[57389, 2164, 324, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[57738, 2175, 120, 2, 44, "Input"],
Cell[57861, 2179, 392, 13, 58, "Output"]
}, Open  ]],
Cell[58268, 2195, 287, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[58580, 2206, 147, 3, 44, "Input"],
Cell[58730, 2211, 709, 24, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59476, 2240, 143, 3, 44, "Input"],
Cell[59622, 2245, 499, 16, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60158, 2266, 122, 2, 44, "Input"],
Cell[60283, 2270, 317, 11, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60637, 2286, 254, 7, 63, "Input"],
Cell[60894, 2295, 332, 13, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61263, 2313, 193, 5, 58, "Input"],
Cell[61459, 2320, 245, 9, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61741, 2334, 218, 5, 46, "Input"],
Cell[61962, 2341, 74, 2, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62073, 2348, 244, 6, 46, "Input"],
Cell[62320, 2356, 188, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62545, 2367, 278, 8, 52, "Input"],
Cell[62826, 2377, 312, 12, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63175, 2394, 294, 8, 52, "Input"],
Cell[63472, 2404, 112, 4, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63633, 2414, 56, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[63714, 2418, 106, 3, 56, "Input"],
Cell[63823, 2423, 95, 3, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63955, 2431, 367, 13, 64, "Input"],
Cell[64325, 2446, 273, 10, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64635, 2461, 262, 9, 59, "Input"],
Cell[64900, 2472, 356, 13, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65293, 2490, 243, 7, 63, "Input"],
Cell[65539, 2499, 619, 18, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66195, 2522, 382, 13, 65, "Input"],
Cell[66580, 2537, 247, 9, 46, "Output"]
}, Open  ]],
Cell[66842, 2549, 113, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[66980, 2556, 206, 7, 59, "Input"],
Cell[67189, 2565, 166, 6, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67392, 2576, 247, 8, 59, "Input"],
Cell[67642, 2586, 174, 6, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67853, 2597, 355, 12, 63, "Input"],
Cell[68211, 2611, 113, 4, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68361, 2620, 196, 7, 65, "Input"],
Cell[68560, 2629, 190, 7, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68787, 2641, 57, 1, 44, "Input"],
Cell[68847, 2644, 190, 7, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69074, 2656, 55, 1, 44, "Input"],
Cell[69132, 2659, 219, 8, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69388, 2672, 171, 6, 63, "Input"],
Cell[69562, 2680, 183, 7, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69782, 2692, 57, 1, 44, "Input"],
Cell[69842, 2695, 183, 7, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70062, 2707, 118, 2, 44, "Input"],
Cell[70183, 2711, 982, 28, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71202, 2744, 129, 4, 57, "Input"],
Cell[71334, 2750, 398, 15, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71769, 2770, 162, 5, 61, "Input"],
Cell[71934, 2777, 439, 15, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72410, 2797, 179, 6, 59, "Input"],
Cell[72592, 2805, 259, 10, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72888, 2820, 207, 7, 59, "Input"],
Cell[73098, 2829, 217, 8, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73352, 2842, 207, 7, 59, "Input"],
Cell[73562, 2851, 259, 10, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73858, 2866, 256, 9, 59, "Input"],
Cell[74117, 2877, 529, 20, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74683, 2902, 189, 6, 63, "Input"],
Cell[74875, 2910, 199, 6, 57, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75135, 2923, 47, 0, 55, "Section"],
Cell[75185, 2925, 76, 1, 44, "Input"],
Cell[CellGroupData[{
Cell[75286, 2930, 44, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[75355, 2934, 372, 12, 61, "Input"],
Cell[75730, 2948, 217, 6, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75984, 2959, 279, 7, 44, "Input"],
Cell[76266, 2968, 1073, 31, 63, "Output"]
}, Open  ]],
Cell[77354, 3002, 196, 4, 42, "SmallText"],
Cell[CellGroupData[{
Cell[77575, 3010, 285, 5, 44, "Input"],
Cell[77863, 3017, 927, 25, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78827, 3047, 194, 4, 44, "Input"],
Cell[79024, 3053, 1471, 42, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80532, 3100, 215, 4, 44, "Input"],
Cell[80750, 3106, 323, 11, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81110, 3122, 314, 6, 44, "Input"],
Cell[81427, 3130, 57, 1, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81533, 3137, 43, 0, 45, "Subsection"],
Cell[81579, 3139, 76, 1, 44, "Input"],
Cell[81658, 3142, 72, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[81755, 3147, 130, 3, 44, "Input"],
Cell[81888, 3152, 246, 7, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82171, 3164, 164, 5, 57, "Input"],
Cell[82338, 3171, 350, 13, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82725, 3189, 112, 3, 44, "Input"],
Cell[82840, 3194, 317, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83194, 3209, 200, 6, 46, "Input"],
Cell[83397, 3217, 543, 19, 62, "Output"]
}, Open  ]],
Cell[83955, 3239, 72, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[84052, 3244, 166, 4, 44, "Input"],
Cell[84221, 3250, 184, 5, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84442, 3260, 118, 3, 46, "Input"],
Cell[84563, 3265, 331, 11, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84931, 3281, 200, 6, 46, "Input"],
Cell[85134, 3289, 350, 12, 58, "Output"]
}, Open  ]],
Cell[85499, 3304, 72, 1, 42, "SmallText"],
Cell[CellGroupData[{
Cell[85596, 3309, 112, 3, 44, "Input"],
Cell[85711, 3314, 272, 9, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86020, 3328, 112, 3, 44, "Input"],
Cell[86135, 3333, 232, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86404, 3346, 250, 8, 57, "Input"],
Cell[86657, 3356, 147, 5, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86841, 3366, 197, 6, 44, "Input"],
Cell[87041, 3374, 1646, 55, 125, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88736, 3435, 55, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[88816, 3439, 652, 22, 65, "Input"],
Cell[89471, 3463, 311, 10, 44, "Output"],
Cell[89785, 3475, 311, 10, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90133, 3490, 164, 5, 44, "Input"],
Cell[90300, 3497, 632, 21, 44, "Output"]
}, Open  ]],
Cell[90947, 3521, 846, 15, 144, "SmallText"],
Cell[CellGroupData[{
Cell[91818, 3540, 232, 5, 44, "Input"],
Cell[92053, 3547, 97, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92187, 3554, 239, 6, 44, "Input"],
Cell[92429, 3562, 270, 9, 44, "Output"]
}, Open  ]],
Cell[92714, 3574, 809, 20, 110, "SmallText"],
Cell[CellGroupData[{
Cell[93548, 3598, 197, 6, 44, "Input"],
Cell[93748, 3606, 182, 5, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93967, 3616, 175, 5, 44, "Input"],
Cell[94145, 3623, 574, 17, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94756, 3645, 160, 5, 44, "Input"],
Cell[94919, 3652, 80, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95036, 3659, 1086, 38, 65, "Input"],
Cell[96125, 3699, 584, 21, 44, "Output"],
Cell[96712, 3722, 584, 21, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97333, 3748, 161, 5, 44, "Input"],
Cell[97497, 3755, 932, 29, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98466, 3789, 415, 14, 46, "Input"],
Cell[98884, 3805, 406, 14, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99327, 3824, 171, 5, 44, "Input"],
Cell[99501, 3831, 334, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99872, 3846, 114, 3, 44, "Input"],
Cell[99989, 3851, 311, 10, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100337, 3866, 55, 1, 44, "Input"],
Cell[100395, 3869, 532, 18, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100964, 3892, 108, 3, 44, "Input"],
Cell[101075, 3897, 307, 10, 44, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[101431, 3913, 36, 0, 45, "Subsection"],
Cell[101470, 3915, 240, 5, 59, "SmallText"],
Cell[101713, 3922, 269, 9, 44, "Input"],
Cell[101985, 3933, 226, 6, 42, "SmallText"],
Cell[CellGroupData[{
Cell[102236, 3943, 414, 13, 85, "Input"],
Cell[102653, 3958, 158, 5, 44, "Output"],
Cell[102814, 3965, 253, 9, 58, "Output"],
Cell[103070, 3976, 417, 15, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103524, 3996, 55, 1, 44, "Input"],
Cell[103582, 3999, 93, 2, 44, "Output"]
}, Open  ]],
Cell[103690, 4004, 316, 7, 59, "SmallText"],
Cell[CellGroupData[{
Cell[104031, 4015, 55, 1, 44, "Input"],
Cell[104089, 4018, 2055, 66, 119, "Output"]
}, Open  ]],
Cell[106159, 4087, 243, 7, 51, "SmallText"],
Cell[CellGroupData[{
Cell[106427, 4098, 420, 13, 98, "Input"],
Cell[106850, 4113, 154, 5, 56, "Output"],
Cell[107007, 4120, 252, 9, 58, "Output"],
Cell[107262, 4131, 435, 16, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107734, 4152, 134, 4, 58, "Input"],
Cell[107871, 4158, 307, 11, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108215, 4174, 136, 4, 58, "Input"],
Cell[108354, 4180, 502, 17, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108893, 4202, 55, 1, 44, "Input"],
Cell[108951, 4205, 93, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109081, 4212, 55, 1, 44, "Input"],
Cell[109139, 4215, 1620, 55, 128, "Output"]
}, Open  ]],
Cell[110774, 4273, 492, 12, 76, "SmallText"],
Cell[CellGroupData[{
Cell[111291, 4289, 583, 18, 79, "Input"],
Cell[111877, 4309, 357, 13, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112271, 4327, 239, 5, 65, "Input"],
Cell[112513, 4334, 344, 12, 58, "Output"],
Cell[112860, 4348, 357, 13, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113254, 4366, 242, 7, 44, "Input"],
Cell[113499, 4375, 969, 32, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114505, 4412, 60, 1, 44, "Input"],
Cell[114568, 4415, 1144, 40, 79, "Output"]
}, Open  ]],
Cell[115727, 4458, 151, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[115903, 4465, 395, 11, 123, "Input"],
Cell[116301, 4478, 81, 2, 46, "Output"],
Cell[116385, 4482, 270, 9, 59, "Output"],
Cell[116658, 4493, 455, 16, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117150, 4514, 55, 1, 44, "Input"],
Cell[117208, 4517, 93, 2, 44, "Output"]
}, Open  ]],
Cell[117316, 4522, 130, 3, 42, "SmallText"],
Cell[CellGroupData[{
Cell[117471, 4529, 55, 1, 44, "Input"],
Cell[117529, 4532, 1285, 42, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118851, 4579, 515, 17, 103, "Input"],
Cell[119369, 4598, 157, 5, 64, "Output"],
Cell[119529, 4605, 415, 15, 61, "Output"],
Cell[119947, 4622, 1156, 41, 104, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121140, 4668, 55, 1, 44, "Input"],
Cell[121198, 4671, 8528, 281, 462, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129763, 4957, 55, 1, 44, "Input"],
Cell[129821, 4960, 2314, 79, 135, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132172, 5044, 538, 19, 102, "Input"],
Cell[132713, 5065, 181, 6, 61, "Output"],
Cell[132897, 5073, 231, 8, 59, "Output"],
Cell[133131, 5083, 578, 21, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133746, 5109, 55, 1, 44, "Input"],
Cell[133804, 5112, 93, 2, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133934, 5119, 55, 1, 44, "Input"],
Cell[133992, 5122, 969, 34, 95, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
