(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47762,       1512]
NotebookOptionsPosition[     42528,       1365]
NotebookOutlinePosition[     42938,       1383]
CellTagsIndexPosition[     42895,       1380]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Mit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " durchs Abitur"
}], "Title",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, 
   3.382549020869715*^9}],

Cell[CellGroupData[{

Cell["Fl\[ADoubleDot]chenst\[UDoubleDot]ck unter einer Kurve", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
   3.36386547274861*^9, 3.36386547931836*^9}, 3.3892697548078*^9}],

Cell[TextData[{
 StyleBox["Aufgabe:",
  FontWeight->"Bold",
  Background->None],
 StyleBox["\nGegeben ist f\[UDoubleDot]r ",
  Background->None],
 StyleBox["x>0", "InlineFormula",
  Background->None],
 StyleBox[" die Funktion ",
  Background->None],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "=", 
    RowBox[{
     FractionBox["x", "8"], "+", 
     FractionBox["2", "x"]}]}], TraditionalForm]],
  Background->None],
 StyleBox[".  Zeichnen Sie den Graphen der Kurve.\n\nIn die \
Fl\[ADoubleDot]che zwischen Kurve und ",
  Background->None],
 StyleBox["x",
  FontSlant->"Italic",
  Background->None],
 StyleBox["-Achse ist ein Streifen mit der Breite 3 parallel zur ",
  Background->None],
 StyleBox["y",
  FontSlant->"Italic",
  Background->None],
 StyleBox["-Achse so einzuf\[UDoubleDot]gen, dass seine Fl\[ADoubleDot]che m\
\[ODoubleDot]glichst klein wird.  Berechnen Sie den Ort der beiden Parallelen \
und die resultierende minimale Fl\[ADoubleDot]che.",
  Background->None]
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
  3363862474.58663}},
 Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   FractionBox["x", "8"], "+", 
   FractionBox["2", "x"]}]}]}], "Input",
 CellChangeTimes->{{3.36386275289306*^9, 3.36386278855872*^9}, 
   3.3638634205039*^9}],

Cell[TextData[{
 "Um ein Bild der Situation mit ",
 StyleBox["Plot",
  FontWeight->"Bold"],
 ", ",
 StyleBox["FillingStyle",
  FontWeight->"Bold"],
 " und verschiedenen Streifen erstellen, definieren wir die folgende \
Funktion. Sie erzeugt den Plot zweier Funktionen, die in der Komposition \
genau das gew\[UDoubleDot]nschte Bild ergeben. Mit den ",
 StyleBox["Filling",
  FontWeight->"Bold"],
 "-Optionen wird genau die Fl\[ADoubleDot]che zwischen den beiden Kurven gef\
\[ADoubleDot]rbt. ",
 StyleBox["PlotRange",
  FontWeight->"Bold"],
 " fixiert den Wertebereich auf einen f\[UDoubleDot]r unsere Zwecke \
sinnvollen Bereich."
}], "SmallText",
 CellChangeTimes->{{3.3638627985965*^9, 3.36386282164846*^9}, {
  3.36386285412745*^9, 3.36386294089008*^9}, {3.36386446004901*^9, 
  3.36386452998521*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fplot", "[", "u_", "]"}], ":=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"u", "<", "x", "<", 
           RowBox[{"u", "+", "3"}]}]}], "}"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "11"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Filling", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", "->", "Axis"}], "}"}]}], ",", 
    RowBox[{"FillingStyle", "\[Rule]", "Blue"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"fplot", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.36386335920881*^9, 3.36386336549634*^9}, {
  3.36386410227139*^9, 3.3638641044319*^9}, {3.36386423091527*^9, 
  3.36386423179518*^9}, {3.3638745350115*^9, 3.3638745362204*^9}, {
  3.36387458244652*^9, 3.3638745825871*^9}, {3.389267313923936*^9, 
  3.389267315894378*^9}, {3.389267756451784*^9, 3.38926777334513*^9}}],

Cell[TextData[{
 "Und so l\[ADoubleDot]sst sich daraus in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 eine Animation erstellen."
}], "SmallText",
 CellChangeTimes->{{3.3638645513526*^9, 3.36386457326146*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Animate", "[", 
   RowBox[{
    RowBox[{"fplot", "[", "u", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", ".4", ",", "7", ",", ".2"}], "}"}], ",", 
    RowBox[{"AnimationDirection", "->", "ForwardBackward"}], ",", 
    RowBox[{"DefaultDuration", "->", "10"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{
  3.36386295058063*^9, {3.36386367728297*^9, 3.36386368064519*^9}, {
   3.389267969648497*^9, 3.38926800365616*^9}, {3.389268079351522*^9, 
   3.389268148880269*^9}, {3.389268286836191*^9, 3.389268301541723*^9}, {
   3.389268352145183*^9, 3.389268353136092*^9}, 3.389268745582872*^9, {
   3.389268805596921*^9, 3.389268818397526*^9}, {3.389268864230448*^9, 
   3.389268871836586*^9}, {3.389268904576973*^9, 3.389268905992477*^9}}],

Cell[TextData[{
 "Die eigentliche Aufgabenstellung l\[ADoubleDot]sst sich mit folgendem \
\"Gewalt\"-Ansatz l\[ODoubleDot]sen: Berechne den Fl\[ADoubleDot]cheninhalt \
",
 StyleBox["A[u]=", "InlineFormula"],
 StyleBox[Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "u", 
    RowBox[{"u", "+", "3"}]], 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]], "InlineFormula",
  PageWidth->Infinity,
  CellChangeTimes->{{3.36386464148139*^9, 3.36386471991508*^9}}], 
  "InlineFormula"],
 " der zu untersuchenden Figur in Abh\[ADoubleDot]ngigkeit von der Abszisse \
",
 StyleBox["u",
  FontSlant->"Italic"],
 " der linken unteren Ecke",
 StyleBox[",", "InlineFormula"],
 " bestimme die Nullstellen der Ableitung von A[u] und \[UDoubleDot]berpr\
\[UDoubleDot]fe die \[UDoubleDot]blichen Extremwert-Konditionen."
}], "SmallText",
 CellChangeTimes->{{3.36386459301252*^9, 3.36386460237623*^9}, {
  3.36386473671622*^9, 3.36386489025762*^9}, {3.36386515570267*^9, 
  3.36386516280051*^9}, {3.36386520263879*^9, 3.3638652201742*^9}, {
  3.36387499163744*^9, 3.36387499271618*^9}, {3.36387504092772*^9, 
  3.36387504897587*^9}, {3.36387513691539*^9, 3.36387513757526*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", "u_", "]"}], "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{"u", ">", "0"}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "u", 
      RowBox[{"u", "+", "3"}]], 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "]"}], " "}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386464148139*^9, 3.36386471991508*^9}, {
   3.36386494634054*^9, 3.36386498750683*^9}, 3.36386504057542*^9}],

Cell[TextData[{
 "Die Eingabe kann nat\[UDoubleDot]rlich auch in der eindinemsionalen \
Input-Notation als ",
 StyleBox["Integrate[f[x],{x,u,u+3}] ",
  FontWeight->"Bold"],
 "erfolgen. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 muss die zus\[ADoubleDot]tzliche ",
 StyleBox["Assuming",
  FontWeight->"Bold"],
 "-Konstruktion verwendet werden, weil das CAS \"zu schlau\" ist und uns erz\
\[ADoubleDot]hlt, dass f\[UDoubleDot]r irgendwelche komplexe Werte von ",
 StyleBox["u",
  FontSlant->"Italic"],
 " B\[ODoubleDot]ses passieren kann."
}], "SmallText",
 CellChangeTimes->{{3.36386499531742*^9, 3.36386512926002*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "u", ",", 
     RowBox[{"u", "+", "3"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"dflaeche", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"A", "[", "u", "]"}], ",", "u"}], "]"}], "//", 
   "Together"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386492509093*^9, 3.36386493258472*^9}, {
  3.36386523374757*^9, 3.36386525682038*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"dflaeche", "\[Equal]", "0"}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386526798291*^9, 3.36386526855388*^9}, 
   3.389275061817372*^9}],

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.3638652768406*^9, 3.36386528037186*^9}}],

Cell["\<\
Nur die positive L\[ODoubleDot]sung ist f\[UDoubleDot]r die Aufgabenstellung \
relevant. Fassen wir zum Schluss noch alle zu berechnenden St\[UDoubleDot]cke \
in einer Liste zusammen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"A", "[", "u", "]"}]}], "}"}], "/.", 
   RowBox[{"sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "N"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386529661573*^9, 3.36386530083447*^9}, {
  3.36387578743021*^9, 3.36387579518097*^9}, {3.389273355387271*^9, 
  3.389273364217235*^9}}],

Cell["\<\
Eine einfachere mathematische L\[ODoubleDot]sung (warum?) geht so:\
\>", "SmallText",
 CellChangeTimes->{{3.36386533670555*^9, 3.36386535801878*^9}, {
  3.36386541635483*^9, 3.36386541942881*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"u", "+", "3"}], "]"}], "-", 
      RowBox[{"f", "[", "u", "]"}]}], "\[Equal]", "0"}], ",", "u"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36386536159901*^9, 3.36386540500043*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eine Eliminationsaufgabe", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36387990206389*^9, 3.36387990670122*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:",
  FontWeight->"Bold",
  Background->None],
 StyleBox["\n",
  Background->None],
 "Bringen Sie die in Parameterform gegebene Funktion (",
 StyleBox["x,y) = (2Cos[t],Cos[3t])", "InlineFormula"],
 " in explizite Form und zeichnen Sie den Graphen.  \nBestimmen Sie den \
Inhalt der Fl\[ADoubleDot]chenst\[UDoubleDot]cke, die zwischen der Kurve und \
der ",
 StyleBox["x",
  FontSlant->"Italic"],
 "-Achse eingeschlossen werden."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
  3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369, 
  3363865693.92767}, {3363879913.55481, 3363879926.325}},
 Background->RGBColor[1, 1, 0]],

Cell["Auch hier erzeugen wir uns erst einmal ein Bild.", "SmallText",
 CellChangeTimes->{{3363865715.8457, 3363865727.70661}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", " ", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386571111207*^9, 3.3638657448007*^9}}],

Cell[TextData[{
 "Zur L\[ODoubleDot]sung einer Eliminationsaufgabe bietet sich das Kommando \
",
 StyleBox["Eliminate",
  FontWeight->"Bold"],
 " an. \nWichtig: bei Eliminate muss ",
 "\[Equal]",
 " und nicht = verwendet werden; trotzdem ist das Ergebnis nicht das, was wir \
wollten."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3.36386576363678*^9, 3.36386582056789*^9}, {
   3.36386592018833*^9, 3.3638659363723*^9}, 3.389275062148157*^9}],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "t"}], "]"}]}]}], "}"}], ",", "t"}], "]"}]], "Input",\

 PageWidth->Infinity,
 CellChangeTimes->{{3.36388044464927*^9, 3.36388044517216*^9}, {
  3.389275062346017*^9, 3.38927506235256*^9}}],

Cell[TextData[{
 "Dabei hat ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " genau das gemacht, was wir gefordert haben: beide Gleichungen nach ",
 StyleBox["t",
  FontSlant->"Italic"],
 " aufgel\[ODoubleDot]st und gleichgesetzt. Wir wollten aber eigentlich \
Cos[t] eliminiert haben."
}], "SmallText",
 CellChangeTimes->{{3.36386583244242*^9, 3.36386586964976*^9}, {
  3.36386594180275*^9, 3.36386598903175*^9}, {3.36386604721006*^9, 
  3.36386608119989*^9}}],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "t"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"Cos", "[", "t", "]"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.3638660142993*^9, 3.3638660219792*^9}, {
  3.3638804493683*^9, 3.36388044967379*^9}, {3.389275062360644*^9, 
  3.389275062366828*^9}}],

Cell[TextData[{
 "Das ging leider auch daneben: ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " wei\[SZ] von sich aus nicht, dass Cos[3t] auch was mit Cos[t] zu tun hat."
}], "SmallText",
 CellChangeTimes->{{3.36386608474984*^9, 3.3638661626113*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"3", " ", "t"}], "]"}], "//", "TrigExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x_", "]"}], "2"], "->", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"y0", "=", 
  RowBox[{"%", "//", "Expand"}]}]], "Input",
 CellChangeTimes->{{3.36388177719429*^9, 3.36388177818664*^9}}],

Cell["\<\
Mit der so umgeformten rechten Seite der Bestimmungsgleichung f\[UDoubleDot]r \
y und Elimination nach Cos[t] statt t gelingt nun die Elimination.\
\>", "SmallText",
 CellChangeTimes->{{3.36386619150412*^9, 3.36386619422038*^9}}],

Cell[BoxData[
 RowBox[{"gl", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
      RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", 
    RowBox[{"Cos", "[", "t", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389275062375588*^9, 3.389275062381796*^9}}],

Cell["\<\
Auch bei Elimination nach t erhalten wir dasselbe Ergebnis, weil die \
Gleichungen polynomial im einzigen Kern Cos[t] sind. Einzig eine zus\
\[ADoubleDot]tzliche Warnung wird ausgegeben.\
\>", "SmallText",
 CellChangeTimes->{{3.382505638611945*^9, 3.3825057323002*^9}, {
  3.38250589900014*^9, 3.382505947142995*^9}}],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.38927506238969*^9, 3.389275062395759*^9}}],

Cell[TextData[{
 StyleBox["Reduce ",
  FontWeight->"Bold"],
 "liefert die L\[ODoubleDot]sung der Aufgabe, in einige \
zus\[ADoubleDot]tzliche Terme eingebettet, \[UDoubleDot]brigens ohne \
vorbereitende Umformungen."
}], "SmallText",
 CellChangeTimes->{{3.382505964631394*^9, 3.382506041886047*^9}, {
   3.382506091824419*^9, 3.382506094348392*^9}, {3.389276313618008*^9, 
   3.389276322077959*^9}, {3.3892763531882*^9, 3.389276424469975*^9}, 
   3.389276534225356*^9}],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Cos", "[", 
        RowBox[{"3", "t"}], "]"}]}]}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.382505773779188*^9, 3.382505775508621*^9}, {3.382505808959411*^9, 
  3.382505840183094*^9}, {3.389275062403639*^9, 3.389275062409658*^9}, {
  3.389276180794036*^9, 3.38927619886934*^9}, {3.38927790133823*^9, 
  3.389277904665092*^9}}],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.382505773779188*^9, 3.382505775508621*^9}, {3.382505808959411*^9, 
  3.382505840183094*^9}, {3.389275062403639*^9, 3.389275062409658*^9}}],

Cell[TextData[{
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " mit Cos[t] als Eliminationsziel stellt x in Abh\[ADoubleDot]ngigkeit von y \
als ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdruck dar. y muss mit in die Liste der Variablen aufgenommen werden, \
nach denen aufgel\[ODoubleDot]st wird, um y durch x auszudr\[UDoubleDot]cken \
und zu obigem Ergebnis zu gelangen. "
}], "SmallText",
 CellChangeTimes->{{3.382506099884212*^9, 3.382506209312404*^9}}],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"y", "\[Equal]", "y0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"Cos", "[", "t", "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36388178976203*^9, 3.36388179915786*^9}, {
  3.382505773779188*^9, 3.382505775508621*^9}, {3.382505808959411*^9, 
  3.382505811365045*^9}, {3.382505857057821*^9, 3.382505861720855*^9}, {
  3.38927506241803*^9, 3.389275062424254*^9}, {3.38927878525541*^9, 
  3.389278804054683*^9}}],

Cell["\<\
Nun verwandeln wir die Gleichung in einen expliziten Funktionszusammenhang \
y=y(x)\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"gl", ",", "y"}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.382506231056918*^9, 3.382506232752561*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "x_", "]"}], "=", 
   RowBox[{"y", "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}],
   ";"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.36386624626444*^9, 3.36386627810723*^9, 3.3638663669547*^9, {
   3.3638825095702*^9, 3.36388251415049*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.36386625600973*^9}],

Cell[TextData[{
 "Als Wertebereich f\[UDoubleDot]r ",
 StyleBox["x",
  FontSlant->"Italic"],
 " wurde der gleiche Bereich wie oben im ersten Plot verwendet. Die \
Schnittpunkte mit den Achsen ergeben sich als "
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3.36386656527568*^9, 3.36386661178261*^9}, {
  3.36386664800726*^9, 3.36386666174014*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.389275062448979*^9}],

Cell["\<\
und die gesuchte Fl\[ADoubleDot]che (beachten Sie die Vorzeichenregeln) zu\
\>", "SmallText",
 CellChangeTimes->{{3.36386668289751*^9, 3.36386671496544*^9}, {
  3.36386674597703*^9, 3.36386674938859*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", 
     SqrtBox["3"]}], "0"], 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 PageWidth->Infinity]
}, Closed]],

Cell[CellGroupData[{

Cell["Komplexe Wurzeln", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36386676316605*^9, 3.36386676782471*^9}, {3.36386875230835*^9, 
  3.36386875783081*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:",
  FontWeight->"Bold",
  Background->None],
 StyleBox["\n",
  Background->None],
 "L\[ODoubleDot]sen Sie die Gleichung ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "3"], "=", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"4", " ", "\[ImaginaryI]"}]}], ")"}], "5"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "-", 
        RowBox[{"3", "\[ImaginaryI]"}]}], ")"}], "2"]]}], TraditionalForm]]],
 " im Bereich der komplexen Zahlen und stellen Sie die L\[ODoubleDot]sungen \
in der Gau\[SZ]schen Zahlenebene grafisch dar."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
  3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369, 
  3363865693.92767}, {3363868776.11101, 3363868889.87804}, {3363868987.67785, 
  3363868988.94409}},
 Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["z", "3"], "\[Equal]", " ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"4", "I"}]}], ")"}], "5"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"3", "I"}]}], ")"}], "2"]]}], ",", "z"}], "]"}]}]}], "Input",\

 CellChangeTimes->{3.36386911163634*^9}],

Cell[TextData[{
 "Das Ergebnis sollte in der Form",
 StyleBox[" ", "InlineFormula"],
 Cell[BoxData[
  RowBox[{"a", " ", "+", " ", 
   RowBox[{
    SuperscriptBox["b", "2"], "\[ImaginaryI]"}]}]]],
 " ausgegeben werden."
}], "SmallText",
 CellChangeTimes->{3.36386912950609*^9}],

Cell[BoxData[
 RowBox[{"lsg", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Auch ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " f\[UDoubleDot]hrt zu keinem besseren Ergebnis."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"lsg", "//", "RootReduce"}]], "Input"],

Cell[TextData[{
 "Die beiden anderen Wurzeln sind algebraische Zahlen vom Grad 4. Mit der \
Root-Notation kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " besser rechnen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{"z", "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "//",
    "RootReduce"}]}]], "Input"],

Cell[TextData[{
 "Wir extrahieren das Minimalpolynom und bestimmen dessen Nullstellen. Zwei \
davon sind die nicht identifizierten Elemente aus ",
 StyleBox["lsg",
  FontSlant->"Italic"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "[", 
   "z", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"lsg1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", "z"}], "]"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["z", "3"], "/.", "lsg1"}], "//", "Expand"}]], "Input"],

Cell[TextData[{
 "Wir transformieren ",
 StyleBox["lsg",
  FontSlant->"Italic"],
 " in numerische N\[ADoubleDot]herungswerte, um ein Bild zu erstellen. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"nlsg", "=", 
  RowBox[{"N", "[", "lsg", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"lst", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], ",", 
     RowBox[{"Im", "[", "z", "]"}]}], "}"}], " ", "/.", "nlsg"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"lst", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.04", "]"}]}], ",", " ", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6"}], ",", "6"}], "}"}]}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.36386926480238*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eine Extremwertaufgabe", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36386676316605*^9, 3.36386676782471*^9}, {3.36388357638755*^9, 
  3.36388358883075*^9}, {3.36388389001981*^9, 3.36388389423147*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:\n",
  FontWeight->"Bold",
  Background->None],
 StyleBox["Der Ellipse",
  Background->None],
 StyleBox[" ",
  FontWeight->"Bold",
  Background->None],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"9", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"16", 
     SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]]],
 " soll ein Rechteck maximaler Fl\[ADoubleDot]che einbeschrieben werden, \
dessen Seiten parallel zu den Koordinatenachsen sind.\n\nBestimmen Sie\na) \
die Abmessungen dieses Rechtecks und\nb) das Volumen des Ellipsoids und des \
Zylinders, die bei Drehung dieser Figueren um die ",
 StyleBox["x",
  FontSlant->"Italic"],
 "-Achse entstehen. "
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
   3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369,
    3363865693.92767}, {3363869342.87972, 3363869472.10979}, 
   3363884017.64136, {3363884104.60001, 3363884264.8706}},
 Background->RGBColor[1, 1, 0]],

Cell["Ein Bild der Situation erstellen. Die Ellipse:", "SmallText"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{"ellipse", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"9", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"16", 
     SuperscriptBox["y", "2"]}]}], "\[Equal]", "144"}]}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386221101731*^9, 3.36386221393524*^9}, {
  3.36386949443442*^9, 3.36386949724216*^9}, {3.381908517689234*^9, 
  3.381908531351125*^9}, {3.381908565193753*^9, 3.381908782525855*^9}}],

Cell["\<\
Die Ellipse kann nun mit ContourPlot gezeichnet werden. Die \
Standardeinstellungen (mit Frame, ohne Achsen, nicht \
ma\[SZ]st\[ADoubleDot]blich) sind ge\[ADoubleDot]ndert.\
\>", "SmallText",
 CellChangeTimes->{{3.381908789864228*^9, 3.381908878878545*^9}}],

Cell[BoxData[
 RowBox[{"e1", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", "ellipse", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "False"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36386221101731*^9, 3.36386221393524*^9}, {
  3.36386949443442*^9, 3.36386949724216*^9}, {3.381908517689234*^9, 
  3.381908531351125*^9}, {3.381908565193753*^9, 3.381908782525855*^9}, {
  3.381908836747103*^9, 3.381908842116796*^9}, {3.381909332230506*^9, 
  3.381909340706379*^9}, {3.389284627895886*^9, 3.389284663712778*^9}, {
  3.389285150583336*^9, 3.389285167785092*^9}}],

Cell[TextData[{
 "Berechnung der Eckpunkte ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[PlusMinus]", 
     SubscriptBox["x", "0"]}], ",", 
    RowBox[{"\[PlusMinus]", 
     SubscriptBox["y", "0"]}]}], ")"}]]],
 " des einbeschriebenen Rechtecks bei vogegebenem ",
 Cell[BoxData[
  SubscriptBox["x", "0"]]],
 ":"
}], "SmallText",
 CellChangeTimes->{3.36386950773648*^9}],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"ellipse", ",", "y"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["y", "0"], "=", 
  RowBox[{
   RowBox[{"y", "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    
   RowBox[{"x", "\[Rule]", 
    SubscriptBox["x", "0"]}]}]}]], "Input"],

Cell[TextData[{
 "Beachten Sie, dass ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "0"], TraditionalForm]]],
 " keine Funktion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "0"], "[", 
    SubscriptBox["x", "0"], "]"}], TraditionalForm]]],
 ", sondern ein Ausdruck ist, welcher die Variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "0"], " "}], TraditionalForm]]],
 "enth\[ADoubleDot]lt. Diese kann durch ein Subsitutionskommando belegt \
werden. \nAlles in einer gemeinsamen Grafik darstellen ..."
}], "SmallText",
 CellChangeTimes->{{3.3638695356302*^9, 3.36386959467424*^9}, {
  3.36418594053497*^9, 3.36418595599481*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rechteck", " ", "=", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        SubscriptBox["y", "0"]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "0"]}], ",", 
        SubscriptBox["y", "0"]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "0"]}], ",", 
        RowBox[{"-", 
         SubscriptBox["y", "0"]}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        RowBox[{"-", 
         SubscriptBox["y", "0"]}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        SubscriptBox["y", "0"]}], "}"}]}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"e1", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"rechteck", "/.", 
     RowBox[{
      SubscriptBox["x", "0"], "\[Rule]", "1.6"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"rechteck", "/.", 
     RowBox[{
      SubscriptBox["x", "0"], "\[Rule]", "3.2"}]}], "]"}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.36386952894811*^9, 3.36386953158946*^9}}],

Cell["... oder eine Animation erstellen:", "SmallText",
 CellChangeTimes->{{3.36386960005296*^9, 3.36386961122463*^9}}],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"e1", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"rechteck", "/.", 
       RowBox[{
        SubscriptBox["x", "0"], "\[Rule]", "u"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.3", ",", "3.8", ",", "0.2"}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.36386963136962*^9, 3.3638696782911*^9}}],

Cell["\<\
Und nun die analytische L\[ODoubleDot]sung der Aufgabe a). \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"flaeche", "=", 
  RowBox[{
   RowBox[{"4", "x", " ", "y"}], "/.", 
   RowBox[{
   "lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"extrema", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"flaeche", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36418709582577*^9, 3.36418709855537*^9}}],

Cell[BoxData[
 RowBox[{"flaeche", "/.", 
  RowBox[{
  "extrema", "\[LeftDoubleBracket]", "2", 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.36418710250986*^9, 3.36418710481768*^9}}],

Cell["\<\
Jetzt beginnt der zweite Rechenabschnitt - die Berechnung der Volumens des \
Rotationsellipsoids und des Zylinders.
Die Begrenzungskurve\
\>", "SmallText",
 Evaluatable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["f", "1"], "[", "x_", "]"}], "=", 
  RowBox[{"y", "/.", 
   RowBox[{
   "lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell["Die Grenzen ", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"ellipse", "/.", 
    RowBox[{"y", "\[Rule]", "0"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ellipsoidVolumen", "=", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{
    UnderoverscriptBox["\[Integral]", 
     RowBox[{"-", "4"}], "4"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SubscriptBox["f", "1"], "[", "x", "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"zylinderVolumen", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "\[Pi]", " ", "x", " ", 
     SuperscriptBox["y", "2"]}], "/.", 
    RowBox[{"lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    
   RowBox[{
   "extrema", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.36418711911802*^9, 3.36418712163934*^9}, {
  3.36418719291803*^9, 3.36418723047086*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Analytische Geometrie", "Section",
 CellChangeTimes->{{3.3638622013478*^9, 3.36386220573919*^9}, {
  3.36386676316605*^9, 3.36386676782471*^9}, {3.36388357638755*^9, 
  3.36388358883075*^9}, {3.36388389001981*^9, 3.36388389423147*^9}, {
  3.36418487488781*^9, 3.36418487847423*^9}}],

Cell[TextData[{
 StyleBox["Aufgabe:\n",
  FontWeight->"Bold",
  Background->None],
 "Der Kreis ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"6", "y"}], "-", "91"}], "\[Equal]", "0"}], TraditionalForm]]],
 " und die Kurve ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", "b"}]}], TraditionalForm]]],
 " schneiden einander in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", "(", 
     RowBox[{"6", ";", "y"}], ")"}], ",", " ", 
    RowBox[{"y", ">", "0"}], ","}], TraditionalForm]]],
 " unter einem Winkel von 90 Grad.\n\na) Berechnen Sie ",
 StyleBox["a",
  FontSlant->"Italic"],
 " und ",
 StyleBox["b",
  FontSlant->"Italic"],
 ".\nb) Die Schnittfl\[ADoubleDot]che der beiden Kurven rotiert um die ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-Achse.  \nBerechnen Sie das Volumen des entstehenden Rotationsk\
\[ODoubleDot]rpers."
}], "SmallText",
 Evaluatable->False,
 CellChangeTimes->{{3363862216.43191, 3363862221.64341}, {3363862273.71604, 
   3363862474.58663}, {3363865577.87094, 3363865626.16818}, {3363865680.72369,
    3363865693.92767}, {3363869342.87972, 3363869472.10979}, 
   3363884017.64136, {3363884104.60001, 3363884264.8706}, {3364184972.02352, 
   3364185124.88087}},
 Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"kreis", "=", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       RowBox[{"6", "y"}], "-", "91"}], "\[Equal]", "0"}]}], ",", "y"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.36418817394384*^9, 3.36418817498613*^9}, 
   3.389275062793047*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], "=", 
  RowBox[{"y", "/.", 
   RowBox[{
   "lsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[TextData[{
 "Die Koordinaten des Punktes ",
 StyleBox["P",
  FontSlant->"Italic"],
 " ergeben sich nun durch Einsetzen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"f1", "[", "6", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}], "+", "b"}]}]], "Input"],

Cell[TextData[{
 "Die beiden Parameter ",
 StyleBox["a",
  FontSlant->"Italic"],
 " und ",
 StyleBox["b",
  FontSlant->"Italic"],
 " ergeben sich aus den Bedingungen ",
 StyleBox["f1[6]\[Equal]f[6] ", "InlineFormula"],
 "(beide Kurven gehen durch ",
 StyleBox["P",
  FontSlant->"Italic"],
 ") und f1'[6]\[CenterDot]f'[6]\[Equal]",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]]],
 " (beide Kurven stehen in ",
 StyleBox["P",
  FontSlant->"Italic"],
 " aufeinander senkrecht)."
}], "SmallText",
 CellChangeTimes->{{3.36418514789761*^9, 3.36418520407457*^9}, {
  3.3641852343762*^9, 3.3641852834606*^9}}],

Cell[BoxData[
 RowBox[{"sys", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "6", "]"}], "\[Equal]", 
     RowBox[{"f", "[", "6", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f1", "'"}], "[", "6", "]"}], "*", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "6", "]"}]}], "\[Equal]", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.389275062888217*^9, 3.389275062894715*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "/.", 
   RowBox[{
   "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "[", "x", "]"}], ",", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36418532509027*^9, {3.36418849027501*^9, 3.36418850997932*^9}}],

Cell[TextData[{
 "Berechnung des Volumens des K\[ODoubleDot]rpers, der sich aus der Rotation \
der gemeinsamen Fl\[ADoubleDot]chenanteile um die ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-Achse ergibt (nach der Formel ",
 Cell[BoxData[
  FormBox[
   RowBox[{"V", "=", 
    RowBox[{"\[Pi]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", "[", "y", "]"}], "2"], 
       RowBox[{"\[DifferentialD]", "y"}]}]}]}]}], TraditionalForm]]],
 "). Die Integrationsgrenzen sind jeweils 5 und f1[0] bzw. f2[0] und 5.\n",
 "\n",
 "Aus der Kreisgleichung wird dazu zun\[ADoubleDot]chst die Umkehrfunktion \
g1[y] extrahiert"
}], "SmallText",
 CellChangeTimes->{{3.36418856724299*^9, 3.36418857596674*^9}}],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"kreis", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36418857902082*^9, 3.36418857965674*^9}, 
   3.36418893906933*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "[", "y_", "]"}], "=", 
  RowBox[{"x", "/.", " ", 
   RowBox[{
   "sol1", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.36418858328468*^9, 3.3641885845029*^9}, 
   3.36418894048644*^9}],

Cell["\<\
Der erste Teil des Volumenintegrals ergibt sich dann als Integral \
\[UDoubleDot]ber g1 von y=5 bis y=f1[0], dem y-Wert des Schnittpunkts des \
Kreises mit der Ordinatenachse.\
\>", "SmallText",
 CellChangeTimes->{{3.36418862517853*^9, 3.36418877560342*^9}}],

Cell[BoxData[
 RowBox[{"vol1", "=", 
  RowBox[{"\[Pi]", 
   RowBox[{
    UnderoverscriptBox["\[Integral]", "5", 
     RowBox[{"f1", "[", "0", "]"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"g1", "[", "y", "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]], "Input"],

Cell["\<\
Analog ergibt sich das zweite Teilvolumen und das Gesamtvolumen als Summe \
beider.\
\>", "SmallText",
 CellChangeTimes->{{3.36418897179539*^9, 3.36418900084568*^9}}],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"f2", "[", "x", "]"}]}], " ", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36418894958666*^9, 3.36418895044425*^9}, 
   3.389275062908545*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", "[", "y_", "]"}], "=", 
  RowBox[{"x", "/.", " ", 
   RowBox[{
   "sol2", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.36418895328616*^9, 3.36418895408685*^9}}],

Cell[BoxData[
 RowBox[{"vol2", "=", 
  RowBox[{"\[Pi]", 
   RowBox[{
    UnderoverscriptBox["\[Integral]", 
     RowBox[{"f2", "[", "0", "]"}], "5"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"g2", "[", "y", "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"vol", "=", 
  RowBox[{"vol1", "+", "vol2"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "10"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{"f1", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{"f2", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"l", ",", "r1", ",", "r2", ",", 
   RowBox[{"Boxed", "->", "False"}], ",", 
   RowBox[{"ViewAngle", "->", 
    RowBox[{"20", "\[Degree]"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389293991428398*^9, 3.389294002401612*^9}, {
  3.389294164752849*^9, 3.389294205141758*^9}, {3.389294240555805*^9, 
  3.389294285456476*^9}, {3.389294315569954*^9, 3.389294400260601*^9}, {
  3.389294590242403*^9, 3.389294598961666*^9}, {3.389294717806356*^9, 
  3.389294725146193*^9}, {3.389294800831515*^9, 3.38929481088832*^9}, {
  3.389294844121712*^9, 3.389294890408359*^9}, {3.389294921482363*^9, 
  3.389294933002795*^9}, {3.389294975338399*^9, 3.389295146112736*^9}, {
  3.389295183220936*^9, 3.389295196510823*^9}, {3.389295257875568*^9, 
  3.389295345365911*^9}, {3.389295377823614*^9, 3.389295384144224*^9}, {
  3.389295415420813*^9, 3.389295433118382*^9}, {3.389295548590586*^9, 
  3.389295596318355*^9}, {3.389295631414908*^9, 3.389295662432914*^9}, {
  3.389295698631657*^9, 3.389295703645731*^9}, {3.389295740092256*^9, 
  3.389295808789632*^9}, {3.389296029416273*^9, 3.389296106073516*^9}, {
  3.3892967634229*^9, 3.389296778137387*^9}}]
}, Closed]]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{632, 680},
WindowMargins->{{Automatic, 14}, {Automatic, 68}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 194, 7, 90, "Title"],
Cell[CellGroupData[{
Cell[809, 34, 204, 2, 55, "Section"],
Cell[1016, 38, 1177, 37, 138, "SmallText",
 Evaluatable->False],
Cell[2196, 77, 296, 8, 62, "Input"],
Cell[2495, 87, 805, 21, 93, "SmallText"],
Cell[3303, 110, 803, 23, 49, "Input"],
Cell[4109, 135, 397, 6, 28, "Input"],
Cell[4509, 143, 223, 6, 42, "SmallText"],
Cell[4735, 151, 778, 15, 49, "Input"],
Cell[5516, 168, 1212, 28, 98, "SmallText"],
Cell[6731, 198, 504, 14, 44, "Input"],
Cell[7238, 214, 637, 17, 76, "SmallText"],
Cell[7878, 233, 199, 6, 28, "Input"],
Cell[8080, 241, 309, 9, 28, "Input"],
Cell[8392, 252, 233, 6, 28, "Input"],
Cell[8628, 260, 137, 3, 28, "Input"],
Cell[8768, 265, 212, 4, 59, "SmallText"],
Cell[8983, 271, 409, 11, 28, "Input"],
Cell[9395, 284, 206, 4, 42, "SmallText"],
Cell[9604, 290, 325, 10, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[9966, 305, 153, 2, 35, "Section"],
Cell[10122, 309, 746, 19, 110, "SmallText",
 Evaluatable->False],
Cell[10871, 330, 126, 1, 42, "SmallText"],
Cell[11000, 333, 486, 13, 49, "Input"],
Cell[11489, 348, 456, 12, 76, "SmallText",
 Evaluatable->False],
Cell[11948, 362, 460, 14, 28, "Input"],
Cell[12411, 378, 466, 12, 59, "SmallText"],
Cell[12880, 392, 534, 15, 28, "Input"],
Cell[13417, 409, 257, 6, 59, "SmallText"],
Cell[13677, 417, 113, 3, 44, "Input"],
Cell[13793, 422, 244, 8, 46, "Input"],
Cell[14040, 432, 143, 3, 44, "Input"],
Cell[14186, 437, 239, 4, 59, "SmallText"],
Cell[14428, 443, 392, 11, 44, "Input"],
Cell[14823, 456, 327, 6, 59, "SmallText"],
Cell[15153, 464, 375, 10, 44, "Input"],
Cell[15531, 476, 469, 10, 59, "SmallText"],
Cell[16003, 488, 654, 16, 44, "Input"],
Cell[16660, 506, 468, 11, 44, "Input"],
Cell[17131, 519, 463, 11, 76, "SmallText"],
Cell[17597, 532, 646, 16, 44, "Input"],
Cell[18246, 550, 112, 3, 42, "SmallText"],
Cell[18361, 555, 196, 5, 44, "Input"],
Cell[18560, 562, 350, 10, 44, "Input"],
Cell[18913, 574, 252, 8, 44, "Input"],
Cell[19168, 584, 359, 9, 59, "SmallText",
 Evaluatable->False],
Cell[19530, 595, 209, 7, 44, "Input"],
Cell[19742, 604, 214, 4, 42, "SmallText"],
Cell[19959, 610, 251, 9, 61, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[20247, 624, 192, 3, 35, "Section"],
Cell[20442, 629, 975, 28, 94, "SmallText",
 Evaluatable->False],
Cell[21420, 659, 520, 17, 70, "Input"],
Cell[21943, 678, 276, 9, 44, "SmallText"],
Cell[22222, 689, 59, 1, 28, "Input"],
Cell[22284, 692, 142, 5, 42, "SmallText"],
Cell[22429, 699, 61, 1, 28, "Input"],
Cell[22493, 702, 199, 6, 59, "SmallText"],
Cell[22695, 710, 182, 5, 28, "Input"],
Cell[22880, 717, 209, 6, 59, "SmallText"],
Cell[23092, 725, 149, 4, 44, "Input"],
Cell[23244, 731, 182, 6, 44, "Input"],
Cell[23429, 739, 107, 3, 46, "Input"],
Cell[23539, 744, 170, 5, 42, "SmallText"],
Cell[23712, 751, 82, 2, 44, "Input"],
Cell[23797, 755, 196, 6, 44, "Input"],
Cell[23996, 763, 349, 10, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[24382, 778, 242, 3, 35, "Section"],
Cell[24627, 783, 1049, 29, 163, "SmallText",
 Evaluatable->False],
Cell[25679, 814, 67, 0, 42, "SmallText"],
Cell[25749, 816, 496, 12, 50, "Input"],
Cell[26248, 830, 267, 5, 59, "SmallText"],
Cell[26518, 837, 930, 20, 49, "Input"],
Cell[27451, 859, 384, 14, 42, "SmallText"],
Cell[27838, 875, 113, 3, 44, "Input"],
Cell[27954, 880, 249, 8, 44, "Input"],
Cell[28206, 890, 668, 20, 76, "SmallText"],
Cell[28877, 912, 1268, 41, 65, "Input"],
Cell[30148, 955, 119, 1, 42, "SmallText"],
Cell[30270, 958, 520, 14, 65, "Input"],
Cell[30793, 974, 88, 2, 42, "SmallText"],
Cell[30884, 978, 182, 5, 44, "Input"],
Cell[31069, 985, 275, 8, 44, "Input"],
Cell[31347, 995, 200, 5, 44, "Input"],
Cell[31550, 1002, 186, 5, 76, "SmallText",
 Evaluatable->False],
Cell[31739, 1009, 199, 6, 44, "Input"],
Cell[31941, 1017, 33, 0, 42, "SmallText"],
Cell[31977, 1019, 143, 4, 44, "Input"],
Cell[32123, 1025, 318, 10, 79, "Input"],
Cell[32444, 1037, 452, 12, 46, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[32933, 1054, 288, 4, 35, "Section"],
Cell[33224, 1060, 1402, 44, 146, "SmallText",
 Evaluatable->False],
Cell[34629, 1106, 471, 13, 50, "Input"],
Cell[35103, 1121, 177, 5, 28, "Input"],
Cell[35283, 1128, 142, 5, 42, "SmallText"],
Cell[35428, 1135, 102, 3, 28, "Input"],
Cell[35533, 1140, 151, 5, 30, "Input"],
Cell[35687, 1147, 622, 22, 59, "SmallText"],
Cell[36312, 1171, 449, 14, 44, "Input"],
Cell[36764, 1187, 160, 5, 44, "Input"],
Cell[36927, 1194, 206, 6, 44, "Input"],
Cell[37136, 1202, 421, 12, 44, "Input"],
Cell[37560, 1216, 733, 20, 112, "SmallText"],
Cell[38296, 1238, 201, 5, 44, "Input"],
Cell[38500, 1245, 276, 8, 44, "Input"],
Cell[38779, 1255, 268, 5, 59, "SmallText"],
Cell[39050, 1262, 286, 9, 80, "Input"],
Cell[39339, 1273, 176, 4, 42, "SmallText"],
Cell[39518, 1279, 267, 7, 44, "Input"],
Cell[39788, 1288, 252, 7, 44, "Input"],
Cell[40043, 1297, 286, 9, 81, "Input"],
Cell[40332, 1308, 80, 2, 44, "Input"],
Cell[40415, 1312, 2085, 49, 105, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
