(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40948,       1414]
NotebookOptionsPosition[     35043,       1239]
NotebookOutlinePosition[     35500,       1259]
CellTagsIndexPosition[     35457,       1256]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fortgeschrittene Konzepte", "Title"],

Cell[CellGroupData[{

Cell["Funktionen und Optionen", "Section"],

Cell[CellGroupData[{

Cell["Optionen in eigenen Funktionsdefinitionen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", "x"}], "]"}], "2"], ",", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"3", "x"}], "]"}], "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"Sin", "[", 
        RowBox[{"n", " ", "x"}], "]"}], "n"], ",", " ", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotMultiple", "[", 
   RowBox[{"func_", ",", " ", "list1_List", ",", " ", "list2_List"}], "]"}], ":=",
   "\n", "\t", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"func", ",", " ", "list1"}], "]"}], "]"}], ",", "list2"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"PlotMultiple", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"n", " ", "x"}], "]"}], "n"], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PlotMultiple", "[", 
  RowBox[{
   RowBox[{"c", " ", 
    SuperscriptBox["E", "x"]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "3"}], ",", "3", ",", ".4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "PlotMultiple", "]"}], "\n", 
 RowBox[{
  RowBox[{"PlotMultiple", "[", 
   RowBox[{"func_", ",", " ", "list1_List", ",", "list2_List", ",", " ", 
    RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", "\n", "\t", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"func", ",", " ", "list1"}], "]"}], "]"}], ",", "list2", ",", 
    " ", "opts"}], "]"}]}]}], "Input"],

Cell[TextData[{
 StyleBox["OptionQ",
  FontWeight->"Bold"],
 " ist in der Online-Hilfe noch immer nicht auffindbar"
}], "SmallText"],

Cell[BoxData[
 RowBox[{"?", "OptionQ"}]], "Input"],

Cell[BoxData[
 RowBox[{"PlotMultiple", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", "x"}], "-", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "4.5"}], ",", " ", "4.5", ",", " ", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "4"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PlotMultiple", "[", 
  RowBox[{
   FractionBox["c", "x"], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Neue Optionen - Beispiel GenericMatrix", "Subsection"],

Cell["\<\
Hier sehen Sie an einem Beispiel die typische Weise Funktionen mit eigenen \
Optionen zu definieren.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"clearAll", "[", "\"\<Global*`\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"genericMatrix", "[", 
   RowBox[{"localOptions___", "?", "OptionQ"}], "]"}], ":=", 
  RowBox[{"myGenericMatrix", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", 
         RowBox[{"#1", ",", "#2"}]], "&"}], ",", "zeilen", ",", "spalten"}], 
      "}"}], "/.", 
     RowBox[{"{", "localOptions", "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"zeilen", "\[Rule]", "2"}], ",", 
      RowBox[{"spalten", "\[Rule]", "2"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myGenericMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"f_", ",", "z_", ",", "s_"}], "}"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "s"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"genericMatrix", "[", "]"}], ",", 
    RowBox[{"genericMatrix", "[", 
     RowBox[{"spalten", "\[Rule]", "5"}], "]"}]}], "}"}]}]], "Input"],

Cell["\<\
Als Optionswerte k\[ODoubleDot]nnen auch Funktionen eingesetzt werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"veryGenericMatrix", "[", 
   RowBox[{"localOptions___", "?", "OptionQ"}], "]"}], ":=", 
  RowBox[{"myGenericMatrix", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "zeilen", ",", "spalten"}], "}"}], "/.", 
     RowBox[{"{", "localOptions", "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["x", 
          RowBox[{"#1", ",", "#2"}]], "&"}], ")"}]}], ",", 
      RowBox[{"zeilen", "\[Rule]", "2"}], ",", 
      RowBox[{"spalten", "\[Rule]", "2"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"veryGenericMatrix", "[", 
   RowBox[{
    RowBox[{"f", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"Random", "[", "]"}]}], "]"}]}], ",", 
    RowBox[{"zeilen", "\[Rule]", "3"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Neue Optionen - Beispiel DotPlot", "Subsection"],

Cell["Und nun noch ein komplexeres Beispiel.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "DotPlot", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DotPlot", "]"}], "=", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"Options", "[", "ListPlot", "]"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "15"}]}], "]"}]}], ";", " ", 
  RowBox[{"SetOptions", "[", 
   RowBox[{"DotPlot", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"PointSize", "[", "0.03", "]"}]}], ",", " ", 
    "\[IndentingNewLine]", "\t", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
    RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DotPlot", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"var_", ",", "start_", ",", "end_"}], "}"}], ",", " ", 
    RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"delta", ",", " ", "plotpts"}], "}"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{"plotpts", "=", 
      RowBox[{
       RowBox[{"PlotPoints", " ", "/.", " ", 
        RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
       RowBox[{"Options", "[", "DotPlot", "]"}]}]}], ";", "\n", "\t", 
     RowBox[{"delta", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"end", "-", "start"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"plotpts", "-", "1"}], ")"}]}]}], ";", "\n", "\t", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"var", ",", "f"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "start", ",", "end", ",", "delta"}], "}"}]}], 
        "]"}], ",", "\n", "\t", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"{", "opts", "}"}], ",", " ", 
           RowBox[{"Options", "[", "DotPlot", "]"}]}], "]"}], ",", " ", 
         RowBox[{"PlotPoints", "\[Rule]", "_"}]}], "]"}]}], "]"}]}]}], 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"DotPlot", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "30", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DotPlot", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "30", ",", "100"}], "}"}], ",", 
   RowBox[{"Frame", "->", "False"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"25", ",", "0"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DotPlot", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "30", ",", "100"}], "}"}], ",", " ", 
   RowBox[{"PlotPoints", "\[Rule]", "25"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DotPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "200"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", ".01", "]"}]}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Noch einmal Funktionen", "Section"],

Cell[CellGroupData[{

Cell["Funktionen mit optionalen Parametern", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"potenzReihe", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"x_:", "x"}], ",", 
    RowBox[{"x0_:", "0"}], ",", 
    RowBox[{"order_:", "6"}]}], "]"}], ":=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "order"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"potenzReihe", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"potenzReihe", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x", ",", "\[Pi]", ",", "3"}], 
  "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", " ", "[", "potenzReihe", "]"}], "\n", 
 RowBox[{
  RowBox[{"potenzReihe", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"x_:", "x"}], ",", 
    RowBox[{"x0_:", "0"}], ",", "order_"}], "]"}], ":=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "order"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"potenzReihe", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "12"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"potenzReihe", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "y", "]"}], ",", "y", ",", "3"}], "]"}]], "Input"],

Cell["Dieselbe Funktion in einer Notation mit Optionen", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", " ", "[", "potenzReihe", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "potenzReihe", "]"}], "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"var", "\[Rule]", " ", "x"}], ",", 
     RowBox[{"value", "\[Rule]", " ", "0"}], ",", 
     RowBox[{"order", "\[Rule]", " ", "10"}]}], "}"}]}], ";", 
  "\:ffff"}], "\n", 
 RowBox[{
  RowBox[{"potenzReihe", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"var", ",", "value", ",", "order"}], "}"}], "/.", 
      RowBox[{"{", "options", "}"}]}], "/.", 
     RowBox[{"Options", "[", "potenzReihe", "]"}]}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"potenzReihe", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "y", "]"}], ",", 
   RowBox[{"var", "\[Rule]", "y"}], ",", 
   RowBox[{"order", "\[Rule]", "7"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Upvalues und Downvalues", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x", "+", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"?", "f"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{"f", ",", "g"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  SuperscriptBox["x", "2"]}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "f g"}]], "Input"],

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dt", "[", 
   RowBox[{"a", ",", "x_"}], "]"}], ":=", "0"}]], "Input"],

Cell[BoxData[
 RowBox[{"Attributes", "[", "Dt", "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{"a", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dt", "[", 
   RowBox[{"a", ",", "x_"}], "]"}], "^:=", "0"}], "\n", 
 RowBox[{"UpValues", "[", "a", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{"a", ",", "y"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{"a", ",", "x"}], "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}], "^=", "0"}], ";"}], "\n", 
 RowBox[{"UpValues", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "x"}], "}"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "x"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"a", "/:", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"UpValues", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "x"}], "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "/:", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "n_Integer"}], "}"}]}], "]"}], "=", "0"}], 
  ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "3"}], "}"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Zusammengesetzte Bezeichner", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  OverscriptBox["x", "\[RightVector]"], " ", 
  SuperscriptBox["x", "+"], 
  SubscriptBox["x", "a"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "3"}], ";", " ", 
  RowBox[{"a", "=", "4"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  OverscriptBox["x", "\[RightVector]"], " ", 
  SuperscriptBox["x", "+"], 
  SubscriptBox["x", "a"]}]], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"x", ",", "a"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["x", "\[RightVector]"], " ", 
   SuperscriptBox["x", "+"], 
   SubscriptBox["x", "a"]}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "OverVector"}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "//", "SuperPlus"}]], "Input"],

Cell[BoxData["%"], "Input"],

Cell[BoxData[
 RowBox[{"??", "SuperPlus"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "Subscript"}]], "Input"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"OverVector", ",", "SuperPlus", ",", "Subscript"}], "}"}], ",", 
   "HoldFirst"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "3"}], ";", " ", 
  RowBox[{"a", "=", "4"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  OverscriptBox["x", "\[RightVector]"], " ", 
  SuperscriptBox["x", "+"], 
  SubscriptBox["x", "a"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "0"], "//", "Head"}]], "Input"],

Cell["\<\
Werte, die solchen zusammengesetzten Symbolen zugewiesen werden, sind nicht \
in der Symboltabelle, sondern als Funktionswerte unter dem entsprechenden \
Funktionssymbol gespeichert. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "3"], "=", "12"}], ";", 
  RowBox[{
   SubscriptBox["x", "4"], "=", "8"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "Subscript"}]], "Input"],

Cell[TextData[{
 "Sie k\[ODoubleDot]nnen deshalb auch nicht mit ",
 StyleBox["Clear",
  FontWeight->"Bold"],
 ", sondern nur mit ",
 StyleBox["Unset",
  FontWeight->"Bold"],
 " (oder ...=.) gel\[ODoubleDot]scht werden."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   SubscriptBox["x", "4"], "]"}], ";", " ", 
  SubscriptBox["x", "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unset", "[", 
   SubscriptBox["x", "4"], "]"}], ";", " ", 
  SubscriptBox["x", "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "Subscript"}]], "Input"],

Cell[TextData[{
 StyleBox["Clear",
  FontWeight->"Bold"],
 " kann jedoch auf das Funktionssymbol ",
 StyleBox["Subscript",
  FontWeight->"Bold"],
 " angewendet werden, was ",
 StyleBox["alle",
  FontSlant->"Italic"],
 " mit ",
 StyleBox["Subscript",
  FontWeight->"Bold"],
 " zusammengesetzten Symbole l\[ODoubleDot]scht."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "Subscript", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "Subscript"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Block versus Module", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"shrink", "[", 
   RowBox[{"pts_List", ",", "\[Alpha]_Real"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "M", "}"}], ",", " ", 
    RowBox[{
     RowBox[{"M", "=", 
      RowBox[{"Mean", "[", "pts", "]"}]}], " ", ";", " ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Alpha]", "#"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], "M"}]}], "&"}], ",", 
       "pts"}], "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"GrayLevel", "[", ".7", "]"}], ",", 
        RowBox[{"Polygon", "[", "test", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"shrink", "[", 
          RowBox[{"test", ",", ".5"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"GrayLevel", "[", ".7", "]"}], ",", 
        RowBox[{"Polygon", "[", "test", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"shrink", "[", 
          RowBox[{"test", ",", 
           RowBox[{"-", ".2"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}], "}"}], "]"}]}], "Input"],

Cell["\<\
Im Gegensatz zu klassischen Programmiersprachen k\[ODoubleDot]nnen lokale \
Bezeichner, die in symbolischen R\[UDoubleDot]ckgabewerten vorkommen, \
\[UDoubleDot]ber das Ende des Block hinaus \"leben\".\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", "x"}], "+", "1"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "x", "]"}], ";", 
    RowBox[{"x", "=", "n"}], ";", "f"}]}], 
  "]"}], "\[IndentingNewLine]", "x"}], "Input"],

Cell[TextData[{
 "Der Inhalt des Statements wird umgebaut zu:  x$123=n; f\nBei der Auswertung \
von f ist das dort vorkommende ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " das globale ",
 StyleBox["x",
  FontSlant->"Italic"],
 " und hat mit dem lokalen x$123 nichts zu tun. Das entspricht \"lexical \
scoping\", die Variable ",
 StyleBox["x",
  FontSlant->"Italic"],
 " ist lokal f\[UDoubleDot]r das Code-Segment."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "x", "]"}], ";", 
    RowBox[{"x", "=", "n"}], ";", "f"}]}], 
  "]"}], "\[IndentingNewLine]", "x"}], "Input"],

Cell[TextData[{
 "Der Inhalt von x wird auf dem Stack zwischengespeichert, die Zuweisung ",
 StyleBox["x=n ",
  FontSlant->"Italic"],
 "ausgef\[UDoubleDot]hrt und dann die Auswertung von f gestartet. Das ",
 StyleBox["x",
  FontSlant->"Italic"],
 " ist das globale ",
 StyleBox["x",
  FontSlant->"Italic"],
 ", das zur Zeit einen anderen Wert hat (n\[ADoubleDot]mlich n). Am Ende des \
Funktionsaufrufs wir der alte Wert von x wieder hergestellt.\nDas entspricht \
\"dynamical scoping\"; Variablen sind nicht wirklich lokal, es wird lediglich \
deren Inhalt gerettet."
}], "SmallText"]
}, Closed]],

Cell[CellGroupData[{

Cell["Eigene Operatoren definieren", "Subsection"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "CirclePlus", "]"}], "\n", 
 RowBox[{
  RowBox[{"CirclePlus", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"a", "+", "b"}], 
   RowBox[{"1", "+", 
    RowBox[{"a", " ", "b"}]}]]}], "\n", 
 RowBox[{
  RowBox[{"CirclePlus", "[", 
   RowBox[{"a__", ",", "b_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"CirclePlus", "[", 
    RowBox[{
     RowBox[{"CirclePlus", "[", "a", "]"}], ",", "b"}], "]"}], "//", 
   "Together"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"x", "\[CirclePlus]", "y", "\[CirclePlus]", "z"}]], "Input"],

Cell[BoxData[
 RowBox[{"0.4", "\[CirclePlus]", "0.4", "\[CirclePlus]", "0.4", 
  "\[CirclePlus]", "0.4"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", "\[CirclePlus]", "2"}]], "Input"],

Cell[BoxData[
 RowBox[{"a", "\[CirclePlus]", "0", "\[CirclePlus]", "1"}]], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", "CirclePlus", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[CirclePlus]", 
   RowBox[{"b", "\[CircleTimes]", "c"}]}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "\[CirclePlus]", "b"}], ")"}], "\[CirclePlus]", "c"}], "//", 
  "FullForm"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Geschwindigkeitsoptimierung, Compile", "Section"],

Cell[CellGroupData[{

Cell["\<\
Apfelm\[ADoubleDot]nnchen-Beispiel ohne Compile\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ApfelCalc", "[", 
   RowBox[{"z0_Complex", ",", " ", "nmax_Integer"}], "]"}], ":=", "\n", "\t", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", "0"}], ",", 
      RowBox[{"z", "=", "0"}]}], "}"}], ",", "\n", "\t\t", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", "z", "]"}], "<", "2"}], " ", "&&", " ", 
        RowBox[{"n", "<", "nmax"}]}], ",", " ", 
       RowBox[{
        RowBox[{"z", "=", 
         RowBox[{
          SuperscriptBox["z", "2"], "+", "z0"}]}], ";", " ", 
        RowBox[{"n", "++"}]}]}], "]"}], ";", "\n", "\t", "n"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ApfelCalc", "[", 
  RowBox[{
   RowBox[{"0.4", "+", 
    RowBox[{"0.4", "I"}]}], ",", "20"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"ColorData", "[", "\"\<TemperatureMap\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ApfelPlot", "[", 
   RowBox[{
   "z0_Complex", ",", "z1_Complex", ",", " ", "nmax_Integer", ",", 
    "dx_Real"}], "]"}], ":=", "\n", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r0", "=", 
       RowBox[{"Re", "[", "z0", "]"}]}], ",", " ", 
      RowBox[{"r1", "=", 
       RowBox[{"Re", "[", "z1", "]"}]}], ",", 
      RowBox[{"i0", "=", 
       RowBox[{"Im", "[", "z0", "]"}]}], ",", " ", 
      RowBox[{"i1", "=", 
       RowBox[{"Im", "[", "z1", "]"}]}]}], "}"}], ",", 
    RowBox[{"ListDensityPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ApfelCalc", "[", 
         RowBox[{
          RowBox[{"r", "+", 
           RowBox[{"I", " ", "i"}]}], ",", "nmax"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "i0", ",", "i1", ",", "dx"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "r0", ",", "r1", ",", "dx"}], "}"}]}], "]"}], ",", 
      
      RowBox[{"AspectRatio", "->", 
       FractionBox[
        RowBox[{"i1", "-", "i0"}], 
        RowBox[{"r1", "-", "r0"}]]}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "c"}]}], "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"ApfelPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "-", 
    RowBox[{"1.25", "I"}]}], ",", 
   RowBox[{"1.25", "+", 
    RowBox[{"1.25", "I"}]}], ",", "50", ",", "0.08"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"ApfelPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"1.25", "I"}]}], ",", 
    RowBox[{"1.25", "+", 
     RowBox[{"1.25", "I"}]}], ",", "50", ",", "0.02"}], "]"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["... und mit Compile", "Subsection"],

Cell["\<\
Beachten Sie, dass hier = und nicht := verwendet wird, denn die Compilierung \
soll ja w\[ADoubleDot]hrend der Funktionsdefinition und nicht erst w\
\[ADoubleDot]hrend des Aufrufs ausgef\[UDoubleDot]hrt werden. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ApfelCalc", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ApfelCalc", "=", 
   RowBox[{"Compile", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z0", ",", "_Complex"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nmax", ",", "_Integer"}], "}"}]}], "}"}], ",", "\n", "\t", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "=", "0"}], ",", 
         RowBox[{"z", "=", 
          RowBox[{"0.", "I"}]}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", "z", "]"}], "<", "2"}], " ", "&&", " ", 
           RowBox[{"n", "<", "nmax"}]}], ",", " ", 
          RowBox[{
           RowBox[{"z", "=", 
            RowBox[{
             SuperscriptBox["z", "2"], "+", "z0"}]}], ";", " ", 
           RowBox[{"n", "++"}]}]}], "]"}], ";", "\n", "\t", "n"}]}], "]"}]}], 
    "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"ApfelCalc", "[", 
  RowBox[{
   RowBox[{"0.4", "+", 
    RowBox[{"0.4", "I"}]}], ",", "20"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"ApfelPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"1.25", "I"}]}], ",", 
    RowBox[{"1.25", "+", 
     RowBox[{"1.25", "I"}]}], ",", "50", ",", "0.02"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReliefApfelPlot", "[", 
   RowBox[{
   "z0_Complex", ",", "z1_Complex", ",", " ", "nmax_Integer", ",", 
    "dx_Real"}], "]"}], ":=", "\n", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r0", "=", 
       RowBox[{"Re", "[", "z0", "]"}]}], ",", " ", 
      RowBox[{"r1", "=", 
       RowBox[{"Re", "[", "z1", "]"}]}], ",", 
      RowBox[{"i0", "=", 
       RowBox[{"Im", "[", "z0", "]"}]}], ",", " ", 
      RowBox[{"i1", "=", 
       RowBox[{"Im", "[", "z1", "]"}]}]}], "}"}], ",", 
    RowBox[{"ReliefPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ApfelCalc", "[", 
         RowBox[{
          RowBox[{"r", "+", 
           RowBox[{"I", " ", "i"}]}], ",", "nmax"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "i0", ",", "i1", ",", "dx"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "r0", ",", "r1", ",", "dx"}], "}"}]}], "]"}], ",", 
      
      RowBox[{"AspectRatio", "->", 
       FractionBox[
        RowBox[{"i1", "-", "i0"}], 
        RowBox[{"r1", "-", "r0"}]]}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "c"}]}], "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"ReliefApfelPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "0.7476"}], "+", 
     RowBox[{"0.0976", "I"}]}], ",", 
    RowBox[{
     RowBox[{"-", "0.7452"}], "+", 
     RowBox[{"0.0993", "I"}]}], ",", "200", ",", 
    RowBox[{".3", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "5"}]]}]}], "]"}]}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Modularisierung und Pakete", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[{
 "In der folgenden Zelle ist der gesamte Code des Test-Fibonacci-Packages \
enthalten, der aus Teilen des Notebooks ",
 StyleBox["mathcomp.nb ",
  FontWeight->"Bold"],
 "herauskopiert und entsprechend modifiziert wurde (insbesondere wurden alle \
Codeteile in die InputForm \[UDoubleDot]berf\[UDoubleDot]hrt, um \"lesbaren\" \
Ausgabecode zu produzieren - f\[UDoubleDot]r ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ist das nicht wesentlich, f\[UDoubleDot]r \"human reading\" aber schon). \n\
Markieren Sie nun diese Zelle als Initialisierungszelle (Cell|Cell \
Properties) und speichern Sie das Notebook ab.  Es wird eine Datei ",
 StyleBox["advanced.m ",
  FontWeight->"Bold"],
 "erzeugt, die den Package-Quellcode (und viele Kommentare) \
enth\[ADoubleDot]lt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "VersuchsPackage", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Zwei", " ", "Definitionen", " ", "zur", " ", "Berechnung", " ", "der", 
    " ", "Fibonaccifolge"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"BeginPackage", "[", "\"\<Test`Fibonacci`\>\"", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fib", "::", "usage"}], ":=", 
     "\"\<fib[n] berechnet die n-te Fibonaccizahl \nmit einem iterativen \
Verfahren\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"matfib", "::", "usage"}], ":=", 
     "\"\<matfib[n] berechnet die n-te Fibonaccizahl \n\[UDoubleDot]ber \
Matrixpotenzen\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fib", "[", "n_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "=", "0"}], ",", 
         RowBox[{"b", "=", "1"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}], "=", 
           RowBox[{"{", 
            RowBox[{"b", ",", 
             RowBox[{"a", "+", "b"}]}], "}"}]}], ",", 
          RowBox[{"{", "n", "}"}]}], "]"}], ";", "a"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"matfib", "[", "n_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"MatrixPower", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", "n"}], "]"}], " ", 
        ".", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", "0", "}"}]}], "}"}]}], ")"}], "\[LeftDoubleBracket]", 
      RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}], "\n", 
   RowBox[{"End", "[", "]"}], "\[IndentingNewLine]", 
   RowBox[{"EndPackage", "[", "]"}]}]}]], "Input"],

Cell[TextData[{
 "Kopieren Sie anschlie\[SZ]end die Datei ",
 StyleBox["prog-advanced.m",
  FontWeight->"Bold"],
 " nach ",
 StyleBox["Fib.m",
  FontWeight->"Bold"],
 " und heben die Markierung der Zelle wieder auf."
}], "SmallText"],

Cell[TextData[{
 "Nun k\[ODoubleDot]nnen Sie den Kernel neu starten und das Package mit ",
 StyleBox["Needs[kontext,file] ",
  FontSlant->"Italic"],
 "laden.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "Setzen Sie vorher mit SetDirectory[ ] das Wurzelverzeichnis. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"SetDirectory", "[", "\"\</home/graebe/Mma-Buch/Notebooks\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", 
  RowBox[{"\"\<Test`Fibonacci`\>\"", ",", "\"\<Fib.m\>\""}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"fib", "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"matfib", "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"fib", "[", "500000", "]"}], ";"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"matfib", "[", "500000", "]"}], ";"}], "]"}]], "Input"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"EditBar",
WindowSize->{690, 617},
WindowMargins->{{Automatic, 1}, {Automatic, 96}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 42, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[657, 27, 42, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[724, 31, 63, 0, 45, "Subsection"],
Cell[790, 33, 76, 1, 28, "Input"],
Cell[869, 36, 418, 14, 43, "Input"],
Cell[1290, 52, 419, 13, 43, "Input"],
Cell[1712, 67, 344, 10, 49, "Input"],
Cell[2059, 79, 321, 10, 43, "Input"],
Cell[2383, 91, 324, 10, 28, "Input"],
Cell[2710, 103, 462, 11, 69, "Input"],
Cell[3175, 116, 132, 4, 42, "SmallText"],
Cell[3310, 122, 50, 1, 28, "Input"],
Cell[3363, 125, 485, 15, 30, "Input"],
Cell[3851, 142, 461, 14, 40, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[4349, 161, 60, 0, 29, "Subsection"],
Cell[4412, 163, 129, 3, 42, "SmallText"],
Cell[4544, 168, 1059, 33, 89, "Input"],
Cell[5606, 203, 223, 6, 28, "Input"],
Cell[5832, 211, 99, 2, 42, "SmallText"],
Cell[5934, 215, 627, 18, 49, "Input"],
Cell[6564, 235, 352, 11, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6953, 251, 54, 0, 29, "Subsection"],
Cell[7010, 253, 59, 0, 42, "SmallText"],
Cell[7072, 255, 2063, 56, 189, "Input"],
Cell[9138, 313, 170, 5, 30, "Input"],
Cell[9311, 320, 350, 10, 30, "Input"],
Cell[9664, 332, 225, 6, 30, "Input"],
Cell[9892, 340, 403, 11, 52, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10344, 357, 41, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[10410, 361, 58, 0, 45, "Subsection"],
Cell[10471, 363, 76, 1, 28, "Input"],
Cell[10550, 366, 327, 10, 28, "Input"],
Cell[10880, 378, 118, 3, 28, "Input"],
Cell[11001, 383, 145, 4, 28, "Input"],
Cell[11149, 389, 365, 10, 49, "Input"],
Cell[11517, 401, 119, 3, 28, "Input"],
Cell[11639, 406, 128, 3, 28, "Input"],
Cell[11770, 411, 69, 0, 42, "SmallText"],
Cell[11842, 413, 810, 24, 89, "Input"],
Cell[12655, 439, 194, 5, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12886, 449, 45, 0, 29, "Subsection"],
Cell[12934, 451, 76, 1, 28, "Input"],
Cell[13013, 454, 208, 7, 52, "Input"],
Cell[13224, 463, 202, 6, 50, "Input"],
Cell[13429, 471, 46, 1, 28, "Input"],
Cell[13478, 474, 63, 1, 28, "Input"],
Cell[13544, 477, 104, 3, 28, "Input"],
Cell[13651, 482, 64, 1, 28, "Input"],
Cell[13718, 485, 237, 6, 69, "Input"],
Cell[13958, 493, 248, 8, 28, "Input"],
Cell[14209, 503, 78, 2, 44, "Input"],
Cell[14290, 507, 281, 9, 85, "Input"],
Cell[14574, 518, 308, 10, 85, "Input"],
Cell[14885, 530, 248, 8, 44, "Input"],
Cell[15136, 540, 431, 15, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[15604, 560, 49, 0, 29, "Subsection"],
Cell[15656, 562, 76, 1, 28, "Input"],
Cell[15735, 565, 136, 4, 30, "Input"],
Cell[15874, 571, 105, 3, 28, "Input"],
Cell[15982, 576, 136, 4, 30, "Input"],
Cell[16121, 582, 81, 2, 28, "Input"],
Cell[16205, 586, 175, 5, 30, "Input"],
Cell[16383, 593, 51, 1, 28, "Input"],
Cell[16437, 596, 54, 1, 28, "Input"],
Cell[16494, 599, 58, 1, 28, "Input"],
Cell[16555, 602, 27, 0, 28, "Input"],
Cell[16585, 604, 53, 1, 28, "Input"],
Cell[16641, 607, 53, 1, 44, "Input"],
Cell[16697, 610, 76, 1, 44, "Input"],
Cell[16776, 613, 185, 5, 44, "Input"],
Cell[16964, 620, 105, 3, 44, "Input"],
Cell[17072, 625, 136, 4, 46, "Input"],
Cell[17211, 631, 75, 2, 44, "Input"],
Cell[17289, 635, 212, 4, 59, "SmallText"],
Cell[17504, 641, 147, 5, 44, "Input"],
Cell[17654, 648, 53, 1, 44, "Input"],
Cell[17710, 651, 236, 8, 42, "SmallText"],
Cell[17949, 661, 131, 4, 44, "Input"],
Cell[18083, 667, 131, 4, 44, "Input"],
Cell[18217, 673, 53, 1, 44, "Input"],
Cell[18273, 676, 339, 13, 59, "SmallText"],
Cell[18615, 691, 69, 1, 44, "Input"],
Cell[18687, 694, 53, 1, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[18777, 700, 41, 0, 29, "Subsection"],
Cell[18821, 702, 76, 1, 28, "Input"],
Cell[18900, 705, 560, 18, 28, "Input"],
Cell[19463, 725, 1352, 37, 189, "Input"],
Cell[20818, 764, 230, 4, 59, "SmallText"],
Cell[21051, 770, 106, 3, 44, "Input"],
Cell[21160, 775, 147, 5, 46, "Input"],
Cell[21310, 782, 232, 7, 65, "Input"],
Cell[21545, 791, 442, 13, 76, "SmallText"],
Cell[21990, 806, 231, 7, 49, "Input"],
Cell[22224, 815, 585, 14, 93, "SmallText"]
}, Closed]],
Cell[CellGroupData[{
Cell[22846, 834, 50, 0, 29, "Subsection"],
Cell[22899, 836, 496, 16, 84, "Input"],
Cell[23398, 854, 83, 1, 28, "Input"],
Cell[23484, 857, 116, 2, 28, "Input"],
Cell[23603, 861, 61, 1, 28, "Input"],
Cell[23667, 864, 83, 1, 28, "Input"],
Cell[23753, 867, 67, 1, 28, "Input"],
Cell[23823, 870, 129, 3, 28, "Input"],
Cell[23955, 875, 156, 5, 28, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24160, 886, 55, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[24240, 890, 77, 2, 45, "Subsection"],
Cell[24320, 894, 721, 23, 91, "Input"],
Cell[25044, 919, 134, 4, 28, "Input"],
Cell[25181, 925, 1402, 40, 164, "Input"],
Cell[26586, 967, 226, 7, 28, "Input"],
Cell[26815, 976, 265, 8, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[27117, 989, 41, 0, 29, "Subsection"],
Cell[27161, 991, 240, 4, 59, "SmallText"],
Cell[27404, 997, 1070, 32, 111, "Input"],
Cell[28477, 1031, 134, 4, 28, "Input"],
Cell[28614, 1037, 265, 8, 28, "Input"],
Cell[28882, 1047, 1292, 37, 144, "Input"],
Cell[30177, 1086, 367, 12, 30, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30593, 1104, 45, 0, 35, "Section"],
Cell[30641, 1106, 76, 1, 28, "Input"],
Cell[30720, 1109, 807, 17, 127, "SmallText"],
Cell[31530, 1128, 2324, 63, 349, "Input"],
Cell[33857, 1193, 233, 8, 42, "SmallText"],
Cell[34093, 1203, 281, 8, 59, "SmallText"],
Cell[34377, 1213, 224, 4, 49, "Input"],
Cell[34604, 1219, 85, 2, 28, "Input"],
Cell[34692, 1223, 88, 2, 28, "Input"],
Cell[34783, 1227, 113, 3, 28, "Input"],
Cell[34899, 1232, 116, 3, 28, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
