(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82527,       3040]
NotebookOptionsPosition[     69062,       2674]
NotebookOutlinePosition[     69488,       2693]
CellTagsIndexPosition[     69445,       2690]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["... Doing Mathematics by Computer", "Title"],

Cell[CellGroupData[{

Cell["Grenzwerte und Reihen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Grenzwertberechnung", "Subsection"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"4", "x"}], 
      RowBox[{
       RowBox[{"2", "x"}], "+", "3"}]], ")"}], "3"], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["1", "x"]}], ")"}], "x"], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Tan", "[", "x", "]"}], "-", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{"x", "-", 
     RowBox[{"Sin", "[", "x", "]"}]}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 PageWidth->Infinity],

Cell["Links- und rechtsseitiger Grenzwert", "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "2"]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}]}], "]"}]], "Input"],

Cell["\<\
Grenzwert einer komplexen Funktion mit wesentlicher Singularit\[ADoubleDot]t \
aus verschiedenen komplexen Richtungen\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"directions", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], "n"], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "8"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      FractionBox["1", "z"], "]"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}], ",", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  "directions"}]], "Input"],

Cell["\<\
Grenzwert einer reellen Funktion, der nicht eindeutig bestimmt ist.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["1", "x"], "]"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["1", "x"], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Grenzwerte f\[UDoubleDot]r Funktionen mit Parametern\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", 
       RowBox[{"-", "a"}]]}], "+", 
     SuperscriptBox["x", "a"]}], 
    RowBox[{"x", "-", 
     FractionBox["1", "x"]}]], ",", 
   RowBox[{"x", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["a", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s F\[ADoubleDot]higkeiten zur Grenzwertberechnung werden von Version zu \
Version besser. Diese Grenzwerte konnte es zum Beispiel in Version 4 noch \
nicht symbolisch bestimmen.   "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "n"], 
    SuperscriptBox["E", "x"]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "!"}], 
    SuperscriptBox["x", "x"]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], 
    RowBox[{"Cot", "[", 
     RowBox[{"2", "x"}], "]"}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], "-", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}]}]}], ",", 
   RowBox[{"s", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell["Differentialquotient als Grenzwertberechnung bestimmen", "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", " ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "dx"}], "]"}], "-", 
     RowBox[{"Sin", "[", "x", "]"}]}], "dx"], ",", 
   RowBox[{"dx", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell["\<\
Grenzwerte mehrstelliger Funktionen sind nicht vorgesehen - sie sind auch \
mathematisch komplizierter. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", "y", "-", "1"}], "x"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"y", " ", 
        FractionBox["\[Pi]", "2"]}], "]"}], "+", "x"}], "y"]}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", " ", 
   RowBox[{"y", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", " ", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Der Grenzwert kann als doppelter Grenzwert (erst nach x, dann nach y) \
berechnet werden. In diesem Beispiel kommt es allerdings auf die Reihenfolge \
an.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"f", ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "]"}], ",", " ", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"f", ",", 
     RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", " ", 
   RowBox[{"y", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell["\<\
Ein Bild schafft Aufkl\[ADoubleDot]rung: Die zweistellige Funktion ist in der \
N\[ADoubleDot]he des Punktes (0,1) sehr unregelm\[ADoubleDot]\[SZ]ig.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", ".01"}], ",", ".01"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0.99", ",", "1.01"}], "}"}], ",", " ", 
   RowBox[{"Axes", "->", "None"}]}], "]"}]], "Input"],

Cell["\<\
Die Grenzwerte, die sich ergeben, wenn man sich dem Punkt aus \
unterschiedlichen Richtungen n\[ADoubleDot]hert, sind verschieden!\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"a", " ", "\[CurlyEpsilon]"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"1", "+", "\[CurlyEpsilon]"}]}]}], "}"}]}], ",", 
   RowBox[{"\[CurlyEpsilon]", "\[Rule]", "0"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Potenzreihen", "Subsection"],

Cell["Potenzreihen entwickeln", "SmallText"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["z", "2"], "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "I", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    SqrtBox["x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "//", "InputForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "\[LeftDoubleBracket]", 
    RowBox[{"3", ",", "5"}], "\[RightDoubleBracket]"}], ",", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"f", ",", "4"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Grenzwertbestimmung f\[UDoubleDot]r einen komplizierten Ausdruck.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox["f", 
    SuperscriptBox["x", "7"]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell["\<\
Der Grenzwert kann aus der zugeh\[ODoubleDot]rigen Potenzreihe leicht \
abgelesen werden. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[StyleBox["Selbst bei so komplizierten Ausdr\[UDoubleDot]cken \
wie dem Folgenden wird die Reihenentwicklung ohne Verz\[ODoubleDot]gerung \
berechnet. ", "SmallText"]], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"x", "-", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      RowBox[{
       SuperscriptBox["E", "x"], "-", 
       SuperscriptBox["E", 
        RowBox[{"Sin", "[", "x", "]"}]]}]], ")"}], "3"]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
In Reihenentwicklungen kann man keine Werte einsetzen. Das macht mathematisch \
ja auch wenig Sinn, denn eine Reihenentwicklung beschreibt ja das Aussehen \
einer Funktion in der N\[ADoubleDot]he eines Punkts. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"f", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"f", "/.", 
  RowBox[{"x", "\[Rule]", "1"}]}]}], "Input"],

Cell[TextData[{
 "Mit ",
 StyleBox["Norma",
  FontSlant->"Italic"],
 StyleBox["l ",
  FontSlant->"Italic"],
 "kann man aber den polynomialen Teil der Reihe extrahieren und weiter \
verarbeiten. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"f1", "=", 
  RowBox[{"Normal", "[", "f", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"f1", "/.", 
  RowBox[{"x", "\[Rule]", "1"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "f1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "\[Pi]"}], ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dashed"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f2", "=", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "f1", ",", "f2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "\[Pi]"}], ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dotted", ",", "Dashed"}], "}"}]}]}], 
  "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Mit Potenzreihen rechnen", "Subsection"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"Tan", "[", "x", "]"}], "]"}], "+", 
  SuperscriptBox[
   RowBox[{"O", "[", 
    RowBox[{"x", ",", "\[Pi]"}], "]"}], "8"]}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"3", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"5", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"], "+", 
  SuperscriptBox[
   RowBox[{"O", "[", 
    RowBox[{"x", ",", "1"}], "]"}], "9"]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Normal"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"4", "x"}]}]]}], ";"}], "\n", 
 RowBox[{"s1", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "+", "s2"}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", " ", "s2"}]], "Input"],

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", 
      RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 SuperscriptBox["s", "2"]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], "s1"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"s1", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"f", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "+", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "-", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  FractionBox["1", "s1"]}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", " ", "s2"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["1", "f"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["s1", 
    RowBox[{"Cos", "[", "x", "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"InverseSeries", "[", 
   RowBox[{"s1", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["ComposeSeries",
  FontWeight->"Bold"],
 "[f,g] funktioniert nur, wenn die beiden Reihen \"verkettet\" sind, d.h. \
wenn der konstante Term in g mit dem Expansionspunkt von f \
\[UDoubleDot]bereinstimmt. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";", 
  RowBox[{"sf", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Tan", "[", "x", "]"}]}], ";", 
  RowBox[{"sg", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{"sf", ",", "sg"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"invsf", "=", 
  RowBox[{"InverseSeries", "[", 
   RowBox[{"sf", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{"sf", ",", "invsf"}], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Differentiation", "Section"],

Cell[CellGroupData[{

Cell["Ableitungen einstelliger Funktionen ", "Subsection"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "2"], "+", "x"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "2"], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Die Notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", "A", ")"}], " "}], TraditionalForm]]],
 "wird intern sofort in die Notation ",
 StyleBox["D[A,x] ",
  FontWeight->"Bold"],
 "umgesetzt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "2"], "+", "x"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", "x"], 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", "1"}], 
    RowBox[{
     SuperscriptBox["x", "3"], "-", "1"}]]}], " ", "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"Sin", "[", 
   RowBox[{"Cos", "[", "x", "]"}], "]"}]}]], "Input"],

Cell[TextData[{
 "Ist im Ausdruck ",
 StyleBox["A",
  FontWeight->"Bold"],
 " eine Funktion ",
 StyleBox["f",
  FontWeight->"Bold"],
 " enthalten, deren Ableitung nicht bekannt ist, so wird ",
 StyleBox["D[A,x]",
  FontWeight->"Bold"],
 " in einen Ausdruck umgeformt, der ",
 StyleBox["f",
  FontWeight->"Bold"],
 " und ",
 StyleBox["f'",
  FontWeight->"Bold"],
 " (FullForm: ",
 StyleBox["Derivative[1][f]",
  FontWeight->"Bold"],
 ") etc. enth\[ADoubleDot]lt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"g", "[", "x", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", "x"], 
   FractionBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"g", "[", "x", "]"}]]}], " ", "//", "Together"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", "x"}], "]"}]}], ";"}]], "Input",
 PageWidth->Infinity,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontColor->GrayLevel[0],
 Background->GrayLevel[1]],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"f", "[", "x", "]"}]}], ")"}]}], ")"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "x", ",", "x", ",", "x"}]], " ", 
  RowBox[{"f", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}]], 
  RowBox[{"f", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "''''"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "'"}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "'"}], ",", 
   RowBox[{"Sqrt", "'"}], ",", 
   RowBox[{"Log", "'"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Achtung, die folgende Definition werden Sie nicht so schnell \
wieder los.",
  FontColor->RGBColor[1, 0, 0]],
 " Unklar bleibt, wo sie von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gespeichert wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "2"]}], "+", "5"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"y", ",", "y"}]], 
  RowBox[{"f", "[", "y", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "y", "]"}], ",", "y", ",", "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "\[CapitalUDoubleDot]brigens hat die Definition von f' keinen Einfluss auf \
f'', denn f' ist als ",
 StyleBox["Derivative[1][f] ",
  FontWeight->"Bold"],
 "codiert, f'' dagegen als ",
 StyleBox["Derivative[2][f]",
  FontWeight->"Bold"],
 ". Das Muster der Definition passt also nicht. ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[PartialD]", 
    RowBox[{"y", ",", "y"}]], 
   RowBox[{"f", "[", "y", "]"}]}]],
  CellChangeTimes:>{3.35115476742904*^9}],
 "dagegen ist als ",
 StyleBox["D[f[y],y,y]",
  FontWeight->"Bold"],
 " codiert."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "''"}], "[", "x", "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ableitungen mehrstelliger Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "x"}], "]"}], ",", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "3"]}], ")"}], "4"]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "y"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "y"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"y", ",", "x"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "3"]}], ")"}], "4"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", 
    RowBox[{"x", ",", "x"}]], 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "y", ",", "y", ",", "z"}]], " ", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Totales Differential", "Subsection"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "3"]}], ")"}], "4"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "3"]}], ")"}], "4"], ",", "x", ",", " ", 
   RowBox[{"Constants", "\[Rule]", "y"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x", ",", " ", 
   RowBox[{"Constants", "\[Rule]", "a"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "/:", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}], "=", "0"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"a", ",", "Constant"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["a", "2"]}], ",", "x"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ein Beispiel", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", " ", "/:", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"y", ",", "x"}], "]"}], "=", "k"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gl", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "16"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"gldt", "=", 
  RowBox[{"Dt", "[", 
   RowBox[{"gl", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"{", 
   RowBox[{"gl", ",", "gldt"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqns", ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqns", ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"eqns", ",", "k", ",", "y"}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"k", "/.", 
       RowBox[{
       "lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "]"}],
      ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "6"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", "gl", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]}], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Integration", "Section"],

Cell[CellGroupData[{

Cell["Einf\[UDoubleDot]hrung", "Subsection"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "2", "3"], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "a", "b"], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Integrale rationaler Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "5"], "-", 
     RowBox[{"2", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"2", 
      SuperscriptBox["x", "3"]}], "-", "x", "+", "1"}], 
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["x", "n"], "-", 
        RowBox[{"2", "x"}], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"i1", "//", "Normal"}]], "Input"],

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]}], 
     RowBox[{"x", "+", 
      SqrtBox["x"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"i3", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "n"], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"i3", "/.", 
     RowBox[{"n", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"i3", "/.", 
     RowBox[{"n", "\[Rule]", "3"}]}], "]"}], ",", 
   RowBox[{"i4", "=", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["x", "3"], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "}"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FunctionExpand", "[", 
   RowBox[{"i3", "/.", 
    RowBox[{"n", "\[Rule]", "3"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"i5", "=", 
  RowBox[{"PowerExpand", "[", "%", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i4", ",", "i5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"i4", "-", "i5"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Elliptische Integrale", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"n", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Alpha]", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "\[Alpha]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"i6", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "\[Alpha]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"i6", ",", "\[Alpha]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"i7", "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox["x", 
      RowBox[{
       SuperscriptBox["x", "3"], "+", 
       SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]], 
    RowBox[{"\[DifferentialD]", "x"}], " "}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"i7", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Das Ergebnis i7 stellt Sie sicher nicht zufrieden, da die verschiedenen \
Wurzeln zusammengefasst werden k\[ODoubleDot]nnen. Aus Gr\[UDoubleDot]nden \
der mathematischen Exaktheit l\[ADoubleDot]sst sich das mit den \
\[UDoubleDot]blichen Simplifikationskommandos nicht bewerkstelligen.\n\nDas n\
\[ADoubleDot]chste Kommando extrahiert alle Terme des Produkts bis auf den \
letzten. Dazu wird das Produkt in eine Liste verwandelt, ",
 StyleBox["DeleteCases",
  FontWeight->"Bold"],
 " angewendet und danach das Ergebnis wieder in eine Liste verwandelt. Nat\
\[UDoubleDot]rlich k\[ODoubleDot]nnen Sie alternativ auch die zu \
untersuchenden Teilausdr\[UDoubleDot]cke mit der Maus markieren und in eine \
neue Zelle kopieren."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{"Times", "@@", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"List", "@@", "i7"}], ",", "_EllipticPi"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SuperscriptBox["u", "2"], "//", "Together"}]}], "Input"],

Cell[TextData[{
 "Auch h\[ADoubleDot]tte es nicht des Umwegs \[UDoubleDot]ber eine Liste \
bedurft, da ",
 StyleBox["DeleteCases",
  FontWeight->"Bold"],
 " auch auf allgemeinere Ausdr\[UDoubleDot]cke angewendet werden kann. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{"i7", ",", "_EllipticPi"}], "]"}]], "Input"],

Cell["\<\
Das Integral i7 sollte also zum folgenden Ausdruck \[ADoubleDot]quivalent \
sein.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"i8", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{"2", "-", 
     RowBox[{"2", "I"}]}]], 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"1", "-", "I"}], ",", 
     RowBox[{"ArcSin", "[", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "I"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}]}], 
        RowBox[{"2", "x"}]]], "]"}], ",", 
     RowBox[{"-", "I"}]}], "]"}]}]}]], "Input"],

Cell[TextData[{
 "Alternativ h\[ADoubleDot]tten Sie nat\[UDoubleDot]rlich auch einfach ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["i7", "2"], " "}]],
  CellChangeTimes:>{3.35117232134555*^9}],
 "berechnen k\[ODoubleDot]nnen:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["i7", "2"], "//", "Together"}]], "Input"],

Cell["\<\
Versuchen wir die Probe, indem wieder die Ableitung der Stammfunktion i6 \
berechnet wird.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"a8", "=", 
  RowBox[{"D", "[", 
   RowBox[{"i8", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"a8", "//", "Simplify"}]], "Input"],

Cell["\<\
Leider dasselbe Problem wie oben mit den Wurzeln. Wir quadrieren einfach \
wieder. i6 ist also bis auf das Vorzeichen die richtige Stammfunktion und \
mehr k\[ODoubleDot]nnen wir auch nicht erwarten, da f\[UDoubleDot]r komplexe \
x der Radikand selbst nur bis aufs Vorzeichen eindeutig bestimmt ist. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  SuperscriptBox["a8", "2"], "//", "Together"}], "\[IndentingNewLine]", 
 RowBox[{
  SuperscriptBox["a8", "2"], "//", "Simplify"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Mehrfachintegrale", "Subsection"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", "2"], 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", "3"], 
   RowBox[{"1", 
    RowBox[{"\[DifferentialD]", "y"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell["\<\
Bei vielen bestimmten Mehrfachintegralen ist die Reihenfolge des \
Abintegrierens  relevant, da die Grenzen des inneren Integrals von der \
\[ADoubleDot]u\[SZ]eren Integrationsvariablen abh\[ADoubleDot]ngen k\
\[ODoubleDot]nnen! Die beiden folgenden Integrale sind gleichwertig, einmal \
in der Formelschreibweise, einmal als konventionelles Kommando; beachten Sie \
beim zweiten Beispiel, dass das innere Integral durch den \
\[ADoubleDot]u\[SZ]eren Parameter angegeben wird (w\[ADoubleDot]hrend bei der \
Formelschreibweise das innere Integral nat\[UDoubleDot]rlich innen steht)\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]], 
   RowBox[{"1", 
    RowBox[{"\[DifferentialD]", "y"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"1", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", "1"], 
   RowBox[{
    UnderoverscriptBox["\[Integral]", "0", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]], " ", 
    RowBox[{
     SuperscriptBox["E", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "y"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{
   UnderoverscriptBox["\[Integral]", "0", 
    RowBox[{"\[Pi]", "/", "2"}]], 
   RowBox[{
    UnderoverscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     SuperscriptBox["E", 
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}]], "r", 
     RowBox[{"\[DifferentialD]", "r"}], 
     RowBox[{"\[DifferentialD]", "\[Phi]"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", " ", "//", "N"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     SuperscriptBox["E", 
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}]], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Phi]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}], ",", "z"}], "}"}], ",", "\n", 
     "\t\t", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"1", "/", "E"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerische Integration", "Subsection"],

Cell["\<\
F\[UDoubleDot]r eine Reihe von Integralen, f\[UDoubleDot]r die keine \
geschlossenen symbolischen Ausdr\[UDoubleDot]cke existieren, kann numerische \
Integration versucht werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "1", "3"], 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "x"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "x"}], ")"}]}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "x"}], ")"}]}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "u_", "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"1", "/", "x"}]], "-", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "u"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"PaddedForm", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          SuperscriptBox["10", "n"], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "2", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "10", ",", "1000"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "u", "]"}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Log", "[", "u", "]"}], "2"], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "3", ",", 
     SuperscriptBox["10", "3"]}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Dotted"}], "}"}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Uneigentliche Integrale", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"1", "/", "2"}]]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   SuperscriptBox["E", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"s", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"s", ",", "30"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", "x"]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", "x"}], "]"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "a"}]}], "}"}]}], "]"}], "+", 
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "b", ",", "1"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "a"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"Re", "[", "a", "]"}], ">", "0"}]}]}], "]"}], "+", 
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "b", ",", "1"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"Re", "[", "b", "]"}], ">", "0"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "2"]}], ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", 
   FractionBox["\[Pi]", "2"]], 
  RowBox[{"f", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "2"]}], ",", 
     FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f0", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"f0", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], "<", "x", "<", 
      FractionBox["\[Pi]", "2"]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"f0", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", "<", "x", "<", 
      FractionBox["\[Pi]", "2"]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Normal", "[", "s", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "100"}], ",", "100"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Dotted"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "-", 
     FractionBox[
      SqrtBox["2"], "x"]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "-", 
     FractionBox[
      SqrtBox["2"], "x"]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], ",", 
      FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"i2", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"i3", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "-", 
     FractionBox[
      SqrtBox["2"], 
      RowBox[{"Abs", "[", "x", "]"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], ",", 
      FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Integrale mit Parametern", "Subsection"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["E", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox["E", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "a", "]"}], ">", "0"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox["E", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     SuperscriptBox["x", "2"]}]], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "a", "]"}], "<", "0"}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Pfadintegrale im Komplexen", "Subsection"],

Cell["\<\
F\[UDoubleDot]r gen\[UDoubleDot]gend glatte Funktionen gilt der Hauptsatz der \
Integralrechnung auch im Komplexen. Deshalb k\[ODoubleDot]nnen die folgenden \
bestimmten Integrale \[UDoubleDot]ber Einsetzen der Integrationsgrenzen in \
die Stammfunktion ermittelt werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"1", "+", "I"}]], 
  RowBox[{
   SuperscriptBox["z", "2"], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"\[Pi]", " ", "I"}]], 
  RowBox[{"z", " ", 
   RowBox[{"Cos", "[", 
    SuperscriptBox["z", "2"], "]"}], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input"],

Cell[TextData[{
 "Hat die Funktion dagegen Singularit\[ADoubleDot]ten wie hier ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "z"], TraditionalForm]]],
 " eine Polstelle bei z=0, so ist der Wert des Integrals vom Integrationsweg \
abh\[ADoubleDot]ngig. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
W\[UDoubleDot]rde der Hauptsatz der Integralrechnung zur Anwendung kommen, so \
w\[ADoubleDot]re das Ergebnis gleich -\[ImaginaryI] \[Pi]. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "[", "z_", "]"}], "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", "z"], 
    RowBox[{"\[DifferentialD]", "z"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F", "[", "1", "]"}], "-", 
  RowBox[{"F", "[", 
   RowBox[{"-", "1"}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Diese Rechnung zeigt, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (nun) wei\[SZ], dass der Wert des Integrals vom Integrationspfad abh\
\[ADoubleDot]ngt.\n\n",
 StyleBox["Integrate",
  FontWeight->"Bold"],
 " verwendet als Pfad immer die direkte geradlinige Verbindung zwischen den \
Integrationsgrenzen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", ">", "0"}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], 
     RowBox[{"1", "+", 
      RowBox[{"I", " ", "a"}]}]], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", "<", "0"}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], 
     RowBox[{"1", "+", 
      RowBox[{"I", " ", "a"}]}]], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"1", "+", "a"}], "]"}], "-", 
  RowBox[{"F", "[", 
   RowBox[{"-", "1"}], "]"}]}]], "Input"],

Cell[TextData[{
 "Im zweiten Parameter des ",
 StyleBox["Integrate",
  FontWeight->"Bold"],
 "-Kommandos k\[ODoubleDot]nnen mehrere St\[UDoubleDot]tzstellen angegeben \
werden. Das zugeh\[ODoubleDot]rige Integral wird als Summe der Teilintegrale \
berechnet."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", "z", "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " die Stammfunktion nicht berechnen, so wird das Integral unausgewertet zur\
\[UDoubleDot]ckgegeben. In diesen F\[ADoubleDot]llen kann eine numerische \
Auswertung mit ",
 StyleBox["% // N",
  FontWeight->"Bold"],
 " oder ",
 StyleBox["NIntegrate",
  FontWeight->"Bold"],
 " noch zu brauchbaren numerischen Werten f\[UDoubleDot]hren. Die symbolische \
Ausertung dauert hier ziemlich lange."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell["\<\
Viele Warnungen ergeben sich, wenn der Wert des Integrals gleich Null ist. \
Hier hilft oft eine Zerlegung des Integrationspfades in mehrere Teile.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["z", "2"], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Sin", "[", 
      SuperscriptBox["z", "2"], "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1", ",", "I", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "+", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Sin", "[", 
      SuperscriptBox["z", "2"], "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "I", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Eine (etwas komplexere) Analyse der Residuen zeigt, dass das richtige \
Ergebnis 2 \[ImaginaryI] \[Pi] lautet. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], "\[Equal]", "0"}], ",", "z"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], "\[Equal]", "0"}], ",", "z"}], 
  "]"}]], "Input"],

Cell["\<\
Die L\[ODoubleDot]sung kann auch k\[UDoubleDot]rzer als 
   z \[Equal] ArcSin[\[Pi] C[1]]+ \[Pi] C[2], C[1],C[2] \[Element] Integers
geschrieben werden. Von diesen liegt genau z=0 im Gebiet, welches vom \
Integrationspfad umschlossen wird. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Nach dem Resiudensatz ist also das Integral gleich 2 \[ImaginaryI] \[Pi].\n\
Die folgende Aufstellung zeigt, dass alle anderen ",
 StyleBox["z",
  FontSlant->"Italic"],
 " bereits einen zu gro\[SZ]en Realteil haben."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{"k", " ", "\[Pi]"}], "]"}], "//", "N"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell["Pfadintegrale lassen sich auch direkt berechnen.", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pfadIntegral", "[", 
   RowBox[{"f_", ",", "z_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", "[", "t", "]"}], "]"}], 
     RowBox[{
      RowBox[{"z", "'"}], "[", "t", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input"],

Cell["\<\
F\[UDoubleDot]r obiges Beispiel und geradlinigen Pfad ergibt sich eine \
geschlossene Formel, die f\[UDoubleDot]r a\[Rule]+0 und a\[Rule]-0 \
verschiedene Werte ergibt.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "z_", "]"}], ":=", 
  RowBox[{"1", "/", "z"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"t", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"I", " ", "a"}]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "\[Element]", "Reals"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"pfadIntegral", "[", 
    RowBox[{"f", ",", "\[Gamma]"}], "]"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"%", ",", 
     RowBox[{"a", "\[Rule]", "0"}], ",", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]}]], "Input"],

Cell["\<\
Auch hier darf nicht einfach der Hauptsatz der Integralrechnung zur Anwendung \
kommen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"\[Gamma]", "[", "t", "]"}], "]"}], 
     RowBox[{
      RowBox[{"\[Gamma]", "'"}], "[", "t", "]"}]}], ",", "t"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "1"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "0"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"%", ",", 
     RowBox[{"a", "\[Rule]", "0"}], ",", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]}]], "Input"],

Cell[TextData[{
 "Pfadintegrale lassen sich mit ",
 StyleBox["pfadIntegral",
  FontWeight->"Bold"],
 " auch \[UDoubleDot]ber kompliziertere Pfade berechnen."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "\[Pi]", " ", "t"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Pi]", " ", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pfadIntegral", "[", 
  RowBox[{"f", ",", "\[Gamma]"}], "]"}]}], "Input"],

Cell["\<\
Das dauert manchmal l\[ADoubleDot]nger, denn auch hier gilt, dass nicht \
einfach der Haupsatz der Integralrechnung angewendet werden kann. Die \
Stammfunktion selbst ist schnell berechnet.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", "z", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "\[Pi]", " ", "t"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Pi]", " ", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pfadIntegral", "[", 
   RowBox[{"f", ",", "\[Gamma]"}], "]"}], "//", "Timing"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"\[Gamma]", "[", "t", "]"}], "]"}], 
  RowBox[{
   RowBox[{"\[Gamma]", "'"}], "[", "t", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"%", ",", "t"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "1"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"u", "/.", 
    RowBox[{"t", "\[Rule]", "0"}]}], ")"}]}]], "Input"],

Cell["Residuen", "SmallText"],

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", "z", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["z", "2"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["z", "2"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Als Beispiel berechnen wir das komplexe\nWegintegral auf dem Kreis um den \
Mittelpunkt z=0 und mit dem Radius ",
 Cell[BoxData[
  FormBox[
   FractionBox["3", "2"], TraditionalForm]]],
 " f\[UDoubleDot]r die Funktion \[LineSeparator]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"22", "z"}], "+", "8"}], 
    RowBox[{
     SuperscriptBox["z", "3"], "-", 
     RowBox[{"5", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"4", "z"}]}]]}]], "Input",
  CellChangeTimes->{3.36422119653342*^9}],
 "."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "z"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"22", "z"}], "+", "8"}], 
    RowBox[{
     SuperscriptBox["z", "3"], "-", 
     RowBox[{"5", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"4", "z"}]}]]}], ";"}]}], "Input"],

Cell["Bestimmen der Singularit\[ADoubleDot]ten.", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Denominator", "[", 
     RowBox[{"f", "[", "z", "]"}], "]"}], "\[Equal]", "0"}], ",", "z"}], 
  "]"}]], "Input"],

Cell["\<\
Summe \[UDoubleDot]ber die Residuen innerhalb des Integrationsbereichs.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", "I", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0"}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1"}], "}"}]}], "]"}]}], ")"}], " "}]], "Input"],

Cell[TextData[{
 StyleBox["pfadIntegral",
  FontWeight->"Bold"],
 " liefert dasselbe Ergebnis."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"3", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", "\[Pi]", " ", "t"}], "]"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "\[Pi]", " ", "t"}], "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pfadIntegral", "[", 
  RowBox[{"f", ",", "\[Gamma]"}], "]"}]}], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{659, 629},
WindowMargins->{{Automatic, 254}, {Automatic, 14}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 50, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[665, 27, 40, 0, 55, "Section"],
Cell[708, 29, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[809, 34, 41, 0, 45, "Subsection"],
Cell[853, 36, 165, 5, 43, "Input"],
Cell[1021, 43, 267, 9, 44, "Input"],
Cell[1291, 54, 222, 7, 42, "Input"],
Cell[1516, 63, 304, 10, 45, "Input"],
Cell[1823, 75, 56, 0, 42, "SmallText"],
Cell[1882, 77, 169, 5, 41, "Input"],
Cell[2054, 84, 217, 6, 41, "Input"],
Cell[2274, 92, 319, 10, 44, "Input"],
Cell[2596, 104, 146, 3, 42, "SmallText"],
Cell[2745, 109, 244, 8, 44, "Input"],
Cell[2992, 119, 278, 9, 58, "Input"],
Cell[3273, 130, 96, 2, 42, "SmallText"],
Cell[3372, 134, 165, 5, 58, "Input"],
Cell[3540, 141, 223, 7, 58, "Input"],
Cell[3766, 150, 81, 2, 42, "SmallText"],
Cell[3850, 154, 306, 11, 71, "Input"],
Cell[4159, 167, 171, 5, 46, "Input"],
Cell[4333, 174, 266, 6, 59, "SmallText"],
Cell[4602, 182, 195, 6, 59, "Input"],
Cell[4800, 190, 189, 6, 59, "Input"],
Cell[4992, 198, 276, 9, 59, "Input"],
Cell[5271, 209, 246, 8, 44, "Input"],
Cell[5520, 219, 75, 0, 42, "SmallText"],
Cell[5598, 221, 259, 8, 59, "Input"],
Cell[5860, 231, 133, 3, 42, "SmallText"],
Cell[5996, 236, 329, 12, 71, "Input"],
Cell[6328, 250, 213, 7, 44, "Input"],
Cell[6544, 259, 156, 4, 44, "Input"],
Cell[6703, 265, 199, 6, 44, "Input"],
Cell[6905, 273, 183, 4, 59, "SmallText"],
Cell[7091, 279, 206, 6, 44, "Input"],
Cell[7300, 287, 206, 6, 44, "Input"],
Cell[7509, 295, 178, 3, 42, "SmallText"],
Cell[7690, 300, 287, 8, 44, "Input"],
Cell[7980, 310, 159, 3, 59, "SmallText"],
Cell[8142, 315, 351, 10, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[8530, 330, 34, 0, 29, "Subsection"],
Cell[8567, 332, 44, 0, 42, "SmallText"],
Cell[8614, 334, 173, 5, 28, "Input"],
Cell[8790, 341, 172, 5, 28, "Input"],
Cell[8965, 348, 215, 7, 43, "Input"],
Cell[9183, 357, 181, 6, 36, "Input"],
Cell[9367, 365, 58, 1, 28, "Input"],
Cell[9428, 368, 235, 6, 28, "Input"],
Cell[9666, 376, 266, 8, 28, "Input"],
Cell[9935, 386, 94, 2, 42, "SmallText"],
Cell[10032, 390, 198, 6, 28, "Input"],
Cell[10233, 398, 159, 5, 43, "Input"],
Cell[10395, 405, 119, 3, 42, "SmallText"],
Cell[10517, 410, 142, 4, 44, "Input"],
Cell[10662, 416, 189, 2, 45, "Text"],
Cell[10854, 420, 324, 11, 62, "Input"],
Cell[11181, 433, 116, 3, 44, "Input"],
Cell[11300, 438, 141, 4, 44, "Input"],
Cell[11444, 444, 239, 4, 59, "SmallText"],
Cell[11686, 450, 264, 8, 65, "Input"],
Cell[11953, 460, 212, 8, 42, "SmallText"],
Cell[12168, 470, 83, 2, 44, "Input"],
Cell[12254, 474, 80, 2, 44, "Input"],
Cell[12337, 478, 406, 13, 44, "Input"],
Cell[12746, 493, 239, 7, 44, "Input"],
Cell[12988, 502, 435, 14, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[13460, 521, 46, 0, 29, "Subsection"],
Cell[13509, 523, 204, 6, 28, "Input"],
Cell[13716, 531, 192, 6, 30, "Input"],
Cell[13911, 539, 267, 9, 30, "Input"],
Cell[14181, 550, 55, 1, 28, "Input"],
Cell[14239, 553, 55, 1, 28, "Input"],
Cell[14297, 556, 76, 1, 28, "Input"],
Cell[14376, 559, 280, 10, 54, "Input"],
Cell[14659, 571, 233, 7, 28, "Input"],
Cell[14895, 580, 51, 1, 28, "Input"],
Cell[14949, 583, 51, 1, 28, "Input"],
Cell[15003, 586, 326, 10, 44, "Input"],
Cell[15332, 598, 50, 1, 46, "Input"],
Cell[15385, 601, 77, 2, 44, "Input"],
Cell[15465, 605, 76, 2, 44, "Input"],
Cell[15544, 609, 141, 4, 44, "Input"],
Cell[15688, 615, 107, 3, 57, "Input"],
Cell[15798, 620, 106, 3, 57, "Input"],
Cell[15907, 625, 141, 4, 44, "Input"],
Cell[16051, 631, 80, 2, 44, "Input"],
Cell[16134, 635, 50, 1, 44, "Input"],
Cell[16187, 638, 72, 2, 58, "Input"],
Cell[16262, 642, 51, 1, 44, "Input"],
Cell[16316, 645, 163, 5, 58, "Input"],
Cell[16482, 652, 196, 6, 60, "Input"],
Cell[16681, 660, 200, 6, 44, "Input"],
Cell[16884, 668, 115, 3, 44, "Input"],
Cell[17002, 673, 175, 5, 44, "Input"],
Cell[17180, 680, 248, 6, 59, "SmallText"],
Cell[17431, 688, 249, 8, 44, "Input"],
Cell[17683, 698, 249, 8, 44, "Input"],
Cell[17935, 708, 91, 2, 44, "Input"],
Cell[18029, 712, 204, 6, 44, "Input"],
Cell[18236, 720, 118, 3, 44, "Input"],
Cell[18357, 725, 94, 2, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18500, 733, 34, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[18559, 737, 58, 0, 45, "Subsection"],
Cell[18620, 739, 163, 5, 30, "Input"],
Cell[18786, 746, 212, 7, 30, "Input"],
Cell[19001, 755, 281, 11, 42, "SmallText"],
Cell[19285, 768, 190, 6, 30, "Input"],
Cell[19478, 776, 242, 9, 47, "Input"],
Cell[19723, 787, 137, 4, 28, "Input"],
Cell[19863, 793, 479, 20, 59, "SmallText"],
Cell[20345, 815, 81, 2, 28, "Input"],
Cell[20429, 819, 178, 6, 28, "Input"],
Cell[20610, 827, 195, 6, 45, "Input"],
Cell[20808, 835, 133, 4, 44, "Input"],
Cell[20944, 841, 58, 1, 44, "Input"],
Cell[21005, 844, 274, 10, 44, "Input"],
Cell[21282, 856, 356, 12, 44, "Input"],
Cell[21641, 870, 153, 4, 44, "Input"],
Cell[21797, 876, 153, 5, 44, "Input"],
Cell[21953, 883, 75, 2, 44, "Input"],
Cell[22031, 887, 80, 2, 44, "Input"],
Cell[22114, 891, 146, 5, 44, "Input"],
Cell[22263, 898, 58, 1, 44, "Input"],
Cell[22324, 901, 256, 8, 59, "SmallText"],
Cell[22583, 911, 197, 7, 46, "Input"],
Cell[22783, 920, 128, 4, 44, "Input"],
Cell[22914, 926, 76, 1, 44, "Input"],
Cell[22993, 929, 116, 3, 44, "Input"],
Cell[23112, 934, 155, 5, 44, "Input"],
Cell[23270, 941, 572, 19, 78, "SmallText"],
Cell[23845, 962, 73, 2, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[23955, 969, 58, 0, 29, "Subsection"],
Cell[24016, 971, 463, 16, 36, "Input"],
Cell[24482, 989, 208, 7, 32, "Input"],
Cell[24693, 998, 232, 8, 32, "Input"],
Cell[24928, 1008, 232, 8, 32, "Input"],
Cell[25163, 1018, 235, 8, 32, "Input"],
Cell[25401, 1028, 187, 6, 28, "Input"],
Cell[25591, 1036, 76, 1, 28, "Input"],
Cell[25670, 1039, 138, 4, 28, "Input"],
Cell[25811, 1045, 62, 1, 28, "Input"],
Cell[25876, 1048, 187, 5, 28, "Input"],
Cell[26066, 1055, 57, 1, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26160, 1061, 42, 0, 29, "Subsection"],
Cell[26205, 1063, 182, 6, 36, "Input"],
Cell[26390, 1071, 210, 7, 36, "Input"],
Cell[26603, 1080, 210, 7, 36, "Input"],
Cell[26816, 1089, 263, 8, 36, "Input"],
Cell[27082, 1099, 214, 7, 30, "Input"],
Cell[27299, 1108, 267, 8, 30, "Input"],
Cell[27569, 1118, 143, 4, 28, "Input"],
Cell[27715, 1124, 214, 7, 30, "Input"],
Cell[27932, 1133, 61, 1, 28, "Input"],
Cell[27996, 1136, 96, 2, 28, "Input"],
Cell[28095, 1140, 214, 7, 46, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28346, 1152, 34, 0, 29, "Subsection"],
Cell[28383, 1154, 143, 4, 28, "Input"],
Cell[28529, 1160, 179, 6, 30, "Input"],
Cell[28711, 1168, 106, 3, 28, "Input"],
Cell[28820, 1173, 103, 3, 28, "Input"],
Cell[28926, 1178, 84, 2, 28, "Input"],
Cell[29013, 1182, 85, 2, 28, "Input"],
Cell[29101, 1186, 120, 3, 28, "Input"],
Cell[29224, 1191, 1006, 32, 69, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30279, 1229, 30, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[30334, 1233, 44, 0, 45, "Subsection"],
Cell[30381, 1235, 231, 8, 41, "Input"],
Cell[30615, 1245, 263, 9, 44, "Input"],
Cell[30881, 1256, 263, 9, 44, "Input"],
Cell[31147, 1267, 220, 7, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[31404, 1279, 53, 0, 29, "Subsection"],
Cell[31460, 1281, 387, 13, 47, "Input"],
Cell[31850, 1296, 372, 12, 42, "Input"],
Cell[32225, 1310, 56, 1, 28, "Input"],
Cell[32284, 1313, 279, 10, 52, "Input"],
Cell[32566, 1325, 209, 7, 42, "Input"],
Cell[32778, 1334, 476, 15, 43, "Input"],
Cell[33257, 1351, 249, 7, 49, "Input"],
Cell[33509, 1360, 190, 6, 44, "Input"],
Cell[33702, 1368, 138, 4, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[33877, 1377, 43, 0, 29, "Subsection"],
Cell[33923, 1379, 98, 2, 28, "Input"],
Cell[34024, 1383, 274, 9, 49, "Input"],
Cell[34301, 1394, 248, 8, 41, "Input"],
Cell[34552, 1404, 85, 2, 28, "Input"],
Cell[34640, 1408, 57, 1, 28, "Input"],
Cell[34700, 1411, 280, 9, 51, "Input"],
Cell[34983, 1422, 78, 2, 28, "Input"],
Cell[35064, 1426, 57, 1, 28, "Input"],
Cell[35124, 1429, 758, 13, 161, "SmallText"],
Cell[35885, 1444, 271, 8, 66, "Input"],
Cell[36159, 1454, 243, 6, 59, "SmallText"],
Cell[36405, 1462, 98, 2, 44, "Input"],
Cell[36506, 1466, 110, 3, 42, "SmallText"],
Cell[36619, 1471, 500, 18, 67, "Input"],
Cell[37122, 1491, 246, 7, 44, "SmallText"],
Cell[37371, 1500, 82, 2, 46, "Input"],
Cell[37456, 1504, 119, 3, 42, "SmallText"],
Cell[37578, 1509, 103, 3, 44, "Input"],
Cell[37684, 1514, 58, 1, 44, "Input"],
Cell[37745, 1517, 329, 5, 76, "SmallText"],
Cell[38077, 1524, 167, 4, 68, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[38281, 1533, 39, 0, 29, "Subsection"],
Cell[38323, 1535, 243, 7, 63, "Input"],
Cell[38569, 1544, 609, 9, 110, "SmallText"],
Cell[39181, 1555, 311, 10, 73, "Input"],
Cell[39495, 1567, 294, 9, 56, "Input"],
Cell[39792, 1578, 516, 17, 89, "Input"],
Cell[40311, 1597, 50, 1, 44, "Input"],
Cell[40364, 1600, 389, 12, 79, "Input"],
Cell[40756, 1614, 55, 1, 44, "Input"],
Cell[40814, 1617, 1114, 34, 114, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[41965, 1656, 44, 0, 29, "Subsection"],
Cell[42012, 1658, 207, 4, 59, "SmallText"],
Cell[42222, 1664, 188, 6, 44, "Input"],
Cell[42413, 1672, 50, 1, 28, "Input"],
Cell[42466, 1675, 195, 6, 30, "Input"],
Cell[42664, 1683, 335, 10, 52, "Input"],
Cell[43002, 1695, 290, 9, 46, "Input"],
Cell[43295, 1706, 256, 8, 44, "Input"],
Cell[43554, 1716, 257, 8, 44, "Input"],
Cell[43814, 1726, 359, 11, 66, "Input"],
Cell[44176, 1739, 497, 15, 44, "Input"],
Cell[44676, 1756, 172, 5, 44, "Input"],
Cell[44851, 1763, 440, 14, 46, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[45328, 1782, 45, 0, 29, "Subsection"],
Cell[45376, 1784, 374, 13, 43, "Input"],
Cell[45753, 1799, 468, 16, 51, "Input"],
Cell[46224, 1817, 398, 14, 33, "Input"],
Cell[46625, 1833, 501, 18, 51, "Input"],
Cell[47129, 1853, 78, 2, 28, "Input"],
Cell[47210, 1857, 358, 12, 58, "Input"],
Cell[47571, 1871, 281, 9, 44, "Input"],
Cell[47855, 1882, 221, 6, 44, "Input"],
Cell[48079, 1890, 384, 13, 59, "Input"],
Cell[48466, 1905, 259, 8, 44, "Input"],
Cell[48728, 1915, 335, 11, 44, "Input"],
Cell[49066, 1928, 555, 17, 65, "Input"],
Cell[49624, 1947, 542, 18, 79, "Input"],
Cell[50169, 1967, 164, 5, 64, "Input"],
Cell[50336, 1974, 222, 7, 57, "Input"],
Cell[50561, 1983, 110, 3, 44, "Input"],
Cell[50674, 1988, 271, 8, 57, "Input"],
Cell[50948, 1998, 219, 6, 57, "Input"],
Cell[51170, 2006, 167, 5, 44, "Input"],
Cell[51340, 2013, 546, 17, 85, "Input"],
Cell[51889, 2032, 265, 9, 64, "Input"],
Cell[52157, 2043, 317, 11, 64, "Input"],
Cell[52477, 2056, 51, 1, 44, "Input"],
Cell[52531, 2059, 351, 12, 66, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[52919, 2076, 46, 0, 29, "Subsection"],
Cell[52968, 2078, 247, 8, 60, "Input"],
Cell[53218, 2088, 369, 11, 37, "Input"],
Cell[53590, 2101, 369, 11, 37, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[53996, 2117, 48, 0, 29, "Subsection"],
Cell[54047, 2119, 300, 5, 76, "SmallText"],
Cell[54350, 2126, 188, 6, 63, "Input"],
Cell[54541, 2134, 234, 7, 78, "Input"],
Cell[54778, 2143, 273, 7, 70, "SmallText"],
Cell[55054, 2152, 187, 6, 58, "Input"],
Cell[55244, 2160, 168, 3, 42, "SmallText"],
Cell[55415, 2165, 310, 10, 80, "Input"],
Cell[55728, 2177, 356, 10, 93, "SmallText"],
Cell[56087, 2189, 325, 11, 60, "Input"],
Cell[56415, 2202, 325, 11, 60, "Input"],
Cell[56743, 2215, 148, 5, 44, "Input"],
Cell[56894, 2222, 276, 7, 59, "SmallText"],
Cell[57173, 2231, 238, 7, 58, "Input"],
Cell[57414, 2240, 270, 8, 60, "Input"],
Cell[57687, 2250, 57, 1, 44, "Input"],
Cell[57747, 2253, 483, 14, 76, "SmallText"],
Cell[58233, 2269, 303, 9, 60, "Input"],
Cell[58539, 2280, 50, 1, 44, "Input"],
Cell[58592, 2283, 176, 3, 59, "SmallText"],
Cell[58771, 2288, 298, 9, 64, "Input"],
Cell[59072, 2299, 547, 18, 64, "Input"],
Cell[59622, 2319, 304, 9, 60, "Input"],
Cell[59929, 2330, 140, 3, 42, "SmallText"],
Cell[60072, 2335, 180, 6, 44, "Input"],
Cell[60255, 2343, 181, 6, 44, "Input"],
Cell[60439, 2351, 269, 5, 76, "SmallText"],
Cell[60711, 2358, 219, 7, 60, "Input"],
Cell[60933, 2367, 251, 6, 59, "SmallText"],
Cell[61187, 2375, 253, 8, 44, "Input"],
Cell[61443, 2385, 69, 0, 42, "SmallText"],
Cell[61515, 2387, 395, 12, 65, "Input"],
Cell[61913, 2401, 197, 4, 59, "SmallText"],
Cell[62113, 2407, 753, 25, 105, "Input"],
Cell[62869, 2434, 275, 9, 44, "Input"],
Cell[63147, 2445, 116, 3, 42, "SmallText"],
Cell[63266, 2450, 263, 9, 44, "Input"],
Cell[63532, 2461, 207, 7, 44, "Input"],
Cell[63742, 2470, 275, 9, 44, "Input"],
Cell[64020, 2481, 174, 5, 42, "SmallText"],
Cell[64197, 2488, 390, 12, 65, "Input"],
Cell[64590, 2502, 218, 4, 59, "SmallText"],
Cell[64811, 2508, 574, 18, 85, "Input"],
Cell[65388, 2528, 162, 5, 44, "Input"],
Cell[65553, 2535, 109, 3, 44, "Input"],
Cell[65665, 2540, 207, 7, 44, "Input"],
Cell[65875, 2549, 29, 0, 42, "SmallText"],
Cell[65907, 2551, 188, 6, 44, "Input"],
Cell[66098, 2559, 215, 7, 46, "Input"],
Cell[66316, 2568, 224, 7, 46, "Input"],
Cell[66543, 2577, 660, 22, 102, "SmallText"],
Cell[67206, 2601, 444, 16, 84, "Input"],
Cell[67653, 2619, 62, 0, 42, "SmallText"],
Cell[67718, 2621, 186, 6, 44, "Input"],
Cell[67907, 2629, 100, 2, 42, "SmallText"],
Cell[68010, 2633, 423, 13, 44, "Input"],
Cell[68436, 2648, 112, 4, 42, "SmallText"],
Cell[68551, 2654, 471, 15, 65, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
