(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59331,       1679]
NotebookOptionsPosition[     54865,       1553]
NotebookOutlinePosition[     55275,       1571]
CellTagsIndexPosition[     55232,       1568]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Differentialgleichungen analysieren", "Title",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, 
   3.382549297319674*^9}],

Cell[CellGroupData[{

Cell["Analyse mit NDSolve", "Section",
 CellChangeTimes->{{3.36643149908654*^9, 3.36643150090416*^9}}],

Cell[TextData[{
 "Die folgende Gleichung hat wirklich nur die L\[ODoubleDot]sung y[x]=Sin[x], \
wenn man eine auf ganz ",
 StyleBox["R",
  FontWeight->"Bold"],
 " definierte sucht. Das wird deutlich, wenn man die numerischen L\
\[ODoubleDot]sungen mit ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " und verschiedenen Anfangswerten berechnet. Die n\[ADoubleDot]hern sich \
alle der Standardl\[ODoubleDot]sung an.\n\nDas sah in der Version 4.1 noch \
deutlich komplizierter aus."
}], "SmallText",
 CellChangeTimes->{{3.36595174484853*^9, 3.36595188988288*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{"eqn", ",", "y", ",", "x"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "//", "Simplify"}]}], "Input",\

 CellChangeTimes->{{3.36594981180802*^9, 3.36594985407313*^9}, {
  3.36629384311863*^9, 3.36629384379527*^9}, {3.36629388058093*^9, 
  3.36629389120363*^9}}],

Cell[TextData[{
 "Wir wollen das mit ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " \[UDoubleDot]berpr\[UDoubleDot]fen."
}], "SmallText",
 CellChangeTimes->{{3.36629441939901*^9, 3.36629443048162*^9}}],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36629439870486*^9, 3.36629440300401*^9}, 
   3.36629444879039*^9}],

Cell[BoxData[
 RowBox[{"nsol", "=", 
  RowBox[{"Join", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"eqn", "&&", 
        RowBox[{
         RowBox[{"y", "[", "0", "]"}], "\[Equal]", "i"}]}], ",", "y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2", ",", ".3"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.36595080485575*^9, 3.36595086821951*^9}, {
   3.3659509024931*^9, 3.36595096846599*^9}, 3.3662939122523*^9, {
   3.36629733716745*^9, 3.36629736735275*^9}}],

Cell[BoxData[
 RowBox[{"eqn", "/.", "nsol"}]], "Input",
 CellChangeTimes->{{3.36629982321367*^9, 3.36629985884435*^9}, 
   3.36630003528038*^9, {3.36630044239959*^9, 3.36630044591372*^9}, 
   3.389327236137587*^9, {3.389327266581481*^9, 3.389327287127642*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "nsol"}], "/.", 
  RowBox[{"x", "\[Rule]", "0.1"}]}]], "Input",
 CellChangeTimes->{{3.36629982321367*^9, 3.36629985884435*^9}, 
   3.36630003528038*^9, {3.36630044239959*^9, 3.36630044591372*^9}}],

Cell["Probe mit den N\[ADoubleDot]herungswerten", "SmallText",
 CellChangeTimes->{{3.36629847144352*^9, 3.36629847692351*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "-", 
    RowBox[{"eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    "nsol"}], "/.", 
  RowBox[{"x", "\[Rule]", "0.1"}]}]], "Input",
 CellChangeTimes->{{3.36629822332273*^9, 3.36629826970728*^9}, {
  3.36629850008482*^9, 3.36629850477446*^9}, {3.389324619950702*^9, 
  3.389324628920945*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Chop", "[", 
      RowBox[{"#", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "-", 
        RowBox[{
        "eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
        "nsol"}], "/.", 
      RowBox[{"x", "\[Rule]", "i"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36629805402524*^9, 3.36629817781134*^9}, {
  3.36629830465572*^9, 3.36629846145399*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "nsol"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36595087026301*^9, 3.36595088556989*^9}, {
   3.36595094636353*^9, 3.36595097636045*^9}, 3.36629391567157*^9, {
   3.389324652967844*^9, 3.389324683377347*^9}}],

Cell["\<\
L\[ODoubleDot]sungen mit einem Fourierreihenansatz suchen:\
\>", "SmallText",
 CellChangeTimes->{{3.36629938305972*^9, 3.36629939500775*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ansatz", "=", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["a", "i"], 
         RowBox[{"Cos", "[", 
          RowBox[{"i", " ", "x"}], "]"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "i"], 
         RowBox[{"Sin", "[", 
          RowBox[{"i", " ", "x"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "0"], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["a", "i"], ",", 
          SubscriptBox["b", "i"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "}"}], "//", 
    "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqn1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "-", 
    RowBox[{"eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "/.",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "\[Rule]", "ansatz"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{"ansatz", ",", "x"}], "]"}]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.36629871395035*^9, 3.36629882527604*^9}, {
  3.36629887260605*^9, 3.36629902265956*^9}, {3.36629908808674*^9, 
  3.36629908866346*^9}, {3.36629942742296*^9, 3.36629946348636*^9}, {
  3.36629950068845*^9, 3.36629950096134*^9}, {3.36629954781461*^9, 
  3.36629968674602*^9}, {3.36630222268173*^9, 3.36630222411183*^9}, {
  3.36630236138301*^9, 3.36630236329866*^9}, {3.389328619217005*^9, 
  3.389328619821755*^9}}],

Cell[BoxData[
 RowBox[{"sys", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"CoefficientList", "[", 
     RowBox[{"eqn1", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"i", " ", "x"}], "]"}], ",", 
           RowBox[{"Cos", "[", 
            RowBox[{"i", " ", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}], "]"}], "//",
     "Flatten"}], "//", "Union"}]}]], "Input",
 CellChangeTimes->{{3.36629903194139*^9, 3.36629921509261*^9}, {
  3.36630236838015*^9, 3.36630237834486*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"sys", "\[Equal]", "0"}], ",", "vars"}], "]"}], "//", 
   "Solve"}]}]], "Input",
 CellChangeTimes->{{3.36629948188407*^9, 3.36629949200914*^9}, {
  3.36629952720641*^9, 3.36629953827225*^9}, {3.36629965010696*^9, 
  3.36629965069156*^9}, {3.36630238922305*^9, 3.36630238993919*^9}}],

Cell[BoxData[
 RowBox[{"ansatz", "/.", "sol"}]], "Input",
 CellChangeTimes->{{3.36629964412651*^9, 3.36629964781536*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Ein komplexes Beispiel", "Section",
 CellChangeTimes->{{3.36643150400791*^9, 3.3664315075098*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", "x"}], ")"}]}], "+", 
     SuperscriptBox["x", "2"], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"y", "[", "x", "]"}], "2"], " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "==", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", 
     RowBox[{"DSolve", "[", 
      RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}], "]"}], "//", 
   "Simplify"}]}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36643991585594*^9, 3.36643993242137*^9}}],

Cell[TextData[{
 "Eine symbolische L\[ODoubleDot]sung mit der Randbedingung y[0]=4 kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nicht finden."
}], "SmallText",
 CellChangeTimes->{{3.36638279238511*^9, 3.36638279748694*^9}}],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "4"}]}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.36630491360188*^9, 3.36630491425002*^9}, {
  3.36638277014915*^9, 3.36638278850442*^9}}],

Cell[CellGroupData[{

Cell["\<\
Das Vektorfeld, welches zu dieser Gleichung geh\[ODoubleDot]rt\
\>", "Subsection",
 CellChangeTimes->{{3.36630512970047*^9, 3.36630514189153*^9}, 
   3.36643158198261*^9}],

Cell[TextData[{
 StyleBox["eqn",
  FontWeight->"Bold"],
 " l\[ADoubleDot]sst sich einfach nach y'[x] aufl\[ODoubleDot]sen, womit sich \
das Vektorfeld der Dgl. berechnen l\[ADoubleDot]sst."
}], "SmallText",
 CellChangeTimes->{{3.36644006125267*^9, 3.36644010890815*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"eqn", ",", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vfy", "=", 
  RowBox[{"First", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "sol"}], "/.", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", "y"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36630592396304*^9, 3.36630595530882*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"frameTicks", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1."}], ",", 
       RowBox[{"-", ".5"}], ",", "0", ",", ".5", ",", "1."}], "}"}], ",", 
     "Automatic", ",", "None", ",", "None"}], "}"}]}], ";", 
  RowBox[{"myPlotOptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"Axes", "->", "None"}], ",", 
     RowBox[{"FrameTicks", "->", "frameTicks"}]}], "}"}]}], ";", 
  RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.36630488789896*^9, 3.36630488925114*^9}, {
   3.36630530654364*^9, 3.36630534985935*^9}, {3.36630568023563*^9, 
   3.36630568046078*^9}, 3.36630596524441*^9, {3.36630621153932*^9, 
   3.36630625356182*^9}, 3.36630656210991*^9, {3.36630659268803*^9, 
   3.36630659855717*^9}, {3.36630675282627*^9, 3.36630675366514*^9}, {
   3.36630678399999*^9, 3.36630678480751*^9}, {3.36638281866656*^9, 
   3.36638288697941*^9}, 3.36638292392006*^9, {3.36696896869596*^9, 
   3.36696901615257*^9}, {3.36696913404838*^9, 3.3669691352378*^9}, {
   3.36696919002407*^9, 3.36696919323749*^9}, 3.3669693269784*^9, {
   3.382701651581977*^9, 3.382701677974315*^9}, {3.382701717699255*^9, 
   3.382701730724514*^9}, {3.382701853946124*^9, 3.382701874897175*^9}, {
   3.382701910567696*^9, 3.382701913950138*^9}, {3.382701961508196*^9, 
   3.382701963665226*^9}, {3.382701996173395*^9, 3.382701997065822*^9}, 
   3.389325629052963*^9, {3.389333152536863*^9, 3.389333152923737*^9}, {
   3.389333519204241*^9, 3.389333522593824*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vf", "[", 
    RowBox[{"a_", ",", "b_", ",", 
     RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"VectorFieldPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "vfy"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", ".9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "a", ",", "b"}], "}"}], ",", "opts"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.389324942792985*^9, 3.389324970603005*^9}, {
   3.389325024210361*^9, 3.389325080311456*^9}, 3.389325152755589*^9, {
   3.389325464499753*^9, 3.389325532070323*^9}, 3.389325728653178*^9, {
   3.389325801942387*^9, 3.38932583554473*^9}}],

Cell[TextData[{
 StyleBox["Graphics",
  FontWeight->"Bold"],
 "-Optionen haben leider \[UDoubleDot]berhaupt keine Auswirkungen, obwohl \
angeblich doch."
}], "SmallText",
 CellChangeTimes->{{3.38932914813597*^9, 3.389329189222239*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3", ",", 
     RowBox[{"PlotPoints", "->", "20"}]}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], " ", "]"}]], "Input",
 CellChangeTimes->{{3.36630488789896*^9, 3.36630488925114*^9}, {
   3.36630530654364*^9, 3.36630534985935*^9}, {3.36630568023563*^9, 
   3.36630568046078*^9}, 3.36630596524441*^9, {3.36630621153932*^9, 
   3.36630625356182*^9}, 3.36630656210991*^9, {3.36630659268803*^9, 
   3.36630659855717*^9}, {3.36630675282627*^9, 3.36630675366514*^9}, {
   3.36630678399999*^9, 3.36630678480751*^9}, {3.36638281866656*^9, 
   3.36638288697941*^9}, 3.36638292392006*^9, {3.382701966179742*^9, 
   3.382701988279349*^9}, {3.38932536646865*^9, 3.389325386995119*^9}, {
   3.389325437704699*^9, 3.389325459053683*^9}, {3.389325559838078*^9, 
   3.389325571824228*^9}, {3.389325747674595*^9, 3.389325781484728*^9}, {
   3.389325822067949*^9, 3.389325850007121*^9}, {3.389329000327616*^9, 
   3.389329003739593*^9}, {3.38932920099959*^9, 3.389329203276474*^9}, {
   3.389330435180914*^9, 3.389330576599995*^9}, {3.389330697906102*^9, 
   3.389330698222876*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sung mit NDSolve", "Subsection"],

Cell["\<\
Die bisherige Analyse hat gezeigt, dass in der N\[ADoubleDot]he von x=1 \
Instabilit\[ADoubleDot]ten zu erwarten sind, wahrscheinlich eine Polstelle. \
Deshalb wollen wir L\[ODoubleDot]sungen im Bereich -1<x<0.9 f\[UDoubleDot]r \
verschiedene Anfangswerte y[0]=c studieren.\
\>", "SmallText",
 CellChangeTimes->{{3.36644068241181*^9, 3.36644078187982*^9}}],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "4"}]}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36638300616063*^9, 3.36638301724437*^9}}],

Cell[TextData[{
 "F\[UDoubleDot]r Anfangswerte c\[GreaterEqual]2 hat ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " keine Probleme, eine L\[ODoubleDot]sung \[UDoubleDot]ber den ganzen uns \
interessierenden Bereich zu generieren. Diese passt auch gut in das \
Vektorfeld der Dgl."
}], "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
  3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
  3.36644048070057*^9}, {3.3664405920042*^9, 3.36644063780813*^9}, {
  3.3664407928681*^9, 3.36644081343934*^9}}],

Cell[BoxData[
 RowBox[{"nsol1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "2", ",", "4", ",", ".5"}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
   3.36644045227148*^9, 3.36644045299187*^9}, {3.36644058552207*^9, 
   3.36644058669555*^9}, 3.3664408585507*^9, {3.36696808047478*^9, 
   3.36696808308461*^9}}],

Cell["Eine Art Probe.", "SmallText",
 CellChangeTimes->{{3.36638310916353*^9, 3.36638311213621*^9}, {
  3.382702857935231*^9, 3.382702896428649*^9}, {3.389325197433865*^9, 
  3.389325198025614*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", "eqn", "]"}], "/.", 
    RowBox[{"nsol1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36591897620293*^9, 3.36630638308132*^9, 3.36630668488073*^9, {
   3.36644037244102*^9, 3.36644037260496*^9}, 3.36644086426545*^9, {
   3.36696903009287*^9, 3.36696906132145*^9}, {3.3669691705387*^9, 
   3.36696917315582*^9}, 3.36696921290739*^9, {3.36696986140894*^9, 
   3.36696986412891*^9}, {3.38270270509602*^9, 3.382702709453922*^9}, {
   3.382702758178848*^9, 3.382702815413026*^9}, {3.382702871489782*^9, 
   3.382702892420672*^9}, 3.382702941423127*^9}],

Cell["Und hier die L\[ODoubleDot]sungen selbst.", "SmallText",
 CellChangeTimes->{{3.36638312592233*^9, 3.36638313262727*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", 
   RowBox[{"vf", "[", 
    RowBox[{"2", ",", "4.5"}], "]"}], ",", "myPlotOptions"}], "]"}]}], "Input",\

 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638331099061*^9}, {3.3664408694685*^9, 3.36644088810172*^9}, {
   3.36696865274727*^9, 3.3669686529012*^9}, {3.3669690468311*^9, 
   3.36696905710896*^9}, 3.36696987454002*^9, {3.382702661167972*^9, 
   3.382702668994074*^9}, {3.389325266614429*^9, 3.389325270273916*^9}, {
   3.389325309837923*^9, 3.38932531748862*^9}, {3.389325701517202*^9, 
   3.38932570687171*^9}, {3.389325898744127*^9, 3.389325920065236*^9}, 
   3.389338550776048*^9}],

Cell[TextData[{
 "F\[UDoubleDot]r Anfangswerte in der N\[ADoubleDot]he von c=0 hat ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " Probleme, weil die L\[ODoubleDot]sung nicht \[UDoubleDot]ber das ganze \
Gebiet ausgedehnt werden kann. Das ist mit Blick auf das Vektorfeld auch \
nicht weiter verwunderlich. \[CapitalUDoubleDot]ber die Stelle ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]]],
 " mit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "[", 
     SubscriptBox["x", "0"], "]"}], "=", "0"}], TraditionalForm]]],
 " l\[ADoubleDot]sst sich die L\[ODoubleDot]sung nicht sinnvoll fortsetzen. "
}], "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
  3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
  3.36644048070057*^9}, {3.36644051650422*^9, 3.36644053374247*^9}, {
  3.36644056386189*^9, 3.36644057173263*^9}, {3.36644083307155*^9, 
  3.36644083454827*^9}, {3.36644110242705*^9, 3.3664411326857*^9}}],

Cell[BoxData[
 RowBox[{"nsol2", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", ".3"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "0.06", ",", "0.2", ",", ".02"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
   3.36638316883576*^9, 3.36638318466153*^9}, {3.36638321570362*^9, 
   3.36638324157278*^9}, {3.36638370424821*^9, 3.36638371299074*^9}, {
   3.36644089788181*^9, 3.36644090262552*^9}, {3.36644096721381*^9, 
   3.36644096769171*^9}, {3.36697011352743*^9, 3.36697011749794*^9}, {
   3.382703223978722*^9, 3.382703224410737*^9}, 3.38270325914223*^9, {
   3.382703290698958*^9, 3.382703291391382*^9}, {3.382703332099888*^9, 
   3.382703369387557*^9}, {3.382703796592814*^9, 3.382703833993711*^9}, {
   3.382703938769323*^9, 3.382703973555786*^9}, {3.38270400545492*^9, 
   3.382704128534603*^9}, {3.382704194065054*^9, 3.382704194802331*^9}, {
   3.382704229308504*^9, 3.382704229517201*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", ".3"}], ",", ".9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2.2"}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638335890342*^9}, {3.36638375346106*^9, 3.36638379395125*^9}, {
   3.36638385324782*^9, 3.36638385347759*^9}, {3.36644090810339*^9, 
   3.36644091826707*^9}, {3.36644097910378*^9, 3.36644105544716*^9}, 
   3.36697005863252*^9, {3.36697036330738*^9, 3.36697036388311*^9}, {
   3.3669704074967*^9, 3.36697042459722*^9}, {3.36697046480268*^9, 
   3.3669704749194*^9}, {3.382703099582849*^9, 3.382703106892808*^9}, {
   3.382703275711332*^9, 3.382703278065186*^9}, {3.38270337362608*^9, 
   3.382703374062924*^9}, {3.382704059572828*^9, 3.382704059963282*^9}, {
   3.382704238765118*^9, 3.38270423910463*^9}, {3.389325299167943*^9, 
   3.389325303804643*^9}, {3.389325977445431*^9, 3.389325999544453*^9}, 
   3.389332000448498*^9}],

Cell["\<\
F\[UDoubleDot]r Anfangswerte c<-2 werden ebenfalls plausible \
L\[ODoubleDot]sungen im ganzen uns interessierenden Bereich gefunden.\
\>", "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
   3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
   3.36644048070057*^9}, {3.36644051650422*^9, 3.36644053374247*^9}, {
   3.36644056386189*^9, 3.36644057173263*^9}, {3.36644083307155*^9, 
   3.36644083454827*^9}, {3.36644110242705*^9, 3.3664411326857*^9}, {
   3.36644135000811*^9, 3.36644141937365*^9}, 3.36697082949473*^9}],

Cell[BoxData[
 RowBox[{"nsol3", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "4"}], ",", 
      RowBox[{"-", "2"}], ",", ".3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
  3.36638316883576*^9, 3.36638318466153*^9}, {3.36638321570362*^9, 
  3.36638324157278*^9}, {3.36638343115048*^9, 3.36638345735994*^9}, {
  3.36644114893442*^9, 3.36644115421382*^9}, {3.36644118668446*^9, 
  3.36644120657309*^9}, {3.36644126641416*^9, 3.36644133051094*^9}, {
  3.36644138065606*^9, 3.36644138895105*^9}, {3.3669708223428*^9, 
  3.36697082590289*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol3"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p3", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "2"}]}], "]"}], ",", "myPlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638335890342*^9}, {3.36638348799274*^9, 3.36638351512981*^9}, {
   3.36644121023608*^9, 3.36644127744919*^9}, {3.36644131108589*^9, 
   3.36644132590008*^9}, 3.36697078858893*^9, {3.36697093600771*^9, 
   3.36697093718865*^9}, {3.38270338875001*^9, 3.382703394278992*^9}, {
   3.389325948014017*^9, 3.389325951683944*^9}, 3.389326010040156*^9, {
   3.38933211926872*^9, 3.389332119720041*^9}}],

Cell[TextData[{
 "Im Bereich -2.2<c<0.5 sehen wir noch einmal deutlich, dass ",
 StyleBox["NDSolve",
  FontWeight->"Bold"],
 " eine L\[ODoubleDot]sung generell nicht \[UDoubleDot]ber die Stelle y=0 \
hinweg verl\[ADoubleDot]ngern kann, ansonsten aber plausible \
L\[ODoubleDot]sungen liefert."
}], "SmallText",
 CellChangeTimes->{{3.36630628738325*^9, 3.36630633676604*^9}, {
  3.36630688973348*^9, 3.36630691228848*^9}, {3.36644048027745*^9, 
  3.36644048070057*^9}, {3.36644051650422*^9, 3.36644053374247*^9}, {
  3.36644056386189*^9, 3.36644057173263*^9}, {3.36644083307155*^9, 
  3.36644083454827*^9}, {3.36644110242705*^9, 3.3664411326857*^9}, {
  3.36644135000811*^9, 3.36644141937365*^9}, {3.36644166666137*^9, 
  3.36644178486316*^9}}],

Cell[BoxData[
 RowBox[{"nsol4", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"eqn", "&&", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "c"}]}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", ".9"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "2.2"}], ",", "0.5", ",", ".3"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.36638306848148*^9, 3.36638306930037*^9}, {
  3.36638316883576*^9, 3.36638318466153*^9}, {3.36638321570362*^9, 
  3.36638324157278*^9}, {3.36638343115048*^9, 3.36638345735994*^9}, {
  3.36644114893442*^9, 3.36644115421382*^9}, {3.36644118668446*^9, 
  3.36644120657309*^9}, {3.36644126641416*^9, 3.36644133051094*^9}, {
  3.36644138065606*^9, 3.36644138895105*^9}, {3.366441469127*^9, 
  3.36644147634493*^9}, {3.36644155240451*^9, 3.36644155828784*^9}, {
  3.36644159812517*^9, 3.36644160076444*^9}, {3.36697135116537*^9, 
  3.36697135388669*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "nsol4"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p4", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ",", "myPlotOptions"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.36591899118416*^9, {3.36630640419954*^9, 3.36630640570876*^9}, {
   3.36630664540308*^9, 3.36630664994539*^9}, {3.36638325859285*^9, 
   3.36638335890342*^9}, {3.36638348799274*^9, 3.36638351512981*^9}, {
   3.36644121023608*^9, 3.36644127744919*^9}, {3.36644131108589*^9, 
   3.36644132590008*^9}, {3.3664414930643*^9, 3.36644153150844*^9}, 
   3.36697116610569*^9, {3.38270341110172*^9, 3.382703418587591*^9}, {
   3.389326023280105*^9, 3.389326029733221*^9}, {3.389332364469024*^9, 
   3.389332396983606*^9}, 3.389338601498908*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Noch einmal die symbolische L\[ODoubleDot]sung \
\>", "Subsection",
 CellChangeTimes->{{3.36630694896728*^9, 3.36630695098131*^9}, {
  3.36643159002579*^9, 3.36643159923483*^9}}],

Cell["\<\
Auch in der symbolischen L\[ODoubleDot]sungsschar gibt es \
L\[ODoubleDot]sungen, welche durch y[0]=c gehen. Wir bestimmen zun\
\[ADoubleDot]chst den Zusammenhang zwischen c und C[1], siehe auch Notebook \
solve.nb\
\>", "SmallText",
 CellChangeTimes->{{3366435438.89025, 3366435441.5208}, {3366435508.92756, 
  3366435546.42025}, {3366441865.12739, 3366441878.06063}, {3366442181.20435, 
  3366442218.17683}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "c", "]"}], "\[IndentingNewLine]", 
 RowBox[{"u", "=", 
  RowBox[{"y0", "[", "0", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"csol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"u", "\[LeftDoubleBracket]", 
       RowBox[{"0", ",", "1"}], "\[RightDoubleBracket]"}], "[", "c", "]"}], 
     "\[Equal]", 
     RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
    ",", 
    RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36697255017744*^9, 3.36697260531788*^9}}],

Cell[TextData[{
 "Die numerische Auswertung wird von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " verweigert, da jeder solche Funktionswert einen Aufruf von ",
 StyleBox["FindRoot ",
  FontWeight->"Bold"],
 "bedeutet. Das kann selbst \"nachger\[UDoubleDot]stet\" werden. \nDa ",
 StyleBox["InverseFunction",
  FontWeight->"Bold"],
 " schreibgesch\[UDoubleDot]tzt ist, ersetzen wir diesen Funktionsnamen durch \
einen anderen und definieren zugleich eine Funktionenschar ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["y", "1"], "[", "c", "]"}], "[", "x", "]"}], 
   TraditionalForm]]],
 ", wobei jede Funktion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "1"], "[", "c", "]"}], TraditionalForm]]],
 " eine L\[ODoubleDot]sung von ",
 StyleBox["eqn",
  FontWeight->"Bold"],
 " mit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["y", "1"], "[", "c", "]"}], "[", "0", "]"}], "=", "c"}], 
   TraditionalForm]]],
 " ist."
}], "SmallText",
 CellChangeTimes->{{3.36643561590133*^9, 3.36643563996943*^9}, {
  3.36644189850327*^9, 3.3664419020832*^9}, {3.36697463234333*^9, 
  3.36697473317273*^9}, {3.36697626853329*^9, 3.36697627662893*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "y1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y1", "[", "c_", "]"}], "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"y0", "[", "x", "]"}], "/.", 
    RowBox[{"csol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
   "/.", 
   RowBox[{"InverseFunction", "\[Rule]", "InvFct"}]}]}]}], "Input",
 CellChangeTimes->{{3.36643566180759*^9, 3.36643566962611*^9}, {
  3.36697274046417*^9, 3.36697274120001*^9}, {3.36697278430989*^9, 
  3.36697278900756*^9}, {3.36697284663466*^9, 3.36697287693588*^9}, {
  3.36697623026584*^9, 3.36697628134008*^9}}],

Cell["\<\
Und nun definieren wir eine Regel, die InvFct[f] mit numerischen Argumenten \
wirklich numerisch auswertet.\
\>", "SmallText",
 CellChangeTimes->{{3.36697439565545*^9, 3.3669744061837*^9}, 
   3.36697444631928*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InvFct", "[", "f_Function", "]"}], "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "y", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"y", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "y", "]"}], "\[Equal]", 
        RowBox[{"N", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1."}], "}"}]}], "]"}]}]}], "]"}]}]], "Input"],

Cell["Die Wertetabelle sieht plausibel aus.", "SmallText",
 CellChangeTimes->{{3.36643619858145*^9, 3.36643620855486*^9}, {
  3.389337171130719*^9, 3.389337175800293*^9}}],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"y1", "[", "4", "]"}], "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2.4"}], ",", "0.9", ",", "0.2"}], "}"}]}], "]"}], "//", 
    "Chop"}], ",", 
   RowBox[{"Alignment", "->", "\"\<.\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36638509033346*^9, 3.36638513821215*^9}, {
   3.36643568300303*^9, 3.36643571621085*^9}, 3.36643619554597*^9, {
   3.36697270095742*^9, 3.36697271197736*^9}, {3.36697274849343*^9, 
   3.36697275698147*^9}, {3.36697280383678*^9, 3.36697281332848*^9}, {
   3.36697629143973*^9, 3.36697629379867*^9}, {3.36697731916924*^9, 
   3.3669773676771*^9}, {3.36697748118969*^9, 3.36697749709204*^9}, {
   3.389336951189647*^9, 3.389337164124855*^9}}],

Cell["\<\
Achtung: F\[UDoubleDot]r x=1 wertet das Argument B von InvFct[A][B] zu \
\[Infinity]  aus und die InvFct-Regel wird nicht angewendet.\
\>", "SmallText",
 CellChangeTimes->{{3.36697841812012*^9, 3.36697848411455*^9}, {
   3.36697851975098*^9, 3.36697852134928*^9}, 3.382704582077171*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"y1", "[", "4", "]"}], "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.3669774531672*^9, 3.36697746790745*^9}}],

Cell["\<\
Selbst eine grafische Darstellung kann man aus diesem Weg generieren. \
\>", "SmallText",
 CellChangeTimes->{{3.36643621842285*^9, 3.36643623524728*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y1", "[", "4", "]"}], "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1.2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36638514384482*^9, 3.3663851529523*^9}, {
  3.3664356910506*^9, 3.3664356933449*^9}, {3.36644193841468*^9, 
  3.36644194987147*^9}, {3.3669728879187*^9, 3.36697288913765*^9}, {
  3.36697629977739*^9, 3.36697630001124*^9}}],

Cell["\<\
Statt einzelner Graphen kann auch eine ganze Funktionenschar untersucht \
werden.\
\>", "SmallText",
 CellChangeTimes->{{3.3664362469311*^9, 3.36643629827637*^9}}],

Cell["\<\
Im Bereich 1.3 \[LessEqual] c \[LessEqual] 4 zeigen die so gewonnenen L\
\[ODoubleDot]sungskurven ein regul\[ADoubleDot]res Verhalten ...\
\>", "SmallText",
 CellChangeTimes->{{3.36643630866307*^9, 3.36643638174525*^9}, {
  3.36697323664356*^9, 3.36697324022199*^9}, {3.36697327461668*^9, 
  3.36697327580435*^9}, {3.38270463536164*^9, 3.382704637141459*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y1", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "1.3", ",", "4", ",", ".3"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p5", ",", 
   RowBox[{"vf", "[", 
    RowBox[{"1", ",", "5"}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.36638514384482*^9, 3.3663851529523*^9}, {
   3.3664356910506*^9, 3.3664356933449*^9}, {3.36643597236892*^9, 
   3.36643606885238*^9}, {3.36644199676428*^9, 3.36644210749922*^9}, {
   3.36697290762136*^9, 3.36697291358155*^9}, {3.36697297674361*^9, 
   3.36697325762006*^9}, {3.36697630778497*^9, 3.36697630820461*^9}, {
   3.382704606489332*^9, 3.382704613853804*^9}, 3.38932620610199*^9, 
   3.389338652208022*^9}],

Cell[TextData[{
 "F\[UDoubleDot]r c<1 wird das Geschehen insbesondere unterhalb der y-Achse \
chaotisch; ",
 StyleBox["FindRoot",
  FontWeight->"Bold"],
 " kann sich nicht f\[UDoubleDot]r eine stetig variierende Nullstelle \
entscheiden. "
}], "SmallText",
 CellChangeTimes->{{3.36643630866307*^9, 3.36643638174525*^9}, {
  3.36697323664356*^9, 3.36697324022199*^9}, {3.36697327461668*^9, 
  3.36697327580435*^9}, {3.36697392291629*^9, 3.36697401995784*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y1", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", 
          RowBox[{"-", "1"}], ",", "1", ",", ".21"}], "}"}]}], "]"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p6", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.36638514384482*^9, 3.3663851529523*^9}, {
   3.3664356910506*^9, 3.3664356933449*^9}, {3.36643597236892*^9, 
   3.36643606885238*^9}, {3.36644199676428*^9, 3.36644210749922*^9}, {
   3.36697290762136*^9, 3.36697291358155*^9}, {3.36697297674361*^9, 
   3.36697325762006*^9}, {3.36697330247198*^9, 3.36697334683171*^9}, {
   3.36697350435731*^9, 3.36697350645509*^9}, {3.36697633259777*^9, 
   3.36697633283236*^9}, {3.38270474145849*^9, 3.382704748971461*^9}, 
   3.389326233935236*^9, 3.389338834697826*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y1", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", 
          RowBox[{"-", ".9"}], ",", 
          RowBox[{"-", ".1"}], ",", ".1"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "->", "Thick"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p7", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "]"}], ",", "myPlotOptions", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.36638514384482*^9, 3.3663851529523*^9}, {
   3.3664356910506*^9, 3.3664356933449*^9}, {3.36643597236892*^9, 
   3.36643606885238*^9}, {3.36644199676428*^9, 3.36644210749922*^9}, {
   3.36697290762136*^9, 3.36697291358155*^9}, {3.36697297674361*^9, 
   3.36697325762006*^9}, {3.36697330247198*^9, 3.36697334683171*^9}, {
   3.36697350435731*^9, 3.36697350645509*^9}, {3.36697356225324*^9, 
   3.36697360159063*^9}, {3.36697375287031*^9, 3.36697376149119*^9}, {
   3.36697635090693*^9, 3.36697635107468*^9}, {3.382704772378175*^9, 
   3.382704779555085*^9}, {3.3827048229807*^9, 3.382704825636092*^9}, 
   3.389326239824435*^9}],

Cell[TextData[{
 "Mit c=-1 kann unser ",
 StyleBox["InvFct ",
  FontWeight->"Bold"],
 "gar nichts anfangen, da -\[Infinity]  nicht die Eigenschaft ",
 StyleBox["NumericQ",
  FontWeight->"Bold"],
 " (und auch nicht ",
 StyleBox["NumberQ",
  FontWeight->"Bold"],
 ") hat.\n\nF\[UDoubleDot]r c<-1 findet ",
 StyleBox["FindRoot",
  FontWeight->"Bold"],
 " Nullstellen mit imagin\[ADoubleDot]rem Anteil, geht also auf ein anderes \
Blatt der ",
 StyleBox["Log",
  FontWeight->"Bold"],
 "-Funktion. Auch ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["y", "3"], "[", "c", "]"}], "[", "0", "]"}], 
   TraditionalForm]]],
 " ergibt nicht mehr c."
}], "SmallText",
 CellChangeTimes->{{3.36643630866307*^9, 3.36643638174525*^9}, {
  3.36697323664356*^9, 3.36697324022199*^9}, {3.36697327461668*^9, 
  3.36697327580435*^9}, {3.36697392291629*^9, 3.36697401995784*^9}, {
  3.36697407035749*^9, 3.36697411693884*^9}, {3.36697420441383*^9, 
  3.36697427639473*^9}, {3.36697446740659*^9, 3.36697451739412*^9}, {
  3.36697457307771*^9, 3.36697459305573*^9}, {3.36697969225339*^9, 
  3.36697970346372*^9}, {3.38270480095057*^9, 3.382704803512939*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"y1", "[", 
   RowBox[{"-", "1"}], "]"}], "[", "0", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y1", "[", 
   RowBox[{"-", "1.2"}], "]"}], "[", "0", "]"}], "\n", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y1", "[", 
      RowBox[{"-", "1.2"}], "]"}], "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "1", ",", "0.3"}], "}"}]}], "]"}], "//", 
  "N"}]}], "Input",
 CellChangeTimes->{{3.36638509033346*^9, 3.36638513821215*^9}, {
   3.36643568300303*^9, 3.36643571621085*^9}, 3.36643619554597*^9, {
   3.36697270095742*^9, 3.36697271197736*^9}, {3.36697274849343*^9, 
   3.36697275698147*^9}, {3.36697280383678*^9, 3.36697281332848*^9}, {
   3.36697367737622*^9, 3.366973722311*^9}, {3.36697382241595*^9, 
   3.36697382861821*^9}, {3.36697410201004*^9, 3.36697410629709*^9}, {
   3.36697454213054*^9, 3.36697455921155*^9}, {3.36697637179896*^9, 
   3.36697637526968*^9}, 3.36697986456295*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sung mit Potenzreihenansatz", "Subsection",
 CellChangeTimes->{{3.36630694896728*^9, 3.36630695098131*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "7"}], ";"}], "\n", 
 RowBox[{"ansatz", "=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "i"], 
      SuperscriptBox["x", "i"]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", 
     RowBox[{"x", ",", "0"}], "]"}], 
    RowBox[{"n", "+", "1"}]]}]}], "\n", 
 RowBox[{"eqn1", "=", 
  RowBox[{"eqn", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "\[Rule]", "ansatz"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{"ansatz", ",", "x"}], "]"}]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{
  3.36630486142382*^9, {3.36697505946028*^9, 3.36697506016599*^9}, {
   3.36697510162928*^9, 3.36697510258819*^9}, {3.36697524094702*^9, 
   3.36697524140424*^9}, {3.36697532364315*^9, 3.36697532416567*^9}, {
   3.36697540730117*^9, 3.36697541989644*^9}}],

Cell[BoxData[
 RowBox[{"eqn2", "=", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"First", "[", "eqn1", "]"}], "]"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"eqn2", "\[Equal]", "0"}], "\[And]", 
    RowBox[{
     SubscriptBox["a", "0"], "\[NotEqual]", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36630645801396*^9, 3.36630650844544*^9}, {
  3.36697511585602*^9, 3.36697512545561*^9}, {3.36698872088479*^9, 
  3.36698872129042*^9}}],

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{
   RowBox[{"ansatz", "+", 
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", ",", "0"}], "]"}], "n"]}], "/.", "sol2"}]}]], "Input"],

Cell["\<\
Hier also die gefundene Potenzreihenl\[ODoubleDot]sung ohne den O-Term, \
wieder in der Notation als Funktionenschar.\
\>", "SmallText",
 CellChangeTimes->{{3.36698998269197*^9, 3.36698999157711*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "y2", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y2", "[", "c_", "]"}], "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "/.",
      
     RowBox[{
      SubscriptBox["a", "0"], "\[Rule]", "c"}]}], ")"}], "//", 
   "Normal"}]}]}], "Input",
 CellChangeTimes->{{3.36697642134888*^9, 3.36697642696356*^9}, {
  3.36698991449504*^9, 3.36698997153427*^9}}],

Cell["\<\
In diesem Fall ist auch eine symbolische Probe m\[ODoubleDot]glich.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"eqn", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "->", "s"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "->", 
     RowBox[{"D", "[", 
      RowBox[{"s", ",", "x"}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.36697644181466*^9, 3.36697644423733*^9}, {
  3.36697649156213*^9, 3.36697649214594*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p8", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y2", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "1.3", ",", "5", ",", ".3"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p8", ",", 
   RowBox[{"vf", "[", 
    RowBox[{"1", ",", "5"}], "]"}], ",", "myPlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36591894981365*^9, {3.36630671684729*^9, 3.3663067191884*^9}, {
   3.36697483074383*^9, 3.36697484321779*^9}, {3.36697489062038*^9, 
   3.36697489858858*^9}, {3.36697494880467*^9, 3.3669750348566*^9}, {
   3.36697649811717*^9, 3.36697650196082*^9}, {3.36698979110405*^9, 
   3.3669897927332*^9}, {3.36699007426664*^9, 3.36699008119293*^9}, {
   3.382704954949109*^9, 3.382704963953741*^9}, 3.38932636658786*^9, 
   3.389339880669872*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p9", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y2", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", 
          RowBox[{"-", "1"}], ",", "1", ",", ".12"}], "}"}]}], "]"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p9", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "5"}], "]"}], ",", "myPlotOptions"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.36591894981365*^9, {3.36630671684729*^9, 3.3663067191884*^9}, {
   3.36697483074383*^9, 3.36697484321779*^9}, {3.36697489062038*^9, 
   3.36697489858858*^9}, {3.36697494880467*^9, 3.3669750348566*^9}, {
   3.36697517670551*^9, 3.36697521179154*^9}, {3.36697526901001*^9, 
   3.36697527264545*^9}, {3.36697537707049*^9, 3.36697539327917*^9}, {
   3.36697650796752*^9, 3.36697651153102*^9}, {3.36699030312184*^9, 
   3.36699030741736*^9}, {3.382704973633749*^9, 3.382704981817296*^9}, 
   3.389326373432969*^9, 3.389340190589471*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p10", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y2", "[", "c", "]"}], "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", 
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "1"}], ",", ".3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p10", ",", 
   RowBox[{"vf", "[", 
    RowBox[{
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", "myPlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36591894981365*^9, {3.36630671684729*^9, 3.3663067191884*^9}, {
   3.36697483074383*^9, 3.36697484321779*^9}, {3.36697489062038*^9, 
   3.36697489858858*^9}, {3.36697494880467*^9, 3.3669750348566*^9}, {
   3.36697517670551*^9, 3.36697521179154*^9}, {3.36697526901001*^9, 
   3.36697527264545*^9}, {3.36697537707049*^9, 3.36697539327917*^9}, {
   3.36697546581119*^9, 3.36697550426889*^9}, {3.36697651682445*^9, 
   3.36697652040933*^9}, {3.3669905856725*^9, 3.3669905910391*^9}, {
   3.382704990545691*^9, 3.382704997696495*^9}, 3.389326379985515*^9, 
   3.389340331372167*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Noch ein Beispiel", "Section"],

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], 
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
    RowBox[{"3", 
     SuperscriptBox["x", "2"], 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
   RowBox[{"6", 
    RowBox[{"Log", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.36699163132838*^9, 3.36699163207619*^9}}],

Cell["Die exakte L\[ODoubleDot]sung", "SmallText",
 CellChangeTimes->{{3.36699168518438*^9, 3.36699168852058*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/.", 
        RowBox[{
        "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "/.",
        
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"C", "[", "1", "]"}], "\[Rule]", "3"}], ",", 
         RowBox[{
          RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "c"}]}], "}"}]}], ",",
       
      RowBox[{"{", 
       RowBox[{"c", ",", "0", ",", "3", ",", ".7"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36699174242168*^9, 3.36699189980192*^9}}],

Cell["\<\
Entwicklung der exakten L\[ODoubleDot]sungen als Potenzreihe in der Umgebung \
von x=1 f\[UDoubleDot]r y[1]=3.\
\>", "SmallText",
 CellChangeTimes->{{3.36699170378263*^9, 3.36699173486897*^9}, {
  3.36699214165199*^9, 3.36699215193459*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "y1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y1", "[", "c_", "]"}], "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"First", "[", "sol", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "\[Rule]", 
       RowBox[{"c", "+", "3"}]}]}], "}"}]}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.36699165890329*^9, 3.36699166423921*^9}, {
  3.36699193455255*^9, 3.36699194200143*^9}, {3.36699216167268*^9, 
  3.3669921700056*^9}, {3.36699272811174*^9, 3.36699272835097*^9}}],

Cell["\<\
Dieselbe L\[ODoubleDot]sungsschar n\[ADoubleDot]herungsweise \[UDoubleDot]ber \
einen Potenzreihenansatz.\
\>", "SmallText",
 CellChangeTimes->{{3.36699222104845*^9, 3.36699224412029*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ansatz", "=", 
  RowBox[{"3", "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "i"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "i"]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", 
     RowBox[{"x", ",", "1"}], "]"}], 
    RowBox[{"n", "+", "1"}]]}]}]}], "Input",
 CellChangeTimes->{{3.36699220663175*^9, 3.36699221473869*^9}}],

Cell[BoxData[
 RowBox[{"eqn1", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"eqn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "/.",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "\[Rule]", "ansatz"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "\[Rule]", 
        RowBox[{"D", "[", 
         RowBox[{"ansatz", ",", "x"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "\[Rule]", 
        RowBox[{"D", "[", 
         RowBox[{"ansatz", ",", "x", ",", "x"}], "]"}]}]}], "}"}]}], ")"}], 
   "-", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"eqn", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", 
       RowBox[{"n", "-", "2"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.36699195758166*^9, 3.36699195990454*^9}, {
  3.36699199952923*^9, 3.36699201438468*^9}, {3.36699218661651*^9, 
  3.36699219202026*^9}}],

Cell[BoxData[
 RowBox[{"sys", "=", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{
    RowBox[{"Normal", "[", "eqn1", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36699198223946*^9, 3.36699198726609*^9}, {
  3.36699202410273*^9, 3.3669920714502*^9}}],

Cell[BoxData[
 RowBox[{"lsol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"sys", "\[Equal]", "0"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["a", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "n"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.36699205016883*^9, 3.36699205256885*^9}, {
  3.36699209106699*^9, 3.36699210888041*^9}, {3.3669922722164*^9, 
  3.36699227245034*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y2", "[", "c_", "]"}], "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"ansatz", "/.", 
    RowBox[{"First", "[", "lsol", "]"}]}], "/.", 
   RowBox[{
    SubscriptBox["a", "1"], "\[Rule]", "c"}]}]}]], "Input",
 CellChangeTimes->{{3.36699234973728*^9, 3.36699237205814*^9}}],

Cell["\<\
Beides sind dieselben L\[ODoubleDot]sungen.\
\>", "SmallText",
 CellChangeTimes->{{3.3669927828292*^9, 3.36699279087671*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y1", "[", "c", "]"}], "[", "x", "]"}], "-", 
  RowBox[{
   RowBox[{"y2", "[", "c", "]"}], "[", "x", "]"}]}]], "Input",
 CellChangeTimes->{{3.36699230773058*^9, 3.36699233426006*^9}, {
  3.36699237814039*^9, 3.36699238827533*^9}, {3.36699264185642*^9, 
  3.36699265044647*^9}, {3.36699268290401*^9, 3.36699269383698*^9}, {
  3.36699276744864*^9, 3.36699276760588*^9}}]
}, Closed]]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{632, 680},
WindowMargins->{{Automatic, 62}, {Automatic, 33}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 142, 2, 90, "Title"],
Cell[CellGroupData[{
Cell[757, 29, 102, 1, 55, "Section"],
Cell[862, 32, 561, 13, 110, "SmallText"],
Cell[1426, 47, 784, 25, 72, "Input"],
Cell[2213, 74, 204, 6, 42, "SmallText"],
Cell[2420, 82, 244, 6, 28, "Input"],
Cell[2667, 90, 639, 17, 28, "Input"],
Cell[3309, 109, 260, 4, 28, "Input"],
Cell[3572, 115, 243, 5, 28, "Input"],
Cell[3818, 122, 126, 1, 42, "SmallText"],
Cell[3947, 125, 443, 11, 28, "Input"],
Cell[4393, 138, 732, 22, 30, "Input"],
Cell[5128, 162, 381, 9, 28, "Input"],
Cell[5512, 173, 151, 3, 42, "SmallText"],
Cell[5666, 178, 2010, 59, 89, "Input"],
Cell[7679, 239, 679, 19, 49, "Input"],
Cell[8361, 260, 382, 9, 28, "Input"],
Cell[8746, 271, 121, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[8904, 278, 104, 1, 35, "Section"],
Cell[9011, 281, 917, 30, 52, "Input"],
Cell[9931, 313, 238, 6, 42, "SmallText"],
Cell[10172, 321, 296, 8, 28, "Input"],
Cell[CellGroupData[{
Cell[10493, 333, 181, 4, 45, "Subsection"],
Cell[10677, 339, 270, 6, 42, "SmallText"],
Cell[10950, 347, 503, 16, 49, "Input"],
Cell[11456, 365, 1607, 31, 69, "Input"],
Cell[13066, 398, 731, 19, 49, "Input"],
Cell[13800, 419, 235, 6, 42, "SmallText"],
Cell[14038, 427, 1210, 21, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[15285, 453, 52, 0, 29, "Subsection"],
Cell[15340, 455, 366, 6, 76, "SmallText"],
Cell[15709, 463, 328, 9, 28, "Input"],
Cell[16040, 474, 547, 11, 59, "SmallText"],
Cell[16590, 487, 672, 18, 28, "Input"],
Cell[17265, 507, 198, 3, 42, "SmallText"],
Cell[17466, 512, 785, 17, 28, "Input"],
Cell[18254, 531, 126, 1, 42, "SmallText"],
Cell[18383, 534, 1051, 25, 65, "Input"],
Cell[19437, 561, 992, 22, 76, "SmallText"],
Cell[20432, 585, 1209, 25, 44, "Input"],
Cell[21644, 612, 1477, 33, 65, "Input"],
Cell[23124, 647, 573, 9, 59, "SmallText"],
Cell[23700, 658, 919, 22, 44, "Input"],
Cell[24622, 682, 1039, 25, 65, "Input"],
Cell[25664, 709, 743, 14, 59, "SmallText"],
Cell[26410, 725, 1042, 24, 44, "Input"],
Cell[27455, 751, 1142, 29, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28634, 785, 188, 4, 29, "Subsection"],
Cell[28825, 791, 420, 8, 59, "SmallText"],
Cell[29248, 801, 585, 15, 69, "Input"],
Cell[29836, 818, 1226, 38, 110, "SmallText"],
Cell[31065, 858, 625, 14, 65, "Input"],
Cell[31693, 874, 224, 5, 59, "SmallText"],
Cell[31920, 881, 510, 15, 65, "Input"],
Cell[32433, 898, 171, 2, 42, "SmallText"],
Cell[32607, 902, 906, 21, 44, "Input"],
Cell[33516, 925, 296, 5, 59, "SmallText"],
Cell[33815, 932, 146, 3, 44, "Input"],
Cell[33964, 937, 163, 3, 42, "SmallText"],
Cell[34130, 942, 467, 11, 44, "Input"],
Cell[34600, 955, 173, 4, 42, "SmallText"],
Cell[34776, 961, 369, 6, 42, "SmallText"],
Cell[35148, 969, 1173, 30, 65, "Input"],
Cell[36324, 1001, 458, 10, 59, "SmallText"],
Cell[36785, 1013, 1332, 34, 65, "Input"],
Cell[38120, 1049, 1521, 37, 85, "Input"],
Cell[39644, 1088, 1159, 32, 110, "SmallText"],
Cell[40806, 1122, 1011, 24, 85, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[41854, 1151, 127, 1, 29, "Subsection"],
Cell[41984, 1154, 1038, 31, 71, "Input"],
Cell[43025, 1187, 191, 5, 28, "Input"],
Cell[43219, 1194, 366, 9, 28, "Input"],
Cell[43588, 1205, 189, 6, 28, "Input"],
Cell[43780, 1213, 210, 4, 59, "SmallText"],
Cell[43993, 1219, 499, 14, 65, "Input"],
Cell[44495, 1235, 96, 2, 42, "SmallText"],
Cell[44594, 1239, 404, 12, 44, "Input"],
Cell[45001, 1253, 1098, 28, 65, "Input"],
Cell[46102, 1283, 1240, 32, 65, "Input"],
Cell[47345, 1317, 1325, 33, 65, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[48719, 1356, 36, 0, 35, "Section"],
Cell[48758, 1358, 492, 16, 30, "Input"],
Cell[49253, 1376, 114, 1, 42, "SmallText"],
Cell[49370, 1379, 120, 3, 28, "Input"],
Cell[49493, 1384, 775, 24, 49, "Input"],
Cell[50271, 1410, 250, 5, 42, "SmallText"],
Cell[50524, 1417, 865, 23, 69, "Input"],
Cell[51392, 1442, 198, 4, 42, "SmallText"],
Cell[51593, 1448, 578, 18, 50, "Input"],
Cell[52174, 1468, 1064, 31, 69, "Input"],
Cell[53241, 1501, 265, 6, 28, "Input"],
Cell[53509, 1509, 452, 13, 28, "Input"],
Cell[53964, 1524, 318, 9, 28, "Input"],
Cell[54285, 1535, 135, 3, 42, "SmallText"],
Cell[54423, 1540, 414, 9, 28, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
