(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57815,       2128]
NotebookOptionsPosition[     47826,       1843]
NotebookOutlinePosition[     48253,       1862]
CellTagsIndexPosition[     48210,       1859]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Funktionen und Auswertung", "Title"],

Cell[CellGroupData[{

Cell["Einf\[UDoubleDot]hrung", "Section"],

Cell[BoxData[
 RowBox[{"Set", "//", "Attributes"}]], "Input"],

Cell[BoxData[
 RowBox[{"SetDelayed", "//", "Attributes"}]], "Input"],

Cell["\<\
Ein und dieselbe Notation auf der rechten Seite kann f\[UDoubleDot]r \
unterschiedliche Objekte stehen.

f1 ist ein Ausdruck mit zwei Symbolvariablen
f2 ist eine Funktion mit formalem Parameter x, in der eine weitere \
Symbolvariable vorkommt.
f3 ist eine zweistelllige Funktion.
f4 ist eine Schar einstelliger Funktionen mit Scharparameter t und \
Funktionsparameter x.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"f1", ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f3", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f4", "[", "t_", "]"}], "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"t", " ", "x"}], "+", "1"}]}]}], "Input"],

Cell["\<\
Das erste Listenelement ist der Ausdruck f1.
Das zweite Listenelement ist der Funktionswert von f2 an der (symbolischen) \
Stelle x f\[UDoubleDot]r den speziellen Wert t\[Equal]3.
Das dritte Listenelement ist der Funktionswert von f3 an der Stelle \
(x,t)=(2,x). Das erste Argument (f\[UDoubleDot]r x) ist eine Zahl, das zweite \
(f\[UDoubleDot]r t) das Symbol x.
Das vierte Listenelement ist der Funktionswert der \"allgemeinen\" Funktion \
f4[t] der Schar (der Unterschied ist wie der zwischen f2 und f2[x] im zweiten \
Fall) an der Stelle x\[Equal]3.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f1", ",", 
   RowBox[{
    RowBox[{"f2", "[", "x", "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "3"}]}], ",", 
   RowBox[{"f3", "[", 
    RowBox[{"2", ",", "x"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "t", "]"}], "[", "3", "]"}]}], "}"}]], "Input"],

Cell["\<\
Und hier werden schlie\[SZ]lich f\[UDoubleDot]nf der Funktionen aus der Schar \
f4 grafisch dargestellt. Ganz genau: Dargestellt werden nicht die Funktionen \
f4[t], sondern die Ausdr\[UDoubleDot]cke f4[t][x].\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f4", "[", "t", "]"}], "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"u", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], " ", ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1", ",", ".5"}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", "\"\<\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"-", "1"}], ",", "1", ",", ".1"}], "}"}]}], "]"}]}], 
       "]"}], "}"}]}]}], "]"}]}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auswertung von Ausdr\[UDoubleDot]cken", "Section"],

Cell[CellGroupData[{

Cell["Attribute mit Transformationswirkung", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "[", 
   RowBox[{
    RowBox[{"Plus", "[", 
     RowBox[{"x1", ",", "x3"}], "]"}], ",", "x2"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "2", ",", 
    FractionBox["\[Pi]", "4"], ",", "3.5"}], "}"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],

Cell[BoxData[
 RowBox[{"Plus", "[", "a", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Auswertung von Plot-Ausdr\[UDoubleDot]cken", "Subsection"],

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plot", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"Sin", "[", 
      SuperscriptBox["x", "2"], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Hiermit gab es gelegentlich Schwierigkeiten, wenn beide Kommandos auf einer \
Zeile stehen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}]}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{"u", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Auswertung boolescher Ausdr\[UDoubleDot]cke\
\>", "Subsection"],

Cell[TextData[{
 "Die oft zu beobachtende \"Faulheit\" von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " bei der Auswertung boolescher Ausdr\[UDoubleDot]cke hat verschiedene \
Ursachen.\n\nDie erste liegt in der Natur der Ausdr\[UDoubleDot]cke selbst: \
Sie k\[ODoubleDot]nnen ",
 StyleBox["Aussagen",
  FontSlant->"Italic"],
 " (boolesche Ausdr\[UDoubleDot]cke ohne freie Variablen, denen sich ein \
Wahrheitswert zuordnen l\[ADoubleDot]sst) oder ",
 StyleBox["Aussageformen",
  FontSlant->"Italic"],
 " (boolesche Ausdr\[UDoubleDot]cke mit freien Variablen) sein. \n\nBeim \
Anschreiben eines Gleichungssystems etwa werden Aussageformen mit \[Equal] \
(",
 StyleBox["Equal",
  FontWeight->"Bold"],
 ") verwendet. Hier soll nicht untersucht werden, ob dies f\[UDoubleDot]r \
alle (x,y) gilt, sondern es wird das ",
 StyleBox["Problem",
  FontSlant->"Italic"],
 " formuliert, die L\[ODoubleDot]sungspaare (x,y) zu finden. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y", "-", "2"}], "\[Equal]", "0"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       SuperscriptBox["y", "2"], "-", "2"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sys", "//", "FullForm"}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "An der Stelle ist die Probe einfach - wenigstens mit Vorversionen von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6. Alle Vereinfachungen wurden automatisch vorgenommen und die \
entsprechenden booleschen Ausdr\[UDoubleDot]cke zu ",
 StyleBox["True",
  FontWeight->"Bold"],
 " vereinfacht. Nun nicht mehr (und von einem systematischen Standpunkt aus \
sollte auch ein ",
 StyleBox["Expand",
  FontWeight->"Bold"],
 " ben\[ODoubleDot]tigt werden ..."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sys", "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[TextData[{
 "... wie es der Fall ist, wenn die rechten Seiten durch einen Parameter ",
 StyleBox["a",
  FontSlant->"Italic"],
 " ersetzt werden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", "a"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "2"], "+", 
       RowBox[{"2", "x"}]}], "\[Equal]", "a"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sys", "/.", "sol"}]}], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " braucht wenigstens den Hinweis, dass die linken Seiten zu expandieren \
sind."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "3"}], "+", "a"}]]}], ")"}], "2"], "+", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "3"}], "+", "a"}]]}], ")"}]}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sys", "/.", "sol"}], "//", "Expand"}]], "Input"],

Cell[TextData[{
 "Dann kann es sein, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zwar Aussagen vorgelegt bekommt, aber mit den eingesetzten Mitteln deren \
Wahrheitswert nicht entscheiden kann.\n\nDie folgende Identit\[ADoubleDot]t \
erkennt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 6 inzwischen automatisch."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}], "\[Equal]", "6"}]], "Input"],

Cell[TextData[{
 "Aber schon beim n\[ADoubleDot]chsten Beispiel muss ein so \
m\[ADoubleDot]chtiges Werkzeug wie ",
 StyleBox["RootReduce",
  FontWeight->"Bold"],
 " oder ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " herangezogen werden."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"expr1", "=", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"3", "-", 
      SqrtBox["5"]}]], "+", 
    SqrtBox[
     RowBox[{"3", "+", 
      SqrtBox["5"]}]]}], "\[Equal]", 
   SqrtBox["10"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"expr1", "//", "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Beide Beispiele geh\[ODoubleDot]ren zu einer Familie von Identit\
\[ADoubleDot]ten der folgenden Bauart, die f\[UDoubleDot]r a>b>0 gelten, was \
aber nicht einmal ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " in der Lage ist nachzupr\[UDoubleDot]fen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SqrtBox[
      RowBox[{"a", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]], "+", 
     SqrtBox[
      RowBox[{"a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]]}], "\[Equal]", 
    SqrtBox[
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}]]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"expr2", ",", 
   RowBox[{"a", ">", "b", ">", "0"}]}], "]"}]], "Input"],

Cell["\<\
Dabei m\[UDoubleDot]ssen nur beide Seiten quadriert und vereinfacht werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"expr2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
       ",", 
      RowBox[{
      "expr2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
     "}"}], "2"], ",", 
   RowBox[{"a", ">", "b", ">", "0"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Beispiele dieser Art k\[ODoubleDot]nnen beliebig kompliziert sein. In den \
1960er Jahren ist im Zusammenhang mit dem 10. Hilbertschen Problem bewiesen \
worden, dass die Frage der algorithmischen Bestimmung des Wahrheitswerts \
eines Booleschen Ausdrucks bereits in nicht sehr umfangreichen Klassen nicht \
entscheidbar ist.\nMit folgendem Beispiel kommt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 nun jedoch in beiden Varianten nach einiger Arbeit zurecht."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"expr3", "=", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "7"], "]"}], "-", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"2", "\[Pi]"}], "7"], "]"}], "+", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"3", "\[Pi]"}], "7"], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"expr3", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"expr4", "=", 
  RowBox[{"expr3", "//", "TrigToExp"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"expr4", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"expr4", "//", "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Zur Untersuchung der allgemeing\[UDoubleDot]ltigen syntaktischen \
Gleichwertigkeit Boolescher Ausdr\[UDoubleDot]cke mit Symbolvariablen dient \
der Operator === (",
 StyleBox["SameQ",
  FontWeight->"Bold"],
 "). Beachten Sie aber, dass nat\[UDoubleDot]rlich auch hier vor dem \
Vergleich die Argumente von ",
 StyleBox["SameQ",
  FontWeight->"Bold"],
 " ausgewertet werden."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "===", 
  RowBox[{"y", "+", "x"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "x"}], "===", 
  RowBox[{"2", "x"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "+", "x"}], "===", 
  RowBox[{"x", 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}]}]}]], "Input"],

Cell[TextData[{
 "=== (",
 StyleBox["SameQ",
  FontWeight->"Bold"],
 ") und \[Equal] (",
 StyleBox["Equal",
  FontWeight->"Bold"],
 ") reagieren in diesem Beispiel unterschiedlich. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x"}], "===", 
   RowBox[{"x", 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}]}]}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x"}], "==", 
   RowBox[{"x", 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}]}]}], "//", "Expand"}]], "Input"],

Cell["\<\
Auch in Steuerstrukturen kann es geschehen, dass Boolesche \
Ausdr\[UDoubleDot]cke nicht vollst\[ADoubleDot]ndig ausgewertet werden k\
\[ODoubleDot]nnen. 

Verzweigungen werden dann in symbolischer Form als Funktionsausdruck zur\
\[UDoubleDot]ckgegeben.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "y"}], ",", "1", ",", "2"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "/.", 
  RowBox[{"x", "\[Rule]", "y"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"y", "+", "1"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Schleifenk\[ODoubleDot]rper werden dagegen nur dann betreten, wenn die \
Testbedingung explizit zu ",
 StyleBox["True",
  FontWeight->"Bold"],
 " auswertet."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "0"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"i", "\[LessEqual]", "n"}], ",", 
    RowBox[{
     RowBox[{"i", "++"}], ";", 
     RowBox[{"Print", "[", "i", "]"}]}]}], "]"}], ";", " ", "i"}]}], "Input"],

Cell[TextData[{
 "Dies kann zu falschen Ergebnissen f\[UDoubleDot]hren, wenn eine Aussage als \
Testbedingung zwar den Wahrheitswert ",
 StyleBox["True",
  FontWeight->"Bold"],
 " hat, dies aber von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nicht erkannt wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["3"]}]], "+", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["3"]}]]}], "\[Equal]", 
  SqrtBox["6"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["i"], "\[LessEqual]", 
     RowBox[{
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox["3"]}]], "+", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["3"]}]]}]}], ",", 
    RowBox[{"i", "++"}]}], "]"}], ";", " ", "i"}]], "Input"],

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox["3"]}]], "+", 
    SqrtBox[
     RowBox[{"2", "-", 
      SqrtBox["3"]}]]}], "\[LessEqual]", 
   SqrtBox["6"]}]}]], "Input"],

Cell[TextData[{
 "Interessanterweise wird als Ergebnis der numerischen N\[ADoubleDot]herung \
",
 StyleBox["True",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ckgegeben, obwohl dies auf Grund von \
Rundungsungenauigkeiten numerisch niemals genau festgestellt werden kann. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"s", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
   RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "N"}]], "Input"],

Cell[TextData[{
 "Mehr noch, wir bekommen damit zwei Ausdr\[UDoubleDot]cke, von denen ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " behauptet, dass sie numerisch gleich seien, ihre Differenz aber nicht \
numerisch gleich Null. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   "\[Equal]", 
   RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
    
    RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "\[Equal]", "0"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "-", 
      RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
      "N"}], "//", "Chop"}], ")"}], "\[Equal]", "0"}]], "Input"],

Cell[TextData[{
 "Mit zus\[ADoubleDot]tzlichem Aufwand kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " den Ausdruck zu ",
 StyleBox["True",
  FontWeight->"Bold"],
 " vereinfachen und liefert dann auch das korrekte Ergebnis."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"s", "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["i"], "\[LessEqual]", 
     RowBox[{"RootReduce", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["3"]}]], "+", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["3"]}]]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"i", "++"}], ";", 
     RowBox[{"Print", "[", "i", "]"}]}]}], "]"}], ";", " ", "i"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Funktionen definieren", "Section"],

Cell[CellGroupData[{

Cell["Transformationen, Regeln, Muster", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"i1", "[", 
   RowBox[{"f", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"i1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"g", "[", "y", "]"}], ",", 
     RowBox[{"f", "[", 
      FractionBox["1", "x"], "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "i1"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"i2", "[", 
   RowBox[{"_", "[", "y_", "]"}], "]"}], ":=", 
  RowBox[{"y", "/", "x"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"i2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"g", "[", "y", "]"}], ",", 
     RowBox[{"g", "[", 
      FractionBox["1", "x"], "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "i2"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Partiell definierte Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "3"}], ",", " ", 
     SqrtBox["12"], ",", "1.7", ",", "x"}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"n", "!"}], 
   RowBox[{
    RowBox[{"k", "!"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "-", "k"}], ")"}], "!"}]}]]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bedingte Funktionsvorschriften", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "!"}], 
    RowBox[{
     RowBox[{"k", "!"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "k"}], ")"}], "!"}]}]], "/;", " ", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "n", "]"}], "\[And]", 
    RowBox[{"IntegerQ", "[", "k", "]"}], "\[And]", 
    RowBox[{"n", "\[GreaterEqual]", "0"}], "\[And]", 
    RowBox[{"k", "\[GreaterEqual]", "0"}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bedingte Muster", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{
    RowBox[{"n_", "?", "NonNegative"}], ",", 
    RowBox[{"k_", "?", "NonNegative"}]}], "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "i", "+", "1"}], "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"NonNegative", ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"{", 
    RowBox[{"1.5", ",", "\[Infinity]", ",", 
     SqrtBox["12"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NonNegative", "/@", "l1"}], "\[IndentingNewLine]", 
 RowBox[{"NumberQ", "/@", "l1"}], "\[IndentingNewLine]", 
 RowBox[{"NumericQ", "/@", "l1"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ourBinomial", "[", 
    RowBox[{"15", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"3.3", ",", "3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"15", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"3.3", ",", "3"}], "}"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"k_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"IntegerQ", "[", "#", "]"}], "\[And]", 
        RowBox[{"NonNegative", "[", "#", "]"}]}], "&"}], ")"}]}]}], "]"}], ":=",
   
  RowBox[{"Product", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "i", "+", "1"}], "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Typmuster", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ourBinomial", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ourBinomial", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"k_Integer", "?", "NonNegative"}]}], "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "i", "+", "1"}], "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ourBinomial", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_Integer", "]"}], ":=", "x"}], "\n", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_Real", "]"}], ":=", "x"}], "\[IndentingNewLine]", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_Integer", "]"}], ":=", "x"}], "\n", 
 RowBox[{"f", "/@", "l"}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], "//", "InputForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Head"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], "//", "FullForm"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"N", "[", "x", "]"}], "]"}]}], "\n", 
 RowBox[{"f", "/@", "l"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Funktionen mit variabler Parameterzahl", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"relSum", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"a", "+", "b"}], 
   RowBox[{"1", "+", 
    RowBox[{"a", " ", "b"}]}]]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"relSum", "[", 
   RowBox[{"a_", ",", "b_", ",", "c__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"relSum", "[", 
    RowBox[{"a", ",", 
     RowBox[{"relSum", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}], "//", "Together"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"relSum", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"relSum", "[", 
  RowBox[{"0.4", ",", "0.4", ",", "0.4", ",", "0.4"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"relSum", "[", 
  RowBox[{"a", ",", "1", ",", "b"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Muster, Regeln, Substitutionen und lokale Zuweisungen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   RowBox[{"2", "a", " ", 
    SuperscriptBox["b", "2"]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", "1"}]}], ",", 
    RowBox[{"b", "\[Rule]", "2"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   RowBox[{"2", "a", " ", 
    SuperscriptBox["b", "2"]}]}], "//.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", "1"}]}], ",", 
    RowBox[{"b", "\[Rule]", "2"}]}], "}"}]}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
St\[UDoubleDot]ckweise zusammengesetzte Funktionen\
\>", "Section"],

Cell[CellGroupData[{

Cell["Realisierung als bedingte Funktionsdefinitions", "Subsection"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", " ", "/;", " ", 
   RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"1", " ", "/;", " ", 
   RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"3", "-", "x"}], " ", "/;", " ", 
   RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", "0", " "}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", " ", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1"}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1"}]}], "//", "Hold"}], "//", 
  "FullForm"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", " ", "/;", " ", 
   RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"1", " ", "/;", " ", 
   RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"3", "-", "x"}], " ", "/;", " ", 
   RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_Real", "]"}], ":=", "0", " "}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1"}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.1", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.5", "]"}]}], "}"}], " "}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.1", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.5", "]"}]}], "}"}], " ", "//", 
  "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "x", "]"}], ",", "  ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Funktionsdefinition mit If oder Which", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"0", "\[LessEqual]", "x", "<", "1"}], ",", "x", ",", 
    RowBox[{"1", "\[LessEqual]", "x", "<", "2"}], ",", "1", ",", 
    RowBox[{"2", "\[LessEqual]", "x", "<", "3"}], ",", 
    RowBox[{"3", "-", "x"}], ",", "True", ",", "0"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "+", "0.1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dashed"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0", "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", 
     RowBox[{"-", "0.1"}], "]"}], ",", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "0.1", "]"}]}], "}"}], " "}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Realisierung mit Piecewise", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", " ", 
        RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "-", "x"}], ",", 
        RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]}], "}"}]}], "}"}], ",", 
    "0"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"1", 
      RowBox[{"1", "\[LessEqual]", "x", "<", "2"}]},
     {
      RowBox[{"3", "-", "x"}], 
      RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]},
     {"x", 
      RowBox[{"0", "\[LessEqual]", "x", "<", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.84]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "+", "0.1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Dashed"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   AdjustmentBox["f",
    BoxMargins->{{-0.238806, 0.238806}, {0, 0}}], 
   AdjustmentBox["'",
    BoxMargins->{{-0.079602, 0.079602}, {0, 0}}]}], 
  AdjustmentBox["[",
   BoxMargins->{{-0.079602, 0.079602}, {0, 0}}], 
  AdjustmentBox["x",
   BoxMargins->{{-0.079602, 0.079602}, {0, 0}}], 
  AdjustmentBox["]",
   BoxMargins->{{-0.079602, 0.079602}, {0, 0}}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", " ", 
     RowBox[{"Direction", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"x", 
      RowBox[{"1", "<", "x"}]},
     {
      RowBox[{
       RowBox[{"2", 
        SqrtBox["x"]}], "-", "1"}], 
      RowBox[{"x", "\[LessEqual]", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.84]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "''"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "*", 
   RowBox[{"UnitStep", "[", 
    RowBox[{"x", "*", "y"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "*", 
     RowBox[{"Floor", "[", "y", "]"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"1", "<", "x", "<", "2"}], "&&", 
    RowBox[{"2", "<", "y", "<", "4"}]}]}], "]"}]], "Input",
 CellID->897672834],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{"0", "\[LessEqual]", "x", "<", "1"}], ",", "x", ",", 
     RowBox[{"1", "\[LessEqual]", "x", "<", "2"}], ",", "1", ",", 
     RowBox[{"2", "\[LessEqual]", "x", "<", "3"}], ",", 
     RowBox[{"3", "-", "x"}]}], "]"}], "//", "PiecewiseExpand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "'"}], "[", "x", "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Funktionen von Funktionen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"Sin", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"f", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sin", "'"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "[", "x", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Namenlose Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{"Log", "'"}]], "Input"],

Cell[BoxData[
 RowBox[{"ArcTan", "'"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"dlog", "=", 
  RowBox[{"Log", "'"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"dlog", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"elog", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"1", "/", "x"}]}], "]"}]}], ";", 
  RowBox[{"elog", "[", "b", "]"}]}]], "Input"],

Cell[TextData[{
 "Solche namenlosen Funktionen treten \[UDoubleDot]berall dort auf, wo ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " selbst Funktionen erzeugt; etwa in der Ausgabe der L\[ODoubleDot]sung von \
Differenzialgleichungen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "}"}], "/.", 
  RowBox[{
  "lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Interpolationsfunktionen", "Subsection"],

Cell[BoxData[
 RowBox[{"Options", "[", "Interpolation", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
    "0.53", ",", "0.66", ",", "0.24", ",", "0.58", ",", "0.92", ",", "0.65", 
     ",", "0.19", ",", "0.67", ",", "0.52", ",", "0.30"}], "}"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", "data", "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", ".02", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "[", "x", "]"}], "-", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "''"}], "[", "x", "]"}], "-", "2.5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"-", "0.01"}], ",", 
      RowBox[{"+", "0.01"}], ",", "0.002"}], "]"}]}], ")"}]}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Funktionen mit Ged\[ADoubleDot]chntis", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"Switch", "[", 
    RowBox[{"n", ",", "0", ",", "0", ",", "1", ",", "1", ",", "_", ",", 
     RowBox[{
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell[BoxData[
 RowBox[{"fib", "[", "6", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "fib", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell[BoxData[
 RowBox[{"fib", "[", "6", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell[BoxData[
 RowBox[{"fib", "[", "1000", "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerische Funktionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "/.", 
   RowBox[{"x", "->", "2"}]}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox["x", "2"], "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", "20"}], "]"}]], "Input"],

Cell["\<\
Zusatzdefinition, damit f in beliebiger Genauigkeit berechnet werden kann\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ",", "_"}], "]"}], "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       SuperscriptBox["x", "2"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", "20"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox["x", "2"], "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}]}], "]"}]], "Input"]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{620, 571},
WindowMargins->{{Automatic, 201}, {Automatic, 108}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 42, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[657, 27, 41, 0, 55, "Section"],
Cell[701, 29, 61, 1, 28, "Input"],
Cell[765, 32, 68, 1, 28, "Input"],
Cell[836, 35, 399, 10, 127, "SmallText"],
Cell[1238, 47, 679, 21, 94, "Input"],
Cell[1920, 70, 582, 10, 144, "SmallText"],
Cell[2505, 82, 295, 9, 28, "Input"],
Cell[2803, 93, 238, 4, 59, "SmallText"],
Cell[3044, 99, 947, 30, 69, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[4028, 134, 56, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[4109, 138, 58, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[4192, 142, 136, 2, 28, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],
Cell[4331, 146, 237, 7, 28, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],
Cell[4571, 155, 212, 5, 41, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}],
Cell[4786, 162, 117, 2, 28, "Input",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 10100}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[4952, 170, 64, 0, 29, "Subsection"],
Cell[5019, 172, 66, 1, 28, "Input"],
Cell[5088, 175, 272, 9, 30, "Input"],
Cell[5363, 186, 312, 10, 30, "Input"],
Cell[5678, 198, 120, 3, 42, "SmallText"],
Cell[5801, 203, 322, 11, 30, "Input"],
Cell[6126, 216, 337, 11, 52, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6500, 232, 73, 2, 29, "Subsection"],
Cell[6576, 236, 949, 23, 195, "SmallText"],
Cell[7528, 261, 410, 14, 52, "Input"],
Cell[7941, 277, 160, 5, 28, "Input"],
Cell[8104, 284, 495, 13, 93, "SmallText"],
Cell[8602, 299, 54, 1, 28, "Input"],
Cell[8659, 302, 55, 1, 28, "Input"],
Cell[8717, 305, 167, 5, 42, "SmallText"],
Cell[8887, 312, 563, 19, 72, "Input"],
Cell[9453, 333, 163, 5, 42, "SmallText"],
Cell[9619, 340, 368, 15, 38, "Input"],
Cell[9990, 357, 83, 2, 28, "Input"],
Cell[10076, 361, 364, 10, 93, "SmallText"],
Cell[10443, 373, 231, 10, 36, "Input"],
Cell[10677, 385, 264, 9, 59, "SmallText"],
Cell[10944, 396, 233, 10, 36, "Input"],
Cell[11180, 408, 65, 1, 28, "Input"],
Cell[11248, 411, 295, 7, 59, "SmallText"],
Cell[11546, 420, 522, 20, 63, "Input"],
Cell[12071, 442, 126, 3, 28, "Input"],
Cell[12200, 447, 104, 2, 42, "SmallText"],
Cell[12307, 451, 364, 11, 30, "Input"],
Cell[12674, 464, 508, 9, 127, "SmallText"],
Cell[13185, 475, 302, 10, 42, "Input"],
Cell[13490, 487, 65, 1, 28, "Input"],
Cell[13558, 490, 89, 2, 28, "Input"],
Cell[13650, 494, 54, 1, 28, "Input"],
Cell[13707, 497, 65, 1, 28, "Input"],
Cell[13775, 500, 410, 11, 76, "SmallText"],
Cell[14188, 513, 97, 3, 28, "Input"],
Cell[14288, 518, 92, 3, 28, "Input"],
Cell[14383, 523, 166, 6, 30, "Input"],
Cell[14552, 531, 199, 8, 42, "SmallText"],
Cell[14754, 541, 200, 7, 30, "Input"],
Cell[14957, 550, 199, 7, 30, "Input"],
Cell[15159, 559, 282, 7, 93, "SmallText"],
Cell[15444, 568, 144, 4, 28, "Input"],
Cell[15591, 574, 79, 2, 28, "Input"],
Cell[15673, 578, 103, 3, 28, "Input"],
Cell[15779, 583, 57, 1, 28, "Input"],
Cell[15839, 586, 192, 6, 59, "SmallText"],
Cell[16034, 594, 340, 10, 49, "Input"],
Cell[16377, 606, 291, 9, 59, "SmallText"],
Cell[16671, 617, 197, 9, 36, "Input"],
Cell[16871, 628, 365, 14, 40, "Input"],
Cell[17239, 644, 232, 10, 36, "Input"],
Cell[17474, 656, 288, 7, 59, "SmallText"],
Cell[17765, 665, 50, 1, 28, "Input"],
Cell[17818, 668, 212, 5, 28, "Input"],
Cell[18033, 675, 254, 6, 59, "SmallText"],
Cell[18290, 683, 223, 6, 28, "Input"],
Cell[18516, 691, 251, 7, 28, "Input"],
Cell[18770, 700, 314, 9, 28, "Input"],
Cell[19087, 711, 253, 8, 59, "SmallText"],
Cell[19343, 721, 59, 1, 28, "Input"],
Cell[19405, 724, 473, 17, 40, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19927, 747, 40, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[19992, 751, 54, 0, 45, "Subsection"],
Cell[20049, 753, 76, 1, 28, "Input"],
Cell[20128, 756, 161, 5, 28, "Input"],
Cell[20292, 763, 325, 10, 42, "Input"],
Cell[20620, 775, 46, 1, 28, "Input"],
Cell[20669, 778, 132, 4, 28, "Input"],
Cell[20804, 784, 325, 10, 42, "Input"],
Cell[21132, 796, 46, 1, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[21215, 802, 52, 0, 29, "Subsection"],
Cell[21270, 804, 190, 6, 36, "Input"],
Cell[21463, 812, 355, 12, 66, "Input"],
Cell[21821, 826, 164, 5, 28, "Input"],
Cell[21988, 833, 161, 5, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[22186, 843, 52, 0, 29, "Subsection"],
Cell[22241, 845, 602, 18, 86, "Input"],
Cell[22846, 865, 164, 5, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[23047, 875, 37, 0, 29, "Subsection"],
Cell[23087, 877, 451, 13, 82, "Input"],
Cell[23541, 892, 89, 2, 28, "Input"],
Cell[23633, 896, 164, 5, 28, "Input"],
Cell[23800, 903, 336, 8, 97, "Input"],
Cell[24139, 913, 182, 6, 28, "Input"],
Cell[24324, 921, 179, 6, 28, "Input"],
Cell[24506, 929, 575, 18, 82, "Input"],
Cell[25084, 949, 164, 5, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[25285, 959, 31, 0, 29, "Subsection"],
Cell[25319, 961, 423, 12, 62, "Input"],
Cell[25745, 975, 164, 5, 28, "Input"],
Cell[25912, 982, 181, 4, 69, "Input"],
Cell[26096, 988, 195, 4, 85, "Input"],
Cell[26294, 994, 122, 3, 65, "Input"],
Cell[26419, 999, 44, 1, 44, "Input"],
Cell[26466, 1002, 70, 2, 48, "Input"],
Cell[26539, 1006, 53, 1, 44, "Input"],
Cell[26595, 1009, 69, 2, 48, "Input"],
Cell[26667, 1013, 203, 6, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26907, 1024, 60, 0, 29, "Subsection"],
Cell[26970, 1026, 203, 7, 42, "Input"],
Cell[27176, 1035, 274, 8, 28, "Input"],
Cell[27453, 1045, 92, 2, 28, "Input"],
Cell[27548, 1049, 110, 2, 28, "Input"],
Cell[27661, 1053, 92, 2, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[27790, 1060, 75, 0, 29, "Subsection"],
Cell[27868, 1062, 316, 11, 30, "Input"],
Cell[28187, 1075, 317, 11, 30, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28553, 1092, 77, 2, 35, "Section"],
Cell[CellGroupData[{
Cell[28655, 1098, 68, 0, 45, "Subsection"],
Cell[28726, 1100, 596, 16, 109, "Input"],
Cell[29325, 1118, 44, 1, 28, "Input"],
Cell[29372, 1121, 340, 11, 28, "Input"],
Cell[29715, 1134, 187, 6, 28, "Input"],
Cell[29905, 1142, 173, 6, 28, "Input"],
Cell[30081, 1150, 582, 16, 109, "Input"],
Cell[30666, 1168, 187, 6, 28, "Input"],
Cell[30856, 1176, 340, 11, 28, "Input"],
Cell[31199, 1189, 319, 11, 28, "Input"],
Cell[31521, 1202, 333, 12, 44, "Input"],
Cell[31857, 1216, 361, 12, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[32255, 1233, 59, 0, 29, "Subsection"],
Cell[32317, 1235, 423, 10, 49, "Input"],
Cell[32743, 1247, 581, 19, 49, "Input"],
Cell[33327, 1268, 340, 12, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[33704, 1285, 48, 0, 29, "Subsection"],
Cell[33755, 1287, 639, 19, 69, "Input"],
Cell[34397, 1308, 739, 21, 53, "Input"],
Cell[35139, 1331, 44, 1, 28, "Input"],
Cell[35186, 1334, 581, 19, 49, "Input"],
Cell[35770, 1355, 406, 12, 44, "Input"],
Cell[36179, 1369, 333, 11, 44, "Input"],
Cell[36515, 1382, 684, 21, 61, "Input"],
Cell[37202, 1405, 168, 5, 44, "Input"],
Cell[37373, 1412, 72, 2, 44, "Input"],
Cell[37448, 1416, 73, 2, 44, "Input"],
Cell[37524, 1420, 208, 6, 44, "Input"],
Cell[37735, 1428, 326, 10, 46, "Input",
 CellID->897672834],
Cell[38064, 1440, 381, 9, 44, "Input"],
Cell[38448, 1451, 72, 2, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[38569, 1459, 44, 0, 35, "Section"],
Cell[38616, 1461, 76, 1, 28, "Input"],
Cell[38695, 1464, 131, 4, 30, "Input"],
Cell[38829, 1470, 129, 4, 30, "Input"],
Cell[38961, 1476, 57, 1, 28, "Input"],
Cell[39021, 1479, 75, 2, 28, "Input"],
Cell[39099, 1483, 46, 1, 28, "Input"],
Cell[39148, 1486, 54, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[39227, 1491, 42, 0, 45, "Subsection"],
Cell[39272, 1493, 46, 1, 28, "Input"],
Cell[39321, 1496, 49, 1, 28, "Input"],
Cell[39373, 1499, 57, 1, 28, "Input"],
Cell[39433, 1502, 72, 2, 28, "Input"],
Cell[39508, 1506, 57, 1, 28, "Input"],
Cell[39568, 1509, 219, 7, 28, "Input"],
Cell[39790, 1518, 260, 6, 59, "SmallText"],
Cell[40053, 1526, 384, 13, 28, "Input"],
Cell[40440, 1541, 250, 8, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[40727, 1554, 46, 0, 29, "Subsection"],
Cell[40776, 1556, 72, 1, 28, "Input"],
Cell[40851, 1559, 243, 7, 28, "Input"],
Cell[41097, 1568, 92, 2, 28, "Input"],
Cell[41192, 1572, 1087, 36, 69, "Input"],
Cell[42282, 1610, 288, 10, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42619, 1626, 56, 0, 35, "Section"],
Cell[42678, 1628, 76, 1, 28, "Input"],
Cell[42757, 1631, 417, 11, 49, "Input"],
Cell[43177, 1644, 46, 1, 28, "Input"],
Cell[43226, 1647, 56, 1, 28, "Input"],
Cell[43285, 1650, 46, 1, 28, "Input"],
Cell[43334, 1653, 554, 17, 89, "Input"],
Cell[43891, 1672, 46, 1, 28, "Input"],
Cell[43940, 1675, 56, 1, 28, "Input"],
Cell[43999, 1678, 46, 1, 28, "Input"],
Cell[44048, 1681, 59, 1, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[44144, 1687, 40, 0, 35, "Section"],
Cell[44187, 1689, 369, 12, 50, "Input"],
Cell[44559, 1703, 54, 1, 28, "Input"],
Cell[44616, 1706, 78, 2, 28, "Input"],
Cell[44697, 1710, 128, 4, 28, "Input"],
Cell[44828, 1716, 44, 1, 28, "Input"],
Cell[44875, 1719, 324, 11, 30, "Input"],
Cell[45202, 1732, 78, 2, 28, "Input"],
Cell[45283, 1736, 44, 1, 28, "Input"],
Cell[45330, 1739, 437, 14, 30, "Input"],
Cell[45770, 1755, 54, 1, 28, "Input"],
Cell[45827, 1758, 54, 1, 28, "Input"],
Cell[45884, 1761, 398, 13, 50, "Input"],
Cell[46285, 1776, 44, 1, 28, "Input"],
Cell[46332, 1779, 54, 1, 28, "Input"],
Cell[46389, 1782, 54, 1, 28, "Input"],
Cell[46446, 1785, 78, 2, 28, "Input"],
Cell[46527, 1789, 78, 2, 28, "Input"],
Cell[46608, 1793, 107, 3, 28, "Input"],
Cell[46718, 1798, 102, 2, 42, "SmallText"],
Cell[46823, 1802, 380, 13, 30, "Input"],
Cell[47206, 1817, 44, 1, 28, "Input"],
Cell[47253, 1820, 107, 3, 28, "Input"],
Cell[47363, 1825, 435, 14, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
