(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    168880,       6000]
NotebookOptionsPosition[    145393,       5375]
NotebookOutlinePosition[    145817,       5394]
CellTagsIndexPosition[    145774,       5391]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Gleichungen und Ungleichungen", "Title"],

Cell[CellGroupData[{

Cell["Solve und Reduce", "Section"],

Cell[CellGroupData[{

Cell["\<\
Lineare und algebraische Gleichungen\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell["\<\
Die Menge der Variablen muss nicht unbedingt angegeben werden, wenn klar ist, \
dass nach allen Variablen aufgel\[ODoubleDot]st werden soll.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", "x"}], "+", "2"}], "\[Equal]", "0"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}]}], "\[Equal]", "11"}]}], "}"}], "]"}]], "Input"],

Cell["\<\
Enth\[ADoubleDot]lt ein Ausdruck \[UDoubleDot]berz\[ADoubleDot]hlige \
Variablen, die als Parameter betrachtet werden sollen, dann ist das zweite \
Argument erforderlich. Je nachdem, welche Variable als Parameter gesetzt \
wird, ergeben sich unterschiedliche L\[ODoubleDot]sungen (es sind ja auch \
unterschiedliche Aufgaben).\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input",\

 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", "y"}], "]"}]], "Input",\

 PageWidth->Infinity],

Cell[TextData[{
 "L\[ADoubleDot]sst man das zweite Argument weg, so ist das Ergebnis dasselbe \
wie in der Notation, wo alle Variablen als zweites Argument angegeben werden. \
In diesem Fall entscheidet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " selbst, welche Variablen als Parameter betrachtet werden. Der Nutzer hat \
auf diese Auswahl keinen Einfluss. Insbesondere zeigt dieses Beispiel, dass \
die Reihenfolge der Variablen auf diese Auswahl keinen Einfluss hat."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "y"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Beachten Sie, dass f\[UDoubleDot]r einen Parameter ",
 StyleBox["y",
  FontSlant->"Italic"],
 " die L\[ODoubleDot]sungen \[UDoubleDot]ber dem K\[ODoubleDot]rper",
 StyleBox[" Q(y) ",
  FontSlant->"Italic"],
 "bestimmt werden. Dabei k\[ODoubleDot]nnen L\[ODoubleDot]sungen, die nur f\
\[UDoubleDot]r spezielle ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-Werte existieren, unter den Tisch fallen. \n\nDie Warnung, dass nicht alle \
L\[ODoubleDot]sungen gefunden wurden, ist also ernst zu nehmen. Sie bedeutet \
allerdings nicht, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " falsch rechnet (das tut es beim Gleichungsl\[ODoubleDot]sen gelegentlich \
auch), sondern dass es zwei Interpretationen der Aufgabenstellung ",
 StyleBox["Solve",
  FontSlant->"Italic"],
 " gibt und Sie vielleicht gerade die andere meinen.\n\nDer Unterschied wird \
am folgenden einfachen Beispiel bereits deutlich."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", "b"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " findet die allgemeine L\[ODoubleDot]sung, d.h. die L\[ODoubleDot]sung im K\
\[ODoubleDot]rper Q(a,b), diesmal sogar ohne Warnungen. \nDass es noch eine L\
\[ODoubleDot]sung ",
 StyleBox["x - beliebig ",
  FontSlant->"Italic"],
 "f\[UDoubleDot]r die speziellen Parameterwerte a\[Equal]b\[Equal]0 gibt \
bleibt dabei au\[SZ]er Betracht.\nEine vollst\[ADoubleDot]ndige \
\[CapitalUDoubleDot]bersicht \[UDoubleDot]ber alle L\[ODoubleDot]sungen, auch \
f\[UDoubleDot]r spezielle Parameterwerte, produziert das Kommando ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "x"}], "-", "b"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"u", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", "b"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "x"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Sie k\[ODoubleDot]nnen im ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Kommando ein drittes Argument angeben, um Abh\[ADoubleDot]ngigkeiten \
explizit zu eliminieren. Das Ergebnis ist dasselbe wie bei einem herk\
\[ODoubleDot]mmlichen ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Aufruf mit dem Ergebnis einer Eliminationsaufgabe."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], "\[Equal]", "2"}]}], "}"}], ",", "x", ",", 
   "y"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "-", "y"}], "\[Equal]", "2"}]}], "}"}], ",", "y"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"u", ",", "x"}], "]"}]}], "Input"],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " m\[UDoubleDot]ssen Gleichungen als Gleichungen angeschrieben werden. Eine \
Liste von Polynomen wird nicht akzeptiert - die aus anderen CAS bekannte \
Interpretation als Aufgabe zur Nullstellenbestimmung muss explizit \
angeschrieben werden. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "-", "2"}], ",", 
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      SuperscriptBox["y", "2"], "-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"sys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}], "+", "z"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       RowBox[{"7", "z"}]}], "\[Equal]", "5"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", "sys", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], " ", "/.", " ", 
  RowBox[{
  "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"2", "3", "1"},
      {"1", 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"3", "0", "7"}
     }], ")"}]}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"(", GridBox[{
      {"x1"},
      {"x2"},
      {"x3"}
     }], ")"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"(", GridBox[{
      {"1"},
      {"4"},
      {"5"}
     }], ")"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Aus dieser komplexeren Notation lassen sich die Zutaten f\[UDoubleDot]r das \
",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Kommando wie folgt extrahieren:"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"vars", "=", 
  RowBox[{"Flatten", "[", "x", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], "]"}], " "}]}], "Input"],

Cell["\<\
Die Antwort wird wieder als Substitutionsliste gegeben, woraus sich die L\
\[ODoubleDot]sung in Matrixnotation wie folgt gewinnen l\[ADoubleDot]sst. \
Auch die Probe l\[ADoubleDot]sst sich leicht ausf\[UDoubleDot]hren.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], ")"}], "/.", 
  "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"mat", ".", "x"}], "-", "b"}], ")"}], "/.", "sol"}], 
   ")"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Transzendente Gleichungen ", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " verwendet beim L\[ODoubleDot]sen transzendenter Gleichungen intern den \
Mechanismus der ",
 StyleBox["InverseFunction",
  FontWeight->"Bold"],
 ". Da die meisten transzendenten Funktionen keine Inverse \[UDoubleDot]ber \
dem ganzen Definitionsbereich besitzen, ist das Ergebnis von beschr\
\[ADoubleDot]nkter Aussagekraft. Meist wird nur eine L\[ODoubleDot]sung, der \
Hauptwert, angegeben.\nMit dem folgenden Ergebnis w\[UDoubleDot]rden Sie im \
Abitur sicher nur mittelm\[ADoubleDot]\[SZ]ig abschneiden."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
    FractionBox["1", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[TextData[{
 "Das Kommando ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " hilft weiter. Die Verbindung zu ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " m\[UDoubleDot]ssen Sie aber selbst herstellen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
     FractionBox["1", "2"]}], ",", "x"}], "]"}]}]], "Input"],

Cell[TextData[{
 "Es ist auch deutlich besser mit Zusatzinformationen konditionierbar als ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
      FractionBox["1", "2"]}], "&&", 
     RowBox[{
      RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"u", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{
     RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"sol", "&&", 
     RowBox[{
      RowBox[{"-", "5"}], "<", "x", "<", "5"}]}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"u", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "//.", "v"}]], "Input"],

Cell["Beispiel: Eine Exponentialgleichung", "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "x"], "+", 
     SuperscriptBox["a", 
      RowBox[{"2", "x"}]]}], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Messages", "[", "Solve", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"Solve", "::", "\"\<ifun\>\""}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "+", 
      SuperscriptBox["u", "2"]}], "\[Equal]", "1"}], ",", "u"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "x"], "\[Equal]", "u"}], ",", "x"}], "]"}], "/.", 
  RowBox[{
  "sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "x"], "+", 
     SuperscriptBox["a", 
      RowBox[{"2", "x"}]]}], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"rsol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "x"], "+", 
       SuperscriptBox["a", 
        RowBox[{"2", "x"}]]}], "\[Equal]", "1"}], "&&", 
     RowBox[{"a", ">", "0"}]}], ",", "x", ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rsol", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "//",
   "ToRules"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"rsol", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
   ",", "x"}], "]"}]], "Input"],

Cell[TextData[{
 "Bei transzendenten Gleichungen ist die explizite Angabe der Variablen, nach \
der aufgel\[ODoubleDot]st werden soll, oftmals erforderlich, um \
Fehlinterpertationen der Gleichung durch ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "zu vermeiden."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "\[Equal]", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], ";", " ", 
  RowBox[{"Solve", "[", "eq", "]"}]}]], "Input"],

Cell[TextData[{
 "So findet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " die (wichtigsten der) L\[ODoubleDot]sungen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"eq", ",", "x"}], "]"}]}]], "Input"],

Cell[TextData[{
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " findet die gesamte L\[ODoubleDot]sungsmenge und durch \
zus\[ADoubleDot]tzliche Beschr\[ADoubleDot]nkung auf ein Intervall lassen \
sich auch einzelne L\[ODoubleDot]sungen isolieren. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eq", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"eq", "&&", 
       RowBox[{"0", "<", "x", "<", "2"}]}], ",", "x"}], "]"}], "//", 
    "Simplify"}], "//", "ToRules"}]}]], "Input"],

Cell[TextData[{
 "Und hier die Probe mit beiden L\[ODoubleDot]sungen. ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " hat sowohl Schwierigkeiten, unterschiedliche Wurzelausdr\[UDoubleDot]cke \
als gleichwertig zu erkennen, als auch Ausdr\[UDoubleDot]cke mit \
trigonometrischen und Arcusfunktionen zu analysieren. ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " schafft es in allen (diesen) F\[ADoubleDot]llen."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "/.", "sol1"}], "//", "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "/.", "sol2"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/.", 
    RowBox[{"sol1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
   ")"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol2"}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "FullSimplify"}]}], "Input"],

Cell[TextData[{
 "Diese L\[ODoubleDot]sung gibt ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " als Antwort. Auch deren Gleichwertigkeit findet ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " heraus. Beachten Sie, dass Klammern gesetzt werden m\[UDoubleDot]ssen, da \
die Bindungskraft des Infixoperators \[Equal] h\[ODoubleDot]her ist als der \
von /. . Ohne Klammern w\[UDoubleDot]rde die zweite Zeile als ",
 StyleBox["x /. (sol1\[LeftDoubleBracket]2\[RightDoubleBracket] \[Equal] x) \
/. sol3",
  FontWeight->"Bold"],
 " gr\[UDoubleDot]ndlich missverstanden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"sol3", "=", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["3"], "-", "1"}], 
      RowBox[{
       SqrtBox["3"], "+", "1"}]], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/.", 
    RowBox[{"sol1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   ")"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol3"}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "FullSimplify"}]}], "Input"],

Cell["\<\
Und hier noch einige Beispiele.
Transzendente Gleichungen sehr unterschiedlicher Struktur k\[ODoubleDot]nnen \
gel\[ODoubleDot]st werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox[
      RowBox[{"x", "+", "1"}]], "+", 
     SqrtBox[
      RowBox[{"x", "-", "1"}]]}], "\[Equal]", "a"}], ",", "x"}], 
  "]"}]], "Input"],

Cell["\<\
Diese Wurzelgleichung ist \[ADoubleDot]quivalent zu einer Eliminationsaufgabe \
mit folgendem System\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "1"}], "\[Equal]", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{
      RowBox[{"x", "-", "1"}], "\[Equal]", 
      SuperscriptBox["z", "2"]}], ",", 
     RowBox[{
      RowBox[{"y", "+", "z"}], "\[Equal]", "a"}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "und dieses wiederum zu diesem ",
 StyleBox["Eliminate",
  FontWeight->"Bold"],
 "-Kommando"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "1"}], "\[Equal]", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{
      RowBox[{"x", "-", "1"}], "\[Equal]", 
      SuperscriptBox["z", "2"]}], ",", 
     RowBox[{
      RowBox[{"y", "+", "z"}], "\[Equal]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "x"}], "]"}]}], "Input"],

Cell["Ein weiteres Beispiel.", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "3"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell["\<\
Diese Gleichung l\[ADoubleDot]sst sich auf eine algebraische \
zur\[UDoubleDot]ckf\[UDoubleDot]hren.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "2"], 
     RowBox[{"x", "-", "1"}]], "\[Equal]", 
    SuperscriptBox["E", "3"]}], ",", "x"}], "]"}]], "Input"],

Cell[TextData[{
 "Bei wirklich transzendenten Gleichungen wei\[SZ] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dann gelegentlich auch nicht weiter."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["2"], 
     RowBox[{"Log", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "-", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     SuperscriptBox["E", "x"]}], "\[Equal]", "12"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"On", "[", 
   RowBox[{"Solve", "::", "\"\<ifun\>\""}], "]"}], ";"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sungen weiterverarbeiten", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell["\<\
L\[ODoubleDot]sungen werden in Form von Substitutionslisten ausgegeben. Diese \
sind besonders einfach f\[UDoubleDot]r die verschiedensten Zwecke der \
Weiterverarbeitung einzusetzen. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y", "-", "2"}], "\[Equal]", "0"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       SuperscriptBox["y", "2"], "-", "2"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input"],

Cell["L\[ODoubleDot]sungstupel extrahieren", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sol"}]], "Input"],

Cell["\<\
L\[ODoubleDot]sungen in Ausdr\[UDoubleDot]cke einsetzen\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], "/.", "sol"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Expand"}]}], "Input"],

Cell["Die Probe", "SmallText"],

Cell[BoxData[
 RowBox[{"sys", "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"First", "/@", "sys"}], ")"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input"],

Cell["\<\
Weiterarbeit mit einzelnen L\[ODoubleDot]sungen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "n"], "+", 
      SuperscriptBox["y", "n"]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "/.", 
   RowBox[{"sol", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], "//",
   "Expand"}]], "Input"],

Cell["\<\
L\[ODoubleDot]sungen in der komplexen Zahlenebene darstellen\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "5"], "+", 
       RowBox[{"7", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], "]"}], "//",
    "N"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "x", "]"}], ",", 
      RowBox[{"Im", "[", "x", "]"}]}], "}"}], "/.", "l"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.03", "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " kann auch dazu verwendet werden, um implizite Formeln nach einzelnen  \
Variablen aufzul\[ODoubleDot]sen und so Parameterdarstellungen zu gewinnen. \n\
Hier wird eine Kreisgleichung, die zum Vergleich  leicht in die Normalform ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"y", "-", "4"}], ")"}], "2"]}], "\[Equal]"}], 
   TraditionalForm]]],
 "117 gebracht werden kann, nach ",
 StyleBox["y",
  FontSlant->"Italic"],
 " aufgel\[ODoubleDot]st."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", "x"}], "+", 
      SuperscriptBox["y", "2"], "-", 
      RowBox[{"8", "y"}]}], "\[Equal]", "100"}], ",", "y"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f1", "[", "x_", "]"}], ",", 
    RowBox[{"f2", "[", "x_", "]"}]}], "}"}], "=", 
  RowBox[{"y", "/.", "lsg"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f1", "[", "3", "]"}], ",", 
    RowBox[{"f2", "[", "4", "]"}]}], "}"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "[", "x", "]"}], ",", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "12"}], ",", "10"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", " ", "1"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Nullstellen von Polynomen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Die Root-Notation", "Subsection"],

Cell[BoxData[
 RowBox[{"nst", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
    "x"}], "]"}]}]], "Input"],

Cell[TextData[{
 StyleBox["Roots",
  FontWeight->"Bold"],
 " und ",
 StyleBox["ToRules",
  FontWeight->"Bold"]
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"%", "//", "ToRules"}], "}"}]], "Input"],

Cell["\<\
Weiterverarbeitung von Root-Ausdr\[UDoubleDot]cken\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"nst", ",", "20"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x", ",", "30"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "nst"}], ")"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5"}], "}"}]], "/.", "nst"}], ")"}]}], "//",
   "Simplify"}]], "Input"],

Cell["\<\
Parameterabh\[ADoubleDot]ngige Root-Ausdr\[UDoubleDot]cke\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"nst", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "+", 
      RowBox[{"a", " ", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"a", "\[Rule]", "1"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "ToRadicals"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"r1", "[", "a_", "]"}], "=", 
   RowBox[{"x", "/.", 
    RowBox[{"nst", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}],
   ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"r1", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rechnen mit algebraischen Zahlen", "Subsection"],

Cell[TextData[StyleBox["RootReduce",
 FontWeight->"Bold"]], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"3", "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]}]], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}], "//", "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Mehrere ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdr\[UDoubleDot]cke zum selben Polynom\nSimultane Zuweisung an die \
Variablen ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["a", "1"], ",", "...", ",", 
   SubscriptBox["a", "5"]}]]],
 ":"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nst", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",",
      "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", 
    SubscriptBox["a", "2"], ",", 
    SubscriptBox["a", "3"], ",", 
    SubscriptBox["a", "4"], ",", 
    SubscriptBox["a", "5"]}], "}"}], "=", 
  RowBox[{"x", "/.", "nst"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["a", "1"], "-", 
   SubscriptBox["a", "2"]}], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"1", "+", 
    SubscriptBox["a", "1"]}], 
   RowBox[{"1", "-", 
    SubscriptBox["a", "1"]}]], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SubscriptBox["a", "1"], "+", 
    SubscriptBox["a", "2"]}], 
   RowBox[{
    SubscriptBox["a", "3"], "+", 
    SubscriptBox["a", "4"]}]], "//", "RootReduce"}]], "Input"],

Cell["Rationalmachen des Nenners", "SmallText"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{"u", "=", 
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]]}], "\[IndentingNewLine]", 
 RowBox[{"u1", "=", 
  RowBox[{"u", "//", "RootReduce"}]}], "\[IndentingNewLine]", 
 RowBox[{"u2", "=", 
  RowBox[{"u1", "//", "ToRadicals"}]}], "\[IndentingNewLine]", 
 RowBox[{"u3", "=", 
  RowBox[{"u2", "//", "FullSimplify"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"LeafCount", "/@", 
  RowBox[{"{", 
   RowBox[{"u", ",", "u1", ",", "u2", ",", "u3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"], "+", 
     SqrtBox["5"]}]], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "//", "RootReduce"}], "//", "ToRadicals"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell["\<\
Alle Variablen mit Subscript l\[ODoubleDot]schen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Clear", "[", "Subscript", "]"}]], "Input"],

Cell[TextData[{
 "Inverse zu ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"], "+", 
   SqrtBox["5"]}]]],
 "als Linearkombination mit unbestimmten Koeffizienten ansetzen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inv", "=", 
   RowBox[{
    SubscriptBox["a", "0"], "+", 
    RowBox[{
     SubscriptBox["a", "1"], 
     SqrtBox["2"]}], "+", 
    RowBox[{
     SubscriptBox["a", "2"], 
     SqrtBox["3"]}], "+", 
    RowBox[{
     SubscriptBox["a", "3"], 
     SqrtBox["5"]}], "+", 
    RowBox[{
     SubscriptBox["a", "4"], 
     SqrtBox["6"]}], "+", 
    RowBox[{
     SubscriptBox["a", "5"], 
     SqrtBox["10"]}], "+", 
    RowBox[{
     SubscriptBox["a", "6"], 
     SqrtBox["15"]}], "+", 
    RowBox[{
     SubscriptBox["a", "7"], 
     SqrtBox["30"]}]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"ex", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"inv", 
     RowBox[{"(", 
      RowBox[{
       SqrtBox["2"], "+", 
       SqrtBox["3"], "+", 
       SqrtBox["5"]}], ")"}]}], "-", "1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"ex", ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", 
     SqrtBox["3"], ",", 
     SqrtBox["5"]}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Das zugeh\[ODoubleDot]rige lineare Gleichungssystem extrahieren und l\
\[ODoubleDot]sen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"lhs", "=", 
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{"ex", ",", 
     RowBox[{"{", 
      RowBox[{
       SqrtBox["2"], ",", 
       SqrtBox["3"], ",", 
       SqrtBox["5"]}], "}"}]}], "]"}], "//", "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"lhs", "\[Equal]", "0"}], " ", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u2", "=", 
  RowBox[{
   RowBox[{"inv", "/.", 
    RowBox[{"sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "//",
    "Together"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u2", "\[Equal]", "u"}]], "Input"],

Cell[BoxData[
 RowBox[{"LeafCount", "/@", 
  RowBox[{"{", 
   RowBox[{"u", ",", "u1", ",", "u2"}], "}"}]}]], "Input"],

Cell[TextData[StyleBox["RootSum",
 FontWeight->"Bold"]], "SmallText"],

Cell[BoxData[
 RowBox[{"nst", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]], "/.", 
     "nst"}], ")"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "-", "x"}]], "/.", "nst"}], ")"}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "-", "#"}]], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      RowBox[{"3", "#", "z"}], "+", 
      SuperscriptBox["#", "3"]}]], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Normal"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynome dritten und vierten Grades", "Subsection"],

Cell[CellGroupData[{

Cell["Polynome dritten Grades ", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", "x"}], "+", "1"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " verwendet die Cardanoschen Formeln zur Darstellung der Nullstellen eines \
Polynoms dritten Grades. Besonders im casus irreducibilis ist es schwer zu \
entscheiden, dass es sich bei den L\[ODoubleDot]sunngen um reelle Zahlen \
handelt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/.", "sol"}], ")"}], "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol"}], "]"}]}]], "Input"],

Cell[TextData[{
 StyleBox["ComplexExpand",
  FontWeight->"Bold"],
 " findet sogar die trigonometrische Darstellung der entsprechenden \
aklgebraischen Zahlen, die im casus irreducibilis eigentlich verwendet werden \
sollte. Mit trigonometrischen Ausdr\[UDoubleDot]cken kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " aber als algebraische Zahlen schlechter rechnen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"sol", "//", "ComplexExpand"}]}]], "Input"],

Cell[TextData[{
 "Deutlich besser kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " mit der Darstellung  der Nullstellen in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation umgehen, die man etwa wie folgt erzeugen kann:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}], "//", "ToRules"}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol2", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol2"}]}]], "Input"],

Cell["\<\
Rekombination der Nullstellen zum Ausgangspolynom in den drei Darstellungen.
Zun\[ADoubleDot]chst die Darstellung durch Wurzelausdr\[UDoubleDot]cke.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol"}], ")"}]}], ")"}]}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Together"}]], "Input"],

Cell[TextData[{
 "Hier die ausgef\[UDoubleDot]hrten Schritte im Einzelnen. A=",
 Cell[BoxData[
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox["3"]}]],
  CellChangeTimes->{3.35946701622635*^9, 3.35947181917236*^9}],
 " ist der einzige Kern im Absolutglied. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], "-", 
   FractionBox["A", "2"], "-", 
   FractionBox["2", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "A"}]]}], "//", "Together"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   SuperscriptBox["A", "2"], "\[Rule]", 
   RowBox[{"-", "3"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Cancel"}]], "Input"],

Cell["Nun die trigonometrische Darstellung.", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol1"}], ")"}]}], ")"}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "TrigReduce"}]], "Input"],

Cell[TextData[{
 "Und schlie\[SZ]lich die durch ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdr\[UDoubleDot]cke."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol2"}], ")"}]}], ")"}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Generell l\[ADoubleDot]sst sich feststellen, dass ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zwar wei\[SZ], dass die folgenden Ausdr\[UDoubleDot]cke algebraische \
Zahlen sind, aber nur zu wenigen die ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "--Darstellung berechnen kann."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", 
    RowBox[{"Range", "[", 
     RowBox[{"3", ",", "15"}], "]"}]], "]"}], "//", "RootReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"#", "\[Element]", "Algebraics"}], "&"}], "/@", "%"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", 
    RowBox[{"Range", "[", 
     RowBox[{"3", ",", "15"}], "]"}]], "]"}], "//", 
  "FunctionExpand"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynome vierten Grades", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", 
    RowBox[{
     SuperscriptBox["x", "4"], "-", 
     RowBox[{"4", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"7", "x"}], "+", "1"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]}], "Input"],

Cell["\<\
Mit solchen L\[ODoubleDot]sungsformeln kann man wirklich nichts mehr \
anfangen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Dass es sich um vier reelle L\[ODoubleDot]sungen handelt, erkennt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " aus dieser Form nur mit M\[UDoubleDot]he. Selbst das m\[ADoubleDot]chtige \
",
 StyleBox["FullSImplify",
  FontWeight->"Bold"],
 " braucht daf\[UDoubleDot]r einige Zeit."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol"}], "]"}], " ", "//", 
  "Timing"}]], "Input"],

Cell[TextData[{
 "Mit dem Ergebnis von ",
 StyleBox["ComplexExpand",
  FontWeight->"Bold"],
 " kann man wohl auch kaum etwas anfangen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"ComplexExpand", " ", "/@", " ", "sol"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol1", "//", "N"}]], "Input"],

Cell[TextData[{
 "Mit der Darstellung in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation dagegen kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gut umgehen. Alle relevanten Informationen \[UDoubleDot]ber die \
Nullstellen sind ohne weitere Vereinfachungen verf\[UDoubleDot]gbar."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}], "//", "ToRules"}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol2", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Element]", "Reals"}], "/.", "sol2", " "}]], "Input"],

Cell[TextData[{
 "F\[UDoubleDot]r diese Kontrollrechnung schafft es erst das \
m\[ADoubleDot]chtige ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 ", die geschachtelten Wurzelausdr\[UDoubleDot]cke aufzul\[ODoubleDot]sen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol"}], ")"}]}], ")"}]}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", "//", "N"}], "//", "Chop"}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "//", "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Mit der Ausgabe von ",
 StyleBox["ComplexExpand",
  FontWeight->"Bold"],
 " kommt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dagegen \[UDoubleDot]berraschend gut zurecht."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"(", 
      RowBox[{"x", "/.", "sol1"}], ")"}]}], ")"}]}], "//", 
  "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[TextData[{
 "Mit der ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation bereitet diese Vereinfachung ebenfalls keine Schwierigkeiten."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{
   RowBox[{"Times", "@@", 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"(", 
       RowBox[{"x", "/.", "sol2"}], ")"}]}], ")"}]}], "//", 
   "Expand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[TextData[{
 "Auch andere abgeleitete Ausdr\[UDoubleDot]cke wie diese Potenzsummen kann \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " deutlich einfacher vereinfachen, wenn die Nullstellen in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation vorliegen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "/.", "sol"}], 
    ")"}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "/.", "sol2"}], 
    ")"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["y", "2"], "-", 
       RowBox[{"x", " ", "y"}], "-", 
       SuperscriptBox["x", "3"]}]], "/.", "sol"}], ")"}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Schreibt man dieselbe Aufgabe mit den Nullstellen in ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Notation an, so gelingt die Vereinfachung mit ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 ", nachdem ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " der Tipp gegeben wird, es doch einmal mit der rationalen Normalform zu \
versuchen. Der ",
 StyleBox["LeafCount",
  FontWeight->"Bold"],
 " ist deutlich kleiner geworden. ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " stellt \[UDoubleDot]brigens Z\[ADoubleDot]hler und Nenner \
zus\[ADoubleDot]tzlich nach dem Hornerschema dar, was den ",
 StyleBox["LeafCount",
  FontWeight->"Bold"],
 " noch einmal verringert. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["y", "2"], "-", 
       RowBox[{"x", " ", "y"}], "-", 
       SuperscriptBox["x", "3"]}]], "/.", "sol2"}], ")"}]}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "LeafCount"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["y", "2"], "-", 
         RowBox[{"x", " ", "y"}], "-", 
         SuperscriptBox["x", "3"]}]], "/.", "sol2"}], ")"}]}], "//", 
    "Together"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"%", "//", "LeafCount"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"u", "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "LeafCount"}]}], "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomiale Gleichungssysteme", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Beispiel 1: Ein System mit Symmetrien", "Subsection"],

Cell[TextData[{
 "Das folgende Gleichungssystem ist invariant unter zyklischer Vertauschung \
der Variablen. Diese Eigenschaft hat deshalb auch die \
L\[ODoubleDot]sungsmenge. An der Ausgabe des ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Kommandos ist das nicht so recht sichtbar."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "+", "x", "+", "y", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x", "+", "z", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "+", "z", "-", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "//", "FullSimplify"}]], "Input"],

Cell[TextData[{
 "Statt ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " k\[ODoubleDot]nnen Sie auch ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " einsetzen, um Gleichungssysteme in einfachere Form zu bringen. In Ergebnis \
wird das Problem in eine boolesche Kombination mehrerer Teilprobleme zerlegt, \
die sich mit ",
 StyleBox["LogicalExpand",
  FontWeight->"Bold"],
 " in die distributive Normalform bringen l\[ADoubleDot]sst."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"rsys", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], ",", "vars"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"rsys", "//", "LogicalExpand"}]], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " kann auch mit solchen booleschen Kombinationen von Gleichungen aufgerufen \
werden. Hier liefert es gleich die Antwort, welche ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " auf dem Ausgangssystem erst nach Anwendung von ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " gefunden hat."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"rsys", ",", "vars"}], "]"}]], "Input"],

Cell["\<\
Das Vorgehen beim L\[ODoubleDot]sen dieses Systems folgt grob dieser Idee:\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"f", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
   RowBox[{"f", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
  "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Beispiel 2",
  FontWeight->"Bold"],
 ": Bestimmung der kritischen Punkte einer Funktion"
}], "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"6", 
     SuperscriptBox["x", "3"], 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["x", "3"], 
     SuperscriptBox["y", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["x", "4"], 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"f", ",", "x"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"f", ",", "y"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Union"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}], ",", 
   "vars"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Beispiele ", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "+", "x", "+", "y", "+", "z"}], ",", 
     RowBox[{
      RowBox[{"w", " ", "x"}], "+", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"w", " ", "z"}], "+", 
      RowBox[{"y", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"w", " ", "x", " ", "y"}], "+", 
      RowBox[{"w", " ", "x", " ", "z"}], "+", 
      RowBox[{"w", " ", "y", " ", "z"}], "+", 
      RowBox[{"x", " ", "y", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"w", " ", "x", " ", "y", " ", "z"}], "-", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "vars"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"t", " ", 
       RowBox[{"x", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"6", " ", "t", " ", "x", " ", "y", " ", "z"}], "+", 
      RowBox[{"3", " ", "t", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"2", " ", "t", " ", 
       RowBox[{"z", "^", "3"}]}], "-", 
      RowBox[{"6", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"6", " ", "x", " ", "y", " ", "z"}], "-", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "t"}], " ", 
       RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
      RowBox[{"3", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"10", " ", "t", " ", 
       RowBox[{"y", "^", "3"}]}], "-", 
      RowBox[{"15", " ", "t", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"3", " ", "t", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"3", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"10", " ", 
       RowBox[{"y", "^", "3"}]}], "+", 
      RowBox[{"x", " ", "y", " ", "z"}], "+", 
      RowBox[{"15", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"5", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"18", " ", "t", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"3", " ", "t", " ", 
       RowBox[{"x", "^", "3"}], " ", "z"}], "-", 
      RowBox[{"18", " ", "t", " ", 
       RowBox[{"x", "^", "2"}], " ", "y", " ", "z"}], "+", 
      RowBox[{"12", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"5", " ", "t", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"12", " ", "t", " ", "x", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"6", " ", "t", " ", "x", " ", 
       RowBox[{"z", "^", "3"}]}], "-", 
      RowBox[{"8", " ", "t", " ", 
       RowBox[{"z", "^", "4"}]}], "-", 
      RowBox[{"18", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"x", "^", "2"}], " ", "y", " ", "z"}], "-", 
      RowBox[{"12", " ", "x", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"12", " ", "x", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"6", " ", "x", " ", 
       RowBox[{"z", "^", "3"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "63"}], " ", 
       RowBox[{"t", "^", "2"}], " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"t", "^", "2"}], " ", 
       RowBox[{"x", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"63", " ", 
       RowBox[{"t", "^", "2"}], " ", "x", " ", "y", " ", "z"}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"t", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"27", " ", 
       RowBox[{"t", "^", "2"}], " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"18", " ", 
       RowBox[{"t", "^", "2"}], " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"t", "^", "2"}], " ", 
       RowBox[{"z", "^", "3"}]}], "+", 
      RowBox[{"78", " ", "t", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"78", " ", "t", " ", "x", " ", "y", " ", "z"}], "-", 
      RowBox[{"18", " ", "t", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"24", " ", "t", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"18", " ", "t", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"9", " ", "t", " ", 
       RowBox[{"z", "^", "3"}]}], "-", 
      RowBox[{"15", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"15", " ", "x", " ", "y", " ", "z"}], "-", 
      RowBox[{"5", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"%", ",", "vars"}], "]"}]}]}], "Input"],

Cell["Vergleich der beiden L\[ODoubleDot]sungen.", "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Sort", "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"sol1", ",", "sol2"}], "}"}]}], ")"}]}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Eine Geometrieaufgabe", "Subsection"],

Cell[TextData[{
 "Ein Geometrieproblem: Im Dreieck mit den Eckpunkten A(0,0), B(2,0), C(u,1) \
ist P(x1,x2) der Schnittpunkt der Winkelhalbierenden durch A und B. Da sich \
Innen- und Au\[SZ]enwinkelhalbierende algebraisch nicht unterscheiden lassen, \
erhalten wir ein System ",
 StyleBox["whpolys",
  FontWeight->"Bold"],
 " mit zwei Polynomen zweiten Grades und daraus vier m\[ODoubleDot]gliche \
Schnittpunkte der Winkelhalbierdendenpaare durch A und B. Die \
L\[ODoubleDot]sung h\[ADoubleDot]ngt von einem Parameter u ab.\n\n",
 StyleBox["whcon",
  FontWeight->"Bold"],
 " ist die Bedingung, dass P auch auf dem WInkelhalbierendenpaar durch C \
liegt. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whpolys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "-", 
      RowBox[{"4", " ", "x1"}], "+", 
      SuperscriptBox["x1", "2"], "-", 
      RowBox[{"8", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x2"}], "+", 
      RowBox[{"4", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
      SuperscriptBox["x2", "2"]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"2", " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x1", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x1", "2"]}], "-", 
      RowBox[{"4", " ", "x2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["u", "2"], " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "3"], " ", "x2"}], "+", 
      RowBox[{"2", " ", "x1", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1", " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x2", "2"]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x2", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whcon", "=", 
   RowBox[{
    SuperscriptBox["x1", "2"], "-", 
    RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell["\<\
Hier ein Bild, in welches die berechneten Daten unmittelbar eingehen. Die \
Punkte sind so benannt, weil C und D Protected sind und deshalb nicht ohne \
weiteres f\[UDoubleDot]r Zuweisungen zur Verf\[UDoubleDot]gung stehen. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PA", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"PB", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], ";", 
  RowBox[{"PC", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "1"}], "}"}]}], ";", 
  RowBox[{"PP", "=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u0", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"txt1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<A\>\"", ",", 
        RowBox[{"PA", "+", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".1"}], ",", 
           RowBox[{"-", ".1"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<B\>\"", ",", 
        RowBox[{"PB", "+", 
         RowBox[{"{", 
          RowBox[{".1", ",", 
           RowBox[{"-", ".1"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<C\>\"", ",", 
        RowBox[{"PC", "+", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".1"}], "}"}]}]}], "]"}]}], "}"}], "/.", 
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"txt2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{"\"\<P\>\"", ",", "#"}], "]"}], ",", 
          RowBox[{"PP", "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "#"], 
            RowBox[{"{", 
             RowBox[{"0", ",", ".2"}], "}"}]}]}]}], "]"}], "/.", 
        RowBox[{
        "sol", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}]}], "/.",
        
       RowBox[{"u", "\[Rule]", "u0"}]}], ")"}], "&"}], "/@", 
    RowBox[{"Range", "[", "4", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{"PA", ",", "PB", ",", "PC", ",", "PA"}], "}"}], "]"}], "/.", 
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"PA", ",", "PP"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"PB", ",", "PP"}], "}"}]}], "}"}], "]"}], "/.", "sol"}], "/.",
     
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{"PC", ",", "PP"}], "}"}], "]"}], "/.", "sol"}], "/.", 
    RowBox[{"u", "\[Rule]", "u0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Thick", ",", "l", ",", "Blue", ",", "w1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", "w2"}], "}"}], ",", "txt1", ",", 
    "txt2"}], "}"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"whcon", "/.", "sol"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"sol1", ",", 
    RowBox[{
     RowBox[{"!", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"u", "/.", "#"}], ",", "u"}], "]"}]}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"whcon", "//.", "sol"}], "//", "Simplify"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Aufgabenstellungen", "Section"],

Cell[CellGroupData[{

Cell["Elimination von Variablen ", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"glsys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}], "+", "z"}], "\[Equal]", "a"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "b"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", "y", "+", 
       RowBox[{"7", "z"}]}], "\[Equal]", "c"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"glsys", ",", "z"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Eine Aufgabe aus der holl\[ADoubleDot]ndischen Mathematikolympiade (Quelle \
[Heck 1993]):\nWie gro\[SZ] ist ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "4"], "+", 
   SuperscriptBox["b", "4"], "+", 
   SuperscriptBox["c", "4"]}]], "Input"],
 ", wenn ",
 StyleBox["a",
  FontSlant->"Italic"],
 ",",
 StyleBox["b",
  FontSlant->"Italic"],
 " und ",
 StyleBox["c",
  FontSlant->"Italic"],
 " reelle Zahlen sind und folgende Annahmen gelten: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", "b", "+", "c"}], "\[Equal]", "3"}], ",", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[Equal]", "9", " "}]}]], "Input"],
 "sowie",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["b", "3"], "+", 
     SuperscriptBox["c", "3"]}], "\[Equal]", "24"}]}]], "Input"],
 "."
}], "SmallText",
 Background->None],

Cell[BoxData[{
 RowBox[{
  RowBox[{"glsys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "+", "b", "+", "c"}], "\[Equal]", "3"}], ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], "\[Equal]", "9"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       SuperscriptBox["b", "3"], "+", 
       SuperscriptBox["c", "3"]}], "\[Equal]", "24"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sum", "=", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox["b", "4"], "+", 
    SuperscriptBox["c", "4"]}]}], ";"}]}], "Input"],

Cell[TextData[{
 StyleBox["Solve",
  FontWeight->"Bold"],
 " produziert zwar riesige, aber von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leicht zu verarbeitende Menge von Wurzeltermen."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"glsys", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"sum", "/.", "sol"}], "//", "Simplify"}]}], "Input"],

Cell[TextData[{
 "Dieser Zugang mit ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " transformiert zun\[ADoubleDot]chst in eine logisch gleichwertige Form: a \
als Nullstellen einer Gleichung vom Grad 3, zu jeder L\[ODoubleDot]sung f\
\[UDoubleDot]r a zwei Werte f\[UDoubleDot]r b als (bereits explizit \
berechnete) Nullstellen eines Polynoms vom Grad 2 und schlie\[SZ]lich zu \
jedem (a,b) ein aus einer linearen Formel zu berechnender Wert c. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"glsys", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}]], "Input"],

Cell["\<\
Ein nachgeschaltetes Solve liefert eine L\[ODoubleDot]sung in \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"red", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"sum", "/.", "sol"}], "//", "Simplify"}]}], "Input"],

Cell["Das geht dagegen (noch) nicht.", "SmallText"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"sum", ",", "red"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{"glsys", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sum", "/.", "sol"}]}], "Input"],

Cell["\<\
Das sollte so eigentlich gar nicht gehen, denn die angegebene \
L\[ODoubleDot]sung gilt nicht f\[UDoubleDot]r beliebige Werte von (a,b,c), \
sondern nur f\[UDoubleDot]r 6 spezielle Tripel.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"sys", "=", 
  RowBox[{"Append", "[", 
   RowBox[{"glsys", ",", 
    RowBox[{"x", "\[Equal]", "sum"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"sys", ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Union"}]], "Input"],

Cell["\<\
Auch das sollte eine leere L\[ODoubleDot]sungsmenge ergeben.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"Reduce", "[", 
  RowBox[{"sys", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "x"}], "]"}]}], "Input"],

Cell["\<\
Einzig diese (\[ADoubleDot]quivalenten) Kommandos reagieren \"wie es im Buche \
steht\".\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"sys", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Nullstellen z\[ADoubleDot]hlen", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    SuperscriptBox["x", "5"], "-", 
    RowBox[{"5", "x"}], "+", "1"}]}], ";"}], "\n", 
 RowBox[{"CountRoots", "[", 
  RowBox[{"p", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"p", "\[Equal]", "0"}], ",", "x"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"p", ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"p", ",", "Complexes"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    SuperscriptBox["x", "5"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], "x"}], "+", "1"}]}], ";"}], "\n", 
 RowBox[{"CountRoots", "[", 
  RowBox[{"p", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"I", "+", "5"}]}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{
     RowBox[{"p", "\[Equal]", "0"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", "#", "]"}], ",", 
        RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{"x", "/.", "sol"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "LightBlue", ",", "v"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"PointSize", "[", "0.03", "]"}], ",", "u"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ungleichungen und Ungleichungssysteme", "Subsection"],

Cell[TextData[{
 "Die fr\[UDoubleDot]here Verwendung von ",
 StyleBox["InequalitySolve",
  FontWeight->"Bold"],
 " wird in der Version 6 vollst\[ADoubleDot]ndig von der Funktionalit\
\[ADoubleDot]t des Kommandos ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " abgedeckt. Mit algebraischen Ungleichungen und Ungleichungssystemen kommt \
",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " dabei ganz gut zurecht. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", "x"}], ">", "2"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "5"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "-", "y"}], "\[LessEqual]", "1"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", ">", "2"}], "&"}], "/@", "polys"}], " ", ",", "vars"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "-", "2"}], "&"}], "/@", "polys"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gb", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", ">", "2"}], "&"}], "/@", "polys"}], " ", ",", "vars"}], 
  "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "3"], "+", "x"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", ">", "2"}], "&"}], "/@", "polys"}], " ", ",", "vars"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "-", "2"}], "&"}], "/@", "polys"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"gb", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   "Reals"}], "]"}]], "Input"],

Cell[TextData[{
 "Mit trigonometrischen Ungleichungen und anderen komplizierteren Fragen kann \
",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " dagegen oft (noch) nichts anfangen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[GreaterEqual]", 
    FractionBox["1", "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], ">", "0"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], ">", "1"}], ",", "x"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Gleichungen \[UDoubleDot]ber anderen Grundbereichen l\[ODoubleDot]sen\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Gleichungen \[UDoubleDot]ber den reellen Zahlen\
\>", "Subsubsection"],

Cell[TextData[{
 "Nach den Ausf\[UDoubleDot]hrungen im vorigen Punkt ist klar, dass ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " in der Lage ist, die reellen L\[ODoubleDot]sungen von Gleichungen und \
Gleichungssystemen zu finden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "3"], "+", "x"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"gb", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "//.", "sol"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input"],

Cell["Zwei Einheitskreise mit Mittenabstand u schneiden sich. ", "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"x", ",", "y", ",", "u"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "u"}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input"],

Cell["Dasselbe mit variablen Radien.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", 
      SuperscriptBox["r1", "2"]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "u"}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", 
      SuperscriptBox["r2", "2"]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", ">", "0"}], ",", 
       RowBox[{"r1", ">", "0"}], ",", 
       RowBox[{"r2", ">", "0"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", ">", "0"}], ",", 
       RowBox[{"r1", ">", "r2", ">", "0"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "u"}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"18", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"10", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"6", 
     SuperscriptBox["x", "6"]}], "+", 
    SuperscriptBox["x", "8"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "-", 
      RowBox[{"18", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "4"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["#1", "6"]}], "+", 
      SuperscriptBox["#1", "8"]}], "&"}], ",", "2"}], "]"}], "//", 
  "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Reduce", "[", 
       RowBox[{
        RowBox[{"polys", "/.", 
         RowBox[{"u", "->", "i"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
      "ToRules"}], "}"}], "//", "Length"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"polys", "/.", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"-", ".1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "u_", "]"}], ":=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "+", 
        RowBox[{"Sin", "[", "a", "]"}]}], ",", 
       RowBox[{"Cos", "[", "a", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", 
        RowBox[{"-", "0.1"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.2"}], ",", "1.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None"}], 
         "}"}]}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", 
        RowBox[{"-", "0.1"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.97"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.44", ",", "0.47"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.44", ",", "0.45", ",", "0.46", ",", "0.47"}], "}"}], 
          ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", ".98"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", 
        RowBox[{"-", "0.1"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".15"}], ",", 
          RowBox[{"-", "0.05"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".9995", ",", "1.0002"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.9995", ",", "0.9997", ",", "0.9999", ",", "1.0001"}], 
           "}"}], ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".14"}], ",", 
            RowBox[{"-", ".07"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}], "}"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"d", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "->", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"DefaultDuration", "->", "10"}], ",", 
   RowBox[{"AnimationDirection", "->", "ForwardBackward"}]}], "]"}]], "Input"],

Cell["\<\
Noch einmal die Sache mit den Winkelhalbierenden.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"u", ",", "x1", ",", "x2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whpolys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "-", 
      RowBox[{"4", " ", "x1"}], "+", 
      SuperscriptBox["x1", "2"], "-", 
      RowBox[{"8", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x2"}], "+", 
      RowBox[{"4", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
      SuperscriptBox["x2", "2"]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"2", " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x1", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x1", "2"]}], "-", 
      RowBox[{"4", " ", "x2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["u", "2"], " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "3"], " ", "x2"}], "+", 
      RowBox[{"2", " ", "x1", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1", " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x2", "2"]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x2", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whcon", "=", 
   RowBox[{
    SuperscriptBox["x1", "2"], "-", 
    RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"whpolys", "\[Equal]", "0"}], "&&", 
     RowBox[{"u", "<", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"red", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "//",
     "ToRules"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"whcon", "//.", "sol"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"whcon", "//.", "sol"}], ",", 
    RowBox[{"u", "<", "1"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"res", "/.", 
  RowBox[{"u", "\[Rule]", "0.3"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"res", "+", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"whpolys", ",", 
    RowBox[{"{", 
     RowBox[{"x2", ",", "x1"}], "}"}], ",", 
    RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"gb", "\[Equal]", "0"}], "&&", 
     RowBox[{"u", "<", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"red", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "&&",
      
     RowBox[{"red", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
    "//", "ToRules"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"whcon", "//.", "sol"}], "//", "Simplify"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Rationale und ganzzahlige L\[ODoubleDot]sungen\
\>", "Subsubsection"],

Cell[TextData[{
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " findet auch ganzzahlige L\[ODoubleDot]sungen von Gleichungen und \
Gleichungssystemen, hier etwa von linearen diophantischen Gleichungen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}]], "Input",
 CellID->489327928],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "x"}], "+", 
    RowBox[{"3", "y"}]}], ",", "red"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "&&", 
    RowBox[{
     RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "+", 
        RowBox[{"3", "y"}]}], "\[Equal]", "5"}], "&&", 
      RowBox[{
       RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
   "ToRules"}], "}"}]], "Input"],

Cell[TextData[{
 "Der Unterschied zwischen gebundenen und ungebundenen Variablen ist ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " noch nicht sehr gel\[ADoubleDot]ufig. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"6", "x"}], "+", 
      RowBox[{"10", "y"}], "+", 
      RowBox[{"15", "z"}]}], "\[Equal]", "11"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
   "]"}]}]], "Input",
 CellID->1679927154],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"red", "&&", 
   RowBox[{
    RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], "]"}]], "Input",
 CellID->1138987686],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "&&", 
    RowBox[{
     RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", "Integers"}], 
  "]"}]], "Input",
 CellID->1212744502],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"6", "x"}], "+", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"15", "z"}]}], "\[Equal]", "11"}], "&&", 
     RowBox[{
      RowBox[{"-", "3"}], "<", "x", "<", "3"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], "]"}], 
  "\:ffff"}]], "Input",
 CellID->1497086605],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"6", "x"}], "+", 
        RowBox[{"10", "y"}], "+", 
        RowBox[{"15", "z"}]}], "\[Equal]", "11"}], "&&", 
      RowBox[{
       RowBox[{"Abs", "[", "#", "]"}], "<", "10"}]}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"FindInstance", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers", ",", "100"}], 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "//", "Length"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input"],

Cell[TextData[{
 "Noch einfacher ist es in diesem Beispiel mit rationalen \
L\[ODoubleDot]sungen - dazu m\[UDoubleDot]ssen einfach die ",
 StyleBox["Root",
  FontWeight->"Bold"],
 "-Ausdr\[UDoubleDot]cke aussortiert werden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "3"], "+", "x"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{"polys", " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Rationals"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "+", "x", "+", "y", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x", "+", "z", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "+", "z", "-", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"polys", "\[Equal]", "0"}], " ", ",", "vars", ",", "Integers"}], 
    "]"}], ",", "vars"}], "]"}]}], "Input"],

Cell["\<\
Und nun noch einmal unser Beispiel mit den Winkelhalbierenden.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"u", ",", "x1", ",", "x2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whpolys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "-", 
      RowBox[{"4", " ", "x1"}], "+", 
      SuperscriptBox["x1", "2"], "-", 
      RowBox[{"8", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x2"}], "+", 
      RowBox[{"4", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
      SuperscriptBox["x2", "2"]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"2", " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x1", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x1", "2"]}], "-", 
      RowBox[{"4", " ", "x2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["u", "2"], " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "3"], " ", "x2"}], "+", 
      RowBox[{"2", " ", "x1", " ", "x2"}], "+", 
      RowBox[{"4", " ", "u", " ", "x1", " ", "x2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"], " ", "x1", " ", "x2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x2", "2"]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox["x2", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whcon", "=", 
   RowBox[{
    SuperscriptBox["x1", "2"], "-", 
    RowBox[{"2", " ", "u", " ", "x1", " ", "x2"}], "-", 
    SuperscriptBox["x2", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gb", "=", 
   RowBox[{"GroebnerBasis", "[", 
    RowBox[{"whpolys", ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "x1"}], "}"}], ",", 
     RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], "]"}]}],
   ";"}]}], "Input"],

Cell["\<\
Es passiert nix au\[SZ]er Backsubstitution und Erg\[ADoubleDot]nzung einer \
Rationals-Klausel.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"whpolys", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Rationals"}], "]"}]], "Input"],

Cell["Und hier dasselbe.", "SmallText"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gb", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Reals"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gb", "\[Equal]", "0"}], "&&", 
    RowBox[{"u", "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Rationals"}], "]"}]], "Input"],

Cell[TextData[{
 "\[CapitalUDoubleDot]ber den ganzen Zahlen kommt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zu folgenden Ergebnissen. Beachten Sie, dass ",
 StyleBox["whpolys",
  FontWeight->"Bold"],
 " und ",
 StyleBox["gb",
  FontWeight->"Bold"],
 " als Gleichungssysteme nur \[ADoubleDot]quivalent in Q(u)[x1,x2] sind, \
nicht aber f\[UDoubleDot]r konkrete Werte des Parameters u."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"whpolys", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"gb", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"whpolys", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "\[Rule]", "1"}], ",", 
    RowBox[{"x1", "\[Rule]", "1"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"gb", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "\[Rule]", "1"}], ",", 
    RowBox[{"x1", "\[Rule]", "1"}]}], "}"}]}]], "Input"],

Cell["\<\
L\[ODoubleDot]sungen einer Pellschen Gleichung\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "<", "x", "<", "5"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"0", "<", "x", "<", 
     SuperscriptBox["10", "3"]}], "&&", 
    RowBox[{"0", "<", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Gleichungen \[UDoubleDot]ber Restklassenringen\
\>", "Subsubsection"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "\[Equal]", "4"}], ",", 
     RowBox[{"Modulus", "\[Equal]", "12"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "4"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "12"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "3"}], ",", "x", ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"primeList", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"5", ",", "50"}], "]"}], ",", "PrimeQ"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"Reduce", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "\[Equal]", "3"}], ",", "x", ",", 
        RowBox[{"Modulus", "->", "#"}]}], "]"}]}], "}"}], "&"}], "/@", 
   "primeList"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"3", ",", "2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"primeList", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"JacobiSymbol", "[", 
      RowBox[{"3", ",", "#"}], "]"}], "\[Equal]", "1"}], "&"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", 
    SuperscriptBox["x", "4"], "\[Equal]", "4"}], ",", "x", ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "+", "x", "+", "y", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x", "+", "z", "-", "3"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y", "+", "z", "-", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", "vars"}], "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", "23"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"polys", "\[Equal]", "0"}], ",", 
      RowBox[{"Modulus", "\[Equal]", "p"}]}], "}"}], ",", "vars"}], 
   "]"}]}], "\n", 
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"polys", "/.", "sol"}], ",", "p"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], ",", "vars", ",", 
    RowBox[{"Modulus", "\[Rule]", "p"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{"red", "//", "ToRules"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"polys", "/.", "sol"}], ",", "p"}], "]"}]}], "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Differenzialgleichungen", "Section"],

Cell[CellGroupData[{

Cell["DSolve: y versus y[x]", "Subsection"],

Cell["\<\
Differentialgleichungen k\[ODoubleDot]nnen mit y[x] oder y als zweitem \
Parameter angeschrieben werden. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "1"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}]], "Input"],

Cell["\<\
Die zweite Form ist f\[UDoubleDot]r die weitere Verarbeitung besser geeignet.\
\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "sol1"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "sol2"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", 
   RowBox[{"t", "-", "2"}], "]"}], "/.", "sol2"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Zwei Beispiele", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Beispiel 1: Freier Fall",
 FontWeight->"Bold"]], "Subsubsection"],

Cell["\<\
Freier Fall aus 10 m H\[ODoubleDot]he mit Anfangsgeschwindigkeit 0 m/s.

Der Ansatz\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dgl", "=", 
   RowBox[{
    RowBox[{"m", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "'"}], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", "m"}], " ", "g"}]}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dgl", ",", 
      RowBox[{
       RowBox[{"z", "[", "0", "]"}], "\[Equal]", "10"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "z", ",", "t"}], "]"}]}]], "Input",
 PageWidth->Infinity],

Cell["Die L\[ODoubleDot]sungsfunktion z=z[t]", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "t", "]"}], " ", "/.", " ", "lsg"}]], "Input"],

Cell["\<\
Die Geschwindigkeit w\[ADoubleDot]chst linear.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"z", "'"}], "[", "t", "]"}], " ", "/.", " ", "lsg"}]], "Input"],

Cell["Die Probe", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"dgl", ",", 
    RowBox[{"z", "[", "0", "]"}], ",", " ", 
    RowBox[{
     RowBox[{"z", "'"}], "[", "0", "]"}]}], "}"}], " ", "/.", " ", 
  "lsg"}]], "Input"],

Cell["Bestimmung des Aufschlagzeitpunkts", "SmallText"],

Cell[BoxData[
 RowBox[{"tlsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", "[", "t", "]"}], "\[Equal]", "0"}], "/.", "lsg"}], ",", 
    "t"}], "]"}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"t0", "=", 
  RowBox[{
   RowBox[{"t", "/.", 
    RowBox[{"tlsg", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "/.", 
   RowBox[{"g", "\[Rule]", "9.81"}]}]}]], "Input",
 PageWidth->Infinity],

Cell["Die Kurve des raum-zeitlichen Verlaufs des Experiments", "SmallText"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", "[", "t", "]"}], "/.", "lsg"}], "/.", 
    RowBox[{"g", "\[Rule]", "9.81"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "t0"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Beispiel 2: Ged\[ADoubleDot]mpfte Schwingung",
 FontWeight->"Bold"]], "Subsubsection"],

Cell["\<\
m\tMasse
c\tFederkonstante
k\tReibungskoeffizient\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", "1"}], ";", " ", 
  RowBox[{"c", "=", "1"}], ";", " ", 
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"lsg", "=", 
  RowBox[{"DSolve", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"m", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"y", "'"}], "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"k", " ", 
         RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", "\n", 
      "\t\t", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    " ", "y", ",", "t"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], " ", "/.", " ", "lsg"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Randbedingungen und Integrationskonstanten", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "1"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "&&", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "2"}]}], ",", "y", ",", "x"}],
    "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", "U"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "C", "}"}], ",", "C"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "->", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "3"}], ",", "5", ",", ".7"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"Axes", "->", "None"}]}], "]"}]}], "Input"],

Cell["\<\
Verwechseln Sie in der Notation nicht = (Set) und \[Equal] (Equal). Bei \
Funktionsausdr\[UDoubleDot]cken ist das besonders l\[ADoubleDot]stig.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "=", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[TextData[{
 "Einfaches Korrigieren der Eingabe hilft nicht, da  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]],
  CellChangeTimes->{3.36430942397709*^9}],
 " ja nun durch 0 ersetzt wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Unset",
  FontWeight->"Bold"],
 " l\[ODoubleDot]scht die Zuweisung."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Unset", "[", 
  RowBox[{
   RowBox[{"y", "'"}], "[", "1", "]"}], "]"}], "\n", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"4", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["DSolve im Einsatz", "Subsection"],

Cell["\<\
Eine Testfunktion zum Ausgeben und Pr\[UDoubleDot]fen des Ergebnisses, mal \
als CompoundExpression.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "[", "eqn_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"DSolve", "[", 
       RowBox[{"eqn", ",", "y", ",", "x"}], "]"}], "//", "Simplify"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "//", "Simplify"}]}], 
   ")"}]}]], "Input"],

Cell["Lineare homogene DGl. mit konstanten Koeffizienten", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}], "-", 
     RowBox[{"7", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"6", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input"],

Cell["\<\
\[CapitalADoubleDot]hnliche Gleichung, aber mit einem St\[ODoubleDot]rterm\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{"3", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    SuperscriptBox["E", "x"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell["\<\
Lineare DGl. erster Ordnung mit nichtkonstanten Koeffizienten\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"4", " ", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 StyleBox["Bernoullische DGL",
  FontWeight->"Bold"],
 ": Das sind DGL der Form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]"], "[", "x", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "x", "]"}], " ", 
     RowBox[{"y", "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"B", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "a"]}]}]}]]],
 ", die mit der Substitution ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SuperscriptBox["y", 
     RowBox[{"1", "-", "a"}]]}], TraditionalForm]]],
 "in eine lineare DGL \[UDoubleDot]berf\[UDoubleDot]hrt werden \
k\[ODoubleDot]nnen."
}], "SmallText",
 Evaluatable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "x"}], "-", "1"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"y", "[", "x", "]"}], "3"]}]}], ")"}]}]}], "\[Equal]", 
    "0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 StyleBox["Riccatische DGL",
  FontWeight->"Bold"],
 ": Das sind DGL der Form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]"], "[", "x", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "x", "]"}], " ", 
     RowBox[{"y", "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"B", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}], "+", 
    RowBox[{"C", "[", "y", "]"}]}]}]]],
 ". \nIst eine spezielle L\[ODoubleDot]sung bekannt, so kann eine solche \
Gleichung in eine lineare DGL \[UDoubleDot]berf\[UDoubleDot]hrt werden. "
}], "SmallText",
 Evaluatable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}], "+", 
     SuperscriptBox["x", "2"], "+", "x", "+", "1"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input"],

Cell["\<\
Dabei k\[ODoubleDot]nnen sich Integrale ergeben, die keine elementaren \
Stammfunktionen haben.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}], "+", 
     SuperscriptBox["x", "2"], "+", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input"],

Cell["\<\
Und hier noch ein Bild verschiedener dieser L\[ODoubleDot]sungstrajektorien:\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "Input"],

Cell[TextData[{
 "Auch wesentlich nichtlineare Gleichungen wie dieser hier, wo y' im Quadrat \
vorkommt, kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " l\[ODoubleDot]sen. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "2"], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     FractionBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 "Am Bild der L\[ODoubleDot]sungsschar erkennen wir, dass es eine Einh\
\[UDoubleDot]llende gibt, die ebenfalls L\[ODoubleDot]sung der Gleichung ",
 StyleBox["eqn",
  FontWeight->"Bold"],
 " ist."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "100"}]}], "}"}]}]}], "]"}]}], "Input"],

Cell[TextData[{
 "Da es sich offensichtlich um eine Parabel handelt, k\[ODoubleDot]nnen wir \
die entsprechende L\[ODoubleDot]sung durch einen Ansatz ",
 Cell[BoxData[
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "2"], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{
     SubscriptBox["a", "1"], "x"}], "+", 
    SubscriptBox["a", "0"]}]}]], "Input",
  CellChangeTimes->{{3.36594277260371*^9, 3.36594285897091*^9}}],
 " mit unbestimmten Koeffizienten finden. Die Zusatzbedingung ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["a", "2"], "\[NotEqual]", "0"}]],
  CellChangeTimes->{{3.36594283251054*^9, 3.36594292667731*^9}}],
 " schlie\[SZ]t uninteressante L\[ODoubleDot]sungen aus."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "2"], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{
     SubscriptBox["a", "1"], "x"}], "+", 
    SubscriptBox["a", "0"]}]}], ";"}], "\n", 
 RowBox[{"sys", "=", 
  RowBox[{
   RowBox[{"First", "[", "eqn", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{"f", ",", "x"}], "]"}]}]}], "}"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{"sys", ",", "x"}], "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     SubscriptBox["a", "2"], "\[NotEqual]", " ", "0"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "/.", "sol"}]], "Input"],

Cell["\<\
Aber selbst bei Angabe der entsprechenden Anfangsbedingung wird diese \
spezielle L\[ODoubleDot]sung nicht gefunden. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell["\<\
Dasselbe gilt f\[UDoubleDot]r dieses Beispiel, wo Einh\[UDoubleDot]llende \
sogar die konstanten Funktionen y[x]=\[PlusMinus]1 sind.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], "-", "1"}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{"eqn", ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
   "Simplify"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "&&", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{
       "sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "/.", 
      
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
       RowBox[{"\[ImaginaryI]", " ", "i"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "7", ",", ".5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["DSolve und InverseFunction", "Subsection"],

Cell[TextData[{
 "Die Funktion ",
 StyleBox["test",
  FontWeight->"Bold"],
 " aus dem vorherigen Abschnitt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "[", "eqn_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"DSolve", "[", 
       RowBox[{"eqn", ",", "y", ",", "x"}], "]"}], "//", "Simplify"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "//", "Simplify"}]}], 
   ")"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", "x"}], ")"}]}], "+", 
     SuperscriptBox["x", "2"], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"y", "[", "x", "]"}], "2"], " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{"test", "[", "eqn", "]"}], "//", "Simplify"}]}]}], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 "Sieht ganz nett aus; leider lassen sich von dieser ",
 StyleBox["InverseFunction",
  FontWeight->"Bold"],
 " keine numerischen Approximationen berechnen. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "0"], TraditionalForm]]],
 " ist die allgemeine L\[ODoubleDot]sung von eqn als Funktion mit \
symbolischem Parameter C[1]"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y0", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"First", "[", "sol", "]"}]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"y0", "[", "1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y1", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"y0", "[", "x", "]"}], "/.", 
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], "\[Rule]", "0"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"y1", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1.1", ",", "3", ",", "0.3"}], "}"}]}], "]"}], "//", 
  "N"}]], "Input"],

Cell["\<\
Auch L\[ODoubleDot]sungen mit konkreten Anfangswert y[0]=4 werden nicht \
gefunden, ...\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"eqn", "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "4"}]}], ",", "y", ",", "x"}], 
  "]"}]], "Input"],

Cell[TextData[{
 "... obwohl es solche Funktionen in der L\[ODoubleDot]sungsschar ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "0"], TraditionalForm]]],
 "gibt:"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{"y0", "[", "0", "]"}]}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"u", "\[Equal]", "4"}], ",", 
   RowBox[{"C", "[", "1", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"u", "\[Equal]", "4"}], ",", 
   RowBox[{"C", "[", "1", "]"}]}], "]"}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"u", "\[LeftDoubleBracket]", 
      RowBox[{"0", ",", "1"}], "\[RightDoubleBracket]"}], "[", "4", "]"}], 
    "\[Equal]", 
    RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
   ",", 
   RowBox[{"C", "[", "1", "]"}]}], "]"}]}], "Input"],

Cell[TextData[{
 "Hinter der Formel f\[UDoubleDot]r ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "0"], "[", "x", "]"}], TraditionalForm]]],
 " verbirgt sich eigentlich die implizite L\[ODoubleDot]sung ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"y", "+", "1"}], "]"}], "-", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"1", "+", "y"}], ")"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "y"}], ")"}], "2"], "2"]}], "\[Equal]", 
    RowBox[{
     FractionBox["3", "2"], "-", "x", "-", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "-", "C"}]}], TraditionalForm]]],
 ".\nDie l\[ADoubleDot]sst sich mit einigen Verrenkungen aus der Standardl\
\[ODoubleDot]sung extrahieren:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"y0", "[", "x", "]"}]}], ";", 
  RowBox[{"sol1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"u", "\[LeftDoubleBracket]", 
       RowBox[{"0", ",", "1"}], "\[RightDoubleBracket]"}], "[", 
      RowBox[{"y", "[", "x", "]"}], "]"}], "\[Equal]", 
     RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "//",
     "Expand"}]}]}]], "Input"],

Cell["\<\
Hier so etwas wie eine Probe. Ableiten f\[UDoubleDot]hrt auf die Ausgangs-DGL \
zur\[UDoubleDot]ck.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"sol1", ",", "x"}], "]"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"sol1", ",", "x"}], "]"}], ",", 
   RowBox[{
    RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{
    RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["InverseFunction",
  FontWeight->"Bold"],
 " wird allerdings nicht in allen F\[ADoubleDot]llen eingesetzt, wo dies m\
\[ODoubleDot]glich w\[ADoubleDot]re. Bei der folgenden  Dgl. etwa wird die L\
\[ODoubleDot]sung trotz separierter Variablen gleich als ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Ausdruck zur\[UDoubleDot]ckgegeben."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    FractionBox[
     RowBox[{"y", "[", "x", "]"}], 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], 
       RowBox[{"Log", "[", 
        RowBox[{"y", "[", "x", "]"}], "]"}]}], "+", "x"}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Systeme von Differentialgleichungen", "Subsection"],

Cell["\<\
DGL-System, das die Bewegung eines K\[ODoubleDot]rpers auf einer Kreisbahn \
beschreibt. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"y", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"-", 
        RowBox[{"x", "[", "t", "]"}]}]}], ",", "\n", "\t\t", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "1", "]"}], "\[Equal]", "2"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 "Anlegen eines Vektors ",
 StyleBox["r",
  FontSlant->"Italic"],
 " mit den Koordinaten des Punkts in Abh\[ADoubleDot]ngigkeit von ",
 StyleBox["t",
  FontSlant->"Italic"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
    RowBox[{"sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "//",
    "Simplify"}]}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"r", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 "Dieses System schafft ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 zwar, aber das Ergebnis in seiner symbolischen Form n\[UDoubleDot]tzt \
nur Spezialisten, die etwas von Jacobi-Funktionen verstehen. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{"3", 
      RowBox[{"y", "[", "t", "]"}], 
      RowBox[{"z", "[", "t", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{"3", 
      RowBox[{"x", "[", "t", "]"}], 
      RowBox[{"z", "[", "t", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "[", "t", "]"}]}], 
      RowBox[{"y", "[", "t", "]"}]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "t"}], "]"}]}]], "Input"],

Cell[TextData[{
 "Aber dieses Ergebnis kann weiter numerisch oder grafisch ausgewertet \
werden.\n\nDer Plot verschiedener Bahnkurven kann wieder mit ",
 StyleBox["ParametricPlot3D",
  FontWeight->"Bold"],
 " erfolgen, was einige Geduld abverlangt. \n\nStattdessen wollen wir einen \
anderen Weg gehen und erzeugen uns selbst eine solche Graphik aus \
Grafikprimitiven. \n\nDazu definieren wir zun\[ADoubleDot]chst eine Funktion \
r[t,a], welche f\[UDoubleDot]r verschiedene ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]],
  CellChangeTimes->{{3.36440046146935*^9, 3.3644005046005*^9}, {
   3.36440053528204*^9, 3.36440062096882*^9}, {3.36440066978207*^9, 
   3.36440067502559*^9}, {3.36440080092545*^9, 3.36440080645362*^9}, {
   3.36440084608301*^9, 3.36440088670189*^9}, {3.36440093812119*^9, 
   3.36440094400604*^9}}],
 " die Punkte auf der jeweiligen Bahnkurve mit dem Parameter (",
 Cell[BoxData[
  SuperscriptBox["a", "2"]],
  CellChangeTimes->{{3.36440046146935*^9, 3.3644005046005*^9}, {
   3.36440053528204*^9, 3.36440062096882*^9}, {3.36440066978207*^9, 
   3.36440067502559*^9}, {3.36440080092545*^9, 3.36440080645362*^9}, {
   3.36440084608301*^9, 3.36440088670189*^9}, {3.36440093812119*^9, 
   3.36440094400604*^9}}],
 ",",
 Cell[BoxData[
  SuperscriptBox["a", "2"]],
  CellChangeTimes->{{3.36440046146935*^9, 3.3644005046005*^9}, {
   3.36440053528204*^9, 3.36440062096882*^9}, {3.36440066978207*^9, 
   3.36440067502559*^9}, {3.36440080092545*^9, 3.36440080645362*^9}, {
   3.36440084608301*^9, 3.36440088670189*^9}, {3.36440093812119*^9, 
   3.36440094400604*^9}}],
 ",",
 Cell[BoxData[
  SuperscriptBox["a", "2"]],
  CellChangeTimes->{{3.36440046146935*^9, 3.3644005046005*^9}, {
   3.36440053528204*^9, 3.36440062096882*^9}, {3.36440066978207*^9, 
   3.36440067502559*^9}, {3.36440080092545*^9, 3.36440080645362*^9}, {
   3.36440084608301*^9, 3.36440088670189*^9}, {3.36440093812119*^9, 
   3.36440094400604*^9}}],
 ") berechnet."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"t_", ",", "a_"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}], ",", 
        RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
      RowBox[{"sol", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
      "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
        SuperscriptBox["a", "2"]}], ",", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], "\[Rule]", 
        SuperscriptBox["a", "2"]}], ",", 
       RowBox[{
        RowBox[{"C", "[", "3", "]"}], "\[Rule]", 
        SuperscriptBox["a", "2"]}]}], "}"}]}], ",", 
    RowBox[{"a", ">", "0"}]}], "]"}]}]], "Input"],

Cell["\<\
Als n\[ADoubleDot]chstes compilieren wir diese Funktion, um sie schneller \
numerisch auswerten zu k\[ODoubleDot]nnen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"Compile", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", "a"}], "}"}], ",", 
    RowBox[{
     RowBox[{"r", "[", 
      RowBox[{"t", ",", "a"}], "]"}], "//", "Evaluate"}]}], "]"}]}]], "Input",\

 PageWidth->Infinity],

Cell[TextData[{
 "Und nun erzeugen wir daraus eine Liste von Listen f\[UDoubleDot]r \
verschiedene positive Werte des Bahnparameters ",
 StyleBox["a",
  FontSlant->"Italic"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"r1", "[", 
       RowBox[{"t", ",", "a"}], "]"}], "//", "Chop"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", "2", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2", ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 PageWidth->Infinity],

Cell[TextData[{
 "Die Punkte jeder Liste werden dem Grafikprimitiv ",
 StyleBox["Line",
  FontWeight->"Bold"],
 " \[UDoubleDot]bergeben, welches den Linienzug erzeugt, welcher diese Punkte \
verbindet. Wir erkennen im folgenden Bild die sechs zugeh\[ODoubleDot]rigen \
Bahnkurven."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Line", "[", "#", "]"}], "&"}], "/@", "pts"}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell["\<\
Diese Bahnkurven werden allerdings mehrfach und mit unterschiedlicher \
Geschwindigkeit durchlaufen.

Mit etwas mehr M\[UDoubleDot]he und Liebe zum Detail l\[ADoubleDot]sst sich \
das in einer Animation darstellen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Hue", "[", 
             RowBox[{
              RowBox[{"2", "u"}], "-", "0.35"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Point", "[", 
              RowBox[{"r1", "[", 
               RowBox[{"t", ",", "u"}], "]"}], "]"}], "//", "Chop"}]}], "}"}],
           ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "0.2", ",", "0.7", ",", "0.1"}], "}"}]}], 
         "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "15", ",", ".01"}], "}"}], ",", 
   RowBox[{"DefaultDuration", "\[Rule]", "100"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Beispiele", "Subsection"],

Cell[CellGroupData[{

Cell["Lineare homogene Differentialgleichungen", "Subsubsection",
 Evaluatable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "4"], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"y", "[", "x", "]"}]}], "8"]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''''"}], "[", "x", "]"}], "-", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity]
}, Closed]],

Cell[CellGroupData[{

Cell["Lineare inhomogene Differentialgleichungen", "Subsubsection",
 Evaluatable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "x"}], 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     RowBox[{
      FractionBox["2", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "1"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"First", "[", "sol", "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "->", 
         RowBox[{"10", "i"}]}], ",", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "->", 
         RowBox[{"10", "j"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"m", " ", "x"}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"m", " ", "x"}], "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"test", "[", "eqn", "]"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"y0", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", 
   RowBox[{"First", "[", "sol", "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigExpand", "[", "y0", "]"}]], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"m", " ", "x"}], "]"}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"m", " ", "x"}], "]"}]}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{679, 775},
WindowMargins->{{Automatic, 85}, {1, Automatic}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 46, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[661, 27, 35, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[721, 31, 66, 2, 45, "Subsection"],
Cell[790, 35, 76, 1, 28, "Input"],
Cell[869, 38, 169, 3, 59, "SmallText"],
Cell[1041, 43, 168, 5, 30, "Input"],
Cell[1212, 50, 310, 11, 28, "Input"],
Cell[1525, 63, 355, 6, 76, "SmallText"],
Cell[1883, 71, 214, 8, 30, "Input"],
Cell[2100, 81, 214, 8, 30, "Input"],
Cell[2317, 91, 497, 9, 93, "SmallText"],
Cell[2817, 102, 163, 5, 30, "Input"],
Cell[2983, 109, 239, 8, 30, "Input"],
Cell[3225, 119, 239, 8, 30, "Input"],
Cell[3467, 129, 939, 22, 161, "SmallText"],
Cell[4409, 153, 166, 6, 44, "Input"],
Cell[4578, 161, 649, 15, 93, "SmallText"],
Cell[5230, 178, 195, 7, 44, "Input"],
Cell[5428, 187, 81, 2, 44, "Input"],
Cell[5512, 191, 222, 7, 44, "Input"],
Cell[5737, 200, 372, 10, 59, "SmallText"],
Cell[6112, 212, 264, 9, 44, "Input"],
Cell[6379, 223, 372, 12, 65, "Input"],
Cell[6754, 237, 336, 8, 76, "SmallText"],
Cell[7093, 247, 414, 14, 68, "Input"],
Cell[7510, 263, 192, 6, 44, "Input"],
Cell[7705, 271, 420, 14, 44, "Input"],
Cell[8128, 287, 85, 2, 44, "Input"],
Cell[8216, 291, 189, 5, 44, "Input"],
Cell[8408, 298, 442, 21, 67, "Input"],
Cell[8853, 321, 193, 6, 42, "SmallText"],
Cell[9049, 329, 235, 6, 65, "Input"],
Cell[9287, 337, 247, 4, 59, "SmallText"],
Cell[9537, 343, 109, 3, 44, "Input"],
Cell[9649, 348, 136, 5, 44, "Input"],
Cell[9788, 355, 193, 7, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[10018, 367, 48, 0, 29, "Subsection"],
Cell[10069, 369, 76, 1, 28, "Input"],
Cell[10148, 372, 585, 12, 93, "SmallText"],
Cell[10736, 386, 167, 5, 42, "Input"],
Cell[10906, 393, 224, 8, 42, "SmallText"],
Cell[11133, 403, 197, 6, 42, "Input"],
Cell[11333, 411, 156, 5, 42, "SmallText"],
Cell[11492, 418, 286, 10, 42, "Input"],
Cell[11781, 430, 81, 2, 28, "Input"],
Cell[11865, 434, 251, 8, 42, "Input"],
Cell[12119, 444, 196, 7, 28, "Input"],
Cell[12318, 453, 103, 3, 28, "Input"],
Cell[12424, 458, 51, 1, 28, "Input"],
Cell[12478, 461, 56, 0, 42, "SmallText"],
Cell[12537, 463, 76, 1, 44, "Input"],
Cell[12616, 466, 213, 7, 46, "Input"],
Cell[12832, 475, 182, 4, 65, "Input"],
Cell[13017, 481, 197, 7, 46, "Input"],
Cell[13217, 490, 237, 7, 44, "Input"],
Cell[13457, 499, 214, 7, 46, "Input"],
Cell[13674, 508, 317, 10, 46, "Input"],
Cell[13994, 520, 129, 3, 44, "Input"],
Cell[14126, 525, 156, 4, 44, "Input"],
Cell[14285, 531, 289, 7, 59, "SmallText"],
Cell[14577, 540, 271, 9, 64, "Input"],
Cell[14851, 551, 144, 5, 42, "SmallText"],
Cell[14998, 558, 109, 3, 44, "Input"],
Cell[15110, 563, 263, 6, 59, "SmallText"],
Cell[15376, 571, 83, 2, 44, "Input"],
Cell[15462, 575, 247, 8, 44, "Input"],
Cell[15712, 585, 438, 10, 76, "SmallText"],
Cell[16153, 597, 149, 3, 65, "Input"],
Cell[16305, 602, 89, 2, 44, "Input"],
Cell[16397, 606, 295, 8, 65, "Input"],
Cell[16695, 616, 588, 14, 76, "SmallText"],
Cell[17286, 632, 548, 17, 113, "Input"],
Cell[17837, 651, 166, 4, 59, "SmallText"],
Cell[18006, 657, 224, 9, 52, "Input"],
Cell[18233, 668, 129, 3, 42, "SmallText"],
Cell[18365, 673, 435, 14, 46, "Input"],
Cell[18803, 689, 126, 5, 42, "SmallText"],
Cell[18932, 696, 513, 16, 68, "Input"],
Cell[19448, 714, 43, 0, 42, "SmallText"],
Cell[19494, 716, 283, 10, 44, "Input"],
Cell[19780, 728, 50, 1, 44, "Input"],
Cell[19833, 731, 129, 3, 42, "SmallText"],
Cell[19965, 736, 269, 9, 62, "Input"],
Cell[20237, 747, 176, 5, 42, "SmallText"],
Cell[20416, 754, 299, 11, 52, "Input"],
Cell[20718, 767, 300, 11, 52, "Input"],
Cell[21021, 780, 316, 11, 52, "Input"],
Cell[21340, 793, 348, 12, 52, "Input"],
Cell[21691, 807, 168, 6, 44, "Input"],
Cell[21862, 815, 50, 1, 44, "Input"],
Cell[21915, 818, 113, 3, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22077, 827, 57, 0, 35, "Section"],
Cell[22137, 829, 76, 1, 28, "Input"],
Cell[22216, 832, 213, 4, 59, "SmallText"],
Cell[22432, 838, 494, 18, 52, "Input"],
Cell[22929, 858, 57, 0, 42, "SmallText"],
Cell[22989, 860, 99, 3, 28, "Input"],
Cell[23091, 865, 84, 2, 42, "SmallText"],
Cell[23178, 869, 183, 5, 52, "Input"],
Cell[23364, 876, 30, 0, 42, "SmallText"],
Cell[23397, 878, 54, 1, 28, "Input"],
Cell[23454, 881, 55, 1, 28, "Input"],
Cell[23512, 884, 106, 3, 28, "Input"],
Cell[23621, 889, 55, 1, 28, "Input"],
Cell[23679, 892, 77, 2, 42, "SmallText"],
Cell[23759, 896, 345, 11, 28, "Input"],
Cell[24107, 909, 89, 2, 42, "SmallText"],
Cell[24199, 913, 257, 9, 46, "Input"],
Cell[24459, 924, 430, 13, 44, "Input"],
Cell[24892, 939, 678, 21, 95, "SmallText"],
Cell[25573, 962, 287, 9, 46, "Input"],
Cell[25863, 973, 186, 6, 44, "Input"],
Cell[26052, 981, 159, 5, 44, "Input"],
Cell[26214, 988, 330, 10, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26581, 1003, 44, 0, 35, "Section"],
Cell[26628, 1005, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[26729, 1010, 39, 0, 45, "Subsection"],
Cell[26771, 1012, 208, 7, 30, "Input"],
Cell[26982, 1021, 127, 6, 42, "SmallText"],
Cell[27112, 1029, 178, 6, 30, "Input"],
Cell[27293, 1037, 79, 2, 28, "Input"],
Cell[27375, 1041, 79, 2, 42, "SmallText"],
Cell[27457, 1045, 80, 2, 28, "Input"],
Cell[27540, 1049, 190, 6, 30, "Input"],
Cell[27733, 1057, 136, 4, 28, "Input"],
Cell[27872, 1063, 231, 8, 30, "Input"],
Cell[28106, 1073, 86, 2, 42, "SmallText"],
Cell[28195, 1077, 234, 8, 30, "Input"],
Cell[28432, 1087, 79, 2, 28, "Input"],
Cell[28514, 1091, 59, 1, 28, "Input"],
Cell[28576, 1094, 373, 12, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28986, 1111, 54, 0, 29, "Subsection"],
Cell[29043, 1113, 72, 1, 42, "SmallText"],
Cell[29118, 1116, 108, 4, 32, "Input"],
Cell[29229, 1122, 133, 5, 36, "Input"],
Cell[29365, 1129, 59, 1, 28, "Input"],
Cell[29427, 1132, 232, 10, 36, "Input"],
Cell[29662, 1144, 59, 1, 28, "Input"],
Cell[29724, 1147, 236, 10, 36, "Input"],
Cell[29963, 1159, 280, 11, 59, "SmallText"],
Cell[30246, 1172, 507, 17, 52, "Input"],
Cell[30756, 1191, 128, 4, 28, "Input"],
Cell[30887, 1197, 176, 6, 45, "Input"],
Cell[31066, 1205, 224, 8, 59, "Input"],
Cell[31293, 1215, 47, 0, 42, "SmallText"],
Cell[31343, 1217, 134, 5, 64, "Input"],
Cell[31480, 1224, 380, 11, 127, "Input"],
Cell[31863, 1237, 128, 3, 44, "Input"],
Cell[31994, 1242, 182, 7, 64, "Input"],
Cell[32179, 1251, 158, 5, 44, "Input"],
Cell[32340, 1258, 78, 2, 42, "SmallText"],
Cell[32421, 1262, 66, 1, 44, "Input"],
Cell[32490, 1265, 207, 8, 44, "SmallText"],
Cell[32700, 1275, 600, 25, 48, "Input"],
Cell[33303, 1302, 243, 9, 52, "Input"],
Cell[33549, 1313, 188, 7, 52, "Input"],
Cell[33740, 1322, 117, 3, 42, "SmallText"],
Cell[33860, 1327, 264, 9, 52, "Input"],
Cell[34127, 1338, 121, 3, 44, "Input"],
Cell[34251, 1343, 183, 5, 44, "Input"],
Cell[34437, 1350, 57, 1, 44, "Input"],
Cell[34497, 1353, 117, 3, 44, "Input"],
Cell[34617, 1358, 69, 1, 42, "SmallText"],
Cell[34689, 1361, 208, 7, 46, "Input"],
Cell[34900, 1370, 254, 8, 46, "Input"],
Cell[35157, 1380, 194, 7, 58, "Input"],
Cell[35354, 1389, 234, 8, 58, "Input"],
Cell[35591, 1399, 327, 11, 59, "Input"],
Cell[35921, 1412, 217, 7, 46, "Input"],
Cell[36141, 1421, 55, 1, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[36233, 1427, 57, 0, 29, "Subsection"],
Cell[CellGroupData[{
Cell[36315, 1431, 49, 0, 41, "Subsubsection"],
Cell[36367, 1433, 332, 11, 52, "Input"],
Cell[36702, 1446, 314, 7, 76, "SmallText"],
Cell[37019, 1455, 139, 4, 28, "Input"],
Cell[37161, 1461, 100, 3, 28, "Input"],
Cell[37264, 1466, 148, 4, 28, "Input"],
Cell[37415, 1472, 395, 9, 76, "SmallText"],
Cell[37813, 1483, 90, 2, 28, "Input"],
Cell[37906, 1487, 254, 8, 59, "SmallText"],
Cell[38163, 1497, 205, 7, 44, "Input"],
Cell[38371, 1506, 53, 1, 44, "Input"],
Cell[38427, 1509, 108, 3, 44, "Input"],
Cell[38538, 1514, 177, 3, 59, "SmallText"],
Cell[38718, 1519, 188, 6, 44, "Input"],
Cell[38909, 1527, 57, 1, 44, "Input"],
Cell[38969, 1530, 271, 7, 44, "SmallText"],
Cell[39243, 1539, 202, 7, 58, "Input"],
Cell[39448, 1548, 123, 4, 46, "Input"],
Cell[39574, 1554, 55, 1, 44, "Input"],
Cell[39632, 1557, 58, 0, 42, "SmallText"],
Cell[39693, 1559, 192, 7, 44, "Input"],
Cell[39888, 1568, 59, 1, 44, "Input"],
Cell[39950, 1571, 135, 5, 42, "SmallText"],
Cell[40088, 1578, 192, 7, 44, "Input"],
Cell[40283, 1587, 57, 1, 44, "Input"],
Cell[40343, 1590, 324, 9, 59, "SmallText"],
Cell[40670, 1601, 176, 5, 59, "Input"],
Cell[40849, 1608, 110, 3, 44, "Input"],
Cell[40962, 1613, 183, 6, 59, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[41182, 1624, 48, 0, 27, "Subsubsection"],
Cell[41233, 1626, 391, 13, 52, "Input"],
Cell[41627, 1641, 109, 3, 42, "SmallText"],
Cell[41739, 1646, 139, 4, 28, "Input"],
Cell[41881, 1652, 59, 1, 28, "Input"],
Cell[41943, 1655, 326, 9, 59, "SmallText"],
Cell[42272, 1666, 52, 1, 28, "Input"],
Cell[42327, 1669, 167, 5, 28, "Input"],
Cell[42497, 1676, 152, 5, 42, "SmallText"],
Cell[42652, 1683, 100, 2, 28, "Input"],
Cell[42755, 1687, 53, 1, 44, "Input"],
Cell[42811, 1690, 317, 9, 59, "SmallText"],
Cell[43131, 1701, 205, 7, 44, "Input"],
Cell[43339, 1710, 53, 1, 44, "Input"],
Cell[43395, 1713, 94, 2, 44, "Input"],
Cell[43492, 1717, 244, 6, 59, "SmallText"],
Cell[43739, 1725, 188, 6, 44, "Input"],
Cell[43930, 1733, 81, 2, 44, "Input"],
Cell[44014, 1737, 78, 2, 44, "Input"],
Cell[44095, 1741, 62, 1, 44, "Input"],
Cell[44160, 1744, 218, 8, 42, "SmallText"],
Cell[44381, 1754, 192, 7, 44, "Input"],
Cell[44576, 1763, 81, 2, 44, "Input"],
Cell[44660, 1767, 161, 5, 42, "SmallText"],
Cell[44824, 1774, 222, 8, 44, "Input"],
Cell[45049, 1784, 57, 1, 44, "Input"],
Cell[45109, 1787, 290, 9, 59, "SmallText"],
Cell[45402, 1798, 246, 8, 44, "Input"],
Cell[45651, 1808, 243, 8, 44, "Input"],
Cell[45897, 1818, 290, 10, 62, "Input"],
Cell[46190, 1830, 717, 22, 93, "SmallText"],
Cell[46910, 1854, 348, 11, 84, "Input"],
Cell[47261, 1867, 404, 13, 84, "Input"],
Cell[47668, 1882, 122, 2, 65, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[47851, 1891, 48, 0, 35, "Section"],
Cell[47902, 1893, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[48003, 1898, 59, 0, 45, "Subsection"],
Cell[48065, 1900, 303, 7, 59, "SmallText"],
Cell[48371, 1909, 642, 20, 72, "Input"],
Cell[49016, 1931, 52, 1, 28, "Input"],
Cell[49071, 1934, 59, 1, 28, "Input"],
Cell[49133, 1937, 63, 1, 28, "Input"],
Cell[49199, 1940, 450, 13, 76, "SmallText"],
Cell[49652, 1955, 148, 4, 28, "Input"],
Cell[49803, 1961, 65, 1, 28, "Input"],
Cell[49871, 1964, 369, 11, 76, "SmallText"],
Cell[50243, 1977, 87, 2, 44, "Input"],
Cell[50333, 1981, 103, 2, 42, "SmallText"],
Cell[50439, 1985, 201, 6, 44, "Input"],
Cell[50643, 1993, 221, 5, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[50901, 2003, 133, 4, 29, "Subsection"],
Cell[51037, 2009, 815, 28, 92, "Input"],
Cell[51855, 2039, 54, 1, 28, "Input"],
Cell[51912, 2042, 192, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[52141, 2053, 40, 0, 29, "Subsection"],
Cell[52184, 2055, 880, 26, 69, "Input"],
Cell[53067, 2083, 215, 6, 49, "Input"],
Cell[53285, 2091, 4596, 120, 209, "Input"],
Cell[57884, 2213, 262, 8, 49, "Input"],
Cell[58149, 2223, 63, 0, 42, "SmallText"],
Cell[58215, 2225, 258, 8, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[58510, 2238, 43, 0, 29, "Subsection"],
Cell[58556, 2240, 675, 14, 127, "SmallText"],
Cell[59234, 2256, 1658, 44, 113, "Input"],
Cell[60895, 2302, 238, 8, 28, "Input"],
Cell[61136, 2312, 253, 4, 59, "SmallText"],
Cell[61392, 2318, 3060, 98, 205, "Input"],
Cell[64455, 2418, 87, 2, 44, "Input"],
Cell[64545, 2422, 199, 6, 44, "Input"],
Cell[64747, 2430, 108, 3, 44, "Input"],
Cell[64858, 2435, 250, 9, 44, "Input"],
Cell[65111, 2446, 88, 2, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[65248, 2454, 45, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[65318, 2458, 48, 0, 45, "Subsection"],
Cell[65369, 2460, 442, 14, 28, "Input"],
Cell[65814, 2476, 89, 2, 28, "Input"],
Cell[65906, 2480, 130, 4, 28, "Input"],
Cell[66039, 2486, 990, 37, 64, "SmallText"],
Cell[67032, 2525, 707, 23, 52, "Input"],
Cell[67742, 2550, 215, 7, 42, "SmallText"],
Cell[67960, 2559, 243, 7, 49, "Input"],
Cell[68206, 2568, 464, 9, 76, "SmallText"],
Cell[68673, 2579, 173, 5, 28, "Input"],
Cell[68849, 2586, 91, 2, 42, "SmallText"],
Cell[68943, 2590, 241, 7, 65, "Input"],
Cell[69187, 2599, 51, 0, 42, "SmallText"],
Cell[69241, 2601, 92, 2, 44, "Input"],
Cell[69336, 2605, 235, 7, 65, "Input"],
Cell[69574, 2614, 217, 4, 59, "SmallText"],
Cell[69794, 2620, 232, 6, 65, "Input"],
Cell[70029, 2628, 54, 1, 44, "Input"],
Cell[70086, 2631, 89, 2, 42, "SmallText"],
Cell[70178, 2635, 168, 4, 65, "Input"],
Cell[70349, 2641, 117, 3, 42, "SmallText"],
Cell[70469, 2646, 152, 4, 44, "Input"],
Cell[70624, 2652, 146, 4, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[70807, 2661, 52, 0, 29, "Subsection"],
Cell[70862, 2663, 333, 10, 72, "Input"],
Cell[71198, 2675, 93, 2, 28, "Input"],
Cell[71294, 2679, 97, 2, 28, "Input"],
Cell[71394, 2683, 357, 12, 52, "Input"],
Cell[71754, 2697, 1361, 46, 109, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[73152, 2748, 59, 0, 29, "Subsection"],
Cell[73214, 2750, 428, 13, 76, "SmallText"],
Cell[73645, 2765, 138, 4, 28, "Input"],
Cell[73786, 2771, 155, 5, 28, "Input"],
Cell[73944, 2778, 203, 6, 28, "Input"],
Cell[74150, 2786, 161, 6, 30, "Input"],
Cell[74314, 2794, 320, 10, 28, "Input"],
Cell[74637, 2806, 522, 19, 72, "Input"],
Cell[75162, 2827, 243, 8, 28, "Input"],
Cell[75408, 2837, 187, 5, 28, "Input"],
Cell[75598, 2844, 186, 6, 44, "Input"],
Cell[75787, 2852, 402, 15, 68, "Input"],
Cell[76192, 2869, 243, 8, 44, "Input"],
Cell[76438, 2879, 166, 4, 44, "Input"],
Cell[76607, 2885, 198, 6, 59, "SmallText"],
Cell[76808, 2893, 175, 5, 58, "Input"],
Cell[76986, 2900, 138, 4, 44, "Input"],
Cell[77127, 2906, 138, 4, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[77302, 2915, 99, 2, 29, "Subsection"],
Cell[CellGroupData[{
Cell[77426, 2921, 80, 2, 41, "Subsubsection"],
Cell[77509, 2925, 252, 6, 59, "SmallText"],
Cell[77764, 2933, 481, 16, 52, "Input"],
Cell[78248, 2951, 135, 4, 28, "Input"],
Cell[78386, 2957, 169, 5, 28, "Input"],
Cell[78558, 2964, 130, 3, 28, "Input"],
Cell[78691, 2969, 269, 8, 30, "Input"],
Cell[78963, 2979, 107, 3, 28, "Input"],
Cell[79073, 2984, 86, 2, 28, "Input"],
Cell[79162, 2988, 59, 1, 44, "Input"],
Cell[79224, 2991, 77, 0, 42, "SmallText"],
Cell[79304, 2993, 662, 21, 87, "Input"],
Cell[79969, 3016, 51, 0, 42, "SmallText"],
Cell[80023, 3018, 831, 27, 68, "Input"],
Cell[80857, 3047, 327, 10, 44, "Input"],
Cell[81187, 3059, 570, 19, 68, "Input"],
Cell[81760, 3080, 394, 13, 46, "Input"],
Cell[82157, 3095, 386, 13, 46, "Input"],
Cell[82546, 3110, 549, 18, 65, "Input"],
Cell[83098, 3130, 213, 7, 28, "Input"],
Cell[83314, 3139, 851, 29, 68, "Input"],
Cell[84168, 3170, 2946, 96, 185, "Input"],
Cell[87117, 3268, 756, 23, 65, "Input"],
Cell[87876, 3293, 78, 2, 42, "SmallText"],
Cell[87957, 3297, 1694, 46, 129, "Input"],
Cell[89654, 3345, 199, 6, 44, "Input"],
Cell[89856, 3353, 213, 6, 44, "Input"],
Cell[90072, 3361, 266, 8, 44, "Input"],
Cell[90341, 3371, 107, 3, 44, "Input"],
Cell[90451, 3376, 181, 5, 44, "Input"],
Cell[90635, 3383, 92, 2, 44, "Input"],
Cell[90730, 3387, 172, 5, 44, "Input"],
Cell[90905, 3394, 83, 2, 28, "Input"],
Cell[90991, 3398, 352, 11, 44, "Input"],
Cell[91346, 3411, 250, 7, 44, "Input"],
Cell[91599, 3420, 261, 8, 44, "Input"],
Cell[91863, 3430, 360, 10, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[92260, 3445, 79, 2, 27, "Subsubsection"],
Cell[92342, 3449, 217, 5, 59, "SmallText"],
Cell[92562, 3456, 298, 10, 28, "Input",
 CellID->489327928],
Cell[92863, 3468, 150, 5, 28, "Input"],
Cell[93016, 3475, 231, 7, 28, "Input"],
Cell[93250, 3484, 409, 14, 28, "Input"],
Cell[93662, 3500, 196, 5, 42, "SmallText"],
Cell[93861, 3507, 348, 12, 28, "Input",
 CellID->1679927154],
Cell[94212, 3521, 160, 5, 28, "Input",
 CellID->1138987686],
Cell[94375, 3528, 196, 7, 44, "Input",
 CellID->1212744502],
Cell[94574, 3537, 434, 15, 44, "Input",
 CellID->1497086605],
Cell[95011, 3554, 628, 21, 65, "Input"],
Cell[95642, 3577, 57, 1, 44, "Input"],
Cell[95702, 3580, 163, 5, 44, "Input"],
Cell[95868, 3587, 241, 6, 59, "SmallText"],
Cell[96112, 3595, 462, 15, 68, "Input"],
Cell[96577, 3612, 701, 22, 88, "Input"],
Cell[97281, 3636, 91, 2, 42, "SmallText"],
Cell[97375, 3640, 1967, 54, 150, "Input"],
Cell[99345, 3696, 124, 3, 42, "SmallText"],
Cell[99472, 3701, 235, 7, 44, "Input"],
Cell[99710, 3710, 239, 7, 44, "Input"],
Cell[99952, 3719, 39, 0, 42, "SmallText"],
Cell[99994, 3721, 230, 7, 44, "Input"],
Cell[100227, 3730, 234, 7, 44, "Input"],
Cell[100464, 3739, 414, 12, 59, "SmallText"],
Cell[100881, 3753, 187, 5, 44, "Input"],
Cell[101071, 3760, 182, 5, 44, "Input"],
Cell[101256, 3767, 166, 5, 28, "Input"],
Cell[101425, 3774, 161, 5, 44, "Input"],
Cell[101589, 3781, 75, 2, 42, "SmallText"],
Cell[101667, 3785, 313, 10, 46, "Input"],
Cell[101983, 3797, 258, 8, 44, "Input"],
Cell[102244, 3807, 409, 13, 46, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[102690, 3825, 79, 2, 27, "Subsubsection"],
Cell[102772, 3829, 234, 8, 30, "Input"],
Cell[103009, 3839, 186, 5, 30, "Input"],
Cell[103198, 3846, 187, 5, 30, "Input"],
Cell[103388, 3853, 526, 18, 50, "Input"],
Cell[103917, 3873, 88, 2, 28, "Input"],
Cell[104008, 3877, 213, 7, 28, "Input"],
Cell[104224, 3886, 230, 6, 30, "Input"],
Cell[104457, 3894, 612, 19, 88, "Input"],
Cell[105072, 3915, 408, 13, 85, "Input"],
Cell[105483, 3930, 483, 13, 105, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[106027, 3950, 42, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[106094, 3954, 43, 0, 45, "Subsection"],
Cell[106140, 3956, 134, 3, 42, "SmallText"],
Cell[106277, 3961, 209, 7, 28, "Input"],
Cell[106489, 3970, 151, 4, 28, "Input"],
Cell[106643, 3976, 121, 3, 28, "Input"],
Cell[106767, 3981, 108, 3, 42, "SmallText"],
Cell[106878, 3986, 100, 3, 28, "Input"],
Cell[106981, 3991, 100, 3, 28, "Input"],
Cell[107084, 3996, 105, 3, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[107226, 4004, 36, 0, 29, "Subsection"],
Cell[CellGroupData[{
Cell[107287, 4008, 89, 1, 41, "Subsubsection"],
Cell[107379, 4011, 112, 4, 76, "SmallText"],
Cell[107494, 4017, 347, 12, 49, "Input"],
Cell[107844, 4031, 367, 12, 28, "Input"],
Cell[108214, 4045, 59, 0, 42, "SmallText"],
Cell[108276, 4047, 90, 2, 28, "Input"],
Cell[108369, 4051, 75, 2, 42, "SmallText"],
Cell[108447, 4055, 109, 3, 28, "Input"],
Cell[108559, 4060, 30, 0, 42, "SmallText"],
Cell[108592, 4062, 210, 7, 44, "Input"],
Cell[108805, 4071, 55, 0, 42, "SmallText"],
Cell[108863, 4073, 228, 8, 44, "Input"],
Cell[109094, 4083, 230, 7, 44, "Input"],
Cell[109327, 4092, 75, 0, 42, "SmallText"],
Cell[109405, 4094, 280, 9, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[109722, 4108, 110, 1, 27, "Subsubsection"],
Cell[109835, 4111, 78, 4, 76, "SmallText"],
Cell[109916, 4117, 943, 30, 89, "Input"],
Cell[110862, 4149, 212, 6, 28, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[111123, 4161, 64, 0, 29, "Subsection"],
Cell[111190, 4163, 209, 7, 28, "Input"],
Cell[111402, 4172, 242, 8, 28, "Input"],
Cell[111647, 4182, 120, 3, 28, "Input"],
Cell[111770, 4187, 152, 3, 28, "Input"],
Cell[111925, 4192, 295, 9, 28, "Input"],
Cell[112223, 4203, 622, 20, 49, "Input"],
Cell[112848, 4225, 172, 3, 42, "SmallText"],
Cell[113023, 4230, 514, 16, 28, "Input"],
Cell[113540, 4248, 273, 8, 42, "SmallText"],
Cell[113816, 4258, 521, 16, 28, "Input"],
Cell[114340, 4276, 112, 4, 42, "SmallText"],
Cell[114455, 4282, 612, 19, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[115104, 4306, 39, 0, 29, "Subsection"],
Cell[115146, 4308, 129, 3, 42, "SmallText"],
Cell[115278, 4313, 556, 17, 89, "Input"],
Cell[115837, 4332, 71, 0, 42, "SmallText"],
Cell[115911, 4334, 394, 13, 49, "Input"],
Cell[116308, 4349, 103, 2, 42, "SmallText"],
Cell[116414, 4353, 438, 14, 49, "Input"],
Cell[116855, 4369, 90, 2, 42, "SmallText"],
Cell[116948, 4373, 355, 11, 65, "Input"],
Cell[117306, 4386, 707, 25, 63, "SmallText",
 Evaluatable->False],
Cell[118016, 4413, 643, 21, 68, "Input"],
Cell[118662, 4436, 650, 20, 61, "SmallText",
 Evaluatable->False],
Cell[119315, 4458, 489, 16, 68, "Input"],
Cell[119807, 4476, 124, 3, 42, "SmallText"],
Cell[119934, 4481, 476, 15, 68, "Input"],
Cell[120413, 4498, 105, 2, 42, "SmallText"],
Cell[120521, 4502, 559, 18, 65, "Input"],
Cell[121083, 4522, 202, 6, 42, "SmallText"],
Cell[121288, 4530, 476, 16, 81, "Input"],
Cell[121767, 4548, 229, 6, 42, "SmallText"],
Cell[121999, 4556, 656, 22, 65, "Input"],
Cell[122658, 4580, 732, 19, 78, "SmallText"],
Cell[123393, 4601, 603, 21, 68, "Input"],
Cell[123999, 4624, 279, 8, 44, "Input"],
Cell[124281, 4634, 52, 1, 44, "Input"],
Cell[124336, 4637, 146, 3, 42, "SmallText"],
Cell[124485, 4642, 211, 6, 44, "Input"],
Cell[124699, 4650, 161, 3, 42, "SmallText"],
Cell[124863, 4655, 499, 17, 68, "Input"],
Cell[125365, 4674, 250, 8, 44, "Input"],
Cell[125618, 4684, 628, 20, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[126283, 4709, 48, 0, 29, "Subsection"],
Cell[126334, 4711, 125, 5, 42, "SmallText"],
Cell[126462, 4718, 556, 17, 89, "Input"],
Cell[127021, 4737, 694, 23, 52, "Input"],
Cell[127718, 4762, 361, 10, 59, "SmallText"],
Cell[128082, 4774, 201, 6, 28, "Input"],
Cell[128286, 4782, 55, 1, 44, "Input"],
Cell[128344, 4785, 193, 6, 44, "Input"],
Cell[128540, 4793, 215, 7, 44, "Input"],
Cell[128758, 4802, 116, 3, 42, "SmallText"],
Cell[128877, 4807, 185, 6, 44, "Input"],
Cell[129065, 4815, 183, 6, 42, "SmallText"],
Cell[129251, 4823, 678, 20, 105, "Input"],
Cell[129932, 4845, 898, 28, 91, "SmallText"],
Cell[130833, 4875, 427, 12, 44, "Input"],
Cell[131263, 4889, 128, 3, 42, "SmallText"],
Cell[131394, 4894, 112, 3, 44, "Input"],
Cell[131509, 4899, 187, 6, 44, "Input"],
Cell[131699, 4907, 132, 4, 44, "Input"],
Cell[131834, 4913, 380, 9, 59, "SmallText"],
Cell[132217, 4924, 455, 15, 83, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[132709, 4944, 57, 0, 29, "Subsection"],
Cell[132769, 4946, 118, 3, 42, "SmallText"],
Cell[132890, 4951, 853, 26, 49, "Input"],
Cell[133746, 4979, 211, 8, 42, "SmallText"],
Cell[133960, 4989, 346, 11, 28, "Input"],
Cell[134309, 5002, 230, 7, 28, "Input"],
Cell[134542, 5011, 248, 6, 59, "SmallText"],
Cell[134793, 5019, 651, 22, 44, "Input"],
Cell[135447, 5043, 181, 5, 44, "Input"],
Cell[135631, 5050, 1966, 41, 180, "SmallText"],
Cell[137600, 5093, 843, 26, 66, "Input"],
Cell[138446, 5121, 147, 3, 42, "SmallText"],
Cell[138596, 5126, 274, 10, 44, "Input"],
Cell[138873, 5138, 196, 6, 42, "SmallText"],
Cell[139072, 5146, 404, 13, 44, "Input"],
Cell[139479, 5161, 298, 7, 59, "SmallText"],
Cell[139780, 5170, 286, 8, 44, "Input"],
Cell[140069, 5180, 243, 6, 76, "SmallText"],
Cell[140315, 5188, 1376, 40, 89, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[141728, 5233, 39, 0, 29, "Subsection"],
Cell[CellGroupData[{
Cell[141792, 5237, 86, 1, 41, "Subsubsection",
 Evaluatable->False],
Cell[141881, 5240, 439, 15, 65, "Input"],
Cell[142323, 5257, 299, 10, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[142659, 5272, 88, 1, 27, "Subsubsection",
 Evaluatable->False],
Cell[142750, 5275, 711, 25, 65, "Input"],
Cell[143464, 5302, 817, 26, 49, "Input"],
Cell[144284, 5330, 550, 18, 52, "Input"],
Cell[144837, 5350, 138, 4, 44, "Input"],
Cell[144978, 5356, 86, 2, 44, "Input"],
Cell[145067, 5360, 274, 9, 44, "Input"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
