(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    120707,       3921]
NotebookOptionsPosition[    110336,       3630]
NotebookOutlinePosition[    110774,       3649]
CellTagsIndexPosition[    110731,       3646]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Grafiken", "Title"],

Cell[CellGroupData[{

Cell["Einfache Grafiken aus Primitiven erstellen", "Section"],

Cell[CellGroupData[{

Cell["Ein Gitter", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterPunkte", "[", 
   RowBox[{
   "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", "ny_Integer"}], 
   "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"P0", "+", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "*", "dx"}], ",", 
       RowBox[{"j", "*", "dy"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "nx"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "ny"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GitterPunkte", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".3"}], ",", 
       RowBox[{"-", ".3"}]}], "}"}], ",", ".1", ",", ".1", ",", "5", ",", 
     "7"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "//", "Chop"}], "//", "MatrixForm"}]}], "Input"],

Cell[TextData[{
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Primitiv kann auch mit Liste von Punktlisten als Argument verwendet werden \
und ist in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Code meist in dieser Form anzutreffen. Ist ein Design-Problem.. Besser w\
\[ADoubleDot]re der Name ",
 StyleBox["PolygonList",
  FontWeight->"Bold"],
 " gewesen. \n\nWir verwenden deshalb nur einfache Polygone."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gitter", "[", "g_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Dimensions", "[", "g", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{"i", ",", "j"}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{"i", ",", 
            RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", 
            RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"g", "\[LeftDoubleBracket]", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", "j"}], "\[RightDoubleBracket]"}]}], 
         "}"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}]}], "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"g1", "=", 
     RowBox[{"Gitter", "[", "g", "]"}]}], ")"}], ",", "7"}], "]"}]], "Input"],

Cell["\<\
Daraus eine 2D-Grafik erzeugen, mit gr\[UDoubleDot]nen Fl\[ADoubleDot]chen \
sowie kurz-gestrichelten schwarzen Kanten, gesteuert durch geeignete \
Grafikprimitive.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
     RowBox[{"EdgeForm", "[", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "Black"}], "}"}], "]"}], ",", "g1"}], "}"}], 
   ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Dasselbe als ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Objekt:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterComplex", "[", 
   RowBox[{
   "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", "ny_Integer"}], 
   "]"}], ":=", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Join", "@@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"P0", "+", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "*", "dx"}], ",", 
           RowBox[{"j", "*", "dy"}]}], "}"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "nx"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "ny"}], "}"}]}], "]"}]}], "//", "Chop"}],
     ",", 
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
           "1"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
           "2"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "2"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ny", "+", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "1"}]}], "}"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"nx", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"ny", "-", "1"}]}], "}"}]}], "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gc", "=", 
   RowBox[{"GitterComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".3"}], ",", 
       RowBox[{"-", ".3"}]}], "}"}], ",", ".1", ",", ".1", ",", "5", ",", 
     "7"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "gc"}], "}"}], 
  "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["GitterPlot und ParametricPlot3D", "Subsection"],

Cell[TextData[{
 "g ist das Gitter der Parameterwerte, f: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["R", "2"], "\[Rule]", " ", 
    SuperscriptBox["R", "3"]}], TraditionalForm]]],
 " die darzustellende parametrisierte Fl\[ADoubleDot]che. ",
 StyleBox["GitterPlot",
  FontWeight->"Bold"],
 " erzeugt wieder ein komplexes Grafikprimitiv vom Typ ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 ". \nZu beachten ist, dass in unserer Anwendung f einstellig ist und als \
Argument einen Punkt ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "\[Element]", 
    SuperscriptBox["R", "2"]}], TraditionalForm]]],
 "\[UDoubleDot]bergeben bekommt. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterPlot", "[", 
   RowBox[{"f_", ",", "g_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Dimensions", "[", "g", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"f", "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", "j"}], "\[RightDoubleBracket]"}], ",", 
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", 
             RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", 
             RowBox[{"j", "+", "1"}]}], "\[RightDoubleBracket]"}], ",", 
           RowBox[{"g", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "j"}], "\[RightDoubleBracket]"}]}],
           "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{
          RowBox[{"d", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "-", "1"}]}], "}"}]}], "]"}]}]}], " ", "]"}]}]], "Input"],

Cell[TextData[{
 "Anwendung : Die Tangentialfl\[ADoubleDot]che an die getwistete Kubik ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"t", ",", 
     SuperscriptBox["t", "2"], ",", 
     SuperscriptBox["t", "3"]}], ")"}], TraditionalForm]]],
 "."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"t_", ",", "u_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t", "+", "u"}], ",", 
    RowBox[{
     SuperscriptBox["t", "2"], "+", 
     RowBox[{"2", "t", " ", "u"}]}], ",", 
    RowBox[{
     SuperscriptBox["t", "3"], "+", 
     RowBox[{"3", 
      SuperscriptBox["t", "2"], "u"}]}]}], "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"GitterPlot", "[", 
    RowBox[{"f", ",", "g"}], "]"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Daraus wird mit entsprechenden Direktiven ein ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekt erzeugt. \nHier eins, das in einem dunklen Raum in der Telekomfarbe \
gl\[UDoubleDot]ht."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Glow", "[", "Magenta", "]"}], ",", "g2"}], "}"}], ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "Black", "}"}]}], ",", 
   RowBox[{"Boxed", "->", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}]}]}], "]"}]], "Input"],

Cell[TextData[{
 "Und hier dasselbe Bild mit ",
 StyleBox["ParametricPlot3D",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "u"}], ",", 
     RowBox[{
      SuperscriptBox["t", "2"], "+", 
      RowBox[{"2", "t", " ", "u"}]}], ",", 
     RowBox[{
      SuperscriptBox["t", "3"], "+", 
      RowBox[{"3", 
       SuperscriptBox["t", "2"], "u"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", ".3"}], ",", ".2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", ".3"}], ",", ".4"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "3"}], ",", 
   RowBox[{"Mesh", "->", "All"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "->", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell[TextData[{
 "In einer Realisierung als ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Objekt m\[UDoubleDot]ssen nur die Punkte transformiert werden. \nSie \
brauchen weiter die Funktion ",
 StyleBox["GitterComplex",
  FontWeight->"Bold"],
 " aus dem letzten Abschnitt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GitterComplexPlot", "[", 
   RowBox[{
   "f_", ",", "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", 
    "ny_Integer"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gc", "=", 
      RowBox[{"GitterComplex", "[", 
       RowBox[{"P0", ",", "dx", ",", "dy", ",", "nx", ",", "ny"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{
      RowBox[{"f", "/@", 
       RowBox[{"gc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
       ",", 
      RowBox[{"gc", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
     "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"GitterComplexPlot", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".3"}], ",", 
       RowBox[{"-", ".3"}]}], "}"}], ",", ".1", ",", ".1", ",", "5", ",", 
     "7"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Glow", "[", "Yellow", "]"}], ",", "g3"}], "}"}], ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "Black", "}"}]}], ",", 
   RowBox[{"Boxed", "->", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}]}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ein Torus", "Subsection"],

Cell["Ein  Torus als GitterPlot. ", "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"tf", ",", "s", ",", "d"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tf", "[", 
   RowBox[{"{", 
    RowBox[{"u_", ",", "t_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"b", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"r", "+", 
     RowBox[{"s", " ", "r", "*", 
      RowBox[{"Sin", "[", "u", "]"}]}], "+", 
     RowBox[{"s", " ", "b", "*", 
      RowBox[{"Cos", "[", "u", "]"}]}]}]}], "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "20"}], ";", 
  RowBox[{"s", "=", ".3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g4", "=", 
   RowBox[{"GitterPlot", "[", 
    RowBox[{"tf", ",", 
     RowBox[{"GitterPunkte", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "d"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "d"}]}], ",", "d", ",", "d"}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{"g4", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "Input"],

Cell[TextData[{
 "Und als ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 ". "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"torusFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t_", ",", "u_"}], "}"}], ",", "s_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"b", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"r", "+", 
      RowBox[{"s", " ", "r", "*", 
       RowBox[{"Sin", "[", "u", "]"}]}], "+", 
      RowBox[{"s", " ", "b", "*", 
       RowBox[{"Cos", "[", "u", "]"}]}]}], "//", "N"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Torus", "[", 
   RowBox[{"s_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"GitterComplexPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"torusFunction", "[", 
      RowBox[{"#", ",", "s", ",", "d"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", "d", ",", "d"}], "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g5", "=", 
   RowBox[{"Torus", "[", 
    RowBox[{".4", ",", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{"g5", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Die Farbsysteme von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section"],

Cell[CellGroupData[{

Cell["Die verschiedenen Farbsysteme", "Subsection"],

Cell["\<\
Die Farbsysteme RGB und CMYK entsprechen einander nicht genau. -- Nun doch.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Cyan", ",", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Der Zusammenhang zwischen ",
 StyleBox["Hue",
  FontWeight->"Bold"],
 " und RGB:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Hue", "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Red", ",", "Yellow", ",", "Green", ",", "Cyan", ",", "Blue", ",", 
           "Magenta", ",", "Red"}], "}"}], ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}]}], "}"}],
    ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Hue",
  FontWeight->"Bold"],
 " mit dem S\[ADoubleDot]ttigungsparameter "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "White"}], "}"}], ",", 
        RowBox[{"1", "-", "i"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Hue",
  FontWeight->"Bold"],
 " mit dem Helligkeitsparameter."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "1", ",", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Black"}], "}"}], ",", 
        RowBox[{"1", "-", "i"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stellt eine gro\[SZ]e Menge von Farbpaletten aus den verschiedensten \
Anwendungsgebieten bereit. Diese k\[ODoubleDot]nnen aus der mitgelieferten ",
 StyleBox["ColorData",
  FontWeight->"Bold"],
 "-Sammlung \[UDoubleDot]ber ein Schl\[UDoubleDot]sselwort als ",
 StyleBox["ColorDataFunction",
  FontWeight->"Bold"],
 "-Objekt extrahiert werden. Eine solche ",
 StyleBox["ColorDataFunction",
  FontWeight->"Bold"],
 " ist eine Funktion aus einem meist als reelles Intervall gegebenen \
Argumentbereich in ein Farbspektrum spezieller, genauestens ausgew\
\[ADoubleDot]hlter (\"carefully chosen\") RGB-Werte."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"c", "=", 
  RowBox[{
  "ColorData", "[", "\"\<Rainbow\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"c", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", ".01"}], "}"}]}], "]"}], "}"}], 
   ",", 
   RowBox[{"AspectRatio", "->", ".1"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"ColorData", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<Physical\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalUDoubleDot]berdeckungen und Transparenz in 2D-Grafiken \
\>", "Subsection"],

Cell["\<\
Zweidimensionale Fl\[ADoubleDot]chen \[UDoubleDot]berdecken sich, was \
passiert? Hier ein Beispiel mit teilweiser Durchsichtigkeit.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{"Green", ",", "r1", ",", 
     RowBox[{"Opacity", "[", ".7", "]"}], ",", "Yellow", ",", "r2"}], "}"}], 
   "]"}]}]}], "Input"],

Cell[TextData[{
 StyleBox["ColorOutput",
  FontWeight->"Bold"],
 " funktioniert nicht und ist als obsolet markiert, aber der Ersatz ",
 StyleBox["ColorFunction",
  FontWeight->"Bold"],
 " ist noch nicht einsatzbereit.\nDer Punkt muss grau sein und nicht gr\
\[UDoubleDot]n (und ist es auch in Version 5.1)."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", ".3", "]"}], ",", "Green", ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Farbgebung und Rastergrafiken ", "Subsection"],

Cell[BoxData[
 RowBox[{"gOut", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<test.gif\>\"", ",", "gOut"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gIn", "=", 
  RowBox[{"Import", "[", "\"\<test.gif\>\"", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"ByteCount", "/@", 
  RowBox[{"{", 
   RowBox[{"gOut", ",", "gIn"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"gIn", "//", "Head"}]], "Input"],

Cell[BoxData[
 RowBox[{"List", "@@", 
  RowBox[{"Head", "/@", "gIn"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gIn", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "4"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"gIn", ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"gIn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"List", "@@", 
  RowBox[{"Head", "/@", "r"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "//", 
  "Dimensions"}]], "Input"],

Cell[BoxData[
 RowBox[{"r", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"r", "\[LeftDoubleBracket]", 
    RowBox[{"4", ",", "2"}], "\[RightDoubleBracket]"}]}], ";"}], "\n", 
 RowBox[{"c", "//", "Short"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"5", ",", "9"}], "]"}], ",", 
    RowBox[{"Range", "[", 
     RowBox[{"7", ",", "12"}], "]"}]}], "\[RightDoubleBracket]"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{
    RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "\[LeftDoubleBracket]", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"5", ",", "25"}], "]"}], ",", 
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", "55"}], "]"}]}], "\[RightDoubleBracket]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{"r1", "/", "300"}], "]"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{
    RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
    
    RowBox[{"ColorFunction", "->", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GrayLevel", "[", 
        RowBox[{"#", "/", "256"}], "]"}], "&"}], ")"}]}]}], "]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"gIn", "=", 
  RowBox[{"Import", "[", "\"\<ExampleData/rose.gif\>\"", "]"}]}]], "Input",
 CellID->1193134083],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"gIn", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Raster", "[", 
    RowBox[{
     RowBox[{"r", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",",
      
     RowBox[{"ColorFunction", "->", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"GrayLevel", "[", 
         RowBox[{"#", "/", "256"}], "]"}], "&"}], ")"}]}]}], "]"}], ",", " ", 
   
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Das Beleuchtungsmodell", "Section"],

Cell[CellGroupData[{

Cell["Visualisierung der Standardbeleuchtung ", "Subsection"],

Cell["\<\
Standard-Lichtquellen auf einer stark spiegelnden Kugel: Ambientes Licht und \
drei (die Dokumentation behauptet vier) Lichtquellen in den Farben Rot, Gr\
\[UDoubleDot]n, Blau, die mit der Kamera starr verbunden sind.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"1", ",", "300"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}]], "Input",
 CellID->1315025100],

Cell[BoxData[
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{"g", ",", 
   RowBox[{"viewOptions", "=", 
    RowBox[{"{", 
     RowBox[{"ViewPoint", ",", "ViewCenter", ",", "ViewVertical"}], "}"}]}]}],
   "]"}]], "Input"],

Cell[TextData[{
 StyleBox["ImageScaled",
  FontWeight->"Bold"],
 " ist angeblich relativ zum ",
 StyleBox["ImageSize",
  FontWeight->"Bold"],
 ". Im 2D-Fall ist plausibel, was darunter zu verstehen ist, nicht aber im \
3D-Fall."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"ImageScaled", "/@", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", "0.1"}], "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
    "v"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[TextData[{
 "Obwohl ",
 StyleBox["ImageScaled",
  FontWeight->"Bold"],
 " ... und sie bewegt sich doch."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"ImageScaled", "/@", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "]"}], "&"}], "/@",
     "v"}], ",", 
   RowBox[{"Boxed", "->", "False"}]}], "]"}]}], "Input"],

Cell["\<\
Fr\[UDoubleDot]her gab es drei Lichtquellen. Ist auch jetzt noch so im \
Gegensatz zur Beschreibung im Hilfesystem. Allein ambientes Licht scheint \
noch eine weitere Portion dabei zu sein. 
Der eps-Export funktioniert hier nicht richtig - die Spielegeffekte werden \
falsch dargestellt.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l0", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Ambient\>\"", ",", 
     RowBox[{"GrayLevel", "[", "0.1", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"ImageScaled", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"u", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"g", ",", 
      RowBox[{"Show", "[", 
       RowBox[{"g", ",", 
        RowBox[{"Lighting", "\[Rule]", "l"}]}], "]"}], ",", 
      RowBox[{"Show", "[", 
       RowBox[{"g", ",", 
        RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}], "}"}], 
    "}"}], "]"}]}]}], "Input"],

Cell["\<\
Leider funktioniert der eps-Export dieser Grafik nicht. Deshalb der Umweg \
\[UDoubleDot]ber eine jpg-Grafik mit leidlicher Aufl\[ODoubleDot]sung. Bei gr\
\[ODoubleDot]\[SZ]eren Aufl\[ODoubleDot]sungen hat auch der jpg-Export so \
seine Probleme.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.jpg\>\"", ",", "u", ",", 
   RowBox[{"ImageSize", "->", 
    RowBox[{"30", 
     RowBox[{"{", 
      RowBox[{"60", ",", "25"}], "}"}]}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Probleme mit der Beleuchtung (1)", "Subsection"],

Cell[TextData[{
 "Obwohl ",
 StyleBox["ImageScaled",
  FontWeight->"Bold"],
 " bewegen sich die Lichtreflexe mit der Grafik und sind au\[SZ]erdem an der \
falschen Stelle."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell["\<\
Hier werden absolute Koordinaten f\[UDoubleDot]r die Lichtquellenpunkte \
verwendet und es sieht gut aus.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell["Mit Spot-Licht ist es nicht viel anders.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"ImageScaled", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"50", "\[Degree]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", 
       RowBox[{"c", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"v", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
       RowBox[{"50", "\[Degree]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Probleme mit der Beleuchtung (2)", "Subsection"],

Cell["\<\
Kurz - mit der Beleuchtung scheint noch vieles im Argen zu liegen. Hier ein \
kleines Testbeispiel, an welchem die Beleuchtungverh\[ADoubleDot]ltnisse \
\[UDoubleDot]berschaubar sind: zwei \[UDoubleDot]bereinander liegende \
Quadrate und eine einzige Lichtquelle. Wengistens den Schatten sollte man ja \
dann sehen.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{".5", 
       RowBox[{"RotateRight", "/@", "v"}]}], "]"}], ",", 
     RowBox[{"Polygon", "[", "v", "]"}], ",", 
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", "v", "]"}], ",", ".3", ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".3"}], "}"}]}], "]"}]}], "}"}], 
   "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Point\>\"", ",", "White", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Point\>\"", ",", "White", ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Point\>\"", ",", "White", ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
     RowBox[{"Scaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d3", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
     RowBox[{"ImageScaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"40", "\[Degree]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
     RowBox[{"Scaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"40", "\[Degree]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
     RowBox[{"ImageScaled", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"40", "\[Degree]"}]}], "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "p1", "}"}]}]}], "]"}]], "Input"],

Cell["\<\
And this are the reults with the version of April 20:
p1 - no shadow, location plausible, moving with the picture
p2 - no shadow, location plausible, moving with the picture
p3 - no shadow, location wrong, moving with the picture
d1 - no shadow, location plausible, moving with the picture
d2 - no shadow, location plausible, moving with the picture
d3 - no shadow, location wrong, moving with the picture
s1 - small shadow, location plausible, moving with the picture
s2 - no shadow, location not plausible, moving with the picture
s3 - no shadow, location wrong, moving with the picture\
\>", "SmallText"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["CutOut (Durchsichtige 3D-Objekte)", "Section"],

Cell[CellGroupData[{

Cell["Eine erste L\[ODoubleDot]sung", "Subsection"],

Cell["\<\
Wir beginnen mit Grafikobjekten, die aus einfachen Primitiven zusammengesetzt \
sind. 
Als Startpunkt verwenden wir unseren weiter oben definierten Torus.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GitterComplex", "[", 
    RowBox[{
    "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", "ny_Integer"}], 
    "]"}], ":=", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Join", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"P0", "+", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "*", "dx"}], ",", 
            RowBox[{"j", "*", "dy"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "nx"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "ny"}], "}"}]}], "]"}]}], "//", 
      "Chop"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"Join", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
            "1"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], " ", "i"}], "+", "j", "+", 
            "2"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], 
             RowBox[{"(", 
              RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "2"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ny", "+", "1"}], ")"}], 
             RowBox[{"(", 
              RowBox[{"i", "+", "1"}], ")"}]}], "+", "j", "+", "1"}]}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", 
           RowBox[{"nx", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", 
           RowBox[{"ny", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GitterComplexPlot", "[", 
    RowBox[{
    "f_", ",", "P0_", ",", "dx_", ",", "dy_", ",", "nx_Integer", ",", 
     "ny_Integer"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gc", "=", 
       RowBox[{"GitterComplex", "[", 
        RowBox[{"P0", ",", "dx", ",", "dy", ",", "nx", ",", "ny"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{
       RowBox[{"f", "/@", 
        RowBox[{
        "gc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ",", 
       RowBox[{"gc", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
       "]"}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"torusFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_"}], "}"}], ",", "s_", ",", "d_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"b", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"r", "+", 
       RowBox[{"s", " ", "r", "*", 
        RowBox[{"Sin", "[", "u", "]"}]}], "+", 
       RowBox[{"s", " ", "b", "*", 
        RowBox[{"Cos", "[", "u", "]"}]}]}], "//", "N"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Torus", "[", 
   RowBox[{"s_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"GitterComplexPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"torusFunction", "[", 
      RowBox[{"#", ",", "s", ",", "d"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "d"}]}], ",", "d", ",", "d"}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Ein solches ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Objekt kann mit ",
 StyleBox["Normal",
  FontWeight->"Bold"],
 " in eine Liste einfacher Grafikprimitive transformiert werden. Dabei werden \
alls Abk\[UDoubleDot]rzungen aufgel\[ODoubleDot]st, auch die, dass ein ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Objekt mit einer Liste von Listen von Punkten als Liste von ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Objekten interpretiert wird."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"Torus", "[", 
    RowBox[{".3", ",", "10"}], "]"}], ",", "3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{"Torus", "[", 
      RowBox[{".3", ",", "10"}], "]"}], "//", "Normal"}]}], ",", "7"}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"torus", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"t", ",", " ", 
    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]], "Input"],

Cell["\<\
Ein so normalisierter Torus besteht aus Polygonen mit vier Eckpunkten, woraus \
das folgende Kommando Polygone mit drei Eckpunkten macht. Damit wird der \
Torus \"durchsichtig\".\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"torushohl", " ", "=", " ", 
  RowBox[{"torus", " ", "/.", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{"p1_", ",", "p2_", ",", "p3_", ",", "p4_"}], "}"}], "]"}], 
    "\[Rule]", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}]}]}]}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
CutOut - L\[ODoubleDot]cher in Polygone schneiden\
\>", "Subsection"],

Cell["\<\
Regul\[ADoubleDot]res Polygon \[UDoubleDot]ber Punkte in der Gau\[SZ]schen \
Zahlenebene als Grafikprimitiv konstruieren.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"regularPolygon", "[", "n_Integer", "]"}], "/;", 
    RowBox[{"n", ">", "0"}]}], ":=", 
   RowBox[{"Polygon", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "[", "#", "]"}], ",", 
         RowBox[{"Im", "[", "#", "]"}], ",", "0"}], "}"}], "&"}], "/@", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", 
           RowBox[{"i", "/", "n"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], "//", "N"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"regularPolygon", "[", "6", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"ViewPoint", "->", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cutout", "[", 
   RowBox[{"p_List", ",", "\[Alpha]_"}], "]"}], ":=", "\[IndentingNewLine]", 
  "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"l", ",", "q"}], "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"q", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
            RowBox[{"Mean", "[", "p", "]"}]}], "+", 
           RowBox[{"\[Alpha]", "#"}]}], ")"}], "&"}], ",", "p"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"l", "=", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"RotateLeft", "[", "p", "]"}], ",", 
         RowBox[{"RotateLeft", "[", "q", "]"}], ",", "q"}], "}"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"Polygon", "/@", "l"}]}]}], "\n", "\t  ", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"torus", "/.", " ", 
  RowBox[{
   RowBox[{"Polygon", "[", "x_", "]"}], " ", "\[Rule]", 
   RowBox[{"cutout", "[", 
    RowBox[{"x", ",", ".66"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"g_Graphics3D", ",", " ", 
    RowBox[{"\[Alpha]_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", "<", "#", "<", "1"}], "&"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{"g", " ", "/.", " ", 
   RowBox[{
    RowBox[{"Polygon", "[", "x_", "]"}], " ", "\[Rule]", 
    RowBox[{"cutout", "[", 
     RowBox[{"x", ",", "\[Alpha]"}], "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"liste", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"cutout", "[", 
  RowBox[{"liste", ",", "0.5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"CutOut", "[", 
   RowBox[{"p", ",", "0.5"}], "]"}]}]], "Input"],

Cell[TextData[{
 "Das ist eine sehr simple Version zum Entfernen der Bildkanten, die nur mit \
einfachen ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekten funktioniert. Hierzu wird in die Liste ",
 StyleBox["a",
  FontSlant->"Italic"],
 " der Grafikprimitive, aus denen das ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekt aufgebaut ist, an erster Stelle die Grafikdirektive ",
 StyleBox["EdgeForm[] ",
  FontWeight->"Bold"],
 "eingef\[UDoubleDot]gt. Diese bewirkt, dass alle folgenden Grafikprimitive \
ohne Kanten dargestellt werden. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NoEdges", "[", "g_Graphics3D", "]"}], ":=", 
  RowBox[{"g", "/.", 
   RowBox[{
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"{", "a__", "}"}], ",", "b___"}], "]"}], "->", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "]"}], ",", "a"}], "}"}], ",", "b"}], 
     "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"torushohl", "//", "NoEdges"}]], "Input"],

Cell[BoxData[
 RowBox[{"CutOut", "[", 
  RowBox[{"torus", ",", ".66"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"torus", ",", ".66"}], "]"}], "//", "NoEdges"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
CutOut f\[UDoubleDot]r komplexe Graphics3D-Objekte\
\>", "Subsection"],

Cell[TextData[{
 "In der neuen Grafik von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " haben die Gitterlinien eines 3D-Objekts nichts mehr mit dessen innerer \
Struktur zu tun, sondern sind erst in einem zweiten Arbeitsschritt als \
eindimensionale Linienz\[UDoubleDot]ge aufgebracht. Demzufolge muss mehr \
Aufwand getrieben werden, um auch komplexe Grafikobjekte zu \"durchl\
\[ODoubleDot]chern\". "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"3", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Als erstes entfernen wir alle Linien, denn sie st\[ODoubleDot]ren nur.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"3", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", " ", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"p", "//", "InputForm"}], ",", "5"}], "]"}]], "Input"],

Cell[TextData[{
 "p ist ein ",
 StyleBox["Graphics3D",
  FontWeight->"Bold"],
 "-Objekt. Da ",
 StyleBox["CutOut",
  FontWeight->"Bold"],
 " neue St\[UDoubleDot]tzpunkte generiert, muss diese kompakte Darstellung \
durch das Kommando ",
 StyleBox["Normal",
  FontWeight->"Bold"],
 " erst aufgel\[ODoubleDot]st werden. Die Grafik wird nat\[UDoubleDot]rlich \
genauso dargestellt wie die vorherige in ihrer kompakten Darstellung."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"p", "//", "Normal"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Depth", "/@", 
  RowBox[{"{", 
   RowBox[{"p", ",", "q"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ByteCount", "/@", 
  RowBox[{"{", 
   RowBox[{"p", ",", "q"}], "}"}]}]], "Input"],

Cell[TextData[{
 "Au\[SZ]erdem k\[ODoubleDot]nnen ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Objekte nun eine Liste von Optionen haben, was wir beim Anschreiben von ",
 StyleBox["cutout",
  FontWeight->"Bold"],
 " und ",
 StyleBox["CutOut",
  FontWeight->"Bold"],
 " ber\[UDoubleDot]cksichtigen m\[UDoubleDot]ssen. Die modifizierten \
Versionen haben folgendes Aussehen: "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cutout", "[", 
   RowBox[{"p_List", ",", "\[Alpha]_", ",", 
    RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", "\[IndentingNewLine]",
   "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"l", ",", "q"}], "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"q", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
            RowBox[{"Mean", "[", "p", "]"}]}], "+", 
           RowBox[{"\[Alpha]", "#"}]}], ")"}], "&"}], ",", "p"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"l", "=", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"RotateLeft", "[", "p", "]"}], ",", 
         RowBox[{"RotateLeft", "[", "q", "]"}], ",", "q"}], "}"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"Polygon", "/@", "l"}]}]}], "\n", "\t  ", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"g_Graphics3D", ",", " ", 
    RowBox[{"\[Alpha]_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", "<", "#", "<", "1"}], "&"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Normal", "[", "g", "]"}], " ", "/.", " ", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], " ", "\[Rule]", 
    RowBox[{"cutout", "[", 
     RowBox[{"x", ",", "\[Alpha]", ",", "opts"}], "]"}]}]}]}]}], "Input"],

Cell[TextData[{
 "Nun funktioniert ",
 StyleBox["CutOut",
  FontWeight->"Bold"],
 " auch f\[UDoubleDot]r ",
 StyleBox["Plot3D",
  FontWeight->"Bold"],
 "-Ausgaben."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"q", ",", "0.7"}], "]"}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "Blue", "}"}]}]}], "]"}]}], "Input"],

Cell[TextData[{
 "Den ",
 StyleBox["Polygon",
  FontWeight->"Bold"],
 "-Objekten ist die Grafikdirektive ",
 StyleBox["EdgeForm[] ",
  FontWeight->"Bold"],
 "vorangestellt, welche das Zeichnen der Kanten der Polygone vermeidet. Dies \
kann mit dem folgenden Kommando ver\[ADoubleDot]ndert werden.  Auf Grund der \
adaptiven Gr\[ODoubleDot]\[SZ]e der Triangulierung ist das Bild aber nicht so \
eindrucksvoll wie bei einer Triangulierung mit konstanter Netzgr\[ODoubleDot]\
\[SZ]e."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CutOut", "[", 
    RowBox[{"q", ",", "0.4"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "]"}], "\[Rule]", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0001", "]"}], ",", "Black"}], "}"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", "Yellow", "}"}]}]}], "]"}]}], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
TubePlot3D - R\[ODoubleDot]hrenkurven programmieren\
\>", "Section"],

Cell["\<\
Einige allgemein n\[UDoubleDot]tzliche Funktionen.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TPlen", "[", "x_", "]"}], ":=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
      "2"]}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TPnorm", "[", "x_", "]"}], ":=", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"TPlen", "[", "x", "]"}]], "//", "Together"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell["\<\
Erste L\[ODoubleDot]sung: Die \"mathematische\", d.h. analytische \
\[UDoubleDot]ber das begleitende Dreibein und ParametricPlot\
\>", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "TPDreibein", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TPDreibein", "[", 
   RowBox[{
    RowBox[{"f_", "?", "VectorQ"}], ",", "t_Symbol"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"h", ",", "n", ",", "b", ",", "u"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"f", ",", "t"}], "]"}], "//", "TPnorm"}]}], ";", " ", 
     RowBox[{"(*", " ", "Haupttangentenvektor", " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"D", "[", 
       RowBox[{"f", ",", "t", ",", "t"}], "]"}]}], ";", "\[IndentingNewLine]",
      
     RowBox[{"n", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
           "h", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "===",
            "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{
            "h", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",", 
            
            RowBox[{"-", 
             RowBox[{
             "h", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
            "h", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
            
            RowBox[{"-", 
             RowBox[{
             "h", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
            ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"(", 
         RowBox[{"u", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"h", " ", ".", " ", "u"}], ")"}], " ", "h"}]}], ")"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"n", "//", "TPnorm"}]}], ";", 
     RowBox[{"(*", " ", "Normalenvektor", " ", "*)"}], "\[IndentingNewLine]", 
     
     RowBox[{"b", "=", 
      RowBox[{
       RowBox[{"h", "\[Cross]", "n"}], "//", "Together"}]}], ";", 
     RowBox[{"(*", " ", "Binormalenvektor", " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"h", ",", "n", ",", "b"}], "}"}]}]}], "]"}]}]}], "Input"],

Cell[TextData[{
 StyleBox["Message",
  FontWeight->"Bold"],
 " gibt Zwischenergebnisse aus. Das ist zum Debuggen der Funktion ebenso \
sinnvoll wie zur Demonstration, dass die analytische L\[ODoubleDot]sung hier \
ungeeignet ist. Solche Zwischenausgaben k\[ODoubleDot]nnen wie \
Systeminformationen mit ",
 StyleBox["Off",
  FontWeight->"Bold"],
 " abgeschaltet werden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "TubePlot3D", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TP", "::", "msg1"}], "=", "\"\<f ist `1`\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TP", "::", "msg2"}], "=", 
   "\"\<Begleitendes Dreibein ist `1`\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TubePlot3D", "[", 
   RowBox[{
    RowBox[{"f_", "?", "VectorQ"}], ",", 
    RowBox[{"r_:", "0.1"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t_Symbol", ",", "start_", ",", "end_"}], "}"}], ",", " ", 
    RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", "\[IndentingNewLine]",
   
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"h", ",", "n", ",", "b", ",", "u"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"TP", "::", "msg1"}], ",", "f"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"h", ",", "n", ",", "b"}], "}"}], "=", 
      RowBox[{"TPDreibein", "[", 
       RowBox[{"f", ",", "t"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"TP", "::", "msg2"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "n", ",", "b"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{"f", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Sin", "[", "u", "]"}], "n"}], "+", 
            RowBox[{
             RowBox[{"Cos", "[", "u", "]"}], "b"}]}], ")"}], "r"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"t", ",", "start", ",", "end"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", "\[IndentingNewLine]", "opts", 
       ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input"],

Cell[TextData[{
 "Einige Beispiele. \nDer Aufruf mit ",
 StyleBox["u",
  FontSlant->"Italic"],
 " statt ",
 StyleBox["t",
  FontSlant->"Italic"],
 "  klappt auch, dank der lokal deklarierten Variablen in der \
Funktionsdefinition von ",
 StyleBox["TubePlot3D",
  FontWeight->"Bold"],
 "."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Boxed", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"TP", "::", "msg1"}], "]"}], ";", 
  RowBox[{"Off", "[", 
   RowBox[{"TP", "::", "msg2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"0.5", "+", 
    RowBox[{"0.3", 
     RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Cos", "[", "t", "]"}], ",", "0"}], "}"}], ",", "0.5", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Cos", "[", "t", "]"}], ",", "0"}], "}"}], ",", "0.5", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}]], "Input"],

Cell[TextData[{
 "An Wendepunkten der Mittenkurve treten Probleme auf, weil dann in den \
Koordinatenberechnungen des Dreibeins Ausdr\[UDoubleDot]cke der Form ",
 Cell[BoxData[
  FormBox[
   FractionBox["0", "0"], TraditionalForm]]],
 " entstehen. Deshalb eine L\[UDoubleDot]cke in der Grafik.  \nMit ",
 StyleBox["Mesh \[Rule] All ",
  FontWeight->"Bold"],
 "oder ",
 StyleBox["Mesh \[Rule] None",
  FontWeight->"Bold"],
 " ist alles okay, weil dazu kein extra Netz auf die Figur aufgebracht wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", " ", 
     RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}], ",", "0.5", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell["\<\
Und hier etwas Code zum Studium des Verhaltens an der Unregelm\[ADoubleDot]\
\[SZ]igkeitsstelle.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", ".05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", " ", 
     RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}], ",", ".3", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"\[Pi]", "-", "u"}], ",", 
     RowBox[{"\[Pi]", "+", "u"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Zweite L\[ODoubleDot]sung: Die \"numerische\", welche die Fl\[ADoubleDot]che \
unmittelbar aus Grafikprimitiven erzeugt\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TPproject", "[", 
    RowBox[{
     RowBox[{"n_", "?", "VectorQ"}], ",", 
     RowBox[{"h_", "?", "VectorQ"}]}], "]"}], ":=", 
   RowBox[{"TPnorm", "[", 
    RowBox[{"n", "-", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"h", ".", "n"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"h", ".", "h"}], ")"}]}], "h"}]}], "]"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Und hier die Definition von ",
 StyleBox["TubePlot3D",
  FontWeight->"Bold"],
 ":"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "TubePlot3D", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"func_", "?", "VectorQ"}], ",", 
     RowBox[{"radiusfunc_:", "0.1"}], ",", " ", "\[IndentingNewLine]", "\t", 
     RowBox[{"{", 
      RowBox[{"var_Symbol", ",", "start_", ",", "end_"}], "}"}], ",", " ", 
     RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", "\n", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "  ", "r", ",", " ", "pList", ",", " ", "hvList", ",", " ", 
       "nvList", ",", " ", "bvList", ",", " ", "rList", ",", " ", "pts", ",", 
       " ", "u", ",", " ", "delta", ",", " ", "plotpts", ",", "nt", ",", " ", 
       "nr"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"plotpts", "=", 
       RowBox[{
        RowBox[{"PlotPoints", " ", "/.", " ", 
         RowBox[{"{", "opts", "}"}]}], " ", "/.", " ", 
        RowBox[{"PlotPoints", " ", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"15", ",", "15"}], "}"}]}]}]}], ";", "\t", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"Switch", "[", 
       RowBox[{"plotpts", ",", "\[IndentingNewLine]", "\t\t", "_List", ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nt", ",", "nr"}], "}"}], "=", 
         RowBox[{"plotpts", "\[LeftDoubleBracket]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "\[RightDoubleBracket]"}]}], ",", 
        "\[IndentingNewLine]", "\t\t", "_", ",", 
        RowBox[{"nt", "=", 
         RowBox[{"nr", "=", "plotpts"}]}]}], "]"}], ";", "\n", "\t\t", 
      RowBox[{"delta", "=", 
       RowBox[{"N", "[", 
        FractionBox[
         RowBox[{"end", "-", "start"}], "nt"], "]"}]}], ";", "\n", "\t\t", 
      RowBox[{
       RowBox[{"f", "[", "t_", "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{"func", "/.", 
         RowBox[{"var", "\[Rule]", "t"}]}], ")"}]}], ";", "\n", "\t\t", 
      RowBox[{
       RowBox[{"r", "[", "t_", "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{"radiusfunc", " ", "/.", " ", 
         RowBox[{"var", "\[Rule]", "t"}]}], ")"}]}], ";", "\n", "\t\t", 
      RowBox[{"pList", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"f", "[", "i", "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", "start", ",", "end", ",", "delta"}], "}"}]}], 
        "]"}]}], ";", "\n", "\t\t", 
      RowBox[{"hvList", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"TPnorm", "[", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"i", "+", 
             FractionBox["delta", "100"]}], "]"}], " ", "-", 
           RowBox[{"f", "[", 
            RowBox[{"i", "-", 
             FractionBox["delta", "100"]}], "]"}]}], "]"}], ",", " ", 
         "\[IndentingNewLine]", "\t\t", 
         RowBox[{"{", 
          RowBox[{"i", ",", "start", ",", "end", ",", "delta"}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"rList", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"r", "[", "i", "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", "start", ",", "end", ",", "delta"}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{"Normalen", "-", " ", 
        RowBox[{"und", " ", "Binormalenvektoren"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"u", "=", 
       RowBox[{"{", 
        RowBox[{"1.", ",", "1.", ",", "1."}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"nvList", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Set", "[", 
           RowBox[{"u", ",", 
            RowBox[{"TPproject", "[", 
             RowBox[{"u", ",", "#"}], "]"}]}], "]"}], "&"}], ",", "hvList"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"bvList", "=", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TPnorm", "[", 
           RowBox[{"Cross", "[", 
            RowBox[{"#1", ",", "#2"}], "]"}], "]"}], "&"}], ",", 
         RowBox[{"{", 
          RowBox[{"hvList", ",", "nvList"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"pts", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"#1", "+", 
             RowBox[{"#2", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Sin", "[", "u", "]"}], "#3"}], "+", 
                RowBox[{
                 RowBox[{"Cos", "[", "u", "]"}], "#4"}]}], ")"}]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"u", ",", "0.", ",", 
              RowBox[{"2", "\[Pi]"}], ",", 
              FractionBox[
               RowBox[{"2", "\[Pi]"}], "nr"]}], "}"}]}], "]"}], "&"}], ",", 
         "\[IndentingNewLine]", "\t\t", 
         RowBox[{"{", 
          RowBox[{"pList", ",", "rList", ",", "nvList", ",", "bvList"}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Table", "[", "\[IndentingNewLine]", "\t", 
           RowBox[{
            RowBox[{"With", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"v", "=", 
                RowBox[{"Join", "@@", 
                 RowBox[{"pts", "\[LeftDoubleBracket]", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"i", ",", 
                    RowBox[{"i", "+", "1"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"j", ",", 
                    RowBox[{"j", "+", "1"}]}], "}"}]}], 
                  "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
              "\[IndentingNewLine]", "\t", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Polygon", "[", 
                 RowBox[{"v", "\[LeftDoubleBracket]", 
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
                  "\[RightDoubleBracket]"}], "]"}], ",", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"v", "\[LeftDoubleBracket]", 
                  RowBox[{"{", 
                   RowBox[{"2", ",", "3", ",", "4"}], "}"}], 
                  "\[RightDoubleBracket]"}], "]"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "\t", 
            RowBox[{"{", 
             RowBox[{"i", ",", "nt"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "nr"}], "}"}]}], "]"}], ",", 
          RowBox[{"EdgeForm", "[", "]"}]}], "]"}], ",", " ", 
        "\[IndentingNewLine]", "\t\t", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"{", "opts", "}"}], ",", " ", 
          RowBox[{"PlotPoints", "\[Rule]", "_"}]}], "]"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Ende", " ", "der", " ", "Definition", " ", "von", " ", "TubePlot3D"}], 
   " ", "*)"}]}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["TubePlot3D anwenden", "Subsection"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "u", "]"}], "\n", 
 RowBox[{"p1", "=", 
  RowBox[{"TubePlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Durch das Einf\[UDoubleDot]gen von ",
 StyleBox["EdgeForm[]",
  FontWeight->"Bold"],
 " in die obige Definition werden die Polygone ohne Rand gezeichnet. Mit \
folgenden Kommandos kann der Rand nachtr\[ADoubleDot]glich sichtbar gemacht \
oder auch wieder versteckt werden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ShowEdges", "[", "g_Graphics3D", "]"}], ":=", 
  RowBox[{"g", "/.", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "]"}], "->", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Thickness", "[", "Tiny", "]"}], 
     "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NoEdges", "[", "g_Graphics3D", "]"}], ":=", 
  RowBox[{"g", "/.", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "_", "]"}], "->", 
    RowBox[{"EdgeForm", "[", "]"}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"p1", "//", "ShowEdges"}]], "Input"],

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", " ", 
       RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}], ",", "0.5", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "//", 
   "ShowEdges"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"0.5", "+", 
      RowBox[{"0.3", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}], "//", 
   "ShowEdges"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p4", "=", 
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", "t", "]"}], ",", "0"}], "}"}], ",", "0.5", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"40", ",", "6"}], "}"}]}]}], "]"}], "//", 
   "ShowEdges"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p5", "=", 
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", "t", "]"}], ",", "0"}], "}"}], ",", "0.5", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"6", ",", "40"}], "}"}]}]}], "]"}], "//", 
   "ShowEdges"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p6", "=", 
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", "t", "]"}], ",", 
       RowBox[{"t", "/", "10"}]}], "}"}], ",", "0.5", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"3", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"50", ",", "12"}], "}"}]}]}], "]"}], "//", 
   "ShowEdges"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"NoEdges", "/@", 
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}]}], ",", 
    RowBox[{"NoEdges", "/@", 
     RowBox[{"{", 
      RowBox[{"p4", ",", "p5", ",", "p6"}], "}"}]}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TubePlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", 
        FractionBox["t", "2"]}], ")"}], 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         FractionBox["t", "2"]}], ")"}]}], 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", "0"}], "}"}], ",", 
   FractionBox[
    RowBox[{"1", "+", "t"}], "10"], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"30", ",", "12"}], "}"}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Titelbild", "Subsection"],

Cell[TextData[{
 "Auch das Titelbild des Buches wurde mit ",
 StyleBox["TubePlot3D",
  FontWeight->"Bold"],
 " erstellt. Hier zun\[ADoubleDot]chst die Einzelteile, aus denen der Knoten \
zusammengesetzt wurde. \nIn der Designphase arbeiten wir mit geringer Aufl\
\[ODoubleDot]sung. Wenn alles zu unserer Zufriedenheit ausgefallen ist, \
werden alle Rechnungen noch einmal mit hoher Aufl\[ODoubleDot]sung ausgef\
\[UDoubleDot]hrt und das endg\[UDoubleDot]ltige Bild erzeugt. \nDazu \
speichern wir die Aufl\[ODoubleDot]sung in einer Variablen ",
 StyleBox["res",
  FontWeight->"Bold"],
 ", deren Wert \[UDoubleDot]ber die Option ",
 StyleBox["PlotPoints",
  FontWeight->"Bold"],
 " die Aufl\[ODoubleDot]sung steuert. "
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["t", "\[Pi]"]}], ")"}], 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["t", "\[Pi]"]}], ")"}], 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{".8", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox["t", "\[Pi]"]}], ")"}], 
       RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["t", "\[Pi]"]}], ")"}], 
      RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox["t", "\[Pi]"]}], ")"}], 
       RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox["t", "\[Pi]"]}], ")"}], 
       RowBox[{"Cos", "[", "t", "]"}]}]}]}], "}"}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"{", 
    RowBox[{"20", ",", "15"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{"f1", ",", ".3", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"-", "0.5"}], "\[Pi]"}], ",", 
       RowBox[{"5.2", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", "res"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{"f2", ",", ".3", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"-", ".2"}], "\[Pi]"}], ",", 
       RowBox[{"5.3", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", "res"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{"f3", ",", ".3", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", 
       RowBox[{"5.7", " ", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", "res"}]}], "]"}]}], ";"}]}], "Input"],

Cell["\<\
Der Knoten ohne Farben. Die F\[ADoubleDot]rbung kommt ausschlie\[SZ]lich \
durch die Standardlichtquellen zustande.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
   RowBox[{"ViewAngle", "->", 
    RowBox[{"30", "\[Degree]"}]}], ",", 
   RowBox[{"Boxed", "->", "True"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input"],

Cell["Der Knoten mit Eigenfarben.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1a", "=", 
   RowBox[{"p1", " ", "/.", " ", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "Red"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"p2a", "=", 
   RowBox[{"p2", " ", "/.", " ", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "Yellow"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"p3a", "=", 
   RowBox[{"p3", " ", "/.", " ", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "Green"}], "]"}]}]}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
   RowBox[{"Lighting", "->", "\"\<Neutral\>\""}], ",", 
   RowBox[{"ViewAngle", "->", 
    RowBox[{"30", "\[Degree]"}]}], ",", 
   RowBox[{"Boxed", "->", "True"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Mit der aktuellen Version von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " l\[ADoubleDot]sst sich das Titelbild des Buches leider nciht erzeugen, \
weil Schattenwurf generell nicht ber\[UDoubleDot]cksichtigt wird. Nicht \
einmal, wenn drei Seitenw\[ADoubleDot]nde explizit eingezogen werden."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"7", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"box", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{"-", "u"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"-", 
       RowBox[{"RotateLeft", "/@", "u"}]}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"RotateRight", "/@", "u"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gbox", "=", 
   RowBox[{"Graphics3D", "[", "box", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sbox", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Specularity", "[", "1", "]"}], ",", "box"}], "}"}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"g1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gbox", ",", "p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
    RowBox[{"Lighting", "->", "\"\<Neutral\>\""}], ",", 
    RowBox[{"Boxed", "->", "False"}]}], "]"}]}]], "Input"],

Cell["\<\
Das mit dem Spotlicht funktioniert bestens, wenn man einmal davon absieht, \
dass der runde Lichtkegel geradlinig begrenzte Hell-Dunkel-Bereiche auf den \
Seitenw\[ADoubleDot]nden erzeugt. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"12", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"20", "\[Degree]"}]}], "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{"g2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gbox", ",", "p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
    RowBox[{"Lighting", "->", "l"}], ",", 
    RowBox[{"Boxed", "->", "False"}]}], "]"}]}]}], "Input"],

Cell["\<\
Auch bei einer punktf\[ODoubleDot]rmigen Lichtquelle sieht das Bild nicht \
anders aus. Die diffusen Schatten auf den Seitenw\[ADoubleDot]nden stammen \
nicht von unserem Knoten, sondern sind Reflexe der Lichtquelle selbst, wie \
ein Bild ohne den Knoten zeigt. \
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<Point\>\"", ",", "White", ",", 
      RowBox[{"10", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "}"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"g3", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gbox", ",", "p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
    RowBox[{"Lighting", "->", "l"}], ",", 
    RowBox[{"Boxed", "->", "False"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"g4", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", "gbox", "}"}], ",", 
    RowBox[{"Lighting", "->", "l"}], ",", 
    RowBox[{"Boxed", "->", "False"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"g1", ",", "g2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g3", ",", "g4"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell["\<\
Das beste, was man derzeit erreichen kann, ist also das folgende Bild.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"{", 
    RowBox[{"150", ",", "25"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{"f1", ",", ".3", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"-", "0.5"}], "\[Pi]"}], ",", 
       RowBox[{"5.2", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", "res"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{"f2", ",", ".3", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"-", ".2"}], "\[Pi]"}], ",", 
       RowBox[{"5.3", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", "res"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{"f3", ",", ".3", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", 
       RowBox[{"5.7", " ", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", "res"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p1a", "=", 
   RowBox[{"p1", " ", "/.", " ", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "Red"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"p2a", "=", 
   RowBox[{"p2", " ", "/.", " ", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "Yellow"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"p3a", "=", 
   RowBox[{"p3", " ", "/.", " ", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "Green"}], "]"}]}]}]}], 
  ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<Point\>\"", ",", "White", ",", 
      RowBox[{"10", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "}"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"p", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
    RowBox[{"Lighting", "->", "l"}], ",", 
    RowBox[{"ViewAngle", "->", 
     RowBox[{"20", "\[Degree]"}]}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
    RowBox[{"Lighting", "->", "\"\<Neutral\>\""}], ",", 
    RowBox[{"ViewAngle", "->", 
     RowBox[{"20", "\[Degree]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p", "//", "ByteCount"}]], "Input"],

Cell["\<\
Export in eine gif-Datei mit (standardm\[ADoubleDot]\[SZ]ig) 360x360 Pixeln.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<cover.gif\>\"", ",", " ", "p"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<cover.eps\>\"", ",", " ", "p"}], "]"}]], "Input"],

Cell["\<\
Und das war das alte Kommando; eine gif-Datei mit 3000x3000 Pixeln\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<cover1.gif\>\"", ",", " ", "p", ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3000", ",", "3000"}], "}"}]}]}], "]"}], ";"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["TubePlot3D und CutOut", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ShowEdges", "[", "g_Graphics3D", "]"}], ":=", 
  RowBox[{"g", "/.", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "]"}], "->", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Thickness", "[", "Tiny", "]"}], 
     "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NoEdges", "[", "g_Graphics3D", "]"}], ":=", 
  RowBox[{"g", "/.", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "_", "]"}], "->", 
    RowBox[{"EdgeForm", "[", "]"}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        SuperscriptBox["t", 
         RowBox[{"3", "/", "2"}]], "5"], ",", 
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"3", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     FractionBox["t", "8"], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.1", ",", 
       RowBox[{"8", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"40", ",", "5"}], "}"}]}]}], "]"}], "//", 
   "ShowEdges"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"TubePlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        SuperscriptBox["t", "1.5"], "5"], ",", 
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"3", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     FractionBox["t", "8"], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.1", ",", 
       RowBox[{"8", "\[Pi]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"80", ",", "20"}], "}"}]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"q", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"p", ",", 
    RowBox[{"Lighting", "\[Rule]", "l"}]}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Das folgende Kommando braucht die Definition von ",
 StyleBox["CutOut",
  FontWeight->"Bold"],
 " f\[UDoubleDot]r komplexe Grafikobjekte aus dem Abschnitt \"CutOut\" dieses \
Notebooks."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cutout", "[", 
   RowBox[{"p_List", ",", "\[Alpha]_", ",", 
    RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", "\[IndentingNewLine]",
   "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"l", ",", "q"}], "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"q", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
            RowBox[{"Mean", "[", "p", "]"}]}], "+", 
           RowBox[{"\[Alpha]", "#"}]}], ")"}], "&"}], ",", "p"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"l", "=", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"RotateLeft", "[", "p", "]"}], ",", 
         RowBox[{"RotateLeft", "[", "q", "]"}], ",", "q"}], "}"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"Polygon", "/@", "l"}]}]}], "\n", "\t  ", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"CutOut", "[", 
   RowBox[{"g_Graphics3D", ",", " ", 
    RowBox[{"\[Alpha]_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", "<", "#", "<", "1"}], "&"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Normal", "[", "g", "]"}], " ", "/.", " ", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], " ", "\[Rule]", 
    RowBox[{"cutout", "[", 
     RowBox[{"x", ",", "\[Alpha]", ",", "opts"}], "]"}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"CutOut", "[", 
  RowBox[{"q", ",", "0.66"}], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Illustrationen ", "Section"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TPlen", "[", "x_", "]"}], ":=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
      "2"]}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TPnorm", "[", "x_", "]"}], ":=", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"TPlen", "[", "x", "]"}]], "//", "Together"}]}], ";", 
  RowBox[{
   RowBox[{"TPproject", "[", 
    RowBox[{
     RowBox[{"n_", "?", "VectorQ"}], ",", 
     RowBox[{"h_", "?", "VectorQ"}]}], "]"}], ":=", 
   RowBox[{"TPnorm", "[", 
    RowBox[{"n", "-", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"h", ".", "n"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"h", ".", "h"}], ")"}]}], "h"}]}], "]"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell["Einige Funktionen", "Subsection"],

Cell["\<\
Ebene durch P mit Normalenvektor h. Q dient der Ausrichtung des Bildes.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ebene", "[", 
   RowBox[{"P_", ",", "Q_", ",", "h_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"Q", "-", "P"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"n", "-", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"h", ".", "n"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"h", ".", "h"}], ")"}]}], "h"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"b", "=", 
      RowBox[{"h", "\[Cross]", "n"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Polygon", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"P", "+", "#"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"n", ",", "b", ",", 
         RowBox[{"-", "n"}], ",", 
         RowBox[{"-", "b"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"normale", "[", "h_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "===",
        "0."}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"h", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
        ",", "0", ",", 
        RowBox[{"-", 
         RowBox[{
         "h", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"h", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"-", 
         RowBox[{
         "h", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
       "}"}]}], "]"}]}], "//", "TPnorm"}]}]], "Input"],

Cell["\<\
Pfeil von P0 nach P1. a1 bestimmt die L\[ADoubleDot]nge, a2 die Dicke der \
Pfeilspitze.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pfeil", "[", 
   RowBox[{"P0_", ",", "P1_", ",", "a1_", ",", "a2_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", ",", "n", ",", "b", ",", "Q", ",", "u"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"P1", "-", "P0"}]}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"Q", "=", 
      RowBox[{
       RowBox[{"a1", " ", "P0"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "a1"}], ")"}], " ", "P1"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"normale", "[", "v", "]"}]}], ";", " ", 
     RowBox[{"b", "=", 
      RowBox[{
       RowBox[{"v", "\[Cross]", "n"}], "//", "TPnorm"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"b", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Q", "+", 
         RowBox[{"a2", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Sin", "[", "u", "]"}], "n"}], "+", 
            RowBox[{
             RowBox[{"Cos", "[", "u", "]"}], "b"}]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0", ",", 
          RowBox[{"2", "\[Pi]"}], ",", 
          RowBox[{"\[Pi]", "/", "12"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Append", "[", 
      RowBox[{
       RowBox[{"Polygon", "/@", 
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Append", "[", 
             RowBox[{"#", ",", "P1"}], "]"}], "&"}], "/@", 
           RowBox[{"Thread", "[", 
            RowBox[{"{", 
             RowBox[{"b", ",", 
              RowBox[{"RotateLeft", "[", "b", "]"}]}], "}"}], "]"}]}], ",", 
          "b"}], "]"}]}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"P0", ",", "P1"}], "}"}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Und nun die Bilder", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"mk", "[", "t_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", "Mittenkurve", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"curve", "=", 
   RowBox[{"Line", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"mk", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0.6", ",", "4.2", ",", ".1"}], "}"}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t0", "=", "1."}], ";", 
  RowBox[{"t1", "=", "3."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P0", "=", 
   RowBox[{"mk", "[", "t0", "]"}]}], ";", 
  RowBox[{"h0", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"mk", "'"}], "[", "t0", "]"}], "//", "TPnorm"}]}], ";", 
  RowBox[{"n0", "=", 
   RowBox[{"normale", "[", "h0", "]"}]}], ";", 
  RowBox[{"b0", "=", 
   RowBox[{"h0", "\[Cross]", "n0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P1", "=", 
   RowBox[{"mk", "[", "t1", "]"}]}], ";", 
  RowBox[{"h1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"mk", "'"}], "[", "t1", "]"}], "//", "TPnorm"}]}], ";", 
  RowBox[{"n1", "=", 
   RowBox[{"TPproject", "[", 
    RowBox[{"n0", ",", "h1"}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", ".8", "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "curve"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FaceForm", "[", 
        RowBox[{"Hue", "[", "0.3", "]"}], "]"}], ",", 
       RowBox[{"ebene", "[", 
        RowBox[{"P0", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".5", ",", "0"}], "}"}], ",", "h0"}], "]"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FaceForm", "[", 
        RowBox[{"Hue", "[", ".5", "]"}], "]"}], ",", 
       RowBox[{"ebene", "[", 
        RowBox[{"P1", ",", 
         RowBox[{"{", 
          RowBox[{"2.", ",", ".3", ",", "2"}], "}"}], ",", "h1"}], "]"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
       RowBox[{"pfeil", "[", 
        RowBox[{"P0", ",", 
         RowBox[{"P0", "+", "h0"}], ",", ".3", ",", ".05"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
       RowBox[{"pfeil", "[", 
        RowBox[{"P0", ",", 
         RowBox[{"P0", "+", "n0"}], ",", ".3", ",", ".05"}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
       RowBox[{"pfeil", "[", 
        RowBox[{"P1", ",", 
         RowBox[{"P1", "+", "h1"}], ",", ".3", ",", ".05"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", 
       RowBox[{"pfeil", "[", 
        RowBox[{"P1", ",", 
         RowBox[{"P1", "+", "n1"}], ",", ".3", ",", ".05"}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(P\), \(0\)]\)\>\"", ",", " ", 
       RowBox[{"P0", "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".5"}], ",", ".1", ",", ".1"}], "}"}]}]}], "]"}], ",", 
     " ", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(P\), \(1\)]\)\>\"", ",", 
       RowBox[{"P1", "+", 
        RowBox[{"{", 
         RowBox[{"0", ",", ".2", ",", ".1"}], "}"}]}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(n\), \(0\)]\)\>\"", ",", 
       RowBox[{"P0", "+", 
        RowBox[{"{", 
         RowBox[{".3", ",", 
          RowBox[{"-", "1.3"}], ",", ".3"}], "}"}]}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(h\), \(0\)]\)\>\"", ",", 
       RowBox[{"P0", "+", 
        RowBox[{"{", 
         RowBox[{".7", ",", ".3", ",", ".3"}], "}"}]}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(n\), \(1\)]\)\>\"", ",", 
       RowBox[{"P1", "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".2"}], ",", 
          RowBox[{"-", "1.2"}], ",", ".3"}], "}"}]}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(h\), \(1\)]\)\>\"", ",", 
       RowBox[{"P1", "+", 
        RowBox[{"{", 
         RowBox[{"1.1", ",", 
          RowBox[{"-", "1."}], ",", "1.4"}], "}"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1."}], ",", "4.", ",", 
      RowBox[{"-", "6."}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"TextStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "18"}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "1", ",", "1"}], "]"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"P0", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"h", "=", 
   RowBox[{"-", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1."}], "}"}]}]}], ";", 
  RowBox[{"n", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3.", ",", "1.", ",", "7."}], "}"}], "//", "TPnorm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"n", "-", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"h", ".", "n"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"h", ".", "h"}], ")"}]}], "h"}]}]}], ";", 
  RowBox[{"p0", "=", 
   RowBox[{"p", "//", "TPnorm"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.", ",", "0.", ",", "0."}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", "Orange", "]"}], ",", 
        RowBox[{"ebene", "[", 
         RowBox[{"P0", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", "h"}], "]"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
        RowBox[{"pfeil", "[", 
         RowBox[{"P0", ",", 
          RowBox[{"P0", "+", "h"}], ",", ".2", ",", ".03"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
        RowBox[{"pfeil", "[", 
         RowBox[{"P0", ",", 
          RowBox[{"P0", "+", "n"}], ",", ".2", ",", ".03"}], "]"}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
        RowBox[{"pfeil", "[", 
         RowBox[{"P0", ",", 
          RowBox[{"P0", "+", "p"}], ",", ".3", ",", ".03"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
        RowBox[{"pfeil", "[", 
         RowBox[{"P0", ",", 
          RowBox[{"P0", "+", "p0"}], ",", ".2", ",", ".03"}], "]"}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"5", ",", "5"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"n", ",", "p"}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<h\>\"", ",", 
        RowBox[{"h", "+", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".1"}], ",", ".1", ",", ".1"}], "}"}]}]}], "]"}], ",",
       " ", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<n\>\"", ",", 
        RowBox[{"n", "+", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".1"}], ",", ".1", ",", "0"}], "}"}]}]}], "]"}], ",", 
      " ", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<p\>\"", ",", 
        RowBox[{"p", "-", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".1", ",", ".1"}], "}"}]}]}], "]"}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(p\), \(0\)]\)\>\"", ",", 
        RowBox[{"p0", "-", 
         RowBox[{"{", 
          RowBox[{".1", ",", ".1", ",", ".1"}], "}"}]}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", 
    RowBox[{"Boxed", "->", "False"}], ",", 
    RowBox[{"ViewPoint", "->", 
     RowBox[{"{", 
      RowBox[{"1.", ",", 
       RowBox[{"-", "12."}], ",", "6."}], "}"}]}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", "White", "}"}]}]}], "]"}]}]], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{695, 843},
WindowMargins->{{Automatic, 64}, {1, Automatic}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 25, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[640, 27, 61, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[726, 31, 32, 0, 45, "Subsection"],
Cell[761, 33, 76, 1, 28, "Input"],
Cell[840, 36, 502, 16, 49, "Input"],
Cell[1345, 54, 343, 11, 49, "Input"],
Cell[1691, 67, 434, 12, 93, "SmallText"],
Cell[2128, 81, 1419, 37, 69, "Input"],
Cell[3550, 120, 167, 5, 28, "Input"],
Cell[3720, 127, 193, 4, 59, "SmallText"],
Cell[3916, 133, 332, 10, 28, "Input"],
Cell[4251, 145, 114, 5, 42, "SmallText"],
Cell[4368, 152, 1813, 56, 89, "Input"],
Cell[6184, 210, 467, 15, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6688, 230, 53, 0, 29, "Subsection"],
Cell[6744, 232, 668, 20, 97, "SmallText"],
Cell[7415, 254, 1498, 39, 69, "Input"],
Cell[8916, 295, 274, 9, 46, "SmallText"],
Cell[9193, 306, 461, 15, 50, "Input"],
Cell[9657, 323, 131, 4, 28, "Input"],
Cell[9791, 329, 230, 6, 59, "SmallText"],
Cell[10024, 337, 389, 11, 49, "Input"],
Cell[10416, 350, 122, 5, 42, "SmallText"],
Cell[10541, 357, 880, 26, 72, "Input"],
Cell[11424, 385, 302, 9, 59, "SmallText"],
Cell[11729, 396, 668, 19, 65, "Input"],
Cell[12400, 417, 661, 20, 85, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[13098, 442, 31, 0, 29, "Subsection"],
Cell[13132, 444, 48, 0, 42, "SmallText"],
Cell[13183, 446, 798, 24, 69, "Input"],
Cell[13984, 472, 644, 20, 69, "Input"],
Cell[14631, 494, 103, 5, 42, "SmallText"],
Cell[14737, 501, 1251, 39, 89, "Input"],
Cell[15991, 542, 288, 8, 49, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16328, 556, 109, 5, 35, "Section"],
Cell[CellGroupData[{
Cell[16462, 565, 51, 0, 45, "Subsection"],
Cell[16516, 567, 104, 2, 42, "SmallText"],
Cell[16623, 571, 627, 18, 49, "Input"],
Cell[17253, 591, 116, 5, 42, "SmallText"],
Cell[17372, 598, 714, 21, 69, "Input"],
Cell[18089, 621, 117, 4, 42, "SmallText"],
Cell[18209, 627, 632, 20, 49, "Input"],
Cell[18844, 649, 106, 4, 42, "SmallText"],
Cell[18953, 655, 642, 20, 49, "Input"],
Cell[19598, 677, 690, 16, 93, "SmallText"],
Cell[20291, 695, 423, 13, 49, "Input"],
Cell[20717, 710, 57, 1, 28, "Input"],
Cell[20777, 713, 77, 1, 44, "Input"],
Cell[20857, 716, 84, 1, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[20978, 722, 94, 2, 29, "Subsection"],
Cell[21075, 726, 161, 3, 42, "SmallText"],
Cell[21239, 731, 790, 28, 69, "Input"],
Cell[22032, 761, 324, 8, 76, "SmallText"],
Cell[22359, 771, 277, 8, 28, "Input"],
Cell[22639, 781, 128, 3, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[22804, 789, 52, 0, 29, "Subsection"],
Cell[22859, 791, 201, 6, 28, "Input"],
Cell[23063, 799, 224, 6, 49, "Input"],
Cell[23290, 807, 110, 3, 28, "Input"],
Cell[23403, 812, 55, 1, 28, "Input"],
Cell[23461, 815, 82, 2, 28, "Input"],
Cell[23546, 819, 199, 6, 28, "Input"],
Cell[23748, 827, 113, 3, 28, "Input"],
Cell[23864, 832, 223, 6, 49, "Input"],
Cell[24090, 840, 129, 3, 28, "Input"],
Cell[24222, 845, 93, 1, 28, "Input"],
Cell[24318, 848, 200, 5, 49, "Input"],
Cell[24521, 855, 346, 10, 28, "Input"],
Cell[24870, 867, 488, 14, 49, "Input"],
Cell[25361, 883, 353, 11, 28, "Input"],
Cell[25717, 896, 132, 3, 28, "Input",
 CellID->1193134083],
Cell[25852, 901, 565, 17, 65, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26466, 924, 41, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[26532, 928, 61, 0, 45, "Subsection"],
Cell[26596, 930, 246, 4, 59, "SmallText"],
Cell[26845, 936, 307, 9, 28, "Input",
 CellID->1315025100],
Cell[27155, 947, 217, 6, 28, "Input"],
Cell[27375, 955, 245, 8, 59, "SmallText"],
Cell[27623, 965, 587, 21, 49, "Input"],
Cell[28213, 988, 126, 5, 42, "SmallText"],
Cell[28342, 995, 690, 23, 49, "Input"],
Cell[29035, 1020, 316, 6, 76, "SmallText"],
Cell[29354, 1028, 1657, 53, 109, "Input"],
Cell[31014, 1083, 275, 5, 59, "SmallText"],
Cell[31292, 1090, 216, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[31545, 1101, 54, 0, 29, "Subsection"],
Cell[31602, 1103, 189, 6, 42, "SmallText"],
Cell[31794, 1111, 632, 18, 49, "Input"],
Cell[32429, 1131, 134, 3, 42, "SmallText"],
Cell[32566, 1136, 586, 17, 49, "Input"],
Cell[33155, 1155, 61, 0, 42, "SmallText"],
Cell[33219, 1157, 808, 23, 49, "Input"],
Cell[34030, 1182, 763, 22, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[34830, 1209, 54, 0, 29, "Subsection"],
Cell[34887, 1211, 344, 6, 76, "SmallText"],
Cell[35234, 1219, 861, 27, 69, "Input"],
Cell[36098, 1248, 3004, 93, 189, "Input"],
Cell[39105, 1343, 138, 4, 28, "Input"],
Cell[39246, 1349, 617, 11, 195, "SmallText"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39912, 1366, 52, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[39989, 1370, 51, 0, 45, "Subsection"],
Cell[40043, 1372, 183, 4, 59, "SmallText"],
Cell[40229, 1378, 3948, 118, 269, "Input"],
Cell[44180, 1498, 507, 15, 76, "SmallText"],
Cell[44690, 1515, 350, 12, 49, "Input"],
Cell[45043, 1529, 158, 4, 28, "Input"],
Cell[45204, 1535, 207, 4, 59, "SmallText"],
Cell[45414, 1541, 512, 14, 85, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[45963, 1560, 79, 2, 29, "Subsection"],
Cell[46045, 1564, 150, 3, 42, "SmallText"],
Cell[46198, 1569, 753, 25, 49, "Input"],
Cell[46954, 1596, 344, 9, 49, "Input"],
Cell[47301, 1607, 1023, 29, 129, "Input"],
Cell[48327, 1638, 190, 5, 28, "Input"],
Cell[48520, 1645, 416, 12, 28, "Input"],
Cell[48939, 1659, 319, 10, 28, "Input"],
Cell[49261, 1671, 88, 2, 28, "Input"],
Cell[49352, 1675, 108, 3, 28, "Input"],
Cell[49463, 1680, 577, 16, 93, "SmallText"],
Cell[50043, 1698, 403, 13, 65, "Input"],
Cell[50449, 1713, 64, 1, 44, "Input"],
Cell[50516, 1716, 88, 2, 44, "Input"],
Cell[50607, 1720, 119, 3, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[50763, 1728, 80, 2, 29, "Subsection"],
Cell[50846, 1732, 428, 9, 76, "SmallText"],
Cell[51277, 1743, 408, 14, 40, "Input"],
Cell[51688, 1759, 99, 2, 42, "SmallText"],
Cell[51790, 1763, 593, 18, 67, "Input"],
Cell[52386, 1783, 114, 3, 28, "Input"],
Cell[52503, 1788, 445, 13, 76, "SmallText"],
Cell[52951, 1803, 78, 2, 28, "Input"],
Cell[53032, 1807, 101, 3, 28, "Input"],
Cell[53136, 1812, 105, 3, 28, "Input"],
Cell[53244, 1817, 396, 12, 59, "SmallText"],
Cell[53643, 1831, 1584, 45, 185, "Input"],
Cell[55230, 1878, 181, 8, 42, "SmallText"],
Cell[55414, 1888, 229, 7, 65, "Input"],
Cell[55646, 1897, 498, 12, 76, "SmallText"],
Cell[56147, 1911, 482, 15, 65, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[56678, 1932, 78, 2, 35, "Section"],
Cell[56759, 1936, 79, 2, 42, "SmallText"],
Cell[56841, 1940, 704, 21, 91, "Input"],
Cell[CellGroupData[{
Cell[57570, 1965, 158, 3, 63, "Subsection"],
Cell[57731, 1970, 2469, 71, 209, "Input"],
Cell[60203, 2043, 387, 10, 76, "SmallText"],
Cell[60593, 2055, 2155, 61, 269, "Input"],
Cell[62751, 2118, 305, 12, 59, "SmallText"],
Cell[63059, 2132, 246, 7, 28, "Input"],
Cell[63308, 2141, 250, 7, 28, "Input"],
Cell[63561, 2150, 495, 15, 49, "Input"],
Cell[64059, 2167, 356, 10, 28, "Input"],
Cell[64418, 2179, 357, 10, 28, "Input"],
Cell[64778, 2191, 516, 13, 87, "SmallText"],
Cell[65297, 2206, 324, 9, 28, "Input"],
Cell[65624, 2217, 125, 3, 42, "SmallText"],
Cell[65752, 2222, 430, 12, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[66219, 2239, 149, 3, 47, "Subsection"],
Cell[66371, 2244, 417, 14, 28, "Input"],
Cell[66791, 2260, 117, 5, 42, "SmallText"],
Cell[66911, 2267, 7318, 183, 713, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[74266, 2455, 41, 0, 29, "Subsection"],
Cell[74310, 2457, 277, 8, 49, "Input"],
Cell[74590, 2467, 308, 7, 59, "SmallText"],
Cell[74901, 2476, 479, 14, 49, "Input"],
Cell[75383, 2492, 59, 1, 28, "Input"],
Cell[75445, 2495, 354, 11, 28, "Input"],
Cell[75802, 2508, 399, 13, 28, "Input"],
Cell[76204, 2523, 496, 15, 49, "Input"],
Cell[76703, 2540, 496, 15, 49, "Input"],
Cell[77202, 2557, 526, 16, 49, "Input"],
Cell[77731, 2575, 308, 9, 28, "Input"],
Cell[78042, 2586, 693, 23, 77, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[78772, 2614, 31, 0, 29, "Subsection"],
Cell[78806, 2616, 734, 16, 127, "SmallText"],
Cell[79543, 2634, 1331, 47, 112, "Input"],
Cell[80877, 2683, 1112, 33, 89, "Input"],
Cell[81992, 2718, 144, 3, 42, "SmallText"],
Cell[82139, 2723, 287, 8, 28, "Input"],
Cell[82429, 2733, 48, 0, 42, "SmallText"],
Cell[82480, 2735, 830, 27, 69, "Input"],
Cell[83313, 2764, 346, 9, 49, "Input"],
Cell[83662, 2775, 337, 7, 59, "SmallText"],
Cell[84002, 2784, 1274, 42, 89, "Input"],
Cell[85279, 2828, 276, 7, 28, "Input"],
Cell[85558, 2837, 218, 4, 59, "SmallText"],
Cell[85779, 2843, 703, 21, 49, "Input"],
Cell[86485, 2866, 291, 5, 59, "SmallText"],
Cell[86779, 2873, 534, 17, 49, "Input"],
Cell[87316, 2892, 210, 6, 28, "Input"],
Cell[87529, 2900, 218, 7, 28, "Input"],
Cell[87750, 2909, 99, 2, 42, "SmallText"],
Cell[87852, 2913, 1908, 60, 149, "Input"],
Cell[89763, 2975, 550, 18, 49, "Input"],
Cell[90316, 2995, 292, 8, 28, "Input"],
Cell[90611, 3005, 58, 1, 28, "Input"],
Cell[90672, 3008, 105, 2, 42, "SmallText"],
Cell[90780, 3012, 103, 2, 28, "Input"],
Cell[90886, 3016, 103, 2, 28, "Input"],
Cell[90992, 3020, 95, 2, 42, "SmallText"],
Cell[91090, 3024, 236, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[91363, 3035, 43, 0, 29, "Subsection"],
Cell[91409, 3037, 479, 14, 49, "Input"],
Cell[91891, 3053, 682, 22, 81, "Input"],
Cell[92576, 3077, 637, 20, 46, "Input"],
Cell[93216, 3099, 601, 19, 49, "Input"],
Cell[93820, 3120, 221, 6, 59, "SmallText"],
Cell[94044, 3128, 1584, 45, 169, "Input"],
Cell[95631, 3175, 85, 2, 28, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[95765, 3183, 42, 0, 35, "Section"],
Cell[95810, 3185, 1104, 34, 113, "Input"],
Cell[CellGroupData[{
Cell[96939, 3223, 39, 0, 45, "Subsection"],
Cell[96981, 3225, 100, 2, 42, "SmallText"],
Cell[97084, 3229, 981, 30, 129, "Input"],
Cell[98068, 3261, 859, 25, 49, "Input"],
Cell[98930, 3288, 117, 3, 42, "SmallText"],
Cell[99050, 3293, 1935, 58, 149, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[101022, 3356, 40, 0, 29, "Subsection"],
Cell[101065, 3358, 1322, 41, 109, "Input"],
Cell[102390, 3401, 4065, 109, 329, "Input"],
Cell[106458, 3512, 685, 24, 49, "Input"],
Cell[107146, 3538, 3150, 87, 249, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
