(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26836,        990]
NotebookOptionsPosition[     21733,        844]
NotebookOutlinePosition[     22159,        863]
CellTagsIndexPosition[     22116,        860]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nutzen"
}], "Title"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als Taschenrechner f\[UDoubleDot]r Zahlen"
}], "Section"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " f\[UDoubleDot]hrt (jenseits numerischer N\[ADoubleDot]herungen) grunds\
\[ADoubleDot]tzlich alle Rechungen exakt aus und verwendet dazu eine \
BigInteger-Arithmetik."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"1.23", "+", "2.25"}]], "Input"],

Cell[BoxData[
 RowBox[{"12", "+", "23"}]], "Input"],

Cell[BoxData[
 SuperscriptBox["2", "100"]], "Input"],

Cell[BoxData[
 RowBox[{"10", "!"}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kennt eine gro\[SZ]e Zahl zahlentheoretischer Funktionen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["2", "30"], "-", "1"}], ",", 
   RowBox[{
    SuperscriptBox["3", "20"], "-", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{
   RowBox[{"12", "!"}], "+", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{
   RowBox[{"12", "!"}], "-", "1"}], "]"}]], "Input"],

Cell["Auch mit rationalen Zahlen wird exakt gerechnet.", "SmallText"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox["2", "3"]}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "i"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "50"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input"],

Cell["\<\
Symbolische Ausdr\[UDoubleDot]cke wie \[Pi] werden als \"Bezeichner mit \
Eigenschaften\" behandelt. Eine Eigenschaft ist oft ein Verfahren zur \
Berechnung numerischer N\[ADoubleDot]herungen beliebiger Genauigkeit.\
\>", "SmallText"],

Cell[BoxData["Pi"], "Input"],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "30"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sin", "[", "\[Pi]", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"\[Pi]", "/", "4"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"\[Pi]", "/", "5"}], "]"}]], "Input"],

Cell[TextData[{
 "Aus numerischen N\[ADoubleDot]herungswerten kann man eine Beziehung wie \
Sin[\[Pi]]\[Equal]0 ",
 StyleBox["prinzipiell",
  FontSlant->"Italic"],
 " nicht ",
 StyleBox["exakt",
  FontSlant->"Italic"],
 " herleiten. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", "10"}], "]"}]}], ";", 
  RowBox[{"Sin", "[", "p", "]"}]}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kann nat\[UDoubleDot]rlich auch mit komplexen Zahlen rechnen. Aus \
innermathematischen Gr\[UDoubleDot]nden wird f\[UDoubleDot]r jede Variable \
angenommne, dass sie komplexwertig ist, wenn nicht anderes vereinbart ist."
}], "SmallText"],

Cell[BoxData[
 SqrtBox[
  RowBox[{"-", "12"}]]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "1"}], ")"}], "+", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "1"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"1", "+", 
    RowBox[{"3", "I"}]}]}], ";", " ", 
  SuperscriptBox["z", "2"]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"z", "+", "1"}], 
  RowBox[{"z", "-", "1"}]]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "1"}], ")"}], "+", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "+", "1"}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input"],

Cell[TextData[{
 "F\[UDoubleDot]r geschachtelte Wurzelausdr\[UDoubleDot]cke kennt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " manchmal verbl\[UDoubleDot]ffende Vereinfachungen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"u1", "=", 
  SqrtBox[
   RowBox[{"4", "+", 
    RowBox[{"2", 
     SqrtBox["3"]}]}]]}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "u1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"u2", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{"11", "+", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]], "+", 
   SqrtBox[
    RowBox[{"11", "-", 
     RowBox[{"6", 
      SqrtBox["2"]}]}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "u2", "]"}]], "Input"],

Cell[TextData[{
 "An anderen Stellen verh\[ADoubleDot]lt sich ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dagegen sehr eigenwillig. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"u3", "=", 
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]]}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"RootReduce", "[", "u3", "]"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als Taschenrechner f\[UDoubleDot]r Formeln und symbolische Ausdr\
\[UDoubleDot]cke"
}], "Section"],

Cell["\<\
Komplizierte rationale Ausdr\[UDoubleDot]cke lassen sich gelegentlich in eine \
verbl\[UDoubleDot]ffend einfache Form bringen.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
   FractionBox["b", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}]}]], "+", 
   FractionBox["c", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"c", "-", "b"}], ")"}]}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", "n"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"a", "-", "c"}], ")"}]}]], "+", 
   FractionBox[
    SuperscriptBox["b", "n"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}]}]], "+", 
   FractionBox[
    SuperscriptBox["c", "n"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"c", "-", "b"}], ")"}]}]]}]}]], "Input"],

Cell[TextData[{
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " ist daf\[UDoubleDot]r nicht immer der rcihtige Operator."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "/.", 
      RowBox[{"n", "\[Rule]", "i"}]}], "//", "Simplify"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "7"}], "}"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "Das richtige Kommando ist hier ",
 StyleBox["Together",
  FontWeight->"Bold"],
 ", mit dem der Hauptnenner gebildet und dann Z\[ADoubleDot]hler und Nenner \
vereinfacht wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"u6", "=", 
  RowBox[{
   RowBox[{"u", "/.", 
    RowBox[{"n", "\[Rule]", "6"}]}], "//", "Together"}]}]], "Input"],

Cell[TextData[{
 "Aber auch das Ergebnis von ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " war richtig, denn f\[UDoubleDot]r n>5 sind die geschachtelten rationalen \
Ausdr\[UDoubleDot]cke in der Tat \"einfacher\". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vergleicht dazu die Anzahl derBausteine, aus denen die verschiedenen m\
\[ODoubleDot]glichen Ergebnisse bestehen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"LeafCount", "/@", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"LeafCount", "[", "u6", "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Listen, Matrizen, Substitutionslisten ", "Section"],

Cell["\<\
Listen und Tabellen sind die grundlegende Datenstruktur, in der Aggregationen \
von symbolischen Ausdr\[UDoubleDot]cken verwaltet werden. Hier sehen Sie die \
wichtigsten Kommandos f\[UDoubleDot]r Listen in Aktion. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["i", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plus", " ", "@@", "l"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "70"}], "}"}]}], "]"}], ",", "PrimeQ"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"Grid", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Auch Vektoren und Matrizen werden intern als Listen dargestellt. Die gewohnte \
mathematische Notation kann mit verschiedenen *Form-Kommandos hergestellt \
werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"mat", "=", 
  RowBox[{"(", GridBox[{
     {"a", "b", "c"},
     {"d", "e", "f"}
    }], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"mat", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", "mat", "]"}], "//", "MatrixForm"}]], "Input"],

Cell[TextData[{
 "Die L\[ODoubleDot]sung von Gleichungssystemen wird als ",
 StyleBox["Substitutionsliste",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ckgegeben. Zusammen mit dem Substitutionsoperator ",
 StyleBox["/. ",
  FontWeight->"Bold"],
 "ist eine solche Form f\[UDoubleDot]r die weitere Verarbeitung besonders gut \
geeignet."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", "y", "-", "2"}], "\[Equal]", "0"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       SuperscriptBox["y", "2"], "-", "2"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "/.", "sol"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sys", "/.", "sol"}], "//", "Expand"}]], "Input"],

Cell[TextData[{
 "Dabei wird vom Attribut Listable von /. (der InfixForm von ReplaceAll) \
Gebrauch gemacht, das als Anwendung einer Liste von Substitutionen auf einen \
Ausdruck eine Liste von Ergebnissen zur\[UDoubleDot]ckgibt.  In Wirklichkeit \
kommt ",
 StyleBox["Map[sys /. # & , sol] ",
  FontWeight->"Bold"],
 "oder kurz "
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"sys", "/.", "#"}], "&"}], ")"}], "/@", "sol"}]], "Input"],

Cell["\<\
zum Einsatz. 

In Versionen < 6 wurden an dieser Stelle Warnungen ausgel\[ODoubleDot]st. \
Diese r\[UDoubleDot]hrten daher, dass beide Seiten von \[Equal] numerisch \
auswertbar (Eigenschaft NumericQ) sind und deshalb zun\[ADoubleDot]chst \
versucht wurde, die Gleichheit durch numerische N\[ADoubleDot]herung zu \
falsifizieren. Erst danach bekam Simplify das Kommando. Dieser Zugang ist \
hier nat\[UDoubleDot]rlich zwecklos und wurde mit Version 6 \
ge\[ADoubleDot]ndert.

Mit dem folgenden komplexen Kommando (k\[ODoubleDot]nnen Sie es \
dechiffrieren?) wird gezeigt, dass alle linken Seiten in der Probe tats\
\[ADoubleDot]chlich die Eigenschaft NumericQ haben.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"NumericQ", "/@", "#"}], ")"}], "&"}], "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"First", "/@", "sys"}], "/.", "sol"}], ")"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als mathematisches Expertensystem"
}], "Section"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kennt mathematisch-algorithmische Verfahren aus vielen Gebieten der \
Mathematik."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  SuperscriptBox["x", "n"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "x"}]], 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "2"], 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Log", "[", "x", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "5"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[TextData[{
 "Manchmal stimmt die Form des Ergebnisses aber nicht mit den Erwartungen \
\[UDoubleDot]berein. Die Gleichwertigkeit von Ergebnissen zu \
pr\[UDoubleDot]fen oder gar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " zu \"\[UDoubleDot]berreden\", ein Ergebnis in einer bestimmten Form zur\
\[UDoubleDot]ckzugeben, ist eine hohe Kunst und bedarf oft genauerer \
Kenntnisse \[UDoubleDot]ber Interna der Darstellung und Rechnungen. \n\nHier \
etwa kommen komplexwertige Argumente an einer Stelle vor, wo sie gar nicht \
erforderlich sind. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"p", "=", 
  FractionBox[
   RowBox[{
    RowBox[{"2", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"2", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", "x"}], "-", "2"}], 
   RowBox[{
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "2"], "+", "1"}]]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"p", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"p", "//", "Apart"}]}]], "Input"],

Cell[TextData[{
 "Eine solche Zerlegung half noch bei ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.1, eine Darstellung mit reellwertigen Argumenten zu finden."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"p1", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 findet dasselbe Ergebnis nur, wenn die beiden Summanden wirklich \
getrennt integriert und dann die Ergebnisse addiert werden. Wir verwenden \
dabei als Interna, dass ",
 StyleBox["Map",
  FontWeight->"Bold"],
 " nicht nur f\[UDoubleDot]r Listen, sondern auch f\[UDoubleDot]r Summen \
funktioniert."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", "p1"}], "]"}]], "Input"],

Cell["Und hier ein paar Rechnungen aus der Analysis.", "SmallText"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["x", "2"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Tan", "[", "x", "]"}]}], 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   SuperscriptBox["k", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "n"], 
  SuperscriptBox["k", "3"]}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "n"}], ",", "n"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "n"}], ",", "n"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "k"}], "}"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Die Notation von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"uFactors", "=", 
  RowBox[{"FactorInteger", "[", 
   RowBox[{
    RowBox[{"12", "!"}], "+", "1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Context", "[", "Tan", "]"}]], "Input"],

Cell[BoxData["$ContextPath"], "Input"],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", "x", "+", "3"}], "\[Equal]", "0"}], ",", 
    "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"lsg", "\[LeftDoubleBracket]", "1", 
  "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SqrtBox["x"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"<<", " ", "Calendar`"}], " ", "oder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"EasterSunday", "/@", 
  RowBox[{"(", 
   RowBox[{"2006", "+", 
    RowBox[{"Range", "[", "10", "]"}]}], ")"}]}]], "Input"],

Cell[TextData[{
 "Bevor Symbole und Funktionen aus Paketen verwendet werden, muss der \
entsprechende Namensraum in den ",
 StyleBox["$ContextPath ",
  FontWeight->"Bold"],
 "aufgenommen werden.\n\nWas passiert, wenn obige Funktion aufgerufen wird, \
aber das Paket nicht geladen wurde? \nProbieren wir es aus. ",
 StyleBox["Mit ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["Evaluation | Quit Kernel",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" starten wir den Kernel neu",
  FontColor->RGBColor[1, 0, 0]],
 ", was alle bisherigen Setzungen l\[ODoubleDot]scht. "
}], "SmallText"],

Cell[BoxData[{"$ContextPath", "\[IndentingNewLine]", 
 RowBox[{"EasterSunday", "[", "2007", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], "Input"],

Cell[TextData[{
 "Beim ersten Aufruf wurde der unausgewertete Funktionsausdruck zur\
\[UDoubleDot]ckgegeben. Beim nachtr\[ADoubleDot]glichen Laden des Pakets ",
 StyleBox["Calendar ",
  FontWeight->"Bold"],
 "wird ein zweiter Bezeichner ",
 StyleBox["EasterSunday",
  FontWeight->"Bold"],
 " im Kontext ",
 StyleBox["Calendar`",
  FontWeight->"Bold"],
 " angelegt. Die Warnung weist darauf hin, dass beide Bezeichner denselben \
unqualifizierten Namen haben.\n\nSeit Version 6 wird beim zweiten Aufruf der \
zuletzt geladene (und damit gew\[UDoubleDot]nschte) Bezeichner verwendet. Mit \
dem folgenden Kommando k\[ODoubleDot]nnen Sie sich \[UDoubleDot]berzeugen, \
dass tats\[ADoubleDot]chlich beide Bezeichner existieren.  "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input"],

Cell[BoxData[{"$ContextPath", "\[IndentingNewLine]", 
 RowBox[{"EasterSunday", "[", "2007", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Names", "[", "\"\<*`EasterSunday\>\"", "]"}]}], "Input"],

Cell[TextData[{
 "Mit ",
 StyleBox["Remove",
  FontWeight->"Bold"],
 " und dem qualifizierten Namen kann der falsche Bezeichner aus der \
Symboltabelle entfernt werden (bzw. -- in fr\[UDoubleDot]heren ",
 StyleBox["Mathematica-V",
  FontSlant->"Italic"],
 "ersionen -- ",
 StyleBox["muss",
  FontWeight->"Bold"],
 " zum ordnungsgem\[ADoubleDot]\[SZ]en Funktionieren entfernt werden)"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Remove", "[", "Global`EasterSunday", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Names", "[", "\"\<*`EasterSunday\>\"", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "Solve"}]], "Input"],

Cell[BoxData[
 RowBox[{"??", "Mod"}]], "Input"]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{674, 647},
WindowMargins->{{Automatic, 223}, {Automatic, 74}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 88, 4, 90, "Title"],
Cell[CellGroupData[{
Cell[703, 31, 125, 4, 55, "Section"],
Cell[831, 37, 251, 6, 59, "SmallText"],
Cell[1085, 45, 55, 1, 28, "Input"],
Cell[1143, 48, 51, 1, 28, "Input"],
Cell[1197, 51, 52, 1, 30, "Input"],
Cell[1252, 54, 45, 1, 28, "Input"],
Cell[1300, 57, 143, 4, 42, "SmallText"],
Cell[1446, 63, 181, 6, 30, "Input"],
Cell[1630, 71, 109, 3, 28, "Input"],
Cell[1742, 76, 102, 3, 28, "Input"],
Cell[1847, 81, 69, 0, 42, "SmallText"],
Cell[1919, 83, 91, 3, 42, "Input"],
Cell[2013, 88, 161, 5, 42, "Input"],
Cell[2177, 95, 54, 1, 28, "Input"],
Cell[2234, 98, 244, 4, 59, "SmallText"],
Cell[2481, 104, 28, 0, 28, "Input"],
Cell[2512, 106, 78, 2, 28, "Input"],
Cell[2593, 110, 60, 1, 28, "Input"],
Cell[2656, 113, 83, 2, 28, "Input"],
Cell[2742, 117, 83, 2, 28, "Input"],
Cell[2828, 121, 251, 9, 42, "SmallText"],
Cell[3082, 132, 161, 5, 28, "Input"],
Cell[3246, 139, 305, 6, 59, "SmallText"],
Cell[3554, 147, 57, 2, 32, "Input"],
Cell[3614, 151, 171, 7, 36, "Input"],
Cell[3788, 160, 145, 5, 30, "Input"],
Cell[3936, 167, 93, 3, 42, "Input"],
Cell[4032, 172, 192, 8, 36, "Input"],
Cell[4227, 182, 59, 1, 28, "Input"],
Cell[4289, 185, 205, 5, 42, "SmallText"],
Cell[4497, 192, 121, 5, 36, "Input"],
Cell[4621, 199, 66, 1, 28, "Input"],
Cell[4690, 202, 225, 10, 36, "Input"],
Cell[4918, 214, 66, 1, 28, "Input"],
Cell[4987, 217, 161, 5, 42, "SmallText"],
Cell[5151, 224, 123, 5, 48, "Input"],
Cell[5277, 231, 103, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[5417, 238, 166, 5, 59, "Section"],
Cell[5586, 245, 155, 3, 42, "SmallText"],
Cell[5744, 250, 526, 20, 44, "Input"],
Cell[6273, 272, 57, 1, 28, "Input"],
Cell[6333, 275, 604, 23, 45, "Input"],
Cell[6940, 300, 138, 4, 42, "SmallText"],
Cell[7081, 306, 261, 8, 28, "Input"],
Cell[7345, 316, 210, 6, 59, "SmallText"],
Cell[7558, 324, 137, 4, 28, "Input"],
Cell[7698, 330, 405, 10, 76, "SmallText"],
Cell[8106, 342, 60, 1, 28, "Input"],
Cell[8169, 345, 63, 1, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[8269, 351, 57, 0, 35, "Section"],
Cell[8329, 353, 244, 4, 59, "SmallText"],
Cell[8576, 359, 94, 2, 28, "Input"],
Cell[8673, 363, 192, 6, 30, "Input"],
Cell[8868, 371, 84, 2, 28, "Input"],
Cell[8955, 375, 58, 1, 28, "Input"],
Cell[9016, 378, 212, 7, 28, "Input"],
Cell[9231, 387, 263, 8, 28, "Input"],
Cell[9497, 397, 167, 5, 28, "Input"],
Cell[9667, 404, 192, 4, 59, "SmallText"],
Cell[9862, 410, 130, 5, 39, "Input"],
Cell[9995, 417, 61, 1, 28, "Input"],
Cell[10059, 420, 97, 2, 28, "Input"],
Cell[10159, 424, 350, 9, 59, "SmallText"],
Cell[10512, 435, 494, 18, 52, "Input"],
Cell[11009, 455, 99, 3, 28, "Input"],
Cell[11111, 460, 157, 5, 30, "Input"],
Cell[11271, 467, 83, 2, 28, "Input"],
Cell[11357, 471, 347, 8, 76, "SmallText"],
Cell[11707, 481, 122, 4, 28, "Input"],
Cell[11832, 487, 695, 14, 178, "SmallText"],
Cell[12530, 503, 207, 7, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12774, 515, 117, 4, 35, "Section"],
Cell[12894, 521, 167, 5, 42, "SmallText"],
Cell[13064, 528, 76, 1, 28, "Input"],
Cell[13143, 531, 100, 3, 28, "Input"],
Cell[13246, 536, 237, 8, 30, "Input"],
Cell[13486, 546, 180, 6, 43, "Input"],
Cell[13669, 554, 180, 6, 43, "Input"],
Cell[13852, 562, 575, 11, 127, "SmallText"],
Cell[14430, 575, 314, 11, 47, "Input"],
Cell[14747, 588, 106, 3, 41, "Input"],
Cell[14856, 593, 78, 2, 28, "Input"],
Cell[14937, 597, 188, 5, 42, "SmallText"],
Cell[15128, 604, 107, 3, 41, "Input"],
Cell[15238, 609, 386, 10, 76, "SmallText"],
Cell[15627, 621, 163, 5, 28, "Input"],
Cell[15793, 628, 67, 0, 42, "SmallText"],
Cell[15863, 630, 163, 5, 41, "Input"],
Cell[16029, 637, 277, 9, 45, "Input"],
Cell[16309, 648, 296, 9, 28, "Input"],
Cell[16608, 659, 163, 5, 30, "Input"],
Cell[16774, 666, 130, 4, 52, "Input"],
Cell[16907, 672, 257, 8, 28, "Input"],
Cell[17167, 682, 247, 8, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[17451, 695, 106, 5, 35, "Section"],
Cell[17560, 702, 76, 1, 28, "Input"],
Cell[17639, 705, 141, 4, 28, "Input"],
Cell[17783, 711, 55, 1, 28, "Input"],
Cell[17841, 714, 62, 1, 28, "Input"],
Cell[17906, 717, 38, 0, 28, "Input"],
Cell[17947, 719, 132, 4, 30, "Input"],
Cell[18082, 725, 128, 4, 30, "Input"],
Cell[18213, 731, 208, 7, 30, "Input"],
Cell[18424, 740, 98, 2, 28, "Input"],
Cell[18525, 744, 177, 5, 28, "Input"],
Cell[18705, 751, 161, 5, 36, "Input"],
Cell[18869, 758, 214, 6, 49, "Input"],
Cell[19086, 766, 146, 4, 28, "Input"],
Cell[19235, 772, 604, 15, 127, "SmallText"],
Cell[19842, 789, 183, 2, 69, "Input"],
Cell[20028, 793, 742, 16, 127, "SmallText"],
Cell[20773, 811, 74, 1, 28, "Input"],
Cell[20850, 814, 189, 2, 69, "Input"],
Cell[21042, 818, 400, 12, 59, "SmallText"],
Cell[21445, 832, 159, 2, 49, "Input"],
Cell[21607, 836, 48, 1, 28, "Input"],
Cell[21658, 839, 47, 1, 28, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
