(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48079,       1842]
NotebookOptionsPosition[     38743,       1571]
NotebookOutlinePosition[     39169,       1590]
CellTagsIndexPosition[     39126,       1587]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Listen", "Title"],

Cell[CellGroupData[{

Cell[TextData[{
 "Listen im allt\[ADoubleDot]glichen Umgang mit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"4", "y"}]}], "\[Equal]", "6"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "-", "y"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"3", "x"}], "]"}], "3"], ",", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"5", "x"}], "]"}], "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Iteratoren", "Subsection"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "4", ",", 
     FractionBox["1", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["i", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Range", "[", "5", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"3", ",", "5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"3", ",", "5", ",", "0.3"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Listen erzeugen", "Subsection"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["x", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "2"], "&"}], ",", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "4"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["x", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "50", ",", "10"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SuperscriptBox["x", "y"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "2", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SuperscriptBox["x", "y"], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "2", ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", " ", "//", " ", "Grid"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["n", "m"], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     SuperscriptBox["n", "m"], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      SuperscriptBox["x", "n"], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "l"}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   SuperscriptBox["x", "3"]}], ";"}], "\[IndentingNewLine]", "l"}], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"x", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"x", ",", "5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Length", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"l", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Depth", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Depth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "c"}]}], "]"}], ",", 
   RowBox[{"Depth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "/", "c"}]}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"c", "+", "d"}]}], "}"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auf Listenelemente zugreifen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "\[LeftDoubleBracket]", "0", 
  "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4"}], "}"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", "2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "4"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"2", ";;", "4"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", " ", "//", "Grid"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", "1", ",", "3"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"l", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a", ",", 
     SuperscriptBox["b", "c"], ",", 
     SqrtBox["3"]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Head", "[", "l", "]"}], ",", " ", 
   RowBox[{"First", "[", "l", "]"}], ",", 
   RowBox[{"Last", "[", "l", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Funktionen und Listen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"5", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"d", ",", "e", ",", "f"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    FractionBox["i", 
     RowBox[{"i", "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "//", "N"}]], "Input"],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]]], "Input"],

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Listen manipulieren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"l", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ";"}], 
  " "}]], "Input"],

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{"l", ",", "7"}], "]"}]], "Input"],

Cell[BoxData["l"], "Input"],

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{"l", ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"First", "[", "l", "]"}], ",", 
   RowBox[{"Rest", "[", "l", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "5", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Flatten", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"l", ",", "1"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", "100"}], "]"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Partition", "[", 
  RowBox[{"l", ",", "5"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"l", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}], "&"}],
   "/@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "i"}], "+", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "5"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Thread", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Transpose", "[", "l", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"l", "\[LeftDoubleBracket]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "#"}], "\[RightDoubleBracket]"}], 
   "&"}], "/@", 
  RowBox[{"Range", "[", "3", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "==", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], " ", "//", 
  "Thread"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"glsys", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{"y", "-", "z"}], ",", 
      RowBox[{"z", "+", 
       RowBox[{"2", "x"}]}]}], "}"}], "==", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"glsys", "//", "Thread"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"glsys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitutionslisten", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"gls", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}], "\[Equal]", "3"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x"}], "\[Equal]", "3"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"gls", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "#"}], "&"}], ",", "sol"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "i"], "+", " ", 
         SuperscriptBox["y", "i"]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], "/.", "#"}], 
     "&"}], ",", "sol"}], "]"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "i"], "+", " ", 
      SuperscriptBox["y", "i"]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], "/.", "sol"}], "//", 
  "Expand"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Beispiel: Nullstellen eines Polynoms \[UDoubleDot]ber ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "p"], TraditionalForm]]]
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"primeList", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", "50", "]"}], ",", "PrimeQ"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"werteTafel", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "3"], "+", "x", "+", "1"}], ",", "31"}], "]"}]}],
      "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "30"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"werteTafel", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
     "\[Equal]", "0"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
    "&"}], ",", "%"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "30"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["#", "3"], "+", "#", "+", "1"}], ",", "31"}], "]"}], 
     "\[Equal]", "0"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "[", 
   RowBox[{"p_", "?", "PrimeQ"}], "]"}], ":=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"p", "-", "1"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "3"], "+", "#", "+", "1"}], ",", "p"}], "]"}], 
      "\[Equal]", "0"}], "&"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "sol"}]], "Input"],

Cell[BoxData[
 RowBox[{"sol", "[", "13", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"sol", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
  "primeList"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "3"], "+", "x", "+", "1"}], ",", 
       RowBox[{"Modulus", "\[Rule]", "#"}]}], "]"}]}], "}"}], "&"}], "/@", 
  "primeList"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Beispiel: Punkte auf einer elliptischen Kurve \[UDoubleDot]ber ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "p"], TraditionalForm]]]
}], "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{"l1", ",", "4"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"Join", "@@", "l1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{"l2", ",", "5"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"ec11", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"l2", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "2"], "-", 
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "3"], "-", "1"}], ",", "11"}], "]"}], "\[Equal]", "0"}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ec11", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "2"], "-", 
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "3"], "-", "1"}], ",", "11"}], "]"}], "\[Equal]", "0"}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"ec11", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ec", "[", 
   RowBox[{"p_", "?", "PrimeQ"}], "]"}], ":=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Join", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "p"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "p"}], "}"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           "2"], "-", 
         SuperscriptBox[
          RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "3"], "-", "1"}], ",", "p"}], "]"}], "\[Equal]", "0"}], "&"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"primeList", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Range", "[", "50", "]"}], ",", "PrimeQ"}], "]"}]}], ";", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"ec", "[", "#", "]"}], "]"}]}], "}"}], "&"}], ",", 
    "primeList"}], "]"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Teillisten und Muster", "Section"],

Cell[CellGroupData[{

Cell["Select, MatchQ und Cases", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a", ",", 
     SuperscriptBox["b", "c"], ",", 
     SuperscriptBox["d", "3"], ",", 
     RowBox[{"e", "+", "f"}], ",", 
     SqrtBox["3"]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["_", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      SuperscriptBox["_", "_"]}], "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["x_", "y_Integer"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      SuperscriptBox["_", "_Integer"]}], "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    SuperscriptBox["x_", "y_Integer"], "\[Rule]", 
    SuperscriptBox["x", 
     RowBox[{"2", "y"}]]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{"l", ",", 
    RowBox[{
     RowBox[{"MatchQ", "[", 
      RowBox[{"#", ",", 
       SuperscriptBox["_", "_Integer"]}], "]"}], "&"}]}], "]"}], "/.", 
  RowBox[{
   SuperscriptBox["x_", "y_Integer"], "\[Rule]", 
   SuperscriptBox["x", 
    RowBox[{"2", "y"}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["_", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"l", ",", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"#", ",", 
       SuperscriptBox["_", "_"]}], "]"}]}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{"12", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "5"]}], "//", "Expand"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"u", ",", 
   RowBox[{"12", 
    SuperscriptBox["_", "_"]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"u", ",", 
   RowBox[{"__", " ", "_"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"u", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"_", " ", "__"}]}], "]"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"List", "@@", "%"}]], "Input"],

Cell[BoxData["l"], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Listenkommandos", "Subsection"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", "_Symbol"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{"l", ",", "_Symbol"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"l", ",", "_Times"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"l", ",", "_Power"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"l", ",", "_Times"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{"u", ",", "_Times"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"u", ",", "_Power"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"u", ",", "_Power"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Zusammengesetzte Muster und Defaultmuster", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     SuperscriptBox["x", "2"], ",", 
     SuperscriptBox["a", 
      RowBox[{"b", "+", "c"}]], ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], 
      RowBox[{"c", "+", "d"}]]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    SuperscriptBox["x_", "_"], "]"}], ":=", 
   RowBox[{"x", "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "l"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ":", 
     SuperscriptBox["_", "_"]}], "]"}], ":=", 
   RowBox[{"x", "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "l"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     SuperscriptBox["x", "2"], ",", "a", ",", 
     RowBox[{"a", " ", "x"}], ",", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["x", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   SuperscriptBox["x", "_."]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   RowBox[{"_", " ", 
    SuperscriptBox["x", "_."]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"l", ",", 
   RowBox[{"_.", 
    SuperscriptBox["x", "_."]}]}], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spezielle listenbasierte Datenstrukturen", "Section"],

Cell[CellGroupData[{

Cell["Mengen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ";", " ", 
  RowBox[{"l2", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "4", ",", "3"}], "}"}]}], ";", 
  RowBox[{"l3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "1", ",", "2"}], "}"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"l1", "\[Union]", "l2"}]], "Input"],

Cell[BoxData[
 RowBox[{"Union", "[", "l3", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l3", "\[Union]", 
  RowBox[{"{", "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l1", "\[Intersection]", "l2"}]], "Input"],

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"l1", ",", "l2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"l1", ",", "1"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Vektoren und Matrizen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11", ",", "12"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"m", "//", "MatrixForm"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", "v"}], "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"v", ".", "v"}]], "Input"],

Cell[BoxData[
 RowBox[{"Dimensions", "[", "m", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"ml", "=", 
    RowBox[{"Transpose", "[", "m", "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"ml", "//", "Dimensions"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Beispiele", "Section"],

Cell[CellGroupData[{

Cell["\<\
Komplexe Zahlen in Real- und Imagin\[ADoubleDot]rteil aufspalten\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", "Complex", "]"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"l", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
      "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"l", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"Length", "[", "l", "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], ",", "l"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "#", "]"}], ",", 
     RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], " ", "/@", " ", 
  "l"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Re", "[", "l", "]"}], ",", " ", 
    RowBox[{"Im", "[", "l", "]"}]}], "}"}], "//", "Thread"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Komplexe Zahlen aus zwei Listen konstruieren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Random", "[", "]"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Random", "[", "]"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"l", "\[LeftDoubleBracket]", 
     RowBox[{"1", ",", "i"}], "\[RightDoubleBracket]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"l", "\[LeftDoubleBracket]", 
      RowBox[{"2", ",", "i"}], "\[RightDoubleBracket]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
    
    RowBox[{"I", " ", 
     RowBox[{"#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
   "&"}], "/@", 
  RowBox[{"Thread", "[", "l", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Apply", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", "+", 
        RowBox[{"I", " ", "#2"}]}], "&"}], ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"Transpose", "[", "l", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",",
      
     RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
    "}"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "->", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#1", "+", 
      RowBox[{"I", "#2"}]}], ")"}], "&"}], ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#1", "+", 
      RowBox[{"I", "#2"}]}], ")"}], "&"}], "[", 
   RowBox[{
    RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
    
    RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"#1", "+", 
     RowBox[{"I", "#2"}]}], ")"}], "&"}], "[", 
  RowBox[{
   RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
  RowBox[{"I", " ", 
   RowBox[{
   "l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Gleitender Durchschnitt", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", "20"}], "]"}], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sublists", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"l", "\[LeftDoubleBracket]", 
     RowBox[{"i", "+", 
      RowBox[{"Range", "[", "4", "]"}]}], "\[RightDoubleBracket]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "6"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"l", ",", "4", ",", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"sums", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Apply", "[", 
     RowBox[{"Plus", ",", "#"}], "]"}], "&"}], "/@", "sublists"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", "sublists", ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"sums", "/", "4"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gleitenderDurchschnitt", "[", 
   RowBox[{"l_List", ",", 
    RowBox[{"n_Integer", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", ">", "0"}], "&"}], ")"}]}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Apply", "[", 
       RowBox[{"Plus", ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"l", "\[LeftDoubleBracket]", 
        RowBox[{"i", "+", 
         RowBox[{"Range", "[", "n", "]"}]}], "\[RightDoubleBracket]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{
          RowBox[{"Length", "[", "l", "]"}], "-", "n"}]}], "}"}]}], "]"}]}], 
    ")"}], "/", "n"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"Sin", "[", "x", "]"}]}], "+", 
        RowBox[{"Random", "[", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Pi]", ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"gleitenderDurchschnitt", "[", 
    RowBox[{"l1", ",", "20"}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"l1", ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"l2", ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], "}"}], "]"}]}], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{537, 594},
WindowMargins->{{Automatic, 186}, {Automatic, 42}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 23, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[638, 27, 135, 5, 79, "Section"],
Cell[776, 34, 76, 1, 28, "Input"],
Cell[855, 37, 138, 4, 30, "Input"],
Cell[996, 43, 350, 12, 28, "Input"],
Cell[1349, 57, 397, 13, 43, "Input"],
Cell[CellGroupData[{
Cell[1771, 74, 32, 0, 45, "Subsection"],
Cell[1806, 76, 130, 4, 30, "Input"],
Cell[1939, 82, 155, 5, 30, "Input"],
Cell[2097, 89, 165, 5, 30, "Input"],
Cell[2265, 96, 199, 6, 42, "Input"],
Cell[2467, 104, 196, 6, 30, "Input"],
Cell[2666, 112, 58, 1, 28, "Input"],
Cell[2727, 115, 81, 2, 28, "Input"],
Cell[2811, 119, 93, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[2941, 126, 37, 0, 29, "Subsection"],
Cell[2981, 128, 126, 3, 28, "Input"],
Cell[3110, 133, 192, 6, 30, "Input"],
Cell[3305, 141, 182, 6, 30, "Input"],
Cell[3490, 149, 204, 6, 30, "Input"],
Cell[3697, 157, 263, 8, 28, "Input"],
Cell[3963, 167, 319, 10, 28, "Input"],
Cell[4285, 179, 63, 1, 28, "Input"],
Cell[4351, 182, 234, 7, 28, "Input"],
Cell[4588, 191, 288, 9, 28, "Input"],
Cell[4879, 202, 281, 9, 49, "Input"],
Cell[5163, 213, 153, 4, 52, "Input"],
Cell[5319, 219, 169, 5, 28, "Input"],
Cell[5491, 226, 81, 2, 28, "Input"],
Cell[5575, 230, 318, 11, 28, "Input"],
Cell[5896, 243, 59, 1, 28, "Input"],
Cell[5958, 246, 129, 3, 28, "Input"],
Cell[6090, 251, 92, 2, 28, "Input"],
Cell[6185, 255, 115, 3, 28, "Input"],
Cell[6303, 260, 58, 1, 28, "Input"],
Cell[6364, 263, 240, 8, 28, "Input"],
Cell[6607, 273, 140, 4, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6784, 282, 50, 0, 29, "Subsection"],
Cell[6837, 284, 136, 4, 28, "Input"],
Cell[6976, 290, 93, 1, 28, "Input"],
Cell[7072, 293, 111, 2, 28, "Input"],
Cell[7186, 297, 93, 1, 28, "Input"],
Cell[7282, 300, 143, 4, 28, "Input"],
Cell[7428, 306, 140, 3, 28, "Input"],
Cell[7571, 311, 80, 2, 28, "Input"],
Cell[7654, 315, 129, 4, 28, "Input"],
Cell[7786, 321, 138, 4, 28, "Input"],
Cell[7927, 327, 117, 2, 28, "Input"],
Cell[8047, 331, 315, 10, 28, "Input"],
Cell[8365, 343, 58, 1, 28, "Input"],
Cell[8426, 346, 93, 1, 28, "Input"],
Cell[8522, 349, 116, 2, 28, "Input"],
Cell[8641, 353, 90, 2, 28, "Input"],
Cell[8734, 357, 214, 6, 28, "Input"],
Cell[8951, 365, 188, 6, 28, "Input"],
Cell[9142, 373, 178, 6, 36, "Input"],
Cell[9323, 381, 184, 5, 28, "Input"],
Cell[9510, 388, 80, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[9627, 395, 43, 0, 29, "Subsection"],
Cell[9673, 397, 76, 1, 28, "Input"],
Cell[9752, 400, 138, 4, 28, "Input"],
Cell[9893, 406, 107, 3, 28, "Input"],
Cell[10003, 411, 101, 3, 28, "Input"],
Cell[10107, 416, 66, 1, 28, "Input"],
Cell[10176, 419, 163, 5, 28, "Input"],
Cell[10342, 426, 205, 7, 42, "Input"],
Cell[10550, 435, 50, 1, 28, "Input"],
Cell[10603, 438, 127, 3, 30, "Input"],
Cell[10733, 443, 140, 4, 28, "Input"],
Cell[10876, 449, 107, 3, 28, "Input"],
Cell[10986, 454, 113, 3, 28, "Input"],
Cell[11102, 459, 112, 3, 28, "Input"],
Cell[11217, 464, 115, 3, 28, "Input"],
Cell[11335, 469, 112, 3, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11484, 477, 41, 0, 29, "Subsection"],
Cell[11528, 479, 76, 1, 28, "Input"],
Cell[11607, 482, 160, 6, 28, "Input"],
Cell[11770, 490, 82, 2, 28, "Input"],
Cell[11855, 494, 27, 0, 28, "Input"],
Cell[11885, 496, 83, 2, 28, "Input"],
Cell[11971, 500, 137, 4, 28, "Input"],
Cell[12111, 506, 218, 6, 28, "Input"],
Cell[12332, 514, 450, 16, 28, "Input"],
Cell[12785, 532, 60, 1, 28, "Input"],
Cell[12848, 535, 83, 2, 28, "Input"],
Cell[12934, 539, 311, 9, 49, "Input"],
Cell[13248, 550, 373, 12, 28, "Input"],
Cell[13624, 564, 218, 7, 28, "Input"],
Cell[13845, 573, 59, 1, 28, "Input"],
Cell[13907, 576, 62, 1, 28, "Input"],
Cell[13972, 579, 250, 8, 28, "Input"],
Cell[14225, 589, 163, 5, 28, "Input"],
Cell[14391, 596, 170, 5, 28, "Input"],
Cell[14564, 603, 205, 7, 28, "Input"],
Cell[14772, 612, 387, 13, 49, "Input"],
Cell[15162, 627, 144, 4, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[15343, 636, 41, 0, 29, "Subsection"],
Cell[15387, 638, 76, 1, 28, "Input"],
Cell[15466, 641, 274, 10, 30, "Input"],
Cell[15743, 653, 160, 5, 28, "Input"],
Cell[15906, 660, 182, 7, 28, "Input"],
Cell[16091, 669, 99, 3, 28, "Input"],
Cell[16193, 674, 393, 13, 46, "Input"],
Cell[16589, 689, 292, 10, 46, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16930, 705, 161, 5, 60, "Section"],
Cell[17094, 712, 76, 1, 28, "Input"],
Cell[17173, 715, 154, 4, 28, "Input"],
Cell[17330, 721, 366, 12, 30, "Input"],
Cell[17699, 735, 218, 6, 28, "Input"],
Cell[17920, 743, 172, 5, 28, "Input"],
Cell[18095, 750, 327, 11, 30, "Input"],
Cell[18425, 763, 446, 15, 30, "Input"],
Cell[18874, 780, 46, 1, 28, "Input"],
Cell[18923, 783, 57, 1, 28, "Input"],
Cell[18983, 786, 161, 6, 28, "Input"],
Cell[19147, 794, 299, 10, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[19483, 809, 170, 5, 61, "Section"],
Cell[19656, 816, 76, 1, 28, "Input"],
Cell[19735, 819, 405, 13, 49, "Input"],
Cell[20143, 834, 182, 5, 49, "Input"],
Cell[20328, 841, 503, 15, 30, "Input"],
Cell[20834, 858, 844, 26, 50, "Input"],
Cell[21681, 886, 166, 4, 28, "Input"],
Cell[21850, 892, 830, 26, 50, "Input"],
Cell[22683, 920, 393, 13, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[23113, 938, 40, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[23178, 942, 46, 0, 45, "Subsection"],
Cell[23227, 944, 251, 8, 36, "Input"],
Cell[23481, 954, 106, 3, 28, "Input"],
Cell[23590, 959, 190, 6, 28, "Input"],
Cell[23783, 967, 115, 3, 30, "Input"],
Cell[23901, 972, 197, 6, 30, "Input"],
Cell[24101, 980, 193, 6, 30, "Input"],
Cell[24297, 988, 334, 11, 30, "Input"],
Cell[24634, 1001, 112, 3, 28, "Input"],
Cell[24749, 1006, 213, 7, 28, "Input"],
Cell[24965, 1015, 177, 6, 46, "Input"],
Cell[25145, 1023, 127, 4, 44, "Input"],
Cell[25275, 1029, 106, 3, 44, "Input"],
Cell[25384, 1034, 190, 6, 44, "Input"],
Cell[25577, 1042, 53, 1, 44, "Input"],
Cell[25633, 1045, 27, 0, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[25697, 1050, 45, 0, 29, "Subsection"],
Cell[25745, 1052, 87, 2, 28, "Input"],
Cell[25835, 1056, 87, 2, 28, "Input"],
Cell[25925, 1060, 88, 2, 28, "Input"],
Cell[26016, 1064, 86, 2, 28, "Input"],
Cell[26105, 1068, 86, 2, 28, "Input"],
Cell[26194, 1072, 86, 2, 28, "Input"],
Cell[26283, 1076, 88, 2, 28, "Input"],
Cell[26374, 1080, 86, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26497, 1087, 63, 0, 29, "Subsection"],
Cell[26563, 1089, 326, 11, 30, "Input"],
Cell[26892, 1102, 307, 9, 69, "Input"],
Cell[27202, 1113, 332, 10, 69, "Input"],
Cell[27537, 1125, 263, 8, 30, "Input"],
Cell[27803, 1135, 106, 3, 28, "Input"],
Cell[27912, 1140, 107, 3, 44, "Input"],
Cell[28022, 1145, 132, 4, 44, "Input"],
Cell[28157, 1151, 128, 4, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28334, 1161, 59, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[28418, 1165, 28, 0, 45, "Subsection"],
Cell[28449, 1167, 76, 1, 28, "Input"],
Cell[28528, 1170, 361, 11, 28, "Input"],
Cell[28892, 1183, 58, 1, 28, "Input"],
Cell[28953, 1186, 59, 1, 28, "Input"],
Cell[29015, 1189, 75, 2, 28, "Input"],
Cell[29093, 1193, 65, 1, 28, "Input"],
Cell[29161, 1196, 88, 2, 28, "Input"],
Cell[29252, 1200, 84, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[29373, 1207, 43, 0, 29, "Subsection"],
Cell[29419, 1209, 76, 1, 28, "Input"],
Cell[29498, 1212, 142, 4, 28, "Input"],
Cell[29643, 1218, 183, 6, 28, "Input"],
Cell[29829, 1226, 209, 7, 28, "Input"],
Cell[30041, 1235, 219, 7, 28, "Input"],
Cell[30263, 1244, 456, 14, 49, "Input"],
Cell[30722, 1260, 82, 2, 28, "Input"],
Cell[30807, 1264, 49, 1, 44, "Input"],
Cell[30859, 1267, 63, 1, 44, "Input"],
Cell[30925, 1270, 148, 5, 44, "Input"],
Cell[31076, 1277, 60, 1, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31185, 1284, 36, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[31246, 1288, 94, 2, 45, "Subsection"],
Cell[31343, 1292, 76, 1, 28, "Input"],
Cell[31422, 1295, 171, 5, 28, "Input"],
Cell[31596, 1302, 435, 13, 28, "Input"],
Cell[32034, 1317, 223, 8, 28, "Input"],
Cell[32260, 1327, 194, 7, 28, "Input"],
Cell[32457, 1336, 169, 5, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[32663, 1346, 66, 0, 29, "Subsection"],
Cell[32732, 1348, 76, 1, 28, "Input"],
Cell[32811, 1351, 334, 11, 28, "Input"],
Cell[33148, 1364, 485, 13, 28, "Input"],
Cell[33636, 1379, 298, 9, 28, "Input"],
Cell[33937, 1390, 276, 9, 28, "Input"],
Cell[34216, 1401, 407, 13, 28, "Input"],
Cell[34626, 1416, 175, 6, 44, "Input"],
Cell[34804, 1424, 352, 11, 44, "Input"],
Cell[35159, 1437, 306, 9, 44, "Input"],
Cell[35468, 1448, 211, 5, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[35716, 1458, 45, 0, 29, "Subsection"],
Cell[35764, 1460, 76, 1, 28, "Input"],
Cell[35843, 1463, 199, 6, 28, "Input"],
Cell[36045, 1471, 304, 8, 28, "Input"],
Cell[36352, 1481, 95, 2, 28, "Input"],
Cell[36450, 1485, 165, 5, 28, "Input"],
Cell[36618, 1492, 125, 3, 44, "Input"],
Cell[36746, 1497, 52, 1, 44, "Input"],
Cell[36801, 1500, 769, 24, 85, "Input"],
Cell[37573, 1526, 385, 13, 44, "Input"],
Cell[37961, 1541, 145, 4, 44, "Input"],
Cell[38109, 1547, 594, 19, 85, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
