(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48478,       1679]
NotebookOptionsPosition[     42097,       1492]
NotebookOutlinePosition[     42836,       1519]
CellTagsIndexPosition[     42793,       1516]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Mathematik mit dem Computer", "Title"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Texte und mathematische Texte"
}], "Section"],

Cell[TextData[{
 "Zum Austausch mit anderen Dokumenten ist es oftmals n\[UDoubleDot]tzlich, \
die Ausgaben der Kommandos nicht in der zweidimensionalen ",
 StyleBox["OutputForm",
  FontWeight->"Bold"],
 ", sondern in der eindimensionalen ",
 StyleBox["InputForm",
  FontWeight->"Bold"],
 " ausgeben zu lassen."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$PrePrint", "=", "InputForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "3"], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", "$PrePrint", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "3"], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematische Experimente und mathematische Beweise", "Section"],

Cell[TextData[{
 "Mathematik zu treiben bedeutet, einerseits mathematische ",
 StyleBox["Regelm\[ADoubleDot]\[SZ]igkeiten und Zusammenh\[ADoubleDot]nge",
  FontSlant->"Italic"],
 " zu entdecken und andererseits diese Beobachtungen mit (streng deduktiven \
Anspr\[UDoubleDot]chen gen\[UDoubleDot]genden) ",
 StyleBox["Beweisen ",
  FontSlant->"Italic"],
 "zu Gesetzm\[ADoubleDot]\[SZ]igkeiten zu verdichten. F\[UDoubleDot]r beide \
Phasen des \"Doing Mathematics\"  bietet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vielf\[ADoubleDot]ltige Unterst\[UDoubleDot]tzung."
}], "SmallText"],

Cell[CellGroupData[{

Cell["Beispiel 1: Potenzreste", "Subsection"],

Cell[BoxData[
 SuperscriptBox["3", "100"]], "Input"],

Cell[BoxData[
 SuperscriptBox["3", 
  SuperscriptBox["10", "10"]]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     SuperscriptBox["3", "k"], ",", "10"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     SuperscriptBox["3", "k"], ",", "7"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     SuperscriptBox["3", "k"], ",", "17"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   SuperscriptBox["10", "10"], ",", "10"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   SuperscriptBox["10", "10"], ",", 
   SuperscriptBox["10", "15"]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Beispiel 2: Perfekte Zahlen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DivisorSum", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", 
    RowBox[{"Divisors", "[", "n", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "2"}], ",", 
   RowBox[{"i", "<", "800"}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DivisorSum", "[", "i", "]"}], "\[Equal]", 
      RowBox[{"2", "i"}]}], ",", 
     RowBox[{"Print", "[", "i", "]"}]}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "800", "]"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DivisorSum", "[", "#", "]"}], "\[Equal]", 
      RowBox[{"2", "#"}]}], ")"}], "&"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tb", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", "=", 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"k", "-", "1"}]], 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["2", "k"], "-", "1"}], ")"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"DivisorSum", "[", "n", "]"}], "\[Equal]", 
          RowBox[{"2", "n"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "n", ",", "\"\<ja\>\""}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "n", ",", "\"\<nein\>\""}], "}"}]}], "]"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "2", ",", "40"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Prepend", "[", 
    RowBox[{"tb", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<k\>\"", ",", "\"\<n\>\"", ",", "\"\<Perfekte Zahl\>\""}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", "True", "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", 
        RowBox[{"{", "False", "}"}], ",", "True"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"4", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", 
        RowBox[{"{", ".5", "}"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Right", "}"}], ",", "Center"}], "}"}], "}"}]}]}], 
  "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Beispiel 3: Der Vietasche Wurzelsatz", "Subsection"],

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "7"], "-", 
      RowBox[{"3", 
       SuperscriptBox["x", "6"]}], "+", "x", "-", "1"}], "\[Equal]", "0"}], 
    ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"x", "/.", "s"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", "a", " ", "x"}], "+", "b"}], "\[Equal]", "0"}], ",", 
     "x"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "+", 
  RowBox[{
  "s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   RowBox[{"s", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], "//",
   "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"x", "-", 
        SubscriptBox["x", "i"]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Programmierung ", "Section"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stellt eine voll ausgebaute imperative Programmiersprache zur Verf\
\[UDoubleDot]gung, die um (effizient implementierte) Elemente einer \
funktionalen Programmiersprache erweitert ist, und die vor allem beim \
Arbeiten mit rekursiv definierten Datenstrukturen wie z.B. Listen hilfreich \
sind. Der eingebaute Patternmatcher erlaubt regelbasiertes Programmieren, das \
 besonders f\[UDoubleDot]r die gezielte Simplifikation von \
Ausdr\[UDoubleDot]cken eingesetzt werden kann. Konzepte der Modularisierung, \
Kapselung, Paketbildung sowie inkrementelle Kompilierung stehen nicht nur den \
Entwicklern, sondern auch den Anwendern zur Verf\[UDoubleDot]gung."
}], "SmallText"],

Cell[CellGroupData[{

Cell["Steuerstrukturen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "3"}], ",", "x", ",", 
    RowBox[{"x", "+", "1"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"x", 
      RowBox[{"x", "<", "3"}]},
     {
      RowBox[{"x", "+", "1"}], "True"}
    }]}]}]], "Input"],

Cell["oder", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", "<", "3"}]}], "}"}], "}"}], ",", 
    RowBox[{"x", "+", "1"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[TextData[{
 "Meist werden die mathematischen EIgenschaften st\[UDoubleDot]ckweiser \
Funktionen von ",
 StyleBox["Piecewise",
  FontWeight->"Bold"],
 " pr\[ADoubleDot]ziser ber\[UDoubleDot]cksichtigt als in ",
 StyleBox["If",
  FontWeight->"Bold"],
 "-Konstrukten. \nHier etwa wird die Ableitung mathematisch \
pr\[ADoubleDot]ziser ermittelt und auch deren Graph ist an den Sprungstellen \
richtig dargestellt."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "1"}], ",", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", "3"}], ",", 
    RowBox[{"6", "-", 
     SuperscriptBox["x", "2"]}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "3"}], ",", 
       RowBox[{"x", "<", "1"}]}], "}"}], "}"}], ",", 
    RowBox[{"6", "-", 
     SuperscriptBox["x", "2"]}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f1", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "'"}], "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f1", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f2", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f1", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f2", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell["\<\
Allerdings hilft das nicht immer. Hier wird beim Bestimmen der Ableitung in \
beiden F\[ADoubleDot]llen offensichtlich das boolesche Pr\[ADoubleDot]dikat \
zu fr\[UDoubleDot]h ausgewertet.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"OddQ", "[", 
     RowBox[{"Floor", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"x", "+", "1"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"g2", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", "1"}], ",", 
       RowBox[{"OddQ", "[", 
        RowBox[{"Floor", "[", "x", "]"}], "]"}]}], "}"}], "}"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"g2", "'"}], "[", "x", "]"}]}], "}"}]], "Input"],

Cell["\<\
Auch der Graph ist in beiden Varianten eine durchgezogene Linie.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g1", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g2", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell["\<\
Und selbst die numerische Auswertung ergibt f\[UDoubleDot]r die Ableitung ein \
falsches Bild.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g2", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"],

Cell[TextData[{
 "Damit es funktioniert muss ",
 StyleBox["OddQ",
  FontWeight->"Bold"],
 " durch ein \"weicheres\" boolesches Pr\[ADoubleDot]dikat ersetzt werden. \
Wir verwenden hier eine Version mit Equal (==)."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Floor", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]", "1"}],
     ",", 
    RowBox[{"x", "+", "1"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"g2", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", "1"}], ",", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"Floor", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]", 
        "1"}]}], "}"}], "}"}], ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"g2", "'"}], "[", "x", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g1", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"g2", "'"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Funktionsdefinitionen und Bl\[ODoubleDot]cke\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"3", "x"}], "+", "5"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mySqrt", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "x"}], " ", ",", 
      RowBox[{"z", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"y", "-", "z"}], "]"}], ">", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], ",", 
       RowBox[{
        RowBox[{"y", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "+", "z"}], ")"}], "/", "2."}]}], ";", 
        RowBox[{"z", "=", 
         RowBox[{"x", "/", "y"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "y"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"mySqrt", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "12", ",", "1221", ",", "21121121"}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"mySqrt", "[", "x", "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Beispiele", "Section"],

Cell[CellGroupData[{

Cell["Symmetrische Polynome", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "[", 
   RowBox[{"d_Integer", ",", "x_List"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "x", "]"}], "<", "d"}], ",", "0", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"d", "\[Equal]", "1"}], ",", 
      RowBox[{"Apply", "[", 
       RowBox[{"Plus", ",", "x"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{"e", "[", 
         RowBox[{"d", ",", 
          RowBox[{"Rest", "[", "x", "]"}]}], "]"}], "+", 
        RowBox[{
         RowBox[{"e", "[", 
          RowBox[{
           RowBox[{"d", "-", "1"}], ",", 
           RowBox[{"Rest", "[", "x", "]"}]}], "]"}], "*", 
         RowBox[{"First", "[", "x", "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"e", "[", 
  RowBox[{"5", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"d_Integer", ",", "x_List"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"d", "\[Equal]", "0"}], ",", "1", ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "x", "]"}], "\[Equal]", "1"}], ",", 
      SuperscriptBox[
       RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
       "d"], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "else", " ", "*)"}], " ", 
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{"h", "[", 
         RowBox[{"d", ",", 
          RowBox[{"Rest", "[", "x", "]"}]}], "]"}], "+", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{
           RowBox[{"d", "-", "1"}], ",", "x"}], "]"}], "*", 
         RowBox[{"First", "[", "x", "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Der Euklidsche Algorithmus", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Euklid", "[", 
   RowBox[{"a0_Integer", ",", "b0_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "a0"}], ",", 
      RowBox[{"b", "=", "b0"}], ",", "q", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"b", "!=", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"q", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "r"}], ")"}], "/", "b"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "a", ",", "\"\< = \>\"", " ", ",", "q", ",", "\"\<*\>\"", ",", "b", 
          ",", "\"\< + \>\"", " ", ",", "r"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"b", ",", "r"}], "}"}]}]}]}], "\[IndentingNewLine]", "]"}], 
     ";", "a"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Euklid", "[", 
  RowBox[{"12", ",", "7"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtendedEuklid", "[", 
   RowBox[{"a0_Integer", ",", "b0_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "a0"}], ",", 
      RowBox[{"b", "=", "b0"}], ",", "q", ",", "r", ",", 
      RowBox[{"ua", "=", "1"}], ",", 
      RowBox[{"ub", "=", "0"}], ",", 
      RowBox[{"va", "=", "0"}], ",", 
      RowBox[{"vb", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"b", "!=", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}], ";", 
        RowBox[{"q", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "r"}], ")"}], "/", "b"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"b", ",", "r"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ua", ",", "ub"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"ub", ",", 
           RowBox[{"ua", "-", 
            RowBox[{"q", "*", "ub"}]}]}], "}"}]}], ";", "\[IndentingNewLine]",
         
        RowBox[{
         RowBox[{"{", 
          RowBox[{"va", ",", "vb"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"vb", ",", 
           RowBox[{"va", "-", 
            RowBox[{"q", "*", "vb"}]}]}], "}"}]}], ";", "\[IndentingNewLine]",
         
        RowBox[{"Print", "[", 
         RowBox[{
         "r", ",", "\"\< = (\>\"", ",", "ub", ",", "\"\<)*\>\"", ",", "a0", 
          ",", "\"\<+(\>\"", ",", "vb", ",", "\"\<)*\>\"", ",", "b0", ",", 
          "\"\< = \>\"", ",", 
          RowBox[{
           RowBox[{"ub", "*", "a0"}], "+", 
           RowBox[{"vb", "*", "b0"}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
      "]"}], ";", 
     RowBox[{"{", 
      RowBox[{"a", ",", "ua", ",", "va"}], "}"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ExtendedEuklid", "[", 
  RowBox[{"12", ",", "7"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ein Grafikbeispiel", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"kreisPunkt", "[", "t_", "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"180", " ", "\[Degree]"}], "-", "t"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"180", " ", "\[Degree]"}], "-", "t"}], "]"}]}], "}"}], 
   "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"w", "=", 
    RowBox[{"230", "\[Degree]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"P2", "=", 
  RowBox[{"kreisPunkt", "[", "w", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"a", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"P2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
    ")"}], "/", 
   RowBox[{
   "P2", "\[LeftDoubleBracket]", "2", 
    "\[RightDoubleBracket]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "a"}], "}"}]}], ";", 
  RowBox[{"P4", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"90", "\[Degree]"}]}], ";", 
  RowBox[{"u", "=", 
   RowBox[{"90", "\[Degree]"}]}], ";"}]}], "Input"],

Cell["\<\
Die Formel f\[UDoubleDot]r die st\[UDoubleDot]ckweise definierte Funktion, \
mit der das Grundger\[UDoubleDot]st der Zwei erzeugt wird.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "t_", "]"}], ":=", 
   RowBox[{"Which", "[", "\n", "       ", 
    RowBox[{
     RowBox[{"t", "\[LessEqual]", "w"}], ",", 
     RowBox[{"kreisPunkt", "[", "t", "]"}], ",", "\n", "       ", 
     RowBox[{"t", "\[LessEqual]", 
      RowBox[{"w", "+", "s"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t", "-", "w"}], ")"}], "/", "s"}]}], ")"}], "P2"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"t", "-", "w"}], ")"}], "/", "s"}], "*", "P3"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"t", "\[LessEqual]", 
      RowBox[{"w", "+", "s", "+", "u"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t", "-", "w", "-", "s"}], ")"}], "/", "u"}]}], ")"}], 
       "P3"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"t", "-", "w", "-", "s"}], ")"}], "/", "u"}], "*", 
       "P4"}]}]}], "]"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Hier noch die 5 fetten Punkte, die Ticks auf den Achsen sowie die \
Beschriftungen als Text-Konstrukte. Die verschiedenen Grafikteile werden mit \
",
 StyleBox["Show",
  FontWeight->"Bold"],
 " gemeinsam angezeigt."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fatPoints", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"P", "[", "0", "]"}], ",", "P2", ",", "P3", ",", "P4"}], "}"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"pointLabels", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "0"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".2"}], ",", 
         RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", 
         RowBox[{"-", "0.2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "2"], ",", 
       RowBox[{"{", 
        RowBox[{"1.0", ",", 
         RowBox[{"-", "1.0"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "3"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.3"}], ",", 
         RowBox[{"-", "2.2"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       SubscriptBox["P", "4"], ",", 
       RowBox[{"{", 
        RowBox[{"1.3", ",", 
         RowBox[{"-", "2.2"}]}], "}"}]}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"tx", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{".1", "i"}], ","}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "30"}], ",", "20"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{".5", "i"}], ",", ",", ".02"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "5"}], ",", "10"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"fatPoints", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", "0.03", "]"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"P", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"w", "+", "s", "+", "u"}]}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", "pointLabels", "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"tx", ",", "tx"}], "}"}]}], ",", 
   RowBox[{"TextStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "20"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"P", "[", "t", "]"}], ",", 
        RowBox[{"P", "[", 
         RowBox[{"t", "+", "s"}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"w", "+", "u"}], ",", " ", 
       RowBox[{"5", " ", "\[Degree]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics", "[", "data", "]"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Berechnung der Kettenbruchentwicklung rationaler Zahlen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearA", 
  RowBox[{"ll", "[", "\"\<Global`*\>\"", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Kettenbruch", "[", "r0_Rational", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "=", "r0"}], ",", 
      RowBox[{"l", "=", 
       RowBox[{"{", "}"}]}], ",", "v"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"r", ",", "_Integer"}], "]"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{
        RowBox[{"v", "=", 
         RowBox[{"Floor", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"r", "-", "v"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"l", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"l", ",", "v"}], "]"}]}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Append", "[", 
      RowBox[{"l", ",", "r"}], "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Probe", "[", "l_List", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "l", "]"}], "==", "1"}], ",", 
    RowBox[{"First", "[", "l", "]"}], ",", 
    RowBox[{
     RowBox[{"First", "[", "l", "]"}], "+", 
     RowBox[{"1", "/", 
      RowBox[{"Probe", "[", 
       RowBox[{"Rest", "[", "l", "]"}], "]"}]}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Kettenbruch", "[", 
  RowBox[{"31", "/", "245"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Probe"}]], "Input"],

Cell["\<\
Und hier eine rekursive Version, die aber auch nicht um einen Block \
herumkommt.  

Die erste Variante liefert mysteri\[ODoubleDot]se Ergebnisse:\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "KRec", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KRec", "[", "r_Rational", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"r", ",", "_Integer"}], "]"}], ",", 
      RowBox[{"{", "r", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"u", "=", 
        RowBox[{"Floor", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"KRec", "[", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", "u"}], ")"}]}], "]"}], ",", "u"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"KRec", "[", 
   RowBox[{"31", "/", "245"}], "]"}]}]], "Input"],

Cell["\<\
Der Grund ist, dass ganze Zahlen _Rational nicht passieren, so dass KRec[3] \
symbolisch bleibt. 
Zu allem \[CapitalUDoubleDot]berfluss funktioniert auch Prepend nicht nur f\
\[UDoubleDot]r Listen, sondern ebenso f\[UDoubleDot]r allgemeinere Ausdr\
\[UDoubleDot]cke. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{"u", ",", "a"}], "]"}]], "Input"],

Cell["So ist's korrekt:", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "KRec", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"KRec", "[", "r_Integer", "]"}], ":=", 
   RowBox[{"{", "r", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KRec", "[", "r_Rational", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", "=", 
      RowBox[{"Floor", "[", "r", "]"}]}], "}"}], ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"KRec", "[", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"r", "-", "u"}], ")"}]}], "]"}], ",", "u"}], "]"}]}], 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"KRec", "[", 
  RowBox[{"31", "/", "245"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Probe"}]], "Input"],

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"31", "/", "245"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  SqrtBox["31"], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Schnelles modulares Potenzieren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"modPower", "[", 
   RowBox[{"a0_Integer", ",", "n0_Integer", ",", "m_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "a0"}], ",", 
      RowBox[{"n", "=", "n0"}], ",", 
      RowBox[{"p", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"n", ">", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "p", ",", "\"\<*\>\"", ",", "a", ",", "\"\<^\>\"", ",", "n", ",", 
          "\"\< = \>\""}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OddQ", "[", "n", "]"}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{"a", "*", "p"}], ",", "m"}], "]"}]}], ";", 
           RowBox[{"n", "-=", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"a", "*", "a"}], ",", "m"}], "]"}]}], ";", 
        RowBox[{"n", "/=", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "p"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"modPower", "[", 
  RowBox[{"2", ",", "107", ",", "163"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", "107", ",", "163"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Fibonaccizahlen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{"n", ",", "0", ",", "0", ",", "1", ",", "1", ",", "_", ",", 
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"fib", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"fib", "[", "25", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Timing", "[", 
       RowBox[{"fib", "[", "i", "]"}], "]"}], "\[LeftDoubleBracket]", "1", 
      "\[RightDoubleBracket]"}], "//", "Chop"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "25"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"l", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}], ",", " ", 
   RowBox[{"PlotRange", "->", "All"}], " ", ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"l", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",",
      
     RowBox[{"{", 
      RowBox[{"i", ",", "10", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"l1", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "fib", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{"Switch", "[", 
    RowBox[{"n", ",", "0", ",", "0", ",", "1", ",", "1", ",", "_", ",", 
     RowBox[{
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell[TextData[{
 "Achtung, ",
 StyleBox["$RecursionLimit",
  FontWeight->"Bold"],
 " wird jetzt bei jedem rekursiven Aufruf hochgez\[ADoubleDot]hlt und nicht \
nur bei verschachtelten. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"fib", "[", "20", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["\<\
Auch die Gr\[ODoubleDot]\[SZ]e der Fibonaccizahlen w\[ADoubleDot]chst \
exponentiell, so dass wir uns in den folgenden Beispielen auf die Berechnung \
der jeweils letzten 20 Ziffern beschr\[ADoubleDot]nken.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "fib", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", "0"}], ",", 
      RowBox[{"b", "=", "1"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], "=", 
        RowBox[{"{", 
         RowBox[{"b", ",", 
          RowBox[{"Mod", "[", 
           RowBox[{
            RowBox[{"a", "+", "b"}], ",", 
            SuperscriptBox["10", "20"]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], ";", "a"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"fib", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "fib"}]], "Input"],

Cell["\<\
Diese Definition hat nicht die Laufzeitprobleme der zuerst gegebenen \
rekursiven Definition und auch nicht die Speicherplatzprobleme der zweiten. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"fib", "[", "1000", "]"}], "]"}]], "Input"],

Cell[TextData[{
 "Und so geht es noch schneller (obwohl ",
 StyleBox["MatrixPower",
  FontWeight->"Bold"],
 " nicht mit modularem Rechnen gekoppelt werden kann):"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"matfib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MatrixPower", "[", 
      RowBox[{
       RowBox[{"(", GridBox[{
          {"1", "1"},
          {"1", "0"}
         }], ")"}], ",", "n"}], "]"}], " ", ".", 
     RowBox[{"(", GridBox[{
        {"1"},
        {"0"}
       }], ")"}]}], ")"}], "\[LeftDoubleBracket]", 
   RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matfib", "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"First", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"fib", "[", 
      SuperscriptBox["10", "n"], "]"}], "//", "Timing"}], ",", 
    RowBox[{
     RowBox[{"matfib", "[", 
      SuperscriptBox["10", "n"], "]"}], "//", "Timing"}]}], "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     SuperscriptBox["10", "3"], "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"fib", "[", "#", "]"}], ",", 
         SuperscriptBox["10", "2"]}], "]"}], "\[Equal]", "99"}], ")"}], 
     "&"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"fib", "/@", "l"}]], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{741, 571},
WindowMargins->{{171, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PostScriptOutputFile":>FrontEnd`FileName[{
  "home", "graebe", "Kofler-Buch", "Notebooks"}, "kap02.nb.ps", 
  CharacterEncoding -> "WindowsANSI"]},
ShowSelection->True,
CellLabelAutoDelete->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 44, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[659, 27, 113, 4, 55, "Section"],
Cell[775, 33, 327, 9, 59, "SmallText"],
Cell[1105, 44, 218, 6, 50, "Input"],
Cell[1326, 52, 66, 1, 28, "Input"],
Cell[1395, 55, 132, 4, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1564, 64, 70, 0, 35, "Section"],
Cell[1637, 66, 595, 13, 76, "SmallText"],
Cell[CellGroupData[{
Cell[2257, 83, 45, 0, 45, "Subsection"],
Cell[2305, 85, 52, 1, 30, "Input"],
Cell[2360, 88, 76, 2, 33, "Input"],
Cell[2439, 92, 225, 7, 30, "Input"],
Cell[2667, 101, 224, 7, 30, "Input"],
Cell[2894, 110, 225, 7, 30, "Input"],
Cell[3122, 119, 122, 3, 30, "Input"],
Cell[3247, 124, 148, 4, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3432, 133, 49, 0, 29, "Subsection"],
Cell[3484, 135, 191, 5, 28, "Input"],
Cell[3678, 142, 378, 11, 49, "Input"],
Cell[4059, 155, 257, 8, 28, "Input"],
Cell[4319, 165, 875, 27, 52, "Input"],
Cell[5197, 194, 933, 29, 89, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6167, 228, 58, 0, 29, "Subsection"],
Cell[6228, 230, 268, 9, 30, "Input"],
Cell[6499, 241, 109, 3, 28, "Input"],
Cell[6611, 246, 269, 9, 30, "Input"],
Cell[6883, 257, 186, 4, 28, "Input"],
Cell[7072, 263, 212, 5, 28, "Input"],
Cell[7287, 270, 391, 13, 28, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[7727, 289, 34, 0, 35, "Section"],
Cell[7764, 291, 740, 12, 110, "SmallText"],
Cell[CellGroupData[{
Cell[8529, 307, 38, 0, 45, "Subsection"],
Cell[8570, 309, 192, 6, 28, "Input"],
Cell[8765, 317, 211, 8, 37, "Input"],
Cell[8979, 327, 25, 0, 42, "SmallText"],
Cell[9007, 329, 270, 9, 28, "Input"],
Cell[9280, 340, 168, 5, 28, "Input"],
Cell[9451, 347, 462, 15, 28, "Input"],
Cell[9916, 364, 433, 11, 76, "SmallText"],
Cell[10352, 377, 612, 21, 52, "Input"],
Cell[10967, 400, 73, 2, 28, "Input"],
Cell[11043, 404, 73, 2, 28, "Input"],
Cell[11119, 408, 464, 15, 28, "Input"],
Cell[11586, 425, 512, 17, 28, "Input"],
Cell[12101, 444, 217, 4, 59, "SmallText"],
Cell[12321, 450, 592, 19, 49, "Input"],
Cell[12916, 471, 172, 6, 28, "Input"],
Cell[13091, 479, 93, 2, 42, "SmallText"],
Cell[13187, 483, 514, 17, 28, "Input"],
Cell[13704, 502, 123, 3, 42, "SmallText"],
Cell[13830, 507, 562, 19, 28, "Input"],
Cell[14395, 528, 231, 6, 59, "SmallText"],
Cell[14629, 536, 734, 25, 49, "Input"],
Cell[15366, 563, 172, 6, 28, "Input"],
Cell[15541, 571, 562, 19, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[16140, 595, 74, 2, 29, "Subsection"],
Cell[16217, 599, 156, 5, 30, "Input"],
Cell[16376, 606, 189, 6, 28, "Input"],
Cell[16568, 614, 750, 24, 71, "Input"],
Cell[17321, 640, 157, 4, 28, "Input"],
Cell[17481, 646, 59, 1, 28, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[17589, 653, 28, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[17642, 657, 43, 0, 45, "Subsection"],
Cell[17688, 659, 76, 1, 28, "Input"],
Cell[17767, 662, 938, 27, 69, "Input"],
Cell[18708, 691, 223, 7, 28, "Input"],
Cell[18934, 700, 943, 26, 71, "Input"],
Cell[19880, 728, 257, 8, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[20174, 741, 48, 0, 29, "Subsection"],
Cell[20225, 743, 76, 1, 28, "Input"],
Cell[20304, 746, 1213, 35, 169, "Input"],
Cell[21520, 783, 83, 2, 28, "Input"],
Cell[21606, 787, 2092, 59, 189, "Input"],
Cell[23701, 848, 91, 2, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[23829, 855, 40, 0, 29, "Subsection"],
Cell[23872, 857, 76, 1, 28, "Input"],
Cell[23951, 860, 365, 12, 28, "Input"],
Cell[24319, 874, 861, 28, 109, "Input"],
Cell[25183, 904, 164, 3, 42, "SmallText"],
Cell[25350, 909, 1143, 36, 89, "Input"],
Cell[26496, 947, 250, 7, 59, "SmallText"],
Cell[26749, 956, 3046, 98, 229, "Input"],
Cell[29798, 1056, 507, 15, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[30342, 1076, 77, 0, 29, "Subsection"],
Cell[30422, 1078, 93, 2, 28, "Input"],
Cell[30518, 1082, 1026, 30, 149, "Input"],
Cell[31547, 1114, 404, 12, 28, "Input"],
Cell[31954, 1128, 90, 2, 28, "Input"],
Cell[32047, 1132, 54, 1, 28, "Input"],
Cell[32104, 1135, 175, 5, 76, "SmallText"],
Cell[32282, 1142, 813, 22, 129, "Input"],
Cell[33098, 1166, 107, 3, 28, "Input"],
Cell[33208, 1171, 296, 6, 59, "SmallText"],
Cell[33507, 1179, 83, 2, 28, "Input"],
Cell[33593, 1183, 38, 0, 42, "SmallText"],
Cell[33634, 1185, 637, 20, 69, "Input"],
Cell[34274, 1207, 83, 2, 28, "Input"],
Cell[34360, 1211, 54, 1, 28, "Input"],
Cell[34417, 1214, 96, 2, 28, "Input"],
Cell[34516, 1218, 83, 2, 36, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[34636, 1225, 53, 0, 29, "Subsection"],
Cell[34692, 1227, 76, 1, 28, "Input"],
Cell[34771, 1230, 1279, 35, 149, "Input"],
Cell[36053, 1267, 98, 2, 44, "Input"],
Cell[36154, 1271, 98, 2, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[36289, 1278, 37, 0, 29, "Subsection"],
Cell[36329, 1280, 76, 1, 28, "Input"],
Cell[36408, 1283, 340, 9, 28, "Input"],
Cell[36751, 1294, 46, 1, 28, "Input"],
Cell[36800, 1297, 162, 5, 28, "Input"],
Cell[36965, 1304, 90, 2, 44, "Input"],
Cell[37058, 1308, 335, 10, 44, "Input"],
Cell[37396, 1320, 323, 8, 44, "Input"],
Cell[37722, 1330, 440, 13, 65, "Input"],
Cell[38165, 1345, 482, 13, 65, "Input"],
Cell[38650, 1360, 46, 1, 44, "Input"],
Cell[38699, 1363, 203, 6, 42, "SmallText"],
Cell[38905, 1371, 57, 1, 44, "Input"],
Cell[38965, 1374, 46, 1, 44, "Input"],
Cell[39014, 1377, 235, 4, 59, "SmallText"],
Cell[39252, 1383, 728, 23, 66, "Input"],
Cell[39983, 1408, 162, 5, 44, "Input"],
Cell[40148, 1415, 46, 1, 44, "Input"],
Cell[40197, 1418, 176, 3, 59, "SmallText"],
Cell[40376, 1423, 92, 2, 44, "Input"],
Cell[40471, 1427, 179, 5, 42, "SmallText"],
Cell[40653, 1434, 457, 16, 53, "Input"],
Cell[41113, 1452, 135, 4, 44, "Input"],
Cell[41251, 1458, 360, 11, 49, "Input"],
Cell[41614, 1471, 388, 13, 46, "Input"],
Cell[42005, 1486, 52, 1, 44, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
