(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44932,       1464]
NotebookOptionsPosition[     40221,       1328]
NotebookOutlinePosition[     40644,       1347]
CellTagsIndexPosition[     40601,       1344]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " als Visualisierungswerkzeug"
}], "Title"],

Cell[CellGroupData[{

Cell["Beispiele", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      SuperscriptBox["x", "2"], ",", 
      SuperscriptBox["x", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Dotted", ",", "Dashed", ",", "DotDashed"}], "}"}]}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["AspectRatio",
  FontWeight->"Bold"],
 " bezieht sich nicht auf die Koordinaten-Ticks, sondern auf die Gr\
\[ODoubleDot]\[SZ]enverh\[ADoubleDot]ltnisse der Box, in welcher das Bild \
dargestellt wird."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"2", "t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"6", "\[Pi]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"2", "t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"6", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"2", "t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"6", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}], ",", 
      RowBox[{"t", " ", 
       RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"6", " ", "\[Pi]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{"%", ",", "AspectRatio"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"6", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "2"]}], ",", 
     FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Mesh\[Rule]All ",
  FontWeight->"Bold"],
 "zeigt jetzt das Netz an wie es der Triangulierung entspricht. Ansonsten \
wird ein separates Netz auf die Fl\[ADoubleDot]che gelegt, welches nichts mit \
der Traigulierung zu tun hat. Insbesondere hat der Wert ",
 StyleBox["PlotPoints",
  FontWeight->"Bold"],
 " dann keinen Einfluss auf die Maschengr\[ODoubleDot]\[SZ]e des Netzes."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]], "]"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", ".1"}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "\[Pi]"}], ",", 
      RowBox[{"5", " ", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{
       RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
      RowBox[{"3", " ", "\[Pi]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
    RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " unterst\[UDoubleDot]tzt auch andere Arten der zweidimensionalen \
Darstellung h\[ODoubleDot]herdimensionaler Strukturen, indem einzelne \
Dimensionen durch Schattierungen oder Farben repr\[ADoubleDot]sentiert \
werden. ",
 StyleBox["DensityPlot",
  FontWeight->"Bold"],
 " und ",
 StyleBox["ContourPlot",
  FontWeight->"Bold"],
 " sind zwei solche Funktionen. ",
 StyleBox["ContourPlot",
  FontWeight->"Bold"],
 " produziert eine Darstellung durch H\[ODoubleDot]henlinien, wobei der \
Funktionswert einer H\[ODoubleDot]henlinie als Tooltip angezeigt wird."
}], "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"y", "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"y", "+", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", "20"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["ContourPlot",
  FontWeight->"Bold"],
 " l\[ADoubleDot]sst sich auch verwenden, um einzelne H\[ODoubleDot]henlinien \
zu zeichnen, was \[ADoubleDot]quivalent zur Herstellung einer impliziten \
Grafik ist."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "2"], "\[Equal]", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{
      SuperscriptBox["y", "2"], 
      SuperscriptBox["z", "2"]}], "+", 
     SuperscriptBox["z", "3"]}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["t", "2"]}], ")"}]}], ",", "u", ",", 
     RowBox[{
      SuperscriptBox["u", "2"], "-", 
      SuperscriptBox["t", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Zum Aufbau von Grafiken", "Section"],

Cell[CellGroupData[{

Cell["2D-Grafiken", "Subsection"],

Cell["Eine 2D-Grafik aus Linienelementen zusammenbauen.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "x"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "x"}], ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1", ",", "0.02"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "x"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "x"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1", ",", "0.02"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"l1", ",", "l2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{"Yellow", ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}], ",", "Red", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Dotted", ",", "Green"}], "}"}], "]"}], ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "]"}]}], "}"}]}], 
    "\[IndentingNewLine]", "}"}], "]"}]}]], "Input",
 CellID->779714166],

Cell[BoxData[
 RowBox[{"g", "/.", 
  RowBox[{
   RowBox[{"RGBColor", "[", "a__", "]"}], ":>", 
   RowBox[{"GrayLevel", "[", 
    RowBox[{"Mean", "[", 
     RowBox[{"{", "a", "}"}], "]"}], "]"}]}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Eine 3D-Grafik: Ein Viereck im Raum ", "Subsection"],

Cell["\<\
Eine 3D-Grafik: Wie ein Viereck mit zuf\[ADoubleDot]llig \
gew\[ADoubleDot]hlten Eckpunkten im Raum dargestellt wird. Inklusive \
Punktbeschriftungen und Sph\[ADoubleDot]ren um die Punkte herum.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RP", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", "]"}], ",", 
    RowBox[{"{", "n", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RP", "[", "3", "]"}], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}]}]], "Input"],

Cell["\<\
Und hier die Punkte, mit denen die aktuellen Grafiken erzeugt wurden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "0.2780630066006887`", ",", "0.13354357331178807`", ",", 
      "0.6857581819746135`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0.5669237236908962`", ",", "0.5348852878846041`", ",", 
      "0.09519123065898773`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0.41961156086013174`", ",", "0.3325578741561961`", ",", 
      "0.7100178257644869`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0.029218381149627496`", ",", "0.06729916702760365`", ",", 
      "0.616399264335642`"}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", "p", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
    RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
    RowBox[{"Polygon", "[", "p", "]"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
     RowBox[{"Polygon", "[", "p", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", "White", "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"RotateLeft", "[", "p", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
     RowBox[{"Polygon", "[", "q", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", "White", "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"txt", "=", 
   RowBox[{"{", 
    RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"zeigeDasBild", ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Beschriftung", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
        RowBox[{"Polygon", "[", "p", "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", "White", "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "Input"],

Cell["Beschriftung - Version 1", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Beschriftung", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"txt", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"p", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "zeigeDasBild"}], "Input"],

Cell["Beschriftung - Version 2", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"M", "=", 
   RowBox[{"Mean", "[", "p", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Beschriftung", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"txt", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{
        RowBox[{"1.1", 
         RowBox[{
         "p", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], "-", 
        RowBox[{"0.1", "M"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "zeigeDasBild"}], "Input"],

Cell["Beschriftung - Version 3", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Beschriftung", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pos", "=", 
         RowBox[{
          RowBox[{"1.2", 
           RowBox[{
           "p", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], "-",
           
          RowBox[{"0.2", "M"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{
           "txt", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",",
            "pos"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Orange", ",", 
           RowBox[{"Sphere", "[", 
            RowBox[{"pos", ",", "0.08"}], "]"}]}], "}"}]}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "zeigeDasBild"}], "Input"],

Cell["Und nun noch das letzte Bild aus dem Abschnitt.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "i", "]"}], ",", 
         RowBox[{"Cos", "[", "i", "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1.5", ",", "4", ",", ".4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "p", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"txt", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"\"\<P\>\"", "<>", 
      RowBox[{"ToString", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"lines", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"p", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}],
        "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Beschriftung", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"txt", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", ">", "1"}], ",", 
         RowBox[{
          RowBox[{"1.1", 
           RowBox[{
           "p", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], "-",
           
          RowBox[{"0.1", 
           RowBox[{
           "p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1.1"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Beschriftung", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dashing", "[", ".03", "]"}], ",", "lines"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", "Yellow", "]"}], ",", 
        RowBox[{"Polygon", "[", "p", "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", "White", "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Duale Polyeder", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gc", "=", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.2", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6", ",", "7.2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
         RowBox[{"Point", "[", "1", "]"}], ",", 
         RowBox[{"Point", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"PointSize", "[", ".05", "]"}], ",", "Thick", ",", "gc"}], "}"}], 
  "]"}]}], "Input",
 CellID->2000605689],

Cell[BoxData[
 RowBox[{"gc", "//", "Normal"}]], "Input"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " enth\[ADoubleDot]lt mit der Version 6 eine Datenbank \[UDoubleDot]ber \
viele regul\[ADoubleDot]re und halbregul\[ADoubleDot]re K\[ODoubleDot]rper. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "]"}]], "Input"],

Cell["\<\
Darunter auch \[UDoubleDot]ber die f\[UDoubleDot]nf Platonischen K\
\[ODoubleDot]rper.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"platonischeKoerper", "=", 
  RowBox[{"PolyhedronData", "[", "\"\<Platonic\>\"", "]"}]}]], "Input",
 CellID->109690157],

Cell["\<\
Die Liste der Schl\[UDoubleDot]sselworte (keys) der etwa zu einem W\
\[UDoubleDot]rfel gespeicherten Informationen:\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Properties\>\""}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Volume\>\""}], "]"}]], "Input"],

Cell["Und hier die Liste der key/value-Paare", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Cube\>\"", ",", "#"}], "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cube\>\"", ",", "\"\<Properties\>\""}], "]"}]}]], "Input"],

Cell["\<\
W\[UDoubleDot]rfel und Oktaeder sind zueinander dual: Verbindet man die \
Seitenmitten eines W\[UDoubleDot]rfels, so ergibt sich ein Oktaeder und \
umgekehrt.
Wir wollen dies in einem 3D-Bild veranschaulichen. Ausgangspunkt sind die \
\"Faces\"-Darstellungen der beiden K\[ODoubleDot]rper aus der Datenbank.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{"cube", "=", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "\n", 
 RowBox[{"octahedron", "=", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Octahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Beide sind ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Konstrukte, aus denen sich sofort ein erstes Bild erzeugen \
l\[ADoubleDot]sst."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"cube", ",", "octahedron"}], "}"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]], "Input"],

Cell["\<\
Das Oktaeder ragt aus dem W\[UDoubleDot]rfel heraus, muss also noch skaliert \
werden. Komisch, dass es nur an zwei Seiten aus dem W\[UDoubleDot]rfel \
herausragt. 
Ein Drahtgitterbild bringt den Grund ans Licht: Das Oktaeder liegt \"falsch \
herum\" im W\[UDoubleDot]rfel und muss auch noch gedreht werden.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", "]"}], ",", "cube", ",", "octahedron"}], "}"}], 
   ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[TextData[{
 StyleBox["cube",
  FontWeight->"Bold"],
 " und ",
 StyleBox["octahedron",
  FontWeight->"Bold"],
 " sind ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Primitive, auf denen sich geometrische Transformationen leicht ausf\
\[UDoubleDot]hren lassen. Das erste Argument eines ",
 StyleBox["GraphicsComplex",
  FontWeight->"Bold"],
 "-Primitivs ist eine Liste von Punkt-Koordinaten, das zweite eine \
Beschreibung der Linien- und Fl\[ADoubleDot]chenelemente des Objekts relativ \
zu diesen Punkten. Wir m\[UDoubleDot]ssen also nur die Koordinaten der Punkte \
mit der entsprechenden Transformationsmatrix multiplizieren und daraus das \
neue Grafikprimitiv nach denselben Anweisungen aufbauen.\nHier ist schon mal \
eine Funktionsdefinition, die das erledigt:"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gcTransform", "[", 
   RowBox[{"r_", ",", "g_GraphicsComplex"}], "]"}], ":=", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"r", ".", "#"}], "&"}], ")"}], "/@", 
     RowBox[{"g", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
    ",", 
    RowBox[{"g", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
   "]"}]}]], "Input"],

Cell["\<\
Die erforderliche Transformation des Oktaeders k\[ODoubleDot]nnen wir aus \
zwei Schritten zusammensetzen. Zun\[ADoubleDot]chst die Drehung in z-Richtung \
um 90\[Degree].\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"r", "=", 
    RowBox[{"RotationMatrix", "[", 
     RowBox[{
      RowBox[{"\[Pi]", "/", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"cube", ",", 
      RowBox[{"gcTransform", "[", 
       RowBox[{"r", ",", "octahedron"}], "]"}]}], "}"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "Rund um die Grafik ist noch extrem viel Platz. Das hat damit zu tun, dass \
die 3D-Begrenzungsbox durch die Mitten des Oktaeders bestimmt wird, also um \
den Faktor ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]]],
 ", wie wir gleich sehen werden, gr\[ODoubleDot]\[SZ]er ist als der W\
\[UDoubleDot]rfel. Diese Begrenzungsbox muss ihrerseits \
standardm\[ADoubleDot]\[SZ]ig vollst\[ADoubleDot]ndig ins 2D-Bildfenster \
passen. Mit der Option ",
 StyleBox["ViewAngle",
  FontWeight->"Bold"],
 " k\[ODoubleDot]nnen Sie die Gr\[ODoubleDot]\[SZ]e der Szene beeinflussen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p", ",", 
   RowBox[{"ViewAngle", "->", 
    RowBox[{"20", "\[Degree]"}]}]}], "]"}]], "Input"],

Cell["\<\
Nun schaut das Oktaeder an allen Seiten auf gleiche Weise heraus und muss nur \
noch skaliert werden, so dass Inkugelradius des W\[UDoubleDot]rfels und \
Umkugelradius des Oktaeders \[UDoubleDot]bereinstimmen. 
Die erforderlichen Informationen k\[ODoubleDot]nnen wir wieder der Datenbank \
entnehmen. Sie sind f\[UDoubleDot]r alle f\[UDoubleDot]nf platonischen K\
\[ODoubleDot]rper in der folgenden Tabelle zusammengestellt.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"radii", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"#", ",", "\"\<Inradius\>\""}], "]"}], ",", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"#", ",", "\"\<Circumradius\>\""}], "]"}]}], "}"}], "&"}], "/@",
     "platonischeKoerper"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Text", "@", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{"radii", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<K\[ODoubleDot]rper\>\"", ",", "\"\<Inkugelradius\>\"", ",", 
        "\"\<Umkugelradius\>\""}], "}"}]}], "]"}], ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "True", "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True", ",", 
         RowBox[{"{", "False", "}"}], ",", "True"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]}]}], "Input"],

Cell[TextData[{
 "Das Oktaeder ist also um den Faktor ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]]],
 " zu verkleinern. \nDie Szene ist mit wei\[SZ]em Licht ausgeleuchtet, um die \
Eigenfarben der beiden K\[ODoubleDot]rper unverf\[ADoubleDot]lscht zur \
Geltung zu bringen. Der W\[UDoubleDot]rfel ist au\[SZ]erdem leicht \
durchsichtig, um auch einen Blick ins Innere zu erm\[ODoubleDot]glichen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Yellow", ",", 
        RowBox[{"Opacity", "[", ".3", "]"}], ",", "cube"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"gcTransform", "[", 
         RowBox[{
          FractionBox["r", 
           SqrtBox["2"]], ",", "octahedron"}], "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", "White", "}"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"rt", "=", 
  RowBox[{"RotationTransform", "[", 
   RowBox[{
    RowBox[{"\[Pi]", "/", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"st", "=", 
  RowBox[{"ScalingTransform", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ct", "=", 
  RowBox[{"Composition", "[", 
   RowBox[{"st", ",", "rt"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"transformedOctahedron", "=", 
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{"octahedron", ",", "ct"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Opacity", "[", ".3", "]"}], ",", "cube"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", "transformedOctahedron"}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", "White", "}"}]}]}], "]"}]], "Input"],

Cell["\<\
Und nun packen wir noch den W\[UDoubleDot]rfel in das Oktaeder.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Opacity", "[", ".3", "]"}], ",", "cube"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Opacity", "[", ".5", "]"}], ",", 
       RowBox[{"gcTransform", "[", 
        RowBox[{
         FractionBox["r", 
          SqrtBox["2"]], ",", "octahedron"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"gcTransform", "[", 
          RowBox[{
           RowBox[{
            FractionBox["1", "3"], 
            RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", "cube"}], 
          "]"}]}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", "White", "}"}]}]}], "]"}]], "Input"],

Cell["Das Tetraeder ist zu sich selbst dual.", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tetrahedron", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Tetrahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Opacity", "[", ".3", "]"}], ",", "tetrahedron"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Opacity", "[", ".5", "]"}], ",", 
       RowBox[{"gcTransform", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "3"]}], 
          RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", "tetrahedron"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"gcTransform", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "9"], 
          RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", "tetrahedron"}], 
        "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", "White", "}"}]}]}], "]"}]}], "Input"],

Cell["\<\
Dasselbe nun auch noch f\[UDoubleDot]r Dodekaeder und Ikosaeder.\
\>", "SmallText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dodecahedron", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"icosahedron", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{
    RowBox[{"radii", "\[LeftDoubleBracket]", 
     RowBox[{"3", ",", "3"}], "\[RightDoubleBracket]"}], "/", 
    RowBox[{"radii", "\[LeftDoubleBracket]", 
     RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   RowBox[{
    RowBox[{"radii", "\[LeftDoubleBracket]", 
     RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}], "/", 
    RowBox[{"radii", "\[LeftDoubleBracket]", 
     RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"RotationMatrix", "[", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{"\[Pi]", "/", "5"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Opacity", "[", ".3", "]"}], ",", "dodecahedron"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Opacity", "[", ".5", "]"}], ",", 
       RowBox[{"gcTransform", "[", 
        RowBox[{
         RowBox[{"r", "/", "\[Alpha]"}], ",", "icosahedron"}], "]"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"gcTransform", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"IdentityMatrix", "[", "3", "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"\[Alpha]", " ", "\[Beta]"}], ")"}]}], ",", 
         "dodecahedron"}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", "White", "}"}]}]}], "]"}]}], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Dynamische Grafiken und Animationen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Animate",
  FontWeight->"Bold"],
 " als automatisches Abspielen, ",
 StyleBox["Manipulate",
  FontWeight->"Bold"],
 " als interaktive Variation."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], "-", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "10", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellID->2086048250],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellID->1824107939],

Cell[TextData[{
 "Das ",
 StyleBox["Manipulate",
  FontWeight->"Bold"],
 "-Objekt kann \[UDoubleDot]ber Schieberegler oder ein Kontrollpanel \
gesteuert werden. Das Kontrollpanel wird durch Knopfdruck \
ge\[ODoubleDot]ffnet. In einer Dialogbox finden sich Kn\[ODoubleDot]pfe, \
\[UDoubleDot]ber welche die Szene automatisch oder im Schrittmodus abgespielt \
werden kann. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellID->1041298703],

Cell[TextData[{
 "Animation einer 3D-Grafik - wir fliegen um das Objekt herum, indem wir den \
",
 StyleBox["ViewPoint",
  FontWeight->"Bold"],
 " \[ADoubleDot]ndern.\nHier zun\[ADoubleDot]chst ein Blick auf das ruhende \
Objekt."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "5"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]], "Input"],

Cell["\<\
Die Animation funktioniert nun, allein das Gitternetz hat ein Eigenleben.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "5"}], ",", 
     RowBox[{"PlotRange", "->", "3"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", " ", 
        RowBox[{"3", 
         RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], ",", "2"}], "}"}]}], " ", 
     ",", 
     RowBox[{"ViewAngle", "->", 
      RowBox[{"25", "\[Degree]"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0.", ",", 
     RowBox[{"2", "\[Pi]"}], ",", 
     FractionBox["\[Pi]", "12"]}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Man kann die Daten auch erst separat erzeugen und dann mit ",
 StyleBox["ListAnimate",
  FontWeight->"Bold"],
 " animieren."
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "5"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", " ", 
          RowBox[{"3", 
           RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], ",", "2"}], "}"}]}], ",", 
       
       RowBox[{"ViewAngle", "->", 
        RowBox[{"25", "\[Degree]"}]}], ",", 
       RowBox[{"Axes", "->", "None"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", 
       FractionBox["\[Pi]", "12"]}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"data", ",", ".2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"data", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", "data", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input"]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{715, 848},
WindowMargins->{{Automatic, 1}, {1, Automatic}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 109, 4, 90, "Title"],
Cell[CellGroupData[{
Cell[724, 31, 28, 0, 55, "Section"],
Cell[755, 33, 76, 1, 28, "Input"],
Cell[834, 36, 416, 13, 30, "Input"],
Cell[1253, 51, 294, 8, 28, "Input"],
Cell[1550, 61, 244, 6, 59, "SmallText"],
Cell[1797, 69, 348, 11, 28, "Input"],
Cell[2148, 82, 398, 12, 28, "Input"],
Cell[2549, 96, 423, 13, 28, "Input"],
Cell[2975, 111, 483, 15, 49, "Input"],
Cell[3461, 128, 398, 12, 28, "Input"],
Cell[3862, 142, 433, 14, 41, "Input"],
Cell[4298, 158, 420, 9, 76, "SmallText"],
Cell[4721, 169, 916, 28, 67, "Input"],
Cell[5640, 199, 641, 17, 93, "SmallText"],
Cell[6284, 218, 570, 19, 49, "Input"],
Cell[6857, 239, 257, 8, 28, "Input"],
Cell[7117, 249, 305, 9, 44, "Input"],
Cell[7425, 260, 248, 6, 59, "SmallText"],
Cell[7676, 268, 460, 14, 46, "Input"],
Cell[8139, 284, 594, 19, 46, "Input"],
Cell[8736, 305, 587, 19, 46, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[9360, 329, 42, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[9427, 333, 33, 0, 45, "Subsection"],
Cell[9463, 335, 70, 0, 42, "SmallText"],
Cell[9536, 337, 1031, 35, 69, "Input"],
Cell[10570, 374, 1073, 31, 109, "Input",
 CellID->779714166],
Cell[11646, 407, 208, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11891, 418, 58, 0, 29, "Subsection"],
Cell[11952, 420, 223, 4, 59, "SmallText"],
Cell[12178, 426, 191, 6, 28, "Input"],
Cell[12372, 434, 161, 5, 28, "Input"],
Cell[12536, 441, 98, 2, 42, "SmallText"],
Cell[12637, 445, 633, 19, 89, "Input"],
Cell[13273, 466, 97, 2, 28, "Input"],
Cell[13373, 470, 242, 6, 28, "Input"],
Cell[13618, 478, 334, 9, 28, "Input"],
Cell[13955, 489, 442, 12, 49, "Input"],
Cell[14400, 503, 595, 17, 69, "Input"],
Cell[14998, 522, 45, 0, 42, "SmallText"],
Cell[15046, 524, 465, 13, 49, "Input"],
Cell[15514, 539, 45, 0, 42, "SmallText"],
Cell[15562, 541, 650, 19, 85, "Input"],
Cell[16215, 562, 45, 0, 42, "SmallText"],
Cell[16263, 564, 930, 29, 85, "Input"],
Cell[17196, 595, 68, 0, 42, "SmallText"],
Cell[17267, 597, 2569, 77, 165, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[19873, 679, 36, 0, 29, "Subsection"],
Cell[19912, 681, 893, 28, 69, "Input",
 CellID->2000605689],
Cell[20808, 711, 56, 1, 28, "Input"],
Cell[20867, 714, 234, 5, 42, "SmallText"],
Cell[21104, 721, 62, 1, 28, "Input"],
Cell[21169, 724, 115, 3, 42, "SmallText"],
Cell[21287, 729, 142, 3, 28, "Input",
 CellID->109690157],
Cell[21432, 734, 144, 3, 42, "SmallText"],
Cell[21579, 739, 118, 2, 28, "Input"],
Cell[21700, 743, 114, 2, 28, "Input"],
Cell[21817, 747, 59, 0, 42, "SmallText"],
Cell[21879, 749, 292, 8, 28, "Input"],
Cell[22174, 759, 336, 6, 93, "SmallText"],
Cell[22513, 767, 278, 6, 49, "Input"],
Cell[22794, 775, 184, 6, 42, "SmallText"],
Cell[22981, 783, 212, 6, 44, "Input"],
Cell[23196, 791, 336, 6, 93, "SmallText"],
Cell[23535, 799, 232, 7, 44, "Input"],
Cell[23770, 808, 800, 19, 127, "SmallText"],
Cell[24573, 829, 445, 13, 44, "Input"],
Cell[25021, 844, 200, 4, 59, "SmallText"],
Cell[25224, 850, 274, 9, 44, "Input"],
Cell[25501, 861, 282, 8, 44, "Input"],
Cell[25786, 871, 618, 14, 95, "SmallText"],
Cell[26407, 887, 142, 4, 44, "Input"],
Cell[26552, 893, 453, 7, 93, "SmallText"],
Cell[27008, 902, 1108, 32, 125, "Input"],
Cell[28119, 936, 432, 9, 78, "SmallText"],
Cell[28554, 947, 635, 18, 90, "Input"],
Cell[29192, 967, 680, 19, 128, "Input"],
Cell[29875, 988, 487, 13, 65, "Input"],
Cell[30365, 1003, 92, 2, 42, "SmallText"],
Cell[30460, 1007, 914, 26, 120, "Input"],
Cell[31377, 1035, 59, 0, 42, "SmallText"],
Cell[31439, 1037, 1173, 35, 168, "Input"],
Cell[32615, 1074, 93, 2, 42, "SmallText"],
Cell[32711, 1078, 342, 10, 65, "Input"],
Cell[33056, 1090, 1823, 53, 165, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34928, 1149, 54, 0, 35, "Section"],
Cell[34985, 1151, 76, 1, 28, "Input"],
Cell[35064, 1154, 189, 7, 42, "SmallText"],
Cell[35256, 1163, 263, 8, 28, "Input",
 CellID->2086048250],
Cell[35522, 1173, 344, 11, 28, "Input",
 CellID->1824107939],
Cell[35869, 1186, 389, 9, 76, "SmallText"],
Cell[36261, 1197, 428, 14, 28, "Input",
 CellID->1041298703],
Cell[36692, 1213, 247, 7, 59, "SmallText"],
Cell[36942, 1222, 467, 13, 28, "Input"],
Cell[37412, 1237, 102, 2, 42, "SmallText"],
Cell[37517, 1241, 1026, 29, 68, "Input"],
Cell[38546, 1272, 159, 5, 42, "SmallText"],
Cell[38708, 1279, 1116, 31, 68, "Input"],
Cell[39827, 1312, 91, 2, 28, "Input"],
Cell[39921, 1316, 272, 8, 28, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
