(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70377,       2147]
NotebookOptionsPosition[     62469,       1929]
NotebookOutlinePosition[     62867,       1947]
CellTagsIndexPosition[     62824,       1944]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Vektoren und Matrizen, Lineare Algebra", "Title",
 Evaluatable->False,
 CellHorizontalScrolling->False],

Cell[CellGroupData[{

Cell["Vektoren", "Section"],

Cell[CellGroupData[{

Cell["Vektoren eingeben. Zusammengesetzte Bezeichner", "Subsection",
 CellChangeTimes->{{3354642755.18096, 3354642777.33945}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.35463829357606*^9, 3.35463829634192*^9}, {
  3.35658445488923*^9, 3.35658446045872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["v2", "\[RightVector]"], "^=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35463857550503*^9, 3.3546386080428*^9}, {
  3.35658611475138*^9, 3.35658611549525*^9}}],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], " "}]]],
 "und ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["v2", "\[RightVector]"], " "}]]],
 "sind zusammengesetzte Bezeichner, bei deren Verwendung einige \
Besonderheiten zu beachten sind.\n\nZun\[ADoubleDot]chst entsprechen diesen \
Bezeichnern keine eigenst\[ADoubleDot]ndigen Eintr\[ADoubleDot]ge in der \
Symboltabelle, weil sie selbst zusammengesetzte Ausdr\[UDoubleDot]cke sind, \
wie die ",
 StyleBox["FullForm",
  FontWeight->"Bold"],
 " an den Tag bringt. "
}], "SmallText",
 CellChangeTimes->{{3.35463836830404*^9, 3.35463844603806*^9}, {
  3.35463848116053*^9, 3.35463854141838*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "//", "Hold"}], "//", 
  "FullForm"}]], "Input",
 CellChangeTimes->{{3.35463846542419*^9, 3.35463847241221*^9}}],

Cell[TextData[{
 "Die Werte der einzelnen Variablen werden standardm\[ADoubleDot]\[SZ]ig als \
",
 StyleBox["DownValue",
  FontWeight->"Bold"],
 " unter dem Funktionsbezeichner, hier also ",
 StyleBox["OverVector",
  FontWeight->"Bold"],
 ", gespeichert. Sie k\[ODoubleDot]nnen aber auch als ",
 StyleBox["UpValue",
  FontWeight->"Bold"],
 " wie hier auf dem Bezeichner v2 selbst gespeichert werden. "
}], "SmallText",
 CellChangeTimes->{{3.35463855847504*^9, 3.35463856449081*^9}, {
  3.35463862976086*^9, 3.35463866788538*^9}, {3.35463921201461*^9, 
  3.35463921250804*^9}, {3.35463937727804*^9, 3.35463939233864*^9}}],

Cell[BoxData[{
 RowBox[{"?", "OverVector"}], "\n", 
 RowBox[{"DownValues", "[", "OverVector", "]"}], "\n", 
 RowBox[{"UpValues", "[", "v2", "]"}]}], "Input",
 CellChangeTimes->{{3.35463832085024*^9, 3.35463835150691*^9}, 
   3.35463942361712*^9, {3.3565875669133*^9, 3.3565875821543*^9}}],

Cell[BoxData[
 RowBox[{"?", "v2"}]], "Input",
 CellChangeTimes->{{3.35463858292639*^9, 3.35463861562719*^9}}],

Cell["\<\
Je nachdem, wie Sie die Werte abspeichern, m\[UDoubleDot]ssen Sie \
verschiedene Kommandos zum L\[ODoubleDot]schen verwenden.\
\>", "SmallText",
 CellChangeTimes->{{3.35658834252362*^9, 3.35658837007078*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"v1", ",", "v2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], ",", " ", 
   OverscriptBox["v2", "\[RightVector]"]}], "}"}]}], "Input",
 CellChangeTimes->{{3.35658819848727*^9, 3.35658826696244*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "OverVector", "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], ",", " ", 
   OverscriptBox["v2", "\[RightVector]"]}], "}"}]}], "Input",
 CellChangeTimes->{{3.3565883775421*^9, 3.35658839774455*^9}}],

Cell[TextData[{
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " ist ein Formatierungskommando, das sowohl auf Vektoren als auch auf \
Matrizen angewendet werden kann. \n\nBeachten Sie, dass einspaltige Matrizen \
und Vektoren intern unterschiedlich dargestellt sind, von MatrixForm aber in \
gleicher Form ausgegeben werden."
}], "SmallText",
 CellChangeTimes->{{3.35463949288494*^9, 3.3546395764788*^9}, {
   3.35658759120801*^9, 3.35658759190482*^9}, 3.35658873650425*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["v2", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], "+", 
   OverscriptBox["v2", "\[RightVector]"]}], " ", "//", 
  "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.35463946823981*^9, 3.35463947821211*^9}, {
  3.35658876700708*^9, 3.35658877264087*^9}}],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   OverscriptBox["v1", "\[RightVector]"], 
   OverscriptBox["v2", "\[RightVector]"]]]],
 " sieht mathematisch recht seltsam (und nicht sehr sinnvoll) aus; die \
Auswertung gelingt, weil ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Vektoren eigentlich nicht kennt, sondern als gew\[ODoubleDot]hnliche \
Listen betrachtet"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   OverscriptBox["v1", "\[RightVector]"], 
   OverscriptBox["v2", "\[RightVector]"]], " ", "//", "MatrixForm"}]], "Input"],

Cell[TextData[{
 "Es gibt drei verschiedene Multiplikationsvarianten: Multiplikation eines \
Vektors mit einem Skalar, das skalare Produkt zweier Vektoren (Eingabe: ein \
einfacher Punkt . ) und das Kreuzprodukt (Eingabe: \[VeryThinSpace]\
\[EscapeKey]cross\[EscapeKey] oder Cross[",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], " ", ",", " ", 
   OverscriptBox["v2", "\[RightVector]"]}]]],
 "], nur f\[UDoubleDot]r Vektoren im ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "3"], TraditionalForm]]],
 ")"
}], "SmallText",
 CellChangeTimes->{{3.35463963671219*^9, 3.35463970176289*^9}, {
  3.35463984348307*^9, 3.35463986990219*^9}, {3.35658898098529*^9, 
  3.35658898169048*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   OverscriptBox["v1", "\[RightVector]"]}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  OverscriptBox["v1", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["v2", "\[RightVector]"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["v1", "\[RightVector]"], " ", "\[Cross]", 
   OverscriptBox["v2", "\[RightVector]"]}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[TextData[{
 "Das Kreuzprodukt ist allgemein f\[UDoubleDot]r (n-1)-Tupel von Vektoren im \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "n"], TraditionalForm]]],
 "definiert."
}], "SmallText",
 CellChangeTimes->{{3.35463982044389*^9, 3.35463983535769*^9}, {
  3.35463988175668*^9, 3.35463991655779*^9}}],

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35463973182355*^9, 3.35463974573895*^9}, {
  3.35463978822457*^9, 3.35463979980039*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Beispiel: Schnitt Gerade-Ebene", "Subsection"],

Cell[TextData[{
 "Schnitt Gerade mit Ebene\nP, Q\tPunkte im 3D Raum\n",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]]],
 "\tVektoren\ng\tGerade\n\[Epsilon]\tEbene"
}], "SmallText"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "OverVector", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "3", ",", "5"}], "}"}]}], ";", " ", 
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "4"}], "}"}]}], ";", " "}]}], "Input",
 CellChangeTimes->{{3.35659061606178*^9, 3.3565906346954*^9}}],

Cell["\<\
Verbundzuweisung und Darstellung als Liste von Vektoren in zweidimensionaler \
Notation.\
\>", "SmallText",
 CellChangeTimes->{{3.35659102584859*^9, 3.3565910554371*^9}}],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], ",", 
      OverscriptBox["v", "\[RightVector]"], ",", " ", 
      OverscriptBox["w", "\[RightVector]"]}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "4"}], "}"}]}], "}"}]}], ")"}]}]], "Input",\

 CellChangeTimes->{{3.35659054047115*^9, 3.35659060906552*^9}, {
  3.35659064015652*^9, 3.35659064261113*^9}, {3.35659083966131*^9, 
  3.35659085064723*^9}}],

Cell[TextData[{
 "Dieselbe Liste von Listen als Matrix in zweidimensionaler Notation. Obige \
Vektoren sind die ",
 StyleBox["Zeilen",
  FontWeight->"Bold"],
 " dieser Matrix."
}], "SmallText",
 CellChangeTimes->{{3.35659106402335*^9, 3.35659110090357*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], ",", 
    OverscriptBox["v", "\[RightVector]"], ",", " ", 
    OverscriptBox["w", "\[RightVector]"]}], "}"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35659101185171*^9, 3.35659101409344*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"g", "=", 
    RowBox[{"P", "+", 
     RowBox[{"a", " ", 
      OverscriptBox["u", "\[RightVector]"]}]}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35659047677087*^9, 3.3565904970156*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"\[CurlyEpsilon]", "=", 
    RowBox[{"Q", "+", 
     RowBox[{"b", " ", 
      OverscriptBox["v", "\[RightVector]"]}], " ", "+", " ", 
     RowBox[{"c", " ", 
      OverscriptBox["w", "\[RightVector]"]}]}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35659048259623*^9, 3.35659050973383*^9}}],

Cell[BoxData[
 RowBox[{"lsg", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"g", "\[Equal]", "\[CurlyEpsilon]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.387964852161771*^9, 3.387964852862003*^9}}],

Cell[BoxData[
 RowBox[{"g", " ", "/.", " ", 
  RowBox[{"lsg", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
  " "}]], "Input"],

Cell[TextData[{
 "Beachten Sie, dass Wertzuweisungen an zusammengesetzte Symbole nur \
\[UDoubleDot]ber den Bezeichner gel\[ODoubleDot]scht werden \
k\[ODoubleDot]nnen, dem sie zugeordnet sind, hier also dem \
Funktionsbezeichner ",
 StyleBox["OverVector",
  FontWeight->"Bold"],
 ". "
}], "SmallText",
 CellChangeTimes->{{3.35464012372758*^9, 3.35464018381096*^9}, {
  3.35659366608474*^9, 3.35659366664038*^9}}],

Cell[BoxData[
 RowBox[{"??", "OverVector"}]], "Input",
 CellChangeTimes->{{3.35464005547486*^9, 3.35464006100857*^9}, 
   3.387964925858163*^9}],

Cell[TextData[{
 "L\[ODoubleDot]schen solches Symbole ist jetzt schwieriger, weil sie im \
Kontext ",
 StyleBox["System'",
  FontWeight->"Bold"],
 " gespeichert sind. "
}], "SmallText",
 CellChangeTimes->{{3.387964985610853*^9, 3.387965011458713*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  OverscriptBox["v", "\[RightVector]"], " "}]}], "Input",
 CellChangeTimes->{{3.35464007327616*^9, 3.35464009284334*^9}, 
   3.387964914051935*^9}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "OverVector", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["v", "\[RightVector]"], " ", " "}]}], "Input",
 CellChangeTimes->{{3.35464002030765*^9, 3.35464002068251*^9}, {
  3.35464019586012*^9, 3.35464020218287*^9}, {3.387964964583727*^9, 
  3.387964975333577*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Unterscheiden Sie zwischen Vektoren und einspaltigen Matrizen!\
\>", "Subsection",
 CellChangeTimes->{{3354641237.26055, 3354641254.90719}}],

Cell["\<\
Vorsicht: Vektoren und einspaltige Matrizen haben unterschiedliche interne \
Darstellungen, werden aber von MatrixForm auf dieselbe Weise dargestellt.

\[CapitalUDoubleDot]ber Palette oder 3D-Eingabe k\[ODoubleDot]nnen nur \
einspaltige Matrizen eingegeben werden.\
\>", "SmallText",
 CellChangeTimes->{{3354640744.94964, 3354640832.79208}}],

Cell[TextData[{
 Cell[BoxData[
  OverscriptBox["a", "\[RightVector]"]], "Input",
  CellChangeTimes->{{3354640388.21048, 3354640425.79998}, {3354640514.40265, 
   3354640523.44683}, {3354640608.1391, 3354640678.0396}},
  FontWeight->"Plain"],
 " und ",
 Cell[BoxData[
  StyleBox[
   OverscriptBox["b", "\[RightVector]"],
   FontWeight->"Plain"]], "Input",
  CellChangeTimes->{{3354640388.21048, 3354640425.79998}, {3354640514.40265, 
   3354640523.44683}, {3354640608.1391, 3354640678.0396}}],
 " sind einspaltige Matrizen, ",
 Cell[BoxData[
  OverscriptBox["c", "\[RightVector]"]], "Input",
  CellChangeTimes->{{3354640388.21048, 3354640425.79998}, {3354640514.40265, 
   3354640523.44683}, {3354640608.1391, 3354640678.0396}},
  FontWeight->"Plain"],
 " dagegen ein Vektor. Das merkt man bei den ersten beiden Kommandos noch \
nicht, denn sie werden komponentenweise ausgef\[UDoubleDot]hrt."
}], "SmallText",
 CellChangeTimes->{{3354640846.20261, 3354640898.03258}, {3356621444.48362, 
  3356621485.61496}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], "=", 
   RowBox[{"(", GridBox[{
      {"a1"},
      {"a2"},
      {"a3"}
     }], ")"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["b", "\[RightVector]"], "=", 
   RowBox[{"(", GridBox[{
      {"b1"},
      {"b2"},
      {"b3"}
     }], ")"}]}], ";", " ", 
  RowBox[{
   OverscriptBox["c", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35464038821048*^9, 3.35464042579998*^9}, {
  3.35464051440265*^9, 3.35464052344683*^9}, {3.3546406081391*^9, 
  3.3546406780396*^9}, {3.35662132562093*^9, 3.35662135104775*^9}, {
  3.35662150526405*^9, 3.35662151869813*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], ",", 
   OverscriptBox["b", "\[RightVector]"], ",", " ", 
   OverscriptBox["c", "\[RightVector]"]}], "}"}]], "Input",
 CellChangeTimes->{{3.35662152318402*^9, 3.35662154033244*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"MatrixForm", "/@", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], ",", 
     OverscriptBox["b", "\[RightVector]"], ",", " ", 
     OverscriptBox["c", "\[RightVector]"]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.35464068387677*^9, 3.3546407242058*^9}, {
  3.3566215472949*^9, 3.35662155652375*^9}}],

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  OverscriptBox["a", "\[RightVector]"], "]"}]], "Input",
 CellChangeTimes->{{3.35662156060063*^9, 3.35662156168775*^9}}],

Cell["\<\
Einspaltige Matrizen k\[ODoubleDot]nnen wie Vektoren addiert und skalar \
vervielfacht werden. Das Ergebnis ist wieder eine einspaltige Matrix.\
\>", "SmallText",
 CellChangeTimes->{{3.3546409824036*^9, 3.35464102116419*^9}, {
  3.35464105934856*^9, 3.35464108680613*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], "+", 
   OverscriptBox["b", "\[RightVector]"]}], " ", "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.3566215659475*^9, 3.35662157047832*^9}}],

Cell["\<\
Selbst die Summe einer einspaltigen Matrix und eines Vektors kann gebildet \
werden. Das Ergebnis ist eine einspaltige Matrix.\
\>", "SmallText",
 CellChangeTimes->{{3.35464109245615*^9, 3.35464115407025*^9}}],

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], "+", 
  OverscriptBox["c", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35464104772817*^9, 3.35464104895804*^9}, {
  3.35662137539683*^9, 3.356621376041*^9}, {3.35662157705807*^9, 
  3.35662158201651*^9}}],

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{
  3.35464113026268*^9, {3.35662136656316*^9, 3.35662136966506*^9}}],

Cell[TextData[{
 "Als einspaltige Matrizen sind ",
 Cell[BoxData[
  OverscriptBox["a", "\[RightVector]"]]],
 " und ",
 Cell[BoxData[
  RowBox[{" ", 
   OverscriptBox["b", "\[RightVector]"]}]]],
 " nicht verkettet - deshalb endet dieses Dot-Kommando mit einer \
Fehlermeldung. W\[ADoubleDot]ren es Vektoren, w\[UDoubleDot]rde es als \
Skalarprodukt interpretiert und ausgef\[UDoubleDot]hrt."
}], "SmallText",
 CellChangeTimes->{{3.35662160354959*^9, 3.35662163522957*^9}}],

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["b", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35662158855663*^9, 3.35662159356681*^9}}],

Cell["\<\
Dasselbe gilt f\[UDoubleDot]r das Vektorprodukt, das ebenfalls nur f\
\[UDoubleDot]r Vektoren, nicht aber f\[UDoubleDot]r einspaltige Matrizen \
definiert ist. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], " ", "\[Cross]", 
  OverscriptBox["b", "\[RightVector]"], " "}]], "Input",
 CellChangeTimes->{{3.35662164884991*^9, 3.35662166070606*^9}}],

Cell[TextData[{
 "Verkettet sind hingegen ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], " "}]], "Input",
  CellChangeTimes->{{3.35662158855663*^9, 3.35662159356681*^9}},
  FontWeight->"Plain"],
 "und die zu ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["b", "\[RightVector]"], " "}]], "Input",
  CellChangeTimes->{{3.35662158855663*^9, 3.35662159356681*^9}},
  FontWeight->"Plain"],
 "transponierte Matrix, und zwar in beiden Reihenfolgen. \nIm ersten Fall \
ergibt sich eine 3\[Times]3-Matrix, deren Eintr\[ADoubleDot]ge die paarweisen \
Produkte sind; im zweiten Fall eine 1\[Times]1-Matrix mit dem Skalarprodukt \
als Eintrag."
}], "SmallText",
 CellChangeTimes->{{3.35662204098694*^9, 3.35662215045451*^9}, {
  3.35662224668827*^9, 3.35662225529259*^9}, {3.35662239014366*^9, 
  3.35662243188979*^9}, {3.35662287529611*^9, 3.35662287975284*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], " ", ".", 
   RowBox[{"Transpose", "[", " ", 
    OverscriptBox["b", "\[RightVector]"], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.3566219358723*^9, 3.35662198503249*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", " ", 
    OverscriptBox["b", "\[RightVector]"], " ", "]"}], ".", 
   OverscriptBox["a", "\[RightVector]"]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35662199819489*^9, 3.35662200939643*^9}, {
  3.3566223637578*^9, 3.35662236829544*^9}}],

Cell["\<\
Auf die Kombination von Matrix und Vektor wirkt . nicht als Skalarprodukt, \
sondern als Produkt von Matrix und Vektor. Daf\[UDoubleDot]r \
m\[UDoubleDot]ssen beide verkettet sein. Als Ergebnis ergibt sich ein \
1-Vektor, dessen Eintrag der Wert des Skalarprodukts ist.\
\>", "SmallText",
 CellChangeTimes->{{3.35662332267448*^9, 3.35662339987597*^9}, {
  3.3566238944243*^9, 3.35662399303223*^9}}],

Cell[BoxData[
 RowBox[{
  OverscriptBox["a", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["c", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35662185365544*^9, 3.35662185408099*^9}}],

Cell[BoxData[
 RowBox[{
  OverscriptBox["c", "\[RightVector]"], " ", ".", " ", 
  OverscriptBox["b", "\[RightVector]"]}]], "Input",
 CellChangeTimes->{{3.35662186738257*^9, 3.35662186798493*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrizen erzeugen", "Section"],

Cell[CellGroupData[{

Cell["Matrizen definieren", "Subsection",
 CellChangeTimes->{{3354643416.14757, 3354643418.98227}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.387966637792579*^9, 3.387966640512899*^9}}],

Cell[BoxData[
 RowBox[{"mat", " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", "5", "6"}
     }], ")"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat1", "=", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"mat1", " ", "//", "MatrixForm"}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.38796665309784*^9, {3.388420619115562*^9, 3.388420640297991*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "=", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "5"}]}], "}"}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"mat2", " ", "//", " ", "MatrixForm"}]}], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{3.387966658310715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", "j"}], ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat3", " ", "//", " ", "MatrixForm"}]}], "Input",
 PageWidth->Infinity],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Random", "[", "]"}], ",", 
    RowBox[{"{", "3", "}"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "UDM", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UDM", "[", 
    RowBox[{"f_Function", ",", 
     RowBox[{"n_Integer", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", ">", "0"}], "&"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", "j"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"i", ",", "j"}], "]"}], ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.35464292636531*^9, 3.35464297799485*^9}, {
  3.35464306196606*^9, 3.35464309204954*^9}, {3.35464320423884*^9, 
  3.35464320917479*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"UDM", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "#2"], "&"}], ",", "3"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35464307924299*^9, 3.35464308151646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"UDM", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", "3"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35464307924299*^9, 3.35464311315499*^9}, {
  3.35464322082281*^9, 3.35464327951711*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HilbertMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], "]"}], " ", "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.387966962490349*^9, 3.38796696454259*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[TextData[{
 "\[Degree] ist die Kurzform der Konstanten ",
 StyleBox["Degree",
  FontWeight->"Bold"],
 ", kann auch als \[EscapeKey]deg\[EscapeKey] eingegeben werden. In \
entsprechenden Kontexten wird sie durch ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Pi]", "180"], TraditionalForm]]],
 "ersetzt."
}], "SmallText",
 CellChangeTimes->{{3.35856807584416*^9, 3.35856813423044*^9}, {
  3.358568467253*^9, 3.35856849899993*^9}}],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   RowBox[{"12", "\[Degree]"}], "+", 
   RowBox[{"\[Pi]", "/", "180"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35856804588822*^9, 3.35856806205735*^9}, {
   3.35856834252373*^9, 3.35856842809305*^9}, {3.35856876757436*^9, 
   3.35856876934537*^9}, 3.387969467797075*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{"12", "\[Degree]"}], "+", 
    RowBox[{"\[Pi]", "/", "180"}]}], "]"}], "//", "FullForm"}]], "Input",
 CellChangeTimes->{{3.35856804588822*^9, 3.35856806205735*^9}, {
  3.35856834252373*^9, 3.35856842809305*^9}, {3.35856876757436*^9, 
  3.35856876934537*^9}, {3.387969452848524*^9, 3.387969456668433*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{"12", "\[Degree]"}], "+", 
    RowBox[{"\[Pi]", "/", "180"}]}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.35856804588822*^9, 3.35856806205735*^9}, {
  3.35856834252373*^9, 3.35856842809305*^9}, {3.35856876757436*^9, 
  3.35856876934537*^9}, {3.387969472078628*^9, 3.387969472786707*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix", "[", 
   RowBox[{"30", "\[Degree]"}], "]"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35856802744712*^9, 3.35856802972589*^9}, {
  3.387966988387414*^9, 3.387966988526247*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix", "[", 
   RowBox[{
    RowBox[{"30", "\[Degree]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.387966993299266*^9, 3.387966993493971*^9}, {
  3.387968590387275*^9, 3.387968620786258*^9}}],

Cell["\<\
Matrizen mit indizierten Variablen.
Die erste M\[ODoubleDot]glichkeit x als zweistellige Funktion\
\>", "SmallText",
 CellChangeTimes->{{3.388402777407233*^9, 3.388402827286153*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.38840269522547*^9, 3.38840269985684*^9}, {
  3.388405426749979*^9, 3.388405433934113*^9}, {3.388405465429489*^9, 
  3.388405468568237*^9}, {3.388409309140423*^9, 3.388409346955918*^9}}],

Cell["\<\
Die zweite M\[ODoubleDot]glichkeit: x mit Subscript-Indizes\
\>", "SmallText",
 CellChangeTimes->{{3.3566272831412*^9, 3.35662729056033*^9}, {
  3.388402847170167*^9, 3.388402866049031*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"i", ",", "j"}]], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.388409369873056*^9, 3.388409380743565*^9}}],

Cell["\<\
Aber beachten Sie, dass es sich auch hierbei um zusammengesetzte Bezeichner \
handelt!\
\>", "SmallText",
 CellChangeTimes->{{3.35662730752292*^9, 3.35662732213685*^9}, {
  3.388409431413052*^9, 3.388409435781635*^9}}],

Cell[BoxData[
 RowBox[{"mat", " ", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.388409406695901*^9, 3.388409407481087*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Auf einzelne Matrixelemente zugreifen", "Subsection",
 CellChangeTimes->{{3.35464336898686*^9, 3.35464337263787*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b", "c", "d"},
      {"e", "f", "g", "h"},
      {"i", "j", "k", "l"}
     }], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.38797036267026*^9, {3.388396948276271*^9, 3.388396980239339*^9}, {
   3.388397072516185*^9, 3.388397075646106*^9}, {3.388397115980092*^9, 
   3.388397119344919*^9}}],

Cell[BoxData[
 RowBox[{"mat", "\[LeftDoubleBracket]", 
  RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}]], "Input",
 CellChangeTimes->{3.387970364235021*^9}],

Cell[TextData[{
 "Achtung, das ist die zweite Zeile obiger Matrix, aber ein Vektor und von ",
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " als Spaltenvektor dargestellt. "
}], "SmallText",
 CellChangeTimes->{{3.35662735943868*^9, 3.35662740185557*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], " ", 
  "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{3.387970368328846*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "mat", "]"}], "\[LeftDoubleBracket]", "2", 
   "\[RightDoubleBracket]"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{3.387970370615101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3"}], "}"}]}], "\[RightDoubleBracket]"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.387970290169791*^9, 3.387970389391142*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"2", ";;", "3"}], ",", 
    RowBox[{"1", ";;", "4"}]}], "\[RightDoubleBracket]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.387970290169791*^9, 3.387970389391142*^9}, {
  3.388396846085384*^9, 3.388396891013654*^9}, {3.388397155404086*^9, 
  3.388397158095708*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"2", ",", "3"}], "]"}], ",", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", "4"}], "]"}]}], "\[RightDoubleBracket]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.3884183049729*^9, 3.388418334594627*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mit Matrizen rechnen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.3546435000076*^9, 3.35464350759723*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b"},
      {"c", "c"},
      {"e", "f"}
     }], ")"}]}], ";", " ", 
  RowBox[{"mat2", "=", 
   RowBox[{"(", GridBox[{
      {"r", "s", "t"},
      {"u", "v", "w"}
     }], ")"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "mat1"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat2", " ", "+", " ", 
   RowBox[{"Transpose", "[", "mat1", "]"}]}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat1", " ", ".", " ", "mat2"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b", "c"},
      {"d", "e", "f"},
      {"g", "h", "i"}
     }], ")"}]}], ";", " ", 
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35663064417879*^9, 3.35663064515475*^9}, {
  3.35856657754603*^9, 3.35856657870574*^9}}],

Cell[TextData[{
 "Bei der Multiplikation mit einer Matrix von links wird ein Vektor als \
Zeilenvektor, bei der Multiplikation von rechts als Spaltenvektor \
interpretiert.  In beiden F\[ADoubleDot]llen wird ein Vektor erzeugt, der im \
ersten Fall aber von ",
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " als Spaltenvektor und nicht als Zeilenvektor dargestellt wird."
}], "SmallText",
 CellChangeTimes->{{3.35464363231653*^9, 3.3546436927707*^9}, {
  3.35464378635233*^9, 3.35464384221892*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", " ", ".", " ", "mat"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35663065122827*^9, 3.35663065262919*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", " ", ".", " ", "vec"}], " ", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35663065478881*^9, 3.35663065505418*^9}}],

Cell[TextData[{
 "Besser ist es deshalb, wenn Sie in diesen F\[ADoubleDot]llen nicht mit \
Vektoren, sondern mit einzeiligen oder einspaltigen Matrizen rechnen. Eine \
einzeilige Matrix l\[ADoubleDot]sst sich aus einem Vektor einfach durch zus\
\[ADoubleDot]tzliche Listenklammern herstellen, eine einspaltige Matrix durch \
",
 StyleBox["List/@...",
  FontWeight->"Bold"],
 " . Das Produkt wird nun von ",
 StyleBox["MatrixForm",
  FontWeight->"Bold"],
 " auch wie erwartet dargestellt. "
}], "SmallText",
 CellChangeTimes->{{3.35464384593001*^9, 3.35464397704927*^9}, {
  3.3566309349305*^9, 3.35663093567768*^9}, {3.35663099245506*^9, 
  3.3566310466927*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"esm", "=", 
    RowBox[{"List", "/@", "vec"}]}], ")"}], "//", "MatrixForm"}], "\n", 
 RowBox[{
  RowBox[{"mat", ".", "esm"}], " ", "//", "MatrixForm"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "esm", "]"}], ".", " ", "mat"}], " ", "//", 
  "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.35464371491509*^9, 3.35464371930597*^9}, {
   3.35663066538681*^9, 3.35663066595576*^9}, {3.35663070844244*^9, 
   3.35663091744949*^9}, {3.35663105415498*^9, 3.35663107762228*^9}, 
   3.35856650061956*^9, {3.35856653940113*^9, 3.3585666149232*^9}, {
   3.35856978362283*^9, 3.35856979384399*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", 
       RowBox[{"-", "5"}], "6"},
      {"9", "8", "7"}
     }], ")"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Det", "[", "mat1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat2", "=", 
   RowBox[{"Inverse", "[", "mat1", "]"}]}], ";", " ", 
  RowBox[{"mat2", " ", "//", "MatrixForm"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPower", "[", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b"},
       {"c", "d"}
      }], ")"}], ",", " ", "3"}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPower", "[", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"1", "2"},
       {"3", "4"}
      }], ")"}], ",", " ", "20"}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixExp", "[", 
   RowBox[{"(", GridBox[{
      {"0.1", "0.2"},
      {"0.3", "0.4"}
     }], ")"}], "]"}], " ", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"MatrixPower", "[", 
      RowBox[{
       RowBox[{"(", GridBox[{
          {"0.1", "0.2"},
          {"0.3", "0.4"}
         }], ")"}], ",", "i"}], "]"}], 
     RowBox[{"i", "!"}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.3546441428813*^9, 3.35464415409144*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["D\[UDoubleDot]nn besetzte Matrizen", "Section",
 CellChangeTimes->{{3.388417997512327*^9, 3.388418038908612*^9}}],

Cell[TextData[{
 "Gro\[SZ]e Matrizen (und allgemeiner Tensoren) k\[ODoubleDot]nnen mit ",
 StyleBox["SparseArray",
  FontWeight->"Bold"],
 " erzeugt werden.\nDiese d\[UDoubleDot]nne Darstellung verwendet intern eine \
andere Speicherform als die bisher betrachtete dichte Darstellung von \
Matrizen."
}], "SmallText",
 CellChangeTimes->{{3.388402899470959*^9, 3.388402952526662*^9}, {
   3.388416849915383*^9, 3.388416981487954*^9}, 3.388417043846337*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "4"}]}], "}"}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388415882014799*^9, 3.388415883265332*^9}, {
  3.388416447025492*^9, 3.388416448685906*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "4"}]}], "}"}], ",", "5", 
    ",", "x"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388415763489433*^9, 3.388415844982011*^9}, {
  3.388416465445933*^9, 3.388416478738977*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_", ",", "i_"}], "}"}], "->", "2"}], "}"}], ",", 
    "3"}], "]"}], "//", "TensorRank"}]], "Input",
 CellChangeTimes->{{3.388416711674093*^9, 3.388416809449733*^9}}],

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}], "}"}], ",", "100"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.388402058936471*^9, 3.388402085168126*^9}, 
   3.388402310420872*^9}],

Cell[BoxData[
 RowBox[{"ByteCount", "/@", 
  RowBox[{"{", 
   RowBox[{"m", ",", 
    RowBox[{"IdentityMatrix", "[", "100", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.388402111845301*^9, 3.38840231383557*^9}}],

Cell[BoxData[
 RowBox[{"m", "\[Equal]", 
  RowBox[{"IdentityMatrix", "[", "100", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "+", 
   RowBox[{"IdentityMatrix", "[", "100", "]"}]}], "//", "Shallow"}]], "Input",\

 CellChangeTimes->{{3.388410626942874*^9, 3.388410629216228*^9}, {
  3.388410678361852*^9, 3.388410699837553*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "\[Rule]", "2"}], "}"}], 
    ",", "10"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388404366330223*^9, 3.388404410117987*^9}, {
  3.388404601963774*^9, 3.388404757090385*^9}, {3.388404826799876*^9, 
  3.388404868204702*^9}, {3.388404916630098*^9, 3.388404932539763*^9}, {
  3.38840498701661*^9, 3.388405030730197*^9}, {3.388405405122549*^9, 
  3.388405416504605*^9}, {3.388405481430343*^9, 3.388405517720421*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", "10"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.388404366330223*^9, 3.388404410117987*^9}, {
  3.388404601963774*^9, 3.388404757090385*^9}, {3.388404826799876*^9, 
  3.388404868204702*^9}, {3.388404916630098*^9, 3.388404932539763*^9}, {
  3.38840498701661*^9, 3.3884049888197*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[Rule]", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"m", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.388404366330223*^9, 3.388404410117987*^9}, {
  3.388404601963774*^9, 3.388404757090385*^9}, {3.388404826799876*^9, 
  3.388404868204702*^9}, {3.388404916630098*^9, 3.388404932539763*^9}, {
  3.388405044466926*^9, 3.388405048381427*^9}, {3.388405557367668*^9, 
  3.388405567395705*^9}, {3.388406673194089*^9, 3.388406738135728*^9}}],

Cell[BoxData[
 RowBox[{"m", "//", "ArrayRules"}]], "Input",
 CellChangeTimes->{{3.388405421709444*^9, 3.388405434584054*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sparsemat", ":=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "2"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "1"}]}], "}"}], 
     ",", "n"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.388405195251311*^9, 3.388405231279466*^9}, {
  3.388407888062723*^9, 3.388407893962496*^9}, {3.388413271122929*^9, 
  3.388413344337377*^9}, {3.388413384629726*^9, 3.388413407224919*^9}, {
  3.38841346260664*^9, 3.388412875607566*^9}, {3.388412973308769*^9, 
  3.388412985284624*^9}}],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "5"}], "}"}], ",", 
   RowBox[{"sparsemat", "//", "MatrixForm"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.388413682271654*^9, 3.388413906648613*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "=", "#"}], ";", 
     RowBox[{"ByteCount", "/@", 
      RowBox[{"{", 
       RowBox[{"sparsemat", ",", 
        RowBox[{"sparsemat", "//", "Normal"}]}], "}"}]}]}], ")"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"10", ",", "20", ",", "50"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.388413223934214*^9, 3.388413230164698*^9}, {
  3.388413506088732*^9, 3.388413534213648*^9}, {3.388413564677396*^9, 
  3.388413724651474*^9}, {3.388413765386848*^9, 3.388409572664346*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Lineare Gleichungssysteme l\[ODoubleDot]sen", "Section",
 CellChangeTimes->{{3358652743.52556, 3358652744.81013}}],

Cell[TextData[{
 "Die einfachste und allgemeinste Weg zum L\[ODoubleDot]sen eines linearen \
Gleichungssystems geht \[UDoubleDot]ber die ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 "-Funktion. \[CapitalUDoubleDot]ber die ausgegebenen Warnungen muss man sich \
keine Gedanken machen.Wir verwenden im Gegensatz zum ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Handbuch die Notation der Vektoren als einspaltige Matrizen."
}], "SmallText",
 CellChangeTimes->{{3358652655.12218, 3358652774.07678}, {3358652959.5341, 
  3358652994.75142}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3", "1"},
      {"3", "1", "2", 
       RowBox[{"-", "1"}]},
      {"2", "3", "1", "0"}
     }], ")"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"(", GridBox[{
      {"14"},
      {"12"},
      {"7"}
     }], ")"}]}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"(", GridBox[{
      {"x1"},
      {"x2"},
      {"x3"},
      {"x4"}
     }], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35857169851264*^9, 3.35857177080088*^9}, {
  3.35857217294834*^9, 3.35857217578182*^9}, {3.35857222072866*^9, 
  3.35857227270377*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35857016701897*^9, 3.35857017090084*^9}, {
  3.35857177853777*^9, 3.35857180537616*^9}}],

Cell[TextData[{
 "Die Solve-Funktion gibt als Anwort eine Substitutionsliste \
zur\[UDoubleDot]ck, aus der sich die allgemeine L\[ODoubleDot]sung durch \
Substitution in die einspaltige Matrix ",
 StyleBox["x",
  FontWeight->"Bold"],
 " gewinnen l\[ADoubleDot]sst. Beachten Sie, dass die L\[ODoubleDot]sung eine \
einelementige ",
 StyleBox["Menge",
  FontSlant->"Italic"],
 " ist."
}], "SmallText",
 CellChangeTimes->{{3.35865279637057*^9, 3.35865294148766*^9}}],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "/.", "sol"}], "/.", 
    RowBox[{"x4", "\[Rule]", "t"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.35857180901215*^9, 3.35857187356302*^9}, {
  3.35857404024004*^9, 3.35857406112246*^9}, {3.35865443553511*^9, 
  3.35865448063429*^9}}],

Cell[TextData[{
 "Gelegentlich muss die Menge der Variablen angegeben werden, etwa wenn die \
Ausdr\[UDoubleDot]cke noch weitere Parameter enthalten. Diese \
m\[UDoubleDot]ssen dazu aus ",
 StyleBox["x",
  FontWeight->"Bold"],
 " extrahiert werden.  "
}], "SmallText",
 CellChangeTimes->{{3.35865300590346*^9, 3.35865308382804*^9}}],

Cell[BoxData[{
 RowBox[{"vars", "=", 
  RowBox[{"Flatten", "[", "x", "]"}]}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mat", ".", "x"}], "\[Equal]", "b"}], ",", "vars"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.35857326385022*^9, 3.35857327075319*^9}, {
  3.35857330672971*^9, 3.35857331245965*^9}}],

Cell[TextData[{
 "Lineare Gleichungssysteme lassen sich auch mit dem Kommando ",
 StyleBox["LinearSolve",
  FontWeight->"Bold"],
 " l\[ODoubleDot]sen. Dieses ist besonders dann angebracht, wenn es sich um \
gro\[SZ]e lineare Gleichungssysteme handelt oder ein und dasselbe System mit \
vielen verschiedenen rechten Seiten gel\[ODoubleDot]st werden soll. \nEs gibt \
zwei Aufrufvarianten des Kommandos ",
 StyleBox["LinearSolve",
  FontWeight->"Bold"],
 ". Die erste Variante ",
 StyleBox["LinearSolve[mat] ",
  FontWeight->"Bold"],
 "bekommt nur die Koeffizientenmatrix als  Parameter \[UDoubleDot]bergeben \
und generiert daraus ein ",
 StyleBox["LinearSolveFunction",
  FontWeight->"Bold"],
 "-Objekt."
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, 3.35865386937932*^9, 
   3.35865489250533*^9, {3.35865499438126*^9, 3.35865499584768*^9}, {
   3.35865517295396*^9, 3.35865519226922*^9}}],

Cell[BoxData[
 RowBox[{"lsol", "=", 
  RowBox[{"LinearSolve", "[", "mat", "]"}]}]], "Input",
 CellChangeTimes->{
  3.35857020049414*^9, {3.35857271914962*^9, 3.35857272012829*^9}}],

Cell[TextData[{
 "Es handelt sich dabei wie bei einer ",
 StyleBox["InterpolatingFunction",
  FontWeight->"Bold"],
 " um eine namenlose Funktion, von der auch die Berechnungsvorschrift nicht \
explizit bekannt ist. Sie berechnet zu einer vorgegebenen rechten Seite ",
 StyleBox["b",
  FontWeight->"Bold"],
 " eine L\[ODoubleDot]sung des Gleichungssystems."
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, 3.35865386937932*^9, 
   3.35865489250533*^9, {3.35865499438126*^9, 3.35865499584768*^9}, {
   3.35865518093976*^9, 3.35865520311125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"lsol", "[", "b", "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35857272352404*^9, 3.35857274042781*^9}}],

Cell[TextData[{
 "Die zweite Aufrufvariante  ",
 StyleBox["LinearSolve[mat,b] ",
  FontWeight->"Bold"],
 "bekommt als zweiten Parameter die rechte Seite \[UDoubleDot]bergeben und \
entspricht dem Aufruf ",
 StyleBox["LinearSolve[mat][b]. ",
  FontWeight->"Bold"]
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, 3.35865386937932*^9, 
   3.35865489250533*^9, {3.35865499438126*^9, 3.35865499584768*^9}, 
   3.35865520939116*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"l0", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"mat", ",", "b"}], "]"}]}], ")"}], "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.35857017786415*^9, 3.35857018033564*^9}, {
  3.3586524045888*^9, 3.35865241522429*^9}, {3.35865381809516*^9, 
  3.35865382033892*^9}, {3.35865414152423*^9, 3.35865414476544*^9}}],

Cell[TextData[{
 "Im Gegensatz zu ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 " gibt ",
 StyleBox["LinearSolve",
  FontWeight->"Bold"],
 " (im Fall eines l\[ODoubleDot]sbaren Systems) immer nur eine spezielle L\
\[ODoubleDot]sung zur\[UDoubleDot]ck. Da die allgemeine L\[ODoubleDot]sung \
eines linearen Gleichungssystems sich zusammensetzt aus einer solchen \
speziellen L\[ODoubleDot]sung und der allgemeinen L\[ODoubleDot]sung des \
zugeh\[ODoubleDot]rigen homogenen linearen Gleichungssystems, bleibt eine \
Basis des L\[ODoubleDot]sungsraums des homogenen Systems zu bestimmen. Dies \
kann mit dem Kommando ",
 StyleBox["NullSpace",
  FontWeight->"Bold"],
 " erfolgen.  "
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
   3.3586534398062*^9, 3.35865372430013*^9}, {3.35865387680041*^9, 
   3.3586539331338*^9}, {3.3586539679735*^9, 3.3586540446349*^9}, 
   3.3586541744818*^9}],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"ns", "=", 
    RowBox[{"NullSpace", "[", "mat", "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.3586537537539*^9, 3.35865378587705*^9}, {
  3.35865382402268*^9, 3.35865382791245*^9}, {3.35865408873657*^9, 
  3.35865412621901*^9}}],

Cell[TextData[{
 "Beachten Sie, dass ",
 StyleBox["NullSpace",
  FontWeight->"Bold"],
 " eine Liste von ",
 StyleBox["Vektoren",
  FontSlant->"Italic"],
 " und nicht von ",
 StyleBox["einspaltigen Matrizen ",
  FontSlant->"Italic"],
 "zur\[UDoubleDot]ckgibt, so dass noch einige Transformationen erforderlich \
sind, um daraus die allgemeine L\[ODoubleDot]sung zu extrahieren. "
}], "SmallText",
 CellChangeTimes->{{3.35865309927189*^9, 3.35865340484957*^9}, {
  3.3586534398062*^9, 3.35865372430013*^9}, {3.35865387680041*^9, 
  3.3586539331338*^9}, {3.3586539679735*^9, 3.3586540446349*^9}, {
  3.35865417975986*^9, 3.35865419282355*^9}, {3.35865449448116*^9, 
  3.35865459990464*^9}, {3.35865465879999*^9, 3.35865470311631*^9}, {
  3.35865773425295*^9, 3.35865773524704*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ".", "ns"}], "}"}], "//", "Transpose"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865421138221*^9, 3.3586543142061*^9}, {
  3.35865434443796*^9, 3.35865437111272*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"l0", "+", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ".", "ns"}], "}"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865413041175*^9, 3.35865413355736*^9}, {
  3.35865438562387*^9, 3.35865441974542*^9}}],

Cell["\<\
Und hier noch ein Beispiel mit einer mehrdimensionalen \
L\[ODoubleDot]sungsraum.\
\>", "SmallText",
 CellChangeTimes->{{3.35865795499313*^9, 3.35865797741762*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3", "1"},
      {"3", "1", "2", 
       RowBox[{"-", "1"}]}
     }], ")"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"(", GridBox[{
      {"14"},
      {"12"}
     }], ")"}]}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"(", GridBox[{
      {"x1"},
      {"x2"},
      {"x3"},
      {"x4"}
     }], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35857169851264*^9, 3.35857177080088*^9}, {
  3.35857217294834*^9, 3.35857217578182*^9}, {3.35857222072866*^9, 
  3.35857227270377*^9}, {3.35865791191847*^9, 3.35865791640448*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"l0", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"mat", ",", "b"}], "]"}]}], ")"}], "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"ns", "=", 
    RowBox[{"NullSpace", "[", "mat", "]"}]}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t1", ",", "t2"}], "}"}], ".", "ns"}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"l0", "+", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t1", ",", "t2"}], "}"}], ".", "ns"}], "}"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865801490474*^9, 3.35865802679471*^9}}],

Cell["\<\
Es geht allerdings auch einfacher, da die Summe einer einspaltigen Matrix und \
eines Vektors berechnet werden kann und wieder eine einspaltige Matric \
ergibt.\
\>", "SmallText",
 CellChangeTimes->{{3.35866053277858*^9, 3.35866058934788*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"l0", "+", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t1", ",", "t2"}], "}"}], ".", "ns"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.35865999950662*^9, 3.3586600101839*^9}, {
  3.35866005197154*^9, 3.35866008404596*^9}}],

Cell["\<\
Und nun noch einmal Matrizen in d\[UDoubleDot]nner Darstellung.\
\>", "SmallText",
 CellChangeTimes->{{3.388417296010137*^9, 3.388417340612983*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"m", ",", "n", ",", "x", ",", "b"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", ":=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "2"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "1"}]}], "}"}], 
     ",", "n"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vx", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.388405195251311*^9, 3.388405231279466*^9}, {
  3.388407888062723*^9, 3.388407893962496*^9}, {3.388413271122929*^9, 
  3.388413344337377*^9}, {3.388413384629726*^9, 3.388413407224919*^9}, {
  3.38841346260664*^9, 3.388412875607566*^9}, {3.388412973308769*^9, 
  3.388412985284624*^9}, {3.388417422684388*^9, 3.388417487774962*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "=", "#"}], ";", 
     RowBox[{"Det", "[", "m", "]"}]}], ")"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"5", ",", "15"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.38841772573443*^9, 3.388417801361173*^9}, {
  3.388421079223832*^9, 3.388421080992675*^9}, {3.388422151408666*^9, 
  3.38842217500108*^9}, {3.388422210517702*^9, 3.388422212317177*^9}}],

Cell[TextData[{
 "Die Rechnung legt nahe, dass die Determinante gleich ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]]],
 " ist. Zum Beweis dieser Beziehung muss aus der Definition der Determinante \
eine Rekursionsbeziehung hergeleitet werden, die zusammen mit den \
entsprechenden Startwerten dann von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gel\[ODoubleDot]st werden kann."
}], "SmallText",
 CellChangeTimes->{{3.388422250887229*^9, 3.388422560310745*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "n", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"d", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], "-", 
       RowBox[{"d", "[", 
        RowBox[{"n", "-", "2"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"d", "[", "1", "]"}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{"d", "[", "2", "]"}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"d", "[", "n", "]"}], ",", "n"}], "]"}]}], "Input",
 CellChangeTimes->{{3.388421894573548*^9, 3.388422133240942*^9}, {
  3.388422185749061*^9, 3.388422244227123*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "100"}], ";", 
    RowBox[{"sol1", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"m", ".", "vx"}], "==", "b"}], ",", "vx"}], "]"}]}], ";"}], 
   ")"}], "//", "Timing"}]], "Input",
 CellChangeTimes->{{3.388393781907393*^9, 3.388393826387709*^9}, 
   3.388394055610569*^9, {3.388394127267804*^9, 3.38839412877967*^9}, {
   3.38839436440316*^9, 3.388394417636768*^9}, 3.388394480233984*^9, {
   3.388394731843327*^9, 3.388394760989847*^9}, 3.388403980278135*^9, 
   3.388404579092726*^9, 3.388404633546138*^9, 3.388407493388757*^9, {
   3.388407538861857*^9, 3.38840754184186*^9}, {3.388417571869402*^9, 
   3.388417572622283*^9}, {3.388418925610679*^9, 3.388418942507562*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"vx", "/.", "sol1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.388403901340141*^9, 3.388403941550554*^9}, {
  3.388404261392629*^9, 3.388404274481972*^9}, {3.388404416824658*^9, 
  3.388404418261565*^9}, {3.388404467723196*^9, 3.388404469293966*^9}, {
  3.388404963797136*^9, 3.388404994690466*^9}, {3.388407367297989*^9, 
  3.388407369718864*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "100"}], ";", 
    RowBox[{"sol2", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"m", ",", "b"}], "]"}]}], ";"}], ")"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{{3.388393781907393*^9, 3.388393826387709*^9}, 
   3.388394055610569*^9, {3.388394127267804*^9, 3.38839412877967*^9}, {
   3.38839436440316*^9, 3.388394417636768*^9}, {3.388394456898857*^9, 
   3.388394486202117*^9}, {3.388394771121911*^9, 3.38839478063522*^9}, {
   3.388407122751504*^9, 3.388407123969682*^9}, {3.388407161753186*^9, 
   3.388407162589661*^9}, {3.388407239213498*^9, 3.388407248208892*^9}, {
   3.388407294072629*^9, 3.388407323732937*^9}, {3.388407379360445*^9, 
   3.388407391035347*^9}, {3.388407506336564*^9, 3.388407506946062*^9}, {
   3.388407557186571*^9, 3.388407557829658*^9}, {3.388425427317228*^9, 
   3.388425430805955*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", "sol2", "]"}]], "Input",
 CellChangeTimes->{{3.388403901340141*^9, 3.388403941550554*^9}, {
  3.388404261392629*^9, 3.388404274481972*^9}, {3.388404416824658*^9, 
  3.388404418261565*^9}, {3.388404467723196*^9, 3.388404469293966*^9}, {
  3.388404963797136*^9, 3.388404994690466*^9}, {3.38840706549112*^9, 
  3.388407066015884*^9}, {3.388407271628988*^9, 3.388407281449524*^9}, {
  3.388407338675714*^9, 3.388407341493985*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "a", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"b", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SubscriptBox["a", "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.388406529077686*^9, 3.388406581987385*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "10"}], ";", 
    RowBox[{"sol1", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"m", ".", "vx"}], "==", "b"}], ",", "vx"}], "]"}]}], ";"}], 
   ")"}], "//", "Timing"}], "\[IndentingNewLine]", "sol1"}], "Input",
 CellChangeTimes->{
  3.388406613870429*^9, 3.388406656280715*^9, {3.388406750712912*^9, 
   3.388406753766881*^9}, {3.388406847454853*^9, 3.388406851064973*^9}, {
   3.388406885061146*^9, 3.388406897033666*^9}, {3.388407754637655*^9, 
   3.388407764537419*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "=", "10"}], ";", 
    RowBox[{"sol2", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"m", ",", "b"}], "]"}]}], ";"}], ")"}], "//", 
  "Timing"}], "\[IndentingNewLine]", "sol2"}], "Input",
 CellChangeTimes->{{3.388393781907393*^9, 3.388393826387709*^9}, 
   3.388394055610569*^9, {3.388394127267804*^9, 3.38839412877967*^9}, {
   3.38839436440316*^9, 3.388394417636768*^9}, {3.388394456898857*^9, 
   3.388394486202117*^9}, {3.388394771121911*^9, 3.38839478063522*^9}, {
   3.388406950007522*^9, 3.388406973035318*^9}, {3.388407592295928*^9, 
   3.388407601517266*^9}, {3.388407783710961*^9, 3.388407793064355*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eigenwerte und Eigenvektoren", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.35866063062494*^9, 3.35866066366085*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", "5", "6"},
      {"1", 
       RowBox[{"-", "1"}], "0"}
     }], ")"}]}], " ", ";"}]], "Input",
 CellChangeTimes->{{3.35866071108885*^9, 3.35866071143023*^9}}],

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{"mat", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.3586606950156*^9, 3.3586606971978*^9}, {
  3.35866073590874*^9, 3.35866074997513*^9}}],

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"mat", "-", 
   RowBox[{"x", " ", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ew", "=", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"mat", "//", "N"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35866071769948*^9, 3.35866071802753*^9}}],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"(", 
   RowBox[{"ev", "=", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"mat", "//", "N"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.35866072603082*^9, 3.35866072656601*^9}, {
  3.35866202156935*^9, 3.35866204092975*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", " ", ".", 
   RowBox[{"ev", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], "==",
   " ", 
  RowBox[{
   RowBox[{"ew", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], " ", 
   
   RowBox[{
   "ev", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]], "Input",\

 CellChangeTimes->{{3.35866079659399*^9, 3.35866080608567*^9}, {
  3.35866197648761*^9, 3.35866198028292*^9}}]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{647, 571},
WindowMargins->{{Automatic, 102}, {Automatic, 127}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 109, 2, 90, "Title",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[724, 29, 27, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[776, 33, 126, 1, 45, "Subsection"],
Cell[905, 36, 187, 3, 28, "Input"],
Cell[1095, 41, 410, 11, 32, "Input"],
Cell[1508, 54, 683, 18, 114, "SmallText"],
Cell[2194, 74, 189, 5, 32, "Input"],
Cell[2386, 81, 620, 15, 76, "SmallText"],
Cell[3009, 98, 288, 5, 69, "Input"],
Cell[3300, 105, 109, 2, 44, "Input"],
Cell[3412, 109, 218, 4, 59, "SmallText"],
Cell[3633, 115, 303, 7, 71, "Input"],
Cell[3939, 124, 286, 6, 71, "Input"],
Cell[4228, 132, 476, 9, 110, "SmallText"],
Cell[4707, 143, 582, 17, 72, "Input"],
Cell[5292, 162, 396, 11, 70, "SmallText"],
Cell[5691, 175, 164, 4, 56, "Input"],
Cell[5858, 181, 708, 17, 80, "SmallText"],
Cell[6569, 200, 128, 4, 48, "Input"],
Cell[6700, 206, 133, 3, 48, "Input"],
Cell[6836, 211, 178, 5, 48, "Input"],
Cell[7017, 218, 314, 9, 42, "SmallText"],
Cell[7334, 229, 409, 10, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[7780, 244, 52, 0, 29, "Subsection"],
Cell[7835, 246, 219, 6, 112, "SmallText"],
Cell[8057, 254, 362, 9, 49, "Input"],
Cell[8422, 265, 180, 4, 42, "SmallText"],
Cell[8605, 271, 732, 21, 30, "Input"],
Cell[9340, 294, 257, 7, 59, "SmallText"],
Cell[9600, 303, 302, 8, 30, "Input"],
Cell[9905, 313, 263, 8, 46, "Input"],
Cell[10171, 323, 364, 10, 46, "Input"],
Cell[10538, 335, 194, 4, 44, "Input"],
Cell[10735, 341, 137, 3, 44, "Input"],
Cell[10875, 346, 413, 10, 59, "SmallText"],
Cell[11291, 358, 144, 3, 44, "Input"],
Cell[11438, 363, 251, 7, 42, "SmallText"],
Cell[11692, 372, 232, 5, 66, "Input"],
Cell[11927, 379, 315, 6, 66, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12279, 390, 150, 3, 29, "Subsection"],
Cell[12432, 395, 351, 7, 93, "SmallText"],
Cell[12786, 404, 1008, 23, 63, "SmallText"],
Cell[13797, 429, 721, 23, 51, "Input"],
Cell[14521, 454, 262, 6, 36, "Input"],
Cell[14786, 462, 367, 9, 36, "Input"],
Cell[15156, 473, 160, 3, 30, "Input"],
Cell[15319, 478, 282, 5, 59, "SmallText"],
Cell[15604, 485, 226, 6, 48, "Input"],
Cell[15833, 493, 219, 4, 59, "SmallText"],
Cell[16055, 499, 277, 6, 46, "Input"],
Cell[16335, 507, 147, 3, 44, "Input"],
Cell[16485, 512, 471, 12, 63, "SmallText"],
Cell[16959, 526, 195, 4, 48, "Input"],
Cell[17157, 532, 189, 4, 59, "SmallText"],
Cell[17349, 538, 202, 4, 48, "Input"],
Cell[17554, 544, 873, 20, 80, "SmallText"],
Cell[18430, 566, 270, 7, 48, "Input"],
Cell[18703, 575, 314, 7, 48, "Input"],
Cell[19020, 584, 408, 7, 76, "SmallText"],
Cell[19431, 593, 195, 4, 46, "Input"],
Cell[19629, 599, 195, 4, 48, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19873, 609, 36, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[19934, 613, 99, 1, 45, "Subsection"],
Cell[20036, 616, 310, 9, 28, "Input"],
Cell[20349, 627, 66, 1, 28, "Input"],
Cell[20418, 630, 152, 6, 37, "Input"],
Cell[20573, 638, 317, 9, 49, "Input"],
Cell[20893, 649, 383, 12, 49, "Input"],
Cell[21279, 663, 432, 13, 49, "Input"],
Cell[21714, 678, 210, 6, 28, "Input"],
Cell[21927, 686, 829, 24, 69, "Input"],
Cell[22759, 712, 234, 7, 46, "Input"],
Cell[22996, 721, 312, 9, 44, "Input"],
Cell[23311, 732, 220, 6, 44, "Input"],
Cell[23534, 740, 165, 5, 44, "Input"],
Cell[23702, 747, 434, 12, 68, "SmallText"],
Cell[24139, 761, 319, 7, 44, "Input"],
Cell[24461, 770, 375, 8, 44, "Input"],
Cell[24839, 780, 379, 8, 44, "Input"],
Cell[25221, 790, 246, 5, 44, "Input"],
Cell[25470, 797, 337, 9, 44, "Input"],
Cell[25810, 808, 192, 4, 59, "SmallText"],
Cell[26005, 814, 668, 16, 85, "Input"],
Cell[26676, 832, 200, 4, 42, "SmallText"],
Cell[26879, 838, 443, 12, 65, "Input"],
Cell[27325, 852, 228, 5, 42, "SmallText"],
Cell[27556, 859, 131, 2, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[27724, 866, 123, 1, 29, "Subsection"],
Cell[27850, 869, 480, 14, 75, "Input"],
Cell[28333, 885, 160, 3, 28, "Input"],
Cell[28496, 890, 257, 6, 59, "SmallText"],
Cell[28756, 898, 178, 4, 28, "Input"],
Cell[28937, 904, 216, 5, 28, "Input"],
Cell[29156, 911, 333, 9, 28, "Input"],
Cell[29492, 922, 371, 9, 28, "Input"],
Cell[29866, 933, 339, 9, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30254, 948, 39, 0, 35, "Section"],
Cell[30296, 950, 139, 2, 28, "Input"],
Cell[30438, 954, 285, 12, 51, "Input"],
Cell[30726, 968, 90, 2, 28, "Input"],
Cell[30819, 972, 143, 4, 28, "Input"],
Cell[30965, 978, 103, 2, 28, "Input"],
Cell[31071, 982, 385, 12, 53, "Input"],
Cell[31459, 996, 501, 10, 76, "SmallText"],
Cell[31963, 1008, 165, 3, 28, "Input"],
Cell[32131, 1013, 165, 3, 44, "Input"],
Cell[32299, 1018, 662, 15, 93, "SmallText"],
Cell[32964, 1035, 656, 15, 85, "Input"],
Cell[33623, 1052, 199, 8, 67, "Input"],
Cell[33825, 1062, 59, 1, 44, "Input"],
Cell[33887, 1065, 159, 4, 44, "Input"],
Cell[34049, 1071, 208, 7, 55, "Input"],
Cell[34260, 1080, 209, 7, 53, "Input"],
Cell[34472, 1089, 181, 6, 53, "Input"],
Cell[34656, 1097, 454, 15, 70, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[35147, 1117, 119, 1, 35, "Section"],
Cell[35269, 1120, 455, 9, 76, "SmallText"],
Cell[35727, 1131, 632, 19, 28, "Input"],
Cell[36362, 1152, 682, 20, 28, "Input"],
Cell[37047, 1174, 312, 9, 28, "Input"],
Cell[37362, 1185, 318, 10, 28, "Input"],
Cell[37683, 1197, 215, 5, 28, "Input"],
Cell[37901, 1204, 99, 2, 28, "Input"],
Cell[38003, 1208, 240, 6, 28, "Input"],
Cell[38246, 1216, 720, 17, 28, "Input"],
Cell[38969, 1235, 676, 18, 44, "Input"],
Cell[39648, 1255, 928, 24, 65, "Input"],
Cell[40579, 1281, 125, 2, 44, "Input"],
Cell[40707, 1285, 991, 26, 85, "Input"],
Cell[41701, 1313, 238, 6, 44, "Input"],
Cell[41942, 1321, 557, 15, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[42536, 1341, 120, 1, 35, "Section"],
Cell[42659, 1344, 546, 12, 76, "SmallText"],
Cell[43208, 1358, 613, 24, 65, "Input"],
Cell[43824, 1384, 252, 6, 28, "Input"],
Cell[44079, 1392, 463, 12, 76, "SmallText"],
Cell[44545, 1406, 325, 8, 44, "Input"],
Cell[44873, 1416, 332, 8, 59, "SmallText"],
Cell[45208, 1426, 357, 10, 65, "Input"],
Cell[45568, 1438, 970, 22, 127, "SmallText"],
Cell[46541, 1462, 180, 4, 44, "Input"],
Cell[46724, 1468, 622, 13, 76, "SmallText"],
Cell[47349, 1483, 154, 3, 44, "Input"],
Cell[47506, 1488, 505, 12, 59, "SmallText"],
Cell[48014, 1502, 378, 9, 44, "Input"],
Cell[48395, 1513, 919, 21, 110, "SmallText"],
Cell[49317, 1536, 304, 7, 44, "Input"],
Cell[49624, 1545, 778, 18, 59, "SmallText"],
Cell[50405, 1565, 280, 8, 44, "Input"],
Cell[50688, 1575, 313, 9, 44, "Input"],
Cell[51004, 1586, 174, 4, 42, "SmallText"],
Cell[51181, 1592, 616, 22, 81, "Input"],
Cell[51800, 1616, 175, 5, 44, "Input"],
Cell[51978, 1623, 147, 4, 44, "Input"],
Cell[52128, 1629, 203, 7, 44, "Input"],
Cell[52334, 1638, 296, 9, 44, "Input"],
Cell[52633, 1649, 253, 5, 59, "SmallText"],
Cell[52889, 1656, 274, 8, 44, "Input"],
Cell[53166, 1666, 158, 3, 42, "SmallText"],
Cell[53327, 1671, 1431, 41, 105, "Input"],
Cell[54761, 1714, 441, 11, 44, "Input"],
Cell[55205, 1727, 501, 12, 76, "SmallText"],
Cell[55709, 1741, 745, 21, 65, "Input"],
Cell[56457, 1764, 783, 17, 44, "Input"],
Cell[57243, 1783, 433, 8, 44, "Input"],
Cell[57679, 1793, 906, 18, 44, "Input"],
Cell[58588, 1813, 466, 7, 44, "Input"],
Cell[59057, 1822, 326, 9, 65, "Input"],
Cell[59386, 1833, 583, 15, 65, "Input"],
Cell[59972, 1850, 692, 14, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[60701, 1869, 47, 0, 35, "Section"],
Cell[60751, 1871, 140, 2, 28, "Input"],
Cell[60894, 1875, 267, 9, 51, "Input"],
Cell[61164, 1886, 211, 4, 28, "Input"],
Cell[61378, 1892, 148, 4, 28, "Input"],
Cell[61529, 1898, 179, 4, 28, "Input"],
Cell[61711, 1904, 288, 7, 28, "Input"],
Cell[62002, 1913, 439, 12, 28, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
