(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24148,        921]*)
(*NotebookOutlinePosition[     24810,        945]*)
(*  CellTagsIndexPosition[     24766,        941]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->12,
  FontSize->16],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  ScriptMinSize->8,
  FontSize->11],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{12, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{24, 10}, {20, 40}},
  LineSpacing->{1, 0},
  FontSize->41],

Cell[StyleData["Title", "Condensed"],
  CellMargins->{{8, 10}, {4, 8}},
  FontSize->17],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{12, Inherited}, {10, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{24, 10}, {15, 20}},
  LineSpacing->{1, 0},
  FontSize->36],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  FontSize->14],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{24, 10}, {10, 20}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Subsubtitle", "Condensed"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{8, 10}, {8, 12}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "Printout"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellDingbat->"\[FilledSquare]",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{25, Inherited}, {8, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Section", "Presentation"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{40, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Section", "Condensed"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{18, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Section", "Printout"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{13, 0}, {7, 22}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{46, Inherited}, {8, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  TextAlignment->Left,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Arial",
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0.996109, 0.500008, 0]],

Cell[StyleData["Subsection", "Presentation"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{36, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{16, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{9, 0}, {7, 22}},
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{55, Inherited}, {8, 18}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Arial",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[StyleData["Subsubsection", "Presentation"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontFamily->"Arial",
  FontSize->18,
  FontColor->RGBColor[1, 0, 1]],

Cell[StyleData["Subsubsection", "Condensed"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{17, Inherited}, {6, 12}},
  FontFamily->"Arial",
  FontSize->10,
  FontColor->RGBColor[1, 0, 1]],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{9, 0}, {7, 14}},
  FontFamily->"Arial",
  FontSize->11,
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{42, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"Text",
  FontFamily->"Arial"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5}],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{41, 10}, {6, 6}},
  LineSpacing->{1, 3},
  CounterIncrements->"SmallText",
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->GrayLevel[0],
  Background->GrayLevel[0.900008]],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->12],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  FontSize->7]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{72, Inherited}, {8, 10}},
  LineSpacing->{1, 0}],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, 10}, {2, 3}}],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Open  ]],

Cell[StyleData["InputOnly"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{72, Inherited}, {10, 8}},
  LineSpacing->{1, 0}],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{41, Inherited}, {3, 2}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{4, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  ImageMargins->{{62, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Condensed"],
  ImageSize->{175, 175},
  ImageMargins->{{38, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Printout"],
  ImageSize->{250, 250},
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->9],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True],

Cell[StyleData["InlineFormula", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5}],

Cell[StyleData["InlineFormula", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  ScriptLevel->0,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  LineSpacing->{1, 5}],

Cell[StyleData["DisplayFormula", "Condensed"],
  LineSpacing->{1, 1}],

Cell[StyleData["DisplayFormula", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"]],

Cell[StyleData["Hyperlink", "Condensed"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"]],

Cell[StyleData["MainBookLink", "Condensed"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"]],

Cell[StyleData["AddOnsLink", "Condensed"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"]],

Cell[StyleData["RefGuideLink", "Condensed"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"]],

Cell[StyleData["GettingStartedLink", "Condensed"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"]],

Cell[StyleData["OtherInformationLink", "Condensed"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Presentation"]],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->Primary,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Presentation"]],

Cell[StyleData["SelectionPlaceholder", "Condensed"]],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{1, -5},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowToolbars->"RulerBar",
WindowSize->{712, 555},
WindowMargins->{{Automatic, 5}, {15, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 64, "Subtitle"],
Cell[1771, 53, 193, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 54, "Section"],
Cell[2034, 63, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 99, 3, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[2216, 72, 158, 5, 70, 33, 0, "StyleData", "All", "Condensed"],
Cell[2377, 79, 140, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2554, 88, 35, 0, 34, "Section"],
Cell[2592, 90, 101, 3, 70, "Text"],
Cell[2696, 95, 426, 11, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3159, 111, 38, 0, 34, "Section"],

Cell[CellGroupData[{
Cell[3222, 115, 379, 10, 103, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3604, 127, 116, 3, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3723, 132, 87, 2, 70, 37, 0, "StyleData", "Title", "Condensed"],
Cell[3813, 136, 88, 2, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3938, 143, 347, 9, 57, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4288, 154, 119, 3, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4410, 159, 90, 2, 70, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[4503, 163, 91, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4631, 170, 349, 9, 46, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4983, 181, 154, 4, 70, 46, 0, "StyleData", "Subsubtitle", 
"Presentation"],
Cell[5140, 187, 126, 3, 70, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[5269, 192, 125, 3, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5431, 200, 400, 11, 49, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5834, 213, 150, 4, 86, 42, 0, "StyleData", "Section", "Presentation"],
Cell[5987, 219, 130, 3, 48, 39, 0, "StyleData", "Section", "Condensed"],
Cell[6120, 224, 121, 3, 61, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6278, 232, 425, 12, 44, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6706, 246, 153, 4, 84, 45, 0, "StyleData", "Subsection", 
"Presentation"],
Cell[6862, 252, 133, 3, 48, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[6998, 257, 123, 3, 59, 41, 0, "StyleData", "Subsection", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7158, 265, 332, 9, 56, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[7493, 276, 211, 6, 74, 48, 0, "StyleData", "Subsubsection", 
"Presentation"],
Cell[7707, 284, 191, 5, 46, 45, 0, "StyleData", "Subsubsection", 
"Condensed"],
Cell[7901, 291, 149, 4, 49, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8099, 301, 39, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[8163, 305, 133, 4, 44, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[8299, 311, 99, 2, 50, 39, 0, "StyleData", "Text", "Presentation"],
Cell[8401, 315, 93, 2, 42, 36, 0, "StyleData", "Text", "Condensed"],
Cell[8497, 319, 68, 1, 42, 35, 0, "StyleData", "Text", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8602, 325, 225, 7, 56, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[8830, 334, 118, 3, 62, 44, 0, "StyleData", "SmallText", "Presentation"],
Cell[8951, 339, 113, 3, 53, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[9067, 344, 88, 2, 50, 40, 0, "StyleData", "SmallText", "Printout"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9204, 352, 42, 0, 54, "Section"],
Cell[9249, 354, 248, 5, 71, "Text"],

Cell[CellGroupData[{
Cell[9522, 363, 500, 15, 44, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[10025, 380, 106, 2, 50, 40, 0, "StyleData", "Input", "Presentation"],
Cell[10134, 384, 72, 1, 37, 37, 0, "StyleData", "Input", "Condensed"],
Cell[10209, 387, 85, 2, 39, 36, 0, "StyleData", "Input", "Printout"]
}, Open  ]],
Cell[10309, 392, 342, 11, 40, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[10676, 407, 454, 13, 44, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[11133, 422, 107, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[11243, 426, 80, 1, 70, 38, 0, "StyleData", "Output", "Condensed"],
Cell[11326, 429, 86, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11449, 436, 501, 14, 40, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[11953, 452, 123, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[12079, 456, 97, 1, 70, 39, 0, "StyleData", "Message", "Condensed"],
Cell[12179, 459, 138, 3, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12354, 467, 498, 14, 40, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[12855, 483, 121, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[12979, 487, 95, 1, 70, 37, 0, "StyleData", "Print", "Condensed"],
Cell[13077, 490, 109, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13223, 497, 439, 12, 40, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[13665, 511, 94, 1, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[13762, 514, 116, 2, 70, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[13881, 518, 130, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14048, 526, 128, 4, 37, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[14179, 532, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[14242, 535, 56, 1, 70, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[14301, 538, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14480, 548, 43, 0, 34, "Section"],

Cell[CellGroupData[{
Cell[14548, 552, 146, 4, 70, 32, 0, "StyleData", "InlineFormula", "All"],
Cell[14697, 558, 108, 2, 70, 48, 0, "StyleData", "InlineFormula", 
"Presentation"],
Cell[14808, 562, 102, 2, 70, 45, 0, "StyleData", "InlineFormula", 
"Condensed"],
Cell[14913, 566, 77, 1, 70, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15027, 572, 253, 6, 70, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[15283, 580, 72, 1, 70, 49, 0, "StyleData", "DisplayFormula", 
"Presentation"],
Cell[15358, 583, 69, 1, 70, 46, 0, "StyleData", "DisplayFormula", 
"Condensed"],
Cell[15430, 586, 45, 0, 70, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15524, 592, 49, 0, 34, "Section"],
Cell[15576, 594, 123, 4, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[15702, 600, 122, 4, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[15827, 606, 127, 4, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[15991, 615, 33, 0, 34, "Section"],
Cell[16027, 617, 121, 3, 70, "Text"],
Cell[16151, 622, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16380, 629, 295, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16678, 638, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17081, 649, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17471, 660, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[17909, 674, 35, 0, 34, "Section"],
Cell[17947, 676, 184, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[18156, 684, 302, 8, 70, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18461, 694, 44, 0, 70, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[18508, 696, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[18552, 698, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[18674, 703, 104, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[18803, 710, 316, 8, 70, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19122, 720, 47, 0, 70, 47, 0, "StyleData", "MainBookLink", 
"Presentation"],
Cell[19172, 722, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[19219, 724, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19366, 731, 337, 9, 70, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19706, 742, 45, 0, 70, 45, 0, "StyleData", "AddOnsLink", 
"Presentation"],
Cell[19754, 744, 42, 0, 70, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[19799, 746, 107, 2, 70, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19943, 753, 345, 9, 70, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20291, 764, 47, 0, 70, 47, 0, "StyleData", "RefGuideLink", 
"Presentation"],
Cell[20341, 766, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "Condensed"],
Cell[20388, 768, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20535, 775, 328, 8, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20866, 785, 53, 0, 70, 53, 0, "StyleData", "GettingStartedLink", 
"Presentation"],
Cell[20922, 787, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"Condensed"],
Cell[20975, 789, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21128, 796, 332, 8, 70, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21463, 806, 55, 0, 70, 55, 0, "StyleData", "OtherInformationLink", 
"Presentation"],
Cell[21521, 808, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"Condensed"],
Cell[21576, 810, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21743, 818, 37, 0, 34, "Section"],
Cell[21783, 820, 115, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[21923, 827, 145, 5, 70, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[22071, 834, 46, 0, 70, 46, 0, "StyleData", "Placeholder", 
"Presentation"],
Cell[22120, 836, 43, 0, 70, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[22166, 838, 42, 0, 70, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22245, 843, 182, 6, 70, 39, 0, "StyleData", "SelectionPlaceholder", 
"All",
  StyleMenuListing->None],
Cell[22430, 851, 55, 0, 70, 55, 0, "StyleData", "SelectionPlaceholder", 
"Presentation"],
Cell[22488, 853, 52, 0, 70, 52, 0, "StyleData", "SelectionPlaceholder", 
"Condensed"],
Cell[22543, 855, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22643, 861, 36, 0, 34, "Section"],
Cell[22682, 863, 258, 5, 70, "Text"],
Cell[22943, 870, 298, 9, 70, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[23244, 881, 106, 3, 70, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[23353, 886, 150, 5, 70, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[23506, 893, 108, 3, 70, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[23617, 898, 179, 5, 70, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[23799, 905, 115, 3, 70, "Text"],
Cell[23917, 910, 96, 3, 70, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[24016, 915, 104, 2, 70, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

