(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70353,       2186]
NotebookOptionsPosition[     61608,       1942]
NotebookOutlinePosition[     61983,       1959]
CellTagsIndexPosition[     61940,       1956]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Numerische Verfahren", "Title"],

Cell[CellGroupData[{

Cell["Numerische Auswertung symbolischer Ergebnisse", "Section"],

Cell[CellGroupData[{

Cell["Numerische Auswertung von Ausdr\[UDoubleDot]cken", "Subsection",
 CellChangeTimes->{{3360065644.24372, 3360065656.88156}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.3600656759901*^9, 3.36006568365043*^9}}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", "4"], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "4"], "]"}], ",", "60"}], "]"}]], "Input"],

Cell[TextData[{
 "Ist das Argument numerischer Natur und tr\[ADoubleDot]gt der verarbeitende \
Funktionsbezeichner das Attribut ",
 StyleBox["NumericFunction",
  FontWeight->"Bold"],
 ", so wird beim Auswerten eine numerische N\[ADoubleDot]herungsroutine \
aufgerufen. Da die Auswertung der ",
 StyleBox["FullForm",
  FontWeight->"Bold"],
 " ",
 StyleBox["Sin[Times[Pi,Power[4.,-1]]]] ",
  FontSlant->"Italic"],
 "von innen nach au\[SZ]en stets einen numerischen Wert als Argument f\
\[UDoubleDot]r den n\[ADoubleDot]chsten Funktionsaufruf liefert, wird \
letztlich ein numerischr Wert zur\[UDoubleDot]ckgegeben."
}], "SmallText",
 CellChangeTimes->{{3.36006408949384*^9, 3.36006413156917*^9}, {
  3.36006416723493*^9, 3.36006426312986*^9}, {3.36006432545209*^9, 
  3.3600643835311*^9}}],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox["\[Pi]", "4."], "]"}]], "Input",
 CellChangeTimes->{{3.36006414138428*^9, 3.36006417763139*^9}}],

Cell[TextData[{
 "Hier die Best\[ADoubleDot]tigung, dass alle beteiligten Funktionen das \
Attribut ",
 StyleBox["NumericFunction",
  FontWeight->"Bold"],
 " tragen."
}], "SmallText",
 CellChangeTimes->{{3.36006428627043*^9, 3.36006431806073*^9}, {
  3.36006439046014*^9, 3.36006439184031*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemberQ", "[", 
    RowBox[{
     RowBox[{"Attributes", "[", "#", "]"}], ",", "NumericFunction"}], "]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Sin", ",", "Times", ",", "Power"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.36006395416064*^9, 3.36006395720117*^9}, {
  3.36006399608393*^9, 3.36006407425259*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    SqrtBox["2"], "]"}], 
   RowBox[{"N", "[", 
    SqrtBox["8"], "]"}]}], "-", "4"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Chop"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], 
   SqrtBox["8"]}], "-", "4"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rechengenauigkeit", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData["$MachinePrecision"], "Input"],

Cell[TextData[{
 "Rechnungen werden standardm\[ADoubleDot]\[SZ]ig mit Maschinengenauigkeit \
ausgef\[UDoubleDot]hrt. ",
 StyleBox["Precision",
  FontWeight->"Bold"],
 " gibt in diesem Fall den symbolischem Wert ",
 StyleBox["MachinePrecision",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ck, der numerisch (mit ",
 StyleBox["N",
  FontWeight->"Bold"],
 ") zu einem Zahlenwert ausgewertet wird, der auch in der Systemkonstanten ",
 StyleBox["$MachinePrecision",
  FontWeight->"Bold"],
 " gespeichert ist. \nIn fr\[UDoubleDot]heren Versionen war dieser Wert \
ganzzahlig. "
}], "SmallText",
 CellChangeTimes->{{3.36006697765804*^9, 3.36006712760619*^9}}],

Cell[BoxData[
 SqrtBox["2."]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Precision"}]], "Input",
 CellChangeTimes->{{3.36006584308278*^9, 3.36006584643004*^9}}],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellChangeTimes->{{3.36006585118774*^9, 3.3600658522166*^9}}],

Cell[BoxData[
 SqrtBox["2.`30"]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Precision"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["a", "1"], "=", "0.3"}], ";", 
  RowBox[{"b", "=", 
   FractionBox["1", "10"]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["c", "1"], "=", 
  RowBox[{"N", "[", 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["a", "1"], "b"], ",", "40"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Precision", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", "b", ",", 
    SubscriptBox["c", "1"]}], "}"}]}]], "Input"],

Cell[BoxData["0.3`25"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["a", "2"], "=", "0.3000000000000000000000000"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["c", "2"], "=", 
  RowBox[{"N", "[", 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["a", "2"], "b"], ",", "40"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Precision", "/@", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "2"], ",", "b", ",", 
     SubscriptBox["c", "2"]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.3600664981756*^9, 3.36006652117472*^9}, {
  3.36006656339399*^9, 3.36006656383342*^9}, {3.389066866597204*^9, 
  3.389066872655051*^9}}],

Cell[BoxData[
 RowBox[{"MachineNumberQ", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", 
    SubscriptBox["a", "2"], ",", 
    SubscriptBox["c", "1"], ",", 
    SubscriptBox["c", "2"]}], "}"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  SubscriptBox["a", "3"], "=", 
  RowBox[{"N", "[", 
   RowBox[{
    SuperscriptBox["\[Pi]", "2"], ",", "30"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["b", "3"], "=", 
  SuperscriptBox[
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", "35"}], "]"}], "2"]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["a", "3"], "//", "InputForm"}]], "Input"],

Cell[BoxData[{
 RowBox[{"Precision", "[", "12345.1234567890123456789", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Accuracy", "[", "12345.1234567890123456789", "]"}]}], "Input",
 CellChangeTimes->{{3.36006690753897*^9, 3.36006692611695*^9}}],

Cell[BoxData[
 RowBox[{
  SubscriptBox["c", "3"], "=", 
  RowBox[{
   SubscriptBox["a", "3"], "-", 
   SubscriptBox["b", "3"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Precision", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "3"], ",", 
    SubscriptBox["b", "3"], ",", 
    SubscriptBox["c", "3"]}], "}"}]}]], "Input"],

Cell["\<\
Ungenaue Eingaben an wenig signifikanter Stelle haben auf die \
Ergebnisgenauigkeit geringen Einfluss, so dass sich in einem solchen Fall die \
Genauigkeit auch vergr\[ODoubleDot]\[SZ]ern kann.\
\>", "SmallText",
 CellChangeTimes->{{3.36006785504319*^9, 3.36006786891357*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["10", "5"], "+", 
  SubscriptBox["c", "2"]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Precision"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
N\[ADoubleDot]herungswerte in exakte Werte verwandeln\
\>", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36006976518695*^9, 3.36006977113265*^9}}],

Cell[BoxData[{
 RowBox[{"u", "=", 
  FractionBox["5.", "17"]}], "\[IndentingNewLine]", 
 RowBox[{"Rationalize", "[", "u", "]"}]}], "Input",
 CellChangeTimes->{{3.36006954249774*^9, 3.36006957542142*^9}, {
  3.36006962924975*^9, 3.36006975462327*^9}}],

Cell["\<\
Diese beiden Rechnungen sehen zwar gleich aus, sind es aber nicht!\
\>", "SmallText",
 CellChangeTimes->{{3.36007038431491*^9, 3.36007039601667*^9}}],

Cell[BoxData[{
 RowBox[{"u1", "=", "3.14159"}], "\[IndentingNewLine]", 
 RowBox[{"Rationalize", "[", "u1", "]"}]}], "Input",
 CellChangeTimes->{{3.36007045953866*^9, 3.36007047290723*^9}, {
  3.36007094724237*^9, 3.36007094857967*^9}}],

Cell[BoxData[{
 RowBox[{"u2", "=", 
  RowBox[{"N", "[", "\[Pi]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Rationalize", "[", "u2", "]"}]}], "Input",
 CellChangeTimes->{{3.36007000326434*^9, 3.36007002547848*^9}, {
  3.36007043441272*^9, 3.36007044678256*^9}, {3.36007095155426*^9, 
  3.36007095267303*^9}}],

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{"u1", ",", "u2"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.36007031624477*^9, 3.36007036523798*^9}, {
  3.36007095931364*^9, 3.36007096298474*^9}}],

Cell["\<\
Die Umwandlung kann man erzwingen, indem als Pr\[ADoubleDot]zision 0 \
angegeben wird.\
\>", "SmallText",
 CellChangeTimes->{{3.36007074473782*^9, 3.3600707651762*^9}}],

Cell[BoxData[{
 RowBox[{"Rationalize", "[", 
  RowBox[{"u2", ",", "0.007"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{"\[Pi]", ",", "20"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36007019692727*^9, 3.36007020223471*^9}, {
  3.36007077494757*^9, 3.36007077876127*^9}, {3.36007148905984*^9, 
  3.36007152188951*^9}, {3.389090417690626*^9, 3.389090444740647*^9}}],

Cell[BoxData[{
 RowBox[{"Rationalize", "[", 
  RowBox[{"u2", ",", "0"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{"\[Pi]", ",", "25"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36007019692727*^9, 3.36007020223471*^9}, {
   3.36007077494757*^9, 3.36007077876127*^9}, {3.36007148905984*^9, 
   3.36007152188951*^9}, 3.389090417690626*^9, {3.389090465714779*^9, 
   3.389090478283494*^9}}],

Cell[BoxData[{
 RowBox[{"Rationalize", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", "40"}], "]"}], ",", "0"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{"\[Pi]", ",", "50"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.36007153553836*^9, 3.36007154165061*^9}, {
  3.389090492493067*^9, 3.389090523733323*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Gleichungen numerisch l\[ODoubleDot]sen", "Section"],

Cell[CellGroupData[{

Cell["Solve und NSolve", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36007169926176*^9, 3.36007171164551*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.38909107234888*^9}],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3."}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.389091075159512*^9}],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.389091075935499*^9}],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x", ",", " ", 
   "30"}], "]"}]], "Input",
 CellChangeTimes->{3.389091076847848*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "3"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["x", "3"]}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"esol", "=", 
        RowBox[{"Solve", "[", 
         RowBox[{"sys", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ")"}], "//", "N"}]}], 
    ";"}], ")"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.389091078080382*^9, 3.389091078974056*^9}, {
  3.389092283400374*^9, 3.389092355757645*^9}}],

Cell[BoxData[{
 RowBox[{"sol", "//", "Length"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "//", "Union"}], "//", "Length"}]}], "Input",
 CellChangeTimes->{{3.36007214468996*^9, 3.36007214753337*^9}, {
  3.36007222207059*^9, 3.36007222718873*^9}, {3.389091797793416*^9, 
  3.38909180305842*^9}}],

Cell[BoxData[
 RowBox[{"esol", "//", "ByteCount"}]], "Input",
 CellChangeTimes->{{3.389093194072033*^9, 3.38909319871478*^9}, {
  3.38909326335778*^9, 3.389093266199753*^9}}],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389093477973332*^9, 3.389093495789392*^9}, {
  3.389093525884508*^9, 3.389093552783522*^9}, {3.38909512719456*^9, 
  3.38909515354374*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"red", "//", "N"}], "//", "ToRules"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.389095251753577*^9, 3.389095262438842*^9}}],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"sys", ",", "y"}], "]"}]], "Input",
 CellChangeTimes->{{3.389094741459798*^9, 3.389094742363982*^9}, {
  3.389095719917422*^9, 3.389095720274616*^9}}],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FactorList", "[", 
   RowBox[{"First", "[", "%", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389094626911241*^9, 3.389094627248435*^9}, {
  3.389094685031011*^9, 3.389094690601983*^9}, {3.389094737385077*^9, 
  3.38909473787402*^9}}],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"Prepend", "[", 
    RowBox[{"sys", ",", 
     RowBox[{
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"5", ",", "1"}], "\[RightDoubleBracket]"}], "\[Equal]", 
      "0"}]}], " ", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.389094645421779*^9, 3.38909465390985*^9}, {
  3.389094753191833*^9, 3.389094886886545*^9}, {3.389095730532009*^9, 
  3.389095732447599*^9}}],

Cell[BoxData[
 RowBox[{"sys", "/.", "sol"}]], "Input",
 CellChangeTimes->{{3.389096008193856*^9, 3.389096020402485*^9}}],

Cell[BoxData[
 RowBox[{"esys", "=", 
  RowBox[{"First", "/@", "sys"}]}]], "Input",
 CellChangeTimes->{{3.389096050652382*^9, 3.38909608383105*^9}, {
  3.389096130393757*^9, 3.389096153094387*^9}}],

Cell[BoxData[
 RowBox[{"esys", "/.", "sol"}]], "Input",
 CellChangeTimes->{{3.389096088380737*^9, 3.389096160599109*^9}}],

Cell[TextData[{
 StyleBox["NSolve",
  FontWeight->"Bold"],
 " liefert dasselbe Ergebnis wie ",
 StyleBox["Solve[sys,vars]//N",
  FontWeight->"Bold"],
 ", jedoch deutlich schneller und in einer anderen Reihenfolge."
}], "SmallText",
 CellChangeTimes->{{3.36007471813369*^9, 3.36007481901441*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"nsol", "=", 
     RowBox[{"NSolve", "[", 
      RowBox[{"sys", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ";"}], ")"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{3.389095998134172*^9}],

Cell[BoxData[{
 RowBox[{"nsol", "//", "Length"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsol", "//", "Union"}], "//", "Length"}]}], "Input",
 CellChangeTimes->{{3.389091833817414*^9, 3.389091844675533*^9}, {
  3.389097292337571*^9, 3.389097298940567*^9}}],

Cell[BoxData[
 RowBox[{"sys", "/.", "nsol"}]], "Input",
 CellChangeTimes->{{3.36007359794651*^9, 3.36007364378939*^9}, {
   3.3600737222694*^9, 3.36007375627459*^9}, 3.36007539030512*^9, {
   3.3600758040885*^9, 3.36007580679351*^9}, {3.389097397979791*^9, 
   3.389097404393256*^9}}],

Cell[BoxData[
 RowBox[{"esys", "/.", "nsol"}]], "Input",
 CellChangeTimes->{{3.36007359794651*^9, 3.36007364378939*^9}, {
   3.3600737222694*^9, 3.36007375627459*^9}, 3.36007539030512*^9, {
   3.3600758040885*^9, 3.36007580679351*^9}, {3.389097397979791*^9, 
   3.38909743085538*^9}}],

Cell[BoxData[
 RowBox[{"%", "//", "Chop"}]], "Input",
 CellChangeTimes->{{3.3600753955299*^9, 3.36007539953827*^9}}],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389091310862248*^9, 3.389091326258983*^9}, {
   3.389091400598585*^9, 3.389091401445021*^9}, 3.389092251592049*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"red", "//", "N"}], "//", "ToRules"}], "}"}]], "Input",
 CellChangeTimes->{{3.389091369410377*^9, 3.389091370204546*^9}, {
  3.389091641965744*^9, 3.389091657537798*^9}}],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"nsol", "//", "Union"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "/.", "#"}], ")"}], "\[Element]", "Reals"}], "&"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.389091719431737*^9, 3.389091767500763*^9}, 
   3.389092387691032*^9, {3.389097356129688*^9, 3.389097357369535*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Nullstellenbestimmung mit FindRoot", "Subsection",
 CellChangeTimes->{{3360075826.15024, 3360075840.85747}}],

Cell[TextData[{
 "Essentiell transzendente Gleichungen lassen sich mit den Kommandos ",
 StyleBox["Solve",
  FontWeight->"Bold"],
 ", ",
 StyleBox["NSolve",
  FontWeight->"Bold"],
 " oder ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " nicht bearbeiten."
}], "SmallText",
 CellChangeTimes->{{3.36007644589768*^9, 3.36007650744319*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}], "+", "x"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.38909865462651*^9, 3.389098677170375*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.3890910791485*^9, 3.389098677916531*^9}],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.36007595984762*^9, 3.36007596277636*^9}, {
   3.389090869120862*^9, 3.389090879439979*^9}, 3.389091079261645*^9, 
   3.389098679076361*^9}],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.389091079338902*^9, 3.389098680854107*^9}],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.36007595984762*^9, 3.36007596277636*^9}, {
   3.389090869120862*^9, 3.389090894526888*^9}, 3.389091079520486*^9, 
   3.389098682463591*^9}],

Cell["\<\
Der Plot zeigt, dass eine relle L\[ODoubleDot]sung von g1\[Equal]5 in der N\
\[ADoubleDot]he von x\[Equal]2 liegt. \
\>", "SmallText",
 CellChangeTimes->{{3.36007653820643*^9, 3.36007659833257*^9}, 
   3.38909868949809*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36007626139348*^9, 3.36007628496297*^9}, {
   3.36007633771846*^9, 3.36007642383248*^9}, {3.36007696083505*^9, 
   3.36007696613085*^9}, 3.389098691303842*^9}],

Cell[TextData[{
 "Diese kann mit ",
 StyleBox["FindRoot",
  FontWeight->"Bold"],
 " bestimmt werden."
}], "SmallText",
 CellChangeTimes->{{3.36007661766164*^9, 3.3600766404589*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g1", "\[Equal]", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36007630822087*^9, 3.36007631610474*^9}, {
   3.36007634772443*^9, 3.36007634958703*^9}, 3.389091079706916*^9, 
   3.389098693881547*^9}],

Cell[BoxData[
 RowBox[{"g1", " ", "/.", " ", "%"}]], "Input",
 CellChangeTimes->{3.389098695348811*^9}],

Cell[BoxData[
 RowBox[{"g2", "=", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"3", "+", "x"}], "]"}], "-", "x"}]}]], "Input",
 CellChangeTimes->{{3.36007895620801*^9, 3.36007897419477*^9}, 
   3.389090937017077*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"g2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36007851258226*^9, 3.36007856652343*^9}, {
   3.36007861734892*^9, 3.36007863749143*^9}, {3.3600786790354*^9, 
   3.3600786953484*^9}, {3.36007898033526*^9, 3.36007898251125*^9}, 
   3.3890909393428*^9, {3.389099020218315*^9, 3.389099065265135*^9}, {
   3.389099150167825*^9, 3.389099154108057*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007951584244*^9}, 3.389090948852283*^9, {3.389099052024542*^9, 
   3.38909905219318*^9}, {3.38909927684121*^9, 3.38909928377543*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "1"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, 3.389090950756417*^9}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "1"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, {3.36007954503472*^9, 3.36007955784933*^9}, 
   3.38909095332799*^9}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, {3.36007954503472*^9, 3.36007957602125*^9}, 
   3.38909095465242*^9, {3.389099513306256*^9, 3.389099513505991*^9}}],

Cell[BoxData[
 RowBox[{"g2", "/.", "%"}]], "Input",
 CellChangeTimes->{{3.36007960889669*^9, 3.3600796212355*^9}, 
   3.389090990392324*^9}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g2", "\[Equal]", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"0", "+", 
      RowBox[{"0.001", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3600773247419*^9, 3.36007736787578*^9}, {
   3.36007741471647*^9, 3.36007744066294*^9}, {3.36007757341982*^9, 
   3.36007757621741*^9}, {3.36007865337848*^9, 3.3600786543847*^9}, {
   3.36007874148946*^9, 3.36007877631565*^9}, {3.36007947632866*^9, 
   3.36007949588316*^9}, {3.36007954503472*^9, 3.36007957602125*^9}, {
   3.36007976118401*^9, 3.36007982729906*^9}, 3.389090997362078*^9, {
   3.38909971408733*^9, 3.389099714463232*^9}, {3.389105416314259*^9, 
   3.389105458752028*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "10"}], ",", " ", 
     RowBox[{
      SuperscriptBox["x", "y"], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{"sys", " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389091057075512*^9, 3.389091058898647*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", ":=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     SuperscriptBox["x", "2"], "]"}], "-", 
    FractionBox["x", "3"]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.36008071278601*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36008072294103*^9, {3.389100222640972*^9, 3.389100225513729*^9}}],

Cell["Nullstellenbestimmung mit dem Newtonverfahren.", "SmallText",
 CellChangeTimes->{{3.36021737045651*^9, 3.36021739010928*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.6"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.389091060752723*^9, 3.389091065473746*^9}, {
  3.389100373305137*^9, 3.389100391556699*^9}}],

Cell[TextData[{
 "Nullstellenbestimmung mit dem Sekantenverfahren. Hierf\[UDoubleDot]r muss",
 StyleBox[" f ",
  FontSlant->"Italic"],
 "nicht symbolisch differenzierbar sein. "
}], "SmallText",
 CellChangeTimes->{{3.36021737045651*^9, 3.36021739010928*^9}, {
  3.36021742169729*^9, 3.36021744485678*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2.4", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36021739588267*^9, 3.3602174028364*^9}, 
   3.389091066356257*^9, {3.389105505302523*^9, 3.389105559284412*^9}}],

Cell["Problem: Die Nullstelle kann in einem Extremwert liegen. ", "SmallText",
 CellChangeTimes->{{3.36021746197*^9, 3.36021748004205*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["f", "2"], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36008075190213*^9, {3.383383829257607*^9, 3.383383831685763*^9}, 
   3.389091067091527*^9}],

Cell["\<\
Analyse in der N\[ADoubleDot]he von x=3.5: Suche mit Startwert und \
Intervallbegrenzung\
\>", "SmallText",
 CellChangeTimes->{{3.3600808830413*^9, 3.36008093428165*^9}, {
  3.36021618255396*^9, 3.3602161871564*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3.5", ",", "3.3", ",", "3.7"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.36008086520548*^9, 3.36008087739672*^9}, 
   3.389091067827691*^9, {3.389105868554471*^9, 3.389105868835657*^9}}],

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36008123376027*^9, 3.36008124581634*^9}, {
  3.36008128206075*^9, 3.36008130485945*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.36008114110913*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1.5"}]}], "}"}]}]], "Input",
 CellChangeTimes->{3.389091068501084*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.36008117231338*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36008118764146*^9, {3.38910605057238*^9, 3.389106062219138*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.389091069404374*^9, {3.38910684122126*^9, 3.389106841492409*^9}, {
   3.389106942292418*^9, 3.389106943146304*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.1"}], ",", 
     RowBox[{"-", "3.0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.389091069404374*^9, {3.38910684122126*^9, 3.389106841492409*^9}}],

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3.0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36008123376027*^9, 3.36008124581634*^9}, {
  3.36008128206075*^9, 3.36008130485945*^9}, {3.36008133971593*^9, 
  3.36008135752188*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerische Integration", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36012439327498*^9, 3.36012440323138*^9}, {
  3.389107478403149*^9, 3.389107479658545*^9}}],

Cell["\<\
Numerische Bestimmung definiter Integrale ist eine M\[ODoubleDot]glichkeit, \
wenn keine Stammfunktion in Termini anderer Funktionen berechnet werden kann.\
\
\>", "SmallText",
 CellChangeTimes->{{3.36012406871449*^9, 3.36012414745808*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36012400145919*^9, 3.36012403938*^9}}],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellChangeTimes->{{3.36012404949584*^9, 3.36012405235663*^9}}],

Cell[TextData[{
 "Das Ergebnis von ",
 StyleBox["Integrate[f,{x,a,b}]//N ",
  FontWeight->"Bold"],
 "und ",
 StyleBox["NIntegrate[f,{x,a,b}]",
  FontWeight->"Bold"],
 " ist dasselbe.\n",
 StyleBox["NIntegrate",
  FontWeight->"Bold"],
 " geht in einem solchen Fall aber schneller, weil der Aufwand zur \
Feststellung, dass es keine Stammfunktion in geschlossner Form gibt, nicht \
anf\[ADoubleDot]llt."
}], "SmallText",
 CellChangeTimes->{{3.36012416125896*^9, 3.36012426718613*^9}, {
  3.36012430013903*^9, 3.36012433260889*^9}}],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.36012400145919*^9, 3.36012402892309*^9}}],

Cell["\<\
Integration einer Funktion mit Sprungstelle im Integrationsintervall. \
\>", "SmallText",
 CellChangeTimes->{{3.36012434505273*^9, 3.36012436114145*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", "x", "]"}]}]]]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.36012438491806*^9, 3.36012438709391*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sf", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{"f", " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"\[Pi]", "/", "2"}]], 
  RowBox[{"f", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "0", 
   RowBox[{"3", 
    RowBox[{"\[Pi]", "/", "4"}]}]], 
  RowBox[{"f", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", " ", "//", "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sf", "[", 
    FractionBox[
     RowBox[{"3", "\[Pi]"}], "4"], "]"}], "-", 
   RowBox[{"sf", "[", "0", "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.3602194284618*^9, 3.36021946671504*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"sf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.3601244914122*^9}],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3602198108093*^9, 3.36021982169651*^9}, {
  3.36021989020716*^9, 3.36021989121504*^9}}],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "40"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36021984286223*^9, 3.36021984325235*^9}, {
  3.36021990108399*^9, 3.36022002182653*^9}}],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox["\[Pi]", "2"], ",", " ", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"]}], "}"}]}], "]"}]], "Input"],

Cell["Beispiel: Mehrdimensionales Integral", "SmallText",
 CellChangeTimes->{{3.3601251221729*^9, 3.3601251228908*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "f", "]"}], "\n", 
 RowBox[{
  RowBox[{"f", ":=", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "+", 
     FractionBox["21", "10"]}]]}], ";"}]}], "Input",
 CellChangeTimes->{3.3602355640818*^9}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.36012496944293*^9, {3.36022236206055*^9, 3.36022236663199*^9}, {
   3.36022240808796*^9, 3.36022240848814*^9}}],

Cell[TextData[{
 StyleBox["Integrate",
  FontWeight->"Bold"],
 " kommt hier in vern\[UDoubleDot]nftiger Zeit gar nicht durch. Das Kommando \
ist deshalb auskommentiert."
}], "SmallText",
 CellChangeTimes->{{3.36022062361911*^9, 3.36022063951939*^9}, {
  3.36022067634922*^9, 3.3602206844156*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"i", "=", 
      RowBox[{"Integrate", "[", 
       RowBox[{"f", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}]}], ";"}], ")"}], "//",
    "Timing"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.36022936170543*^9, 3.36022936565486*^9}, {
  3.389108427820905*^9, 3.389108454823238*^9}, {3.38910884255939*^9, 
  3.389108853283103*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"WorkingPrecision", "\[Rule]", "15"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{{3.36023557828643*^9, 3.36023561749004*^9}, {
  3.36023568143499*^9, 3.36023569381978*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "//", 
  "Precision"}]], "Input",
 CellChangeTimes->{{3.36023570493952*^9, 3.36023572476466*^9}, {
  3.36023652909542*^9, 3.36023655082495*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Datenanalyse", "Section",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, 
   3.382549354421271*^9, 3.389343121278491*^9}],

Cell[CellGroupData[{

Cell["Fit mit vorgegebenen Basisfunktionen", "Subsection",
 CellChangeTimes->{{3.36756889017536*^9, 3.36756889371428*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"list1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Real", ",", "100"}], "]"}], ",", 
     RowBox[{"{", "80", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["#", "100"], "Pi"}], "]"}], "+", 
        RowBox[{"Random", "[", 
         RowBox[{"Real", ",", "0.3"}], "]"}]}]}], "}"}], "&"}], "/@", 
    "list1"}]}], ";", 
  RowBox[{"gr0", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"PointSize", "[", "0.01", "]"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.36756883836059*^9, 3.36756884012234*^9}, 
   3.36757108635275*^9}],

Cell[BoxData[{
 RowBox[{"f1", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      SuperscriptBox["x", "2"]}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr1"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756895160975*^9, 3.36756896054408*^9}, {
  3.36756900319146*^9, 3.36756900903593*^9}, {3.382759557653988*^9, 
  3.382759564432809*^9}, {3.382864215456792*^9, 3.382864228708426*^9}}],

Cell[TextData[{
 "Dieselbe Aufgabe mit ",
 StyleBox["FindFit",
  FontWeight->"Bold"],
 "."
}], "SmallText",
 CellChangeTimes->{{3.382864340601213*^9, 3.382864370484761*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FindFit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"f1a", "=", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"b", " ", "x"}], "+", " ", "c"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"f1a", "/.", "%"}]}], "Input",
 CellChangeTimes->{{3.382862460263427*^9, 3.382862533898802*^9}, {
   3.382862715240472*^9, 3.382862716638054*^9}, {3.382864262564183*^9, 
   3.382864332440341*^9}, 3.382864399982234*^9}],

Cell[BoxData[{
 RowBox[{"f2", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f2", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756895160975*^9, 3.3675689870168*^9}, {
  3.36756911353827*^9, 3.36756911623518*^9}, {3.382759576030142*^9, 
  3.382759585730101*^9}, {3.382864421209583*^9, 3.382864435488599*^9}}],

Cell[BoxData[{
 RowBox[{"f3", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "10"], "]"}], ",", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "20"], "]"}]}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f3", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756920059633*^9, 3.36756921908864*^9}, {
  3.382759596686402*^9, 3.382759602032047*^9}, {3.382864445230275*^9, 
  3.382864454683993*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Regressionsanalyse (Regress)", "Subsection"],

Cell[BoxData[{
 RowBox[{"f4", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "10"], "]"}]}], "}"}], ",", " ", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"f4", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"gr0", ",", "gr4"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.36756920059633*^9, 3.36756921908864*^9}, {
  3.382759596686402*^9, 3.382759602032047*^9}, {3.382864445230275*^9, 
  3.382864454683993*^9}, {3.382864567655668*^9, 3.382864636665567*^9}}],

Cell[TextData[{
 "Informationen \[UDoubleDot]ber die G\[UDoubleDot]te der Approximation \
liefert das Kommando ",
 StyleBox["Regress",
  FontWeight->"Bold"],
 " aus dem Paket ",
 StyleBox["LinearRegression",
  FontWeight->"Bold"],
 ". Standardm\[ADoubleDot]\[SZ]ig wird die Parametertabelle ausgegeben, es \
gibt aber auch andere interessante Optionen."
}], "SmallText",
 CellChangeTimes->{{3.382865155598654*^9, 3.382865223855791*^9}, {
  3.382865295604817*^9, 3.382865300789606*^9}, {3.382865348549828*^9, 
  3.382865464740365*^9}}],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "10"], "]"}]}], "}"}], ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.382759675665724*^9, {3.38275973920773*^9, 3.382759772166177*^9}, {
   3.38275982812825*^9, 3.38275987064441*^9}, {3.382759944218985*^9, 
   3.382759945888483*^9}, {3.382864519150991*^9, 3.38286455216245*^9}, {
   3.382865005298074*^9, 3.382865009629333*^9}, {3.382865041303789*^9, 
   3.382865042422365*^9}}],

Cell["RegressionReportValues[Regress]", "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Nichtlineare Regression (FindFit)", "Subsection",
 CellChangeTimes->{{3.382869489177463*^9, 3.382869494746026*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"3", 
         RowBox[{"Sin", "[", 
          RowBox[{"5", "x"}], "]"}]}], " ", "+", "  ", 
        RowBox[{"Random", "[", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", " ", 
       RowBox[{"0.01", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"a", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.36757238659488*^9, 3.36757239994618*^9}, 
   3.382869515616863*^9, {3.382869983527439*^9, 3.382869992941007*^9}, {
   3.382870342681602*^9, 3.382870362649077*^9}, {3.382871141306282*^9, 
   3.382871153166371*^9}}],

Cell["\<\
Nichtlineare Fits sind sehr von den Anfangswerten f\[UDoubleDot]r die gew\
\[ADoubleDot]hlten Parameter abh\[ADoubleDot]ngig. Defaultstartwert f\
\[UDoubleDot]r alle Parameter ist 1, was hier weit von den wirklichen Werten \
entfernt ist. \
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"f1", " ", "=", " ", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", "f", ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382869531760619*^9, 3.382869535952392*^9}, {
  3.382870013952154*^9, 3.382870047558389*^9}, {3.382870083343229*^9, 
  3.382870084372604*^9}, {3.382870374687735*^9, 3.382870406684775*^9}}],

Cell["\<\
Mit besseren Startwerten erhalten wir, trotz des hohen Rauschanteils in den \
Daten, einen sehr guten Fit.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"f2", " ", "=", " ", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", "f", ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "5.2"}], "}"}]}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382870113493066*^9, 3.382870150881666*^9}, {
  3.382870428301223*^9, 3.382870462373022*^9}, {3.382870667944184*^9, 
  3.382870679108599*^9}, {3.382871223924885*^9, 3.38287127210097*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", " ", 
   RowBox[{
    RowBox[{"ListPlot", "[", "data", "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f1", ",", "f2"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.36757245799955*^9, 3.36757247543997*^9}, {
   3.38287018878941*^9, 3.382870278169118*^9}, {3.382870489897605*^9, 
   3.382870550207166*^9}, {3.382873263322182*^9, 3.382873280725669*^9}, 
   3.389342310895373*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"20", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}], " ", "+", " ", 
        RowBox[{"10", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"0.2", " ", "x"}], "]"}]}], " ", "+", " ", 
        RowBox[{"10", " ", 
         RowBox[{"Random", "[", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", " ", 
       RowBox[{"0.01", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Sin", "[", " ", 
      RowBox[{"b", " ", "x"}], "]"}]}], " ", "+", " ", 
    RowBox[{"c", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"d", " ", "x"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.36757251442617*^9, 3.36757251521293*^9}, {
  3.382871383144356*^9, 3.382871406269256*^9}}],

Cell[BoxData[
 RowBox[{"f1", "=", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data1", ",", "f", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.3675725294559*^9, 3.36757253029556*^9}, {
   3.382871363752193*^9, 3.382871367683413*^9}, {3.382871416039097*^9, 
   3.382871455445528*^9}, {3.382871513563709*^9, 3.382871521232601*^9}, {
   3.382871553117335*^9, 3.382871555589398*^9}, 3.382871595918028*^9}],

Cell[BoxData[
 RowBox[{"f2", "=", 
  RowBox[{"f", "/.", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data1", ",", "f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "12."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "7."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "0.3"}], "}"}]}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382871466532498*^9, 3.382871528962218*^9}, {
  3.382871614533863*^9, 3.382871616843829*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", " ", 
  RowBox[{
   RowBox[{"ListPlot", "[", "data1", "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "f2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.36757271792934*^9, 3.36757273393646*^9}, {
   3.38287164736062*^9, 3.382871673594124*^9}, 3.382875020776573*^9, {
   3.382875634766848*^9, 3.382875654763021*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Zur Genauigkeit numerischer Rechnungen", "Section",
 CellChangeTimes->{{3360126296.10338, 3360126305.41521}, {3360126344.45992, 
  3360126344.97358}}],

Cell[CellGroupData[{

Cell["PrecisionGoal, AccuracyGoal, WorkingPrecision", "Subsection",
 CellChangeTimes->{{3360126107.35653, 3360126125.12995}}],

Cell[TextData[{
 "Normalerweise rechnet ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " mit Maschinengenauigkeit und verwendet dazu die schnelle interne \
Hardware-Arithmetik."
}], "SmallText",
 CellChangeTimes->{{3360215531.32076, 3360215576.38625}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.36021542966276*^9, 3.36021543539202*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "10"}], ",", " ", 
     RowBox[{
      SuperscriptBox["x", "y"], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Precision"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36021546848598*^9, 3.36021547029298*^9}, {
   3.36023157965807*^9, 3.36023159212324*^9}, 3.36023163018712*^9, 
   3.36023188884662*^9, {3.36023207473844*^9, 3.36023207810307*^9}, {
   3.389091070302349*^9, 3.389091071098694*^9}}],

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "30"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.3602154767564*^9, 3.3602154784429*^9}, {
  3.36021559837167*^9, 3.3602156010192*^9}, {3.36021567055274*^9, 
  3.36021569001069*^9}, {3.36023250832507*^9, 3.36023251105944*^9}}],

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Precision"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.3602154767564*^9, 3.3602154784429*^9}, {
  3.36021559837167*^9, 3.36021563154924*^9}, {3.36023154792005*^9, 
  3.36023156522889*^9}, {3.389109459929128*^9, 3.389109460519064*^9}}],

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{"sys", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}], ",", "\n", "\t", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}], ",", " ", 
    RowBox[{"AccuracyGoal", "\[Rule]", "4"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Precision"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.3602154767564*^9, 3.36021551762969*^9}, {
  3.360233064429*^9, 3.36023307053218*^9}, {3.389109572685782*^9, 
  3.389109572970664*^9}, {3.389109779212212*^9, 3.389109805151708*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"First", "/@", "sys"}], ")"}], "/.", 
  "sol"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36007774174031*^9, 3.36007778025906*^9}, {
  3.36023308824814*^9, 3.36023309065436*^9}, {3.389109765364823*^9, 
  3.389109765958895*^9}, {3.389109813865382*^9, 3.389109815353789*^9}}],

Cell[TextData[{
 "Bei schlecht konditionierten numerischen Problemen muss oft eine andere als \
die Standardeinstellung zwischen den verschiedenen \
Pr\[ADoubleDot]zisionsparametern verwendet werden. \nIm folgenden Beispiel \
lautet das exakte Ergebnis Null, so dass ein N\[ADoubleDot]herungsverfahren \
mit Stellenausl\[ODoubleDot]schung zu \"k\[ADoubleDot]mpfen\" hat. Dies ist \
klarerweise ein Wechselspiel zwischen ",
 StyleBox["AccuracyGoal",
  FontWeight->"Bold"],
 " - wieviele Stellen nach dem Komma garantiert werden sollen - und ",
 StyleBox["WorkingPrecision",
  FontWeight->"Bold"],
 " - auf wieviele Stellen genau daf\[UDoubleDot]r zu rechnen ist. ",
 StyleBox["PrecisionGoal",
  FontWeight->"Bold"],
 " - wieviele g\[UDoubleDot]ltige Ziffern zu produzieren sind - kann dagegen \
keine Role spielen, da das (erwartete) Ergebnis ja gleich Null ist und \
folglich \[UDoubleDot]berhaupt keine g\[UDoubleDot]ltigen Ziffern hat.  "
}], "SmallText",
 CellChangeTimes->{{3.36021573576664*^9, 3.36021576006748*^9}, {
   3.36022961409651*^9, 3.36022985978754*^9}, 3.36023369099824*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["x", "3"]], "-", 
    FractionBox["3", "8"]}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", "Yellow"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.36022942393666*^9, {3.389110094649357*^9, 3.389110118672034*^9}, {
   3.389110212109944*^9, 3.389110219598219*^9}}],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Integral]", "1", "2"], 
  RowBox[{"f", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell["\<\
In der Standardeinstellung kommt das richtige Ergebnis heraus, aber die n\
\[ODoubleDot]tige Konvergenzg\[UDoubleDot]te wird nicht erreicht.\
\>", "SmallText",
 CellChangeTimes->{{3.36022987953486*^9, 3.36022992695015*^9}}],

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022997075961*^9, 3.3602299750911*^9}, 
   3.36023003579674*^9, {3.36023017004137*^9, 3.36023017873887*^9}}],

Cell[TextData[{
 "Wird ",
 StyleBox["AccuracyGoal",
  FontWeight->"Bold"],
 " heruntergesetzt, so verschwinden die Warnungen. Arbeits- und \
Ergebnisgenauigkeit sind im Einklang; das Ergebnis hat geringere ",
 StyleBox["Accuracy",
  FontWeight->"Bold"],
 "."
}], "SmallText",
 CellChangeTimes->{{3.36022987953486*^9, 3.36022996593315*^9}, {
   3.3602300541147*^9, 3.36023010712551*^9}, {3.36023014482042*^9, 
   3.36023016744045*^9}, 3.36023022090847*^9, {3.36023025245614*^9, 
   3.36023027673314*^9}, {3.36023661972394*^9, 3.36023662130364*^9}}],

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "4"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022945471236*^9, 3.36022948200521*^9}, {
  3.36022998361199*^9, 3.36023004753962*^9}, {3.36023018569826*^9, 
  3.36023020841398*^9}}],

Cell[TextData[{
 "Dasselbe mit ",
 StyleBox["PrecisionGoal",
  FontWeight->"Bold"],
 " hat dagegen keinen Einfluss auf das Verhalten, selbst wenn die ",
 StyleBox["WorkingPrecision",
  FontWeight->"Bold"],
 " hochgesetzt wird."
}], "SmallText",
 CellChangeTimes->{{3.36023012064302*^9, 3.36023013612186*^9}, {
  3.36023030132711*^9, 3.36023030976798*^9}, {3.36023035882293*^9, 
  3.36023037201194*^9}}],

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "4"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022945471236*^9, 3.36022950362948*^9}, {
  3.36023028895906*^9, 3.3602302951311*^9}}],

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "4"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "80"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.36022945471236*^9, 3.36022948200521*^9}, {
  3.36022952522082*^9, 3.36022954779431*^9}, {3.36023032115032*^9, 
  3.3602303521504*^9}, {3.36023038689934*^9, 3.3602303900543*^9}}],

Cell[TextData[{
 StyleBox["AccuracyGoal",
  FontWeight->"Bold"],
 " schon."
}], "SmallText",
 CellChangeTimes->{{3.36023041942121*^9, 3.36023042306719*^9}}],

Cell[BoxData[{
 RowBox[{"NIntegrate", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "30"}], ",", "  ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Accuracy"}]}], "Input",
 CellChangeTimes->{{3.360230406979*^9, 3.36023041012312*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["ExtraPrecision", "Subsection",
 CellChangeTimes->{{3.36012622524907*^9, 3.36012623747473*^9}}],

Cell[TextData[{
 "Die von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " verwendeten Algorithmen zur numerischen Auswertung\nmathematischer \
Funktionen sind so ausgelegt, dass sie die Genauigkeit so weit\nals m\
\[ODoubleDot]glich erhalten. Dazu wird intern an vielen Stellen mit h\
\[ODoubleDot]herer Pr\[ADoubleDot]zision gerechnet. "
}], "SmallText",
 CellChangeTimes->{{3360068218.80344, 3360068289.5948}, {3360068326.60259, 
  3360068358.57007}}],

Cell[BoxData[{
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["10", "10"], "]"}], ",", "30"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.3600679230649*^9, 3.36006792696891*^9}}],

Cell[TextData[{
 "Diese intern vorgesehen Pr\[ADoubleDot]zisionserh\[ODoubleDot]hung ist \
durch den in der Systemvariablen ",
 StyleBox["$MaxExtraPrecision",
  FontWeight->"Bold"],
 " gespeicherten Wert begrenzt, was an manchen Stellen nicht ausreicht."
}], "SmallText",
 CellChangeTimes->{{3.36006836851485*^9, 3.36006844829324*^9}}],

Cell[BoxData[{
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["10", "100"], "]"}], ",", "30"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.36006793383255*^9, 3.36006793712645*^9}}],

Cell[TextData[{
 "Verwenden Sie ",
 StyleBox["Block",
  FontWeight->"Bold"],
 ", um Systemvariablen intermedi\[ADoubleDot]r zu ver\[ADoubleDot]ndern, ohne \
dass dies globale Auswirkungen hat."
}], "SmallText",
 CellChangeTimes->{{3.36006846427262*^9, 3.36006853282211*^9}}],

Cell[BoxData[{
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", " ", "=", " ", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox["10", "100"], "]"}], ",", "30"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Precision"}]}], "Input",
 CellChangeTimes->{{3.3600680696694*^9, 3.36006817858659*^9}, {
  3.36006831392927*^9, 3.36006831611745*^9}, {3.36006849299514*^9, 
  3.36006850421036*^9}, {3.36006949641559*^9, 3.36006950029108*^9}}],

Cell["\<\
Der vorherige globale Wert der Systemvariablen wird nach Verlassen des \
Block-Konstrukts automatisch wieder hergestellt.\
\>", "SmallText",
 CellChangeTimes->{{3.36006916086659*^9, 3.36006921568755*^9}}],

Cell[BoxData["$MaxExtraPrecision"], "Input",
 CellChangeTimes->{{3.36006815566573*^9, 3.36006815644675*^9}}]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{659, 600},
WindowMargins->{{Automatic, 80}, {Automatic, 59}},
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 37, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[652, 27, 64, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[741, 31, 128, 1, 45, "Subsection"],
Cell[872, 34, 139, 2, 28, "Input"],
Cell[1014, 38, 110, 3, 41, "Input"],
Cell[1127, 43, 136, 4, 41, "Input"],
Cell[1266, 49, 787, 18, 93, "SmallText"],
Cell[2056, 69, 146, 3, 41, "Input"],
Cell[2205, 74, 294, 8, 42, "SmallText"],
Cell[2502, 84, 364, 10, 28, "Input"],
Cell[2869, 96, 153, 6, 36, "Input"],
Cell[3025, 104, 53, 1, 44, "Input"],
Cell[3081, 107, 93, 4, 48, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3211, 116, 39, 0, 29, "Subsection"],
Cell[3253, 118, 76, 1, 28, "Input"],
Cell[3332, 121, 43, 0, 28, "Input"],
Cell[3378, 123, 650, 17, 93, "SmallText"],
Cell[4031, 142, 39, 1, 32, "Input"],
Cell[4073, 145, 122, 2, 28, "Input"],
Cell[4198, 149, 113, 2, 28, "Input"],
Cell[4314, 153, 42, 1, 32, "Input"],
Cell[4359, 156, 58, 1, 28, "Input"],
Cell[4420, 159, 148, 5, 42, "Input"],
Cell[4571, 166, 175, 6, 46, "Input"],
Cell[4749, 174, 163, 5, 44, "Input"],
Cell[4915, 181, 32, 0, 44, "Input"],
Cell[4950, 183, 297, 10, 66, "Input"],
Cell[5250, 195, 349, 9, 44, "Input"],
Cell[5602, 206, 226, 7, 44, "Input"],
Cell[5831, 215, 315, 11, 68, "Input"],
Cell[6149, 228, 80, 2, 44, "Input"],
Cell[6232, 232, 241, 4, 65, "Input"],
Cell[6476, 238, 140, 5, 44, "Input"],
Cell[6619, 245, 187, 6, 44, "Input"],
Cell[6809, 253, 286, 5, 76, "SmallText"],
Cell[7098, 260, 96, 3, 46, "Input"],
Cell[7197, 265, 58, 1, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[7292, 271, 83, 2, 29, "Subsection"],
Cell[7378, 275, 140, 2, 28, "Input"],
Cell[7521, 279, 250, 5, 64, "Input"],
Cell[7774, 286, 159, 3, 42, "SmallText"],
Cell[7936, 291, 235, 4, 49, "Input"],
Cell[8174, 297, 308, 6, 49, "Input"],
Cell[8485, 305, 218, 5, 28, "Input"],
Cell[8706, 312, 178, 4, 42, "SmallText"],
Cell[8887, 318, 405, 8, 65, "Input"],
Cell[9295, 328, 429, 9, 65, "Input"],
Cell[9727, 339, 371, 10, 65, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10147, 355, 58, 0, 35, "Section"],
Cell[CellGroupData[{
Cell[10230, 359, 38, 0, 45, "Subsection"],
Cell[10271, 361, 140, 2, 28, "Input"],
Cell[10414, 365, 239, 8, 30, "Input"],
Cell[10656, 375, 50, 1, 28, "Input"],
Cell[10709, 378, 241, 8, 30, "Input"],
Cell[10953, 388, 241, 8, 30, "Input"],
Cell[11197, 398, 258, 8, 30, "Input"],
Cell[11458, 408, 805, 27, 52, "Input"],
Cell[12266, 437, 304, 6, 49, "Input"],
Cell[12573, 445, 174, 3, 28, "Input"],
Cell[12750, 450, 382, 9, 28, "Input"],
Cell[13135, 461, 199, 5, 28, "Input"],
Cell[13337, 468, 202, 4, 28, "Input"],
Cell[13542, 474, 282, 6, 44, "Input"],
Cell[13827, 482, 507, 13, 44, "Input"],
Cell[14337, 497, 120, 2, 44, "Input"],
Cell[14460, 501, 196, 4, 44, "Input"],
Cell[14659, 507, 121, 2, 44, "Input"],
Cell[14783, 511, 295, 8, 59, "SmallText"],
Cell[15081, 521, 292, 10, 44, "Input"],
Cell[15376, 533, 262, 5, 65, "Input"],
Cell[15641, 540, 284, 5, 44, "Input"],
Cell[15928, 547, 284, 5, 44, "Input"],
Cell[16215, 554, 116, 2, 44, "Input"],
Cell[16334, 558, 313, 7, 44, "Input"],
Cell[16650, 567, 221, 5, 44, "Input"],
Cell[16874, 574, 366, 10, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[17277, 589, 114, 1, 29, "Subsection"],
Cell[17394, 592, 336, 12, 59, "SmallText"],
Cell[17733, 606, 283, 8, 28, "Input"],
Cell[18019, 616, 175, 4, 28, "Input"],
Cell[18197, 622, 276, 6, 28, "Input"],
Cell[18476, 630, 178, 4, 28, "Input"],
Cell[18657, 636, 282, 6, 28, "Input"],
Cell[18942, 644, 233, 5, 42, "SmallText"],
Cell[19178, 651, 392, 10, 28, "Input"],
Cell[19573, 663, 181, 6, 42, "SmallText"],
Cell[19757, 671, 325, 8, 44, "Input"],
Cell[20085, 681, 103, 2, 44, "Input"],
Cell[20191, 685, 285, 8, 44, "Input"],
Cell[20479, 695, 577, 13, 44, "Input"],
Cell[21059, 710, 604, 12, 44, "Input"],
Cell[21666, 724, 511, 11, 44, "Input"],
Cell[22180, 737, 537, 11, 44, "Input"],
Cell[22720, 750, 583, 11, 44, "Input"],
Cell[23306, 763, 140, 3, 44, "Input"],
Cell[23449, 768, 733, 15, 44, "Input"],
Cell[24185, 785, 584, 18, 68, "Input"],
Cell[24772, 805, 174, 6, 56, "Input"],
Cell[24949, 813, 201, 6, 44, "Input"],
Cell[25153, 821, 229, 6, 44, "Input"],
Cell[25385, 829, 131, 1, 42, "SmallText"],
Cell[25519, 832, 381, 11, 44, "Input"],
Cell[25903, 845, 305, 7, 42, "SmallText"],
Cell[26211, 854, 280, 6, 44, "Input"],
Cell[26494, 862, 139, 1, 42, "SmallText"],
Cell[26636, 865, 306, 9, 46, "Input"],
Cell[26945, 876, 226, 5, 42, "SmallText"],
Cell[27174, 883, 298, 7, 44, "Input"],
Cell[27475, 892, 249, 6, 44, "Input"],
Cell[27727, 900, 222, 7, 44, "Input"],
Cell[27952, 909, 346, 12, 44, "Input"],
Cell[28301, 923, 222, 7, 44, "Input"],
Cell[28526, 932, 272, 8, 44, "Input"],
Cell[28801, 942, 296, 8, 44, "Input"],
Cell[29100, 952, 279, 8, 44, "Input"],
Cell[29382, 962, 317, 8, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29748, 976, 41, 0, 35, "Section"],
Cell[29792, 978, 189, 3, 28, "Input"],
Cell[29984, 983, 250, 5, 59, "SmallText"],
Cell[30237, 990, 343, 10, 30, "Input"],
Cell[30583, 1002, 114, 2, 28, "Input"],
Cell[30700, 1006, 529, 15, 76, "SmallText"],
Cell[31232, 1023, 347, 10, 30, "Input"],
Cell[31582, 1035, 163, 3, 42, "SmallText"],
Cell[31748, 1040, 388, 12, 88, "Input"],
Cell[32139, 1054, 200, 6, 57, "Input"],
Cell[32342, 1062, 172, 5, 79, "Input"],
Cell[32517, 1069, 173, 5, 57, "Input"],
Cell[32693, 1076, 192, 6, 79, "Input"],
Cell[32888, 1084, 55, 1, 44, "Input"],
Cell[32946, 1087, 251, 7, 58, "Input"],
Cell[33200, 1096, 213, 6, 44, "Input"],
Cell[33416, 1104, 195, 6, 58, "Input"],
Cell[33614, 1112, 357, 9, 58, "Input"],
Cell[33974, 1123, 414, 10, 58, "Input"],
Cell[34391, 1135, 238, 7, 58, "Input"],
Cell[34632, 1144, 119, 1, 42, "SmallText"],
Cell[34754, 1147, 434, 14, 96, "Input"],
Cell[35191, 1163, 388, 11, 44, "Input"],
Cell[35582, 1176, 296, 7, 42, "SmallText"],
Cell[35881, 1185, 593, 17, 28, "Input"],
Cell[36477, 1204, 295, 10, 44, "Input"],
Cell[36775, 1216, 486, 13, 65, "Input"],
Cell[37264, 1231, 239, 5, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[37540, 1241, 143, 2, 35, "Section"],
Cell[CellGroupData[{
Cell[37708, 1247, 122, 1, 45, "Subsection"],
Cell[37833, 1250, 913, 28, 106, "Input"],
Cell[38749, 1280, 738, 20, 72, "Input"],
Cell[39490, 1302, 173, 6, 42, "SmallText"],
Cell[39666, 1310, 583, 15, 52, "Input"],
Cell[40252, 1327, 699, 19, 85, "Input"],
Cell[40954, 1348, 783, 23, 98, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[41774, 1376, 50, 0, 29, "Subsection"],
Cell[41827, 1378, 849, 23, 82, "Input"],
Cell[42679, 1403, 534, 13, 76, "SmallText"],
Cell[43216, 1418, 714, 16, 60, "Input"],
Cell[43933, 1436, 48, 0, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[44018, 1441, 121, 1, 29, "Subsection"],
Cell[44142, 1444, 947, 26, 69, "Input"],
Cell[45092, 1472, 268, 5, 59, "SmallText"],
Cell[45363, 1479, 435, 9, 28, "Input"],
Cell[45801, 1490, 135, 3, 42, "SmallText"],
Cell[45939, 1495, 555, 14, 28, "Input"],
Cell[46497, 1511, 590, 15, 44, "Input"],
Cell[47090, 1528, 1043, 31, 65, "Input"],
Cell[48136, 1561, 517, 11, 44, "Input"],
Cell[48656, 1574, 586, 17, 44, "Input"],
Cell[49245, 1593, 519, 13, 44, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[49813, 1612, 156, 2, 35, "Section"],
Cell[CellGroupData[{
Cell[49994, 1618, 125, 1, 45, "Subsection"],
Cell[50122, 1621, 258, 7, 59, "SmallText"],
Cell[50383, 1630, 140, 2, 28, "Input"],
Cell[50526, 1634, 972, 25, 112, "Input"],
Cell[51501, 1661, 557, 13, 49, "Input"],
Cell[52061, 1676, 625, 14, 85, "Input"],
Cell[52689, 1692, 695, 15, 105, "Input"],
Cell[53387, 1709, 375, 8, 65, "Input"],
Cell[53765, 1719, 1090, 20, 144, "SmallText"],
Cell[54858, 1741, 524, 15, 81, "Input"],
Cell[55385, 1758, 144, 4, 79, "Input"],
Cell[55532, 1764, 233, 4, 59, "SmallText"],
Cell[55768, 1770, 345, 8, 65, "Input"],
Cell[56116, 1780, 547, 13, 59, "SmallText"],
Cell[56666, 1795, 419, 9, 65, "Input"],
Cell[57088, 1806, 402, 11, 59, "SmallText"],
Cell[57493, 1819, 375, 9, 65, "Input"],
Cell[57871, 1830, 521, 11, 65, "Input"],
Cell[58395, 1843, 156, 5, 42, "SmallText"],
Cell[58554, 1850, 389, 9, 65, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[58980, 1864, 100, 1, 29, "Subsection"],
Cell[59083, 1867, 460, 10, 76, "SmallText"],
Cell[59546, 1879, 264, 7, 52, "Input"],
Cell[59813, 1888, 335, 7, 59, "SmallText"],
Cell[60151, 1897, 266, 7, 52, "Input"],
Cell[60420, 1906, 274, 7, 59, "SmallText"],
Cell[60697, 1915, 543, 13, 68, "Input"],
Cell[61243, 1930, 214, 4, 59, "SmallText"],
Cell[61460, 1936, 108, 1, 44, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
