(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45264,       1415]
NotebookOptionsPosition[     40003,       1265]
NotebookOutlinePosition[     40414,       1283]
CellTagsIndexPosition[     40371,       1280]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Summen und Integrale", "Title",
 CellChangeTimes->{{3.36386182531826*^9, 3.36386182729626*^9}, {
  3.382549130804531*^9, 3.382549138378205*^9}, {3.382669100417725*^9, 
  3.382669104129491*^9}}],

Cell[CellGroupData[{

Cell["Folgen und Partialsummen", "Section",
 CellChangeTimes->{{3.382549487164993*^9, 3.382549503138874*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     SuperscriptBox["i", "k"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.389302486781149*^9, 3.389302488512284*^9}}],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], 
    SuperscriptBox["x", "k"], 
    SuperscriptBox["y", 
     RowBox[{"n", "-", "k"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "PowerExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hypergeometrische Summen", "Section"],

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"n", "!"}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", "1"}], "]"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"n", "!"}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", "1"}], "]"}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "-", 
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{"2", "n"}], ",", "n"}], "]"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], "2"]}]], "Input"],

Cell["\<\
Die Formel l\[ADoubleDot]sst sich \[UDoubleDot]ber lineare Rekursionen und \
doppeltes Summieren beweisen. 
f[n,k] etwa erf\[UDoubleDot]llt die folgende zweistellige lineare \
Rekursionsbeziehung.\
\>", "SmallText",
 CellChangeTimes->{{3.382508238709032*^9, 3.382508343972766*^9}, {
  3.38250840910117*^9, 3.382508445347786*^9}}],

Cell[BoxData[
 RowBox[{"eqn1", "=", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"f", "[", 
     RowBox[{"n", ",", "k"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", "k"}], "]"}], "+", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", 
        RowBox[{"k", "-", "1"}]}], "]"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "2"}], ",", "k"}], "]"}], "-", 
      RowBox[{"2", 
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"n", "-", "2"}], ",", 
         RowBox[{"k", "-", "1"}]}], "]"}]}], "+", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"n", "-", "2"}], ",", 
        RowBox[{"k", "-", "2"}]}], "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{3.36422777706755*^9}],

Cell[TextData[{
 "Das kann mit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " bis k=14 mit ",
 StyleBox["FullSImplify",
  FontWeight->"Bold"],
 " \[UDoubleDot]berpr\[UDoubleDot]ft werden."
}], "SmallText",
 CellChangeTimes->{{3.382508459947687*^9, 3.382508483202638*^9}, {
  3.382510121085491*^9, 3.382510144822508*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"eqn1", ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "2", ",", "14"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.3642277800087*^9, {3.382508048028452*^9, 3.382508057461228*^9}, {
   3.382508142700404*^9, 3.382508143509122*^9}, {3.382508487118475*^9, 
   3.382508526770288*^9}, {3.382509770393974*^9, 3.382509792581563*^9}, {
   3.382510114503443*^9, 3.38251011485649*^9}}],

Cell[TextData[{
 "Bei gr\[ODoubleDot]\[SZ]eren Werten f\[UDoubleDot]r k muss noch ",
 StyleBox["FunctionExpand",
  FontWeight->"Bold"],
 " vorangestellt werden."
}], "SmallText",
 CellChangeTimes->{{3.382508535845833*^9, 3.382508569455341*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"eqn1", "/.", 
    RowBox[{"k", "\[Rule]", "15"}]}], ")"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "FunctionExpand"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.382508108997956*^9, 3.382508131325231*^9}, {
  3.382510154913345*^9, 3.382510186159529*^9}}],

Cell[TextData[{
 "Interessanterweise hat ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " mit demselben Ausdruck f\[UDoubleDot]r allgemeine k keine Probleme."
}], "SmallText",
 CellChangeTimes->{{3.382511257711999*^9, 3.382511275692878*^9}}],

Cell[BoxData[
 RowBox[{"eqn1", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.3642277818817*^9, {3.382508644285171*^9, 3.382508654809138*^9}, {
   3.382508686619791*^9, 3.382508701817503*^9}}],

Cell[TextData[{
 "Summiert man diese Relation \[UDoubleDot]ber alle k, so ergibt sich wegen \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"n"},
      {"k"}
     }], ")"}], TraditionalForm]]],
 "=0 f\[UDoubleDot]r k<0 und k>n f\[UDoubleDot]r \n     s[n] = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "k"], 
    RowBox[{"f", "[", 
     RowBox[{"n", ",", "k"}], "]"}]}], TraditionalForm]]],
 " \ndie Beziehung"
}], "SmallText",
 CellChangeTimes->{{3.382511361527639*^9, 3.382511562040403*^9}}],

Cell[BoxData[
 RowBox[{"eqn2", "=", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"s", "[", "n", "]"}]}], "\[Equal]", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}], ")"}], 
    RowBox[{"s", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{3.36422778799814*^9, 3.389303693466614*^9}],

Cell[TextData[{
 StyleBox["RSolve",
  FontWeight->"Bold"],
 " liefert dann die eingangs von ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gefundene Antwort."
}], "SmallText",
 CellChangeTimes->{{3.382511696917897*^9, 3.382511740881455*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eqn2", ",", 
      RowBox[{
       RowBox[{"s", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"s", "[", "n", "]"}], ",", "n"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.36422779477748*^9, 3.36422780006068*^9}, 
   3.389303693474971*^9}],

Cell["\<\
Das bisher untersuchte Beispiel ist ein Spezialfall der folgenden \
allgemeineren Summationsaufgabe.\
\>", "SmallText",
 CellChangeTimes->{{3.382511750474981*^9, 3.382511780159805*^9}, {
  3.382512030491013*^9, 3.382512051468033*^9}}],

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Binomial", "[", 
       RowBox[{"n", ",", "k"}], "]"}], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "k"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], 
      RowBox[{"n", "-", "k"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "Das Ergebnis kann auch in Termini der (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ebenfalls bekannten) Legendre-Polynome ",
 StyleBox["LegendreP",
  FontWeight->"Bold"],
 " angegeben werden, wie ein Vergleich der Ergebnisse f\[UDoubleDot]r einige \
Werte von n zeigt."
}], "SmallText",
 CellChangeTimes->{{3.382512330887535*^9, 3.382512377299097*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"res", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}], "//", 
  "Together"}], "\n", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "n"], 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "x"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}], "//", 
  "Together"}]}], "Input",
 CellChangeTimes->{3.382512398937433*^9}],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " hat aber selbst mit ",
 StyleBox["FullSimplify",
  FontWeight->"Bold"],
 " Schwierigkeiten, dies in symbolischer Form zu erkennen."
}], "SmallText",
 CellChangeTimes->{{3.382512811957578*^9, 3.382512877244542*^9}, {
   3.382512923852315*^9, 3.382512928487038*^9}, 3.382512965624206*^9, {
   3.382611879803169*^9, 3.382611880803445*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "x"}], ")"}], "n"], 
    RowBox[{"LegendreP", "[", 
     RowBox[{"n", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512500899923*^9}}],

Cell[TextData[{
 "F\[UDoubleDot]r konkrete Werte von n dagegen wird bereits beim Einsetzen \
sowohl ",
 StyleBox["Hypergeometric2F1",
  FontWeight->"Bold"],
 " als auch ",
 StyleBox["LegendreP",
  FontWeight->"Bold"],
 " durch die entsprechende rationale Funktion ersetzt, so dass ein einfaches \
",
 StyleBox["Together",
  FontWeight->"Bold"],
 " zum Nachweis der Identit\[ADoubleDot]t ausreicht."
}], "SmallText",
 CellChangeTimes->{{3.382611527046444*^9, 3.382611541142561*^9}, {
  3.382611761957574*^9, 3.382611803773107*^9}, {3.382611839361049*^9, 
  3.382611865290029*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"res", "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "x"}], ")"}], "n"], 
       RowBox[{"LegendreP", "[", 
        RowBox[{"n", ",", 
         RowBox[{"1", "/", "x"}]}], "]"}]}]}], ")"}], "/.", 
    RowBox[{"n", "->", "#"}]}], "&"}], "/@", 
  RowBox[{"Range", "[", "10", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Together"}]}], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512600926745*^9}, {
  3.382512697574273*^9, 3.382512779226465*^9}, {3.382611670808178*^9, 
  3.382611706692546*^9}, {3.382611819614658*^9, 3.382611827671535*^9}, {
  3.382672449181648*^9, 3.38267245779078*^9}}],

Cell[TextData[{
 "Dieselbe Simplifikationsfrage an ",
 StyleBox["FullSImplify",
  FontWeight->"Bold"],
 " mit einer logischen Restriktion als zweitem Parameter kann ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dagegen nicht vereinfachen, selbst wenn die Restriktion mit ",
 StyleBox["Reduce",
  FontWeight->"Bold"],
 " in eine explizite endliche Alternative umgewandelt wird."
}], "SmallText",
 CellChangeTimes->{{3.382611894179518*^9, 3.382611998319406*^9}}],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"res", "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "n"], 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "x"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"0", "<", "n", "<", "5"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512600926745*^9}, {
  3.382512697574273*^9, 3.382512698647642*^9}}],

Cell[BoxData[{
 RowBox[{"cc", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"0", "<", "n", "<", "5"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"res", "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "n"], 
     RowBox[{"LegendreP", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "x"}]}], "]"}]}]}], ",", "cc"}], "]"}]}], "Input",
 CellChangeTimes->{{3.382512414778267*^9, 3.382512600926745*^9}, {
  3.382512697574273*^9, 3.382512698647642*^9}, {3.382519354581516*^9, 
  3.382519412203306*^9}}],

Cell["\<\
Der Zusammenhang zur urspr\[UDoubleDot]nglichen Aufgabe.\
\>", "SmallText",
 CellChangeTimes->{{3.382612022188271*^9, 3.382612038583405*^9}, 
   3.382612374221625*^9, {3.382612600362625*^9, 3.382612602527993*^9}}],

Cell[BoxData[
 RowBox[{"res", "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"htest", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{"2", "n"}], ",", "n"}], "]"}], "-", "res"}], "/.", 
     RowBox[{"x", "\[Rule]", "0"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"htest", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.389304835184927*^9, 3.389304855184733*^9}, 
   3.389304951008829*^9}],

Cell[BoxData[
 RowBox[{"ltest", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"2", "x"}], ")"}], "n"], 
        RowBox[{"LegendreP", "[", 
         RowBox[{"n", ",", 
          RowBox[{"1", "/", "x"}]}], "]"}]}], ",", 
       RowBox[{"x", "->", "0"}]}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{"res", "/.", 
       RowBox[{"x", "->", "0"}]}], ")"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.382612061438191*^9, 3.382612077893745*^9}, {
   3.382612112835775*^9, 3.382612162642808*^9}, {3.382612204701346*^9, 
   3.382612242694307*^9}, {3.382612292796706*^9, 3.38261229332567*^9}, {
   3.382612548233471*^9, 3.382612565970458*^9}, {3.389303693511234*^9, 
   3.389303693518682*^9}, 3.389304932103186*^9, {3.389305019019613*^9, 
   3.389305043724212*^9}, {3.38930507829969*^9, 3.389305104245807*^9}}],

Cell[TextData[{
 "F\[UDoubleDot]r konkrete Werte von n stehen auf beiden Seiten konkrete \
Zahlen, die ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nat\[UDoubleDot]rlich automatisch berechnet. "
}], "SmallText",
 CellChangeTimes->{{3.38261227194019*^9, 3.382612330559926*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"htest", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382612147056359*^9, 3.382612147805151*^9}, {
   3.38261223661036*^9, 3.382612237221981*^9}, 3.382612614207278*^9}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"ltest", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.382612618079804*^9}],

Cell[CellGroupData[{

Cell["Einige weitere Beispiele", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "k_", "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"k", " ", 
     RowBox[{"k", "!"}]}], 
    SuperscriptBox["n", "k"]], 
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"t", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "k_", "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"t", "[", "k", "]"}]}], "k"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "-", 
    RowBox[{"s", "[", "k", "]"}]}], "\[Equal]", 
   RowBox[{"t", "[", "k", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.389303693557333*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "k_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "k"], " ", 
   FractionBox[
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"4", "n"}], ",", 
      RowBox[{"2", "k"}]}], "]"}], 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "n"}], ",", "k"}], "]"}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"t", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", 
     RowBox[{"2", "n"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "k_", "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "k"}], "-", "1"}], ")"}], 
    RowBox[{"t", "[", "k", "]"}]}], 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", "n"}]}], ")"}]}]]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "-", 
    RowBox[{"s", "[", "k", "]"}]}], "\[Equal]", 
   RowBox[{"t", "[", "k", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.389303693572673*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unendliche Summen und Integrale", "Section",
 CellChangeTimes->{{3.382551899857107*^9, 3.382551902529866*^9}}],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["n", "k"]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["n", "k"]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "2", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input"],

Cell["Summation rationaler Ausdr\[UDoubleDot]cke", "SmallText",
 CellChangeTimes->{{3.382614335479635*^9, 3.382614346802322*^9}}],

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["n", "4"], "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382520664015535*^9, 3.382520664768492*^9}, {
  3.382520768128417*^9, 3.382520815198054*^9}, {3.382614238009372*^9, 
  3.382614238417599*^9}, {3.382685770591068*^9, 3.382685771001491*^9}}],

Cell[CellGroupData[{

Cell["Etwas Theorie", "Subsection",
 CellChangeTimes->{{3.382617623926793*^9, 3.382617628934409*^9}}],

Cell["Integration rationaler Funktionen.", "SmallText",
 CellChangeTimes->{{3.382618067847538*^9, 3.382618082469689*^9}}],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"2", "x"}], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", "x", "+", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.382617641722755*^9, 3.382617751676256*^9}, {
  3.382617788635086*^9, 3.382617798693689*^9}, {3.382617899285596*^9, 
  3.382618009083145*^9}, {3.389306389241886*^9, 3.389306390231137*^9}, {
  3.389307040085554*^9, 3.389307047159539*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", "g1"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617853634622*^9}, {
  3.389307057984709*^9, 3.389307059556829*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", "g2", "]"}]], "Input",
 CellChangeTimes->{{3.382618046132709*^9, 3.38261804964705*^9}, {
  3.389307071931403*^9, 3.389307074391685*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", "g2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617863399235*^9}, {
  3.382617913501571*^9, 3.382617913917586*^9}, {3.382628017708489*^9, 
  3.382628017862434*^9}, {3.382629940175316*^9, 3.382629940952445*^9}, {
  3.382630596362136*^9, 3.382630602169834*^9}, {3.382630718420045*^9, 
  3.382630747301005*^9}, {3.389307088349121*^9, 3.389307089325098*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"g2", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.38262031389502*^9, 3.382620331595114*^9}, 
   3.389303693586491*^9, {3.38930710057476*^9, 3.389307102097179*^9}}],

Cell[BoxData[
 RowBox[{"cc", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"3", 
       SuperscriptBox["x", "2"]}], "-", "2"}]], "/.", "sol"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.382620345181866*^9, 3.382620449273525*^9}, {
  3.382621612055052*^9, 3.382621619942384*^9}, {3.38262168262576*^9, 
  3.382621683241902*^9}, {3.382622372719325*^9, 3.382622377934803*^9}, {
  3.382622619219222*^9, 3.382622619678295*^9}, {3.382626246582672*^9, 
  3.382626254944598*^9}, {3.382627809042962*^9, 3.382627809202416*^9}, {
  3.382628233971275*^9, 3.382628264393035*^9}, {3.382630725435021*^9, 
  3.382630755678464*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", 
       SqrtBox["5"]}]}], ")"}]}], " ", "-", 
   FractionBox["2", 
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]}]]}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.382628312566352*^9, 3.382628333861993*^9}}],

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"3", 
         SuperscriptBox["x", "2"]}], "-", "2"}]]}], "}"}], "/.", "sol"}], "//",
    "Together"}]}]], "Input",
 CellChangeTimes->{{3.382620345181866*^9, 3.382620449273525*^9}, {
  3.382621612055052*^9, 3.382621619942384*^9}, {3.38262168262576*^9, 
  3.382621683241902*^9}, {3.382622372719325*^9, 3.382622377934803*^9}, {
  3.382622619219222*^9, 3.382622619678295*^9}, {3.382627817858345*^9, 
  3.382627818006138*^9}, {3.382630501137598*^9, 3.382630501424961*^9}, {
  3.382630555954098*^9, 3.382630556089591*^9}, {3.38931107007308*^9, 
  3.389311099547223*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterpolatingPolynomial", "[", 
   RowBox[{"pts", ",", "a"}], "]"}], "//", 
  "Together"}], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{"%", "//", "ExpandDenominator"}]}]}], "Input",
 CellChangeTimes->{{3.38931117992498*^9, 3.389311204020933*^9}, {
  3.389314425248712*^9, 3.389314456036569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"v", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", 
         SuperscriptBox["a", "2"]}], "-", "2"}], ")"}]}], "//", "Expand"}], 
    ")"}], "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "3"], "->", 
      RowBox[{
       RowBox[{"2", "a"}], "-", "1"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "->", 
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["a", "2"]}], "-", "a"}]}]}], "}"}]}], "//", 
  "Expand"}]], "Input",
 CellChangeTimes->{{3.382621821757265*^9, 3.382621968903678*^9}, {
  3.38262211980398*^9, 3.382622178352168*^9}, {3.382627844574247*^9, 
  3.382627845166358*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", "g3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617879619539*^9}, {
   3.382617927727184*^9, 3.382617928076934*^9}, {3.382618018470782*^9, 
   3.382618018840875*^9}, 3.382629670587845*^9, {3.389314528322145*^9, 
   3.389314529570279*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Uneigentliche Integrale rationaler Funktionen", "Subsection",
 CellChangeTimes->{{3.382625241854328*^9, 3.382625266160474*^9}}],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   FractionBox["1", "g1"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382625273473902*^9, 3.382625450061928*^9}, {
  3.382626486394353*^9, 3.382626502365661*^9}, {3.389314543200687*^9, 
  3.389314544722209*^9}}],

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "2", "\[Infinity]"], 
   RowBox[{
    FractionBox["1", "g2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 CellChangeTimes->{{3.382625273473902*^9, 3.382625527474163*^9}, {
  3.382627243121328*^9, 3.38262724349537*^9}, {3.382627311591345*^9, 
  3.382627311860852*^9}, {3.382627455529826*^9, 3.382627460068427*^9}, {
  3.382630514325018*^9, 3.382630514875067*^9}, {3.382630564578892*^9, 
  3.382630564736223*^9}, {3.389314558422405*^9, 3.389314559750584*^9}}],

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], 
       RowBox[{"Log", "[", 
        RowBox[{"x", "-", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "&"}], "/@", "pts"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.382617807106597*^9, 3.382617863399235*^9}, {
  3.382617913501571*^9, 3.382617913917586*^9}, {3.382627408448615*^9, 
  3.382627470026127*^9}, {3.382627604379738*^9, 3.382627732873547*^9}, {
  3.382627895472398*^9, 3.382627896095135*^9}, {3.382629995175527*^9, 
  3.382629995491649*^9}, {3.382630524575578*^9, 3.382630524972188*^9}, {
  3.382631881102105*^9, 3.382631909699358*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"r1", "+", 
   RowBox[{"(", 
    RowBox[{"r2", "/.", 
     RowBox[{"x", "\[Rule]", "2"}]}], ")"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.382627472823546*^9, 3.382627492596782*^9}, {
  3.382630085870224*^9, 3.382630111578101*^9}, {3.38263053895217*^9, 
  3.382630543234725*^9}, {3.382630576271477*^9, 3.382630577532034*^9}, {
  3.38263188681813*^9, 3.382631897519283*^9}, {3.382631930767228*^9, 
  3.38263193646925*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "cc"}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.382626302307017*^9, 3.382626305659774*^9}, {
  3.382630677820415*^9, 3.382630682088735*^9}}],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "2", "\[Infinity]"], 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "1"}], "g2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382625551781773*^9, 3.382625555845148*^9}, {
  3.389314600545112*^9, 3.389314602545391*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"g3", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382625721047543*^9, 3.382625775044933*^9}, {
   3.382632350180407*^9, 3.382632352081615*^9}, 3.389303693599935*^9, {
   3.389314622929713*^9, 3.389314624040934*^9}}],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   FractionBox["1", "g3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.382625273473902*^9, 3.382625482519494*^9}, {
  3.382625564511687*^9, 3.382625575698019*^9}, {3.382625785537286*^9, 
  3.382625808116691*^9}, {3.382632356413273*^9, 3.382632357581918*^9}, {
  3.389315831891648*^9, 3.389315836646775*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Unendliche Summen rationaler Ausdr\[UDoubleDot]cke\
\>", "Subsection",
 CellChangeTimes->{{3.382633846074672*^9, 3.382633860632035*^9}}],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "g1"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.3893158763248*^9, 
   3.389315878134408*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", "+", "1"}]], "-", 
   FractionBox["1", 
    RowBox[{"x", "+", "2"}]]}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.38931607498849*^9, 3.389316133910207*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], "-", 
   FractionBox["1", 
    RowBox[{"n", "+", "2"}]]}], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.389316219998109*^9, 3.389316259356892*^9}}],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "g1"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.389316293060197*^9, 3.38931630101191*^9}, {
   3.389316348413158*^9, 3.38931634916853*^9}}],

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox["1", "g1"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677716159894*^9}, {3.389316372154908*^9, 3.389316389771011*^9}}],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.382678375739943*^9, 3.382678384802303*^9}, {
   3.382678425429395*^9, 3.382678427493474*^9}, {3.382678489907073*^9, 
   3.38267849041059*^9}, {3.389316410692564*^9, 3.389316421962447*^9}}],

Cell[BoxData[
 RowBox[{"%", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678445087843*^9, 3.382678448661394*^9}}],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.382678375739943*^9, 3.382678384802303*^9}, {
   3.382678469933435*^9, 3.382678470556505*^9}, {3.389318109839228*^9, 
   3.38931813025315*^9}}],

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"s2", ",", 
     RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.382678495427599*^9, 3.382678519736378*^9}, {
  3.3826785703306*^9, 3.382678579099327*^9}, {3.382679925680652*^9, 
  3.382679926456489*^9}, {3.382680274063422*^9, 3.382680276754158*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", "-", "s3"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678523920534*^9, 3.382678585061952*^9}}],

Cell[BoxData[
 RowBox[{"s4", "=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g2"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2", ",", "9"}], "}"}]}], "]"}], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g2"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "10", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382676285428259*^9, 3.382676292469116*^9}, {3.382677687589916*^9, 
   3.382677693177589*^9}, {3.382678375739943*^9, 3.382678384802303*^9}, {
   3.382678425429395*^9, 3.382678427493474*^9}, {3.382678489907073*^9, 
   3.38267849041059*^9}, {3.382678617395005*^9, 3.382678632884729*^9}, {
   3.382684370214802*^9, 3.38268437375771*^9}, {3.382684415282626*^9, 
   3.382684418794817*^9}, {3.389318341116185*^9, 3.389318389551152*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s1", "-", "s4"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678640392668*^9, 3.382678651616359*^9}, {
  3.382684425483586*^9, 3.382684426998467*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s3", "-", "s4"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382678640392668*^9, 3.382678693164489*^9}, {
  3.382684347699823*^9, 3.3826844380787*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", "//", "Normal"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.382684493906589*^9, 3.38268452210363*^9}, {
  3.382684653610793*^9, 3.382684671829711*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"s4", "//", "Normal"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.382684493906589*^9, 3.38268452210363*^9}, {
  3.382684653610793*^9, 3.382684653995378*^9}}],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g3"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382634734153226*^9, 3.382634755478537*^9}, {3.382634824217346*^9, 
   3.382634860004832*^9}, {3.382634902876293*^9, 3.382634903778039*^9}, {
   3.382684840604221*^9, 3.382684843282925*^9}, {3.389318664852327*^9, 
   3.389318683232594*^9}}],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", "g3"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382634734153226*^9, 3.382634755478537*^9}, {3.382634824217346*^9, 
   3.382634860004832*^9}, {3.382634902876293*^9, 3.382634903778039*^9}, {
   3.382684840604221*^9, 3.382684843282925*^9}, {3.389318664852327*^9, 
   3.389318717689133*^9}}],

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g3"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "g3"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "3", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.382634047843272*^9, 3.38263422073446*^9}, 
   3.382634377256268*^9, {3.382634683147363*^9, 3.382634702420355*^9}, {
   3.382634734153226*^9, 3.382634755478537*^9}, {3.382634824217346*^9, 
   3.382634860004832*^9}, {3.382634902876293*^9, 3.382634903778039*^9}, {
   3.382684840604221*^9, 3.382684843282925*^9}, {3.389318664852327*^9, 
   3.389318683232594*^9}, {3.389318733388105*^9, 3.389318776820122*^9}}],

Cell[TextData[{
 "Die folgenden beiden Rechnungen schafft ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nicht."
}], "SmallText",
 CellChangeTimes->{{3.382685003897397*^9, 3.382685029954142*^9}}],

Cell[BoxData[
 RowBox[{"s4", "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"s2", ",", 
     RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.389319143901559*^9, 3.389319145254632*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s1", "-", "s4"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382634915438517*^9, 3.382634927918398*^9}, {
  3.382684789271179*^9, 3.382684790634335*^9}, {3.382684950884307*^9, 
  3.382684961321644*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"s1", "-", "s3"}], "//", "Normal"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.389319512140721*^9, {3.389319644651015*^9, 3.389319645642273*^9}, 
   3.389319699857573*^9}],

Cell["Noch einmal unser Ausgangsbeispiel", "SmallText",
 CellChangeTimes->{{3.382685883835895*^9, 3.382685894710446*^9}}],

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["n", "4"], "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.382520664015535*^9, 3.382520664768492*^9}, {
  3.382520768128417*^9, 3.382520815198054*^9}, {3.382614238009372*^9, 
  3.382614238417599*^9}, {3.382685770591068*^9, 3.382685771001491*^9}}],

Cell[BoxData[
 RowBox[{"res1", "=", 
  RowBox[{
   RowBox[{"res", "//", "Normal"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.38261427354401*^9, 3.382614316207895*^9}, {
  3.382685829274136*^9, 3.382685857190036*^9}, {3.382686571849822*^9, 
  3.382686573272099*^9}}],

Cell[BoxData[
 RowBox[{"res2", "=", 
  RowBox[{
   RowBox[{"res1", "//", "TrigExpand"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.382686577673514*^9, 3.382686647453793*^9}, {
  3.382686697306573*^9, 3.382686700102715*^9}}],

Cell[BoxData[
 RowBox[{"res1", "//", "N"}]], "Input",
 CellChangeTimes->{{3.382685907378193*^9, 3.382685907935993*^9}, {
   3.382686671413886*^9, 3.382686672237514*^9}, 3.382686707312093*^9}],

Cell[BoxData[
 RowBox[{"res2", "//", "N"}]], "Input",
 CellChangeTimes->{{3.382685907378193*^9, 3.382685907935993*^9}, {
  3.382686671413886*^9, 3.382686704035346*^9}}],

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["n", "4"], "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.382686217016973*^9, 3.382686225671239*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Die PolyGamma-Funktion", "Subsection",
 CellChangeTimes->{{3.382687407194282*^9, 3.382687423905347*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyGamma", "[", 
    RowBox[{"x", "+", "1"}], "]"}], "-", 
   RowBox[{"PolyGamma", "[", "x", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382687427024098*^9, 3.382687462459036*^9}, {
  3.382688718781804*^9, 3.382688734435562*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     FractionBox["1", "k"], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "-", 
   RowBox[{"PolyGamma", "[", "n", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.382687525113263*^9, 3.382687615038952*^9}}],

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellChangeTimes->{{3.382687623191907*^9, 3.382687623844848*^9}}]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{632, 680},
WindowMargins->{{Automatic, 100}, {Automatic, 65}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 199, 3, 90, "Title"],
Cell[CellGroupData[{
Cell[814, 30, 109, 1, 55, "Section"],
Cell[926, 33, 352, 10, 30, "Input"],
Cell[1281, 45, 303, 10, 30, "Input"],
Cell[1587, 57, 60, 1, 28, "Input"],
Cell[1650, 60, 199, 6, 28, "Input"],
Cell[1852, 68, 294, 10, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[2183, 83, 43, 0, 35, "Section"],
Cell[2229, 85, 257, 8, 30, "Input"],
Cell[2489, 95, 157, 5, 28, "Input"],
Cell[2649, 102, 161, 5, 28, "Input"],
Cell[2813, 109, 164, 5, 28, "Input"],
Cell[2980, 116, 61, 1, 28, "Input"],
Cell[3044, 119, 189, 6, 30, "Input"],
Cell[3236, 127, 339, 7, 59, "SmallText"],
Cell[3578, 136, 1038, 36, 49, "Input"],
Cell[4619, 174, 328, 10, 42, "SmallText"],
Cell[4950, 186, 469, 11, 28, "Input"],
Cell[5422, 199, 244, 6, 42, "SmallText"],
Cell[5669, 207, 363, 9, 49, "Input"],
Cell[6035, 218, 247, 6, 42, "SmallText"],
Cell[6285, 226, 203, 4, 28, "Input"],
Cell[6491, 232, 534, 18, 89, "SmallText"],
Cell[7028, 252, 352, 11, 28, "Input"],
Cell[7383, 265, 249, 8, 42, "SmallText"],
Cell[7635, 275, 359, 10, 28, "Input"],
Cell[7997, 287, 244, 5, 42, "SmallText"],
Cell[8244, 294, 476, 16, 30, "Input"],
Cell[8723, 312, 381, 10, 59, "SmallText"],
Cell[9107, 324, 575, 20, 49, "Input"],
Cell[9685, 346, 404, 10, 42, "SmallText"],
Cell[10092, 358, 336, 10, 28, "Input"],
Cell[10431, 370, 579, 16, 76, "SmallText"],
Cell[11013, 388, 728, 19, 49, "Input"],
Cell[11744, 409, 469, 12, 76, "SmallText"],
Cell[12216, 423, 521, 15, 28, "Input"],
Cell[12740, 440, 657, 18, 49, "Input"],
Cell[13400, 460, 223, 4, 42, "SmallText"],
Cell[13626, 466, 81, 2, 28, "Input"],
Cell[13710, 470, 293, 10, 28, "Input"],
Cell[14006, 482, 237, 6, 28, "Input"],
Cell[14246, 490, 957, 24, 49, "Input"],
Cell[15206, 516, 286, 7, 59, "SmallText"],
Cell[15495, 525, 282, 6, 28, "Input"],
Cell[15780, 533, 187, 5, 28, "Input"],
Cell[CellGroupData[{
Cell[15992, 542, 46, 0, 45, "Subsection"],
Cell[16041, 544, 252, 9, 44, "Input"],
Cell[16296, 555, 167, 5, 28, "Input"],
Cell[16466, 562, 175, 6, 43, "Input"],
Cell[16644, 570, 272, 8, 28, "Input"],
Cell[16919, 580, 387, 14, 45, "Input"],
Cell[17309, 596, 188, 6, 28, "Input"],
Cell[17500, 604, 314, 12, 45, "Input"],
Cell[17817, 618, 272, 8, 28, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18138, 632, 116, 1, 35, "Section"],
Cell[18257, 635, 196, 6, 43, "Input"],
Cell[18456, 643, 196, 6, 43, "Input"],
Cell[18655, 651, 173, 5, 28, "Input"],
Cell[18831, 658, 50, 1, 28, "Input"],
Cell[18884, 661, 129, 1, 42, "SmallText"],
Cell[19016, 664, 463, 11, 43, "Input"],
Cell[CellGroupData[{
Cell[19504, 679, 101, 1, 45, "Subsection"],
Cell[19608, 682, 121, 1, 42, "SmallText"],
Cell[19732, 685, 805, 21, 91, "Input"],
Cell[20540, 708, 244, 6, 44, "Input"],
Cell[20787, 716, 174, 3, 28, "Input"],
Cell[20964, 721, 483, 9, 44, "Input"],
Cell[21450, 732, 276, 6, 28, "Input"],
Cell[21729, 740, 663, 15, 43, "Input"],
Cell[22395, 757, 405, 14, 48, "Input"],
Cell[22803, 773, 722, 17, 43, "Input"],
Cell[23528, 792, 342, 8, 49, "Input"],
Cell[23873, 802, 731, 25, 30, "Input"],
Cell[24607, 829, 367, 8, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[25011, 842, 133, 1, 29, "Subsection"],
Cell[25147, 845, 335, 8, 44, "Input"],
Cell[25485, 855, 552, 11, 44, "Input"],
Cell[26040, 868, 772, 19, 28, "Input"],
Cell[26815, 889, 469, 10, 28, "Input"],
Cell[27287, 901, 200, 4, 28, "Input"],
Cell[27490, 907, 311, 8, 44, "Input"],
Cell[27804, 917, 353, 8, 28, "Input"],
Cell[28160, 927, 430, 9, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28627, 941, 146, 3, 29, "Subsection"],
Cell[28776, 946, 396, 9, 44, "Input"],
Cell[29175, 957, 239, 7, 42, "Input"],
Cell[29417, 966, 215, 6, 42, "Input"],
Cell[29635, 974, 492, 10, 44, "Input"],
Cell[30130, 986, 454, 9, 44, "Input"],
Cell[30587, 997, 627, 12, 44, "Input"],
Cell[31217, 1011, 127, 2, 28, "Input"],
Cell[31347, 1015, 571, 12, 44, "Input"],
Cell[31921, 1029, 398, 9, 28, "Input"],
Cell[32322, 1040, 152, 3, 28, "Input"],
Cell[32477, 1045, 950, 21, 44, "Input"],
Cell[33430, 1068, 234, 6, 28, "Input"],
Cell[33667, 1076, 232, 6, 28, "Input"],
Cell[33902, 1084, 201, 4, 28, "Input"],
Cell[34106, 1090, 201, 4, 28, "Input"],
Cell[34310, 1096, 582, 12, 44, "Input"],
Cell[34895, 1110, 572, 12, 44, "Input"],
Cell[35470, 1124, 805, 19, 44, "Input"],
Cell[36278, 1145, 203, 6, 42, "SmallText"],
Cell[36484, 1153, 256, 7, 28, "Input"],
Cell[36743, 1162, 283, 7, 28, "Input"],
Cell[37029, 1171, 236, 7, 28, "Input"],
Cell[37268, 1180, 121, 1, 42, "SmallText"],
Cell[37392, 1183, 463, 11, 43, "Input"],
Cell[37858, 1196, 282, 6, 28, "Input"],
Cell[38143, 1204, 235, 5, 28, "Input"],
Cell[38381, 1211, 191, 3, 28, "Input"],
Cell[38575, 1216, 168, 3, 28, "Input"],
Cell[38746, 1221, 289, 8, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[39072, 1234, 110, 1, 29, "Subsection"],
Cell[39185, 1237, 298, 7, 28, "Input"],
Cell[39486, 1246, 358, 10, 42, "Input"],
Cell[39847, 1258, 116, 2, 28, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
