(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26460,       1039]
NotebookOptionsPosition[     19204,        826]
NotebookOutlinePosition[     19628,        845]
CellTagsIndexPosition[     19585,        842]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Symbole und Ausdr\[UDoubleDot]cke", "Title"],

Cell[CellGroupData[{

Cell["Ausdr\[UDoubleDot]cke", "Section"],

Cell[CellGroupData[{

Cell["Zum Aufbau von Ausdr\[UDoubleDot]cken", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"12", "!"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"a", "++"}], ",", "a"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], ",", 
   RowBox[{"u", "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}], ",", 
   RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  "}"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Klammern", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "2"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"3", "x"}], "+", "2"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(*", " ", "a", " ", "*)"}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "//", "FullForm"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Elementare Objekte", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{"Plot", ",", "\"\<abc\>\"", ",", "12", ",", "1.2", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "+", "I"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Map", "[", 
  RowBox[{"Head", ",", "l"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"AtomQ", ",", "l"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "=", 
    RowBox[{"1", "/", "2"}]}], ")"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}], ",", 
   RowBox[{"a", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Numerator", "[", "a", "]"}], ",", 
   RowBox[{"Denominator", "[", "a", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"b", "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "I"}]}]}], ")"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", "b", "]"}], ",", 
   RowBox[{"Im", "[", "b", "]"}]}], "}"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Operatoren", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[{
 StyleBox["Logische Verkn\[UDoubleDot]pfungen",
  FontWeight->"Bold"],
 "\nEingabe: \tEsc not Esc\n\t\tEsc or Esc\n\t\tEsc and Esc\n\t\tEsc => Esc"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Not]", "a"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "\[Or]", "b"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "\[And]", " ", "b"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Implies]", "b"}], "//", "FullForm"}]], "Input"],

Cell[TextData[{
 StyleBox["Listen, Vektoren, Matrizen",
  FontWeight->"Bold"],
 "\nEingabe:\tEsc cross Esc\n\t\tEsc un Esc\n\t\tEsc inter Esc"
}], "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", ".", " ", "b"}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "\[Cross]", " ", "b"}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "\[Union]", " ", "b"}], " ", "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "\[Intersection]", " ", "b"}], " ", "//", 
  "FullForm"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematische Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "2", "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "4"], "]"}], ",", 
   RowBox[{"Sin", "[", "3.5", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"Attributes", "[", "Sin", "]"}]], "Input"],

Cell["Numerische Funktionen", "SmallText"],

Cell[BoxData[
 RowBox[{"Round", "[", "2.5", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"-", "2.6"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FractionalPart", "[", "2.6", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Floor", "[", "1.9", "]"}]], "Input"],

Cell["\<\
Eingabe: \tEsc lf Esc   Esc rf Esc
\t\tEsc lc Esc   Esc rc Esc\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"\[LeftFloor]", 
  RowBox[{"-", "2.5"}], "\[RightFloor]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[LeftCeiling]", 
  RowBox[{"-", "2.5"}], "\[RightCeiling]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"1", " ", "+", " ", 
   RowBox[{"2.4", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "16"}]], "I"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Chop", "[", "0.00000000000000000001234", "]"}]], "Input"],

Cell[TextData[StyleBox["Komplexe Zahlen",
 FontWeight->"Bold"]], "SmallText"],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"-", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"-", "1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"1", "+", "I"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ausgabeformatierung", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"0.012345", " ", "//", " ", "ScientificForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"0.012345", " ", "//", " ", "EngineeringForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["x", "2"]], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["x", "2"]], "//", "TeXForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["x", "2"]], "//", "MathMLForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["x", "2"]], "//", "TreeForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], 
    RowBox[{"50", " "}]], "]"}], " ", "//", "Short"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], 
    RowBox[{"50", " "}]], "]"}], " ", "//", "Shallow"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "//", 
  "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["2", "x"]], "//", "InputForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["2", "x"]], "//", "OutputForm"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Bezeichner, Symbolvariablen und Wertvariablen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", "1"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "2"}], ";", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";", "f"}]], "Input"],

Cell[TextData[{
 "An dieser Stelle ",
 StyleBox["sollten Sie den Kernel mit ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["Evaluation|Quit Kernel",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" neu starten",
  FontColor->RGBColor[1, 0, 0]],
 ", um den unverf\[ADoubleDot]lschten Anfang einer ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Sitzung nachvollziehen zu k\[ODoubleDot]nnen."
}], "SmallText"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", "1"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f x"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "2"}], ";", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f x"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "unknown"}], ";", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "x"}], ";", " ", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ":=", "x"}], ";", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f x"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ":=", "y"}], ";", 
  RowBox[{"y", ":=", "x"}], ";"}]], "Input"],

Cell[BoxData["x"], "Input"],

Cell[BoxData[
 RowBox[{"?", "x y"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";", "f"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "f x"}]], "Input"],

Cell["\<\
Und nun geht es darum, ob einem Bezeichner ein Wert zugewiesen ist \
(Wwertvariable) oder nicht (Symbolvariable). Beachten Sie, dass dies zwei \
Modi sind, in denen im Laufe einer Rechnung ein und derselbe Bezeichner \
auftreten kann.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "2"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "=", 
  SqrtBox["2"]}]], "Input"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "2"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "\[Equal]", "2"}], ",", "x"}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell["Kontexte und Bezeichner aus Paketen", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "3"}], ";"}]], "Input"],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Input"],

Cell[BoxData[
 SuperscriptBox["Global`a", "2"]], "Input"],

Cell[BoxData["$Context"], "Input"],

Cell[BoxData["$ContextPath"], "Input"],

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "System`*"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wertzuweisungen", "Subsection"],

Cell["Zuweisung mit und ohne Auswertung", "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ":=", "3"}], ";", " ", 
  RowBox[{"y", "=", "3"}], ";", " ", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "x y"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", "3"}], ";", 
  RowBox[{"x", ":=", "f"}], ";", " ", 
  RowBox[{"y", "=", "f"}], ";", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", " ", "x y"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", "7"}], ";", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input"],

Cell["Lokale Wertzuweisungen", "SmallText"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", 
    SuperscriptBox["y", "2"]}], "-", 
   RowBox[{"3", "y"}], "+", "5"}], "/.", 
  RowBox[{"y", "\[Rule]", "4"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "y"}]], "Input"],

Cell["Wertzuweisungen l\[ODoubleDot]schen", "SmallText"],

Cell[BoxData[
 RowBox[{"x", "=", 
  SqrtBox["2"]}]], "Input"],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input"],

Cell[BoxData[
 RowBox[{"Unset", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "x"}]], "Input"],

Cell[BoxData[
 RowBox[{"Remove", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"?", "x"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systemvariablen", "Subsection"],

Cell[BoxData[
 RowBox[{"?", "$*"}]], "Input"],

Cell[BoxData["$OperatingSystem"], "Input"],

Cell[BoxData["$Version"], "Input"],

Cell[BoxData["$DefaultPath"], "Input"],

Cell[BoxData[
 RowBox[{"$Path", "  "}]], "Input"],

Cell[BoxData["$PathnameSeparator"], "Input"],

Cell[BoxData["$MachinePrecision"], "Input"],

Cell[BoxData["$DisplayFunction"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", 
   RowBox[{
    RowBox[{"Which", "[", "\n", "\t\t", 
     RowBox[{
      RowBox[{"MatrixQ", "[", "#", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "#", "]"}], ",", "\n", "\t\t", 
      RowBox[{"NumberQ", "[", "#", "]"}], ",", " ", 
      RowBox[{"N", "[", 
       RowBox[{"#", ",", "20"}], "]"}], ",", "\n", "\t\t", "True", ",", " ", 
      RowBox[{"Short", "[", 
       RowBox[{"#", ",", "10"}], "]"}]}], "]"}], "&"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "/", "3"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], 
   RowBox[{"50", " "}]], "//", "Expand"}]], "Input"],

Cell[BoxData[
 RowBox[{"Clear", "[", "$PrePrint", "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optionen", "Subsection"],

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "2"]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["\[Pi]", "2"]}], ",", " ", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Options", "[", "Limit", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Options", "[", "Plot", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"Graphics", ",", "AxesOrigin"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"Head", "[", "p", "]"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{"p", ",", "AxesOrigin"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"Options", "[", 
  RowBox[{"Plot3D", ",", "BaseStyle"}], "]"}], "\n", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot3D", ",", " ", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontSize", "->", "20"}], "}"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"Plot3D", ",", "BaseStyle"}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematische Konstanten", "Subsection"],

Cell[TextData[{
 "Vorsicht bei ",
 StyleBox["Unprotect",
  FontWeight->"Bold"]
}], "SmallText"],

Cell[BoxData[
 RowBox[{"??", "Pi"}]], "Input"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "Pi", "]"}], ";", " ", 
  RowBox[{"\[Pi]", "=", "Hallo"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "Pi", "]"}], ";", " ", "\[Pi]"}]], "Input"],

Cell[TextData[{
 "Fast alles wieder im Lot, allein die aktive Verwendung der \
\[CapitalADoubleDot]quivalenz von Pi und \[Pi] hat ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " irgendwie vergessen. "
}], "SmallText"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "1", "]"}]], "Input"],

Cell[TextData[{
 "Variablen sollten Sie immer mit einem der ",
 StyleBox["Clear",
  FontWeight->"Bold"],
 "-Kommandos l\[ODoubleDot]schen und m\[ODoubleDot]glichst nicht mit ",
 StyleBox["Remove",
  FontWeight->"Bold"],
 ". Letzteres entfernt den Eintrag aus der Symboltabelle, auf den alle \
bisherigen Verweise auf diesen Bezeichner zegen. Vielleicht sind ja noch \
welche \[UDoubleDot]brig, von deren Existenz Sie gar nichts ahnen!"
}], "SmallText"],

Cell[BoxData[
 RowBox[{"Remove", "[", "Pi", "]"}]], "Input"],

Cell["\<\
ArcTan[1] wird nun wieder richtig berechnet; leider mit dem \"alten\" \[Pi]\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTan", "[", "1", "]"}], "-", 
  RowBox[{"Pi", "/", "4"}]}]], "Input"],

Cell["\<\
Auch hinter dem Palettensymbol \[Pi] verbirgt sich das \"alte\" \[Pi], obwohl \
das Hilfesystem behauptet, dass das neue Pi auch das Alte sei. Aber wichtige \
Eigenschaften sind ebenfalls vergessen.\
\>", "SmallText"],

Cell[BoxData["\[Pi]"], "Input"],

Cell[BoxData[{
 RowBox[{"?", "Pi"}], "\[IndentingNewLine]", 
 RowBox[{"Sin", "[", "Pi", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTan", "[", "1", "]"}], "-", 
  RowBox[{"\[Pi]", "/", "4"}]}]], "Input"],

Cell[TextData[{
 "An dieser Stelle sollten Sie den ",
 StyleBox["Kernel mit ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["Evaluate|Quit Kernel ",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["neu starten.",
  FontColor->RGBColor[1, 0, 0]],
 " "
}], "SmallText"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{568, 617},
WindowMargins->{{Automatic, 153}, {1, Automatic}},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 50, 0, 90, "Title"],
Cell[CellGroupData[{
Cell[665, 27, 40, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[730, 31, 59, 0, 45, "Subsection"],
Cell[792, 33, 76, 1, 28, "Input"],
Cell[871, 36, 68, 2, 28, "Input"],
Cell[942, 40, 136, 4, 28, "Input"],
Cell[1081, 46, 79, 2, 28, "Input"],
Cell[1163, 50, 253, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1453, 61, 30, 0, 29, "Subsection"],
Cell[1486, 63, 76, 1, 28, "Input"],
Cell[1565, 66, 132, 4, 30, "Input"],
Cell[1700, 72, 198, 7, 30, "Input"],
Cell[1901, 81, 106, 3, 28, "Input"],
Cell[2010, 86, 93, 1, 28, "Input"],
Cell[2106, 89, 129, 4, 28, "Input"],
Cell[2238, 95, 107, 2, 28, "Input"],
Cell[2348, 99, 114, 3, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[2499, 107, 40, 0, 29, "Subsection"],
Cell[2542, 109, 292, 8, 49, "Input"],
Cell[2837, 119, 83, 2, 28, "Input"],
Cell[2923, 123, 129, 4, 28, "Input"],
Cell[3055, 129, 211, 5, 28, "Input"],
Cell[3269, 136, 148, 4, 28, "Input"],
Cell[3420, 142, 155, 5, 28, "Input"],
Cell[3578, 149, 132, 4, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3747, 158, 32, 0, 29, "Subsection"],
Cell[3782, 160, 76, 1, 28, "Input"],
Cell[3861, 163, 180, 4, 110, "SmallText"],
Cell[4044, 169, 80, 2, 28, "Input"],
Cell[4127, 173, 89, 2, 28, "Input"],
Cell[4219, 177, 95, 2, 28, "Input"],
Cell[4317, 181, 89, 2, 28, "Input"],
Cell[4409, 185, 159, 4, 93, "SmallText"],
Cell[4571, 191, 95, 2, 44, "Input"],
Cell[4669, 195, 102, 2, 44, "Input"],
Cell[4774, 199, 223, 7, 44, "Input"],
Cell[5000, 208, 102, 2, 44, "Input"],
Cell[5105, 212, 112, 3, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[5254, 220, 46, 0, 29, "Subsection"],
Cell[5303, 222, 76, 1, 28, "Input"],
Cell[5382, 225, 245, 7, 41, "Input"],
Cell[5630, 234, 65, 1, 28, "Input"],
Cell[5698, 237, 42, 0, 42, "SmallText"],
Cell[5743, 239, 60, 1, 28, "Input"],
Cell[5806, 242, 84, 2, 28, "Input"],
Cell[5893, 246, 69, 1, 28, "Input"],
Cell[5965, 249, 60, 1, 28, "Input"],
Cell[6028, 252, 91, 3, 59, "SmallText"],
Cell[6122, 257, 92, 2, 44, "Input"],
Cell[6217, 261, 96, 2, 44, "Input"],
Cell[6316, 265, 170, 5, 46, "Input"],
Cell[6489, 272, 81, 1, 44, "Input"],
Cell[6573, 275, 77, 1, 42, "SmallText"],
Cell[6653, 278, 74, 2, 44, "Input"],
Cell[6730, 282, 75, 2, 44, "Input"],
Cell[6808, 286, 80, 2, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6925, 293, 41, 0, 29, "Subsection"],
Cell[6969, 295, 76, 1, 28, "Input"],
Cell[7048, 298, 216, 8, 28, "Input"],
Cell[7267, 308, 80, 1, 28, "Input"],
Cell[7350, 311, 81, 1, 28, "Input"],
Cell[7434, 314, 91, 3, 51, "Input"],
Cell[7528, 319, 90, 3, 51, "Input"],
Cell[7621, 324, 93, 3, 51, "Input"],
Cell[7717, 329, 91, 3, 67, "Input"],
Cell[7811, 334, 189, 6, 46, "Input"],
Cell[8003, 342, 191, 6, 46, "Input"],
Cell[8197, 350, 124, 4, 44, "Input"],
Cell[8324, 356, 92, 3, 67, "Input"],
Cell[8419, 361, 93, 3, 67, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[8561, 370, 64, 0, 59, "Section"],
Cell[8628, 372, 76, 1, 28, "Input"],
Cell[8707, 375, 97, 3, 30, "Input"],
Cell[8807, 380, 72, 2, 28, "Input"],
Cell[8882, 384, 72, 2, 28, "Input"],
Cell[8957, 388, 431, 13, 59, "SmallText"],
Cell[9391, 403, 97, 3, 30, "Input"],
Cell[9491, 408, 51, 1, 28, "Input"],
Cell[9545, 411, 46, 1, 28, "Input"],
Cell[9594, 414, 72, 2, 28, "Input"],
Cell[9669, 418, 46, 1, 28, "Input"],
Cell[9718, 421, 78, 2, 28, "Input"],
Cell[9799, 425, 77, 2, 28, "Input"],
Cell[9879, 429, 73, 2, 28, "Input"],
Cell[9955, 433, 46, 1, 28, "Input"],
Cell[10004, 436, 102, 3, 28, "Input"],
Cell[10109, 441, 27, 0, 28, "Input"],
Cell[10139, 443, 46, 1, 28, "Input"],
Cell[10188, 446, 81, 2, 28, "Input"],
Cell[10272, 450, 46, 1, 28, "Input"],
Cell[10321, 453, 263, 5, 76, "SmallText"],
Cell[10587, 460, 76, 1, 28, "Input"],
Cell[10666, 463, 138, 4, 30, "Input"],
Cell[10807, 469, 61, 2, 32, "Input"],
Cell[10871, 473, 138, 4, 30, "Input"],
Cell[11012, 479, 200, 7, 30, "Input"],
Cell[CellGroupData[{
Cell[11237, 490, 57, 0, 45, "Subsection"],
Cell[11297, 492, 67, 2, 28, "Input"],
Cell[11367, 496, 50, 1, 30, "Input"],
Cell[11420, 499, 57, 1, 30, "Input"],
Cell[11480, 502, 34, 0, 28, "Input"],
Cell[11517, 504, 38, 0, 28, "Input"],
Cell[11558, 506, 51, 1, 28, "Input"],
Cell[11612, 509, 51, 1, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11700, 515, 37, 0, 45, "Subsection"],
Cell[11740, 517, 54, 0, 42, "SmallText"],
Cell[11797, 519, 76, 1, 28, "Input"],
Cell[11876, 522, 163, 5, 28, "Input"],
Cell[12042, 529, 46, 1, 28, "Input"],
Cell[12091, 532, 72, 2, 28, "Input"],
Cell[12166, 536, 191, 6, 28, "Input"],
Cell[12360, 544, 51, 1, 28, "Input"],
Cell[12414, 547, 119, 4, 28, "Input"],
Cell[12536, 553, 43, 0, 42, "SmallText"],
Cell[12582, 555, 76, 1, 28, "Input"],
Cell[12661, 558, 176, 6, 30, "Input"],
Cell[12840, 566, 44, 1, 28, "Input"],
Cell[12887, 569, 56, 0, 42, "SmallText"],
Cell[12946, 571, 61, 2, 32, "Input"],
Cell[13010, 575, 45, 1, 28, "Input"],
Cell[13058, 578, 58, 1, 28, "Input"],
Cell[13119, 581, 58, 1, 28, "Input"],
Cell[13180, 584, 44, 1, 28, "Input"],
Cell[13227, 587, 59, 1, 28, "Input"],
Cell[13289, 590, 44, 1, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13370, 596, 37, 0, 45, "Subsection"],
Cell[13410, 598, 45, 1, 28, "Input"],
Cell[13458, 601, 42, 0, 28, "Input"],
Cell[13503, 603, 34, 0, 28, "Input"],
Cell[13540, 605, 38, 0, 28, "Input"],
Cell[13581, 607, 49, 1, 28, "Input"],
Cell[13633, 610, 44, 0, 28, "Input"],
Cell[13680, 612, 43, 0, 28, "Input"],
Cell[13726, 614, 42, 0, 28, "Input"],
Cell[13771, 616, 497, 12, 89, "Input"],
Cell[14271, 630, 170, 6, 28, "Input"],
Cell[14444, 638, 49, 1, 28, "Input"],
Cell[14496, 641, 148, 5, 30, "Input"],
Cell[14647, 648, 66, 1, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14750, 654, 30, 0, 45, "Subsection"],
Cell[14783, 656, 58, 1, 28, "Input"],
Cell[14844, 659, 169, 5, 41, "Input"],
Cell[15016, 666, 222, 6, 41, "Input"],
Cell[15241, 674, 64, 1, 28, "Input"],
Cell[15308, 677, 63, 1, 28, "Input"],
Cell[15374, 680, 99, 2, 28, "Input"],
Cell[15476, 684, 223, 7, 28, "Input"],
Cell[15702, 693, 160, 3, 49, "Input"],
Cell[15865, 698, 356, 10, 49, "Input"],
Cell[16224, 710, 476, 14, 49, "Input"],
Cell[16703, 726, 96, 2, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16836, 733, 46, 0, 45, "Subsection"],
Cell[16885, 735, 95, 4, 42, "SmallText"],
Cell[16983, 741, 46, 1, 28, "Input"],
Cell[17032, 744, 59, 1, 28, "Input"],
Cell[17094, 747, 122, 3, 28, "Input"],
Cell[17219, 752, 59, 1, 28, "Input"],
Cell[17281, 755, 91, 2, 28, "Input"],
Cell[17375, 759, 224, 6, 59, "SmallText"],
Cell[17602, 767, 59, 1, 28, "Input"],
Cell[17664, 770, 452, 10, 93, "SmallText"],
Cell[18119, 782, 60, 1, 28, "Input"],
Cell[18182, 785, 104, 2, 42, "SmallText"],
Cell[18289, 789, 106, 3, 28, "Input"],
Cell[18398, 794, 227, 4, 76, "SmallText"],
Cell[18628, 800, 31, 0, 28, "Input"],
Cell[18662, 802, 105, 2, 49, "Input"],
Cell[18770, 806, 109, 3, 28, "Input"],
Cell[18882, 811, 282, 10, 42, "SmallText"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
