(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54353,       1934]
NotebookOptionsPosition[     45546,       1685]
NotebookOutlinePosition[     45942,       1703]
CellTagsIndexPosition[     45899,       1700]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Umformung und Vereinfachung 
mathematischer Ausdr\[UDoubleDot]cke\
\>", "Title"],

Cell[CellGroupData[{

Cell["Die Simplifikationsproblematik", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.35882889854241*^9, 3.35882890592059*^9}}],

Cell[CellGroupData[{

Cell["Was Sie erwarten k\[ODoubleDot]nnen", "Subsection"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"576", "+", 
   RowBox[{"816", " ", "x"}], "+", 
   RowBox[{"460", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"129", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"18", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   SuperscriptBox["x", "5"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "-", "1"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "Expand"}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "FullSimplify"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Vereinfachen mit Simplify", "Subsection"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Together"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}], "]"}], "2"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Gezielte Umformung von Ausdr\[UDoubleDot]cken", "Subsection"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "1"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"%", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"s1", "\[Equal]", "s2"}], "]"}]], "Input",
 CellChangeTimes->{{3.387977864923293*^9, 3.387977865764098*^9}, {
  3.387978327180446*^9, 3.387978337208455*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "1"}], "]"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.387977871657865*^9, 3.387977880995748*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"s1", "\[Equal]", "s2"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.387977864923293*^9, 3.387977865764098*^9}, {
   3.387978327180446*^9, 3.387978349694897*^9}, 3.387978626188865*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Vereinfachen und mathematische Exaktheit. Zusatzannahmen", "Subsection"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sqrt", "[", "x", "]"}], "2"], ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Tan", "[", 
    RowBox[{"ArcSin", "[", "x", "]"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Log", "[", 
     RowBox[{"Exp", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Sqrt", "[", 
     SuperscriptBox["x", "2"], "]"}]}], "}"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.35882864590562*^9, {3.35883056335001*^9, 3.35883059365086*^9}, {
   3.35883075560573*^9, 3.35883077117818*^9}, {3.35883091789373*^9, 
   3.3588309197511*^9}}],

Cell[BoxData[
 RowBox[{"f", "/.", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{"12", "\[Pi]"}], "5"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Log", "[", 
    RowBox[{"Exp", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{3.35882874012939*^9}],

Cell[BoxData[
 RowBox[{"f", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"10", "I"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Sqrt", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", "\[GreaterEqual]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"w1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SqrtBox["x"], 
     SqrtBox["y"]}], "-", 
    SqrtBox[
     RowBox[{"x", " ", "y"}]]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"w1", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "1"}], ",", 
      RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"w1", ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"w2", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     SqrtBox["x"]], "-", 
    SqrtBox[
     FractionBox["1", "x"]]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"w2", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w2", "/.", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"0.001", "I"}]}]}]}], "//", "Chop"}]], "Input"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"w2", "/.", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"a", " ", "I"}]}]}], "}"}]}], ",", 
   RowBox[{"a", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"l", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "2"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"l", ",", 
   RowBox[{"x", ">", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Eigene Umformungsregeln vereinbaren", "Subsection"],

Cell[BoxData[
 RowBox[{"sqrtRules", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["x_"], 
      SqrtBox["y_"]}], "\[Rule]", 
     SqrtBox[
      RowBox[{"x", " ", "y"}]]}], ",", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["y_"]], "\[Rule]", 
     SqrtBox[
      FractionBox["1", "y"]]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"w1", ",", "w2", ",", 
    RowBox[{
     FractionBox[
      SqrtBox["x"], 
      SqrtBox["y"]], "-", 
     SqrtBox[
      FractionBox["x", "y"]]}]}], "}"}], "//.", "sqrtRules"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"w1", ",", "w2", ",", 
    RowBox[{
     FractionBox[
      SqrtBox["x"], 
      SqrtBox["y"]], "-", 
     SqrtBox[
      FractionBox["x", "y"]]}]}], "}"}], "//", "PowerExpand"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomiale, rationale und pseudorationale Ausdr\[UDoubleDot]cke", \
"Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Ausmultiplizieren polynomialer Ausdr\[UDoubleDot]cke", "Subsection",
 CellChangeTimes->{{3359005004.57914, 3359005012.74179}}],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "a"}], ")"}], "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "b"}], ")"}], "3"]}]}]], "Input",
 CellChangeTimes->{{3.35883227606644*^9, 3.35883227647481*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "u", "]"}]], "Input",
 CellChangeTimes->{{3.35883228061837*^9, 3.35883228106071*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "a"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "b"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "2"]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "a"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "b"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "2"]}], ",", 
   RowBox[{"a", "+", "b"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "3"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "3"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "4"]], "]"}]], "Input",
 CellChangeTimes->{{3.35883237018546*^9, 3.3588323718145*^9}, {
  3.35883241756864*^9, 3.35883248904869*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandDenominator", "[", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "3"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]], "]"}], "Mfx\:ffff"}]], "Input",
 CellChangeTimes->{3.387982324694822*^9}],

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "]"}], "+", "1"}], ")"}], "2"], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ExpandAll", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "]"}], "+", "1"}], ")"}], "2"], 
  "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ausdr\[UDoubleDot]cke ordnen und nach Variablen zusammenfassen", \
"Subsection",
 CellChangeTimes->{{3358940296.32144, 3358940313.63908}, {3358949119.53778, 
  3358949121.61005}}],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{
        SuperscriptBox["x", "2"], "y"}], "+", 
       RowBox[{"b", " ", "y"}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["y", "2"]}]}], ")"}], "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    RowBox[{
     SuperscriptBox["x", "4"], 
     SuperscriptBox["y", "2"]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35894032131768*^9, 3.35894038131373*^9}}],

Cell[TextData[{
 "Das Polynom wird als Polynom in x mit polynomialen Koeffizienten \
umsortiert, was eine gewisse Klammersetzung induziert.\nDas macht sich leider \
in der Ausgabe nur teilweise bemerkbar, weil die Summanden einer Summe (als \
Auswirkung des Attributs ",
 StyleBox["Orderless",
  FontWeight->"Bold"],
 " von ",
 StyleBox["Plus",
  FontWeight->"Bold"],
 ") defaultm\[ADoubleDot]\[SZ]ig nach einer inneren Ordnung sortiert werden, \
also nicht nach x-Potenzen. "
}], "SmallText",
 CellChangeTimes->{{3.35895190152591*^9, 3.35895203898415*^9}, {
  3.35895207499501*^9, 3.35895208448968*^9}, {3.35895213300441*^9, 
  3.35895214859406*^9}}],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35894038750063*^9, 3.35894039274868*^9}}],

Cell[BoxData[
 RowBox[{"Depth", "/@", 
  RowBox[{"List", "@@", "u"}]}]], "Input",
 CellChangeTimes->{{3.35894093991702*^9, 3.35894096932638*^9}}],

Cell[BoxData[
 RowBox[{"Depth", "/@", "u"}]], "Input",
 CellChangeTimes->{{3.35900558193123*^9, 3.3590055867809*^9}}],

Cell[TextData[{
 "Selbst Sortieren hilft nichts, weil ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " die \"falsche\" Ordnung sofort erkennt und durch die seiner Meinung nach \
korrekte ersetzt. "
}], "SmallText",
 CellChangeTimes->{{3.35895209168313*^9, 3.35895212820098*^9}, {
  3.3589521612969*^9, 3.3589521831879*^9}}],

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"List", "@@", "u"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"#1", ",", "x"}], "]"}], ">", 
     RowBox[{"Exponent", "[", 
      RowBox[{"#2", ",", "x"}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894334839293*^9, 3.35894337071827*^9}, {
  3.387983024549984*^9, 3.38798302623695*^9}}],

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"u", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"#1", ",", "x"}], "]"}], ">", 
     RowBox[{"Exponent", "[", 
      RowBox[{"#2", ",", "x"}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894334839293*^9, 3.35894337071827*^9}}],

Cell[TextData[{
 "Das Ganze \[ADoubleDot]ndert sich erst, wenn das Attribut ",
 StyleBox["Orderless",
  FontWeight->"Bold"],
 " zur\[UDoubleDot]ckgesetzt wird. Nun ist die Ausgabe sowohl von ",
 StyleBox["Collect",
  FontWeight->"Bold"],
 " als auch von ",
 StyleBox["Sort",
  FontWeight->"Bold"],
 " nach x-Potenzen geordnet."
}], "SmallText",
 CellChangeTimes->{{3.35895219263398*^9, 3.35895224785148*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"Plus", ",", "Orderless"}], "]"}], ";"}], "\n", 
 RowBox[{"u", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Depth", "/@", 
  RowBox[{"List", "@@", "u"}]}], "\n", 
 RowBox[{"Sort", "[", 
  RowBox[{"u", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"#1", ",", "x"}], "]"}], ">", 
     RowBox[{"Exponent", "[", 
      RowBox[{"#2", ",", "x"}], "]"}]}], "&"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"Plus", ",", "Orderless"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.35894189811027*^9, 3.35894197285223*^9}, {
  3.35894338253776*^9, 3.35894338605427*^9}, {3.35894342249508*^9, 
  3.35894343199634*^9}, {3.35894820699297*^9, 3.35894821980127*^9}}],

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.35894882745902*^9, 3.35894885830214*^9}}],

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.3589488368669*^9, 3.35894884876862*^9}}],

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894886489751*^9, 3.35894887820722*^9}}],

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", "x", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.35894888348223*^9, 3.35894889142233*^9}}],

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894967085058*^9, 3.3589496779255*^9}}],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35894980631585*^9, 3.35894985154959*^9}}],

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35900992554888*^9, 3.35900993448457*^9}}],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", "x", ",", "Simplify"}], "]"}]], "Input",
 CellChangeTimes->{{3.3589507505919*^9, 3.35895083995361*^9}}],

Cell[TextData[{
 StyleBox["Collect",
  FontWeight->"Bold"],
 " ist ein komplexes Kommando, welches auf ",
 StyleBox["Coefficient",
  FontWeight->"Bold"],
 " aufbaut. So h\[ADoubleDot]tte man das vorige Kommando auch so anschreiben \
k\[ODoubleDot]nnen:"
}], "SmallText",
 CellChangeTimes->{{3.35895226662428*^9, 3.35895230978761*^9}}],

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"Coefficient", "[", 
       RowBox[{"f", ",", "x", ",", "i"}], "]"}], "]"}], 
     RowBox[{"x", "^", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"Exponent", "[", 
       RowBox[{"f", ",", "x"}], "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35895085618304*^9, 3.35895101090977*^9}, {
  3.35895106789344*^9, 3.35895130542723*^9}}],

Cell[TextData[{
 "Und dies ist eine Alternative zu ",
 StyleBox["Collect",
  FontWeight->"Bold"],
 "[f,{y,a}]"
}], "SmallText",
 CellChangeTimes->{{3.35901049050706*^9, 3.35901050686345*^9}}],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", "y", ",", 
   RowBox[{
    RowBox[{"Collect", "[", 
     RowBox[{"#", ",", "a"}], "]"}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35900986985126*^9, 3.35900987788463*^9}, {
  3.35900997308341*^9, 3.35900999829578*^9}}],

Cell[TextData[{
 StyleBox["Collect",
  FontWeight->"Bold"],
 " kann nat\[UDoubleDot]rlich auch mit verallgemeinerten Kernen aufgreufen \
werden."
}], "SmallText",
 CellChangeTimes->{{3.35901053411013*^9, 3.35901055779012*^9}}],

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "-", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35895248922278*^9, 3.35895252697953*^9}}],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"u", ",", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895253554787*^9, 3.35895254427002*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Zerlegen in Faktoren", "Subsection",
 CellChangeTimes->{{3358952626.15156, 3358952632.57063}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "-", 
   RowBox[{"4", "x"}], "+", 
   RowBox[{"6", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"4", 
    SuperscriptBox["x", "3"]}], "+", 
   SuperscriptBox["x", "4"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895264709324*^9, 3.35895267472325*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   SuperscriptBox["x", "4"], "-", 
   SuperscriptBox["y", "4"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895267932358*^9, 3.35895268638204*^9}}],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.35895270062605*^9, 3.35895273596737*^9}}],

Cell[TextData[{
 StyleBox["Factor",
  FontWeight->"Bold"],
 " funktioniert auch f\[UDoubleDot]r pseudorationale Ausdr\[UDoubleDot]cke in \
verallgemeinerten Kernen. Mit vier Kernen ist keine (wesentliche) \
Faktorisierung m\[ODoubleDot]glich."
}], "SmallText",
 CellChangeTimes->{{3.35895287074766*^9, 3.35895293599764*^9}}],

Cell[BoxData[
 RowBox[{"s1", "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.35895274874391*^9, 3.35895275564026*^9}}],

Cell[TextData[{
 "Reduziert man die Zahl der Kerne aber durch ",
 StyleBox["TrigExpand",
  FontWeight->"Bold"],
 " auf Sin[x] und Cos[x], so l\[ADoubleDot]sst sich der Ausdruck in zwei \
Faktoren zerlegen."
}], "SmallText",
 CellChangeTimes->{{3.35895294128296*^9, 3.35895301204206*^9}}],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"s1", "//", "TrigExpand"}]}]], "Input",
 CellChangeTimes->{{3.35895278358409*^9, 3.3589527896899*^9}}],

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{"s2", "//", "Factor"}]}]], "Input",
 CellChangeTimes->{{3.35895279393521*^9, 3.3589528159196*^9}}],

Cell[BoxData[
 RowBox[{"s3", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.35895281810962*^9, 3.35895282485917*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x", "-", "6"}], 
   RowBox[{
    SuperscriptBox["x", "2"], "-", "1"}]], "]"}]], "Input",
 CellChangeTimes->{{3.35895302862068*^9, 3.35895306258705*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   FractionBox["1", "4"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895306802705*^9, 3.35895307986212*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895397333672*^9, 3.35895398118116*^9}, 
   3.35895408885574*^9, 3.387987020300385*^9}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895398877321*^9, 3.35895399883866*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", "x"}], "+", "1"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    SqrtBox["5"]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35895400718177*^9, 3.35895403035241*^9}}],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", 
     SqrtBox["2"], "x"}], "+", "2"}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.387987174722884*^9, 3.387987194849396*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Arbeiten mit rationalen Funktionen", "Subsection"],

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{"x", "+", 
   FractionBox["y", "z"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}]], "+", 
   FractionBox["1", 
    RowBox[{"x", "+", "1"}]], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"x", "-", "1"}]]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", "+", "3"}]], "+", 
   FractionBox["1", 
    RowBox[{"x", "-", "1"}]], "+", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "1"}]]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"1", "-", 
    SuperscriptBox["x", "10"]}], 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "9"]}]], "//", "Together"}]], "Input",
 CellChangeTimes->{{3.35893613581338*^9, 3.35893617295782*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "3"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}], "2"]]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Numerator", "[", "f", "]"}], ",", " ", 
    RowBox[{"Denominator", "[", "f", "]"}]}], "}"}]}]], "Input"],

Cell["\<\
Beide Kommandos sind reine Selektoren und bilden vorher keinen gemeinsamen \
Nenner.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "x"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox["b", "x"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{"Together", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", "x"}], 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], "+", 
    FractionBox["b", "x"]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  FractionBox[
   RowBox[{"12", "-", 
    RowBox[{"8", "x"}], "-", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"]}], 
   RowBox[{
    RowBox[{"-", "18"}], "-", 
    RowBox[{"3", "x"}], "+", 
    RowBox[{"4", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "=", 
  FractionBox[
   RowBox[{"1", "-", 
    SuperscriptBox["x", "3"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "6"]]}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "//", "Cancel"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "20"], "-", "1"}], 
   RowBox[{
    SuperscriptBox["x", "7"], "-", "1"}]]}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"f", "//", "Cancel"}]], "Input",
 CellChangeTimes->{{3.3589361983899*^9, 3.35893619969324*^9}}],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox["x", 
   RowBox[{
    SuperscriptBox["x", "4"], "-", "1"}]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{"x", " ", "y"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "2"]], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", "y"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "2"]], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", "y"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "2"]], ",", "y"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", "y"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "5"], "+", "1"}], 
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x", "+", "1"}]], "]"}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Trigonometrische Umformungen", "Section"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Einf\[UDoubleDot]hrung", "Subsection"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]], ",", 
   FractionBox["1", 
    RowBox[{"Cos", "[", "x", "]"}]], ",", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "x", "]"}]], ",", 
   FractionBox["1", 
    RowBox[{"Sin", "[", "x", "]"}]]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"u1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Cot", "[", "x", "]"}]}], "//", "TrigToExp"}]}]], "Input",
 CellChangeTimes->{{3.35901236014325*^9, 3.3590123603799*^9}, {
  3.35901407239032*^9, 3.3590140831623*^9}}],

Cell["\<\
Das ist nun noch komplizierter als vorher, weil gleich im ersten Term Grad 4 \
statt Grad 3 entsteht.\
\>", "SmallText",
 CellChangeTimes->{{3.387989130476364*^9, 3.387989165926399*^9}}],

Cell[BoxData[
 RowBox[{"u2", "=", 
  RowBox[{"u1", "//", "Together"}]}]], "Input",
 CellChangeTimes->{{3.35901236325017*^9, 3.35901237466643*^9}, {
  3.35901407463925*^9, 3.35901407644171*^9}, {3.3590142867875*^9, 
  3.35901428993705*^9}, {3.387989061550777*^9, 3.387989118052525*^9}}],

Cell[BoxData[
 RowBox[{"u3", "=", 
  RowBox[{"u2", "//", "ExpToTrig"}]}]], "Input",
 CellChangeTimes->{{3.35901236668429*^9, 3.35901239264716*^9}, {
  3.35901409055622*^9, 3.35901409302918*^9}}],

Cell[BoxData[
 RowBox[{"u3", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.35901238425093*^9, 3.35901239528736*^9}, {
  3.3590124649434*^9, 3.35901247551884*^9}, {3.35901409552575*^9, 
  3.35901409632401*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"u3", "-", 
   RowBox[{"Sin", "[", "x", "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.35901239953177*^9, 3.35901240809544*^9}, {
  3.35901248564194*^9, 3.35901248677059*^9}, {3.35901291010563*^9, 
  3.35901291048115*^9}, {3.35901409845154*^9, 3.35901409926905*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Die Standardkommandos", "Subsection"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[StyleBox["TrigExpand",
 FontWeight->"Bold"]], "SmallText"],

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"\[Alpha]", "+", "\[Beta]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{
    RowBox[{"2", "x"}], "+", 
    FractionBox["\[Pi]", "4"]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cot", "[", "x", "]"}], "2"]}], "]"}]], "Input"],

Cell[TextData[StyleBox["TrigReduce",
 FontWeight->"Bold"]], "SmallText"],

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{"2", 
   RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", 
   RowBox[{"Cos", "[", "\[Beta]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "5"], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Cot", "[", "x", "]"}], "2"]}], "]"}]], "Input"],

Cell[TextData[StyleBox["TrigFactor",
 FontWeight->"Bold"]], "SmallText"],

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"3", "x"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "+", 
     FractionBox["\[Pi]", "3"]}], "]"}], 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "-", 
     FractionBox["\[Pi]", "3"]}], "]"}]}], "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], "x"}], 
   "]"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Ein trigonometrisches Regelsystem", "Subsection"],

Cell[BoxData[{
 RowBox[{"s1", "=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "y", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}]}]}]}], "\n", 
 RowBox[{"c1", "=", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "y", "]"}]}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", "y", "+", "z"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1"}], "}"}]}]], "Input"],

Cell[TextData[{
 "Die Regeln wurden mehrfach angewendet, aber Klammern nicht aufgel\
\[ODoubleDot]st. ",
 StyleBox["Expand",
  FontWeight->"Bold"],
 " erst im Nachhinein anzuwenden ist sinnvoll; besser w\[ADoubleDot]re es \
aber,  den Effekt des Zusammenfassens so fr\[UDoubleDot]h wie \
m\[ODoubleDot]glich in der Rechnung zu ber\[UDoubleDot]cksichtigen. \nNat\
\[UDoubleDot]rlich ist \[RuleDelayed] statt \[Rule] zu verwenden, denn \
Expand[a] soll ja zur Zeiit der Regelanwendung und nicht zur Zeit der \
Regeldefinition ausgef\[UDoubleDot]hrt werden. Die rechte Seite der Regel \
darf also w\[ADoubleDot]hrend der Definition nicht ausgewertet werden. \nDer \
folgende Ansatz scheitert trotzdem zun\[ADoubleDot]chst."
}], "SmallText",
 CellChangeTimes->{{3.359016500605*^9, 3.35901663624388*^9}, {
  3.35901679145504*^9, 3.35901688966746*^9}}],

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"a_", "\[RuleDelayed]", 
   RowBox[{"Expand", "[", "a", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.35901640571136*^9, 3.35901640594634*^9}, {
  3.35901680895699*^9, 3.35901681289424*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "-", "y", "+", "z"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1", ",", "d1"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.35901633727962*^9, 3.35901633746815*^9}}],

Cell[TextData[{
 "Der Grund ist simpel: ",
 StyleBox["d1 ",
  FontWeight->"Bold"],
 "wurde auf Teilausdr\[UDoubleDot]cken gar nicht erst versucht, weil die \
Regel ja auch auf den Gesamtausdruck angewendet werden kann und dort keine \
\[CapitalADoubleDot]nderung hervorruft. Um \"unendliche Schleifen des \
Nichtstuns\" zu vermeiden bricht ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in solchen F\[ADoubleDot]llen das ",
 StyleBox["ReplaceRepeated",
  FontWeight->"Bold"],
 " ab. \nDie Regel d1 darf also nur angewendet werden, wenn sich wirklich \
etwas \[ADoubleDot]ndert, was hier mit =!= (",
 StyleBox["UnsameQ",
  FontWeight->"Bold"],
 ") gepr\[UDoubleDot]ft wird."
}], "SmallText",
 CellChangeTimes->{{3.35901664143312*^9, 3.35901676066004*^9}, {
  3.35901691213894*^9, 3.35901696678293*^9}}],

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{
   RowBox[{"a_", "/;", 
    RowBox[{
     RowBox[{"Expand", "[", "a", "]"}], "=!=", "a"}]}], ":>", 
   RowBox[{"Expand", "[", "a", "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "-", "y", "+", "z"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1", ",", "d1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"2", "x"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "c1", ",", "d1"}], "}"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"s2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"n_Integer", " ", "x_"}], "]"}], "/;", 
    RowBox[{"n", ">", "1"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}]}]}]}], "\n", 
 RowBox[{"c2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"n_Integer", " ", "x_"}], "]"}], "/;", 
    RowBox[{"n", ">", "1"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "x"}], "]"}]}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"12", "x"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s2", ",", "c2", ",", "d1"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"sc", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x_", "]"}], "n_Integer"], "/;", 
    RowBox[{"n", ">", "1"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"n", "-", "2"}]]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"5", "x"}], "]"}], "//.", 
  RowBox[{"{", 
   RowBox[{"s2", ",", "c2", ",", "d1", ",", "sc"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Sin", "[", "x", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "Factor"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"5", "x"}], "]"}], "//", "TrigFactor"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Eine Testserie", "Subsection"],

Cell["\<\
Mit dieser Funktion werden die Ergebnisse verschiedene \
Simplifikationsstrategien f\[UDoubleDot]r trigonometrische \
Ausdr\[UDoubleDot]cke aufgesammelt.\
\>", "SmallText",
 CellChangeTimes->{{3359020584.41773, 3359020633.08199}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"tests", "[", "h_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", "h", "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Simplify", ",", "TrigReduce", ",", "TrigExpand", ",", "TrigFactor"}], 
    "}"}]}]}]], "Input"],

Cell[TextData[{
 "Ein erstes einfaches Beispiel: Ein polynomialer Ausdruck in ",
 StyleBox["Sin",
  FontWeight->"Bold"],
 " mit Mehrfachwinkeln."
}], "SmallText",
 CellChangeTimes->{{3.35902064293312*^9, 3.35902068233458*^9}}],

Cell[BoxData[{
 RowBox[{"d1", "=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"3", "x"}], "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"5", "x"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"i1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d1", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"h1", "=", 
  RowBox[{"d1", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i1", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"h1", "//", "tests"}]], "Input"],

Cell[TextData[{
 "Hier sehen Sie noch einmal die Wirkung der vier Simplifikationskommandos \
auf einen trigonometrischen Ausdruck. Das Ergebnis von ",
 StyleBox["TrigFactor",
  FontWeight->"Bold"],
 " ist wegen der komplexen Zahlen nicht zufriedenstellend."
}], "SmallText",
 CellChangeTimes->{3.388076637373515*^9}],

Cell[BoxData[
 RowBox[{"i1", "//", "tests"}]], "Input"],

Cell[TextData[{
 "Im zweiten Beispiel muss der gemeinsame Kern ",
 Cell[BoxData[
  FormBox[
   FractionBox["x", "6"], TraditionalForm]]],
 "erst gefunden werden."
}], "SmallText",
 CellChangeTimes->{{3.35902071875337*^9, 3.35902077756017*^9}}],

Cell[BoxData[{
 RowBox[{"d2", "=", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}], 
   RowBox[{"Cos", "[", 
    FractionBox["x", "3"], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"i2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d2", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"h2", "=", 
  RowBox[{"d2", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i2", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"5", " ", "x"}], "6"], "]"}], "//", "FullForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"5", " ", "x"}], "6"], "]"}], "//", "TrigExpand"}]], "Input"],

Cell[BoxData[
 RowBox[{"h2", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"i2", "//", "tests"}]], "Input"],

Cell[TextData[{
 "Das folgende Beispiel bereitete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vor Version 6 gro\[SZ]e Schwierigkeiten, weil der einfache Weg der \
Integration nicht gefunden wurde.  Relikte dieser \"Blindheit\" haben noch \
beim Ergebnis von ",
 StyleBox["TrigFactor",
  FontWeight->"Bold"],
 " auf diesem Ausdruck \[UDoubleDot]berlebt."
}], "SmallText",
 CellChangeTimes->{{3.35902079028381*^9, 3.35902084907129*^9}, {
  3.35902102263104*^9, 3.35902110030499*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"d3", "=", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"2", "x"}], "-", 
       FractionBox["\[Pi]", "6"]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       FractionBox["\[Pi]", "4"]}], "]"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"i3", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d3", ",", "x"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.35902085344425*^9, 3.35902085508933*^9}, {
   3.3590227181644*^9, 3.35902273380282*^9}, 3.388077222136884*^9}],

Cell[BoxData[{
 RowBox[{"d3a", "=", 
  RowBox[{"d3", "//", "TrigReduce"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"d3a", ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{{3.35902210884183*^9, 3.35902216737781*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"d3", "-", 
    RowBox[{"D", "[", 
     RowBox[{"i3", ",", "x"}], "]"}]}], "//", "tests"}]}]], "Input",
 CellChangeTimes->{
  3.35902090990497*^9, {3.35902270385838*^9, 3.35902274421138*^9}}],

Cell[BoxData[
 RowBox[{"d3", "//", "TrigFactor"}]], "Input"],

Cell["\<\
Und nun noch einige Beispiele, die nicht im Buch besprochen sind.\
\>", "SmallText",
 CellChangeTimes->{{3359025456.8522, 3359025468.15545}}],

Cell[BoxData[{
 RowBox[{"d4", "=", 
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"]]}], "\[IndentingNewLine]", 
 RowBox[{"i4", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"d4", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"h4", "=", 
  RowBox[{"d4", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i4", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[
 RowBox[{"h4", "//", "tests"}]], "Input"],

Cell["\<\
Hier die Wirkung der 4 Simplifikationsbefehle, wenn auch andere \
Winkelfunktionen mit im Spiel sind.\
\>", "SmallText"],

Cell[BoxData[
 RowBox[{"i4", "//", "tests"}]], "Input"],

Cell[BoxData[{
 RowBox[{"d5", "=", 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{"i5", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"d5", ",", "x"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"h5", "=", 
  RowBox[{"d5", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i5", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"h5", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"i5", "//", "tests"}]], "Input"],

Cell[BoxData[{
 RowBox[{"d6", "=", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", "x"}], "]"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"Tan", "[", "x", "]"}]}], "+", "5"}], 
     ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{"i6", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"d6", ",", "x"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"h6", "=", 
  RowBox[{"d6", "-", 
   RowBox[{"D", "[", 
    RowBox[{"i6", ",", "x"}], "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"h6", "//", "tests"}]], "Input"],

Cell[BoxData[
 RowBox[{"i6", "//", "tests"}]], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{656, 622},
WindowMargins->{{Automatic, 285}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"mk.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 90, 3, 121, "Title"],
Cell[CellGroupData[{
Cell[705, 30, 49, 0, 55, "Section"],
Cell[757, 32, 140, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[922, 38, 57, 0, 45, "Subsection"],
Cell[982, 40, 332, 10, 30, "Input"],
Cell[1317, 52, 80, 2, 28, "Input"],
Cell[1400, 56, 86, 2, 28, "Input"],
Cell[1489, 60, 61, 1, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1587, 66, 47, 0, 29, "Subsection"],
Cell[1637, 68, 295, 11, 53, "Input"],
Cell[1935, 81, 57, 1, 28, "Input"],
Cell[1995, 84, 57, 1, 28, "Input"],
Cell[2055, 87, 198, 6, 30, "Input"],
Cell[2256, 95, 411, 14, 36, "Input"],
Cell[2670, 111, 236, 8, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[2943, 124, 67, 0, 29, "Subsection"],
Cell[3013, 126, 189, 6, 41, "Input"],
Cell[3205, 134, 81, 2, 28, "Input"],
Cell[3289, 138, 275, 9, 41, "Input"],
Cell[3567, 149, 81, 2, 28, "Input"],
Cell[3651, 153, 212, 4, 28, "Input"],
Cell[3866, 159, 268, 8, 30, "Input"],
Cell[4137, 169, 260, 9, 28, "Input"],
Cell[4400, 180, 279, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[4716, 191, 78, 0, 29, "Subsection"],
Cell[4797, 193, 295, 9, 30, "Input"],
Cell[5095, 204, 314, 10, 30, "Input"],
Cell[5412, 216, 600, 17, 49, "Input"],
Cell[6015, 235, 126, 4, 42, "Input"],
Cell[6144, 241, 138, 4, 28, "Input"],
Cell[6285, 247, 336, 10, 49, "Input"],
Cell[6624, 259, 99, 3, 28, "Input"],
Cell[6726, 264, 121, 3, 28, "Input"],
Cell[6850, 269, 105, 3, 46, "Input"],
Cell[6958, 274, 121, 3, 44, "Input"],
Cell[7082, 279, 122, 3, 44, "Input"],
Cell[7207, 284, 195, 8, 48, "Input"],
Cell[7405, 294, 378, 13, 44, "Input"],
Cell[7786, 309, 109, 3, 44, "Input"],
Cell[7898, 314, 181, 7, 70, "Input"],
Cell[8082, 323, 234, 8, 44, "Input"],
Cell[8319, 333, 179, 6, 44, "Input"],
Cell[8501, 341, 272, 9, 44, "Input"],
Cell[8776, 352, 319, 11, 46, "Input"],
Cell[9098, 365, 98, 3, 44, "Input"],
Cell[9199, 370, 128, 4, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[9364, 379, 57, 0, 29, "Subsection"],
Cell[9424, 381, 344, 14, 53, "Input"],
Cell[9771, 397, 239, 9, 54, "Input"],
Cell[10013, 408, 240, 9, 54, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10302, 423, 85, 1, 35, "Section"],
Cell[10390, 426, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[10491, 431, 132, 1, 45, "Subsection"],
Cell[10626, 434, 293, 9, 30, "Input"],
Cell[10922, 445, 123, 2, 28, "Input"],
Cell[11048, 449, 287, 10, 30, "Input"],
Cell[11338, 461, 311, 11, 30, "Input"],
Cell[11652, 474, 198, 6, 30, "Input"],
Cell[11853, 482, 351, 10, 49, "Input"],
Cell[12207, 494, 318, 10, 49, "Input"],
Cell[12528, 506, 253, 9, 36, "Input"],
Cell[12784, 517, 256, 9, 36, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[13077, 531, 185, 3, 29, "Subsection"],
Cell[13265, 536, 630, 20, 36, "Input"],
Cell[13898, 558, 651, 15, 110, "SmallText"],
Cell[14552, 575, 171, 4, 28, "Input"],
Cell[14726, 581, 145, 3, 28, "Input"],
Cell[14874, 586, 117, 2, 28, "Input"],
Cell[14994, 590, 329, 8, 59, "SmallText"],
Cell[15326, 600, 396, 11, 28, "Input"],
Cell[15725, 613, 320, 9, 44, "Input"],
Cell[16048, 624, 408, 12, 59, "SmallText"],
Cell[16459, 638, 861, 23, 125, "Input"],
Cell[17323, 663, 148, 3, 44, "Input"],
Cell[17474, 668, 154, 3, 44, "Input"],
Cell[17631, 673, 176, 4, 46, "Input"],
Cell[17810, 679, 161, 3, 44, "Input"],
Cell[17974, 684, 219, 5, 44, "Input"],
Cell[18196, 691, 196, 5, 44, "Input"],
Cell[18395, 698, 204, 5, 44, "Input"],
Cell[18602, 705, 163, 3, 44, "Input"],
Cell[18768, 710, 334, 9, 59, "SmallText"],
Cell[19105, 721, 512, 14, 44, "Input"],
Cell[19620, 737, 191, 6, 42, "SmallText"],
Cell[19814, 745, 285, 7, 44, "Input"],
Cell[20102, 754, 226, 6, 42, "SmallText"],
Cell[20331, 762, 463, 14, 52, "Input"],
Cell[20797, 778, 178, 4, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[21012, 787, 100, 1, 29, "Subsection"],
Cell[21115, 790, 310, 9, 30, "Input"],
Cell[21428, 801, 196, 5, 30, "Input"],
Cell[21627, 808, 321, 9, 30, "Input"],
Cell[21951, 819, 324, 7, 59, "SmallText"],
Cell[22278, 828, 120, 2, 28, "Input"],
Cell[22401, 832, 287, 7, 59, "SmallText"],
Cell[22691, 841, 147, 3, 28, "Input"],
Cell[22841, 846, 143, 3, 28, "Input"],
Cell[22987, 851, 122, 2, 44, "Input"],
Cell[23112, 855, 254, 7, 63, "Input"],
Cell[23369, 864, 193, 5, 58, "Input"],
Cell[23565, 871, 218, 5, 46, "Input"],
Cell[23786, 878, 244, 6, 46, "Input"],
Cell[24033, 886, 278, 8, 52, "Input"],
Cell[24314, 896, 294, 8, 52, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[24645, 909, 56, 0, 29, "Subsection"],
Cell[24704, 911, 106, 3, 40, "Input"],
Cell[24813, 916, 367, 13, 48, "Input"],
Cell[25183, 931, 262, 9, 43, "Input"],
Cell[25448, 942, 243, 7, 47, "Input"],
Cell[25694, 951, 382, 13, 49, "Input"],
Cell[26079, 966, 113, 3, 42, "SmallText"],
Cell[26195, 971, 206, 7, 59, "Input"],
Cell[26404, 980, 247, 8, 59, "Input"],
Cell[26654, 990, 355, 12, 63, "Input"],
Cell[27012, 1004, 196, 7, 65, "Input"],
Cell[27211, 1013, 57, 1, 44, "Input"],
Cell[27271, 1016, 55, 1, 44, "Input"],
Cell[27329, 1019, 171, 6, 63, "Input"],
Cell[27503, 1027, 57, 1, 44, "Input"],
Cell[27563, 1030, 118, 2, 44, "Input"],
Cell[27684, 1034, 129, 4, 57, "Input"],
Cell[27816, 1040, 162, 5, 61, "Input"],
Cell[27981, 1047, 179, 6, 59, "Input"],
Cell[28163, 1055, 207, 7, 59, "Input"],
Cell[28373, 1064, 207, 7, 59, "Input"],
Cell[28583, 1073, 256, 9, 59, "Input"],
Cell[28842, 1084, 189, 6, 63, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29080, 1096, 47, 0, 35, "Section"],
Cell[29130, 1098, 76, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[29231, 1103, 44, 0, 45, "Subsection"],
Cell[29278, 1105, 372, 12, 45, "Input"],
Cell[29653, 1119, 279, 7, 28, "Input"],
Cell[29935, 1128, 196, 4, 42, "SmallText"],
Cell[30134, 1134, 285, 5, 28, "Input"],
Cell[30422, 1141, 194, 4, 28, "Input"],
Cell[30619, 1147, 215, 4, 28, "Input"],
Cell[30837, 1153, 314, 6, 28, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[31188, 1164, 43, 0, 29, "Subsection"],
Cell[31234, 1166, 76, 1, 28, "Input"],
Cell[31313, 1169, 72, 1, 42, "SmallText"],
Cell[31388, 1172, 130, 3, 28, "Input"],
Cell[31521, 1177, 164, 5, 41, "Input"],
Cell[31688, 1184, 112, 3, 28, "Input"],
Cell[31803, 1189, 200, 6, 30, "Input"],
Cell[32006, 1197, 72, 1, 42, "SmallText"],
Cell[32081, 1200, 166, 4, 28, "Input"],
Cell[32250, 1206, 118, 3, 30, "Input"],
Cell[32371, 1211, 200, 6, 30, "Input"],
Cell[32574, 1219, 72, 1, 42, "SmallText"],
Cell[32649, 1222, 112, 3, 28, "Input"],
Cell[32764, 1227, 112, 3, 28, "Input"],
Cell[32879, 1232, 250, 8, 41, "Input"],
Cell[33132, 1242, 197, 6, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[33366, 1253, 55, 0, 29, "Subsection"],
Cell[33424, 1255, 652, 22, 49, "Input"],
Cell[34079, 1279, 164, 5, 28, "Input"],
Cell[34246, 1286, 846, 15, 144, "SmallText"],
Cell[35095, 1303, 232, 5, 28, "Input"],
Cell[35330, 1310, 239, 6, 44, "Input"],
Cell[35572, 1318, 809, 20, 110, "SmallText"],
Cell[36384, 1340, 197, 6, 44, "Input"],
Cell[36584, 1348, 175, 5, 44, "Input"],
Cell[36762, 1355, 160, 5, 44, "Input"],
Cell[36925, 1362, 1086, 38, 65, "Input"],
Cell[38014, 1402, 161, 5, 44, "Input"],
Cell[38178, 1409, 415, 14, 46, "Input"],
Cell[38596, 1425, 171, 5, 44, "Input"],
Cell[38770, 1432, 114, 3, 44, "Input"],
Cell[38887, 1437, 55, 1, 44, "Input"],
Cell[38945, 1440, 108, 3, 44, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[39090, 1448, 36, 0, 29, "Subsection"],
Cell[39129, 1450, 240, 5, 59, "SmallText"],
Cell[39372, 1457, 269, 9, 28, "Input"],
Cell[39644, 1468, 226, 6, 42, "SmallText"],
Cell[39873, 1476, 414, 13, 69, "Input"],
Cell[40290, 1491, 55, 1, 28, "Input"],
Cell[40348, 1494, 316, 7, 59, "SmallText"],
Cell[40667, 1503, 55, 1, 44, "Input"],
Cell[40725, 1506, 243, 7, 51, "SmallText"],
Cell[40971, 1515, 420, 13, 98, "Input"],
Cell[41394, 1530, 134, 4, 58, "Input"],
Cell[41531, 1536, 136, 4, 58, "Input"],
Cell[41670, 1542, 55, 1, 44, "Input"],
Cell[41728, 1545, 55, 1, 44, "Input"],
Cell[41786, 1548, 492, 12, 76, "SmallText"],
Cell[42281, 1562, 583, 18, 79, "Input"],
Cell[42867, 1582, 239, 5, 65, "Input"],
Cell[43109, 1589, 242, 7, 44, "Input"],
Cell[43354, 1598, 60, 1, 44, "Input"],
Cell[43417, 1601, 151, 3, 42, "SmallText"],
Cell[43571, 1606, 395, 11, 123, "Input"],
Cell[43969, 1619, 55, 1, 44, "Input"],
Cell[44027, 1622, 130, 3, 42, "SmallText"],
Cell[44160, 1627, 55, 1, 44, "Input"],
Cell[44218, 1630, 515, 17, 103, "Input"],
Cell[44736, 1649, 55, 1, 44, "Input"],
Cell[44794, 1652, 55, 1, 44, "Input"],
Cell[44852, 1655, 538, 19, 102, "Input"],
Cell[45393, 1676, 55, 1, 44, "Input"],
Cell[45451, 1679, 55, 1, 44, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
